# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Index(_model_base.Model):
    """Index resource Definition.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource Id:
     azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the index. Required.
    :vartype id: str
    :ivar stage: Update stage to 'Archive' for soft delete. Default is Development, which means the
     asset is under development. Required.
    :vartype stage: str
    :ivar description: Description information of the asset.
    :vartype description: str
    :ivar system_data: Metadata containing createdBy and modifiedBy information.
    :vartype system_data: ~azureaiassetsv20240401.models.SystemData
    :ivar tags: Asset's tags.
    :vartype tags: dict[str, str]
    :ivar properties: Asset's properties.
    :vartype properties: dict[str, str]
    :ivar storage_uri: Default workspace blob storage Uri. Should work across storage types and
     auth scenarios. Required.
    :vartype storage_uri: str
    """

    id: str = rest_field(visibility=["read"])
    """Fully qualified resource Id:
     azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the index. Required."""
    stage: str = rest_field()
    """Update stage to 'Archive' for soft delete. Default is Development, which means the asset is
     under development. Required."""
    description: Optional[str] = rest_field()
    """Description information of the asset."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Metadata containing createdBy and modifiedBy information."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Asset's tags."""
    properties: Optional[Dict[str, str]] = rest_field()
    """Asset's properties."""
    storage_uri: str = rest_field(name="storageUri")
    """Default workspace blob storage Uri. Should work across storage types and auth scenarios.
     Required."""

    @overload
    def __init__(
        self,
        *,
        stage: str,
        storage_uri: str,
        description: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PagedIndex(_model_base.Model):
    """Paged collection of IndexVersion items.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of Indexes. Required.
    :vartype value: list[~azureaiassetsv20240401.models.Index]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    value: List["_models.Index"] = rest_field()
    """The list of Indexes. Required."""
    next_link: Optional[str] = rest_field(name="nextLink")
    """The link to the next page of items."""

    @overload
    def __init__(
        self,
        *,
        value: List["_models.Index"],
        next_link: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_at: The timestamp the resource was created at.
    :vartype created_at: ~datetime.datetime
    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The identity type that created the resource.
    :vartype created_by_type: str
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", visibility=["read"], format="rfc3339")
    """The timestamp the resource was created at."""
    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read"])
    """The identity that created the resource."""
    created_by_type: Optional[str] = rest_field(name="createdByType", visibility=["read"])
    """The identity type that created the resource."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""


class VersionInfo(_model_base.Model):
    """Next version definition.

    All required parameters must be populated in order to send to server.

    :ivar next_version: Next version as defined by the server.
    :vartype next_version: int
    :ivar latest_version: Current latest version of the resource. Required.
    :vartype latest_version: str
    """

    next_version: Optional[int] = rest_field(name="nextVersion")
    """Next version as defined by the server."""
    latest_version: str = rest_field(name="latestVersion")
    """Current latest version of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        latest_version: str,
        next_version: Optional[int] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
