# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AclActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of actions that can be performed."""

    DROP = "Drop"
    COUNT = "Count"
    LOG = "Log"


class Action(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify action."""

    ALLOW = "Allow"
    DENY = "Deny"


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AddressFamilyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AddressFamilyType. This parameter decides whether the given ipv4 or ipv6 route policy."""

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"


class AdministrativeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State defined to represent administrative actions or post actions on a particular resource."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    MAT = "MAT"
    RMA = "RMA"


class AllowASOverride(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enable Or Disable state."""

    ENABLE = "Enable"
    DISABLE = "Disable"


class BfdAdministrativeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Administrative state of the BfdConfiguration. Example: Enabled | Disabled."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    MAT = "MAT"
    RMA = "RMA"


class BooleanEnumProperty(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Boolean Enum. Example- True/False."""

    TRUE = "True"
    FALSE = "False"


class CommunityActionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """community action types. Example: Permit | Deny."""

    PERMIT = "Permit"
    DENY = "Deny"


class Condition(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify prefix-list bounds."""

    EQUAL_TO = "EqualTo"
    GREATER_THAN_OR_EQUAL_TO = "GreaterThanOrEqualTo"
    LESSER_THAN_OR_EQUAL_TO = "LesserThanOrEqualTo"
    RANGE = "Range"


class ConfigurationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Configuration state for the resource."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    REJECTED = "Rejected"
    ACCEPTED = "Accepted"
    PROVISIONED = "Provisioned"
    ERROR_PROVISIONING = "ErrorProvisioning"
    DEPROVISIONING = "Deprovisioning"
    DEPROVISIONED = "Deprovisioned"
    ERROR_DEPROVISIONING = "ErrorDeprovisioning"
    DEFERRED_CONTROL = "DeferredControl"


class ConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Input method to configure Access Control List."""

    FILE = "File"
    INLINE = "Inline"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DestinationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of destination. Input can be IsolationDomain or Direct."""

    ISOLATION_DOMAIN = "IsolationDomain"
    DIRECT = "Direct"


class DeviceAdministrativeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Administrative state."""

    RMA = "RMA"
    RESYNC = "Resync"
    GRACEFUL_QUARANTINE = "GracefulQuarantine"
    QUARANTINE = "Quarantine"


class EnableDisableState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Administrative state."""

    ENABLE = "Enable"
    DISABLE = "Disable"


class Encapsulation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of encapsulation."""

    NONE = "None"
    GRE = "GRE"


class EncapsulationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Encapsulation Type."""

    NONE = "None"
    GT_PV1 = "GTPv1"


class Extension(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extension. Example: NoExtension | NPB."""

    NO_EXTENSION = "NoExtension"
    NPB = "NPB"


class FabricSkuType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Network Fabric SKU."""

    SINGLE_RACK = "SingleRack"
    MULTI_RACK = "MultiRack"


class GatewayType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gateway Type of the resource."""

    INFRASTRUCTURE = "Infrastructure"
    WORKLOAD = "Workload"


class InterfaceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Interface Type. Example: Management/Data."""

    MANAGEMENT = "Management"
    DATA = "Data"


class IPAddressType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IP Address type."""

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"


class IsManagementType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Configuration to use NNI for Infrastructure Management. Example: True/False."""

    TRUE = "True"
    FALSE = "False"


class IsMonitoringEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """To check whether monitoring of internal network is enabled or not."""

    TRUE = "True"
    FALSE = "False"


class IsWorkloadManagementNetworkEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A workload management network is required for all the tenant (workload) traffic. This traffic
    is only dedicated for Tenant workloads which are required to access internet or any other
    MSFT/Public endpoints.
    """

    TRUE = "True"
    FALSE = "False"


class Layer4Protocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Layer4 protocol type that needs to be matched."""

    TCP = "TCP"
    UDP = "UDP"


class NetworkDeviceRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """NetworkDeviceRole is the device role: Example: CE | ToR."""

    CE = "CE"
    TO_R = "ToR"
    NPB = "NPB"
    TS = "TS"
    MANAGEMENT = "Management"


class NetworkDeviceRoleName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available roles for the network device."""

    CE = "CE"
    TO_R = "ToR"
    NPB = "NPB"
    TS = "TS"
    MANAGEMENT = "Management"


class NetworkRackType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network Rack SKU name."""

    AGGREGATE = "Aggregate"
    COMPUTE = "Compute"
    COMBINED = "Combined"


class NfcSku(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network Fabric Controller SKU."""

    BASIC = "Basic"
    STANDARD = "Standard"
    HIGH_PERFORMANCE = "HighPerformance"


class NniType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of NNI used. Example: CE | NPB."""

    CE = "CE"
    NPB = "NPB"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class PeeringOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Peering option list."""

    OPTION_A = "OptionA"
    OPTION_B = "OptionB"


class PollingIntervalInSeconds(int, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Polling interval in seconds."""

    THIRTY = 30
    SIXTY = 60
    NINETY = 90
    ONE_HUNDRED_TWENTY = 120


class PollingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Polling type."""

    PULL = "Pull"
    PUSH = "Push"


class PortType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Port type that needs to be matched."""

    SOURCE_PORT = "SourcePort"
    DESTINATION_PORT = "DestinationPort"


class PrefixType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IP Prefix Type."""

    PREFIX = "Prefix"
    LONGEST_PREFIX = "LongestPrefix"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    ACCEPTED = "Accepted"
    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"
    DELETING = "Deleting"
    FAILED = "Failed"
    CANCELED = "Canceled"


class RebootType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of reboot to be performed. Example: GracefulRebootWithZTP."""

    GRACEFUL_REBOOT_WITH_ZTP = "GracefulRebootWithZTP"
    GRACEFUL_REBOOT_WITHOUT_ZTP = "GracefulRebootWithoutZTP"
    UNGRACEFUL_REBOOT_WITH_ZTP = "UngracefulRebootWithZTP"
    UNGRACEFUL_REBOOT_WITHOUT_ZTP = "UngracefulRebootWithoutZTP"


class RedistributeConnectedSubnets(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Advertise Connected Subnets. Ex: "True" | "False"."""

    TRUE = "True"
    FALSE = "False"


class RedistributeStaticRoutes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Advertise Static Routes. Ex: "True" | "False"."""

    TRUE = "True"
    FALSE = "False"


class RoutePolicyActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Action type. Example: Permit | Deny | Continue."""

    PERMIT = "Permit"
    DENY = "Deny"
    CONTINUE = "Continue"
    CONTINUE_ENUM = "Continue"


class RoutePolicyConditionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the condition used."""

    OR = "Or"
    AND = "And"
    OR_ENUM = "Or"
    AND_ENUM = "And"


class SourceDestinationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IP Address type."""

    SOURCE_IP = "SourceIP"
    DESTINATION_IP = "DestinationIP"


class TapRuleActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of actions that can be performed."""

    DROP = "Drop"
    COUNT = "Count"
    LOG = "Log"
    REPLICATE = "Replicate"
    GOTO = "Goto"
    REDIRECT = "Redirect"
    MIRROR = "Mirror"


class ValidateAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Validate action that to be performed."""

    CABLING = "Cabling"
    CONFIGURATION = "Configuration"
    CONNECTIVITY = "Connectivity"


class WellKnownCommunities(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """``Internet`` - Advertise routes to internet community.
     ``LocalAS`` - Advertise routes to only localAS peers.
     ``NoAdvertise`` - Don't advertise routes to any peer.
    ``NoExport`` - Don't export to next AS.
    ``GShut`` - Graceful Shutdown (GSHUT) withdraw routes before terminating BGP connection.
    """

    INTERNET = "Internet"
    LOCAL_AS = "LocalAS"
    NO_ADVERTISE = "NoAdvertise"
    NO_EXPORT = "NoExport"
    G_SHUT = "GShut"
