# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, AsyncIterable, AsyncIterator, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ..._serialization import Deserializer, Serializer
from ..._validation import api_version_validation
from ...operations._operations import (
    build_key_vault_full_backup_request,
    build_key_vault_full_backup_status_request,
    build_key_vault_full_restore_operation_request,
    build_key_vault_get_setting_request,
    build_key_vault_get_settings_request,
    build_key_vault_pre_full_backup_request,
    build_key_vault_pre_full_restore_operation_request,
    build_key_vault_restore_status_request,
    build_key_vault_selective_key_restore_operation_request,
    build_key_vault_selective_key_restore_status_request,
    build_key_vault_update_setting_request,
    build_role_assignments_create_request,
    build_role_assignments_delete_request,
    build_role_assignments_get_request,
    build_role_assignments_list_for_scope_request,
    build_role_definitions_create_or_update_request,
    build_role_definitions_delete_request,
    build_role_definitions_get_request,
    build_role_definitions_list_request,
)
from .._configuration import KeyVaultClientConfiguration
from .._vendor import KeyVaultClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class RoleAssignmentsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.keyvault.administration._generated.aio.KeyVaultClient`'s
        :attr:`role_assignments` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: KeyVaultClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def delete(self, scope: str, role_assignment_name: str, **kwargs: Any) -> _models.RoleAssignment:
        """Deletes a role assignment.

        :param scope: The scope of the role assignment to delete. Required.
        :type scope: str
        :param role_assignment_name: The name of the role assignment to delete. Required.
        :type role_assignment_name: str
        :return: RoleAssignment. The RoleAssignment is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleAssignment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RoleAssignment] = kwargs.pop("cls", None)

        _request = build_role_assignments_delete_request(
            scope=scope,
            role_assignment_name=role_assignment_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RoleAssignment, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create(
        self,
        scope: str,
        role_assignment_name: str,
        parameters: _models.RoleAssignmentCreateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleAssignment:
        """Creates a role assignment.

        :param scope: The scope of the role assignment to create. Required.
        :type scope: str
        :param role_assignment_name: The name of the role assignment to create. It can be any valid
         GUID. Required.
        :type role_assignment_name: str
        :param parameters: Parameters for the role assignment. Required.
        :type parameters: ~azure.keyvault.administration._generated.models.RoleAssignmentCreateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleAssignment. The RoleAssignment is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleAssignment
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        scope: str,
        role_assignment_name: str,
        parameters: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleAssignment:
        """Creates a role assignment.

        :param scope: The scope of the role assignment to create. Required.
        :type scope: str
        :param role_assignment_name: The name of the role assignment to create. It can be any valid
         GUID. Required.
        :type role_assignment_name: str
        :param parameters: Parameters for the role assignment. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleAssignment. The RoleAssignment is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleAssignment
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        scope: str,
        role_assignment_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleAssignment:
        """Creates a role assignment.

        :param scope: The scope of the role assignment to create. Required.
        :type scope: str
        :param role_assignment_name: The name of the role assignment to create. It can be any valid
         GUID. Required.
        :type role_assignment_name: str
        :param parameters: Parameters for the role assignment. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleAssignment. The RoleAssignment is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleAssignment
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        scope: str,
        role_assignment_name: str,
        parameters: Union[_models.RoleAssignmentCreateParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.RoleAssignment:
        """Creates a role assignment.

        :param scope: The scope of the role assignment to create. Required.
        :type scope: str
        :param role_assignment_name: The name of the role assignment to create. It can be any valid
         GUID. Required.
        :type role_assignment_name: str
        :param parameters: Parameters for the role assignment. Is one of the following types:
         RoleAssignmentCreateParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.keyvault.administration._generated.models.RoleAssignmentCreateParameters or JSON
         or IO[bytes]
        :return: RoleAssignment. The RoleAssignment is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleAssignment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RoleAssignment] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_role_assignments_create_request(
            scope=scope,
            role_assignment_name=role_assignment_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RoleAssignment, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(self, scope: str, role_assignment_name: str, **kwargs: Any) -> _models.RoleAssignment:
        """Get the specified role assignment.

        :param scope: The scope of the role assignment. Required.
        :type scope: str
        :param role_assignment_name: The name of the role assignment to get. Required.
        :type role_assignment_name: str
        :return: RoleAssignment. The RoleAssignment is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleAssignment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RoleAssignment] = kwargs.pop("cls", None)

        _request = build_role_assignments_get_request(
            scope=scope,
            role_assignment_name=role_assignment_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RoleAssignment, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_for_scope(
        self, scope: str, *, filter: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.RoleAssignment"]:
        """Gets role assignments for a scope.

        :param scope: The scope of the role assignments. Required.
        :type scope: str
        :keyword filter: The filter to apply on the operation. Use $filter=atScope() to return all role
         assignments at or above the scope. Use $filter=principalId eq {id} to return all role
         assignments at, above or below the scope for the specified principal. Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of RoleAssignment
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.administration._generated.models.RoleAssignment]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.RoleAssignment]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_role_assignments_list_for_scope_request(
                    scope=scope,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.RoleAssignment], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.KeyVaultError, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class RoleDefinitionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.keyvault.administration._generated.aio.KeyVaultClient`'s
        :attr:`role_definitions` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: KeyVaultClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def delete(self, scope: str, role_definition_name: str, **kwargs: Any) -> _models.RoleDefinition:
        """Deletes a custom role definition.

        :param scope: The scope of the role definition to delete. Managed HSM only supports '/'.
         Required.
        :type scope: str
        :param role_definition_name: The name (GUID) of the role definition to delete. Required.
        :type role_definition_name: str
        :return: RoleDefinition. The RoleDefinition is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RoleDefinition] = kwargs.pop("cls", None)

        _request = build_role_definitions_delete_request(
            scope=scope,
            role_definition_name=role_definition_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RoleDefinition, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update(
        self,
        scope: str,
        role_definition_name: str,
        parameters: _models.RoleDefinitionCreateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleDefinition:
        """Creates or updates a custom role definition.

        :param scope: The scope of the role definition to create or update. Managed HSM only supports
         '/'. Required.
        :type scope: str
        :param role_definition_name: The name of the role definition to create or update. It can be any
         valid GUID. Required.
        :type role_definition_name: str
        :param parameters: Parameters for the role definition. Required.
        :type parameters: ~azure.keyvault.administration._generated.models.RoleDefinitionCreateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleDefinition. The RoleDefinition is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        scope: str,
        role_definition_name: str,
        parameters: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleDefinition:
        """Creates or updates a custom role definition.

        :param scope: The scope of the role definition to create or update. Managed HSM only supports
         '/'. Required.
        :type scope: str
        :param role_definition_name: The name of the role definition to create or update. It can be any
         valid GUID. Required.
        :type role_definition_name: str
        :param parameters: Parameters for the role definition. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleDefinition. The RoleDefinition is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        scope: str,
        role_definition_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleDefinition:
        """Creates or updates a custom role definition.

        :param scope: The scope of the role definition to create or update. Managed HSM only supports
         '/'. Required.
        :type scope: str
        :param role_definition_name: The name of the role definition to create or update. It can be any
         valid GUID. Required.
        :type role_definition_name: str
        :param parameters: Parameters for the role definition. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleDefinition. The RoleDefinition is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        scope: str,
        role_definition_name: str,
        parameters: Union[_models.RoleDefinitionCreateParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.RoleDefinition:
        """Creates or updates a custom role definition.

        :param scope: The scope of the role definition to create or update. Managed HSM only supports
         '/'. Required.
        :type scope: str
        :param role_definition_name: The name of the role definition to create or update. It can be any
         valid GUID. Required.
        :type role_definition_name: str
        :param parameters: Parameters for the role definition. Is one of the following types:
         RoleDefinitionCreateParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.keyvault.administration._generated.models.RoleDefinitionCreateParameters or JSON
         or IO[bytes]
        :return: RoleDefinition. The RoleDefinition is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RoleDefinition] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_role_definitions_create_or_update_request(
            scope=scope,
            role_definition_name=role_definition_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RoleDefinition, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(self, scope: str, role_definition_name: str, **kwargs: Any) -> _models.RoleDefinition:
        """Get the specified role definition.

        :param scope: The scope of the role definition to get. Managed HSM only supports '/'. Required.
        :type scope: str
        :param role_definition_name: The name of the role definition to get. Required.
        :type role_definition_name: str
        :return: RoleDefinition. The RoleDefinition is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RoleDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RoleDefinition] = kwargs.pop("cls", None)

        _request = build_role_definitions_get_request(
            scope=scope,
            role_definition_name=role_definition_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RoleDefinition, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(
        self, scope: str, *, filter: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.RoleDefinition"]:
        """Get all role definitions that are applicable at scope and above.

        :param scope: The scope of the role definition. Required.
        :type scope: str
        :keyword filter: The filter to apply on the operation. Use atScopeAndBelow filter to search
         below the given scope as well. Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of RoleDefinition
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.administration._generated.models.RoleDefinition]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.RoleDefinition]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_role_definitions_list_request(
                    scope=scope,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.RoleDefinition], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.KeyVaultError, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class KeyVaultClientOperationsMixin(KeyVaultClientMixinABC):

    @distributed_trace_async
    async def full_backup_status(self, job_id: str, **kwargs: Any) -> _models.FullBackupOperation:
        """Returns the status of full backup operation.

        :param job_id: The id returned as part of the backup request. Required.
        :type job_id: str
        :return: FullBackupOperation. The FullBackupOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.FullBackupOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.FullBackupOperation] = kwargs.pop("cls", None)

        _request = build_key_vault_full_backup_status_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FullBackupOperation, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _full_backup_initial(
        self, azure_storage_blob_container_uri: Union[_models.SASTokenParameter, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(azure_storage_blob_container_uri, (IOBase, bytes)):
            _content = azure_storage_blob_container_uri
        else:
            _content = json.dumps(azure_storage_blob_container_uri, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_full_backup_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Azure-AsyncOperation"] = self._deserialize(
            "str", response.headers.get("Azure-AsyncOperation")
        )
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_full_backup(
        self,
        azure_storage_blob_container_uri: _models.SASTokenParameter,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FullBackupOperation]:
        """Creates a full backup using a user-provided SAS token to an Azure blob storage container.

        :param azure_storage_blob_container_uri: Azure blob shared access signature token pointing to a
         valid Azure blob container where full backup needs to be stored. This token needs to be valid
         for at least next 24 hours from the time of making this call. Required.
        :type azure_storage_blob_container_uri: ~azure.keyvault.administration._generated.models.SASTokenParameter
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns FullBackupOperation. The
         FullBackupOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.FullBackupOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_full_backup(
        self, azure_storage_blob_container_uri: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.FullBackupOperation]:
        """Creates a full backup using a user-provided SAS token to an Azure blob storage container.

        :param azure_storage_blob_container_uri: Azure blob shared access signature token pointing to a
         valid Azure blob container where full backup needs to be stored. This token needs to be valid
         for at least next 24 hours from the time of making this call. Required.
        :type azure_storage_blob_container_uri: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns FullBackupOperation. The
         FullBackupOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.FullBackupOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_full_backup(
        self, azure_storage_blob_container_uri: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.FullBackupOperation]:
        """Creates a full backup using a user-provided SAS token to an Azure blob storage container.

        :param azure_storage_blob_container_uri: Azure blob shared access signature token pointing to a
         valid Azure blob container where full backup needs to be stored. This token needs to be valid
         for at least next 24 hours from the time of making this call. Required.
        :type azure_storage_blob_container_uri: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns FullBackupOperation. The
         FullBackupOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.FullBackupOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_full_backup(
        self, azure_storage_blob_container_uri: Union[_models.SASTokenParameter, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.FullBackupOperation]:
        """Creates a full backup using a user-provided SAS token to an Azure blob storage container.

        :param azure_storage_blob_container_uri: Azure blob shared access signature token pointing to a
         valid Azure blob container where full backup needs to be stored. This token needs to be valid
         for at least next 24 hours from the time of making this call. Is one of the following types:
         SASTokenParameter, JSON, IO[bytes] Required.
        :type azure_storage_blob_container_uri: ~azure.keyvault.administration._generated.models.SASTokenParameter
         or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns FullBackupOperation. The
         FullBackupOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.FullBackupOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FullBackupOperation] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._full_backup_initial(
                azure_storage_blob_container_uri=azure_storage_blob_container_uri,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

            deserialized = _deserialize(_models.FullBackupOperation, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.FullBackupOperation].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.FullBackupOperation](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @api_version_validation(
        method_added_on="7.6-preview.2",
        params_added_on={"7.6-preview.2": ["api_version", "content_type", "accept"]},
    )
    async def _pre_full_backup_initial(
        self,
        pre_backup_operation_parameters: Union[_models.PreBackupOperationParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(pre_backup_operation_parameters, (IOBase, bytes)):
            _content = pre_backup_operation_parameters
        else:
            _content = json.dumps(pre_backup_operation_parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_pre_full_backup_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Azure-AsyncOperation"] = self._deserialize(
            "str", response.headers.get("Azure-AsyncOperation")
        )
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_pre_full_backup(
        self,
        pre_backup_operation_parameters: _models.PreBackupOperationParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FullBackupOperation]:
        """Pre-backup operation for checking whether the customer can perform a full backup operation.

        :param pre_backup_operation_parameters: Optional parameters to validate prior to performing a
         full backup operation. Required.
        :type pre_backup_operation_parameters:
         ~azure.keyvault.administration._generated.models.PreBackupOperationParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns FullBackupOperation. The
         FullBackupOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.FullBackupOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_pre_full_backup(
        self, pre_backup_operation_parameters: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.FullBackupOperation]:
        """Pre-backup operation for checking whether the customer can perform a full backup operation.

        :param pre_backup_operation_parameters: Optional parameters to validate prior to performing a
         full backup operation. Required.
        :type pre_backup_operation_parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns FullBackupOperation. The
         FullBackupOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.FullBackupOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_pre_full_backup(
        self, pre_backup_operation_parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.FullBackupOperation]:
        """Pre-backup operation for checking whether the customer can perform a full backup operation.

        :param pre_backup_operation_parameters: Optional parameters to validate prior to performing a
         full backup operation. Required.
        :type pre_backup_operation_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns FullBackupOperation. The
         FullBackupOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.FullBackupOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    @api_version_validation(
        method_added_on="7.6-preview.2",
        params_added_on={"7.6-preview.2": ["api_version", "content_type", "accept"]},
    )
    async def begin_pre_full_backup(
        self,
        pre_backup_operation_parameters: Union[_models.PreBackupOperationParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FullBackupOperation]:
        """Pre-backup operation for checking whether the customer can perform a full backup operation.

        :param pre_backup_operation_parameters: Optional parameters to validate prior to performing a
         full backup operation. Is one of the following types: PreBackupOperationParameters, JSON,
         IO[bytes] Required.
        :type pre_backup_operation_parameters:
         ~azure.keyvault.administration._generated.models.PreBackupOperationParameters or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns FullBackupOperation. The
         FullBackupOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.FullBackupOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FullBackupOperation] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._pre_full_backup_initial(
                pre_backup_operation_parameters=pre_backup_operation_parameters,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

            deserialized = _deserialize(_models.FullBackupOperation, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.FullBackupOperation].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.FullBackupOperation](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def restore_status(self, job_id: str, **kwargs: Any) -> _models.RestoreOperation:
        """Returns the status of restore operation.

        :param job_id: The Job Id returned part of the restore operation. Required.
        :type job_id: str
        :return: RestoreOperation. The RestoreOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.RestoreOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RestoreOperation] = kwargs.pop("cls", None)

        _request = build_key_vault_restore_status_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RestoreOperation, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @api_version_validation(
        method_added_on="7.6-preview.2",
        params_added_on={"7.6-preview.2": ["api_version", "content_type", "accept"]},
    )
    async def _pre_full_restore_operation_initial(
        self,
        pre_restore_operation_parameters: Union[_models.PreRestoreOperationParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(pre_restore_operation_parameters, (IOBase, bytes)):
            _content = pre_restore_operation_parameters
        else:
            _content = json.dumps(pre_restore_operation_parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_pre_full_restore_operation_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Azure-AsyncOperation"] = self._deserialize(
            "str", response.headers.get("Azure-AsyncOperation")
        )
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_pre_full_restore_operation(
        self,
        pre_restore_operation_parameters: _models.PreRestoreOperationParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreOperation]:
        """Pre-restore operation for checking whether the customer can perform a full restore operation.

        :param pre_restore_operation_parameters: Optional pre restore parameters to validate prior to
         performing a full restore operation. Required.
        :type pre_restore_operation_parameters:
         ~azure.keyvault.administration._generated.models.PreRestoreOperationParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns RestoreOperation. The RestoreOperation is
         compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.RestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_pre_full_restore_operation(
        self, pre_restore_operation_parameters: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreOperation]:
        """Pre-restore operation for checking whether the customer can perform a full restore operation.

        :param pre_restore_operation_parameters: Optional pre restore parameters to validate prior to
         performing a full restore operation. Required.
        :type pre_restore_operation_parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns RestoreOperation. The RestoreOperation is
         compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.RestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_pre_full_restore_operation(
        self, pre_restore_operation_parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreOperation]:
        """Pre-restore operation for checking whether the customer can perform a full restore operation.

        :param pre_restore_operation_parameters: Optional pre restore parameters to validate prior to
         performing a full restore operation. Required.
        :type pre_restore_operation_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns RestoreOperation. The RestoreOperation is
         compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.RestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    @api_version_validation(
        method_added_on="7.6-preview.2",
        params_added_on={"7.6-preview.2": ["api_version", "content_type", "accept"]},
    )
    async def begin_pre_full_restore_operation(
        self,
        pre_restore_operation_parameters: Union[_models.PreRestoreOperationParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreOperation]:
        """Pre-restore operation for checking whether the customer can perform a full restore operation.

        :param pre_restore_operation_parameters: Optional pre restore parameters to validate prior to
         performing a full restore operation. Is one of the following types:
         PreRestoreOperationParameters, JSON, IO[bytes] Required.
        :type pre_restore_operation_parameters:
         ~azure.keyvault.administration._generated.models.PreRestoreOperationParameters or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns RestoreOperation. The RestoreOperation is
         compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.RestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RestoreOperation] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._pre_full_restore_operation_initial(
                pre_restore_operation_parameters=pre_restore_operation_parameters,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

            deserialized = _deserialize(_models.RestoreOperation, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RestoreOperation].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RestoreOperation](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _full_restore_operation_initial(
        self, restore_blob_details: Union[_models.RestoreOperationParameters, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(restore_blob_details, (IOBase, bytes)):
            _content = restore_blob_details
        else:
            _content = json.dumps(restore_blob_details, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_full_restore_operation_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Azure-AsyncOperation"] = self._deserialize(
            "str", response.headers.get("Azure-AsyncOperation")
        )
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_full_restore_operation(
        self,
        restore_blob_details: _models.RestoreOperationParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreOperation]:
        """Restores all key materials using the SAS token pointing to a previously stored Azure Blob
        storage backup folder.

        :param restore_blob_details: The Azure blob SAS token pointing to a folder where the previous
         successful full backup was stored. Required.
        :type restore_blob_details: ~azure.keyvault.administration._generated.models.RestoreOperationParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns RestoreOperation. The RestoreOperation is
         compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.RestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_full_restore_operation(
        self, restore_blob_details: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreOperation]:
        """Restores all key materials using the SAS token pointing to a previously stored Azure Blob
        storage backup folder.

        :param restore_blob_details: The Azure blob SAS token pointing to a folder where the previous
         successful full backup was stored. Required.
        :type restore_blob_details: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns RestoreOperation. The RestoreOperation is
         compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.RestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_full_restore_operation(
        self, restore_blob_details: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreOperation]:
        """Restores all key materials using the SAS token pointing to a previously stored Azure Blob
        storage backup folder.

        :param restore_blob_details: The Azure blob SAS token pointing to a folder where the previous
         successful full backup was stored. Required.
        :type restore_blob_details: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns RestoreOperation. The RestoreOperation is
         compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.RestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_full_restore_operation(
        self, restore_blob_details: Union[_models.RestoreOperationParameters, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreOperation]:
        """Restores all key materials using the SAS token pointing to a previously stored Azure Blob
        storage backup folder.

        :param restore_blob_details: The Azure blob SAS token pointing to a folder where the previous
         successful full backup was stored. Is one of the following types: RestoreOperationParameters,
         JSON, IO[bytes] Required.
        :type restore_blob_details: ~azure.keyvault.administration._generated.models.RestoreOperationParameters or
         JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns RestoreOperation. The RestoreOperation is
         compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.RestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RestoreOperation] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._full_restore_operation_initial(
                restore_blob_details=restore_blob_details,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

            deserialized = _deserialize(_models.RestoreOperation, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RestoreOperation].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RestoreOperation](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def selective_key_restore_status(self, job_id: str, **kwargs: Any) -> _models.SelectiveKeyRestoreOperation:
        """Returns the status of the selective key restore operation.

        :param job_id: The Job Id returned part of the restore operation. Required.
        :type job_id: str
        :return: SelectiveKeyRestoreOperation. The SelectiveKeyRestoreOperation is compatible with
         MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.SelectiveKeyRestoreOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SelectiveKeyRestoreOperation] = kwargs.pop("cls", None)

        _request = build_key_vault_selective_key_restore_status_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SelectiveKeyRestoreOperation, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _selective_key_restore_operation_initial(
        self,
        key_name: str,
        restore_blob_details: Union[_models.SelectiveKeyRestoreOperationParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(restore_blob_details, (IOBase, bytes)):
            _content = restore_blob_details
        else:
            _content = json.dumps(restore_blob_details, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_selective_key_restore_operation_request(
            key_name=key_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Azure-AsyncOperation"] = self._deserialize(
            "str", response.headers.get("Azure-AsyncOperation")
        )
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_selective_key_restore_operation(
        self,
        key_name: str,
        restore_blob_details: _models.SelectiveKeyRestoreOperationParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.SelectiveKeyRestoreOperation]:
        """Restores all key versions of a given key using user supplied SAS token pointing to a previously
        stored Azure Blob storage backup folder.

        :param key_name: The name of the key to be restored from the user supplied backup. Required.
        :type key_name: str
        :param restore_blob_details: The Azure blob SAS token pointing to a folder where the previous
         successful full backup was stored. Required.
        :type restore_blob_details:
         ~azure.keyvault.administration._generated.models.SelectiveKeyRestoreOperationParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns SelectiveKeyRestoreOperation. The
         SelectiveKeyRestoreOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.SelectiveKeyRestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_selective_key_restore_operation(
        self, key_name: str, restore_blob_details: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.SelectiveKeyRestoreOperation]:
        """Restores all key versions of a given key using user supplied SAS token pointing to a previously
        stored Azure Blob storage backup folder.

        :param key_name: The name of the key to be restored from the user supplied backup. Required.
        :type key_name: str
        :param restore_blob_details: The Azure blob SAS token pointing to a folder where the previous
         successful full backup was stored. Required.
        :type restore_blob_details: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns SelectiveKeyRestoreOperation. The
         SelectiveKeyRestoreOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.SelectiveKeyRestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_selective_key_restore_operation(
        self, key_name: str, restore_blob_details: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[_models.SelectiveKeyRestoreOperation]:
        """Restores all key versions of a given key using user supplied SAS token pointing to a previously
        stored Azure Blob storage backup folder.

        :param key_name: The name of the key to be restored from the user supplied backup. Required.
        :type key_name: str
        :param restore_blob_details: The Azure blob SAS token pointing to a folder where the previous
         successful full backup was stored. Required.
        :type restore_blob_details: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns SelectiveKeyRestoreOperation. The
         SelectiveKeyRestoreOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.SelectiveKeyRestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_selective_key_restore_operation(
        self,
        key_name: str,
        restore_blob_details: Union[_models.SelectiveKeyRestoreOperationParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.SelectiveKeyRestoreOperation]:
        """Restores all key versions of a given key using user supplied SAS token pointing to a previously
        stored Azure Blob storage backup folder.

        :param key_name: The name of the key to be restored from the user supplied backup. Required.
        :type key_name: str
        :param restore_blob_details: The Azure blob SAS token pointing to a folder where the previous
         successful full backup was stored. Is one of the following types:
         SelectiveKeyRestoreOperationParameters, JSON, IO[bytes] Required.
        :type restore_blob_details:
         ~azure.keyvault.administration._generated.models.SelectiveKeyRestoreOperationParameters or JSON or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns SelectiveKeyRestoreOperation. The
         SelectiveKeyRestoreOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.keyvault.administration._generated.models.SelectiveKeyRestoreOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SelectiveKeyRestoreOperation] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._selective_key_restore_operation_initial(
                key_name=key_name,
                restore_blob_details=restore_blob_details,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

            deserialized = _deserialize(_models.SelectiveKeyRestoreOperation, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.SelectiveKeyRestoreOperation].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.SelectiveKeyRestoreOperation](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    async def update_setting(
        self,
        setting_name: str,
        parameters: _models.UpdateSettingRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Setting:
        """Updates key vault account setting, stores it, then returns the setting name and value to the
        client.

        Description of the pool setting to be updated.

        :param setting_name: The name of the account setting. Must be a valid settings option.
         Required.
        :type setting_name: str
        :param parameters: The parameters to update an account setting. Required.
        :type parameters: ~azure.keyvault.administration._generated.models.UpdateSettingRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Setting. The Setting is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.Setting
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_setting(
        self, setting_name: str, parameters: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Setting:
        """Updates key vault account setting, stores it, then returns the setting name and value to the
        client.

        Description of the pool setting to be updated.

        :param setting_name: The name of the account setting. Must be a valid settings option.
         Required.
        :type setting_name: str
        :param parameters: The parameters to update an account setting. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Setting. The Setting is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.Setting
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_setting(
        self, setting_name: str, parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Setting:
        """Updates key vault account setting, stores it, then returns the setting name and value to the
        client.

        Description of the pool setting to be updated.

        :param setting_name: The name of the account setting. Must be a valid settings option.
         Required.
        :type setting_name: str
        :param parameters: The parameters to update an account setting. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Setting. The Setting is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.Setting
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_setting(
        self, setting_name: str, parameters: Union[_models.UpdateSettingRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.Setting:
        """Updates key vault account setting, stores it, then returns the setting name and value to the
        client.

        Description of the pool setting to be updated.

        :param setting_name: The name of the account setting. Must be a valid settings option.
         Required.
        :type setting_name: str
        :param parameters: The parameters to update an account setting. Is one of the following types:
         UpdateSettingRequest, JSON, IO[bytes] Required.
        :type parameters: ~azure.keyvault.administration._generated.models.UpdateSettingRequest or JSON or
         IO[bytes]
        :return: Setting. The Setting is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.Setting
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Setting] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_update_setting_request(
            setting_name=setting_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Setting, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_setting(self, setting_name: str, **kwargs: Any) -> _models.Setting:
        """Get specified account setting object.

        Retrieves the setting object of a specified setting name.

        :param setting_name: The name of the account setting. Must be a valid settings option.
         Required.
        :type setting_name: str
        :return: Setting. The Setting is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.Setting
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Setting] = kwargs.pop("cls", None)

        _request = build_key_vault_get_setting_request(
            setting_name=setting_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Setting, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_settings(self, **kwargs: Any) -> _models.SettingsListResult:
        """List account settings.

        Retrieves a list of all the available account settings that can be configured.

        :return: SettingsListResult. The SettingsListResult is compatible with MutableMapping
        :rtype: ~azure.keyvault.administration._generated.models.SettingsListResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SettingsListResult] = kwargs.pop("cls", None)

        _request = build_key_vault_get_settings_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SettingsListResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
