# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.devopsinfrastructure import DevOpsInfrastructureMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-devopsinfrastructure
# USAGE
    python create_or_update_pool.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DevOpsInfrastructureMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.pools.begin_create_or_update(
        resource_group_name="rg",
        pool_name="pool",
        resource={
            "location": "eastus",
            "properties": {
                "agentProfile": {"kind": "Stateless"},
                "devCenterProjectResourceId": "/subscriptions/222e81d0-cf38-4dab-baa5-289bf16baaa4/resourceGroups/rg-1es-devcenter/providers/Microsoft.DevCenter/projects/1ES",
                "fabricProfile": {
                    "images": [{"resourceId": "/MicrosoftWindowsServer/WindowsServer/2019-Datacenter/latest"}],
                    "kind": "Vmss",
                    "sku": {"name": "Standard_D4ads_v5"},
                },
                "maximumConcurrency": 10,
                "organizationProfile": {
                    "kind": "AzureDevOps",
                    "organizations": [{"url": "https://mseng.visualstudio.com"}],
                },
                "provisioningState": "Succeeded",
            },
        },
    ).result()
    print(response)


# x-ms-original-file: 2024-10-19/CreateOrUpdatePool.json
if __name__ == "__main__":
    main()
