# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class CustomParameterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning status of the workspace."""

    BOOL = "Bool"
    OBJECT = "Object"
    STRING = "String"


class EncryptionKeySource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault."""

    MICROSOFT_KEYVAULT = "Microsoft.Keyvault"


class KeySource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The encryption keySource (provider). Possible values (case-insensitive):  Default,
    Microsoft.Keyvault.
    """

    DEFAULT = "Default"
    MICROSOFT_KEYVAULT = "Microsoft.Keyvault"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class PeeringProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PeeringState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the virtual network peering."""

    INITIATED = "Initiated"
    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PrivateLinkServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of a private endpoint connection."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning status of the workspace."""

    ACCEPTED = "Accepted"
    RUNNING = "Running"
    READY = "Ready"
    CREATING = "Creating"
    CREATED = "Created"
    DELETING = "Deleting"
    DELETED = "Deleted"
    CANCELED = "Canceled"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The network access type for accessing workspace. Set value to disabled to access workspace only
    via private link.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class RequiredNsgRules(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets a value indicating whether data plane (clusters) to control plane communication
    happen over private endpoint. Supported values are 'AllRules' and 'NoAzureDatabricksRules'.
    'NoAzureServiceRules' value is for internal use only.
    """

    ALL_RULES = "AllRules"
    NO_AZURE_DATABRICKS_RULES = "NoAzureDatabricksRules"
    NO_AZURE_SERVICE_RULES = "NoAzureServiceRules"
