# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Iterable, List, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._configuration import ConfidentialLedgerClientConfiguration
from .._utils.serialization import Serializer
from .._utils.utils import ClientMixinABC

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_confidential_ledger_get_constitution_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/governance/constitution"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_list_consortium_members_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/governance/members"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_enclave_quotes_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/enclaveQuotes"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_list_collections_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/collections"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_list_ledger_entries_request(  # pylint: disable=name-too-long
    *,
    collection_id: Optional[str] = None,
    from_transaction_id: Optional[str] = None,
    to_transaction_id: Optional[str] = None,
    tag: Optional[str] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/transactions"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if collection_id is not None:
        _params["collectionId"] = _SERIALIZER.query("collection_id", collection_id, "str")
    if from_transaction_id is not None:
        _params["fromTransactionId"] = _SERIALIZER.query("from_transaction_id", from_transaction_id, "str")
    if to_transaction_id is not None:
        _params["toTransactionId"] = _SERIALIZER.query("to_transaction_id", to_transaction_id, "str")
    if tag is not None:
        _params["tag"] = _SERIALIZER.query("tag", tag, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_create_ledger_entry_request(  # pylint: disable=name-too-long
    *, collection_id: Optional[str] = None, tags: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/transactions"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if collection_id is not None:
        _params["collectionId"] = _SERIALIZER.query("collection_id", collection_id, "str")
    if tags is not None:
        _params["tags"] = _SERIALIZER.query("tags", tags, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_ledger_entry_request(  # pylint: disable=name-too-long
    transaction_id: str, *, collection_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/transactions/{transactionId}"
    path_format_arguments = {
        "transactionId": _SERIALIZER.url("transaction_id", transaction_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if collection_id is not None:
        _params["collectionId"] = _SERIALIZER.query("collection_id", collection_id, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_receipt_request(  # pylint: disable=name-too-long
    transaction_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/transactions/{transactionId}/receipt"
    path_format_arguments = {
        "transactionId": _SERIALIZER.url("transaction_id", transaction_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_transaction_status_request(  # pylint: disable=name-too-long
    transaction_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/transactions/{transactionId}/status"
    path_format_arguments = {
        "transactionId": _SERIALIZER.url("transaction_id", transaction_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_current_ledger_entry_request(  # pylint: disable=name-too-long
    *, collection_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/transactions/current"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if collection_id is not None:
        _params["collectionId"] = _SERIALIZER.query("collection_id", collection_id, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_list_users_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/users"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_list_ledger_users_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/ledgerUsers"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_delete_user_request(  # pylint: disable=name-too-long
    user_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/users/{userId}"
    path_format_arguments = {
        "userId": _SERIALIZER.url("user_id", user_id, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_user_request(  # pylint: disable=name-too-long
    user_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/users/{userId}"
    path_format_arguments = {
        "userId": _SERIALIZER.url("user_id", user_id, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_create_or_update_user_request(  # pylint: disable=name-too-long
    user_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/users/{userId}"
    path_format_arguments = {
        "userId": _SERIALIZER.url("user_id", user_id, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_delete_ledger_user_request(  # pylint: disable=name-too-long
    user_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/ledgerUsers/{userId}"
    path_format_arguments = {
        "userId": _SERIALIZER.url("user_id", user_id, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_ledger_user_request(  # pylint: disable=name-too-long
    user_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/ledgerUsers/{userId}"
    path_format_arguments = {
        "userId": _SERIALIZER.url("user_id", user_id, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_create_or_update_ledger_user_request(  # pylint: disable=name-too-long
    user_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/ledgerUsers/{userId}"
    path_format_arguments = {
        "userId": _SERIALIZER.url("user_id", user_id, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_user_defined_endpoint_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/userDefinedEndpoints"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_create_user_defined_endpoint_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/userDefinedEndpoints"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_runtime_options_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/userDefinedEndpoints/runtimeOptions"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_update_runtime_options_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/userDefinedEndpoints/runtimeOptions"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_user_defined_endpoints_module_request(  # pylint: disable=name-too-long
    *, module_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/userDefinedEndpoints/modules"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    _params["module_name"] = _SERIALIZER.query("module_name", module_name, "str", skip_quote=True)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_list_user_defined_functions_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/userDefinedFunctions"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_delete_user_defined_function_request(  # pylint: disable=name-too-long
    function_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/userDefinedFunctions/{functionId}"
    path_format_arguments = {
        "functionId": _SERIALIZER.url("function_id", function_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_user_defined_function_request(  # pylint: disable=name-too-long
    function_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/userDefinedFunctions/{functionId}"
    path_format_arguments = {
        "functionId": _SERIALIZER.url("function_id", function_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_create_user_defined_function_request(  # pylint: disable=name-too-long
    function_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/userDefinedFunctions/{functionId}"
    path_format_arguments = {
        "functionId": _SERIALIZER.url("function_id", function_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_execute_user_defined_function_request(  # pylint: disable=name-too-long
    function_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/userDefinedFunctions/{functionId}:execute"
    path_format_arguments = {
        "functionId": _SERIALIZER.url("function_id", function_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_get_user_defined_role_request(  # pylint: disable=name-too-long
    *, role_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/roles"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    _params["roleName"] = _SERIALIZER.query("role_name", role_name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_create_user_defined_role_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/roles"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_update_user_defined_role_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/roles"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_confidential_ledger_delete_user_defined_role_request(  # pylint: disable=name-too-long
    *, role_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-09-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/app/roles"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    _params["roleName"] = _SERIALIZER.query("role_name", role_name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


class ConfidentialLedgerClientOperationsMixin(  # pylint: disable=too-many-public-methods
    ClientMixinABC[PipelineClient[HttpRequest, HttpResponse], ConfidentialLedgerClientConfiguration]
):

    @distributed_trace
    def get_constitution(self, **kwargs: Any) -> JSON:
        """Gets the constitution used for governance.

        The constitution is a script that assesses and applies proposals from consortium members.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "digest": "str",
                    "script": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_constitution_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_consortium_members(self, **kwargs: Any) -> Iterable[JSON]:
        """Lists the consortium members.

        Consortium members can manage the Confidential Ledger.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "certificate": "str",
                    "id": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_consortium_members_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized.get("members", [])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_enclave_quotes(self, **kwargs: Any) -> JSON:
        """Gets quotes for all nodes of the Confidential Ledger.

        A quote is an SGX enclave measurement that can be used to verify the validity of a node and its
        enclave.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "currentNodeId": "str",
                    "enclaveQuotes": {
                        "str": {
                            "nodeId": "str",
                            "quoteVersion": "str",
                            "raw": "str",
                            "mrenclave": "str"
                        }
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_enclave_quotes_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_collections(self, **kwargs: Any) -> Iterable[JSON]:
        """Retrieves a list of collection ids present in the Confidential Ledger.

        Collection ids are user-created collections of ledger entries.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "collectionId": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_collections_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized.get("collections", [])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_ledger_entries(
        self,
        *,
        collection_id: Optional[str] = None,
        from_transaction_id: Optional[str] = None,
        to_transaction_id: Optional[str] = None,
        tag: Optional[str] = None,
        **kwargs: Any,
    ) -> Iterable[JSON]:
        """Gets ledger entries from a collection corresponding to a range.

        A collection id may optionally be specified. Only entries in the specified (or default)
        collection will be returned.

        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword from_transaction_id: Specify the first transaction ID in a range. Default value is
         None.
        :paramtype from_transaction_id: str
        :keyword to_transaction_id: Specify the last transaction ID in a range. Default value is None.
        :paramtype to_transaction_id: str
        :keyword tag: Single tag. Default value is None.
        :paramtype tag: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "contents": "str",
                    "collectionId": "str",
                    "postHooks": [
                        {
                            "functionId": "str",
                            "properties": {
                                "arguments": [
                                    "str"
                                ],
                                "exportedFunctionName": "str",
                                "runtimeOptions": {
                                    "log_exception_details": bool,
                                    "max_cached_interpreters": 0,
                                    "max_execution_time_ms": 0,
                                    "max_heap_bytes": 0,
                                    "max_stack_bytes": 0,
                                    "return_exception_details": bool
                                }
                            }
                        }
                    ],
                    "preHooks": [
                        {
                            "functionId": "str",
                            "properties": {
                                "arguments": [
                                    "str"
                                ],
                                "exportedFunctionName": "str",
                                "runtimeOptions": {
                                    "log_exception_details": bool,
                                    "max_cached_interpreters": 0,
                                    "max_execution_time_ms": 0,
                                    "max_heap_bytes": 0,
                                    "max_stack_bytes": 0,
                                    "return_exception_details": bool
                                }
                            }
                        }
                    ],
                    "transactionId": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_ledger_entries_request(
                    collection_id=collection_id,
                    from_transaction_id=from_transaction_id,
                    to_transaction_id=to_transaction_id,
                    tag=tag,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized.get("entries", [])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @overload
    def create_ledger_entry(
        self,
        entry: JSON,
        *,
        collection_id: Optional[str] = None,
        tags: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Writes a ledger entry.

        A collection id may optionally be specified.

        :param entry: Ledger entry. Required.
        :type entry: JSON
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword tags: Comma separated tags. Default value is None.
        :paramtype tags: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                entry = {
                    "contents": "str",
                    "collectionId": "str",
                    "postHooks": [
                        {
                            "functionId": "str",
                            "properties": {
                                "arguments": [
                                    "str"
                                ],
                                "exportedFunctionName": "str",
                                "runtimeOptions": {
                                    "log_exception_details": bool,
                                    "max_cached_interpreters": 0,
                                    "max_execution_time_ms": 0,
                                    "max_heap_bytes": 0,
                                    "max_stack_bytes": 0,
                                    "return_exception_details": bool
                                }
                            }
                        }
                    ],
                    "preHooks": [
                        {
                            "functionId": "str",
                            "properties": {
                                "arguments": [
                                    "str"
                                ],
                                "exportedFunctionName": "str",
                                "runtimeOptions": {
                                    "log_exception_details": bool,
                                    "max_cached_interpreters": 0,
                                    "max_execution_time_ms": 0,
                                    "max_heap_bytes": 0,
                                    "max_stack_bytes": 0,
                                    "return_exception_details": bool
                                }
                            }
                        }
                    ],
                    "transactionId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "collectionId": "str"
                }
        """

    @overload
    def create_ledger_entry(
        self,
        entry: IO[bytes],
        *,
        collection_id: Optional[str] = None,
        tags: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Writes a ledger entry.

        A collection id may optionally be specified.

        :param entry: Ledger entry. Required.
        :type entry: IO[bytes]
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword tags: Comma separated tags. Default value is None.
        :paramtype tags: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "collectionId": "str"
                }
        """

    @distributed_trace
    def create_ledger_entry(
        self,
        entry: Union[JSON, IO[bytes]],
        *,
        collection_id: Optional[str] = None,
        tags: Optional[str] = None,
        **kwargs: Any,
    ) -> JSON:
        """Writes a ledger entry.

        A collection id may optionally be specified.

        :param entry: Ledger entry. Is either a JSON type or a IO[bytes] type. Required.
        :type entry: JSON or IO[bytes]
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword tags: Comma separated tags. Default value is None.
        :paramtype tags: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                entry = {
                    "contents": "str",
                    "collectionId": "str",
                    "postHooks": [
                        {
                            "functionId": "str",
                            "properties": {
                                "arguments": [
                                    "str"
                                ],
                                "exportedFunctionName": "str",
                                "runtimeOptions": {
                                    "log_exception_details": bool,
                                    "max_cached_interpreters": 0,
                                    "max_execution_time_ms": 0,
                                    "max_heap_bytes": 0,
                                    "max_stack_bytes": 0,
                                    "return_exception_details": bool
                                }
                            }
                        }
                    ],
                    "preHooks": [
                        {
                            "functionId": "str",
                            "properties": {
                                "arguments": [
                                    "str"
                                ],
                                "exportedFunctionName": "str",
                                "runtimeOptions": {
                                    "log_exception_details": bool,
                                    "max_cached_interpreters": 0,
                                    "max_execution_time_ms": 0,
                                    "max_heap_bytes": 0,
                                    "max_stack_bytes": 0,
                                    "return_exception_details": bool
                                }
                            }
                        }
                    ],
                    "transactionId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "collectionId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(entry, (IOBase, bytes)):
            _content = entry
        else:
            _json = entry

        _request = build_confidential_ledger_create_ledger_entry_request(
            collection_id=collection_id,
            tags=tags,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["x-ms-ccf-transaction-id"] = self._deserialize(
            "str", response.headers.get("x-ms-ccf-transaction-id")
        )

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get_ledger_entry(self, transaction_id: str, *, collection_id: Optional[str] = None, **kwargs: Any) -> JSON:
        """Gets the ledger entry at the specified transaction id. A collection id may optionally be
        specified to indicate the collection from which to fetch the value.

        To return older ledger entries, the relevant sections of the ledger must be read from disk and
        validated. To prevent blocking within the enclave, the response will indicate whether the entry
        is ready and part of the response, or if the loading is still ongoing.

        :param transaction_id: Identifies a write transaction. Required.
        :type transaction_id: str
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "state": "str",
                    "entry": {
                        "contents": "str",
                        "collectionId": "str",
                        "postHooks": [
                            {
                                "functionId": "str",
                                "properties": {
                                    "arguments": [
                                        "str"
                                    ],
                                    "exportedFunctionName": "str",
                                    "runtimeOptions": {
                                        "log_exception_details": bool,
                                        "max_cached_interpreters": 0,
                                        "max_execution_time_ms": 0,
                                        "max_heap_bytes": 0,
                                        "max_stack_bytes": 0,
                                        "return_exception_details": bool
                                    }
                                }
                            }
                        ],
                        "preHooks": [
                            {
                                "functionId": "str",
                                "properties": {
                                    "arguments": [
                                        "str"
                                    ],
                                    "exportedFunctionName": "str",
                                    "runtimeOptions": {
                                        "log_exception_details": bool,
                                        "max_cached_interpreters": 0,
                                        "max_execution_time_ms": 0,
                                        "max_heap_bytes": 0,
                                        "max_stack_bytes": 0,
                                        "return_exception_details": bool
                                    }
                                }
                            }
                        ],
                        "transactionId": "str"
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_ledger_entry_request(
            transaction_id=transaction_id,
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get_receipt(self, transaction_id: str, **kwargs: Any) -> JSON:
        """Gets a receipt certifying ledger contents at a particular transaction id.

        Gets a receipt certifying ledger contents at a particular transaction id.

        :param transaction_id: Identifies a write transaction. Required.
        :type transaction_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "state": "str",
                    "transactionId": "str",
                    "applicationClaims": [
                        {
                            "kind": "str",
                            "digest": {
                                "protocol": "str",
                                "value": "str"
                            },
                            "ledgerEntry": {
                                "protocol": "str",
                                "collectionId": "str",
                                "contents": "str",
                                "secretKey": "str"
                            }
                        }
                    ],
                    "receipt": {
                        "nodeId": "str",
                        "proof": [
                            {
                                "left": "str",
                                "right": "str"
                            }
                        ],
                        "signature": "str",
                        "cert": "str",
                        "leaf": "str",
                        "leafComponents": {
                            "claimsDigest": "str",
                            "commitEvidence": "str",
                            "writeSetDigest": "str"
                        },
                        "root": "str",
                        "serviceEndorsements": [
                            "str"
                        ]
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_receipt_request(
            transaction_id=transaction_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get_transaction_status(self, transaction_id: str, **kwargs: Any) -> JSON:
        """Gets the status of an entry identified by a transaction id.

        Gets the status of an entry identified by a transaction id.

        :param transaction_id: Identifies a write transaction. Required.
        :type transaction_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "state": "str",
                    "transactionId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_transaction_status_request(
            transaction_id=transaction_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get_current_ledger_entry(self, *, collection_id: Optional[str] = None, **kwargs: Any) -> JSON:
        """Gets the current value available in the ledger.

        A collection id may optionally be specified.

        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "contents": "str",
                    "collectionId": "str",
                    "postHooks": [
                        {
                            "functionId": "str",
                            "properties": {
                                "arguments": [
                                    "str"
                                ],
                                "exportedFunctionName": "str",
                                "runtimeOptions": {
                                    "log_exception_details": bool,
                                    "max_cached_interpreters": 0,
                                    "max_execution_time_ms": 0,
                                    "max_heap_bytes": 0,
                                    "max_stack_bytes": 0,
                                    "return_exception_details": bool
                                }
                            }
                        }
                    ],
                    "preHooks": [
                        {
                            "functionId": "str",
                            "properties": {
                                "arguments": [
                                    "str"
                                ],
                                "exportedFunctionName": "str",
                                "runtimeOptions": {
                                    "log_exception_details": bool,
                                    "max_cached_interpreters": 0,
                                    "max_execution_time_ms": 0,
                                    "max_heap_bytes": 0,
                                    "max_stack_bytes": 0,
                                    "return_exception_details": bool
                                }
                            }
                        }
                    ],
                    "transactionId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_current_ledger_entry_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_users(self, **kwargs: Any) -> Iterable[JSON]:
        """Gets details on a list of users.

        All users' object IDs and single role per user will be returned.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRole": "str",
                    "userId": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_users_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized.get("ledgerUsers", [])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_ledger_users(self, **kwargs: Any) -> Iterable[JSON]:
        """Gets details on a list of users.

        All users' object IDs and multiple roles will be returned.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_ledger_users_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized.get("ledgerUsers", [])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def delete_user(self, user_id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Deletes a user from the Confidential Ledger.

        Deletes a user from the Confidential Ledger.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_delete_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def get_user(self, user_id: str, **kwargs: Any) -> JSON:
        """Gets a user.

        Gets a user.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRole": "str",
                    "userId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def create_or_update_user(
        self, user_id: str, user_details: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_details: Details about a Confidential Ledger user. Required.
        :type user_details: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_details = {
                    "assignedRole": "str",
                    "userId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "assignedRole": "str",
                    "userId": "str"
                }
        """

    @overload
    def create_or_update_user(
        self,
        user_id: str,
        user_details: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any,
    ) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_details: Details about a Confidential Ledger user. Required.
        :type user_details: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRole": "str",
                    "userId": "str"
                }
        """

    @distributed_trace
    def create_or_update_user(self, user_id: str, user_details: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_details: Details about a Confidential Ledger user. Is either a JSON type or a
         IO[bytes] type. Required.
        :type user_details: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_details = {
                    "assignedRole": "str",
                    "userId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "assignedRole": "str",
                    "userId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(user_details, (IOBase, bytes)):
            _content = user_details
        else:
            _json = user_details

        _request = build_confidential_ledger_create_or_update_user_request(
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def delete_ledger_user(self, user_id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Deletes a user with multiple roles from the Confidential Ledger.

        Deletes a user with multiple roles from the Confidential Ledger.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_delete_ledger_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def get_ledger_user(self, user_id: str, **kwargs: Any) -> JSON:
        """Gets a user with multiple roles.

        Gets a user with multiple roles.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_ledger_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def create_or_update_ledger_user(
        self,
        user_id: str,
        user_multiple_roles: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any,
    ) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_multiple_roles: Details about a Confidential Ledger user with multiple roles.
         Required.
        :type user_multiple_roles: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_multiple_roles = {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }
        """

    @overload
    def create_or_update_ledger_user(
        self,
        user_id: str,
        user_multiple_roles: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any,
    ) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_multiple_roles: Details about a Confidential Ledger user with multiple roles.
         Required.
        :type user_multiple_roles: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }
        """

    @distributed_trace
    def create_or_update_ledger_user(
        self, user_id: str, user_multiple_roles: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> JSON:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_multiple_roles: Details about a Confidential Ledger user with multiple roles. Is
         either a JSON type or a IO[bytes] type. Required.
        :type user_multiple_roles: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_multiple_roles = {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }

                # response body for status code(s): 200
                response == {
                    "assignedRoles": [
                        "str"
                    ],
                    "userId": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(user_multiple_roles, (IOBase, bytes)):
            _content = user_multiple_roles
        else:
            _json = user_multiple_roles

        _request = build_confidential_ledger_create_or_update_ledger_user_request(
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get_user_defined_endpoint(self, **kwargs: Any) -> JSON:
        """Gets a user defined endpoint.

        Returns the user defined endpoint in the ACL instance.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "metadata": {
                        "endpoints": {
                            "str": {
                                "delete": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "get": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "patch": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "put": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                }
                            }
                        }
                    },
                    "modules": {}
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_defined_endpoint_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def create_user_defined_endpoint(
        self, bundle: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates a user defined endpoint.

        Creates the user defined endpoint in the ACL instance.

        :param bundle: bundle parameter description. Required.
        :type bundle: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                bundle = {
                    "metadata": {
                        "endpoints": {
                            "str": {
                                "delete": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "get": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "patch": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "put": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                }
                            }
                        }
                    },
                    "modules": {}
                }
        """

    @overload
    def create_user_defined_endpoint(
        self, bundle: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates a user defined endpoint.

        Creates the user defined endpoint in the ACL instance.

        :param bundle: bundle parameter description. Required.
        :type bundle: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_user_defined_endpoint(  # pylint: disable=inconsistent-return-statements
        self, bundle: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Creates a user defined endpoint.

        Creates the user defined endpoint in the ACL instance.

        :param bundle: bundle parameter description. Is either a JSON type or a IO[bytes] type.
         Required.
        :type bundle: JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                bundle = {
                    "metadata": {
                        "endpoints": {
                            "str": {
                                "delete": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "get": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "patch": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                },
                                "put": {
                                    "authn_policies": [
                                        {}
                                    ],
                                    "forwarding_required": "str",
                                    "interpreter_reuse": {
                                        "key": "str"
                                    },
                                    "js_function": "str",
                                    "js_module": "str",
                                    "mode": "str",
                                    "openapi": {},
                                    "openapi_hidden": bool,
                                    "redirection_strategy": "str"
                                }
                            }
                        }
                    },
                    "modules": {}
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(bundle, (IOBase, bytes)):
            _content = bundle
        else:
            _json = bundle

        _request = build_confidential_ledger_create_user_defined_endpoint_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def get_runtime_options(self, **kwargs: Any) -> JSON:
        """Runtime options for user defined endpoints.

        It returns the runtime options.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_runtime_options_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def update_runtime_options(
        self, js_runtime_options: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Runtime options for user defined endpoints.

        Updates the runtime options.

        :param js_runtime_options: JS runtime options. Required.
        :type js_runtime_options: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                js_runtime_options = {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }

                # response body for status code(s): 200
                response == {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }
        """

    @overload
    def update_runtime_options(
        self, js_runtime_options: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Runtime options for user defined endpoints.

        Updates the runtime options.

        :param js_runtime_options: JS runtime options. Required.
        :type js_runtime_options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }
        """

    @distributed_trace
    def update_runtime_options(self, js_runtime_options: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Runtime options for user defined endpoints.

        Updates the runtime options.

        :param js_runtime_options: JS runtime options. Is either a JSON type or a IO[bytes] type.
         Required.
        :type js_runtime_options: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                js_runtime_options = {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }

                # response body for status code(s): 200
                response == {
                    "log_exception_details": bool,
                    "max_cached_interpreters": 0,
                    "max_execution_time_ms": 0,
                    "max_heap_bytes": 0,
                    "max_stack_bytes": 0,
                    "return_exception_details": bool
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(js_runtime_options, (IOBase, bytes)):
            _content = js_runtime_options
        else:
            _json = js_runtime_options

        _request = build_confidential_ledger_update_runtime_options_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get_user_defined_endpoints_module(self, *, module_name: str, **kwargs: Any) -> JSON:
        """Module for user defined endpoints.

        It gets the module for the user defined endpoint.

        :keyword module_name: module name of the user defined endpoint. Required.
        :paramtype module_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "module": "str",
                    "name": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_defined_endpoints_module_request(
            module_name=module_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_user_defined_functions(self, **kwargs: Any) -> Iterable[JSON]:
        """Retrieves a list of user defined functions present in the Confidential Ledger.

        User defined functions stored in the Confidential Ledger.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "code": "str",
                    "id": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_user_defined_functions_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized.get("functions", [])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def delete_user_defined_function(  # pylint: disable=inconsistent-return-statements
        self, function_id: str, **kwargs: Any
    ) -> None:
        """Deletes a user defined function from the Confidential Ledger.

        Deletes a user defined function from the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_delete_user_defined_function_request(
            function_id=function_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def get_user_defined_function(self, function_id: str, **kwargs: Any) -> JSON:
        """Gets a user defined function.

        Returns the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "code": "str",
                    "id": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_defined_function_request(
            function_id=function_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def create_user_defined_function(
        self, function_id: str, user_defined_function: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Creates a user defined function.

        Creates the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function: Specify a user defined function of a Confidential Ledger.
         Required.
        :type user_defined_function: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_defined_function = {
                    "code": "str",
                    "id": "str"
                }

                # response body for status code(s): 200, 201
                response == {
                    "code": "str",
                    "id": "str"
                }
        """

    @overload
    def create_user_defined_function(
        self,
        function_id: str,
        user_defined_function: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Creates a user defined function.

        Creates the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function: Specify a user defined function of a Confidential Ledger.
         Required.
        :type user_defined_function: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "code": "str",
                    "id": "str"
                }
        """

    @distributed_trace
    def create_user_defined_function(
        self, function_id: str, user_defined_function: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> JSON:
        """Creates a user defined function.

        Creates the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function: Specify a user defined function of a Confidential Ledger. Is
         either a JSON type or a IO[bytes] type. Required.
        :type user_defined_function: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_defined_function = {
                    "code": "str",
                    "id": "str"
                }

                # response body for status code(s): 200, 201
                response == {
                    "code": "str",
                    "id": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(user_defined_function, (IOBase, bytes)):
            _content = user_defined_function
        else:
            _json = user_defined_function

        _request = build_confidential_ledger_create_user_defined_function_request(
            function_id=function_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["x-ms-ccf-transaction-id"] = self._deserialize(
            "str", response.headers.get("x-ms-ccf-transaction-id")
        )

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def execute_user_defined_function(
        self,
        function_id: str,
        user_defined_function_execution_properties: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Executes a user defined function.

        Executes the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function_execution_properties: Specify user defined function execution
         properties. Default value is None.
        :type user_defined_function_execution_properties: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_defined_function_execution_properties = {
                    "arguments": [
                        "str"
                    ],
                    "exportedFunctionName": "str",
                    "runtimeOptions": {
                        "log_exception_details": bool,
                        "max_cached_interpreters": 0,
                        "max_execution_time_ms": 0,
                        "max_heap_bytes": 0,
                        "max_stack_bytes": 0,
                        "return_exception_details": bool
                    }
                }

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "error": {
                        "message": "str"
                    },
                    "result": {
                        "returnValue": "str"
                    }
                }
        """

    @overload
    def execute_user_defined_function(
        self,
        function_id: str,
        user_defined_function_execution_properties: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Executes a user defined function.

        Executes the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function_execution_properties: Specify user defined function execution
         properties. Default value is None.
        :type user_defined_function_execution_properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "error": {
                        "message": "str"
                    },
                    "result": {
                        "returnValue": "str"
                    }
                }
        """

    @distributed_trace
    def execute_user_defined_function(
        self,
        function_id: str,
        user_defined_function_execution_properties: Optional[Union[JSON, IO[bytes]]] = None,
        **kwargs: Any,
    ) -> JSON:
        """Executes a user defined function.

        Executes the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function_execution_properties: Specify user defined function execution
         properties. Is either a JSON type or a IO[bytes] type. Default value is None.
        :type user_defined_function_execution_properties: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                user_defined_function_execution_properties = {
                    "arguments": [
                        "str"
                    ],
                    "exportedFunctionName": "str",
                    "runtimeOptions": {
                        "log_exception_details": bool,
                        "max_cached_interpreters": 0,
                        "max_execution_time_ms": 0,
                        "max_heap_bytes": 0,
                        "max_stack_bytes": 0,
                        "return_exception_details": bool
                    }
                }

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "error": {
                        "message": "str"
                    },
                    "result": {
                        "returnValue": "str"
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(user_defined_function_execution_properties, (IOBase, bytes)):
            _content = user_defined_function_execution_properties
        else:
            if user_defined_function_execution_properties is not None:
                _json = user_defined_function_execution_properties
            else:
                _json = None

        _request = build_confidential_ledger_execute_user_defined_function_request(
            function_id=function_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get_user_defined_role(self, *, role_name: str, **kwargs: Any) -> List[JSON]:
        """Gets role actions for user defined roles.

        user defined roles allow users to define and manage app specific AuthZ policy.

        :keyword role_name: user defined role name. Required.
        :paramtype role_name: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "roleActions": [
                            "str"
                        ],
                        "roleName": "str"
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_defined_role_request(
            role_name=role_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
            if 'roles' in deserialized:
                deserialized = deserialized['roles']
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    def create_user_defined_role(
        self, roles: List[JSON], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates new roles and their actions.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Required.
        :type roles: list[JSON]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                roles = [
                    {
                        "roleActions": [
                            "str"
                        ],
                        "roleName": "str"
                    }
                ]
        """

    @overload
    def create_user_defined_role(
        self, roles: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates new roles and their actions.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Required.
        :type roles: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_user_defined_role(  # pylint: disable=inconsistent-return-statements
        self, roles: Union[List[JSON], IO[bytes]], **kwargs: Any
    ) -> None:
        """Creates new roles and their actions.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Is either a [JSON] type or a IO[bytes] type. Required.
        :type roles: list[JSON] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(roles, (IOBase, bytes)):
            _content = roles
        else:
            _json = {"roles": roles}

        _request = build_confidential_ledger_create_user_defined_role_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    def update_user_defined_role(
        self, roles: List[JSON], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Patch replaces the allowed action on existing roles,if the desire is to remove an existing
        action, the role must be deleted and recreated.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Required.
        :type roles: list[JSON]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                roles = [
                    {
                        "roleActions": [
                            "str"
                        ],
                        "roleName": "str"
                    }
                ]
        """

    @overload
    def update_user_defined_role(
        self, roles: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Patch replaces the allowed action on existing roles,if the desire is to remove an existing
        action, the role must be deleted and recreated.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Required.
        :type roles: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_user_defined_role(  # pylint: disable=inconsistent-return-statements
        self, roles: Union[List[JSON], IO[bytes]], **kwargs: Any
    ) -> None:
        """Patch replaces the allowed action on existing roles,if the desire is to remove an existing
        action, the role must be deleted and recreated.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param roles: user defined role. Is either a [JSON] type or a IO[bytes] type. Required.
        :type roles: list[JSON] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(roles, (IOBase, bytes)):
            _content = roles
        else:
            _json = {"roles": roles}

        _request = build_confidential_ledger_update_user_defined_role_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def delete_user_defined_role(  # pylint: disable=inconsistent-return-statements
        self, *, role_name: str, **kwargs: Any
    ) -> None:
        """Deletes user defined roles.

        A user defined role allows the users to create and manage their own role actions using the API.

        :keyword role_name: user defined role name. Required.
        :paramtype role_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_delete_user_defined_role_request(
            role_name=role_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
