# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Category(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Category."""

    HIGH_AVAILABILITY = "HighAvailability"
    SECURITY = "Security"
    PERFORMANCE = "Performance"
    COST = "Cost"
    OPERATIONAL_EXCELLENCE = "OperationalExcellence"


class ConfigurationName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ConfigurationName."""

    DEFAULT = "default"


class CpuThreshold(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Minimum percentage threshold for Advisor low CPU utilization evaluation. Valid only for
    subscriptions. Valid values: 5 (default), 10, 15 or 20.
    """

    FIVE = "5"
    TEN = "10"
    FIFTEEN = "15"
    TWENTY = "20"


class DigestConfigState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of digest configuration."""

    ACTIVE = "Active"
    DISABLED = "Disabled"


class Impact(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The business impact of the recommendation."""

    HIGH = "High"
    MEDIUM = "Medium"
    LOW = "Low"


class Scenario(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scenario."""

    ALERTS = "Alerts"
