# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._suppressions_operations import (
    build_create_request,
    build_delete_request,
    build_get_request,
    build_list_request,
)

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class SuppressionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.advisor.aio.AdvisorManagementClient`'s
        :attr:`suppressions` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, resource_uri: str, recommendation_id: str, name: str, **kwargs: Any
    ) -> _models.SuppressionContract:
        """Obtains the details of a suppression.

        :param resource_uri: The fully qualified Azure Resource Manager identifier of the resource to
         which the recommendation applies. Required.
        :type resource_uri: str
        :param recommendation_id: The recommendation ID. Required.
        :type recommendation_id: str
        :param name: The name of the suppression. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SuppressionContract or the result of cls(response)
        :rtype: ~azure.mgmt.advisor.models.SuppressionContract
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(
                response=response,
                model=self._deserialize(_models.ArmErrorResponse, response),
                error_format=ARMErrorFormat,
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.SuppressionContract]

        request = build_get_request(
            resource_uri=resource_uri,
            recommendation_id=recommendation_id,
            name=name,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ArmErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SuppressionContract", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}"}  # type: ignore

    @overload
    async def create(
        self,
        resource_uri: str,
        recommendation_id: str,
        name: str,
        suppression_contract: _models.SuppressionContract,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SuppressionContract:
        """Enables the snoozed or dismissed attribute of a recommendation. The snoozed or dismissed
        attribute is referred to as a suppression. Use this API to create or update the snoozed or
        dismissed status of a recommendation.

        :param resource_uri: The fully qualified Azure Resource Manager identifier of the resource to
         which the recommendation applies. Required.
        :type resource_uri: str
        :param recommendation_id: The recommendation ID. Required.
        :type recommendation_id: str
        :param name: The name of the suppression. Required.
        :type name: str
        :param suppression_contract: The snoozed or dismissed attribute; for example, the snooze
         duration. Required.
        :type suppression_contract: ~azure.mgmt.advisor.models.SuppressionContract
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SuppressionContract or the result of cls(response)
        :rtype: ~azure.mgmt.advisor.models.SuppressionContract
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_uri: str,
        recommendation_id: str,
        name: str,
        suppression_contract: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SuppressionContract:
        """Enables the snoozed or dismissed attribute of a recommendation. The snoozed or dismissed
        attribute is referred to as a suppression. Use this API to create or update the snoozed or
        dismissed status of a recommendation.

        :param resource_uri: The fully qualified Azure Resource Manager identifier of the resource to
         which the recommendation applies. Required.
        :type resource_uri: str
        :param recommendation_id: The recommendation ID. Required.
        :type recommendation_id: str
        :param name: The name of the suppression. Required.
        :type name: str
        :param suppression_contract: The snoozed or dismissed attribute; for example, the snooze
         duration. Required.
        :type suppression_contract: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SuppressionContract or the result of cls(response)
        :rtype: ~azure.mgmt.advisor.models.SuppressionContract
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        resource_uri: str,
        recommendation_id: str,
        name: str,
        suppression_contract: Union[_models.SuppressionContract, IO],
        **kwargs: Any
    ) -> _models.SuppressionContract:
        """Enables the snoozed or dismissed attribute of a recommendation. The snoozed or dismissed
        attribute is referred to as a suppression. Use this API to create or update the snoozed or
        dismissed status of a recommendation.

        :param resource_uri: The fully qualified Azure Resource Manager identifier of the resource to
         which the recommendation applies. Required.
        :type resource_uri: str
        :param recommendation_id: The recommendation ID. Required.
        :type recommendation_id: str
        :param name: The name of the suppression. Required.
        :type name: str
        :param suppression_contract: The snoozed or dismissed attribute; for example, the snooze
         duration. Is either a model type or a IO type. Required.
        :type suppression_contract: ~azure.mgmt.advisor.models.SuppressionContract or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SuppressionContract or the result of cls(response)
        :rtype: ~azure.mgmt.advisor.models.SuppressionContract
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(
                response=response,
                model=self._deserialize(_models.ArmErrorResponse, response),
                error_format=ARMErrorFormat,
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-01-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.SuppressionContract]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(suppression_contract, (IO, bytes)):
            _content = suppression_contract
        else:
            _json = self._serialize.body(suppression_contract, "SuppressionContract")

        request = build_create_request(
            resource_uri=resource_uri,
            recommendation_id=recommendation_id,
            name=name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ArmErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SuppressionContract", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create.metadata = {"url": "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}"}  # type: ignore

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_uri: str, recommendation_id: str, name: str, **kwargs: Any
    ) -> None:
        """Enables the activation of a snoozed or dismissed recommendation. The snoozed or dismissed
        attribute of a recommendation is referred to as a suppression.

        :param resource_uri: The fully qualified Azure Resource Manager identifier of the resource to
         which the recommendation applies. Required.
        :type resource_uri: str
        :param recommendation_id: The recommendation ID. Required.
        :type recommendation_id: str
        :param name: The name of the suppression. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_request(
            resource_uri=resource_uri,
            recommendation_id=recommendation_id,
            name=name,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ArmErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {"url": "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}"}  # type: ignore

    @distributed_trace
    def list(
        self, top: Optional[int] = None, skip_token: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.SuppressionContract"]:
        """Retrieves the list of snoozed or dismissed suppressions for a subscription. The snoozed or
        dismissed attribute of a recommendation is referred to as a suppression.

        :param top: The number of suppressions per page if a paged version of this API is being used.
         Default value is None.
        :type top: int
        :param skip_token: The page-continuation token to use with a paged version of this API. Default
         value is None.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SuppressionContract or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.advisor.models.SuppressionContract]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.SuppressionContractListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    top=top,
                    skip_token=skip_token,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SuppressionContractListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ArmErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Advisor/suppressions"}  # type: ignore
