// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_DispPerFiles_HeaderFile
#define _IFSelect_DispPerFiles_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IFSelect_DispPerFiles.hxx>

#include <Handle_IFSelect_IntParam.hxx>
#include <IFSelect_Dispatch.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Boolean.hxx>
class IFSelect_IntParam;
class Interface_InterfaceError;
class TCollection_AsciiString;
class Interface_Graph;
class IFGraph_SubPartsIterator;


//! A DispPerFiles produces a determined count of Packets from the
//! input Entities. It divides, as equally as possible, the input
//! list into a count of files. This count is the parameter of the
//! DispPerFiles. If the input list has less than this count, of
//! course there will be one packet per input entity.
//! This count is a Parameter of the DispPerFiles, given as an
//! IntParam, thus allowing external control of its Value
class IFSelect_DispPerFiles : public IFSelect_Dispatch
{

public:

  
  //! Creates a DispPerFiles with no Count (default value 1 file)
  Standard_EXPORT IFSelect_DispPerFiles();
  
  //! Returns the Count Parameter used for splitting
  Standard_EXPORT   Handle(IFSelect_IntParam) Count()  const;
  
  //! Sets a new Parameter for Count
  Standard_EXPORT   void SetCount (const Handle(IFSelect_IntParam)& count) ;
  
  //! Returns the effective value of the count parameter
  //! (if Count Parameter not Set or value not positive, returns 1)
  Standard_EXPORT   Standard_Integer CountValue()  const;
  
  //! Returns as Label, "Maximum <count> Files"
  Standard_EXPORT   TCollection_AsciiString Label()  const;
  
  //! Returns True, maximum count is given as CountValue
  Standard_EXPORT virtual   Standard_Boolean LimitedMax (const Standard_Integer nbent, Standard_Integer& max)  const;
  
  //! Returns True (count is easy to know) and count is the minimum
  //! value between  length of input list and CountValue
  Standard_EXPORT virtual   Standard_Integer PacketsCount (const Interface_Graph& G, Standard_Integer& count)  const;
  
  //! Computes the list of produced Packets. It defines Packets in
  //! order to have <Count> Packets, except if the input count of
  //! Entities is lower. Entities are given by RootResult from the
  //! Final Selection.
  Standard_EXPORT   void Packets (const Interface_Graph& G, IFGraph_SubPartsIterator& packs)  const;




  DEFINE_STANDARD_RTTI(IFSelect_DispPerFiles)

protected:




private: 


  Handle(IFSelect_IntParam) thecount;


};







#endif // _IFSelect_DispPerFiles_HeaderFile
