// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom2d_Direction_HeaderFile
#define _Geom2d_Direction_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Geom2d_Direction.hxx>

#include <Geom2d_Vector.hxx>
#include <Standard_Real.hxx>
#include <Handle_Geom2d_Vector.hxx>
#include <Handle_Geom2d_Geometry.hxx>
class Standard_ConstructionError;
class gp_Dir2d;
class Geom2d_Vector;
class gp_Trsf2d;
class Geom2d_Geometry;



//! The class Direction specifies a vector that is never null.
//! It is a unit vector.
class Geom2d_Direction : public Geom2d_Vector
{

public:

  
  //! Creates a unit vector with it 2 cartesian coordinates.
  //!
  //! Raised if Sqrt( X*X + Y*Y) <= Resolution from gp.
  Standard_EXPORT Geom2d_Direction(const Standard_Real X, const Standard_Real Y);
  
  //! Creates a persistent copy of <me>.
  Standard_EXPORT Geom2d_Direction(const gp_Dir2d& V);
  
  //! Assigns the coordinates X and Y to this unit vector,
  //! then normalizes it.
  //! Exceptions
  //! Standard_ConstructionError if Sqrt(X*X +
  //! Y*Y) is less than or equal to gp::Resolution().
  Standard_EXPORT   void SetCoord (const Standard_Real X, const Standard_Real Y) ;
  
  //! Converts the gp_Dir2d unit vector V into this unit vector.
  Standard_EXPORT   void SetDir2d (const gp_Dir2d& V) ;
  

  //! Assigns a value to the X coordinate of this unit vector, then normalizes it.
  //! Exceptions
  //! Standard_ConstructionError if the value assigned
  //! causes the magnitude of the vector to become less
  //! than or equal to gp::Resolution().
  Standard_EXPORT   void SetX (const Standard_Real X) ;
  
  //! Assigns a value to the Y coordinate of this unit vector, then normalizes it.
  //! Exceptions
  //! Standard_ConstructionError if the value assigned
  //! causes the magnitude of the vector to become less
  //! than or equal to gp::Resolution().
  Standard_EXPORT   void SetY (const Standard_Real Y) ;
  
  //! Converts this unit vector into a gp_Dir2d unit vector.
  Standard_EXPORT   gp_Dir2d Dir2d()  const;
  
  //! returns 1.0
  Standard_EXPORT   Standard_Real Magnitude()  const;
  
  //! returns 1.0
  Standard_EXPORT   Standard_Real SquareMagnitude()  const;
  
  //! Computes the cross product between <me> and <Other>.
  Standard_EXPORT   Standard_Real Crossed (const Handle(Geom2d_Vector)& Other)  const;
  Standard_Real operator ^ (const Handle(Geom2d_Vector)& Other)  const
{
  return Crossed(Other);
}
  
  //! Applies the transformation T to this unit vector, then normalizes it.
  Standard_EXPORT   void Transform (const gp_Trsf2d& T) ;
  
  //! Creates a new object which is a copy of this unit vector.
  Standard_EXPORT   Handle(Geom2d_Geometry) Copy()  const;




  DEFINE_STANDARD_RTTI(Geom2d_Direction)

protected:




private: 




};







#endif // _Geom2d_Direction_HeaderFile
