/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
* Version: MPL 1.1/GPL 2.0/LGPL 2.1
*
* The contents of this file are subject to the Mozilla Public License Version
* 1.1 (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an "AS IS" basis,
* WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
* for the specific language governing rights and limitations under the
* License.
*
* The Original Code is Mozilla Communicator client code.
*
* The Initial Developer of the Original Code is
* Netscape Communications Corporation.
* Portions created by the Initial Developer are Copyright (C) 1998
* the Initial Developer. All Rights Reserved.
*
* Contributor(s):
 *                 Jehan <jehan@girinstud.io>
*
* Alternatively, the contents of this file may be used under the terms of
* either the GNU General Public License Version 2 or later (the "GPL"), or
* the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
* in which case the provisions of the GPL or the LGPL are applicable instead
* of those above. If you wish to allow use of your version of this file only
* under the terms of either the GPL or the LGPL, and not to allow others to
* use your version of this file under the terms of the MPL, indicate your
* decision by deleting the provisions above and replace them with the notice
* and other provisions required by the GPL or the LGPL. If you do not delete
* the provisions above, a recipient may use your version of this file under
* the terms of any one of the MPL, the GPL or the LGPL.
*
* ***** END LICENSE BLOCK ***** */

#include "nsSBCharSetProber.h"
/****************************************************************
ILL: illegal character.
CTR: control character specific to the charset.
RET: carriage/return.
SYM: symbol (punctuation) that does not belong to word.
NUM: 0 - 9.

*****************************************************************/
static unsigned char win1253_CharToOrderMap[] =
{
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, // 00
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, // 10
SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, // 20
NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, // 30
SYM, 31, 50, 40, 41, 29, 52, 49, 42, 30, 55, 46, 39, 45, 33, 32, // 40
 43, 59, 34, 36, 37, 44, 54, 47, 57, 53, 58,SYM,SYM,SYM,SYM,SYM, // 50
SYM, 31, 50, 40, 41, 29, 52, 49, 42, 30, 55, 46, 39, 45, 33, 32, // 60
 43, 59, 34, 36, 37, 44, 54, 47, 57, 53, 58,SYM,SYM,SYM,SYM,CTR, // 70
SYM,ILL,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,ILL,SYM,ILL,ILL,ILL,ILL, // 80
ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,ILL,SYM,ILL,ILL,ILL,ILL, // 90
SYM,SYM, 17,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,SYM,SYM,SYM,SYM, // a0
SYM,SYM,SYM,SYM,SYM, 62,SYM,SYM, 19, 21, 15,SYM, 16,SYM, 25, 28, // b0
 56,  0, 26, 18, 20,  5, 38,  9, 24,  3,  8, 13, 14,  4, 35,  1, // c0
 11,  6,ILL,  7,  2, 12, 27, 23, 48, 22, 51, 60, 17, 19, 21, 15, // d0
 61,  0, 26, 18, 20,  5, 38,  9, 24,  3,  8, 13, 14,  4, 35,  1, // e0
 11,  6, 10,  7,  2, 12, 27, 23, 48, 22, 51, 60, 16, 25, 28,ILL, // f0
};


static unsigned char Latin7_CharToOrderMap[] =
{
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, // 00
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, // 10
SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, // 20
NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, // 30
SYM, 31, 50, 40, 41, 29, 52, 49, 42, 30, 55, 46, 39, 45, 33, 32, // 40
 43, 59, 34, 36, 37, 44, 54, 47, 57, 53, 58,SYM,SYM,SYM,SYM,SYM, // 50
SYM, 31, 50, 40, 41, 29, 52, 49, 42, 30, 55, 46, 39, 45, 33, 32, // 60
 43, 59, 34, 36, 37, 44, 54, 47, 57, 53, 58,SYM,SYM,SYM,SYM,CTR, // 70
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, // 80
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, // 90
SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, // a0
SYM,SYM,SYM,SYM,SYM,SYM, 17,SYM, 19, 21, 15,SYM, 16,SYM, 25, 28, // b0
 56,  0, 26, 18, 20,  5, 38,  9, 24,  3,  8, 13, 14,  4, 35,  1, // c0
 11,  6,ILL,  7,  2, 12, 27, 23, 48, 22, 51, 60, 17, 19, 21, 15, // d0
 61,  0, 26, 18, 20,  5, 38,  9, 24,  3,  8, 13, 14,  4, 35,  1, // e0
 11,  6, 10,  7,  2, 12, 27, 23, 48, 22, 51, 60, 16, 25, 28,ILL, // f0
};



/* Model Table:
* total sequences: 1318
* first 512 sequences: 0.9559164541711023
* next 512 sequences (512-1024): 0.04258163543188176
* rest sequences: 0.0015019103970159708
*/
char GreekLangModel[] = 
{
1,2,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,2,3,2,3,3,0,3,3,2,3,3,2,0,0,0,0,0,0,3,0,0,3,0,0,0,0,0,0,0,0,0,2,
2,2,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,2,3,2,3,2,2,3,3,3,3,3,2,0,0,0,0,0,0,2,0,0,2,0,0,0,0,1,0,0,0,0,2,
3,3,3,3,2,3,3,3,0,3,2,0,3,2,2,3,3,3,1,3,0,3,3,1,1,2,0,1,3,0,0,0,2,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,
3,3,3,1,3,3,3,3,3,2,3,3,1,3,3,2,3,3,3,3,3,2,3,3,3,0,3,2,3,0,0,0,0,0,0,2,0,0,3,0,0,0,0,0,0,0,0,0,2,
3,3,3,3,3,3,2,3,2,3,2,1,2,2,2,3,3,3,3,3,3,3,3,2,3,2,1,1,3,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
2,2,3,3,3,2,3,3,3,2,3,3,3,3,3,3,2,2,3,2,3,0,3,3,3,3,3,3,2,0,0,0,0,0,0,3,0,0,2,0,0,0,0,0,0,0,0,0,2,
3,3,3,3,3,3,3,3,3,3,2,2,3,2,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,0,0,0,0,0,0,2,0,0,1,0,0,0,0,0,0,0,0,0,1,
3,3,3,3,2,3,3,3,3,3,0,3,3,2,3,3,3,3,1,3,2,3,3,3,3,3,2,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,2,3,3,2,2,3,2,2,3,3,2,3,3,3,0,3,3,3,3,2,1,2,2,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,0,3,1,3,2,3,3,3,0,3,2,0,3,3,0,0,0,3,0,2,0,0,2,3,1,2,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,2,
0,0,0,1,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,2,3,3,0,1,3,0,2,2,3,1,3,3,3,1,3,0,3,3,1,0,2,0,1,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,3,2,3,2,3,3,3,2,3,3,0,3,3,2,2,2,3,2,3,2,1,3,3,0,3,2,2,0,0,0,0,0,0,3,0,0,2,0,0,0,0,0,0,0,0,0,2,
3,3,2,3,2,3,0,2,3,3,2,2,3,3,2,3,3,3,2,3,2,3,3,2,2,3,2,2,3,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,
3,3,1,3,2,3,1,1,0,3,2,3,2,0,3,3,3,3,1,3,1,3,3,1,0,2,3,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
3,3,3,0,3,3,3,3,3,2,3,3,0,3,3,0,0,0,3,0,3,0,3,3,2,0,2,2,0,0,0,0,0,0,0,2,0,0,3,0,0,0,0,0,0,0,0,0,2,
2,2,3,2,3,2,3,3,2,2,3,3,1,3,3,0,0,0,3,0,3,0,1,3,2,0,2,2,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,2,
1,2,3,3,3,2,3,3,3,1,3,3,1,3,3,0,0,0,3,0,3,0,0,3,3,0,2,3,0,0,0,0,0,0,0,2,0,0,3,0,0,0,0,0,0,0,0,0,2,
3,3,0,3,3,3,3,0,3,3,0,0,3,3,3,3,3,3,3,3,2,3,3,3,0,2,0,0,2,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,2,3,2,3,3,3,1,3,3,1,3,3,0,0,0,3,0,3,0,3,3,3,0,3,3,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,2,
3,3,0,3,2,3,3,1,0,3,0,0,3,0,1,3,3,2,0,3,0,3,3,0,0,3,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,3,1,3,1,3,3,3,0,3,2,0,3,3,0,0,0,2,0,2,0,0,2,3,0,2,3,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,2,
2,1,3,2,3,1,3,3,2,0,3,3,0,2,3,1,0,2,3,1,2,2,0,2,3,0,2,2,1,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,1,0,3,0,0,2,2,2,3,2,3,0,3,0,3,3,0,3,2,1,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,0,3,3,3,3,0,0,3,1,0,3,2,3,2,2,3,0,3,0,3,2,0,0,2,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,3,3,1,3,2,3,3,2,2,3,3,0,3,3,0,0,0,3,0,2,0,1,2,3,0,2,2,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,2,
3,3,0,3,1,3,3,0,0,2,1,0,2,3,1,3,2,3,2,3,2,2,2,0,0,2,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,3,2,3,3,2,1,2,0,1,3,2,1,3,2,3,1,3,0,3,3,0,2,2,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,3,2,3,0,3,3,2,2,3,2,0,2,2,0,0,0,2,0,2,0,1,1,3,0,2,1,0,0,0,0,0,0,0,1,0,0,2,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,3,3,0,3,2,0,3,2,3,1,2,2,2,2,2,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,2,2,3,3,3,2,0,3,3,0,2,3,2,1,2,2,2,3,2,0,
0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,3,3,0,2,3,0,3,2,2,2,2,2,2,2,2,0,
0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,3,3,0,2,2,0,2,2,2,2,3,2,2,2,2,0,
0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,2,2,2,0,2,3,0,1,2,3,1,1,2,1,2,2,0,
0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,2,2,0,3,2,0,2,2,2,1,1,2,2,2,1,0,
3,3,1,3,0,3,0,0,1,3,0,1,2,1,0,2,2,2,0,2,0,2,2,0,0,3,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,2,2,2,2,0,2,3,0,2,2,0,2,2,2,2,2,1,0,
0,2,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,2,0,2,2,0,2,2,0,3,2,2,1,0,2,0,
3,3,0,2,1,3,2,0,1,2,0,1,2,0,1,2,2,2,0,2,0,2,3,1,0,2,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,1,1,0,2,2,0,3,1,2,0,1,2,1,2,1,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,3,1,2,0,0,2,0,2,2,1,2,1,2,2,2,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,2,2,1,2,0,2,1,0,2,2,2,0,0,2,1,0,2,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,2,2,2,2,0,1,2,0,0,1,0,0,1,2,0,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,3,2,2,3,0,1,2,0,2,0,1,2,2,2,1,1,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,3,2,0,2,2,0,2,2,2,1,2,0,2,2,2,0,
1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,3,2,1,1,0,2,1,0,1,1,0,0,2,2,2,0,1,0,
1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,3,2,2,2,2,0,2,2,0,2,0,0,2,0,2,2,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,2,2,2,1,0,2,1,0,2,0,1,1,0,1,1,1,2,0,
2,2,0,2,0,3,0,0,0,3,0,0,2,0,0,2,1,1,0,1,0,3,1,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


SequenceModel Win1253_GreekModel = 
{
win1253_CharToOrderMap,
GreekLangModel,
49,
(float)0.9559164541711023,
PR_FALSE,
"windows-1253"
};

SequenceModel Latin7_GreekModel = 
{
Latin7_CharToOrderMap,
GreekLangModel,
49,
(float)0.9559164541711023,
PR_FALSE,
"ISO-8859-7"
};
