; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s -mtriple=powerpc64-unknown-linux -mcpu=pwr9 -O0 | FileCheck %s

define i32 @une_ppcf128(ppc_fp128 %a, ppc_fp128 %b) #0 {
; CHECK-LABEL: une_ppcf128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu cr0, f1, f3
; CHECK-NEXT:    crmove 4*cr5+lt, eq
; CHECK-NEXT:    fcmpu cr1, f2, f4
; CHECK-NEXT:    crmove 4*cr5+gt, 4*cr1+eq
; CHECK-NEXT:    crnot 4*cr5+gt, 4*cr5+gt
; CHECK-NEXT:    crand 4*cr5+gt, 4*cr5+lt, 4*cr5+gt
; CHECK-NEXT:    crmove 4*cr5+lt, eq
; CHECK-NEXT:    crnot 4*cr5+lt, 4*cr5+lt
; CHECK-NEXT:    crand 4*cr5+lt, 4*cr5+lt, 4*cr5+lt
; CHECK-NEXT:    cror 4*cr5+lt, 4*cr5+lt, 4*cr5+gt
; CHECK-NEXT:    li r4, 0
; CHECK-NEXT:    li r3, 1
; CHECK-NEXT:    isel r3, r3, r4, 4*cr5+lt
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %0 = call i1 @llvm.experimental.constrained.fcmp.ppcf128(ppc_fp128 %a, ppc_fp128 %b, metadata !"une", metadata !"fpexcept.strict") #0
  %1 = zext i1 %0 to i32
  ret i32 %1
}

; This is a different branch from une
define i32 @ogt_ppcf128(ppc_fp128 %a, ppc_fp128 %b) #0 {
; CHECK-LABEL: ogt_ppcf128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu cr0, f1, f3
; CHECK-NEXT:    crmove 4*cr5+lt, eq
; CHECK-NEXT:    fcmpu cr1, f2, f4
; CHECK-NEXT:    crmove 4*cr5+gt, 4*cr1+gt
; CHECK-NEXT:    crand 4*cr5+gt, 4*cr5+lt, 4*cr5+gt
; CHECK-NEXT:    crmove 4*cr5+lt, eq
; CHECK-NEXT:    crnot 4*cr5+lt, 4*cr5+lt
; CHECK-NEXT:    crmove 4*cr5+eq, gt
; CHECK-NEXT:    crand 4*cr5+lt, 4*cr5+lt, 4*cr5+eq
; CHECK-NEXT:    cror 4*cr5+lt, 4*cr5+lt, 4*cr5+gt
; CHECK-NEXT:    li r4, 0
; CHECK-NEXT:    li r3, 1
; CHECK-NEXT:    isel r3, r3, r4, 4*cr5+lt
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %0 = call i1 @llvm.experimental.constrained.fcmp.ppcf128(ppc_fp128 %a, ppc_fp128 %b, metadata !"ogt", metadata !"fpexcept.strict") #0
  %1 = zext i1 %0 to i32
  ret i32 %1
}

define i1 @test_f128(fp128 %a, fp128 %b) #0 {
; CHECK-LABEL: test_f128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscmpuqp cr0, v2, v3
; CHECK-NEXT:    crmove 4*cr5+lt, eq
; CHECK-NEXT:    crnot 4*cr5+lt, 4*cr5+lt
; CHECK-NEXT:    li r4, 0
; CHECK-NEXT:    li r3, 1
; CHECK-NEXT:    isel r3, r3, r4, 4*cr5+lt
; CHECK-NEXT:    blr
entry:
  %0 = call i1 @llvm.experimental.constrained.fcmp.f128(fp128 %a, fp128 %b, metadata !"une", metadata !"fpexcept.strict") #0
  ret i1 %0
}

define i1 @testbr_f64(double %a, double %b) #0 {
; CHECK-LABEL: testbr_f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    crmove 4*cr5+lt, eq
; CHECK-NEXT:    bc 12, 4*cr5+lt, .LBB3_2
; CHECK-NEXT:    b .LBB3_1
; CHECK-NEXT:  .LBB3_1: # %tr
; CHECK-NEXT:    li r3, -1
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB3_2: # %fl
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    blr
entry:
  %0 = call i1 @llvm.experimental.constrained.fcmp.f64(double %a, double %b, metadata !"une", metadata !"fpexcept.strict") #0
  br i1 %0, label %tr, label %fl
tr:
  ret i1 true
fl:
  ret i1 false
}

define i1 @testbr_f32(float %a, float %b) #0 {
; CHECK-LABEL: testbr_f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    crmove 4*cr5+lt, eq
; CHECK-NEXT:    bc 12, 4*cr5+lt, .LBB4_2
; CHECK-NEXT:    b .LBB4_1
; CHECK-NEXT:  .LBB4_1: # %tr
; CHECK-NEXT:    li r3, -1
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB4_2: # %fl
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    blr
entry:
  %0 = call i1 @llvm.experimental.constrained.fcmp.f32(float %a, float %b, metadata !"une", metadata !"fpexcept.strict") #0
  br i1 %0, label %tr, label %fl
tr:
  ret i1 true
fl:
  ret i1 false
}

declare i1 @llvm.experimental.constrained.fcmp.ppcf128(ppc_fp128, ppc_fp128, metadata, metadata)
declare i1 @llvm.experimental.constrained.fcmp.f128(fp128, fp128, metadata, metadata)
declare i1 @llvm.experimental.constrained.fcmp.f64(double, double, metadata, metadata)
declare i1 @llvm.experimental.constrained.fcmp.f32(float, float, metadata, metadata)

attributes #0 = { strictfp }
