// ------------------------------------------------------------------------------
// NOTE: This file was generated from Microsoft's Language Server Protocol (LSP)
// specification. Please do not edit it by hand.
// ------------------------------------------------------------------------------

#include <stdexcept>

#include <server/lsp_exception.h>
#include <server/lsp_specification.h>
#include <server/lsp_transformer.h>

namespace LCompilers::LanguageServerProtocol {

    auto LspTransformer::anyToSemanticTokenTypes(
        const LSPAny &any
    ) const -> SemanticTokenTypes
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return semanticTokenTypesByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "SemanticTokenTypes"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::semanticTokenTypesToAny(
        SemanticTokenTypes enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = SemanticTokenTypesValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToSemanticTokenModifiers(
        const LSPAny &any
    ) const -> SemanticTokenModifiers
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return semanticTokenModifiersByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "SemanticTokenModifiers"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::semanticTokenModifiersToAny(
        SemanticTokenModifiers enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = SemanticTokenModifiersValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToDocumentDiagnosticReportKind(
        const LSPAny &any
    ) const -> DocumentDiagnosticReportKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return documentDiagnosticReportKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "DocumentDiagnosticReportKind"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::documentDiagnosticReportKindToAny(
        DocumentDiagnosticReportKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = DocumentDiagnosticReportKindValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToErrorCodes(const LSPAny &any) const -> ErrorCodes
    {
        try {
            switch (any.type()) {
            case LSPAnyType::Integer: {
                integer_t value = any.integer();
                return errorCodesByValue(value);
            }
            case LSPAnyType::UInteger: {
                integer_t value = static_cast<integer_t>(any.integer());
                return errorCodesByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for an "
                     "ErrorCodes"
                     " must be of type LSPAnyType::Integer"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::errorCodesToAny(ErrorCodes enumerator) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<integer_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToLSPErrorCodes(
        const LSPAny &any
    ) const -> LSPErrorCodes
    {
        try {
            switch (any.type()) {
            case LSPAnyType::Integer: {
                integer_t value = any.integer();
                return lspErrorCodesByValue(value);
            }
            case LSPAnyType::UInteger: {
                integer_t value = static_cast<integer_t>(any.integer());
                return lspErrorCodesByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "LSPErrorCodes"
                     " must be of type LSPAnyType::Integer"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::lspErrorCodesToAny(
        LSPErrorCodes enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<integer_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToFoldingRangeKind(
        const LSPAny &any
    ) const -> FoldingRangeKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return foldingRangeKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "FoldingRangeKind"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::foldingRangeKindToAny(
        FoldingRangeKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = FoldingRangeKindValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToFoldingRangeClientCapabilities_foldingRangeKind(
        const LSPAny &any
    ) const -> FoldingRangeClientCapabilities_foldingRangeKind
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FoldingRangeClientCapabilities_foldingRangeKind"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FoldingRangeClientCapabilities_foldingRangeKind value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FoldingRangeClientCapabilities_foldingRangeKind"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("valueSet");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<FoldingRangeKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToFoldingRangeKind(*elem_0));
            }
            value_0.valueSet = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::foldingRangeClientCapabilities_foldingRangeKindToAny(
        const FoldingRangeClientCapabilities_foldingRangeKind &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.valueSet.has_value()) {
            const auto &valueSet_0 = param.valueSet.value();
            LSPArray array_0;
            array_0.reserve(valueSet_0.size());
            for (const auto &elem_0 : valueSet_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = foldingRangeKindToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("valueSet", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::foldingRangeClientCapabilities_foldingRangeKind_valueSetToAny(
        const FoldingRangeClientCapabilities_foldingRangeKind_valueSet &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = foldingRangeKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToFoldingRangeClientCapabilities_foldingRangeKind_valueSet(
        const LSPAny &any
    ) const -> FoldingRangeClientCapabilities_foldingRangeKind_valueSet
    {
        const auto &array_0 = any.array();
        std::vector<FoldingRangeKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToFoldingRangeKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToSymbolKind(const LSPAny &any) const -> SymbolKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return symbolKindByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return symbolKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "SymbolKind"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::symbolKindToAny(SymbolKind enumerator) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToWorkspaceSymbolClientCapabilities_symbolKind(
        const LSPAny &any
    ) const -> WorkspaceSymbolClientCapabilities_symbolKind
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceSymbolClientCapabilities_symbolKind"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceSymbolClientCapabilities_symbolKind value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceSymbolClientCapabilities_symbolKind"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("valueSet");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<SymbolKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToSymbolKind(*elem_0));
            }
            value_0.valueSet = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::workspaceSymbolClientCapabilities_symbolKindToAny(
        const WorkspaceSymbolClientCapabilities_symbolKind &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.valueSet.has_value()) {
            const auto &valueSet_0 = param.valueSet.value();
            LSPArray array_0;
            array_0.reserve(valueSet_0.size());
            for (const auto &elem_0 : valueSet_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = symbolKindToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("valueSet", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::workspaceSymbolClientCapabilities_symbolKind_valueSetToAny(
        const WorkspaceSymbolClientCapabilities_symbolKind_valueSet &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = symbolKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToWorkspaceSymbolClientCapabilities_symbolKind_valueSet(
        const LSPAny &any
    ) const -> WorkspaceSymbolClientCapabilities_symbolKind_valueSet
    {
        const auto &array_0 = any.array();
        std::vector<SymbolKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToSymbolKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToDocumentSymbolClientCapabilities_symbolKind(
        const LSPAny &any
    ) const -> DocumentSymbolClientCapabilities_symbolKind
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentSymbolClientCapabilities_symbolKind"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentSymbolClientCapabilities_symbolKind value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentSymbolClientCapabilities_symbolKind"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("valueSet");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<SymbolKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToSymbolKind(*elem_0));
            }
            value_0.valueSet = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::documentSymbolClientCapabilities_symbolKindToAny(
        const DocumentSymbolClientCapabilities_symbolKind &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.valueSet.has_value()) {
            const auto &valueSet_0 = param.valueSet.value();
            LSPArray array_0;
            array_0.reserve(valueSet_0.size());
            for (const auto &elem_0 : valueSet_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = symbolKindToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("valueSet", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::documentSymbolClientCapabilities_symbolKind_valueSetToAny(
        const DocumentSymbolClientCapabilities_symbolKind_valueSet &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = symbolKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDocumentSymbolClientCapabilities_symbolKind_valueSet(
        const LSPAny &any
    ) const -> DocumentSymbolClientCapabilities_symbolKind_valueSet
    {
        const auto &array_0 = any.array();
        std::vector<SymbolKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToSymbolKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToSymbolTag(const LSPAny &any) const -> SymbolTag
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return symbolTagByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return symbolTagByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "SymbolTag"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::symbolTagToAny(SymbolTag enumerator) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::callHierarchyItem_tagsToAny(
        const CallHierarchyItem_tags &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = symbolTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCallHierarchyItem_tags(
        const LSPAny &any
    ) const -> CallHierarchyItem_tags
    {
        const auto &array_0 = any.array();
        std::vector<SymbolTag> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToSymbolTag(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::typeHierarchyItem_tagsToAny(
        const TypeHierarchyItem_tags &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = symbolTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToTypeHierarchyItem_tags(
        const LSPAny &any
    ) const -> TypeHierarchyItem_tags
    {
        const auto &array_0 = any.array();
        std::vector<SymbolTag> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToSymbolTag(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::documentSymbol_tagsToAny(
        const DocumentSymbol_tags &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = symbolTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDocumentSymbol_tags(
        const LSPAny &any
    ) const -> DocumentSymbol_tags
    {
        const auto &array_0 = any.array();
        std::vector<SymbolTag> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToSymbolTag(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::baseSymbolInformation_tagsToAny(
        const BaseSymbolInformation_tags &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = symbolTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToBaseSymbolInformation_tags(
        const LSPAny &any
    ) const -> BaseSymbolInformation_tags
    {
        const auto &array_0 = any.array();
        std::vector<SymbolTag> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToSymbolTag(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToWorkspaceSymbolClientCapabilities_tagSupport(
        const LSPAny &any
    ) const -> WorkspaceSymbolClientCapabilities_tagSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceSymbolClientCapabilities_tagSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceSymbolClientCapabilities_tagSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceSymbolClientCapabilities_tagSupport"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("valueSet");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<SymbolTag> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToSymbolTag(*elem_0));
            }
            value_0.valueSet = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WorkspaceSymbolClientCapabilities_tagSupport attribute: valueSet"
            );
        }

        return value_0;
    }

    auto LspTransformer::workspaceSymbolClientCapabilities_tagSupportToAny(
        const WorkspaceSymbolClientCapabilities_tagSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.valueSet.size());
        for (const auto &elem_0 : param.valueSet) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = symbolTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("valueSet", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::workspaceSymbolClientCapabilities_tagSupport_valueSetToAny(
        const WorkspaceSymbolClientCapabilities_tagSupport_valueSet &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = symbolTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToWorkspaceSymbolClientCapabilities_tagSupport_valueSet(
        const LSPAny &any
    ) const -> WorkspaceSymbolClientCapabilities_tagSupport_valueSet
    {
        const auto &array_0 = any.array();
        std::vector<SymbolTag> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToSymbolTag(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToDocumentSymbolClientCapabilities_tagSupport(
        const LSPAny &any
    ) const -> DocumentSymbolClientCapabilities_tagSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentSymbolClientCapabilities_tagSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentSymbolClientCapabilities_tagSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentSymbolClientCapabilities_tagSupport"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("valueSet");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<SymbolTag> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToSymbolTag(*elem_0));
            }
            value_0.valueSet = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentSymbolClientCapabilities_tagSupport attribute: valueSet"
            );
        }

        return value_0;
    }

    auto LspTransformer::documentSymbolClientCapabilities_tagSupportToAny(
        const DocumentSymbolClientCapabilities_tagSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.valueSet.size());
        for (const auto &elem_0 : param.valueSet) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = symbolTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("valueSet", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::documentSymbolClientCapabilities_tagSupport_valueSetToAny(
        const DocumentSymbolClientCapabilities_tagSupport_valueSet &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = symbolTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDocumentSymbolClientCapabilities_tagSupport_valueSet(
        const LSPAny &any
    ) const -> DocumentSymbolClientCapabilities_tagSupport_valueSet
    {
        const auto &array_0 = any.array();
        std::vector<SymbolTag> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToSymbolTag(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToUniquenessLevel(
        const LSPAny &any
    ) const -> UniquenessLevel
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return uniquenessLevelByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for an "
                     "UniquenessLevel"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::uniquenessLevelToAny(
        UniquenessLevel enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = UniquenessLevelValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToMonikerKind(
        const LSPAny &any
    ) const -> MonikerKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return monikerKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "MonikerKind"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::monikerKindToAny(
        MonikerKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = MonikerKindValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToInlayHintKind(
        const LSPAny &any
    ) const -> InlayHintKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return inlayHintKindByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return inlayHintKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for an "
                     "InlayHintKind"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::inlayHintKindToAny(
        InlayHintKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToMessageType(
        const LSPAny &any
    ) const -> MessageType
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return messageTypeByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return messageTypeByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "MessageType"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::messageTypeToAny(
        MessageType enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentSyncKind(
        const LSPAny &any
    ) const -> TextDocumentSyncKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return textDocumentSyncKindByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return textDocumentSyncKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "TextDocumentSyncKind"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::textDocumentSyncKindToAny(
        TextDocumentSyncKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentSaveReason(
        const LSPAny &any
    ) const -> TextDocumentSaveReason
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return textDocumentSaveReasonByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return textDocumentSaveReasonByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "TextDocumentSaveReason"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::textDocumentSaveReasonToAny(
        TextDocumentSaveReason enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToCompletionItemKind(
        const LSPAny &any
    ) const -> CompletionItemKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return completionItemKindByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return completionItemKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "CompletionItemKind"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::completionItemKindToAny(
        CompletionItemKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionItemKind(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionItemKind
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionClientCapabilities_completionItemKind"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionClientCapabilities_completionItemKind value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionClientCapabilities_completionItemKind"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("valueSet");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<CompletionItemKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToCompletionItemKind(*elem_0));
            }
            value_0.valueSet = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::completionClientCapabilities_completionItemKindToAny(
        const CompletionClientCapabilities_completionItemKind &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.valueSet.has_value()) {
            const auto &valueSet_0 = param.valueSet.value();
            LSPArray array_0;
            array_0.reserve(valueSet_0.size());
            for (const auto &elem_0 : valueSet_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = completionItemKindToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("valueSet", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::completionClientCapabilities_completionItemKind_valueSetToAny(
        const CompletionClientCapabilities_completionItemKind_valueSet &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = completionItemKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionItemKind_valueSet(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionItemKind_valueSet
    {
        const auto &array_0 = any.array();
        std::vector<CompletionItemKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToCompletionItemKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToCompletionItemTag(
        const LSPAny &any
    ) const -> CompletionItemTag
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return completionItemTagByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return completionItemTagByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "CompletionItemTag"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::completionItemTagToAny(
        CompletionItemTag enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::completionItem_tagsToAny(
        const CompletionItem_tags &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = completionItemTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionItem_tags(
        const LSPAny &any
    ) const -> CompletionItem_tags
    {
        const auto &array_0 = any.array();
        std::vector<CompletionItemTag> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToCompletionItemTag(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionItem_tagSupport(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionItem_tagSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionClientCapabilities_completionItem_tagSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionClientCapabilities_completionItem_tagSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionClientCapabilities_completionItem_tagSupport"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("valueSet");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<CompletionItemTag> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToCompletionItemTag(*elem_0));
            }
            value_0.valueSet = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CompletionClientCapabilities_completionItem_tagSupport attribute: valueSet"
            );
        }

        return value_0;
    }

    auto LspTransformer::completionClientCapabilities_completionItem_tagSupportToAny(
        const CompletionClientCapabilities_completionItem_tagSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.valueSet.size());
        for (const auto &elem_0 : param.valueSet) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = completionItemTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("valueSet", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::completionClientCapabilities_completionItem_tagSupport_valueSetToAny(
        const CompletionClientCapabilities_completionItem_tagSupport_valueSet &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = completionItemTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionItem_tagSupport_valueSet(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionItem_tagSupport_valueSet
    {
        const auto &array_0 = any.array();
        std::vector<CompletionItemTag> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToCompletionItemTag(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToInsertTextFormat(
        const LSPAny &any
    ) const -> InsertTextFormat
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return insertTextFormatByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return insertTextFormatByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for an "
                     "InsertTextFormat"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::insertTextFormatToAny(
        InsertTextFormat enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToInsertTextMode(
        const LSPAny &any
    ) const -> InsertTextMode
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return insertTextModeByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return insertTextModeByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for an "
                     "InsertTextMode"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::insertTextModeToAny(
        InsertTextMode enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionItem_insertTextModeSupport(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionItem_insertTextModeSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionClientCapabilities_completionItem_insertTextModeSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionClientCapabilities_completionItem_insertTextModeSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionClientCapabilities_completionItem_insertTextModeSupport"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("valueSet");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<InsertTextMode> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToInsertTextMode(*elem_0));
            }
            value_0.valueSet = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CompletionClientCapabilities_completionItem_insertTextModeSupport attribute: valueSet"
            );
        }

        return value_0;
    }

    auto LspTransformer::completionClientCapabilities_completionItem_insertTextModeSupportToAny(
        const CompletionClientCapabilities_completionItem_insertTextModeSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.valueSet.size());
        for (const auto &elem_0 : param.valueSet) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = insertTextModeToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("valueSet", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::completionClientCapabilities_completionItem_insertTextModeSupport_valueSetToAny(
        const CompletionClientCapabilities_completionItem_insertTextModeSupport_valueSet &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = insertTextModeToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionItem_insertTextModeSupport_valueSet(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionItem_insertTextModeSupport_valueSet
    {
        const auto &array_0 = any.array();
        std::vector<InsertTextMode> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToInsertTextMode(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToDocumentHighlightKind(
        const LSPAny &any
    ) const -> DocumentHighlightKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return documentHighlightKindByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return documentHighlightKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "DocumentHighlightKind"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::documentHighlightKindToAny(
        DocumentHighlightKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToCodeActionKind(
        const LSPAny &any
    ) const -> CodeActionKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return codeActionKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "CodeActionKind"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::codeActionKindToAny(
        CodeActionKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = CodeActionKindValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::codeActionContext_onlyToAny(
        const CodeActionContext_only &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = codeActionKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCodeActionContext_only(
        const LSPAny &any
    ) const -> CodeActionContext_only
    {
        const auto &array_0 = any.array();
        std::vector<CodeActionKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToCodeActionKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::codeActionOptions_codeActionKindsToAny(
        const CodeActionOptions_codeActionKinds &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = codeActionKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCodeActionOptions_codeActionKinds(
        const LSPAny &any
    ) const -> CodeActionOptions_codeActionKinds
    {
        const auto &array_0 = any.array();
        std::vector<CodeActionKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToCodeActionKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToCodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind(
        const LSPAny &any
    ) const -> CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("valueSet");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<CodeActionKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToCodeActionKind(*elem_0));
            }
            value_0.valueSet = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind attribute: valueSet"
            );
        }

        return value_0;
    }

    auto LspTransformer::codeActionClientCapabilities_codeActionLiteralSupport_codeActionKindToAny(
        const CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.valueSet.size());
        for (const auto &elem_0 : param.valueSet) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = codeActionKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("valueSet", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToCodeActionClientCapabilities_codeActionLiteralSupport(
        const LSPAny &any
    ) const -> CodeActionClientCapabilities_codeActionLiteralSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeActionClientCapabilities_codeActionLiteralSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeActionClientCapabilities_codeActionLiteralSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeActionClientCapabilities_codeActionLiteralSupport"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("codeActionKind");
        if (iter_0 != object_0.end()) {
            value_0.codeActionKind =
                anyToCodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CodeActionClientCapabilities_codeActionLiteralSupport attribute: codeActionKind"
            );
        }

        return value_0;
    }

    auto LspTransformer::codeActionClientCapabilities_codeActionLiteralSupportToAny(
        const CodeActionClientCapabilities_codeActionLiteralSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "codeActionKind",
            std::make_unique<LSPAny>(codeActionClientCapabilities_codeActionLiteralSupport_codeActionKindToAny(param.codeActionKind))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::codeActionClientCapabilities_codeActionLiteralSupport_codeActionKind_valueSetToAny(
        const CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind_valueSet &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = codeActionKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind_valueSet(
        const LSPAny &any
    ) const -> CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind_valueSet
    {
        const auto &array_0 = any.array();
        std::vector<CodeActionKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToCodeActionKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToTraceValues(
        const LSPAny &any
    ) const -> TraceValues
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return traceValuesByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "TraceValues"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::traceValuesToAny(
        TraceValues enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = TraceValuesValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToSetTraceParams(
        const LSPAny &any
    ) const -> SetTraceParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SetTraceParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SetTraceParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SetTraceParams"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("value");
        if (iter_0 != object_0.end()) {
            value_0.value = anyToTraceValues(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SetTraceParams attribute: value"
            );
        }

        return value_0;
    }

    auto LspTransformer::setTraceParamsToAny(
        const SetTraceParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "value",
            std::make_unique<LSPAny>(traceValuesToAny(param.value))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::asSetTraceParams(
        const MessageParams &notificationParams
    ) const -> SetTraceParams
    {
        if (notificationParams.type() != MessageParamsType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Message parameter type must be MessageParamsType::Object "
                 "for method=\"$/setTrace\" but received "
                 "MessageParamsType::" + MessageParamsTypeNames.at(notificationParams.type()))
            );
        }

        SetTraceParams params_0;
        const auto &object_0 = notificationParams.object();
        LSPObject::const_iterator iter_0;

        iter_0 = object_0.find("value");
        if (iter_0 != object_0.end()) {
            params_0.value = anyToTraceValues(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SetTraceParams attribute: value"
            );
        }

        return params_0;
    }

    auto LspTransformer::anyToMarkupKind(const LSPAny &any) const -> MarkupKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return markupKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "MarkupKind"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::markupKindToAny(MarkupKind enumerator) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = MarkupKindValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::completionClientCapabilities_completionItem_documentationFormatToAny(
        const CompletionClientCapabilities_completionItem_documentationFormat &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = markupKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionItem_documentationFormat(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionItem_documentationFormat
    {
        const auto &array_0 = any.array();
        std::vector<MarkupKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToMarkupKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::hoverClientCapabilities_contentFormatToAny(
        const HoverClientCapabilities_contentFormat &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = markupKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToHoverClientCapabilities_contentFormat(
        const LSPAny &any
    ) const -> HoverClientCapabilities_contentFormat
    {
        const auto &array_0 = any.array();
        std::vector<MarkupKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToMarkupKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::signatureHelpClientCapabilities_signatureInformation_documentationFormatToAny(
        const SignatureHelpClientCapabilities_signatureInformation_documentationFormat &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = markupKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSignatureHelpClientCapabilities_signatureInformation_documentationFormat(
        const LSPAny &any
    ) const -> SignatureHelpClientCapabilities_signatureInformation_documentationFormat
    {
        const auto &array_0 = any.array();
        std::vector<MarkupKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToMarkupKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToInlineCompletionTriggerKind(
        const LSPAny &any
    ) const -> InlineCompletionTriggerKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return inlineCompletionTriggerKindByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return inlineCompletionTriggerKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for an "
                     "InlineCompletionTriggerKind"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::inlineCompletionTriggerKindToAny(
        InlineCompletionTriggerKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToPositionEncodingKind(
        const LSPAny &any
    ) const -> PositionEncodingKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return positionEncodingKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "PositionEncodingKind"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::positionEncodingKindToAny(
        PositionEncodingKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = PositionEncodingKindValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::generalClientCapabilities_positionEncodingsToAny(
        const GeneralClientCapabilities_positionEncodings &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = positionEncodingKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToGeneralClientCapabilities_positionEncodings(
        const LSPAny &any
    ) const -> GeneralClientCapabilities_positionEncodings
    {
        const auto &array_0 = any.array();
        std::vector<PositionEncodingKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToPositionEncodingKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToFileChangeType(
        const LSPAny &any
    ) const -> FileChangeType
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return fileChangeTypeByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return fileChangeTypeByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "FileChangeType"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::fileChangeTypeToAny(
        FileChangeType enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToWatchKind(const LSPAny &any) const -> WatchKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return watchKindByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return watchKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "WatchKind"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::watchKindToAny(WatchKind enumerator) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToDiagnosticSeverity(
        const LSPAny &any
    ) const -> DiagnosticSeverity
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return diagnosticSeverityByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return diagnosticSeverityByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "DiagnosticSeverity"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::diagnosticSeverityToAny(
        DiagnosticSeverity enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToDiagnosticTag(
        const LSPAny &any
    ) const -> DiagnosticTag
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return diagnosticTagByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return diagnosticTagByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "DiagnosticTag"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::diagnosticTagToAny(
        DiagnosticTag enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::diagnostic_tagsToAny(
        const Diagnostic_tags &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = diagnosticTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDiagnostic_tags(
        const LSPAny &any
    ) const -> Diagnostic_tags
    {
        const auto &array_0 = any.array();
        std::vector<DiagnosticTag> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToDiagnosticTag(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToPublishDiagnosticsClientCapabilities_tagSupport(
        const LSPAny &any
    ) const -> PublishDiagnosticsClientCapabilities_tagSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "PublishDiagnosticsClientCapabilities_tagSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        PublishDiagnosticsClientCapabilities_tagSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "PublishDiagnosticsClientCapabilities_tagSupport"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("valueSet");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<DiagnosticTag> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToDiagnosticTag(*elem_0));
            }
            value_0.valueSet = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required PublishDiagnosticsClientCapabilities_tagSupport attribute: valueSet"
            );
        }

        return value_0;
    }

    auto LspTransformer::publishDiagnosticsClientCapabilities_tagSupportToAny(
        const PublishDiagnosticsClientCapabilities_tagSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.valueSet.size());
        for (const auto &elem_0 : param.valueSet) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = diagnosticTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("valueSet", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::publishDiagnosticsClientCapabilities_tagSupport_valueSetToAny(
        const PublishDiagnosticsClientCapabilities_tagSupport_valueSet &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = diagnosticTagToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToPublishDiagnosticsClientCapabilities_tagSupport_valueSet(
        const LSPAny &any
    ) const -> PublishDiagnosticsClientCapabilities_tagSupport_valueSet
    {
        const auto &array_0 = any.array();
        std::vector<DiagnosticTag> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToDiagnosticTag(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToCompletionTriggerKind(
        const LSPAny &any
    ) const -> CompletionTriggerKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return completionTriggerKindByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return completionTriggerKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "CompletionTriggerKind"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::completionTriggerKindToAny(
        CompletionTriggerKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToSignatureHelpTriggerKind(
        const LSPAny &any
    ) const -> SignatureHelpTriggerKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return signatureHelpTriggerKindByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return signatureHelpTriggerKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "SignatureHelpTriggerKind"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::signatureHelpTriggerKindToAny(
        SignatureHelpTriggerKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToCodeActionTriggerKind(
        const LSPAny &any
    ) const -> CodeActionTriggerKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return codeActionTriggerKindByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return codeActionTriggerKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "CodeActionTriggerKind"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::codeActionTriggerKindToAny(
        CodeActionTriggerKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToFileOperationPatternKind(
        const LSPAny &any
    ) const -> FileOperationPatternKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return fileOperationPatternKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "FileOperationPatternKind"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::fileOperationPatternKindToAny(
        FileOperationPatternKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = FileOperationPatternKindValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToNotebookCellKind(
        const LSPAny &any
    ) const -> NotebookCellKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return notebookCellKindByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return notebookCellKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "NotebookCellKind"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::notebookCellKindToAny(
        NotebookCellKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToResourceOperationKind(
        const LSPAny &any
    ) const -> ResourceOperationKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return resourceOperationKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "ResourceOperationKind"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::resourceOperationKindToAny(
        ResourceOperationKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = ResourceOperationKindValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::workspaceEditClientCapabilities_resourceOperationsToAny(
        const WorkspaceEditClientCapabilities_resourceOperations &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = resourceOperationKindToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToWorkspaceEditClientCapabilities_resourceOperations(
        const LSPAny &any
    ) const -> WorkspaceEditClientCapabilities_resourceOperations
    {
        const auto &array_0 = any.array();
        std::vector<ResourceOperationKind> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToResourceOperationKind(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToFailureHandlingKind(
        const LSPAny &any
    ) const -> FailureHandlingKind
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return failureHandlingKindByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "FailureHandlingKind"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::failureHandlingKindToAny(
        FailureHandlingKind enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = FailureHandlingKindValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToPrepareSupportDefaultBehavior(
        const LSPAny &any
    ) const -> PrepareSupportDefaultBehavior
    {
        try {
            switch (any.type()) {
            case LSPAnyType::UInteger: {
                uinteger_t value = any.uinteger();
                return prepareSupportDefaultBehaviorByValue(value);
            }
            case LSPAnyType::Integer: {
                uinteger_t value = static_cast<uinteger_t>(any.uinteger());
                return prepareSupportDefaultBehaviorByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "PrepareSupportDefaultBehavior"
                     " must be of type LSPAnyType::UInteger"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::prepareSupportDefaultBehaviorToAny(
        PrepareSupportDefaultBehavior enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = static_cast<uinteger_t>(enumerator);
        return any_0;
    }

    auto LspTransformer::anyToTokenFormat(
        const LSPAny &any
    ) const -> TokenFormat
    {
        try {
            switch (any.type()) {
            case LSPAnyType::String: {
                const string_t &value = any.string();
                return tokenFormatByValue(value);
            }
            default: {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("LSPAnyType for a "
                     "TokenFormat"
                     " must be of type LSPAnyType::String"
                     " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
                );
            }
            }
        } catch (std::invalid_argument &e) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                e.what()
            );
        }
    }

    auto LspTransformer::tokenFormatToAny(
        TokenFormat enumerator
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = TokenFormatValues.at(enumerator);
        return any_0;
    }

    auto LspTransformer::semanticTokensClientCapabilities_formatsToAny(
        const SemanticTokensClientCapabilities_formats &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = tokenFormatToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSemanticTokensClientCapabilities_formats(
        const LSPAny &any
    ) const -> SemanticTokensClientCapabilities_formats
    {
        const auto &array_0 = any.array();
        std::vector<TokenFormat> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToTokenFormat(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::documentUriToAny(
        const DocumentUri &param
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = param;
        return any_0;
    }

    auto LspTransformer::anyToDocumentUri(
        const LSPAny &any
    ) const -> DocumentUri
    {
        switch (any.type()) {
        case LSPAnyType::String: {
            return any.string();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type DocumentUri")
            );
        }
        }
    }

    auto LspTransformer::anyToWorkspaceSymbol_location_1(
        const LSPAny &any
    ) const -> WorkspaceSymbol_location_1
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceSymbol_location_1"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceSymbol_location_1 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceSymbol_location_1"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToDocumentUri(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WorkspaceSymbol_location_1 attribute: uri"
            );
        }

        return value_0;
    }

    auto LspTransformer::workspaceSymbol_location_1ToAny(
        const WorkspaceSymbol_location_1 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "uri",
            std::make_unique<LSPAny>(documentUriToAny(param.uri))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentIdentifier(
        const LSPAny &any
    ) const -> TextDocumentIdentifier
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentIdentifier"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentIdentifier value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentIdentifier"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToDocumentUri(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentIdentifier attribute: uri"
            );
        }

        return value_0;
    }

    auto LspTransformer::textDocumentIdentifierToAny(
        const TextDocumentIdentifier &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "uri",
            std::make_unique<LSPAny>(documentUriToAny(param.uri))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::didCloseNotebookDocumentParams_cellTextDocumentsToAny(
        const DidCloseNotebookDocumentParams_cellTextDocuments &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = textDocumentIdentifierToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDidCloseNotebookDocumentParams_cellTextDocuments(
        const LSPAny &any
    ) const -> DidCloseNotebookDocumentParams_cellTextDocuments
    {
        const auto &array_0 = any.array();
        std::vector<TextDocumentIdentifier> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToTextDocumentIdentifier(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToDidCloseTextDocumentParams(
        const LSPAny &any
    ) const -> DidCloseTextDocumentParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DidCloseTextDocumentParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DidCloseTextDocumentParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DidCloseTextDocumentParams"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("textDocument");
        if (iter_0 != object_0.end()) {
            value_0.textDocument =
                anyToTextDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidCloseTextDocumentParams attribute: textDocument"
            );
        }

        return value_0;
    }

    auto LspTransformer::didCloseTextDocumentParamsToAny(
        const DidCloseTextDocumentParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "textDocument",
            std::make_unique<LSPAny>(textDocumentIdentifierToAny(param.textDocument))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWillSaveTextDocumentParams(
        const LSPAny &any
    ) const -> WillSaveTextDocumentParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WillSaveTextDocumentParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WillSaveTextDocumentParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WillSaveTextDocumentParams"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("textDocument");
        if (iter_0 != object_0.end()) {
            value_0.textDocument =
                anyToTextDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WillSaveTextDocumentParams attribute: textDocument"
            );
        }

        iter_0 = object_0.find("reason");
        if (iter_0 != object_0.end()) {
            value_0.reason = anyToTextDocumentSaveReason(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WillSaveTextDocumentParams attribute: reason"
            );
        }

        return value_0;
    }

    auto LspTransformer::willSaveTextDocumentParamsToAny(
        const WillSaveTextDocumentParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "textDocument",
            std::make_unique<LSPAny>(textDocumentIdentifierToAny(param.textDocument))
        );

        object_0.emplace(
            "reason",
            std::make_unique<LSPAny>(textDocumentSaveReasonToAny(param.reason))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::notebookDocumentChangeEvent_cells_structure_didCloseToAny(
        const NotebookDocumentChangeEvent_cells_structure_didClose &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = textDocumentIdentifierToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToNotebookDocumentChangeEvent_cells_structure_didClose(
        const LSPAny &any
    ) const -> NotebookDocumentChangeEvent_cells_structure_didClose
    {
        const auto &array_0 = any.array();
        std::vector<TextDocumentIdentifier> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToTextDocumentIdentifier(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToFileEvent(const LSPAny &any) const -> FileEvent
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FileEvent"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FileEvent value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FileEvent"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToDocumentUri(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FileEvent attribute: uri"
            );
        }

        iter_0 = object_0.find("type");
        if (iter_0 != object_0.end()) {
            value_0.type = anyToFileChangeType(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FileEvent attribute: type"
            );
        }

        return value_0;
    }

    auto LspTransformer::fileEventToAny(const FileEvent &param) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "uri",
            std::make_unique<LSPAny>(documentUriToAny(param.uri))
        );

        object_0.emplace(
            "type",
            std::make_unique<LSPAny>(fileChangeTypeToAny(param.type))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDidChangeWatchedFilesParams(
        const LSPAny &any
    ) const -> DidChangeWatchedFilesParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DidChangeWatchedFilesParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DidChangeWatchedFilesParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DidChangeWatchedFilesParams"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("changes");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<FileEvent> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToFileEvent(*elem_0));
            }
            value_0.changes = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidChangeWatchedFilesParams attribute: changes"
            );
        }

        return value_0;
    }

    auto LspTransformer::didChangeWatchedFilesParamsToAny(
        const DidChangeWatchedFilesParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.changes.size());
        for (const auto &elem_0 : param.changes) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileEventToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("changes", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::didChangeWatchedFilesParams_changesToAny(
        const DidChangeWatchedFilesParams_changes &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileEventToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDidChangeWatchedFilesParams_changes(
        const LSPAny &any
    ) const -> DidChangeWatchedFilesParams_changes
    {
        const auto &array_0 = any.array();
        std::vector<FileEvent> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToFileEvent(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::asTextDocument_DidCloseParams(
        const MessageParams &notificationParams
    ) const -> DidCloseTextDocumentParams
    {
        if (notificationParams.type() != MessageParamsType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Message parameter type must be MessageParamsType::Object "
                 "for method=\"textDocument/didClose\" but received "
                 "MessageParamsType::" + MessageParamsTypeNames.at(notificationParams.type()))
            );
        }

        DidCloseTextDocumentParams params_0;
        const auto &object_0 = notificationParams.object();
        LSPObject::const_iterator iter_0;

        iter_0 = object_0.find("textDocument");
        if (iter_0 != object_0.end()) {
            params_0.textDocument =
                anyToTextDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidCloseTextDocumentParams attribute: textDocument"
            );
        }

        return params_0;
    }

    auto LspTransformer::asTextDocument_WillSaveParams(
        const MessageParams &notificationParams
    ) const -> WillSaveTextDocumentParams
    {
        if (notificationParams.type() != MessageParamsType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Message parameter type must be MessageParamsType::Object "
                 "for method=\"textDocument/willSave\" but received "
                 "MessageParamsType::" + MessageParamsTypeNames.at(notificationParams.type()))
            );
        }

        WillSaveTextDocumentParams params_0;
        const auto &object_0 = notificationParams.object();
        LSPObject::const_iterator iter_0;

        iter_0 = object_0.find("textDocument");
        if (iter_0 != object_0.end()) {
            params_0.textDocument =
                anyToTextDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WillSaveTextDocumentParams attribute: textDocument"
            );
        }

        iter_0 = object_0.find("reason");
        if (iter_0 != object_0.end()) {
            params_0.reason = anyToTextDocumentSaveReason(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WillSaveTextDocumentParams attribute: reason"
            );
        }

        return params_0;
    }

    auto LspTransformer::asWorkspace_DidChangeWatchedFilesParams(
        const MessageParams &notificationParams
    ) const -> DidChangeWatchedFilesParams
    {
        if (notificationParams.type() != MessageParamsType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Message parameter type must be MessageParamsType::Object "
                 "for method=\"workspace/didChangeWatchedFiles\" but received "
                 "MessageParamsType::" + MessageParamsTypeNames.at(notificationParams.type()))
            );
        }

        DidChangeWatchedFilesParams params_0;
        const auto &object_0 = notificationParams.object();
        LSPObject::const_iterator iter_0;

        iter_0 = object_0.find("changes");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<FileEvent> values_0;
            values_0.reserve(array_0.size());
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToFileEvent(*elem_0));
            }
            params_0.changes = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidChangeWatchedFilesParams attribute: changes"
            );
        }

        return params_0;
    }

    auto LspTransformer::uriToAny(const URI &param) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = param;
        return any_0;
    }

    auto LspTransformer::anyToURI(const LSPAny &any) const -> URI
    {
        switch (any.type()) {
        case LSPAnyType::String: {
            return any.string();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type URI")
            );
        }
        }
    }

    auto LspTransformer::anyToNotebookDocumentIdentifier(
        const LSPAny &any
    ) const -> NotebookDocumentIdentifier
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentIdentifier"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentIdentifier value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentIdentifier"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToURI(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookDocumentIdentifier attribute: uri"
            );
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentIdentifierToAny(
        const NotebookDocumentIdentifier &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace("uri", std::make_unique<LSPAny>(uriToAny(param.uri)));

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDidSaveNotebookDocumentParams(
        const LSPAny &any
    ) const -> DidSaveNotebookDocumentParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DidSaveNotebookDocumentParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DidSaveNotebookDocumentParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DidSaveNotebookDocumentParams"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("notebookDocument");
        if (iter_0 != object_0.end()) {
            value_0.notebookDocument =
                anyToNotebookDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidSaveNotebookDocumentParams attribute: notebookDocument"
            );
        }

        return value_0;
    }

    auto LspTransformer::didSaveNotebookDocumentParamsToAny(
        const DidSaveNotebookDocumentParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "notebookDocument",
            std::make_unique<LSPAny>(notebookDocumentIdentifierToAny(param.notebookDocument))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDidCloseNotebookDocumentParams(
        const LSPAny &any
    ) const -> DidCloseNotebookDocumentParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DidCloseNotebookDocumentParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DidCloseNotebookDocumentParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DidCloseNotebookDocumentParams"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("notebookDocument");
        if (iter_0 != object_0.end()) {
            value_0.notebookDocument =
                anyToNotebookDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidCloseNotebookDocumentParams attribute: notebookDocument"
            );
        }

        iter_0 = object_0.find("cellTextDocuments");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<TextDocumentIdentifier> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToTextDocumentIdentifier(*elem_0));
            }
            value_0.cellTextDocuments = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidCloseNotebookDocumentParams attribute: cellTextDocuments"
            );
        }

        return value_0;
    }

    auto LspTransformer::didCloseNotebookDocumentParamsToAny(
        const DidCloseNotebookDocumentParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "notebookDocument",
            std::make_unique<LSPAny>(notebookDocumentIdentifierToAny(param.notebookDocument))
        );

        LSPArray array_0;
        array_0.reserve(param.cellTextDocuments.size());
        for (const auto &elem_0 : param.cellTextDocuments) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = textDocumentIdentifierToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("cellTextDocuments", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToCodeDescription(
        const LSPAny &any
    ) const -> CodeDescription
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeDescription"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeDescription value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeDescription"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("href");
        if (iter_0 != object_0.end()) {
            value_0.href = anyToURI(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CodeDescription attribute: href"
            );
        }

        return value_0;
    }

    auto LspTransformer::codeDescriptionToAny(
        const CodeDescription &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "href",
            std::make_unique<LSPAny>(uriToAny(param.href))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::asNotebookDocument_DidSaveParams(
        const MessageParams &notificationParams
    ) const -> DidSaveNotebookDocumentParams
    {
        if (notificationParams.type() != MessageParamsType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Message parameter type must be MessageParamsType::Object "
                 "for method=\"notebookDocument/didSave\" but received "
                 "MessageParamsType::" + MessageParamsTypeNames.at(notificationParams.type()))
            );
        }

        DidSaveNotebookDocumentParams params_0;
        const auto &object_0 = notificationParams.object();
        LSPObject::const_iterator iter_0;

        iter_0 = object_0.find("notebookDocument");
        if (iter_0 != object_0.end()) {
            params_0.notebookDocument =
                anyToNotebookDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidSaveNotebookDocumentParams attribute: notebookDocument"
            );
        }

        return params_0;
    }

    auto LspTransformer::asNotebookDocument_DidCloseParams(
        const MessageParams &notificationParams
    ) const -> DidCloseNotebookDocumentParams
    {
        if (notificationParams.type() != MessageParamsType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Message parameter type must be MessageParamsType::Object "
                 "for method=\"notebookDocument/didClose\" but received "
                 "MessageParamsType::" + MessageParamsTypeNames.at(notificationParams.type()))
            );
        }

        DidCloseNotebookDocumentParams params_0;
        const auto &object_0 = notificationParams.object();
        LSPObject::const_iterator iter_0;

        iter_0 = object_0.find("notebookDocument");
        if (iter_0 != object_0.end()) {
            params_0.notebookDocument =
                anyToNotebookDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidCloseNotebookDocumentParams attribute: notebookDocument"
            );
        }

        iter_0 = object_0.find("cellTextDocuments");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<TextDocumentIdentifier> values_0;
            values_0.reserve(array_0.size());
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToTextDocumentIdentifier(*elem_0));
            }
            params_0.cellTextDocuments = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidCloseNotebookDocumentParams attribute: cellTextDocuments"
            );
        }

        return params_0;
    }

    auto LspTransformer::stringToAny(const string_t &param) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = param;
        return any_0;
    }

    auto LspTransformer::anyToString(const LSPAny &any) const -> string_t
    {
        switch (any.type()) {
        case LSPAnyType::String: {
            return any.string();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type string_t")
            );
        }
        }
    }

    auto LspTransformer::anyToWorkspaceFolder(
        const LSPAny &any
    ) const -> WorkspaceFolder
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceFolder"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceFolder value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceFolder"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToURI(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WorkspaceFolder attribute: uri"
            );
        }

        iter_0 = object_0.find("name");
        if (iter_0 != object_0.end()) {
            value_0.name = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WorkspaceFolder attribute: name"
            );
        }

        return value_0;
    }

    auto LspTransformer::workspaceFolderToAny(
        const WorkspaceFolder &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace("uri", std::make_unique<LSPAny>(uriToAny(param.uri)));

        object_0.emplace(
            "name",
            std::make_unique<LSPAny>(stringToAny(param.name))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToMoniker(const LSPAny &any) const -> Moniker
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "Moniker"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        Moniker value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "Moniker"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("scheme");
        if (iter_0 != object_0.end()) {
            value_0.scheme = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Moniker attribute: scheme"
            );
        }

        iter_0 = object_0.find("identifier");
        if (iter_0 != object_0.end()) {
            value_0.identifier = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Moniker attribute: identifier"
            );
        }

        iter_0 = object_0.find("unique");
        if (iter_0 != object_0.end()) {
            value_0.unique = anyToUniquenessLevel(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Moniker attribute: unique"
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToMonikerKind(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::monikerToAny(const Moniker &param) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "scheme",
            std::make_unique<LSPAny>(stringToAny(param.scheme))
        );

        object_0.emplace(
            "identifier",
            std::make_unique<LSPAny>(stringToAny(param.identifier))
        );

        object_0.emplace(
            "unique",
            std::make_unique<LSPAny>(uniquenessLevelToAny(param.unique))
        );

        if (param.kind.has_value()) {
            const auto &kind_0 = param.kind.value();
            object_0.emplace(
                "kind",
                std::make_unique<LSPAny>(monikerKindToAny(kind_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInitializeResult_serverInfo(
        const LSPAny &any
    ) const -> InitializeResult_serverInfo
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InitializeResult_serverInfo"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InitializeResult_serverInfo value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InitializeResult_serverInfo"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("name");
        if (iter_0 != object_0.end()) {
            value_0.name = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InitializeResult_serverInfo attribute: name"
            );
        }

        iter_0 = object_0.find("version");
        if (iter_0 != object_0.end()) {
            value_0.version = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::initializeResult_serverInfoToAny(
        const InitializeResult_serverInfo &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "name",
            std::make_unique<LSPAny>(stringToAny(param.name))
        );

        if (param.version.has_value()) {
            const auto &version_0 = param.version.value();
            object_0.emplace(
                "version",
                std::make_unique<LSPAny>(stringToAny(version_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDidChangeConfigurationRegistrationOptions_section(
        const LSPAny &any
    ) const -> DidChangeConfigurationRegistrationOptions_section
    {
        DidChangeConfigurationRegistrationOptions_section value_0;

        switch (any.type()) {
        case LSPAnyType::Array: {
            try {
                value_0 =
                    anyToDidChangeConfigurationRegistrationOptions_section_1(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to DidChangeConfigurationRegistrationOptions_section"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "DidChangeConfigurationRegistrationOptions_section"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::didChangeConfigurationRegistrationOptions_sectionToAny(
        const DidChangeConfigurationRegistrationOptions_section &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case DidChangeConfigurationRegistrationOptions_sectionType::String: {
            return stringToAny(value.string());
        }
        case DidChangeConfigurationRegistrationOptions_sectionType::StringArray: {
            LSPArray array_0;
            array_0.reserve(value.stringArray().size());
            for (const auto &elem_0 : value.stringArray()) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = stringToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            LSPAny any_1;
            any_1 = std::move(array_0);
            return any_1;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported DidChangeConfigurationRegistrationOptions_sectionType: " +
                 DidChangeConfigurationRegistrationOptions_sectionTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToDidChangeConfigurationRegistrationOptions(
        const LSPAny &any
    ) const -> DidChangeConfigurationRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DidChangeConfigurationRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DidChangeConfigurationRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DidChangeConfigurationRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("section");
        if (iter_0 != object_0.end()) {
            value_0.section =
                anyToDidChangeConfigurationRegistrationOptions_section(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::didChangeConfigurationRegistrationOptionsToAny(
        const DidChangeConfigurationRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.section.has_value()) {
            const auto &section_0 = param.section.value();
            object_0.emplace(
                "section",
                std::make_unique<LSPAny>(didChangeConfigurationRegistrationOptions_sectionToAny(section_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::didChangeConfigurationRegistrationOptions_section_1ToAny(
        const DidChangeConfigurationRegistrationOptions_section_1 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDidChangeConfigurationRegistrationOptions_section_1(
        const LSPAny &any
    ) const -> DidChangeConfigurationRegistrationOptions_section_1
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToShowMessageParams(
        const LSPAny &any
    ) const -> ShowMessageParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ShowMessageParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ShowMessageParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ShowMessageParams"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("type");
        if (iter_0 != object_0.end()) {
            value_0.type = anyToMessageType(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ShowMessageParams attribute: type"
            );
        }

        iter_0 = object_0.find("message");
        if (iter_0 != object_0.end()) {
            value_0.message = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ShowMessageParams attribute: message"
            );
        }

        return value_0;
    }

    auto LspTransformer::showMessageParamsToAny(
        const ShowMessageParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "type",
            std::make_unique<LSPAny>(messageTypeToAny(param.type))
        );

        object_0.emplace(
            "message",
            std::make_unique<LSPAny>(stringToAny(param.message))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToMessageActionItem(
        const LSPAny &any
    ) const -> MessageActionItem
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "MessageActionItem"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        MessageActionItem value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "MessageActionItem"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("title");
        if (iter_0 != object_0.end()) {
            value_0.title = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required MessageActionItem attribute: title"
            );
        }

        return value_0;
    }

    auto LspTransformer::messageActionItemToAny(
        const MessageActionItem &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "title",
            std::make_unique<LSPAny>(stringToAny(param.title))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToShowMessageRequestParams(
        const LSPAny &any
    ) const -> ShowMessageRequestParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ShowMessageRequestParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ShowMessageRequestParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ShowMessageRequestParams"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("type");
        if (iter_0 != object_0.end()) {
            value_0.type = anyToMessageType(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ShowMessageRequestParams attribute: type"
            );
        }

        iter_0 = object_0.find("message");
        if (iter_0 != object_0.end()) {
            value_0.message = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ShowMessageRequestParams attribute: message"
            );
        }

        iter_0 = object_0.find("actions");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<MessageActionItem> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToMessageActionItem(*elem_0));
            }
            value_0.actions = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::showMessageRequestParamsToAny(
        const ShowMessageRequestParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "type",
            std::make_unique<LSPAny>(messageTypeToAny(param.type))
        );

        object_0.emplace(
            "message",
            std::make_unique<LSPAny>(stringToAny(param.message))
        );

        if (param.actions.has_value()) {
            const auto &actions_0 = param.actions.value();
            LSPArray array_0;
            array_0.reserve(actions_0.size());
            for (const auto &elem_0 : actions_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = messageActionItemToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("actions", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::showMessageRequestParams_actionsToAny(
        const ShowMessageRequestParams_actions &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = messageActionItemToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToShowMessageRequestParams_actions(
        const LSPAny &any
    ) const -> ShowMessageRequestParams_actions
    {
        const auto &array_0 = any.array();
        std::vector<MessageActionItem> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToMessageActionItem(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToLogMessageParams(
        const LSPAny &any
    ) const -> LogMessageParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "LogMessageParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        LogMessageParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "LogMessageParams"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("type");
        if (iter_0 != object_0.end()) {
            value_0.type = anyToMessageType(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required LogMessageParams attribute: type"
            );
        }

        iter_0 = object_0.find("message");
        if (iter_0 != object_0.end()) {
            value_0.message = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required LogMessageParams attribute: message"
            );
        }

        return value_0;
    }

    auto LspTransformer::logMessageParamsToAny(
        const LogMessageParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "type",
            std::make_unique<LSPAny>(messageTypeToAny(param.type))
        );

        object_0.emplace(
            "message",
            std::make_unique<LSPAny>(stringToAny(param.message))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDidSaveTextDocumentParams(
        const LSPAny &any
    ) const -> DidSaveTextDocumentParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DidSaveTextDocumentParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DidSaveTextDocumentParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DidSaveTextDocumentParams"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("textDocument");
        if (iter_0 != object_0.end()) {
            value_0.textDocument =
                anyToTextDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidSaveTextDocumentParams attribute: textDocument"
            );
        }

        iter_0 = object_0.find("text");
        if (iter_0 != object_0.end()) {
            value_0.text = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::didSaveTextDocumentParamsToAny(
        const DidSaveTextDocumentParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "textDocument",
            std::make_unique<LSPAny>(textDocumentIdentifierToAny(param.textDocument))
        );

        if (param.text.has_value()) {
            const auto &text_0 = param.text.value();
            object_0.emplace(
                "text",
                std::make_unique<LSPAny>(stringToAny(text_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::completionItem_commitCharactersToAny(
        const CompletionItem_commitCharacters &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionItem_commitCharacters(
        const LSPAny &any
    ) const -> CompletionItem_commitCharacters
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::completionList_itemDefaults_commitCharactersToAny(
        const CompletionList_itemDefaults_commitCharacters &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionList_itemDefaults_commitCharacters(
        const LSPAny &any
    ) const -> CompletionList_itemDefaults_commitCharacters
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToCodeAction_disabled(
        const LSPAny &any
    ) const -> CodeAction_disabled
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeAction_disabled"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeAction_disabled value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeAction_disabled"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("reason");
        if (iter_0 != object_0.end()) {
            value_0.reason = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CodeAction_disabled attribute: reason"
            );
        }

        return value_0;
    }

    auto LspTransformer::codeAction_disabledToAny(
        const CodeAction_disabled &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "reason",
            std::make_unique<LSPAny>(stringToAny(param.reason))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWorkDoneProgressEnd(
        const LSPAny &any
    ) const -> WorkDoneProgressEnd
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkDoneProgressEnd"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkDoneProgressEnd value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkDoneProgressEnd"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            const auto &value_1 = anyToString(*iter_0->second);
            if (value_1 != "end") {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("String value for "
                     "WorkDoneProgressEnd.kind"
                     " must be \"end\""
                     " but was: \"value_1\"")
                );
            }
            value_0.kind = value_1;
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WorkDoneProgressEnd attribute: kind"
            );
        }

        iter_0 = object_0.find("message");
        if (iter_0 != object_0.end()) {
            value_0.message = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workDoneProgressEndToAny(
        const WorkDoneProgressEnd &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        if (param.message.has_value()) {
            const auto &message_0 = param.message.value();
            object_0.emplace(
                "message",
                std::make_unique<LSPAny>(stringToAny(message_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToLogTraceParams(
        const LSPAny &any
    ) const -> LogTraceParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "LogTraceParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        LogTraceParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "LogTraceParams"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("message");
        if (iter_0 != object_0.end()) {
            value_0.message = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required LogTraceParams attribute: message"
            );
        }

        iter_0 = object_0.find("verbose");
        if (iter_0 != object_0.end()) {
            value_0.verbose = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::logTraceParamsToAny(
        const LogTraceParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "message",
            std::make_unique<LSPAny>(stringToAny(param.message))
        );

        if (param.verbose.has_value()) {
            const auto &verbose_0 = param.verbose.value();
            object_0.emplace(
                "verbose",
                std::make_unique<LSPAny>(stringToAny(verbose_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToStaticRegistrationOptions(
        const LSPAny &any
    ) const -> StaticRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "StaticRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        StaticRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "StaticRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::staticRegistrationOptionsToAny(
        const StaticRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWorkspaceFoldersChangeEvent(
        const LSPAny &any
    ) const -> WorkspaceFoldersChangeEvent
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceFoldersChangeEvent"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceFoldersChangeEvent value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceFoldersChangeEvent"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("added");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<WorkspaceFolder> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToWorkspaceFolder(*elem_0));
            }
            value_0.added = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WorkspaceFoldersChangeEvent attribute: added"
            );
        }

        iter_0 = object_0.find("removed");
        if (iter_0 != object_0.end()) {
            const auto &array_1 = iter_0->second->array();
            std::vector<WorkspaceFolder> values_1;
            for (const auto &elem_1 : array_1) {
                values_1.push_back(anyToWorkspaceFolder(*elem_1));
            }
            value_0.removed = std::move(values_1);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WorkspaceFoldersChangeEvent attribute: removed"
            );
        }

        return value_0;
    }

    auto LspTransformer::workspaceFoldersChangeEventToAny(
        const WorkspaceFoldersChangeEvent &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.added.size());
        for (const auto &elem_0 : param.added) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = workspaceFolderToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("added", std::move(any_1));

        LSPArray array_1;
        array_1.reserve(param.removed.size());
        for (const auto &elem_1 : param.removed) {
            auto any_2 = std::make_unique<LSPAny>();
            (*any_2) = workspaceFolderToAny(elem_1);
            array_1.push_back(std::move(any_2));
        }
        auto any_3 = std::make_unique<LSPAny>();
        (*any_3) = std::move(array_1);
        object_0.emplace("removed", std::move(any_3));

        LSPAny any_4;
        any_4 = std::move(object_0);
        return any_4;
    }

    auto LspTransformer::anyToDidChangeWorkspaceFoldersParams(
        const LSPAny &any
    ) const -> DidChangeWorkspaceFoldersParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DidChangeWorkspaceFoldersParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DidChangeWorkspaceFoldersParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DidChangeWorkspaceFoldersParams"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("event");
        if (iter_0 != object_0.end()) {
            value_0.event = anyToWorkspaceFoldersChangeEvent(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidChangeWorkspaceFoldersParams attribute: event"
            );
        }

        return value_0;
    }

    auto LspTransformer::didChangeWorkspaceFoldersParamsToAny(
        const DidChangeWorkspaceFoldersParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "event",
            std::make_unique<LSPAny>(workspaceFoldersChangeEventToAny(param.event))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::workspaceFoldersChangeEvent_addedToAny(
        const WorkspaceFoldersChangeEvent_added &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = workspaceFolderToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToWorkspaceFoldersChangeEvent_added(
        const LSPAny &any
    ) const -> WorkspaceFoldersChangeEvent_added
    {
        const auto &array_0 = any.array();
        std::vector<WorkspaceFolder> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToWorkspaceFolder(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::workspaceFoldersChangeEvent_removedToAny(
        const WorkspaceFoldersChangeEvent_removed &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = workspaceFolderToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToWorkspaceFoldersChangeEvent_removed(
        const LSPAny &any
    ) const -> WorkspaceFoldersChangeEvent_removed
    {
        const auto &array_0 = any.array();
        std::vector<WorkspaceFolder> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToWorkspaceFolder(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToConfigurationItem(
        const LSPAny &any
    ) const -> ConfigurationItem
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ConfigurationItem"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ConfigurationItem value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ConfigurationItem"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("scopeUri");
        if (iter_0 != object_0.end()) {
            value_0.scopeUri = anyToURI(*iter_0->second);
        }

        iter_0 = object_0.find("section");
        if (iter_0 != object_0.end()) {
            value_0.section = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::configurationItemToAny(
        const ConfigurationItem &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.scopeUri.has_value()) {
            const auto &scopeUri_0 = param.scopeUri.value();
            object_0.emplace(
                "scopeUri",
                std::make_unique<LSPAny>(uriToAny(scopeUri_0))
            );
        }

        if (param.section.has_value()) {
            const auto &section_0 = param.section.value();
            object_0.emplace(
                "section",
                std::make_unique<LSPAny>(stringToAny(section_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToConfigurationParams(
        const LSPAny &any
    ) const -> ConfigurationParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ConfigurationParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ConfigurationParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ConfigurationParams"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("items");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<ConfigurationItem> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToConfigurationItem(*elem_0));
            }
            value_0.items = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ConfigurationParams attribute: items"
            );
        }

        return value_0;
    }

    auto LspTransformer::configurationParamsToAny(
        const ConfigurationParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.items.size());
        for (const auto &elem_0 : param.items) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = configurationItemToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("items", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::configurationParams_itemsToAny(
        const ConfigurationParams_items &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = configurationItemToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToConfigurationParams_items(
        const LSPAny &any
    ) const -> ConfigurationParams_items
    {
        const auto &array_0 = any.array();
        std::vector<ConfigurationItem> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToConfigurationItem(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToFileCreate(const LSPAny &any) const -> FileCreate
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FileCreate"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FileCreate value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FileCreate"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FileCreate attribute: uri"
            );
        }

        return value_0;
    }

    auto LspTransformer::fileCreateToAny(
        const FileCreate &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "uri",
            std::make_unique<LSPAny>(stringToAny(param.uri))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCreateFilesParams(
        const LSPAny &any
    ) const -> CreateFilesParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CreateFilesParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CreateFilesParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CreateFilesParams"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("files");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<FileCreate> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToFileCreate(*elem_0));
            }
            value_0.files = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CreateFilesParams attribute: files"
            );
        }

        return value_0;
    }

    auto LspTransformer::createFilesParamsToAny(
        const CreateFilesParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.files.size());
        for (const auto &elem_0 : param.files) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileCreateToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("files", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::createFilesParams_filesToAny(
        const CreateFilesParams_files &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileCreateToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCreateFilesParams_files(
        const LSPAny &any
    ) const -> CreateFilesParams_files
    {
        const auto &array_0 = any.array();
        std::vector<FileCreate> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToFileCreate(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToFileRename(const LSPAny &any) const -> FileRename
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FileRename"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FileRename value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FileRename"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("oldUri");
        if (iter_0 != object_0.end()) {
            value_0.oldUri = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FileRename attribute: oldUri"
            );
        }

        iter_0 = object_0.find("newUri");
        if (iter_0 != object_0.end()) {
            value_0.newUri = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FileRename attribute: newUri"
            );
        }

        return value_0;
    }

    auto LspTransformer::fileRenameToAny(
        const FileRename &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "oldUri",
            std::make_unique<LSPAny>(stringToAny(param.oldUri))
        );

        object_0.emplace(
            "newUri",
            std::make_unique<LSPAny>(stringToAny(param.newUri))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToRenameFilesParams(
        const LSPAny &any
    ) const -> RenameFilesParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "RenameFilesParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        RenameFilesParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "RenameFilesParams"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("files");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<FileRename> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToFileRename(*elem_0));
            }
            value_0.files = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required RenameFilesParams attribute: files"
            );
        }

        return value_0;
    }

    auto LspTransformer::renameFilesParamsToAny(
        const RenameFilesParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.files.size());
        for (const auto &elem_0 : param.files) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileRenameToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("files", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::renameFilesParams_filesToAny(
        const RenameFilesParams_files &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileRenameToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToRenameFilesParams_files(
        const LSPAny &any
    ) const -> RenameFilesParams_files
    {
        const auto &array_0 = any.array();
        std::vector<FileRename> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToFileRename(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToFileDelete(const LSPAny &any) const -> FileDelete
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FileDelete"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FileDelete value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FileDelete"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FileDelete attribute: uri"
            );
        }

        return value_0;
    }

    auto LspTransformer::fileDeleteToAny(
        const FileDelete &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "uri",
            std::make_unique<LSPAny>(stringToAny(param.uri))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDeleteFilesParams(
        const LSPAny &any
    ) const -> DeleteFilesParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DeleteFilesParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DeleteFilesParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DeleteFilesParams"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("files");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<FileDelete> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToFileDelete(*elem_0));
            }
            value_0.files = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DeleteFilesParams attribute: files"
            );
        }

        return value_0;
    }

    auto LspTransformer::deleteFilesParamsToAny(
        const DeleteFilesParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.files.size());
        for (const auto &elem_0 : param.files) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileDeleteToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("files", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::deleteFilesParams_filesToAny(
        const DeleteFilesParams_files &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileDeleteToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDeleteFilesParams_files(
        const LSPAny &any
    ) const -> DeleteFilesParams_files
    {
        const auto &array_0 = any.array();
        std::vector<FileDelete> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToFileDelete(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToMarkupContent(
        const LSPAny &any
    ) const -> MarkupContent
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "MarkupContent"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        MarkupContent value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "MarkupContent"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToMarkupKind(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required MarkupContent attribute: kind"
            );
        }

        iter_0 = object_0.find("value");
        if (iter_0 != object_0.end()) {
            value_0.value = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required MarkupContent attribute: value"
            );
        }

        return value_0;
    }

    auto LspTransformer::markupContentToAny(
        const MarkupContent &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(markupKindToAny(param.kind))
        );

        object_0.emplace(
            "value",
            std::make_unique<LSPAny>(stringToAny(param.value))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlayHint_tooltip(
        const LSPAny &any
    ) const -> InlayHint_tooltip
    {
        InlayHint_tooltip value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToMarkupContent(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to InlayHint_tooltip"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for an "
                 "InlayHint_tooltip"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::inlayHint_tooltipToAny(
        const InlayHint_tooltip &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case InlayHint_tooltipType::String: {
            return stringToAny(value.string());
        }
        case InlayHint_tooltipType::MarkupContent: {
            return markupContentToAny(value.markupContent());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported InlayHint_tooltipType: " +
                 InlayHint_tooltipTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToCompletionItem_documentation(
        const LSPAny &any
    ) const -> CompletionItem_documentation
    {
        CompletionItem_documentation value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToMarkupContent(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to CompletionItem_documentation"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "CompletionItem_documentation"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::completionItem_documentationToAny(
        const CompletionItem_documentation &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case CompletionItem_documentationType::String: {
            return stringToAny(value.string());
        }
        case CompletionItem_documentationType::MarkupContent: {
            return markupContentToAny(value.markupContent());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported CompletionItem_documentationType: " +
                 CompletionItem_documentationTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToInlayHintLabelPart_tooltip(
        const LSPAny &any
    ) const -> InlayHintLabelPart_tooltip
    {
        InlayHintLabelPart_tooltip value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToMarkupContent(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to InlayHintLabelPart_tooltip"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for an "
                 "InlayHintLabelPart_tooltip"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::inlayHintLabelPart_tooltipToAny(
        const InlayHintLabelPart_tooltip &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case InlayHintLabelPart_tooltipType::String: {
            return stringToAny(value.string());
        }
        case InlayHintLabelPart_tooltipType::MarkupContent: {
            return markupContentToAny(value.markupContent());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported InlayHintLabelPart_tooltipType: " +
                 InlayHintLabelPart_tooltipTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToUnchangedDocumentDiagnosticReport(
        const LSPAny &any
    ) const -> UnchangedDocumentDiagnosticReport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "UnchangedDocumentDiagnosticReport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        UnchangedDocumentDiagnosticReport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "UnchangedDocumentDiagnosticReport"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            const auto &value_1 = anyToString(*iter_0->second);
            if (value_1 != "unchanged") {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("String value for "
                     "UnchangedDocumentDiagnosticReport.kind"
                     " must be \"unchanged\""
                     " but was: \"value_1\"")
                );
            }
            value_0.kind = value_1;
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required UnchangedDocumentDiagnosticReport attribute: kind"
            );
        }

        iter_0 = object_0.find("resultId");
        if (iter_0 != object_0.end()) {
            value_0.resultId = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required UnchangedDocumentDiagnosticReport attribute: resultId"
            );
        }

        return value_0;
    }

    auto LspTransformer::unchangedDocumentDiagnosticReportToAny(
        const UnchangedDocumentDiagnosticReport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        object_0.emplace(
            "resultId",
            std::make_unique<LSPAny>(stringToAny(param.resultId))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToPreviousResultId(
        const LSPAny &any
    ) const -> PreviousResultId
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "PreviousResultId"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        PreviousResultId value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "PreviousResultId"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToDocumentUri(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required PreviousResultId attribute: uri"
            );
        }

        iter_0 = object_0.find("value");
        if (iter_0 != object_0.end()) {
            value_0.value = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required PreviousResultId attribute: value"
            );
        }

        return value_0;
    }

    auto LspTransformer::previousResultIdToAny(
        const PreviousResultId &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "uri",
            std::make_unique<LSPAny>(documentUriToAny(param.uri))
        );

        object_0.emplace(
            "value",
            std::make_unique<LSPAny>(stringToAny(param.value))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::workspaceDiagnosticParams_previousResultIdsToAny(
        const WorkspaceDiagnosticParams_previousResultIds &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = previousResultIdToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToWorkspaceDiagnosticParams_previousResultIds(
        const LSPAny &any
    ) const -> WorkspaceDiagnosticParams_previousResultIds
    {
        const auto &array_0 = any.array();
        std::vector<PreviousResultId> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToPreviousResultId(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToStringValue(
        const LSPAny &any
    ) const -> StringValue
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "StringValue"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        StringValue value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "StringValue"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            const auto &value_1 = anyToString(*iter_0->second);
            if (value_1 != "snippet") {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("String value for "
                     "StringValue.kind"
                     " must be \"snippet\""
                     " but was: \"value_1\"")
                );
            }
            value_0.kind = value_1;
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required StringValue attribute: kind"
            );
        }

        iter_0 = object_0.find("value");
        if (iter_0 != object_0.end()) {
            value_0.value = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required StringValue attribute: value"
            );
        }

        return value_0;
    }

    auto LspTransformer::stringValueToAny(
        const StringValue &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        object_0.emplace(
            "value",
            std::make_unique<LSPAny>(stringToAny(param.value))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlineCompletionItem_insertText(
        const LSPAny &any
    ) const -> InlineCompletionItem_insertText
    {
        InlineCompletionItem_insertText value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToStringValue(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to InlineCompletionItem_insertText"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for an "
                 "InlineCompletionItem_insertText"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::inlineCompletionItem_insertTextToAny(
        const InlineCompletionItem_insertText &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case InlineCompletionItem_insertTextType::String: {
            return stringToAny(value.string());
        }
        case InlineCompletionItem_insertTextType::StringValue: {
            return stringValueToAny(value.stringValue());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported InlineCompletionItem_insertTextType: " +
                 InlineCompletionItem_insertTextTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToUnregistration(
        const LSPAny &any
    ) const -> Unregistration
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "Unregistration"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        Unregistration value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "Unregistration"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Unregistration attribute: id"
            );
        }

        iter_0 = object_0.find("method");
        if (iter_0 != object_0.end()) {
            value_0.method = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Unregistration attribute: method"
            );
        }

        return value_0;
    }

    auto LspTransformer::unregistrationToAny(
        const Unregistration &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "id",
            std::make_unique<LSPAny>(stringToAny(param.id))
        );

        object_0.emplace(
            "method",
            std::make_unique<LSPAny>(stringToAny(param.method))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToUnregistrationParams(
        const LSPAny &any
    ) const -> UnregistrationParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "UnregistrationParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        UnregistrationParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "UnregistrationParams"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("unregisterations");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<Unregistration> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToUnregistration(*elem_0));
            }
            value_0.unregisterations = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required UnregistrationParams attribute: unregisterations"
            );
        }

        return value_0;
    }

    auto LspTransformer::unregistrationParamsToAny(
        const UnregistrationParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.unregisterations.size());
        for (const auto &elem_0 : param.unregisterations) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = unregistrationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("unregisterations", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::unregistrationParams_unregisterationsToAny(
        const UnregistrationParams_unregisterations &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = unregistrationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToUnregistrationParams_unregisterations(
        const LSPAny &any
    ) const -> UnregistrationParams_unregisterations
    {
        const auto &array_0 = any.array();
        std::vector<Unregistration> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToUnregistration(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyTo_InitializeParams_clientInfo(
        const LSPAny &any
    ) const -> _InitializeParams_clientInfo
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "_InitializeParams_clientInfo"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        _InitializeParams_clientInfo value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "_InitializeParams_clientInfo"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("name");
        if (iter_0 != object_0.end()) {
            value_0.name = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required _InitializeParams_clientInfo attribute: name"
            );
        }

        iter_0 = object_0.find("version");
        if (iter_0 != object_0.end()) {
            value_0.version = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::_InitializeParams_clientInfoToAny(
        const _InitializeParams_clientInfo &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "name",
            std::make_unique<LSPAny>(stringToAny(param.name))
        );

        if (param.version.has_value()) {
            const auto &version_0 = param.version.value();
            object_0.emplace(
                "version",
                std::make_unique<LSPAny>(stringToAny(version_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::workspaceFoldersInitializeParams_workspaceFolders_0ToAny(
        const WorkspaceFoldersInitializeParams_workspaceFolders_0 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = workspaceFolderToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToWorkspaceFoldersInitializeParams_workspaceFolders_0(
        const LSPAny &any
    ) const -> WorkspaceFoldersInitializeParams_workspaceFolders_0
    {
        const auto &array_0 = any.array();
        std::vector<WorkspaceFolder> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToWorkspaceFolder(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToCompletionContext(
        const LSPAny &any
    ) const -> CompletionContext
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionContext"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionContext value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionContext"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("triggerKind");
        if (iter_0 != object_0.end()) {
            value_0.triggerKind = anyToCompletionTriggerKind(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CompletionContext attribute: triggerKind"
            );
        }

        iter_0 = object_0.find("triggerCharacter");
        if (iter_0 != object_0.end()) {
            value_0.triggerCharacter = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::completionContextToAny(
        const CompletionContext &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "triggerKind",
            std::make_unique<LSPAny>(completionTriggerKindToAny(param.triggerKind))
        );

        if (param.triggerCharacter.has_value()) {
            const auto &triggerCharacter_0 = param.triggerCharacter.value();
            object_0.emplace(
                "triggerCharacter",
                std::make_unique<LSPAny>(stringToAny(triggerCharacter_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCompletionItemLabelDetails(
        const LSPAny &any
    ) const -> CompletionItemLabelDetails
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionItemLabelDetails"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionItemLabelDetails value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionItemLabelDetails"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("detail");
        if (iter_0 != object_0.end()) {
            value_0.detail = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("description");
        if (iter_0 != object_0.end()) {
            value_0.description = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::completionItemLabelDetailsToAny(
        const CompletionItemLabelDetails &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.detail.has_value()) {
            const auto &detail_0 = param.detail.value();
            object_0.emplace(
                "detail",
                std::make_unique<LSPAny>(stringToAny(detail_0))
            );
        }

        if (param.description.has_value()) {
            const auto &description_0 = param.description.value();
            object_0.emplace(
                "description",
                std::make_unique<LSPAny>(stringToAny(description_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::completionOptions_triggerCharactersToAny(
        const CompletionOptions_triggerCharacters &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionOptions_triggerCharacters(
        const LSPAny &any
    ) const -> CompletionOptions_triggerCharacters
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::completionOptions_allCommitCharactersToAny(
        const CompletionOptions_allCommitCharacters &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionOptions_allCommitCharacters(
        const LSPAny &any
    ) const -> CompletionOptions_allCommitCharacters
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToSignatureInformation_documentation(
        const LSPAny &any
    ) const -> SignatureInformation_documentation
    {
        SignatureInformation_documentation value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToMarkupContent(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to SignatureInformation_documentation"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "SignatureInformation_documentation"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::signatureInformation_documentationToAny(
        const SignatureInformation_documentation &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case SignatureInformation_documentationType::String: {
            return stringToAny(value.string());
        }
        case SignatureInformation_documentationType::MarkupContent: {
            return markupContentToAny(value.markupContent());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported SignatureInformation_documentationType: " +
                 SignatureInformation_documentationTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::signatureHelpOptions_triggerCharactersToAny(
        const SignatureHelpOptions_triggerCharacters &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSignatureHelpOptions_triggerCharacters(
        const LSPAny &any
    ) const -> SignatureHelpOptions_triggerCharacters
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::signatureHelpOptions_retriggerCharactersToAny(
        const SignatureHelpOptions_retriggerCharacters &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSignatureHelpOptions_retriggerCharacters(
        const LSPAny &any
    ) const -> SignatureHelpOptions_retriggerCharacters
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToBaseSymbolInformation(
        const LSPAny &any
    ) const -> BaseSymbolInformation
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "BaseSymbolInformation"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        BaseSymbolInformation value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "BaseSymbolInformation"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("name");
        if (iter_0 != object_0.end()) {
            value_0.name = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required BaseSymbolInformation attribute: name"
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToSymbolKind(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required BaseSymbolInformation attribute: kind"
            );
        }

        iter_0 = object_0.find("tags");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<SymbolTag> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToSymbolTag(*elem_0));
            }
            value_0.tags = std::move(values_0);
        }

        iter_0 = object_0.find("containerName");
        if (iter_0 != object_0.end()) {
            value_0.containerName = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::baseSymbolInformationToAny(
        const BaseSymbolInformation &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "name",
            std::make_unique<LSPAny>(stringToAny(param.name))
        );

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(symbolKindToAny(param.kind))
        );

        if (param.tags.has_value()) {
            const auto &tags_0 = param.tags.value();
            LSPArray array_0;
            array_0.reserve(tags_0.size());
            for (const auto &elem_0 : tags_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = symbolTagToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("tags", std::move(any_1));
        }

        if (param.containerName.has_value()) {
            const auto &containerName_0 = param.containerName.value();
            object_0.emplace(
                "containerName",
                std::make_unique<LSPAny>(stringToAny(containerName_0))
            );
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToDocumentOnTypeFormattingOptions(
        const LSPAny &any
    ) const -> DocumentOnTypeFormattingOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentOnTypeFormattingOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentOnTypeFormattingOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentOnTypeFormattingOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("firstTriggerCharacter");
        if (iter_0 != object_0.end()) {
            value_0.firstTriggerCharacter = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentOnTypeFormattingOptions attribute: firstTriggerCharacter"
            );
        }

        iter_0 = object_0.find("moreTriggerCharacter");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.moreTriggerCharacter = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::documentOnTypeFormattingOptionsToAny(
        const DocumentOnTypeFormattingOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "firstTriggerCharacter",
            std::make_unique<LSPAny>(stringToAny(param.firstTriggerCharacter))
        );

        if (param.moreTriggerCharacter.has_value()) {
            const auto &moreTriggerCharacter_0 =
                param.moreTriggerCharacter.value();
            LSPArray array_0;
            array_0.reserve(moreTriggerCharacter_0.size());
            for (const auto &elem_0 : moreTriggerCharacter_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = stringToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("moreTriggerCharacter", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::documentOnTypeFormattingOptions_moreTriggerCharacterToAny(
        const DocumentOnTypeFormattingOptions_moreTriggerCharacter &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDocumentOnTypeFormattingOptions_moreTriggerCharacter(
        const LSPAny &any
    ) const -> DocumentOnTypeFormattingOptions_moreTriggerCharacter
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::executeCommandOptions_commandsToAny(
        const ExecuteCommandOptions_commands &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToExecuteCommandOptions_commands(
        const LSPAny &any
    ) const -> ExecuteCommandOptions_commands
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToSemanticTokensLegend(
        const LSPAny &any
    ) const -> SemanticTokensLegend
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SemanticTokensLegend"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SemanticTokensLegend value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SemanticTokensLegend"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("tokenTypes");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.tokenTypes = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SemanticTokensLegend attribute: tokenTypes"
            );
        }

        iter_0 = object_0.find("tokenModifiers");
        if (iter_0 != object_0.end()) {
            const auto &array_1 = iter_0->second->array();
            std::vector<string_t> values_1;
            for (const auto &elem_1 : array_1) {
                values_1.push_back(anyToString(*elem_1));
            }
            value_0.tokenModifiers = std::move(values_1);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SemanticTokensLegend attribute: tokenModifiers"
            );
        }

        return value_0;
    }

    auto LspTransformer::semanticTokensLegendToAny(
        const SemanticTokensLegend &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.tokenTypes.size());
        for (const auto &elem_0 : param.tokenTypes) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("tokenTypes", std::move(any_1));

        LSPArray array_1;
        array_1.reserve(param.tokenModifiers.size());
        for (const auto &elem_1 : param.tokenModifiers) {
            auto any_2 = std::make_unique<LSPAny>();
            (*any_2) = stringToAny(elem_1);
            array_1.push_back(std::move(any_2));
        }
        auto any_3 = std::make_unique<LSPAny>();
        (*any_3) = std::move(array_1);
        object_0.emplace("tokenModifiers", std::move(any_3));

        LSPAny any_4;
        any_4 = std::move(object_0);
        return any_4;
    }

    auto LspTransformer::semanticTokensLegend_tokenTypesToAny(
        const SemanticTokensLegend_tokenTypes &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSemanticTokensLegend_tokenTypes(
        const LSPAny &any
    ) const -> SemanticTokensLegend_tokenTypes
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::semanticTokensLegend_tokenModifiersToAny(
        const SemanticTokensLegend_tokenModifiers &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSemanticTokensLegend_tokenModifiers(
        const LSPAny &any
    ) const -> SemanticTokensLegend_tokenModifiers
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToNotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem(
        const LSPAny &any
    ) const -> NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("language");
        if (iter_0 != object_0.end()) {
            value_0.language = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem attribute: language"
            );
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentSyncOptions_notebookSelector_elem_0_cells_elemToAny(
        const NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "language",
            std::make_unique<LSPAny>(stringToAny(param.language))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::notebookDocumentSyncOptions_notebookSelector_elem_0_cellsToAny(
        const NotebookDocumentSyncOptions_notebookSelector_elem_0_cells &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) =
                notebookDocumentSyncOptions_notebookSelector_elem_0_cells_elemToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToNotebookDocumentSyncOptions_notebookSelector_elem_0_cells(
        const LSPAny &any
    ) const -> NotebookDocumentSyncOptions_notebookSelector_elem_0_cells
    {
        const auto &array_0 = any.array();
        std::vector<NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(
                anyToNotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem(*elem_0)
            );
        }
        return values_0;
    }

    auto LspTransformer::anyToNotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem(
        const LSPAny &any
    ) const -> NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("language");
        if (iter_0 != object_0.end()) {
            value_0.language = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem attribute: language"
            );
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentSyncOptions_notebookSelector_elem_1_cells_elemToAny(
        const NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "language",
            std::make_unique<LSPAny>(stringToAny(param.language))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::notebookDocumentSyncOptions_notebookSelector_elem_1_cellsToAny(
        const NotebookDocumentSyncOptions_notebookSelector_elem_1_cells &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) =
                notebookDocumentSyncOptions_notebookSelector_elem_1_cells_elemToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToNotebookDocumentSyncOptions_notebookSelector_elem_1_cells(
        const LSPAny &any
    ) const -> NotebookDocumentSyncOptions_notebookSelector_elem_1_cells
    {
        const auto &array_0 = any.array();
        std::vector<NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(
                anyToNotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem(*elem_0)
            );
        }
        return values_0;
    }

    auto LspTransformer::anyToParameterInformation_documentation(
        const LSPAny &any
    ) const -> ParameterInformation_documentation
    {
        ParameterInformation_documentation value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToMarkupContent(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ParameterInformation_documentation"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ParameterInformation_documentation"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::parameterInformation_documentationToAny(
        const ParameterInformation_documentation &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ParameterInformation_documentationType::String: {
            return stringToAny(value.string());
        }
        case ParameterInformation_documentationType::MarkupContent: {
            return markupContentToAny(value.markupContent());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ParameterInformation_documentationType: " +
                 ParameterInformation_documentationTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::generalClientCapabilities_staleRequestSupport_retryOnContentModifiedToAny(
        const GeneralClientCapabilities_staleRequestSupport_retryOnContentModified &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToGeneralClientCapabilities_staleRequestSupport_retryOnContentModified(
        const LSPAny &any
    ) const -> GeneralClientCapabilities_staleRequestSupport_retryOnContentModified
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToRelativePattern_baseUri(
        const LSPAny &any
    ) const -> RelativePattern_baseUri
    {
        RelativePattern_baseUri value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToWorkspaceFolder(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to RelativePattern_baseUri"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "RelativePattern_baseUri"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::relativePattern_baseUriToAny(
        const RelativePattern_baseUri &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case RelativePattern_baseUriType::WorkspaceFolder: {
            return workspaceFolderToAny(value.workspaceFolder());
        }
        case RelativePattern_baseUriType::String: {
            return uriToAny(value.uri());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported RelativePattern_baseUriType: " +
                 RelativePattern_baseUriTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToWorkspaceSymbolClientCapabilities_resolveSupport(
        const LSPAny &any
    ) const -> WorkspaceSymbolClientCapabilities_resolveSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceSymbolClientCapabilities_resolveSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceSymbolClientCapabilities_resolveSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceSymbolClientCapabilities_resolveSupport"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("properties");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.properties = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WorkspaceSymbolClientCapabilities_resolveSupport attribute: properties"
            );
        }

        return value_0;
    }

    auto LspTransformer::workspaceSymbolClientCapabilities_resolveSupportToAny(
        const WorkspaceSymbolClientCapabilities_resolveSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.properties.size());
        for (const auto &elem_0 : param.properties) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("properties", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::workspaceSymbolClientCapabilities_resolveSupport_propertiesToAny(
        const WorkspaceSymbolClientCapabilities_resolveSupport_properties &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToWorkspaceSymbolClientCapabilities_resolveSupport_properties(
        const LSPAny &any
    ) const -> WorkspaceSymbolClientCapabilities_resolveSupport_properties
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionItem_resolveSupport(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionItem_resolveSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionClientCapabilities_completionItem_resolveSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionClientCapabilities_completionItem_resolveSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionClientCapabilities_completionItem_resolveSupport"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("properties");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.properties = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CompletionClientCapabilities_completionItem_resolveSupport attribute: properties"
            );
        }

        return value_0;
    }

    auto LspTransformer::completionClientCapabilities_completionItem_resolveSupportToAny(
        const CompletionClientCapabilities_completionItem_resolveSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.properties.size());
        for (const auto &elem_0 : param.properties) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("properties", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::completionClientCapabilities_completionItem_resolveSupport_propertiesToAny(
        const CompletionClientCapabilities_completionItem_resolveSupport_properties &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionItem_resolveSupport_properties(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionItem_resolveSupport_properties
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionList(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionList
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionClientCapabilities_completionList"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionClientCapabilities_completionList value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionClientCapabilities_completionList"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("itemDefaults");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.itemDefaults = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::completionClientCapabilities_completionListToAny(
        const CompletionClientCapabilities_completionList &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.itemDefaults.has_value()) {
            const auto &itemDefaults_0 = param.itemDefaults.value();
            LSPArray array_0;
            array_0.reserve(itemDefaults_0.size());
            for (const auto &elem_0 : itemDefaults_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = stringToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("itemDefaults", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::completionClientCapabilities_completionList_itemDefaultsToAny(
        const CompletionClientCapabilities_completionList_itemDefaults &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionList_itemDefaults(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionList_itemDefaults
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToCodeActionClientCapabilities_resolveSupport(
        const LSPAny &any
    ) const -> CodeActionClientCapabilities_resolveSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeActionClientCapabilities_resolveSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeActionClientCapabilities_resolveSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeActionClientCapabilities_resolveSupport"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("properties");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.properties = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CodeActionClientCapabilities_resolveSupport attribute: properties"
            );
        }

        return value_0;
    }

    auto LspTransformer::codeActionClientCapabilities_resolveSupportToAny(
        const CodeActionClientCapabilities_resolveSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.properties.size());
        for (const auto &elem_0 : param.properties) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("properties", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::codeActionClientCapabilities_resolveSupport_propertiesToAny(
        const CodeActionClientCapabilities_resolveSupport_properties &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCodeActionClientCapabilities_resolveSupport_properties(
        const LSPAny &any
    ) const -> CodeActionClientCapabilities_resolveSupport_properties
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::semanticTokensClientCapabilities_tokenTypesToAny(
        const SemanticTokensClientCapabilities_tokenTypes &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSemanticTokensClientCapabilities_tokenTypes(
        const LSPAny &any
    ) const -> SemanticTokensClientCapabilities_tokenTypes
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::semanticTokensClientCapabilities_tokenModifiersToAny(
        const SemanticTokensClientCapabilities_tokenModifiers &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSemanticTokensClientCapabilities_tokenModifiers(
        const LSPAny &any
    ) const -> SemanticTokensClientCapabilities_tokenModifiers
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToInlayHintClientCapabilities_resolveSupport(
        const LSPAny &any
    ) const -> InlayHintClientCapabilities_resolveSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlayHintClientCapabilities_resolveSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlayHintClientCapabilities_resolveSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlayHintClientCapabilities_resolveSupport"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("properties");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.properties = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InlayHintClientCapabilities_resolveSupport attribute: properties"
            );
        }

        return value_0;
    }

    auto LspTransformer::inlayHintClientCapabilities_resolveSupportToAny(
        const InlayHintClientCapabilities_resolveSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.properties.size());
        for (const auto &elem_0 : param.properties) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("properties", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::inlayHintClientCapabilities_resolveSupport_propertiesToAny(
        const InlayHintClientCapabilities_resolveSupport_properties &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToInlayHintClientCapabilities_resolveSupport_properties(
        const LSPAny &any
    ) const -> InlayHintClientCapabilities_resolveSupport_properties
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToRegularExpressionsClientCapabilities(
        const LSPAny &any
    ) const -> RegularExpressionsClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "RegularExpressionsClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        RegularExpressionsClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "RegularExpressionsClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("engine");
        if (iter_0 != object_0.end()) {
            value_0.engine = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required RegularExpressionsClientCapabilities attribute: engine"
            );
        }

        iter_0 = object_0.find("version");
        if (iter_0 != object_0.end()) {
            value_0.version = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::regularExpressionsClientCapabilitiesToAny(
        const RegularExpressionsClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "engine",
            std::make_unique<LSPAny>(stringToAny(param.engine))
        );

        if (param.version.has_value()) {
            const auto &version_0 = param.version.value();
            object_0.emplace(
                "version",
                std::make_unique<LSPAny>(stringToAny(version_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToMarkdownClientCapabilities(
        const LSPAny &any
    ) const -> MarkdownClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "MarkdownClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        MarkdownClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "MarkdownClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("parser");
        if (iter_0 != object_0.end()) {
            value_0.parser = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required MarkdownClientCapabilities attribute: parser"
            );
        }

        iter_0 = object_0.find("version");
        if (iter_0 != object_0.end()) {
            value_0.version = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("allowedTags");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.allowedTags = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::markdownClientCapabilitiesToAny(
        const MarkdownClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "parser",
            std::make_unique<LSPAny>(stringToAny(param.parser))
        );

        if (param.version.has_value()) {
            const auto &version_0 = param.version.value();
            object_0.emplace(
                "version",
                std::make_unique<LSPAny>(stringToAny(version_0))
            );
        }

        if (param.allowedTags.has_value()) {
            const auto &allowedTags_0 = param.allowedTags.value();
            LSPArray array_0;
            array_0.reserve(allowedTags_0.size());
            for (const auto &elem_0 : allowedTags_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = stringToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("allowedTags", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::markdownClientCapabilities_allowedTagsToAny(
        const MarkdownClientCapabilities_allowedTags &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToMarkdownClientCapabilities_allowedTags(
        const LSPAny &any
    ) const -> MarkdownClientCapabilities_allowedTags
    {
        const auto &array_0 = any.array();
        std::vector<string_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToMessage(const LSPAny &any) const -> Message
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "Message"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        Message value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "Message"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("jsonrpc");
        if (iter_0 != object_0.end()) {
            value_0.jsonrpc = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Message attribute: jsonrpc"
            );
        }

        return value_0;
    }

    auto LspTransformer::messageToAny(const Message &param) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "jsonrpc",
            std::make_unique<LSPAny>(stringToAny(param.jsonrpc))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToChangeAnnotationIdentifier(
        const LSPAny &any
    ) const -> ChangeAnnotationIdentifier
    {
        switch (any.type()) {
        case LSPAnyType::String: {
            return any.string();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type ChangeAnnotationIdentifier")
            );
        }
        }
    }

    auto LspTransformer::changeAnnotationIdentifierToAny(
        const ChangeAnnotationIdentifier &alias
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::anyToResourceOperation(
        const LSPAny &any
    ) const -> ResourceOperation
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ResourceOperation"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ResourceOperation value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ResourceOperation"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ResourceOperation attribute: kind"
            );
        }

        iter_0 = object_0.find("annotationId");
        if (iter_0 != object_0.end()) {
            value_0.annotationId =
                anyToChangeAnnotationIdentifier(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::resourceOperationToAny(
        const ResourceOperation &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        if (param.annotationId.has_value()) {
            const auto &annotationId_0 = param.annotationId.value();
            object_0.emplace(
                "annotationId",
                std::make_unique<LSPAny>(changeAnnotationIdentifierToAny(annotationId_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentContentChangeEvent_1(
        const LSPAny &any
    ) const -> TextDocumentContentChangeEvent_1
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentContentChangeEvent_1"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentContentChangeEvent_1 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentContentChangeEvent_1"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("text");
        if (iter_0 != object_0.end()) {
            value_0.text = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentContentChangeEvent_1 attribute: text"
            );
        }

        return value_0;
    }

    auto LspTransformer::textDocumentContentChangeEvent_1ToAny(
        const TextDocumentContentChangeEvent_1 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "text",
            std::make_unique<LSPAny>(stringToAny(param.text))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToMarkedString_1(
        const LSPAny &any
    ) const -> MarkedString_1
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "MarkedString_1"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        MarkedString_1 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "MarkedString_1"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("language");
        if (iter_0 != object_0.end()) {
            value_0.language = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required MarkedString_1 attribute: language"
            );
        }

        iter_0 = object_0.find("value");
        if (iter_0 != object_0.end()) {
            value_0.value = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required MarkedString_1 attribute: value"
            );
        }

        return value_0;
    }

    auto LspTransformer::markedString_1ToAny(
        const MarkedString_1 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "language",
            std::make_unique<LSPAny>(stringToAny(param.language))
        );

        object_0.emplace(
            "value",
            std::make_unique<LSPAny>(stringToAny(param.value))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToMarkedString(
        const LSPAny &any
    ) const -> MarkedString
    {
        MarkedString value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToMarkedString_1(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to MarkedString"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "MarkedString"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::markedStringToAny(
        const MarkedString &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case MarkedStringType::String: {
            return stringToAny(value.string());
        }
        case MarkedStringType::MarkedString_1: {
            return markedString_1ToAny(value.markedString_1());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported MarkedStringType: " +
                 MarkedStringTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToHover_contents(
        const LSPAny &any
    ) const -> Hover_contents
    {
        Hover_contents value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToMarkupContent(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToMarkedString(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to Hover_contents"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Array: {
            try {
                value_0 = anyToHover_contents_2(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to Hover_contents"
                );
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "Hover_contents"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::hover_contentsToAny(
        const Hover_contents &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case Hover_contentsType::MarkupContent: {
            return markupContentToAny(value.markupContent());
        }
        case Hover_contentsType::MarkedString: {
            return markedStringToAny(value.markedString());
        }
        case Hover_contentsType::MarkedStringArray: {
            LSPArray array_0;
            array_0.reserve(value.markedStringArray().size());
            for (const auto &elem_0 : value.markedStringArray()) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = markedStringToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            LSPAny any_1;
            any_1 = std::move(array_0);
            return any_1;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported Hover_contentsType: " +
                 Hover_contentsTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::hover_contents_2ToAny(
        const Hover_contents_2 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = markedStringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToHover_contents_2(
        const LSPAny &any
    ) const -> Hover_contents_2
    {
        const auto &array_0 = any.array();
        std::vector<MarkedString> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToMarkedString(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::lspObjectToAny(const LSPObject &map) const -> LSPAny
    {
        LSPObject object_0;
        for (const auto &[key_0, value_0] : map) {
            object_0.emplace(
                key_0,
                std::make_unique<LSPAny>(lspAnyToAny(*value_0))
            );
        }
        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToLSPObject(const LSPAny &any) const -> LSPObject
    {
        std::map<string_t, std::unique_ptr<LSPAny>> map_0;
        for (const auto &[key_0, value_0] : any.object()) {
            map_0.emplace(
                key_0,
                std::make_unique<LSPAny>(anyToLSPAny(*value_0))
            );
        }
        return map_0;
    }

    auto LspTransformer::anyToTextDocumentFilter_0(
        const LSPAny &any
    ) const -> TextDocumentFilter_0
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentFilter_0"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentFilter_0 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentFilter_0"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("language");
        if (iter_0 != object_0.end()) {
            value_0.language = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentFilter_0 attribute: language"
            );
        }

        iter_0 = object_0.find("scheme");
        if (iter_0 != object_0.end()) {
            value_0.scheme = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("pattern");
        if (iter_0 != object_0.end()) {
            value_0.pattern = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::textDocumentFilter_0ToAny(
        const TextDocumentFilter_0 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "language",
            std::make_unique<LSPAny>(stringToAny(param.language))
        );

        if (param.scheme.has_value()) {
            const auto &scheme_0 = param.scheme.value();
            object_0.emplace(
                "scheme",
                std::make_unique<LSPAny>(stringToAny(scheme_0))
            );
        }

        if (param.pattern.has_value()) {
            const auto &pattern_0 = param.pattern.value();
            object_0.emplace(
                "pattern",
                std::make_unique<LSPAny>(stringToAny(pattern_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentFilter_1(
        const LSPAny &any
    ) const -> TextDocumentFilter_1
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentFilter_1"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentFilter_1 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentFilter_1"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("language");
        if (iter_0 != object_0.end()) {
            value_0.language = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("scheme");
        if (iter_0 != object_0.end()) {
            value_0.scheme = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentFilter_1 attribute: scheme"
            );
        }

        iter_0 = object_0.find("pattern");
        if (iter_0 != object_0.end()) {
            value_0.pattern = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::textDocumentFilter_1ToAny(
        const TextDocumentFilter_1 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.language.has_value()) {
            const auto &language_0 = param.language.value();
            object_0.emplace(
                "language",
                std::make_unique<LSPAny>(stringToAny(language_0))
            );
        }

        object_0.emplace(
            "scheme",
            std::make_unique<LSPAny>(stringToAny(param.scheme))
        );

        if (param.pattern.has_value()) {
            const auto &pattern_0 = param.pattern.value();
            object_0.emplace(
                "pattern",
                std::make_unique<LSPAny>(stringToAny(pattern_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentFilter_2(
        const LSPAny &any
    ) const -> TextDocumentFilter_2
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentFilter_2"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentFilter_2 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentFilter_2"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("language");
        if (iter_0 != object_0.end()) {
            value_0.language = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("scheme");
        if (iter_0 != object_0.end()) {
            value_0.scheme = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("pattern");
        if (iter_0 != object_0.end()) {
            value_0.pattern = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentFilter_2 attribute: pattern"
            );
        }

        return value_0;
    }

    auto LspTransformer::textDocumentFilter_2ToAny(
        const TextDocumentFilter_2 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.language.has_value()) {
            const auto &language_0 = param.language.value();
            object_0.emplace(
                "language",
                std::make_unique<LSPAny>(stringToAny(language_0))
            );
        }

        if (param.scheme.has_value()) {
            const auto &scheme_0 = param.scheme.value();
            object_0.emplace(
                "scheme",
                std::make_unique<LSPAny>(stringToAny(scheme_0))
            );
        }

        object_0.emplace(
            "pattern",
            std::make_unique<LSPAny>(stringToAny(param.pattern))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentFilter(
        const LSPAny &any
    ) const -> TextDocumentFilter
    {
        TextDocumentFilter value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToTextDocumentFilter_0(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToTextDocumentFilter_1(any);
                } catch (LspException &/*e*/) {
                    try {
                        value_0 = anyToTextDocumentFilter_2(any);
                    } catch (LspException &/*e*/) {
                        throw LSP_EXCEPTION(
                            ErrorCodes::InvalidParams,
                            "Failed to transform LSPAny to TextDocumentFilter"
                        );
                    }
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "TextDocumentFilter"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::textDocumentFilterToAny(
        const TextDocumentFilter &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case TextDocumentFilterType::TextDocumentFilter_0: {
            return textDocumentFilter_0ToAny(value.textDocumentFilter_0());
        }
        case TextDocumentFilterType::TextDocumentFilter_1: {
            return textDocumentFilter_1ToAny(value.textDocumentFilter_1());
        }
        case TextDocumentFilterType::TextDocumentFilter_2: {
            return textDocumentFilter_2ToAny(value.textDocumentFilter_2());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported TextDocumentFilterType: " +
                 TextDocumentFilterTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToNotebookDocumentFilter_0(
        const LSPAny &any
    ) const -> NotebookDocumentFilter_0
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentFilter_0"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentFilter_0 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentFilter_0"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("notebookType");
        if (iter_0 != object_0.end()) {
            value_0.notebookType = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookDocumentFilter_0 attribute: notebookType"
            );
        }

        iter_0 = object_0.find("scheme");
        if (iter_0 != object_0.end()) {
            value_0.scheme = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("pattern");
        if (iter_0 != object_0.end()) {
            value_0.pattern = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentFilter_0ToAny(
        const NotebookDocumentFilter_0 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "notebookType",
            std::make_unique<LSPAny>(stringToAny(param.notebookType))
        );

        if (param.scheme.has_value()) {
            const auto &scheme_0 = param.scheme.value();
            object_0.emplace(
                "scheme",
                std::make_unique<LSPAny>(stringToAny(scheme_0))
            );
        }

        if (param.pattern.has_value()) {
            const auto &pattern_0 = param.pattern.value();
            object_0.emplace(
                "pattern",
                std::make_unique<LSPAny>(stringToAny(pattern_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToNotebookDocumentFilter_1(
        const LSPAny &any
    ) const -> NotebookDocumentFilter_1
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentFilter_1"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentFilter_1 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentFilter_1"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("notebookType");
        if (iter_0 != object_0.end()) {
            value_0.notebookType = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("scheme");
        if (iter_0 != object_0.end()) {
            value_0.scheme = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookDocumentFilter_1 attribute: scheme"
            );
        }

        iter_0 = object_0.find("pattern");
        if (iter_0 != object_0.end()) {
            value_0.pattern = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentFilter_1ToAny(
        const NotebookDocumentFilter_1 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.notebookType.has_value()) {
            const auto &notebookType_0 = param.notebookType.value();
            object_0.emplace(
                "notebookType",
                std::make_unique<LSPAny>(stringToAny(notebookType_0))
            );
        }

        object_0.emplace(
            "scheme",
            std::make_unique<LSPAny>(stringToAny(param.scheme))
        );

        if (param.pattern.has_value()) {
            const auto &pattern_0 = param.pattern.value();
            object_0.emplace(
                "pattern",
                std::make_unique<LSPAny>(stringToAny(pattern_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToNotebookDocumentFilter_2(
        const LSPAny &any
    ) const -> NotebookDocumentFilter_2
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentFilter_2"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentFilter_2 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentFilter_2"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("notebookType");
        if (iter_0 != object_0.end()) {
            value_0.notebookType = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("scheme");
        if (iter_0 != object_0.end()) {
            value_0.scheme = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("pattern");
        if (iter_0 != object_0.end()) {
            value_0.pattern = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookDocumentFilter_2 attribute: pattern"
            );
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentFilter_2ToAny(
        const NotebookDocumentFilter_2 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.notebookType.has_value()) {
            const auto &notebookType_0 = param.notebookType.value();
            object_0.emplace(
                "notebookType",
                std::make_unique<LSPAny>(stringToAny(notebookType_0))
            );
        }

        if (param.scheme.has_value()) {
            const auto &scheme_0 = param.scheme.value();
            object_0.emplace(
                "scheme",
                std::make_unique<LSPAny>(stringToAny(scheme_0))
            );
        }

        object_0.emplace(
            "pattern",
            std::make_unique<LSPAny>(stringToAny(param.pattern))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToNotebookDocumentFilter(
        const LSPAny &any
    ) const -> NotebookDocumentFilter
    {
        NotebookDocumentFilter value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToNotebookDocumentFilter_0(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToNotebookDocumentFilter_1(any);
                } catch (LspException &/*e*/) {
                    try {
                        value_0 = anyToNotebookDocumentFilter_2(any);
                    } catch (LspException &/*e*/) {
                        throw LSP_EXCEPTION(
                            ErrorCodes::InvalidParams,
                            "Failed to transform LSPAny to NotebookDocumentFilter"
                        );
                    }
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "NotebookDocumentFilter"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentFilterToAny(
        const NotebookDocumentFilter &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case NotebookDocumentFilterType::NotebookDocumentFilter_0: {
            return notebookDocumentFilter_0ToAny(value.notebookDocumentFilter_0());
        }
        case NotebookDocumentFilterType::NotebookDocumentFilter_1: {
            return notebookDocumentFilter_1ToAny(value.notebookDocumentFilter_1());
        }
        case NotebookDocumentFilterType::NotebookDocumentFilter_2: {
            return notebookDocumentFilter_2ToAny(value.notebookDocumentFilter_2());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported NotebookDocumentFilterType: " +
                 NotebookDocumentFilterTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToNotebookDocumentSyncOptions_notebookSelector_elem_0_notebook(
        const LSPAny &any
    ) const -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook
    {
        NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToNotebookDocumentFilter(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentSyncOptions_notebookSelector_elem_0_notebookToAny(
        const NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::String: {
            return stringToAny(value.string());
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::NotebookDocumentFilter: {
            return notebookDocumentFilterToAny(value.notebookDocumentFilter());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType: " +
                 NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToNotebookDocumentSyncOptions_notebookSelector_elem_0(
        const LSPAny &any
    ) const -> NotebookDocumentSyncOptions_notebookSelector_elem_0
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_0"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentSyncOptions_notebookSelector_elem_0 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_0"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("notebook");
        if (iter_0 != object_0.end()) {
            value_0.notebook =
                anyToNotebookDocumentSyncOptions_notebookSelector_elem_0_notebook(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookDocumentSyncOptions_notebookSelector_elem_0 attribute: notebook"
            );
        }

        iter_0 = object_0.find("cells");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(
                    anyToNotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem(*elem_0)
                );
            }
            value_0.cells = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentSyncOptions_notebookSelector_elem_0ToAny(
        const NotebookDocumentSyncOptions_notebookSelector_elem_0 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "notebook",
            std::make_unique<LSPAny>(notebookDocumentSyncOptions_notebookSelector_elem_0_notebookToAny(param.notebook))
        );

        if (param.cells.has_value()) {
            const auto &cells_0 = param.cells.value();
            LSPArray array_0;
            array_0.reserve(cells_0.size());
            for (const auto &elem_0 : cells_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) =
                    notebookDocumentSyncOptions_notebookSelector_elem_0_cells_elemToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("cells", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToNotebookDocumentSyncOptions_notebookSelector_elem_1_notebook(
        const LSPAny &any
    ) const -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook
    {
        NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToNotebookDocumentFilter(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentSyncOptions_notebookSelector_elem_1_notebookToAny(
        const NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::String: {
            return stringToAny(value.string());
        }
        case NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::NotebookDocumentFilter: {
            return notebookDocumentFilterToAny(value.notebookDocumentFilter());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType: " +
                 NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToNotebookDocumentSyncOptions_notebookSelector_elem_1(
        const LSPAny &any
    ) const -> NotebookDocumentSyncOptions_notebookSelector_elem_1
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_1"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentSyncOptions_notebookSelector_elem_1 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentSyncOptions_notebookSelector_elem_1"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("notebook");
        if (iter_0 != object_0.end()) {
            value_0.notebook =
                anyToNotebookDocumentSyncOptions_notebookSelector_elem_1_notebook(*iter_0->second);
        }

        iter_0 = object_0.find("cells");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(
                    anyToNotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem(*elem_0)
                );
            }
            value_0.cells = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookDocumentSyncOptions_notebookSelector_elem_1 attribute: cells"
            );
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentSyncOptions_notebookSelector_elem_1ToAny(
        const NotebookDocumentSyncOptions_notebookSelector_elem_1 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.notebook.has_value()) {
            const auto &notebook_0 = param.notebook.value();
            object_0.emplace(
                "notebook",
                std::make_unique<LSPAny>(notebookDocumentSyncOptions_notebookSelector_elem_1_notebookToAny(notebook_0))
            );
        }

        LSPArray array_0;
        array_0.reserve(param.cells.size());
        for (const auto &elem_0 : param.cells) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) =
                notebookDocumentSyncOptions_notebookSelector_elem_1_cells_elemToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("cells", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToNotebookDocumentSyncOptions_notebookSelector_elem(
        const LSPAny &any
    ) const -> NotebookDocumentSyncOptions_notebookSelector_elem
    {
        NotebookDocumentSyncOptions_notebookSelector_elem value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 =
                    anyToNotebookDocumentSyncOptions_notebookSelector_elem_0(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 =
                        anyToNotebookDocumentSyncOptions_notebookSelector_elem_1(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to NotebookDocumentSyncOptions_notebookSelector_elem"
                    );
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "NotebookDocumentSyncOptions_notebookSelector_elem"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentSyncOptions_notebookSelector_elemToAny(
        const NotebookDocumentSyncOptions_notebookSelector_elem &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_0: {
            return notebookDocumentSyncOptions_notebookSelector_elem_0ToAny(value.notebookDocumentSyncOptions_notebookSelector_elem_0());
        }
        case NotebookDocumentSyncOptions_notebookSelector_elemType::NotebookDocumentSyncOptions_notebookSelector_elem_1: {
            return notebookDocumentSyncOptions_notebookSelector_elem_1ToAny(value.notebookDocumentSyncOptions_notebookSelector_elem_1());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported NotebookDocumentSyncOptions_notebookSelector_elemType: " +
                 NotebookDocumentSyncOptions_notebookSelector_elemTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::notebookDocumentSyncOptions_notebookSelectorToAny(
        const NotebookDocumentSyncOptions_notebookSelector &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) =
                notebookDocumentSyncOptions_notebookSelector_elemToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToNotebookDocumentSyncOptions_notebookSelector(
        const LSPAny &any
    ) const -> NotebookDocumentSyncOptions_notebookSelector
    {
        const auto &array_0 = any.array();
        std::vector<NotebookDocumentSyncOptions_notebookSelector_elem> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(
                anyToNotebookDocumentSyncOptions_notebookSelector_elem(*elem_0)
            );
        }
        return values_0;
    }

    auto LspTransformer::anyToNotebookCellTextDocumentFilter_notebook(
        const LSPAny &any
    ) const -> NotebookCellTextDocumentFilter_notebook
    {
        NotebookCellTextDocumentFilter_notebook value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToNotebookDocumentFilter(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to NotebookCellTextDocumentFilter_notebook"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "NotebookCellTextDocumentFilter_notebook"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::notebookCellTextDocumentFilter_notebookToAny(
        const NotebookCellTextDocumentFilter_notebook &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case NotebookCellTextDocumentFilter_notebookType::String: {
            return stringToAny(value.string());
        }
        case NotebookCellTextDocumentFilter_notebookType::NotebookDocumentFilter: {
            return notebookDocumentFilterToAny(value.notebookDocumentFilter());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported NotebookCellTextDocumentFilter_notebookType: " +
                 NotebookCellTextDocumentFilter_notebookTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToNotebookCellTextDocumentFilter(
        const LSPAny &any
    ) const -> NotebookCellTextDocumentFilter
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookCellTextDocumentFilter"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookCellTextDocumentFilter value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookCellTextDocumentFilter"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("notebook");
        if (iter_0 != object_0.end()) {
            value_0.notebook =
                anyToNotebookCellTextDocumentFilter_notebook(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookCellTextDocumentFilter attribute: notebook"
            );
        }

        iter_0 = object_0.find("language");
        if (iter_0 != object_0.end()) {
            value_0.language = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::notebookCellTextDocumentFilterToAny(
        const NotebookCellTextDocumentFilter &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "notebook",
            std::make_unique<LSPAny>(notebookCellTextDocumentFilter_notebookToAny(param.notebook))
        );

        if (param.language.has_value()) {
            const auto &language_0 = param.language.value();
            object_0.emplace(
                "language",
                std::make_unique<LSPAny>(stringToAny(language_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentFilter(
        const LSPAny &any
    ) const -> DocumentFilter
    {
        DocumentFilter value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToNotebookCellTextDocumentFilter(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToTextDocumentFilter(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to DocumentFilter"
                    );
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "DocumentFilter"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::documentFilterToAny(
        const DocumentFilter &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case DocumentFilterType::TextDocumentFilter: {
            return textDocumentFilterToAny(value.textDocumentFilter());
        }
        case DocumentFilterType::NotebookCellTextDocumentFilter: {
            return notebookCellTextDocumentFilterToAny(value.notebookCellTextDocumentFilter());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported DocumentFilterType: " +
                 DocumentFilterTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::documentSelectorToAny(
        const DocumentSelector &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = documentFilterToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDocumentSelector(
        const LSPAny &any
    ) const -> DocumentSelector
    {
        const auto &array_0 = any.array();
        std::vector<DocumentFilter> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToDocumentFilter(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToPattern(const LSPAny &any) const -> Pattern
    {
        switch (any.type()) {
        case LSPAnyType::String: {
            return any.string();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type Pattern")
            );
        }
        }
    }

    auto LspTransformer::patternToAny(const Pattern &alias) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::anyToRelativePattern(
        const LSPAny &any
    ) const -> RelativePattern
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "RelativePattern"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        RelativePattern value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "RelativePattern"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("baseUri");
        if (iter_0 != object_0.end()) {
            value_0.baseUri = anyToRelativePattern_baseUri(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required RelativePattern attribute: baseUri"
            );
        }

        iter_0 = object_0.find("pattern");
        if (iter_0 != object_0.end()) {
            value_0.pattern = anyToPattern(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required RelativePattern attribute: pattern"
            );
        }

        return value_0;
    }

    auto LspTransformer::relativePatternToAny(
        const RelativePattern &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "baseUri",
            std::make_unique<LSPAny>(relativePattern_baseUriToAny(param.baseUri))
        );

        object_0.emplace(
            "pattern",
            std::make_unique<LSPAny>(patternToAny(param.pattern))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToGlobPattern(
        const LSPAny &any
    ) const -> GlobPattern
    {
        GlobPattern value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToRelativePattern(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to GlobPattern"
                );
            }
            break;
        }
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "GlobPattern"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::globPatternToAny(
        const GlobPattern &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case GlobPatternType::Pattern: {
            return patternToAny(value.pattern());
        }
        case GlobPatternType::RelativePattern: {
            return relativePatternToAny(value.relativePattern());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported GlobPatternType: " +
                 GlobPatternTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToFileSystemWatcher(
        const LSPAny &any
    ) const -> FileSystemWatcher
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FileSystemWatcher"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FileSystemWatcher value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FileSystemWatcher"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("globPattern");
        if (iter_0 != object_0.end()) {
            value_0.globPattern = anyToGlobPattern(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FileSystemWatcher attribute: globPattern"
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToWatchKind(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::fileSystemWatcherToAny(
        const FileSystemWatcher &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "globPattern",
            std::make_unique<LSPAny>(globPatternToAny(param.globPattern))
        );

        if (param.kind.has_value()) {
            const auto &kind_0 = param.kind.value();
            object_0.emplace(
                "kind",
                std::make_unique<LSPAny>(watchKindToAny(kind_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDidChangeWatchedFilesRegistrationOptions(
        const LSPAny &any
    ) const -> DidChangeWatchedFilesRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DidChangeWatchedFilesRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DidChangeWatchedFilesRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DidChangeWatchedFilesRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("watchers");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<FileSystemWatcher> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToFileSystemWatcher(*elem_0));
            }
            value_0.watchers = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidChangeWatchedFilesRegistrationOptions attribute: watchers"
            );
        }

        return value_0;
    }

    auto LspTransformer::didChangeWatchedFilesRegistrationOptionsToAny(
        const DidChangeWatchedFilesRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.watchers.size());
        for (const auto &elem_0 : param.watchers) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileSystemWatcherToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("watchers", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::didChangeWatchedFilesRegistrationOptions_watchersToAny(
        const DidChangeWatchedFilesRegistrationOptions_watchers &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileSystemWatcherToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDidChangeWatchedFilesRegistrationOptions_watchers(
        const LSPAny &any
    ) const -> DidChangeWatchedFilesRegistrationOptions_watchers
    {
        const auto &array_0 = any.array();
        std::vector<FileSystemWatcher> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToFileSystemWatcher(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::workspace_WorkspaceFoldersResult_0ToAny(
        const Workspace_WorkspaceFoldersResult_0 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = workspaceFolderToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToWorkspace_WorkspaceFoldersResult_0(
        const LSPAny &any
    ) const -> Workspace_WorkspaceFoldersResult_0
    {
        const auto &array_0 = any.array();
        std::vector<WorkspaceFolder> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToWorkspaceFolder(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::textDocument_MonikerResult_0ToAny(
        const TextDocument_MonikerResult_0 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = monikerToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToTextDocument_MonikerResult_0(
        const LSPAny &any
    ) const -> TextDocument_MonikerResult_0
    {
        const auto &array_0 = any.array();
        std::vector<Moniker> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToMoniker(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::asWorkspace_DidChangeWorkspaceFoldersParams(
        const MessageParams &notificationParams
    ) const -> DidChangeWorkspaceFoldersParams
    {
        if (notificationParams.type() != MessageParamsType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Message parameter type must be MessageParamsType::Object "
                 "for method=\"workspace/didChangeWorkspaceFolders\" but received "
                 "MessageParamsType::" + MessageParamsTypeNames.at(notificationParams.type()))
            );
        }

        DidChangeWorkspaceFoldersParams params_0;
        const auto &object_0 = notificationParams.object();
        LSPObject::const_iterator iter_0;

        iter_0 = object_0.find("event");
        if (iter_0 != object_0.end()) {
            params_0.event = anyToWorkspaceFoldersChangeEvent(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidChangeWorkspaceFoldersParams attribute: event"
            );
        }

        return params_0;
    }

    auto LspTransformer::asWorkspace_DidCreateFilesParams(
        const MessageParams &notificationParams
    ) const -> CreateFilesParams
    {
        if (notificationParams.type() != MessageParamsType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Message parameter type must be MessageParamsType::Object "
                 "for method=\"workspace/didCreateFiles\" but received "
                 "MessageParamsType::" + MessageParamsTypeNames.at(notificationParams.type()))
            );
        }

        CreateFilesParams params_0;
        const auto &object_0 = notificationParams.object();
        LSPObject::const_iterator iter_0;

        iter_0 = object_0.find("files");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<FileCreate> values_0;
            values_0.reserve(array_0.size());
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToFileCreate(*elem_0));
            }
            params_0.files = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CreateFilesParams attribute: files"
            );
        }

        return params_0;
    }

    auto LspTransformer::asWorkspace_DidRenameFilesParams(
        const MessageParams &notificationParams
    ) const -> RenameFilesParams
    {
        if (notificationParams.type() != MessageParamsType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Message parameter type must be MessageParamsType::Object "
                 "for method=\"workspace/didRenameFiles\" but received "
                 "MessageParamsType::" + MessageParamsTypeNames.at(notificationParams.type()))
            );
        }

        RenameFilesParams params_0;
        const auto &object_0 = notificationParams.object();
        LSPObject::const_iterator iter_0;

        iter_0 = object_0.find("files");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<FileRename> values_0;
            values_0.reserve(array_0.size());
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToFileRename(*elem_0));
            }
            params_0.files = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required RenameFilesParams attribute: files"
            );
        }

        return params_0;
    }

    auto LspTransformer::asWorkspace_DidDeleteFilesParams(
        const MessageParams &notificationParams
    ) const -> DeleteFilesParams
    {
        if (notificationParams.type() != MessageParamsType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Message parameter type must be MessageParamsType::Object "
                 "for method=\"workspace/didDeleteFiles\" but received "
                 "MessageParamsType::" + MessageParamsTypeNames.at(notificationParams.type()))
            );
        }

        DeleteFilesParams params_0;
        const auto &object_0 = notificationParams.object();
        LSPObject::const_iterator iter_0;

        iter_0 = object_0.find("files");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<FileDelete> values_0;
            values_0.reserve(array_0.size());
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToFileDelete(*elem_0));
            }
            params_0.files = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DeleteFilesParams attribute: files"
            );
        }

        return params_0;
    }

    auto LspTransformer::asMessageParams(
        const ShowMessageParams &notificationParams
    ) const -> MessageParams
    {
        MessageParams messageParams_0;
        LSPObject object_0;

        auto any_0 = std::make_unique<LSPAny>();
        (*any_0) = messageTypeToAny(notificationParams.type);
        object_0.emplace("type", std::move(any_0));

        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = stringToAny(notificationParams.message);
        object_0.emplace("message", std::move(any_1));

        messageParams_0 = std::move(object_0);
        return messageParams_0;
    }

    auto LspTransformer::asMessageParams(
        const LogMessageParams &notificationParams
    ) const -> MessageParams
    {
        MessageParams messageParams_0;
        LSPObject object_0;

        auto any_0 = std::make_unique<LSPAny>();
        (*any_0) = messageTypeToAny(notificationParams.type);
        object_0.emplace("type", std::move(any_0));

        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = stringToAny(notificationParams.message);
        object_0.emplace("message", std::move(any_1));

        messageParams_0 = std::move(object_0);
        return messageParams_0;
    }

    auto LspTransformer::asTextDocument_DidSaveParams(
        const MessageParams &notificationParams
    ) const -> DidSaveTextDocumentParams
    {
        if (notificationParams.type() != MessageParamsType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Message parameter type must be MessageParamsType::Object "
                 "for method=\"textDocument/didSave\" but received "
                 "MessageParamsType::" + MessageParamsTypeNames.at(notificationParams.type()))
            );
        }

        DidSaveTextDocumentParams params_0;
        const auto &object_0 = notificationParams.object();
        LSPObject::const_iterator iter_0;

        iter_0 = object_0.find("textDocument");
        if (iter_0 != object_0.end()) {
            params_0.textDocument =
                anyToTextDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DidSaveTextDocumentParams attribute: textDocument"
            );
        }

        iter_0 = object_0.find("text");
        if (iter_0 != object_0.end()) {
            params_0.text = anyToString(*iter_0->second);
        }

        return params_0;
    }

    auto LspTransformer::asMessageParams(
        const LogTraceParams &notificationParams
    ) const -> MessageParams
    {
        MessageParams messageParams_0;
        LSPObject object_0;

        auto any_0 = std::make_unique<LSPAny>();
        (*any_0) = stringToAny(notificationParams.message);
        object_0.emplace("message", std::move(any_0));

        if (notificationParams.verbose.has_value()) {
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = stringToAny(notificationParams.verbose.value());
            object_0.emplace("verbose", std::move(any_1));
        }

        messageParams_0 = std::move(object_0);
        return messageParams_0;
    }

    auto LspTransformer::booleanToAny(boolean_t param) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = param;
        return any_0;
    }

    auto LspTransformer::anyToBoolean(const LSPAny &any) const -> boolean_t
    {
        switch (any.type()) {
        case LSPAnyType::Boolean: {
            return any.boolean();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type boolean_t")
            );
        }
        }
    }

    auto LspTransformer::anyToWorkDoneProgressOptions(
        const LSPAny &any
    ) const -> WorkDoneProgressOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkDoneProgressOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkDoneProgressOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkDoneProgressOptions"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workDoneProgressOptionsToAny(
        const WorkDoneProgressOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToShowDocumentResult(
        const LSPAny &any
    ) const -> ShowDocumentResult
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ShowDocumentResult"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ShowDocumentResult value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ShowDocumentResult"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("success");
        if (iter_0 != object_0.end()) {
            value_0.success = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ShowDocumentResult attribute: success"
            );
        }

        return value_0;
    }

    auto LspTransformer::showDocumentResultToAny(
        const ShowDocumentResult &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "success",
            std::make_unique<LSPAny>(booleanToAny(param.success))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDiagnosticServerCancellationData(
        const LSPAny &any
    ) const -> DiagnosticServerCancellationData
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DiagnosticServerCancellationData"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DiagnosticServerCancellationData value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DiagnosticServerCancellationData"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("retriggerRequest");
        if (iter_0 != object_0.end()) {
            value_0.retriggerRequest = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DiagnosticServerCancellationData attribute: retriggerRequest"
            );
        }

        return value_0;
    }

    auto LspTransformer::diagnosticServerCancellationDataToAny(
        const DiagnosticServerCancellationData &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "retriggerRequest",
            std::make_unique<LSPAny>(booleanToAny(param.retriggerRequest))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInitializeError(
        const LSPAny &any
    ) const -> InitializeError
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InitializeError"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InitializeError value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InitializeError"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("retry");
        if (iter_0 != object_0.end()) {
            value_0.retry = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InitializeError attribute: retry"
            );
        }

        return value_0;
    }

    auto LspTransformer::initializeErrorToAny(
        const InitializeError &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "retry",
            std::make_unique<LSPAny>(booleanToAny(param.retry))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToImplementationOptions(
        const LSPAny &any
    ) const -> ImplementationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "ImplementationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ImplementationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "ImplementationOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::implementationOptionsToAny(
        const ImplementationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTypeDefinitionOptions(
        const LSPAny &any
    ) const -> TypeDefinitionOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TypeDefinitionOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TypeDefinitionOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TypeDefinitionOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::typeDefinitionOptionsToAny(
        const TypeDefinitionOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentColorOptions(
        const LSPAny &any
    ) const -> DocumentColorOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentColorOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentColorOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentColorOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentColorOptionsToAny(
        const DocumentColorOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToFoldingRangeOptions(
        const LSPAny &any
    ) const -> FoldingRangeOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FoldingRangeOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FoldingRangeOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FoldingRangeOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::foldingRangeOptionsToAny(
        const FoldingRangeOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDeclarationOptions(
        const LSPAny &any
    ) const -> DeclarationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DeclarationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DeclarationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DeclarationOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::declarationOptionsToAny(
        const DeclarationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSelectionRangeOptions(
        const LSPAny &any
    ) const -> SelectionRangeOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SelectionRangeOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SelectionRangeOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SelectionRangeOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::selectionRangeOptionsToAny(
        const SelectionRangeOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCallHierarchyOptions(
        const LSPAny &any
    ) const -> CallHierarchyOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CallHierarchyOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CallHierarchyOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CallHierarchyOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::callHierarchyOptionsToAny(
        const CallHierarchyOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSemanticTokensOptions_full_1(
        const LSPAny &any
    ) const -> SemanticTokensOptions_full_1
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SemanticTokensOptions_full_1"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SemanticTokensOptions_full_1 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SemanticTokensOptions_full_1"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("delta");
        if (iter_0 != object_0.end()) {
            value_0.delta = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::semanticTokensOptions_full_1ToAny(
        const SemanticTokensOptions_full_1 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.delta.has_value()) {
            const auto &delta_0 = param.delta.value();
            object_0.emplace(
                "delta",
                std::make_unique<LSPAny>(booleanToAny(delta_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSemanticTokensOptions_full(
        const LSPAny &any
    ) const -> SemanticTokensOptions_full
    {
        SemanticTokensOptions_full value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToSemanticTokensOptions_full_1(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to SemanticTokensOptions_full"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "SemanticTokensOptions_full"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::semanticTokensOptions_fullToAny(
        const SemanticTokensOptions_full &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case SemanticTokensOptions_fullType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case SemanticTokensOptions_fullType::SemanticTokensOptions_full_1: {
            return semanticTokensOptions_full_1ToAny(value.semanticTokensOptions_full_1());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported SemanticTokensOptions_fullType: " +
                 SemanticTokensOptions_fullTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToLinkedEditingRangeOptions(
        const LSPAny &any
    ) const -> LinkedEditingRangeOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "LinkedEditingRangeOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        LinkedEditingRangeOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "LinkedEditingRangeOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::linkedEditingRangeOptionsToAny(
        const LinkedEditingRangeOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToChangeAnnotation(
        const LSPAny &any
    ) const -> ChangeAnnotation
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ChangeAnnotation"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ChangeAnnotation value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ChangeAnnotation"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("label");
        if (iter_0 != object_0.end()) {
            value_0.label = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ChangeAnnotation attribute: label"
            );
        }

        iter_0 = object_0.find("needsConfirmation");
        if (iter_0 != object_0.end()) {
            value_0.needsConfirmation = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("description");
        if (iter_0 != object_0.end()) {
            value_0.description = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::changeAnnotationToAny(
        const ChangeAnnotation &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "label",
            std::make_unique<LSPAny>(stringToAny(param.label))
        );

        if (param.needsConfirmation.has_value()) {
            const auto &needsConfirmation_0 = param.needsConfirmation.value();
            object_0.emplace(
                "needsConfirmation",
                std::make_unique<LSPAny>(booleanToAny(needsConfirmation_0))
            );
        }

        if (param.description.has_value()) {
            const auto &description_0 = param.description.value();
            object_0.emplace(
                "description",
                std::make_unique<LSPAny>(stringToAny(description_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::workspaceEdit_changeAnnotationsToAny(
        const WorkspaceEdit_changeAnnotations &map
    ) const -> LSPAny
    {
        LSPObject object_0;
        for (const auto &[key_0, value_0] : map) {
            object_0.emplace(
                key_0,
                std::make_unique<LSPAny>(changeAnnotationToAny(value_0))
            );
        }
        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWorkspaceEdit_changeAnnotations(
        const LSPAny &any
    ) const -> WorkspaceEdit_changeAnnotations
    {
        std::map<string_t, ChangeAnnotation> map_0;
        for (const auto &[key_0, value_0] : any.object()) {
            map_0.emplace(key_0, anyToChangeAnnotation(*value_0));
        }
        return map_0;
    }

    auto LspTransformer::anyToMonikerOptions(
        const LSPAny &any
    ) const -> MonikerOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "MonikerOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        MonikerOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "MonikerOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::monikerOptionsToAny(
        const MonikerOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTypeHierarchyOptions(
        const LSPAny &any
    ) const -> TypeHierarchyOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TypeHierarchyOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TypeHierarchyOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TypeHierarchyOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::typeHierarchyOptionsToAny(
        const TypeHierarchyOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlineValueOptions(
        const LSPAny &any
    ) const -> InlineValueOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlineValueOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlineValueOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlineValueOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlineValueOptionsToAny(
        const InlineValueOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlayHintOptions(
        const LSPAny &any
    ) const -> InlayHintOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlayHintOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlayHintOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlayHintOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlayHintOptionsToAny(
        const InlayHintOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDiagnosticOptions(
        const LSPAny &any
    ) const -> DiagnosticOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DiagnosticOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DiagnosticOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DiagnosticOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("identifier");
        if (iter_0 != object_0.end()) {
            value_0.identifier = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("interFileDependencies");
        if (iter_0 != object_0.end()) {
            value_0.interFileDependencies = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DiagnosticOptions attribute: interFileDependencies"
            );
        }

        iter_0 = object_0.find("workspaceDiagnostics");
        if (iter_0 != object_0.end()) {
            value_0.workspaceDiagnostics = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DiagnosticOptions attribute: workspaceDiagnostics"
            );
        }

        return value_0;
    }

    auto LspTransformer::diagnosticOptionsToAny(
        const DiagnosticOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.identifier.has_value()) {
            const auto &identifier_0 = param.identifier.value();
            object_0.emplace(
                "identifier",
                std::make_unique<LSPAny>(stringToAny(identifier_0))
            );
        }

        object_0.emplace(
            "interFileDependencies",
            std::make_unique<LSPAny>(booleanToAny(param.interFileDependencies))
        );

        object_0.emplace(
            "workspaceDiagnostics",
            std::make_unique<LSPAny>(booleanToAny(param.workspaceDiagnostics))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlineCompletionOptions(
        const LSPAny &any
    ) const -> InlineCompletionOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlineCompletionOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlineCompletionOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlineCompletionOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlineCompletionOptionsToAny(
        const InlineCompletionOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_inlineCompletionProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_inlineCompletionProvider
    {
        ServerCapabilities_inlineCompletionProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToInlineCompletionOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_inlineCompletionProvider"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_inlineCompletionProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_inlineCompletionProviderToAny(
        const ServerCapabilities_inlineCompletionProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_inlineCompletionProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_inlineCompletionProviderType::InlineCompletionOptions: {
            return inlineCompletionOptionsToAny(value.inlineCompletionOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_inlineCompletionProviderType: " +
                 ServerCapabilities_inlineCompletionProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToSaveOptions(
        const LSPAny &any
    ) const -> SaveOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SaveOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SaveOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SaveOptions"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("includeText");
        if (iter_0 != object_0.end()) {
            value_0.includeText = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::saveOptionsToAny(
        const SaveOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.includeText.has_value()) {
            const auto &includeText_0 = param.includeText.value();
            object_0.emplace(
                "includeText",
                std::make_unique<LSPAny>(booleanToAny(includeText_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCompletionOptions_completionItem(
        const LSPAny &any
    ) const -> CompletionOptions_completionItem
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionOptions_completionItem"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionOptions_completionItem value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionOptions_completionItem"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("labelDetailsSupport");
        if (iter_0 != object_0.end()) {
            value_0.labelDetailsSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::completionOptions_completionItemToAny(
        const CompletionOptions_completionItem &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.labelDetailsSupport.has_value()) {
            const auto &labelDetailsSupport_0 =
                param.labelDetailsSupport.value();
            object_0.emplace(
                "labelDetailsSupport",
                std::make_unique<LSPAny>(booleanToAny(labelDetailsSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCompletionOptions(
        const LSPAny &any
    ) const -> CompletionOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 6) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionOptions"
                 ": " + std::to_string(object_0.size()) + " > 6")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("triggerCharacters");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.triggerCharacters = std::move(values_0);
        }

        iter_0 = object_0.find("allCommitCharacters");
        if (iter_0 != object_0.end()) {
            const auto &array_1 = iter_0->second->array();
            std::vector<string_t> values_1;
            for (const auto &elem_1 : array_1) {
                values_1.push_back(anyToString(*elem_1));
            }
            value_0.allCommitCharacters = std::move(values_1);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("completionItem");
        if (iter_0 != object_0.end()) {
            value_0.completionItem =
                anyToCompletionOptions_completionItem(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::completionOptionsToAny(
        const CompletionOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.triggerCharacters.has_value()) {
            const auto &triggerCharacters_0 = param.triggerCharacters.value();
            LSPArray array_0;
            array_0.reserve(triggerCharacters_0.size());
            for (const auto &elem_0 : triggerCharacters_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = stringToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("triggerCharacters", std::move(any_1));
        }

        if (param.allCommitCharacters.has_value()) {
            const auto &allCommitCharacters_0 =
                param.allCommitCharacters.value();
            LSPArray array_1;
            array_1.reserve(allCommitCharacters_0.size());
            for (const auto &elem_1 : allCommitCharacters_0) {
                auto any_2 = std::make_unique<LSPAny>();
                (*any_2) = stringToAny(elem_1);
                array_1.push_back(std::move(any_2));
            }
            auto any_3 = std::make_unique<LSPAny>();
            (*any_3) = std::move(array_1);
            object_0.emplace("allCommitCharacters", std::move(any_3));
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        if (param.completionItem.has_value()) {
            const auto &completionItem_0 = param.completionItem.value();
            object_0.emplace(
                "completionItem",
                std::make_unique<LSPAny>(completionOptions_completionItemToAny(completionItem_0))
            );
        }

        LSPAny any_4;
        any_4 = std::move(object_0);
        return any_4;
    }

    auto LspTransformer::anyToHoverOptions(
        const LSPAny &any
    ) const -> HoverOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "HoverOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        HoverOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "HoverOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::hoverOptionsToAny(
        const HoverOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_hoverProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_hoverProvider
    {
        ServerCapabilities_hoverProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToHoverOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_hoverProvider"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_hoverProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_hoverProviderToAny(
        const ServerCapabilities_hoverProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_hoverProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_hoverProviderType::HoverOptions: {
            return hoverOptionsToAny(value.hoverOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_hoverProviderType: " +
                 ServerCapabilities_hoverProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToSignatureHelpOptions(
        const LSPAny &any
    ) const -> SignatureHelpOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SignatureHelpOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SignatureHelpOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SignatureHelpOptions"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("triggerCharacters");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.triggerCharacters = std::move(values_0);
        }

        iter_0 = object_0.find("retriggerCharacters");
        if (iter_0 != object_0.end()) {
            const auto &array_1 = iter_0->second->array();
            std::vector<string_t> values_1;
            for (const auto &elem_1 : array_1) {
                values_1.push_back(anyToString(*elem_1));
            }
            value_0.retriggerCharacters = std::move(values_1);
        }

        return value_0;
    }

    auto LspTransformer::signatureHelpOptionsToAny(
        const SignatureHelpOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.triggerCharacters.has_value()) {
            const auto &triggerCharacters_0 = param.triggerCharacters.value();
            LSPArray array_0;
            array_0.reserve(triggerCharacters_0.size());
            for (const auto &elem_0 : triggerCharacters_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = stringToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("triggerCharacters", std::move(any_1));
        }

        if (param.retriggerCharacters.has_value()) {
            const auto &retriggerCharacters_0 =
                param.retriggerCharacters.value();
            LSPArray array_1;
            array_1.reserve(retriggerCharacters_0.size());
            for (const auto &elem_1 : retriggerCharacters_0) {
                auto any_2 = std::make_unique<LSPAny>();
                (*any_2) = stringToAny(elem_1);
                array_1.push_back(std::move(any_2));
            }
            auto any_3 = std::make_unique<LSPAny>();
            (*any_3) = std::move(array_1);
            object_0.emplace("retriggerCharacters", std::move(any_3));
        }

        LSPAny any_4;
        any_4 = std::move(object_0);
        return any_4;
    }

    auto LspTransformer::anyToDefinitionOptions(
        const LSPAny &any
    ) const -> DefinitionOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DefinitionOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DefinitionOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DefinitionOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::definitionOptionsToAny(
        const DefinitionOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_definitionProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_definitionProvider
    {
        ServerCapabilities_definitionProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToDefinitionOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_definitionProvider"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_definitionProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_definitionProviderToAny(
        const ServerCapabilities_definitionProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_definitionProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_definitionProviderType::DefinitionOptions: {
            return definitionOptionsToAny(value.definitionOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_definitionProviderType: " +
                 ServerCapabilities_definitionProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToReferenceContext(
        const LSPAny &any
    ) const -> ReferenceContext
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ReferenceContext"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ReferenceContext value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ReferenceContext"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("includeDeclaration");
        if (iter_0 != object_0.end()) {
            value_0.includeDeclaration = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ReferenceContext attribute: includeDeclaration"
            );
        }

        return value_0;
    }

    auto LspTransformer::referenceContextToAny(
        const ReferenceContext &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "includeDeclaration",
            std::make_unique<LSPAny>(booleanToAny(param.includeDeclaration))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToReferenceOptions(
        const LSPAny &any
    ) const -> ReferenceOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ReferenceOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ReferenceOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ReferenceOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::referenceOptionsToAny(
        const ReferenceOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_referencesProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_referencesProvider
    {
        ServerCapabilities_referencesProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToReferenceOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_referencesProvider"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_referencesProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_referencesProviderToAny(
        const ServerCapabilities_referencesProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_referencesProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_referencesProviderType::ReferenceOptions: {
            return referenceOptionsToAny(value.referenceOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_referencesProviderType: " +
                 ServerCapabilities_referencesProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToDocumentHighlightOptions(
        const LSPAny &any
    ) const -> DocumentHighlightOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentHighlightOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentHighlightOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentHighlightOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentHighlightOptionsToAny(
        const DocumentHighlightOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_documentHighlightProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_documentHighlightProvider
    {
        ServerCapabilities_documentHighlightProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToDocumentHighlightOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_documentHighlightProvider"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_documentHighlightProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_documentHighlightProviderToAny(
        const ServerCapabilities_documentHighlightProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_documentHighlightProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_documentHighlightProviderType::DocumentHighlightOptions: {
            return documentHighlightOptionsToAny(value.documentHighlightOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_documentHighlightProviderType: " +
                 ServerCapabilities_documentHighlightProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToDocumentSymbolOptions(
        const LSPAny &any
    ) const -> DocumentSymbolOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentSymbolOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentSymbolOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentSymbolOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("label");
        if (iter_0 != object_0.end()) {
            value_0.label = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentSymbolOptionsToAny(
        const DocumentSymbolOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.label.has_value()) {
            const auto &label_0 = param.label.value();
            object_0.emplace(
                "label",
                std::make_unique<LSPAny>(stringToAny(label_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_documentSymbolProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_documentSymbolProvider
    {
        ServerCapabilities_documentSymbolProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToDocumentSymbolOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_documentSymbolProvider"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_documentSymbolProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_documentSymbolProviderToAny(
        const ServerCapabilities_documentSymbolProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_documentSymbolProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_documentSymbolProviderType::DocumentSymbolOptions: {
            return documentSymbolOptionsToAny(value.documentSymbolOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_documentSymbolProviderType: " +
                 ServerCapabilities_documentSymbolProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToCodeActionOptions(
        const LSPAny &any
    ) const -> CodeActionOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeActionOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeActionOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeActionOptions"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("codeActionKinds");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<CodeActionKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToCodeActionKind(*elem_0));
            }
            value_0.codeActionKinds = std::move(values_0);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::codeActionOptionsToAny(
        const CodeActionOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.codeActionKinds.has_value()) {
            const auto &codeActionKinds_0 = param.codeActionKinds.value();
            LSPArray array_0;
            array_0.reserve(codeActionKinds_0.size());
            for (const auto &elem_0 : codeActionKinds_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = codeActionKindToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("codeActionKinds", std::move(any_1));
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToServerCapabilities_codeActionProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_codeActionProvider
    {
        ServerCapabilities_codeActionProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToCodeActionOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_codeActionProvider"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_codeActionProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_codeActionProviderToAny(
        const ServerCapabilities_codeActionProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_codeActionProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_codeActionProviderType::CodeActionOptions: {
            return codeActionOptionsToAny(value.codeActionOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_codeActionProviderType: " +
                 ServerCapabilities_codeActionProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToWorkspaceSymbolOptions(
        const LSPAny &any
    ) const -> WorkspaceSymbolOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceSymbolOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceSymbolOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceSymbolOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workspaceSymbolOptionsToAny(
        const WorkspaceSymbolOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWorkspaceSymbolRegistrationOptions(
        const LSPAny &any
    ) const -> WorkspaceSymbolRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceSymbolRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceSymbolRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceSymbolRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workspaceSymbolRegistrationOptionsToAny(
        const WorkspaceSymbolRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_workspaceSymbolProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_workspaceSymbolProvider
    {
        ServerCapabilities_workspaceSymbolProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToWorkspaceSymbolOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_workspaceSymbolProvider"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_workspaceSymbolProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_workspaceSymbolProviderToAny(
        const ServerCapabilities_workspaceSymbolProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_workspaceSymbolProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_workspaceSymbolProviderType::WorkspaceSymbolOptions: {
            return workspaceSymbolOptionsToAny(value.workspaceSymbolOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_workspaceSymbolProviderType: " +
                 ServerCapabilities_workspaceSymbolProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToCodeLensOptions(
        const LSPAny &any
    ) const -> CodeLensOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeLensOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeLensOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeLensOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::codeLensOptionsToAny(
        const CodeLensOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentLinkOptions(
        const LSPAny &any
    ) const -> DocumentLinkOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentLinkOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentLinkOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentLinkOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentLinkOptionsToAny(
        const DocumentLinkOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentFormattingOptions(
        const LSPAny &any
    ) const -> DocumentFormattingOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentFormattingOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentFormattingOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentFormattingOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentFormattingOptionsToAny(
        const DocumentFormattingOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_documentFormattingProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_documentFormattingProvider
    {
        ServerCapabilities_documentFormattingProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToDocumentFormattingOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_documentFormattingProvider"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_documentFormattingProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_documentFormattingProviderToAny(
        const ServerCapabilities_documentFormattingProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_documentFormattingProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_documentFormattingProviderType::DocumentFormattingOptions: {
            return documentFormattingOptionsToAny(value.documentFormattingOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_documentFormattingProviderType: " +
                 ServerCapabilities_documentFormattingProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToDocumentRangeFormattingOptions(
        const LSPAny &any
    ) const -> DocumentRangeFormattingOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentRangeFormattingOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentRangeFormattingOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentRangeFormattingOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("rangesSupport");
        if (iter_0 != object_0.end()) {
            value_0.rangesSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentRangeFormattingOptionsToAny(
        const DocumentRangeFormattingOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.rangesSupport.has_value()) {
            const auto &rangesSupport_0 = param.rangesSupport.value();
            object_0.emplace(
                "rangesSupport",
                std::make_unique<LSPAny>(booleanToAny(rangesSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_documentRangeFormattingProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_documentRangeFormattingProvider
    {
        ServerCapabilities_documentRangeFormattingProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToDocumentRangeFormattingOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_documentRangeFormattingProvider"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_documentRangeFormattingProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_documentRangeFormattingProviderToAny(
        const ServerCapabilities_documentRangeFormattingProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_documentRangeFormattingProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_documentRangeFormattingProviderType::DocumentRangeFormattingOptions: {
            return documentRangeFormattingOptionsToAny(value.documentRangeFormattingOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_documentRangeFormattingProviderType: " +
                 ServerCapabilities_documentRangeFormattingProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToRenameOptions(
        const LSPAny &any
    ) const -> RenameOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "RenameOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        RenameOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "RenameOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("prepareProvider");
        if (iter_0 != object_0.end()) {
            value_0.prepareProvider = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::renameOptionsToAny(
        const RenameOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.prepareProvider.has_value()) {
            const auto &prepareProvider_0 = param.prepareProvider.value();
            object_0.emplace(
                "prepareProvider",
                std::make_unique<LSPAny>(booleanToAny(prepareProvider_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_renameProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_renameProvider
    {
        ServerCapabilities_renameProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToRenameOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_renameProvider"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_renameProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_renameProviderToAny(
        const ServerCapabilities_renameProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_renameProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_renameProviderType::RenameOptions: {
            return renameOptionsToAny(value.renameOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_renameProviderType: " +
                 ServerCapabilities_renameProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToExecuteCommandOptions(
        const LSPAny &any
    ) const -> ExecuteCommandOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "ExecuteCommandOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ExecuteCommandOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "ExecuteCommandOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("commands");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.commands = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ExecuteCommandOptions attribute: commands"
            );
        }

        return value_0;
    }

    auto LspTransformer::executeCommandOptionsToAny(
        const ExecuteCommandOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPArray array_0;
        array_0.reserve(param.commands.size());
        for (const auto &elem_0 : param.commands) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("commands", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToExecuteCommandRegistrationOptions(
        const LSPAny &any
    ) const -> ExecuteCommandRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "ExecuteCommandRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ExecuteCommandRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "ExecuteCommandRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("commands");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.commands = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ExecuteCommandRegistrationOptions attribute: commands"
            );
        }

        return value_0;
    }

    auto LspTransformer::executeCommandRegistrationOptionsToAny(
        const ExecuteCommandRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPArray array_0;
        array_0.reserve(param.commands.size());
        for (const auto &elem_0 : param.commands) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("commands", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToCreateFileOptions(
        const LSPAny &any
    ) const -> CreateFileOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CreateFileOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CreateFileOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CreateFileOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("overwrite");
        if (iter_0 != object_0.end()) {
            value_0.overwrite = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("ignoreIfExists");
        if (iter_0 != object_0.end()) {
            value_0.ignoreIfExists = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::createFileOptionsToAny(
        const CreateFileOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.overwrite.has_value()) {
            const auto &overwrite_0 = param.overwrite.value();
            object_0.emplace(
                "overwrite",
                std::make_unique<LSPAny>(booleanToAny(overwrite_0))
            );
        }

        if (param.ignoreIfExists.has_value()) {
            const auto &ignoreIfExists_0 = param.ignoreIfExists.value();
            object_0.emplace(
                "ignoreIfExists",
                std::make_unique<LSPAny>(booleanToAny(ignoreIfExists_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCreateFile(const LSPAny &any) const -> CreateFile
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CreateFile"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CreateFile value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CreateFile"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CreateFile attribute: kind"
            );
        }

        iter_0 = object_0.find("annotationId");
        if (iter_0 != object_0.end()) {
            value_0.annotationId =
                anyToChangeAnnotationIdentifier(*iter_0->second);
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            const auto &value_1 = anyToString(*iter_0->second);
            if (value_1 != "create") {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("String value for "
                     "CreateFile.kind"
                     " must be \"create\""
                     " but was: \"value_1\"")
                );
            }
            value_0.kind = value_1;
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CreateFile attribute: kind"
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToDocumentUri(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CreateFile attribute: uri"
            );
        }

        iter_0 = object_0.find("options");
        if (iter_0 != object_0.end()) {
            value_0.options = anyToCreateFileOptions(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::createFileToAny(
        const CreateFile &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        if (param.annotationId.has_value()) {
            const auto &annotationId_0 = param.annotationId.value();
            object_0.emplace(
                "annotationId",
                std::make_unique<LSPAny>(changeAnnotationIdentifierToAny(annotationId_0))
            );
        }

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        object_0.emplace(
            "uri",
            std::make_unique<LSPAny>(documentUriToAny(param.uri))
        );

        if (param.options.has_value()) {
            const auto &options_0 = param.options.value();
            object_0.emplace(
                "options",
                std::make_unique<LSPAny>(createFileOptionsToAny(options_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToRenameFileOptions(
        const LSPAny &any
    ) const -> RenameFileOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "RenameFileOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        RenameFileOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "RenameFileOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("overwrite");
        if (iter_0 != object_0.end()) {
            value_0.overwrite = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("ignoreIfExists");
        if (iter_0 != object_0.end()) {
            value_0.ignoreIfExists = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::renameFileOptionsToAny(
        const RenameFileOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.overwrite.has_value()) {
            const auto &overwrite_0 = param.overwrite.value();
            object_0.emplace(
                "overwrite",
                std::make_unique<LSPAny>(booleanToAny(overwrite_0))
            );
        }

        if (param.ignoreIfExists.has_value()) {
            const auto &ignoreIfExists_0 = param.ignoreIfExists.value();
            object_0.emplace(
                "ignoreIfExists",
                std::make_unique<LSPAny>(booleanToAny(ignoreIfExists_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToRenameFile(const LSPAny &any) const -> RenameFile
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "RenameFile"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        RenameFile value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 6) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "RenameFile"
                 ": " + std::to_string(object_0.size()) + " > 6")
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required RenameFile attribute: kind"
            );
        }

        iter_0 = object_0.find("annotationId");
        if (iter_0 != object_0.end()) {
            value_0.annotationId =
                anyToChangeAnnotationIdentifier(*iter_0->second);
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            const auto &value_1 = anyToString(*iter_0->second);
            if (value_1 != "rename") {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("String value for "
                     "RenameFile.kind"
                     " must be \"rename\""
                     " but was: \"value_1\"")
                );
            }
            value_0.kind = value_1;
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required RenameFile attribute: kind"
            );
        }

        iter_0 = object_0.find("oldUri");
        if (iter_0 != object_0.end()) {
            value_0.oldUri = anyToDocumentUri(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required RenameFile attribute: oldUri"
            );
        }

        iter_0 = object_0.find("newUri");
        if (iter_0 != object_0.end()) {
            value_0.newUri = anyToDocumentUri(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required RenameFile attribute: newUri"
            );
        }

        iter_0 = object_0.find("options");
        if (iter_0 != object_0.end()) {
            value_0.options = anyToRenameFileOptions(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::renameFileToAny(
        const RenameFile &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        if (param.annotationId.has_value()) {
            const auto &annotationId_0 = param.annotationId.value();
            object_0.emplace(
                "annotationId",
                std::make_unique<LSPAny>(changeAnnotationIdentifierToAny(annotationId_0))
            );
        }

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        object_0.emplace(
            "oldUri",
            std::make_unique<LSPAny>(documentUriToAny(param.oldUri))
        );

        object_0.emplace(
            "newUri",
            std::make_unique<LSPAny>(documentUriToAny(param.newUri))
        );

        if (param.options.has_value()) {
            const auto &options_0 = param.options.value();
            object_0.emplace(
                "options",
                std::make_unique<LSPAny>(renameFileOptionsToAny(options_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDeleteFileOptions(
        const LSPAny &any
    ) const -> DeleteFileOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DeleteFileOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DeleteFileOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DeleteFileOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("recursive");
        if (iter_0 != object_0.end()) {
            value_0.recursive = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("ignoreIfNotExists");
        if (iter_0 != object_0.end()) {
            value_0.ignoreIfNotExists = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::deleteFileOptionsToAny(
        const DeleteFileOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.recursive.has_value()) {
            const auto &recursive_0 = param.recursive.value();
            object_0.emplace(
                "recursive",
                std::make_unique<LSPAny>(booleanToAny(recursive_0))
            );
        }

        if (param.ignoreIfNotExists.has_value()) {
            const auto &ignoreIfNotExists_0 = param.ignoreIfNotExists.value();
            object_0.emplace(
                "ignoreIfNotExists",
                std::make_unique<LSPAny>(booleanToAny(ignoreIfNotExists_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDeleteFile(const LSPAny &any) const -> DeleteFile
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DeleteFile"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DeleteFile value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DeleteFile"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DeleteFile attribute: kind"
            );
        }

        iter_0 = object_0.find("annotationId");
        if (iter_0 != object_0.end()) {
            value_0.annotationId =
                anyToChangeAnnotationIdentifier(*iter_0->second);
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            const auto &value_1 = anyToString(*iter_0->second);
            if (value_1 != "delete") {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("String value for "
                     "DeleteFile.kind"
                     " must be \"delete\""
                     " but was: \"value_1\"")
                );
            }
            value_0.kind = value_1;
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DeleteFile attribute: kind"
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToDocumentUri(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DeleteFile attribute: uri"
            );
        }

        iter_0 = object_0.find("options");
        if (iter_0 != object_0.end()) {
            value_0.options = anyToDeleteFileOptions(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::deleteFileToAny(
        const DeleteFile &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        if (param.annotationId.has_value()) {
            const auto &annotationId_0 = param.annotationId.value();
            object_0.emplace(
                "annotationId",
                std::make_unique<LSPAny>(changeAnnotationIdentifierToAny(annotationId_0))
            );
        }

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        object_0.emplace(
            "uri",
            std::make_unique<LSPAny>(documentUriToAny(param.uri))
        );

        if (param.options.has_value()) {
            const auto &options_0 = param.options.value();
            object_0.emplace(
                "options",
                std::make_unique<LSPAny>(deleteFileOptionsToAny(options_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentSyncOptions_save(
        const LSPAny &any
    ) const -> TextDocumentSyncOptions_save
    {
        TextDocumentSyncOptions_save value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToSaveOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to TextDocumentSyncOptions_save"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "TextDocumentSyncOptions_save"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::textDocumentSyncOptions_saveToAny(
        const TextDocumentSyncOptions_save &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case TextDocumentSyncOptions_saveType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case TextDocumentSyncOptions_saveType::SaveOptions: {
            return saveOptionsToAny(value.saveOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported TextDocumentSyncOptions_saveType: " +
                 TextDocumentSyncOptions_saveTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToTextDocumentSyncOptions(
        const LSPAny &any
    ) const -> TextDocumentSyncOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentSyncOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentSyncOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentSyncOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("openClose");
        if (iter_0 != object_0.end()) {
            value_0.openClose = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("change");
        if (iter_0 != object_0.end()) {
            value_0.change = anyToTextDocumentSyncKind(*iter_0->second);
        }

        iter_0 = object_0.find("willSave");
        if (iter_0 != object_0.end()) {
            value_0.willSave = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("willSaveWaitUntil");
        if (iter_0 != object_0.end()) {
            value_0.willSaveWaitUntil = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("save");
        if (iter_0 != object_0.end()) {
            value_0.save = anyToTextDocumentSyncOptions_save(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::textDocumentSyncOptionsToAny(
        const TextDocumentSyncOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.openClose.has_value()) {
            const auto &openClose_0 = param.openClose.value();
            object_0.emplace(
                "openClose",
                std::make_unique<LSPAny>(booleanToAny(openClose_0))
            );
        }

        if (param.change.has_value()) {
            const auto &change_0 = param.change.value();
            object_0.emplace(
                "change",
                std::make_unique<LSPAny>(textDocumentSyncKindToAny(change_0))
            );
        }

        if (param.willSave.has_value()) {
            const auto &willSave_0 = param.willSave.value();
            object_0.emplace(
                "willSave",
                std::make_unique<LSPAny>(booleanToAny(willSave_0))
            );
        }

        if (param.willSaveWaitUntil.has_value()) {
            const auto &willSaveWaitUntil_0 = param.willSaveWaitUntil.value();
            object_0.emplace(
                "willSaveWaitUntil",
                std::make_unique<LSPAny>(booleanToAny(willSaveWaitUntil_0))
            );
        }

        if (param.save.has_value()) {
            const auto &save_0 = param.save.value();
            object_0.emplace(
                "save",
                std::make_unique<LSPAny>(textDocumentSyncOptions_saveToAny(save_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_textDocumentSync(
        const LSPAny &any
    ) const -> ServerCapabilities_textDocumentSync
    {
        ServerCapabilities_textDocumentSync value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToTextDocumentSyncOptions(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to ServerCapabilities_textDocumentSync"
                );
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_textDocumentSync"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_textDocumentSyncToAny(
        const ServerCapabilities_textDocumentSync &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_textDocumentSyncType::TextDocumentSyncOptions: {
            return textDocumentSyncOptionsToAny(value.textDocumentSyncOptions());
        }
        case ServerCapabilities_textDocumentSyncType::TextDocumentSyncKind: {
            return textDocumentSyncKindToAny(value.textDocumentSyncKind());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_textDocumentSyncType: " +
                 ServerCapabilities_textDocumentSyncTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToNotebookDocumentSyncOptions(
        const LSPAny &any
    ) const -> NotebookDocumentSyncOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentSyncOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentSyncOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentSyncOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("notebookSelector");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<NotebookDocumentSyncOptions_notebookSelector_elem> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(
                    anyToNotebookDocumentSyncOptions_notebookSelector_elem(*elem_0)
                );
            }
            value_0.notebookSelector = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookDocumentSyncOptions attribute: notebookSelector"
            );
        }

        iter_0 = object_0.find("save");
        if (iter_0 != object_0.end()) {
            value_0.save = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentSyncOptionsToAny(
        const NotebookDocumentSyncOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.notebookSelector.size());
        for (const auto &elem_0 : param.notebookSelector) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) =
                notebookDocumentSyncOptions_notebookSelector_elemToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("notebookSelector", std::move(any_1));

        if (param.save.has_value()) {
            const auto &save_0 = param.save.value();
            object_0.emplace(
                "save",
                std::make_unique<LSPAny>(booleanToAny(save_0))
            );
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToNotebookDocumentSyncRegistrationOptions(
        const LSPAny &any
    ) const -> NotebookDocumentSyncRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentSyncRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentSyncRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentSyncRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("notebookSelector");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<NotebookDocumentSyncOptions_notebookSelector_elem> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(
                    anyToNotebookDocumentSyncOptions_notebookSelector_elem(*elem_0)
                );
            }
            value_0.notebookSelector = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookDocumentSyncRegistrationOptions attribute: notebookSelector"
            );
        }

        iter_0 = object_0.find("save");
        if (iter_0 != object_0.end()) {
            value_0.save = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentSyncRegistrationOptionsToAny(
        const NotebookDocumentSyncRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.notebookSelector.size());
        for (const auto &elem_0 : param.notebookSelector) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) =
                notebookDocumentSyncOptions_notebookSelector_elemToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("notebookSelector", std::move(any_1));

        if (param.save.has_value()) {
            const auto &save_0 = param.save.value();
            object_0.emplace(
                "save",
                std::make_unique<LSPAny>(booleanToAny(save_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToServerCapabilities_notebookDocumentSync(
        const LSPAny &any
    ) const -> ServerCapabilities_notebookDocumentSync
    {
        ServerCapabilities_notebookDocumentSync value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToNotebookDocumentSyncOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 =
                        anyToNotebookDocumentSyncRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_notebookDocumentSync"
                    );
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_notebookDocumentSync"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_notebookDocumentSyncToAny(
        const ServerCapabilities_notebookDocumentSync &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncOptions: {
            return notebookDocumentSyncOptionsToAny(value.notebookDocumentSyncOptions());
        }
        case ServerCapabilities_notebookDocumentSyncType::NotebookDocumentSyncRegistrationOptions: {
            return notebookDocumentSyncRegistrationOptionsToAny(value.notebookDocumentSyncRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_notebookDocumentSyncType: " +
                 ServerCapabilities_notebookDocumentSyncTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToWorkspaceFoldersServerCapabilities_changeNotifications(
        const LSPAny &any
    ) const -> WorkspaceFoldersServerCapabilities_changeNotifications
    {
        WorkspaceFoldersServerCapabilities_changeNotifications value_0;

        switch (any.type()) {
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "WorkspaceFoldersServerCapabilities_changeNotifications"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::workspaceFoldersServerCapabilities_changeNotificationsToAny(
        const WorkspaceFoldersServerCapabilities_changeNotifications &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case WorkspaceFoldersServerCapabilities_changeNotificationsType::String: {
            return stringToAny(value.string());
        }
        case WorkspaceFoldersServerCapabilities_changeNotificationsType::Boolean: {
            return booleanToAny(value.boolean());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported WorkspaceFoldersServerCapabilities_changeNotificationsType: " +
                 WorkspaceFoldersServerCapabilities_changeNotificationsTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToWorkspaceFoldersServerCapabilities(
        const LSPAny &any
    ) const -> WorkspaceFoldersServerCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceFoldersServerCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceFoldersServerCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceFoldersServerCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("supported");
        if (iter_0 != object_0.end()) {
            value_0.supported = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("changeNotifications");
        if (iter_0 != object_0.end()) {
            value_0.changeNotifications =
                anyToWorkspaceFoldersServerCapabilities_changeNotifications(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workspaceFoldersServerCapabilitiesToAny(
        const WorkspaceFoldersServerCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.supported.has_value()) {
            const auto &supported_0 = param.supported.value();
            object_0.emplace(
                "supported",
                std::make_unique<LSPAny>(booleanToAny(supported_0))
            );
        }

        if (param.changeNotifications.has_value()) {
            const auto &changeNotifications_0 =
                param.changeNotifications.value();
            object_0.emplace(
                "changeNotifications",
                std::make_unique<LSPAny>(workspaceFoldersServerCapabilities_changeNotificationsToAny(changeNotifications_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToFileOperationPatternOptions(
        const LSPAny &any
    ) const -> FileOperationPatternOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FileOperationPatternOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FileOperationPatternOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FileOperationPatternOptions"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("ignoreCase");
        if (iter_0 != object_0.end()) {
            value_0.ignoreCase = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::fileOperationPatternOptionsToAny(
        const FileOperationPatternOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.ignoreCase.has_value()) {
            const auto &ignoreCase_0 = param.ignoreCase.value();
            object_0.emplace(
                "ignoreCase",
                std::make_unique<LSPAny>(booleanToAny(ignoreCase_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToFileOperationPattern(
        const LSPAny &any
    ) const -> FileOperationPattern
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FileOperationPattern"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FileOperationPattern value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FileOperationPattern"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("glob");
        if (iter_0 != object_0.end()) {
            value_0.glob = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FileOperationPattern attribute: glob"
            );
        }

        iter_0 = object_0.find("matches");
        if (iter_0 != object_0.end()) {
            value_0.matches = anyToFileOperationPatternKind(*iter_0->second);
        }

        iter_0 = object_0.find("options");
        if (iter_0 != object_0.end()) {
            value_0.options =
                anyToFileOperationPatternOptions(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::fileOperationPatternToAny(
        const FileOperationPattern &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "glob",
            std::make_unique<LSPAny>(stringToAny(param.glob))
        );

        if (param.matches.has_value()) {
            const auto &matches_0 = param.matches.value();
            object_0.emplace(
                "matches",
                std::make_unique<LSPAny>(fileOperationPatternKindToAny(matches_0))
            );
        }

        if (param.options.has_value()) {
            const auto &options_0 = param.options.value();
            object_0.emplace(
                "options",
                std::make_unique<LSPAny>(fileOperationPatternOptionsToAny(options_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToFileOperationFilter(
        const LSPAny &any
    ) const -> FileOperationFilter
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FileOperationFilter"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FileOperationFilter value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FileOperationFilter"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("scheme");
        if (iter_0 != object_0.end()) {
            value_0.scheme = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("pattern");
        if (iter_0 != object_0.end()) {
            value_0.pattern = anyToFileOperationPattern(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FileOperationFilter attribute: pattern"
            );
        }

        return value_0;
    }

    auto LspTransformer::fileOperationFilterToAny(
        const FileOperationFilter &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.scheme.has_value()) {
            const auto &scheme_0 = param.scheme.value();
            object_0.emplace(
                "scheme",
                std::make_unique<LSPAny>(stringToAny(scheme_0))
            );
        }

        object_0.emplace(
            "pattern",
            std::make_unique<LSPAny>(fileOperationPatternToAny(param.pattern))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToFileOperationRegistrationOptions(
        const LSPAny &any
    ) const -> FileOperationRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FileOperationRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FileOperationRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FileOperationRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("filters");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<FileOperationFilter> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToFileOperationFilter(*elem_0));
            }
            value_0.filters = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FileOperationRegistrationOptions attribute: filters"
            );
        }

        return value_0;
    }

    auto LspTransformer::fileOperationRegistrationOptionsToAny(
        const FileOperationRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.filters.size());
        for (const auto &elem_0 : param.filters) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileOperationFilterToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("filters", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::fileOperationRegistrationOptions_filtersToAny(
        const FileOperationRegistrationOptions_filters &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = fileOperationFilterToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToFileOperationRegistrationOptions_filters(
        const LSPAny &any
    ) const -> FileOperationRegistrationOptions_filters
    {
        const auto &array_0 = any.array();
        std::vector<FileOperationFilter> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToFileOperationFilter(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToFileOperationOptions(
        const LSPAny &any
    ) const -> FileOperationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FileOperationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FileOperationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 6) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FileOperationOptions"
                 ": " + std::to_string(object_0.size()) + " > 6")
            );
        }

        iter_0 = object_0.find("didCreate");
        if (iter_0 != object_0.end()) {
            value_0.didCreate =
                anyToFileOperationRegistrationOptions(*iter_0->second);
        }

        iter_0 = object_0.find("willCreate");
        if (iter_0 != object_0.end()) {
            value_0.willCreate =
                anyToFileOperationRegistrationOptions(*iter_0->second);
        }

        iter_0 = object_0.find("didRename");
        if (iter_0 != object_0.end()) {
            value_0.didRename =
                anyToFileOperationRegistrationOptions(*iter_0->second);
        }

        iter_0 = object_0.find("willRename");
        if (iter_0 != object_0.end()) {
            value_0.willRename =
                anyToFileOperationRegistrationOptions(*iter_0->second);
        }

        iter_0 = object_0.find("didDelete");
        if (iter_0 != object_0.end()) {
            value_0.didDelete =
                anyToFileOperationRegistrationOptions(*iter_0->second);
        }

        iter_0 = object_0.find("willDelete");
        if (iter_0 != object_0.end()) {
            value_0.willDelete =
                anyToFileOperationRegistrationOptions(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::fileOperationOptionsToAny(
        const FileOperationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.didCreate.has_value()) {
            const auto &didCreate_0 = param.didCreate.value();
            object_0.emplace(
                "didCreate",
                std::make_unique<LSPAny>(fileOperationRegistrationOptionsToAny(didCreate_0))
            );
        }

        if (param.willCreate.has_value()) {
            const auto &willCreate_0 = param.willCreate.value();
            object_0.emplace(
                "willCreate",
                std::make_unique<LSPAny>(fileOperationRegistrationOptionsToAny(willCreate_0))
            );
        }

        if (param.didRename.has_value()) {
            const auto &didRename_0 = param.didRename.value();
            object_0.emplace(
                "didRename",
                std::make_unique<LSPAny>(fileOperationRegistrationOptionsToAny(didRename_0))
            );
        }

        if (param.willRename.has_value()) {
            const auto &willRename_0 = param.willRename.value();
            object_0.emplace(
                "willRename",
                std::make_unique<LSPAny>(fileOperationRegistrationOptionsToAny(willRename_0))
            );
        }

        if (param.didDelete.has_value()) {
            const auto &didDelete_0 = param.didDelete.value();
            object_0.emplace(
                "didDelete",
                std::make_unique<LSPAny>(fileOperationRegistrationOptionsToAny(didDelete_0))
            );
        }

        if (param.willDelete.has_value()) {
            const auto &willDelete_0 = param.willDelete.value();
            object_0.emplace(
                "willDelete",
                std::make_unique<LSPAny>(fileOperationRegistrationOptionsToAny(willDelete_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_workspace(
        const LSPAny &any
    ) const -> ServerCapabilities_workspace
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ServerCapabilities_workspace"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ServerCapabilities_workspace value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ServerCapabilities_workspace"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("workspaceFolders");
        if (iter_0 != object_0.end()) {
            value_0.workspaceFolders =
                anyToWorkspaceFoldersServerCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("fileOperations");
        if (iter_0 != object_0.end()) {
            value_0.fileOperations =
                anyToFileOperationOptions(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_workspaceToAny(
        const ServerCapabilities_workspace &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workspaceFolders.has_value()) {
            const auto &workspaceFolders_0 = param.workspaceFolders.value();
            object_0.emplace(
                "workspaceFolders",
                std::make_unique<LSPAny>(workspaceFoldersServerCapabilitiesToAny(workspaceFolders_0))
            );
        }

        if (param.fileOperations.has_value()) {
            const auto &fileOperations_0 = param.fileOperations.value();
            object_0.emplace(
                "fileOperations",
                std::make_unique<LSPAny>(fileOperationOptionsToAny(fileOperations_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToGeneralClientCapabilities_staleRequestSupport(
        const LSPAny &any
    ) const -> GeneralClientCapabilities_staleRequestSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "GeneralClientCapabilities_staleRequestSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        GeneralClientCapabilities_staleRequestSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "GeneralClientCapabilities_staleRequestSupport"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("cancel");
        if (iter_0 != object_0.end()) {
            value_0.cancel = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required GeneralClientCapabilities_staleRequestSupport attribute: cancel"
            );
        }

        iter_0 = object_0.find("retryOnContentModified");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.retryOnContentModified = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required GeneralClientCapabilities_staleRequestSupport attribute: retryOnContentModified"
            );
        }

        return value_0;
    }

    auto LspTransformer::generalClientCapabilities_staleRequestSupportToAny(
        const GeneralClientCapabilities_staleRequestSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "cancel",
            std::make_unique<LSPAny>(booleanToAny(param.cancel))
        );

        LSPArray array_0;
        array_0.reserve(param.retryOnContentModified.size());
        for (const auto &elem_0 : param.retryOnContentModified) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = stringToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("retryOnContentModified", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToGeneralClientCapabilities(
        const LSPAny &any
    ) const -> GeneralClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "GeneralClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        GeneralClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "GeneralClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("staleRequestSupport");
        if (iter_0 != object_0.end()) {
            value_0.staleRequestSupport =
                anyToGeneralClientCapabilities_staleRequestSupport(*iter_0->second);
        }

        iter_0 = object_0.find("regularExpressions");
        if (iter_0 != object_0.end()) {
            value_0.regularExpressions =
                anyToRegularExpressionsClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("markdown");
        if (iter_0 != object_0.end()) {
            value_0.markdown =
                anyToMarkdownClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("positionEncodings");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<PositionEncodingKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToPositionEncodingKind(*elem_0));
            }
            value_0.positionEncodings = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::generalClientCapabilitiesToAny(
        const GeneralClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.staleRequestSupport.has_value()) {
            const auto &staleRequestSupport_0 =
                param.staleRequestSupport.value();
            object_0.emplace(
                "staleRequestSupport",
                std::make_unique<LSPAny>(generalClientCapabilities_staleRequestSupportToAny(staleRequestSupport_0))
            );
        }

        if (param.regularExpressions.has_value()) {
            const auto &regularExpressions_0 =
                param.regularExpressions.value();
            object_0.emplace(
                "regularExpressions",
                std::make_unique<LSPAny>(regularExpressionsClientCapabilitiesToAny(regularExpressions_0))
            );
        }

        if (param.markdown.has_value()) {
            const auto &markdown_0 = param.markdown.value();
            object_0.emplace(
                "markdown",
                std::make_unique<LSPAny>(markdownClientCapabilitiesToAny(markdown_0))
            );
        }

        if (param.positionEncodings.has_value()) {
            const auto &positionEncodings_0 = param.positionEncodings.value();
            LSPArray array_0;
            array_0.reserve(positionEncodings_0.size());
            for (const auto &elem_0 : positionEncodings_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = positionEncodingKindToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("positionEncodings", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToWorkspaceEditClientCapabilities_changeAnnotationSupport(
        const LSPAny &any
    ) const -> WorkspaceEditClientCapabilities_changeAnnotationSupport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceEditClientCapabilities_changeAnnotationSupport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceEditClientCapabilities_changeAnnotationSupport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceEditClientCapabilities_changeAnnotationSupport"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("groupsOnLabel");
        if (iter_0 != object_0.end()) {
            value_0.groupsOnLabel = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workspaceEditClientCapabilities_changeAnnotationSupportToAny(
        const WorkspaceEditClientCapabilities_changeAnnotationSupport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.groupsOnLabel.has_value()) {
            const auto &groupsOnLabel_0 = param.groupsOnLabel.value();
            object_0.emplace(
                "groupsOnLabel",
                std::make_unique<LSPAny>(booleanToAny(groupsOnLabel_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWorkspaceEditClientCapabilities(
        const LSPAny &any
    ) const -> WorkspaceEditClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceEditClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceEditClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceEditClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("documentChanges");
        if (iter_0 != object_0.end()) {
            value_0.documentChanges = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resourceOperations");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<ResourceOperationKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToResourceOperationKind(*elem_0));
            }
            value_0.resourceOperations = std::move(values_0);
        }

        iter_0 = object_0.find("failureHandling");
        if (iter_0 != object_0.end()) {
            value_0.failureHandling =
                anyToFailureHandlingKind(*iter_0->second);
        }

        iter_0 = object_0.find("normalizesLineEndings");
        if (iter_0 != object_0.end()) {
            value_0.normalizesLineEndings = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("changeAnnotationSupport");
        if (iter_0 != object_0.end()) {
            value_0.changeAnnotationSupport =
                anyToWorkspaceEditClientCapabilities_changeAnnotationSupport(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workspaceEditClientCapabilitiesToAny(
        const WorkspaceEditClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.documentChanges.has_value()) {
            const auto &documentChanges_0 = param.documentChanges.value();
            object_0.emplace(
                "documentChanges",
                std::make_unique<LSPAny>(booleanToAny(documentChanges_0))
            );
        }

        if (param.resourceOperations.has_value()) {
            const auto &resourceOperations_0 =
                param.resourceOperations.value();
            LSPArray array_0;
            array_0.reserve(resourceOperations_0.size());
            for (const auto &elem_0 : resourceOperations_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = resourceOperationKindToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("resourceOperations", std::move(any_1));
        }

        if (param.failureHandling.has_value()) {
            const auto &failureHandling_0 = param.failureHandling.value();
            object_0.emplace(
                "failureHandling",
                std::make_unique<LSPAny>(failureHandlingKindToAny(failureHandling_0))
            );
        }

        if (param.normalizesLineEndings.has_value()) {
            const auto &normalizesLineEndings_0 =
                param.normalizesLineEndings.value();
            object_0.emplace(
                "normalizesLineEndings",
                std::make_unique<LSPAny>(booleanToAny(normalizesLineEndings_0))
            );
        }

        if (param.changeAnnotationSupport.has_value()) {
            const auto &changeAnnotationSupport_0 =
                param.changeAnnotationSupport.value();
            object_0.emplace(
                "changeAnnotationSupport",
                std::make_unique<LSPAny>(workspaceEditClientCapabilities_changeAnnotationSupportToAny(changeAnnotationSupport_0))
            );
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToDidChangeConfigurationClientCapabilities(
        const LSPAny &any
    ) const -> DidChangeConfigurationClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DidChangeConfigurationClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DidChangeConfigurationClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DidChangeConfigurationClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::didChangeConfigurationClientCapabilitiesToAny(
        const DidChangeConfigurationClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDidChangeWatchedFilesClientCapabilities(
        const LSPAny &any
    ) const -> DidChangeWatchedFilesClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DidChangeWatchedFilesClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DidChangeWatchedFilesClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DidChangeWatchedFilesClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("relativePatternSupport");
        if (iter_0 != object_0.end()) {
            value_0.relativePatternSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::didChangeWatchedFilesClientCapabilitiesToAny(
        const DidChangeWatchedFilesClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.relativePatternSupport.has_value()) {
            const auto &relativePatternSupport_0 =
                param.relativePatternSupport.value();
            object_0.emplace(
                "relativePatternSupport",
                std::make_unique<LSPAny>(booleanToAny(relativePatternSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWorkspaceSymbolClientCapabilities(
        const LSPAny &any
    ) const -> WorkspaceSymbolClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceSymbolClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceSymbolClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceSymbolClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("symbolKind");
        if (iter_0 != object_0.end()) {
            value_0.symbolKind =
                anyToWorkspaceSymbolClientCapabilities_symbolKind(*iter_0->second);
        }

        iter_0 = object_0.find("tagSupport");
        if (iter_0 != object_0.end()) {
            value_0.tagSupport =
                anyToWorkspaceSymbolClientCapabilities_tagSupport(*iter_0->second);
        }

        iter_0 = object_0.find("resolveSupport");
        if (iter_0 != object_0.end()) {
            value_0.resolveSupport =
                anyToWorkspaceSymbolClientCapabilities_resolveSupport(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workspaceSymbolClientCapabilitiesToAny(
        const WorkspaceSymbolClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.symbolKind.has_value()) {
            const auto &symbolKind_0 = param.symbolKind.value();
            object_0.emplace(
                "symbolKind",
                std::make_unique<LSPAny>(workspaceSymbolClientCapabilities_symbolKindToAny(symbolKind_0))
            );
        }

        if (param.tagSupport.has_value()) {
            const auto &tagSupport_0 = param.tagSupport.value();
            object_0.emplace(
                "tagSupport",
                std::make_unique<LSPAny>(workspaceSymbolClientCapabilities_tagSupportToAny(tagSupport_0))
            );
        }

        if (param.resolveSupport.has_value()) {
            const auto &resolveSupport_0 = param.resolveSupport.value();
            object_0.emplace(
                "resolveSupport",
                std::make_unique<LSPAny>(workspaceSymbolClientCapabilities_resolveSupportToAny(resolveSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToExecuteCommandClientCapabilities(
        const LSPAny &any
    ) const -> ExecuteCommandClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "ExecuteCommandClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ExecuteCommandClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "ExecuteCommandClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::executeCommandClientCapabilitiesToAny(
        const ExecuteCommandClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSemanticTokensWorkspaceClientCapabilities(
        const LSPAny &any
    ) const -> SemanticTokensWorkspaceClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SemanticTokensWorkspaceClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SemanticTokensWorkspaceClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SemanticTokensWorkspaceClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("refreshSupport");
        if (iter_0 != object_0.end()) {
            value_0.refreshSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::semanticTokensWorkspaceClientCapabilitiesToAny(
        const SemanticTokensWorkspaceClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.refreshSupport.has_value()) {
            const auto &refreshSupport_0 = param.refreshSupport.value();
            object_0.emplace(
                "refreshSupport",
                std::make_unique<LSPAny>(booleanToAny(refreshSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCodeLensWorkspaceClientCapabilities(
        const LSPAny &any
    ) const -> CodeLensWorkspaceClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeLensWorkspaceClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeLensWorkspaceClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeLensWorkspaceClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("refreshSupport");
        if (iter_0 != object_0.end()) {
            value_0.refreshSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::codeLensWorkspaceClientCapabilitiesToAny(
        const CodeLensWorkspaceClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.refreshSupport.has_value()) {
            const auto &refreshSupport_0 = param.refreshSupport.value();
            object_0.emplace(
                "refreshSupport",
                std::make_unique<LSPAny>(booleanToAny(refreshSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToFileOperationClientCapabilities(
        const LSPAny &any
    ) const -> FileOperationClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FileOperationClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FileOperationClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 7) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FileOperationClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 7")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("didCreate");
        if (iter_0 != object_0.end()) {
            value_0.didCreate = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("willCreate");
        if (iter_0 != object_0.end()) {
            value_0.willCreate = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("didRename");
        if (iter_0 != object_0.end()) {
            value_0.didRename = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("willRename");
        if (iter_0 != object_0.end()) {
            value_0.willRename = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("didDelete");
        if (iter_0 != object_0.end()) {
            value_0.didDelete = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("willDelete");
        if (iter_0 != object_0.end()) {
            value_0.willDelete = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::fileOperationClientCapabilitiesToAny(
        const FileOperationClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.didCreate.has_value()) {
            const auto &didCreate_0 = param.didCreate.value();
            object_0.emplace(
                "didCreate",
                std::make_unique<LSPAny>(booleanToAny(didCreate_0))
            );
        }

        if (param.willCreate.has_value()) {
            const auto &willCreate_0 = param.willCreate.value();
            object_0.emplace(
                "willCreate",
                std::make_unique<LSPAny>(booleanToAny(willCreate_0))
            );
        }

        if (param.didRename.has_value()) {
            const auto &didRename_0 = param.didRename.value();
            object_0.emplace(
                "didRename",
                std::make_unique<LSPAny>(booleanToAny(didRename_0))
            );
        }

        if (param.willRename.has_value()) {
            const auto &willRename_0 = param.willRename.value();
            object_0.emplace(
                "willRename",
                std::make_unique<LSPAny>(booleanToAny(willRename_0))
            );
        }

        if (param.didDelete.has_value()) {
            const auto &didDelete_0 = param.didDelete.value();
            object_0.emplace(
                "didDelete",
                std::make_unique<LSPAny>(booleanToAny(didDelete_0))
            );
        }

        if (param.willDelete.has_value()) {
            const auto &willDelete_0 = param.willDelete.value();
            object_0.emplace(
                "willDelete",
                std::make_unique<LSPAny>(booleanToAny(willDelete_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlineValueWorkspaceClientCapabilities(
        const LSPAny &any
    ) const -> InlineValueWorkspaceClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlineValueWorkspaceClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlineValueWorkspaceClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlineValueWorkspaceClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("refreshSupport");
        if (iter_0 != object_0.end()) {
            value_0.refreshSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlineValueWorkspaceClientCapabilitiesToAny(
        const InlineValueWorkspaceClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.refreshSupport.has_value()) {
            const auto &refreshSupport_0 = param.refreshSupport.value();
            object_0.emplace(
                "refreshSupport",
                std::make_unique<LSPAny>(booleanToAny(refreshSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlayHintWorkspaceClientCapabilities(
        const LSPAny &any
    ) const -> InlayHintWorkspaceClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlayHintWorkspaceClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlayHintWorkspaceClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlayHintWorkspaceClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("refreshSupport");
        if (iter_0 != object_0.end()) {
            value_0.refreshSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlayHintWorkspaceClientCapabilitiesToAny(
        const InlayHintWorkspaceClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.refreshSupport.has_value()) {
            const auto &refreshSupport_0 = param.refreshSupport.value();
            object_0.emplace(
                "refreshSupport",
                std::make_unique<LSPAny>(booleanToAny(refreshSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDiagnosticWorkspaceClientCapabilities(
        const LSPAny &any
    ) const -> DiagnosticWorkspaceClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DiagnosticWorkspaceClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DiagnosticWorkspaceClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DiagnosticWorkspaceClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("refreshSupport");
        if (iter_0 != object_0.end()) {
            value_0.refreshSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::diagnosticWorkspaceClientCapabilitiesToAny(
        const DiagnosticWorkspaceClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.refreshSupport.has_value()) {
            const auto &refreshSupport_0 = param.refreshSupport.value();
            object_0.emplace(
                "refreshSupport",
                std::make_unique<LSPAny>(booleanToAny(refreshSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToFoldingRangeWorkspaceClientCapabilities(
        const LSPAny &any
    ) const -> FoldingRangeWorkspaceClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FoldingRangeWorkspaceClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FoldingRangeWorkspaceClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FoldingRangeWorkspaceClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("refreshSupport");
        if (iter_0 != object_0.end()) {
            value_0.refreshSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::foldingRangeWorkspaceClientCapabilitiesToAny(
        const FoldingRangeWorkspaceClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.refreshSupport.has_value()) {
            const auto &refreshSupport_0 = param.refreshSupport.value();
            object_0.emplace(
                "refreshSupport",
                std::make_unique<LSPAny>(booleanToAny(refreshSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWorkspaceClientCapabilities(
        const LSPAny &any
    ) const -> WorkspaceClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 15) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 15")
            );
        }

        iter_0 = object_0.find("applyEdit");
        if (iter_0 != object_0.end()) {
            value_0.applyEdit = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workspaceEdit");
        if (iter_0 != object_0.end()) {
            value_0.workspaceEdit =
                anyToWorkspaceEditClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("didChangeConfiguration");
        if (iter_0 != object_0.end()) {
            value_0.didChangeConfiguration =
                anyToDidChangeConfigurationClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("didChangeWatchedFiles");
        if (iter_0 != object_0.end()) {
            value_0.didChangeWatchedFiles =
                anyToDidChangeWatchedFilesClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("symbol");
        if (iter_0 != object_0.end()) {
            value_0.symbol =
                anyToWorkspaceSymbolClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("executeCommand");
        if (iter_0 != object_0.end()) {
            value_0.executeCommand =
                anyToExecuteCommandClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("workspaceFolders");
        if (iter_0 != object_0.end()) {
            value_0.workspaceFolders = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("configuration");
        if (iter_0 != object_0.end()) {
            value_0.configuration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("semanticTokens");
        if (iter_0 != object_0.end()) {
            value_0.semanticTokens =
                anyToSemanticTokensWorkspaceClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("codeLens");
        if (iter_0 != object_0.end()) {
            value_0.codeLens =
                anyToCodeLensWorkspaceClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("fileOperations");
        if (iter_0 != object_0.end()) {
            value_0.fileOperations =
                anyToFileOperationClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("inlineValue");
        if (iter_0 != object_0.end()) {
            value_0.inlineValue =
                anyToInlineValueWorkspaceClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("inlayHint");
        if (iter_0 != object_0.end()) {
            value_0.inlayHint =
                anyToInlayHintWorkspaceClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("diagnostics");
        if (iter_0 != object_0.end()) {
            value_0.diagnostics =
                anyToDiagnosticWorkspaceClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("foldingRange");
        if (iter_0 != object_0.end()) {
            value_0.foldingRange =
                anyToFoldingRangeWorkspaceClientCapabilities(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workspaceClientCapabilitiesToAny(
        const WorkspaceClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.applyEdit.has_value()) {
            const auto &applyEdit_0 = param.applyEdit.value();
            object_0.emplace(
                "applyEdit",
                std::make_unique<LSPAny>(booleanToAny(applyEdit_0))
            );
        }

        if (param.workspaceEdit.has_value()) {
            const auto &workspaceEdit_0 = param.workspaceEdit.value();
            object_0.emplace(
                "workspaceEdit",
                std::make_unique<LSPAny>(workspaceEditClientCapabilitiesToAny(workspaceEdit_0))
            );
        }

        if (param.didChangeConfiguration.has_value()) {
            const auto &didChangeConfiguration_0 =
                param.didChangeConfiguration.value();
            object_0.emplace(
                "didChangeConfiguration",
                std::make_unique<LSPAny>(didChangeConfigurationClientCapabilitiesToAny(didChangeConfiguration_0))
            );
        }

        if (param.didChangeWatchedFiles.has_value()) {
            const auto &didChangeWatchedFiles_0 =
                param.didChangeWatchedFiles.value();
            object_0.emplace(
                "didChangeWatchedFiles",
                std::make_unique<LSPAny>(didChangeWatchedFilesClientCapabilitiesToAny(didChangeWatchedFiles_0))
            );
        }

        if (param.symbol.has_value()) {
            const auto &symbol_0 = param.symbol.value();
            object_0.emplace(
                "symbol",
                std::make_unique<LSPAny>(workspaceSymbolClientCapabilitiesToAny(symbol_0))
            );
        }

        if (param.executeCommand.has_value()) {
            const auto &executeCommand_0 = param.executeCommand.value();
            object_0.emplace(
                "executeCommand",
                std::make_unique<LSPAny>(executeCommandClientCapabilitiesToAny(executeCommand_0))
            );
        }

        if (param.workspaceFolders.has_value()) {
            const auto &workspaceFolders_0 = param.workspaceFolders.value();
            object_0.emplace(
                "workspaceFolders",
                std::make_unique<LSPAny>(booleanToAny(workspaceFolders_0))
            );
        }

        if (param.configuration.has_value()) {
            const auto &configuration_0 = param.configuration.value();
            object_0.emplace(
                "configuration",
                std::make_unique<LSPAny>(booleanToAny(configuration_0))
            );
        }

        if (param.semanticTokens.has_value()) {
            const auto &semanticTokens_0 = param.semanticTokens.value();
            object_0.emplace(
                "semanticTokens",
                std::make_unique<LSPAny>(semanticTokensWorkspaceClientCapabilitiesToAny(semanticTokens_0))
            );
        }

        if (param.codeLens.has_value()) {
            const auto &codeLens_0 = param.codeLens.value();
            object_0.emplace(
                "codeLens",
                std::make_unique<LSPAny>(codeLensWorkspaceClientCapabilitiesToAny(codeLens_0))
            );
        }

        if (param.fileOperations.has_value()) {
            const auto &fileOperations_0 = param.fileOperations.value();
            object_0.emplace(
                "fileOperations",
                std::make_unique<LSPAny>(fileOperationClientCapabilitiesToAny(fileOperations_0))
            );
        }

        if (param.inlineValue.has_value()) {
            const auto &inlineValue_0 = param.inlineValue.value();
            object_0.emplace(
                "inlineValue",
                std::make_unique<LSPAny>(inlineValueWorkspaceClientCapabilitiesToAny(inlineValue_0))
            );
        }

        if (param.inlayHint.has_value()) {
            const auto &inlayHint_0 = param.inlayHint.value();
            object_0.emplace(
                "inlayHint",
                std::make_unique<LSPAny>(inlayHintWorkspaceClientCapabilitiesToAny(inlayHint_0))
            );
        }

        if (param.diagnostics.has_value()) {
            const auto &diagnostics_0 = param.diagnostics.value();
            object_0.emplace(
                "diagnostics",
                std::make_unique<LSPAny>(diagnosticWorkspaceClientCapabilitiesToAny(diagnostics_0))
            );
        }

        if (param.foldingRange.has_value()) {
            const auto &foldingRange_0 = param.foldingRange.value();
            object_0.emplace(
                "foldingRange",
                std::make_unique<LSPAny>(foldingRangeWorkspaceClientCapabilitiesToAny(foldingRange_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentSyncClientCapabilities(
        const LSPAny &any
    ) const -> TextDocumentSyncClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentSyncClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentSyncClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentSyncClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("willSave");
        if (iter_0 != object_0.end()) {
            value_0.willSave = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("willSaveWaitUntil");
        if (iter_0 != object_0.end()) {
            value_0.willSaveWaitUntil = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("didSave");
        if (iter_0 != object_0.end()) {
            value_0.didSave = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::textDocumentSyncClientCapabilitiesToAny(
        const TextDocumentSyncClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.willSave.has_value()) {
            const auto &willSave_0 = param.willSave.value();
            object_0.emplace(
                "willSave",
                std::make_unique<LSPAny>(booleanToAny(willSave_0))
            );
        }

        if (param.willSaveWaitUntil.has_value()) {
            const auto &willSaveWaitUntil_0 = param.willSaveWaitUntil.value();
            object_0.emplace(
                "willSaveWaitUntil",
                std::make_unique<LSPAny>(booleanToAny(willSaveWaitUntil_0))
            );
        }

        if (param.didSave.has_value()) {
            const auto &didSave_0 = param.didSave.value();
            object_0.emplace(
                "didSave",
                std::make_unique<LSPAny>(booleanToAny(didSave_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCompletionClientCapabilities_completionItem(
        const LSPAny &any
    ) const -> CompletionClientCapabilities_completionItem
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionClientCapabilities_completionItem"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionClientCapabilities_completionItem value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 10) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionClientCapabilities_completionItem"
                 ": " + std::to_string(object_0.size()) + " > 10")
            );
        }

        iter_0 = object_0.find("snippetSupport");
        if (iter_0 != object_0.end()) {
            value_0.snippetSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("commitCharactersSupport");
        if (iter_0 != object_0.end()) {
            value_0.commitCharactersSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("documentationFormat");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<MarkupKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToMarkupKind(*elem_0));
            }
            value_0.documentationFormat = std::move(values_0);
        }

        iter_0 = object_0.find("deprecatedSupport");
        if (iter_0 != object_0.end()) {
            value_0.deprecatedSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("preselectSupport");
        if (iter_0 != object_0.end()) {
            value_0.preselectSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("tagSupport");
        if (iter_0 != object_0.end()) {
            value_0.tagSupport =
                anyToCompletionClientCapabilities_completionItem_tagSupport(*iter_0->second);
        }

        iter_0 = object_0.find("insertReplaceSupport");
        if (iter_0 != object_0.end()) {
            value_0.insertReplaceSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resolveSupport");
        if (iter_0 != object_0.end()) {
            value_0.resolveSupport =
                anyToCompletionClientCapabilities_completionItem_resolveSupport(*iter_0->second);
        }

        iter_0 = object_0.find("insertTextModeSupport");
        if (iter_0 != object_0.end()) {
            value_0.insertTextModeSupport =
                anyToCompletionClientCapabilities_completionItem_insertTextModeSupport(*iter_0->second);
        }

        iter_0 = object_0.find("labelDetailsSupport");
        if (iter_0 != object_0.end()) {
            value_0.labelDetailsSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::completionClientCapabilities_completionItemToAny(
        const CompletionClientCapabilities_completionItem &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.snippetSupport.has_value()) {
            const auto &snippetSupport_0 = param.snippetSupport.value();
            object_0.emplace(
                "snippetSupport",
                std::make_unique<LSPAny>(booleanToAny(snippetSupport_0))
            );
        }

        if (param.commitCharactersSupport.has_value()) {
            const auto &commitCharactersSupport_0 =
                param.commitCharactersSupport.value();
            object_0.emplace(
                "commitCharactersSupport",
                std::make_unique<LSPAny>(booleanToAny(commitCharactersSupport_0))
            );
        }

        if (param.documentationFormat.has_value()) {
            const auto &documentationFormat_0 =
                param.documentationFormat.value();
            LSPArray array_0;
            array_0.reserve(documentationFormat_0.size());
            for (const auto &elem_0 : documentationFormat_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = markupKindToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("documentationFormat", std::move(any_1));
        }

        if (param.deprecatedSupport.has_value()) {
            const auto &deprecatedSupport_0 = param.deprecatedSupport.value();
            object_0.emplace(
                "deprecatedSupport",
                std::make_unique<LSPAny>(booleanToAny(deprecatedSupport_0))
            );
        }

        if (param.preselectSupport.has_value()) {
            const auto &preselectSupport_0 = param.preselectSupport.value();
            object_0.emplace(
                "preselectSupport",
                std::make_unique<LSPAny>(booleanToAny(preselectSupport_0))
            );
        }

        if (param.tagSupport.has_value()) {
            const auto &tagSupport_0 = param.tagSupport.value();
            object_0.emplace(
                "tagSupport",
                std::make_unique<LSPAny>(completionClientCapabilities_completionItem_tagSupportToAny(tagSupport_0))
            );
        }

        if (param.insertReplaceSupport.has_value()) {
            const auto &insertReplaceSupport_0 =
                param.insertReplaceSupport.value();
            object_0.emplace(
                "insertReplaceSupport",
                std::make_unique<LSPAny>(booleanToAny(insertReplaceSupport_0))
            );
        }

        if (param.resolveSupport.has_value()) {
            const auto &resolveSupport_0 = param.resolveSupport.value();
            object_0.emplace(
                "resolveSupport",
                std::make_unique<LSPAny>(completionClientCapabilities_completionItem_resolveSupportToAny(resolveSupport_0))
            );
        }

        if (param.insertTextModeSupport.has_value()) {
            const auto &insertTextModeSupport_0 =
                param.insertTextModeSupport.value();
            object_0.emplace(
                "insertTextModeSupport",
                std::make_unique<LSPAny>(completionClientCapabilities_completionItem_insertTextModeSupportToAny(insertTextModeSupport_0))
            );
        }

        if (param.labelDetailsSupport.has_value()) {
            const auto &labelDetailsSupport_0 =
                param.labelDetailsSupport.value();
            object_0.emplace(
                "labelDetailsSupport",
                std::make_unique<LSPAny>(booleanToAny(labelDetailsSupport_0))
            );
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToCompletionClientCapabilities(
        const LSPAny &any
    ) const -> CompletionClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 6) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 6")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("completionItem");
        if (iter_0 != object_0.end()) {
            value_0.completionItem =
                anyToCompletionClientCapabilities_completionItem(*iter_0->second);
        }

        iter_0 = object_0.find("completionItemKind");
        if (iter_0 != object_0.end()) {
            value_0.completionItemKind =
                anyToCompletionClientCapabilities_completionItemKind(*iter_0->second);
        }

        iter_0 = object_0.find("insertTextMode");
        if (iter_0 != object_0.end()) {
            value_0.insertTextMode = anyToInsertTextMode(*iter_0->second);
        }

        iter_0 = object_0.find("contextSupport");
        if (iter_0 != object_0.end()) {
            value_0.contextSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("completionList");
        if (iter_0 != object_0.end()) {
            value_0.completionList =
                anyToCompletionClientCapabilities_completionList(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::completionClientCapabilitiesToAny(
        const CompletionClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.completionItem.has_value()) {
            const auto &completionItem_0 = param.completionItem.value();
            object_0.emplace(
                "completionItem",
                std::make_unique<LSPAny>(completionClientCapabilities_completionItemToAny(completionItem_0))
            );
        }

        if (param.completionItemKind.has_value()) {
            const auto &completionItemKind_0 =
                param.completionItemKind.value();
            object_0.emplace(
                "completionItemKind",
                std::make_unique<LSPAny>(completionClientCapabilities_completionItemKindToAny(completionItemKind_0))
            );
        }

        if (param.insertTextMode.has_value()) {
            const auto &insertTextMode_0 = param.insertTextMode.value();
            object_0.emplace(
                "insertTextMode",
                std::make_unique<LSPAny>(insertTextModeToAny(insertTextMode_0))
            );
        }

        if (param.contextSupport.has_value()) {
            const auto &contextSupport_0 = param.contextSupport.value();
            object_0.emplace(
                "contextSupport",
                std::make_unique<LSPAny>(booleanToAny(contextSupport_0))
            );
        }

        if (param.completionList.has_value()) {
            const auto &completionList_0 = param.completionList.value();
            object_0.emplace(
                "completionList",
                std::make_unique<LSPAny>(completionClientCapabilities_completionListToAny(completionList_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToHoverClientCapabilities(
        const LSPAny &any
    ) const -> HoverClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "HoverClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        HoverClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "HoverClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("contentFormat");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<MarkupKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToMarkupKind(*elem_0));
            }
            value_0.contentFormat = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::hoverClientCapabilitiesToAny(
        const HoverClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.contentFormat.has_value()) {
            const auto &contentFormat_0 = param.contentFormat.value();
            LSPArray array_0;
            array_0.reserve(contentFormat_0.size());
            for (const auto &elem_0 : contentFormat_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = markupKindToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("contentFormat", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToSignatureHelpClientCapabilities_signatureInformation_parameterInformation(
        const LSPAny &any
    ) const -> SignatureHelpClientCapabilities_signatureInformation_parameterInformation
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SignatureHelpClientCapabilities_signatureInformation_parameterInformation"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SignatureHelpClientCapabilities_signatureInformation_parameterInformation value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SignatureHelpClientCapabilities_signatureInformation_parameterInformation"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("labelOffsetSupport");
        if (iter_0 != object_0.end()) {
            value_0.labelOffsetSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::signatureHelpClientCapabilities_signatureInformation_parameterInformationToAny(
        const SignatureHelpClientCapabilities_signatureInformation_parameterInformation &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.labelOffsetSupport.has_value()) {
            const auto &labelOffsetSupport_0 =
                param.labelOffsetSupport.value();
            object_0.emplace(
                "labelOffsetSupport",
                std::make_unique<LSPAny>(booleanToAny(labelOffsetSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSignatureHelpClientCapabilities_signatureInformation(
        const LSPAny &any
    ) const -> SignatureHelpClientCapabilities_signatureInformation
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SignatureHelpClientCapabilities_signatureInformation"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SignatureHelpClientCapabilities_signatureInformation value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SignatureHelpClientCapabilities_signatureInformation"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("documentationFormat");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<MarkupKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToMarkupKind(*elem_0));
            }
            value_0.documentationFormat = std::move(values_0);
        }

        iter_0 = object_0.find("parameterInformation");
        if (iter_0 != object_0.end()) {
            value_0.parameterInformation =
                anyToSignatureHelpClientCapabilities_signatureInformation_parameterInformation(*iter_0->second);
        }

        iter_0 = object_0.find("activeParameterSupport");
        if (iter_0 != object_0.end()) {
            value_0.activeParameterSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::signatureHelpClientCapabilities_signatureInformationToAny(
        const SignatureHelpClientCapabilities_signatureInformation &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.documentationFormat.has_value()) {
            const auto &documentationFormat_0 =
                param.documentationFormat.value();
            LSPArray array_0;
            array_0.reserve(documentationFormat_0.size());
            for (const auto &elem_0 : documentationFormat_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = markupKindToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("documentationFormat", std::move(any_1));
        }

        if (param.parameterInformation.has_value()) {
            const auto &parameterInformation_0 =
                param.parameterInformation.value();
            object_0.emplace(
                "parameterInformation",
                std::make_unique<LSPAny>(signatureHelpClientCapabilities_signatureInformation_parameterInformationToAny(parameterInformation_0))
            );
        }

        if (param.activeParameterSupport.has_value()) {
            const auto &activeParameterSupport_0 =
                param.activeParameterSupport.value();
            object_0.emplace(
                "activeParameterSupport",
                std::make_unique<LSPAny>(booleanToAny(activeParameterSupport_0))
            );
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToSignatureHelpClientCapabilities(
        const LSPAny &any
    ) const -> SignatureHelpClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SignatureHelpClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SignatureHelpClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SignatureHelpClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("signatureInformation");
        if (iter_0 != object_0.end()) {
            value_0.signatureInformation =
                anyToSignatureHelpClientCapabilities_signatureInformation(*iter_0->second);
        }

        iter_0 = object_0.find("contextSupport");
        if (iter_0 != object_0.end()) {
            value_0.contextSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::signatureHelpClientCapabilitiesToAny(
        const SignatureHelpClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.signatureInformation.has_value()) {
            const auto &signatureInformation_0 =
                param.signatureInformation.value();
            object_0.emplace(
                "signatureInformation",
                std::make_unique<LSPAny>(signatureHelpClientCapabilities_signatureInformationToAny(signatureInformation_0))
            );
        }

        if (param.contextSupport.has_value()) {
            const auto &contextSupport_0 = param.contextSupport.value();
            object_0.emplace(
                "contextSupport",
                std::make_unique<LSPAny>(booleanToAny(contextSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDeclarationClientCapabilities(
        const LSPAny &any
    ) const -> DeclarationClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DeclarationClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DeclarationClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DeclarationClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("linkSupport");
        if (iter_0 != object_0.end()) {
            value_0.linkSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::declarationClientCapabilitiesToAny(
        const DeclarationClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.linkSupport.has_value()) {
            const auto &linkSupport_0 = param.linkSupport.value();
            object_0.emplace(
                "linkSupport",
                std::make_unique<LSPAny>(booleanToAny(linkSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDefinitionClientCapabilities(
        const LSPAny &any
    ) const -> DefinitionClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DefinitionClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DefinitionClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DefinitionClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("linkSupport");
        if (iter_0 != object_0.end()) {
            value_0.linkSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::definitionClientCapabilitiesToAny(
        const DefinitionClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.linkSupport.has_value()) {
            const auto &linkSupport_0 = param.linkSupport.value();
            object_0.emplace(
                "linkSupport",
                std::make_unique<LSPAny>(booleanToAny(linkSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTypeDefinitionClientCapabilities(
        const LSPAny &any
    ) const -> TypeDefinitionClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TypeDefinitionClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TypeDefinitionClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TypeDefinitionClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("linkSupport");
        if (iter_0 != object_0.end()) {
            value_0.linkSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::typeDefinitionClientCapabilitiesToAny(
        const TypeDefinitionClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.linkSupport.has_value()) {
            const auto &linkSupport_0 = param.linkSupport.value();
            object_0.emplace(
                "linkSupport",
                std::make_unique<LSPAny>(booleanToAny(linkSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToImplementationClientCapabilities(
        const LSPAny &any
    ) const -> ImplementationClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "ImplementationClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ImplementationClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "ImplementationClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("linkSupport");
        if (iter_0 != object_0.end()) {
            value_0.linkSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::implementationClientCapabilitiesToAny(
        const ImplementationClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.linkSupport.has_value()) {
            const auto &linkSupport_0 = param.linkSupport.value();
            object_0.emplace(
                "linkSupport",
                std::make_unique<LSPAny>(booleanToAny(linkSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToReferenceClientCapabilities(
        const LSPAny &any
    ) const -> ReferenceClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ReferenceClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ReferenceClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ReferenceClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::referenceClientCapabilitiesToAny(
        const ReferenceClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentHighlightClientCapabilities(
        const LSPAny &any
    ) const -> DocumentHighlightClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentHighlightClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentHighlightClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentHighlightClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentHighlightClientCapabilitiesToAny(
        const DocumentHighlightClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentSymbolClientCapabilities(
        const LSPAny &any
    ) const -> DocumentSymbolClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentSymbolClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentSymbolClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentSymbolClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("symbolKind");
        if (iter_0 != object_0.end()) {
            value_0.symbolKind =
                anyToDocumentSymbolClientCapabilities_symbolKind(*iter_0->second);
        }

        iter_0 = object_0.find("hierarchicalDocumentSymbolSupport");
        if (iter_0 != object_0.end()) {
            value_0.hierarchicalDocumentSymbolSupport =
                anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("tagSupport");
        if (iter_0 != object_0.end()) {
            value_0.tagSupport =
                anyToDocumentSymbolClientCapabilities_tagSupport(*iter_0->second);
        }

        iter_0 = object_0.find("labelSupport");
        if (iter_0 != object_0.end()) {
            value_0.labelSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentSymbolClientCapabilitiesToAny(
        const DocumentSymbolClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.symbolKind.has_value()) {
            const auto &symbolKind_0 = param.symbolKind.value();
            object_0.emplace(
                "symbolKind",
                std::make_unique<LSPAny>(documentSymbolClientCapabilities_symbolKindToAny(symbolKind_0))
            );
        }

        if (param.hierarchicalDocumentSymbolSupport.has_value()) {
            const auto &hierarchicalDocumentSymbolSupport_0 =
                param.hierarchicalDocumentSymbolSupport.value();
            object_0.emplace(
                "hierarchicalDocumentSymbolSupport",
                std::make_unique<LSPAny>(booleanToAny(hierarchicalDocumentSymbolSupport_0))
            );
        }

        if (param.tagSupport.has_value()) {
            const auto &tagSupport_0 = param.tagSupport.value();
            object_0.emplace(
                "tagSupport",
                std::make_unique<LSPAny>(documentSymbolClientCapabilities_tagSupportToAny(tagSupport_0))
            );
        }

        if (param.labelSupport.has_value()) {
            const auto &labelSupport_0 = param.labelSupport.value();
            object_0.emplace(
                "labelSupport",
                std::make_unique<LSPAny>(booleanToAny(labelSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCodeActionClientCapabilities(
        const LSPAny &any
    ) const -> CodeActionClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeActionClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeActionClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 7) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeActionClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 7")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("codeActionLiteralSupport");
        if (iter_0 != object_0.end()) {
            value_0.codeActionLiteralSupport =
                anyToCodeActionClientCapabilities_codeActionLiteralSupport(*iter_0->second);
        }

        iter_0 = object_0.find("isPreferredSupport");
        if (iter_0 != object_0.end()) {
            value_0.isPreferredSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("disabledSupport");
        if (iter_0 != object_0.end()) {
            value_0.disabledSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("dataSupport");
        if (iter_0 != object_0.end()) {
            value_0.dataSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resolveSupport");
        if (iter_0 != object_0.end()) {
            value_0.resolveSupport =
                anyToCodeActionClientCapabilities_resolveSupport(*iter_0->second);
        }

        iter_0 = object_0.find("honorsChangeAnnotations");
        if (iter_0 != object_0.end()) {
            value_0.honorsChangeAnnotations = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::codeActionClientCapabilitiesToAny(
        const CodeActionClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.codeActionLiteralSupport.has_value()) {
            const auto &codeActionLiteralSupport_0 =
                param.codeActionLiteralSupport.value();
            object_0.emplace(
                "codeActionLiteralSupport",
                std::make_unique<LSPAny>(codeActionClientCapabilities_codeActionLiteralSupportToAny(codeActionLiteralSupport_0))
            );
        }

        if (param.isPreferredSupport.has_value()) {
            const auto &isPreferredSupport_0 =
                param.isPreferredSupport.value();
            object_0.emplace(
                "isPreferredSupport",
                std::make_unique<LSPAny>(booleanToAny(isPreferredSupport_0))
            );
        }

        if (param.disabledSupport.has_value()) {
            const auto &disabledSupport_0 = param.disabledSupport.value();
            object_0.emplace(
                "disabledSupport",
                std::make_unique<LSPAny>(booleanToAny(disabledSupport_0))
            );
        }

        if (param.dataSupport.has_value()) {
            const auto &dataSupport_0 = param.dataSupport.value();
            object_0.emplace(
                "dataSupport",
                std::make_unique<LSPAny>(booleanToAny(dataSupport_0))
            );
        }

        if (param.resolveSupport.has_value()) {
            const auto &resolveSupport_0 = param.resolveSupport.value();
            object_0.emplace(
                "resolveSupport",
                std::make_unique<LSPAny>(codeActionClientCapabilities_resolveSupportToAny(resolveSupport_0))
            );
        }

        if (param.honorsChangeAnnotations.has_value()) {
            const auto &honorsChangeAnnotations_0 =
                param.honorsChangeAnnotations.value();
            object_0.emplace(
                "honorsChangeAnnotations",
                std::make_unique<LSPAny>(booleanToAny(honorsChangeAnnotations_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCodeLensClientCapabilities(
        const LSPAny &any
    ) const -> CodeLensClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeLensClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeLensClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeLensClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::codeLensClientCapabilitiesToAny(
        const CodeLensClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentLinkClientCapabilities(
        const LSPAny &any
    ) const -> DocumentLinkClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentLinkClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentLinkClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentLinkClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("tooltipSupport");
        if (iter_0 != object_0.end()) {
            value_0.tooltipSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentLinkClientCapabilitiesToAny(
        const DocumentLinkClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.tooltipSupport.has_value()) {
            const auto &tooltipSupport_0 = param.tooltipSupport.value();
            object_0.emplace(
                "tooltipSupport",
                std::make_unique<LSPAny>(booleanToAny(tooltipSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentColorClientCapabilities(
        const LSPAny &any
    ) const -> DocumentColorClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentColorClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentColorClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentColorClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentColorClientCapabilitiesToAny(
        const DocumentColorClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentFormattingClientCapabilities(
        const LSPAny &any
    ) const -> DocumentFormattingClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentFormattingClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentFormattingClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentFormattingClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentFormattingClientCapabilitiesToAny(
        const DocumentFormattingClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentRangeFormattingClientCapabilities(
        const LSPAny &any
    ) const -> DocumentRangeFormattingClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentRangeFormattingClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentRangeFormattingClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentRangeFormattingClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("rangesSupport");
        if (iter_0 != object_0.end()) {
            value_0.rangesSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentRangeFormattingClientCapabilitiesToAny(
        const DocumentRangeFormattingClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.rangesSupport.has_value()) {
            const auto &rangesSupport_0 = param.rangesSupport.value();
            object_0.emplace(
                "rangesSupport",
                std::make_unique<LSPAny>(booleanToAny(rangesSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentOnTypeFormattingClientCapabilities(
        const LSPAny &any
    ) const -> DocumentOnTypeFormattingClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentOnTypeFormattingClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentOnTypeFormattingClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentOnTypeFormattingClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentOnTypeFormattingClientCapabilitiesToAny(
        const DocumentOnTypeFormattingClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToRenameClientCapabilities(
        const LSPAny &any
    ) const -> RenameClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "RenameClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        RenameClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "RenameClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("prepareSupport");
        if (iter_0 != object_0.end()) {
            value_0.prepareSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("prepareSupportDefaultBehavior");
        if (iter_0 != object_0.end()) {
            value_0.prepareSupportDefaultBehavior =
                anyToPrepareSupportDefaultBehavior(*iter_0->second);
        }

        iter_0 = object_0.find("honorsChangeAnnotations");
        if (iter_0 != object_0.end()) {
            value_0.honorsChangeAnnotations = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::renameClientCapabilitiesToAny(
        const RenameClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.prepareSupport.has_value()) {
            const auto &prepareSupport_0 = param.prepareSupport.value();
            object_0.emplace(
                "prepareSupport",
                std::make_unique<LSPAny>(booleanToAny(prepareSupport_0))
            );
        }

        if (param.prepareSupportDefaultBehavior.has_value()) {
            const auto &prepareSupportDefaultBehavior_0 =
                param.prepareSupportDefaultBehavior.value();
            object_0.emplace(
                "prepareSupportDefaultBehavior",
                std::make_unique<LSPAny>(prepareSupportDefaultBehaviorToAny(prepareSupportDefaultBehavior_0))
            );
        }

        if (param.honorsChangeAnnotations.has_value()) {
            const auto &honorsChangeAnnotations_0 =
                param.honorsChangeAnnotations.value();
            object_0.emplace(
                "honorsChangeAnnotations",
                std::make_unique<LSPAny>(booleanToAny(honorsChangeAnnotations_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToFoldingRangeClientCapabilities_foldingRange(
        const LSPAny &any
    ) const -> FoldingRangeClientCapabilities_foldingRange
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FoldingRangeClientCapabilities_foldingRange"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FoldingRangeClientCapabilities_foldingRange value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FoldingRangeClientCapabilities_foldingRange"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("collapsedText");
        if (iter_0 != object_0.end()) {
            value_0.collapsedText = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::foldingRangeClientCapabilities_foldingRangeToAny(
        const FoldingRangeClientCapabilities_foldingRange &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.collapsedText.has_value()) {
            const auto &collapsedText_0 = param.collapsedText.value();
            object_0.emplace(
                "collapsedText",
                std::make_unique<LSPAny>(booleanToAny(collapsedText_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSelectionRangeClientCapabilities(
        const LSPAny &any
    ) const -> SelectionRangeClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SelectionRangeClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SelectionRangeClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SelectionRangeClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::selectionRangeClientCapabilitiesToAny(
        const SelectionRangeClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToPublishDiagnosticsClientCapabilities(
        const LSPAny &any
    ) const -> PublishDiagnosticsClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "PublishDiagnosticsClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        PublishDiagnosticsClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "PublishDiagnosticsClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("relatedInformation");
        if (iter_0 != object_0.end()) {
            value_0.relatedInformation = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("tagSupport");
        if (iter_0 != object_0.end()) {
            value_0.tagSupport =
                anyToPublishDiagnosticsClientCapabilities_tagSupport(*iter_0->second);
        }

        iter_0 = object_0.find("versionSupport");
        if (iter_0 != object_0.end()) {
            value_0.versionSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("codeDescriptionSupport");
        if (iter_0 != object_0.end()) {
            value_0.codeDescriptionSupport = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("dataSupport");
        if (iter_0 != object_0.end()) {
            value_0.dataSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::publishDiagnosticsClientCapabilitiesToAny(
        const PublishDiagnosticsClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.relatedInformation.has_value()) {
            const auto &relatedInformation_0 =
                param.relatedInformation.value();
            object_0.emplace(
                "relatedInformation",
                std::make_unique<LSPAny>(booleanToAny(relatedInformation_0))
            );
        }

        if (param.tagSupport.has_value()) {
            const auto &tagSupport_0 = param.tagSupport.value();
            object_0.emplace(
                "tagSupport",
                std::make_unique<LSPAny>(publishDiagnosticsClientCapabilities_tagSupportToAny(tagSupport_0))
            );
        }

        if (param.versionSupport.has_value()) {
            const auto &versionSupport_0 = param.versionSupport.value();
            object_0.emplace(
                "versionSupport",
                std::make_unique<LSPAny>(booleanToAny(versionSupport_0))
            );
        }

        if (param.codeDescriptionSupport.has_value()) {
            const auto &codeDescriptionSupport_0 =
                param.codeDescriptionSupport.value();
            object_0.emplace(
                "codeDescriptionSupport",
                std::make_unique<LSPAny>(booleanToAny(codeDescriptionSupport_0))
            );
        }

        if (param.dataSupport.has_value()) {
            const auto &dataSupport_0 = param.dataSupport.value();
            object_0.emplace(
                "dataSupport",
                std::make_unique<LSPAny>(booleanToAny(dataSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCallHierarchyClientCapabilities(
        const LSPAny &any
    ) const -> CallHierarchyClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CallHierarchyClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CallHierarchyClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CallHierarchyClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::callHierarchyClientCapabilitiesToAny(
        const CallHierarchyClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSemanticTokensClientCapabilities_requests_full_1(
        const LSPAny &any
    ) const -> SemanticTokensClientCapabilities_requests_full_1
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SemanticTokensClientCapabilities_requests_full_1"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SemanticTokensClientCapabilities_requests_full_1 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SemanticTokensClientCapabilities_requests_full_1"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("delta");
        if (iter_0 != object_0.end()) {
            value_0.delta = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::semanticTokensClientCapabilities_requests_full_1ToAny(
        const SemanticTokensClientCapabilities_requests_full_1 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.delta.has_value()) {
            const auto &delta_0 = param.delta.value();
            object_0.emplace(
                "delta",
                std::make_unique<LSPAny>(booleanToAny(delta_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSemanticTokensClientCapabilities_requests_full(
        const LSPAny &any
    ) const -> SemanticTokensClientCapabilities_requests_full
    {
        SemanticTokensClientCapabilities_requests_full value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 =
                    anyToSemanticTokensClientCapabilities_requests_full_1(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to SemanticTokensClientCapabilities_requests_full"
                );
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "SemanticTokensClientCapabilities_requests_full"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::semanticTokensClientCapabilities_requests_fullToAny(
        const SemanticTokensClientCapabilities_requests_full &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case SemanticTokensClientCapabilities_requests_fullType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case SemanticTokensClientCapabilities_requests_fullType::SemanticTokensClientCapabilities_requests_full_1: {
            return semanticTokensClientCapabilities_requests_full_1ToAny(value.semanticTokensClientCapabilities_requests_full_1());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported SemanticTokensClientCapabilities_requests_fullType: " +
                 SemanticTokensClientCapabilities_requests_fullTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToLinkedEditingRangeClientCapabilities(
        const LSPAny &any
    ) const -> LinkedEditingRangeClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "LinkedEditingRangeClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        LinkedEditingRangeClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "LinkedEditingRangeClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::linkedEditingRangeClientCapabilitiesToAny(
        const LinkedEditingRangeClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToMonikerClientCapabilities(
        const LSPAny &any
    ) const -> MonikerClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "MonikerClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        MonikerClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "MonikerClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::monikerClientCapabilitiesToAny(
        const MonikerClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTypeHierarchyClientCapabilities(
        const LSPAny &any
    ) const -> TypeHierarchyClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TypeHierarchyClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TypeHierarchyClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TypeHierarchyClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::typeHierarchyClientCapabilitiesToAny(
        const TypeHierarchyClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlineValueClientCapabilities(
        const LSPAny &any
    ) const -> InlineValueClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlineValueClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlineValueClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlineValueClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlineValueClientCapabilitiesToAny(
        const InlineValueClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlayHintClientCapabilities(
        const LSPAny &any
    ) const -> InlayHintClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlayHintClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlayHintClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlayHintClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resolveSupport");
        if (iter_0 != object_0.end()) {
            value_0.resolveSupport =
                anyToInlayHintClientCapabilities_resolveSupport(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlayHintClientCapabilitiesToAny(
        const InlayHintClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.resolveSupport.has_value()) {
            const auto &resolveSupport_0 = param.resolveSupport.value();
            object_0.emplace(
                "resolveSupport",
                std::make_unique<LSPAny>(inlayHintClientCapabilities_resolveSupportToAny(resolveSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDiagnosticClientCapabilities(
        const LSPAny &any
    ) const -> DiagnosticClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DiagnosticClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DiagnosticClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DiagnosticClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("relatedDocumentSupport");
        if (iter_0 != object_0.end()) {
            value_0.relatedDocumentSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::diagnosticClientCapabilitiesToAny(
        const DiagnosticClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.relatedDocumentSupport.has_value()) {
            const auto &relatedDocumentSupport_0 =
                param.relatedDocumentSupport.value();
            object_0.emplace(
                "relatedDocumentSupport",
                std::make_unique<LSPAny>(booleanToAny(relatedDocumentSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlineCompletionClientCapabilities(
        const LSPAny &any
    ) const -> InlineCompletionClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlineCompletionClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlineCompletionClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlineCompletionClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlineCompletionClientCapabilitiesToAny(
        const InlineCompletionClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToNotebookDocumentSyncClientCapabilities(
        const LSPAny &any
    ) const -> NotebookDocumentSyncClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentSyncClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentSyncClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentSyncClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("executionSummarySupport");
        if (iter_0 != object_0.end()) {
            value_0.executionSummarySupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentSyncClientCapabilitiesToAny(
        const NotebookDocumentSyncClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.executionSummarySupport.has_value()) {
            const auto &executionSummarySupport_0 =
                param.executionSummarySupport.value();
            object_0.emplace(
                "executionSummarySupport",
                std::make_unique<LSPAny>(booleanToAny(executionSummarySupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToNotebookDocumentClientCapabilities(
        const LSPAny &any
    ) const -> NotebookDocumentClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "NotebookDocumentClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        NotebookDocumentClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "NotebookDocumentClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("synchronization");
        if (iter_0 != object_0.end()) {
            value_0.synchronization =
                anyToNotebookDocumentSyncClientCapabilities(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required NotebookDocumentClientCapabilities attribute: synchronization"
            );
        }

        return value_0;
    }

    auto LspTransformer::notebookDocumentClientCapabilitiesToAny(
        const NotebookDocumentClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "synchronization",
            std::make_unique<LSPAny>(notebookDocumentSyncClientCapabilitiesToAny(param.synchronization))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToShowMessageRequestClientCapabilities_messageActionItem(
        const LSPAny &any
    ) const -> ShowMessageRequestClientCapabilities_messageActionItem
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ShowMessageRequestClientCapabilities_messageActionItem"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ShowMessageRequestClientCapabilities_messageActionItem value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ShowMessageRequestClientCapabilities_messageActionItem"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("additionalPropertiesSupport");
        if (iter_0 != object_0.end()) {
            value_0.additionalPropertiesSupport =
                anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::showMessageRequestClientCapabilities_messageActionItemToAny(
        const ShowMessageRequestClientCapabilities_messageActionItem &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.additionalPropertiesSupport.has_value()) {
            const auto &additionalPropertiesSupport_0 =
                param.additionalPropertiesSupport.value();
            object_0.emplace(
                "additionalPropertiesSupport",
                std::make_unique<LSPAny>(booleanToAny(additionalPropertiesSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToShowMessageRequestClientCapabilities(
        const LSPAny &any
    ) const -> ShowMessageRequestClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ShowMessageRequestClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ShowMessageRequestClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ShowMessageRequestClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("messageActionItem");
        if (iter_0 != object_0.end()) {
            value_0.messageActionItem =
                anyToShowMessageRequestClientCapabilities_messageActionItem(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::showMessageRequestClientCapabilitiesToAny(
        const ShowMessageRequestClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.messageActionItem.has_value()) {
            const auto &messageActionItem_0 = param.messageActionItem.value();
            object_0.emplace(
                "messageActionItem",
                std::make_unique<LSPAny>(showMessageRequestClientCapabilities_messageActionItemToAny(messageActionItem_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToShowDocumentClientCapabilities(
        const LSPAny &any
    ) const -> ShowDocumentClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ShowDocumentClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ShowDocumentClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ShowDocumentClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("support");
        if (iter_0 != object_0.end()) {
            value_0.support = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ShowDocumentClientCapabilities attribute: support"
            );
        }

        return value_0;
    }

    auto LspTransformer::showDocumentClientCapabilitiesToAny(
        const ShowDocumentClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "support",
            std::make_unique<LSPAny>(booleanToAny(param.support))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWindowClientCapabilities(
        const LSPAny &any
    ) const -> WindowClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WindowClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WindowClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WindowClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("showMessage");
        if (iter_0 != object_0.end()) {
            value_0.showMessage =
                anyToShowMessageRequestClientCapabilities(*iter_0->second);
        }

        iter_0 = object_0.find("showDocument");
        if (iter_0 != object_0.end()) {
            value_0.showDocument =
                anyToShowDocumentClientCapabilities(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::windowClientCapabilitiesToAny(
        const WindowClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.showMessage.has_value()) {
            const auto &showMessage_0 = param.showMessage.value();
            object_0.emplace(
                "showMessage",
                std::make_unique<LSPAny>(showMessageRequestClientCapabilitiesToAny(showMessage_0))
            );
        }

        if (param.showDocument.has_value()) {
            const auto &showDocument_0 = param.showDocument.value();
            object_0.emplace(
                "showDocument",
                std::make_unique<LSPAny>(showDocumentClientCapabilitiesToAny(showDocument_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToPrepareRenameResult_2(
        const LSPAny &any
    ) const -> PrepareRenameResult_2
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "PrepareRenameResult_2"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        PrepareRenameResult_2 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "PrepareRenameResult_2"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("defaultBehavior");
        if (iter_0 != object_0.end()) {
            value_0.defaultBehavior = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required PrepareRenameResult_2 attribute: defaultBehavior"
            );
        }

        return value_0;
    }

    auto LspTransformer::prepareRenameResult_2ToAny(
        const PrepareRenameResult_2 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "defaultBehavior",
            std::make_unique<LSPAny>(booleanToAny(param.defaultBehavior))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWindow_ShowDocumentResult(
        const LSPAny &any
    ) const -> Window_ShowDocumentResult
    {
        return anyToShowDocumentResult(any);
    }

    auto LspTransformer::window_ShowDocumentResultToAny(
        const Window_ShowDocumentResult &alias
    ) const -> LSPAny
    {
        return showDocumentResultToAny(alias);
    }

    auto LspTransformer::nullToAny(null_t param) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = param;
        return any_0;
    }

    auto LspTransformer::anyToNull(const LSPAny &any) const -> null_t
    {
        switch (any.type()) {
        case LSPAnyType::Null: {
            return any.null();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type null_t")
            );
        }
        }
    }

    auto LspTransformer::anyToTextDocumentRegistrationOptions_documentSelector(
        const LSPAny &any
    ) const -> TextDocumentRegistrationOptions_documentSelector
    {
        TextDocumentRegistrationOptions_documentSelector value_0;

        switch (any.type()) {
        case LSPAnyType::Array: {
            try {
                value_0 = anyToDocumentSelector(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to TextDocumentRegistrationOptions_documentSelector"
                );
            }
            break;
        }
        case LSPAnyType::Null: {
            value_0 = anyToNull(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "TextDocumentRegistrationOptions_documentSelector"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::textDocumentRegistrationOptions_documentSelectorToAny(
        const TextDocumentRegistrationOptions_documentSelector &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case TextDocumentRegistrationOptions_documentSelectorType::DocumentSelector: {
            return documentSelectorToAny(value.documentSelector());
        }
        case TextDocumentRegistrationOptions_documentSelectorType::Null: {
            return nullToAny(value.null());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported TextDocumentRegistrationOptions_documentSelectorType: " +
                 TextDocumentRegistrationOptions_documentSelectorTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToTextDocumentRegistrationOptions(
        const LSPAny &any
    ) const -> TextDocumentRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentRegistrationOptions attribute: documentSelector"
            );
        }

        return value_0;
    }

    auto LspTransformer::textDocumentRegistrationOptionsToAny(
        const TextDocumentRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToImplementationRegistrationOptions(
        const LSPAny &any
    ) const -> ImplementationRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "ImplementationRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ImplementationRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "ImplementationRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ImplementationRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::implementationRegistrationOptionsToAny(
        const ImplementationRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTypeDefinitionRegistrationOptions(
        const LSPAny &any
    ) const -> TypeDefinitionRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TypeDefinitionRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TypeDefinitionRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TypeDefinitionRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TypeDefinitionRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::typeDefinitionRegistrationOptionsToAny(
        const TypeDefinitionRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentColorRegistrationOptions(
        const LSPAny &any
    ) const -> DocumentColorRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentColorRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentColorRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentColorRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentColorRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentColorRegistrationOptionsToAny(
        const DocumentColorRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToFoldingRangeRegistrationOptions(
        const LSPAny &any
    ) const -> FoldingRangeRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FoldingRangeRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FoldingRangeRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FoldingRangeRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FoldingRangeRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::foldingRangeRegistrationOptionsToAny(
        const FoldingRangeRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDeclarationRegistrationOptions(
        const LSPAny &any
    ) const -> DeclarationRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DeclarationRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DeclarationRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DeclarationRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DeclarationRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::declarationRegistrationOptionsToAny(
        const DeclarationRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSelectionRangeRegistrationOptions(
        const LSPAny &any
    ) const -> SelectionRangeRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SelectionRangeRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SelectionRangeRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SelectionRangeRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SelectionRangeRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::selectionRangeRegistrationOptionsToAny(
        const SelectionRangeRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCallHierarchyRegistrationOptions(
        const LSPAny &any
    ) const -> CallHierarchyRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CallHierarchyRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CallHierarchyRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CallHierarchyRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CallHierarchyRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::callHierarchyRegistrationOptionsToAny(
        const CallHierarchyRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToLinkedEditingRangeRegistrationOptions(
        const LSPAny &any
    ) const -> LinkedEditingRangeRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "LinkedEditingRangeRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        LinkedEditingRangeRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "LinkedEditingRangeRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required LinkedEditingRangeRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::linkedEditingRangeRegistrationOptionsToAny(
        const LinkedEditingRangeRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToMonikerRegistrationOptions(
        const LSPAny &any
    ) const -> MonikerRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "MonikerRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        MonikerRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "MonikerRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required MonikerRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::monikerRegistrationOptionsToAny(
        const MonikerRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTypeHierarchyRegistrationOptions(
        const LSPAny &any
    ) const -> TypeHierarchyRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TypeHierarchyRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TypeHierarchyRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TypeHierarchyRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TypeHierarchyRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::typeHierarchyRegistrationOptionsToAny(
        const TypeHierarchyRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlineValueRegistrationOptions(
        const LSPAny &any
    ) const -> InlineValueRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlineValueRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlineValueRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlineValueRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InlineValueRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlineValueRegistrationOptionsToAny(
        const InlineValueRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlayHintRegistrationOptions(
        const LSPAny &any
    ) const -> InlayHintRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlayHintRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlayHintRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 6) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlayHintRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 6")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InlayHintRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlayHintRegistrationOptionsToAny(
        const InlayHintRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDiagnosticRegistrationOptions(
        const LSPAny &any
    ) const -> DiagnosticRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DiagnosticRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DiagnosticRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 8) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DiagnosticRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 8")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DiagnosticRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("identifier");
        if (iter_0 != object_0.end()) {
            value_0.identifier = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("interFileDependencies");
        if (iter_0 != object_0.end()) {
            value_0.interFileDependencies = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DiagnosticRegistrationOptions attribute: interFileDependencies"
            );
        }

        iter_0 = object_0.find("workspaceDiagnostics");
        if (iter_0 != object_0.end()) {
            value_0.workspaceDiagnostics = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DiagnosticRegistrationOptions attribute: workspaceDiagnostics"
            );
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::diagnosticRegistrationOptionsToAny(
        const DiagnosticRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.identifier.has_value()) {
            const auto &identifier_0 = param.identifier.value();
            object_0.emplace(
                "identifier",
                std::make_unique<LSPAny>(stringToAny(identifier_0))
            );
        }

        object_0.emplace(
            "interFileDependencies",
            std::make_unique<LSPAny>(booleanToAny(param.interFileDependencies))
        );

        object_0.emplace(
            "workspaceDiagnostics",
            std::make_unique<LSPAny>(booleanToAny(param.workspaceDiagnostics))
        );

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlineCompletionRegistrationOptions(
        const LSPAny &any
    ) const -> InlineCompletionRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlineCompletionRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlineCompletionRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlineCompletionRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InlineCompletionRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("id");
        if (iter_0 != object_0.end()) {
            value_0.id = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlineCompletionRegistrationOptionsToAny(
        const InlineCompletionRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.id.has_value()) {
            const auto &id_0 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_0))
            );
        }

        if (param.id.has_value()) {
            const auto &id_1 = param.id.value();
            object_0.emplace(
                "id",
                std::make_unique<LSPAny>(stringToAny(id_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentChangeRegistrationOptions(
        const LSPAny &any
    ) const -> TextDocumentChangeRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentChangeRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentChangeRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentChangeRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentChangeRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("syncKind");
        if (iter_0 != object_0.end()) {
            value_0.syncKind = anyToTextDocumentSyncKind(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentChangeRegistrationOptions attribute: syncKind"
            );
        }

        return value_0;
    }

    auto LspTransformer::textDocumentChangeRegistrationOptionsToAny(
        const TextDocumentChangeRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        object_0.emplace(
            "syncKind",
            std::make_unique<LSPAny>(textDocumentSyncKindToAny(param.syncKind))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentSaveRegistrationOptions(
        const LSPAny &any
    ) const -> TextDocumentSaveRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentSaveRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentSaveRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentSaveRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentSaveRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("includeText");
        if (iter_0 != object_0.end()) {
            value_0.includeText = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::textDocumentSaveRegistrationOptionsToAny(
        const TextDocumentSaveRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.includeText.has_value()) {
            const auto &includeText_0 = param.includeText.value();
            object_0.emplace(
                "includeText",
                std::make_unique<LSPAny>(booleanToAny(includeText_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCompletionRegistrationOptions(
        const LSPAny &any
    ) const -> CompletionRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 7) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 7")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CompletionRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("triggerCharacters");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.triggerCharacters = std::move(values_0);
        }

        iter_0 = object_0.find("allCommitCharacters");
        if (iter_0 != object_0.end()) {
            const auto &array_1 = iter_0->second->array();
            std::vector<string_t> values_1;
            for (const auto &elem_1 : array_1) {
                values_1.push_back(anyToString(*elem_1));
            }
            value_0.allCommitCharacters = std::move(values_1);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("completionItem");
        if (iter_0 != object_0.end()) {
            value_0.completionItem =
                anyToCompletionOptions_completionItem(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::completionRegistrationOptionsToAny(
        const CompletionRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.triggerCharacters.has_value()) {
            const auto &triggerCharacters_0 = param.triggerCharacters.value();
            LSPArray array_0;
            array_0.reserve(triggerCharacters_0.size());
            for (const auto &elem_0 : triggerCharacters_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = stringToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("triggerCharacters", std::move(any_1));
        }

        if (param.allCommitCharacters.has_value()) {
            const auto &allCommitCharacters_0 =
                param.allCommitCharacters.value();
            LSPArray array_1;
            array_1.reserve(allCommitCharacters_0.size());
            for (const auto &elem_1 : allCommitCharacters_0) {
                auto any_2 = std::make_unique<LSPAny>();
                (*any_2) = stringToAny(elem_1);
                array_1.push_back(std::move(any_2));
            }
            auto any_3 = std::make_unique<LSPAny>();
            (*any_3) = std::move(array_1);
            object_0.emplace("allCommitCharacters", std::move(any_3));
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        if (param.completionItem.has_value()) {
            const auto &completionItem_0 = param.completionItem.value();
            object_0.emplace(
                "completionItem",
                std::make_unique<LSPAny>(completionOptions_completionItemToAny(completionItem_0))
            );
        }

        LSPAny any_4;
        any_4 = std::move(object_0);
        return any_4;
    }

    auto LspTransformer::anyToHoverRegistrationOptions(
        const LSPAny &any
    ) const -> HoverRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "HoverRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        HoverRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "HoverRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required HoverRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::hoverRegistrationOptionsToAny(
        const HoverRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSignatureHelpRegistrationOptions(
        const LSPAny &any
    ) const -> SignatureHelpRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SignatureHelpRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SignatureHelpRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SignatureHelpRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SignatureHelpRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("triggerCharacters");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.triggerCharacters = std::move(values_0);
        }

        iter_0 = object_0.find("retriggerCharacters");
        if (iter_0 != object_0.end()) {
            const auto &array_1 = iter_0->second->array();
            std::vector<string_t> values_1;
            for (const auto &elem_1 : array_1) {
                values_1.push_back(anyToString(*elem_1));
            }
            value_0.retriggerCharacters = std::move(values_1);
        }

        return value_0;
    }

    auto LspTransformer::signatureHelpRegistrationOptionsToAny(
        const SignatureHelpRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.triggerCharacters.has_value()) {
            const auto &triggerCharacters_0 = param.triggerCharacters.value();
            LSPArray array_0;
            array_0.reserve(triggerCharacters_0.size());
            for (const auto &elem_0 : triggerCharacters_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = stringToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("triggerCharacters", std::move(any_1));
        }

        if (param.retriggerCharacters.has_value()) {
            const auto &retriggerCharacters_0 =
                param.retriggerCharacters.value();
            LSPArray array_1;
            array_1.reserve(retriggerCharacters_0.size());
            for (const auto &elem_1 : retriggerCharacters_0) {
                auto any_2 = std::make_unique<LSPAny>();
                (*any_2) = stringToAny(elem_1);
                array_1.push_back(std::move(any_2));
            }
            auto any_3 = std::make_unique<LSPAny>();
            (*any_3) = std::move(array_1);
            object_0.emplace("retriggerCharacters", std::move(any_3));
        }

        LSPAny any_4;
        any_4 = std::move(object_0);
        return any_4;
    }

    auto LspTransformer::anyToDefinitionRegistrationOptions(
        const LSPAny &any
    ) const -> DefinitionRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DefinitionRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DefinitionRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DefinitionRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DefinitionRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::definitionRegistrationOptionsToAny(
        const DefinitionRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToReferenceRegistrationOptions(
        const LSPAny &any
    ) const -> ReferenceRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ReferenceRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ReferenceRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ReferenceRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ReferenceRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::referenceRegistrationOptionsToAny(
        const ReferenceRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentHighlightRegistrationOptions(
        const LSPAny &any
    ) const -> DocumentHighlightRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentHighlightRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentHighlightRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentHighlightRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentHighlightRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentHighlightRegistrationOptionsToAny(
        const DocumentHighlightRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentSymbolRegistrationOptions(
        const LSPAny &any
    ) const -> DocumentSymbolRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentSymbolRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentSymbolRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentSymbolRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentSymbolRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("label");
        if (iter_0 != object_0.end()) {
            value_0.label = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentSymbolRegistrationOptionsToAny(
        const DocumentSymbolRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.label.has_value()) {
            const auto &label_0 = param.label.value();
            object_0.emplace(
                "label",
                std::make_unique<LSPAny>(stringToAny(label_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCodeActionRegistrationOptions(
        const LSPAny &any
    ) const -> CodeActionRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeActionRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeActionRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeActionRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CodeActionRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("codeActionKinds");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<CodeActionKind> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToCodeActionKind(*elem_0));
            }
            value_0.codeActionKinds = std::move(values_0);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::codeActionRegistrationOptionsToAny(
        const CodeActionRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.codeActionKinds.has_value()) {
            const auto &codeActionKinds_0 = param.codeActionKinds.value();
            LSPArray array_0;
            array_0.reserve(codeActionKinds_0.size());
            for (const auto &elem_0 : codeActionKinds_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = codeActionKindToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("codeActionKinds", std::move(any_1));
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToCodeLensRegistrationOptions(
        const LSPAny &any
    ) const -> CodeLensRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CodeLensRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CodeLensRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CodeLensRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CodeLensRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::codeLensRegistrationOptionsToAny(
        const CodeLensRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentLinkRegistrationOptions(
        const LSPAny &any
    ) const -> DocumentLinkRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentLinkRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentLinkRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentLinkRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentLinkRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("resolveProvider");
        if (iter_0 != object_0.end()) {
            value_0.resolveProvider = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentLinkRegistrationOptionsToAny(
        const DocumentLinkRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.resolveProvider.has_value()) {
            const auto &resolveProvider_0 = param.resolveProvider.value();
            object_0.emplace(
                "resolveProvider",
                std::make_unique<LSPAny>(booleanToAny(resolveProvider_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentFormattingRegistrationOptions(
        const LSPAny &any
    ) const -> DocumentFormattingRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentFormattingRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentFormattingRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentFormattingRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentFormattingRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentFormattingRegistrationOptionsToAny(
        const DocumentFormattingRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentRangeFormattingRegistrationOptions(
        const LSPAny &any
    ) const -> DocumentRangeFormattingRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentRangeFormattingRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentRangeFormattingRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentRangeFormattingRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentRangeFormattingRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("rangesSupport");
        if (iter_0 != object_0.end()) {
            value_0.rangesSupport = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentRangeFormattingRegistrationOptionsToAny(
        const DocumentRangeFormattingRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.rangesSupport.has_value()) {
            const auto &rangesSupport_0 = param.rangesSupport.value();
            object_0.emplace(
                "rangesSupport",
                std::make_unique<LSPAny>(booleanToAny(rangesSupport_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentOnTypeFormattingRegistrationOptions(
        const LSPAny &any
    ) const -> DocumentOnTypeFormattingRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentOnTypeFormattingRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentOnTypeFormattingRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentOnTypeFormattingRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentOnTypeFormattingRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("firstTriggerCharacter");
        if (iter_0 != object_0.end()) {
            value_0.firstTriggerCharacter = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentOnTypeFormattingRegistrationOptions attribute: firstTriggerCharacter"
            );
        }

        iter_0 = object_0.find("moreTriggerCharacter");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<string_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToString(*elem_0));
            }
            value_0.moreTriggerCharacter = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::documentOnTypeFormattingRegistrationOptionsToAny(
        const DocumentOnTypeFormattingRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        object_0.emplace(
            "firstTriggerCharacter",
            std::make_unique<LSPAny>(stringToAny(param.firstTriggerCharacter))
        );

        if (param.moreTriggerCharacter.has_value()) {
            const auto &moreTriggerCharacter_0 =
                param.moreTriggerCharacter.value();
            LSPArray array_0;
            array_0.reserve(moreTriggerCharacter_0.size());
            for (const auto &elem_0 : moreTriggerCharacter_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = stringToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("moreTriggerCharacter", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToRenameRegistrationOptions(
        const LSPAny &any
    ) const -> RenameRegistrationOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "RenameRegistrationOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        RenameRegistrationOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "RenameRegistrationOptions"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("documentSelector");
        if (iter_0 != object_0.end()) {
            value_0.documentSelector =
                anyToTextDocumentRegistrationOptions_documentSelector(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required RenameRegistrationOptions attribute: documentSelector"
            );
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("workDoneProgress");
        if (iter_0 != object_0.end()) {
            value_0.workDoneProgress = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("prepareProvider");
        if (iter_0 != object_0.end()) {
            value_0.prepareProvider = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::renameRegistrationOptionsToAny(
        const RenameRegistrationOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "documentSelector",
            std::make_unique<LSPAny>(textDocumentRegistrationOptions_documentSelectorToAny(param.documentSelector))
        );

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_0 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_0))
            );
        }

        if (param.workDoneProgress.has_value()) {
            const auto &workDoneProgress_1 = param.workDoneProgress.value();
            object_0.emplace(
                "workDoneProgress",
                std::make_unique<LSPAny>(booleanToAny(workDoneProgress_1))
            );
        }

        if (param.prepareProvider.has_value()) {
            const auto &prepareProvider_0 = param.prepareProvider.value();
            object_0.emplace(
                "prepareProvider",
                std::make_unique<LSPAny>(booleanToAny(prepareProvider_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyTo_InitializeParams_rootPath(
        const LSPAny &any
    ) const -> _InitializeParams_rootPath
    {
        _InitializeParams_rootPath value_0;

        switch (any.type()) {
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        case LSPAnyType::Null: {
            value_0 = anyToNull(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "_InitializeParams_rootPath"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::_InitializeParams_rootPathToAny(
        const _InitializeParams_rootPath &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case _InitializeParams_rootPathType::String: {
            return stringToAny(value.string());
        }
        case _InitializeParams_rootPathType::Null: {
            return nullToAny(value.null());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported _InitializeParams_rootPathType: " +
                 _InitializeParams_rootPathTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyTo_InitializeParams_rootUri(
        const LSPAny &any
    ) const -> _InitializeParams_rootUri
    {
        _InitializeParams_rootUri value_0;

        switch (any.type()) {
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        case LSPAnyType::Null: {
            value_0 = anyToNull(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "_InitializeParams_rootUri"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::_InitializeParams_rootUriToAny(
        const _InitializeParams_rootUri &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case _InitializeParams_rootUriType::String: {
            return documentUriToAny(value.documentUri());
        }
        case _InitializeParams_rootUriType::Null: {
            return nullToAny(value.null());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported _InitializeParams_rootUriType: " +
                 _InitializeParams_rootUriTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToWorkspaceFoldersInitializeParams_workspaceFolders(
        const LSPAny &any
    ) const -> WorkspaceFoldersInitializeParams_workspaceFolders
    {
        WorkspaceFoldersInitializeParams_workspaceFolders value_0;

        switch (any.type()) {
        case LSPAnyType::Array: {
            try {
                value_0 =
                    anyToWorkspaceFoldersInitializeParams_workspaceFolders_0(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to WorkspaceFoldersInitializeParams_workspaceFolders"
                );
            }
            break;
        }
        case LSPAnyType::Null: {
            value_0 = anyToNull(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "WorkspaceFoldersInitializeParams_workspaceFolders"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::workspaceFoldersInitializeParams_workspaceFoldersToAny(
        const WorkspaceFoldersInitializeParams_workspaceFolders &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case WorkspaceFoldersInitializeParams_workspaceFoldersType::WorkspaceFolderArray: {
            LSPArray array_0;
            array_0.reserve(value.workspaceFolderArray().size());
            for (const auto &elem_0 : value.workspaceFolderArray()) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = workspaceFolderToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            LSPAny any_1;
            any_1 = std::move(array_0);
            return any_1;
        }
        case WorkspaceFoldersInitializeParams_workspaceFoldersType::Null: {
            return nullToAny(value.null());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported WorkspaceFoldersInitializeParams_workspaceFoldersType: " +
                 WorkspaceFoldersInitializeParams_workspaceFoldersTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToWorkspaceFoldersInitializeParams(
        const LSPAny &any
    ) const -> WorkspaceFoldersInitializeParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkspaceFoldersInitializeParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkspaceFoldersInitializeParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkspaceFoldersInitializeParams"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("workspaceFolders");
        if (iter_0 != object_0.end()) {
            value_0.workspaceFolders =
                anyToWorkspaceFoldersInitializeParams_workspaceFolders(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workspaceFoldersInitializeParamsToAny(
        const WorkspaceFoldersInitializeParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.workspaceFolders.has_value()) {
            const auto &workspaceFolders_0 = param.workspaceFolders.value();
            object_0.emplace(
                "workspaceFolders",
                std::make_unique<LSPAny>(workspaceFoldersInitializeParams_workspaceFoldersToAny(workspaceFolders_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToServerCapabilities_declarationProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_declarationProvider
    {
        ServerCapabilities_declarationProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToDeclarationOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToDeclarationRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_declarationProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_declarationProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_declarationProviderToAny(
        const ServerCapabilities_declarationProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_declarationProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_declarationProviderType::DeclarationOptions: {
            return declarationOptionsToAny(value.declarationOptions());
        }
        case ServerCapabilities_declarationProviderType::DeclarationRegistrationOptions: {
            return declarationRegistrationOptionsToAny(value.declarationRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_declarationProviderType: " +
                 ServerCapabilities_declarationProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_typeDefinitionProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_typeDefinitionProvider
    {
        ServerCapabilities_typeDefinitionProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToTypeDefinitionOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToTypeDefinitionRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_typeDefinitionProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_typeDefinitionProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_typeDefinitionProviderToAny(
        const ServerCapabilities_typeDefinitionProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_typeDefinitionProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionOptions: {
            return typeDefinitionOptionsToAny(value.typeDefinitionOptions());
        }
        case ServerCapabilities_typeDefinitionProviderType::TypeDefinitionRegistrationOptions: {
            return typeDefinitionRegistrationOptionsToAny(value.typeDefinitionRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_typeDefinitionProviderType: " +
                 ServerCapabilities_typeDefinitionProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_implementationProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_implementationProvider
    {
        ServerCapabilities_implementationProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToImplementationOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToImplementationRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_implementationProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_implementationProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_implementationProviderToAny(
        const ServerCapabilities_implementationProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_implementationProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_implementationProviderType::ImplementationOptions: {
            return implementationOptionsToAny(value.implementationOptions());
        }
        case ServerCapabilities_implementationProviderType::ImplementationRegistrationOptions: {
            return implementationRegistrationOptionsToAny(value.implementationRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_implementationProviderType: " +
                 ServerCapabilities_implementationProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_colorProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_colorProvider
    {
        ServerCapabilities_colorProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToDocumentColorOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToDocumentColorRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_colorProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_colorProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_colorProviderToAny(
        const ServerCapabilities_colorProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_colorProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_colorProviderType::DocumentColorOptions: {
            return documentColorOptionsToAny(value.documentColorOptions());
        }
        case ServerCapabilities_colorProviderType::DocumentColorRegistrationOptions: {
            return documentColorRegistrationOptionsToAny(value.documentColorRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_colorProviderType: " +
                 ServerCapabilities_colorProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_foldingRangeProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_foldingRangeProvider
    {
        ServerCapabilities_foldingRangeProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToFoldingRangeOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToFoldingRangeRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_foldingRangeProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_foldingRangeProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_foldingRangeProviderToAny(
        const ServerCapabilities_foldingRangeProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_foldingRangeProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_foldingRangeProviderType::FoldingRangeOptions: {
            return foldingRangeOptionsToAny(value.foldingRangeOptions());
        }
        case ServerCapabilities_foldingRangeProviderType::FoldingRangeRegistrationOptions: {
            return foldingRangeRegistrationOptionsToAny(value.foldingRangeRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_foldingRangeProviderType: " +
                 ServerCapabilities_foldingRangeProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_selectionRangeProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_selectionRangeProvider
    {
        ServerCapabilities_selectionRangeProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToSelectionRangeOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToSelectionRangeRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_selectionRangeProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_selectionRangeProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_selectionRangeProviderToAny(
        const ServerCapabilities_selectionRangeProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_selectionRangeProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_selectionRangeProviderType::SelectionRangeOptions: {
            return selectionRangeOptionsToAny(value.selectionRangeOptions());
        }
        case ServerCapabilities_selectionRangeProviderType::SelectionRangeRegistrationOptions: {
            return selectionRangeRegistrationOptionsToAny(value.selectionRangeRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_selectionRangeProviderType: " +
                 ServerCapabilities_selectionRangeProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_callHierarchyProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_callHierarchyProvider
    {
        ServerCapabilities_callHierarchyProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToCallHierarchyOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToCallHierarchyRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_callHierarchyProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_callHierarchyProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_callHierarchyProviderToAny(
        const ServerCapabilities_callHierarchyProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_callHierarchyProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_callHierarchyProviderType::CallHierarchyOptions: {
            return callHierarchyOptionsToAny(value.callHierarchyOptions());
        }
        case ServerCapabilities_callHierarchyProviderType::CallHierarchyRegistrationOptions: {
            return callHierarchyRegistrationOptionsToAny(value.callHierarchyRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_callHierarchyProviderType: " +
                 ServerCapabilities_callHierarchyProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_linkedEditingRangeProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_linkedEditingRangeProvider
    {
        ServerCapabilities_linkedEditingRangeProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToLinkedEditingRangeOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToLinkedEditingRangeRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_linkedEditingRangeProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_linkedEditingRangeProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_linkedEditingRangeProviderToAny(
        const ServerCapabilities_linkedEditingRangeProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_linkedEditingRangeProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeOptions: {
            return linkedEditingRangeOptionsToAny(value.linkedEditingRangeOptions());
        }
        case ServerCapabilities_linkedEditingRangeProviderType::LinkedEditingRangeRegistrationOptions: {
            return linkedEditingRangeRegistrationOptionsToAny(value.linkedEditingRangeRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_linkedEditingRangeProviderType: " +
                 ServerCapabilities_linkedEditingRangeProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_monikerProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_monikerProvider
    {
        ServerCapabilities_monikerProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToMonikerOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToMonikerRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_monikerProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_monikerProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_monikerProviderToAny(
        const ServerCapabilities_monikerProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_monikerProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_monikerProviderType::MonikerOptions: {
            return monikerOptionsToAny(value.monikerOptions());
        }
        case ServerCapabilities_monikerProviderType::MonikerRegistrationOptions: {
            return monikerRegistrationOptionsToAny(value.monikerRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_monikerProviderType: " +
                 ServerCapabilities_monikerProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_typeHierarchyProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_typeHierarchyProvider
    {
        ServerCapabilities_typeHierarchyProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToTypeHierarchyOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToTypeHierarchyRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_typeHierarchyProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_typeHierarchyProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_typeHierarchyProviderToAny(
        const ServerCapabilities_typeHierarchyProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_typeHierarchyProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyOptions: {
            return typeHierarchyOptionsToAny(value.typeHierarchyOptions());
        }
        case ServerCapabilities_typeHierarchyProviderType::TypeHierarchyRegistrationOptions: {
            return typeHierarchyRegistrationOptionsToAny(value.typeHierarchyRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_typeHierarchyProviderType: " +
                 ServerCapabilities_typeHierarchyProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_inlineValueProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_inlineValueProvider
    {
        ServerCapabilities_inlineValueProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToInlineValueOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToInlineValueRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_inlineValueProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_inlineValueProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_inlineValueProviderToAny(
        const ServerCapabilities_inlineValueProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_inlineValueProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_inlineValueProviderType::InlineValueOptions: {
            return inlineValueOptionsToAny(value.inlineValueOptions());
        }
        case ServerCapabilities_inlineValueProviderType::InlineValueRegistrationOptions: {
            return inlineValueRegistrationOptionsToAny(value.inlineValueRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_inlineValueProviderType: " +
                 ServerCapabilities_inlineValueProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_inlayHintProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_inlayHintProvider
    {
        ServerCapabilities_inlayHintProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToInlayHintOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToInlayHintRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_inlayHintProvider"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Boolean: {
            value_0 = anyToBoolean(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_inlayHintProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_inlayHintProviderToAny(
        const ServerCapabilities_inlayHintProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_inlayHintProviderType::Boolean: {
            return booleanToAny(value.boolean());
        }
        case ServerCapabilities_inlayHintProviderType::InlayHintOptions: {
            return inlayHintOptionsToAny(value.inlayHintOptions());
        }
        case ServerCapabilities_inlayHintProviderType::InlayHintRegistrationOptions: {
            return inlayHintRegistrationOptionsToAny(value.inlayHintRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_inlayHintProviderType: " +
                 ServerCapabilities_inlayHintProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToServerCapabilities_diagnosticProvider(
        const LSPAny &any
    ) const -> ServerCapabilities_diagnosticProvider
    {
        ServerCapabilities_diagnosticProvider value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToDiagnosticOptions(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToDiagnosticRegistrationOptions(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to ServerCapabilities_diagnosticProvider"
                    );
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ServerCapabilities_diagnosticProvider"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::serverCapabilities_diagnosticProviderToAny(
        const ServerCapabilities_diagnosticProvider &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ServerCapabilities_diagnosticProviderType::DiagnosticOptions: {
            return diagnosticOptionsToAny(value.diagnosticOptions());
        }
        case ServerCapabilities_diagnosticProviderType::DiagnosticRegistrationOptions: {
            return diagnosticRegistrationOptionsToAny(value.diagnosticRegistrationOptions());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ServerCapabilities_diagnosticProviderType: " +
                 ServerCapabilities_diagnosticProviderTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToWorkspace_WorkspaceFoldersResult(
        const LSPAny &any
    ) const -> Workspace_WorkspaceFoldersResult
    {
        Workspace_WorkspaceFoldersResult value_0;

        switch (any.type()) {
        case LSPAnyType::Array: {
            try {
                value_0 = anyToWorkspace_WorkspaceFoldersResult_0(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to Workspace_WorkspaceFoldersResult"
                );
            }
            break;
        }
        case LSPAnyType::Null: {
            value_0 = anyToNull(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "Workspace_WorkspaceFoldersResult"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::workspace_WorkspaceFoldersResultToAny(
        const Workspace_WorkspaceFoldersResult &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case Workspace_WorkspaceFoldersResultType::WorkspaceFolderArray: {
            LSPArray array_0;
            array_0.reserve(value.workspaceFolderArray().size());
            for (const auto &elem_0 : value.workspaceFolderArray()) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = workspaceFolderToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            LSPAny any_1;
            any_1 = std::move(array_0);
            return any_1;
        }
        case Workspace_WorkspaceFoldersResultType::Null: {
            return nullToAny(value.null());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported Workspace_WorkspaceFoldersResultType: " +
                 Workspace_WorkspaceFoldersResultTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToWorkspace_FoldingRange_RefreshResult(
        const LSPAny &any
    ) const -> Workspace_FoldingRange_RefreshResult
    {
        switch (any.type()) {
        case LSPAnyType::Null: {
            return any.null();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type Workspace_FoldingRange_RefreshResult")
            );
        }
        }
    }

    auto LspTransformer::workspace_FoldingRange_RefreshResultToAny(
        const Workspace_FoldingRange_RefreshResult &alias
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::anyToWindow_WorkDoneProgress_CreateResult(
        const LSPAny &any
    ) const -> Window_WorkDoneProgress_CreateResult
    {
        switch (any.type()) {
        case LSPAnyType::Null: {
            return any.null();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type Window_WorkDoneProgress_CreateResult")
            );
        }
        }
    }

    auto LspTransformer::window_WorkDoneProgress_CreateResultToAny(
        const Window_WorkDoneProgress_CreateResult &alias
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::anyToWorkspace_SemanticTokens_RefreshResult(
        const LSPAny &any
    ) const -> Workspace_SemanticTokens_RefreshResult
    {
        switch (any.type()) {
        case LSPAnyType::Null: {
            return any.null();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type Workspace_SemanticTokens_RefreshResult")
            );
        }
        }
    }

    auto LspTransformer::workspace_SemanticTokens_RefreshResultToAny(
        const Workspace_SemanticTokens_RefreshResult &alias
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::anyToTextDocument_MonikerResult(
        const LSPAny &any
    ) const -> TextDocument_MonikerResult
    {
        TextDocument_MonikerResult value_0;

        switch (any.type()) {
        case LSPAnyType::Array: {
            try {
                value_0 = anyToTextDocument_MonikerResult_0(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to TextDocument_MonikerResult"
                );
            }
            break;
        }
        case LSPAnyType::Null: {
            value_0 = anyToNull(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "TextDocument_MonikerResult"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::textDocument_MonikerResultToAny(
        const TextDocument_MonikerResult &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case TextDocument_MonikerResultType::MonikerArray: {
            LSPArray array_0;
            array_0.reserve(value.monikerArray().size());
            for (const auto &elem_0 : value.monikerArray()) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = monikerToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            LSPAny any_1;
            any_1 = std::move(array_0);
            return any_1;
        }
        case TextDocument_MonikerResultType::Null: {
            return nullToAny(value.null());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported TextDocument_MonikerResultType: " +
                 TextDocument_MonikerResultTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToWorkspace_InlineValue_RefreshResult(
        const LSPAny &any
    ) const -> Workspace_InlineValue_RefreshResult
    {
        switch (any.type()) {
        case LSPAnyType::Null: {
            return any.null();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type Workspace_InlineValue_RefreshResult")
            );
        }
        }
    }

    auto LspTransformer::workspace_InlineValue_RefreshResultToAny(
        const Workspace_InlineValue_RefreshResult &alias
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::anyToWorkspace_InlayHint_RefreshResult(
        const LSPAny &any
    ) const -> Workspace_InlayHint_RefreshResult
    {
        switch (any.type()) {
        case LSPAnyType::Null: {
            return any.null();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type Workspace_InlayHint_RefreshResult")
            );
        }
        }
    }

    auto LspTransformer::workspace_InlayHint_RefreshResultToAny(
        const Workspace_InlayHint_RefreshResult &alias
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::anyToWorkspace_Diagnostic_RefreshResult(
        const LSPAny &any
    ) const -> Workspace_Diagnostic_RefreshResult
    {
        switch (any.type()) {
        case LSPAnyType::Null: {
            return any.null();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type Workspace_Diagnostic_RefreshResult")
            );
        }
        }
    }

    auto LspTransformer::workspace_Diagnostic_RefreshResultToAny(
        const Workspace_Diagnostic_RefreshResult &alias
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::anyToClient_RegisterCapabilityResult(
        const LSPAny &any
    ) const -> Client_RegisterCapabilityResult
    {
        switch (any.type()) {
        case LSPAnyType::Null: {
            return any.null();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type Client_RegisterCapabilityResult")
            );
        }
        }
    }

    auto LspTransformer::client_RegisterCapabilityResultToAny(
        const Client_RegisterCapabilityResult &alias
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::anyToClient_UnregisterCapabilityResult(
        const LSPAny &any
    ) const -> Client_UnregisterCapabilityResult
    {
        switch (any.type()) {
        case LSPAnyType::Null: {
            return any.null();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type Client_UnregisterCapabilityResult")
            );
        }
        }
    }

    auto LspTransformer::client_UnregisterCapabilityResultToAny(
        const Client_UnregisterCapabilityResult &alias
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::asMessageParams(
        const UnregistrationParams &requestParams
    ) const -> MessageParams
    {
        MessageParams messageParams_0;
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(requestParams.unregisterations.size());
        for (const auto &elem_0 : requestParams.unregisterations) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = unregistrationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = array_0;
        object_0.emplace("unregisterations", std::move(any_1));

        messageParams_0 = std::move(object_0);
        return messageParams_0;
    }

    auto LspTransformer::anyToShutdownResult(
        const LSPAny &any
    ) const -> ShutdownResult
    {
        switch (any.type()) {
        case LSPAnyType::Null: {
            return any.null();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type ShutdownResult")
            );
        }
        }
    }

    auto LspTransformer::shutdownResultToAny(
        const ShutdownResult &alias
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::anyToWindow_ShowMessageRequestResult(
        const LSPAny &any
    ) const -> Window_ShowMessageRequestResult
    {
        Window_ShowMessageRequestResult value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToMessageActionItem(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to Window_ShowMessageRequestResult"
                );
            }
            break;
        }
        case LSPAnyType::Null: {
            value_0 = anyToNull(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "Window_ShowMessageRequestResult"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::window_ShowMessageRequestResultToAny(
        const Window_ShowMessageRequestResult &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case Window_ShowMessageRequestResultType::MessageActionItem: {
            return messageActionItemToAny(value.messageActionItem());
        }
        case Window_ShowMessageRequestResultType::Null: {
            return nullToAny(value.null());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported Window_ShowMessageRequestResultType: " +
                 Window_ShowMessageRequestResultTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::asMessageParams(
        const ShowMessageRequestParams &requestParams
    ) const -> MessageParams
    {
        MessageParams messageParams_0;
        LSPObject object_0;

        auto any_0 = std::make_unique<LSPAny>();
        (*any_0) = messageTypeToAny(requestParams.type);
        object_0.emplace("type", std::move(any_0));

        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = stringToAny(requestParams.message);
        object_0.emplace("message", std::move(any_1));

        if (requestParams.actions.has_value()) {
            LSPArray array_0;
            array_0.reserve(requestParams.actions.value().size());
            for (const auto &elem_0 : requestParams.actions.value()) {
                auto any_2 = std::make_unique<LSPAny>();
                (*any_2) = messageActionItemToAny(elem_0);
                array_0.push_back(std::move(any_2));
            }
            auto any_3 = std::make_unique<LSPAny>();
            (*any_3) = array_0;
            object_0.emplace("actions", std::move(any_3));
        }

        messageParams_0 = std::move(object_0);
        return messageParams_0;
    }

    auto LspTransformer::anyToWorkspace_CodeLens_RefreshResult(
        const LSPAny &any
    ) const -> Workspace_CodeLens_RefreshResult
    {
        switch (any.type()) {
        case LSPAnyType::Null: {
            return any.null();
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type Workspace_CodeLens_RefreshResult")
            );
        }
        }
    }

    auto LspTransformer::workspace_CodeLens_RefreshResultToAny(
        const Workspace_CodeLens_RefreshResult &alias
    ) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = alias;
        return any_0;
    }

    auto LspTransformer::uintegerToAny(uinteger_t param) const -> LSPAny
    {
        LSPAny any_0;
        any_0 = param;
        return any_0;
    }

    auto LspTransformer::anyToUInteger(const LSPAny &any) const -> uinteger_t
    {
        switch (any.type()) {
        case LSPAnyType::UInteger: {
            return any.uinteger();
        }
        case LSPAnyType::Integer: {
            return static_cast<uinteger_t>(any.integer());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Cannot transform LSPAny of type LSPAnyType::" +
                 LSPAnyTypeNames.at(any.type()) +
                 " to type uinteger_t")
            );
        }
        }
    }

    auto LspTransformer::anyToFoldingRange(
        const LSPAny &any
    ) const -> FoldingRange
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FoldingRange"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FoldingRange value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 6) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FoldingRange"
                 ": " + std::to_string(object_0.size()) + " > 6")
            );
        }

        iter_0 = object_0.find("startLine");
        if (iter_0 != object_0.end()) {
            value_0.startLine = anyToUInteger(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FoldingRange attribute: startLine"
            );
        }

        iter_0 = object_0.find("startCharacter");
        if (iter_0 != object_0.end()) {
            value_0.startCharacter = anyToUInteger(*iter_0->second);
        }

        iter_0 = object_0.find("endLine");
        if (iter_0 != object_0.end()) {
            value_0.endLine = anyToUInteger(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FoldingRange attribute: endLine"
            );
        }

        iter_0 = object_0.find("endCharacter");
        if (iter_0 != object_0.end()) {
            value_0.endCharacter = anyToUInteger(*iter_0->second);
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToFoldingRangeKind(*iter_0->second);
        }

        iter_0 = object_0.find("collapsedText");
        if (iter_0 != object_0.end()) {
            value_0.collapsedText = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::foldingRangeToAny(
        const FoldingRange &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "startLine",
            std::make_unique<LSPAny>(uintegerToAny(param.startLine))
        );

        if (param.startCharacter.has_value()) {
            const auto &startCharacter_0 = param.startCharacter.value();
            object_0.emplace(
                "startCharacter",
                std::make_unique<LSPAny>(uintegerToAny(startCharacter_0))
            );
        }

        object_0.emplace(
            "endLine",
            std::make_unique<LSPAny>(uintegerToAny(param.endLine))
        );

        if (param.endCharacter.has_value()) {
            const auto &endCharacter_0 = param.endCharacter.value();
            object_0.emplace(
                "endCharacter",
                std::make_unique<LSPAny>(uintegerToAny(endCharacter_0))
            );
        }

        if (param.kind.has_value()) {
            const auto &kind_0 = param.kind.value();
            object_0.emplace(
                "kind",
                std::make_unique<LSPAny>(foldingRangeKindToAny(kind_0))
            );
        }

        if (param.collapsedText.has_value()) {
            const auto &collapsedText_0 = param.collapsedText.value();
            object_0.emplace(
                "collapsedText",
                std::make_unique<LSPAny>(stringToAny(collapsedText_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSemanticTokens(
        const LSPAny &any
    ) const -> SemanticTokens
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SemanticTokens"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SemanticTokens value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SemanticTokens"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("resultId");
        if (iter_0 != object_0.end()) {
            value_0.resultId = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("data");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<uinteger_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToUInteger(*elem_0));
            }
            value_0.data = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SemanticTokens attribute: data"
            );
        }

        return value_0;
    }

    auto LspTransformer::semanticTokensToAny(
        const SemanticTokens &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.resultId.has_value()) {
            const auto &resultId_0 = param.resultId.value();
            object_0.emplace(
                "resultId",
                std::make_unique<LSPAny>(stringToAny(resultId_0))
            );
        }

        LSPArray array_0;
        array_0.reserve(param.data.size());
        for (const auto &elem_0 : param.data) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = uintegerToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("data", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::semanticTokens_dataToAny(
        const SemanticTokens_data &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = uintegerToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSemanticTokens_data(
        const LSPAny &any
    ) const -> SemanticTokens_data
    {
        const auto &array_0 = any.array();
        std::vector<uinteger_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToUInteger(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToSemanticTokensPartialResult(
        const LSPAny &any
    ) const -> SemanticTokensPartialResult
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SemanticTokensPartialResult"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SemanticTokensPartialResult value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SemanticTokensPartialResult"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("data");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<uinteger_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToUInteger(*elem_0));
            }
            value_0.data = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SemanticTokensPartialResult attribute: data"
            );
        }

        return value_0;
    }

    auto LspTransformer::semanticTokensPartialResultToAny(
        const SemanticTokensPartialResult &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.data.size());
        for (const auto &elem_0 : param.data) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = uintegerToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("data", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::semanticTokensPartialResult_dataToAny(
        const SemanticTokensPartialResult_data &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = uintegerToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSemanticTokensPartialResult_data(
        const LSPAny &any
    ) const -> SemanticTokensPartialResult_data
    {
        const auto &array_0 = any.array();
        std::vector<uinteger_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToUInteger(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToApplyWorkspaceEditResult(
        const LSPAny &any
    ) const -> ApplyWorkspaceEditResult
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "ApplyWorkspaceEditResult"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ApplyWorkspaceEditResult value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "ApplyWorkspaceEditResult"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("applied");
        if (iter_0 != object_0.end()) {
            value_0.applied = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ApplyWorkspaceEditResult attribute: applied"
            );
        }

        iter_0 = object_0.find("failureReason");
        if (iter_0 != object_0.end()) {
            value_0.failureReason = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("failedChange");
        if (iter_0 != object_0.end()) {
            value_0.failedChange = anyToUInteger(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::applyWorkspaceEditResultToAny(
        const ApplyWorkspaceEditResult &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "applied",
            std::make_unique<LSPAny>(booleanToAny(param.applied))
        );

        if (param.failureReason.has_value()) {
            const auto &failureReason_0 = param.failureReason.value();
            object_0.emplace(
                "failureReason",
                std::make_unique<LSPAny>(stringToAny(failureReason_0))
            );
        }

        if (param.failedChange.has_value()) {
            const auto &failedChange_0 = param.failedChange.value();
            object_0.emplace(
                "failedChange",
                std::make_unique<LSPAny>(uintegerToAny(failedChange_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWorkDoneProgressBegin(
        const LSPAny &any
    ) const -> WorkDoneProgressBegin
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkDoneProgressBegin"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkDoneProgressBegin value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkDoneProgressBegin"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            const auto &value_1 = anyToString(*iter_0->second);
            if (value_1 != "begin") {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("String value for "
                     "WorkDoneProgressBegin.kind"
                     " must be \"begin\""
                     " but was: \"value_1\"")
                );
            }
            value_0.kind = value_1;
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WorkDoneProgressBegin attribute: kind"
            );
        }

        iter_0 = object_0.find("title");
        if (iter_0 != object_0.end()) {
            value_0.title = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WorkDoneProgressBegin attribute: title"
            );
        }

        iter_0 = object_0.find("cancellable");
        if (iter_0 != object_0.end()) {
            value_0.cancellable = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("message");
        if (iter_0 != object_0.end()) {
            value_0.message = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("percentage");
        if (iter_0 != object_0.end()) {
            value_0.percentage = anyToUInteger(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workDoneProgressBeginToAny(
        const WorkDoneProgressBegin &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        object_0.emplace(
            "title",
            std::make_unique<LSPAny>(stringToAny(param.title))
        );

        if (param.cancellable.has_value()) {
            const auto &cancellable_0 = param.cancellable.value();
            object_0.emplace(
                "cancellable",
                std::make_unique<LSPAny>(booleanToAny(cancellable_0))
            );
        }

        if (param.message.has_value()) {
            const auto &message_0 = param.message.value();
            object_0.emplace(
                "message",
                std::make_unique<LSPAny>(stringToAny(message_0))
            );
        }

        if (param.percentage.has_value()) {
            const auto &percentage_0 = param.percentage.value();
            object_0.emplace(
                "percentage",
                std::make_unique<LSPAny>(uintegerToAny(percentage_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWorkDoneProgressReport(
        const LSPAny &any
    ) const -> WorkDoneProgressReport
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "WorkDoneProgressReport"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        WorkDoneProgressReport value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "WorkDoneProgressReport"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            const auto &value_1 = anyToString(*iter_0->second);
            if (value_1 != "report") {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    ("String value for "
                     "WorkDoneProgressReport.kind"
                     " must be \"report\""
                     " but was: \"value_1\"")
                );
            }
            value_0.kind = value_1;
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required WorkDoneProgressReport attribute: kind"
            );
        }

        iter_0 = object_0.find("cancellable");
        if (iter_0 != object_0.end()) {
            value_0.cancellable = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("message");
        if (iter_0 != object_0.end()) {
            value_0.message = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("percentage");
        if (iter_0 != object_0.end()) {
            value_0.percentage = anyToUInteger(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::workDoneProgressReportToAny(
        const WorkDoneProgressReport &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(stringToAny(param.kind))
        );

        if (param.cancellable.has_value()) {
            const auto &cancellable_0 = param.cancellable.value();
            object_0.emplace(
                "cancellable",
                std::make_unique<LSPAny>(booleanToAny(cancellable_0))
            );
        }

        if (param.message.has_value()) {
            const auto &message_0 = param.message.value();
            object_0.emplace(
                "message",
                std::make_unique<LSPAny>(stringToAny(message_0))
            );
        }

        if (param.percentage.has_value()) {
            const auto &percentage_0 = param.percentage.value();
            object_0.emplace(
                "percentage",
                std::make_unique<LSPAny>(uintegerToAny(percentage_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToPosition(const LSPAny &any) const -> Position
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "Position"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        Position value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "Position"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("line");
        if (iter_0 != object_0.end()) {
            value_0.line = anyToUInteger(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Position attribute: line"
            );
        }

        iter_0 = object_0.find("character");
        if (iter_0 != object_0.end()) {
            value_0.character = anyToUInteger(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Position attribute: character"
            );
        }

        return value_0;
    }

    auto LspTransformer::positionToAny(const Position &param) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "line",
            std::make_unique<LSPAny>(uintegerToAny(param.line))
        );

        object_0.emplace(
            "character",
            std::make_unique<LSPAny>(uintegerToAny(param.character))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::selectionRangeParams_positionsToAny(
        const SelectionRangeParams_positions &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = positionToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSelectionRangeParams_positions(
        const LSPAny &any
    ) const -> SelectionRangeParams_positions
    {
        const auto &array_0 = any.array();
        std::vector<Position> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToPosition(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToTextDocumentPositionParams(
        const LSPAny &any
    ) const -> TextDocumentPositionParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentPositionParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentPositionParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentPositionParams"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("textDocument");
        if (iter_0 != object_0.end()) {
            value_0.textDocument =
                anyToTextDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentPositionParams attribute: textDocument"
            );
        }

        iter_0 = object_0.find("position");
        if (iter_0 != object_0.end()) {
            value_0.position = anyToPosition(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentPositionParams attribute: position"
            );
        }

        return value_0;
    }

    auto LspTransformer::textDocumentPositionParamsToAny(
        const TextDocumentPositionParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "textDocument",
            std::make_unique<LSPAny>(textDocumentIdentifierToAny(param.textDocument))
        );

        object_0.emplace(
            "position",
            std::make_unique<LSPAny>(positionToAny(param.position))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToRange(const LSPAny &any) const -> Range
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "Range"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        Range value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "Range"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("start");
        if (iter_0 != object_0.end()) {
            value_0.start = anyToPosition(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Range attribute: start"
            );
        }

        iter_0 = object_0.find("end");
        if (iter_0 != object_0.end()) {
            value_0.end = anyToPosition(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Range attribute: end"
            );
        }

        return value_0;
    }

    auto LspTransformer::rangeToAny(const Range &param) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "start",
            std::make_unique<LSPAny>(positionToAny(param.start))
        );

        object_0.emplace(
            "end",
            std::make_unique<LSPAny>(positionToAny(param.end))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToLocation(const LSPAny &any) const -> Location
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "Location"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        Location value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "Location"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToDocumentUri(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Location attribute: uri"
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Location attribute: range"
            );
        }

        return value_0;
    }

    auto LspTransformer::locationToAny(const Location &param) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "uri",
            std::make_unique<LSPAny>(documentUriToAny(param.uri))
        );

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSelectionRange(
        const LSPAny &any
    ) const -> SelectionRange
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SelectionRange"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SelectionRange value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SelectionRange"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SelectionRange attribute: range"
            );
        }

        iter_0 = object_0.find("parent");
        if (iter_0 != object_0.end()) {
            value_0.parent =
                std::make_unique<SelectionRange>(anyToSelectionRange(*iter_0->second));
        }

        return value_0;
    }

    auto LspTransformer::selectionRangeToAny(
        const SelectionRange &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        if (param.parent.has_value()) {
            const auto &parent_0 = param.parent.value();
            object_0.emplace(
                "parent",
                std::make_unique<LSPAny>(selectionRangeToAny(*parent_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::callHierarchyIncomingCall_fromRangesToAny(
        const CallHierarchyIncomingCall_fromRanges &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = rangeToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCallHierarchyIncomingCall_fromRanges(
        const LSPAny &any
    ) const -> CallHierarchyIncomingCall_fromRanges
    {
        const auto &array_0 = any.array();
        std::vector<Range> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToRange(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::callHierarchyOutgoingCall_fromRangesToAny(
        const CallHierarchyOutgoingCall_fromRanges &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = rangeToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCallHierarchyOutgoingCall_fromRanges(
        const LSPAny &any
    ) const -> CallHierarchyOutgoingCall_fromRanges
    {
        const auto &array_0 = any.array();
        std::vector<Range> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToRange(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToShowDocumentParams(
        const LSPAny &any
    ) const -> ShowDocumentParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ShowDocumentParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ShowDocumentParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ShowDocumentParams"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("uri");
        if (iter_0 != object_0.end()) {
            value_0.uri = anyToURI(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ShowDocumentParams attribute: uri"
            );
        }

        iter_0 = object_0.find("external");
        if (iter_0 != object_0.end()) {
            value_0.external = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("takeFocus");
        if (iter_0 != object_0.end()) {
            value_0.takeFocus = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("selection");
        if (iter_0 != object_0.end()) {
            value_0.selection = anyToRange(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::showDocumentParamsToAny(
        const ShowDocumentParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace("uri", std::make_unique<LSPAny>(uriToAny(param.uri)));

        if (param.external.has_value()) {
            const auto &external_0 = param.external.value();
            object_0.emplace(
                "external",
                std::make_unique<LSPAny>(booleanToAny(external_0))
            );
        }

        if (param.takeFocus.has_value()) {
            const auto &takeFocus_0 = param.takeFocus.value();
            object_0.emplace(
                "takeFocus",
                std::make_unique<LSPAny>(booleanToAny(takeFocus_0))
            );
        }

        if (param.selection.has_value()) {
            const auto &selection_0 = param.selection.value();
            object_0.emplace(
                "selection",
                std::make_unique<LSPAny>(rangeToAny(selection_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToLinkedEditingRanges(
        const LSPAny &any
    ) const -> LinkedEditingRanges
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "LinkedEditingRanges"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        LinkedEditingRanges value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "LinkedEditingRanges"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("ranges");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<Range> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToRange(*elem_0));
            }
            value_0.ranges = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required LinkedEditingRanges attribute: ranges"
            );
        }

        iter_0 = object_0.find("wordPattern");
        if (iter_0 != object_0.end()) {
            value_0.wordPattern = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::linkedEditingRangesToAny(
        const LinkedEditingRanges &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.ranges.size());
        for (const auto &elem_0 : param.ranges) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = rangeToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("ranges", std::move(any_1));

        if (param.wordPattern.has_value()) {
            const auto &wordPattern_0 = param.wordPattern.value();
            object_0.emplace(
                "wordPattern",
                std::make_unique<LSPAny>(stringToAny(wordPattern_0))
            );
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::linkedEditingRanges_rangesToAny(
        const LinkedEditingRanges_ranges &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = rangeToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToLinkedEditingRanges_ranges(
        const LSPAny &any
    ) const -> LinkedEditingRanges_ranges
    {
        const auto &array_0 = any.array();
        std::vector<Range> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToRange(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToTextEdit(const LSPAny &any) const -> TextEdit
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextEdit"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextEdit value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextEdit"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextEdit attribute: range"
            );
        }

        iter_0 = object_0.find("newText");
        if (iter_0 != object_0.end()) {
            value_0.newText = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextEdit attribute: newText"
            );
        }

        return value_0;
    }

    auto LspTransformer::textEditToAny(const TextEdit &param) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        object_0.emplace(
            "newText",
            std::make_unique<LSPAny>(stringToAny(param.newText))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToColorPresentation(
        const LSPAny &any
    ) const -> ColorPresentation
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ColorPresentation"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ColorPresentation value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ColorPresentation"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("label");
        if (iter_0 != object_0.end()) {
            value_0.label = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ColorPresentation attribute: label"
            );
        }

        iter_0 = object_0.find("textEdit");
        if (iter_0 != object_0.end()) {
            value_0.textEdit = anyToTextEdit(*iter_0->second);
        }

        iter_0 = object_0.find("additionalTextEdits");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<TextEdit> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToTextEdit(*elem_0));
            }
            value_0.additionalTextEdits = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::colorPresentationToAny(
        const ColorPresentation &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "label",
            std::make_unique<LSPAny>(stringToAny(param.label))
        );

        if (param.textEdit.has_value()) {
            const auto &textEdit_0 = param.textEdit.value();
            object_0.emplace(
                "textEdit",
                std::make_unique<LSPAny>(textEditToAny(textEdit_0))
            );
        }

        if (param.additionalTextEdits.has_value()) {
            const auto &additionalTextEdits_0 =
                param.additionalTextEdits.value();
            LSPArray array_0;
            array_0.reserve(additionalTextEdits_0.size());
            for (const auto &elem_0 : additionalTextEdits_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = textEditToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("additionalTextEdits", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::colorPresentation_additionalTextEditsToAny(
        const ColorPresentation_additionalTextEdits &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = textEditToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToColorPresentation_additionalTextEdits(
        const LSPAny &any
    ) const -> ColorPresentation_additionalTextEdits
    {
        const auto &array_0 = any.array();
        std::vector<TextEdit> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToTextEdit(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::workspaceEdit_changesToAny(
        const WorkspaceEdit_changes &map
    ) const -> LSPAny
    {
        LSPObject object_0;
        for (const auto &[key_0, value_0] : map) {
            object_0.emplace(
                key_0,
                std::make_unique<LSPAny>(workspaceEdit_changes_valueToAny(value_0))
            );
        }
        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToWorkspaceEdit_changes(
        const LSPAny &any
    ) const -> WorkspaceEdit_changes
    {
        std::map<DocumentUri, std::vector<TextEdit>> map_0;
        for (const auto &[key_0, value_0] : any.object()) {
            map_0.emplace(key_0, anyToWorkspaceEdit_changes_value(*value_0));
        }
        return map_0;
    }

    auto LspTransformer::workspaceEdit_changes_valueToAny(
        const WorkspaceEdit_changes_value &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = textEditToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToWorkspaceEdit_changes_value(
        const LSPAny &any
    ) const -> WorkspaceEdit_changes_value
    {
        const auto &array_0 = any.array();
        std::vector<TextEdit> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToTextEdit(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::inlayHint_textEditsToAny(
        const InlayHint_textEdits &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = textEditToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToInlayHint_textEdits(
        const LSPAny &any
    ) const -> InlayHint_textEdits
    {
        const auto &array_0 = any.array();
        std::vector<TextEdit> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToTextEdit(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::completionItem_additionalTextEditsToAny(
        const CompletionItem_additionalTextEdits &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = textEditToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToCompletionItem_additionalTextEdits(
        const LSPAny &any
    ) const -> CompletionItem_additionalTextEdits
    {
        const auto &array_0 = any.array();
        std::vector<TextEdit> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToTextEdit(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToCompletionList_itemDefaults_editRange_1(
        const LSPAny &any
    ) const -> CompletionList_itemDefaults_editRange_1
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "CompletionList_itemDefaults_editRange_1"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        CompletionList_itemDefaults_editRange_1 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "CompletionList_itemDefaults_editRange_1"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("insert");
        if (iter_0 != object_0.end()) {
            value_0.insert = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CompletionList_itemDefaults_editRange_1 attribute: insert"
            );
        }

        iter_0 = object_0.find("replace");
        if (iter_0 != object_0.end()) {
            value_0.replace = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required CompletionList_itemDefaults_editRange_1 attribute: replace"
            );
        }

        return value_0;
    }

    auto LspTransformer::completionList_itemDefaults_editRange_1ToAny(
        const CompletionList_itemDefaults_editRange_1 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "insert",
            std::make_unique<LSPAny>(rangeToAny(param.insert))
        );

        object_0.emplace(
            "replace",
            std::make_unique<LSPAny>(rangeToAny(param.replace))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCompletionList_itemDefaults_editRange(
        const LSPAny &any
    ) const -> CompletionList_itemDefaults_editRange
    {
        CompletionList_itemDefaults_editRange value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToRange(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 =
                        anyToCompletionList_itemDefaults_editRange_1(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to CompletionList_itemDefaults_editRange"
                    );
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "CompletionList_itemDefaults_editRange"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::completionList_itemDefaults_editRangeToAny(
        const CompletionList_itemDefaults_editRange &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case CompletionList_itemDefaults_editRangeType::Range: {
            return rangeToAny(value.range());
        }
        case CompletionList_itemDefaults_editRangeType::CompletionList_itemDefaults_editRange_1: {
            return completionList_itemDefaults_editRange_1ToAny(value.completionList_itemDefaults_editRange_1());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported CompletionList_itemDefaults_editRangeType: " +
                 CompletionList_itemDefaults_editRangeTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToHover(const LSPAny &any) const -> Hover
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "Hover"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        Hover value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "Hover"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("contents");
        if (iter_0 != object_0.end()) {
            value_0.contents = anyToHover_contents(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required Hover attribute: contents"
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::hoverToAny(const Hover &param) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "contents",
            std::make_unique<LSPAny>(hover_contentsToAny(param.contents))
        );

        if (param.range.has_value()) {
            const auto &range_0 = param.range.value();
            object_0.emplace(
                "range",
                std::make_unique<LSPAny>(rangeToAny(range_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentHighlight(
        const LSPAny &any
    ) const -> DocumentHighlight
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentHighlight"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentHighlight value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentHighlight"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentHighlight attribute: range"
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToDocumentHighlightKind(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::documentHighlightToAny(
        const DocumentHighlight &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        if (param.kind.has_value()) {
            const auto &kind_0 = param.kind.value();
            object_0.emplace(
                "kind",
                std::make_unique<LSPAny>(documentHighlightKindToAny(kind_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSymbolInformation(
        const LSPAny &any
    ) const -> SymbolInformation
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SymbolInformation"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SymbolInformation value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 6) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SymbolInformation"
                 ": " + std::to_string(object_0.size()) + " > 6")
            );
        }

        iter_0 = object_0.find("name");
        if (iter_0 != object_0.end()) {
            value_0.name = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SymbolInformation attribute: name"
            );
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToSymbolKind(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SymbolInformation attribute: kind"
            );
        }

        iter_0 = object_0.find("tags");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<SymbolTag> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToSymbolTag(*elem_0));
            }
            value_0.tags = std::move(values_0);
        }

        iter_0 = object_0.find("containerName");
        if (iter_0 != object_0.end()) {
            value_0.containerName = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("deprecated");
        if (iter_0 != object_0.end()) {
            value_0.deprecated = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("location");
        if (iter_0 != object_0.end()) {
            value_0.location = anyToLocation(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SymbolInformation attribute: location"
            );
        }

        return value_0;
    }

    auto LspTransformer::symbolInformationToAny(
        const SymbolInformation &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "name",
            std::make_unique<LSPAny>(stringToAny(param.name))
        );

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(symbolKindToAny(param.kind))
        );

        if (param.tags.has_value()) {
            const auto &tags_0 = param.tags.value();
            LSPArray array_0;
            array_0.reserve(tags_0.size());
            for (const auto &elem_0 : tags_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = symbolTagToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("tags", std::move(any_1));
        }

        if (param.containerName.has_value()) {
            const auto &containerName_0 = param.containerName.value();
            object_0.emplace(
                "containerName",
                std::make_unique<LSPAny>(stringToAny(containerName_0))
            );
        }

        if (param.deprecated.has_value()) {
            const auto &deprecated_0 = param.deprecated.value();
            object_0.emplace(
                "deprecated",
                std::make_unique<LSPAny>(booleanToAny(deprecated_0))
            );
        }

        object_0.emplace(
            "location",
            std::make_unique<LSPAny>(locationToAny(param.location))
        );

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToDocumentSymbol(
        const LSPAny &any
    ) const -> DocumentSymbol
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentSymbol"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentSymbol value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 8) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentSymbol"
                 ": " + std::to_string(object_0.size()) + " > 8")
            );
        }

        iter_0 = object_0.find("name");
        if (iter_0 != object_0.end()) {
            value_0.name = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentSymbol attribute: name"
            );
        }

        iter_0 = object_0.find("detail");
        if (iter_0 != object_0.end()) {
            value_0.detail = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("kind");
        if (iter_0 != object_0.end()) {
            value_0.kind = anyToSymbolKind(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentSymbol attribute: kind"
            );
        }

        iter_0 = object_0.find("tags");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<SymbolTag> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToSymbolTag(*elem_0));
            }
            value_0.tags = std::move(values_0);
        }

        iter_0 = object_0.find("deprecated");
        if (iter_0 != object_0.end()) {
            value_0.deprecated = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentSymbol attribute: range"
            );
        }

        iter_0 = object_0.find("selectionRange");
        if (iter_0 != object_0.end()) {
            value_0.selectionRange = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentSymbol attribute: selectionRange"
            );
        }

        iter_0 = object_0.find("children");
        if (iter_0 != object_0.end()) {
            const auto &array_1 = iter_0->second->array();
            std::vector<std::unique_ptr<DocumentSymbol>> values_1;
            for (const auto &elem_1 : array_1) {
                values_1.push_back(
                    std::make_unique<DocumentSymbol>(anyToDocumentSymbol(*elem_1))
                );
            }
            value_0.children = std::move(values_1);
        }

        return value_0;
    }

    auto LspTransformer::documentSymbolToAny(
        const DocumentSymbol &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "name",
            std::make_unique<LSPAny>(stringToAny(param.name))
        );

        if (param.detail.has_value()) {
            const auto &detail_0 = param.detail.value();
            object_0.emplace(
                "detail",
                std::make_unique<LSPAny>(stringToAny(detail_0))
            );
        }

        object_0.emplace(
            "kind",
            std::make_unique<LSPAny>(symbolKindToAny(param.kind))
        );

        if (param.tags.has_value()) {
            const auto &tags_0 = param.tags.value();
            LSPArray array_0;
            array_0.reserve(tags_0.size());
            for (const auto &elem_0 : tags_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = symbolTagToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("tags", std::move(any_1));
        }

        if (param.deprecated.has_value()) {
            const auto &deprecated_0 = param.deprecated.value();
            object_0.emplace(
                "deprecated",
                std::make_unique<LSPAny>(booleanToAny(deprecated_0))
            );
        }

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        object_0.emplace(
            "selectionRange",
            std::make_unique<LSPAny>(rangeToAny(param.selectionRange))
        );

        if (param.children.has_value()) {
            const auto &children_0 = param.children.value();
            LSPArray array_1;
            array_1.reserve(children_0.size());
            for (const auto &elem_1 : children_0) {
                auto any_2 = std::make_unique<LSPAny>();
                (*any_2) = documentSymbolToAny(*elem_1);
                array_1.push_back(std::move(any_2));
            }
            auto any_3 = std::make_unique<LSPAny>();
            (*any_3) = std::move(array_1);
            object_0.emplace("children", std::move(any_3));
        }

        LSPAny any_4;
        any_4 = std::move(object_0);
        return any_4;
    }

    auto LspTransformer::documentSymbol_childrenToAny(
        const DocumentSymbol_children &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = documentSymbolToAny(*elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDocumentSymbol_children(
        const LSPAny &any
    ) const -> DocumentSymbol_children
    {
        const auto &array_0 = any.array();
        std::vector<std::unique_ptr<DocumentSymbol>> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(
                std::make_unique<DocumentSymbol>(anyToDocumentSymbol(*elem_0))
            );
        }
        return values_0;
    }

    auto LspTransformer::anyToWorkspaceSymbol_location(
        const LSPAny &any
    ) const -> WorkspaceSymbol_location
    {
        WorkspaceSymbol_location value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToLocation(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToWorkspaceSymbol_location_1(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to WorkspaceSymbol_location"
                    );
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "WorkspaceSymbol_location"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::workspaceSymbol_locationToAny(
        const WorkspaceSymbol_location &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case WorkspaceSymbol_locationType::Location: {
            return locationToAny(value.location());
        }
        case WorkspaceSymbol_locationType::WorkspaceSymbol_location_1: {
            return workspaceSymbol_location_1ToAny(value.workspaceSymbol_location_1());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported WorkspaceSymbol_locationType: " +
                 WorkspaceSymbol_locationTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::documentRangesFormattingParams_rangesToAny(
        const DocumentRangesFormattingParams_ranges &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = rangeToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDocumentRangesFormattingParams_ranges(
        const LSPAny &any
    ) const -> DocumentRangesFormattingParams_ranges
    {
        const auto &array_0 = any.array();
        std::vector<Range> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToRange(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToLocationLink(
        const LSPAny &any
    ) const -> LocationLink
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "LocationLink"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        LocationLink value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "LocationLink"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("originSelectionRange");
        if (iter_0 != object_0.end()) {
            value_0.originSelectionRange = anyToRange(*iter_0->second);
        }

        iter_0 = object_0.find("targetUri");
        if (iter_0 != object_0.end()) {
            value_0.targetUri = anyToDocumentUri(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required LocationLink attribute: targetUri"
            );
        }

        iter_0 = object_0.find("targetRange");
        if (iter_0 != object_0.end()) {
            value_0.targetRange = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required LocationLink attribute: targetRange"
            );
        }

        iter_0 = object_0.find("targetSelectionRange");
        if (iter_0 != object_0.end()) {
            value_0.targetSelectionRange = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required LocationLink attribute: targetSelectionRange"
            );
        }

        return value_0;
    }

    auto LspTransformer::locationLinkToAny(
        const LocationLink &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.originSelectionRange.has_value()) {
            const auto &originSelectionRange_0 =
                param.originSelectionRange.value();
            object_0.emplace(
                "originSelectionRange",
                std::make_unique<LSPAny>(rangeToAny(originSelectionRange_0))
            );
        }

        object_0.emplace(
            "targetUri",
            std::make_unique<LSPAny>(documentUriToAny(param.targetUri))
        );

        object_0.emplace(
            "targetRange",
            std::make_unique<LSPAny>(rangeToAny(param.targetRange))
        );

        object_0.emplace(
            "targetSelectionRange",
            std::make_unique<LSPAny>(rangeToAny(param.targetSelectionRange))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSemanticTokensEdit(
        const LSPAny &any
    ) const -> SemanticTokensEdit
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SemanticTokensEdit"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SemanticTokensEdit value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SemanticTokensEdit"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("start");
        if (iter_0 != object_0.end()) {
            value_0.start = anyToUInteger(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SemanticTokensEdit attribute: start"
            );
        }

        iter_0 = object_0.find("deleteCount");
        if (iter_0 != object_0.end()) {
            value_0.deleteCount = anyToUInteger(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SemanticTokensEdit attribute: deleteCount"
            );
        }

        iter_0 = object_0.find("data");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<uinteger_t> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToUInteger(*elem_0));
            }
            value_0.data = std::move(values_0);
        }

        return value_0;
    }

    auto LspTransformer::semanticTokensEditToAny(
        const SemanticTokensEdit &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "start",
            std::make_unique<LSPAny>(uintegerToAny(param.start))
        );

        object_0.emplace(
            "deleteCount",
            std::make_unique<LSPAny>(uintegerToAny(param.deleteCount))
        );

        if (param.data.has_value()) {
            const auto &data_0 = param.data.value();
            LSPArray array_0;
            array_0.reserve(data_0.size());
            for (const auto &elem_0 : data_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = uintegerToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("data", std::move(any_1));
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToSemanticTokensDelta(
        const LSPAny &any
    ) const -> SemanticTokensDelta
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SemanticTokensDelta"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SemanticTokensDelta value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SemanticTokensDelta"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("resultId");
        if (iter_0 != object_0.end()) {
            value_0.resultId = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("edits");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<SemanticTokensEdit> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToSemanticTokensEdit(*elem_0));
            }
            value_0.edits = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SemanticTokensDelta attribute: edits"
            );
        }

        return value_0;
    }

    auto LspTransformer::semanticTokensDeltaToAny(
        const SemanticTokensDelta &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.resultId.has_value()) {
            const auto &resultId_0 = param.resultId.value();
            object_0.emplace(
                "resultId",
                std::make_unique<LSPAny>(stringToAny(resultId_0))
            );
        }

        LSPArray array_0;
        array_0.reserve(param.edits.size());
        for (const auto &elem_0 : param.edits) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = semanticTokensEditToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("edits", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::semanticTokensDelta_editsToAny(
        const SemanticTokensDelta_edits &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = semanticTokensEditToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSemanticTokensDelta_edits(
        const LSPAny &any
    ) const -> SemanticTokensDelta_edits
    {
        const auto &array_0 = any.array();
        std::vector<SemanticTokensEdit> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToSemanticTokensEdit(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToSemanticTokensDeltaPartialResult(
        const LSPAny &any
    ) const -> SemanticTokensDeltaPartialResult
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SemanticTokensDeltaPartialResult"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SemanticTokensDeltaPartialResult value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 1) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SemanticTokensDeltaPartialResult"
                 ": " + std::to_string(object_0.size()) + " > 1")
            );
        }

        iter_0 = object_0.find("edits");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<SemanticTokensEdit> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToSemanticTokensEdit(*elem_0));
            }
            value_0.edits = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SemanticTokensDeltaPartialResult attribute: edits"
            );
        }

        return value_0;
    }

    auto LspTransformer::semanticTokensDeltaPartialResultToAny(
        const SemanticTokensDeltaPartialResult &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.edits.size());
        for (const auto &elem_0 : param.edits) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = semanticTokensEditToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("edits", std::move(any_1));

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::semanticTokensDeltaPartialResult_editsToAny(
        const SemanticTokensDeltaPartialResult_edits &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = semanticTokensEditToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSemanticTokensDeltaPartialResult_edits(
        const LSPAny &any
    ) const -> SemanticTokensDeltaPartialResult_edits
    {
        const auto &array_0 = any.array();
        std::vector<SemanticTokensEdit> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToSemanticTokensEdit(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::semanticTokensEdit_dataToAny(
        const SemanticTokensEdit_data &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = uintegerToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSemanticTokensEdit_data(
        const LSPAny &any
    ) const -> SemanticTokensEdit_data
    {
        const auto &array_0 = any.array();
        std::vector<uinteger_t> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToUInteger(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToInlineValueText(
        const LSPAny &any
    ) const -> InlineValueText
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlineValueText"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlineValueText value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlineValueText"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InlineValueText attribute: range"
            );
        }

        iter_0 = object_0.find("text");
        if (iter_0 != object_0.end()) {
            value_0.text = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InlineValueText attribute: text"
            );
        }

        return value_0;
    }

    auto LspTransformer::inlineValueTextToAny(
        const InlineValueText &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        object_0.emplace(
            "text",
            std::make_unique<LSPAny>(stringToAny(param.text))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlineValueVariableLookup(
        const LSPAny &any
    ) const -> InlineValueVariableLookup
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlineValueVariableLookup"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlineValueVariableLookup value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlineValueVariableLookup"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InlineValueVariableLookup attribute: range"
            );
        }

        iter_0 = object_0.find("variableName");
        if (iter_0 != object_0.end()) {
            value_0.variableName = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("caseSensitiveLookup");
        if (iter_0 != object_0.end()) {
            value_0.caseSensitiveLookup = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InlineValueVariableLookup attribute: caseSensitiveLookup"
            );
        }

        return value_0;
    }

    auto LspTransformer::inlineValueVariableLookupToAny(
        const InlineValueVariableLookup &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        if (param.variableName.has_value()) {
            const auto &variableName_0 = param.variableName.value();
            object_0.emplace(
                "variableName",
                std::make_unique<LSPAny>(stringToAny(variableName_0))
            );
        }

        object_0.emplace(
            "caseSensitiveLookup",
            std::make_unique<LSPAny>(booleanToAny(param.caseSensitiveLookup))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlineValueEvaluatableExpression(
        const LSPAny &any
    ) const -> InlineValueEvaluatableExpression
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlineValueEvaluatableExpression"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlineValueEvaluatableExpression value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlineValueEvaluatableExpression"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InlineValueEvaluatableExpression attribute: range"
            );
        }

        iter_0 = object_0.find("expression");
        if (iter_0 != object_0.end()) {
            value_0.expression = anyToString(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlineValueEvaluatableExpressionToAny(
        const InlineValueEvaluatableExpression &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        if (param.expression.has_value()) {
            const auto &expression_0 = param.expression.value();
            object_0.emplace(
                "expression",
                std::make_unique<LSPAny>(stringToAny(expression_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInsertReplaceEdit(
        const LSPAny &any
    ) const -> InsertReplaceEdit
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InsertReplaceEdit"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InsertReplaceEdit value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InsertReplaceEdit"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("newText");
        if (iter_0 != object_0.end()) {
            value_0.newText = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InsertReplaceEdit attribute: newText"
            );
        }

        iter_0 = object_0.find("insert");
        if (iter_0 != object_0.end()) {
            value_0.insert = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InsertReplaceEdit attribute: insert"
            );
        }

        iter_0 = object_0.find("replace");
        if (iter_0 != object_0.end()) {
            value_0.replace = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InsertReplaceEdit attribute: replace"
            );
        }

        return value_0;
    }

    auto LspTransformer::insertReplaceEditToAny(
        const InsertReplaceEdit &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "newText",
            std::make_unique<LSPAny>(stringToAny(param.newText))
        );

        object_0.emplace(
            "insert",
            std::make_unique<LSPAny>(rangeToAny(param.insert))
        );

        object_0.emplace(
            "replace",
            std::make_unique<LSPAny>(rangeToAny(param.replace))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToCompletionItem_textEdit(
        const LSPAny &any
    ) const -> CompletionItem_textEdit
    {
        CompletionItem_textEdit value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToTextEdit(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToInsertReplaceEdit(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to CompletionItem_textEdit"
                    );
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "CompletionItem_textEdit"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::completionItem_textEditToAny(
        const CompletionItem_textEdit &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case CompletionItem_textEditType::TextEdit: {
            return textEditToAny(value.textEdit());
        }
        case CompletionItem_textEditType::InsertReplaceEdit: {
            return insertReplaceEditToAny(value.insertReplaceEdit());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported CompletionItem_textEditType: " +
                 CompletionItem_textEditTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToFormattingOptions(
        const LSPAny &any
    ) const -> FormattingOptions
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FormattingOptions"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FormattingOptions value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FormattingOptions"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("tabSize");
        if (iter_0 != object_0.end()) {
            value_0.tabSize = anyToUInteger(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FormattingOptions attribute: tabSize"
            );
        }

        iter_0 = object_0.find("insertSpaces");
        if (iter_0 != object_0.end()) {
            value_0.insertSpaces = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required FormattingOptions attribute: insertSpaces"
            );
        }

        iter_0 = object_0.find("trimTrailingWhitespace");
        if (iter_0 != object_0.end()) {
            value_0.trimTrailingWhitespace = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("insertFinalNewline");
        if (iter_0 != object_0.end()) {
            value_0.insertFinalNewline = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("trimFinalNewlines");
        if (iter_0 != object_0.end()) {
            value_0.trimFinalNewlines = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::formattingOptionsToAny(
        const FormattingOptions &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "tabSize",
            std::make_unique<LSPAny>(uintegerToAny(param.tabSize))
        );

        object_0.emplace(
            "insertSpaces",
            std::make_unique<LSPAny>(booleanToAny(param.insertSpaces))
        );

        if (param.trimTrailingWhitespace.has_value()) {
            const auto &trimTrailingWhitespace_0 =
                param.trimTrailingWhitespace.value();
            object_0.emplace(
                "trimTrailingWhitespace",
                std::make_unique<LSPAny>(booleanToAny(trimTrailingWhitespace_0))
            );
        }

        if (param.insertFinalNewline.has_value()) {
            const auto &insertFinalNewline_0 =
                param.insertFinalNewline.value();
            object_0.emplace(
                "insertFinalNewline",
                std::make_unique<LSPAny>(booleanToAny(insertFinalNewline_0))
            );
        }

        if (param.trimFinalNewlines.has_value()) {
            const auto &trimFinalNewlines_0 = param.trimFinalNewlines.value();
            object_0.emplace(
                "trimFinalNewlines",
                std::make_unique<LSPAny>(booleanToAny(trimFinalNewlines_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDocumentOnTypeFormattingParams(
        const LSPAny &any
    ) const -> DocumentOnTypeFormattingParams
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DocumentOnTypeFormattingParams"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DocumentOnTypeFormattingParams value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DocumentOnTypeFormattingParams"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("textDocument");
        if (iter_0 != object_0.end()) {
            value_0.textDocument =
                anyToTextDocumentIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentOnTypeFormattingParams attribute: textDocument"
            );
        }

        iter_0 = object_0.find("position");
        if (iter_0 != object_0.end()) {
            value_0.position = anyToPosition(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentOnTypeFormattingParams attribute: position"
            );
        }

        iter_0 = object_0.find("ch");
        if (iter_0 != object_0.end()) {
            value_0.ch = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentOnTypeFormattingParams attribute: ch"
            );
        }

        iter_0 = object_0.find("options");
        if (iter_0 != object_0.end()) {
            value_0.options = anyToFormattingOptions(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DocumentOnTypeFormattingParams attribute: options"
            );
        }

        return value_0;
    }

    auto LspTransformer::documentOnTypeFormattingParamsToAny(
        const DocumentOnTypeFormattingParams &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "textDocument",
            std::make_unique<LSPAny>(textDocumentIdentifierToAny(param.textDocument))
        );

        object_0.emplace(
            "position",
            std::make_unique<LSPAny>(positionToAny(param.position))
        );

        object_0.emplace(
            "ch",
            std::make_unique<LSPAny>(stringToAny(param.ch))
        );

        object_0.emplace(
            "options",
            std::make_unique<LSPAny>(formattingOptionsToAny(param.options))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToAnnotatedTextEdit(
        const LSPAny &any
    ) const -> AnnotatedTextEdit
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "AnnotatedTextEdit"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        AnnotatedTextEdit value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "AnnotatedTextEdit"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required AnnotatedTextEdit attribute: range"
            );
        }

        iter_0 = object_0.find("newText");
        if (iter_0 != object_0.end()) {
            value_0.newText = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required AnnotatedTextEdit attribute: newText"
            );
        }

        iter_0 = object_0.find("annotationId");
        if (iter_0 != object_0.end()) {
            value_0.annotationId =
                anyToChangeAnnotationIdentifier(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required AnnotatedTextEdit attribute: annotationId"
            );
        }

        return value_0;
    }

    auto LspTransformer::annotatedTextEditToAny(
        const AnnotatedTextEdit &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        object_0.emplace(
            "newText",
            std::make_unique<LSPAny>(stringToAny(param.newText))
        );

        object_0.emplace(
            "annotationId",
            std::make_unique<LSPAny>(changeAnnotationIdentifierToAny(param.annotationId))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentEdit_edits_elem(
        const LSPAny &any
    ) const -> TextDocumentEdit_edits_elem
    {
        TextDocumentEdit_edits_elem value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToTextEdit(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToAnnotatedTextEdit(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to TextDocumentEdit_edits_elem"
                    );
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "TextDocumentEdit_edits_elem"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::textDocumentEdit_edits_elemToAny(
        const TextDocumentEdit_edits_elem &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case TextDocumentEdit_edits_elemType::TextEdit: {
            return textEditToAny(value.textEdit());
        }
        case TextDocumentEdit_edits_elemType::AnnotatedTextEdit: {
            return annotatedTextEditToAny(value.annotatedTextEdit());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported TextDocumentEdit_edits_elemType: " +
                 TextDocumentEdit_edits_elemTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::textDocumentEdit_editsToAny(
        const TextDocumentEdit_edits &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = textDocumentEdit_edits_elemToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToTextDocumentEdit_edits(
        const LSPAny &any
    ) const -> TextDocumentEdit_edits
    {
        const auto &array_0 = any.array();
        std::vector<TextDocumentEdit_edits_elem> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToTextDocumentEdit_edits_elem(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToSelectedCompletionInfo(
        const LSPAny &any
    ) const -> SelectedCompletionInfo
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SelectedCompletionInfo"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SelectedCompletionInfo value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SelectedCompletionInfo"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SelectedCompletionInfo attribute: range"
            );
        }

        iter_0 = object_0.find("text");
        if (iter_0 != object_0.end()) {
            value_0.text = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SelectedCompletionInfo attribute: text"
            );
        }

        return value_0;
    }

    auto LspTransformer::selectedCompletionInfoToAny(
        const SelectedCompletionInfo &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        object_0.emplace(
            "text",
            std::make_unique<LSPAny>(stringToAny(param.text))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToInlineCompletionContext(
        const LSPAny &any
    ) const -> InlineCompletionContext
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "InlineCompletionContext"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        InlineCompletionContext value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "InlineCompletionContext"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("triggerKind");
        if (iter_0 != object_0.end()) {
            value_0.triggerKind =
                anyToInlineCompletionTriggerKind(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required InlineCompletionContext attribute: triggerKind"
            );
        }

        iter_0 = object_0.find("selectedCompletionInfo");
        if (iter_0 != object_0.end()) {
            value_0.selectedCompletionInfo =
                anyToSelectedCompletionInfo(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::inlineCompletionContextToAny(
        const InlineCompletionContext &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "triggerKind",
            std::make_unique<LSPAny>(inlineCompletionTriggerKindToAny(param.triggerKind))
        );

        if (param.selectedCompletionInfo.has_value()) {
            const auto &selectedCompletionInfo_0 =
                param.selectedCompletionInfo.value();
            object_0.emplace(
                "selectedCompletionInfo",
                std::make_unique<LSPAny>(selectedCompletionInfoToAny(selectedCompletionInfo_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDiagnosticRelatedInformation(
        const LSPAny &any
    ) const -> DiagnosticRelatedInformation
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "DiagnosticRelatedInformation"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        DiagnosticRelatedInformation value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "DiagnosticRelatedInformation"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("location");
        if (iter_0 != object_0.end()) {
            value_0.location = anyToLocation(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DiagnosticRelatedInformation attribute: location"
            );
        }

        iter_0 = object_0.find("message");
        if (iter_0 != object_0.end()) {
            value_0.message = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required DiagnosticRelatedInformation attribute: message"
            );
        }

        return value_0;
    }

    auto LspTransformer::diagnosticRelatedInformationToAny(
        const DiagnosticRelatedInformation &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "location",
            std::make_unique<LSPAny>(locationToAny(param.location))
        );

        object_0.emplace(
            "message",
            std::make_unique<LSPAny>(stringToAny(param.message))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::diagnostic_relatedInformationToAny(
        const Diagnostic_relatedInformation &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = diagnosticRelatedInformationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDiagnostic_relatedInformation(
        const LSPAny &any
    ) const -> Diagnostic_relatedInformation
    {
        const auto &array_0 = any.array();
        std::vector<DiagnosticRelatedInformation> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToDiagnosticRelatedInformation(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToParameterInformation_label(
        const LSPAny &any
    ) const -> ParameterInformation_label
    {
        ParameterInformation_label value_0;

        switch (any.type()) {
        case LSPAnyType::String: {
            value_0 = anyToString(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "ParameterInformation_label"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::parameterInformation_labelToAny(
        const ParameterInformation_label &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case ParameterInformation_labelType::String: {
            return stringToAny(value.string());
        }
        case ParameterInformation_labelType::PairOfUIntegerAndUInteger: {
            LSPArray array_0;
            array_0.reserve(2);
            const std::pair<uinteger_t, uinteger_t> &tuple_0 =
                value.pairOfUIntegerAndUInteger();
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = uintegerToAny(std::get<0>(tuple_0));
            array_0.push_back(std::move(any_0));
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = uintegerToAny(std::get<1>(tuple_0));
            array_0.push_back(std::move(any_1));
            LSPAny any_2;
            any_2 = std::move(array_0);
            return any_2;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported ParameterInformation_labelType: " +
                 ParameterInformation_labelTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToParameterInformation(
        const LSPAny &any
    ) const -> ParameterInformation
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "ParameterInformation"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ParameterInformation value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "ParameterInformation"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("label");
        if (iter_0 != object_0.end()) {
            value_0.label = anyToParameterInformation_label(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ParameterInformation attribute: label"
            );
        }

        iter_0 = object_0.find("documentation");
        if (iter_0 != object_0.end()) {
            value_0.documentation =
                anyToParameterInformation_documentation(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::parameterInformationToAny(
        const ParameterInformation &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "label",
            std::make_unique<LSPAny>(parameterInformation_labelToAny(param.label))
        );

        if (param.documentation.has_value()) {
            const auto &documentation_0 = param.documentation.value();
            object_0.emplace(
                "documentation",
                std::make_unique<LSPAny>(parameterInformation_documentationToAny(documentation_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToSignatureInformation(
        const LSPAny &any
    ) const -> SignatureInformation
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SignatureInformation"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SignatureInformation value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SignatureInformation"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("label");
        if (iter_0 != object_0.end()) {
            value_0.label = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SignatureInformation attribute: label"
            );
        }

        iter_0 = object_0.find("documentation");
        if (iter_0 != object_0.end()) {
            value_0.documentation =
                anyToSignatureInformation_documentation(*iter_0->second);
        }

        iter_0 = object_0.find("parameters");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<ParameterInformation> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToParameterInformation(*elem_0));
            }
            value_0.parameters = std::move(values_0);
        }

        iter_0 = object_0.find("activeParameter");
        if (iter_0 != object_0.end()) {
            value_0.activeParameter = anyToUInteger(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::signatureInformationToAny(
        const SignatureInformation &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "label",
            std::make_unique<LSPAny>(stringToAny(param.label))
        );

        if (param.documentation.has_value()) {
            const auto &documentation_0 = param.documentation.value();
            object_0.emplace(
                "documentation",
                std::make_unique<LSPAny>(signatureInformation_documentationToAny(documentation_0))
            );
        }

        if (param.parameters.has_value()) {
            const auto &parameters_0 = param.parameters.value();
            LSPArray array_0;
            array_0.reserve(parameters_0.size());
            for (const auto &elem_0 : parameters_0) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = parameterInformationToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            auto any_1 = std::make_unique<LSPAny>();
            (*any_1) = std::move(array_0);
            object_0.emplace("parameters", std::move(any_1));
        }

        if (param.activeParameter.has_value()) {
            const auto &activeParameter_0 = param.activeParameter.value();
            object_0.emplace(
                "activeParameter",
                std::make_unique<LSPAny>(uintegerToAny(activeParameter_0))
            );
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::anyToSignatureHelp(
        const LSPAny &any
    ) const -> SignatureHelp
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SignatureHelp"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SignatureHelp value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SignatureHelp"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("signatures");
        if (iter_0 != object_0.end()) {
            const auto &array_0 = iter_0->second->array();
            std::vector<SignatureInformation> values_0;
            for (const auto &elem_0 : array_0) {
                values_0.push_back(anyToSignatureInformation(*elem_0));
            }
            value_0.signatures = std::move(values_0);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SignatureHelp attribute: signatures"
            );
        }

        iter_0 = object_0.find("activeSignature");
        if (iter_0 != object_0.end()) {
            value_0.activeSignature = anyToUInteger(*iter_0->second);
        }

        iter_0 = object_0.find("activeParameter");
        if (iter_0 != object_0.end()) {
            value_0.activeParameter = anyToUInteger(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::signatureHelpToAny(
        const SignatureHelp &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        LSPArray array_0;
        array_0.reserve(param.signatures.size());
        for (const auto &elem_0 : param.signatures) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = signatureInformationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        auto any_1 = std::make_unique<LSPAny>();
        (*any_1) = std::move(array_0);
        object_0.emplace("signatures", std::move(any_1));

        if (param.activeSignature.has_value()) {
            const auto &activeSignature_0 = param.activeSignature.value();
            object_0.emplace(
                "activeSignature",
                std::make_unique<LSPAny>(uintegerToAny(activeSignature_0))
            );
        }

        if (param.activeParameter.has_value()) {
            const auto &activeParameter_0 = param.activeParameter.value();
            object_0.emplace(
                "activeParameter",
                std::make_unique<LSPAny>(uintegerToAny(activeParameter_0))
            );
        }

        LSPAny any_2;
        any_2 = std::move(object_0);
        return any_2;
    }

    auto LspTransformer::signatureHelp_signaturesToAny(
        const SignatureHelp_signatures &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = signatureInformationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSignatureHelp_signatures(
        const LSPAny &any
    ) const -> SignatureHelp_signatures
    {
        const auto &array_0 = any.array();
        std::vector<SignatureInformation> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToSignatureInformation(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToSignatureHelpContext(
        const LSPAny &any
    ) const -> SignatureHelpContext
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "SignatureHelpContext"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        SignatureHelpContext value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 4) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "SignatureHelpContext"
                 ": " + std::to_string(object_0.size()) + " > 4")
            );
        }

        iter_0 = object_0.find("triggerKind");
        if (iter_0 != object_0.end()) {
            value_0.triggerKind =
                anyToSignatureHelpTriggerKind(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SignatureHelpContext attribute: triggerKind"
            );
        }

        iter_0 = object_0.find("triggerCharacter");
        if (iter_0 != object_0.end()) {
            value_0.triggerCharacter = anyToString(*iter_0->second);
        }

        iter_0 = object_0.find("isRetrigger");
        if (iter_0 != object_0.end()) {
            value_0.isRetrigger = anyToBoolean(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required SignatureHelpContext attribute: isRetrigger"
            );
        }

        iter_0 = object_0.find("activeSignatureHelp");
        if (iter_0 != object_0.end()) {
            value_0.activeSignatureHelp = anyToSignatureHelp(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::signatureHelpContextToAny(
        const SignatureHelpContext &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "triggerKind",
            std::make_unique<LSPAny>(signatureHelpTriggerKindToAny(param.triggerKind))
        );

        if (param.triggerCharacter.has_value()) {
            const auto &triggerCharacter_0 = param.triggerCharacter.value();
            object_0.emplace(
                "triggerCharacter",
                std::make_unique<LSPAny>(stringToAny(triggerCharacter_0))
            );
        }

        object_0.emplace(
            "isRetrigger",
            std::make_unique<LSPAny>(booleanToAny(param.isRetrigger))
        );

        if (param.activeSignatureHelp.has_value()) {
            const auto &activeSignatureHelp_0 =
                param.activeSignatureHelp.value();
            object_0.emplace(
                "activeSignatureHelp",
                std::make_unique<LSPAny>(signatureHelpToAny(activeSignatureHelp_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::signatureInformation_parametersToAny(
        const SignatureInformation_parameters &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = parameterInformationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToSignatureInformation_parameters(
        const LSPAny &any
    ) const -> SignatureInformation_parameters
    {
        const auto &array_0 = any.array();
        std::vector<ParameterInformation> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToParameterInformation(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToExecutionSummary(
        const LSPAny &any
    ) const -> ExecutionSummary
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for an "
                 "ExecutionSummary"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        ExecutionSummary value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to an "
                 "ExecutionSummary"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("executionOrder");
        if (iter_0 != object_0.end()) {
            value_0.executionOrder = anyToUInteger(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required ExecutionSummary attribute: executionOrder"
            );
        }

        iter_0 = object_0.find("success");
        if (iter_0 != object_0.end()) {
            value_0.success = anyToBoolean(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::executionSummaryToAny(
        const ExecutionSummary &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "executionOrder",
            std::make_unique<LSPAny>(uintegerToAny(param.executionOrder))
        );

        if (param.success.has_value()) {
            const auto &success_0 = param.success.value();
            object_0.emplace(
                "success",
                std::make_unique<LSPAny>(booleanToAny(success_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToFoldingRangeClientCapabilities(
        const LSPAny &any
    ) const -> FoldingRangeClientCapabilities
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "FoldingRangeClientCapabilities"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        FoldingRangeClientCapabilities value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 5) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "FoldingRangeClientCapabilities"
                 ": " + std::to_string(object_0.size()) + " > 5")
            );
        }

        iter_0 = object_0.find("dynamicRegistration");
        if (iter_0 != object_0.end()) {
            value_0.dynamicRegistration = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("rangeLimit");
        if (iter_0 != object_0.end()) {
            value_0.rangeLimit = anyToUInteger(*iter_0->second);
        }

        iter_0 = object_0.find("lineFoldingOnly");
        if (iter_0 != object_0.end()) {
            value_0.lineFoldingOnly = anyToBoolean(*iter_0->second);
        }

        iter_0 = object_0.find("foldingRangeKind");
        if (iter_0 != object_0.end()) {
            value_0.foldingRangeKind =
                anyToFoldingRangeClientCapabilities_foldingRangeKind(*iter_0->second);
        }

        iter_0 = object_0.find("foldingRange");
        if (iter_0 != object_0.end()) {
            value_0.foldingRange =
                anyToFoldingRangeClientCapabilities_foldingRange(*iter_0->second);
        }

        return value_0;
    }

    auto LspTransformer::foldingRangeClientCapabilitiesToAny(
        const FoldingRangeClientCapabilities &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        if (param.dynamicRegistration.has_value()) {
            const auto &dynamicRegistration_0 =
                param.dynamicRegistration.value();
            object_0.emplace(
                "dynamicRegistration",
                std::make_unique<LSPAny>(booleanToAny(dynamicRegistration_0))
            );
        }

        if (param.rangeLimit.has_value()) {
            const auto &rangeLimit_0 = param.rangeLimit.value();
            object_0.emplace(
                "rangeLimit",
                std::make_unique<LSPAny>(uintegerToAny(rangeLimit_0))
            );
        }

        if (param.lineFoldingOnly.has_value()) {
            const auto &lineFoldingOnly_0 = param.lineFoldingOnly.value();
            object_0.emplace(
                "lineFoldingOnly",
                std::make_unique<LSPAny>(booleanToAny(lineFoldingOnly_0))
            );
        }

        if (param.foldingRangeKind.has_value()) {
            const auto &foldingRangeKind_0 = param.foldingRangeKind.value();
            object_0.emplace(
                "foldingRangeKind",
                std::make_unique<LSPAny>(foldingRangeClientCapabilities_foldingRangeKindToAny(foldingRangeKind_0))
            );
        }

        if (param.foldingRange.has_value()) {
            const auto &foldingRange_0 = param.foldingRange.value();
            object_0.emplace(
                "foldingRange",
                std::make_unique<LSPAny>(foldingRangeClientCapabilities_foldingRangeToAny(foldingRange_0))
            );
        }

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToDefinition(const LSPAny &any) const -> Definition
    {
        Definition value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToLocation(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to Definition"
                );
            }
            break;
        }
        case LSPAnyType::Array: {
            try {
                value_0 = anyToDefinition_1(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to Definition"
                );
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "Definition"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::definitionToAny(
        const Definition &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case DefinitionType::Location: {
            return locationToAny(value.location());
        }
        case DefinitionType::LocationArray: {
            LSPArray array_0;
            array_0.reserve(value.locationArray().size());
            for (const auto &elem_0 : value.locationArray()) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = locationToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            LSPAny any_1;
            any_1 = std::move(array_0);
            return any_1;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported DefinitionType: " +
                 DefinitionTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::definition_1ToAny(
        const Definition_1 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = locationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDefinition_1(
        const LSPAny &any
    ) const -> Definition_1
    {
        const auto &array_0 = any.array();
        std::vector<Location> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToLocation(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToDefinitionLink(
        const LSPAny &any
    ) const -> DefinitionLink
    {
        return anyToLocationLink(any);
    }

    auto LspTransformer::definitionLinkToAny(
        const DefinitionLink &alias
    ) const -> LSPAny
    {
        return locationLinkToAny(alias);
    }

    auto LspTransformer::anyToDeclaration(
        const LSPAny &any
    ) const -> Declaration
    {
        Declaration value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToLocation(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to Declaration"
                );
            }
            break;
        }
        case LSPAnyType::Array: {
            try {
                value_0 = anyToDeclaration_1(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to Declaration"
                );
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "Declaration"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::declarationToAny(
        const Declaration &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case DeclarationType::Location: {
            return locationToAny(value.location());
        }
        case DeclarationType::LocationArray: {
            LSPArray array_0;
            array_0.reserve(value.locationArray().size());
            for (const auto &elem_0 : value.locationArray()) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = locationToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            LSPAny any_1;
            any_1 = std::move(array_0);
            return any_1;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported DeclarationType: " +
                 DeclarationTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::declaration_1ToAny(
        const Declaration_1 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = locationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDeclaration_1(
        const LSPAny &any
    ) const -> Declaration_1
    {
        const auto &array_0 = any.array();
        std::vector<Location> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToLocation(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToDeclarationLink(
        const LSPAny &any
    ) const -> DeclarationLink
    {
        return anyToLocationLink(any);
    }

    auto LspTransformer::declarationLinkToAny(
        const DeclarationLink &alias
    ) const -> LSPAny
    {
        return locationLinkToAny(alias);
    }

    auto LspTransformer::anyToInlineValue(
        const LSPAny &any
    ) const -> InlineValue
    {
        InlineValue value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToInlineValueText(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToInlineValueVariableLookup(any);
                } catch (LspException &/*e*/) {
                    try {
                        value_0 = anyToInlineValueEvaluatableExpression(any);
                    } catch (LspException &/*e*/) {
                        throw LSP_EXCEPTION(
                            ErrorCodes::InvalidParams,
                            "Failed to transform LSPAny to InlineValue"
                        );
                    }
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for an "
                 "InlineValue"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::inlineValueToAny(
        const InlineValue &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case InlineValueType::InlineValueText: {
            return inlineValueTextToAny(value.inlineValueText());
        }
        case InlineValueType::InlineValueVariableLookup: {
            return inlineValueVariableLookupToAny(value.inlineValueVariableLookup());
        }
        case InlineValueType::InlineValueEvaluatableExpression: {
            return inlineValueEvaluatableExpressionToAny(value.inlineValueEvaluatableExpression());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported InlineValueType: " +
                 InlineValueTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToPrepareRenameResult_1(
        const LSPAny &any
    ) const -> PrepareRenameResult_1
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "PrepareRenameResult_1"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        PrepareRenameResult_1 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 2) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "PrepareRenameResult_1"
                 ": " + std::to_string(object_0.size()) + " > 2")
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required PrepareRenameResult_1 attribute: range"
            );
        }

        iter_0 = object_0.find("placeholder");
        if (iter_0 != object_0.end()) {
            value_0.placeholder = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required PrepareRenameResult_1 attribute: placeholder"
            );
        }

        return value_0;
    }

    auto LspTransformer::prepareRenameResult_1ToAny(
        const PrepareRenameResult_1 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        object_0.emplace(
            "placeholder",
            std::make_unique<LSPAny>(stringToAny(param.placeholder))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToPrepareRenameResult(
        const LSPAny &any
    ) const -> PrepareRenameResult
    {
        PrepareRenameResult value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToRange(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToPrepareRenameResult_1(any);
                } catch (LspException &/*e*/) {
                    try {
                        value_0 = anyToPrepareRenameResult_2(any);
                    } catch (LspException &/*e*/) {
                        throw LSP_EXCEPTION(
                            ErrorCodes::InvalidParams,
                            "Failed to transform LSPAny to PrepareRenameResult"
                        );
                    }
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "PrepareRenameResult"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::prepareRenameResultToAny(
        const PrepareRenameResult &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case PrepareRenameResultType::Range: {
            return rangeToAny(value.range());
        }
        case PrepareRenameResultType::PrepareRenameResult_1: {
            return prepareRenameResult_1ToAny(value.prepareRenameResult_1());
        }
        case PrepareRenameResultType::PrepareRenameResult_2: {
            return prepareRenameResult_2ToAny(value.prepareRenameResult_2());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported PrepareRenameResultType: " +
                 PrepareRenameResultTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::anyToTextDocumentContentChangeEvent_0(
        const LSPAny &any
    ) const -> TextDocumentContentChangeEvent_0
    {
        if (any.type() != LSPAnyType::Object) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("LSPAnyType for a "
                 "TextDocumentContentChangeEvent_0"
                 " must be of type LSPAnyType::Object"
                 " but received LSPAnyType::" + LSPAnyTypeNames.at(any.type()))
            );
        }

        TextDocumentContentChangeEvent_0 value_0;

        const auto &object_0 = any.object();
        LSPObject::const_iterator iter_0;

        if (object_0.size() > 3) {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Too many attributes to transform to a "
                 "TextDocumentContentChangeEvent_0"
                 ": " + std::to_string(object_0.size()) + " > 3")
            );
        }

        iter_0 = object_0.find("range");
        if (iter_0 != object_0.end()) {
            value_0.range = anyToRange(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentContentChangeEvent_0 attribute: range"
            );
        }

        iter_0 = object_0.find("rangeLength");
        if (iter_0 != object_0.end()) {
            value_0.rangeLength = anyToUInteger(*iter_0->second);
        }

        iter_0 = object_0.find("text");
        if (iter_0 != object_0.end()) {
            value_0.text = anyToString(*iter_0->second);
        } else {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                "Missing required TextDocumentContentChangeEvent_0 attribute: text"
            );
        }

        return value_0;
    }

    auto LspTransformer::textDocumentContentChangeEvent_0ToAny(
        const TextDocumentContentChangeEvent_0 &param
    ) const -> LSPAny
    {
        LSPObject object_0;

        object_0.emplace(
            "range",
            std::make_unique<LSPAny>(rangeToAny(param.range))
        );

        if (param.rangeLength.has_value()) {
            const auto &rangeLength_0 = param.rangeLength.value();
            object_0.emplace(
                "rangeLength",
                std::make_unique<LSPAny>(uintegerToAny(rangeLength_0))
            );
        }

        object_0.emplace(
            "text",
            std::make_unique<LSPAny>(stringToAny(param.text))
        );

        LSPAny any_0;
        any_0 = std::move(object_0);
        return any_0;
    }

    auto LspTransformer::anyToTextDocumentContentChangeEvent(
        const LSPAny &any
    ) const -> TextDocumentContentChangeEvent
    {
        TextDocumentContentChangeEvent value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToTextDocumentContentChangeEvent_0(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToTextDocumentContentChangeEvent_1(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to TextDocumentContentChangeEvent"
                    );
                }
            }
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "TextDocumentContentChangeEvent"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::textDocumentContentChangeEventToAny(
        const TextDocumentContentChangeEvent &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case TextDocumentContentChangeEventType::TextDocumentContentChangeEvent_0: {
            return textDocumentContentChangeEvent_0ToAny(value.textDocumentContentChangeEvent_0());
        }
        case TextDocumentContentChangeEventType::TextDocumentContentChangeEvent_1: {
            return textDocumentContentChangeEvent_1ToAny(value.textDocumentContentChangeEvent_1());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported TextDocumentContentChangeEventType: " +
                 TextDocumentContentChangeEventTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::didChangeTextDocumentParams_contentChangesToAny(
        const DidChangeTextDocumentParams_contentChanges &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = textDocumentContentChangeEventToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToDidChangeTextDocumentParams_contentChanges(
        const LSPAny &any
    ) const -> DidChangeTextDocumentParams_contentChanges
    {
        const auto &array_0 = any.array();
        std::vector<TextDocumentContentChangeEvent> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToTextDocumentContentChangeEvent(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::notebookDocumentChangeEvent_cells_textContent_elem_changesToAny(
        const NotebookDocumentChangeEvent_cells_textContent_elem_changes &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = textDocumentContentChangeEventToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToNotebookDocumentChangeEvent_cells_textContent_elem_changes(
        const LSPAny &any
    ) const -> NotebookDocumentChangeEvent_cells_textContent_elem_changes
    {
        const auto &array_0 = any.array();
        std::vector<TextDocumentContentChangeEvent> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToTextDocumentContentChangeEvent(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToTextDocument_ImplementationResult(
        const LSPAny &any
    ) const -> TextDocument_ImplementationResult
    {
        TextDocument_ImplementationResult value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToDefinition(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to TextDocument_ImplementationResult"
                );
            }
            break;
        }
        case LSPAnyType::Array: {
            try {
                value_0 = anyToTextDocument_ImplementationResult_1(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToTextDocument_ImplementationResult_3(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to TextDocument_ImplementationResult"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Null: {
            value_0 = anyToNull(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "TextDocument_ImplementationResult"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::textDocument_ImplementationResultToAny(
        const TextDocument_ImplementationResult &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case TextDocument_ImplementationResultType::Definition: {
            return definitionToAny(value.definition());
        }
        case TextDocument_ImplementationResultType::DefinitionLinkArray: {
            LSPArray array_0;
            array_0.reserve(value.locationLinkArray().size());
            for (const auto &elem_0 : value.locationLinkArray()) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = definitionLinkToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            LSPAny any_1;
            any_1 = std::move(array_0);
            return any_1;
        }
        case TextDocument_ImplementationResultType::Null: {
            return nullToAny(value.null());
        }
        case TextDocument_ImplementationResultType::LocationArray: {
            LSPArray array_1;
            array_1.reserve(value.locationArray().size());
            for (const auto &elem_1 : value.locationArray()) {
                auto any_2 = std::make_unique<LSPAny>();
                (*any_2) = locationToAny(elem_1);
                array_1.push_back(std::move(any_2));
            }
            LSPAny any_3;
            any_3 = std::move(array_1);
            return any_3;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported TextDocument_ImplementationResultType: " +
                 TextDocument_ImplementationResultTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::textDocument_ImplementationResult_1ToAny(
        const TextDocument_ImplementationResult_1 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = definitionLinkToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToTextDocument_ImplementationResult_1(
        const LSPAny &any
    ) const -> TextDocument_ImplementationResult_1
    {
        const auto &array_0 = any.array();
        std::vector<DefinitionLink> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToDefinitionLink(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::textDocument_ImplementationResult_3ToAny(
        const TextDocument_ImplementationResult_3 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = locationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToTextDocument_ImplementationResult_3(
        const LSPAny &any
    ) const -> TextDocument_ImplementationResult_3
    {
        const auto &array_0 = any.array();
        std::vector<Location> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToLocation(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToTextDocument_TypeDefinitionResult(
        const LSPAny &any
    ) const -> TextDocument_TypeDefinitionResult
    {
        TextDocument_TypeDefinitionResult value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToDefinition(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to TextDocument_TypeDefinitionResult"
                );
            }
            break;
        }
        case LSPAnyType::Array: {
            try {
                value_0 = anyToTextDocument_TypeDefinitionResult_1(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToTextDocument_TypeDefinitionResult_3(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to TextDocument_TypeDefinitionResult"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Null: {
            value_0 = anyToNull(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "TextDocument_TypeDefinitionResult"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::textDocument_TypeDefinitionResultToAny(
        const TextDocument_TypeDefinitionResult &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case TextDocument_TypeDefinitionResultType::Definition: {
            return definitionToAny(value.definition());
        }
        case TextDocument_TypeDefinitionResultType::DefinitionLinkArray: {
            LSPArray array_0;
            array_0.reserve(value.locationLinkArray().size());
            for (const auto &elem_0 : value.locationLinkArray()) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = definitionLinkToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            LSPAny any_1;
            any_1 = std::move(array_0);
            return any_1;
        }
        case TextDocument_TypeDefinitionResultType::Null: {
            return nullToAny(value.null());
        }
        case TextDocument_TypeDefinitionResultType::LocationArray: {
            LSPArray array_1;
            array_1.reserve(value.locationArray().size());
            for (const auto &elem_1 : value.locationArray()) {
                auto any_2 = std::make_unique<LSPAny>();
                (*any_2) = locationToAny(elem_1);
                array_1.push_back(std::move(any_2));
            }
            LSPAny any_3;
            any_3 = std::move(array_1);
            return any_3;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported TextDocument_TypeDefinitionResultType: " +
                 TextDocument_TypeDefinitionResultTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::textDocument_TypeDefinitionResult_1ToAny(
        const TextDocument_TypeDefinitionResult_1 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = definitionLinkToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToTextDocument_TypeDefinitionResult_1(
        const LSPAny &any
    ) const -> TextDocument_TypeDefinitionResult_1
    {
        const auto &array_0 = any.array();
        std::vector<DefinitionLink> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToDefinitionLink(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::textDocument_TypeDefinitionResult_3ToAny(
        const TextDocument_TypeDefinitionResult_3 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = locationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToTextDocument_TypeDefinitionResult_3(
        const LSPAny &any
    ) const -> TextDocument_TypeDefinitionResult_3
    {
        const auto &array_0 = any.array();
        std::vector<Location> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToLocation(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::textDocument_ColorPresentationResultToAny(
        const TextDocument_ColorPresentationResult &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = colorPresentationToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToTextDocument_ColorPresentationResult(
        const LSPAny &any
    ) const -> TextDocument_ColorPresentationResult
    {
        const auto &array_0 = any.array();
        std::vector<ColorPresentation> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToColorPresentation(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToTextDocument_FoldingRangeResult(
        const LSPAny &any
    ) const -> TextDocument_FoldingRangeResult
    {
        TextDocument_FoldingRangeResult value_0;

        switch (any.type()) {
        case LSPAnyType::Array: {
            try {
                value_0 = anyToTextDocument_FoldingRangeResult_0(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to TextDocument_FoldingRangeResult"
                );
            }
            break;
        }
        case LSPAnyType::Null: {
            value_0 = anyToNull(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "TextDocument_FoldingRangeResult"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::textDocument_FoldingRangeResultToAny(
        const TextDocument_FoldingRangeResult &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case TextDocument_FoldingRangeResultType::FoldingRangeArray: {
            LSPArray array_0;
            array_0.reserve(value.foldingRangeArray().size());
            for (const auto &elem_0 : value.foldingRangeArray()) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = foldingRangeToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            LSPAny any_1;
            any_1 = std::move(array_0);
            return any_1;
        }
        case TextDocument_FoldingRangeResultType::Null: {
            return nullToAny(value.null());
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported TextDocument_FoldingRangeResultType: " +
                 TextDocument_FoldingRangeResultTypeNames.at(value.type()))
            );
        }
        }
    }

    auto LspTransformer::textDocument_FoldingRangeResult_0ToAny(
        const TextDocument_FoldingRangeResult_0 &array
    ) const -> LSPAny
    {
        LSPArray array_0;
        array_0.reserve(array.size());
        for (const auto &elem_0 : array) {
            auto any_0 = std::make_unique<LSPAny>();
            (*any_0) = foldingRangeToAny(elem_0);
            array_0.push_back(std::move(any_0));
        }
        LSPAny any_1;
        any_1 = std::move(array_0);
        return any_1;
    }

    auto LspTransformer::anyToTextDocument_FoldingRangeResult_0(
        const LSPAny &any
    ) const -> TextDocument_FoldingRangeResult_0
    {
        const auto &array_0 = any.array();
        std::vector<FoldingRange> values_0;
        values_0.reserve(array_0.size());
        for (const auto &elem_0 : array_0) {
            values_0.push_back(anyToFoldingRange(*elem_0));
        }
        return values_0;
    }

    auto LspTransformer::anyToTextDocument_DeclarationResult(
        const LSPAny &any
    ) const -> TextDocument_DeclarationResult
    {
        TextDocument_DeclarationResult value_0;

        switch (any.type()) {
        case LSPAnyType::Object: {
            try {
                value_0 = anyToDeclaration(any);
            } catch (LspException &/*e*/) {
                throw LSP_EXCEPTION(
                    ErrorCodes::InvalidParams,
                    "Failed to transform LSPAny to TextDocument_DeclarationResult"
                );
            }
            break;
        }
        case LSPAnyType::Array: {
            try {
                value_0 = anyToTextDocument_DeclarationResult_1(any);
            } catch (LspException &/*e*/) {
                try {
                    value_0 = anyToTextDocument_DeclarationResult_3(any);
                } catch (LspException &/*e*/) {
                    throw LSP_EXCEPTION(
                        ErrorCodes::InvalidParams,
                        "Failed to transform LSPAny to TextDocument_DeclarationResult"
                    );
                }
            }
            break;
        }
        case LSPAnyType::Null: {
            value_0 = anyToNull(any);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Invalid LSPAnyType for a "
                 "TextDocument_DeclarationResult"
                 ": " + LSPAnyTypeNames.at(any.type()))
            );
        }
        }

        return value_0;
    }

    auto LspTransformer::textDocument_DeclarationResultToAny(
        const TextDocument_DeclarationResult &value
    ) const -> LSPAny
    {
        switch (value.type()) {
        case TextDocument_DeclarationResultType::Declaration: {
            return declarationToAny(value.declaration());
        }
        case TextDocument_DeclarationResultType::DeclarationLinkArray: {
            LSPArray array_0;
            array_0.reserve(value.locationLinkArray().size());
            for (const auto &elem_0 : value.locationLinkArray()) {
                auto any_0 = std::make_unique<LSPAny>();
                (*any_0) = declarationLinkToAny(elem_0);
                array_0.push_back(std::move(any_0));
            }
            LSPAny any_1;
            any_1 = std::move(array_0);
            return any_1;
        }
        case TextDocument_DeclarationResultType::Null: {
            return nullToAny(value.null());
        }
        case TextDocument_DeclarationResultType::LocationArray: {
            LSPArray array_1;
            array_1.reserve(value.locationArray().size());
            for (const auto &elem_1 : value.locationArray()) {
                auto any_2 = std::make_unique<LSPAny>();
                (*any_2) = locationToAny(elem_1);
                array_1.push_back(std::move(any_2));
            }
            LSPAny any_3;
            any_3 = std::move(array_1);
            return any_3;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::InvalidParams,
                ("Unsupported TextDocument_DeclarationResultType: " +
        