// ------------------------------------------------------------------------------
// NOTE: This file was generated from Microsoft's Language Server Protocol (LSP)
// specification. Please do not edit it by hand.
// ------------------------------------------------------------------------------

#pragma once

#include <cstddef>
#include <map>
#include <memory>
#include <optional>
#include <string>
#include <tuple>
#include <utility>
#include <vector>

namespace LCompilers::LanguageServerProtocol {
    const std::string JSON_RPC_VERSION = "2.0";
    const std::string LSP_VERSION = "3.17.0";

    struct SelectionRange;  // Forward-declaration for cyclic dependencies

    class LSPAny;  // Forward-declaration for cyclic dependencies

    struct DocumentSymbol;  // Forward-declaration for cyclic dependencies

    /**
     * A set of predefined token types. This set is not fixed
     * an clients can specify additional token types via the
     * corresponding client capabilities.
     *
     * @since 3.16.0
     */
    enum class SemanticTokenTypes {
        Namespace,
        /**
         * Represents a generic type. Acts as a fallback for types which can't be mapped to
         * a specific type like class or enum.
         */
        Type,
        Class,
        Enum,
        Interface,
        Struct,
        TypeParameter,
        Parameter,
        Variable,
        Property,
        EnumMember,
        Event,
        Function,
        Method,
        Macro,
        Keyword,
        Modifier,
        Comment,
        String,
        Number,
        Regexp,
        Operator,
        /**
         * @since 3.17.0
         */
        Decorator,
    }; // enum class SemanticTokenTypes

    extern const std::map<SemanticTokenTypes, std::string>
        SemanticTokenTypesNames;

    extern const std::map<SemanticTokenTypes, std::string>
        SemanticTokenTypesValues;

    auto semanticTokenTypesByName(
        const std::string &name
    ) -> SemanticTokenTypes;

    auto semanticTokenTypesByValue(
        const std::string &value
    ) -> SemanticTokenTypes;

    auto isSemanticTokenTypes(const std::string &value) -> bool;

    /**
     * A set of predefined token modifiers. This set is not fixed
     * an clients can specify additional token types via the
     * corresponding client capabilities.
     *
     * @since 3.16.0
     */
    enum class SemanticTokenModifiers {
        Declaration,
        Definition,
        Readonly,
        Static,
        Deprecated,
        Abstract,
        Async,
        Modification,
        Documentation,
        DefaultLibrary,
    }; // enum class SemanticTokenModifiers

    extern const std::map<SemanticTokenModifiers, std::string>
        SemanticTokenModifiersNames;

    extern const std::map<SemanticTokenModifiers, std::string>
        SemanticTokenModifiersValues;

    auto semanticTokenModifiersByName(
        const std::string &name
    ) -> SemanticTokenModifiers;

    auto semanticTokenModifiersByValue(
        const std::string &value
    ) -> SemanticTokenModifiers;

    auto isSemanticTokenModifiers(const std::string &value) -> bool;

    /**
     * The document diagnostic report kinds.
     *
     * @since 3.17.0
     */
    enum class DocumentDiagnosticReportKind {
        /**
         * A diagnostic report with a full
         * set of problems.
         */
        Full,
        /**
         * A report indicating that the last
         * returned report is still accurate.
         */
        Unchanged,
    }; // enum class DocumentDiagnosticReportKind

    extern const std::map<DocumentDiagnosticReportKind, std::string>
        DocumentDiagnosticReportKindNames;

    extern const std::map<DocumentDiagnosticReportKind, std::string>
        DocumentDiagnosticReportKindValues;

    auto documentDiagnosticReportKindByName(
        const std::string &name
    ) -> DocumentDiagnosticReportKind;

    auto documentDiagnosticReportKindByValue(
        const std::string &value
    ) -> DocumentDiagnosticReportKind;

    auto isDocumentDiagnosticReportKind(const std::string &value) -> bool;

    /**
     * Predefined error codes.
     */
    enum class ErrorCodes {
        ParseError = -32700,
        InvalidRequest = -32600,
        MethodNotFound = -32601,
        InvalidParams = -32602,
        InternalError = -32603,
        /**
         * Error code indicating that a server received a notification or
         * request before the server has received the `initialize` request.
         */
        ServerNotInitialized = -32002,
        UnknownErrorCode = -32001,
    }; // enum class ErrorCodes

    extern const std::map<ErrorCodes, std::string> ErrorCodesNames;

    auto errorCodesByName(const std::string &name) -> ErrorCodes;

    auto errorCodesByValue(int value) -> ErrorCodes;

    enum class LSPErrorCodes {
        /**
         * A request failed but it was syntactically correct, e.g the
         * method name was known and the parameters were valid. The error
         * message should contain human readable information about why
         * the request failed.
         *
         * @since 3.17.0
         */
        RequestFailed = -32803,
        /**
         * The server cancelled the request. This error code should
         * only be used for requests that explicitly support being
         * server cancellable.
         *
         * @since 3.17.0
         */
        ServerCancelled = -32802,
        /**
         * The server detected that the content of a document got
         * modified outside normal conditions. A server should
         * NOT send this error code if it detects a content change
         * in it unprocessed messages. The result even computed
         * on an older state might still be useful for the client.
         *
         * If a client decides that a result is not of any use anymore
         * the client should cancel the request.
         */
        ContentModified = -32801,
        /**
         * The client has canceled a request and a server has detected
         * the cancel.
         */
        RequestCancelled = -32800,
    }; // enum class LSPErrorCodes

    extern const std::map<LSPErrorCodes, std::string> LSPErrorCodesNames;

    auto lspErrorCodesByName(const std::string &name) -> LSPErrorCodes;

    auto lspErrorCodesByValue(int value) -> LSPErrorCodes;

    /**
     * A set of predefined range kinds.
     */
    enum class FoldingRangeKind {
        /**
         * Folding range for a comment
         */
        Comment,
        /**
         * Folding range for an import or include
         */
        Imports,
        /**
         * Folding range for a region (e.g. `#region`)
         */
        Region,
    }; // enum class FoldingRangeKind

    extern const std::map<FoldingRangeKind, std::string> FoldingRangeKindNames;

    extern const std::map<FoldingRangeKind, std::string>
        FoldingRangeKindValues;

    auto foldingRangeKindByName(const std::string &name) -> FoldingRangeKind;

    auto foldingRangeKindByValue(const std::string &value) -> FoldingRangeKind;

    auto isFoldingRangeKind(const std::string &value) -> bool;

    struct FoldingRangeClientCapabilities_foldingRangeKind {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FoldingRangeClientCapabilities_foldingRangeKind();
        FoldingRangeClientCapabilities_foldingRangeKind(
            FoldingRangeClientCapabilities_foldingRangeKind &&other
        );
        FoldingRangeClientCapabilities_foldingRangeKind(
            const FoldingRangeClientCapabilities_foldingRangeKind &other
        );
        ~FoldingRangeClientCapabilities_foldingRangeKind();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            FoldingRangeClientCapabilities_foldingRangeKind &&other
        ) -> FoldingRangeClientCapabilities_foldingRangeKind &;

        auto operator=(
            const FoldingRangeClientCapabilities_foldingRangeKind &other
        ) -> FoldingRangeClientCapabilities_foldingRangeKind &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The folding range kind values the client supports. When this
         * property exists the client also guarantees that it will
         * handle values outside its set gracefully and falls back
         * to a default value when unknown.
         */
        std::optional<std::vector<FoldingRangeKind>> valueSet;
    }; // struct FoldingRangeClientCapabilities_foldingRangeKind

    typedef std::vector<FoldingRangeKind> FoldingRangeClientCapabilities_foldingRangeKind_valueSet;

    /**
     * A symbol kind.
     */
    enum class SymbolKind {
        File = 1,
        Module = 2,
        Namespace = 3,
        Package = 4,
        Class = 5,
        Method = 6,
        Property = 7,
        Field = 8,
        Constructor = 9,
        Enum = 10,
        Interface = 11,
        Function = 12,
        Variable = 13,
        Constant = 14,
        String = 15,
        Number = 16,
        Boolean = 17,
        Array = 18,
        Object = 19,
        Key = 20,
        Null = 21,
        EnumMember = 22,
        Struct = 23,
        Event = 24,
        Operator = 25,
        TypeParameter = 26,
    }; // enum class SymbolKind

    extern const std::map<SymbolKind, std::string> SymbolKindNames;

    auto symbolKindByName(const std::string &name) -> SymbolKind;

    auto symbolKindByValue(unsigned int value) -> SymbolKind;

    struct WorkspaceSymbolClientCapabilities_symbolKind {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceSymbolClientCapabilities_symbolKind();
        WorkspaceSymbolClientCapabilities_symbolKind(
            WorkspaceSymbolClientCapabilities_symbolKind &&other
        );
        WorkspaceSymbolClientCapabilities_symbolKind(
            const WorkspaceSymbolClientCapabilities_symbolKind &other
        );
        ~WorkspaceSymbolClientCapabilities_symbolKind();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceSymbolClientCapabilities_symbolKind &&other
        ) -> WorkspaceSymbolClientCapabilities_symbolKind &;

        auto operator=(
            const WorkspaceSymbolClientCapabilities_symbolKind &other
        ) -> WorkspaceSymbolClientCapabilities_symbolKind &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The symbol kind values the client supports. When this
         * property exists the client also guarantees that it will
         * handle values outside its set gracefully and falls back
         * to a default value when unknown.
         *
         * If this property is not present the client only supports
         * the symbol kinds from `File` to `Array` as defined in
         * the initial version of the protocol.
         */
        std::optional<std::vector<SymbolKind>> valueSet;
    }; // struct WorkspaceSymbolClientCapabilities_symbolKind

    typedef std::vector<SymbolKind> WorkspaceSymbolClientCapabilities_symbolKind_valueSet;

    struct DocumentSymbolClientCapabilities_symbolKind {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentSymbolClientCapabilities_symbolKind();
        DocumentSymbolClientCapabilities_symbolKind(
            DocumentSymbolClientCapabilities_symbolKind &&other
        );
        DocumentSymbolClientCapabilities_symbolKind(
            const DocumentSymbolClientCapabilities_symbolKind &other
        );
        ~DocumentSymbolClientCapabilities_symbolKind();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentSymbolClientCapabilities_symbolKind &&other
        ) -> DocumentSymbolClientCapabilities_symbolKind &;

        auto operator=(
            const DocumentSymbolClientCapabilities_symbolKind &other
        ) -> DocumentSymbolClientCapabilities_symbolKind &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The symbol kind values the client supports. When this
         * property exists the client also guarantees that it will
         * handle values outside its set gracefully and falls back
         * to a default value when unknown.
         *
         * If this property is not present the client only supports
         * the symbol kinds from `File` to `Array` as defined in
         * the initial version of the protocol.
         */
        std::optional<std::vector<SymbolKind>> valueSet;
    }; // struct DocumentSymbolClientCapabilities_symbolKind

    typedef std::vector<SymbolKind> DocumentSymbolClientCapabilities_symbolKind_valueSet;

    /**
     * Symbol tags are extra annotations that tweak the rendering of a symbol.
     *
     * @since 3.16
     */
    enum class SymbolTag {
        /**
         * Render a symbol as obsolete, usually using a strike-out.
         */
        Deprecated = 1,
    }; // enum class SymbolTag

    extern const std::map<SymbolTag, std::string> SymbolTagNames;

    auto symbolTagByName(const std::string &name) -> SymbolTag;

    auto symbolTagByValue(unsigned int value) -> SymbolTag;

    typedef std::vector<SymbolTag> CallHierarchyItem_tags;

    typedef std::vector<SymbolTag> TypeHierarchyItem_tags;

    typedef std::vector<SymbolTag> DocumentSymbol_tags;

    typedef std::vector<SymbolTag> BaseSymbolInformation_tags;

    struct WorkspaceSymbolClientCapabilities_tagSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceSymbolClientCapabilities_tagSupport();
        WorkspaceSymbolClientCapabilities_tagSupport(
            WorkspaceSymbolClientCapabilities_tagSupport &&other
        );
        WorkspaceSymbolClientCapabilities_tagSupport(
            const WorkspaceSymbolClientCapabilities_tagSupport &other
        );
        ~WorkspaceSymbolClientCapabilities_tagSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceSymbolClientCapabilities_tagSupport &&other
        ) -> WorkspaceSymbolClientCapabilities_tagSupport &;

        auto operator=(
            const WorkspaceSymbolClientCapabilities_tagSupport &other
        ) -> WorkspaceSymbolClientCapabilities_tagSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The tags supported by the client.
         */
        std::vector<SymbolTag> valueSet;
    }; // struct WorkspaceSymbolClientCapabilities_tagSupport

    typedef std::vector<SymbolTag> WorkspaceSymbolClientCapabilities_tagSupport_valueSet;

    struct DocumentSymbolClientCapabilities_tagSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentSymbolClientCapabilities_tagSupport();
        DocumentSymbolClientCapabilities_tagSupport(
            DocumentSymbolClientCapabilities_tagSupport &&other
        );
        DocumentSymbolClientCapabilities_tagSupport(
            const DocumentSymbolClientCapabilities_tagSupport &other
        );
        ~DocumentSymbolClientCapabilities_tagSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentSymbolClientCapabilities_tagSupport &&other
        ) -> DocumentSymbolClientCapabilities_tagSupport &;

        auto operator=(
            const DocumentSymbolClientCapabilities_tagSupport &other
        ) -> DocumentSymbolClientCapabilities_tagSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The tags supported by the client.
         */
        std::vector<SymbolTag> valueSet;
    }; // struct DocumentSymbolClientCapabilities_tagSupport

    typedef std::vector<SymbolTag> DocumentSymbolClientCapabilities_tagSupport_valueSet;

    /**
     * Moniker uniqueness level to define scope of the moniker.
     *
     * @since 3.16.0
     */
    enum class UniquenessLevel {
        /**
         * The moniker is only unique inside a document
         */
        Document,
        /**
         * The moniker is unique inside a project for which a dump got created
         */
        Project,
        /**
         * The moniker is unique inside the group to which a project belongs
         */
        Group,
        /**
         * The moniker is unique inside the moniker scheme.
         */
        Scheme,
        /**
         * The moniker is globally unique
         */
        Global,
    }; // enum class UniquenessLevel

    extern const std::map<UniquenessLevel, std::string> UniquenessLevelNames;

    extern const std::map<UniquenessLevel, std::string> UniquenessLevelValues;

    auto uniquenessLevelByName(const std::string &name) -> UniquenessLevel;

    auto uniquenessLevelByValue(const std::string &value) -> UniquenessLevel;

    auto isUniquenessLevel(const std::string &value) -> bool;

    /**
     * The moniker kind.
     *
     * @since 3.16.0
     */
    enum class MonikerKind {
        /**
         * The moniker represent a symbol that is imported into a project
         */
        Import,
        /**
         * The moniker represents a symbol that is exported from a project
         */
        Export,
        /**
         * The moniker represents a symbol that is local to a project (e.g. a local
         * variable of a function, a class not visible outside the project, ...)
         */
        Local,
    }; // enum class MonikerKind

    extern const std::map<MonikerKind, std::string> MonikerKindNames;

    extern const std::map<MonikerKind, std::string> MonikerKindValues;

    auto monikerKindByName(const std::string &name) -> MonikerKind;

    auto monikerKindByValue(const std::string &value) -> MonikerKind;

    auto isMonikerKind(const std::string &value) -> bool;

    /**
     * Inlay hint kinds.
     *
     * @since 3.17.0
     */
    enum class InlayHintKind {
        /**
         * An inlay hint that for a type annotation.
         */
        Type = 1,
        /**
         * An inlay hint that is for a parameter.
         */
        Parameter = 2,
    }; // enum class InlayHintKind

    extern const std::map<InlayHintKind, std::string> InlayHintKindNames;

    auto inlayHintKindByName(const std::string &name) -> InlayHintKind;

    auto inlayHintKindByValue(unsigned int value) -> InlayHintKind;

    /**
     * The message type
     */
    enum class MessageType {
        /**
         * An error message.
         */
        Error = 1,
        /**
         * A warning message.
         */
        Warning = 2,
        /**
         * An information message.
         */
        Info = 3,
        /**
         * A log message.
         */
        Log = 4,
        /**
         * A debug message.
         *
         * @since 3.18.0
         */
        Debug = 5,
    }; // enum class MessageType

    extern const std::map<MessageType, std::string> MessageTypeNames;

    auto messageTypeByName(const std::string &name) -> MessageType;

    auto messageTypeByValue(unsigned int value) -> MessageType;

    /**
     * Defines how the host (editor) should sync
     * document changes to the language server.
     */
    enum class TextDocumentSyncKind {
        /**
         * Documents should not be synced at all.
         */
        None = 0,
        /**
         * Documents are synced by always sending the full content
         * of the document.
         */
        Full = 1,
        /**
         * Documents are synced by sending the full content on open.
         * After that only incremental updates to the document are
         * send.
         */
        Incremental = 2,
    }; // enum class TextDocumentSyncKind

    extern const std::map<TextDocumentSyncKind, std::string>
        TextDocumentSyncKindNames;

    auto textDocumentSyncKindByName(
        const std::string &name
    ) -> TextDocumentSyncKind;

    auto textDocumentSyncKindByValue(
        unsigned int value
    ) -> TextDocumentSyncKind;

    /**
     * Represents reasons why a text document is saved.
     */
    enum class TextDocumentSaveReason {
        /**
         * Manually triggered, e.g. by the user pressing save, by starting debugging,
         * or by an API call.
         */
        Manual = 1,
        /**
         * Automatic after a delay.
         */
        AfterDelay = 2,
        /**
         * When the editor lost focus.
         */
        FocusOut = 3,
    }; // enum class TextDocumentSaveReason

    extern const std::map<TextDocumentSaveReason, std::string>
        TextDocumentSaveReasonNames;

    auto textDocumentSaveReasonByName(
        const std::string &name
    ) -> TextDocumentSaveReason;

    auto textDocumentSaveReasonByValue(
        unsigned int value
    ) -> TextDocumentSaveReason;

    /**
     * The kind of a completion entry.
     */
    enum class CompletionItemKind {
        Text = 1,
        Method = 2,
        Function = 3,
        Constructor = 4,
        Field = 5,
        Variable = 6,
        Class = 7,
        Interface = 8,
        Module = 9,
        Property = 10,
        Unit = 11,
        Value = 12,
        Enum = 13,
        Keyword = 14,
        Snippet = 15,
        Color = 16,
        File = 17,
        Reference = 18,
        Folder = 19,
        EnumMember = 20,
        Constant = 21,
        Struct = 22,
        Event = 23,
        Operator = 24,
        TypeParameter = 25,
    }; // enum class CompletionItemKind

    extern const std::map<CompletionItemKind, std::string>
        CompletionItemKindNames;

    auto completionItemKindByName(
        const std::string &name
    ) -> CompletionItemKind;

    auto completionItemKindByValue(unsigned int value) -> CompletionItemKind;

    struct CompletionClientCapabilities_completionItemKind {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionClientCapabilities_completionItemKind();
        CompletionClientCapabilities_completionItemKind(
            CompletionClientCapabilities_completionItemKind &&other
        );
        CompletionClientCapabilities_completionItemKind(
            const CompletionClientCapabilities_completionItemKind &other
        );
        ~CompletionClientCapabilities_completionItemKind();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionClientCapabilities_completionItemKind &&other
        ) -> CompletionClientCapabilities_completionItemKind &;

        auto operator=(
            const CompletionClientCapabilities_completionItemKind &other
        ) -> CompletionClientCapabilities_completionItemKind &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The completion item kind values the client supports. When this
         * property exists the client also guarantees that it will
         * handle values outside its set gracefully and falls back
         * to a default value when unknown.
         *
         * If this property is not present the client only supports
         * the completion items kinds from `Text` to `Reference` as defined in
         * the initial version of the protocol.
         */
        std::optional<std::vector<CompletionItemKind>> valueSet;
    }; // struct CompletionClientCapabilities_completionItemKind

    typedef std::vector<CompletionItemKind> CompletionClientCapabilities_completionItemKind_valueSet;

    /**
     * Completion item tags are extra annotations that tweak the rendering of a completion
     * item.
     *
     * @since 3.15.0
     */
    enum class CompletionItemTag {
        /**
         * Render a completion as obsolete, usually using a strike-out.
         */
        Deprecated = 1,
    }; // enum class CompletionItemTag

    extern const std::map<CompletionItemTag, std::string>
        CompletionItemTagNames;

    auto completionItemTagByName(const std::string &name) -> CompletionItemTag;

    auto completionItemTagByValue(unsigned int value) -> CompletionItemTag;

    typedef std::vector<CompletionItemTag> CompletionItem_tags;

    struct CompletionClientCapabilities_completionItem_tagSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionClientCapabilities_completionItem_tagSupport();
        CompletionClientCapabilities_completionItem_tagSupport(
            CompletionClientCapabilities_completionItem_tagSupport &&other
        );
        CompletionClientCapabilities_completionItem_tagSupport(
            const CompletionClientCapabilities_completionItem_tagSupport &other
        );
        ~CompletionClientCapabilities_completionItem_tagSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionClientCapabilities_completionItem_tagSupport &&other
        ) -> CompletionClientCapabilities_completionItem_tagSupport &;

        auto operator=(
            const CompletionClientCapabilities_completionItem_tagSupport &other
        ) -> CompletionClientCapabilities_completionItem_tagSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The tags supported by the client.
         */
        std::vector<CompletionItemTag> valueSet;
    }; // struct CompletionClientCapabilities_completionItem_tagSupport

    typedef std::vector<CompletionItemTag> CompletionClientCapabilities_completionItem_tagSupport_valueSet;

    /**
     * Defines whether the insert text in a completion item should be interpreted as
     * plain text or a snippet.
     */
    enum class InsertTextFormat {
        /**
         * The primary text to be inserted is treated as a plain string.
         */
        PlainText = 1,
        /**
         * The primary text to be inserted is treated as a snippet.
         *
         * A snippet can define tab stops and placeholders with `$1`, `$2`
         * and `${3:foo}`. `$0` defines the final tab stop, it defaults to
         * the end of the snippet. Placeholders with equal identifiers are linked,
         * that is typing in one will update others too.
         *
         * See also: https://microsoft.github.io/language-server-protocol/specifications/specification-current/#snippet_syntax
         */
        Snippet = 2,
    }; // enum class InsertTextFormat

    extern const std::map<InsertTextFormat, std::string> InsertTextFormatNames;

    auto insertTextFormatByName(const std::string &name) -> InsertTextFormat;

    auto insertTextFormatByValue(unsigned int value) -> InsertTextFormat;

    /**
     * How whitespace and indentation is handled during completion
     * item insertion.
     *
     * @since 3.16.0
     */
    enum class InsertTextMode {
        /**
         * The insertion or replace strings is taken as it is. If the
         * value is multi line the lines below the cursor will be
         * inserted using the indentation defined in the string value.
         * The client will not apply any kind of adjustments to the
         * string.
         */
        AsIs = 1,
        /**
         * The editor adjusts leading whitespace of new lines so that
         * they match the indentation up to the cursor of the line for
         * which the item is accepted.
         *
         * Consider a line like this: <2tabs><cursor><3tabs>foo. Accepting a
         * multi line completion item is indented using 2 tabs and all
         * following lines inserted will be indented using 2 tabs as well.
         */
        AdjustIndentation = 2,
    }; // enum class InsertTextMode

    extern const std::map<InsertTextMode, std::string> InsertTextModeNames;

    auto insertTextModeByName(const std::string &name) -> InsertTextMode;

    auto insertTextModeByValue(unsigned int value) -> InsertTextMode;

    struct CompletionClientCapabilities_completionItem_insertTextModeSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionClientCapabilities_completionItem_insertTextModeSupport();
        CompletionClientCapabilities_completionItem_insertTextModeSupport(
            CompletionClientCapabilities_completionItem_insertTextModeSupport &&other
        );
        CompletionClientCapabilities_completionItem_insertTextModeSupport(
            const CompletionClientCapabilities_completionItem_insertTextModeSupport &other
        );
        ~CompletionClientCapabilities_completionItem_insertTextModeSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionClientCapabilities_completionItem_insertTextModeSupport &&other
        ) -> CompletionClientCapabilities_completionItem_insertTextModeSupport &;

        auto operator=(
            const CompletionClientCapabilities_completionItem_insertTextModeSupport &other
        ) -> CompletionClientCapabilities_completionItem_insertTextModeSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::vector<InsertTextMode> valueSet;
    }; // struct CompletionClientCapabilities_completionItem_insertTextModeSupport

    typedef std::vector<InsertTextMode> CompletionClientCapabilities_completionItem_insertTextModeSupport_valueSet;

    /**
     * A document highlight kind.
     */
    enum class DocumentHighlightKind {
        /**
         * A textual occurrence.
         */
        Text = 1,
        /**
         * Read-access of a symbol, like reading a variable.
         */
        Read = 2,
        /**
         * Write-access of a symbol, like writing to a variable.
         */
        Write = 3,
    }; // enum class DocumentHighlightKind

    extern const std::map<DocumentHighlightKind, std::string>
        DocumentHighlightKindNames;

    auto documentHighlightKindByName(
        const std::string &name
    ) -> DocumentHighlightKind;

    auto documentHighlightKindByValue(
        unsigned int value
    ) -> DocumentHighlightKind;

    /**
     * A set of predefined code action kinds
     */
    enum class CodeActionKind {
        /**
         * Empty kind.
         */
        Empty,
        /**
         * Base kind for quickfix actions: 'quickfix'
         */
        QuickFix,
        /**
         * Base kind for refactoring actions: 'refactor'
         */
        Refactor,
        /**
         * Base kind for refactoring extraction actions: 'refactor.extract'
         *
         * Example extract actions:
         *
         * - Extract method
         * - Extract function
         * - Extract variable
         * - Extract interface from class
         * - ...
         */
        RefactorExtract,
        /**
         * Base kind for refactoring inline actions: 'refactor.inline'
         *
         * Example inline actions:
         *
         * - Inline function
         * - Inline variable
         * - Inline constant
         * - ...
         */
        RefactorInline,
        /**
         * Base kind for refactoring rewrite actions: 'refactor.rewrite'
         *
         * Example rewrite actions:
         *
         * - Convert JavaScript function to class
         * - Add or remove parameter
         * - Encapsulate field
         * - Make method static
         * - Move method to base class
         * - ...
         */
        RefactorRewrite,
        /**
         * Base kind for source actions: `source`
         *
         * Source code actions apply to the entire file.
         */
        Source,
        /**
         * Base kind for an organize imports source action: `source.organizeImports`
         */
        SourceOrganizeImports,
        /**
         * Base kind for auto-fix source actions: `source.fixAll`.
         *
         * Fix all actions automatically fix errors that have a clear fix that do not require user input.
         * They should not suppress errors or perform unsafe fixes such as generating new types or classes.
         *
         * @since 3.15.0
         */
        SourceFixAll,
    }; // enum class CodeActionKind

    extern const std::map<CodeActionKind, std::string> CodeActionKindNames;

    extern const std::map<CodeActionKind, std::string> CodeActionKindValues;

    auto codeActionKindByName(const std::string &name) -> CodeActionKind;

    auto codeActionKindByValue(const std::string &value) -> CodeActionKind;

    auto isCodeActionKind(const std::string &value) -> bool;

    typedef std::vector<CodeActionKind> CodeActionContext_only;

    typedef std::vector<CodeActionKind> CodeActionOptions_codeActionKinds;

    struct CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind();
        CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind(
            CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &&other
        );
        CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind(
            const CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &other
        );
        ~CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &&other
        ) -> CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &;

        auto operator=(
            const CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &other
        ) -> CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The code action kind values the client supports. When this
         * property exists the client also guarantees that it will
         * handle values outside its set gracefully and falls back
         * to a default value when unknown.
         */
        std::vector<CodeActionKind> valueSet;
    }; // struct CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind

    struct CodeActionClientCapabilities_codeActionLiteralSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeActionClientCapabilities_codeActionLiteralSupport();
        CodeActionClientCapabilities_codeActionLiteralSupport(
            CodeActionClientCapabilities_codeActionLiteralSupport &&other
        );
        CodeActionClientCapabilities_codeActionLiteralSupport(
            const CodeActionClientCapabilities_codeActionLiteralSupport &other
        );
        ~CodeActionClientCapabilities_codeActionLiteralSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CodeActionClientCapabilities_codeActionLiteralSupport &&other
        ) -> CodeActionClientCapabilities_codeActionLiteralSupport &;

        auto operator=(
            const CodeActionClientCapabilities_codeActionLiteralSupport &other
        ) -> CodeActionClientCapabilities_codeActionLiteralSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The code action kind is support with the following value
         * set.
         */
        CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind
            codeActionKind;
    }; // struct CodeActionClientCapabilities_codeActionLiteralSupport

    typedef std::vector<CodeActionKind> CodeActionClientCapabilities_codeActionLiteralSupport_codeActionKind_valueSet;

    enum class TraceValues {
        /**
         * Turn tracing off.
         */
        Off,
        /**
         * Trace messages only.
         */
        Messages,
        /**
         * Verbose message tracing.
         */
        Verbose,
    }; // enum class TraceValues

    extern const std::map<TraceValues, std::string> TraceValuesNames;

    extern const std::map<TraceValues, std::string> TraceValuesValues;

    auto traceValuesByName(const std::string &name) -> TraceValues;

    auto traceValuesByValue(const std::string &value) -> TraceValues;

    auto isTraceValues(const std::string &value) -> bool;

    struct SetTraceParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SetTraceParams();
        SetTraceParams(SetTraceParams &&other);
        SetTraceParams(const SetTraceParams &other);
        ~SetTraceParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SetTraceParams &&other) -> SetTraceParams &;

        auto operator=(const SetTraceParams &other) -> SetTraceParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        TraceValues value;
    }; // struct SetTraceParams

    /**
     * Describes the content type that a client supports in various
     * result literals like `Hover`, `ParameterInfo` or `CompletionItem`.
     *
     * Please note that `MarkupKinds` must not start with a `$`. This kinds
     * are reserved for internal usage.
     */
    enum class MarkupKind {
        /**
         * Plain text is supported as a content format
         */
        PlainText,
        /**
         * Markdown is supported as a content format
         */
        Markdown,
    }; // enum class MarkupKind

    extern const std::map<MarkupKind, std::string> MarkupKindNames;

    extern const std::map<MarkupKind, std::string> MarkupKindValues;

    auto markupKindByName(const std::string &name) -> MarkupKind;

    auto markupKindByValue(const std::string &value) -> MarkupKind;

    auto isMarkupKind(const std::string &value) -> bool;

    typedef std::vector<MarkupKind> CompletionClientCapabilities_completionItem_documentationFormat;

    typedef std::vector<MarkupKind> HoverClientCapabilities_contentFormat;

    typedef std::vector<MarkupKind> SignatureHelpClientCapabilities_signatureInformation_documentationFormat;

    /**
     * Describes how an {@link InlineCompletionItemProvider inline completion provider} was triggered.
     *
     * @since 3.18.0
     * @proposed
     */
    enum class InlineCompletionTriggerKind {
        /**
         * Completion was triggered explicitly by a user gesture.
         */
        Invoked = 0,
        /**
         * Completion was triggered automatically while editing.
         */
        Automatic = 1,
    }; // enum class InlineCompletionTriggerKind

    extern const std::map<InlineCompletionTriggerKind, std::string>
        InlineCompletionTriggerKindNames;

    auto inlineCompletionTriggerKindByName(
        const std::string &name
    ) -> InlineCompletionTriggerKind;

    auto inlineCompletionTriggerKindByValue(
        unsigned int value
    ) -> InlineCompletionTriggerKind;

    /**
     * A set of predefined position encoding kinds.
     *
     * @since 3.17.0
     */
    enum class PositionEncodingKind {
        /**
         * Character offsets count UTF-8 code units (e.g. bytes).
         */
        UTF8,
        /**
         * Character offsets count UTF-16 code units.
         *
         * This is the default and must always be supported
         * by servers
         */
        UTF16,
        /**
         * Character offsets count UTF-32 code units.
         *
         * Implementation note: these are the same as Unicode codepoints,
         * so this `PositionEncodingKind` may also be used for an
         * encoding-agnostic representation of character offsets.
         */
        UTF32,
    }; // enum class PositionEncodingKind

    extern const std::map<PositionEncodingKind, std::string>
        PositionEncodingKindNames;

    extern const std::map<PositionEncodingKind, std::string>
        PositionEncodingKindValues;

    auto positionEncodingKindByName(
        const std::string &name
    ) -> PositionEncodingKind;

    auto positionEncodingKindByValue(
        const std::string &value
    ) -> PositionEncodingKind;

    auto isPositionEncodingKind(const std::string &value) -> bool;

    typedef std::vector<PositionEncodingKind> GeneralClientCapabilities_positionEncodings;

    /**
     * The file event type
     */
    enum class FileChangeType {
        /**
         * The file got created.
         */
        Created = 1,
        /**
         * The file got changed.
         */
        Changed = 2,
        /**
         * The file got deleted.
         */
        Deleted = 3,
    }; // enum class FileChangeType

    extern const std::map<FileChangeType, std::string> FileChangeTypeNames;

    auto fileChangeTypeByName(const std::string &name) -> FileChangeType;

    auto fileChangeTypeByValue(unsigned int value) -> FileChangeType;

    enum class WatchKind {
        /**
         * Interested in create events.
         */
        Create = 1,
        /**
         * Interested in change events
         */
        Change = 2,
        /**
         * Interested in delete events
         */
        Delete = 4,
    }; // enum class WatchKind

    extern const std::map<WatchKind, std::string> WatchKindNames;

    auto watchKindByName(const std::string &name) -> WatchKind;

    auto watchKindByValue(unsigned int value) -> WatchKind;

    /**
     * The diagnostic's severity.
     */
    enum class DiagnosticSeverity {
        /**
         * Reports an error.
         */
        Error = 1,
        /**
         * Reports a warning.
         */
        Warning = 2,
        /**
         * Reports an information.
         */
        Information = 3,
        /**
         * Reports a hint.
         */
        Hint = 4,
    }; // enum class DiagnosticSeverity

    extern const std::map<DiagnosticSeverity, std::string>
        DiagnosticSeverityNames;

    auto diagnosticSeverityByName(
        const std::string &name
    ) -> DiagnosticSeverity;

    auto diagnosticSeverityByValue(unsigned int value) -> DiagnosticSeverity;

    /**
     * The diagnostic tags.
     *
     * @since 3.15.0
     */
    enum class DiagnosticTag {
        /**
         * Unused or unnecessary code.
         *
         * Clients are allowed to render diagnostics with this tag faded out instead of having
         * an error squiggle.
         */
        Unnecessary = 1,
        /**
         * Deprecated or obsolete code.
         *
         * Clients are allowed to rendered diagnostics with this tag strike through.
         */
        Deprecated = 2,
    }; // enum class DiagnosticTag

    extern const std::map<DiagnosticTag, std::string> DiagnosticTagNames;

    auto diagnosticTagByName(const std::string &name) -> DiagnosticTag;

    auto diagnosticTagByValue(unsigned int value) -> DiagnosticTag;

    typedef std::vector<DiagnosticTag> Diagnostic_tags;

    struct PublishDiagnosticsClientCapabilities_tagSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        PublishDiagnosticsClientCapabilities_tagSupport();
        PublishDiagnosticsClientCapabilities_tagSupport(
            PublishDiagnosticsClientCapabilities_tagSupport &&other
        );
        PublishDiagnosticsClientCapabilities_tagSupport(
            const PublishDiagnosticsClientCapabilities_tagSupport &other
        );
        ~PublishDiagnosticsClientCapabilities_tagSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            PublishDiagnosticsClientCapabilities_tagSupport &&other
        ) -> PublishDiagnosticsClientCapabilities_tagSupport &;

        auto operator=(
            const PublishDiagnosticsClientCapabilities_tagSupport &other
        ) -> PublishDiagnosticsClientCapabilities_tagSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The tags supported by the client.
         */
        std::vector<DiagnosticTag> valueSet;
    }; // struct PublishDiagnosticsClientCapabilities_tagSupport

    typedef std::vector<DiagnosticTag> PublishDiagnosticsClientCapabilities_tagSupport_valueSet;

    /**
     * How a completion was triggered
     */
    enum class CompletionTriggerKind {
        /**
         * Completion was triggered by typing an identifier (24x7 code
         * complete), manual invocation (e.g Ctrl+Space) or via API.
         */
        Invoked = 1,
        /**
         * Completion was triggered by a trigger character specified by
         * the `triggerCharacters` properties of the `CompletionRegistrationOptions`.
         */
        TriggerCharacter = 2,
        /**
         * Completion was re-triggered as current completion list is incomplete
         */
        TriggerForIncompleteCompletions = 3,
    }; // enum class CompletionTriggerKind

    extern const std::map<CompletionTriggerKind, std::string>
        CompletionTriggerKindNames;

    auto completionTriggerKindByName(
        const std::string &name
    ) -> CompletionTriggerKind;

    auto completionTriggerKindByValue(
        unsigned int value
    ) -> CompletionTriggerKind;

    /**
     * How a signature help was triggered.
     *
     * @since 3.15.0
     */
    enum class SignatureHelpTriggerKind {
        /**
         * Signature help was invoked manually by the user or by a command.
         */
        Invoked = 1,
        /**
         * Signature help was triggered by a trigger character.
         */
        TriggerCharacter = 2,
        /**
         * Signature help was triggered by the cursor moving or by the document content changing.
         */
        ContentChange = 3,
    }; // enum class SignatureHelpTriggerKind

    extern const std::map<SignatureHelpTriggerKind, std::string>
        SignatureHelpTriggerKindNames;

    auto signatureHelpTriggerKindByName(
        const std::string &name
    ) -> SignatureHelpTriggerKind;

    auto signatureHelpTriggerKindByValue(
        unsigned int value
    ) -> SignatureHelpTriggerKind;

    /**
     * The reason why code actions were requested.
     *
     * @since 3.17.0
     */
    enum class CodeActionTriggerKind {
        /**
         * Code actions were explicitly requested by the user or by an extension.
         */
        Invoked = 1,
        /**
         * Code actions were requested automatically.
         *
         * This typically happens when current selection in a file changes, but can
         * also be triggered when file content changes.
         */
        Automatic = 2,
    }; // enum class CodeActionTriggerKind

    extern const std::map<CodeActionTriggerKind, std::string>
        CodeActionTriggerKindNames;

    auto codeActionTriggerKindByName(
        const std::string &name
    ) -> CodeActionTriggerKind;

    auto codeActionTriggerKindByValue(
        unsigned int value
    ) -> CodeActionTriggerKind;

    /**
     * A pattern kind describing if a glob pattern matches a file a folder or
     * both.
     *
     * @since 3.16.0
     */
    enum class FileOperationPatternKind {
        /**
         * The pattern matches a file only.
         */
        File,
        /**
         * The pattern matches a folder only.
         */
        Folder,
    }; // enum class FileOperationPatternKind

    extern const std::map<FileOperationPatternKind, std::string>
        FileOperationPatternKindNames;

    extern const std::map<FileOperationPatternKind, std::string>
        FileOperationPatternKindValues;

    auto fileOperationPatternKindByName(
        const std::string &name
    ) -> FileOperationPatternKind;

    auto fileOperationPatternKindByValue(
        const std::string &value
    ) -> FileOperationPatternKind;

    auto isFileOperationPatternKind(const std::string &value) -> bool;

    /**
     * A notebook cell kind.
     *
     * @since 3.17.0
     */
    enum class NotebookCellKind {
        /**
         * A markup-cell is formatted source that is used for display.
         */
        Markup = 1,
        /**
         * A code-cell is source code.
         */
        Code = 2,
    }; // enum class NotebookCellKind

    extern const std::map<NotebookCellKind, std::string> NotebookCellKindNames;

    auto notebookCellKindByName(const std::string &name) -> NotebookCellKind;

    auto notebookCellKindByValue(unsigned int value) -> NotebookCellKind;

    enum class ResourceOperationKind {
        /**
         * Supports creating new files and folders.
         */
        Create,
        /**
         * Supports renaming existing files and folders.
         */
        Rename,
        /**
         * Supports deleting existing files and folders.
         */
        Delete,
    }; // enum class ResourceOperationKind

    extern const std::map<ResourceOperationKind, std::string>
        ResourceOperationKindNames;

    extern const std::map<ResourceOperationKind, std::string>
        ResourceOperationKindValues;

    auto resourceOperationKindByName(
        const std::string &name
    ) -> ResourceOperationKind;

    auto resourceOperationKindByValue(
        const std::string &value
    ) -> ResourceOperationKind;

    auto isResourceOperationKind(const std::string &value) -> bool;

    typedef std::vector<ResourceOperationKind> WorkspaceEditClientCapabilities_resourceOperations;

    enum class FailureHandlingKind {
        /**
         * Applying the workspace change is simply aborted if one of the changes provided
         * fails. All operations executed before the failing operation stay executed.
         */
        Abort,
        /**
         * All operations are executed transactional. That means they either all
         * succeed or no changes at all are applied to the workspace.
         */
        Transactional,
        /**
         * If the workspace edit contains only textual file changes they are executed transactional.
         * If resource changes (create, rename or delete file) are part of the change the failure
         * handling strategy is abort.
         */
        TextOnlyTransactional,
        /**
         * The client tries to undo the operations already executed. But there is no
         * guarantee that this is succeeding.
         */
        Undo,
    }; // enum class FailureHandlingKind

    extern const std::map<FailureHandlingKind, std::string>
        FailureHandlingKindNames;

    extern const std::map<FailureHandlingKind, std::string>
        FailureHandlingKindValues;

    auto failureHandlingKindByName(
        const std::string &name
    ) -> FailureHandlingKind;

    auto failureHandlingKindByValue(
        const std::string &value
    ) -> FailureHandlingKind;

    auto isFailureHandlingKind(const std::string &value) -> bool;

    enum class PrepareSupportDefaultBehavior {
        /**
         * The client's default behavior is to select the identifier
         * according the to language's syntax rule.
         */
        Identifier = 1,
    }; // enum class PrepareSupportDefaultBehavior

    extern const std::map<PrepareSupportDefaultBehavior, std::string>
        PrepareSupportDefaultBehaviorNames;

    auto prepareSupportDefaultBehaviorByName(
        const std::string &name
    ) -> PrepareSupportDefaultBehavior;

    auto prepareSupportDefaultBehaviorByValue(
        unsigned int value
    ) -> PrepareSupportDefaultBehavior;

    enum class TokenFormat {
        Relative,
    }; // enum class TokenFormat

    extern const std::map<TokenFormat, std::string> TokenFormatNames;

    extern const std::map<TokenFormat, std::string> TokenFormatValues;

    auto tokenFormatByName(const std::string &name) -> TokenFormat;

    auto tokenFormatByValue(const std::string &value) -> TokenFormat;

    auto isTokenFormat(const std::string &value) -> bool;

    typedef std::vector<TokenFormat> SemanticTokensClientCapabilities_formats;

    typedef std::string DocumentUri;

    struct WorkspaceSymbol_location_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceSymbol_location_1();
        WorkspaceSymbol_location_1(WorkspaceSymbol_location_1 &&other);
        WorkspaceSymbol_location_1(const WorkspaceSymbol_location_1 &other);
        ~WorkspaceSymbol_location_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceSymbol_location_1 &&other
        ) -> WorkspaceSymbol_location_1 &;

        auto operator=(
            const WorkspaceSymbol_location_1 &other
        ) -> WorkspaceSymbol_location_1 &;

        // ================== //
        // Field Declarations //
        // ================== //

        DocumentUri uri;
    }; // struct WorkspaceSymbol_location_1

    /**
     * A literal to identify a text document in the client.
     */
    struct TextDocumentIdentifier {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentIdentifier();
        TextDocumentIdentifier(TextDocumentIdentifier &&other);
        TextDocumentIdentifier(const TextDocumentIdentifier &other);
        ~TextDocumentIdentifier();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentIdentifier &&other
        ) -> TextDocumentIdentifier &;

        auto operator=(
            const TextDocumentIdentifier &other
        ) -> TextDocumentIdentifier &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The text document's uri.
         */
        DocumentUri uri;
    }; // struct TextDocumentIdentifier

    typedef std::vector<TextDocumentIdentifier> DidCloseNotebookDocumentParams_cellTextDocuments;

    /**
     * The parameters sent in a close text document notification
     */
    struct DidCloseTextDocumentParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidCloseTextDocumentParams();
        DidCloseTextDocumentParams(DidCloseTextDocumentParams &&other);
        DidCloseTextDocumentParams(const DidCloseTextDocumentParams &other);
        ~DidCloseTextDocumentParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidCloseTextDocumentParams &&other
        ) -> DidCloseTextDocumentParams &;

        auto operator=(
            const DidCloseTextDocumentParams &other
        ) -> DidCloseTextDocumentParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The document that was closed.
         */
        TextDocumentIdentifier textDocument;
    }; // struct DidCloseTextDocumentParams

    /**
     * The parameters sent in a will save text document notification.
     */
    struct WillSaveTextDocumentParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WillSaveTextDocumentParams();
        WillSaveTextDocumentParams(WillSaveTextDocumentParams &&other);
        WillSaveTextDocumentParams(const WillSaveTextDocumentParams &other);
        ~WillSaveTextDocumentParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WillSaveTextDocumentParams &&other
        ) -> WillSaveTextDocumentParams &;

        auto operator=(
            const WillSaveTextDocumentParams &other
        ) -> WillSaveTextDocumentParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The document that will be saved.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The 'TextDocumentSaveReason'.
         */
        TextDocumentSaveReason reason;
    }; // struct WillSaveTextDocumentParams

    typedef std::vector<TextDocumentIdentifier> NotebookDocumentChangeEvent_cells_structure_didClose;

    /**
     * An event describing a file change.
     */
    struct FileEvent {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FileEvent();
        FileEvent(FileEvent &&other);
        FileEvent(const FileEvent &other);
        ~FileEvent();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FileEvent &&other) -> FileEvent &;

        auto operator=(const FileEvent &other) -> FileEvent &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The file's uri.
         */
        DocumentUri uri;
        /**
         * The change type.
         */
        FileChangeType type;
    }; // struct FileEvent

    /**
     * The watched files change notification's parameters.
     */
    struct DidChangeWatchedFilesParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidChangeWatchedFilesParams();
        DidChangeWatchedFilesParams(DidChangeWatchedFilesParams &&other);
        DidChangeWatchedFilesParams(const DidChangeWatchedFilesParams &other);
        ~DidChangeWatchedFilesParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidChangeWatchedFilesParams &&other
        ) -> DidChangeWatchedFilesParams &;

        auto operator=(
            const DidChangeWatchedFilesParams &other
        ) -> DidChangeWatchedFilesParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The actual file events.
         */
        std::vector<FileEvent> changes;
    }; // struct DidChangeWatchedFilesParams

    typedef std::vector<FileEvent> DidChangeWatchedFilesParams_changes;

    typedef std::string URI;

    /**
     * A literal to identify a notebook document in the client.
     *
     * @since 3.17.0
     */
    struct NotebookDocumentIdentifier {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentIdentifier();
        NotebookDocumentIdentifier(NotebookDocumentIdentifier &&other);
        NotebookDocumentIdentifier(const NotebookDocumentIdentifier &other);
        ~NotebookDocumentIdentifier();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentIdentifier &&other
        ) -> NotebookDocumentIdentifier &;

        auto operator=(
            const NotebookDocumentIdentifier &other
        ) -> NotebookDocumentIdentifier &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The notebook document's uri.
         */
        URI uri;
    }; // struct NotebookDocumentIdentifier

    /**
     * The params sent in a save notebook document notification.
     *
     * @since 3.17.0
     */
    struct DidSaveNotebookDocumentParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidSaveNotebookDocumentParams();
        DidSaveNotebookDocumentParams(DidSaveNotebookDocumentParams &&other);
        DidSaveNotebookDocumentParams(
            const DidSaveNotebookDocumentParams &other
        );
        ~DidSaveNotebookDocumentParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidSaveNotebookDocumentParams &&other
        ) -> DidSaveNotebookDocumentParams &;

        auto operator=(
            const DidSaveNotebookDocumentParams &other
        ) -> DidSaveNotebookDocumentParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The notebook document that got saved.
         */
        NotebookDocumentIdentifier notebookDocument;
    }; // struct DidSaveNotebookDocumentParams

    /**
     * The params sent in a close notebook document notification.
     *
     * @since 3.17.0
     */
    struct DidCloseNotebookDocumentParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidCloseNotebookDocumentParams();
        DidCloseNotebookDocumentParams(DidCloseNotebookDocumentParams &&other);
        DidCloseNotebookDocumentParams(
            const DidCloseNotebookDocumentParams &other
        );
        ~DidCloseNotebookDocumentParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidCloseNotebookDocumentParams &&other
        ) -> DidCloseNotebookDocumentParams &;

        auto operator=(
            const DidCloseNotebookDocumentParams &other
        ) -> DidCloseNotebookDocumentParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The notebook document that got closed.
         */
        NotebookDocumentIdentifier notebookDocument;
        /**
         * The text documents that represent the content
         * of a notebook cell that got closed.
         */
        std::vector<TextDocumentIdentifier> cellTextDocuments;
    }; // struct DidCloseNotebookDocumentParams

    /**
     * Structure to capture a description for an error code.
     *
     * @since 3.16.0
     */
    struct CodeDescription {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeDescription();
        CodeDescription(CodeDescription &&other);
        CodeDescription(const CodeDescription &other);
        ~CodeDescription();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CodeDescription &&other) -> CodeDescription &;

        auto operator=(const CodeDescription &other) -> CodeDescription &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An URI to open with more information about the diagnostic error.
         */
        URI href;
    }; // struct CodeDescription

    typedef std::string string_t;

    /**
     * A workspace folder inside a client.
     */
    struct WorkspaceFolder {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceFolder();
        WorkspaceFolder(WorkspaceFolder &&other);
        WorkspaceFolder(const WorkspaceFolder &other);
        ~WorkspaceFolder();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(WorkspaceFolder &&other) -> WorkspaceFolder &;

        auto operator=(const WorkspaceFolder &other) -> WorkspaceFolder &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The associated URI for this workspace folder.
         */
        URI uri;
        /**
         * The name of the workspace folder. Used to refer to this
         * workspace folder in the user interface.
         */
        string_t name;
    }; // struct WorkspaceFolder

    /**
     * Moniker definition to match LSIF 0.5 moniker definition.
     *
     * @since 3.16.0
     */
    struct Moniker {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Moniker();
        Moniker(Moniker &&other);
        Moniker(const Moniker &other);
        ~Moniker();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Moniker &&other) -> Moniker &;

        auto operator=(const Moniker &other) -> Moniker &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The scheme of the moniker. For example tsc or .Net
         */
        string_t scheme;
        /**
         * The identifier of the moniker. The value is opaque in LSIF however
         * schema owners are allowed to define the structure if they want.
         */
        string_t identifier;
        /**
         * The scope in which the moniker is unique
         */
        UniquenessLevel unique;
        /**
         * The moniker kind if known.
         */
        std::optional<MonikerKind> kind;
    }; // struct Moniker

    struct InitializeResult_serverInfo {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InitializeResult_serverInfo();
        InitializeResult_serverInfo(InitializeResult_serverInfo &&other);
        InitializeResult_serverInfo(const InitializeResult_serverInfo &other);
        ~InitializeResult_serverInfo();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InitializeResult_serverInfo &&other
        ) -> InitializeResult_serverInfo &;

        auto operator=(
            const InitializeResult_serverInfo &other
        ) -> InitializeResult_serverInfo &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The name of the server as defined by the server.
         */
        string_t name;
        /**
         * The server's version as defined by the server.
         */
        std::optional<string_t> version;
    }; // struct InitializeResult_serverInfo

    enum class DidChangeConfigurationRegistrationOptions_sectionType {
        Uninitialized = -1,
        String = 0,
        StringArray = 1,
    }; // enum class DidChangeConfigurationRegistrationOptions_sectionType

    extern const std::map<
        DidChangeConfigurationRegistrationOptions_sectionType,
        std::string
    > DidChangeConfigurationRegistrationOptions_sectionTypeNames;

    class DidChangeConfigurationRegistrationOptions_section {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidChangeConfigurationRegistrationOptions_section();
        DidChangeConfigurationRegistrationOptions_section(
            DidChangeConfigurationRegistrationOptions_section &&other
        );
        DidChangeConfigurationRegistrationOptions_section(
            const DidChangeConfigurationRegistrationOptions_section &other
        );
        ~DidChangeConfigurationRegistrationOptions_section();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidChangeConfigurationRegistrationOptions_section &&other
        ) -> DidChangeConfigurationRegistrationOptions_section &;

        auto operator=(
            const DidChangeConfigurationRegistrationOptions_section &other
        ) -> DidChangeConfigurationRegistrationOptions_section &;

        auto type() const
        -> const DidChangeConfigurationRegistrationOptions_sectionType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> DidChangeConfigurationRegistrationOptions_section &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> DidChangeConfigurationRegistrationOptions_section &;

        auto operator=(
            const string_t &string
        ) -> DidChangeConfigurationRegistrationOptions_section &;

        auto operator=(
            string_t &&string
        ) -> DidChangeConfigurationRegistrationOptions_section &;

        auto stringArray() const -> const std::vector<string_t> &;

        auto operator=(
            const std::unique_ptr<std::vector<string_t>> &stringArray
        ) -> DidChangeConfigurationRegistrationOptions_section &;

        auto operator=(
            std::unique_ptr<std::vector<string_t>> &&stringArray
        ) -> DidChangeConfigurationRegistrationOptions_section &;

        auto operator=(
            const std::vector<string_t> &stringArray
        ) -> DidChangeConfigurationRegistrationOptions_section &;

        auto operator=(
            std::vector<string_t> &&stringArray
        ) -> DidChangeConfigurationRegistrationOptions_section &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        DidChangeConfigurationRegistrationOptions_sectionType _type{
            DidChangeConfigurationRegistrationOptions_sectionType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<std::vector<string_t>> _stringArray;
        };

        auto reset() -> void;
    }; // class DidChangeConfigurationRegistrationOptions_section

    struct DidChangeConfigurationRegistrationOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidChangeConfigurationRegistrationOptions();
        DidChangeConfigurationRegistrationOptions(
            DidChangeConfigurationRegistrationOptions &&other
        );
        DidChangeConfigurationRegistrationOptions(
            const DidChangeConfigurationRegistrationOptions &other
        );
        ~DidChangeConfigurationRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidChangeConfigurationRegistrationOptions &&other
        ) -> DidChangeConfigurationRegistrationOptions &;

        auto operator=(
            const DidChangeConfigurationRegistrationOptions &other
        ) -> DidChangeConfigurationRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<DidChangeConfigurationRegistrationOptions_section>
            section;
    }; // struct DidChangeConfigurationRegistrationOptions

    typedef std::vector<string_t> DidChangeConfigurationRegistrationOptions_section_1;

    /**
     * The parameters of a notification message.
     */
    struct ShowMessageParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ShowMessageParams();
        ShowMessageParams(ShowMessageParams &&other);
        ShowMessageParams(const ShowMessageParams &other);
        ~ShowMessageParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ShowMessageParams &&other) -> ShowMessageParams &;

        auto operator=(const ShowMessageParams &other) -> ShowMessageParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The message type. See {@link MessageType}
         */
        MessageType type;
        /**
         * The actual message.
         */
        string_t message;
    }; // struct ShowMessageParams

    struct MessageActionItem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        MessageActionItem();
        MessageActionItem(MessageActionItem &&other);
        MessageActionItem(const MessageActionItem &other);
        ~MessageActionItem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(MessageActionItem &&other) -> MessageActionItem &;

        auto operator=(const MessageActionItem &other) -> MessageActionItem &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A short title like 'Retry', 'Open Log' etc.
         */
        string_t title;
    }; // struct MessageActionItem

    struct ShowMessageRequestParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ShowMessageRequestParams();
        ShowMessageRequestParams(ShowMessageRequestParams &&other);
        ShowMessageRequestParams(const ShowMessageRequestParams &other);
        ~ShowMessageRequestParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ShowMessageRequestParams &&other
        ) -> ShowMessageRequestParams &;

        auto operator=(
            const ShowMessageRequestParams &other
        ) -> ShowMessageRequestParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The message type. See {@link MessageType}
         */
        MessageType type;
        /**
         * The actual message.
         */
        string_t message;
        /**
         * The message action items to present.
         */
        std::optional<std::vector<MessageActionItem>> actions;
    }; // struct ShowMessageRequestParams

    typedef std::vector<MessageActionItem> ShowMessageRequestParams_actions;

    /**
     * The log message parameters.
     */
    struct LogMessageParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        LogMessageParams();
        LogMessageParams(LogMessageParams &&other);
        LogMessageParams(const LogMessageParams &other);
        ~LogMessageParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(LogMessageParams &&other) -> LogMessageParams &;

        auto operator=(const LogMessageParams &other) -> LogMessageParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The message type. See {@link MessageType}
         */
        MessageType type;
        /**
         * The actual message.
         */
        string_t message;
    }; // struct LogMessageParams

    /**
     * The parameters sent in a save text document notification
     */
    struct DidSaveTextDocumentParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidSaveTextDocumentParams();
        DidSaveTextDocumentParams(DidSaveTextDocumentParams &&other);
        DidSaveTextDocumentParams(const DidSaveTextDocumentParams &other);
        ~DidSaveTextDocumentParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidSaveTextDocumentParams &&other
        ) -> DidSaveTextDocumentParams &;

        auto operator=(
            const DidSaveTextDocumentParams &other
        ) -> DidSaveTextDocumentParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The document that was saved.
         */
        TextDocumentIdentifier textDocument;
        /**
         * Optional the content when saved. Depends on the includeText value
         * when the save notification was requested.
         */
        std::optional<string_t> text;
    }; // struct DidSaveTextDocumentParams

    typedef std::vector<string_t> CompletionItem_commitCharacters;

    typedef std::vector<string_t> CompletionList_itemDefaults_commitCharacters;

    struct CodeAction_disabled {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeAction_disabled();
        CodeAction_disabled(CodeAction_disabled &&other);
        CodeAction_disabled(const CodeAction_disabled &other);
        ~CodeAction_disabled();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CodeAction_disabled &&other) -> CodeAction_disabled &;

        auto operator=(
            const CodeAction_disabled &other
        ) -> CodeAction_disabled &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Human readable description of why the code action is currently disabled.
         *
         * This is displayed in the code actions UI.
         */
        string_t reason;
    }; // struct CodeAction_disabled

    struct WorkDoneProgressEnd {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkDoneProgressEnd();
        WorkDoneProgressEnd(WorkDoneProgressEnd &&other);
        WorkDoneProgressEnd(const WorkDoneProgressEnd &other);
        ~WorkDoneProgressEnd();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(WorkDoneProgressEnd &&other) -> WorkDoneProgressEnd &;

        auto operator=(
            const WorkDoneProgressEnd &other
        ) -> WorkDoneProgressEnd &;

        // ================== //
        // Field Declarations //
        // ================== //

        string_t kind;
        /**
         * Optional, a final message indicating to for example indicate the outcome
         * of the operation.
         */
        std::optional<string_t> message;
    }; // struct WorkDoneProgressEnd

    struct LogTraceParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        LogTraceParams();
        LogTraceParams(LogTraceParams &&other);
        LogTraceParams(const LogTraceParams &other);
        ~LogTraceParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(LogTraceParams &&other) -> LogTraceParams &;

        auto operator=(const LogTraceParams &other) -> LogTraceParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        string_t message;
        std::optional<string_t> verbose;
    }; // struct LogTraceParams

    /**
     * Static registration options to be returned in the initialize
     * request.
     */
    struct StaticRegistrationOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        StaticRegistrationOptions();
        StaticRegistrationOptions(StaticRegistrationOptions &&other);
        StaticRegistrationOptions(const StaticRegistrationOptions &other);
        ~StaticRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            StaticRegistrationOptions &&other
        ) -> StaticRegistrationOptions &;

        auto operator=(
            const StaticRegistrationOptions &other
        ) -> StaticRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct StaticRegistrationOptions

    /**
     * The workspace folder change event.
     */
    struct WorkspaceFoldersChangeEvent {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceFoldersChangeEvent();
        WorkspaceFoldersChangeEvent(WorkspaceFoldersChangeEvent &&other);
        WorkspaceFoldersChangeEvent(const WorkspaceFoldersChangeEvent &other);
        ~WorkspaceFoldersChangeEvent();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceFoldersChangeEvent &&other
        ) -> WorkspaceFoldersChangeEvent &;

        auto operator=(
            const WorkspaceFoldersChangeEvent &other
        ) -> WorkspaceFoldersChangeEvent &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The array of added workspace folders
         */
        std::vector<WorkspaceFolder> added;
        /**
         * The array of the removed workspace folders
         */
        std::vector<WorkspaceFolder> removed;
    }; // struct WorkspaceFoldersChangeEvent

    /**
     * The parameters of a `workspace/didChangeWorkspaceFolders` notification.
     */
    struct DidChangeWorkspaceFoldersParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidChangeWorkspaceFoldersParams();
        DidChangeWorkspaceFoldersParams(
            DidChangeWorkspaceFoldersParams &&other
        );
        DidChangeWorkspaceFoldersParams(
            const DidChangeWorkspaceFoldersParams &other
        );
        ~DidChangeWorkspaceFoldersParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidChangeWorkspaceFoldersParams &&other
        ) -> DidChangeWorkspaceFoldersParams &;

        auto operator=(
            const DidChangeWorkspaceFoldersParams &other
        ) -> DidChangeWorkspaceFoldersParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The actual workspace folder change event.
         */
        WorkspaceFoldersChangeEvent event;
    }; // struct DidChangeWorkspaceFoldersParams

    typedef std::vector<WorkspaceFolder> WorkspaceFoldersChangeEvent_added;

    typedef std::vector<WorkspaceFolder> WorkspaceFoldersChangeEvent_removed;

    struct ConfigurationItem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ConfigurationItem();
        ConfigurationItem(ConfigurationItem &&other);
        ConfigurationItem(const ConfigurationItem &other);
        ~ConfigurationItem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ConfigurationItem &&other) -> ConfigurationItem &;

        auto operator=(const ConfigurationItem &other) -> ConfigurationItem &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The scope to get the configuration section for.
         */
        std::optional<URI> scopeUri;
        /**
         * The configuration section asked for.
         */
        std::optional<string_t> section;
    }; // struct ConfigurationItem

    /**
     * The parameters of a configuration request.
     */
    struct ConfigurationParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ConfigurationParams();
        ConfigurationParams(ConfigurationParams &&other);
        ConfigurationParams(const ConfigurationParams &other);
        ~ConfigurationParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ConfigurationParams &&other) -> ConfigurationParams &;

        auto operator=(
            const ConfigurationParams &other
        ) -> ConfigurationParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::vector<ConfigurationItem> items;
    }; // struct ConfigurationParams

    typedef std::vector<ConfigurationItem> ConfigurationParams_items;

    /**
     * Represents information on a file/folder create.
     *
     * @since 3.16.0
     */
    struct FileCreate {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FileCreate();
        FileCreate(FileCreate &&other);
        FileCreate(const FileCreate &other);
        ~FileCreate();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FileCreate &&other) -> FileCreate &;

        auto operator=(const FileCreate &other) -> FileCreate &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A file:// URI for the location of the file/folder being created.
         */
        string_t uri;
    }; // struct FileCreate

    /**
     * The parameters sent in notifications/requests for user-initiated creation of
     * files.
     *
     * @since 3.16.0
     */
    struct CreateFilesParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CreateFilesParams();
        CreateFilesParams(CreateFilesParams &&other);
        CreateFilesParams(const CreateFilesParams &other);
        ~CreateFilesParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CreateFilesParams &&other) -> CreateFilesParams &;

        auto operator=(const CreateFilesParams &other) -> CreateFilesParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An array of all files/folders created in this operation.
         */
        std::vector<FileCreate> files;
    }; // struct CreateFilesParams

    typedef std::vector<FileCreate> CreateFilesParams_files;

    /**
     * Represents information on a file/folder rename.
     *
     * @since 3.16.0
     */
    struct FileRename {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FileRename();
        FileRename(FileRename &&other);
        FileRename(const FileRename &other);
        ~FileRename();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FileRename &&other) -> FileRename &;

        auto operator=(const FileRename &other) -> FileRename &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A file:// URI for the original location of the file/folder being renamed.
         */
        string_t oldUri;
        /**
         * A file:// URI for the new location of the file/folder being renamed.
         */
        string_t newUri;
    }; // struct FileRename

    /**
     * The parameters sent in notifications/requests for user-initiated renames of
     * files.
     *
     * @since 3.16.0
     */
    struct RenameFilesParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RenameFilesParams();
        RenameFilesParams(RenameFilesParams &&other);
        RenameFilesParams(const RenameFilesParams &other);
        ~RenameFilesParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(RenameFilesParams &&other) -> RenameFilesParams &;

        auto operator=(const RenameFilesParams &other) -> RenameFilesParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An array of all files/folders renamed in this operation. When a folder is renamed, only
         * the folder will be included, and not its children.
         */
        std::vector<FileRename> files;
    }; // struct RenameFilesParams

    typedef std::vector<FileRename> RenameFilesParams_files;

    /**
     * Represents information on a file/folder delete.
     *
     * @since 3.16.0
     */
    struct FileDelete {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FileDelete();
        FileDelete(FileDelete &&other);
        FileDelete(const FileDelete &other);
        ~FileDelete();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FileDelete &&other) -> FileDelete &;

        auto operator=(const FileDelete &other) -> FileDelete &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A file:// URI for the location of the file/folder being deleted.
         */
        string_t uri;
    }; // struct FileDelete

    /**
     * The parameters sent in notifications/requests for user-initiated deletes of
     * files.
     *
     * @since 3.16.0
     */
    struct DeleteFilesParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DeleteFilesParams();
        DeleteFilesParams(DeleteFilesParams &&other);
        DeleteFilesParams(const DeleteFilesParams &other);
        ~DeleteFilesParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DeleteFilesParams &&other) -> DeleteFilesParams &;

        auto operator=(const DeleteFilesParams &other) -> DeleteFilesParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An array of all files/folders deleted in this operation.
         */
        std::vector<FileDelete> files;
    }; // struct DeleteFilesParams

    typedef std::vector<FileDelete> DeleteFilesParams_files;

    /**
     * A `MarkupContent` literal represents a string value which content is interpreted base on its
     * kind flag. Currently the protocol supports `plaintext` and `markdown` as markup kinds.
     *
     * If the kind is `markdown` then the value can contain fenced code blocks like in GitHub issues.
     * See https://help.github.com/articles/creating-and-highlighting-code-blocks/#syntax-highlighting
     *
     * Here is an example how such a string can be constructed using JavaScript / TypeScript:
     * ```ts
     * let markdown: MarkdownContent = {
     *  kind: MarkupKind.Markdown,
     *  value: [
     *    '# Header',
     *    'Some text',
     *    '```typescript',
     *    'someCode();',
     *    '```'
     *  ].join('\n')
     * };
     * ```
     *
     * *Please Note* that clients might sanitize the return markdown. A client could decide to
     * remove HTML from the markdown to avoid script execution.
     */
    struct MarkupContent {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        MarkupContent();
        MarkupContent(MarkupContent &&other);
        MarkupContent(const MarkupContent &other);
        ~MarkupContent();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(MarkupContent &&other) -> MarkupContent &;

        auto operator=(const MarkupContent &other) -> MarkupContent &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The type of the Markup
         */
        MarkupKind kind;
        /**
         * The content itself
         */
        string_t value;
    }; // struct MarkupContent

    enum class InlayHint_tooltipType {
        Uninitialized = -1,
        String = 0,
        MarkupContent = 1,
    }; // enum class InlayHint_tooltipType

    extern const std::map<InlayHint_tooltipType, std::string>
        InlayHint_tooltipTypeNames;

    class InlayHint_tooltip {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlayHint_tooltip();
        InlayHint_tooltip(InlayHint_tooltip &&other);
        InlayHint_tooltip(const InlayHint_tooltip &other);
        ~InlayHint_tooltip();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlayHint_tooltip &&other) -> InlayHint_tooltip &;

        auto operator=(const InlayHint_tooltip &other) -> InlayHint_tooltip &;

        auto type() const -> const InlayHint_tooltipType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> InlayHint_tooltip &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> InlayHint_tooltip &;

        auto operator=(const string_t &string) -> InlayHint_tooltip &;

        auto operator=(string_t &&string) -> InlayHint_tooltip &;

        auto markupContent() const -> const MarkupContent &;

        auto operator=(
            const std::unique_ptr<MarkupContent> &markupContent
        ) -> InlayHint_tooltip &;

        auto operator=(
            std::unique_ptr<MarkupContent> &&markupContent
        ) -> InlayHint_tooltip &;

        auto operator=(
            const MarkupContent &markupContent
        ) -> InlayHint_tooltip &;

        auto operator=(MarkupContent &&markupContent) -> InlayHint_tooltip &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        InlayHint_tooltipType _type{InlayHint_tooltipType::Uninitialized};

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<MarkupContent> _markupContent;
        };

        auto reset() -> void;
    }; // class InlayHint_tooltip

    enum class CompletionItem_documentationType {
        Uninitialized = -1,
        String = 0,
        MarkupContent = 1,
    }; // enum class CompletionItem_documentationType

    extern const std::map<CompletionItem_documentationType, std::string>
        CompletionItem_documentationTypeNames;

    class CompletionItem_documentation {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionItem_documentation();
        CompletionItem_documentation(CompletionItem_documentation &&other);
        CompletionItem_documentation(
            const CompletionItem_documentation &other
        );
        ~CompletionItem_documentation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionItem_documentation &&other
        ) -> CompletionItem_documentation &;

        auto operator=(
            const CompletionItem_documentation &other
        ) -> CompletionItem_documentation &;

        auto type() const -> const CompletionItem_documentationType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> CompletionItem_documentation &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> CompletionItem_documentation &;

        auto operator=(
            const string_t &string
        ) -> CompletionItem_documentation &;

        auto operator=(string_t &&string) -> CompletionItem_documentation &;

        auto markupContent() const -> const MarkupContent &;

        auto operator=(
            const std::unique_ptr<MarkupContent> &markupContent
        ) -> CompletionItem_documentation &;

        auto operator=(
            std::unique_ptr<MarkupContent> &&markupContent
        ) -> CompletionItem_documentation &;

        auto operator=(
            const MarkupContent &markupContent
        ) -> CompletionItem_documentation &;

        auto operator=(
            MarkupContent &&markupContent
        ) -> CompletionItem_documentation &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        CompletionItem_documentationType _type{
            CompletionItem_documentationType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<MarkupContent> _markupContent;
        };

        auto reset() -> void;
    }; // class CompletionItem_documentation

    enum class InlayHintLabelPart_tooltipType {
        Uninitialized = -1,
        String = 0,
        MarkupContent = 1,
    }; // enum class InlayHintLabelPart_tooltipType

    extern const std::map<InlayHintLabelPart_tooltipType, std::string>
        InlayHintLabelPart_tooltipTypeNames;

    class InlayHintLabelPart_tooltip {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlayHintLabelPart_tooltip();
        InlayHintLabelPart_tooltip(InlayHintLabelPart_tooltip &&other);
        InlayHintLabelPart_tooltip(const InlayHintLabelPart_tooltip &other);
        ~InlayHintLabelPart_tooltip();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlayHintLabelPart_tooltip &&other
        ) -> InlayHintLabelPart_tooltip &;

        auto operator=(
            const InlayHintLabelPart_tooltip &other
        ) -> InlayHintLabelPart_tooltip &;

        auto type() const -> const InlayHintLabelPart_tooltipType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> InlayHintLabelPart_tooltip &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> InlayHintLabelPart_tooltip &;

        auto operator=(const string_t &string) -> InlayHintLabelPart_tooltip &;

        auto operator=(string_t &&string) -> InlayHintLabelPart_tooltip &;

        auto markupContent() const -> const MarkupContent &;

        auto operator=(
            const std::unique_ptr<MarkupContent> &markupContent
        ) -> InlayHintLabelPart_tooltip &;

        auto operator=(
            std::unique_ptr<MarkupContent> &&markupContent
        ) -> InlayHintLabelPart_tooltip &;

        auto operator=(
            const MarkupContent &markupContent
        ) -> InlayHintLabelPart_tooltip &;

        auto operator=(
            MarkupContent &&markupContent
        ) -> InlayHintLabelPart_tooltip &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        InlayHintLabelPart_tooltipType _type{
            InlayHintLabelPart_tooltipType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<MarkupContent> _markupContent;
        };

        auto reset() -> void;
    }; // class InlayHintLabelPart_tooltip

    /**
     * A diagnostic report indicating that the last returned
     * report is still accurate.
     *
     * @since 3.17.0
     */
    struct UnchangedDocumentDiagnosticReport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        UnchangedDocumentDiagnosticReport();
        UnchangedDocumentDiagnosticReport(
            UnchangedDocumentDiagnosticReport &&other
        );
        UnchangedDocumentDiagnosticReport(
            const UnchangedDocumentDiagnosticReport &other
        );
        ~UnchangedDocumentDiagnosticReport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            UnchangedDocumentDiagnosticReport &&other
        ) -> UnchangedDocumentDiagnosticReport &;

        auto operator=(
            const UnchangedDocumentDiagnosticReport &other
        ) -> UnchangedDocumentDiagnosticReport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A document diagnostic report indicating
         * no changes to the last result. A server can
         * only return `unchanged` if result ids are
         * provided.
         */
        string_t kind;
        /**
         * A result id which will be sent on the next
         * diagnostic request for the same document.
         */
        string_t resultId;
    }; // struct UnchangedDocumentDiagnosticReport

    /**
     * A previous result id in a workspace pull request.
     *
     * @since 3.17.0
     */
    struct PreviousResultId {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        PreviousResultId();
        PreviousResultId(PreviousResultId &&other);
        PreviousResultId(const PreviousResultId &other);
        ~PreviousResultId();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(PreviousResultId &&other) -> PreviousResultId &;

        auto operator=(const PreviousResultId &other) -> PreviousResultId &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The URI for which the client knowns a
         * result id.
         */
        DocumentUri uri;
        /**
         * The value of the previous result id.
         */
        string_t value;
    }; // struct PreviousResultId

    typedef std::vector<PreviousResultId> WorkspaceDiagnosticParams_previousResultIds;

    /**
     * A string value used as a snippet is a template which allows to insert text
     * and to control the editor cursor when insertion happens.
     *
     * A snippet can define tab stops and placeholders with `$1`, `$2`
     * and `${3:foo}`. `$0` defines the final tab stop, it defaults to
     * the end of the snippet. Variables are defined with `$name` and
     * `${name:default value}`.
     *
     * @since 3.18.0
     * @proposed
     */
    struct StringValue {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        StringValue();
        StringValue(StringValue &&other);
        StringValue(const StringValue &other);
        ~StringValue();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(StringValue &&other) -> StringValue &;

        auto operator=(const StringValue &other) -> StringValue &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The kind of string value.
         */
        string_t kind;
        /**
         * The snippet string.
         */
        string_t value;
    }; // struct StringValue

    enum class InlineCompletionItem_insertTextType {
        Uninitialized = -1,
        String = 0,
        StringValue = 1,
    }; // enum class InlineCompletionItem_insertTextType

    extern const std::map<InlineCompletionItem_insertTextType, std::string>
        InlineCompletionItem_insertTextTypeNames;

    class InlineCompletionItem_insertText {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineCompletionItem_insertText();
        InlineCompletionItem_insertText(
            InlineCompletionItem_insertText &&other
        );
        InlineCompletionItem_insertText(
            const InlineCompletionItem_insertText &other
        );
        ~InlineCompletionItem_insertText();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlineCompletionItem_insertText &&other
        ) -> InlineCompletionItem_insertText &;

        auto operator=(
            const InlineCompletionItem_insertText &other
        ) -> InlineCompletionItem_insertText &;

        auto type() const -> const InlineCompletionItem_insertTextType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> InlineCompletionItem_insertText &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> InlineCompletionItem_insertText &;

        auto operator=(
            const string_t &string
        ) -> InlineCompletionItem_insertText &;

        auto operator=(string_t &&string) -> InlineCompletionItem_insertText &;

        auto stringValue() const -> const StringValue &;

        auto operator=(
            const std::unique_ptr<StringValue> &stringValue
        ) -> InlineCompletionItem_insertText &;

        auto operator=(
            std::unique_ptr<StringValue> &&stringValue
        ) -> InlineCompletionItem_insertText &;

        auto operator=(
            const StringValue &stringValue
        ) -> InlineCompletionItem_insertText &;

        auto operator=(
            StringValue &&stringValue
        ) -> InlineCompletionItem_insertText &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        InlineCompletionItem_insertTextType _type{
            InlineCompletionItem_insertTextType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<StringValue> _stringValue;
        };

        auto reset() -> void;
    }; // class InlineCompletionItem_insertText

    /**
     * General parameters to unregister a request or notification.
     */
    struct Unregistration {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Unregistration();
        Unregistration(Unregistration &&other);
        Unregistration(const Unregistration &other);
        ~Unregistration();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Unregistration &&other) -> Unregistration &;

        auto operator=(const Unregistration &other) -> Unregistration &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to unregister the request or notification. Usually an id
         * provided during the register request.
         */
        string_t id;
        /**
         * The method to unregister for.
         */
        string_t method;
    }; // struct Unregistration

    struct UnregistrationParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        UnregistrationParams();
        UnregistrationParams(UnregistrationParams &&other);
        UnregistrationParams(const UnregistrationParams &other);
        ~UnregistrationParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(UnregistrationParams &&other) -> UnregistrationParams &;

        auto operator=(
            const UnregistrationParams &other
        ) -> UnregistrationParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::vector<Unregistration> unregisterations;
    }; // struct UnregistrationParams

    typedef std::vector<Unregistration> UnregistrationParams_unregisterations;

    struct _InitializeParams_clientInfo {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        _InitializeParams_clientInfo();
        _InitializeParams_clientInfo(_InitializeParams_clientInfo &&other);
        _InitializeParams_clientInfo(
            const _InitializeParams_clientInfo &other
        );
        ~_InitializeParams_clientInfo();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            _InitializeParams_clientInfo &&other
        ) -> _InitializeParams_clientInfo &;

        auto operator=(
            const _InitializeParams_clientInfo &other
        ) -> _InitializeParams_clientInfo &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The name of the client as defined by the client.
         */
        string_t name;
        /**
         * The client's version as defined by the client.
         */
        std::optional<string_t> version;
    }; // struct _InitializeParams_clientInfo

    typedef std::vector<WorkspaceFolder> WorkspaceFoldersInitializeParams_workspaceFolders_0;

    /**
     * Contains additional information about the context in which a completion request is triggered.
     */
    struct CompletionContext {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionContext();
        CompletionContext(CompletionContext &&other);
        CompletionContext(const CompletionContext &other);
        ~CompletionContext();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CompletionContext &&other) -> CompletionContext &;

        auto operator=(const CompletionContext &other) -> CompletionContext &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * How the completion was triggered.
         */
        CompletionTriggerKind triggerKind;
        /**
         * The trigger character (a single character) that has trigger code complete.
         * Is undefined if `triggerKind !== CompletionTriggerKind.TriggerCharacter`
         */
        std::optional<string_t> triggerCharacter;
    }; // struct CompletionContext

    /**
     * Additional details for a completion item label.
     *
     * @since 3.17.0
     */
    struct CompletionItemLabelDetails {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionItemLabelDetails();
        CompletionItemLabelDetails(CompletionItemLabelDetails &&other);
        CompletionItemLabelDetails(const CompletionItemLabelDetails &other);
        ~CompletionItemLabelDetails();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionItemLabelDetails &&other
        ) -> CompletionItemLabelDetails &;

        auto operator=(
            const CompletionItemLabelDetails &other
        ) -> CompletionItemLabelDetails &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional string which is rendered less prominently directly after {@link CompletionItem.label label},
         * without any spacing. Should be used for function signatures and type annotations.
         */
        std::optional<string_t> detail;
        /**
         * An optional string which is rendered less prominently after {@link CompletionItem.detail}. Should be used
         * for fully qualified names and file paths.
         */
        std::optional<string_t> description;
    }; // struct CompletionItemLabelDetails

    typedef std::vector<string_t> CompletionOptions_triggerCharacters;

    typedef std::vector<string_t> CompletionOptions_allCommitCharacters;

    enum class SignatureInformation_documentationType {
        Uninitialized = -1,
        String = 0,
        MarkupContent = 1,
    }; // enum class SignatureInformation_documentationType

    extern const std::map<SignatureInformation_documentationType, std::string>
        SignatureInformation_documentationTypeNames;

    class SignatureInformation_documentation {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SignatureInformation_documentation();
        SignatureInformation_documentation(
            SignatureInformation_documentation &&other
        );
        SignatureInformation_documentation(
            const SignatureInformation_documentation &other
        );
        ~SignatureInformation_documentation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SignatureInformation_documentation &&other
        ) -> SignatureInformation_documentation &;

        auto operator=(
            const SignatureInformation_documentation &other
        ) -> SignatureInformation_documentation &;

        auto type() const -> const SignatureInformation_documentationType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> SignatureInformation_documentation &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> SignatureInformation_documentation &;

        auto operator=(
            const string_t &string
        ) -> SignatureInformation_documentation &;

        auto operator=(
            string_t &&string
        ) -> SignatureInformation_documentation &;

        auto markupContent() const -> const MarkupContent &;

        auto operator=(
            const std::unique_ptr<MarkupContent> &markupContent
        ) -> SignatureInformation_documentation &;

        auto operator=(
            std::unique_ptr<MarkupContent> &&markupContent
        ) -> SignatureInformation_documentation &;

        auto operator=(
            const MarkupContent &markupContent
        ) -> SignatureInformation_documentation &;

        auto operator=(
            MarkupContent &&markupContent
        ) -> SignatureInformation_documentation &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        SignatureInformation_documentationType _type{
            SignatureInformation_documentationType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<MarkupContent> _markupContent;
        };

        auto reset() -> void;
    }; // class SignatureInformation_documentation

    typedef std::vector<string_t> SignatureHelpOptions_triggerCharacters;

    typedef std::vector<string_t> SignatureHelpOptions_retriggerCharacters;

    /**
     * A base for all symbol information.
     */
    struct BaseSymbolInformation {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        BaseSymbolInformation();
        BaseSymbolInformation(BaseSymbolInformation &&other);
        BaseSymbolInformation(const BaseSymbolInformation &other);
        ~BaseSymbolInformation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            BaseSymbolInformation &&other
        ) -> BaseSymbolInformation &;

        auto operator=(
            const BaseSymbolInformation &other
        ) -> BaseSymbolInformation &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The name of this symbol.
         */
        string_t name;
        /**
         * The kind of this symbol.
         */
        SymbolKind kind;
        /**
         * Tags for this symbol.
         *
         * @since 3.16.0
         */
        std::optional<std::vector<SymbolTag>> tags;
        /**
         * The name of the symbol containing this symbol. This information is for
         * user interface purposes (e.g. to render a qualifier in the user interface
         * if necessary). It can't be used to re-infer a hierarchy for the document
         * symbols.
         */
        std::optional<string_t> containerName;
    }; // struct BaseSymbolInformation

    /**
     * Provider options for a {@link DocumentOnTypeFormattingRequest}.
     */
    struct DocumentOnTypeFormattingOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentOnTypeFormattingOptions();
        DocumentOnTypeFormattingOptions(
            DocumentOnTypeFormattingOptions &&other
        );
        DocumentOnTypeFormattingOptions(
            const DocumentOnTypeFormattingOptions &other
        );
        ~DocumentOnTypeFormattingOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentOnTypeFormattingOptions &&other
        ) -> DocumentOnTypeFormattingOptions &;

        auto operator=(
            const DocumentOnTypeFormattingOptions &other
        ) -> DocumentOnTypeFormattingOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A character on which formatting should be triggered, like `{`.
         */
        string_t firstTriggerCharacter;
        /**
         * More trigger characters.
         */
        std::optional<std::vector<string_t>> moreTriggerCharacter;
    }; // struct DocumentOnTypeFormattingOptions

    typedef std::vector<string_t> DocumentOnTypeFormattingOptions_moreTriggerCharacter;

    typedef std::vector<string_t> ExecuteCommandOptions_commands;

    /**
     * @since 3.16.0
     */
    struct SemanticTokensLegend {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensLegend();
        SemanticTokensLegend(SemanticTokensLegend &&other);
        SemanticTokensLegend(const SemanticTokensLegend &other);
        ~SemanticTokensLegend();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SemanticTokensLegend &&other) -> SemanticTokensLegend &;

        auto operator=(
            const SemanticTokensLegend &other
        ) -> SemanticTokensLegend &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The token types a server uses.
         */
        std::vector<string_t> tokenTypes;
        /**
         * The token modifiers a server uses.
         */
        std::vector<string_t> tokenModifiers;
    }; // struct SemanticTokensLegend

    typedef std::vector<string_t> SemanticTokensLegend_tokenTypes;

    typedef std::vector<string_t> SemanticTokensLegend_tokenModifiers;

    struct NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem();
        NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem(
            NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &&other
        );
        NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem(
            const NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &other
        );
        ~NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &&other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &;

        auto operator=(
            const NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem &;

        // ================== //
        // Field Declarations //
        // ================== //

        string_t language;
    }; // struct NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem

    typedef std::vector<NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem> NotebookDocumentSyncOptions_notebookSelector_elem_0_cells;

    struct NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem();
        NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem(
            NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &&other
        );
        NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem(
            const NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &other
        );
        ~NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &&other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &;

        auto operator=(
            const NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem &;

        // ================== //
        // Field Declarations //
        // ================== //

        string_t language;
    }; // struct NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem

    typedef std::vector<NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem> NotebookDocumentSyncOptions_notebookSelector_elem_1_cells;

    enum class ParameterInformation_documentationType {
        Uninitialized = -1,
        String = 0,
        MarkupContent = 1,
    }; // enum class ParameterInformation_documentationType

    extern const std::map<ParameterInformation_documentationType, std::string>
        ParameterInformation_documentationTypeNames;

    class ParameterInformation_documentation {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ParameterInformation_documentation();
        ParameterInformation_documentation(
            ParameterInformation_documentation &&other
        );
        ParameterInformation_documentation(
            const ParameterInformation_documentation &other
        );
        ~ParameterInformation_documentation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ParameterInformation_documentation &&other
        ) -> ParameterInformation_documentation &;

        auto operator=(
            const ParameterInformation_documentation &other
        ) -> ParameterInformation_documentation &;

        auto type() const -> const ParameterInformation_documentationType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> ParameterInformation_documentation &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> ParameterInformation_documentation &;

        auto operator=(
            const string_t &string
        ) -> ParameterInformation_documentation &;

        auto operator=(
            string_t &&string
        ) -> ParameterInformation_documentation &;

        auto markupContent() const -> const MarkupContent &;

        auto operator=(
            const std::unique_ptr<MarkupContent> &markupContent
        ) -> ParameterInformation_documentation &;

        auto operator=(
            std::unique_ptr<MarkupContent> &&markupContent
        ) -> ParameterInformation_documentation &;

        auto operator=(
            const MarkupContent &markupContent
        ) -> ParameterInformation_documentation &;

        auto operator=(
            MarkupContent &&markupContent
        ) -> ParameterInformation_documentation &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ParameterInformation_documentationType _type{
            ParameterInformation_documentationType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<MarkupContent> _markupContent;
        };

        auto reset() -> void;
    }; // class ParameterInformation_documentation

    typedef std::vector<string_t> GeneralClientCapabilities_staleRequestSupport_retryOnContentModified;

    enum class RelativePattern_baseUriType {
        Uninitialized = -1,
        WorkspaceFolder = 0,
        String = 1,
    }; // enum class RelativePattern_baseUriType

    extern const std::map<RelativePattern_baseUriType, std::string>
        RelativePattern_baseUriTypeNames;

    class RelativePattern_baseUri {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RelativePattern_baseUri();
        RelativePattern_baseUri(RelativePattern_baseUri &&other);
        RelativePattern_baseUri(const RelativePattern_baseUri &other);
        ~RelativePattern_baseUri();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            RelativePattern_baseUri &&other
        ) -> RelativePattern_baseUri &;

        auto operator=(
            const RelativePattern_baseUri &other
        ) -> RelativePattern_baseUri &;

        auto type() const -> const RelativePattern_baseUriType &;

        auto workspaceFolder() const -> const WorkspaceFolder &;

        auto operator=(
            const std::unique_ptr<WorkspaceFolder> &workspaceFolder
        ) -> RelativePattern_baseUri &;

        auto operator=(
            std::unique_ptr<WorkspaceFolder> &&workspaceFolder
        ) -> RelativePattern_baseUri &;

        auto operator=(
            const WorkspaceFolder &workspaceFolder
        ) -> RelativePattern_baseUri &;

        auto operator=(
            WorkspaceFolder &&workspaceFolder
        ) -> RelativePattern_baseUri &;

        auto uri() const -> const URI &;

        auto operator=(
            const std::unique_ptr<URI> &uri
        ) -> RelativePattern_baseUri &;

        auto operator=(
            std::unique_ptr<URI> &&uri
        ) -> RelativePattern_baseUri &;

        auto operator=(const URI &uri) -> RelativePattern_baseUri &;

        auto operator=(URI &&uri) -> RelativePattern_baseUri &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        RelativePattern_baseUriType _type{
            RelativePattern_baseUriType::Uninitialized
        };

        union {
            std::unique_ptr<WorkspaceFolder> _workspaceFolder;
            std::unique_ptr<URI> _uri;
        };

        auto reset() -> void;
    }; // class RelativePattern_baseUri

    struct WorkspaceSymbolClientCapabilities_resolveSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceSymbolClientCapabilities_resolveSupport();
        WorkspaceSymbolClientCapabilities_resolveSupport(
            WorkspaceSymbolClientCapabilities_resolveSupport &&other
        );
        WorkspaceSymbolClientCapabilities_resolveSupport(
            const WorkspaceSymbolClientCapabilities_resolveSupport &other
        );
        ~WorkspaceSymbolClientCapabilities_resolveSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceSymbolClientCapabilities_resolveSupport &&other
        ) -> WorkspaceSymbolClientCapabilities_resolveSupport &;

        auto operator=(
            const WorkspaceSymbolClientCapabilities_resolveSupport &other
        ) -> WorkspaceSymbolClientCapabilities_resolveSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The properties that a client can resolve lazily. Usually
         * `location.range`
         */
        std::vector<string_t> properties;
    }; // struct WorkspaceSymbolClientCapabilities_resolveSupport

    typedef std::vector<string_t> WorkspaceSymbolClientCapabilities_resolveSupport_properties;

    struct CompletionClientCapabilities_completionItem_resolveSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionClientCapabilities_completionItem_resolveSupport();
        CompletionClientCapabilities_completionItem_resolveSupport(
            CompletionClientCapabilities_completionItem_resolveSupport &&other
        );
        CompletionClientCapabilities_completionItem_resolveSupport(
            const CompletionClientCapabilities_completionItem_resolveSupport &other
        );
        ~CompletionClientCapabilities_completionItem_resolveSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionClientCapabilities_completionItem_resolveSupport &&other
        ) -> CompletionClientCapabilities_completionItem_resolveSupport &;

        auto operator=(
            const CompletionClientCapabilities_completionItem_resolveSupport &other
        ) -> CompletionClientCapabilities_completionItem_resolveSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The properties that a client can resolve lazily.
         */
        std::vector<string_t> properties;
    }; // struct CompletionClientCapabilities_completionItem_resolveSupport

    typedef std::vector<string_t> CompletionClientCapabilities_completionItem_resolveSupport_properties;

    struct CompletionClientCapabilities_completionList {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionClientCapabilities_completionList();
        CompletionClientCapabilities_completionList(
            CompletionClientCapabilities_completionList &&other
        );
        CompletionClientCapabilities_completionList(
            const CompletionClientCapabilities_completionList &other
        );
        ~CompletionClientCapabilities_completionList();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionClientCapabilities_completionList &&other
        ) -> CompletionClientCapabilities_completionList &;

        auto operator=(
            const CompletionClientCapabilities_completionList &other
        ) -> CompletionClientCapabilities_completionList &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The client supports the following itemDefaults on
         * a completion list.
         *
         * The value lists the supported property names of the
         * `CompletionList.itemDefaults` object. If omitted
         * no properties are supported.
         *
         * @since 3.17.0
         */
        std::optional<std::vector<string_t>> itemDefaults;
    }; // struct CompletionClientCapabilities_completionList

    typedef std::vector<string_t> CompletionClientCapabilities_completionList_itemDefaults;

    struct CodeActionClientCapabilities_resolveSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeActionClientCapabilities_resolveSupport();
        CodeActionClientCapabilities_resolveSupport(
            CodeActionClientCapabilities_resolveSupport &&other
        );
        CodeActionClientCapabilities_resolveSupport(
            const CodeActionClientCapabilities_resolveSupport &other
        );
        ~CodeActionClientCapabilities_resolveSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CodeActionClientCapabilities_resolveSupport &&other
        ) -> CodeActionClientCapabilities_resolveSupport &;

        auto operator=(
            const CodeActionClientCapabilities_resolveSupport &other
        ) -> CodeActionClientCapabilities_resolveSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The properties that a client can resolve lazily.
         */
        std::vector<string_t> properties;
    }; // struct CodeActionClientCapabilities_resolveSupport

    typedef std::vector<string_t> CodeActionClientCapabilities_resolveSupport_properties;

    typedef std::vector<string_t> SemanticTokensClientCapabilities_tokenTypes;

    typedef std::vector<string_t> SemanticTokensClientCapabilities_tokenModifiers;

    struct InlayHintClientCapabilities_resolveSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlayHintClientCapabilities_resolveSupport();
        InlayHintClientCapabilities_resolveSupport(
            InlayHintClientCapabilities_resolveSupport &&other
        );
        InlayHintClientCapabilities_resolveSupport(
            const InlayHintClientCapabilities_resolveSupport &other
        );
        ~InlayHintClientCapabilities_resolveSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlayHintClientCapabilities_resolveSupport &&other
        ) -> InlayHintClientCapabilities_resolveSupport &;

        auto operator=(
            const InlayHintClientCapabilities_resolveSupport &other
        ) -> InlayHintClientCapabilities_resolveSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The properties that a client can resolve lazily.
         */
        std::vector<string_t> properties;
    }; // struct InlayHintClientCapabilities_resolveSupport

    typedef std::vector<string_t> InlayHintClientCapabilities_resolveSupport_properties;

    /**
     * Client capabilities specific to regular expressions.
     *
     * @since 3.16.0
     */
    struct RegularExpressionsClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RegularExpressionsClientCapabilities();
        RegularExpressionsClientCapabilities(
            RegularExpressionsClientCapabilities &&other
        );
        RegularExpressionsClientCapabilities(
            const RegularExpressionsClientCapabilities &other
        );
        ~RegularExpressionsClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            RegularExpressionsClientCapabilities &&other
        ) -> RegularExpressionsClientCapabilities &;

        auto operator=(
            const RegularExpressionsClientCapabilities &other
        ) -> RegularExpressionsClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The engine's name.
         */
        string_t engine;
        /**
         * The engine's version.
         */
        std::optional<string_t> version;
    }; // struct RegularExpressionsClientCapabilities

    /**
     * Client capabilities specific to the used markdown parser.
     *
     * @since 3.16.0
     */
    struct MarkdownClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        MarkdownClientCapabilities();
        MarkdownClientCapabilities(MarkdownClientCapabilities &&other);
        MarkdownClientCapabilities(const MarkdownClientCapabilities &other);
        ~MarkdownClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            MarkdownClientCapabilities &&other
        ) -> MarkdownClientCapabilities &;

        auto operator=(
            const MarkdownClientCapabilities &other
        ) -> MarkdownClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The name of the parser.
         */
        string_t parser;
        /**
         * The version of the parser.
         */
        std::optional<string_t> version;
        /**
         * A list of HTML tags that the client allows / supports in
         * Markdown.
         *
         * @since 3.17.0
         */
        std::optional<std::vector<string_t>> allowedTags;
    }; // struct MarkdownClientCapabilities

    typedef std::vector<string_t> MarkdownClientCapabilities_allowedTags;

    /**
     * A general message as defined by JSON-RPC. The language server protocol
     * always uses “2.0” as the jsonrpc version.
     */
    struct Message {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Message();
        Message(Message &&other);
        Message(const Message &other);
        ~Message();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Message &&other) -> Message &;

        auto operator=(const Message &other) -> Message &;

        // ================== //
        // Field Declarations //
        // ================== //

        string_t jsonrpc;
    }; // struct Message

    typedef string_t ChangeAnnotationIdentifier;

    /**
     * A generic resource operation.
     */
    struct ResourceOperation {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ResourceOperation();
        ResourceOperation(ResourceOperation &&other);
        ResourceOperation(const ResourceOperation &other);
        ~ResourceOperation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ResourceOperation &&other) -> ResourceOperation &;

        auto operator=(const ResourceOperation &other) -> ResourceOperation &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The resource operation kind.
         */
        string_t kind;
        /**
         * An optional annotation identifier describing the operation.
         *
         * @since 3.16.0
         */
        std::optional<string_t> annotationId;
    }; // struct ResourceOperation

    struct TextDocumentContentChangeEvent_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentContentChangeEvent_1();
        TextDocumentContentChangeEvent_1(
            TextDocumentContentChangeEvent_1 &&other
        );
        TextDocumentContentChangeEvent_1(
            const TextDocumentContentChangeEvent_1 &other
        );
        ~TextDocumentContentChangeEvent_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentContentChangeEvent_1 &&other
        ) -> TextDocumentContentChangeEvent_1 &;

        auto operator=(
            const TextDocumentContentChangeEvent_1 &other
        ) -> TextDocumentContentChangeEvent_1 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The new text of the whole document.
         */
        string_t text;
    }; // struct TextDocumentContentChangeEvent_1

    struct MarkedString_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        MarkedString_1();
        MarkedString_1(MarkedString_1 &&other);
        MarkedString_1(const MarkedString_1 &other);
        ~MarkedString_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(MarkedString_1 &&other) -> MarkedString_1 &;

        auto operator=(const MarkedString_1 &other) -> MarkedString_1 &;

        // ================== //
        // Field Declarations //
        // ================== //

        string_t language;
        string_t value;
    }; // struct MarkedString_1

    enum class MarkedStringType {
        Uninitialized = -1,
        String = 0,
        MarkedString_1 = 1,
    }; // enum class MarkedStringType

    extern const std::map<MarkedStringType, std::string> MarkedStringTypeNames;

    class MarkedString {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        MarkedString();
        MarkedString(MarkedString &&other);
        MarkedString(const MarkedString &other);
        ~MarkedString();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(MarkedString &&other) -> MarkedString &;

        auto operator=(const MarkedString &other) -> MarkedString &;

        auto type() const -> const MarkedStringType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> MarkedString &;

        auto operator=(std::unique_ptr<string_t> &&string) -> MarkedString &;

        auto operator=(const string_t &string) -> MarkedString &;

        auto operator=(string_t &&string) -> MarkedString &;

        auto markedString_1() const -> const MarkedString_1 &;

        auto operator=(
            const std::unique_ptr<MarkedString_1> &markedString_1
        ) -> MarkedString &;

        auto operator=(
            std::unique_ptr<MarkedString_1> &&markedString_1
        ) -> MarkedString &;

        auto operator=(const MarkedString_1 &markedString_1) -> MarkedString &;

        auto operator=(MarkedString_1 &&markedString_1) -> MarkedString &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        MarkedStringType _type{MarkedStringType::Uninitialized};

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<MarkedString_1> _markedString_1;
        };

        auto reset() -> void;
    }; // class MarkedString

    enum class Hover_contentsType {
        Uninitialized = -1,
        MarkupContent = 0,
        MarkedString = 1,
        MarkedStringArray = 2,
    }; // enum class Hover_contentsType

    extern const std::map<Hover_contentsType, std::string>
        Hover_contentsTypeNames;

    class Hover_contents {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Hover_contents();
        Hover_contents(Hover_contents &&other);
        Hover_contents(const Hover_contents &other);
        ~Hover_contents();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Hover_contents &&other) -> Hover_contents &;

        auto operator=(const Hover_contents &other) -> Hover_contents &;

        auto type() const -> const Hover_contentsType &;

        auto markupContent() const -> const MarkupContent &;

        auto operator=(
            const std::unique_ptr<MarkupContent> &markupContent
        ) -> Hover_contents &;

        auto operator=(
            std::unique_ptr<MarkupContent> &&markupContent
        ) -> Hover_contents &;

        auto operator=(const MarkupContent &markupContent) -> Hover_contents &;

        auto operator=(MarkupContent &&markupContent) -> Hover_contents &;

        auto markedString() const -> const MarkedString &;

        auto operator=(
            const std::unique_ptr<MarkedString> &markedString
        ) -> Hover_contents &;

        auto operator=(
            std::unique_ptr<MarkedString> &&markedString
        ) -> Hover_contents &;

        auto operator=(const MarkedString &markedString) -> Hover_contents &;

        auto operator=(MarkedString &&markedString) -> Hover_contents &;

        auto markedStringArray() const -> const std::vector<MarkedString> &;

        auto operator=(
            const std::unique_ptr<std::vector<MarkedString>> &markedStringArray
        ) -> Hover_contents &;

        auto operator=(
            std::unique_ptr<std::vector<MarkedString>> &&markedStringArray
        ) -> Hover_contents &;

        auto operator=(
            const std::vector<MarkedString> &markedStringArray
        ) -> Hover_contents &;

        auto operator=(
            std::vector<MarkedString> &&markedStringArray
        ) -> Hover_contents &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        Hover_contentsType _type{Hover_contentsType::Uninitialized};

        union {
            std::unique_ptr<MarkupContent> _markupContent;
            std::unique_ptr<MarkedString> _markedString;
            std::unique_ptr<std::vector<MarkedString>> _markedStringArray;
        };

        auto reset() -> void;
    }; // class Hover_contents

    typedef std::vector<MarkedString> Hover_contents_2;

    typedef std::map<string_t, std::unique_ptr<LSPAny>> LSPObject;

    struct TextDocumentFilter_0 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentFilter_0();
        TextDocumentFilter_0(TextDocumentFilter_0 &&other);
        TextDocumentFilter_0(const TextDocumentFilter_0 &other);
        ~TextDocumentFilter_0();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(TextDocumentFilter_0 &&other) -> TextDocumentFilter_0 &;

        auto operator=(
            const TextDocumentFilter_0 &other
        ) -> TextDocumentFilter_0 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A language id, like `typescript`.
         */
        string_t language;
        /**
         * A Uri {@link Uri.scheme scheme}, like `file` or `untitled`.
         */
        std::optional<string_t> scheme;
        /**
         * A glob pattern, like **{@literal /}*.{ts,js}. See TextDocumentFilter for examples.
         */
        std::optional<string_t> pattern;
    }; // struct TextDocumentFilter_0

    struct TextDocumentFilter_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentFilter_1();
        TextDocumentFilter_1(TextDocumentFilter_1 &&other);
        TextDocumentFilter_1(const TextDocumentFilter_1 &other);
        ~TextDocumentFilter_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(TextDocumentFilter_1 &&other) -> TextDocumentFilter_1 &;

        auto operator=(
            const TextDocumentFilter_1 &other
        ) -> TextDocumentFilter_1 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A language id, like `typescript`.
         */
        std::optional<string_t> language;
        /**
         * A Uri {@link Uri.scheme scheme}, like `file` or `untitled`.
         */
        string_t scheme;
        /**
         * A glob pattern, like **{@literal /}*.{ts,js}. See TextDocumentFilter for examples.
         */
        std::optional<string_t> pattern;
    }; // struct TextDocumentFilter_1

    struct TextDocumentFilter_2 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentFilter_2();
        TextDocumentFilter_2(TextDocumentFilter_2 &&other);
        TextDocumentFilter_2(const TextDocumentFilter_2 &other);
        ~TextDocumentFilter_2();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(TextDocumentFilter_2 &&other) -> TextDocumentFilter_2 &;

        auto operator=(
            const TextDocumentFilter_2 &other
        ) -> TextDocumentFilter_2 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A language id, like `typescript`.
         */
        std::optional<string_t> language;
        /**
         * A Uri {@link Uri.scheme scheme}, like `file` or `untitled`.
         */
        std::optional<string_t> scheme;
        /**
         * A glob pattern, like **{@literal /}*.{ts,js}. See TextDocumentFilter for examples.
         */
        string_t pattern;
    }; // struct TextDocumentFilter_2

    enum class TextDocumentFilterType {
        Uninitialized = -1,
        TextDocumentFilter_0 = 0,
        TextDocumentFilter_1 = 1,
        TextDocumentFilter_2 = 2,
    }; // enum class TextDocumentFilterType

    extern const std::map<TextDocumentFilterType, std::string>
        TextDocumentFilterTypeNames;

    class TextDocumentFilter {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentFilter();
        TextDocumentFilter(TextDocumentFilter &&other);
        TextDocumentFilter(const TextDocumentFilter &other);
        ~TextDocumentFilter();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(TextDocumentFilter &&other) -> TextDocumentFilter &;

        auto operator=(
            const TextDocumentFilter &other
        ) -> TextDocumentFilter &;

        auto type() const -> const TextDocumentFilterType &;

        auto textDocumentFilter_0() const -> const TextDocumentFilter_0 &;

        auto operator=(
            const std::unique_ptr<TextDocumentFilter_0> &textDocumentFilter_0
        ) -> TextDocumentFilter &;

        auto operator=(
            std::unique_ptr<TextDocumentFilter_0> &&textDocumentFilter_0
        ) -> TextDocumentFilter &;

        auto operator=(
            const TextDocumentFilter_0 &textDocumentFilter_0
        ) -> TextDocumentFilter &;

        auto operator=(
            TextDocumentFilter_0 &&textDocumentFilter_0
        ) -> TextDocumentFilter &;

        auto textDocumentFilter_1() const -> const TextDocumentFilter_1 &;

        auto operator=(
            const std::unique_ptr<TextDocumentFilter_1> &textDocumentFilter_1
        ) -> TextDocumentFilter &;

        auto operator=(
            std::unique_ptr<TextDocumentFilter_1> &&textDocumentFilter_1
        ) -> TextDocumentFilter &;

        auto operator=(
            const TextDocumentFilter_1 &textDocumentFilter_1
        ) -> TextDocumentFilter &;

        auto operator=(
            TextDocumentFilter_1 &&textDocumentFilter_1
        ) -> TextDocumentFilter &;

        auto textDocumentFilter_2() const -> const TextDocumentFilter_2 &;

        auto operator=(
            const std::unique_ptr<TextDocumentFilter_2> &textDocumentFilter_2
        ) -> TextDocumentFilter &;

        auto operator=(
            std::unique_ptr<TextDocumentFilter_2> &&textDocumentFilter_2
        ) -> TextDocumentFilter &;

        auto operator=(
            const TextDocumentFilter_2 &textDocumentFilter_2
        ) -> TextDocumentFilter &;

        auto operator=(
            TextDocumentFilter_2 &&textDocumentFilter_2
        ) -> TextDocumentFilter &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocumentFilterType _type{TextDocumentFilterType::Uninitialized};

        union {
            std::unique_ptr<TextDocumentFilter_0> _textDocumentFilter_0;
            std::unique_ptr<TextDocumentFilter_1> _textDocumentFilter_1;
            std::unique_ptr<TextDocumentFilter_2> _textDocumentFilter_2;
        };

        auto reset() -> void;
    }; // class TextDocumentFilter

    struct NotebookDocumentFilter_0 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentFilter_0();
        NotebookDocumentFilter_0(NotebookDocumentFilter_0 &&other);
        NotebookDocumentFilter_0(const NotebookDocumentFilter_0 &other);
        ~NotebookDocumentFilter_0();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentFilter_0 &&other
        ) -> NotebookDocumentFilter_0 &;

        auto operator=(
            const NotebookDocumentFilter_0 &other
        ) -> NotebookDocumentFilter_0 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The type of the enclosing notebook.
         */
        string_t notebookType;
        /**
         * A Uri {@link Uri.scheme scheme}, like `file` or `untitled`.
         */
        std::optional<string_t> scheme;
        /**
         * A glob pattern.
         */
        std::optional<string_t> pattern;
    }; // struct NotebookDocumentFilter_0

    struct NotebookDocumentFilter_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentFilter_1();
        NotebookDocumentFilter_1(NotebookDocumentFilter_1 &&other);
        NotebookDocumentFilter_1(const NotebookDocumentFilter_1 &other);
        ~NotebookDocumentFilter_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentFilter_1 &&other
        ) -> NotebookDocumentFilter_1 &;

        auto operator=(
            const NotebookDocumentFilter_1 &other
        ) -> NotebookDocumentFilter_1 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The type of the enclosing notebook.
         */
        std::optional<string_t> notebookType;
        /**
         * A Uri {@link Uri.scheme scheme}, like `file` or `untitled`.
         */
        string_t scheme;
        /**
         * A glob pattern.
         */
        std::optional<string_t> pattern;
    }; // struct NotebookDocumentFilter_1

    struct NotebookDocumentFilter_2 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentFilter_2();
        NotebookDocumentFilter_2(NotebookDocumentFilter_2 &&other);
        NotebookDocumentFilter_2(const NotebookDocumentFilter_2 &other);
        ~NotebookDocumentFilter_2();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentFilter_2 &&other
        ) -> NotebookDocumentFilter_2 &;

        auto operator=(
            const NotebookDocumentFilter_2 &other
        ) -> NotebookDocumentFilter_2 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The type of the enclosing notebook.
         */
        std::optional<string_t> notebookType;
        /**
         * A Uri {@link Uri.scheme scheme}, like `file` or `untitled`.
         */
        std::optional<string_t> scheme;
        /**
         * A glob pattern.
         */
        string_t pattern;
    }; // struct NotebookDocumentFilter_2

    enum class NotebookDocumentFilterType {
        Uninitialized = -1,
        NotebookDocumentFilter_0 = 0,
        NotebookDocumentFilter_1 = 1,
        NotebookDocumentFilter_2 = 2,
    }; // enum class NotebookDocumentFilterType

    extern const std::map<NotebookDocumentFilterType, std::string>
        NotebookDocumentFilterTypeNames;

    class NotebookDocumentFilter {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentFilter();
        NotebookDocumentFilter(NotebookDocumentFilter &&other);
        NotebookDocumentFilter(const NotebookDocumentFilter &other);
        ~NotebookDocumentFilter();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentFilter &&other
        ) -> NotebookDocumentFilter &;

        auto operator=(
            const NotebookDocumentFilter &other
        ) -> NotebookDocumentFilter &;

        auto type() const -> const NotebookDocumentFilterType &;

        auto notebookDocumentFilter_0() const
        -> const NotebookDocumentFilter_0 &;

        auto operator=(
            const std::unique_ptr<NotebookDocumentFilter_0> &notebookDocumentFilter_0
        ) -> NotebookDocumentFilter &;

        auto operator=(
            std::unique_ptr<NotebookDocumentFilter_0> &&notebookDocumentFilter_0
        ) -> NotebookDocumentFilter &;

        auto operator=(
            const NotebookDocumentFilter_0 &notebookDocumentFilter_0
        ) -> NotebookDocumentFilter &;

        auto operator=(
            NotebookDocumentFilter_0 &&notebookDocumentFilter_0
        ) -> NotebookDocumentFilter &;

        auto notebookDocumentFilter_1() const
        -> const NotebookDocumentFilter_1 &;

        auto operator=(
            const std::unique_ptr<NotebookDocumentFilter_1> &notebookDocumentFilter_1
        ) -> NotebookDocumentFilter &;

        auto operator=(
            std::unique_ptr<NotebookDocumentFilter_1> &&notebookDocumentFilter_1
        ) -> NotebookDocumentFilter &;

        auto operator=(
            const NotebookDocumentFilter_1 &notebookDocumentFilter_1
        ) -> NotebookDocumentFilter &;

        auto operator=(
            NotebookDocumentFilter_1 &&notebookDocumentFilter_1
        ) -> NotebookDocumentFilter &;

        auto notebookDocumentFilter_2() const
        -> const NotebookDocumentFilter_2 &;

        auto operator=(
            const std::unique_ptr<NotebookDocumentFilter_2> &notebookDocumentFilter_2
        ) -> NotebookDocumentFilter &;

        auto operator=(
            std::unique_ptr<NotebookDocumentFilter_2> &&notebookDocumentFilter_2
        ) -> NotebookDocumentFilter &;

        auto operator=(
            const NotebookDocumentFilter_2 &notebookDocumentFilter_2
        ) -> NotebookDocumentFilter &;

        auto operator=(
            NotebookDocumentFilter_2 &&notebookDocumentFilter_2
        ) -> NotebookDocumentFilter &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        NotebookDocumentFilterType _type{
            NotebookDocumentFilterType::Uninitialized
        };

        union {
            std::unique_ptr<NotebookDocumentFilter_0> _notebookDocumentFilter_0;
            std::unique_ptr<NotebookDocumentFilter_1> _notebookDocumentFilter_1;
            std::unique_ptr<NotebookDocumentFilter_2> _notebookDocumentFilter_2;
        };

        auto reset() -> void;
    }; // class NotebookDocumentFilter

    enum class NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType {
        Uninitialized = -1,
        String = 0,
        NotebookDocumentFilter = 1,
    }; // enum class NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType

    extern const std::map<
        NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType,
        std::string
    > NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookTypeNames;

    class NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook();
        NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook(
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &&other
        );
        NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook(
            const NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &other
        );
        ~NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &&other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &;

        auto operator=(
            const NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &;

        auto type() const
        -> const NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &;

        auto operator=(
            const string_t &string
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &;

        auto operator=(
            string_t &&string
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &;

        auto notebookDocumentFilter() const -> const NotebookDocumentFilter &;

        auto operator=(
            const std::unique_ptr<NotebookDocumentFilter> &notebookDocumentFilter
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &;

        auto operator=(
            std::unique_ptr<NotebookDocumentFilter> &&notebookDocumentFilter
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &;

        auto operator=(
            const NotebookDocumentFilter &notebookDocumentFilter
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &;

        auto operator=(
            NotebookDocumentFilter &&notebookDocumentFilter
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType _type{
            NotebookDocumentSyncOptions_notebookSelector_elem_0_notebookType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<NotebookDocumentFilter> _notebookDocumentFilter;
        };

        auto reset() -> void;
    }; // class NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook

    struct NotebookDocumentSyncOptions_notebookSelector_elem_0 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentSyncOptions_notebookSelector_elem_0();
        NotebookDocumentSyncOptions_notebookSelector_elem_0(
            NotebookDocumentSyncOptions_notebookSelector_elem_0 &&other
        );
        NotebookDocumentSyncOptions_notebookSelector_elem_0(
            const NotebookDocumentSyncOptions_notebookSelector_elem_0 &other
        );
        ~NotebookDocumentSyncOptions_notebookSelector_elem_0();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentSyncOptions_notebookSelector_elem_0 &&other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0 &;

        auto operator=(
            const NotebookDocumentSyncOptions_notebookSelector_elem_0 &other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_0 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The notebook to be synced If a string
         * value is provided it matches against the
         * notebook type. '*' matches every notebook.
         */
        NotebookDocumentSyncOptions_notebookSelector_elem_0_notebook notebook;
        /**
         * The cells of the matching notebook to be synced.
         */
        std::optional<
            std::vector<NotebookDocumentSyncOptions_notebookSelector_elem_0_cells_elem>
        > cells;
    }; // struct NotebookDocumentSyncOptions_notebookSelector_elem_0

    enum class NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType {
        Uninitialized = -1,
        String = 0,
        NotebookDocumentFilter = 1,
    }; // enum class NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType

    extern const std::map<
        NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType,
        std::string
    > NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookTypeNames;

    class NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook();
        NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook(
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &&other
        );
        NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook(
            const NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &other
        );
        ~NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &&other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &;

        auto operator=(
            const NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &;

        auto type() const
        -> const NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &;

        auto operator=(
            const string_t &string
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &;

        auto operator=(
            string_t &&string
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &;

        auto notebookDocumentFilter() const -> const NotebookDocumentFilter &;

        auto operator=(
            const std::unique_ptr<NotebookDocumentFilter> &notebookDocumentFilter
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &;

        auto operator=(
            std::unique_ptr<NotebookDocumentFilter> &&notebookDocumentFilter
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &;

        auto operator=(
            const NotebookDocumentFilter &notebookDocumentFilter
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &;

        auto operator=(
            NotebookDocumentFilter &&notebookDocumentFilter
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType _type{
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebookType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<NotebookDocumentFilter> _notebookDocumentFilter;
        };

        auto reset() -> void;
    }; // class NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook

    struct NotebookDocumentSyncOptions_notebookSelector_elem_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentSyncOptions_notebookSelector_elem_1();
        NotebookDocumentSyncOptions_notebookSelector_elem_1(
            NotebookDocumentSyncOptions_notebookSelector_elem_1 &&other
        );
        NotebookDocumentSyncOptions_notebookSelector_elem_1(
            const NotebookDocumentSyncOptions_notebookSelector_elem_1 &other
        );
        ~NotebookDocumentSyncOptions_notebookSelector_elem_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentSyncOptions_notebookSelector_elem_1 &&other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1 &;

        auto operator=(
            const NotebookDocumentSyncOptions_notebookSelector_elem_1 &other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem_1 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The notebook to be synced If a string
         * value is provided it matches against the
         * notebook type. '*' matches every notebook.
         */
        std::optional<
            NotebookDocumentSyncOptions_notebookSelector_elem_1_notebook
        > notebook;
        /**
         * The cells of the matching notebook to be synced.
         */
        std::vector<NotebookDocumentSyncOptions_notebookSelector_elem_1_cells_elem>
            cells;
    }; // struct NotebookDocumentSyncOptions_notebookSelector_elem_1

    enum class NotebookDocumentSyncOptions_notebookSelector_elemType {
        Uninitialized = -1,
        NotebookDocumentSyncOptions_notebookSelector_elem_0 = 0,
        NotebookDocumentSyncOptions_notebookSelector_elem_1 = 1,
    }; // enum class NotebookDocumentSyncOptions_notebookSelector_elemType

    extern const std::map<
        NotebookDocumentSyncOptions_notebookSelector_elemType,
        std::string
    > NotebookDocumentSyncOptions_notebookSelector_elemTypeNames;

    class NotebookDocumentSyncOptions_notebookSelector_elem {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentSyncOptions_notebookSelector_elem();
        NotebookDocumentSyncOptions_notebookSelector_elem(
            NotebookDocumentSyncOptions_notebookSelector_elem &&other
        );
        NotebookDocumentSyncOptions_notebookSelector_elem(
            const NotebookDocumentSyncOptions_notebookSelector_elem &other
        );
        ~NotebookDocumentSyncOptions_notebookSelector_elem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentSyncOptions_notebookSelector_elem &&other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem &;

        auto operator=(
            const NotebookDocumentSyncOptions_notebookSelector_elem &other
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem &;

        auto type() const
        -> const NotebookDocumentSyncOptions_notebookSelector_elemType &;

        auto notebookDocumentSyncOptions_notebookSelector_elem_0() const
        -> const NotebookDocumentSyncOptions_notebookSelector_elem_0 &;

        auto operator=(
            const std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> &notebookDocumentSyncOptions_notebookSelector_elem_0
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem &;

        auto operator=(
            std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> &&notebookDocumentSyncOptions_notebookSelector_elem_0
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem &;

        auto operator=(
            const NotebookDocumentSyncOptions_notebookSelector_elem_0 &notebookDocumentSyncOptions_notebookSelector_elem_0
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem &;

        auto operator=(
            NotebookDocumentSyncOptions_notebookSelector_elem_0 &&notebookDocumentSyncOptions_notebookSelector_elem_0
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem &;

        auto notebookDocumentSyncOptions_notebookSelector_elem_1() const
        -> const NotebookDocumentSyncOptions_notebookSelector_elem_1 &;

        auto operator=(
            const std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> &notebookDocumentSyncOptions_notebookSelector_elem_1
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem &;

        auto operator=(
            std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> &&notebookDocumentSyncOptions_notebookSelector_elem_1
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem &;

        auto operator=(
            const NotebookDocumentSyncOptions_notebookSelector_elem_1 &notebookDocumentSyncOptions_notebookSelector_elem_1
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem &;

        auto operator=(
            NotebookDocumentSyncOptions_notebookSelector_elem_1 &&notebookDocumentSyncOptions_notebookSelector_elem_1
        ) -> NotebookDocumentSyncOptions_notebookSelector_elem &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        NotebookDocumentSyncOptions_notebookSelector_elemType _type{
            NotebookDocumentSyncOptions_notebookSelector_elemType::Uninitialized
        };

        union {
            std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_0> _notebookDocumentSyncOptions_notebookSelector_elem_0;
            std::unique_ptr<NotebookDocumentSyncOptions_notebookSelector_elem_1> _notebookDocumentSyncOptions_notebookSelector_elem_1;
        };

        auto reset() -> void;
    }; // class NotebookDocumentSyncOptions_notebookSelector_elem

    typedef std::vector<NotebookDocumentSyncOptions_notebookSelector_elem> NotebookDocumentSyncOptions_notebookSelector;

    enum class NotebookCellTextDocumentFilter_notebookType {
        Uninitialized = -1,
        String = 0,
        NotebookDocumentFilter = 1,
    }; // enum class NotebookCellTextDocumentFilter_notebookType

    extern const std::map<
        NotebookCellTextDocumentFilter_notebookType,
        std::string
    > NotebookCellTextDocumentFilter_notebookTypeNames;

    class NotebookCellTextDocumentFilter_notebook {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookCellTextDocumentFilter_notebook();
        NotebookCellTextDocumentFilter_notebook(
            NotebookCellTextDocumentFilter_notebook &&other
        );
        NotebookCellTextDocumentFilter_notebook(
            const NotebookCellTextDocumentFilter_notebook &other
        );
        ~NotebookCellTextDocumentFilter_notebook();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookCellTextDocumentFilter_notebook &&other
        ) -> NotebookCellTextDocumentFilter_notebook &;

        auto operator=(
            const NotebookCellTextDocumentFilter_notebook &other
        ) -> NotebookCellTextDocumentFilter_notebook &;

        auto type() const
        -> const NotebookCellTextDocumentFilter_notebookType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> NotebookCellTextDocumentFilter_notebook &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> NotebookCellTextDocumentFilter_notebook &;

        auto operator=(
            const string_t &string
        ) -> NotebookCellTextDocumentFilter_notebook &;

        auto operator=(
            string_t &&string
        ) -> NotebookCellTextDocumentFilter_notebook &;

        auto notebookDocumentFilter() const -> const NotebookDocumentFilter &;

        auto operator=(
            const std::unique_ptr<NotebookDocumentFilter> &notebookDocumentFilter
        ) -> NotebookCellTextDocumentFilter_notebook &;

        auto operator=(
            std::unique_ptr<NotebookDocumentFilter> &&notebookDocumentFilter
        ) -> NotebookCellTextDocumentFilter_notebook &;

        auto operator=(
            const NotebookDocumentFilter &notebookDocumentFilter
        ) -> NotebookCellTextDocumentFilter_notebook &;

        auto operator=(
            NotebookDocumentFilter &&notebookDocumentFilter
        ) -> NotebookCellTextDocumentFilter_notebook &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        NotebookCellTextDocumentFilter_notebookType _type{
            NotebookCellTextDocumentFilter_notebookType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<NotebookDocumentFilter> _notebookDocumentFilter;
        };

        auto reset() -> void;
    }; // class NotebookCellTextDocumentFilter_notebook

    /**
     * A notebook cell text document filter denotes a cell text
     * document by different properties.
     *
     * @since 3.17.0
     */
    struct NotebookCellTextDocumentFilter {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookCellTextDocumentFilter();
        NotebookCellTextDocumentFilter(NotebookCellTextDocumentFilter &&other);
        NotebookCellTextDocumentFilter(
            const NotebookCellTextDocumentFilter &other
        );
        ~NotebookCellTextDocumentFilter();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookCellTextDocumentFilter &&other
        ) -> NotebookCellTextDocumentFilter &;

        auto operator=(
            const NotebookCellTextDocumentFilter &other
        ) -> NotebookCellTextDocumentFilter &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A filter that matches against the notebook
         * containing the notebook cell. If a string
         * value is provided it matches against the
         * notebook type. '*' matches every notebook.
         */
        NotebookCellTextDocumentFilter_notebook notebook;
        /**
         * A language id like `python`.
         *
         * Will be matched against the language id of the
         * notebook cell document. '*' matches every language.
         */
        std::optional<string_t> language;
    }; // struct NotebookCellTextDocumentFilter

    enum class DocumentFilterType {
        Uninitialized = -1,
        TextDocumentFilter = 0,
        NotebookCellTextDocumentFilter = 1,
    }; // enum class DocumentFilterType

    extern const std::map<DocumentFilterType, std::string>
        DocumentFilterTypeNames;

    class DocumentFilter {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentFilter();
        DocumentFilter(DocumentFilter &&other);
        DocumentFilter(const DocumentFilter &other);
        ~DocumentFilter();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DocumentFilter &&other) -> DocumentFilter &;

        auto operator=(const DocumentFilter &other) -> DocumentFilter &;

        auto type() const -> const DocumentFilterType &;

        auto textDocumentFilter() const -> const TextDocumentFilter &;

        auto operator=(
            const std::unique_ptr<TextDocumentFilter> &textDocumentFilter
        ) -> DocumentFilter &;

        auto operator=(
            std::unique_ptr<TextDocumentFilter> &&textDocumentFilter
        ) -> DocumentFilter &;

        auto operator=(
            const TextDocumentFilter &textDocumentFilter
        ) -> DocumentFilter &;

        auto operator=(
            TextDocumentFilter &&textDocumentFilter
        ) -> DocumentFilter &;

        auto notebookCellTextDocumentFilter() const
        -> const NotebookCellTextDocumentFilter &;

        auto operator=(
            const std::unique_ptr<NotebookCellTextDocumentFilter> &notebookCellTextDocumentFilter
        ) -> DocumentFilter &;

        auto operator=(
            std::unique_ptr<NotebookCellTextDocumentFilter> &&notebookCellTextDocumentFilter
        ) -> DocumentFilter &;

        auto operator=(
            const NotebookCellTextDocumentFilter &notebookCellTextDocumentFilter
        ) -> DocumentFilter &;

        auto operator=(
            NotebookCellTextDocumentFilter &&notebookCellTextDocumentFilter
        ) -> DocumentFilter &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        DocumentFilterType _type{DocumentFilterType::Uninitialized};

        union {
            std::unique_ptr<TextDocumentFilter> _textDocumentFilter;
            std::unique_ptr<NotebookCellTextDocumentFilter> _notebookCellTextDocumentFilter;
        };

        auto reset() -> void;
    }; // class DocumentFilter

    typedef std::vector<DocumentFilter> DocumentSelector;

    typedef string_t Pattern;

    /**
     * A relative pattern is a helper to construct glob patterns that are matched
     * relatively to a base URI. The common value for a `baseUri` is a workspace
     * folder root, but it can be another absolute URI as well.
     *
     * @since 3.17.0
     */
    struct RelativePattern {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RelativePattern();
        RelativePattern(RelativePattern &&other);
        RelativePattern(const RelativePattern &other);
        ~RelativePattern();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(RelativePattern &&other) -> RelativePattern &;

        auto operator=(const RelativePattern &other) -> RelativePattern &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A workspace folder or a base URI to which this pattern will be matched
         * against relatively.
         */
        RelativePattern_baseUri baseUri;
        /**
         * The actual glob pattern;
         */
        string_t pattern;
    }; // struct RelativePattern

    enum class GlobPatternType {
        Uninitialized = -1,
        Pattern = 0,
        RelativePattern = 1,
    }; // enum class GlobPatternType

    extern const std::map<GlobPatternType, std::string> GlobPatternTypeNames;

    class GlobPattern {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        GlobPattern();
        GlobPattern(GlobPattern &&other);
        GlobPattern(const GlobPattern &other);
        ~GlobPattern();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(GlobPattern &&other) -> GlobPattern &;

        auto operator=(const GlobPattern &other) -> GlobPattern &;

        auto type() const -> const GlobPatternType &;

        auto pattern() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &pattern
        ) -> GlobPattern &;

        auto operator=(std::unique_ptr<string_t> &&pattern) -> GlobPattern &;

        auto operator=(const string_t &pattern) -> GlobPattern &;

        auto operator=(string_t &&pattern) -> GlobPattern &;

        auto relativePattern() const -> const RelativePattern &;

        auto operator=(
            const std::unique_ptr<RelativePattern> &relativePattern
        ) -> GlobPattern &;

        auto operator=(
            std::unique_ptr<RelativePattern> &&relativePattern
        ) -> GlobPattern &;

        auto operator=(
            const RelativePattern &relativePattern
        ) -> GlobPattern &;

        auto operator=(RelativePattern &&relativePattern) -> GlobPattern &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        GlobPatternType _type{GlobPatternType::Uninitialized};

        union {
            std::unique_ptr<string_t> _pattern;
            std::unique_ptr<RelativePattern> _relativePattern;
        };

        auto reset() -> void;
    }; // class GlobPattern

    struct FileSystemWatcher {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FileSystemWatcher();
        FileSystemWatcher(FileSystemWatcher &&other);
        FileSystemWatcher(const FileSystemWatcher &other);
        ~FileSystemWatcher();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FileSystemWatcher &&other) -> FileSystemWatcher &;

        auto operator=(const FileSystemWatcher &other) -> FileSystemWatcher &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The glob pattern to watch. See {@link GlobPattern glob pattern} for more detail.
         *
         * @since 3.17.0 support for relative patterns.
         */
        GlobPattern globPattern;
        /**
         * The kind of events of interest. If omitted it defaults
         * to WatchKind.Create | WatchKind.Change | WatchKind.Delete
         * which is 7.
         */
        std::optional<WatchKind> kind;
    }; // struct FileSystemWatcher

    /**
     * Describe options to be used when registered for text document change events.
     */
    struct DidChangeWatchedFilesRegistrationOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidChangeWatchedFilesRegistrationOptions();
        DidChangeWatchedFilesRegistrationOptions(
            DidChangeWatchedFilesRegistrationOptions &&other
        );
        DidChangeWatchedFilesRegistrationOptions(
            const DidChangeWatchedFilesRegistrationOptions &other
        );
        ~DidChangeWatchedFilesRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidChangeWatchedFilesRegistrationOptions &&other
        ) -> DidChangeWatchedFilesRegistrationOptions &;

        auto operator=(
            const DidChangeWatchedFilesRegistrationOptions &other
        ) -> DidChangeWatchedFilesRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The watchers to register.
         */
        std::vector<FileSystemWatcher> watchers;
    }; // struct DidChangeWatchedFilesRegistrationOptions

    typedef std::vector<FileSystemWatcher> DidChangeWatchedFilesRegistrationOptions_watchers;

    typedef std::vector<WorkspaceFolder> Workspace_WorkspaceFoldersResult_0;

    typedef std::vector<Moniker> TextDocument_MonikerResult_0;

    typedef bool boolean_t;

    struct WorkDoneProgressOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkDoneProgressOptions();
        WorkDoneProgressOptions(WorkDoneProgressOptions &&other);
        WorkDoneProgressOptions(const WorkDoneProgressOptions &other);
        ~WorkDoneProgressOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkDoneProgressOptions &&other
        ) -> WorkDoneProgressOptions &;

        auto operator=(
            const WorkDoneProgressOptions &other
        ) -> WorkDoneProgressOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct WorkDoneProgressOptions

    /**
     * The result of a showDocument request.
     *
     * @since 3.16.0
     */
    struct ShowDocumentResult {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ShowDocumentResult();
        ShowDocumentResult(ShowDocumentResult &&other);
        ShowDocumentResult(const ShowDocumentResult &other);
        ~ShowDocumentResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ShowDocumentResult &&other) -> ShowDocumentResult &;

        auto operator=(
            const ShowDocumentResult &other
        ) -> ShowDocumentResult &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A boolean indicating if the show was successful.
         */
        boolean_t success;
    }; // struct ShowDocumentResult

    /**
     * Cancellation data returned from a diagnostic request.
     *
     * @since 3.17.0
     */
    struct DiagnosticServerCancellationData {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DiagnosticServerCancellationData();
        DiagnosticServerCancellationData(
            DiagnosticServerCancellationData &&other
        );
        DiagnosticServerCancellationData(
            const DiagnosticServerCancellationData &other
        );
        ~DiagnosticServerCancellationData();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DiagnosticServerCancellationData &&other
        ) -> DiagnosticServerCancellationData &;

        auto operator=(
            const DiagnosticServerCancellationData &other
        ) -> DiagnosticServerCancellationData &;

        // ================== //
        // Field Declarations //
        // ================== //

        boolean_t retriggerRequest;
    }; // struct DiagnosticServerCancellationData

    /**
     * The data type of the ResponseError if the
     * initialize request fails.
     */
    struct InitializeError {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InitializeError();
        InitializeError(InitializeError &&other);
        InitializeError(const InitializeError &other);
        ~InitializeError();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InitializeError &&other) -> InitializeError &;

        auto operator=(const InitializeError &other) -> InitializeError &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Indicates whether the client execute the following retry logic:
         * (1) show the message provided by the ResponseError to the user
         * (2) user selects retry or cancel
         * (3) if user selected retry the initialize method is sent again.
         */
        boolean_t retry;
    }; // struct InitializeError

    struct ImplementationOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ImplementationOptions();
        ImplementationOptions(ImplementationOptions &&other);
        ImplementationOptions(const ImplementationOptions &other);
        ~ImplementationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ImplementationOptions &&other
        ) -> ImplementationOptions &;

        auto operator=(
            const ImplementationOptions &other
        ) -> ImplementationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct ImplementationOptions

    struct TypeDefinitionOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeDefinitionOptions();
        TypeDefinitionOptions(TypeDefinitionOptions &&other);
        TypeDefinitionOptions(const TypeDefinitionOptions &other);
        ~TypeDefinitionOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TypeDefinitionOptions &&other
        ) -> TypeDefinitionOptions &;

        auto operator=(
            const TypeDefinitionOptions &other
        ) -> TypeDefinitionOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct TypeDefinitionOptions

    struct DocumentColorOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentColorOptions();
        DocumentColorOptions(DocumentColorOptions &&other);
        DocumentColorOptions(const DocumentColorOptions &other);
        ~DocumentColorOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DocumentColorOptions &&other) -> DocumentColorOptions &;

        auto operator=(
            const DocumentColorOptions &other
        ) -> DocumentColorOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct DocumentColorOptions

    struct FoldingRangeOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FoldingRangeOptions();
        FoldingRangeOptions(FoldingRangeOptions &&other);
        FoldingRangeOptions(const FoldingRangeOptions &other);
        ~FoldingRangeOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FoldingRangeOptions &&other) -> FoldingRangeOptions &;

        auto operator=(
            const FoldingRangeOptions &other
        ) -> FoldingRangeOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct FoldingRangeOptions

    struct DeclarationOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DeclarationOptions();
        DeclarationOptions(DeclarationOptions &&other);
        DeclarationOptions(const DeclarationOptions &other);
        ~DeclarationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DeclarationOptions &&other) -> DeclarationOptions &;

        auto operator=(
            const DeclarationOptions &other
        ) -> DeclarationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct DeclarationOptions

    struct SelectionRangeOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SelectionRangeOptions();
        SelectionRangeOptions(SelectionRangeOptions &&other);
        SelectionRangeOptions(const SelectionRangeOptions &other);
        ~SelectionRangeOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SelectionRangeOptions &&other
        ) -> SelectionRangeOptions &;

        auto operator=(
            const SelectionRangeOptions &other
        ) -> SelectionRangeOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct SelectionRangeOptions

    /**
     * Call hierarchy options used during static registration.
     *
     * @since 3.16.0
     */
    struct CallHierarchyOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CallHierarchyOptions();
        CallHierarchyOptions(CallHierarchyOptions &&other);
        CallHierarchyOptions(const CallHierarchyOptions &other);
        ~CallHierarchyOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CallHierarchyOptions &&other) -> CallHierarchyOptions &;

        auto operator=(
            const CallHierarchyOptions &other
        ) -> CallHierarchyOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct CallHierarchyOptions

    struct SemanticTokensOptions_full_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensOptions_full_1();
        SemanticTokensOptions_full_1(SemanticTokensOptions_full_1 &&other);
        SemanticTokensOptions_full_1(
            const SemanticTokensOptions_full_1 &other
        );
        ~SemanticTokensOptions_full_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensOptions_full_1 &&other
        ) -> SemanticTokensOptions_full_1 &;

        auto operator=(
            const SemanticTokensOptions_full_1 &other
        ) -> SemanticTokensOptions_full_1 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The server supports deltas for full documents.
         */
        std::optional<boolean_t> delta;
    }; // struct SemanticTokensOptions_full_1

    enum class SemanticTokensOptions_fullType {
        Uninitialized = -1,
        Boolean = 0,
        SemanticTokensOptions_full_1 = 1,
    }; // enum class SemanticTokensOptions_fullType

    extern const std::map<SemanticTokensOptions_fullType, std::string>
        SemanticTokensOptions_fullTypeNames;

    class SemanticTokensOptions_full {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensOptions_full();
        SemanticTokensOptions_full(SemanticTokensOptions_full &&other);
        SemanticTokensOptions_full(const SemanticTokensOptions_full &other);
        ~SemanticTokensOptions_full();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensOptions_full &&other
        ) -> SemanticTokensOptions_full &;

        auto operator=(
            const SemanticTokensOptions_full &other
        ) -> SemanticTokensOptions_full &;

        auto type() const -> const SemanticTokensOptions_fullType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(boolean_t boolean) -> SemanticTokensOptions_full &;

        auto semanticTokensOptions_full_1() const
        -> const SemanticTokensOptions_full_1 &;

        auto operator=(
            const std::unique_ptr<SemanticTokensOptions_full_1> &semanticTokensOptions_full_1
        ) -> SemanticTokensOptions_full &;

        auto operator=(
            std::unique_ptr<SemanticTokensOptions_full_1> &&semanticTokensOptions_full_1
        ) -> SemanticTokensOptions_full &;

        auto operator=(
            const SemanticTokensOptions_full_1 &semanticTokensOptions_full_1
        ) -> SemanticTokensOptions_full &;

        auto operator=(
            SemanticTokensOptions_full_1 &&semanticTokensOptions_full_1
        ) -> SemanticTokensOptions_full &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        SemanticTokensOptions_fullType _type{
            SemanticTokensOptions_fullType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<SemanticTokensOptions_full_1> _semanticTokensOptions_full_1;
        };

        auto reset() -> void;
    }; // class SemanticTokensOptions_full

    struct LinkedEditingRangeOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        LinkedEditingRangeOptions();
        LinkedEditingRangeOptions(LinkedEditingRangeOptions &&other);
        LinkedEditingRangeOptions(const LinkedEditingRangeOptions &other);
        ~LinkedEditingRangeOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            LinkedEditingRangeOptions &&other
        ) -> LinkedEditingRangeOptions &;

        auto operator=(
            const LinkedEditingRangeOptions &other
        ) -> LinkedEditingRangeOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct LinkedEditingRangeOptions

    /**
     * Additional information that describes document changes.
     *
     * @since 3.16.0
     */
    struct ChangeAnnotation {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ChangeAnnotation();
        ChangeAnnotation(ChangeAnnotation &&other);
        ChangeAnnotation(const ChangeAnnotation &other);
        ~ChangeAnnotation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ChangeAnnotation &&other) -> ChangeAnnotation &;

        auto operator=(const ChangeAnnotation &other) -> ChangeAnnotation &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A human-readable string describing the actual change. The string
         * is rendered prominent in the user interface.
         */
        string_t label;
        /**
         * A flag which indicates that user confirmation is needed
         * before applying the change.
         */
        std::optional<boolean_t> needsConfirmation;
        /**
         * A human-readable string which is rendered less prominent in
         * the user interface.
         */
        std::optional<string_t> description;
    }; // struct ChangeAnnotation

    typedef std::map<string_t, ChangeAnnotation> WorkspaceEdit_changeAnnotations;

    struct MonikerOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        MonikerOptions();
        MonikerOptions(MonikerOptions &&other);
        MonikerOptions(const MonikerOptions &other);
        ~MonikerOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(MonikerOptions &&other) -> MonikerOptions &;

        auto operator=(const MonikerOptions &other) -> MonikerOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct MonikerOptions

    /**
     * Type hierarchy options used during static registration.
     *
     * @since 3.17.0
     */
    struct TypeHierarchyOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeHierarchyOptions();
        TypeHierarchyOptions(TypeHierarchyOptions &&other);
        TypeHierarchyOptions(const TypeHierarchyOptions &other);
        ~TypeHierarchyOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(TypeHierarchyOptions &&other) -> TypeHierarchyOptions &;

        auto operator=(
            const TypeHierarchyOptions &other
        ) -> TypeHierarchyOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct TypeHierarchyOptions

    /**
     * Inline value options used during static registration.
     *
     * @since 3.17.0
     */
    struct InlineValueOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineValueOptions();
        InlineValueOptions(InlineValueOptions &&other);
        InlineValueOptions(const InlineValueOptions &other);
        ~InlineValueOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlineValueOptions &&other) -> InlineValueOptions &;

        auto operator=(
            const InlineValueOptions &other
        ) -> InlineValueOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct InlineValueOptions

    /**
     * Inlay hint options used during static registration.
     *
     * @since 3.17.0
     */
    struct InlayHintOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlayHintOptions();
        InlayHintOptions(InlayHintOptions &&other);
        InlayHintOptions(const InlayHintOptions &other);
        ~InlayHintOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlayHintOptions &&other) -> InlayHintOptions &;

        auto operator=(const InlayHintOptions &other) -> InlayHintOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * The server provides support to resolve additional
         * information for an inlay hint item.
         */
        std::optional<boolean_t> resolveProvider;
    }; // struct InlayHintOptions

    /**
     * Diagnostic options.
     *
     * @since 3.17.0
     */
    struct DiagnosticOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DiagnosticOptions();
        DiagnosticOptions(DiagnosticOptions &&other);
        DiagnosticOptions(const DiagnosticOptions &other);
        ~DiagnosticOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DiagnosticOptions &&other) -> DiagnosticOptions &;

        auto operator=(const DiagnosticOptions &other) -> DiagnosticOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * An optional identifier under which the diagnostics are
         * managed by the client.
         */
        std::optional<string_t> identifier;
        /**
         * Whether the language has inter file dependencies meaning that
         * editing code in one file can result in a different diagnostic
         * set in another file. Inter file dependencies are common for
         * most programming languages and typically uncommon for linters.
         */
        boolean_t interFileDependencies;
        /**
         * The server provides support for workspace diagnostics as well.
         */
        boolean_t workspaceDiagnostics;
    }; // struct DiagnosticOptions

    /**
     * Inline completion options used during static registration.
     *
     * @since 3.18.0
     * @proposed
     */
    struct InlineCompletionOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineCompletionOptions();
        InlineCompletionOptions(InlineCompletionOptions &&other);
        InlineCompletionOptions(const InlineCompletionOptions &other);
        ~InlineCompletionOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlineCompletionOptions &&other
        ) -> InlineCompletionOptions &;

        auto operator=(
            const InlineCompletionOptions &other
        ) -> InlineCompletionOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct InlineCompletionOptions

    enum class ServerCapabilities_inlineCompletionProviderType {
        Uninitialized = -1,
        Boolean = 0,
        InlineCompletionOptions = 1,
    }; // enum class ServerCapabilities_inlineCompletionProviderType

    extern const std::map<
        ServerCapabilities_inlineCompletionProviderType,
        std::string
    > ServerCapabilities_inlineCompletionProviderTypeNames;

    class ServerCapabilities_inlineCompletionProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_inlineCompletionProvider();
        ServerCapabilities_inlineCompletionProvider(
            ServerCapabilities_inlineCompletionProvider &&other
        );
        ServerCapabilities_inlineCompletionProvider(
            const ServerCapabilities_inlineCompletionProvider &other
        );
        ~ServerCapabilities_inlineCompletionProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_inlineCompletionProvider &&other
        ) -> ServerCapabilities_inlineCompletionProvider &;

        auto operator=(
            const ServerCapabilities_inlineCompletionProvider &other
        ) -> ServerCapabilities_inlineCompletionProvider &;

        auto type() const
        -> const ServerCapabilities_inlineCompletionProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_inlineCompletionProvider &;

        auto inlineCompletionOptions() const
        -> const InlineCompletionOptions &;

        auto operator=(
            const std::unique_ptr<InlineCompletionOptions> &inlineCompletionOptions
        ) -> ServerCapabilities_inlineCompletionProvider &;

        auto operator=(
            std::unique_ptr<InlineCompletionOptions> &&inlineCompletionOptions
        ) -> ServerCapabilities_inlineCompletionProvider &;

        auto operator=(
            const InlineCompletionOptions &inlineCompletionOptions
        ) -> ServerCapabilities_inlineCompletionProvider &;

        auto operator=(
            InlineCompletionOptions &&inlineCompletionOptions
        ) -> ServerCapabilities_inlineCompletionProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_inlineCompletionProviderType _type{
            ServerCapabilities_inlineCompletionProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<InlineCompletionOptions> _inlineCompletionOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_inlineCompletionProvider

    /**
     * Save options.
     */
    struct SaveOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SaveOptions();
        SaveOptions(SaveOptions &&other);
        SaveOptions(const SaveOptions &other);
        ~SaveOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SaveOptions &&other) -> SaveOptions &;

        auto operator=(const SaveOptions &other) -> SaveOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The client is supposed to include the content on save.
         */
        std::optional<boolean_t> includeText;
    }; // struct SaveOptions

    struct CompletionOptions_completionItem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionOptions_completionItem();
        CompletionOptions_completionItem(
            CompletionOptions_completionItem &&other
        );
        CompletionOptions_completionItem(
            const CompletionOptions_completionItem &other
        );
        ~CompletionOptions_completionItem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionOptions_completionItem &&other
        ) -> CompletionOptions_completionItem &;

        auto operator=(
            const CompletionOptions_completionItem &other
        ) -> CompletionOptions_completionItem &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The server has support for completion item label
         * details (see also `CompletionItemLabelDetails`) when
         * receiving a completion item in a resolve call.
         *
         * @since 3.17.0
         */
        std::optional<boolean_t> labelDetailsSupport;
    }; // struct CompletionOptions_completionItem

    /**
     * Completion options.
     */
    struct CompletionOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionOptions();
        CompletionOptions(CompletionOptions &&other);
        CompletionOptions(const CompletionOptions &other);
        ~CompletionOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CompletionOptions &&other) -> CompletionOptions &;

        auto operator=(const CompletionOptions &other) -> CompletionOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * Most tools trigger completion request automatically without explicitly requesting
         * it using a keyboard shortcut (e.g. Ctrl+Space). Typically they do so when the user
         * starts to type an identifier. For example if the user types `c` in a JavaScript file
         * code complete will automatically pop up present `console` besides others as a
         * completion item. Characters that make up identifiers don't need to be listed here.
         *
         * If code complete should automatically be trigger on characters not being valid inside
         * an identifier (for example `.` in JavaScript) list them in `triggerCharacters`.
         */
        std::optional<std::vector<string_t>> triggerCharacters;
        /**
         * The list of all possible characters that commit a completion. This field can be used
         * if clients don't support individual commit characters per completion item. See
         * `ClientCapabilities.textDocument.completion.completionItem.commitCharactersSupport`
         *
         * If a server provides both `allCommitCharacters` and commit characters on an individual
         * completion item the ones on the completion item win.
         *
         * @since 3.2.0
         */
        std::optional<std::vector<string_t>> allCommitCharacters;
        /**
         * The server provides support to resolve additional
         * information for a completion item.
         */
        std::optional<boolean_t> resolveProvider;
        /**
         * The server supports the following `CompletionItem` specific
         * capabilities.
         *
         * @since 3.17.0
         */
        std::optional<CompletionOptions_completionItem> completionItem;
    }; // struct CompletionOptions

    /**
     * Hover options.
     */
    struct HoverOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        HoverOptions();
        HoverOptions(HoverOptions &&other);
        HoverOptions(const HoverOptions &other);
        ~HoverOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(HoverOptions &&other) -> HoverOptions &;

        auto operator=(const HoverOptions &other) -> HoverOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct HoverOptions

    enum class ServerCapabilities_hoverProviderType {
        Uninitialized = -1,
        Boolean = 0,
        HoverOptions = 1,
    }; // enum class ServerCapabilities_hoverProviderType

    extern const std::map<ServerCapabilities_hoverProviderType, std::string>
        ServerCapabilities_hoverProviderTypeNames;

    class ServerCapabilities_hoverProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_hoverProvider();
        ServerCapabilities_hoverProvider(
            ServerCapabilities_hoverProvider &&other
        );
        ServerCapabilities_hoverProvider(
            const ServerCapabilities_hoverProvider &other
        );
        ~ServerCapabilities_hoverProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_hoverProvider &&other
        ) -> ServerCapabilities_hoverProvider &;

        auto operator=(
            const ServerCapabilities_hoverProvider &other
        ) -> ServerCapabilities_hoverProvider &;

        auto type() const -> const ServerCapabilities_hoverProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_hoverProvider &;

        auto hoverOptions() const -> const HoverOptions &;

        auto operator=(
            const std::unique_ptr<HoverOptions> &hoverOptions
        ) -> ServerCapabilities_hoverProvider &;

        auto operator=(
            std::unique_ptr<HoverOptions> &&hoverOptions
        ) -> ServerCapabilities_hoverProvider &;

        auto operator=(
            const HoverOptions &hoverOptions
        ) -> ServerCapabilities_hoverProvider &;

        auto operator=(
            HoverOptions &&hoverOptions
        ) -> ServerCapabilities_hoverProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_hoverProviderType _type{
            ServerCapabilities_hoverProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<HoverOptions> _hoverOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_hoverProvider

    /**
     * Server Capabilities for a {@link SignatureHelpRequest}.
     */
    struct SignatureHelpOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SignatureHelpOptions();
        SignatureHelpOptions(SignatureHelpOptions &&other);
        SignatureHelpOptions(const SignatureHelpOptions &other);
        ~SignatureHelpOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SignatureHelpOptions &&other) -> SignatureHelpOptions &;

        auto operator=(
            const SignatureHelpOptions &other
        ) -> SignatureHelpOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * List of characters that trigger signature help automatically.
         */
        std::optional<std::vector<string_t>> triggerCharacters;
        /**
         * List of characters that re-trigger signature help.
         *
         * These trigger characters are only active when signature help is already showing. All trigger characters
         * are also counted as re-trigger characters.
         *
         * @since 3.15.0
         */
        std::optional<std::vector<string_t>> retriggerCharacters;
    }; // struct SignatureHelpOptions

    /**
     * Server Capabilities for a {@link DefinitionRequest}.
     */
    struct DefinitionOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DefinitionOptions();
        DefinitionOptions(DefinitionOptions &&other);
        DefinitionOptions(const DefinitionOptions &other);
        ~DefinitionOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DefinitionOptions &&other) -> DefinitionOptions &;

        auto operator=(const DefinitionOptions &other) -> DefinitionOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct DefinitionOptions

    enum class ServerCapabilities_definitionProviderType {
        Uninitialized = -1,
        Boolean = 0,
        DefinitionOptions = 1,
    }; // enum class ServerCapabilities_definitionProviderType

    extern const std::map<
        ServerCapabilities_definitionProviderType,
        std::string
    > ServerCapabilities_definitionProviderTypeNames;

    class ServerCapabilities_definitionProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_definitionProvider();
        ServerCapabilities_definitionProvider(
            ServerCapabilities_definitionProvider &&other
        );
        ServerCapabilities_definitionProvider(
            const ServerCapabilities_definitionProvider &other
        );
        ~ServerCapabilities_definitionProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_definitionProvider &&other
        ) -> ServerCapabilities_definitionProvider &;

        auto operator=(
            const ServerCapabilities_definitionProvider &other
        ) -> ServerCapabilities_definitionProvider &;

        auto type() const -> const ServerCapabilities_definitionProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_definitionProvider &;

        auto definitionOptions() const -> const DefinitionOptions &;

        auto operator=(
            const std::unique_ptr<DefinitionOptions> &definitionOptions
        ) -> ServerCapabilities_definitionProvider &;

        auto operator=(
            std::unique_ptr<DefinitionOptions> &&definitionOptions
        ) -> ServerCapabilities_definitionProvider &;

        auto operator=(
            const DefinitionOptions &definitionOptions
        ) -> ServerCapabilities_definitionProvider &;

        auto operator=(
            DefinitionOptions &&definitionOptions
        ) -> ServerCapabilities_definitionProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_definitionProviderType _type{
            ServerCapabilities_definitionProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<DefinitionOptions> _definitionOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_definitionProvider

    /**
     * Value-object that contains additional information when
     * requesting references.
     */
    struct ReferenceContext {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ReferenceContext();
        ReferenceContext(ReferenceContext &&other);
        ReferenceContext(const ReferenceContext &other);
        ~ReferenceContext();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ReferenceContext &&other) -> ReferenceContext &;

        auto operator=(const ReferenceContext &other) -> ReferenceContext &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Include the declaration of the current symbol.
         */
        boolean_t includeDeclaration;
    }; // struct ReferenceContext

    /**
     * Reference options.
     */
    struct ReferenceOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ReferenceOptions();
        ReferenceOptions(ReferenceOptions &&other);
        ReferenceOptions(const ReferenceOptions &other);
        ~ReferenceOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ReferenceOptions &&other) -> ReferenceOptions &;

        auto operator=(const ReferenceOptions &other) -> ReferenceOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct ReferenceOptions

    enum class ServerCapabilities_referencesProviderType {
        Uninitialized = -1,
        Boolean = 0,
        ReferenceOptions = 1,
    }; // enum class ServerCapabilities_referencesProviderType

    extern const std::map<
        ServerCapabilities_referencesProviderType,
        std::string
    > ServerCapabilities_referencesProviderTypeNames;

    class ServerCapabilities_referencesProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_referencesProvider();
        ServerCapabilities_referencesProvider(
            ServerCapabilities_referencesProvider &&other
        );
        ServerCapabilities_referencesProvider(
            const ServerCapabilities_referencesProvider &other
        );
        ~ServerCapabilities_referencesProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_referencesProvider &&other
        ) -> ServerCapabilities_referencesProvider &;

        auto operator=(
            const ServerCapabilities_referencesProvider &other
        ) -> ServerCapabilities_referencesProvider &;

        auto type() const -> const ServerCapabilities_referencesProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_referencesProvider &;

        auto referenceOptions() const -> const ReferenceOptions &;

        auto operator=(
            const std::unique_ptr<ReferenceOptions> &referenceOptions
        ) -> ServerCapabilities_referencesProvider &;

        auto operator=(
            std::unique_ptr<ReferenceOptions> &&referenceOptions
        ) -> ServerCapabilities_referencesProvider &;

        auto operator=(
            const ReferenceOptions &referenceOptions
        ) -> ServerCapabilities_referencesProvider &;

        auto operator=(
            ReferenceOptions &&referenceOptions
        ) -> ServerCapabilities_referencesProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_referencesProviderType _type{
            ServerCapabilities_referencesProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<ReferenceOptions> _referenceOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_referencesProvider

    /**
     * Provider options for a {@link DocumentHighlightRequest}.
     */
    struct DocumentHighlightOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentHighlightOptions();
        DocumentHighlightOptions(DocumentHighlightOptions &&other);
        DocumentHighlightOptions(const DocumentHighlightOptions &other);
        ~DocumentHighlightOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentHighlightOptions &&other
        ) -> DocumentHighlightOptions &;

        auto operator=(
            const DocumentHighlightOptions &other
        ) -> DocumentHighlightOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct DocumentHighlightOptions

    enum class ServerCapabilities_documentHighlightProviderType {
        Uninitialized = -1,
        Boolean = 0,
        DocumentHighlightOptions = 1,
    }; // enum class ServerCapabilities_documentHighlightProviderType

    extern const std::map<
        ServerCapabilities_documentHighlightProviderType,
        std::string
    > ServerCapabilities_documentHighlightProviderTypeNames;

    class ServerCapabilities_documentHighlightProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_documentHighlightProvider();
        ServerCapabilities_documentHighlightProvider(
            ServerCapabilities_documentHighlightProvider &&other
        );
        ServerCapabilities_documentHighlightProvider(
            const ServerCapabilities_documentHighlightProvider &other
        );
        ~ServerCapabilities_documentHighlightProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_documentHighlightProvider &&other
        ) -> ServerCapabilities_documentHighlightProvider &;

        auto operator=(
            const ServerCapabilities_documentHighlightProvider &other
        ) -> ServerCapabilities_documentHighlightProvider &;

        auto type() const
        -> const ServerCapabilities_documentHighlightProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_documentHighlightProvider &;

        auto documentHighlightOptions() const
        -> const DocumentHighlightOptions &;

        auto operator=(
            const std::unique_ptr<DocumentHighlightOptions> &documentHighlightOptions
        ) -> ServerCapabilities_documentHighlightProvider &;

        auto operator=(
            std::unique_ptr<DocumentHighlightOptions> &&documentHighlightOptions
        ) -> ServerCapabilities_documentHighlightProvider &;

        auto operator=(
            const DocumentHighlightOptions &documentHighlightOptions
        ) -> ServerCapabilities_documentHighlightProvider &;

        auto operator=(
            DocumentHighlightOptions &&documentHighlightOptions
        ) -> ServerCapabilities_documentHighlightProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_documentHighlightProviderType _type{
            ServerCapabilities_documentHighlightProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<DocumentHighlightOptions> _documentHighlightOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_documentHighlightProvider

    /**
     * Provider options for a {@link DocumentSymbolRequest}.
     */
    struct DocumentSymbolOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentSymbolOptions();
        DocumentSymbolOptions(DocumentSymbolOptions &&other);
        DocumentSymbolOptions(const DocumentSymbolOptions &other);
        ~DocumentSymbolOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentSymbolOptions &&other
        ) -> DocumentSymbolOptions &;

        auto operator=(
            const DocumentSymbolOptions &other
        ) -> DocumentSymbolOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * A human-readable string that is shown when multiple outlines trees
         * are shown for the same document.
         *
         * @since 3.16.0
         */
        std::optional<string_t> label;
    }; // struct DocumentSymbolOptions

    enum class ServerCapabilities_documentSymbolProviderType {
        Uninitialized = -1,
        Boolean = 0,
        DocumentSymbolOptions = 1,
    }; // enum class ServerCapabilities_documentSymbolProviderType

    extern const std::map<
        ServerCapabilities_documentSymbolProviderType,
        std::string
    > ServerCapabilities_documentSymbolProviderTypeNames;

    class ServerCapabilities_documentSymbolProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_documentSymbolProvider();
        ServerCapabilities_documentSymbolProvider(
            ServerCapabilities_documentSymbolProvider &&other
        );
        ServerCapabilities_documentSymbolProvider(
            const ServerCapabilities_documentSymbolProvider &other
        );
        ~ServerCapabilities_documentSymbolProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_documentSymbolProvider &&other
        ) -> ServerCapabilities_documentSymbolProvider &;

        auto operator=(
            const ServerCapabilities_documentSymbolProvider &other
        ) -> ServerCapabilities_documentSymbolProvider &;

        auto type() const
        -> const ServerCapabilities_documentSymbolProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_documentSymbolProvider &;

        auto documentSymbolOptions() const -> const DocumentSymbolOptions &;

        auto operator=(
            const std::unique_ptr<DocumentSymbolOptions> &documentSymbolOptions
        ) -> ServerCapabilities_documentSymbolProvider &;

        auto operator=(
            std::unique_ptr<DocumentSymbolOptions> &&documentSymbolOptions
        ) -> ServerCapabilities_documentSymbolProvider &;

        auto operator=(
            const DocumentSymbolOptions &documentSymbolOptions
        ) -> ServerCapabilities_documentSymbolProvider &;

        auto operator=(
            DocumentSymbolOptions &&documentSymbolOptions
        ) -> ServerCapabilities_documentSymbolProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_documentSymbolProviderType _type{
            ServerCapabilities_documentSymbolProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<DocumentSymbolOptions> _documentSymbolOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_documentSymbolProvider

    /**
     * Provider options for a {@link CodeActionRequest}.
     */
    struct CodeActionOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeActionOptions();
        CodeActionOptions(CodeActionOptions &&other);
        CodeActionOptions(const CodeActionOptions &other);
        ~CodeActionOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CodeActionOptions &&other) -> CodeActionOptions &;

        auto operator=(const CodeActionOptions &other) -> CodeActionOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * CodeActionKinds that this server may return.
         *
         * The list of kinds may be generic, such as `CodeActionKind.Refactor`, or the server
         * may list out every specific kind they provide.
         */
        std::optional<std::vector<CodeActionKind>> codeActionKinds;
        /**
         * The server provides support to resolve additional
         * information for a code action.
         *
         * @since 3.16.0
         */
        std::optional<boolean_t> resolveProvider;
    }; // struct CodeActionOptions

    enum class ServerCapabilities_codeActionProviderType {
        Uninitialized = -1,
        Boolean = 0,
        CodeActionOptions = 1,
    }; // enum class ServerCapabilities_codeActionProviderType

    extern const std::map<
        ServerCapabilities_codeActionProviderType,
        std::string
    > ServerCapabilities_codeActionProviderTypeNames;

    class ServerCapabilities_codeActionProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_codeActionProvider();
        ServerCapabilities_codeActionProvider(
            ServerCapabilities_codeActionProvider &&other
        );
        ServerCapabilities_codeActionProvider(
            const ServerCapabilities_codeActionProvider &other
        );
        ~ServerCapabilities_codeActionProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_codeActionProvider &&other
        ) -> ServerCapabilities_codeActionProvider &;

        auto operator=(
            const ServerCapabilities_codeActionProvider &other
        ) -> ServerCapabilities_codeActionProvider &;

        auto type() const -> const ServerCapabilities_codeActionProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_codeActionProvider &;

        auto codeActionOptions() const -> const CodeActionOptions &;

        auto operator=(
            const std::unique_ptr<CodeActionOptions> &codeActionOptions
        ) -> ServerCapabilities_codeActionProvider &;

        auto operator=(
            std::unique_ptr<CodeActionOptions> &&codeActionOptions
        ) -> ServerCapabilities_codeActionProvider &;

        auto operator=(
            const CodeActionOptions &codeActionOptions
        ) -> ServerCapabilities_codeActionProvider &;

        auto operator=(
            CodeActionOptions &&codeActionOptions
        ) -> ServerCapabilities_codeActionProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_codeActionProviderType _type{
            ServerCapabilities_codeActionProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<CodeActionOptions> _codeActionOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_codeActionProvider

    /**
     * Server capabilities for a {@link WorkspaceSymbolRequest}.
     */
    struct WorkspaceSymbolOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceSymbolOptions();
        WorkspaceSymbolOptions(WorkspaceSymbolOptions &&other);
        WorkspaceSymbolOptions(const WorkspaceSymbolOptions &other);
        ~WorkspaceSymbolOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceSymbolOptions &&other
        ) -> WorkspaceSymbolOptions &;

        auto operator=(
            const WorkspaceSymbolOptions &other
        ) -> WorkspaceSymbolOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * The server provides support to resolve additional
         * information for a workspace symbol.
         *
         * @since 3.17.0
         */
        std::optional<boolean_t> resolveProvider;
    }; // struct WorkspaceSymbolOptions

    /**
     * Registration options for a {@link WorkspaceSymbolRequest}.
     */
    struct WorkspaceSymbolRegistrationOptions
        : public WorkspaceSymbolOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceSymbolRegistrationOptions();
        WorkspaceSymbolRegistrationOptions(
            WorkspaceSymbolRegistrationOptions &&other
        );
        WorkspaceSymbolRegistrationOptions(
            const WorkspaceSymbolRegistrationOptions &other
        );
        ~WorkspaceSymbolRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceSymbolRegistrationOptions &&other
        ) -> WorkspaceSymbolRegistrationOptions &;

        auto operator=(
            const WorkspaceSymbolRegistrationOptions &other
        ) -> WorkspaceSymbolRegistrationOptions &;
    }; // struct WorkspaceSymbolRegistrationOptions

    enum class ServerCapabilities_workspaceSymbolProviderType {
        Uninitialized = -1,
        Boolean = 0,
        WorkspaceSymbolOptions = 1,
    }; // enum class ServerCapabilities_workspaceSymbolProviderType

    extern const std::map<
        ServerCapabilities_workspaceSymbolProviderType,
        std::string
    > ServerCapabilities_workspaceSymbolProviderTypeNames;

    class ServerCapabilities_workspaceSymbolProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_workspaceSymbolProvider();
        ServerCapabilities_workspaceSymbolProvider(
            ServerCapabilities_workspaceSymbolProvider &&other
        );
        ServerCapabilities_workspaceSymbolProvider(
            const ServerCapabilities_workspaceSymbolProvider &other
        );
        ~ServerCapabilities_workspaceSymbolProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_workspaceSymbolProvider &&other
        ) -> ServerCapabilities_workspaceSymbolProvider &;

        auto operator=(
            const ServerCapabilities_workspaceSymbolProvider &other
        ) -> ServerCapabilities_workspaceSymbolProvider &;

        auto type() const
        -> const ServerCapabilities_workspaceSymbolProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_workspaceSymbolProvider &;

        auto workspaceSymbolOptions() const -> const WorkspaceSymbolOptions &;

        auto operator=(
            const std::unique_ptr<WorkspaceSymbolOptions> &workspaceSymbolOptions
        ) -> ServerCapabilities_workspaceSymbolProvider &;

        auto operator=(
            std::unique_ptr<WorkspaceSymbolOptions> &&workspaceSymbolOptions
        ) -> ServerCapabilities_workspaceSymbolProvider &;

        auto operator=(
            const WorkspaceSymbolOptions &workspaceSymbolOptions
        ) -> ServerCapabilities_workspaceSymbolProvider &;

        auto operator=(
            WorkspaceSymbolOptions &&workspaceSymbolOptions
        ) -> ServerCapabilities_workspaceSymbolProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_workspaceSymbolProviderType _type{
            ServerCapabilities_workspaceSymbolProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<WorkspaceSymbolOptions> _workspaceSymbolOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_workspaceSymbolProvider

    /**
     * Code Lens provider options of a {@link CodeLensRequest}.
     */
    struct CodeLensOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeLensOptions();
        CodeLensOptions(CodeLensOptions &&other);
        CodeLensOptions(const CodeLensOptions &other);
        ~CodeLensOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CodeLensOptions &&other) -> CodeLensOptions &;

        auto operator=(const CodeLensOptions &other) -> CodeLensOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * Code lens has a resolve provider as well.
         */
        std::optional<boolean_t> resolveProvider;
    }; // struct CodeLensOptions

    /**
     * Provider options for a {@link DocumentLinkRequest}.
     */
    struct DocumentLinkOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentLinkOptions();
        DocumentLinkOptions(DocumentLinkOptions &&other);
        DocumentLinkOptions(const DocumentLinkOptions &other);
        ~DocumentLinkOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DocumentLinkOptions &&other) -> DocumentLinkOptions &;

        auto operator=(
            const DocumentLinkOptions &other
        ) -> DocumentLinkOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * Document links have a resolve provider as well.
         */
        std::optional<boolean_t> resolveProvider;
    }; // struct DocumentLinkOptions

    /**
     * Provider options for a {@link DocumentFormattingRequest}.
     */
    struct DocumentFormattingOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentFormattingOptions();
        DocumentFormattingOptions(DocumentFormattingOptions &&other);
        DocumentFormattingOptions(const DocumentFormattingOptions &other);
        ~DocumentFormattingOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentFormattingOptions &&other
        ) -> DocumentFormattingOptions &;

        auto operator=(
            const DocumentFormattingOptions &other
        ) -> DocumentFormattingOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
    }; // struct DocumentFormattingOptions

    enum class ServerCapabilities_documentFormattingProviderType {
        Uninitialized = -1,
        Boolean = 0,
        DocumentFormattingOptions = 1,
    }; // enum class ServerCapabilities_documentFormattingProviderType

    extern const std::map<
        ServerCapabilities_documentFormattingProviderType,
        std::string
    > ServerCapabilities_documentFormattingProviderTypeNames;

    class ServerCapabilities_documentFormattingProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_documentFormattingProvider();
        ServerCapabilities_documentFormattingProvider(
            ServerCapabilities_documentFormattingProvider &&other
        );
        ServerCapabilities_documentFormattingProvider(
            const ServerCapabilities_documentFormattingProvider &other
        );
        ~ServerCapabilities_documentFormattingProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_documentFormattingProvider &&other
        ) -> ServerCapabilities_documentFormattingProvider &;

        auto operator=(
            const ServerCapabilities_documentFormattingProvider &other
        ) -> ServerCapabilities_documentFormattingProvider &;

        auto type() const
        -> const ServerCapabilities_documentFormattingProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_documentFormattingProvider &;

        auto documentFormattingOptions() const
        -> const DocumentFormattingOptions &;

        auto operator=(
            const std::unique_ptr<DocumentFormattingOptions> &documentFormattingOptions
        ) -> ServerCapabilities_documentFormattingProvider &;

        auto operator=(
            std::unique_ptr<DocumentFormattingOptions> &&documentFormattingOptions
        ) -> ServerCapabilities_documentFormattingProvider &;

        auto operator=(
            const DocumentFormattingOptions &documentFormattingOptions
        ) -> ServerCapabilities_documentFormattingProvider &;

        auto operator=(
            DocumentFormattingOptions &&documentFormattingOptions
        ) -> ServerCapabilities_documentFormattingProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_documentFormattingProviderType _type{
            ServerCapabilities_documentFormattingProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<DocumentFormattingOptions> _documentFormattingOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_documentFormattingProvider

    /**
     * Provider options for a {@link DocumentRangeFormattingRequest}.
     */
    struct DocumentRangeFormattingOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentRangeFormattingOptions();
        DocumentRangeFormattingOptions(DocumentRangeFormattingOptions &&other);
        DocumentRangeFormattingOptions(
            const DocumentRangeFormattingOptions &other
        );
        ~DocumentRangeFormattingOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentRangeFormattingOptions &&other
        ) -> DocumentRangeFormattingOptions &;

        auto operator=(
            const DocumentRangeFormattingOptions &other
        ) -> DocumentRangeFormattingOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * Whether the server supports formatting multiple ranges at once.
         *
         * @since 3.18.0
         * @proposed
         */
        std::optional<boolean_t> rangesSupport;
    }; // struct DocumentRangeFormattingOptions

    enum class ServerCapabilities_documentRangeFormattingProviderType {
        Uninitialized = -1,
        Boolean = 0,
        DocumentRangeFormattingOptions = 1,
    }; // enum class ServerCapabilities_documentRangeFormattingProviderType

    extern const std::map<
        ServerCapabilities_documentRangeFormattingProviderType,
        std::string
    > ServerCapabilities_documentRangeFormattingProviderTypeNames;

    class ServerCapabilities_documentRangeFormattingProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_documentRangeFormattingProvider();
        ServerCapabilities_documentRangeFormattingProvider(
            ServerCapabilities_documentRangeFormattingProvider &&other
        );
        ServerCapabilities_documentRangeFormattingProvider(
            const ServerCapabilities_documentRangeFormattingProvider &other
        );
        ~ServerCapabilities_documentRangeFormattingProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_documentRangeFormattingProvider &&other
        ) -> ServerCapabilities_documentRangeFormattingProvider &;

        auto operator=(
            const ServerCapabilities_documentRangeFormattingProvider &other
        ) -> ServerCapabilities_documentRangeFormattingProvider &;

        auto type() const
        -> const ServerCapabilities_documentRangeFormattingProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_documentRangeFormattingProvider &;

        auto documentRangeFormattingOptions() const
        -> const DocumentRangeFormattingOptions &;

        auto operator=(
            const std::unique_ptr<DocumentRangeFormattingOptions> &documentRangeFormattingOptions
        ) -> ServerCapabilities_documentRangeFormattingProvider &;

        auto operator=(
            std::unique_ptr<DocumentRangeFormattingOptions> &&documentRangeFormattingOptions
        ) -> ServerCapabilities_documentRangeFormattingProvider &;

        auto operator=(
            const DocumentRangeFormattingOptions &documentRangeFormattingOptions
        ) -> ServerCapabilities_documentRangeFormattingProvider &;

        auto operator=(
            DocumentRangeFormattingOptions &&documentRangeFormattingOptions
        ) -> ServerCapabilities_documentRangeFormattingProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_documentRangeFormattingProviderType _type{
            ServerCapabilities_documentRangeFormattingProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<DocumentRangeFormattingOptions> _documentRangeFormattingOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_documentRangeFormattingProvider

    /**
     * Provider options for a {@link RenameRequest}.
     */
    struct RenameOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RenameOptions();
        RenameOptions(RenameOptions &&other);
        RenameOptions(const RenameOptions &other);
        ~RenameOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(RenameOptions &&other) -> RenameOptions &;

        auto operator=(const RenameOptions &other) -> RenameOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * Renames should be checked and tested before being executed.
         *
         * @since version 3.12.0
         */
        std::optional<boolean_t> prepareProvider;
    }; // struct RenameOptions

    enum class ServerCapabilities_renameProviderType {
        Uninitialized = -1,
        Boolean = 0,
        RenameOptions = 1,
    }; // enum class ServerCapabilities_renameProviderType

    extern const std::map<ServerCapabilities_renameProviderType, std::string>
        ServerCapabilities_renameProviderTypeNames;

    class ServerCapabilities_renameProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_renameProvider();
        ServerCapabilities_renameProvider(
            ServerCapabilities_renameProvider &&other
        );
        ServerCapabilities_renameProvider(
            const ServerCapabilities_renameProvider &other
        );
        ~ServerCapabilities_renameProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_renameProvider &&other
        ) -> ServerCapabilities_renameProvider &;

        auto operator=(
            const ServerCapabilities_renameProvider &other
        ) -> ServerCapabilities_renameProvider &;

        auto type() const -> const ServerCapabilities_renameProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_renameProvider &;

        auto renameOptions() const -> const RenameOptions &;

        auto operator=(
            const std::unique_ptr<RenameOptions> &renameOptions
        ) -> ServerCapabilities_renameProvider &;

        auto operator=(
            std::unique_ptr<RenameOptions> &&renameOptions
        ) -> ServerCapabilities_renameProvider &;

        auto operator=(
            const RenameOptions &renameOptions
        ) -> ServerCapabilities_renameProvider &;

        auto operator=(
            RenameOptions &&renameOptions
        ) -> ServerCapabilities_renameProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_renameProviderType _type{
            ServerCapabilities_renameProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<RenameOptions> _renameOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_renameProvider

    /**
     * The server capabilities of a {@link ExecuteCommandRequest}.
     */
    struct ExecuteCommandOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ExecuteCommandOptions();
        ExecuteCommandOptions(ExecuteCommandOptions &&other);
        ExecuteCommandOptions(const ExecuteCommandOptions &other);
        ~ExecuteCommandOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ExecuteCommandOptions &&other
        ) -> ExecuteCommandOptions &;

        auto operator=(
            const ExecuteCommandOptions &other
        ) -> ExecuteCommandOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * The commands to be executed on the server
         */
        std::vector<string_t> commands;
    }; // struct ExecuteCommandOptions

    /**
     * Registration options for a {@link ExecuteCommandRequest}.
     */
    struct ExecuteCommandRegistrationOptions
        : public ExecuteCommandOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ExecuteCommandRegistrationOptions();
        ExecuteCommandRegistrationOptions(
            ExecuteCommandRegistrationOptions &&other
        );
        ExecuteCommandRegistrationOptions(
            const ExecuteCommandRegistrationOptions &other
        );
        ~ExecuteCommandRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ExecuteCommandRegistrationOptions &&other
        ) -> ExecuteCommandRegistrationOptions &;

        auto operator=(
            const ExecuteCommandRegistrationOptions &other
        ) -> ExecuteCommandRegistrationOptions &;
    }; // struct ExecuteCommandRegistrationOptions

    /**
     * Options to create a file.
     */
    struct CreateFileOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CreateFileOptions();
        CreateFileOptions(CreateFileOptions &&other);
        CreateFileOptions(const CreateFileOptions &other);
        ~CreateFileOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CreateFileOptions &&other) -> CreateFileOptions &;

        auto operator=(const CreateFileOptions &other) -> CreateFileOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Overwrite existing file. Overwrite wins over `ignoreIfExists`
         */
        std::optional<boolean_t> overwrite;
        /**
         * Ignore if exists.
         */
        std::optional<boolean_t> ignoreIfExists;
    }; // struct CreateFileOptions

    /**
     * Create file operation.
     */
    struct CreateFile
        : public ResourceOperation
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CreateFile();
        CreateFile(CreateFile &&other);
        CreateFile(const CreateFile &other);
        ~CreateFile();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CreateFile &&other) -> CreateFile &;

        auto operator=(const CreateFile &other) -> CreateFile &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A create
         */
        string_t kind;
        /**
         * The resource to create.
         */
        DocumentUri uri;
        /**
         * Additional options
         */
        std::optional<CreateFileOptions> options;
    }; // struct CreateFile

    /**
     * Rename file options
     */
    struct RenameFileOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RenameFileOptions();
        RenameFileOptions(RenameFileOptions &&other);
        RenameFileOptions(const RenameFileOptions &other);
        ~RenameFileOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(RenameFileOptions &&other) -> RenameFileOptions &;

        auto operator=(const RenameFileOptions &other) -> RenameFileOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Overwrite target if existing. Overwrite wins over `ignoreIfExists`
         */
        std::optional<boolean_t> overwrite;
        /**
         * Ignores if target exists.
         */
        std::optional<boolean_t> ignoreIfExists;
    }; // struct RenameFileOptions

    /**
     * Rename file operation
     */
    struct RenameFile
        : public ResourceOperation
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RenameFile();
        RenameFile(RenameFile &&other);
        RenameFile(const RenameFile &other);
        ~RenameFile();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(RenameFile &&other) -> RenameFile &;

        auto operator=(const RenameFile &other) -> RenameFile &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A rename
         */
        string_t kind;
        /**
         * The old (existing) location.
         */
        DocumentUri oldUri;
        /**
         * The new location.
         */
        DocumentUri newUri;
        /**
         * Rename options.
         */
        std::optional<RenameFileOptions> options;
    }; // struct RenameFile

    /**
     * Delete file options
     */
    struct DeleteFileOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DeleteFileOptions();
        DeleteFileOptions(DeleteFileOptions &&other);
        DeleteFileOptions(const DeleteFileOptions &other);
        ~DeleteFileOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DeleteFileOptions &&other) -> DeleteFileOptions &;

        auto operator=(const DeleteFileOptions &other) -> DeleteFileOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Delete the content recursively if a folder is denoted.
         */
        std::optional<boolean_t> recursive;
        /**
         * Ignore the operation if the file doesn't exist.
         */
        std::optional<boolean_t> ignoreIfNotExists;
    }; // struct DeleteFileOptions

    /**
     * Delete file operation
     */
    struct DeleteFile
        : public ResourceOperation
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DeleteFile();
        DeleteFile(DeleteFile &&other);
        DeleteFile(const DeleteFile &other);
        ~DeleteFile();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DeleteFile &&other) -> DeleteFile &;

        auto operator=(const DeleteFile &other) -> DeleteFile &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A delete
         */
        string_t kind;
        /**
         * The file to delete.
         */
        DocumentUri uri;
        /**
         * Delete options.
         */
        std::optional<DeleteFileOptions> options;
    }; // struct DeleteFile

    enum class TextDocumentSyncOptions_saveType {
        Uninitialized = -1,
        Boolean = 0,
        SaveOptions = 1,
    }; // enum class TextDocumentSyncOptions_saveType

    extern const std::map<TextDocumentSyncOptions_saveType, std::string>
        TextDocumentSyncOptions_saveTypeNames;

    class TextDocumentSyncOptions_save {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentSyncOptions_save();
        TextDocumentSyncOptions_save(TextDocumentSyncOptions_save &&other);
        TextDocumentSyncOptions_save(
            const TextDocumentSyncOptions_save &other
        );
        ~TextDocumentSyncOptions_save();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentSyncOptions_save &&other
        ) -> TextDocumentSyncOptions_save &;

        auto operator=(
            const TextDocumentSyncOptions_save &other
        ) -> TextDocumentSyncOptions_save &;

        auto type() const -> const TextDocumentSyncOptions_saveType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(boolean_t boolean) -> TextDocumentSyncOptions_save &;

        auto saveOptions() const -> const SaveOptions &;

        auto operator=(
            const std::unique_ptr<SaveOptions> &saveOptions
        ) -> TextDocumentSyncOptions_save &;

        auto operator=(
            std::unique_ptr<SaveOptions> &&saveOptions
        ) -> TextDocumentSyncOptions_save &;

        auto operator=(
            const SaveOptions &saveOptions
        ) -> TextDocumentSyncOptions_save &;

        auto operator=(
            SaveOptions &&saveOptions
        ) -> TextDocumentSyncOptions_save &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocumentSyncOptions_saveType _type{
            TextDocumentSyncOptions_saveType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<SaveOptions> _saveOptions;
        };

        auto reset() -> void;
    }; // class TextDocumentSyncOptions_save

    struct TextDocumentSyncOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentSyncOptions();
        TextDocumentSyncOptions(TextDocumentSyncOptions &&other);
        TextDocumentSyncOptions(const TextDocumentSyncOptions &other);
        ~TextDocumentSyncOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentSyncOptions &&other
        ) -> TextDocumentSyncOptions &;

        auto operator=(
            const TextDocumentSyncOptions &other
        ) -> TextDocumentSyncOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Open and close notifications are sent to the server. If omitted open close notification should not
         * be sent.
         */
        std::optional<boolean_t> openClose;
        /**
         * Change notifications are sent to the server. See TextDocumentSyncKind.None, TextDocumentSyncKind.Full
         * and TextDocumentSyncKind.Incremental. If omitted it defaults to TextDocumentSyncKind.None.
         */
        std::optional<TextDocumentSyncKind> change;
        /**
         * If present will save notifications are sent to the server. If omitted the notification should not be
         * sent.
         */
        std::optional<boolean_t> willSave;
        /**
         * If present will save wait until requests are sent to the server. If omitted the request should not be
         * sent.
         */
        std::optional<boolean_t> willSaveWaitUntil;
        /**
         * If present save notifications are sent to the server. If omitted the notification should not be
         * sent.
         */
        std::optional<TextDocumentSyncOptions_save> save;
    }; // struct TextDocumentSyncOptions

    enum class ServerCapabilities_textDocumentSyncType {
        Uninitialized = -1,
        TextDocumentSyncOptions = 0,
        TextDocumentSyncKind = 1,
    }; // enum class ServerCapabilities_textDocumentSyncType

    extern const std::map<ServerCapabilities_textDocumentSyncType, std::string>
        ServerCapabilities_textDocumentSyncTypeNames;

    class ServerCapabilities_textDocumentSync {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_textDocumentSync();
        ServerCapabilities_textDocumentSync(
            ServerCapabilities_textDocumentSync &&other
        );
        ServerCapabilities_textDocumentSync(
            const ServerCapabilities_textDocumentSync &other
        );
        ~ServerCapabilities_textDocumentSync();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_textDocumentSync &&other
        ) -> ServerCapabilities_textDocumentSync &;

        auto operator=(
            const ServerCapabilities_textDocumentSync &other
        ) -> ServerCapabilities_textDocumentSync &;

        auto type() const -> const ServerCapabilities_textDocumentSyncType &;

        auto textDocumentSyncOptions() const
        -> const TextDocumentSyncOptions &;

        auto operator=(
            const std::unique_ptr<TextDocumentSyncOptions> &textDocumentSyncOptions
        ) -> ServerCapabilities_textDocumentSync &;

        auto operator=(
            std::unique_ptr<TextDocumentSyncOptions> &&textDocumentSyncOptions
        ) -> ServerCapabilities_textDocumentSync &;

        auto operator=(
            const TextDocumentSyncOptions &textDocumentSyncOptions
        ) -> ServerCapabilities_textDocumentSync &;

        auto operator=(
            TextDocumentSyncOptions &&textDocumentSyncOptions
        ) -> ServerCapabilities_textDocumentSync &;

        auto textDocumentSyncKind() const -> const TextDocumentSyncKind &;

        auto operator=(
            TextDocumentSyncKind textDocumentSyncKind
        ) -> ServerCapabilities_textDocumentSync &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_textDocumentSyncType _type{
            ServerCapabilities_textDocumentSyncType::Uninitialized
        };

        union {
            std::unique_ptr<TextDocumentSyncOptions> _textDocumentSyncOptions;
            TextDocumentSyncKind _textDocumentSyncKind;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_textDocumentSync

    /**
     * Options specific to a notebook plus its cells
     * to be synced to the server.
     *
     * If a selector provides a notebook document
     * filter but no cell selector all cells of a
     * matching notebook document will be synced.
     *
     * If a selector provides no notebook document
     * filter but only a cell selector all notebook
     * document that contain at least one matching
     * cell will be synced.
     *
     * @since 3.17.0
     */
    struct NotebookDocumentSyncOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentSyncOptions();
        NotebookDocumentSyncOptions(NotebookDocumentSyncOptions &&other);
        NotebookDocumentSyncOptions(const NotebookDocumentSyncOptions &other);
        ~NotebookDocumentSyncOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentSyncOptions &&other
        ) -> NotebookDocumentSyncOptions &;

        auto operator=(
            const NotebookDocumentSyncOptions &other
        ) -> NotebookDocumentSyncOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The notebooks to be synced
         */
        std::vector<NotebookDocumentSyncOptions_notebookSelector_elem>
            notebookSelector;
        /**
         * Whether save notification should be forwarded to
         * the server. Will only be honored if mode === `notebook`.
         */
        std::optional<boolean_t> save;
    }; // struct NotebookDocumentSyncOptions

    /**
     * Registration options specific to a notebook.
     *
     * @since 3.17.0
     */
    struct NotebookDocumentSyncRegistrationOptions
        : public NotebookDocumentSyncOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentSyncRegistrationOptions();
        NotebookDocumentSyncRegistrationOptions(
            NotebookDocumentSyncRegistrationOptions &&other
        );
        NotebookDocumentSyncRegistrationOptions(
            const NotebookDocumentSyncRegistrationOptions &other
        );
        ~NotebookDocumentSyncRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentSyncRegistrationOptions &&other
        ) -> NotebookDocumentSyncRegistrationOptions &;

        auto operator=(
            const NotebookDocumentSyncRegistrationOptions &other
        ) -> NotebookDocumentSyncRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct NotebookDocumentSyncRegistrationOptions

    enum class ServerCapabilities_notebookDocumentSyncType {
        Uninitialized = -1,
        NotebookDocumentSyncOptions = 0,
        NotebookDocumentSyncRegistrationOptions = 1,
    }; // enum class ServerCapabilities_notebookDocumentSyncType

    extern const std::map<
        ServerCapabilities_notebookDocumentSyncType,
        std::string
    > ServerCapabilities_notebookDocumentSyncTypeNames;

    class ServerCapabilities_notebookDocumentSync {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_notebookDocumentSync();
        ServerCapabilities_notebookDocumentSync(
            ServerCapabilities_notebookDocumentSync &&other
        );
        ServerCapabilities_notebookDocumentSync(
            const ServerCapabilities_notebookDocumentSync &other
        );
        ~ServerCapabilities_notebookDocumentSync();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_notebookDocumentSync &&other
        ) -> ServerCapabilities_notebookDocumentSync &;

        auto operator=(
            const ServerCapabilities_notebookDocumentSync &other
        ) -> ServerCapabilities_notebookDocumentSync &;

        auto type() const
        -> const ServerCapabilities_notebookDocumentSyncType &;

        auto notebookDocumentSyncOptions() const
        -> const NotebookDocumentSyncOptions &;

        auto operator=(
            const std::unique_ptr<NotebookDocumentSyncOptions> &notebookDocumentSyncOptions
        ) -> ServerCapabilities_notebookDocumentSync &;

        auto operator=(
            std::unique_ptr<NotebookDocumentSyncOptions> &&notebookDocumentSyncOptions
        ) -> ServerCapabilities_notebookDocumentSync &;

        auto operator=(
            const NotebookDocumentSyncOptions &notebookDocumentSyncOptions
        ) -> ServerCapabilities_notebookDocumentSync &;

        auto operator=(
            NotebookDocumentSyncOptions &&notebookDocumentSyncOptions
        ) -> ServerCapabilities_notebookDocumentSync &;

        auto notebookDocumentSyncRegistrationOptions() const
        -> const NotebookDocumentSyncRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<NotebookDocumentSyncRegistrationOptions> &notebookDocumentSyncRegistrationOptions
        ) -> ServerCapabilities_notebookDocumentSync &;

        auto operator=(
            std::unique_ptr<NotebookDocumentSyncRegistrationOptions> &&notebookDocumentSyncRegistrationOptions
        ) -> ServerCapabilities_notebookDocumentSync &;

        auto operator=(
            const NotebookDocumentSyncRegistrationOptions &notebookDocumentSyncRegistrationOptions
        ) -> ServerCapabilities_notebookDocumentSync &;

        auto operator=(
            NotebookDocumentSyncRegistrationOptions &&notebookDocumentSyncRegistrationOptions
        ) -> ServerCapabilities_notebookDocumentSync &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_notebookDocumentSyncType _type{
            ServerCapabilities_notebookDocumentSyncType::Uninitialized
        };

        union {
            std::unique_ptr<NotebookDocumentSyncOptions> _notebookDocumentSyncOptions;
            std::unique_ptr<NotebookDocumentSyncRegistrationOptions> _notebookDocumentSyncRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_notebookDocumentSync

    enum class WorkspaceFoldersServerCapabilities_changeNotificationsType {
        Uninitialized = -1,
        String = 0,
        Boolean = 1,
    }; // enum class WorkspaceFoldersServerCapabilities_changeNotificationsType

    extern const std::map<
        WorkspaceFoldersServerCapabilities_changeNotificationsType,
        std::string
    > WorkspaceFoldersServerCapabilities_changeNotificationsTypeNames;

    class WorkspaceFoldersServerCapabilities_changeNotifications {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceFoldersServerCapabilities_changeNotifications();
        WorkspaceFoldersServerCapabilities_changeNotifications(
            WorkspaceFoldersServerCapabilities_changeNotifications &&other
        );
        WorkspaceFoldersServerCapabilities_changeNotifications(
            const WorkspaceFoldersServerCapabilities_changeNotifications &other
        );
        ~WorkspaceFoldersServerCapabilities_changeNotifications();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceFoldersServerCapabilities_changeNotifications &&other
        ) -> WorkspaceFoldersServerCapabilities_changeNotifications &;

        auto operator=(
            const WorkspaceFoldersServerCapabilities_changeNotifications &other
        ) -> WorkspaceFoldersServerCapabilities_changeNotifications &;

        auto type() const
        -> const WorkspaceFoldersServerCapabilities_changeNotificationsType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> WorkspaceFoldersServerCapabilities_changeNotifications &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> WorkspaceFoldersServerCapabilities_changeNotifications &;

        auto operator=(
            const string_t &string
        ) -> WorkspaceFoldersServerCapabilities_changeNotifications &;

        auto operator=(
            string_t &&string
        ) -> WorkspaceFoldersServerCapabilities_changeNotifications &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> WorkspaceFoldersServerCapabilities_changeNotifications &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        WorkspaceFoldersServerCapabilities_changeNotificationsType _type{
            WorkspaceFoldersServerCapabilities_changeNotificationsType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            boolean_t _boolean;
        };

        auto reset() -> void;
    }; // class WorkspaceFoldersServerCapabilities_changeNotifications

    struct WorkspaceFoldersServerCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceFoldersServerCapabilities();
        WorkspaceFoldersServerCapabilities(
            WorkspaceFoldersServerCapabilities &&other
        );
        WorkspaceFoldersServerCapabilities(
            const WorkspaceFoldersServerCapabilities &other
        );
        ~WorkspaceFoldersServerCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceFoldersServerCapabilities &&other
        ) -> WorkspaceFoldersServerCapabilities &;

        auto operator=(
            const WorkspaceFoldersServerCapabilities &other
        ) -> WorkspaceFoldersServerCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The server has support for workspace folders
         */
        std::optional<boolean_t> supported;
        /**
         * Whether the server wants to receive workspace folder
         * change notifications.
         *
         * If a string is provided the string is treated as an ID
         * under which the notification is registered on the client
         * side. The ID can be used to unregister for these events
         * using the `client/unregisterCapability` request.
         */
        std::optional<WorkspaceFoldersServerCapabilities_changeNotifications>
            changeNotifications;
    }; // struct WorkspaceFoldersServerCapabilities

    /**
     * Matching options for the file operation pattern.
     *
     * @since 3.16.0
     */
    struct FileOperationPatternOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FileOperationPatternOptions();
        FileOperationPatternOptions(FileOperationPatternOptions &&other);
        FileOperationPatternOptions(const FileOperationPatternOptions &other);
        ~FileOperationPatternOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            FileOperationPatternOptions &&other
        ) -> FileOperationPatternOptions &;

        auto operator=(
            const FileOperationPatternOptions &other
        ) -> FileOperationPatternOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The pattern should be matched ignoring casing.
         */
        std::optional<boolean_t> ignoreCase;
    }; // struct FileOperationPatternOptions

    /**
     * A pattern to describe in which file operation requests or notifications
     * the server is interested in receiving.
     *
     * @since 3.16.0
     */
    struct FileOperationPattern {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FileOperationPattern();
        FileOperationPattern(FileOperationPattern &&other);
        FileOperationPattern(const FileOperationPattern &other);
        ~FileOperationPattern();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FileOperationPattern &&other) -> FileOperationPattern &;

        auto operator=(
            const FileOperationPattern &other
        ) -> FileOperationPattern &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The glob pattern to match. Glob patterns can have the following syntax:
         * - `*` to match one or more characters in a path segment
         * - `?` to match on one character in a path segment
         * - `**` to match any number of path segments, including none
         * - `{}` to group sub patterns into an OR expression. (e.g. `**{@literal /}*.{ts,js}` matches all TypeScript and JavaScript files)
         * - `[]` to declare a range of characters to match in a path segment (e.g., `example.[0-9]` to match on `example.0`, `example.1`, …)
         * - `[!...]` to negate a range of characters to match in a path segment (e.g., `example.[!0-9]` to match on `example.a`, `example.b`, but not `example.0`)
         */
        string_t glob;
        /**
         * Whether to match files or folders with this pattern.
         *
         * Matches both if undefined.
         */
        std::optional<FileOperationPatternKind> matches;
        /**
         * Additional options used during matching.
         */
        std::optional<FileOperationPatternOptions> options;
    }; // struct FileOperationPattern

    /**
     * A filter to describe in which file operation requests or notifications
     * the server is interested in receiving.
     *
     * @since 3.16.0
     */
    struct FileOperationFilter {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FileOperationFilter();
        FileOperationFilter(FileOperationFilter &&other);
        FileOperationFilter(const FileOperationFilter &other);
        ~FileOperationFilter();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FileOperationFilter &&other) -> FileOperationFilter &;

        auto operator=(
            const FileOperationFilter &other
        ) -> FileOperationFilter &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A Uri scheme like `file` or `untitled`.
         */
        std::optional<string_t> scheme;
        /**
         * The actual file operation pattern.
         */
        FileOperationPattern pattern;
    }; // struct FileOperationFilter

    /**
     * The options to register for file operations.
     *
     * @since 3.16.0
     */
    struct FileOperationRegistrationOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FileOperationRegistrationOptions();
        FileOperationRegistrationOptions(
            FileOperationRegistrationOptions &&other
        );
        FileOperationRegistrationOptions(
            const FileOperationRegistrationOptions &other
        );
        ~FileOperationRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            FileOperationRegistrationOptions &&other
        ) -> FileOperationRegistrationOptions &;

        auto operator=(
            const FileOperationRegistrationOptions &other
        ) -> FileOperationRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The actual filters.
         */
        std::vector<FileOperationFilter> filters;
    }; // struct FileOperationRegistrationOptions

    typedef std::vector<FileOperationFilter> FileOperationRegistrationOptions_filters;

    /**
     * Options for notifications/requests for user operations on files.
     *
     * @since 3.16.0
     */
    struct FileOperationOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FileOperationOptions();
        FileOperationOptions(FileOperationOptions &&other);
        FileOperationOptions(const FileOperationOptions &other);
        ~FileOperationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FileOperationOptions &&other) -> FileOperationOptions &;

        auto operator=(
            const FileOperationOptions &other
        ) -> FileOperationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The server is interested in receiving didCreateFiles notifications.
         */
        std::optional<FileOperationRegistrationOptions> didCreate;
        /**
         * The server is interested in receiving willCreateFiles requests.
         */
        std::optional<FileOperationRegistrationOptions> willCreate;
        /**
         * The server is interested in receiving didRenameFiles notifications.
         */
        std::optional<FileOperationRegistrationOptions> didRename;
        /**
         * The server is interested in receiving willRenameFiles requests.
         */
        std::optional<FileOperationRegistrationOptions> willRename;
        /**
         * The server is interested in receiving didDeleteFiles file notifications.
         */
        std::optional<FileOperationRegistrationOptions> didDelete;
        /**
         * The server is interested in receiving willDeleteFiles file requests.
         */
        std::optional<FileOperationRegistrationOptions> willDelete;
    }; // struct FileOperationOptions

    struct ServerCapabilities_workspace {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_workspace();
        ServerCapabilities_workspace(ServerCapabilities_workspace &&other);
        ServerCapabilities_workspace(
            const ServerCapabilities_workspace &other
        );
        ~ServerCapabilities_workspace();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_workspace &&other
        ) -> ServerCapabilities_workspace &;

        auto operator=(
            const ServerCapabilities_workspace &other
        ) -> ServerCapabilities_workspace &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The server supports workspace folder.
         *
         * @since 3.6.0
         */
        std::optional<WorkspaceFoldersServerCapabilities> workspaceFolders;
        /**
         * The server is interested in notifications/requests for operations on files.
         *
         * @since 3.16.0
         */
        std::optional<FileOperationOptions> fileOperations;
    }; // struct ServerCapabilities_workspace

    struct GeneralClientCapabilities_staleRequestSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        GeneralClientCapabilities_staleRequestSupport();
        GeneralClientCapabilities_staleRequestSupport(
            GeneralClientCapabilities_staleRequestSupport &&other
        );
        GeneralClientCapabilities_staleRequestSupport(
            const GeneralClientCapabilities_staleRequestSupport &other
        );
        ~GeneralClientCapabilities_staleRequestSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            GeneralClientCapabilities_staleRequestSupport &&other
        ) -> GeneralClientCapabilities_staleRequestSupport &;

        auto operator=(
            const GeneralClientCapabilities_staleRequestSupport &other
        ) -> GeneralClientCapabilities_staleRequestSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The client will actively cancel the request.
         */
        boolean_t cancel;
        /**
         * The list of requests for which the client
         * will retry the request if it receives a
         * response with error code `ContentModified`
         */
        std::vector<string_t> retryOnContentModified;
    }; // struct GeneralClientCapabilities_staleRequestSupport

    /**
     * General client capabilities.
     *
     * @since 3.16.0
     */
    struct GeneralClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        GeneralClientCapabilities();
        GeneralClientCapabilities(GeneralClientCapabilities &&other);
        GeneralClientCapabilities(const GeneralClientCapabilities &other);
        ~GeneralClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            GeneralClientCapabilities &&other
        ) -> GeneralClientCapabilities &;

        auto operator=(
            const GeneralClientCapabilities &other
        ) -> GeneralClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Client capability that signals how the client
         * handles stale requests (e.g. a request
         * for which the client will not process the response
         * anymore since the information is outdated).
         *
         * @since 3.17.0
         */
        std::optional<GeneralClientCapabilities_staleRequestSupport>
            staleRequestSupport;
        /**
         * Client capabilities specific to regular expressions.
         *
         * @since 3.16.0
         */
        std::optional<RegularExpressionsClientCapabilities> regularExpressions;
        /**
         * Client capabilities specific to the client's markdown parser.
         *
         * @since 3.16.0
         */
        std::optional<MarkdownClientCapabilities> markdown;
        /**
         * The position encodings supported by the client. Client and server
         * have to agree on the same position encoding to ensure that offsets
         * (e.g. character position in a line) are interpreted the same on both
         * sides.
         *
         * To keep the protocol backwards compatible the following applies: if
         * the value 'utf-16' is missing from the array of position encodings
         * servers can assume that the client supports UTF-16. UTF-16 is
         * therefore a mandatory encoding.
         *
         * If omitted it defaults to ['utf-16'].
         *
         * Implementation considerations: since the conversion from one encoding
         * into another requires the content of the file / line the conversion
         * is best done where the file is read which is usually on the server
         * side.
         *
         * @since 3.17.0
         */
        std::optional<std::vector<PositionEncodingKind>> positionEncodings;
    }; // struct GeneralClientCapabilities

    struct WorkspaceEditClientCapabilities_changeAnnotationSupport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceEditClientCapabilities_changeAnnotationSupport();
        WorkspaceEditClientCapabilities_changeAnnotationSupport(
            WorkspaceEditClientCapabilities_changeAnnotationSupport &&other
        );
        WorkspaceEditClientCapabilities_changeAnnotationSupport(
            const WorkspaceEditClientCapabilities_changeAnnotationSupport &other
        );
        ~WorkspaceEditClientCapabilities_changeAnnotationSupport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceEditClientCapabilities_changeAnnotationSupport &&other
        ) -> WorkspaceEditClientCapabilities_changeAnnotationSupport &;

        auto operator=(
            const WorkspaceEditClientCapabilities_changeAnnotationSupport &other
        ) -> WorkspaceEditClientCapabilities_changeAnnotationSupport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether the client groups edits with equal labels into tree nodes,
         * for instance all edits labelled with "Changes in Strings" would
         * be a tree node.
         */
        std::optional<boolean_t> groupsOnLabel;
    }; // struct WorkspaceEditClientCapabilities_changeAnnotationSupport

    struct WorkspaceEditClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceEditClientCapabilities();
        WorkspaceEditClientCapabilities(
            WorkspaceEditClientCapabilities &&other
        );
        WorkspaceEditClientCapabilities(
            const WorkspaceEditClientCapabilities &other
        );
        ~WorkspaceEditClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceEditClientCapabilities &&other
        ) -> WorkspaceEditClientCapabilities &;

        auto operator=(
            const WorkspaceEditClientCapabilities &other
        ) -> WorkspaceEditClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The client supports versioned document changes in `WorkspaceEdit`s
         */
        std::optional<boolean_t> documentChanges;
        /**
         * The resource operations the client supports. Clients should at least
         * support 'create', 'rename' and 'delete' files and folders.
         *
         * @since 3.13.0
         */
        std::optional<std::vector<ResourceOperationKind>> resourceOperations;
        /**
         * The failure handling strategy of a client if applying the workspace edit
         * fails.
         *
         * @since 3.13.0
         */
        std::optional<FailureHandlingKind> failureHandling;
        /**
         * Whether the client normalizes line endings to the client specific
         * setting.
         * If set to `true` the client will normalize line ending characters
         * in a workspace edit to the client-specified new line
         * character.
         *
         * @since 3.16.0
         */
        std::optional<boolean_t> normalizesLineEndings;
        /**
         * Whether the client in general supports change annotations on text edits,
         * create file, rename file and delete file changes.
         *
         * @since 3.16.0
         */
        std::optional<WorkspaceEditClientCapabilities_changeAnnotationSupport>
            changeAnnotationSupport;
    }; // struct WorkspaceEditClientCapabilities

    struct DidChangeConfigurationClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidChangeConfigurationClientCapabilities();
        DidChangeConfigurationClientCapabilities(
            DidChangeConfigurationClientCapabilities &&other
        );
        DidChangeConfigurationClientCapabilities(
            const DidChangeConfigurationClientCapabilities &other
        );
        ~DidChangeConfigurationClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidChangeConfigurationClientCapabilities &&other
        ) -> DidChangeConfigurationClientCapabilities &;

        auto operator=(
            const DidChangeConfigurationClientCapabilities &other
        ) -> DidChangeConfigurationClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Did change configuration notification supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct DidChangeConfigurationClientCapabilities

    struct DidChangeWatchedFilesClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidChangeWatchedFilesClientCapabilities();
        DidChangeWatchedFilesClientCapabilities(
            DidChangeWatchedFilesClientCapabilities &&other
        );
        DidChangeWatchedFilesClientCapabilities(
            const DidChangeWatchedFilesClientCapabilities &other
        );
        ~DidChangeWatchedFilesClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidChangeWatchedFilesClientCapabilities &&other
        ) -> DidChangeWatchedFilesClientCapabilities &;

        auto operator=(
            const DidChangeWatchedFilesClientCapabilities &other
        ) -> DidChangeWatchedFilesClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Did change watched files notification supports dynamic registration. Please note
         * that the current protocol doesn't support static configuration for file changes
         * from the server side.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * Whether the client has support for {@link  RelativePattern relative pattern}
         * or not.
         *
         * @since 3.17.0
         */
        std::optional<boolean_t> relativePatternSupport;
    }; // struct DidChangeWatchedFilesClientCapabilities

    /**
     * Client capabilities for a {@link WorkspaceSymbolRequest}.
     */
    struct WorkspaceSymbolClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceSymbolClientCapabilities();
        WorkspaceSymbolClientCapabilities(
            WorkspaceSymbolClientCapabilities &&other
        );
        WorkspaceSymbolClientCapabilities(
            const WorkspaceSymbolClientCapabilities &other
        );
        ~WorkspaceSymbolClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceSymbolClientCapabilities &&other
        ) -> WorkspaceSymbolClientCapabilities &;

        auto operator=(
            const WorkspaceSymbolClientCapabilities &other
        ) -> WorkspaceSymbolClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Symbol request supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * Specific capabilities for the `SymbolKind` in the `workspace/symbol` request.
         */
        std::optional<WorkspaceSymbolClientCapabilities_symbolKind> symbolKind;
        /**
         * The client supports tags on `SymbolInformation`.
         * Clients supporting tags have to handle unknown tags gracefully.
         *
         * @since 3.16.0
         */
        std::optional<WorkspaceSymbolClientCapabilities_tagSupport> tagSupport;
        /**
         * The client support partial workspace symbols. The client will send the
         * request `workspaceSymbol/resolve` to the server to resolve additional
         * properties.
         *
         * @since 3.17.0
         */
        std::optional<WorkspaceSymbolClientCapabilities_resolveSupport>
            resolveSupport;
    }; // struct WorkspaceSymbolClientCapabilities

    /**
     * The client capabilities of a {@link ExecuteCommandRequest}.
     */
    struct ExecuteCommandClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ExecuteCommandClientCapabilities();
        ExecuteCommandClientCapabilities(
            ExecuteCommandClientCapabilities &&other
        );
        ExecuteCommandClientCapabilities(
            const ExecuteCommandClientCapabilities &other
        );
        ~ExecuteCommandClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ExecuteCommandClientCapabilities &&other
        ) -> ExecuteCommandClientCapabilities &;

        auto operator=(
            const ExecuteCommandClientCapabilities &other
        ) -> ExecuteCommandClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Execute command supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct ExecuteCommandClientCapabilities

    /**
     * @since 3.16.0
     */
    struct SemanticTokensWorkspaceClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensWorkspaceClientCapabilities();
        SemanticTokensWorkspaceClientCapabilities(
            SemanticTokensWorkspaceClientCapabilities &&other
        );
        SemanticTokensWorkspaceClientCapabilities(
            const SemanticTokensWorkspaceClientCapabilities &other
        );
        ~SemanticTokensWorkspaceClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensWorkspaceClientCapabilities &&other
        ) -> SemanticTokensWorkspaceClientCapabilities &;

        auto operator=(
            const SemanticTokensWorkspaceClientCapabilities &other
        ) -> SemanticTokensWorkspaceClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether the client implementation supports a refresh request sent from
         * the server to the client.
         *
         * Note that this event is global and will force the client to refresh all
         * semantic tokens currently shown. It should be used with absolute care
         * and is useful for situation where a server for example detects a project
         * wide change that requires such a calculation.
         */
        std::optional<boolean_t> refreshSupport;
    }; // struct SemanticTokensWorkspaceClientCapabilities

    /**
     * @since 3.16.0
     */
    struct CodeLensWorkspaceClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeLensWorkspaceClientCapabilities();
        CodeLensWorkspaceClientCapabilities(
            CodeLensWorkspaceClientCapabilities &&other
        );
        CodeLensWorkspaceClientCapabilities(
            const CodeLensWorkspaceClientCapabilities &other
        );
        ~CodeLensWorkspaceClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CodeLensWorkspaceClientCapabilities &&other
        ) -> CodeLensWorkspaceClientCapabilities &;

        auto operator=(
            const CodeLensWorkspaceClientCapabilities &other
        ) -> CodeLensWorkspaceClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether the client implementation supports a refresh request sent from the
         * server to the client.
         *
         * Note that this event is global and will force the client to refresh all
         * code lenses currently shown. It should be used with absolute care and is
         * useful for situation where a server for example detect a project wide
         * change that requires such a calculation.
         */
        std::optional<boolean_t> refreshSupport;
    }; // struct CodeLensWorkspaceClientCapabilities

    /**
     * Capabilities relating to events from file operations by the user in the client.
     *
     * These events do not come from the file system, they come from user operations
     * like renaming a file in the UI.
     *
     * @since 3.16.0
     */
    struct FileOperationClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FileOperationClientCapabilities();
        FileOperationClientCapabilities(
            FileOperationClientCapabilities &&other
        );
        FileOperationClientCapabilities(
            const FileOperationClientCapabilities &other
        );
        ~FileOperationClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            FileOperationClientCapabilities &&other
        ) -> FileOperationClientCapabilities &;

        auto operator=(
            const FileOperationClientCapabilities &other
        ) -> FileOperationClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether the client supports dynamic registration for file requests/notifications.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * The client has support for sending didCreateFiles notifications.
         */
        std::optional<boolean_t> didCreate;
        /**
         * The client has support for sending willCreateFiles requests.
         */
        std::optional<boolean_t> willCreate;
        /**
         * The client has support for sending didRenameFiles notifications.
         */
        std::optional<boolean_t> didRename;
        /**
         * The client has support for sending willRenameFiles requests.
         */
        std::optional<boolean_t> willRename;
        /**
         * The client has support for sending didDeleteFiles notifications.
         */
        std::optional<boolean_t> didDelete;
        /**
         * The client has support for sending willDeleteFiles requests.
         */
        std::optional<boolean_t> willDelete;
    }; // struct FileOperationClientCapabilities

    /**
     * Client workspace capabilities specific to inline values.
     *
     * @since 3.17.0
     */
    struct InlineValueWorkspaceClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineValueWorkspaceClientCapabilities();
        InlineValueWorkspaceClientCapabilities(
            InlineValueWorkspaceClientCapabilities &&other
        );
        InlineValueWorkspaceClientCapabilities(
            const InlineValueWorkspaceClientCapabilities &other
        );
        ~InlineValueWorkspaceClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlineValueWorkspaceClientCapabilities &&other
        ) -> InlineValueWorkspaceClientCapabilities &;

        auto operator=(
            const InlineValueWorkspaceClientCapabilities &other
        ) -> InlineValueWorkspaceClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether the client implementation supports a refresh request sent from the
         * server to the client.
         *
         * Note that this event is global and will force the client to refresh all
         * inline values currently shown. It should be used with absolute care and is
         * useful for situation where a server for example detects a project wide
         * change that requires such a calculation.
         */
        std::optional<boolean_t> refreshSupport;
    }; // struct InlineValueWorkspaceClientCapabilities

    /**
     * Client workspace capabilities specific to inlay hints.
     *
     * @since 3.17.0
     */
    struct InlayHintWorkspaceClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlayHintWorkspaceClientCapabilities();
        InlayHintWorkspaceClientCapabilities(
            InlayHintWorkspaceClientCapabilities &&other
        );
        InlayHintWorkspaceClientCapabilities(
            const InlayHintWorkspaceClientCapabilities &other
        );
        ~InlayHintWorkspaceClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlayHintWorkspaceClientCapabilities &&other
        ) -> InlayHintWorkspaceClientCapabilities &;

        auto operator=(
            const InlayHintWorkspaceClientCapabilities &other
        ) -> InlayHintWorkspaceClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether the client implementation supports a refresh request sent from
         * the server to the client.
         *
         * Note that this event is global and will force the client to refresh all
         * inlay hints currently shown. It should be used with absolute care and
         * is useful for situation where a server for example detects a project wide
         * change that requires such a calculation.
         */
        std::optional<boolean_t> refreshSupport;
    }; // struct InlayHintWorkspaceClientCapabilities

    /**
     * Workspace client capabilities specific to diagnostic pull requests.
     *
     * @since 3.17.0
     */
    struct DiagnosticWorkspaceClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DiagnosticWorkspaceClientCapabilities();
        DiagnosticWorkspaceClientCapabilities(
            DiagnosticWorkspaceClientCapabilities &&other
        );
        DiagnosticWorkspaceClientCapabilities(
            const DiagnosticWorkspaceClientCapabilities &other
        );
        ~DiagnosticWorkspaceClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DiagnosticWorkspaceClientCapabilities &&other
        ) -> DiagnosticWorkspaceClientCapabilities &;

        auto operator=(
            const DiagnosticWorkspaceClientCapabilities &other
        ) -> DiagnosticWorkspaceClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether the client implementation supports a refresh request sent from
         * the server to the client.
         *
         * Note that this event is global and will force the client to refresh all
         * pulled diagnostics currently shown. It should be used with absolute care and
         * is useful for situation where a server for example detects a project wide
         * change that requires such a calculation.
         */
        std::optional<boolean_t> refreshSupport;
    }; // struct DiagnosticWorkspaceClientCapabilities

    /**
     * Client workspace capabilities specific to folding ranges
     *
     * @since 3.18.0
     * @proposed
     */
    struct FoldingRangeWorkspaceClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FoldingRangeWorkspaceClientCapabilities();
        FoldingRangeWorkspaceClientCapabilities(
            FoldingRangeWorkspaceClientCapabilities &&other
        );
        FoldingRangeWorkspaceClientCapabilities(
            const FoldingRangeWorkspaceClientCapabilities &other
        );
        ~FoldingRangeWorkspaceClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            FoldingRangeWorkspaceClientCapabilities &&other
        ) -> FoldingRangeWorkspaceClientCapabilities &;

        auto operator=(
            const FoldingRangeWorkspaceClientCapabilities &other
        ) -> FoldingRangeWorkspaceClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether the client implementation supports a refresh request sent from the
         * server to the client.
         *
         * Note that this event is global and will force the client to refresh all
         * folding ranges currently shown. It should be used with absolute care and is
         * useful for situation where a server for example detects a project wide
         * change that requires such a calculation.
         *
         * @since 3.18.0
         * @proposed
         */
        std::optional<boolean_t> refreshSupport;
    }; // struct FoldingRangeWorkspaceClientCapabilities

    /**
     * Workspace specific client capabilities.
     */
    struct WorkspaceClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceClientCapabilities();
        WorkspaceClientCapabilities(WorkspaceClientCapabilities &&other);
        WorkspaceClientCapabilities(const WorkspaceClientCapabilities &other);
        ~WorkspaceClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceClientCapabilities &&other
        ) -> WorkspaceClientCapabilities &;

        auto operator=(
            const WorkspaceClientCapabilities &other
        ) -> WorkspaceClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The client supports applying batch edits
         * to the workspace by supporting the request
         * 'workspace/applyEdit'
         */
        std::optional<boolean_t> applyEdit;
        /**
         * Capabilities specific to `WorkspaceEdit`s.
         */
        std::optional<WorkspaceEditClientCapabilities> workspaceEdit;
        /**
         * Capabilities specific to the `workspace/didChangeConfiguration` notification.
         */
        std::optional<DidChangeConfigurationClientCapabilities>
            didChangeConfiguration;
        /**
         * Capabilities specific to the `workspace/didChangeWatchedFiles` notification.
         */
        std::optional<DidChangeWatchedFilesClientCapabilities>
            didChangeWatchedFiles;
        /**
         * Capabilities specific to the `workspace/symbol` request.
         */
        std::optional<WorkspaceSymbolClientCapabilities> symbol;
        /**
         * Capabilities specific to the `workspace/executeCommand` request.
         */
        std::optional<ExecuteCommandClientCapabilities> executeCommand;
        /**
         * The client has support for workspace folders.
         *
         * @since 3.6.0
         */
        std::optional<boolean_t> workspaceFolders;
        /**
         * The client supports `workspace/configuration` requests.
         *
         * @since 3.6.0
         */
        std::optional<boolean_t> configuration;
        /**
         * Capabilities specific to the semantic token requests scoped to the
         * workspace.
         *
         * @since 3.16.0.
         */
        std::optional<SemanticTokensWorkspaceClientCapabilities>
            semanticTokens;
        /**
         * Capabilities specific to the code lens requests scoped to the
         * workspace.
         *
         * @since 3.16.0.
         */
        std::optional<CodeLensWorkspaceClientCapabilities> codeLens;
        /**
         * The client has support for file notifications/requests for user operations on files.
         *
         * Since 3.16.0
         */
        std::optional<FileOperationClientCapabilities> fileOperations;
        /**
         * Capabilities specific to the inline values requests scoped to the
         * workspace.
         *
         * @since 3.17.0.
         */
        std::optional<InlineValueWorkspaceClientCapabilities> inlineValue;
        /**
         * Capabilities specific to the inlay hint requests scoped to the
         * workspace.
         *
         * @since 3.17.0.
         */
        std::optional<InlayHintWorkspaceClientCapabilities> inlayHint;
        /**
         * Capabilities specific to the diagnostic requests scoped to the
         * workspace.
         *
         * @since 3.17.0.
         */
        std::optional<DiagnosticWorkspaceClientCapabilities> diagnostics;
        /**
         * Capabilities specific to the folding range requests scoped to the workspace.
         *
         * @since 3.18.0
         * @proposed
         */
        std::optional<FoldingRangeWorkspaceClientCapabilities> foldingRange;
    }; // struct WorkspaceClientCapabilities

    struct TextDocumentSyncClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentSyncClientCapabilities();
        TextDocumentSyncClientCapabilities(
            TextDocumentSyncClientCapabilities &&other
        );
        TextDocumentSyncClientCapabilities(
            const TextDocumentSyncClientCapabilities &other
        );
        ~TextDocumentSyncClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentSyncClientCapabilities &&other
        ) -> TextDocumentSyncClientCapabilities &;

        auto operator=(
            const TextDocumentSyncClientCapabilities &other
        ) -> TextDocumentSyncClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether text document synchronization supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * The client supports sending will save notifications.
         */
        std::optional<boolean_t> willSave;
        /**
         * The client supports sending a will save request and
         * waits for a response providing text edits which will
         * be applied to the document before it is saved.
         */
        std::optional<boolean_t> willSaveWaitUntil;
        /**
         * The client supports did save notifications.
         */
        std::optional<boolean_t> didSave;
    }; // struct TextDocumentSyncClientCapabilities

    struct CompletionClientCapabilities_completionItem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionClientCapabilities_completionItem();
        CompletionClientCapabilities_completionItem(
            CompletionClientCapabilities_completionItem &&other
        );
        CompletionClientCapabilities_completionItem(
            const CompletionClientCapabilities_completionItem &other
        );
        ~CompletionClientCapabilities_completionItem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionClientCapabilities_completionItem &&other
        ) -> CompletionClientCapabilities_completionItem &;

        auto operator=(
            const CompletionClientCapabilities_completionItem &other
        ) -> CompletionClientCapabilities_completionItem &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Client supports snippets as insert text.
         *
         * A snippet can define tab stops and placeholders with `$1`, `$2`
         * and `${3:foo}`. `$0` defines the final tab stop, it defaults to
         * the end of the snippet. Placeholders with equal identifiers are linked,
         * that is typing in one will update others too.
         */
        std::optional<boolean_t> snippetSupport;
        /**
         * Client supports commit characters on a completion item.
         */
        std::optional<boolean_t> commitCharactersSupport;
        /**
         * Client supports the following content formats for the documentation
         * property. The order describes the preferred format of the client.
         */
        std::optional<std::vector<MarkupKind>> documentationFormat;
        /**
         * Client supports the deprecated property on a completion item.
         */
        std::optional<boolean_t> deprecatedSupport;
        /**
         * Client supports the preselect property on a completion item.
         */
        std::optional<boolean_t> preselectSupport;
        /**
         * Client supports the tag property on a completion item. Clients supporting
         * tags have to handle unknown tags gracefully. Clients especially need to
         * preserve unknown tags when sending a completion item back to the server in
         * a resolve call.
         *
         * @since 3.15.0
         */
        std::optional<CompletionClientCapabilities_completionItem_tagSupport>
            tagSupport;
        /**
         * Client support insert replace edit to control different behavior if a
         * completion item is inserted in the text or should replace text.
         *
         * @since 3.16.0
         */
        std::optional<boolean_t> insertReplaceSupport;
        /**
         * Indicates which properties a client can resolve lazily on a completion
         * item. Before version 3.16.0 only the predefined properties `documentation`
         * and `details` could be resolved lazily.
         *
         * @since 3.16.0
         */
        std::optional<
            CompletionClientCapabilities_completionItem_resolveSupport
        > resolveSupport;
        /**
         * The client supports the `insertTextMode` property on
         * a completion item to override the whitespace handling mode
         * as defined by the client (see `insertTextMode`).
         *
         * @since 3.16.0
         */
        std::optional<
            CompletionClientCapabilities_completionItem_insertTextModeSupport
        > insertTextModeSupport;
        /**
         * The client has support for completion item label
         * details (see also `CompletionItemLabelDetails`).
         *
         * @since 3.17.0
         */
        std::optional<boolean_t> labelDetailsSupport;
    }; // struct CompletionClientCapabilities_completionItem

    /**
     * Completion client capabilities
     */
    struct CompletionClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionClientCapabilities();
        CompletionClientCapabilities(CompletionClientCapabilities &&other);
        CompletionClientCapabilities(
            const CompletionClientCapabilities &other
        );
        ~CompletionClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionClientCapabilities &&other
        ) -> CompletionClientCapabilities &;

        auto operator=(
            const CompletionClientCapabilities &other
        ) -> CompletionClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether completion supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * The client supports the following `CompletionItem` specific
         * capabilities.
         */
        std::optional<CompletionClientCapabilities_completionItem>
            completionItem;
        std::optional<CompletionClientCapabilities_completionItemKind>
            completionItemKind;
        /**
         * Defines how the client handles whitespace and indentation
         * when accepting a completion item that uses multi line
         * text in either `insertText` or `textEdit`.
         *
         * @since 3.17.0
         */
        std::optional<InsertTextMode> insertTextMode;
        /**
         * The client supports to send additional context information for a
         * `textDocument/completion` request.
         */
        std::optional<boolean_t> contextSupport;
        /**
         * The client supports the following `CompletionList` specific
         * capabilities.
         *
         * @since 3.17.0
         */
        std::optional<CompletionClientCapabilities_completionList>
            completionList;
    }; // struct CompletionClientCapabilities

    struct HoverClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        HoverClientCapabilities();
        HoverClientCapabilities(HoverClientCapabilities &&other);
        HoverClientCapabilities(const HoverClientCapabilities &other);
        ~HoverClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            HoverClientCapabilities &&other
        ) -> HoverClientCapabilities &;

        auto operator=(
            const HoverClientCapabilities &other
        ) -> HoverClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether hover supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * Client supports the following content formats for the content
         * property. The order describes the preferred format of the client.
         */
        std::optional<std::vector<MarkupKind>> contentFormat;
    }; // struct HoverClientCapabilities

    struct SignatureHelpClientCapabilities_signatureInformation_parameterInformation {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SignatureHelpClientCapabilities_signatureInformation_parameterInformation();
        SignatureHelpClientCapabilities_signatureInformation_parameterInformation(
            SignatureHelpClientCapabilities_signatureInformation_parameterInformation &&other
        );
        SignatureHelpClientCapabilities_signatureInformation_parameterInformation(
            const SignatureHelpClientCapabilities_signatureInformation_parameterInformation &other
        );
        ~SignatureHelpClientCapabilities_signatureInformation_parameterInformation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SignatureHelpClientCapabilities_signatureInformation_parameterInformation &&other
        ) -> SignatureHelpClientCapabilities_signatureInformation_parameterInformation &;

        auto operator=(
            const SignatureHelpClientCapabilities_signatureInformation_parameterInformation &other
        ) -> SignatureHelpClientCapabilities_signatureInformation_parameterInformation &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The client supports processing label offsets instead of a
         * simple label string.
         *
         * @since 3.14.0
         */
        std::optional<boolean_t> labelOffsetSupport;
    }; // struct SignatureHelpClientCapabilities_signatureInformation_parameterInformation

    struct SignatureHelpClientCapabilities_signatureInformation {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SignatureHelpClientCapabilities_signatureInformation();
        SignatureHelpClientCapabilities_signatureInformation(
            SignatureHelpClientCapabilities_signatureInformation &&other
        );
        SignatureHelpClientCapabilities_signatureInformation(
            const SignatureHelpClientCapabilities_signatureInformation &other
        );
        ~SignatureHelpClientCapabilities_signatureInformation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SignatureHelpClientCapabilities_signatureInformation &&other
        ) -> SignatureHelpClientCapabilities_signatureInformation &;

        auto operator=(
            const SignatureHelpClientCapabilities_signatureInformation &other
        ) -> SignatureHelpClientCapabilities_signatureInformation &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Client supports the following content formats for the documentation
         * property. The order describes the preferred format of the client.
         */
        std::optional<std::vector<MarkupKind>> documentationFormat;
        /**
         * Client capabilities specific to parameter information.
         */
        std::optional<
            SignatureHelpClientCapabilities_signatureInformation_parameterInformation
        > parameterInformation;
        /**
         * The client supports the `activeParameter` property on `SignatureInformation`
         * literal.
         *
         * @since 3.16.0
         */
        std::optional<boolean_t> activeParameterSupport;
    }; // struct SignatureHelpClientCapabilities_signatureInformation

    /**
     * Client Capabilities for a {@link SignatureHelpRequest}.
     */
    struct SignatureHelpClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SignatureHelpClientCapabilities();
        SignatureHelpClientCapabilities(
            SignatureHelpClientCapabilities &&other
        );
        SignatureHelpClientCapabilities(
            const SignatureHelpClientCapabilities &other
        );
        ~SignatureHelpClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SignatureHelpClientCapabilities &&other
        ) -> SignatureHelpClientCapabilities &;

        auto operator=(
            const SignatureHelpClientCapabilities &other
        ) -> SignatureHelpClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether signature help supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * The client supports the following `SignatureInformation`
         * specific properties.
         */
        std::optional<SignatureHelpClientCapabilities_signatureInformation>
            signatureInformation;
        /**
         * The client supports to send additional context information for a
         * `textDocument/signatureHelp` request. A client that opts into
         * contextSupport will also support the `retriggerCharacters` on
         * `SignatureHelpOptions`.
         *
         * @since 3.15.0
         */
        std::optional<boolean_t> contextSupport;
    }; // struct SignatureHelpClientCapabilities

    /**
     * @since 3.14.0
     */
    struct DeclarationClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DeclarationClientCapabilities();
        DeclarationClientCapabilities(DeclarationClientCapabilities &&other);
        DeclarationClientCapabilities(
            const DeclarationClientCapabilities &other
        );
        ~DeclarationClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DeclarationClientCapabilities &&other
        ) -> DeclarationClientCapabilities &;

        auto operator=(
            const DeclarationClientCapabilities &other
        ) -> DeclarationClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether declaration supports dynamic registration. If this is set to `true`
         * the client supports the new `DeclarationRegistrationOptions` return value
         * for the corresponding server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * The client supports additional metadata in the form of declaration links.
         */
        std::optional<boolean_t> linkSupport;
    }; // struct DeclarationClientCapabilities

    /**
     * Client Capabilities for a {@link DefinitionRequest}.
     */
    struct DefinitionClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DefinitionClientCapabilities();
        DefinitionClientCapabilities(DefinitionClientCapabilities &&other);
        DefinitionClientCapabilities(
            const DefinitionClientCapabilities &other
        );
        ~DefinitionClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DefinitionClientCapabilities &&other
        ) -> DefinitionClientCapabilities &;

        auto operator=(
            const DefinitionClientCapabilities &other
        ) -> DefinitionClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether definition supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * The client supports additional metadata in the form of definition links.
         *
         * @since 3.14.0
         */
        std::optional<boolean_t> linkSupport;
    }; // struct DefinitionClientCapabilities

    /**
     * Since 3.6.0
     */
    struct TypeDefinitionClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeDefinitionClientCapabilities();
        TypeDefinitionClientCapabilities(
            TypeDefinitionClientCapabilities &&other
        );
        TypeDefinitionClientCapabilities(
            const TypeDefinitionClientCapabilities &other
        );
        ~TypeDefinitionClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TypeDefinitionClientCapabilities &&other
        ) -> TypeDefinitionClientCapabilities &;

        auto operator=(
            const TypeDefinitionClientCapabilities &other
        ) -> TypeDefinitionClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration. If this is set to `true`
         * the client supports the new `TypeDefinitionRegistrationOptions` return value
         * for the corresponding server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * The client supports additional metadata in the form of definition links.
         *
         * Since 3.14.0
         */
        std::optional<boolean_t> linkSupport;
    }; // struct TypeDefinitionClientCapabilities

    /**
     * @since 3.6.0
     */
    struct ImplementationClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ImplementationClientCapabilities();
        ImplementationClientCapabilities(
            ImplementationClientCapabilities &&other
        );
        ImplementationClientCapabilities(
            const ImplementationClientCapabilities &other
        );
        ~ImplementationClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ImplementationClientCapabilities &&other
        ) -> ImplementationClientCapabilities &;

        auto operator=(
            const ImplementationClientCapabilities &other
        ) -> ImplementationClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration. If this is set to `true`
         * the client supports the new `ImplementationRegistrationOptions` return value
         * for the corresponding server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * The client supports additional metadata in the form of definition links.
         *
         * @since 3.14.0
         */
        std::optional<boolean_t> linkSupport;
    }; // struct ImplementationClientCapabilities

    /**
     * Client Capabilities for a {@link ReferencesRequest}.
     */
    struct ReferenceClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ReferenceClientCapabilities();
        ReferenceClientCapabilities(ReferenceClientCapabilities &&other);
        ReferenceClientCapabilities(const ReferenceClientCapabilities &other);
        ~ReferenceClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ReferenceClientCapabilities &&other
        ) -> ReferenceClientCapabilities &;

        auto operator=(
            const ReferenceClientCapabilities &other
        ) -> ReferenceClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether references supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct ReferenceClientCapabilities

    /**
     * Client Capabilities for a {@link DocumentHighlightRequest}.
     */
    struct DocumentHighlightClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentHighlightClientCapabilities();
        DocumentHighlightClientCapabilities(
            DocumentHighlightClientCapabilities &&other
        );
        DocumentHighlightClientCapabilities(
            const DocumentHighlightClientCapabilities &other
        );
        ~DocumentHighlightClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentHighlightClientCapabilities &&other
        ) -> DocumentHighlightClientCapabilities &;

        auto operator=(
            const DocumentHighlightClientCapabilities &other
        ) -> DocumentHighlightClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether document highlight supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct DocumentHighlightClientCapabilities

    /**
     * Client Capabilities for a {@link DocumentSymbolRequest}.
     */
    struct DocumentSymbolClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentSymbolClientCapabilities();
        DocumentSymbolClientCapabilities(
            DocumentSymbolClientCapabilities &&other
        );
        DocumentSymbolClientCapabilities(
            const DocumentSymbolClientCapabilities &other
        );
        ~DocumentSymbolClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentSymbolClientCapabilities &&other
        ) -> DocumentSymbolClientCapabilities &;

        auto operator=(
            const DocumentSymbolClientCapabilities &other
        ) -> DocumentSymbolClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether document symbol supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * Specific capabilities for the `SymbolKind` in the
         * `textDocument/documentSymbol` request.
         */
        std::optional<DocumentSymbolClientCapabilities_symbolKind> symbolKind;
        /**
         * The client supports hierarchical document symbols.
         */
        std::optional<boolean_t> hierarchicalDocumentSymbolSupport;
        /**
         * The client supports tags on `SymbolInformation`. Tags are supported on
         * `DocumentSymbol` if `hierarchicalDocumentSymbolSupport` is set to true.
         * Clients supporting tags have to handle unknown tags gracefully.
         *
         * @since 3.16.0
         */
        std::optional<DocumentSymbolClientCapabilities_tagSupport> tagSupport;
        /**
         * The client supports an additional label presented in the UI when
         * registering a document symbol provider.
         *
         * @since 3.16.0
         */
        std::optional<boolean_t> labelSupport;
    }; // struct DocumentSymbolClientCapabilities

    /**
     * The Client Capabilities of a {@link CodeActionRequest}.
     */
    struct CodeActionClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeActionClientCapabilities();
        CodeActionClientCapabilities(CodeActionClientCapabilities &&other);
        CodeActionClientCapabilities(
            const CodeActionClientCapabilities &other
        );
        ~CodeActionClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CodeActionClientCapabilities &&other
        ) -> CodeActionClientCapabilities &;

        auto operator=(
            const CodeActionClientCapabilities &other
        ) -> CodeActionClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether code action supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * The client support code action literals of type `CodeAction` as a valid
         * response of the `textDocument/codeAction` request. If the property is not
         * set the request can only return `Command` literals.
         *
         * @since 3.8.0
         */
        std::optional<CodeActionClientCapabilities_codeActionLiteralSupport>
            codeActionLiteralSupport;
        /**
         * Whether code action supports the `isPreferred` property.
         *
         * @since 3.15.0
         */
        std::optional<boolean_t> isPreferredSupport;
        /**
         * Whether code action supports the `disabled` property.
         *
         * @since 3.16.0
         */
        std::optional<boolean_t> disabledSupport;
        /**
         * Whether code action supports the `data` property which is
         * preserved between a `textDocument/codeAction` and a
         * `codeAction/resolve` request.
         *
         * @since 3.16.0
         */
        std::optional<boolean_t> dataSupport;
        /**
         * Whether the client supports resolving additional code action
         * properties via a separate `codeAction/resolve` request.
         *
         * @since 3.16.0
         */
        std::optional<CodeActionClientCapabilities_resolveSupport>
            resolveSupport;
        /**
         * Whether the client honors the change annotations in
         * text edits and resource operations returned via the
         * `CodeAction#edit` property by for example presenting
         * the workspace edit in the user interface and asking
         * for confirmation.
         *
         * @since 3.16.0
         */
        std::optional<boolean_t> honorsChangeAnnotations;
    }; // struct CodeActionClientCapabilities

    /**
     * The client capabilities  of a {@link CodeLensRequest}.
     */
    struct CodeLensClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeLensClientCapabilities();
        CodeLensClientCapabilities(CodeLensClientCapabilities &&other);
        CodeLensClientCapabilities(const CodeLensClientCapabilities &other);
        ~CodeLensClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CodeLensClientCapabilities &&other
        ) -> CodeLensClientCapabilities &;

        auto operator=(
            const CodeLensClientCapabilities &other
        ) -> CodeLensClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether code lens supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct CodeLensClientCapabilities

    /**
     * The client capabilities of a {@link DocumentLinkRequest}.
     */
    struct DocumentLinkClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentLinkClientCapabilities();
        DocumentLinkClientCapabilities(DocumentLinkClientCapabilities &&other);
        DocumentLinkClientCapabilities(
            const DocumentLinkClientCapabilities &other
        );
        ~DocumentLinkClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentLinkClientCapabilities &&other
        ) -> DocumentLinkClientCapabilities &;

        auto operator=(
            const DocumentLinkClientCapabilities &other
        ) -> DocumentLinkClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether document link supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * Whether the client supports the `tooltip` property on `DocumentLink`.
         *
         * @since 3.15.0
         */
        std::optional<boolean_t> tooltipSupport;
    }; // struct DocumentLinkClientCapabilities

    struct DocumentColorClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentColorClientCapabilities();
        DocumentColorClientCapabilities(
            DocumentColorClientCapabilities &&other
        );
        DocumentColorClientCapabilities(
            const DocumentColorClientCapabilities &other
        );
        ~DocumentColorClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentColorClientCapabilities &&other
        ) -> DocumentColorClientCapabilities &;

        auto operator=(
            const DocumentColorClientCapabilities &other
        ) -> DocumentColorClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration. If this is set to `true`
         * the client supports the new `DocumentColorRegistrationOptions` return value
         * for the corresponding server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct DocumentColorClientCapabilities

    /**
     * Client capabilities of a {@link DocumentFormattingRequest}.
     */
    struct DocumentFormattingClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentFormattingClientCapabilities();
        DocumentFormattingClientCapabilities(
            DocumentFormattingClientCapabilities &&other
        );
        DocumentFormattingClientCapabilities(
            const DocumentFormattingClientCapabilities &other
        );
        ~DocumentFormattingClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentFormattingClientCapabilities &&other
        ) -> DocumentFormattingClientCapabilities &;

        auto operator=(
            const DocumentFormattingClientCapabilities &other
        ) -> DocumentFormattingClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether formatting supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct DocumentFormattingClientCapabilities

    /**
     * Client capabilities of a {@link DocumentRangeFormattingRequest}.
     */
    struct DocumentRangeFormattingClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentRangeFormattingClientCapabilities();
        DocumentRangeFormattingClientCapabilities(
            DocumentRangeFormattingClientCapabilities &&other
        );
        DocumentRangeFormattingClientCapabilities(
            const DocumentRangeFormattingClientCapabilities &other
        );
        ~DocumentRangeFormattingClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentRangeFormattingClientCapabilities &&other
        ) -> DocumentRangeFormattingClientCapabilities &;

        auto operator=(
            const DocumentRangeFormattingClientCapabilities &other
        ) -> DocumentRangeFormattingClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether range formatting supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * Whether the client supports formatting multiple ranges at once.
         *
         * @since 3.18.0
         * @proposed
         */
        std::optional<boolean_t> rangesSupport;
    }; // struct DocumentRangeFormattingClientCapabilities

    /**
     * Client capabilities of a {@link DocumentOnTypeFormattingRequest}.
     */
    struct DocumentOnTypeFormattingClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentOnTypeFormattingClientCapabilities();
        DocumentOnTypeFormattingClientCapabilities(
            DocumentOnTypeFormattingClientCapabilities &&other
        );
        DocumentOnTypeFormattingClientCapabilities(
            const DocumentOnTypeFormattingClientCapabilities &other
        );
        ~DocumentOnTypeFormattingClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentOnTypeFormattingClientCapabilities &&other
        ) -> DocumentOnTypeFormattingClientCapabilities &;

        auto operator=(
            const DocumentOnTypeFormattingClientCapabilities &other
        ) -> DocumentOnTypeFormattingClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether on type formatting supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct DocumentOnTypeFormattingClientCapabilities

    struct RenameClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RenameClientCapabilities();
        RenameClientCapabilities(RenameClientCapabilities &&other);
        RenameClientCapabilities(const RenameClientCapabilities &other);
        ~RenameClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            RenameClientCapabilities &&other
        ) -> RenameClientCapabilities &;

        auto operator=(
            const RenameClientCapabilities &other
        ) -> RenameClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether rename supports dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * Client supports testing for validity of rename operations
         * before execution.
         *
         * @since 3.12.0
         */
        std::optional<boolean_t> prepareSupport;
        /**
         * Client supports the default behavior result.
         *
         * The value indicates the default behavior used by the
         * client.
         *
         * @since 3.16.0
         */
        std::optional<PrepareSupportDefaultBehavior>
            prepareSupportDefaultBehavior;
        /**
         * Whether the client honors the change annotations in
         * text edits and resource operations returned via the
         * rename request's workspace edit by for example presenting
         * the workspace edit in the user interface and asking
         * for confirmation.
         *
         * @since 3.16.0
         */
        std::optional<boolean_t> honorsChangeAnnotations;
    }; // struct RenameClientCapabilities

    struct FoldingRangeClientCapabilities_foldingRange {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FoldingRangeClientCapabilities_foldingRange();
        FoldingRangeClientCapabilities_foldingRange(
            FoldingRangeClientCapabilities_foldingRange &&other
        );
        FoldingRangeClientCapabilities_foldingRange(
            const FoldingRangeClientCapabilities_foldingRange &other
        );
        ~FoldingRangeClientCapabilities_foldingRange();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            FoldingRangeClientCapabilities_foldingRange &&other
        ) -> FoldingRangeClientCapabilities_foldingRange &;

        auto operator=(
            const FoldingRangeClientCapabilities_foldingRange &other
        ) -> FoldingRangeClientCapabilities_foldingRange &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * If set, the client signals that it supports setting collapsedText on
         * folding ranges to display custom labels instead of the default text.
         *
         * @since 3.17.0
         */
        std::optional<boolean_t> collapsedText;
    }; // struct FoldingRangeClientCapabilities_foldingRange

    struct SelectionRangeClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SelectionRangeClientCapabilities();
        SelectionRangeClientCapabilities(
            SelectionRangeClientCapabilities &&other
        );
        SelectionRangeClientCapabilities(
            const SelectionRangeClientCapabilities &other
        );
        ~SelectionRangeClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SelectionRangeClientCapabilities &&other
        ) -> SelectionRangeClientCapabilities &;

        auto operator=(
            const SelectionRangeClientCapabilities &other
        ) -> SelectionRangeClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration for selection range providers. If this is set to `true`
         * the client supports the new `SelectionRangeRegistrationOptions` return value for the corresponding server
         * capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct SelectionRangeClientCapabilities

    /**
     * The publish diagnostic client capabilities.
     */
    struct PublishDiagnosticsClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        PublishDiagnosticsClientCapabilities();
        PublishDiagnosticsClientCapabilities(
            PublishDiagnosticsClientCapabilities &&other
        );
        PublishDiagnosticsClientCapabilities(
            const PublishDiagnosticsClientCapabilities &other
        );
        ~PublishDiagnosticsClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            PublishDiagnosticsClientCapabilities &&other
        ) -> PublishDiagnosticsClientCapabilities &;

        auto operator=(
            const PublishDiagnosticsClientCapabilities &other
        ) -> PublishDiagnosticsClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether the clients accepts diagnostics with related information.
         */
        std::optional<boolean_t> relatedInformation;
        /**
         * Client supports the tag property to provide meta data about a diagnostic.
         * Clients supporting tags have to handle unknown tags gracefully.
         *
         * @since 3.15.0
         */
        std::optional<PublishDiagnosticsClientCapabilities_tagSupport>
            tagSupport;
        /**
         * Whether the client interprets the version property of the
         * `textDocument/publishDiagnostics` notification's parameter.
         *
         * @since 3.15.0
         */
        std::optional<boolean_t> versionSupport;
        /**
         * Client supports a codeDescription property
         *
         * @since 3.16.0
         */
        std::optional<boolean_t> codeDescriptionSupport;
        /**
         * Whether code action supports the `data` property which is
         * preserved between a `textDocument/publishDiagnostics` and
         * `textDocument/codeAction` request.
         *
         * @since 3.16.0
         */
        std::optional<boolean_t> dataSupport;
    }; // struct PublishDiagnosticsClientCapabilities

    /**
     * @since 3.16.0
     */
    struct CallHierarchyClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CallHierarchyClientCapabilities();
        CallHierarchyClientCapabilities(
            CallHierarchyClientCapabilities &&other
        );
        CallHierarchyClientCapabilities(
            const CallHierarchyClientCapabilities &other
        );
        ~CallHierarchyClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CallHierarchyClientCapabilities &&other
        ) -> CallHierarchyClientCapabilities &;

        auto operator=(
            const CallHierarchyClientCapabilities &other
        ) -> CallHierarchyClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration. If this is set to `true`
         * the client supports the new `(TextDocumentRegistrationOptions & StaticRegistrationOptions)`
         * return value for the corresponding server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct CallHierarchyClientCapabilities

    struct SemanticTokensClientCapabilities_requests_full_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensClientCapabilities_requests_full_1();
        SemanticTokensClientCapabilities_requests_full_1(
            SemanticTokensClientCapabilities_requests_full_1 &&other
        );
        SemanticTokensClientCapabilities_requests_full_1(
            const SemanticTokensClientCapabilities_requests_full_1 &other
        );
        ~SemanticTokensClientCapabilities_requests_full_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensClientCapabilities_requests_full_1 &&other
        ) -> SemanticTokensClientCapabilities_requests_full_1 &;

        auto operator=(
            const SemanticTokensClientCapabilities_requests_full_1 &other
        ) -> SemanticTokensClientCapabilities_requests_full_1 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The client will send the `textDocument/semanticTokens/full/delta` request if
         * the server provides a corresponding handler.
         */
        std::optional<boolean_t> delta;
    }; // struct SemanticTokensClientCapabilities_requests_full_1

    enum class SemanticTokensClientCapabilities_requests_fullType {
        Uninitialized = -1,
        Boolean = 0,
        SemanticTokensClientCapabilities_requests_full_1 = 1,
    }; // enum class SemanticTokensClientCapabilities_requests_fullType

    extern const std::map<
        SemanticTokensClientCapabilities_requests_fullType,
        std::string
    > SemanticTokensClientCapabilities_requests_fullTypeNames;

    class SemanticTokensClientCapabilities_requests_full {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensClientCapabilities_requests_full();
        SemanticTokensClientCapabilities_requests_full(
            SemanticTokensClientCapabilities_requests_full &&other
        );
        SemanticTokensClientCapabilities_requests_full(
            const SemanticTokensClientCapabilities_requests_full &other
        );
        ~SemanticTokensClientCapabilities_requests_full();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensClientCapabilities_requests_full &&other
        ) -> SemanticTokensClientCapabilities_requests_full &;

        auto operator=(
            const SemanticTokensClientCapabilities_requests_full &other
        ) -> SemanticTokensClientCapabilities_requests_full &;

        auto type() const
        -> const SemanticTokensClientCapabilities_requests_fullType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> SemanticTokensClientCapabilities_requests_full &;

        auto semanticTokensClientCapabilities_requests_full_1() const
        -> const SemanticTokensClientCapabilities_requests_full_1 &;

        auto operator=(
            const std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> &semanticTokensClientCapabilities_requests_full_1
        ) -> SemanticTokensClientCapabilities_requests_full &;

        auto operator=(
            std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> &&semanticTokensClientCapabilities_requests_full_1
        ) -> SemanticTokensClientCapabilities_requests_full &;

        auto operator=(
            const SemanticTokensClientCapabilities_requests_full_1 &semanticTokensClientCapabilities_requests_full_1
        ) -> SemanticTokensClientCapabilities_requests_full &;

        auto operator=(
            SemanticTokensClientCapabilities_requests_full_1 &&semanticTokensClientCapabilities_requests_full_1
        ) -> SemanticTokensClientCapabilities_requests_full &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        SemanticTokensClientCapabilities_requests_fullType _type{
            SemanticTokensClientCapabilities_requests_fullType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<SemanticTokensClientCapabilities_requests_full_1> _semanticTokensClientCapabilities_requests_full_1;
        };

        auto reset() -> void;
    }; // class SemanticTokensClientCapabilities_requests_full

    /**
     * Client capabilities for the linked editing range request.
     *
     * @since 3.16.0
     */
    struct LinkedEditingRangeClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        LinkedEditingRangeClientCapabilities();
        LinkedEditingRangeClientCapabilities(
            LinkedEditingRangeClientCapabilities &&other
        );
        LinkedEditingRangeClientCapabilities(
            const LinkedEditingRangeClientCapabilities &other
        );
        ~LinkedEditingRangeClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            LinkedEditingRangeClientCapabilities &&other
        ) -> LinkedEditingRangeClientCapabilities &;

        auto operator=(
            const LinkedEditingRangeClientCapabilities &other
        ) -> LinkedEditingRangeClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration. If this is set to `true`
         * the client supports the new `(TextDocumentRegistrationOptions & StaticRegistrationOptions)`
         * return value for the corresponding server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct LinkedEditingRangeClientCapabilities

    /**
     * Client capabilities specific to the moniker request.
     *
     * @since 3.16.0
     */
    struct MonikerClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        MonikerClientCapabilities();
        MonikerClientCapabilities(MonikerClientCapabilities &&other);
        MonikerClientCapabilities(const MonikerClientCapabilities &other);
        ~MonikerClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            MonikerClientCapabilities &&other
        ) -> MonikerClientCapabilities &;

        auto operator=(
            const MonikerClientCapabilities &other
        ) -> MonikerClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether moniker supports dynamic registration. If this is set to `true`
         * the client supports the new `MonikerRegistrationOptions` return value
         * for the corresponding server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct MonikerClientCapabilities

    /**
     * @since 3.17.0
     */
    struct TypeHierarchyClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeHierarchyClientCapabilities();
        TypeHierarchyClientCapabilities(
            TypeHierarchyClientCapabilities &&other
        );
        TypeHierarchyClientCapabilities(
            const TypeHierarchyClientCapabilities &other
        );
        ~TypeHierarchyClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TypeHierarchyClientCapabilities &&other
        ) -> TypeHierarchyClientCapabilities &;

        auto operator=(
            const TypeHierarchyClientCapabilities &other
        ) -> TypeHierarchyClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration. If this is set to `true`
         * the client supports the new `(TextDocumentRegistrationOptions & StaticRegistrationOptions)`
         * return value for the corresponding server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct TypeHierarchyClientCapabilities

    /**
     * Client capabilities specific to inline values.
     *
     * @since 3.17.0
     */
    struct InlineValueClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineValueClientCapabilities();
        InlineValueClientCapabilities(InlineValueClientCapabilities &&other);
        InlineValueClientCapabilities(
            const InlineValueClientCapabilities &other
        );
        ~InlineValueClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlineValueClientCapabilities &&other
        ) -> InlineValueClientCapabilities &;

        auto operator=(
            const InlineValueClientCapabilities &other
        ) -> InlineValueClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration for inline value providers.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct InlineValueClientCapabilities

    /**
     * Inlay hint client capabilities.
     *
     * @since 3.17.0
     */
    struct InlayHintClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlayHintClientCapabilities();
        InlayHintClientCapabilities(InlayHintClientCapabilities &&other);
        InlayHintClientCapabilities(const InlayHintClientCapabilities &other);
        ~InlayHintClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlayHintClientCapabilities &&other
        ) -> InlayHintClientCapabilities &;

        auto operator=(
            const InlayHintClientCapabilities &other
        ) -> InlayHintClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether inlay hints support dynamic registration.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * Indicates which properties a client can resolve lazily on an inlay
         * hint.
         */
        std::optional<InlayHintClientCapabilities_resolveSupport>
            resolveSupport;
    }; // struct InlayHintClientCapabilities

    /**
     * Client capabilities specific to diagnostic pull requests.
     *
     * @since 3.17.0
     */
    struct DiagnosticClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DiagnosticClientCapabilities();
        DiagnosticClientCapabilities(DiagnosticClientCapabilities &&other);
        DiagnosticClientCapabilities(
            const DiagnosticClientCapabilities &other
        );
        ~DiagnosticClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DiagnosticClientCapabilities &&other
        ) -> DiagnosticClientCapabilities &;

        auto operator=(
            const DiagnosticClientCapabilities &other
        ) -> DiagnosticClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration. If this is set to `true`
         * the client supports the new `(TextDocumentRegistrationOptions & StaticRegistrationOptions)`
         * return value for the corresponding server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * Whether the clients supports related documents for document diagnostic pulls.
         */
        std::optional<boolean_t> relatedDocumentSupport;
    }; // struct DiagnosticClientCapabilities

    /**
     * Client capabilities specific to inline completions.
     *
     * @since 3.18.0
     * @proposed
     */
    struct InlineCompletionClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineCompletionClientCapabilities();
        InlineCompletionClientCapabilities(
            InlineCompletionClientCapabilities &&other
        );
        InlineCompletionClientCapabilities(
            const InlineCompletionClientCapabilities &other
        );
        ~InlineCompletionClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlineCompletionClientCapabilities &&other
        ) -> InlineCompletionClientCapabilities &;

        auto operator=(
            const InlineCompletionClientCapabilities &other
        ) -> InlineCompletionClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration for inline completion providers.
         */
        std::optional<boolean_t> dynamicRegistration;
    }; // struct InlineCompletionClientCapabilities

    /**
     * Notebook specific client capabilities.
     *
     * @since 3.17.0
     */
    struct NotebookDocumentSyncClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentSyncClientCapabilities();
        NotebookDocumentSyncClientCapabilities(
            NotebookDocumentSyncClientCapabilities &&other
        );
        NotebookDocumentSyncClientCapabilities(
            const NotebookDocumentSyncClientCapabilities &other
        );
        ~NotebookDocumentSyncClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentSyncClientCapabilities &&other
        ) -> NotebookDocumentSyncClientCapabilities &;

        auto operator=(
            const NotebookDocumentSyncClientCapabilities &other
        ) -> NotebookDocumentSyncClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration. If this is
         * set to `true` the client supports the new
         * `(TextDocumentRegistrationOptions & StaticRegistrationOptions)`
         * return value for the corresponding server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * The client supports sending execution summary data per cell.
         */
        std::optional<boolean_t> executionSummarySupport;
    }; // struct NotebookDocumentSyncClientCapabilities

    /**
     * Capabilities specific to the notebook document support.
     *
     * @since 3.17.0
     */
    struct NotebookDocumentClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentClientCapabilities();
        NotebookDocumentClientCapabilities(
            NotebookDocumentClientCapabilities &&other
        );
        NotebookDocumentClientCapabilities(
            const NotebookDocumentClientCapabilities &other
        );
        ~NotebookDocumentClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentClientCapabilities &&other
        ) -> NotebookDocumentClientCapabilities &;

        auto operator=(
            const NotebookDocumentClientCapabilities &other
        ) -> NotebookDocumentClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Capabilities specific to notebook document synchronization
         *
         * @since 3.17.0
         */
        NotebookDocumentSyncClientCapabilities synchronization;
    }; // struct NotebookDocumentClientCapabilities

    struct ShowMessageRequestClientCapabilities_messageActionItem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ShowMessageRequestClientCapabilities_messageActionItem();
        ShowMessageRequestClientCapabilities_messageActionItem(
            ShowMessageRequestClientCapabilities_messageActionItem &&other
        );
        ShowMessageRequestClientCapabilities_messageActionItem(
            const ShowMessageRequestClientCapabilities_messageActionItem &other
        );
        ~ShowMessageRequestClientCapabilities_messageActionItem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ShowMessageRequestClientCapabilities_messageActionItem &&other
        ) -> ShowMessageRequestClientCapabilities_messageActionItem &;

        auto operator=(
            const ShowMessageRequestClientCapabilities_messageActionItem &other
        ) -> ShowMessageRequestClientCapabilities_messageActionItem &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether the client supports additional attributes which
         * are preserved and send back to the server in the
         * request's response.
         */
        std::optional<boolean_t> additionalPropertiesSupport;
    }; // struct ShowMessageRequestClientCapabilities_messageActionItem

    /**
     * Show message request client capabilities
     */
    struct ShowMessageRequestClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ShowMessageRequestClientCapabilities();
        ShowMessageRequestClientCapabilities(
            ShowMessageRequestClientCapabilities &&other
        );
        ShowMessageRequestClientCapabilities(
            const ShowMessageRequestClientCapabilities &other
        );
        ~ShowMessageRequestClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ShowMessageRequestClientCapabilities &&other
        ) -> ShowMessageRequestClientCapabilities &;

        auto operator=(
            const ShowMessageRequestClientCapabilities &other
        ) -> ShowMessageRequestClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Capabilities specific to the `MessageActionItem` type.
         */
        std::optional<ShowMessageRequestClientCapabilities_messageActionItem>
            messageActionItem;
    }; // struct ShowMessageRequestClientCapabilities

    /**
     * Client capabilities for the showDocument request.
     *
     * @since 3.16.0
     */
    struct ShowDocumentClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ShowDocumentClientCapabilities();
        ShowDocumentClientCapabilities(ShowDocumentClientCapabilities &&other);
        ShowDocumentClientCapabilities(
            const ShowDocumentClientCapabilities &other
        );
        ~ShowDocumentClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ShowDocumentClientCapabilities &&other
        ) -> ShowDocumentClientCapabilities &;

        auto operator=(
            const ShowDocumentClientCapabilities &other
        ) -> ShowDocumentClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The client has support for the showDocument
         * request.
         */
        boolean_t support;
    }; // struct ShowDocumentClientCapabilities

    struct WindowClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WindowClientCapabilities();
        WindowClientCapabilities(WindowClientCapabilities &&other);
        WindowClientCapabilities(const WindowClientCapabilities &other);
        ~WindowClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WindowClientCapabilities &&other
        ) -> WindowClientCapabilities &;

        auto operator=(
            const WindowClientCapabilities &other
        ) -> WindowClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * It indicates whether the client supports server initiated
         * progress using the `window/workDoneProgress/create` request.
         *
         * The capability also controls Whether client supports handling
         * of progress notifications. If set servers are allowed to report a
         * `workDoneProgress` property in the request specific server
         * capabilities.
         *
         * @since 3.15.0
         */
        std::optional<boolean_t> workDoneProgress;
        /**
         * Capabilities specific to the showMessage request.
         *
         * @since 3.16.0
         */
        std::optional<ShowMessageRequestClientCapabilities> showMessage;
        /**
         * Capabilities specific to the showDocument request.
         *
         * @since 3.16.0
         */
        std::optional<ShowDocumentClientCapabilities> showDocument;
    }; // struct WindowClientCapabilities

    struct PrepareRenameResult_2 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        PrepareRenameResult_2();
        PrepareRenameResult_2(PrepareRenameResult_2 &&other);
        PrepareRenameResult_2(const PrepareRenameResult_2 &other);
        ~PrepareRenameResult_2();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            PrepareRenameResult_2 &&other
        ) -> PrepareRenameResult_2 &;

        auto operator=(
            const PrepareRenameResult_2 &other
        ) -> PrepareRenameResult_2 &;

        // ================== //
        // Field Declarations //
        // ================== //

        boolean_t defaultBehavior;
    }; // struct PrepareRenameResult_2

    typedef ShowDocumentResult Window_ShowDocumentResult;

    typedef std::nullptr_t null_t;

    enum class TextDocumentRegistrationOptions_documentSelectorType {
        Uninitialized = -1,
        DocumentSelector = 0,
        Null = 1,
    }; // enum class TextDocumentRegistrationOptions_documentSelectorType

    extern const std::map<
        TextDocumentRegistrationOptions_documentSelectorType,
        std::string
    > TextDocumentRegistrationOptions_documentSelectorTypeNames;

    class TextDocumentRegistrationOptions_documentSelector {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentRegistrationOptions_documentSelector();
        TextDocumentRegistrationOptions_documentSelector(
            TextDocumentRegistrationOptions_documentSelector &&other
        );
        TextDocumentRegistrationOptions_documentSelector(
            const TextDocumentRegistrationOptions_documentSelector &other
        );
        ~TextDocumentRegistrationOptions_documentSelector();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentRegistrationOptions_documentSelector &&other
        ) -> TextDocumentRegistrationOptions_documentSelector &;

        auto operator=(
            const TextDocumentRegistrationOptions_documentSelector &other
        ) -> TextDocumentRegistrationOptions_documentSelector &;

        auto type() const
        -> const TextDocumentRegistrationOptions_documentSelectorType &;

        auto documentSelector() const -> const DocumentSelector &;

        auto operator=(
            const std::unique_ptr<DocumentSelector> &documentSelector
        ) -> TextDocumentRegistrationOptions_documentSelector &;

        auto operator=(
            std::unique_ptr<DocumentSelector> &&documentSelector
        ) -> TextDocumentRegistrationOptions_documentSelector &;

        auto operator=(
            const DocumentSelector &documentSelector
        ) -> TextDocumentRegistrationOptions_documentSelector &;

        auto operator=(
            DocumentSelector &&documentSelector
        ) -> TextDocumentRegistrationOptions_documentSelector &;

        auto null() const -> const null_t &;

        auto operator=(
            null_t null
        ) -> TextDocumentRegistrationOptions_documentSelector &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocumentRegistrationOptions_documentSelectorType _type{
            TextDocumentRegistrationOptions_documentSelectorType::Uninitialized
        };

        union {
            std::unique_ptr<DocumentSelector> _documentSelector;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocumentRegistrationOptions_documentSelector

    /**
     * General text document registration options.
     */
    struct TextDocumentRegistrationOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentRegistrationOptions();
        TextDocumentRegistrationOptions(
            TextDocumentRegistrationOptions &&other
        );
        TextDocumentRegistrationOptions(
            const TextDocumentRegistrationOptions &other
        );
        ~TextDocumentRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentRegistrationOptions &&other
        ) -> TextDocumentRegistrationOptions &;

        auto operator=(
            const TextDocumentRegistrationOptions &other
        ) -> TextDocumentRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A document selector to identify the scope of the registration. If set to null
         * the document selector provided on the client side will be used.
         */
        TextDocumentRegistrationOptions_documentSelector documentSelector;
    }; // struct TextDocumentRegistrationOptions

    struct ImplementationRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public ImplementationOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ImplementationRegistrationOptions();
        ImplementationRegistrationOptions(
            ImplementationRegistrationOptions &&other
        );
        ImplementationRegistrationOptions(
            const ImplementationRegistrationOptions &other
        );
        ~ImplementationRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ImplementationRegistrationOptions &&other
        ) -> ImplementationRegistrationOptions &;

        auto operator=(
            const ImplementationRegistrationOptions &other
        ) -> ImplementationRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct ImplementationRegistrationOptions

    struct TypeDefinitionRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public TypeDefinitionOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeDefinitionRegistrationOptions();
        TypeDefinitionRegistrationOptions(
            TypeDefinitionRegistrationOptions &&other
        );
        TypeDefinitionRegistrationOptions(
            const TypeDefinitionRegistrationOptions &other
        );
        ~TypeDefinitionRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TypeDefinitionRegistrationOptions &&other
        ) -> TypeDefinitionRegistrationOptions &;

        auto operator=(
            const TypeDefinitionRegistrationOptions &other
        ) -> TypeDefinitionRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct TypeDefinitionRegistrationOptions

    struct DocumentColorRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public DocumentColorOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentColorRegistrationOptions();
        DocumentColorRegistrationOptions(
            DocumentColorRegistrationOptions &&other
        );
        DocumentColorRegistrationOptions(
            const DocumentColorRegistrationOptions &other
        );
        ~DocumentColorRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentColorRegistrationOptions &&other
        ) -> DocumentColorRegistrationOptions &;

        auto operator=(
            const DocumentColorRegistrationOptions &other
        ) -> DocumentColorRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct DocumentColorRegistrationOptions

    struct FoldingRangeRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public FoldingRangeOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FoldingRangeRegistrationOptions();
        FoldingRangeRegistrationOptions(
            FoldingRangeRegistrationOptions &&other
        );
        FoldingRangeRegistrationOptions(
            const FoldingRangeRegistrationOptions &other
        );
        ~FoldingRangeRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            FoldingRangeRegistrationOptions &&other
        ) -> FoldingRangeRegistrationOptions &;

        auto operator=(
            const FoldingRangeRegistrationOptions &other
        ) -> FoldingRangeRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct FoldingRangeRegistrationOptions

    struct DeclarationRegistrationOptions
        : public DeclarationOptions
        , public TextDocumentRegistrationOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DeclarationRegistrationOptions();
        DeclarationRegistrationOptions(DeclarationRegistrationOptions &&other);
        DeclarationRegistrationOptions(
            const DeclarationRegistrationOptions &other
        );
        ~DeclarationRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DeclarationRegistrationOptions &&other
        ) -> DeclarationRegistrationOptions &;

        auto operator=(
            const DeclarationRegistrationOptions &other
        ) -> DeclarationRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct DeclarationRegistrationOptions

    struct SelectionRangeRegistrationOptions
        : public SelectionRangeOptions
        , public TextDocumentRegistrationOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SelectionRangeRegistrationOptions();
        SelectionRangeRegistrationOptions(
            SelectionRangeRegistrationOptions &&other
        );
        SelectionRangeRegistrationOptions(
            const SelectionRangeRegistrationOptions &other
        );
        ~SelectionRangeRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SelectionRangeRegistrationOptions &&other
        ) -> SelectionRangeRegistrationOptions &;

        auto operator=(
            const SelectionRangeRegistrationOptions &other
        ) -> SelectionRangeRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct SelectionRangeRegistrationOptions

    /**
     * Call hierarchy options used during static or dynamic registration.
     *
     * @since 3.16.0
     */
    struct CallHierarchyRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public CallHierarchyOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CallHierarchyRegistrationOptions();
        CallHierarchyRegistrationOptions(
            CallHierarchyRegistrationOptions &&other
        );
        CallHierarchyRegistrationOptions(
            const CallHierarchyRegistrationOptions &other
        );
        ~CallHierarchyRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CallHierarchyRegistrationOptions &&other
        ) -> CallHierarchyRegistrationOptions &;

        auto operator=(
            const CallHierarchyRegistrationOptions &other
        ) -> CallHierarchyRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct CallHierarchyRegistrationOptions

    struct LinkedEditingRangeRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public LinkedEditingRangeOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        LinkedEditingRangeRegistrationOptions();
        LinkedEditingRangeRegistrationOptions(
            LinkedEditingRangeRegistrationOptions &&other
        );
        LinkedEditingRangeRegistrationOptions(
            const LinkedEditingRangeRegistrationOptions &other
        );
        ~LinkedEditingRangeRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            LinkedEditingRangeRegistrationOptions &&other
        ) -> LinkedEditingRangeRegistrationOptions &;

        auto operator=(
            const LinkedEditingRangeRegistrationOptions &other
        ) -> LinkedEditingRangeRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct LinkedEditingRangeRegistrationOptions

    struct MonikerRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public MonikerOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        MonikerRegistrationOptions();
        MonikerRegistrationOptions(MonikerRegistrationOptions &&other);
        MonikerRegistrationOptions(const MonikerRegistrationOptions &other);
        ~MonikerRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            MonikerRegistrationOptions &&other
        ) -> MonikerRegistrationOptions &;

        auto operator=(
            const MonikerRegistrationOptions &other
        ) -> MonikerRegistrationOptions &;
    }; // struct MonikerRegistrationOptions

    /**
     * Type hierarchy options used during static or dynamic registration.
     *
     * @since 3.17.0
     */
    struct TypeHierarchyRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public TypeHierarchyOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeHierarchyRegistrationOptions();
        TypeHierarchyRegistrationOptions(
            TypeHierarchyRegistrationOptions &&other
        );
        TypeHierarchyRegistrationOptions(
            const TypeHierarchyRegistrationOptions &other
        );
        ~TypeHierarchyRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TypeHierarchyRegistrationOptions &&other
        ) -> TypeHierarchyRegistrationOptions &;

        auto operator=(
            const TypeHierarchyRegistrationOptions &other
        ) -> TypeHierarchyRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct TypeHierarchyRegistrationOptions

    /**
     * Inline value options used during static or dynamic registration.
     *
     * @since 3.17.0
     */
    struct InlineValueRegistrationOptions
        : public InlineValueOptions
        , public TextDocumentRegistrationOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineValueRegistrationOptions();
        InlineValueRegistrationOptions(InlineValueRegistrationOptions &&other);
        InlineValueRegistrationOptions(
            const InlineValueRegistrationOptions &other
        );
        ~InlineValueRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlineValueRegistrationOptions &&other
        ) -> InlineValueRegistrationOptions &;

        auto operator=(
            const InlineValueRegistrationOptions &other
        ) -> InlineValueRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct InlineValueRegistrationOptions

    /**
     * Inlay hint options used during static or dynamic registration.
     *
     * @since 3.17.0
     */
    struct InlayHintRegistrationOptions
        : public InlayHintOptions
        , public TextDocumentRegistrationOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlayHintRegistrationOptions();
        InlayHintRegistrationOptions(InlayHintRegistrationOptions &&other);
        InlayHintRegistrationOptions(
            const InlayHintRegistrationOptions &other
        );
        ~InlayHintRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlayHintRegistrationOptions &&other
        ) -> InlayHintRegistrationOptions &;

        auto operator=(
            const InlayHintRegistrationOptions &other
        ) -> InlayHintRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct InlayHintRegistrationOptions

    /**
     * Diagnostic registration options.
     *
     * @since 3.17.0
     */
    struct DiagnosticRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public DiagnosticOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DiagnosticRegistrationOptions();
        DiagnosticRegistrationOptions(DiagnosticRegistrationOptions &&other);
        DiagnosticRegistrationOptions(
            const DiagnosticRegistrationOptions &other
        );
        ~DiagnosticRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DiagnosticRegistrationOptions &&other
        ) -> DiagnosticRegistrationOptions &;

        auto operator=(
            const DiagnosticRegistrationOptions &other
        ) -> DiagnosticRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct DiagnosticRegistrationOptions

    /**
     * Inline completion options used during static or dynamic registration.
     *
     * @since 3.18.0
     * @proposed
     */
    struct InlineCompletionRegistrationOptions
        : public InlineCompletionOptions
        , public TextDocumentRegistrationOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineCompletionRegistrationOptions();
        InlineCompletionRegistrationOptions(
            InlineCompletionRegistrationOptions &&other
        );
        InlineCompletionRegistrationOptions(
            const InlineCompletionRegistrationOptions &other
        );
        ~InlineCompletionRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlineCompletionRegistrationOptions &&other
        ) -> InlineCompletionRegistrationOptions &;

        auto operator=(
            const InlineCompletionRegistrationOptions &other
        ) -> InlineCompletionRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct InlineCompletionRegistrationOptions

    /**
     * Describe options to be used when registered for text document change events.
     */
    struct TextDocumentChangeRegistrationOptions
        : public TextDocumentRegistrationOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentChangeRegistrationOptions();
        TextDocumentChangeRegistrationOptions(
            TextDocumentChangeRegistrationOptions &&other
        );
        TextDocumentChangeRegistrationOptions(
            const TextDocumentChangeRegistrationOptions &other
        );
        ~TextDocumentChangeRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentChangeRegistrationOptions &&other
        ) -> TextDocumentChangeRegistrationOptions &;

        auto operator=(
            const TextDocumentChangeRegistrationOptions &other
        ) -> TextDocumentChangeRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * How documents are synced to the server.
         */
        TextDocumentSyncKind syncKind;
    }; // struct TextDocumentChangeRegistrationOptions

    /**
     * Save registration options.
     */
    struct TextDocumentSaveRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public SaveOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentSaveRegistrationOptions();
        TextDocumentSaveRegistrationOptions(
            TextDocumentSaveRegistrationOptions &&other
        );
        TextDocumentSaveRegistrationOptions(
            const TextDocumentSaveRegistrationOptions &other
        );
        ~TextDocumentSaveRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentSaveRegistrationOptions &&other
        ) -> TextDocumentSaveRegistrationOptions &;

        auto operator=(
            const TextDocumentSaveRegistrationOptions &other
        ) -> TextDocumentSaveRegistrationOptions &;
    }; // struct TextDocumentSaveRegistrationOptions

    /**
     * Registration options for a {@link CompletionRequest}.
     */
    struct CompletionRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public CompletionOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionRegistrationOptions();
        CompletionRegistrationOptions(CompletionRegistrationOptions &&other);
        CompletionRegistrationOptions(
            const CompletionRegistrationOptions &other
        );
        ~CompletionRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionRegistrationOptions &&other
        ) -> CompletionRegistrationOptions &;

        auto operator=(
            const CompletionRegistrationOptions &other
        ) -> CompletionRegistrationOptions &;
    }; // struct CompletionRegistrationOptions

    /**
     * Registration options for a {@link HoverRequest}.
     */
    struct HoverRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public HoverOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        HoverRegistrationOptions();
        HoverRegistrationOptions(HoverRegistrationOptions &&other);
        HoverRegistrationOptions(const HoverRegistrationOptions &other);
        ~HoverRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            HoverRegistrationOptions &&other
        ) -> HoverRegistrationOptions &;

        auto operator=(
            const HoverRegistrationOptions &other
        ) -> HoverRegistrationOptions &;
    }; // struct HoverRegistrationOptions

    /**
     * Registration options for a {@link SignatureHelpRequest}.
     */
    struct SignatureHelpRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public SignatureHelpOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SignatureHelpRegistrationOptions();
        SignatureHelpRegistrationOptions(
            SignatureHelpRegistrationOptions &&other
        );
        SignatureHelpRegistrationOptions(
            const SignatureHelpRegistrationOptions &other
        );
        ~SignatureHelpRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SignatureHelpRegistrationOptions &&other
        ) -> SignatureHelpRegistrationOptions &;

        auto operator=(
            const SignatureHelpRegistrationOptions &other
        ) -> SignatureHelpRegistrationOptions &;
    }; // struct SignatureHelpRegistrationOptions

    /**
     * Registration options for a {@link DefinitionRequest}.
     */
    struct DefinitionRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public DefinitionOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DefinitionRegistrationOptions();
        DefinitionRegistrationOptions(DefinitionRegistrationOptions &&other);
        DefinitionRegistrationOptions(
            const DefinitionRegistrationOptions &other
        );
        ~DefinitionRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DefinitionRegistrationOptions &&other
        ) -> DefinitionRegistrationOptions &;

        auto operator=(
            const DefinitionRegistrationOptions &other
        ) -> DefinitionRegistrationOptions &;
    }; // struct DefinitionRegistrationOptions

    /**
     * Registration options for a {@link ReferencesRequest}.
     */
    struct ReferenceRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public ReferenceOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ReferenceRegistrationOptions();
        ReferenceRegistrationOptions(ReferenceRegistrationOptions &&other);
        ReferenceRegistrationOptions(
            const ReferenceRegistrationOptions &other
        );
        ~ReferenceRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ReferenceRegistrationOptions &&other
        ) -> ReferenceRegistrationOptions &;

        auto operator=(
            const ReferenceRegistrationOptions &other
        ) -> ReferenceRegistrationOptions &;
    }; // struct ReferenceRegistrationOptions

    /**
     * Registration options for a {@link DocumentHighlightRequest}.
     */
    struct DocumentHighlightRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public DocumentHighlightOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentHighlightRegistrationOptions();
        DocumentHighlightRegistrationOptions(
            DocumentHighlightRegistrationOptions &&other
        );
        DocumentHighlightRegistrationOptions(
            const DocumentHighlightRegistrationOptions &other
        );
        ~DocumentHighlightRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentHighlightRegistrationOptions &&other
        ) -> DocumentHighlightRegistrationOptions &;

        auto operator=(
            const DocumentHighlightRegistrationOptions &other
        ) -> DocumentHighlightRegistrationOptions &;
    }; // struct DocumentHighlightRegistrationOptions

    /**
     * Registration options for a {@link DocumentSymbolRequest}.
     */
    struct DocumentSymbolRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public DocumentSymbolOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentSymbolRegistrationOptions();
        DocumentSymbolRegistrationOptions(
            DocumentSymbolRegistrationOptions &&other
        );
        DocumentSymbolRegistrationOptions(
            const DocumentSymbolRegistrationOptions &other
        );
        ~DocumentSymbolRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentSymbolRegistrationOptions &&other
        ) -> DocumentSymbolRegistrationOptions &;

        auto operator=(
            const DocumentSymbolRegistrationOptions &other
        ) -> DocumentSymbolRegistrationOptions &;
    }; // struct DocumentSymbolRegistrationOptions

    /**
     * Registration options for a {@link CodeActionRequest}.
     */
    struct CodeActionRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public CodeActionOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeActionRegistrationOptions();
        CodeActionRegistrationOptions(CodeActionRegistrationOptions &&other);
        CodeActionRegistrationOptions(
            const CodeActionRegistrationOptions &other
        );
        ~CodeActionRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CodeActionRegistrationOptions &&other
        ) -> CodeActionRegistrationOptions &;

        auto operator=(
            const CodeActionRegistrationOptions &other
        ) -> CodeActionRegistrationOptions &;
    }; // struct CodeActionRegistrationOptions

    /**
     * Registration options for a {@link CodeLensRequest}.
     */
    struct CodeLensRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public CodeLensOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeLensRegistrationOptions();
        CodeLensRegistrationOptions(CodeLensRegistrationOptions &&other);
        CodeLensRegistrationOptions(const CodeLensRegistrationOptions &other);
        ~CodeLensRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CodeLensRegistrationOptions &&other
        ) -> CodeLensRegistrationOptions &;

        auto operator=(
            const CodeLensRegistrationOptions &other
        ) -> CodeLensRegistrationOptions &;
    }; // struct CodeLensRegistrationOptions

    /**
     * Registration options for a {@link DocumentLinkRequest}.
     */
    struct DocumentLinkRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public DocumentLinkOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentLinkRegistrationOptions();
        DocumentLinkRegistrationOptions(
            DocumentLinkRegistrationOptions &&other
        );
        DocumentLinkRegistrationOptions(
            const DocumentLinkRegistrationOptions &other
        );
        ~DocumentLinkRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentLinkRegistrationOptions &&other
        ) -> DocumentLinkRegistrationOptions &;

        auto operator=(
            const DocumentLinkRegistrationOptions &other
        ) -> DocumentLinkRegistrationOptions &;
    }; // struct DocumentLinkRegistrationOptions

    /**
     * Registration options for a {@link DocumentFormattingRequest}.
     */
    struct DocumentFormattingRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public DocumentFormattingOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentFormattingRegistrationOptions();
        DocumentFormattingRegistrationOptions(
            DocumentFormattingRegistrationOptions &&other
        );
        DocumentFormattingRegistrationOptions(
            const DocumentFormattingRegistrationOptions &other
        );
        ~DocumentFormattingRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentFormattingRegistrationOptions &&other
        ) -> DocumentFormattingRegistrationOptions &;

        auto operator=(
            const DocumentFormattingRegistrationOptions &other
        ) -> DocumentFormattingRegistrationOptions &;
    }; // struct DocumentFormattingRegistrationOptions

    /**
     * Registration options for a {@link DocumentRangeFormattingRequest}.
     */
    struct DocumentRangeFormattingRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public DocumentRangeFormattingOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentRangeFormattingRegistrationOptions();
        DocumentRangeFormattingRegistrationOptions(
            DocumentRangeFormattingRegistrationOptions &&other
        );
        DocumentRangeFormattingRegistrationOptions(
            const DocumentRangeFormattingRegistrationOptions &other
        );
        ~DocumentRangeFormattingRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentRangeFormattingRegistrationOptions &&other
        ) -> DocumentRangeFormattingRegistrationOptions &;

        auto operator=(
            const DocumentRangeFormattingRegistrationOptions &other
        ) -> DocumentRangeFormattingRegistrationOptions &;
    }; // struct DocumentRangeFormattingRegistrationOptions

    /**
     * Registration options for a {@link DocumentOnTypeFormattingRequest}.
     */
    struct DocumentOnTypeFormattingRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public DocumentOnTypeFormattingOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentOnTypeFormattingRegistrationOptions();
        DocumentOnTypeFormattingRegistrationOptions(
            DocumentOnTypeFormattingRegistrationOptions &&other
        );
        DocumentOnTypeFormattingRegistrationOptions(
            const DocumentOnTypeFormattingRegistrationOptions &other
        );
        ~DocumentOnTypeFormattingRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentOnTypeFormattingRegistrationOptions &&other
        ) -> DocumentOnTypeFormattingRegistrationOptions &;

        auto operator=(
            const DocumentOnTypeFormattingRegistrationOptions &other
        ) -> DocumentOnTypeFormattingRegistrationOptions &;
    }; // struct DocumentOnTypeFormattingRegistrationOptions

    /**
     * Registration options for a {@link RenameRequest}.
     */
    struct RenameRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public RenameOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RenameRegistrationOptions();
        RenameRegistrationOptions(RenameRegistrationOptions &&other);
        RenameRegistrationOptions(const RenameRegistrationOptions &other);
        ~RenameRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            RenameRegistrationOptions &&other
        ) -> RenameRegistrationOptions &;

        auto operator=(
            const RenameRegistrationOptions &other
        ) -> RenameRegistrationOptions &;
    }; // struct RenameRegistrationOptions

    enum class _InitializeParams_rootPathType {
        Uninitialized = -1,
        String = 0,
        Null = 1,
    }; // enum class _InitializeParams_rootPathType

    extern const std::map<_InitializeParams_rootPathType, std::string>
        _InitializeParams_rootPathTypeNames;

    class _InitializeParams_rootPath {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        _InitializeParams_rootPath();
        _InitializeParams_rootPath(_InitializeParams_rootPath &&other);
        _InitializeParams_rootPath(const _InitializeParams_rootPath &other);
        ~_InitializeParams_rootPath();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            _InitializeParams_rootPath &&other
        ) -> _InitializeParams_rootPath &;

        auto operator=(
            const _InitializeParams_rootPath &other
        ) -> _InitializeParams_rootPath &;

        auto type() const -> const _InitializeParams_rootPathType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> _InitializeParams_rootPath &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> _InitializeParams_rootPath &;

        auto operator=(const string_t &string) -> _InitializeParams_rootPath &;

        auto operator=(string_t &&string) -> _InitializeParams_rootPath &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> _InitializeParams_rootPath &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        _InitializeParams_rootPathType _type{
            _InitializeParams_rootPathType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            null_t _null;
        };

        auto reset() -> void;
    }; // class _InitializeParams_rootPath

    enum class _InitializeParams_rootUriType {
        Uninitialized = -1,
        String = 0,
        Null = 1,
    }; // enum class _InitializeParams_rootUriType

    extern const std::map<_InitializeParams_rootUriType, std::string>
        _InitializeParams_rootUriTypeNames;

    class _InitializeParams_rootUri {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        _InitializeParams_rootUri();
        _InitializeParams_rootUri(_InitializeParams_rootUri &&other);
        _InitializeParams_rootUri(const _InitializeParams_rootUri &other);
        ~_InitializeParams_rootUri();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            _InitializeParams_rootUri &&other
        ) -> _InitializeParams_rootUri &;

        auto operator=(
            const _InitializeParams_rootUri &other
        ) -> _InitializeParams_rootUri &;

        auto type() const -> const _InitializeParams_rootUriType &;

        auto documentUri() const -> const DocumentUri &;

        auto operator=(
            const std::unique_ptr<DocumentUri> &documentUri
        ) -> _InitializeParams_rootUri &;

        auto operator=(
            std::unique_ptr<DocumentUri> &&documentUri
        ) -> _InitializeParams_rootUri &;

        auto operator=(
            const DocumentUri &documentUri
        ) -> _InitializeParams_rootUri &;

        auto operator=(
            DocumentUri &&documentUri
        ) -> _InitializeParams_rootUri &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> _InitializeParams_rootUri &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        _InitializeParams_rootUriType _type{
            _InitializeParams_rootUriType::Uninitialized
        };

        union {
            std::unique_ptr<DocumentUri> _documentUri;
            null_t _null;
        };

        auto reset() -> void;
    }; // class _InitializeParams_rootUri

    enum class WorkspaceFoldersInitializeParams_workspaceFoldersType {
        Uninitialized = -1,
        WorkspaceFolderArray = 0,
        Null = 1,
    }; // enum class WorkspaceFoldersInitializeParams_workspaceFoldersType

    extern const std::map<
        WorkspaceFoldersInitializeParams_workspaceFoldersType,
        std::string
    > WorkspaceFoldersInitializeParams_workspaceFoldersTypeNames;

    class WorkspaceFoldersInitializeParams_workspaceFolders {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceFoldersInitializeParams_workspaceFolders();
        WorkspaceFoldersInitializeParams_workspaceFolders(
            WorkspaceFoldersInitializeParams_workspaceFolders &&other
        );
        WorkspaceFoldersInitializeParams_workspaceFolders(
            const WorkspaceFoldersInitializeParams_workspaceFolders &other
        );
        ~WorkspaceFoldersInitializeParams_workspaceFolders();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceFoldersInitializeParams_workspaceFolders &&other
        ) -> WorkspaceFoldersInitializeParams_workspaceFolders &;

        auto operator=(
            const WorkspaceFoldersInitializeParams_workspaceFolders &other
        ) -> WorkspaceFoldersInitializeParams_workspaceFolders &;

        auto type() const
        -> const WorkspaceFoldersInitializeParams_workspaceFoldersType &;

        auto workspaceFolderArray() const
        -> const std::vector<WorkspaceFolder> &;

        auto operator=(
            const std::unique_ptr<std::vector<WorkspaceFolder>> &workspaceFolderArray
        ) -> WorkspaceFoldersInitializeParams_workspaceFolders &;

        auto operator=(
            std::unique_ptr<std::vector<WorkspaceFolder>> &&workspaceFolderArray
        ) -> WorkspaceFoldersInitializeParams_workspaceFolders &;

        auto operator=(
            const std::vector<WorkspaceFolder> &workspaceFolderArray
        ) -> WorkspaceFoldersInitializeParams_workspaceFolders &;

        auto operator=(
            std::vector<WorkspaceFolder> &&workspaceFolderArray
        ) -> WorkspaceFoldersInitializeParams_workspaceFolders &;

        auto null() const -> const null_t &;

        auto operator=(
            null_t null
        ) -> WorkspaceFoldersInitializeParams_workspaceFolders &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        WorkspaceFoldersInitializeParams_workspaceFoldersType _type{
            WorkspaceFoldersInitializeParams_workspaceFoldersType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<WorkspaceFolder>> _workspaceFolderArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class WorkspaceFoldersInitializeParams_workspaceFolders

    struct WorkspaceFoldersInitializeParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceFoldersInitializeParams();
        WorkspaceFoldersInitializeParams(
            WorkspaceFoldersInitializeParams &&other
        );
        WorkspaceFoldersInitializeParams(
            const WorkspaceFoldersInitializeParams &other
        );
        ~WorkspaceFoldersInitializeParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceFoldersInitializeParams &&other
        ) -> WorkspaceFoldersInitializeParams &;

        auto operator=(
            const WorkspaceFoldersInitializeParams &other
        ) -> WorkspaceFoldersInitializeParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The workspace folders configured in the client when the server starts.
         *
         * This property is only available if the client supports workspace folders.
         * It can be `null` if the client supports workspace folders but none are
         * configured.
         *
         * @since 3.6.0
         */
        std::optional<WorkspaceFoldersInitializeParams_workspaceFolders>
            workspaceFolders;
    }; // struct WorkspaceFoldersInitializeParams

    enum class ServerCapabilities_declarationProviderType {
        Uninitialized = -1,
        Boolean = 0,
        DeclarationOptions = 1,
        DeclarationRegistrationOptions = 2,
    }; // enum class ServerCapabilities_declarationProviderType

    extern const std::map<
        ServerCapabilities_declarationProviderType,
        std::string
    > ServerCapabilities_declarationProviderTypeNames;

    class ServerCapabilities_declarationProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_declarationProvider();
        ServerCapabilities_declarationProvider(
            ServerCapabilities_declarationProvider &&other
        );
        ServerCapabilities_declarationProvider(
            const ServerCapabilities_declarationProvider &other
        );
        ~ServerCapabilities_declarationProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_declarationProvider &&other
        ) -> ServerCapabilities_declarationProvider &;

        auto operator=(
            const ServerCapabilities_declarationProvider &other
        ) -> ServerCapabilities_declarationProvider &;

        auto type() const
        -> const ServerCapabilities_declarationProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_declarationProvider &;

        auto declarationOptions() const -> const DeclarationOptions &;

        auto operator=(
            const std::unique_ptr<DeclarationOptions> &declarationOptions
        ) -> ServerCapabilities_declarationProvider &;

        auto operator=(
            std::unique_ptr<DeclarationOptions> &&declarationOptions
        ) -> ServerCapabilities_declarationProvider &;

        auto operator=(
            const DeclarationOptions &declarationOptions
        ) -> ServerCapabilities_declarationProvider &;

        auto operator=(
            DeclarationOptions &&declarationOptions
        ) -> ServerCapabilities_declarationProvider &;

        auto declarationRegistrationOptions() const
        -> const DeclarationRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<DeclarationRegistrationOptions> &declarationRegistrationOptions
        ) -> ServerCapabilities_declarationProvider &;

        auto operator=(
            std::unique_ptr<DeclarationRegistrationOptions> &&declarationRegistrationOptions
        ) -> ServerCapabilities_declarationProvider &;

        auto operator=(
            const DeclarationRegistrationOptions &declarationRegistrationOptions
        ) -> ServerCapabilities_declarationProvider &;

        auto operator=(
            DeclarationRegistrationOptions &&declarationRegistrationOptions
        ) -> ServerCapabilities_declarationProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_declarationProviderType _type{
            ServerCapabilities_declarationProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<DeclarationOptions> _declarationOptions;
            std::unique_ptr<DeclarationRegistrationOptions> _declarationRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_declarationProvider

    enum class ServerCapabilities_typeDefinitionProviderType {
        Uninitialized = -1,
        Boolean = 0,
        TypeDefinitionOptions = 1,
        TypeDefinitionRegistrationOptions = 2,
    }; // enum class ServerCapabilities_typeDefinitionProviderType

    extern const std::map<
        ServerCapabilities_typeDefinitionProviderType,
        std::string
    > ServerCapabilities_typeDefinitionProviderTypeNames;

    class ServerCapabilities_typeDefinitionProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_typeDefinitionProvider();
        ServerCapabilities_typeDefinitionProvider(
            ServerCapabilities_typeDefinitionProvider &&other
        );
        ServerCapabilities_typeDefinitionProvider(
            const ServerCapabilities_typeDefinitionProvider &other
        );
        ~ServerCapabilities_typeDefinitionProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_typeDefinitionProvider &&other
        ) -> ServerCapabilities_typeDefinitionProvider &;

        auto operator=(
            const ServerCapabilities_typeDefinitionProvider &other
        ) -> ServerCapabilities_typeDefinitionProvider &;

        auto type() const
        -> const ServerCapabilities_typeDefinitionProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_typeDefinitionProvider &;

        auto typeDefinitionOptions() const -> const TypeDefinitionOptions &;

        auto operator=(
            const std::unique_ptr<TypeDefinitionOptions> &typeDefinitionOptions
        ) -> ServerCapabilities_typeDefinitionProvider &;

        auto operator=(
            std::unique_ptr<TypeDefinitionOptions> &&typeDefinitionOptions
        ) -> ServerCapabilities_typeDefinitionProvider &;

        auto operator=(
            const TypeDefinitionOptions &typeDefinitionOptions
        ) -> ServerCapabilities_typeDefinitionProvider &;

        auto operator=(
            TypeDefinitionOptions &&typeDefinitionOptions
        ) -> ServerCapabilities_typeDefinitionProvider &;

        auto typeDefinitionRegistrationOptions() const
        -> const TypeDefinitionRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<TypeDefinitionRegistrationOptions> &typeDefinitionRegistrationOptions
        ) -> ServerCapabilities_typeDefinitionProvider &;

        auto operator=(
            std::unique_ptr<TypeDefinitionRegistrationOptions> &&typeDefinitionRegistrationOptions
        ) -> ServerCapabilities_typeDefinitionProvider &;

        auto operator=(
            const TypeDefinitionRegistrationOptions &typeDefinitionRegistrationOptions
        ) -> ServerCapabilities_typeDefinitionProvider &;

        auto operator=(
            TypeDefinitionRegistrationOptions &&typeDefinitionRegistrationOptions
        ) -> ServerCapabilities_typeDefinitionProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_typeDefinitionProviderType _type{
            ServerCapabilities_typeDefinitionProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<TypeDefinitionOptions> _typeDefinitionOptions;
            std::unique_ptr<TypeDefinitionRegistrationOptions> _typeDefinitionRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_typeDefinitionProvider

    enum class ServerCapabilities_implementationProviderType {
        Uninitialized = -1,
        Boolean = 0,
        ImplementationOptions = 1,
        ImplementationRegistrationOptions = 2,
    }; // enum class ServerCapabilities_implementationProviderType

    extern const std::map<
        ServerCapabilities_implementationProviderType,
        std::string
    > ServerCapabilities_implementationProviderTypeNames;

    class ServerCapabilities_implementationProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_implementationProvider();
        ServerCapabilities_implementationProvider(
            ServerCapabilities_implementationProvider &&other
        );
        ServerCapabilities_implementationProvider(
            const ServerCapabilities_implementationProvider &other
        );
        ~ServerCapabilities_implementationProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_implementationProvider &&other
        ) -> ServerCapabilities_implementationProvider &;

        auto operator=(
            const ServerCapabilities_implementationProvider &other
        ) -> ServerCapabilities_implementationProvider &;

        auto type() const
        -> const ServerCapabilities_implementationProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_implementationProvider &;

        auto implementationOptions() const -> const ImplementationOptions &;

        auto operator=(
            const std::unique_ptr<ImplementationOptions> &implementationOptions
        ) -> ServerCapabilities_implementationProvider &;

        auto operator=(
            std::unique_ptr<ImplementationOptions> &&implementationOptions
        ) -> ServerCapabilities_implementationProvider &;

        auto operator=(
            const ImplementationOptions &implementationOptions
        ) -> ServerCapabilities_implementationProvider &;

        auto operator=(
            ImplementationOptions &&implementationOptions
        ) -> ServerCapabilities_implementationProvider &;

        auto implementationRegistrationOptions() const
        -> const ImplementationRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<ImplementationRegistrationOptions> &implementationRegistrationOptions
        ) -> ServerCapabilities_implementationProvider &;

        auto operator=(
            std::unique_ptr<ImplementationRegistrationOptions> &&implementationRegistrationOptions
        ) -> ServerCapabilities_implementationProvider &;

        auto operator=(
            const ImplementationRegistrationOptions &implementationRegistrationOptions
        ) -> ServerCapabilities_implementationProvider &;

        auto operator=(
            ImplementationRegistrationOptions &&implementationRegistrationOptions
        ) -> ServerCapabilities_implementationProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_implementationProviderType _type{
            ServerCapabilities_implementationProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<ImplementationOptions> _implementationOptions;
            std::unique_ptr<ImplementationRegistrationOptions> _implementationRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_implementationProvider

    enum class ServerCapabilities_colorProviderType {
        Uninitialized = -1,
        Boolean = 0,
        DocumentColorOptions = 1,
        DocumentColorRegistrationOptions = 2,
    }; // enum class ServerCapabilities_colorProviderType

    extern const std::map<ServerCapabilities_colorProviderType, std::string>
        ServerCapabilities_colorProviderTypeNames;

    class ServerCapabilities_colorProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_colorProvider();
        ServerCapabilities_colorProvider(
            ServerCapabilities_colorProvider &&other
        );
        ServerCapabilities_colorProvider(
            const ServerCapabilities_colorProvider &other
        );
        ~ServerCapabilities_colorProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_colorProvider &&other
        ) -> ServerCapabilities_colorProvider &;

        auto operator=(
            const ServerCapabilities_colorProvider &other
        ) -> ServerCapabilities_colorProvider &;

        auto type() const -> const ServerCapabilities_colorProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_colorProvider &;

        auto documentColorOptions() const -> const DocumentColorOptions &;

        auto operator=(
            const std::unique_ptr<DocumentColorOptions> &documentColorOptions
        ) -> ServerCapabilities_colorProvider &;

        auto operator=(
            std::unique_ptr<DocumentColorOptions> &&documentColorOptions
        ) -> ServerCapabilities_colorProvider &;

        auto operator=(
            const DocumentColorOptions &documentColorOptions
        ) -> ServerCapabilities_colorProvider &;

        auto operator=(
            DocumentColorOptions &&documentColorOptions
        ) -> ServerCapabilities_colorProvider &;

        auto documentColorRegistrationOptions() const
        -> const DocumentColorRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<DocumentColorRegistrationOptions> &documentColorRegistrationOptions
        ) -> ServerCapabilities_colorProvider &;

        auto operator=(
            std::unique_ptr<DocumentColorRegistrationOptions> &&documentColorRegistrationOptions
        ) -> ServerCapabilities_colorProvider &;

        auto operator=(
            const DocumentColorRegistrationOptions &documentColorRegistrationOptions
        ) -> ServerCapabilities_colorProvider &;

        auto operator=(
            DocumentColorRegistrationOptions &&documentColorRegistrationOptions
        ) -> ServerCapabilities_colorProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_colorProviderType _type{
            ServerCapabilities_colorProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<DocumentColorOptions> _documentColorOptions;
            std::unique_ptr<DocumentColorRegistrationOptions> _documentColorRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_colorProvider

    enum class ServerCapabilities_foldingRangeProviderType {
        Uninitialized = -1,
        Boolean = 0,
        FoldingRangeOptions = 1,
        FoldingRangeRegistrationOptions = 2,
    }; // enum class ServerCapabilities_foldingRangeProviderType

    extern const std::map<
        ServerCapabilities_foldingRangeProviderType,
        std::string
    > ServerCapabilities_foldingRangeProviderTypeNames;

    class ServerCapabilities_foldingRangeProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_foldingRangeProvider();
        ServerCapabilities_foldingRangeProvider(
            ServerCapabilities_foldingRangeProvider &&other
        );
        ServerCapabilities_foldingRangeProvider(
            const ServerCapabilities_foldingRangeProvider &other
        );
        ~ServerCapabilities_foldingRangeProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_foldingRangeProvider &&other
        ) -> ServerCapabilities_foldingRangeProvider &;

        auto operator=(
            const ServerCapabilities_foldingRangeProvider &other
        ) -> ServerCapabilities_foldingRangeProvider &;

        auto type() const
        -> const ServerCapabilities_foldingRangeProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_foldingRangeProvider &;

        auto foldingRangeOptions() const -> const FoldingRangeOptions &;

        auto operator=(
            const std::unique_ptr<FoldingRangeOptions> &foldingRangeOptions
        ) -> ServerCapabilities_foldingRangeProvider &;

        auto operator=(
            std::unique_ptr<FoldingRangeOptions> &&foldingRangeOptions
        ) -> ServerCapabilities_foldingRangeProvider &;

        auto operator=(
            const FoldingRangeOptions &foldingRangeOptions
        ) -> ServerCapabilities_foldingRangeProvider &;

        auto operator=(
            FoldingRangeOptions &&foldingRangeOptions
        ) -> ServerCapabilities_foldingRangeProvider &;

        auto foldingRangeRegistrationOptions() const
        -> const FoldingRangeRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<FoldingRangeRegistrationOptions> &foldingRangeRegistrationOptions
        ) -> ServerCapabilities_foldingRangeProvider &;

        auto operator=(
            std::unique_ptr<FoldingRangeRegistrationOptions> &&foldingRangeRegistrationOptions
        ) -> ServerCapabilities_foldingRangeProvider &;

        auto operator=(
            const FoldingRangeRegistrationOptions &foldingRangeRegistrationOptions
        ) -> ServerCapabilities_foldingRangeProvider &;

        auto operator=(
            FoldingRangeRegistrationOptions &&foldingRangeRegistrationOptions
        ) -> ServerCapabilities_foldingRangeProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_foldingRangeProviderType _type{
            ServerCapabilities_foldingRangeProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<FoldingRangeOptions> _foldingRangeOptions;
            std::unique_ptr<FoldingRangeRegistrationOptions> _foldingRangeRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_foldingRangeProvider

    enum class ServerCapabilities_selectionRangeProviderType {
        Uninitialized = -1,
        Boolean = 0,
        SelectionRangeOptions = 1,
        SelectionRangeRegistrationOptions = 2,
    }; // enum class ServerCapabilities_selectionRangeProviderType

    extern const std::map<
        ServerCapabilities_selectionRangeProviderType,
        std::string
    > ServerCapabilities_selectionRangeProviderTypeNames;

    class ServerCapabilities_selectionRangeProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_selectionRangeProvider();
        ServerCapabilities_selectionRangeProvider(
            ServerCapabilities_selectionRangeProvider &&other
        );
        ServerCapabilities_selectionRangeProvider(
            const ServerCapabilities_selectionRangeProvider &other
        );
        ~ServerCapabilities_selectionRangeProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_selectionRangeProvider &&other
        ) -> ServerCapabilities_selectionRangeProvider &;

        auto operator=(
            const ServerCapabilities_selectionRangeProvider &other
        ) -> ServerCapabilities_selectionRangeProvider &;

        auto type() const
        -> const ServerCapabilities_selectionRangeProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_selectionRangeProvider &;

        auto selectionRangeOptions() const -> const SelectionRangeOptions &;

        auto operator=(
            const std::unique_ptr<SelectionRangeOptions> &selectionRangeOptions
        ) -> ServerCapabilities_selectionRangeProvider &;

        auto operator=(
            std::unique_ptr<SelectionRangeOptions> &&selectionRangeOptions
        ) -> ServerCapabilities_selectionRangeProvider &;

        auto operator=(
            const SelectionRangeOptions &selectionRangeOptions
        ) -> ServerCapabilities_selectionRangeProvider &;

        auto operator=(
            SelectionRangeOptions &&selectionRangeOptions
        ) -> ServerCapabilities_selectionRangeProvider &;

        auto selectionRangeRegistrationOptions() const
        -> const SelectionRangeRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<SelectionRangeRegistrationOptions> &selectionRangeRegistrationOptions
        ) -> ServerCapabilities_selectionRangeProvider &;

        auto operator=(
            std::unique_ptr<SelectionRangeRegistrationOptions> &&selectionRangeRegistrationOptions
        ) -> ServerCapabilities_selectionRangeProvider &;

        auto operator=(
            const SelectionRangeRegistrationOptions &selectionRangeRegistrationOptions
        ) -> ServerCapabilities_selectionRangeProvider &;

        auto operator=(
            SelectionRangeRegistrationOptions &&selectionRangeRegistrationOptions
        ) -> ServerCapabilities_selectionRangeProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_selectionRangeProviderType _type{
            ServerCapabilities_selectionRangeProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<SelectionRangeOptions> _selectionRangeOptions;
            std::unique_ptr<SelectionRangeRegistrationOptions> _selectionRangeRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_selectionRangeProvider

    enum class ServerCapabilities_callHierarchyProviderType {
        Uninitialized = -1,
        Boolean = 0,
        CallHierarchyOptions = 1,
        CallHierarchyRegistrationOptions = 2,
    }; // enum class ServerCapabilities_callHierarchyProviderType

    extern const std::map<
        ServerCapabilities_callHierarchyProviderType,
        std::string
    > ServerCapabilities_callHierarchyProviderTypeNames;

    class ServerCapabilities_callHierarchyProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_callHierarchyProvider();
        ServerCapabilities_callHierarchyProvider(
            ServerCapabilities_callHierarchyProvider &&other
        );
        ServerCapabilities_callHierarchyProvider(
            const ServerCapabilities_callHierarchyProvider &other
        );
        ~ServerCapabilities_callHierarchyProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_callHierarchyProvider &&other
        ) -> ServerCapabilities_callHierarchyProvider &;

        auto operator=(
            const ServerCapabilities_callHierarchyProvider &other
        ) -> ServerCapabilities_callHierarchyProvider &;

        auto type() const
        -> const ServerCapabilities_callHierarchyProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_callHierarchyProvider &;

        auto callHierarchyOptions() const -> const CallHierarchyOptions &;

        auto operator=(
            const std::unique_ptr<CallHierarchyOptions> &callHierarchyOptions
        ) -> ServerCapabilities_callHierarchyProvider &;

        auto operator=(
            std::unique_ptr<CallHierarchyOptions> &&callHierarchyOptions
        ) -> ServerCapabilities_callHierarchyProvider &;

        auto operator=(
            const CallHierarchyOptions &callHierarchyOptions
        ) -> ServerCapabilities_callHierarchyProvider &;

        auto operator=(
            CallHierarchyOptions &&callHierarchyOptions
        ) -> ServerCapabilities_callHierarchyProvider &;

        auto callHierarchyRegistrationOptions() const
        -> const CallHierarchyRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<CallHierarchyRegistrationOptions> &callHierarchyRegistrationOptions
        ) -> ServerCapabilities_callHierarchyProvider &;

        auto operator=(
            std::unique_ptr<CallHierarchyRegistrationOptions> &&callHierarchyRegistrationOptions
        ) -> ServerCapabilities_callHierarchyProvider &;

        auto operator=(
            const CallHierarchyRegistrationOptions &callHierarchyRegistrationOptions
        ) -> ServerCapabilities_callHierarchyProvider &;

        auto operator=(
            CallHierarchyRegistrationOptions &&callHierarchyRegistrationOptions
        ) -> ServerCapabilities_callHierarchyProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_callHierarchyProviderType _type{
            ServerCapabilities_callHierarchyProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<CallHierarchyOptions> _callHierarchyOptions;
            std::unique_ptr<CallHierarchyRegistrationOptions> _callHierarchyRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_callHierarchyProvider

    enum class ServerCapabilities_linkedEditingRangeProviderType {
        Uninitialized = -1,
        Boolean = 0,
        LinkedEditingRangeOptions = 1,
        LinkedEditingRangeRegistrationOptions = 2,
    }; // enum class ServerCapabilities_linkedEditingRangeProviderType

    extern const std::map<
        ServerCapabilities_linkedEditingRangeProviderType,
        std::string
    > ServerCapabilities_linkedEditingRangeProviderTypeNames;

    class ServerCapabilities_linkedEditingRangeProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_linkedEditingRangeProvider();
        ServerCapabilities_linkedEditingRangeProvider(
            ServerCapabilities_linkedEditingRangeProvider &&other
        );
        ServerCapabilities_linkedEditingRangeProvider(
            const ServerCapabilities_linkedEditingRangeProvider &other
        );
        ~ServerCapabilities_linkedEditingRangeProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_linkedEditingRangeProvider &&other
        ) -> ServerCapabilities_linkedEditingRangeProvider &;

        auto operator=(
            const ServerCapabilities_linkedEditingRangeProvider &other
        ) -> ServerCapabilities_linkedEditingRangeProvider &;

        auto type() const
        -> const ServerCapabilities_linkedEditingRangeProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_linkedEditingRangeProvider &;

        auto linkedEditingRangeOptions() const
        -> const LinkedEditingRangeOptions &;

        auto operator=(
            const std::unique_ptr<LinkedEditingRangeOptions> &linkedEditingRangeOptions
        ) -> ServerCapabilities_linkedEditingRangeProvider &;

        auto operator=(
            std::unique_ptr<LinkedEditingRangeOptions> &&linkedEditingRangeOptions
        ) -> ServerCapabilities_linkedEditingRangeProvider &;

        auto operator=(
            const LinkedEditingRangeOptions &linkedEditingRangeOptions
        ) -> ServerCapabilities_linkedEditingRangeProvider &;

        auto operator=(
            LinkedEditingRangeOptions &&linkedEditingRangeOptions
        ) -> ServerCapabilities_linkedEditingRangeProvider &;

        auto linkedEditingRangeRegistrationOptions() const
        -> const LinkedEditingRangeRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<LinkedEditingRangeRegistrationOptions> &linkedEditingRangeRegistrationOptions
        ) -> ServerCapabilities_linkedEditingRangeProvider &;

        auto operator=(
            std::unique_ptr<LinkedEditingRangeRegistrationOptions> &&linkedEditingRangeRegistrationOptions
        ) -> ServerCapabilities_linkedEditingRangeProvider &;

        auto operator=(
            const LinkedEditingRangeRegistrationOptions &linkedEditingRangeRegistrationOptions
        ) -> ServerCapabilities_linkedEditingRangeProvider &;

        auto operator=(
            LinkedEditingRangeRegistrationOptions &&linkedEditingRangeRegistrationOptions
        ) -> ServerCapabilities_linkedEditingRangeProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_linkedEditingRangeProviderType _type{
            ServerCapabilities_linkedEditingRangeProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<LinkedEditingRangeOptions> _linkedEditingRangeOptions;
            std::unique_ptr<LinkedEditingRangeRegistrationOptions> _linkedEditingRangeRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_linkedEditingRangeProvider

    enum class ServerCapabilities_monikerProviderType {
        Uninitialized = -1,
        Boolean = 0,
        MonikerOptions = 1,
        MonikerRegistrationOptions = 2,
    }; // enum class ServerCapabilities_monikerProviderType

    extern const std::map<ServerCapabilities_monikerProviderType, std::string>
        ServerCapabilities_monikerProviderTypeNames;

    class ServerCapabilities_monikerProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_monikerProvider();
        ServerCapabilities_monikerProvider(
            ServerCapabilities_monikerProvider &&other
        );
        ServerCapabilities_monikerProvider(
            const ServerCapabilities_monikerProvider &other
        );
        ~ServerCapabilities_monikerProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_monikerProvider &&other
        ) -> ServerCapabilities_monikerProvider &;

        auto operator=(
            const ServerCapabilities_monikerProvider &other
        ) -> ServerCapabilities_monikerProvider &;

        auto type() const -> const ServerCapabilities_monikerProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_monikerProvider &;

        auto monikerOptions() const -> const MonikerOptions &;

        auto operator=(
            const std::unique_ptr<MonikerOptions> &monikerOptions
        ) -> ServerCapabilities_monikerProvider &;

        auto operator=(
            std::unique_ptr<MonikerOptions> &&monikerOptions
        ) -> ServerCapabilities_monikerProvider &;

        auto operator=(
            const MonikerOptions &monikerOptions
        ) -> ServerCapabilities_monikerProvider &;

        auto operator=(
            MonikerOptions &&monikerOptions
        ) -> ServerCapabilities_monikerProvider &;

        auto monikerRegistrationOptions() const
        -> const MonikerRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<MonikerRegistrationOptions> &monikerRegistrationOptions
        ) -> ServerCapabilities_monikerProvider &;

        auto operator=(
            std::unique_ptr<MonikerRegistrationOptions> &&monikerRegistrationOptions
        ) -> ServerCapabilities_monikerProvider &;

        auto operator=(
            const MonikerRegistrationOptions &monikerRegistrationOptions
        ) -> ServerCapabilities_monikerProvider &;

        auto operator=(
            MonikerRegistrationOptions &&monikerRegistrationOptions
        ) -> ServerCapabilities_monikerProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_monikerProviderType _type{
            ServerCapabilities_monikerProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<MonikerOptions> _monikerOptions;
            std::unique_ptr<MonikerRegistrationOptions> _monikerRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_monikerProvider

    enum class ServerCapabilities_typeHierarchyProviderType {
        Uninitialized = -1,
        Boolean = 0,
        TypeHierarchyOptions = 1,
        TypeHierarchyRegistrationOptions = 2,
    }; // enum class ServerCapabilities_typeHierarchyProviderType

    extern const std::map<
        ServerCapabilities_typeHierarchyProviderType,
        std::string
    > ServerCapabilities_typeHierarchyProviderTypeNames;

    class ServerCapabilities_typeHierarchyProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_typeHierarchyProvider();
        ServerCapabilities_typeHierarchyProvider(
            ServerCapabilities_typeHierarchyProvider &&other
        );
        ServerCapabilities_typeHierarchyProvider(
            const ServerCapabilities_typeHierarchyProvider &other
        );
        ~ServerCapabilities_typeHierarchyProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_typeHierarchyProvider &&other
        ) -> ServerCapabilities_typeHierarchyProvider &;

        auto operator=(
            const ServerCapabilities_typeHierarchyProvider &other
        ) -> ServerCapabilities_typeHierarchyProvider &;

        auto type() const
        -> const ServerCapabilities_typeHierarchyProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_typeHierarchyProvider &;

        auto typeHierarchyOptions() const -> const TypeHierarchyOptions &;

        auto operator=(
            const std::unique_ptr<TypeHierarchyOptions> &typeHierarchyOptions
        ) -> ServerCapabilities_typeHierarchyProvider &;

        auto operator=(
            std::unique_ptr<TypeHierarchyOptions> &&typeHierarchyOptions
        ) -> ServerCapabilities_typeHierarchyProvider &;

        auto operator=(
            const TypeHierarchyOptions &typeHierarchyOptions
        ) -> ServerCapabilities_typeHierarchyProvider &;

        auto operator=(
            TypeHierarchyOptions &&typeHierarchyOptions
        ) -> ServerCapabilities_typeHierarchyProvider &;

        auto typeHierarchyRegistrationOptions() const
        -> const TypeHierarchyRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<TypeHierarchyRegistrationOptions> &typeHierarchyRegistrationOptions
        ) -> ServerCapabilities_typeHierarchyProvider &;

        auto operator=(
            std::unique_ptr<TypeHierarchyRegistrationOptions> &&typeHierarchyRegistrationOptions
        ) -> ServerCapabilities_typeHierarchyProvider &;

        auto operator=(
            const TypeHierarchyRegistrationOptions &typeHierarchyRegistrationOptions
        ) -> ServerCapabilities_typeHierarchyProvider &;

        auto operator=(
            TypeHierarchyRegistrationOptions &&typeHierarchyRegistrationOptions
        ) -> ServerCapabilities_typeHierarchyProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_typeHierarchyProviderType _type{
            ServerCapabilities_typeHierarchyProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<TypeHierarchyOptions> _typeHierarchyOptions;
            std::unique_ptr<TypeHierarchyRegistrationOptions> _typeHierarchyRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_typeHierarchyProvider

    enum class ServerCapabilities_inlineValueProviderType {
        Uninitialized = -1,
        Boolean = 0,
        InlineValueOptions = 1,
        InlineValueRegistrationOptions = 2,
    }; // enum class ServerCapabilities_inlineValueProviderType

    extern const std::map<
        ServerCapabilities_inlineValueProviderType,
        std::string
    > ServerCapabilities_inlineValueProviderTypeNames;

    class ServerCapabilities_inlineValueProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_inlineValueProvider();
        ServerCapabilities_inlineValueProvider(
            ServerCapabilities_inlineValueProvider &&other
        );
        ServerCapabilities_inlineValueProvider(
            const ServerCapabilities_inlineValueProvider &other
        );
        ~ServerCapabilities_inlineValueProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_inlineValueProvider &&other
        ) -> ServerCapabilities_inlineValueProvider &;

        auto operator=(
            const ServerCapabilities_inlineValueProvider &other
        ) -> ServerCapabilities_inlineValueProvider &;

        auto type() const
        -> const ServerCapabilities_inlineValueProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_inlineValueProvider &;

        auto inlineValueOptions() const -> const InlineValueOptions &;

        auto operator=(
            const std::unique_ptr<InlineValueOptions> &inlineValueOptions
        ) -> ServerCapabilities_inlineValueProvider &;

        auto operator=(
            std::unique_ptr<InlineValueOptions> &&inlineValueOptions
        ) -> ServerCapabilities_inlineValueProvider &;

        auto operator=(
            const InlineValueOptions &inlineValueOptions
        ) -> ServerCapabilities_inlineValueProvider &;

        auto operator=(
            InlineValueOptions &&inlineValueOptions
        ) -> ServerCapabilities_inlineValueProvider &;

        auto inlineValueRegistrationOptions() const
        -> const InlineValueRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<InlineValueRegistrationOptions> &inlineValueRegistrationOptions
        ) -> ServerCapabilities_inlineValueProvider &;

        auto operator=(
            std::unique_ptr<InlineValueRegistrationOptions> &&inlineValueRegistrationOptions
        ) -> ServerCapabilities_inlineValueProvider &;

        auto operator=(
            const InlineValueRegistrationOptions &inlineValueRegistrationOptions
        ) -> ServerCapabilities_inlineValueProvider &;

        auto operator=(
            InlineValueRegistrationOptions &&inlineValueRegistrationOptions
        ) -> ServerCapabilities_inlineValueProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_inlineValueProviderType _type{
            ServerCapabilities_inlineValueProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<InlineValueOptions> _inlineValueOptions;
            std::unique_ptr<InlineValueRegistrationOptions> _inlineValueRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_inlineValueProvider

    enum class ServerCapabilities_inlayHintProviderType {
        Uninitialized = -1,
        Boolean = 0,
        InlayHintOptions = 1,
        InlayHintRegistrationOptions = 2,
    }; // enum class ServerCapabilities_inlayHintProviderType

    extern const std::map<
        ServerCapabilities_inlayHintProviderType,
        std::string
    > ServerCapabilities_inlayHintProviderTypeNames;

    class ServerCapabilities_inlayHintProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_inlayHintProvider();
        ServerCapabilities_inlayHintProvider(
            ServerCapabilities_inlayHintProvider &&other
        );
        ServerCapabilities_inlayHintProvider(
            const ServerCapabilities_inlayHintProvider &other
        );
        ~ServerCapabilities_inlayHintProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_inlayHintProvider &&other
        ) -> ServerCapabilities_inlayHintProvider &;

        auto operator=(
            const ServerCapabilities_inlayHintProvider &other
        ) -> ServerCapabilities_inlayHintProvider &;

        auto type() const -> const ServerCapabilities_inlayHintProviderType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> ServerCapabilities_inlayHintProvider &;

        auto inlayHintOptions() const -> const InlayHintOptions &;

        auto operator=(
            const std::unique_ptr<InlayHintOptions> &inlayHintOptions
        ) -> ServerCapabilities_inlayHintProvider &;

        auto operator=(
            std::unique_ptr<InlayHintOptions> &&inlayHintOptions
        ) -> ServerCapabilities_inlayHintProvider &;

        auto operator=(
            const InlayHintOptions &inlayHintOptions
        ) -> ServerCapabilities_inlayHintProvider &;

        auto operator=(
            InlayHintOptions &&inlayHintOptions
        ) -> ServerCapabilities_inlayHintProvider &;

        auto inlayHintRegistrationOptions() const
        -> const InlayHintRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<InlayHintRegistrationOptions> &inlayHintRegistrationOptions
        ) -> ServerCapabilities_inlayHintProvider &;

        auto operator=(
            std::unique_ptr<InlayHintRegistrationOptions> &&inlayHintRegistrationOptions
        ) -> ServerCapabilities_inlayHintProvider &;

        auto operator=(
            const InlayHintRegistrationOptions &inlayHintRegistrationOptions
        ) -> ServerCapabilities_inlayHintProvider &;

        auto operator=(
            InlayHintRegistrationOptions &&inlayHintRegistrationOptions
        ) -> ServerCapabilities_inlayHintProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_inlayHintProviderType _type{
            ServerCapabilities_inlayHintProviderType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<InlayHintOptions> _inlayHintOptions;
            std::unique_ptr<InlayHintRegistrationOptions> _inlayHintRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_inlayHintProvider

    enum class ServerCapabilities_diagnosticProviderType {
        Uninitialized = -1,
        DiagnosticOptions = 0,
        DiagnosticRegistrationOptions = 1,
    }; // enum class ServerCapabilities_diagnosticProviderType

    extern const std::map<
        ServerCapabilities_diagnosticProviderType,
        std::string
    > ServerCapabilities_diagnosticProviderTypeNames;

    class ServerCapabilities_diagnosticProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_diagnosticProvider();
        ServerCapabilities_diagnosticProvider(
            ServerCapabilities_diagnosticProvider &&other
        );
        ServerCapabilities_diagnosticProvider(
            const ServerCapabilities_diagnosticProvider &other
        );
        ~ServerCapabilities_diagnosticProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_diagnosticProvider &&other
        ) -> ServerCapabilities_diagnosticProvider &;

        auto operator=(
            const ServerCapabilities_diagnosticProvider &other
        ) -> ServerCapabilities_diagnosticProvider &;

        auto type() const -> const ServerCapabilities_diagnosticProviderType &;

        auto diagnosticOptions() const -> const DiagnosticOptions &;

        auto operator=(
            const std::unique_ptr<DiagnosticOptions> &diagnosticOptions
        ) -> ServerCapabilities_diagnosticProvider &;

        auto operator=(
            std::unique_ptr<DiagnosticOptions> &&diagnosticOptions
        ) -> ServerCapabilities_diagnosticProvider &;

        auto operator=(
            const DiagnosticOptions &diagnosticOptions
        ) -> ServerCapabilities_diagnosticProvider &;

        auto operator=(
            DiagnosticOptions &&diagnosticOptions
        ) -> ServerCapabilities_diagnosticProvider &;

        auto diagnosticRegistrationOptions() const
        -> const DiagnosticRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<DiagnosticRegistrationOptions> &diagnosticRegistrationOptions
        ) -> ServerCapabilities_diagnosticProvider &;

        auto operator=(
            std::unique_ptr<DiagnosticRegistrationOptions> &&diagnosticRegistrationOptions
        ) -> ServerCapabilities_diagnosticProvider &;

        auto operator=(
            const DiagnosticRegistrationOptions &diagnosticRegistrationOptions
        ) -> ServerCapabilities_diagnosticProvider &;

        auto operator=(
            DiagnosticRegistrationOptions &&diagnosticRegistrationOptions
        ) -> ServerCapabilities_diagnosticProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_diagnosticProviderType _type{
            ServerCapabilities_diagnosticProviderType::Uninitialized
        };

        union {
            std::unique_ptr<DiagnosticOptions> _diagnosticOptions;
            std::unique_ptr<DiagnosticRegistrationOptions> _diagnosticRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_diagnosticProvider

    enum class Workspace_WorkspaceFoldersResultType {
        Uninitialized = -1,
        WorkspaceFolderArray = 0,
        Null = 1,
    }; // enum class Workspace_WorkspaceFoldersResultType

    extern const std::map<Workspace_WorkspaceFoldersResultType, std::string>
        Workspace_WorkspaceFoldersResultTypeNames;

    class Workspace_WorkspaceFoldersResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Workspace_WorkspaceFoldersResult();
        Workspace_WorkspaceFoldersResult(
            Workspace_WorkspaceFoldersResult &&other
        );
        Workspace_WorkspaceFoldersResult(
            const Workspace_WorkspaceFoldersResult &other
        );
        ~Workspace_WorkspaceFoldersResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            Workspace_WorkspaceFoldersResult &&other
        ) -> Workspace_WorkspaceFoldersResult &;

        auto operator=(
            const Workspace_WorkspaceFoldersResult &other
        ) -> Workspace_WorkspaceFoldersResult &;

        auto type() const -> const Workspace_WorkspaceFoldersResultType &;

        auto workspaceFolderArray() const
        -> const std::vector<WorkspaceFolder> &;

        auto operator=(
            const std::unique_ptr<std::vector<WorkspaceFolder>> &workspaceFolderArray
        ) -> Workspace_WorkspaceFoldersResult &;

        auto operator=(
            std::unique_ptr<std::vector<WorkspaceFolder>> &&workspaceFolderArray
        ) -> Workspace_WorkspaceFoldersResult &;

        auto operator=(
            const std::vector<WorkspaceFolder> &workspaceFolderArray
        ) -> Workspace_WorkspaceFoldersResult &;

        auto operator=(
            std::vector<WorkspaceFolder> &&workspaceFolderArray
        ) -> Workspace_WorkspaceFoldersResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> Workspace_WorkspaceFoldersResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        Workspace_WorkspaceFoldersResultType _type{
            Workspace_WorkspaceFoldersResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<WorkspaceFolder>> _workspaceFolderArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class Workspace_WorkspaceFoldersResult

    typedef null_t Workspace_FoldingRange_RefreshResult;

    typedef null_t Window_WorkDoneProgress_CreateResult;

    typedef null_t Workspace_SemanticTokens_RefreshResult;

    enum class TextDocument_MonikerResultType {
        Uninitialized = -1,
        MonikerArray = 0,
        Null = 1,
    }; // enum class TextDocument_MonikerResultType

    extern const std::map<TextDocument_MonikerResultType, std::string>
        TextDocument_MonikerResultTypeNames;

    class TextDocument_MonikerResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_MonikerResult();
        TextDocument_MonikerResult(TextDocument_MonikerResult &&other);
        TextDocument_MonikerResult(const TextDocument_MonikerResult &other);
        ~TextDocument_MonikerResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_MonikerResult &&other
        ) -> TextDocument_MonikerResult &;

        auto operator=(
            const TextDocument_MonikerResult &other
        ) -> TextDocument_MonikerResult &;

        auto type() const -> const TextDocument_MonikerResultType &;

        auto monikerArray() const -> const std::vector<Moniker> &;

        auto operator=(
            const std::unique_ptr<std::vector<Moniker>> &monikerArray
        ) -> TextDocument_MonikerResult &;

        auto operator=(
            std::unique_ptr<std::vector<Moniker>> &&monikerArray
        ) -> TextDocument_MonikerResult &;

        auto operator=(
            const std::vector<Moniker> &monikerArray
        ) -> TextDocument_MonikerResult &;

        auto operator=(
            std::vector<Moniker> &&monikerArray
        ) -> TextDocument_MonikerResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_MonikerResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_MonikerResultType _type{
            TextDocument_MonikerResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<Moniker>> _monikerArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_MonikerResult

    typedef null_t Workspace_InlineValue_RefreshResult;

    typedef null_t Workspace_InlayHint_RefreshResult;

    typedef null_t Workspace_Diagnostic_RefreshResult;

    typedef null_t Client_RegisterCapabilityResult;

    typedef null_t Client_UnregisterCapabilityResult;

    typedef null_t ShutdownResult;

    enum class Window_ShowMessageRequestResultType {
        Uninitialized = -1,
        MessageActionItem = 0,
        Null = 1,
    }; // enum class Window_ShowMessageRequestResultType

    extern const std::map<Window_ShowMessageRequestResultType, std::string>
        Window_ShowMessageRequestResultTypeNames;

    class Window_ShowMessageRequestResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Window_ShowMessageRequestResult();
        Window_ShowMessageRequestResult(
            Window_ShowMessageRequestResult &&other
        );
        Window_ShowMessageRequestResult(
            const Window_ShowMessageRequestResult &other
        );
        ~Window_ShowMessageRequestResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            Window_ShowMessageRequestResult &&other
        ) -> Window_ShowMessageRequestResult &;

        auto operator=(
            const Window_ShowMessageRequestResult &other
        ) -> Window_ShowMessageRequestResult &;

        auto type() const -> const Window_ShowMessageRequestResultType &;

        auto messageActionItem() const -> const MessageActionItem &;

        auto operator=(
            const std::unique_ptr<MessageActionItem> &messageActionItem
        ) -> Window_ShowMessageRequestResult &;

        auto operator=(
            std::unique_ptr<MessageActionItem> &&messageActionItem
        ) -> Window_ShowMessageRequestResult &;

        auto operator=(
            const MessageActionItem &messageActionItem
        ) -> Window_ShowMessageRequestResult &;

        auto operator=(
            MessageActionItem &&messageActionItem
        ) -> Window_ShowMessageRequestResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> Window_ShowMessageRequestResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        Window_ShowMessageRequestResultType _type{
            Window_ShowMessageRequestResultType::Uninitialized
        };

        union {
            std::unique_ptr<MessageActionItem> _messageActionItem;
            null_t _null;
        };

        auto reset() -> void;
    }; // class Window_ShowMessageRequestResult

    typedef null_t Workspace_CodeLens_RefreshResult;

    typedef unsigned int uinteger_t;

    /**
     * Represents a folding range. To be valid, start and end line must be bigger than zero and smaller
     * than the number of lines in the document. Clients are free to ignore invalid ranges.
     */
    struct FoldingRange {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FoldingRange();
        FoldingRange(FoldingRange &&other);
        FoldingRange(const FoldingRange &other);
        ~FoldingRange();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FoldingRange &&other) -> FoldingRange &;

        auto operator=(const FoldingRange &other) -> FoldingRange &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The zero-based start line of the range to fold. The folded area starts after the line's last character.
         * To be valid, the end must be zero or larger and smaller than the number of lines in the document.
         */
        uinteger_t startLine;
        /**
         * The zero-based character offset from where the folded range starts. If not defined, defaults to the length of the start line.
         */
        std::optional<uinteger_t> startCharacter;
        /**
         * The zero-based end line of the range to fold. The folded area ends with the line's last character.
         * To be valid, the end must be zero or larger and smaller than the number of lines in the document.
         */
        uinteger_t endLine;
        /**
         * The zero-based character offset before the folded range ends. If not defined, defaults to the length of the end line.
         */
        std::optional<uinteger_t> endCharacter;
        /**
         * Describes the kind of the folding range such as `comment' or 'region'. The kind
         * is used to categorize folding ranges and used by commands like 'Fold all comments'.
         * See {@link FoldingRangeKind} for an enumeration of standardized kinds.
         */
        std::optional<FoldingRangeKind> kind;
        /**
         * The text that the client should show when the specified range is
         * collapsed. If not defined or not supported by the client, a default
         * will be chosen by the client.
         *
         * @since 3.17.0
         */
        std::optional<string_t> collapsedText;
    }; // struct FoldingRange

    /**
     * @since 3.16.0
     */
    struct SemanticTokens {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokens();
        SemanticTokens(SemanticTokens &&other);
        SemanticTokens(const SemanticTokens &other);
        ~SemanticTokens();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SemanticTokens &&other) -> SemanticTokens &;

        auto operator=(const SemanticTokens &other) -> SemanticTokens &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional result id. If provided and clients support delta updating
         * the client will include the result id in the next semantic token request.
         * A server can then instead of computing all semantic tokens again simply
         * send a delta.
         */
        std::optional<string_t> resultId;
        /**
         * The actual tokens.
         */
        std::vector<uinteger_t> data;
    }; // struct SemanticTokens

    typedef std::vector<uinteger_t> SemanticTokens_data;

    /**
     * @since 3.16.0
     */
    struct SemanticTokensPartialResult {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensPartialResult();
        SemanticTokensPartialResult(SemanticTokensPartialResult &&other);
        SemanticTokensPartialResult(const SemanticTokensPartialResult &other);
        ~SemanticTokensPartialResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensPartialResult &&other
        ) -> SemanticTokensPartialResult &;

        auto operator=(
            const SemanticTokensPartialResult &other
        ) -> SemanticTokensPartialResult &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::vector<uinteger_t> data;
    }; // struct SemanticTokensPartialResult

    typedef std::vector<uinteger_t> SemanticTokensPartialResult_data;

    /**
     * The result returned from the apply workspace edit request.
     *
     * @since 3.17 renamed from ApplyWorkspaceEditResponse
     */
    struct ApplyWorkspaceEditResult {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ApplyWorkspaceEditResult();
        ApplyWorkspaceEditResult(ApplyWorkspaceEditResult &&other);
        ApplyWorkspaceEditResult(const ApplyWorkspaceEditResult &other);
        ~ApplyWorkspaceEditResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ApplyWorkspaceEditResult &&other
        ) -> ApplyWorkspaceEditResult &;

        auto operator=(
            const ApplyWorkspaceEditResult &other
        ) -> ApplyWorkspaceEditResult &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Indicates whether the edit was applied or not.
         */
        boolean_t applied;
        /**
         * An optional textual description for why the edit was not applied.
         * This may be used by the server for diagnostic logging or to provide
         * a suitable error for a request that triggered the edit.
         */
        std::optional<string_t> failureReason;
        /**
         * Depending on the client's failure handling strategy `failedChange` might
         * contain the index of the change that failed. This property is only available
         * if the client signals a `failureHandlingStrategy` in its client capabilities.
         */
        std::optional<uinteger_t> failedChange;
    }; // struct ApplyWorkspaceEditResult

    struct WorkDoneProgressBegin {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkDoneProgressBegin();
        WorkDoneProgressBegin(WorkDoneProgressBegin &&other);
        WorkDoneProgressBegin(const WorkDoneProgressBegin &other);
        ~WorkDoneProgressBegin();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkDoneProgressBegin &&other
        ) -> WorkDoneProgressBegin &;

        auto operator=(
            const WorkDoneProgressBegin &other
        ) -> WorkDoneProgressBegin &;

        // ================== //
        // Field Declarations //
        // ================== //

        string_t kind;
        /**
         * Mandatory title of the progress operation. Used to briefly inform about
         * the kind of operation being performed.
         *
         * Examples: "Indexing" or "Linking dependencies".
         */
        string_t title;
        /**
         * Controls if a cancel button should show to allow the user to cancel the
         * long running operation. Clients that don't support cancellation are allowed
         * to ignore the setting.
         */
        std::optional<boolean_t> cancellable;
        /**
         * Optional, more detailed associated progress message. Contains
         * complementary information to the `title`.
         *
         * Examples: "3/25 files", "project/src/module2", "node_modules/some_dep".
         * If unset, the previous progress message (if any) is still valid.
         */
        std::optional<string_t> message;
        /**
         * Optional progress percentage to display (value 100 is considered 100%).
         * If not provided infinite progress is assumed and clients are allowed
         * to ignore the `percentage` value in subsequent report notifications.
         *
         * The value should be steadily rising. Clients are free to ignore values
         * that are not following this rule. The value range is [0, 100].
         */
        std::optional<uinteger_t> percentage;
    }; // struct WorkDoneProgressBegin

    struct WorkDoneProgressReport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkDoneProgressReport();
        WorkDoneProgressReport(WorkDoneProgressReport &&other);
        WorkDoneProgressReport(const WorkDoneProgressReport &other);
        ~WorkDoneProgressReport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkDoneProgressReport &&other
        ) -> WorkDoneProgressReport &;

        auto operator=(
            const WorkDoneProgressReport &other
        ) -> WorkDoneProgressReport &;

        // ================== //
        // Field Declarations //
        // ================== //

        string_t kind;
        /**
         * Controls enablement state of a cancel button.
         *
         * Clients that don't support cancellation or don't support controlling the button's
         * enablement state are allowed to ignore the property.
         */
        std::optional<boolean_t> cancellable;
        /**
         * Optional, more detailed associated progress message. Contains
         * complementary information to the `title`.
         *
         * Examples: "3/25 files", "project/src/module2", "node_modules/some_dep".
         * If unset, the previous progress message (if any) is still valid.
         */
        std::optional<string_t> message;
        /**
         * Optional progress percentage to display (value 100 is considered 100%).
         * If not provided infinite progress is assumed and clients are allowed
         * to ignore the `percentage` value in subsequent report notifications.
         *
         * The value should be steadily rising. Clients are free to ignore values
         * that are not following this rule. The value range is [0, 100].
         */
        std::optional<uinteger_t> percentage;
    }; // struct WorkDoneProgressReport

    /**
     * Position in a text document expressed as zero-based line and character
     * offset. Prior to 3.17 the offsets were always based on a UTF-16 string
     * representation. So a string of the form `a𐐀b` the character offset of the
     * character `a` is 0, the character offset of `𐐀` is 1 and the character
     * offset of b is 3 since `𐐀` is represented using two code units in UTF-16.
     * Since 3.17 clients and servers can agree on a different string encoding
     * representation (e.g. UTF-8). The client announces it's supported encoding
     * via the client capability [`general.positionEncodings`](https://microsoft.github.io/language-server-protocol/specifications/specification-current/#clientCapabilities).
     * The value is an array of position encodings the client supports, with
     * decreasing preference (e.g. the encoding at index `0` is the most preferred
     * one). To stay backwards compatible the only mandatory encoding is UTF-16
     * represented via the string `utf-16`. The server can pick one of the
     * encodings offered by the client and signals that encoding back to the
     * client via the initialize result's property
     * [`capabilities.positionEncoding`](https://microsoft.github.io/language-server-protocol/specifications/specification-current/#serverCapabilities). If the string value
     * `utf-16` is missing from the client's capability `general.positionEncodings`
     * servers can safely assume that the client supports UTF-16. If the server
     * omits the position encoding in its initialize result the encoding defaults
     * to the string value `utf-16`. Implementation considerations: since the
     * conversion from one encoding into another requires the content of the
     * file / line the conversion is best done where the file is read which is
     * usually on the server side.
     *
     * Positions are line end character agnostic. So you can not specify a position
     * that denotes `\r|\n` or `\n|` where `|` represents the character offset.
     *
     * @since 3.17.0 - support for negotiated position encoding.
     */
    struct Position {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Position();
        Position(Position &&other);
        Position(const Position &other);
        ~Position();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Position &&other) -> Position &;

        auto operator=(const Position &other) -> Position &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Line position in a document (zero-based).
         *
         * If a line number is greater than the number of lines in a document, it defaults back to the number of lines in the document.
         * If a line number is negative, it defaults to 0.
         */
        uinteger_t line;
        /**
         * Character offset on a line in a document (zero-based).
         *
         * The meaning of this offset is determined by the negotiated
         * `PositionEncodingKind`.
         *
         * If the character value is greater than the line length it defaults back to the
         * line length.
         */
        uinteger_t character;
    }; // struct Position

    typedef std::vector<Position> SelectionRangeParams_positions;

    /**
     * A parameter literal used in requests to pass a text document and a position inside that
     * document.
     */
    struct TextDocumentPositionParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentPositionParams();
        TextDocumentPositionParams(TextDocumentPositionParams &&other);
        TextDocumentPositionParams(const TextDocumentPositionParams &other);
        ~TextDocumentPositionParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentPositionParams &&other
        ) -> TextDocumentPositionParams &;

        auto operator=(
            const TextDocumentPositionParams &other
        ) -> TextDocumentPositionParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The position inside the text document.
         */
        Position position;
    }; // struct TextDocumentPositionParams

    /**
     * A range in a text document expressed as (zero-based) start and end positions.
     *
     * If you want to specify a range that contains a line including the line ending
     * character(s) then use an end position denoting the start of the next line.
     * For example:
     * ```ts
     * {
     *     start: { line: 5, character: 23 }
     *     end : { line 6, character : 0 }
     * }
     * ```
     */
    struct Range {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Range();
        Range(Range &&other);
        Range(const Range &other);
        ~Range();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Range &&other) -> Range &;

        auto operator=(const Range &other) -> Range &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The range's start position.
         */
        Position start;
        /**
         * The range's end position.
         */
        Position end;
    }; // struct Range

    /**
     * Represents a location inside a resource, such as a line
     * inside a text file.
     */
    struct Location {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Location();
        Location(Location &&other);
        Location(const Location &other);
        ~Location();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Location &&other) -> Location &;

        auto operator=(const Location &other) -> Location &;

        // ================== //
        // Field Declarations //
        // ================== //

        DocumentUri uri;
        Range range;
    }; // struct Location

    /**
     * A selection range represents a part of a selection hierarchy. A selection range
     * may have a parent selection range that contains it.
     */
    struct SelectionRange {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SelectionRange();
        SelectionRange(SelectionRange &&other);
        SelectionRange(const SelectionRange &other);
        ~SelectionRange();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SelectionRange &&other) -> SelectionRange &;

        auto operator=(const SelectionRange &other) -> SelectionRange &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The {@link Range range} of this selection range.
         */
        Range range;
        /**
         * The parent selection range containing this range. Therefore `parent.range` must contain `this.range`.
         */
        std::optional<std::unique_ptr<SelectionRange>> parent;
    }; // struct SelectionRange

    typedef std::vector<Range> CallHierarchyIncomingCall_fromRanges;

    typedef std::vector<Range> CallHierarchyOutgoingCall_fromRanges;

    /**
     * Params to show a resource in the UI.
     *
     * @since 3.16.0
     */
    struct ShowDocumentParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ShowDocumentParams();
        ShowDocumentParams(ShowDocumentParams &&other);
        ShowDocumentParams(const ShowDocumentParams &other);
        ~ShowDocumentParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ShowDocumentParams &&other) -> ShowDocumentParams &;

        auto operator=(
            const ShowDocumentParams &other
        ) -> ShowDocumentParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The uri to show.
         */
        URI uri;
        /**
         * Indicates to show the resource in an external program.
         * To show, for example, `https://code.visualstudio.com/`
         * in the default WEB browser set `external` to `true`.
         */
        std::optional<boolean_t> external;
        /**
         * An optional property to indicate whether the editor
         * showing the document should take focus or not.
         * Clients might ignore this property if an external
         * program is started.
         */
        std::optional<boolean_t> takeFocus;
        /**
         * An optional selection range if the document is a text
         * document. Clients might ignore the property if an
         * external program is started or the file is not a text
         * file.
         */
        std::optional<Range> selection;
    }; // struct ShowDocumentParams

    /**
     * The result of a linked editing range request.
     *
     * @since 3.16.0
     */
    struct LinkedEditingRanges {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        LinkedEditingRanges();
        LinkedEditingRanges(LinkedEditingRanges &&other);
        LinkedEditingRanges(const LinkedEditingRanges &other);
        ~LinkedEditingRanges();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(LinkedEditingRanges &&other) -> LinkedEditingRanges &;

        auto operator=(
            const LinkedEditingRanges &other
        ) -> LinkedEditingRanges &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A list of ranges that can be edited together. The ranges must have
         * identical length and contain identical text content. The ranges cannot overlap.
         */
        std::vector<Range> ranges;
        /**
         * An optional word pattern (regular expression) that describes valid contents for
         * the given ranges. If no pattern is provided, the client configuration's word
         * pattern will be used.
         */
        std::optional<string_t> wordPattern;
    }; // struct LinkedEditingRanges

    typedef std::vector<Range> LinkedEditingRanges_ranges;

    /**
     * A text edit applicable to a text document.
     */
    struct TextEdit {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextEdit();
        TextEdit(TextEdit &&other);
        TextEdit(const TextEdit &other);
        ~TextEdit();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(TextEdit &&other) -> TextEdit &;

        auto operator=(const TextEdit &other) -> TextEdit &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The range of the text document to be manipulated. To insert
         * text into a document create a range where start === end.
         */
        Range range;
        /**
         * The string to be inserted. For delete operations use an
         * empty string.
         */
        string_t newText;
    }; // struct TextEdit

    struct ColorPresentation {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ColorPresentation();
        ColorPresentation(ColorPresentation &&other);
        ColorPresentation(const ColorPresentation &other);
        ~ColorPresentation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ColorPresentation &&other) -> ColorPresentation &;

        auto operator=(const ColorPresentation &other) -> ColorPresentation &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The label of this color presentation. It will be shown on the color
         * picker header. By default this is also the text that is inserted when selecting
         * this color presentation.
         */
        string_t label;
        /**
         * An {@link TextEdit edit} which is applied to a document when selecting
         * this presentation for the color.  When `falsy` the {@link ColorPresentation.label label}
         * is used.
         */
        std::optional<TextEdit> textEdit;
        /**
         * An optional array of additional {@link TextEdit text edits} that are applied when
         * selecting this color presentation. Edits must not overlap with the main {@link ColorPresentation.textEdit edit} nor with themselves.
         */
        std::optional<std::vector<TextEdit>> additionalTextEdits;
    }; // struct ColorPresentation

    typedef std::vector<TextEdit> ColorPresentation_additionalTextEdits;

    typedef std::map<DocumentUri, std::vector<TextEdit>> WorkspaceEdit_changes;

    typedef std::vector<TextEdit> WorkspaceEdit_changes_value;

    typedef std::vector<TextEdit> InlayHint_textEdits;

    typedef std::vector<TextEdit> CompletionItem_additionalTextEdits;

    struct CompletionList_itemDefaults_editRange_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionList_itemDefaults_editRange_1();
        CompletionList_itemDefaults_editRange_1(
            CompletionList_itemDefaults_editRange_1 &&other
        );
        CompletionList_itemDefaults_editRange_1(
            const CompletionList_itemDefaults_editRange_1 &other
        );
        ~CompletionList_itemDefaults_editRange_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionList_itemDefaults_editRange_1 &&other
        ) -> CompletionList_itemDefaults_editRange_1 &;

        auto operator=(
            const CompletionList_itemDefaults_editRange_1 &other
        ) -> CompletionList_itemDefaults_editRange_1 &;

        // ================== //
        // Field Declarations //
        // ================== //

        Range insert;
        Range replace;
    }; // struct CompletionList_itemDefaults_editRange_1

    enum class CompletionList_itemDefaults_editRangeType {
        Uninitialized = -1,
        Range = 0,
        CompletionList_itemDefaults_editRange_1 = 1,
    }; // enum class CompletionList_itemDefaults_editRangeType

    extern const std::map<
        CompletionList_itemDefaults_editRangeType,
        std::string
    > CompletionList_itemDefaults_editRangeTypeNames;

    class CompletionList_itemDefaults_editRange {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionList_itemDefaults_editRange();
        CompletionList_itemDefaults_editRange(
            CompletionList_itemDefaults_editRange &&other
        );
        CompletionList_itemDefaults_editRange(
            const CompletionList_itemDefaults_editRange &other
        );
        ~CompletionList_itemDefaults_editRange();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionList_itemDefaults_editRange &&other
        ) -> CompletionList_itemDefaults_editRange &;

        auto operator=(
            const CompletionList_itemDefaults_editRange &other
        ) -> CompletionList_itemDefaults_editRange &;

        auto type() const -> const CompletionList_itemDefaults_editRangeType &;

        auto range() const -> const Range &;

        auto operator=(
            const std::unique_ptr<Range> &range
        ) -> CompletionList_itemDefaults_editRange &;

        auto operator=(
            std::unique_ptr<Range> &&range
        ) -> CompletionList_itemDefaults_editRange &;

        auto operator=(
            const Range &range
        ) -> CompletionList_itemDefaults_editRange &;

        auto operator=(
            Range &&range
        ) -> CompletionList_itemDefaults_editRange &;

        auto completionList_itemDefaults_editRange_1() const
        -> const CompletionList_itemDefaults_editRange_1 &;

        auto operator=(
            const std::unique_ptr<CompletionList_itemDefaults_editRange_1> &completionList_itemDefaults_editRange_1
        ) -> CompletionList_itemDefaults_editRange &;

        auto operator=(
            std::unique_ptr<CompletionList_itemDefaults_editRange_1> &&completionList_itemDefaults_editRange_1
        ) -> CompletionList_itemDefaults_editRange &;

        auto operator=(
            const CompletionList_itemDefaults_editRange_1 &completionList_itemDefaults_editRange_1
        ) -> CompletionList_itemDefaults_editRange &;

        auto operator=(
            CompletionList_itemDefaults_editRange_1 &&completionList_itemDefaults_editRange_1
        ) -> CompletionList_itemDefaults_editRange &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        CompletionList_itemDefaults_editRangeType _type{
            CompletionList_itemDefaults_editRangeType::Uninitialized
        };

        union {
            std::unique_ptr<Range> _range;
            std::unique_ptr<CompletionList_itemDefaults_editRange_1> _completionList_itemDefaults_editRange_1;
        };

        auto reset() -> void;
    }; // class CompletionList_itemDefaults_editRange

    /**
     * The result of a hover request.
     */
    struct Hover {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Hover();
        Hover(Hover &&other);
        Hover(const Hover &other);
        ~Hover();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Hover &&other) -> Hover &;

        auto operator=(const Hover &other) -> Hover &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The hover's content
         */
        Hover_contents contents;
        /**
         * An optional range inside the text document that is used to
         * visualize the hover, e.g. by changing the background color.
         */
        std::optional<Range> range;
    }; // struct Hover

    /**
     * A document highlight is a range inside a text document which deserves
     * special attention. Usually a document highlight is visualized by changing
     * the background color of its range.
     */
    struct DocumentHighlight {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentHighlight();
        DocumentHighlight(DocumentHighlight &&other);
        DocumentHighlight(const DocumentHighlight &other);
        ~DocumentHighlight();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DocumentHighlight &&other) -> DocumentHighlight &;

        auto operator=(const DocumentHighlight &other) -> DocumentHighlight &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The range this highlight applies to.
         */
        Range range;
        /**
         * The highlight kind, default is {@link DocumentHighlightKind.Text text}.
         */
        std::optional<DocumentHighlightKind> kind;
    }; // struct DocumentHighlight

    /**
     * Represents information about programming constructs like variables, classes,
     * interfaces etc.
     */
    struct SymbolInformation
        : public BaseSymbolInformation
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SymbolInformation();
        SymbolInformation(SymbolInformation &&other);
        SymbolInformation(const SymbolInformation &other);
        ~SymbolInformation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SymbolInformation &&other) -> SymbolInformation &;

        auto operator=(const SymbolInformation &other) -> SymbolInformation &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Indicates if this symbol is deprecated.
         *
         * @deprecated Use tags instead
         */
        std::optional<boolean_t> deprecated;
        /**
         * The location of this symbol. The location's range is used by a tool
         * to reveal the location in the editor. If the symbol is selected in the
         * tool the range's start information is used to position the cursor. So
         * the range usually spans more than the actual symbol's name and does
         * normally include things like visibility modifiers.
         *
         * The range doesn't have to denote a node range in the sense of an abstract
         * syntax tree. It can therefore not be used to re-construct a hierarchy of
         * the symbols.
         */
        Location location;
    }; // struct SymbolInformation

    /**
     * Represents programming constructs like variables, classes, interfaces etc.
     * that appear in a document. Document symbols can be hierarchical and they
     * have two ranges: one that encloses its definition and one that points to
     * its most interesting range, e.g. the range of an identifier.
     */
    struct DocumentSymbol {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentSymbol();
        DocumentSymbol(DocumentSymbol &&other);
        DocumentSymbol(const DocumentSymbol &other);
        ~DocumentSymbol();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DocumentSymbol &&other) -> DocumentSymbol &;

        auto operator=(const DocumentSymbol &other) -> DocumentSymbol &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The name of this symbol. Will be displayed in the user interface and therefore must not be
         * an empty string or a string only consisting of white spaces.
         */
        string_t name;
        /**
         * More detail for this symbol, e.g the signature of a function.
         */
        std::optional<string_t> detail;
        /**
         * The kind of this symbol.
         */
        SymbolKind kind;
        /**
         * Tags for this document symbol.
         *
         * @since 3.16.0
         */
        std::optional<std::vector<SymbolTag>> tags;
        /**
         * Indicates if this symbol is deprecated.
         *
         * @deprecated Use tags instead
         */
        std::optional<boolean_t> deprecated;
        /**
         * The range enclosing this symbol not including leading/trailing whitespace but everything else
         * like comments. This information is typically used to determine if the clients cursor is
         * inside the symbol to reveal in the symbol in the UI.
         */
        Range range;
        /**
         * The range that should be selected and revealed when this symbol is being picked, e.g the name of a function.
         * Must be contained by the `range`.
         */
        Range selectionRange;
        /**
         * Children of this symbol, e.g. properties of a class.
         */
        std::optional<std::vector<std::unique_ptr<DocumentSymbol>>> children;
    }; // struct DocumentSymbol

    typedef std::vector<std::unique_ptr<DocumentSymbol>> DocumentSymbol_children;

    enum class WorkspaceSymbol_locationType {
        Uninitialized = -1,
        Location = 0,
        WorkspaceSymbol_location_1 = 1,
    }; // enum class WorkspaceSymbol_locationType

    extern const std::map<WorkspaceSymbol_locationType, std::string>
        WorkspaceSymbol_locationTypeNames;

    class WorkspaceSymbol_location {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceSymbol_location();
        WorkspaceSymbol_location(WorkspaceSymbol_location &&other);
        WorkspaceSymbol_location(const WorkspaceSymbol_location &other);
        ~WorkspaceSymbol_location();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceSymbol_location &&other
        ) -> WorkspaceSymbol_location &;

        auto operator=(
            const WorkspaceSymbol_location &other
        ) -> WorkspaceSymbol_location &;

        auto type() const -> const WorkspaceSymbol_locationType &;

        auto location() const -> const Location &;

        auto operator=(
            const std::unique_ptr<Location> &location
        ) -> WorkspaceSymbol_location &;

        auto operator=(
            std::unique_ptr<Location> &&location
        ) -> WorkspaceSymbol_location &;

        auto operator=(const Location &location) -> WorkspaceSymbol_location &;

        auto operator=(Location &&location) -> WorkspaceSymbol_location &;

        auto workspaceSymbol_location_1() const
        -> const WorkspaceSymbol_location_1 &;

        auto operator=(
            const std::unique_ptr<WorkspaceSymbol_location_1> &workspaceSymbol_location_1
        ) -> WorkspaceSymbol_location &;

        auto operator=(
            std::unique_ptr<WorkspaceSymbol_location_1> &&workspaceSymbol_location_1
        ) -> WorkspaceSymbol_location &;

        auto operator=(
            const WorkspaceSymbol_location_1 &workspaceSymbol_location_1
        ) -> WorkspaceSymbol_location &;

        auto operator=(
            WorkspaceSymbol_location_1 &&workspaceSymbol_location_1
        ) -> WorkspaceSymbol_location &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        WorkspaceSymbol_locationType _type{
            WorkspaceSymbol_locationType::Uninitialized
        };

        union {
            std::unique_ptr<Location> _location;
            std::unique_ptr<WorkspaceSymbol_location_1> _workspaceSymbol_location_1;
        };

        auto reset() -> void;
    }; // class WorkspaceSymbol_location

    typedef std::vector<Range> DocumentRangesFormattingParams_ranges;

    /**
     * Represents the connection of two locations. Provides additional metadata over normal {@link Location locations},
     * including an origin range.
     */
    struct LocationLink {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        LocationLink();
        LocationLink(LocationLink &&other);
        LocationLink(const LocationLink &other);
        ~LocationLink();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(LocationLink &&other) -> LocationLink &;

        auto operator=(const LocationLink &other) -> LocationLink &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Span of the origin of this link.
         *
         * Used as the underlined span for mouse interaction. Defaults to the word range at
         * the definition position.
         */
        std::optional<Range> originSelectionRange;
        /**
         * The target resource identifier of this link.
         */
        DocumentUri targetUri;
        /**
         * The full target range of this link. If the target for example is a symbol then target range is the
         * range enclosing this symbol not including leading/trailing whitespace but everything else
         * like comments. This information is typically used to highlight the range in the editor.
         */
        Range targetRange;
        /**
         * The range that should be selected and revealed when this link is being followed, e.g the name of a function.
         * Must be contained by the `targetRange`. See also `DocumentSymbol#range`
         */
        Range targetSelectionRange;
    }; // struct LocationLink

    /**
     * @since 3.16.0
     */
    struct SemanticTokensEdit {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensEdit();
        SemanticTokensEdit(SemanticTokensEdit &&other);
        SemanticTokensEdit(const SemanticTokensEdit &other);
        ~SemanticTokensEdit();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SemanticTokensEdit &&other) -> SemanticTokensEdit &;

        auto operator=(
            const SemanticTokensEdit &other
        ) -> SemanticTokensEdit &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The start offset of the edit.
         */
        uinteger_t start;
        /**
         * The count of elements to remove.
         */
        uinteger_t deleteCount;
        /**
         * The elements to insert.
         */
        std::optional<std::vector<uinteger_t>> data;
    }; // struct SemanticTokensEdit

    /**
     * @since 3.16.0
     */
    struct SemanticTokensDelta {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensDelta();
        SemanticTokensDelta(SemanticTokensDelta &&other);
        SemanticTokensDelta(const SemanticTokensDelta &other);
        ~SemanticTokensDelta();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SemanticTokensDelta &&other) -> SemanticTokensDelta &;

        auto operator=(
            const SemanticTokensDelta &other
        ) -> SemanticTokensDelta &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<string_t> resultId;
        /**
         * The semantic token edits to transform a previous result into a new result.
         */
        std::vector<SemanticTokensEdit> edits;
    }; // struct SemanticTokensDelta

    typedef std::vector<SemanticTokensEdit> SemanticTokensDelta_edits;

    /**
     * @since 3.16.0
     */
    struct SemanticTokensDeltaPartialResult {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensDeltaPartialResult();
        SemanticTokensDeltaPartialResult(
            SemanticTokensDeltaPartialResult &&other
        );
        SemanticTokensDeltaPartialResult(
            const SemanticTokensDeltaPartialResult &other
        );
        ~SemanticTokensDeltaPartialResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensDeltaPartialResult &&other
        ) -> SemanticTokensDeltaPartialResult &;

        auto operator=(
            const SemanticTokensDeltaPartialResult &other
        ) -> SemanticTokensDeltaPartialResult &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::vector<SemanticTokensEdit> edits;
    }; // struct SemanticTokensDeltaPartialResult

    typedef std::vector<SemanticTokensEdit> SemanticTokensDeltaPartialResult_edits;

    typedef std::vector<uinteger_t> SemanticTokensEdit_data;

    /**
     * Provide inline value as text.
     *
     * @since 3.17.0
     */
    struct InlineValueText {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineValueText();
        InlineValueText(InlineValueText &&other);
        InlineValueText(const InlineValueText &other);
        ~InlineValueText();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlineValueText &&other) -> InlineValueText &;

        auto operator=(const InlineValueText &other) -> InlineValueText &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The document range for which the inline value applies.
         */
        Range range;
        /**
         * The text of the inline value.
         */
        string_t text;
    }; // struct InlineValueText

    /**
     * Provide inline value through a variable lookup.
     * If only a range is specified, the variable name will be extracted from the underlying document.
     * An optional variable name can be used to override the extracted name.
     *
     * @since 3.17.0
     */
    struct InlineValueVariableLookup {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineValueVariableLookup();
        InlineValueVariableLookup(InlineValueVariableLookup &&other);
        InlineValueVariableLookup(const InlineValueVariableLookup &other);
        ~InlineValueVariableLookup();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlineValueVariableLookup &&other
        ) -> InlineValueVariableLookup &;

        auto operator=(
            const InlineValueVariableLookup &other
        ) -> InlineValueVariableLookup &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The document range for which the inline value applies.
         * The range is used to extract the variable name from the underlying document.
         */
        Range range;
        /**
         * If specified the name of the variable to look up.
         */
        std::optional<string_t> variableName;
        /**
         * How to perform the lookup.
         */
        boolean_t caseSensitiveLookup;
    }; // struct InlineValueVariableLookup

    /**
     * Provide an inline value through an expression evaluation.
     * If only a range is specified, the expression will be extracted from the underlying document.
     * An optional expression can be used to override the extracted expression.
     *
     * @since 3.17.0
     */
    struct InlineValueEvaluatableExpression {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineValueEvaluatableExpression();
        InlineValueEvaluatableExpression(
            InlineValueEvaluatableExpression &&other
        );
        InlineValueEvaluatableExpression(
            const InlineValueEvaluatableExpression &other
        );
        ~InlineValueEvaluatableExpression();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlineValueEvaluatableExpression &&other
        ) -> InlineValueEvaluatableExpression &;

        auto operator=(
            const InlineValueEvaluatableExpression &other
        ) -> InlineValueEvaluatableExpression &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The document range for which the inline value applies.
         * The range is used to extract the evaluatable expression from the underlying document.
         */
        Range range;
        /**
         * If specified the expression overrides the extracted expression.
         */
        std::optional<string_t> expression;
    }; // struct InlineValueEvaluatableExpression

    /**
     * A special text edit to provide an insert and a replace operation.
     *
     * @since 3.16.0
     */
    struct InsertReplaceEdit {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InsertReplaceEdit();
        InsertReplaceEdit(InsertReplaceEdit &&other);
        InsertReplaceEdit(const InsertReplaceEdit &other);
        ~InsertReplaceEdit();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InsertReplaceEdit &&other) -> InsertReplaceEdit &;

        auto operator=(const InsertReplaceEdit &other) -> InsertReplaceEdit &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The string to be inserted.
         */
        string_t newText;
        /**
         * The range if the insert is requested
         */
        Range insert;
        /**
         * The range if the replace is requested.
         */
        Range replace;
    }; // struct InsertReplaceEdit

    enum class CompletionItem_textEditType {
        Uninitialized = -1,
        TextEdit = 0,
        InsertReplaceEdit = 1,
    }; // enum class CompletionItem_textEditType

    extern const std::map<CompletionItem_textEditType, std::string>
        CompletionItem_textEditTypeNames;

    class CompletionItem_textEdit {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionItem_textEdit();
        CompletionItem_textEdit(CompletionItem_textEdit &&other);
        CompletionItem_textEdit(const CompletionItem_textEdit &other);
        ~CompletionItem_textEdit();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionItem_textEdit &&other
        ) -> CompletionItem_textEdit &;

        auto operator=(
            const CompletionItem_textEdit &other
        ) -> CompletionItem_textEdit &;

        auto type() const -> const CompletionItem_textEditType &;

        auto textEdit() const -> const TextEdit &;

        auto operator=(
            const std::unique_ptr<TextEdit> &textEdit
        ) -> CompletionItem_textEdit &;

        auto operator=(
            std::unique_ptr<TextEdit> &&textEdit
        ) -> CompletionItem_textEdit &;

        auto operator=(const TextEdit &textEdit) -> CompletionItem_textEdit &;

        auto operator=(TextEdit &&textEdit) -> CompletionItem_textEdit &;

        auto insertReplaceEdit() const -> const InsertReplaceEdit &;

        auto operator=(
            const std::unique_ptr<InsertReplaceEdit> &insertReplaceEdit
        ) -> CompletionItem_textEdit &;

        auto operator=(
            std::unique_ptr<InsertReplaceEdit> &&insertReplaceEdit
        ) -> CompletionItem_textEdit &;

        auto operator=(
            const InsertReplaceEdit &insertReplaceEdit
        ) -> CompletionItem_textEdit &;

        auto operator=(
            InsertReplaceEdit &&insertReplaceEdit
        ) -> CompletionItem_textEdit &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        CompletionItem_textEditType _type{
            CompletionItem_textEditType::Uninitialized
        };

        union {
            std::unique_ptr<TextEdit> _textEdit;
            std::unique_ptr<InsertReplaceEdit> _insertReplaceEdit;
        };

        auto reset() -> void;
    }; // class CompletionItem_textEdit

    /**
     * Value-object describing what options formatting should use.
     */
    struct FormattingOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FormattingOptions();
        FormattingOptions(FormattingOptions &&other);
        FormattingOptions(const FormattingOptions &other);
        ~FormattingOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FormattingOptions &&other) -> FormattingOptions &;

        auto operator=(const FormattingOptions &other) -> FormattingOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Size of a tab in spaces.
         */
        uinteger_t tabSize;
        /**
         * Prefer spaces over tabs.
         */
        boolean_t insertSpaces;
        /**
         * Trim trailing whitespace on a line.
         *
         * @since 3.15.0
         */
        std::optional<boolean_t> trimTrailingWhitespace;
        /**
         * Insert a newline character at the end of the file if one does not exist.
         *
         * @since 3.15.0
         */
        std::optional<boolean_t> insertFinalNewline;
        /**
         * Trim all newlines after the final newline at the end of the file.
         *
         * @since 3.15.0
         */
        std::optional<boolean_t> trimFinalNewlines;
    }; // struct FormattingOptions

    /**
     * The parameters of a {@link DocumentOnTypeFormattingRequest}.
     */
    struct DocumentOnTypeFormattingParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentOnTypeFormattingParams();
        DocumentOnTypeFormattingParams(DocumentOnTypeFormattingParams &&other);
        DocumentOnTypeFormattingParams(
            const DocumentOnTypeFormattingParams &other
        );
        ~DocumentOnTypeFormattingParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentOnTypeFormattingParams &&other
        ) -> DocumentOnTypeFormattingParams &;

        auto operator=(
            const DocumentOnTypeFormattingParams &other
        ) -> DocumentOnTypeFormattingParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The document to format.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The position around which the on type formatting should happen.
         * This is not necessarily the exact position where the character denoted
         * by the property `ch` got typed.
         */
        Position position;
        /**
         * The character that has been typed that triggered the formatting
         * on type request. That is not necessarily the last character that
         * got inserted into the document since the client could auto insert
         * characters as well (e.g. like automatic brace completion).
         */
        string_t ch;
        /**
         * The formatting options.
         */
        FormattingOptions options;
    }; // struct DocumentOnTypeFormattingParams

    /**
     * A special text edit with an additional change annotation.
     *
     * @since 3.16.0.
     */
    struct AnnotatedTextEdit
        : public TextEdit
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        AnnotatedTextEdit();
        AnnotatedTextEdit(AnnotatedTextEdit &&other);
        AnnotatedTextEdit(const AnnotatedTextEdit &other);
        ~AnnotatedTextEdit();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(AnnotatedTextEdit &&other) -> AnnotatedTextEdit &;

        auto operator=(const AnnotatedTextEdit &other) -> AnnotatedTextEdit &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The actual identifier of the change annotation
         */
        string_t annotationId;
    }; // struct AnnotatedTextEdit

    enum class TextDocumentEdit_edits_elemType {
        Uninitialized = -1,
        TextEdit = 0,
        AnnotatedTextEdit = 1,
    }; // enum class TextDocumentEdit_edits_elemType

    extern const std::map<TextDocumentEdit_edits_elemType, std::string>
        TextDocumentEdit_edits_elemTypeNames;

    class TextDocumentEdit_edits_elem {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentEdit_edits_elem();
        TextDocumentEdit_edits_elem(TextDocumentEdit_edits_elem &&other);
        TextDocumentEdit_edits_elem(const TextDocumentEdit_edits_elem &other);
        ~TextDocumentEdit_edits_elem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentEdit_edits_elem &&other
        ) -> TextDocumentEdit_edits_elem &;

        auto operator=(
            const TextDocumentEdit_edits_elem &other
        ) -> TextDocumentEdit_edits_elem &;

        auto type() const -> const TextDocumentEdit_edits_elemType &;

        auto textEdit() const -> const TextEdit &;

        auto operator=(
            const std::unique_ptr<TextEdit> &textEdit
        ) -> TextDocumentEdit_edits_elem &;

        auto operator=(
            std::unique_ptr<TextEdit> &&textEdit
        ) -> TextDocumentEdit_edits_elem &;

        auto operator=(
            const TextEdit &textEdit
        ) -> TextDocumentEdit_edits_elem &;

        auto operator=(TextEdit &&textEdit) -> TextDocumentEdit_edits_elem &;

        auto annotatedTextEdit() const -> const AnnotatedTextEdit &;

        auto operator=(
            const std::unique_ptr<AnnotatedTextEdit> &annotatedTextEdit
        ) -> TextDocumentEdit_edits_elem &;

        auto operator=(
            std::unique_ptr<AnnotatedTextEdit> &&annotatedTextEdit
        ) -> TextDocumentEdit_edits_elem &;

        auto operator=(
            const AnnotatedTextEdit &annotatedTextEdit
        ) -> TextDocumentEdit_edits_elem &;

        auto operator=(
            AnnotatedTextEdit &&annotatedTextEdit
        ) -> TextDocumentEdit_edits_elem &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocumentEdit_edits_elemType _type{
            TextDocumentEdit_edits_elemType::Uninitialized
        };

        union {
            std::unique_ptr<TextEdit> _textEdit;
            std::unique_ptr<AnnotatedTextEdit> _annotatedTextEdit;
        };

        auto reset() -> void;
    }; // class TextDocumentEdit_edits_elem

    typedef std::vector<TextDocumentEdit_edits_elem> TextDocumentEdit_edits;

    /**
     * Describes the currently selected completion item.
     *
     * @since 3.18.0
     * @proposed
     */
    struct SelectedCompletionInfo {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SelectedCompletionInfo();
        SelectedCompletionInfo(SelectedCompletionInfo &&other);
        SelectedCompletionInfo(const SelectedCompletionInfo &other);
        ~SelectedCompletionInfo();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SelectedCompletionInfo &&other
        ) -> SelectedCompletionInfo &;

        auto operator=(
            const SelectedCompletionInfo &other
        ) -> SelectedCompletionInfo &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The range that will be replaced if this completion item is accepted.
         */
        Range range;
        /**
         * The text the range will be replaced with if this completion is accepted.
         */
        string_t text;
    }; // struct SelectedCompletionInfo

    /**
     * Provides information about the context in which an inline completion was requested.
     *
     * @since 3.18.0
     * @proposed
     */
    struct InlineCompletionContext {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineCompletionContext();
        InlineCompletionContext(InlineCompletionContext &&other);
        InlineCompletionContext(const InlineCompletionContext &other);
        ~InlineCompletionContext();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlineCompletionContext &&other
        ) -> InlineCompletionContext &;

        auto operator=(
            const InlineCompletionContext &other
        ) -> InlineCompletionContext &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Describes how the inline completion was triggered.
         */
        InlineCompletionTriggerKind triggerKind;
        /**
         * Provides information about the currently selected item in the autocomplete widget if it is visible.
         */
        std::optional<SelectedCompletionInfo> selectedCompletionInfo;
    }; // struct InlineCompletionContext

    /**
     * Represents a related message and source code location for a diagnostic. This should be
     * used to point to code locations that cause or related to a diagnostics, e.g when duplicating
     * a symbol in a scope.
     */
    struct DiagnosticRelatedInformation {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DiagnosticRelatedInformation();
        DiagnosticRelatedInformation(DiagnosticRelatedInformation &&other);
        DiagnosticRelatedInformation(
            const DiagnosticRelatedInformation &other
        );
        ~DiagnosticRelatedInformation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DiagnosticRelatedInformation &&other
        ) -> DiagnosticRelatedInformation &;

        auto operator=(
            const DiagnosticRelatedInformation &other
        ) -> DiagnosticRelatedInformation &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The location of this related diagnostic information.
         */
        Location location;
        /**
         * The message of this related diagnostic information.
         */
        string_t message;
    }; // struct DiagnosticRelatedInformation

    typedef std::vector<DiagnosticRelatedInformation> Diagnostic_relatedInformation;

    enum class ParameterInformation_labelType {
        Uninitialized = -1,
        String = 0,
        PairOfUIntegerAndUInteger = 1,
    }; // enum class ParameterInformation_labelType

    extern const std::map<ParameterInformation_labelType, std::string>
        ParameterInformation_labelTypeNames;

    class ParameterInformation_label {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ParameterInformation_label();
        ParameterInformation_label(ParameterInformation_label &&other);
        ParameterInformation_label(const ParameterInformation_label &other);
        ~ParameterInformation_label();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ParameterInformation_label &&other
        ) -> ParameterInformation_label &;

        auto operator=(
            const ParameterInformation_label &other
        ) -> ParameterInformation_label &;

        auto type() const -> const ParameterInformation_labelType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> ParameterInformation_label &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> ParameterInformation_label &;

        auto operator=(const string_t &string) -> ParameterInformation_label &;

        auto operator=(string_t &&string) -> ParameterInformation_label &;

        auto pairOfUIntegerAndUInteger() const
        -> const std::pair<uinteger_t, uinteger_t> &;

        auto operator=(
            const std::unique_ptr<std::pair<uinteger_t, uinteger_t>> &pairOfUIntegerAndUInteger
        ) -> ParameterInformation_label &;

        auto operator=(
            std::unique_ptr<std::pair<uinteger_t, uinteger_t>> &&pairOfUIntegerAndUInteger
        ) -> ParameterInformation_label &;

        auto operator=(
            const std::pair<uinteger_t, uinteger_t> &pairOfUIntegerAndUInteger
        ) -> ParameterInformation_label &;

        auto operator=(
            std::pair<uinteger_t, uinteger_t> &&pairOfUIntegerAndUInteger
        ) -> ParameterInformation_label &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ParameterInformation_labelType _type{
            ParameterInformation_labelType::Uninitialized
        };

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<std::pair<uinteger_t, uinteger_t>> _pairOfUIntegerAndUInteger;
        };

        auto reset() -> void;
    }; // class ParameterInformation_label

    /**
     * Represents a parameter of a callable-signature. A parameter can
     * have a label and a doc-comment.
     */
    struct ParameterInformation {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ParameterInformation();
        ParameterInformation(ParameterInformation &&other);
        ParameterInformation(const ParameterInformation &other);
        ~ParameterInformation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ParameterInformation &&other) -> ParameterInformation &;

        auto operator=(
            const ParameterInformation &other
        ) -> ParameterInformation &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The label of this parameter information.
         *
         * Either a string or an inclusive start and exclusive end offsets within its containing
         * signature label. (see SignatureInformation.label). The offsets are based on a UTF-16
         * string representation as `Position` and `Range` does.
         *
         * *Note*: a label of type string should be a substring of its containing signature label.
         * Its intended use case is to highlight the parameter label part in the `SignatureInformation.label`.
         */
        ParameterInformation_label label;
        /**
         * The human-readable doc-comment of this parameter. Will be shown
         * in the UI but can be omitted.
         */
        std::optional<ParameterInformation_documentation> documentation;
    }; // struct ParameterInformation

    /**
     * Represents the signature of something callable. A signature
     * can have a label, like a function-name, a doc-comment, and
     * a set of parameters.
     */
    struct SignatureInformation {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SignatureInformation();
        SignatureInformation(SignatureInformation &&other);
        SignatureInformation(const SignatureInformation &other);
        ~SignatureInformation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SignatureInformation &&other) -> SignatureInformation &;

        auto operator=(
            const SignatureInformation &other
        ) -> SignatureInformation &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The label of this signature. Will be shown in
         * the UI.
         */
        string_t label;
        /**
         * The human-readable doc-comment of this signature. Will be shown
         * in the UI but can be omitted.
         */
        std::optional<SignatureInformation_documentation> documentation;
        /**
         * The parameters of this signature.
         */
        std::optional<std::vector<ParameterInformation>> parameters;
        /**
         * The index of the active parameter.
         *
         * If provided, this is used in place of `SignatureHelp.activeParameter`.
         *
         * @since 3.16.0
         */
        std::optional<uinteger_t> activeParameter;
    }; // struct SignatureInformation

    /**
     * Signature help represents the signature of something
     * callable. There can be multiple signature but only one
     * active and only one active parameter.
     */
    struct SignatureHelp {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SignatureHelp();
        SignatureHelp(SignatureHelp &&other);
        SignatureHelp(const SignatureHelp &other);
        ~SignatureHelp();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SignatureHelp &&other) -> SignatureHelp &;

        auto operator=(const SignatureHelp &other) -> SignatureHelp &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * One or more signatures.
         */
        std::vector<SignatureInformation> signatures;
        /**
         * The active signature. If omitted or the value lies outside the
         * range of `signatures` the value defaults to zero or is ignored if
         * the `SignatureHelp` has no signatures.
         *
         * Whenever possible implementors should make an active decision about
         * the active signature and shouldn't rely on a default value.
         *
         * In future version of the protocol this property might become
         * mandatory to better express this.
         */
        std::optional<uinteger_t> activeSignature;
        /**
         * The active parameter of the active signature. If omitted or the value
         * lies outside the range of `signatures[activeSignature].parameters`
         * defaults to 0 if the active signature has parameters. If
         * the active signature has no parameters it is ignored.
         * In future version of the protocol this property might become
         * mandatory to better express the active parameter if the
         * active signature does have any.
         */
        std::optional<uinteger_t> activeParameter;
    }; // struct SignatureHelp

    typedef std::vector<SignatureInformation> SignatureHelp_signatures;

    /**
     * Additional information about the context in which a signature help request was triggered.
     *
     * @since 3.15.0
     */
    struct SignatureHelpContext {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SignatureHelpContext();
        SignatureHelpContext(SignatureHelpContext &&other);
        SignatureHelpContext(const SignatureHelpContext &other);
        ~SignatureHelpContext();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SignatureHelpContext &&other) -> SignatureHelpContext &;

        auto operator=(
            const SignatureHelpContext &other
        ) -> SignatureHelpContext &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Action that caused signature help to be triggered.
         */
        SignatureHelpTriggerKind triggerKind;
        /**
         * Character that caused signature help to be triggered.
         *
         * This is undefined when `triggerKind !== SignatureHelpTriggerKind.TriggerCharacter`
         */
        std::optional<string_t> triggerCharacter;
        /**
         * `true` if signature help was already showing when it was triggered.
         *
         * Retriggers occurs when the signature help is already active and can be caused by actions such as
         * typing a trigger character, a cursor move, or document content changes.
         */
        boolean_t isRetrigger;
        /**
         * The currently active `SignatureHelp`.
         *
         * The `activeSignatureHelp` has its `SignatureHelp.activeSignature` field updated based on
         * the user navigating through available signatures.
         */
        std::optional<SignatureHelp> activeSignatureHelp;
    }; // struct SignatureHelpContext

    typedef std::vector<ParameterInformation> SignatureInformation_parameters;

    typedef std::pair<uinteger_t, uinteger_t> ParameterInformation_label_1;

    struct ExecutionSummary {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ExecutionSummary();
        ExecutionSummary(ExecutionSummary &&other);
        ExecutionSummary(const ExecutionSummary &other);
        ~ExecutionSummary();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ExecutionSummary &&other) -> ExecutionSummary &;

        auto operator=(const ExecutionSummary &other) -> ExecutionSummary &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A strict monotonically increasing value
         * indicating the execution order of a cell
         * inside a notebook.
         */
        uinteger_t executionOrder;
        /**
         * Whether the execution was successful or
         * not if known by the client.
         */
        std::optional<boolean_t> success;
    }; // struct ExecutionSummary

    struct FoldingRangeClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FoldingRangeClientCapabilities();
        FoldingRangeClientCapabilities(FoldingRangeClientCapabilities &&other);
        FoldingRangeClientCapabilities(
            const FoldingRangeClientCapabilities &other
        );
        ~FoldingRangeClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            FoldingRangeClientCapabilities &&other
        ) -> FoldingRangeClientCapabilities &;

        auto operator=(
            const FoldingRangeClientCapabilities &other
        ) -> FoldingRangeClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration for folding range
         * providers. If this is set to `true` the client supports the new
         * `FoldingRangeRegistrationOptions` return value for the corresponding
         * server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * The maximum number of folding ranges that the client prefers to receive
         * per document. The value serves as a hint, servers are free to follow the
         * limit.
         */
        std::optional<uinteger_t> rangeLimit;
        /**
         * If set, the client signals that it only supports folding complete lines.
         * If set, client will ignore specified `startCharacter` and `endCharacter`
         * properties in a FoldingRange.
         */
        std::optional<boolean_t> lineFoldingOnly;
        /**
         * Specific options for the folding range kind.
         *
         * @since 3.17.0
         */
        std::optional<FoldingRangeClientCapabilities_foldingRangeKind>
            foldingRangeKind;
        /**
         * Specific options for the folding range.
         *
         * @since 3.17.0
         */
        std::optional<FoldingRangeClientCapabilities_foldingRange>
            foldingRange;
    }; // struct FoldingRangeClientCapabilities

    enum class DefinitionType {
        Uninitialized = -1,
        Location = 0,
        LocationArray = 1,
    }; // enum class DefinitionType

    extern const std::map<DefinitionType, std::string> DefinitionTypeNames;

    class Definition {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Definition();
        Definition(Definition &&other);
        Definition(const Definition &other);
        ~Definition();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Definition &&other) -> Definition &;

        auto operator=(const Definition &other) -> Definition &;

        auto type() const -> const DefinitionType &;

        auto location() const -> const Location &;

        auto operator=(
            const std::unique_ptr<Location> &location
        ) -> Definition &;

        auto operator=(std::unique_ptr<Location> &&location) -> Definition &;

        auto operator=(const Location &location) -> Definition &;

        auto operator=(Location &&location) -> Definition &;

        auto locationArray() const -> const std::vector<Location> &;

        auto operator=(
            const std::unique_ptr<std::vector<Location>> &locationArray
        ) -> Definition &;

        auto operator=(
            std::unique_ptr<std::vector<Location>> &&locationArray
        ) -> Definition &;

        auto operator=(
            const std::vector<Location> &locationArray
        ) -> Definition &;

        auto operator=(std::vector<Location> &&locationArray) -> Definition &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        DefinitionType _type{DefinitionType::Uninitialized};

        union {
            std::unique_ptr<Location> _location;
            std::unique_ptr<std::vector<Location>> _locationArray;
        };

        auto reset() -> void;
    }; // class Definition

    typedef std::vector<Location> Definition_1;

    typedef LocationLink DefinitionLink;

    enum class DeclarationType {
        Uninitialized = -1,
        Location = 0,
        LocationArray = 1,
    }; // enum class DeclarationType

    extern const std::map<DeclarationType, std::string> DeclarationTypeNames;

    class Declaration {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Declaration();
        Declaration(Declaration &&other);
        Declaration(const Declaration &other);
        ~Declaration();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Declaration &&other) -> Declaration &;

        auto operator=(const Declaration &other) -> Declaration &;

        auto type() const -> const DeclarationType &;

        auto location() const -> const Location &;

        auto operator=(
            const std::unique_ptr<Location> &location
        ) -> Declaration &;

        auto operator=(std::unique_ptr<Location> &&location) -> Declaration &;

        auto operator=(const Location &location) -> Declaration &;

        auto operator=(Location &&location) -> Declaration &;

        auto locationArray() const -> const std::vector<Location> &;

        auto operator=(
            const std::unique_ptr<std::vector<Location>> &locationArray
        ) -> Declaration &;

        auto operator=(
            std::unique_ptr<std::vector<Location>> &&locationArray
        ) -> Declaration &;

        auto operator=(
            const std::vector<Location> &locationArray
        ) -> Declaration &;

        auto operator=(std::vector<Location> &&locationArray) -> Declaration &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        DeclarationType _type{DeclarationType::Uninitialized};

        union {
            std::unique_ptr<Location> _location;
            std::unique_ptr<std::vector<Location>> _locationArray;
        };

        auto reset() -> void;
    }; // class Declaration

    typedef std::vector<Location> Declaration_1;

    typedef LocationLink DeclarationLink;

    enum class InlineValueType {
        Uninitialized = -1,
        InlineValueText = 0,
        InlineValueVariableLookup = 1,
        InlineValueEvaluatableExpression = 2,
    }; // enum class InlineValueType

    extern const std::map<InlineValueType, std::string> InlineValueTypeNames;

    class InlineValue {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineValue();
        InlineValue(InlineValue &&other);
        InlineValue(const InlineValue &other);
        ~InlineValue();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlineValue &&other) -> InlineValue &;

        auto operator=(const InlineValue &other) -> InlineValue &;

        auto type() const -> const InlineValueType &;

        auto inlineValueText() const -> const InlineValueText &;

        auto operator=(
            const std::unique_ptr<InlineValueText> &inlineValueText
        ) -> InlineValue &;

        auto operator=(
            std::unique_ptr<InlineValueText> &&inlineValueText
        ) -> InlineValue &;

        auto operator=(
            const InlineValueText &inlineValueText
        ) -> InlineValue &;

        auto operator=(InlineValueText &&inlineValueText) -> InlineValue &;

        auto inlineValueVariableLookup() const
        -> const InlineValueVariableLookup &;

        auto operator=(
            const std::unique_ptr<InlineValueVariableLookup> &inlineValueVariableLookup
        ) -> InlineValue &;

        auto operator=(
            std::unique_ptr<InlineValueVariableLookup> &&inlineValueVariableLookup
        ) -> InlineValue &;

        auto operator=(
            const InlineValueVariableLookup &inlineValueVariableLookup
        ) -> InlineValue &;

        auto operator=(
            InlineValueVariableLookup &&inlineValueVariableLookup
        ) -> InlineValue &;

        auto inlineValueEvaluatableExpression() const
        -> const InlineValueEvaluatableExpression &;

        auto operator=(
            const std::unique_ptr<InlineValueEvaluatableExpression> &inlineValueEvaluatableExpression
        ) -> InlineValue &;

        auto operator=(
            std::unique_ptr<InlineValueEvaluatableExpression> &&inlineValueEvaluatableExpression
        ) -> InlineValue &;

        auto operator=(
            const InlineValueEvaluatableExpression &inlineValueEvaluatableExpression
        ) -> InlineValue &;

        auto operator=(
            InlineValueEvaluatableExpression &&inlineValueEvaluatableExpression
        ) -> InlineValue &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        InlineValueType _type{InlineValueType::Uninitialized};

        union {
            std::unique_ptr<InlineValueText> _inlineValueText;
            std::unique_ptr<InlineValueVariableLookup> _inlineValueVariableLookup;
            std::unique_ptr<InlineValueEvaluatableExpression> _inlineValueEvaluatableExpression;
        };

        auto reset() -> void;
    }; // class InlineValue

    struct PrepareRenameResult_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        PrepareRenameResult_1();
        PrepareRenameResult_1(PrepareRenameResult_1 &&other);
        PrepareRenameResult_1(const PrepareRenameResult_1 &other);
        ~PrepareRenameResult_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            PrepareRenameResult_1 &&other
        ) -> PrepareRenameResult_1 &;

        auto operator=(
            const PrepareRenameResult_1 &other
        ) -> PrepareRenameResult_1 &;

        // ================== //
        // Field Declarations //
        // ================== //

        Range range;
        string_t placeholder;
    }; // struct PrepareRenameResult_1

    enum class PrepareRenameResultType {
        Uninitialized = -1,
        Range = 0,
        PrepareRenameResult_1 = 1,
        PrepareRenameResult_2 = 2,
    }; // enum class PrepareRenameResultType

    extern const std::map<PrepareRenameResultType, std::string>
        PrepareRenameResultTypeNames;

    class PrepareRenameResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        PrepareRenameResult();
        PrepareRenameResult(PrepareRenameResult &&other);
        PrepareRenameResult(const PrepareRenameResult &other);
        ~PrepareRenameResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(PrepareRenameResult &&other) -> PrepareRenameResult &;

        auto operator=(
            const PrepareRenameResult &other
        ) -> PrepareRenameResult &;

        auto type() const -> const PrepareRenameResultType &;

        auto range() const -> const Range &;

        auto operator=(
            const std::unique_ptr<Range> &range
        ) -> PrepareRenameResult &;

        auto operator=(
            std::unique_ptr<Range> &&range
        ) -> PrepareRenameResult &;

        auto operator=(const Range &range) -> PrepareRenameResult &;

        auto operator=(Range &&range) -> PrepareRenameResult &;

        auto prepareRenameResult_1() const -> const PrepareRenameResult_1 &;

        auto operator=(
            const std::unique_ptr<PrepareRenameResult_1> &prepareRenameResult_1
        ) -> PrepareRenameResult &;

        auto operator=(
            std::unique_ptr<PrepareRenameResult_1> &&prepareRenameResult_1
        ) -> PrepareRenameResult &;

        auto operator=(
            const PrepareRenameResult_1 &prepareRenameResult_1
        ) -> PrepareRenameResult &;

        auto operator=(
            PrepareRenameResult_1 &&prepareRenameResult_1
        ) -> PrepareRenameResult &;

        auto prepareRenameResult_2() const -> const PrepareRenameResult_2 &;

        auto operator=(
            const std::unique_ptr<PrepareRenameResult_2> &prepareRenameResult_2
        ) -> PrepareRenameResult &;

        auto operator=(
            std::unique_ptr<PrepareRenameResult_2> &&prepareRenameResult_2
        ) -> PrepareRenameResult &;

        auto operator=(
            const PrepareRenameResult_2 &prepareRenameResult_2
        ) -> PrepareRenameResult &;

        auto operator=(
            PrepareRenameResult_2 &&prepareRenameResult_2
        ) -> PrepareRenameResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        PrepareRenameResultType _type{PrepareRenameResultType::Uninitialized};

        union {
            std::unique_ptr<Range> _range;
            std::unique_ptr<PrepareRenameResult_1> _prepareRenameResult_1;
            std::unique_ptr<PrepareRenameResult_2> _prepareRenameResult_2;
        };

        auto reset() -> void;
    }; // class PrepareRenameResult

    struct TextDocumentContentChangeEvent_0 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentContentChangeEvent_0();
        TextDocumentContentChangeEvent_0(
            TextDocumentContentChangeEvent_0 &&other
        );
        TextDocumentContentChangeEvent_0(
            const TextDocumentContentChangeEvent_0 &other
        );
        ~TextDocumentContentChangeEvent_0();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentContentChangeEvent_0 &&other
        ) -> TextDocumentContentChangeEvent_0 &;

        auto operator=(
            const TextDocumentContentChangeEvent_0 &other
        ) -> TextDocumentContentChangeEvent_0 &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The range of the document that changed.
         */
        Range range;
        /**
         * The optional length of the range that got replaced.
         *
         * @deprecated use range instead.
         */
        std::optional<uinteger_t> rangeLength;
        /**
         * The new text for the provided range.
         */
        string_t text;
    }; // struct TextDocumentContentChangeEvent_0

    enum class TextDocumentContentChangeEventType {
        Uninitialized = -1,
        TextDocumentContentChangeEvent_0 = 0,
        TextDocumentContentChangeEvent_1 = 1,
    }; // enum class TextDocumentContentChangeEventType

    extern const std::map<TextDocumentContentChangeEventType, std::string>
        TextDocumentContentChangeEventTypeNames;

    class TextDocumentContentChangeEvent {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentContentChangeEvent();
        TextDocumentContentChangeEvent(TextDocumentContentChangeEvent &&other);
        TextDocumentContentChangeEvent(
            const TextDocumentContentChangeEvent &other
        );
        ~TextDocumentContentChangeEvent();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentContentChangeEvent &&other
        ) -> TextDocumentContentChangeEvent &;

        auto operator=(
            const TextDocumentContentChangeEvent &other
        ) -> TextDocumentContentChangeEvent &;

        auto type() const -> const TextDocumentContentChangeEventType &;

        auto textDocumentContentChangeEvent_0() const
        -> const TextDocumentContentChangeEvent_0 &;

        auto operator=(
            const std::unique_ptr<TextDocumentContentChangeEvent_0> &textDocumentContentChangeEvent_0
        ) -> TextDocumentContentChangeEvent &;

        auto operator=(
            std::unique_ptr<TextDocumentContentChangeEvent_0> &&textDocumentContentChangeEvent_0
        ) -> TextDocumentContentChangeEvent &;

        auto operator=(
            const TextDocumentContentChangeEvent_0 &textDocumentContentChangeEvent_0
        ) -> TextDocumentContentChangeEvent &;

        auto operator=(
            TextDocumentContentChangeEvent_0 &&textDocumentContentChangeEvent_0
        ) -> TextDocumentContentChangeEvent &;

        auto textDocumentContentChangeEvent_1() const
        -> const TextDocumentContentChangeEvent_1 &;

        auto operator=(
            const std::unique_ptr<TextDocumentContentChangeEvent_1> &textDocumentContentChangeEvent_1
        ) -> TextDocumentContentChangeEvent &;

        auto operator=(
            std::unique_ptr<TextDocumentContentChangeEvent_1> &&textDocumentContentChangeEvent_1
        ) -> TextDocumentContentChangeEvent &;

        auto operator=(
            const TextDocumentContentChangeEvent_1 &textDocumentContentChangeEvent_1
        ) -> TextDocumentContentChangeEvent &;

        auto operator=(
            TextDocumentContentChangeEvent_1 &&textDocumentContentChangeEvent_1
        ) -> TextDocumentContentChangeEvent &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocumentContentChangeEventType _type{
            TextDocumentContentChangeEventType::Uninitialized
        };

        union {
            std::unique_ptr<TextDocumentContentChangeEvent_0> _textDocumentContentChangeEvent_0;
            std::unique_ptr<TextDocumentContentChangeEvent_1> _textDocumentContentChangeEvent_1;
        };

        auto reset() -> void;
    }; // class TextDocumentContentChangeEvent

    typedef std::vector<TextDocumentContentChangeEvent> DidChangeTextDocumentParams_contentChanges;

    typedef std::vector<TextDocumentContentChangeEvent> NotebookDocumentChangeEvent_cells_textContent_elem_changes;

    enum class TextDocument_ImplementationResultType {
        Uninitialized = -1,
        Definition = 0,
        DefinitionLinkArray = 1,
        Null = 2,
        LocationArray = 3,
    }; // enum class TextDocument_ImplementationResultType

    extern const std::map<TextDocument_ImplementationResultType, std::string>
        TextDocument_ImplementationResultTypeNames;

    class TextDocument_ImplementationResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_ImplementationResult();
        TextDocument_ImplementationResult(
            TextDocument_ImplementationResult &&other
        );
        TextDocument_ImplementationResult(
            const TextDocument_ImplementationResult &other
        );
        ~TextDocument_ImplementationResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_ImplementationResult &&other
        ) -> TextDocument_ImplementationResult &;

        auto operator=(
            const TextDocument_ImplementationResult &other
        ) -> TextDocument_ImplementationResult &;

        auto type() const -> const TextDocument_ImplementationResultType &;

        auto definition() const -> const Definition &;

        auto operator=(
            const std::unique_ptr<Definition> &definition
        ) -> TextDocument_ImplementationResult &;

        auto operator=(
            std::unique_ptr<Definition> &&definition
        ) -> TextDocument_ImplementationResult &;

        auto operator=(
            const Definition &definition
        ) -> TextDocument_ImplementationResult &;

        auto operator=(
            Definition &&definition
        ) -> TextDocument_ImplementationResult &;

        auto locationLinkArray() const -> const std::vector<DefinitionLink> &;

        auto operator=(
            const std::unique_ptr<std::vector<DefinitionLink>> &locationLinkArray
        ) -> TextDocument_ImplementationResult &;

        auto operator=(
            std::unique_ptr<std::vector<DefinitionLink>> &&locationLinkArray
        ) -> TextDocument_ImplementationResult &;

        auto operator=(
            const std::vector<DefinitionLink> &locationLinkArray
        ) -> TextDocument_ImplementationResult &;

        auto operator=(
            std::vector<DefinitionLink> &&locationLinkArray
        ) -> TextDocument_ImplementationResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_ImplementationResult &;

        auto locationArray() const -> const std::vector<Location> &;

        auto operator=(
            const std::unique_ptr<std::vector<Location>> &locationArray
        ) -> TextDocument_ImplementationResult &;

        auto operator=(
            std::unique_ptr<std::vector<Location>> &&locationArray
        ) -> TextDocument_ImplementationResult &;

        auto operator=(
            const std::vector<Location> &locationArray
        ) -> TextDocument_ImplementationResult &;

        auto operator=(
            std::vector<Location> &&locationArray
        ) -> TextDocument_ImplementationResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_ImplementationResultType _type{
            TextDocument_ImplementationResultType::Uninitialized
        };

        union {
            std::unique_ptr<Definition> _definition;
            std::unique_ptr<std::vector<DefinitionLink>> _locationLinkArray;
            null_t _null;
            std::unique_ptr<std::vector<Location>> _locationArray;
        };

        auto reset() -> void;
    }; // class TextDocument_ImplementationResult

    typedef std::vector<DefinitionLink> TextDocument_ImplementationResult_1;

    typedef std::vector<Location> TextDocument_ImplementationResult_3;

    enum class TextDocument_TypeDefinitionResultType {
        Uninitialized = -1,
        Definition = 0,
        DefinitionLinkArray = 1,
        Null = 2,
        LocationArray = 3,
    }; // enum class TextDocument_TypeDefinitionResultType

    extern const std::map<TextDocument_TypeDefinitionResultType, std::string>
        TextDocument_TypeDefinitionResultTypeNames;

    class TextDocument_TypeDefinitionResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_TypeDefinitionResult();
        TextDocument_TypeDefinitionResult(
            TextDocument_TypeDefinitionResult &&other
        );
        TextDocument_TypeDefinitionResult(
            const TextDocument_TypeDefinitionResult &other
        );
        ~TextDocument_TypeDefinitionResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_TypeDefinitionResult &&other
        ) -> TextDocument_TypeDefinitionResult &;

        auto operator=(
            const TextDocument_TypeDefinitionResult &other
        ) -> TextDocument_TypeDefinitionResult &;

        auto type() const -> const TextDocument_TypeDefinitionResultType &;

        auto definition() const -> const Definition &;

        auto operator=(
            const std::unique_ptr<Definition> &definition
        ) -> TextDocument_TypeDefinitionResult &;

        auto operator=(
            std::unique_ptr<Definition> &&definition
        ) -> TextDocument_TypeDefinitionResult &;

        auto operator=(
            const Definition &definition
        ) -> TextDocument_TypeDefinitionResult &;

        auto operator=(
            Definition &&definition
        ) -> TextDocument_TypeDefinitionResult &;

        auto locationLinkArray() const -> const std::vector<DefinitionLink> &;

        auto operator=(
            const std::unique_ptr<std::vector<DefinitionLink>> &locationLinkArray
        ) -> TextDocument_TypeDefinitionResult &;

        auto operator=(
            std::unique_ptr<std::vector<DefinitionLink>> &&locationLinkArray
        ) -> TextDocument_TypeDefinitionResult &;

        auto operator=(
            const std::vector<DefinitionLink> &locationLinkArray
        ) -> TextDocument_TypeDefinitionResult &;

        auto operator=(
            std::vector<DefinitionLink> &&locationLinkArray
        ) -> TextDocument_TypeDefinitionResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_TypeDefinitionResult &;

        auto locationArray() const -> const std::vector<Location> &;

        auto operator=(
            const std::unique_ptr<std::vector<Location>> &locationArray
        ) -> TextDocument_TypeDefinitionResult &;

        auto operator=(
            std::unique_ptr<std::vector<Location>> &&locationArray
        ) -> TextDocument_TypeDefinitionResult &;

        auto operator=(
            const std::vector<Location> &locationArray
        ) -> TextDocument_TypeDefinitionResult &;

        auto operator=(
            std::vector<Location> &&locationArray
        ) -> TextDocument_TypeDefinitionResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_TypeDefinitionResultType _type{
            TextDocument_TypeDefinitionResultType::Uninitialized
        };

        union {
            std::unique_ptr<Definition> _definition;
            std::unique_ptr<std::vector<DefinitionLink>> _locationLinkArray;
            null_t _null;
            std::unique_ptr<std::vector<Location>> _locationArray;
        };

        auto reset() -> void;
    }; // class TextDocument_TypeDefinitionResult

    typedef std::vector<DefinitionLink> TextDocument_TypeDefinitionResult_1;

    typedef std::vector<Location> TextDocument_TypeDefinitionResult_3;

    typedef std::vector<ColorPresentation> TextDocument_ColorPresentationResult;

    enum class TextDocument_FoldingRangeResultType {
        Uninitialized = -1,
        FoldingRangeArray = 0,
        Null = 1,
    }; // enum class TextDocument_FoldingRangeResultType

    extern const std::map<TextDocument_FoldingRangeResultType, std::string>
        TextDocument_FoldingRangeResultTypeNames;

    class TextDocument_FoldingRangeResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_FoldingRangeResult();
        TextDocument_FoldingRangeResult(
            TextDocument_FoldingRangeResult &&other
        );
        TextDocument_FoldingRangeResult(
            const TextDocument_FoldingRangeResult &other
        );
        ~TextDocument_FoldingRangeResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_FoldingRangeResult &&other
        ) -> TextDocument_FoldingRangeResult &;

        auto operator=(
            const TextDocument_FoldingRangeResult &other
        ) -> TextDocument_FoldingRangeResult &;

        auto type() const -> const TextDocument_FoldingRangeResultType &;

        auto foldingRangeArray() const -> const std::vector<FoldingRange> &;

        auto operator=(
            const std::unique_ptr<std::vector<FoldingRange>> &foldingRangeArray
        ) -> TextDocument_FoldingRangeResult &;

        auto operator=(
            std::unique_ptr<std::vector<FoldingRange>> &&foldingRangeArray
        ) -> TextDocument_FoldingRangeResult &;

        auto operator=(
            const std::vector<FoldingRange> &foldingRangeArray
        ) -> TextDocument_FoldingRangeResult &;

        auto operator=(
            std::vector<FoldingRange> &&foldingRangeArray
        ) -> TextDocument_FoldingRangeResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_FoldingRangeResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_FoldingRangeResultType _type{
            TextDocument_FoldingRangeResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<FoldingRange>> _foldingRangeArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_FoldingRangeResult

    typedef std::vector<FoldingRange> TextDocument_FoldingRangeResult_0;

    enum class TextDocument_DeclarationResultType {
        Uninitialized = -1,
        Declaration = 0,
        DeclarationLinkArray = 1,
        Null = 2,
        LocationArray = 3,
    }; // enum class TextDocument_DeclarationResultType

    extern const std::map<TextDocument_DeclarationResultType, std::string>
        TextDocument_DeclarationResultTypeNames;

    class TextDocument_DeclarationResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_DeclarationResult();
        TextDocument_DeclarationResult(TextDocument_DeclarationResult &&other);
        TextDocument_DeclarationResult(
            const TextDocument_DeclarationResult &other
        );
        ~TextDocument_DeclarationResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_DeclarationResult &&other
        ) -> TextDocument_DeclarationResult &;

        auto operator=(
            const TextDocument_DeclarationResult &other
        ) -> TextDocument_DeclarationResult &;

        auto type() const -> const TextDocument_DeclarationResultType &;

        auto declaration() const -> const Declaration &;

        auto operator=(
            const std::unique_ptr<Declaration> &declaration
        ) -> TextDocument_DeclarationResult &;

        auto operator=(
            std::unique_ptr<Declaration> &&declaration
        ) -> TextDocument_DeclarationResult &;

        auto operator=(
            const Declaration &declaration
        ) -> TextDocument_DeclarationResult &;

        auto operator=(
            Declaration &&declaration
        ) -> TextDocument_DeclarationResult &;

        auto locationLinkArray() const -> const std::vector<DeclarationLink> &;

        auto operator=(
            const std::unique_ptr<std::vector<DeclarationLink>> &locationLinkArray
        ) -> TextDocument_DeclarationResult &;

        auto operator=(
            std::unique_ptr<std::vector<DeclarationLink>> &&locationLinkArray
        ) -> TextDocument_DeclarationResult &;

        auto operator=(
            const std::vector<DeclarationLink> &locationLinkArray
        ) -> TextDocument_DeclarationResult &;

        auto operator=(
            std::vector<DeclarationLink> &&locationLinkArray
        ) -> TextDocument_DeclarationResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_DeclarationResult &;

        auto locationArray() const -> const std::vector<Location> &;

        auto operator=(
            const std::unique_ptr<std::vector<Location>> &locationArray
        ) -> TextDocument_DeclarationResult &;

        auto operator=(
            std::unique_ptr<std::vector<Location>> &&locationArray
        ) -> TextDocument_DeclarationResult &;

        auto operator=(
            const std::vector<Location> &locationArray
        ) -> TextDocument_DeclarationResult &;

        auto operator=(
            std::vector<Location> &&locationArray
        ) -> TextDocument_DeclarationResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_DeclarationResultType _type{
            TextDocument_DeclarationResultType::Uninitialized
        };

        union {
            std::unique_ptr<Declaration> _declaration;
            std::unique_ptr<std::vector<DeclarationLink>> _locationLinkArray;
            null_t _null;
            std::unique_ptr<std::vector<Location>> _locationArray;
        };

        auto reset() -> void;
    }; // class TextDocument_DeclarationResult

    typedef std::vector<DeclarationLink> TextDocument_DeclarationResult_1;

    typedef std::vector<Location> TextDocument_DeclarationResult_3;

    enum class TextDocument_SelectionRangeResultType {
        Uninitialized = -1,
        SelectionRangeArray = 0,
        Null = 1,
    }; // enum class TextDocument_SelectionRangeResultType

    extern const std::map<TextDocument_SelectionRangeResultType, std::string>
        TextDocument_SelectionRangeResultTypeNames;

    class TextDocument_SelectionRangeResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_SelectionRangeResult();
        TextDocument_SelectionRangeResult(
            TextDocument_SelectionRangeResult &&other
        );
        TextDocument_SelectionRangeResult(
            const TextDocument_SelectionRangeResult &other
        );
        ~TextDocument_SelectionRangeResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_SelectionRangeResult &&other
        ) -> TextDocument_SelectionRangeResult &;

        auto operator=(
            const TextDocument_SelectionRangeResult &other
        ) -> TextDocument_SelectionRangeResult &;

        auto type() const -> const TextDocument_SelectionRangeResultType &;

        auto selectionRangeArray() const
        -> const std::vector<SelectionRange> &;

        auto operator=(
            const std::unique_ptr<std::vector<SelectionRange>> &selectionRangeArray
        ) -> TextDocument_SelectionRangeResult &;

        auto operator=(
            std::unique_ptr<std::vector<SelectionRange>> &&selectionRangeArray
        ) -> TextDocument_SelectionRangeResult &;

        auto operator=(
            const std::vector<SelectionRange> &selectionRangeArray
        ) -> TextDocument_SelectionRangeResult &;

        auto operator=(
            std::vector<SelectionRange> &&selectionRangeArray
        ) -> TextDocument_SelectionRangeResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_SelectionRangeResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_SelectionRangeResultType _type{
            TextDocument_SelectionRangeResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<SelectionRange>> _selectionRangeArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_SelectionRangeResult

    typedef std::vector<SelectionRange> TextDocument_SelectionRangeResult_0;

    enum class TextDocument_SemanticTokens_FullResultType {
        Uninitialized = -1,
        SemanticTokens = 0,
        Null = 1,
        SemanticTokensPartialResult = 2,
    }; // enum class TextDocument_SemanticTokens_FullResultType

    extern const std::map<
        TextDocument_SemanticTokens_FullResultType,
        std::string
    > TextDocument_SemanticTokens_FullResultTypeNames;

    class TextDocument_SemanticTokens_FullResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_SemanticTokens_FullResult();
        TextDocument_SemanticTokens_FullResult(
            TextDocument_SemanticTokens_FullResult &&other
        );
        TextDocument_SemanticTokens_FullResult(
            const TextDocument_SemanticTokens_FullResult &other
        );
        ~TextDocument_SemanticTokens_FullResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_SemanticTokens_FullResult &&other
        ) -> TextDocument_SemanticTokens_FullResult &;

        auto operator=(
            const TextDocument_SemanticTokens_FullResult &other
        ) -> TextDocument_SemanticTokens_FullResult &;

        auto type() const
        -> const TextDocument_SemanticTokens_FullResultType &;

        auto semanticTokens() const -> const SemanticTokens &;

        auto operator=(
            const std::unique_ptr<SemanticTokens> &semanticTokens
        ) -> TextDocument_SemanticTokens_FullResult &;

        auto operator=(
            std::unique_ptr<SemanticTokens> &&semanticTokens
        ) -> TextDocument_SemanticTokens_FullResult &;

        auto operator=(
            const SemanticTokens &semanticTokens
        ) -> TextDocument_SemanticTokens_FullResult &;

        auto operator=(
            SemanticTokens &&semanticTokens
        ) -> TextDocument_SemanticTokens_FullResult &;

        auto null() const -> const null_t &;

        auto operator=(
            null_t null
        ) -> TextDocument_SemanticTokens_FullResult &;

        auto semanticTokensPartialResult() const
        -> const SemanticTokensPartialResult &;

        auto operator=(
            const std::unique_ptr<SemanticTokensPartialResult> &semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_FullResult &;

        auto operator=(
            std::unique_ptr<SemanticTokensPartialResult> &&semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_FullResult &;

        auto operator=(
            const SemanticTokensPartialResult &semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_FullResult &;

        auto operator=(
            SemanticTokensPartialResult &&semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_FullResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_SemanticTokens_FullResultType _type{
            TextDocument_SemanticTokens_FullResultType::Uninitialized
        };

        union {
            std::unique_ptr<SemanticTokens> _semanticTokens;
            null_t _null;
            std::unique_ptr<SemanticTokensPartialResult> _semanticTokensPartialResult;
        };

        auto reset() -> void;
    }; // class TextDocument_SemanticTokens_FullResult

    enum class TextDocument_SemanticTokens_Full_DeltaResultType {
        Uninitialized = -1,
        SemanticTokens = 0,
        SemanticTokensDelta = 1,
        Null = 2,
        SemanticTokensPartialResult = 3,
        SemanticTokensDeltaPartialResult = 4,
    }; // enum class TextDocument_SemanticTokens_Full_DeltaResultType

    extern const std::map<
        TextDocument_SemanticTokens_Full_DeltaResultType,
        std::string
    > TextDocument_SemanticTokens_Full_DeltaResultTypeNames;

    class TextDocument_SemanticTokens_Full_DeltaResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_SemanticTokens_Full_DeltaResult();
        TextDocument_SemanticTokens_Full_DeltaResult(
            TextDocument_SemanticTokens_Full_DeltaResult &&other
        );
        TextDocument_SemanticTokens_Full_DeltaResult(
            const TextDocument_SemanticTokens_Full_DeltaResult &other
        );
        ~TextDocument_SemanticTokens_Full_DeltaResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_SemanticTokens_Full_DeltaResult &&other
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            const TextDocument_SemanticTokens_Full_DeltaResult &other
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto type() const
        -> const TextDocument_SemanticTokens_Full_DeltaResultType &;

        auto semanticTokens() const -> const SemanticTokens &;

        auto operator=(
            const std::unique_ptr<SemanticTokens> &semanticTokens
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            std::unique_ptr<SemanticTokens> &&semanticTokens
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            const SemanticTokens &semanticTokens
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            SemanticTokens &&semanticTokens
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto semanticTokensDelta() const -> const SemanticTokensDelta &;

        auto operator=(
            const std::unique_ptr<SemanticTokensDelta> &semanticTokensDelta
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            std::unique_ptr<SemanticTokensDelta> &&semanticTokensDelta
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            const SemanticTokensDelta &semanticTokensDelta
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            SemanticTokensDelta &&semanticTokensDelta
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto null() const -> const null_t &;

        auto operator=(
            null_t null
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto semanticTokensPartialResult() const
        -> const SemanticTokensPartialResult &;

        auto operator=(
            const std::unique_ptr<SemanticTokensPartialResult> &semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            std::unique_ptr<SemanticTokensPartialResult> &&semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            const SemanticTokensPartialResult &semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            SemanticTokensPartialResult &&semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto semanticTokensDeltaPartialResult() const
        -> const SemanticTokensDeltaPartialResult &;

        auto operator=(
            const std::unique_ptr<SemanticTokensDeltaPartialResult> &semanticTokensDeltaPartialResult
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            std::unique_ptr<SemanticTokensDeltaPartialResult> &&semanticTokensDeltaPartialResult
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            const SemanticTokensDeltaPartialResult &semanticTokensDeltaPartialResult
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;

        auto operator=(
            SemanticTokensDeltaPartialResult &&semanticTokensDeltaPartialResult
        ) -> TextDocument_SemanticTokens_Full_DeltaResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_SemanticTokens_Full_DeltaResultType _type{
            TextDocument_SemanticTokens_Full_DeltaResultType::Uninitialized
        };

        union {
            std::unique_ptr<SemanticTokens> _semanticTokens;
            std::unique_ptr<SemanticTokensDelta> _semanticTokensDelta;
            null_t _null;
            std::unique_ptr<SemanticTokensPartialResult> _semanticTokensPartialResult;
            std::unique_ptr<SemanticTokensDeltaPartialResult> _semanticTokensDeltaPartialResult;
        };

        auto reset() -> void;
    }; // class TextDocument_SemanticTokens_Full_DeltaResult

    enum class TextDocument_SemanticTokens_RangeResultType {
        Uninitialized = -1,
        SemanticTokens = 0,
        Null = 1,
        SemanticTokensPartialResult = 2,
    }; // enum class TextDocument_SemanticTokens_RangeResultType

    extern const std::map<
        TextDocument_SemanticTokens_RangeResultType,
        std::string
    > TextDocument_SemanticTokens_RangeResultTypeNames;

    class TextDocument_SemanticTokens_RangeResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_SemanticTokens_RangeResult();
        TextDocument_SemanticTokens_RangeResult(
            TextDocument_SemanticTokens_RangeResult &&other
        );
        TextDocument_SemanticTokens_RangeResult(
            const TextDocument_SemanticTokens_RangeResult &other
        );
        ~TextDocument_SemanticTokens_RangeResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_SemanticTokens_RangeResult &&other
        ) -> TextDocument_SemanticTokens_RangeResult &;

        auto operator=(
            const TextDocument_SemanticTokens_RangeResult &other
        ) -> TextDocument_SemanticTokens_RangeResult &;

        auto type() const
        -> const TextDocument_SemanticTokens_RangeResultType &;

        auto semanticTokens() const -> const SemanticTokens &;

        auto operator=(
            const std::unique_ptr<SemanticTokens> &semanticTokens
        ) -> TextDocument_SemanticTokens_RangeResult &;

        auto operator=(
            std::unique_ptr<SemanticTokens> &&semanticTokens
        ) -> TextDocument_SemanticTokens_RangeResult &;

        auto operator=(
            const SemanticTokens &semanticTokens
        ) -> TextDocument_SemanticTokens_RangeResult &;

        auto operator=(
            SemanticTokens &&semanticTokens
        ) -> TextDocument_SemanticTokens_RangeResult &;

        auto null() const -> const null_t &;

        auto operator=(
            null_t null
        ) -> TextDocument_SemanticTokens_RangeResult &;

        auto semanticTokensPartialResult() const
        -> const SemanticTokensPartialResult &;

        auto operator=(
            const std::unique_ptr<SemanticTokensPartialResult> &semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_RangeResult &;

        auto operator=(
            std::unique_ptr<SemanticTokensPartialResult> &&semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_RangeResult &;

        auto operator=(
            const SemanticTokensPartialResult &semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_RangeResult &;

        auto operator=(
            SemanticTokensPartialResult &&semanticTokensPartialResult
        ) -> TextDocument_SemanticTokens_RangeResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_SemanticTokens_RangeResultType _type{
            TextDocument_SemanticTokens_RangeResultType::Uninitialized
        };

        union {
            std::unique_ptr<SemanticTokens> _semanticTokens;
            null_t _null;
            std::unique_ptr<SemanticTokensPartialResult> _semanticTokensPartialResult;
        };

        auto reset() -> void;
    }; // class TextDocument_SemanticTokens_RangeResult

    enum class TextDocument_LinkedEditingRangeResultType {
        Uninitialized = -1,
        LinkedEditingRanges = 0,
        Null = 1,
    }; // enum class TextDocument_LinkedEditingRangeResultType

    extern const std::map<
        TextDocument_LinkedEditingRangeResultType,
        std::string
    > TextDocument_LinkedEditingRangeResultTypeNames;

    class TextDocument_LinkedEditingRangeResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_LinkedEditingRangeResult();
        TextDocument_LinkedEditingRangeResult(
            TextDocument_LinkedEditingRangeResult &&other
        );
        TextDocument_LinkedEditingRangeResult(
            const TextDocument_LinkedEditingRangeResult &other
        );
        ~TextDocument_LinkedEditingRangeResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_LinkedEditingRangeResult &&other
        ) -> TextDocument_LinkedEditingRangeResult &;

        auto operator=(
            const TextDocument_LinkedEditingRangeResult &other
        ) -> TextDocument_LinkedEditingRangeResult &;

        auto type() const -> const TextDocument_LinkedEditingRangeResultType &;

        auto linkedEditingRanges() const -> const LinkedEditingRanges &;

        auto operator=(
            const std::unique_ptr<LinkedEditingRanges> &linkedEditingRanges
        ) -> TextDocument_LinkedEditingRangeResult &;

        auto operator=(
            std::unique_ptr<LinkedEditingRanges> &&linkedEditingRanges
        ) -> TextDocument_LinkedEditingRangeResult &;

        auto operator=(
            const LinkedEditingRanges &linkedEditingRanges
        ) -> TextDocument_LinkedEditingRangeResult &;

        auto operator=(
            LinkedEditingRanges &&linkedEditingRanges
        ) -> TextDocument_LinkedEditingRangeResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_LinkedEditingRangeResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_LinkedEditingRangeResultType _type{
            TextDocument_LinkedEditingRangeResultType::Uninitialized
        };

        union {
            std::unique_ptr<LinkedEditingRanges> _linkedEditingRanges;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_LinkedEditingRangeResult

    enum class TextDocument_InlineValueResultType {
        Uninitialized = -1,
        InlineValueArray = 0,
        Null = 1,
    }; // enum class TextDocument_InlineValueResultType

    extern const std::map<TextDocument_InlineValueResultType, std::string>
        TextDocument_InlineValueResultTypeNames;

    class TextDocument_InlineValueResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_InlineValueResult();
        TextDocument_InlineValueResult(TextDocument_InlineValueResult &&other);
        TextDocument_InlineValueResult(
            const TextDocument_InlineValueResult &other
        );
        ~TextDocument_InlineValueResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_InlineValueResult &&other
        ) -> TextDocument_InlineValueResult &;

        auto operator=(
            const TextDocument_InlineValueResult &other
        ) -> TextDocument_InlineValueResult &;

        auto type() const -> const TextDocument_InlineValueResultType &;

        auto inlineValueArray() const -> const std::vector<InlineValue> &;

        auto operator=(
            const std::unique_ptr<std::vector<InlineValue>> &inlineValueArray
        ) -> TextDocument_InlineValueResult &;

        auto operator=(
            std::unique_ptr<std::vector<InlineValue>> &&inlineValueArray
        ) -> TextDocument_InlineValueResult &;

        auto operator=(
            const std::vector<InlineValue> &inlineValueArray
        ) -> TextDocument_InlineValueResult &;

        auto operator=(
            std::vector<InlineValue> &&inlineValueArray
        ) -> TextDocument_InlineValueResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_InlineValueResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_InlineValueResultType _type{
            TextDocument_InlineValueResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<InlineValue>> _inlineValueArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_InlineValueResult

    typedef std::vector<InlineValue> TextDocument_InlineValueResult_0;

    enum class TextDocument_WillSaveWaitUntilResultType {
        Uninitialized = -1,
        TextEditArray = 0,
        Null = 1,
    }; // enum class TextDocument_WillSaveWaitUntilResultType

    extern const std::map<
        TextDocument_WillSaveWaitUntilResultType,
        std::string
    > TextDocument_WillSaveWaitUntilResultTypeNames;

    class TextDocument_WillSaveWaitUntilResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_WillSaveWaitUntilResult();
        TextDocument_WillSaveWaitUntilResult(
            TextDocument_WillSaveWaitUntilResult &&other
        );
        TextDocument_WillSaveWaitUntilResult(
            const TextDocument_WillSaveWaitUntilResult &other
        );
        ~TextDocument_WillSaveWaitUntilResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_WillSaveWaitUntilResult &&other
        ) -> TextDocument_WillSaveWaitUntilResult &;

        auto operator=(
            const TextDocument_WillSaveWaitUntilResult &other
        ) -> TextDocument_WillSaveWaitUntilResult &;

        auto type() const -> const TextDocument_WillSaveWaitUntilResultType &;

        auto textEditArray() const -> const std::vector<TextEdit> &;

        auto operator=(
            const std::unique_ptr<std::vector<TextEdit>> &textEditArray
        ) -> TextDocument_WillSaveWaitUntilResult &;

        auto operator=(
            std::unique_ptr<std::vector<TextEdit>> &&textEditArray
        ) -> TextDocument_WillSaveWaitUntilResult &;

        auto operator=(
            const std::vector<TextEdit> &textEditArray
        ) -> TextDocument_WillSaveWaitUntilResult &;

        auto operator=(
            std::vector<TextEdit> &&textEditArray
        ) -> TextDocument_WillSaveWaitUntilResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_WillSaveWaitUntilResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_WillSaveWaitUntilResultType _type{
            TextDocument_WillSaveWaitUntilResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<TextEdit>> _textEditArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_WillSaveWaitUntilResult

    typedef std::vector<TextEdit> TextDocument_WillSaveWaitUntilResult_0;

    enum class TextDocument_HoverResultType {
        Uninitialized = -1,
        Hover = 0,
        Null = 1,
    }; // enum class TextDocument_HoverResultType

    extern const std::map<TextDocument_HoverResultType, std::string>
        TextDocument_HoverResultTypeNames;

    class TextDocument_HoverResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_HoverResult();
        TextDocument_HoverResult(TextDocument_HoverResult &&other);
        TextDocument_HoverResult(const TextDocument_HoverResult &other);
        ~TextDocument_HoverResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_HoverResult &&other
        ) -> TextDocument_HoverResult &;

        auto operator=(
            const TextDocument_HoverResult &other
        ) -> TextDocument_HoverResult &;

        auto type() const -> const TextDocument_HoverResultType &;

        auto hover() const -> const Hover &;

        auto operator=(
            const std::unique_ptr<Hover> &hover
        ) -> TextDocument_HoverResult &;

        auto operator=(
            std::unique_ptr<Hover> &&hover
        ) -> TextDocument_HoverResult &;

        auto operator=(const Hover &hover) -> TextDocument_HoverResult &;

        auto operator=(Hover &&hover) -> TextDocument_HoverResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_HoverResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_HoverResultType _type{
            TextDocument_HoverResultType::Uninitialized
        };

        union {
            std::unique_ptr<Hover> _hover;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_HoverResult

    enum class TextDocument_SignatureHelpResultType {
        Uninitialized = -1,
        SignatureHelp = 0,
        Null = 1,
    }; // enum class TextDocument_SignatureHelpResultType

    extern const std::map<TextDocument_SignatureHelpResultType, std::string>
        TextDocument_SignatureHelpResultTypeNames;

    class TextDocument_SignatureHelpResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_SignatureHelpResult();
        TextDocument_SignatureHelpResult(
            TextDocument_SignatureHelpResult &&other
        );
        TextDocument_SignatureHelpResult(
            const TextDocument_SignatureHelpResult &other
        );
        ~TextDocument_SignatureHelpResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_SignatureHelpResult &&other
        ) -> TextDocument_SignatureHelpResult &;

        auto operator=(
            const TextDocument_SignatureHelpResult &other
        ) -> TextDocument_SignatureHelpResult &;

        auto type() const -> const TextDocument_SignatureHelpResultType &;

        auto signatureHelp() const -> const SignatureHelp &;

        auto operator=(
            const std::unique_ptr<SignatureHelp> &signatureHelp
        ) -> TextDocument_SignatureHelpResult &;

        auto operator=(
            std::unique_ptr<SignatureHelp> &&signatureHelp
        ) -> TextDocument_SignatureHelpResult &;

        auto operator=(
            const SignatureHelp &signatureHelp
        ) -> TextDocument_SignatureHelpResult &;

        auto operator=(
            SignatureHelp &&signatureHelp
        ) -> TextDocument_SignatureHelpResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_SignatureHelpResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_SignatureHelpResultType _type{
            TextDocument_SignatureHelpResultType::Uninitialized
        };

        union {
            std::unique_ptr<SignatureHelp> _signatureHelp;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_SignatureHelpResult

    enum class TextDocument_DefinitionResultType {
        Uninitialized = -1,
        Definition = 0,
        DefinitionLinkArray = 1,
        Null = 2,
        LocationArray = 3,
    }; // enum class TextDocument_DefinitionResultType

    extern const std::map<TextDocument_DefinitionResultType, std::string>
        TextDocument_DefinitionResultTypeNames;

    class TextDocument_DefinitionResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_DefinitionResult();
        TextDocument_DefinitionResult(TextDocument_DefinitionResult &&other);
        TextDocument_DefinitionResult(
            const TextDocument_DefinitionResult &other
        );
        ~TextDocument_DefinitionResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_DefinitionResult &&other
        ) -> TextDocument_DefinitionResult &;

        auto operator=(
            const TextDocument_DefinitionResult &other
        ) -> TextDocument_DefinitionResult &;

        auto type() const -> const TextDocument_DefinitionResultType &;

        auto definition() const -> const Definition &;

        auto operator=(
            const std::unique_ptr<Definition> &definition
        ) -> TextDocument_DefinitionResult &;

        auto operator=(
            std::unique_ptr<Definition> &&definition
        ) -> TextDocument_DefinitionResult &;

        auto operator=(
            const Definition &definition
        ) -> TextDocument_DefinitionResult &;

        auto operator=(
            Definition &&definition
        ) -> TextDocument_DefinitionResult &;

        auto locationLinkArray() const -> const std::vector<DefinitionLink> &;

        auto operator=(
            const std::unique_ptr<std::vector<DefinitionLink>> &locationLinkArray
        ) -> TextDocument_DefinitionResult &;

        auto operator=(
            std::unique_ptr<std::vector<DefinitionLink>> &&locationLinkArray
        ) -> TextDocument_DefinitionResult &;

        auto operator=(
            const std::vector<DefinitionLink> &locationLinkArray
        ) -> TextDocument_DefinitionResult &;

        auto operator=(
            std::vector<DefinitionLink> &&locationLinkArray
        ) -> TextDocument_DefinitionResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_DefinitionResult &;

        auto locationArray() const -> const std::vector<Location> &;

        auto operator=(
            const std::unique_ptr<std::vector<Location>> &locationArray
        ) -> TextDocument_DefinitionResult &;

        auto operator=(
            std::unique_ptr<std::vector<Location>> &&locationArray
        ) -> TextDocument_DefinitionResult &;

        auto operator=(
            const std::vector<Location> &locationArray
        ) -> TextDocument_DefinitionResult &;

        auto operator=(
            std::vector<Location> &&locationArray
        ) -> TextDocument_DefinitionResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_DefinitionResultType _type{
            TextDocument_DefinitionResultType::Uninitialized
        };

        union {
            std::unique_ptr<Definition> _definition;
            std::unique_ptr<std::vector<DefinitionLink>> _locationLinkArray;
            null_t _null;
            std::unique_ptr<std::vector<Location>> _locationArray;
        };

        auto reset() -> void;
    }; // class TextDocument_DefinitionResult

    typedef std::vector<DefinitionLink> TextDocument_DefinitionResult_1;

    typedef std::vector<Location> TextDocument_DefinitionResult_3;

    enum class TextDocument_ReferencesResultType {
        Uninitialized = -1,
        LocationArray = 0,
        Null = 1,
    }; // enum class TextDocument_ReferencesResultType

    extern const std::map<TextDocument_ReferencesResultType, std::string>
        TextDocument_ReferencesResultTypeNames;

    class TextDocument_ReferencesResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_ReferencesResult();
        TextDocument_ReferencesResult(TextDocument_ReferencesResult &&other);
        TextDocument_ReferencesResult(
            const TextDocument_ReferencesResult &other
        );
        ~TextDocument_ReferencesResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_ReferencesResult &&other
        ) -> TextDocument_ReferencesResult &;

        auto operator=(
            const TextDocument_ReferencesResult &other
        ) -> TextDocument_ReferencesResult &;

        auto type() const -> const TextDocument_ReferencesResultType &;

        auto locationArray() const -> const std::vector<Location> &;

        auto operator=(
            const std::unique_ptr<std::vector<Location>> &locationArray
        ) -> TextDocument_ReferencesResult &;

        auto operator=(
            std::unique_ptr<std::vector<Location>> &&locationArray
        ) -> TextDocument_ReferencesResult &;

        auto operator=(
            const std::vector<Location> &locationArray
        ) -> TextDocument_ReferencesResult &;

        auto operator=(
            std::vector<Location> &&locationArray
        ) -> TextDocument_ReferencesResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_ReferencesResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_ReferencesResultType _type{
            TextDocument_ReferencesResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<Location>> _locationArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_ReferencesResult

    typedef std::vector<Location> TextDocument_ReferencesResult_0;

    enum class TextDocument_DocumentHighlightResultType {
        Uninitialized = -1,
        DocumentHighlightArray = 0,
        Null = 1,
    }; // enum class TextDocument_DocumentHighlightResultType

    extern const std::map<
        TextDocument_DocumentHighlightResultType,
        std::string
    > TextDocument_DocumentHighlightResultTypeNames;

    class TextDocument_DocumentHighlightResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_DocumentHighlightResult();
        TextDocument_DocumentHighlightResult(
            TextDocument_DocumentHighlightResult &&other
        );
        TextDocument_DocumentHighlightResult(
            const TextDocument_DocumentHighlightResult &other
        );
        ~TextDocument_DocumentHighlightResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_DocumentHighlightResult &&other
        ) -> TextDocument_DocumentHighlightResult &;

        auto operator=(
            const TextDocument_DocumentHighlightResult &other
        ) -> TextDocument_DocumentHighlightResult &;

        auto type() const -> const TextDocument_DocumentHighlightResultType &;

        auto documentHighlightArray() const
        -> const std::vector<DocumentHighlight> &;

        auto operator=(
            const std::unique_ptr<std::vector<DocumentHighlight>> &documentHighlightArray
        ) -> TextDocument_DocumentHighlightResult &;

        auto operator=(
            std::unique_ptr<std::vector<DocumentHighlight>> &&documentHighlightArray
        ) -> TextDocument_DocumentHighlightResult &;

        auto operator=(
            const std::vector<DocumentHighlight> &documentHighlightArray
        ) -> TextDocument_DocumentHighlightResult &;

        auto operator=(
            std::vector<DocumentHighlight> &&documentHighlightArray
        ) -> TextDocument_DocumentHighlightResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_DocumentHighlightResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_DocumentHighlightResultType _type{
            TextDocument_DocumentHighlightResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<DocumentHighlight>> _documentHighlightArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_DocumentHighlightResult

    typedef std::vector<DocumentHighlight> TextDocument_DocumentHighlightResult_0;

    enum class TextDocument_DocumentSymbolResultType {
        Uninitialized = -1,
        SymbolInformationArray = 0,
        DocumentSymbolArray = 1,
        Null = 2,
    }; // enum class TextDocument_DocumentSymbolResultType

    extern const std::map<TextDocument_DocumentSymbolResultType, std::string>
        TextDocument_DocumentSymbolResultTypeNames;

    class TextDocument_DocumentSymbolResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_DocumentSymbolResult();
        TextDocument_DocumentSymbolResult(
            TextDocument_DocumentSymbolResult &&other
        );
        TextDocument_DocumentSymbolResult(
            const TextDocument_DocumentSymbolResult &other
        );
        ~TextDocument_DocumentSymbolResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_DocumentSymbolResult &&other
        ) -> TextDocument_DocumentSymbolResult &;

        auto operator=(
            const TextDocument_DocumentSymbolResult &other
        ) -> TextDocument_DocumentSymbolResult &;

        auto type() const -> const TextDocument_DocumentSymbolResultType &;

        auto symbolInformationArray() const
        -> const std::vector<SymbolInformation> &;

        auto operator=(
            const std::unique_ptr<std::vector<SymbolInformation>> &symbolInformationArray
        ) -> TextDocument_DocumentSymbolResult &;

        auto operator=(
            std::unique_ptr<std::vector<SymbolInformation>> &&symbolInformationArray
        ) -> TextDocument_DocumentSymbolResult &;

        auto operator=(
            const std::vector<SymbolInformation> &symbolInformationArray
        ) -> TextDocument_DocumentSymbolResult &;

        auto operator=(
            std::vector<SymbolInformation> &&symbolInformationArray
        ) -> TextDocument_DocumentSymbolResult &;

        auto documentSymbolArray() const
        -> const std::vector<DocumentSymbol> &;

        auto operator=(
            const std::unique_ptr<std::vector<DocumentSymbol>> &documentSymbolArray
        ) -> TextDocument_DocumentSymbolResult &;

        auto operator=(
            std::unique_ptr<std::vector<DocumentSymbol>> &&documentSymbolArray
        ) -> TextDocument_DocumentSymbolResult &;

        auto operator=(
            const std::vector<DocumentSymbol> &documentSymbolArray
        ) -> TextDocument_DocumentSymbolResult &;

        auto operator=(
            std::vector<DocumentSymbol> &&documentSymbolArray
        ) -> TextDocument_DocumentSymbolResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_DocumentSymbolResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_DocumentSymbolResultType _type{
            TextDocument_DocumentSymbolResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<SymbolInformation>> _symbolInformationArray;
            std::unique_ptr<std::vector<DocumentSymbol>> _documentSymbolArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_DocumentSymbolResult

    typedef std::vector<SymbolInformation> TextDocument_DocumentSymbolResult_0;

    typedef std::vector<DocumentSymbol> TextDocument_DocumentSymbolResult_1;

    typedef std::vector<SymbolInformation> Workspace_SymbolResult_0;

    enum class TextDocument_FormattingResultType {
        Uninitialized = -1,
        TextEditArray = 0,
        Null = 1,
    }; // enum class TextDocument_FormattingResultType

    extern const std::map<TextDocument_FormattingResultType, std::string>
        TextDocument_FormattingResultTypeNames;

    class TextDocument_FormattingResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_FormattingResult();
        TextDocument_FormattingResult(TextDocument_FormattingResult &&other);
        TextDocument_FormattingResult(
            const TextDocument_FormattingResult &other
        );
        ~TextDocument_FormattingResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_FormattingResult &&other
        ) -> TextDocument_FormattingResult &;

        auto operator=(
            const TextDocument_FormattingResult &other
        ) -> TextDocument_FormattingResult &;

        auto type() const -> const TextDocument_FormattingResultType &;

        auto textEditArray() const -> const std::vector<TextEdit> &;

        auto operator=(
            const std::unique_ptr<std::vector<TextEdit>> &textEditArray
        ) -> TextDocument_FormattingResult &;

        auto operator=(
            std::unique_ptr<std::vector<TextEdit>> &&textEditArray
        ) -> TextDocument_FormattingResult &;

        auto operator=(
            const std::vector<TextEdit> &textEditArray
        ) -> TextDocument_FormattingResult &;

        auto operator=(
            std::vector<TextEdit> &&textEditArray
        ) -> TextDocument_FormattingResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_FormattingResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_FormattingResultType _type{
            TextDocument_FormattingResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<TextEdit>> _textEditArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_FormattingResult

    typedef std::vector<TextEdit> TextDocument_FormattingResult_0;

    enum class TextDocument_RangeFormattingResultType {
        Uninitialized = -1,
        TextEditArray = 0,
        Null = 1,
    }; // enum class TextDocument_RangeFormattingResultType

    extern const std::map<TextDocument_RangeFormattingResultType, std::string>
        TextDocument_RangeFormattingResultTypeNames;

    class TextDocument_RangeFormattingResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_RangeFormattingResult();
        TextDocument_RangeFormattingResult(
            TextDocument_RangeFormattingResult &&other
        );
        TextDocument_RangeFormattingResult(
            const TextDocument_RangeFormattingResult &other
        );
        ~TextDocument_RangeFormattingResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_RangeFormattingResult &&other
        ) -> TextDocument_RangeFormattingResult &;

        auto operator=(
            const TextDocument_RangeFormattingResult &other
        ) -> TextDocument_RangeFormattingResult &;

        auto type() const -> const TextDocument_RangeFormattingResultType &;

        auto textEditArray() const -> const std::vector<TextEdit> &;

        auto operator=(
            const std::unique_ptr<std::vector<TextEdit>> &textEditArray
        ) -> TextDocument_RangeFormattingResult &;

        auto operator=(
            std::unique_ptr<std::vector<TextEdit>> &&textEditArray
        ) -> TextDocument_RangeFormattingResult &;

        auto operator=(
            const std::vector<TextEdit> &textEditArray
        ) -> TextDocument_RangeFormattingResult &;

        auto operator=(
            std::vector<TextEdit> &&textEditArray
        ) -> TextDocument_RangeFormattingResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_RangeFormattingResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_RangeFormattingResultType _type{
            TextDocument_RangeFormattingResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<TextEdit>> _textEditArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_RangeFormattingResult

    typedef std::vector<TextEdit> TextDocument_RangeFormattingResult_0;

    enum class TextDocument_RangesFormattingResultType {
        Uninitialized = -1,
        TextEditArray = 0,
        Null = 1,
    }; // enum class TextDocument_RangesFormattingResultType

    extern const std::map<TextDocument_RangesFormattingResultType, std::string>
        TextDocument_RangesFormattingResultTypeNames;

    class TextDocument_RangesFormattingResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_RangesFormattingResult();
        TextDocument_RangesFormattingResult(
            TextDocument_RangesFormattingResult &&other
        );
        TextDocument_RangesFormattingResult(
            const TextDocument_RangesFormattingResult &other
        );
        ~TextDocument_RangesFormattingResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_RangesFormattingResult &&other
        ) -> TextDocument_RangesFormattingResult &;

        auto operator=(
            const TextDocument_RangesFormattingResult &other
        ) -> TextDocument_RangesFormattingResult &;

        auto type() const -> const TextDocument_RangesFormattingResultType &;

        auto textEditArray() const -> const std::vector<TextEdit> &;

        auto operator=(
            const std::unique_ptr<std::vector<TextEdit>> &textEditArray
        ) -> TextDocument_RangesFormattingResult &;

        auto operator=(
            std::unique_ptr<std::vector<TextEdit>> &&textEditArray
        ) -> TextDocument_RangesFormattingResult &;

        auto operator=(
            const std::vector<TextEdit> &textEditArray
        ) -> TextDocument_RangesFormattingResult &;

        auto operator=(
            std::vector<TextEdit> &&textEditArray
        ) -> TextDocument_RangesFormattingResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_RangesFormattingResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_RangesFormattingResultType _type{
            TextDocument_RangesFormattingResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<TextEdit>> _textEditArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_RangesFormattingResult

    typedef std::vector<TextEdit> TextDocument_RangesFormattingResult_0;

    enum class TextDocument_OnTypeFormattingResultType {
        Uninitialized = -1,
        TextEditArray = 0,
        Null = 1,
    }; // enum class TextDocument_OnTypeFormattingResultType

    extern const std::map<TextDocument_OnTypeFormattingResultType, std::string>
        TextDocument_OnTypeFormattingResultTypeNames;

    class TextDocument_OnTypeFormattingResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_OnTypeFormattingResult();
        TextDocument_OnTypeFormattingResult(
            TextDocument_OnTypeFormattingResult &&other
        );
        TextDocument_OnTypeFormattingResult(
            const TextDocument_OnTypeFormattingResult &other
        );
        ~TextDocument_OnTypeFormattingResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_OnTypeFormattingResult &&other
        ) -> TextDocument_OnTypeFormattingResult &;

        auto operator=(
            const TextDocument_OnTypeFormattingResult &other
        ) -> TextDocument_OnTypeFormattingResult &;

        auto type() const -> const TextDocument_OnTypeFormattingResultType &;

        auto textEditArray() const -> const std::vector<TextEdit> &;

        auto operator=(
            const std::unique_ptr<std::vector<TextEdit>> &textEditArray
        ) -> TextDocument_OnTypeFormattingResult &;

        auto operator=(
            std::unique_ptr<std::vector<TextEdit>> &&textEditArray
        ) -> TextDocument_OnTypeFormattingResult &;

        auto operator=(
            const std::vector<TextEdit> &textEditArray
        ) -> TextDocument_OnTypeFormattingResult &;

        auto operator=(
            std::vector<TextEdit> &&textEditArray
        ) -> TextDocument_OnTypeFormattingResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_OnTypeFormattingResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_OnTypeFormattingResultType _type{
            TextDocument_OnTypeFormattingResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<TextEdit>> _textEditArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_OnTypeFormattingResult

    typedef std::vector<TextEdit> TextDocument_OnTypeFormattingResult_0;

    enum class TextDocument_PrepareRenameResultType {
        Uninitialized = -1,
        PrepareRenameResult = 0,
        Null = 1,
    }; // enum class TextDocument_PrepareRenameResultType

    extern const std::map<TextDocument_PrepareRenameResultType, std::string>
        TextDocument_PrepareRenameResultTypeNames;

    class TextDocument_PrepareRenameResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_PrepareRenameResult();
        TextDocument_PrepareRenameResult(
            TextDocument_PrepareRenameResult &&other
        );
        TextDocument_PrepareRenameResult(
            const TextDocument_PrepareRenameResult &other
        );
        ~TextDocument_PrepareRenameResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_PrepareRenameResult &&other
        ) -> TextDocument_PrepareRenameResult &;

        auto operator=(
            const TextDocument_PrepareRenameResult &other
        ) -> TextDocument_PrepareRenameResult &;

        auto type() const -> const TextDocument_PrepareRenameResultType &;

        auto prepareRenameResult() const -> const PrepareRenameResult &;

        auto operator=(
            const std::unique_ptr<PrepareRenameResult> &prepareRenameResult
        ) -> TextDocument_PrepareRenameResult &;

        auto operator=(
            std::unique_ptr<PrepareRenameResult> &&prepareRenameResult
        ) -> TextDocument_PrepareRenameResult &;

        auto operator=(
            const PrepareRenameResult &prepareRenameResult
        ) -> TextDocument_PrepareRenameResult &;

        auto operator=(
            PrepareRenameResult &&prepareRenameResult
        ) -> TextDocument_PrepareRenameResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_PrepareRenameResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_PrepareRenameResultType _type{
            TextDocument_PrepareRenameResultType::Uninitialized
        };

        union {
            std::unique_ptr<PrepareRenameResult> _prepareRenameResult;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_PrepareRenameResult

    typedef ApplyWorkspaceEditResult Workspace_ApplyEditResult;

    struct InitializedParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InitializedParams();
        InitializedParams(InitializedParams &&other);
        InitializedParams(const InitializedParams &other);
        ~InitializedParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InitializedParams &&other) -> InitializedParams &;

        auto operator=(const InitializedParams &other) -> InitializedParams &;
    }; // struct InitializedParams

    typedef int integer_t;

    enum class CancelParams_idType {
        Uninitialized = -1,
        Integer = 0,
        String = 1,
    }; // enum class CancelParams_idType

    extern const std::map<CancelParams_idType, std::string>
        CancelParams_idTypeNames;

    class CancelParams_id {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CancelParams_id();
        CancelParams_id(CancelParams_id &&other);
        CancelParams_id(const CancelParams_id &other);
        ~CancelParams_id();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CancelParams_id &&other) -> CancelParams_id &;

        auto operator=(const CancelParams_id &other) -> CancelParams_id &;

        auto type() const -> const CancelParams_idType &;

        auto integer() const -> const integer_t &;

        auto operator=(integer_t integer) -> CancelParams_id &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> CancelParams_id &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> CancelParams_id &;

        auto operator=(const string_t &string) -> CancelParams_id &;

        auto operator=(string_t &&string) -> CancelParams_id &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        CancelParams_idType _type{CancelParams_idType::Uninitialized};

        union {
            integer_t _integer;
            std::unique_ptr<string_t> _string;
        };

        auto reset() -> void;
    }; // class CancelParams_id

    struct CancelParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CancelParams();
        CancelParams(CancelParams &&other);
        CancelParams(const CancelParams &other);
        ~CancelParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CancelParams &&other) -> CancelParams &;

        auto operator=(const CancelParams &other) -> CancelParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The request id to cancel.
         */
        CancelParams_id id;
    }; // struct CancelParams

    /**
     * @since 3.17.0
     */
    struct InlineValueContext {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineValueContext();
        InlineValueContext(InlineValueContext &&other);
        InlineValueContext(const InlineValueContext &other);
        ~InlineValueContext();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlineValueContext &&other) -> InlineValueContext &;

        auto operator=(
            const InlineValueContext &other
        ) -> InlineValueContext &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The stack frame (as a DAP Id) where the execution has stopped.
         */
        integer_t frameId;
        /**
         * The document range where execution has stopped.
         * Typically the end position of the range denotes the line where the inline values are shown.
         */
        Range stoppedLocation;
    }; // struct InlineValueContext

    /**
     * An item to transfer a text document from the client to the
     * server.
     */
    struct TextDocumentItem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentItem();
        TextDocumentItem(TextDocumentItem &&other);
        TextDocumentItem(const TextDocumentItem &other);
        ~TextDocumentItem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(TextDocumentItem &&other) -> TextDocumentItem &;

        auto operator=(const TextDocumentItem &other) -> TextDocumentItem &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The text document's uri.
         */
        DocumentUri uri;
        /**
         * The text document's language identifier.
         */
        string_t languageId;
        /**
         * The version number of this document (it will increase after each
         * change, including undo/redo).
         */
        integer_t version;
        /**
         * The content of the opened text document.
         */
        string_t text;
    }; // struct TextDocumentItem

    typedef std::vector<TextDocumentItem> DidOpenNotebookDocumentParams_cellTextDocuments;

    /**
     * The parameters sent in an open text document notification
     */
    struct DidOpenTextDocumentParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidOpenTextDocumentParams();
        DidOpenTextDocumentParams(DidOpenTextDocumentParams &&other);
        DidOpenTextDocumentParams(const DidOpenTextDocumentParams &other);
        ~DidOpenTextDocumentParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidOpenTextDocumentParams &&other
        ) -> DidOpenTextDocumentParams &;

        auto operator=(
            const DidOpenTextDocumentParams &other
        ) -> DidOpenTextDocumentParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The document that was opened.
         */
        TextDocumentItem textDocument;
    }; // struct DidOpenTextDocumentParams

    /**
     * A versioned notebook document identifier.
     *
     * @since 3.17.0
     */
    struct VersionedNotebookDocumentIdentifier {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        VersionedNotebookDocumentIdentifier();
        VersionedNotebookDocumentIdentifier(
            VersionedNotebookDocumentIdentifier &&other
        );
        VersionedNotebookDocumentIdentifier(
            const VersionedNotebookDocumentIdentifier &other
        );
        ~VersionedNotebookDocumentIdentifier();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            VersionedNotebookDocumentIdentifier &&other
        ) -> VersionedNotebookDocumentIdentifier &;

        auto operator=(
            const VersionedNotebookDocumentIdentifier &other
        ) -> VersionedNotebookDocumentIdentifier &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The version number of this notebook document.
         */
        integer_t version;
        /**
         * The notebook document's uri.
         */
        URI uri;
    }; // struct VersionedNotebookDocumentIdentifier

    typedef std::vector<TextDocumentItem> NotebookDocumentChangeEvent_cells_structure_didOpen;

    enum class _InitializeParams_processIdType {
        Uninitialized = -1,
        Integer = 0,
        Null = 1,
    }; // enum class _InitializeParams_processIdType

    extern const std::map<_InitializeParams_processIdType, std::string>
        _InitializeParams_processIdTypeNames;

    class _InitializeParams_processId {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        _InitializeParams_processId();
        _InitializeParams_processId(_InitializeParams_processId &&other);
        _InitializeParams_processId(const _InitializeParams_processId &other);
        ~_InitializeParams_processId();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            _InitializeParams_processId &&other
        ) -> _InitializeParams_processId &;

        auto operator=(
            const _InitializeParams_processId &other
        ) -> _InitializeParams_processId &;

        auto type() const -> const _InitializeParams_processIdType &;

        auto integer() const -> const integer_t &;

        auto operator=(integer_t integer) -> _InitializeParams_processId &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> _InitializeParams_processId &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        _InitializeParams_processIdType _type{
            _InitializeParams_processIdType::Uninitialized
        };

        union {
            integer_t _integer;
            null_t _null;
        };
    }; // class _InitializeParams_processId

    /**
     * A text document identifier to denote a specific version of a text document.
     */
    struct VersionedTextDocumentIdentifier
        : public TextDocumentIdentifier
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        VersionedTextDocumentIdentifier();
        VersionedTextDocumentIdentifier(
            VersionedTextDocumentIdentifier &&other
        );
        VersionedTextDocumentIdentifier(
            const VersionedTextDocumentIdentifier &other
        );
        ~VersionedTextDocumentIdentifier();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            VersionedTextDocumentIdentifier &&other
        ) -> VersionedTextDocumentIdentifier &;

        auto operator=(
            const VersionedTextDocumentIdentifier &other
        ) -> VersionedTextDocumentIdentifier &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The version number of this document.
         */
        integer_t version;
    }; // struct VersionedTextDocumentIdentifier

    /**
     * The change text document notification's parameters.
     */
    struct DidChangeTextDocumentParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidChangeTextDocumentParams();
        DidChangeTextDocumentParams(DidChangeTextDocumentParams &&other);
        DidChangeTextDocumentParams(const DidChangeTextDocumentParams &other);
        ~DidChangeTextDocumentParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidChangeTextDocumentParams &&other
        ) -> DidChangeTextDocumentParams &;

        auto operator=(
            const DidChangeTextDocumentParams &other
        ) -> DidChangeTextDocumentParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The document that did change. The version number points
         * to the version after all provided content changes have
         * been applied.
         */
        VersionedTextDocumentIdentifier textDocument;
        /**
         * The actual content changes. The content changes describe single state changes
         * to the document. So if there are two content changes c1 (at array index 0) and
         * c2 (at array index 1) for a document in state S then c1 moves the document from
         * S to S' and c2 from S' to S''. So c1 is computed on the state S and c2 is computed
         * on the state S'.
         *
         * To mirror the content of a document using change events use the following approach:
         * - start with the same initial content
         * - apply the 'textDocument/didChange' notifications in the order you receive them.
         * - apply the `TextDocumentContentChangeEvent`s in a single notification in the order
         *   you receive them.
         */
        std::vector<TextDocumentContentChangeEvent> contentChanges;
    }; // struct DidChangeTextDocumentParams

    struct NotebookDocumentChangeEvent_cells_textContent_elem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentChangeEvent_cells_textContent_elem();
        NotebookDocumentChangeEvent_cells_textContent_elem(
            NotebookDocumentChangeEvent_cells_textContent_elem &&other
        );
        NotebookDocumentChangeEvent_cells_textContent_elem(
            const NotebookDocumentChangeEvent_cells_textContent_elem &other
        );
        ~NotebookDocumentChangeEvent_cells_textContent_elem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentChangeEvent_cells_textContent_elem &&other
        ) -> NotebookDocumentChangeEvent_cells_textContent_elem &;

        auto operator=(
            const NotebookDocumentChangeEvent_cells_textContent_elem &other
        ) -> NotebookDocumentChangeEvent_cells_textContent_elem &;

        // ================== //
        // Field Declarations //
        // ================== //

        VersionedTextDocumentIdentifier document;
        std::vector<TextDocumentContentChangeEvent> changes;
    }; // struct NotebookDocumentChangeEvent_cells_textContent_elem

    typedef std::vector<NotebookDocumentChangeEvent_cells_textContent_elem> NotebookDocumentChangeEvent_cells_textContent;

    enum class Diagnostic_codeType {
        Uninitialized = -1,
        Integer = 0,
        String = 1,
    }; // enum class Diagnostic_codeType

    extern const std::map<Diagnostic_codeType, std::string>
        Diagnostic_codeTypeNames;

    class Diagnostic_code {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Diagnostic_code();
        Diagnostic_code(Diagnostic_code &&other);
        Diagnostic_code(const Diagnostic_code &other);
        ~Diagnostic_code();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Diagnostic_code &&other) -> Diagnostic_code &;

        auto operator=(const Diagnostic_code &other) -> Diagnostic_code &;

        auto type() const -> const Diagnostic_codeType &;

        auto integer() const -> const integer_t &;

        auto operator=(integer_t integer) -> Diagnostic_code &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> Diagnostic_code &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> Diagnostic_code &;

        auto operator=(const string_t &string) -> Diagnostic_code &;

        auto operator=(string_t &&string) -> Diagnostic_code &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        Diagnostic_codeType _type{Diagnostic_codeType::Uninitialized};

        union {
            integer_t _integer;
            std::unique_ptr<string_t> _string;
        };

        auto reset() -> void;
    }; // class Diagnostic_code

    enum class OptionalVersionedTextDocumentIdentifier_versionType {
        Uninitialized = -1,
        Integer = 0,
        Null = 1,
    }; // enum class OptionalVersionedTextDocumentIdentifier_versionType

    extern const std::map<
        OptionalVersionedTextDocumentIdentifier_versionType,
        std::string
    > OptionalVersionedTextDocumentIdentifier_versionTypeNames;

    class OptionalVersionedTextDocumentIdentifier_version {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        OptionalVersionedTextDocumentIdentifier_version();
        OptionalVersionedTextDocumentIdentifier_version(
            OptionalVersionedTextDocumentIdentifier_version &&other
        );
        OptionalVersionedTextDocumentIdentifier_version(
            const OptionalVersionedTextDocumentIdentifier_version &other
        );
        ~OptionalVersionedTextDocumentIdentifier_version();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            OptionalVersionedTextDocumentIdentifier_version &&other
        ) -> OptionalVersionedTextDocumentIdentifier_version &;

        auto operator=(
            const OptionalVersionedTextDocumentIdentifier_version &other
        ) -> OptionalVersionedTextDocumentIdentifier_version &;

        auto type() const
        -> const OptionalVersionedTextDocumentIdentifier_versionType &;

        auto integer() const -> const integer_t &;

        auto operator=(
            integer_t integer
        ) -> OptionalVersionedTextDocumentIdentifier_version &;

        auto null() const -> const null_t &;

        auto operator=(
            null_t null
        ) -> OptionalVersionedTextDocumentIdentifier_version &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        OptionalVersionedTextDocumentIdentifier_versionType _type{
            OptionalVersionedTextDocumentIdentifier_versionType::Uninitialized
        };

        union {
            integer_t _integer;
            null_t _null;
        };
    }; // class OptionalVersionedTextDocumentIdentifier_version

    /**
     * A text document identifier to optionally denote a specific version of a text document.
     */
    struct OptionalVersionedTextDocumentIdentifier
        : public TextDocumentIdentifier
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        OptionalVersionedTextDocumentIdentifier();
        OptionalVersionedTextDocumentIdentifier(
            OptionalVersionedTextDocumentIdentifier &&other
        );
        OptionalVersionedTextDocumentIdentifier(
            const OptionalVersionedTextDocumentIdentifier &other
        );
        ~OptionalVersionedTextDocumentIdentifier();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            OptionalVersionedTextDocumentIdentifier &&other
        ) -> OptionalVersionedTextDocumentIdentifier &;

        auto operator=(
            const OptionalVersionedTextDocumentIdentifier &other
        ) -> OptionalVersionedTextDocumentIdentifier &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The version number of this document. If a versioned text document identifier
         * is sent from the server to the client and the file is not open in the editor
         * (the server has not received an open notification before) the server can send
         * `null` to indicate that the version is unknown and the content on disk is the
         * truth (as specified with document content ownership).
         */
        OptionalVersionedTextDocumentIdentifier_version version;
    }; // struct OptionalVersionedTextDocumentIdentifier

    /**
     * Describes textual changes on a text document. A TextDocumentEdit describes all changes
     * on a document version Si and after they are applied move the document to version Si+1.
     * So the creator of a TextDocumentEdit doesn't need to sort the array of edits or do any
     * kind of ordering. However the edits must be non overlapping.
     */
    struct TextDocumentEdit {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentEdit();
        TextDocumentEdit(TextDocumentEdit &&other);
        TextDocumentEdit(const TextDocumentEdit &other);
        ~TextDocumentEdit();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(TextDocumentEdit &&other) -> TextDocumentEdit &;

        auto operator=(const TextDocumentEdit &other) -> TextDocumentEdit &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The text document to change.
         */
        OptionalVersionedTextDocumentIdentifier textDocument;
        /**
         * The edits to be applied.
         *
         * @since 3.16.0 - support for AnnotatedTextEdit. This is guarded using a
         * client capability.
         */
        std::vector<TextDocumentEdit_edits_elem> edits;
    }; // struct TextDocumentEdit

    enum class WorkspaceEdit_documentChanges_elemType {
        Uninitialized = -1,
        TextDocumentEdit = 0,
        CreateFile = 1,
        RenameFile = 2,
        DeleteFile = 3,
    }; // enum class WorkspaceEdit_documentChanges_elemType

    extern const std::map<WorkspaceEdit_documentChanges_elemType, std::string>
        WorkspaceEdit_documentChanges_elemTypeNames;

    class WorkspaceEdit_documentChanges_elem {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceEdit_documentChanges_elem();
        WorkspaceEdit_documentChanges_elem(
            WorkspaceEdit_documentChanges_elem &&other
        );
        WorkspaceEdit_documentChanges_elem(
            const WorkspaceEdit_documentChanges_elem &other
        );
        ~WorkspaceEdit_documentChanges_elem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceEdit_documentChanges_elem &&other
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            const WorkspaceEdit_documentChanges_elem &other
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto type() const -> const WorkspaceEdit_documentChanges_elemType &;

        auto textDocumentEdit() const -> const TextDocumentEdit &;

        auto operator=(
            const std::unique_ptr<TextDocumentEdit> &textDocumentEdit
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            std::unique_ptr<TextDocumentEdit> &&textDocumentEdit
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            const TextDocumentEdit &textDocumentEdit
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            TextDocumentEdit &&textDocumentEdit
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto createFile() const -> const CreateFile &;

        auto operator=(
            const std::unique_ptr<CreateFile> &createFile
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            std::unique_ptr<CreateFile> &&createFile
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            const CreateFile &createFile
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            CreateFile &&createFile
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto renameFile() const -> const RenameFile &;

        auto operator=(
            const std::unique_ptr<RenameFile> &renameFile
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            std::unique_ptr<RenameFile> &&renameFile
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            const RenameFile &renameFile
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            RenameFile &&renameFile
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto deleteFile() const -> const DeleteFile &;

        auto operator=(
            const std::unique_ptr<DeleteFile> &deleteFile
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            std::unique_ptr<DeleteFile> &&deleteFile
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            const DeleteFile &deleteFile
        ) -> WorkspaceEdit_documentChanges_elem &;

        auto operator=(
            DeleteFile &&deleteFile
        ) -> WorkspaceEdit_documentChanges_elem &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        WorkspaceEdit_documentChanges_elemType _type{
            WorkspaceEdit_documentChanges_elemType::Uninitialized
        };

        union {
            std::unique_ptr<TextDocumentEdit> _textDocumentEdit;
            std::unique_ptr<CreateFile> _createFile;
            std::unique_ptr<RenameFile> _renameFile;
            std::unique_ptr<DeleteFile> _deleteFile;
        };

        auto reset() -> void;
    }; // class WorkspaceEdit_documentChanges_elem

    /**
     * A workspace edit represents changes to many resources managed in the workspace. The edit
     * should either provide `changes` or `documentChanges`. If documentChanges are present
     * they are preferred over `changes` if the client can handle versioned document edits.
     *
     * Since version 3.13.0 a workspace edit can contain resource operations as well. If resource
     * operations are present clients need to execute the operations in the order in which they
     * are provided. So a workspace edit for example can consist of the following two changes:
     * (1) a create file a.txt and (2) a text document edit which insert text into file a.txt.
     *
     * An invalid sequence (e.g. (1) delete file a.txt and (2) insert text into file a.txt) will
     * cause failure of the operation. How the client recovers from the failure is described by
     * the client capability: `workspace.workspaceEdit.failureHandling`
     */
    struct WorkspaceEdit {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceEdit();
        WorkspaceEdit(WorkspaceEdit &&other);
        WorkspaceEdit(const WorkspaceEdit &other);
        ~WorkspaceEdit();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(WorkspaceEdit &&other) -> WorkspaceEdit &;

        auto operator=(const WorkspaceEdit &other) -> WorkspaceEdit &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Holds changes to existing resources.
         */
        std::optional<std::map<DocumentUri, std::vector<TextEdit>>> changes;
        /**
         * Depending on the client capability `workspace.workspaceEdit.resourceOperations` document changes
         * are either an array of `TextDocumentEdit`s to express changes to n different text documents
         * where each text document edit addresses a specific version of a text document. Or it can contain
         * above `TextDocumentEdit`s mixed with create, rename and delete file / folder operations.
         *
         * Whether a client supports versioned document edits is expressed via
         * `workspace.workspaceEdit.documentChanges` client capability.
         *
         * If a client neither supports `documentChanges` nor `workspace.workspaceEdit.resourceOperations` then
         * only plain `TextEdit`s using the `changes` property are supported.
         */
        std::optional<std::vector<WorkspaceEdit_documentChanges_elem>>
            documentChanges;
        /**
         * A map of change annotations that can be referenced in `AnnotatedTextEdit`s or create, rename and
         * delete file / folder operations.
         *
         * Whether clients honor this property depends on the client capability `workspace.changeAnnotationSupport`.
         *
         * @since 3.16.0
         */
        std::optional<std::map<string_t, ChangeAnnotation>> changeAnnotations;
    }; // struct WorkspaceEdit

    typedef std::vector<WorkspaceEdit_documentChanges_elem> WorkspaceEdit_documentChanges;

    /**
     * The parameters passed via an apply workspace edit request.
     */
    struct ApplyWorkspaceEditParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ApplyWorkspaceEditParams();
        ApplyWorkspaceEditParams(ApplyWorkspaceEditParams &&other);
        ApplyWorkspaceEditParams(const ApplyWorkspaceEditParams &other);
        ~ApplyWorkspaceEditParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ApplyWorkspaceEditParams &&other
        ) -> ApplyWorkspaceEditParams &;

        auto operator=(
            const ApplyWorkspaceEditParams &other
        ) -> ApplyWorkspaceEditParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional label of the workspace edit. This label is
         * presented in the user interface for example on an undo
         * stack to undo the workspace edit.
         */
        std::optional<string_t> label;
        /**
         * The edits to apply.
         */
        WorkspaceEdit edit;
    }; // struct ApplyWorkspaceEditParams

    enum class WorkspaceFullDocumentDiagnosticReport_versionType {
        Uninitialized = -1,
        Integer = 0,
        Null = 1,
    }; // enum class WorkspaceFullDocumentDiagnosticReport_versionType

    extern const std::map<
        WorkspaceFullDocumentDiagnosticReport_versionType,
        std::string
    > WorkspaceFullDocumentDiagnosticReport_versionTypeNames;

    class WorkspaceFullDocumentDiagnosticReport_version {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceFullDocumentDiagnosticReport_version();
        WorkspaceFullDocumentDiagnosticReport_version(
            WorkspaceFullDocumentDiagnosticReport_version &&other
        );
        WorkspaceFullDocumentDiagnosticReport_version(
            const WorkspaceFullDocumentDiagnosticReport_version &other
        );
        ~WorkspaceFullDocumentDiagnosticReport_version();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceFullDocumentDiagnosticReport_version &&other
        ) -> WorkspaceFullDocumentDiagnosticReport_version &;

        auto operator=(
            const WorkspaceFullDocumentDiagnosticReport_version &other
        ) -> WorkspaceFullDocumentDiagnosticReport_version &;

        auto type() const
        -> const WorkspaceFullDocumentDiagnosticReport_versionType &;

        auto integer() const -> const integer_t &;

        auto operator=(
            integer_t integer
        ) -> WorkspaceFullDocumentDiagnosticReport_version &;

        auto null() const -> const null_t &;

        auto operator=(
            null_t null
        ) -> WorkspaceFullDocumentDiagnosticReport_version &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        WorkspaceFullDocumentDiagnosticReport_versionType _type{
            WorkspaceFullDocumentDiagnosticReport_versionType::Uninitialized
        };

        union {
            integer_t _integer;
            null_t _null;
        };
    }; // class WorkspaceFullDocumentDiagnosticReport_version

    enum class WorkspaceUnchangedDocumentDiagnosticReport_versionType {
        Uninitialized = -1,
        Integer = 0,
        Null = 1,
    }; // enum class WorkspaceUnchangedDocumentDiagnosticReport_versionType

    extern const std::map<
        WorkspaceUnchangedDocumentDiagnosticReport_versionType,
        std::string
    > WorkspaceUnchangedDocumentDiagnosticReport_versionTypeNames;

    class WorkspaceUnchangedDocumentDiagnosticReport_version {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceUnchangedDocumentDiagnosticReport_version();
        WorkspaceUnchangedDocumentDiagnosticReport_version(
            WorkspaceUnchangedDocumentDiagnosticReport_version &&other
        );
        WorkspaceUnchangedDocumentDiagnosticReport_version(
            const WorkspaceUnchangedDocumentDiagnosticReport_version &other
        );
        ~WorkspaceUnchangedDocumentDiagnosticReport_version();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceUnchangedDocumentDiagnosticReport_version &&other
        ) -> WorkspaceUnchangedDocumentDiagnosticReport_version &;

        auto operator=(
            const WorkspaceUnchangedDocumentDiagnosticReport_version &other
        ) -> WorkspaceUnchangedDocumentDiagnosticReport_version &;

        auto type() const
        -> const WorkspaceUnchangedDocumentDiagnosticReport_versionType &;

        auto integer() const -> const integer_t &;

        auto operator=(
            integer_t integer
        ) -> WorkspaceUnchangedDocumentDiagnosticReport_version &;

        auto null() const -> const null_t &;

        auto operator=(
            null_t null
        ) -> WorkspaceUnchangedDocumentDiagnosticReport_version &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        WorkspaceUnchangedDocumentDiagnosticReport_versionType _type{
            WorkspaceUnchangedDocumentDiagnosticReport_versionType::Uninitialized
        };

        union {
            integer_t _integer;
            null_t _null;
        };
    }; // class WorkspaceUnchangedDocumentDiagnosticReport_version

    /**
     * An unchanged document diagnostic report for a workspace diagnostic result.
     *
     * @since 3.17.0
     */
    struct WorkspaceUnchangedDocumentDiagnosticReport
        : public UnchangedDocumentDiagnosticReport
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceUnchangedDocumentDiagnosticReport();
        WorkspaceUnchangedDocumentDiagnosticReport(
            WorkspaceUnchangedDocumentDiagnosticReport &&other
        );
        WorkspaceUnchangedDocumentDiagnosticReport(
            const WorkspaceUnchangedDocumentDiagnosticReport &other
        );
        ~WorkspaceUnchangedDocumentDiagnosticReport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceUnchangedDocumentDiagnosticReport &&other
        ) -> WorkspaceUnchangedDocumentDiagnosticReport &;

        auto operator=(
            const WorkspaceUnchangedDocumentDiagnosticReport &other
        ) -> WorkspaceUnchangedDocumentDiagnosticReport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The URI for which diagnostic information is reported.
         */
        DocumentUri uri;
        /**
         * The version number for which the diagnostics are reported.
         * If the document is not marked as open `null` can be provided.
         */
        WorkspaceUnchangedDocumentDiagnosticReport_version version;
    }; // struct WorkspaceUnchangedDocumentDiagnosticReport

    enum class ProgressTokenType {
        Uninitialized = -1,
        Integer = 0,
        String = 1,
    }; // enum class ProgressTokenType

    extern const std::map<ProgressTokenType, std::string>
        ProgressTokenTypeNames;

    class ProgressToken {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ProgressToken();
        ProgressToken(ProgressToken &&other);
        ProgressToken(const ProgressToken &other);
        ~ProgressToken();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ProgressToken &&other) -> ProgressToken &;

        auto operator=(const ProgressToken &other) -> ProgressToken &;

        auto type() const -> const ProgressTokenType &;

        auto integer() const -> const integer_t &;

        auto operator=(integer_t integer) -> ProgressToken &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> ProgressToken &;

        auto operator=(std::unique_ptr<string_t> &&string) -> ProgressToken &;

        auto operator=(const string_t &string) -> ProgressToken &;

        auto operator=(string_t &&string) -> ProgressToken &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ProgressTokenType _type{ProgressTokenType::Uninitialized};

        union {
            integer_t _integer;
            std::unique_ptr<string_t> _string;
        };

        auto reset() -> void;
    }; // class ProgressToken

    struct WorkDoneProgressCreateParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkDoneProgressCreateParams();
        WorkDoneProgressCreateParams(WorkDoneProgressCreateParams &&other);
        WorkDoneProgressCreateParams(
            const WorkDoneProgressCreateParams &other
        );
        ~WorkDoneProgressCreateParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkDoneProgressCreateParams &&other
        ) -> WorkDoneProgressCreateParams &;

        auto operator=(
            const WorkDoneProgressCreateParams &other
        ) -> WorkDoneProgressCreateParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The token to be used to report progress.
         */
        ProgressToken token;
    }; // struct WorkDoneProgressCreateParams

    struct WorkDoneProgressCancelParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkDoneProgressCancelParams();
        WorkDoneProgressCancelParams(WorkDoneProgressCancelParams &&other);
        WorkDoneProgressCancelParams(
            const WorkDoneProgressCancelParams &other
        );
        ~WorkDoneProgressCancelParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkDoneProgressCancelParams &&other
        ) -> WorkDoneProgressCancelParams &;

        auto operator=(
            const WorkDoneProgressCancelParams &other
        ) -> WorkDoneProgressCancelParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The token to be used to report progress.
         */
        ProgressToken token;
    }; // struct WorkDoneProgressCancelParams

    struct WorkDoneProgressParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkDoneProgressParams();
        WorkDoneProgressParams(WorkDoneProgressParams &&other);
        WorkDoneProgressParams(const WorkDoneProgressParams &other);
        ~WorkDoneProgressParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkDoneProgressParams &&other
        ) -> WorkDoneProgressParams &;

        auto operator=(
            const WorkDoneProgressParams &other
        ) -> WorkDoneProgressParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct WorkDoneProgressParams

    /**
     * The parameter of a `textDocument/prepareCallHierarchy` request.
     *
     * @since 3.16.0
     */
    struct CallHierarchyPrepareParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CallHierarchyPrepareParams();
        CallHierarchyPrepareParams(CallHierarchyPrepareParams &&other);
        CallHierarchyPrepareParams(const CallHierarchyPrepareParams &other);
        ~CallHierarchyPrepareParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CallHierarchyPrepareParams &&other
        ) -> CallHierarchyPrepareParams &;

        auto operator=(
            const CallHierarchyPrepareParams &other
        ) -> CallHierarchyPrepareParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct CallHierarchyPrepareParams

    struct LinkedEditingRangeParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        LinkedEditingRangeParams();
        LinkedEditingRangeParams(LinkedEditingRangeParams &&other);
        LinkedEditingRangeParams(const LinkedEditingRangeParams &other);
        ~LinkedEditingRangeParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            LinkedEditingRangeParams &&other
        ) -> LinkedEditingRangeParams &;

        auto operator=(
            const LinkedEditingRangeParams &other
        ) -> LinkedEditingRangeParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct LinkedEditingRangeParams

    /**
     * The parameter of a `textDocument/prepareTypeHierarchy` request.
     *
     * @since 3.17.0
     */
    struct TypeHierarchyPrepareParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeHierarchyPrepareParams();
        TypeHierarchyPrepareParams(TypeHierarchyPrepareParams &&other);
        TypeHierarchyPrepareParams(const TypeHierarchyPrepareParams &other);
        ~TypeHierarchyPrepareParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TypeHierarchyPrepareParams &&other
        ) -> TypeHierarchyPrepareParams &;

        auto operator=(
            const TypeHierarchyPrepareParams &other
        ) -> TypeHierarchyPrepareParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct TypeHierarchyPrepareParams

    /**
     * A parameter literal used in inline value requests.
     *
     * @since 3.17.0
     */
    struct InlineValueParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineValueParams();
        InlineValueParams(InlineValueParams &&other);
        InlineValueParams(const InlineValueParams &other);
        ~InlineValueParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlineValueParams &&other) -> InlineValueParams &;

        auto operator=(const InlineValueParams &other) -> InlineValueParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The document range for which inline values should be computed.
         */
        Range range;
        /**
         * Additional information about the context in which inline values were
         * requested.
         */
        InlineValueContext context;
    }; // struct InlineValueParams

    /**
     * A parameter literal used in inlay hint requests.
     *
     * @since 3.17.0
     */
    struct InlayHintParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlayHintParams();
        InlayHintParams(InlayHintParams &&other);
        InlayHintParams(const InlayHintParams &other);
        ~InlayHintParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlayHintParams &&other) -> InlayHintParams &;

        auto operator=(const InlayHintParams &other) -> InlayHintParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The document range for which inlay hints should be computed.
         */
        Range range;
    }; // struct InlayHintParams

    /**
     * A parameter literal used in inline completion requests.
     *
     * @since 3.18.0
     * @proposed
     */
    struct InlineCompletionParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineCompletionParams();
        InlineCompletionParams(InlineCompletionParams &&other);
        InlineCompletionParams(const InlineCompletionParams &other);
        ~InlineCompletionParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            InlineCompletionParams &&other
        ) -> InlineCompletionParams &;

        auto operator=(
            const InlineCompletionParams &other
        ) -> InlineCompletionParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * Additional information about the context in which inline completions were
         * requested.
         */
        InlineCompletionContext context;
    }; // struct InlineCompletionParams

    /**
     * Parameters for a {@link HoverRequest}.
     */
    struct HoverParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        HoverParams();
        HoverParams(HoverParams &&other);
        HoverParams(const HoverParams &other);
        ~HoverParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(HoverParams &&other) -> HoverParams &;

        auto operator=(const HoverParams &other) -> HoverParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct HoverParams

    /**
     * Parameters for a {@link SignatureHelpRequest}.
     */
    struct SignatureHelpParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SignatureHelpParams();
        SignatureHelpParams(SignatureHelpParams &&other);
        SignatureHelpParams(const SignatureHelpParams &other);
        ~SignatureHelpParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SignatureHelpParams &&other) -> SignatureHelpParams &;

        auto operator=(
            const SignatureHelpParams &other
        ) -> SignatureHelpParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The signature help context. This is only available if the client specifies
         * to send this using the client capability `textDocument.signatureHelp.contextSupport === true`
         *
         * @since 3.15.0
         */
        std::optional<SignatureHelpContext> context;
    }; // struct SignatureHelpParams

    /**
     * The parameters of a {@link DocumentFormattingRequest}.
     */
    struct DocumentFormattingParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentFormattingParams();
        DocumentFormattingParams(DocumentFormattingParams &&other);
        DocumentFormattingParams(const DocumentFormattingParams &other);
        ~DocumentFormattingParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentFormattingParams &&other
        ) -> DocumentFormattingParams &;

        auto operator=(
            const DocumentFormattingParams &other
        ) -> DocumentFormattingParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The document to format.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The format options.
         */
        FormattingOptions options;
    }; // struct DocumentFormattingParams

    /**
     * The parameters of a {@link DocumentRangeFormattingRequest}.
     */
    struct DocumentRangeFormattingParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentRangeFormattingParams();
        DocumentRangeFormattingParams(DocumentRangeFormattingParams &&other);
        DocumentRangeFormattingParams(
            const DocumentRangeFormattingParams &other
        );
        ~DocumentRangeFormattingParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentRangeFormattingParams &&other
        ) -> DocumentRangeFormattingParams &;

        auto operator=(
            const DocumentRangeFormattingParams &other
        ) -> DocumentRangeFormattingParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The document to format.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The range to format
         */
        Range range;
        /**
         * The format options
         */
        FormattingOptions options;
    }; // struct DocumentRangeFormattingParams

    /**
     * The parameters of a {@link DocumentRangesFormattingRequest}.
     *
     * @since 3.18.0
     * @proposed
     */
    struct DocumentRangesFormattingParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentRangesFormattingParams();
        DocumentRangesFormattingParams(DocumentRangesFormattingParams &&other);
        DocumentRangesFormattingParams(
            const DocumentRangesFormattingParams &other
        );
        ~DocumentRangesFormattingParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentRangesFormattingParams &&other
        ) -> DocumentRangesFormattingParams &;

        auto operator=(
            const DocumentRangesFormattingParams &other
        ) -> DocumentRangesFormattingParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The document to format.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The ranges to format
         */
        std::vector<Range> ranges;
        /**
         * The format options
         */
        FormattingOptions options;
    }; // struct DocumentRangesFormattingParams

    /**
     * The parameters of a {@link RenameRequest}.
     */
    struct RenameParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RenameParams();
        RenameParams(RenameParams &&other);
        RenameParams(const RenameParams &other);
        ~RenameParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(RenameParams &&other) -> RenameParams &;

        auto operator=(const RenameParams &other) -> RenameParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The document to rename.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The position at which this request was sent.
         */
        Position position;
        /**
         * The new name of the symbol. If the given name is not valid the
         * request must return a {@link ResponseError} with an
         * appropriate message set.
         */
        string_t newName;
    }; // struct RenameParams

    struct PrepareRenameParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        PrepareRenameParams();
        PrepareRenameParams(PrepareRenameParams &&other);
        PrepareRenameParams(const PrepareRenameParams &other);
        ~PrepareRenameParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(PrepareRenameParams &&other) -> PrepareRenameParams &;

        auto operator=(
            const PrepareRenameParams &other
        ) -> PrepareRenameParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct PrepareRenameParams

    struct PartialResultParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        PartialResultParams();
        PartialResultParams(PartialResultParams &&other);
        PartialResultParams(const PartialResultParams &other);
        ~PartialResultParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(PartialResultParams &&other) -> PartialResultParams &;

        auto operator=(
            const PartialResultParams &other
        ) -> PartialResultParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
    }; // struct PartialResultParams

    struct ImplementationParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ImplementationParams();
        ImplementationParams(ImplementationParams &&other);
        ImplementationParams(const ImplementationParams &other);
        ~ImplementationParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ImplementationParams &&other) -> ImplementationParams &;

        auto operator=(
            const ImplementationParams &other
        ) -> ImplementationParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct ImplementationParams

    struct TypeDefinitionParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeDefinitionParams();
        TypeDefinitionParams(TypeDefinitionParams &&other);
        TypeDefinitionParams(const TypeDefinitionParams &other);
        ~TypeDefinitionParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(TypeDefinitionParams &&other) -> TypeDefinitionParams &;

        auto operator=(
            const TypeDefinitionParams &other
        ) -> TypeDefinitionParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct TypeDefinitionParams

    /**
     * Parameters for a {@link DocumentColorRequest}.
     */
    struct DocumentColorParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentColorParams();
        DocumentColorParams(DocumentColorParams &&other);
        DocumentColorParams(const DocumentColorParams &other);
        ~DocumentColorParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DocumentColorParams &&other) -> DocumentColorParams &;

        auto operator=(
            const DocumentColorParams &other
        ) -> DocumentColorParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
    }; // struct DocumentColorParams

    /**
     * Parameters for a {@link FoldingRangeRequest}.
     */
    struct FoldingRangeParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FoldingRangeParams();
        FoldingRangeParams(FoldingRangeParams &&other);
        FoldingRangeParams(const FoldingRangeParams &other);
        ~FoldingRangeParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(FoldingRangeParams &&other) -> FoldingRangeParams &;

        auto operator=(
            const FoldingRangeParams &other
        ) -> FoldingRangeParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
    }; // struct FoldingRangeParams

    struct DeclarationParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DeclarationParams();
        DeclarationParams(DeclarationParams &&other);
        DeclarationParams(const DeclarationParams &other);
        ~DeclarationParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DeclarationParams &&other) -> DeclarationParams &;

        auto operator=(const DeclarationParams &other) -> DeclarationParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct DeclarationParams

    /**
     * A parameter literal used in selection range requests.
     */
    struct SelectionRangeParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SelectionRangeParams();
        SelectionRangeParams(SelectionRangeParams &&other);
        SelectionRangeParams(const SelectionRangeParams &other);
        ~SelectionRangeParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SelectionRangeParams &&other) -> SelectionRangeParams &;

        auto operator=(
            const SelectionRangeParams &other
        ) -> SelectionRangeParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The positions inside the text document.
         */
        std::vector<Position> positions;
    }; // struct SelectionRangeParams

    /**
     * @since 3.16.0
     */
    struct SemanticTokensParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensParams();
        SemanticTokensParams(SemanticTokensParams &&other);
        SemanticTokensParams(const SemanticTokensParams &other);
        ~SemanticTokensParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(SemanticTokensParams &&other) -> SemanticTokensParams &;

        auto operator=(
            const SemanticTokensParams &other
        ) -> SemanticTokensParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
    }; // struct SemanticTokensParams

    /**
     * @since 3.16.0
     */
    struct SemanticTokensDeltaParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensDeltaParams();
        SemanticTokensDeltaParams(SemanticTokensDeltaParams &&other);
        SemanticTokensDeltaParams(const SemanticTokensDeltaParams &other);
        ~SemanticTokensDeltaParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensDeltaParams &&other
        ) -> SemanticTokensDeltaParams &;

        auto operator=(
            const SemanticTokensDeltaParams &other
        ) -> SemanticTokensDeltaParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The result id of a previous response. The result Id can either point to a full response
         * or a delta response depending on what was received last.
         */
        string_t previousResultId;
    }; // struct SemanticTokensDeltaParams

    /**
     * @since 3.16.0
     */
    struct SemanticTokensRangeParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensRangeParams();
        SemanticTokensRangeParams(SemanticTokensRangeParams &&other);
        SemanticTokensRangeParams(const SemanticTokensRangeParams &other);
        ~SemanticTokensRangeParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensRangeParams &&other
        ) -> SemanticTokensRangeParams &;

        auto operator=(
            const SemanticTokensRangeParams &other
        ) -> SemanticTokensRangeParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The range the semantic tokens are requested for.
         */
        Range range;
    }; // struct SemanticTokensRangeParams

    struct MonikerParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        MonikerParams();
        MonikerParams(MonikerParams &&other);
        MonikerParams(const MonikerParams &other);
        ~MonikerParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(MonikerParams &&other) -> MonikerParams &;

        auto operator=(const MonikerParams &other) -> MonikerParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct MonikerParams

    /**
     * Parameters of the document diagnostic request.
     *
     * @since 3.17.0
     */
    struct DocumentDiagnosticParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentDiagnosticParams();
        DocumentDiagnosticParams(DocumentDiagnosticParams &&other);
        DocumentDiagnosticParams(const DocumentDiagnosticParams &other);
        ~DocumentDiagnosticParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentDiagnosticParams &&other
        ) -> DocumentDiagnosticParams &;

        auto operator=(
            const DocumentDiagnosticParams &other
        ) -> DocumentDiagnosticParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The additional identifier  provided during registration.
         */
        std::optional<string_t> identifier;
        /**
         * The result id of a previous response if provided.
         */
        std::optional<string_t> previousResultId;
    }; // struct DocumentDiagnosticParams

    /**
     * Parameters of the workspace diagnostic request.
     *
     * @since 3.17.0
     */
    struct WorkspaceDiagnosticParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceDiagnosticParams();
        WorkspaceDiagnosticParams(WorkspaceDiagnosticParams &&other);
        WorkspaceDiagnosticParams(const WorkspaceDiagnosticParams &other);
        ~WorkspaceDiagnosticParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceDiagnosticParams &&other
        ) -> WorkspaceDiagnosticParams &;

        auto operator=(
            const WorkspaceDiagnosticParams &other
        ) -> WorkspaceDiagnosticParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The additional identifier provided during registration.
         */
        std::optional<string_t> identifier;
        /**
         * The currently known diagnostic reports with their
         * previous result ids.
         */
        std::vector<PreviousResultId> previousResultIds;
    }; // struct WorkspaceDiagnosticParams

    /**
     * Completion parameters
     */
    struct CompletionParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionParams();
        CompletionParams(CompletionParams &&other);
        CompletionParams(const CompletionParams &other);
        ~CompletionParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CompletionParams &&other) -> CompletionParams &;

        auto operator=(const CompletionParams &other) -> CompletionParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The completion context. This is only available if the client specifies
         * to send this using the client capability `textDocument.completion.contextSupport === true`
         */
        std::optional<CompletionContext> context;
    }; // struct CompletionParams

    /**
     * Parameters for a {@link DefinitionRequest}.
     */
    struct DefinitionParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DefinitionParams();
        DefinitionParams(DefinitionParams &&other);
        DefinitionParams(const DefinitionParams &other);
        ~DefinitionParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DefinitionParams &&other) -> DefinitionParams &;

        auto operator=(const DefinitionParams &other) -> DefinitionParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct DefinitionParams

    /**
     * Parameters for a {@link ReferencesRequest}.
     */
    struct ReferenceParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ReferenceParams();
        ReferenceParams(ReferenceParams &&other);
        ReferenceParams(const ReferenceParams &other);
        ~ReferenceParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ReferenceParams &&other) -> ReferenceParams &;

        auto operator=(const ReferenceParams &other) -> ReferenceParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        ReferenceContext context;
    }; // struct ReferenceParams

    /**
     * Parameters for a {@link DocumentHighlightRequest}.
     */
    struct DocumentHighlightParams
        : public TextDocumentPositionParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentHighlightParams();
        DocumentHighlightParams(DocumentHighlightParams &&other);
        DocumentHighlightParams(const DocumentHighlightParams &other);
        ~DocumentHighlightParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentHighlightParams &&other
        ) -> DocumentHighlightParams &;

        auto operator=(
            const DocumentHighlightParams &other
        ) -> DocumentHighlightParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
    }; // struct DocumentHighlightParams

    /**
     * Parameters for a {@link DocumentSymbolRequest}.
     */
    struct DocumentSymbolParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentSymbolParams();
        DocumentSymbolParams(DocumentSymbolParams &&other);
        DocumentSymbolParams(const DocumentSymbolParams &other);
        ~DocumentSymbolParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DocumentSymbolParams &&other) -> DocumentSymbolParams &;

        auto operator=(
            const DocumentSymbolParams &other
        ) -> DocumentSymbolParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
    }; // struct DocumentSymbolParams

    /**
     * The parameters of a {@link WorkspaceSymbolRequest}.
     */
    struct WorkspaceSymbolParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceSymbolParams();
        WorkspaceSymbolParams(WorkspaceSymbolParams &&other);
        WorkspaceSymbolParams(const WorkspaceSymbolParams &other);
        ~WorkspaceSymbolParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceSymbolParams &&other
        ) -> WorkspaceSymbolParams &;

        auto operator=(
            const WorkspaceSymbolParams &other
        ) -> WorkspaceSymbolParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * A query string to filter symbols by. Clients may send an empty
         * string here to request all symbols.
         */
        string_t query;
    }; // struct WorkspaceSymbolParams

    /**
     * The parameters of a {@link CodeLensRequest}.
     */
    struct CodeLensParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeLensParams();
        CodeLensParams(CodeLensParams &&other);
        CodeLensParams(const CodeLensParams &other);
        ~CodeLensParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CodeLensParams &&other) -> CodeLensParams &;

        auto operator=(const CodeLensParams &other) -> CodeLensParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The document to request code lens for.
         */
        TextDocumentIdentifier textDocument;
    }; // struct CodeLensParams

    /**
     * The parameters of a {@link DocumentLinkRequest}.
     */
    struct DocumentLinkParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentLinkParams();
        DocumentLinkParams(DocumentLinkParams &&other);
        DocumentLinkParams(const DocumentLinkParams &other);
        ~DocumentLinkParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DocumentLinkParams &&other) -> DocumentLinkParams &;

        auto operator=(
            const DocumentLinkParams &other
        ) -> DocumentLinkParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The document to provide document links for.
         */
        TextDocumentIdentifier textDocument;
    }; // struct DocumentLinkParams

    enum class RequestIdType {
        Uninitialized = -1,
        Integer = 0,
        String = 1,
    }; // enum class RequestIdType

    extern const std::map<RequestIdType, std::string> RequestIdTypeNames;

    class RequestId {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RequestId();
        RequestId(RequestId &&other);
        RequestId(const RequestId &other);
        ~RequestId();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(RequestId &&other) -> RequestId &;

        auto operator=(const RequestId &other) -> RequestId &;

        auto type() const -> const RequestIdType &;

        auto integer() const -> const integer_t &;

        auto operator=(integer_t integer) -> RequestId &;

        auto string() const -> const string_t &;

        auto operator=(const std::unique_ptr<string_t> &string) -> RequestId &;

        auto operator=(std::unique_ptr<string_t> &&string) -> RequestId &;

        auto operator=(const string_t &string) -> RequestId &;

        auto operator=(string_t &&string) -> RequestId &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        RequestIdType _type{RequestIdType::Uninitialized};

        union {
            integer_t _integer;
            std::unique_ptr<string_t> _string;
        };

        auto reset() -> void;
    }; // class RequestId

    enum class ResponseIdType {
        Uninitialized = -1,
        Integer = 0,
        String = 1,
        Null = 2,
    }; // enum class ResponseIdType

    extern const std::map<ResponseIdType, std::string> ResponseIdTypeNames;

    class ResponseId {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ResponseId();
        ResponseId(ResponseId &&other);
        ResponseId(const ResponseId &other);
        ~ResponseId();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ResponseId &&other) -> ResponseId &;

        auto operator=(const ResponseId &other) -> ResponseId &;

        auto type() const -> const ResponseIdType &;

        auto integer() const -> const integer_t &;

        auto operator=(integer_t integer) -> ResponseId &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> ResponseId &;

        auto operator=(std::unique_ptr<string_t> &&string) -> ResponseId &;

        auto operator=(const string_t &string) -> ResponseId &;

        auto operator=(string_t &&string) -> ResponseId &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> ResponseId &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ResponseIdType _type{ResponseIdType::Uninitialized};

        union {
            integer_t _integer;
            std::unique_ptr<string_t> _string;
            null_t _null;
        };

        auto reset() -> void;
    }; // class ResponseId

    enum class Workspace_WillCreateFilesResultType {
        Uninitialized = -1,
        WorkspaceEdit = 0,
        Null = 1,
    }; // enum class Workspace_WillCreateFilesResultType

    extern const std::map<Workspace_WillCreateFilesResultType, std::string>
        Workspace_WillCreateFilesResultTypeNames;

    class Workspace_WillCreateFilesResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Workspace_WillCreateFilesResult();
        Workspace_WillCreateFilesResult(
            Workspace_WillCreateFilesResult &&other
        );
        Workspace_WillCreateFilesResult(
            const Workspace_WillCreateFilesResult &other
        );
        ~Workspace_WillCreateFilesResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            Workspace_WillCreateFilesResult &&other
        ) -> Workspace_WillCreateFilesResult &;

        auto operator=(
            const Workspace_WillCreateFilesResult &other
        ) -> Workspace_WillCreateFilesResult &;

        auto type() const -> const Workspace_WillCreateFilesResultType &;

        auto workspaceEdit() const -> const WorkspaceEdit &;

        auto operator=(
            const std::unique_ptr<WorkspaceEdit> &workspaceEdit
        ) -> Workspace_WillCreateFilesResult &;

        auto operator=(
            std::unique_ptr<WorkspaceEdit> &&workspaceEdit
        ) -> Workspace_WillCreateFilesResult &;

        auto operator=(
            const WorkspaceEdit &workspaceEdit
        ) -> Workspace_WillCreateFilesResult &;

        auto operator=(
            WorkspaceEdit &&workspaceEdit
        ) -> Workspace_WillCreateFilesResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> Workspace_WillCreateFilesResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        Workspace_WillCreateFilesResultType _type{
            Workspace_WillCreateFilesResultType::Uninitialized
        };

        union {
            std::unique_ptr<WorkspaceEdit> _workspaceEdit;
            null_t _null;
        };

        auto reset() -> void;
    }; // class Workspace_WillCreateFilesResult

    enum class Workspace_WillRenameFilesResultType {
        Uninitialized = -1,
        WorkspaceEdit = 0,
        Null = 1,
    }; // enum class Workspace_WillRenameFilesResultType

    extern const std::map<Workspace_WillRenameFilesResultType, std::string>
        Workspace_WillRenameFilesResultTypeNames;

    class Workspace_WillRenameFilesResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Workspace_WillRenameFilesResult();
        Workspace_WillRenameFilesResult(
            Workspace_WillRenameFilesResult &&other
        );
        Workspace_WillRenameFilesResult(
            const Workspace_WillRenameFilesResult &other
        );
        ~Workspace_WillRenameFilesResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            Workspace_WillRenameFilesResult &&other
        ) -> Workspace_WillRenameFilesResult &;

        auto operator=(
            const Workspace_WillRenameFilesResult &other
        ) -> Workspace_WillRenameFilesResult &;

        auto type() const -> const Workspace_WillRenameFilesResultType &;

        auto workspaceEdit() const -> const WorkspaceEdit &;

        auto operator=(
            const std::unique_ptr<WorkspaceEdit> &workspaceEdit
        ) -> Workspace_WillRenameFilesResult &;

        auto operator=(
            std::unique_ptr<WorkspaceEdit> &&workspaceEdit
        ) -> Workspace_WillRenameFilesResult &;

        auto operator=(
            const WorkspaceEdit &workspaceEdit
        ) -> Workspace_WillRenameFilesResult &;

        auto operator=(
            WorkspaceEdit &&workspaceEdit
        ) -> Workspace_WillRenameFilesResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> Workspace_WillRenameFilesResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        Workspace_WillRenameFilesResultType _type{
            Workspace_WillRenameFilesResultType::Uninitialized
        };

        union {
            std::unique_ptr<WorkspaceEdit> _workspaceEdit;
            null_t _null;
        };

        auto reset() -> void;
    }; // class Workspace_WillRenameFilesResult

    enum class Workspace_WillDeleteFilesResultType {
        Uninitialized = -1,
        WorkspaceEdit = 0,
        Null = 1,
    }; // enum class Workspace_WillDeleteFilesResultType

    extern const std::map<Workspace_WillDeleteFilesResultType, std::string>
        Workspace_WillDeleteFilesResultTypeNames;

    class Workspace_WillDeleteFilesResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Workspace_WillDeleteFilesResult();
        Workspace_WillDeleteFilesResult(
            Workspace_WillDeleteFilesResult &&other
        );
        Workspace_WillDeleteFilesResult(
            const Workspace_WillDeleteFilesResult &other
        );
        ~Workspace_WillDeleteFilesResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            Workspace_WillDeleteFilesResult &&other
        ) -> Workspace_WillDeleteFilesResult &;

        auto operator=(
            const Workspace_WillDeleteFilesResult &other
        ) -> Workspace_WillDeleteFilesResult &;

        auto type() const -> const Workspace_WillDeleteFilesResultType &;

        auto workspaceEdit() const -> const WorkspaceEdit &;

        auto operator=(
            const std::unique_ptr<WorkspaceEdit> &workspaceEdit
        ) -> Workspace_WillDeleteFilesResult &;

        auto operator=(
            std::unique_ptr<WorkspaceEdit> &&workspaceEdit
        ) -> Workspace_WillDeleteFilesResult &;

        auto operator=(
            const WorkspaceEdit &workspaceEdit
        ) -> Workspace_WillDeleteFilesResult &;

        auto operator=(
            WorkspaceEdit &&workspaceEdit
        ) -> Workspace_WillDeleteFilesResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> Workspace_WillDeleteFilesResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        Workspace_WillDeleteFilesResultType _type{
            Workspace_WillDeleteFilesResultType::Uninitialized
        };

        union {
            std::unique_ptr<WorkspaceEdit> _workspaceEdit;
            null_t _null;
        };

        auto reset() -> void;
    }; // class Workspace_WillDeleteFilesResult

    enum class TextDocument_RenameResultType {
        Uninitialized = -1,
        WorkspaceEdit = 0,
        Null = 1,
    }; // enum class TextDocument_RenameResultType

    extern const std::map<TextDocument_RenameResultType, std::string>
        TextDocument_RenameResultTypeNames;

    class TextDocument_RenameResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_RenameResult();
        TextDocument_RenameResult(TextDocument_RenameResult &&other);
        TextDocument_RenameResult(const TextDocument_RenameResult &other);
        ~TextDocument_RenameResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_RenameResult &&other
        ) -> TextDocument_RenameResult &;

        auto operator=(
            const TextDocument_RenameResult &other
        ) -> TextDocument_RenameResult &;

        auto type() const -> const TextDocument_RenameResultType &;

        auto workspaceEdit() const -> const WorkspaceEdit &;

        auto operator=(
            const std::unique_ptr<WorkspaceEdit> &workspaceEdit
        ) -> TextDocument_RenameResult &;

        auto operator=(
            std::unique_ptr<WorkspaceEdit> &&workspaceEdit
        ) -> TextDocument_RenameResult &;

        auto operator=(
            const WorkspaceEdit &workspaceEdit
        ) -> TextDocument_RenameResult &;

        auto operator=(
            WorkspaceEdit &&workspaceEdit
        ) -> TextDocument_RenameResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_RenameResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_RenameResultType _type{
            TextDocument_RenameResultType::Uninitialized
        };

        union {
            std::unique_ptr<WorkspaceEdit> _workspaceEdit;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_RenameResult

    typedef double decimal_t;

    /**
     * Represents a color in RGBA space.
     */
    struct Color {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Color();
        Color(Color &&other);
        Color(const Color &other);
        ~Color();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Color &&other) -> Color &;

        auto operator=(const Color &other) -> Color &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The red component of this color in the range [0-1].
         */
        decimal_t red;
        /**
         * The green component of this color in the range [0-1].
         */
        decimal_t green;
        /**
         * The blue component of this color in the range [0-1].
         */
        decimal_t blue;
        /**
         * The alpha component of this color in the range [0-1].
         */
        decimal_t alpha;
    }; // struct Color

    /**
     * Represents a color range from a document.
     */
    struct ColorInformation {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ColorInformation();
        ColorInformation(ColorInformation &&other);
        ColorInformation(const ColorInformation &other);
        ~ColorInformation();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ColorInformation &&other) -> ColorInformation &;

        auto operator=(const ColorInformation &other) -> ColorInformation &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The range in the document where this color appears.
         */
        Range range;
        /**
         * The actual color value for this color range.
         */
        Color color;
    }; // struct ColorInformation

    /**
     * Parameters for a {@link ColorPresentationRequest}.
     */
    struct ColorPresentationParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ColorPresentationParams();
        ColorPresentationParams(ColorPresentationParams &&other);
        ColorPresentationParams(const ColorPresentationParams &other);
        ~ColorPresentationParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ColorPresentationParams &&other
        ) -> ColorPresentationParams &;

        auto operator=(
            const ColorPresentationParams &other
        ) -> ColorPresentationParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The text document.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The color to request presentations for.
         */
        Color color;
        /**
         * The range where the color would be inserted. Serves as a context.
         */
        Range range;
    }; // struct ColorPresentationParams

    typedef std::vector<ColorInformation> TextDocument_DocumentColorResult;

    struct SemanticTokensOptions_range_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensOptions_range_1();
        SemanticTokensOptions_range_1(SemanticTokensOptions_range_1 &&other);
        SemanticTokensOptions_range_1(
            const SemanticTokensOptions_range_1 &other
        );
        ~SemanticTokensOptions_range_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensOptions_range_1 &&other
        ) -> SemanticTokensOptions_range_1 &;

        auto operator=(
            const SemanticTokensOptions_range_1 &other
        ) -> SemanticTokensOptions_range_1 &;
    }; // struct SemanticTokensOptions_range_1

    enum class SemanticTokensOptions_rangeType {
        Uninitialized = -1,
        Boolean = 0,
        SemanticTokensOptions_range_1 = 1,
    }; // enum class SemanticTokensOptions_rangeType

    extern const std::map<SemanticTokensOptions_rangeType, std::string>
        SemanticTokensOptions_rangeTypeNames;

    class SemanticTokensOptions_range {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensOptions_range();
        SemanticTokensOptions_range(SemanticTokensOptions_range &&other);
        SemanticTokensOptions_range(const SemanticTokensOptions_range &other);
        ~SemanticTokensOptions_range();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensOptions_range &&other
        ) -> SemanticTokensOptions_range &;

        auto operator=(
            const SemanticTokensOptions_range &other
        ) -> SemanticTokensOptions_range &;

        auto type() const -> const SemanticTokensOptions_rangeType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(boolean_t boolean) -> SemanticTokensOptions_range &;

        auto semanticTokensOptions_range_1() const
        -> const SemanticTokensOptions_range_1 &;

        auto operator=(
            const std::unique_ptr<SemanticTokensOptions_range_1> &semanticTokensOptions_range_1
        ) -> SemanticTokensOptions_range &;

        auto operator=(
            std::unique_ptr<SemanticTokensOptions_range_1> &&semanticTokensOptions_range_1
        ) -> SemanticTokensOptions_range &;

        auto operator=(
            const SemanticTokensOptions_range_1 &semanticTokensOptions_range_1
        ) -> SemanticTokensOptions_range &;

        auto operator=(
            SemanticTokensOptions_range_1 &&semanticTokensOptions_range_1
        ) -> SemanticTokensOptions_range &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        SemanticTokensOptions_rangeType _type{
            SemanticTokensOptions_rangeType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<SemanticTokensOptions_range_1> _semanticTokensOptions_range_1;
        };

        auto reset() -> void;
    }; // class SemanticTokensOptions_range

    /**
     * @since 3.16.0
     */
    struct SemanticTokensOptions {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensOptions();
        SemanticTokensOptions(SemanticTokensOptions &&other);
        SemanticTokensOptions(const SemanticTokensOptions &other);
        ~SemanticTokensOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensOptions &&other
        ) -> SemanticTokensOptions &;

        auto operator=(
            const SemanticTokensOptions &other
        ) -> SemanticTokensOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::optional<boolean_t> workDoneProgress;
        /**
         * The legend used by the server
         */
        SemanticTokensLegend legend;
        /**
         * Server supports providing semantic tokens for a specific range
         * of a document.
         */
        std::optional<SemanticTokensOptions_range> range;
        /**
         * Server supports providing semantic tokens for a full document.
         */
        std::optional<SemanticTokensOptions_full> full;
    }; // struct SemanticTokensOptions

    /**
     * @since 3.16.0
     */
    struct SemanticTokensRegistrationOptions
        : public TextDocumentRegistrationOptions
        , public SemanticTokensOptions
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensRegistrationOptions();
        SemanticTokensRegistrationOptions(
            SemanticTokensRegistrationOptions &&other
        );
        SemanticTokensRegistrationOptions(
            const SemanticTokensRegistrationOptions &other
        );
        ~SemanticTokensRegistrationOptions();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensRegistrationOptions &&other
        ) -> SemanticTokensRegistrationOptions &;

        auto operator=(
            const SemanticTokensRegistrationOptions &other
        ) -> SemanticTokensRegistrationOptions &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again. See also Registration#id.
         */
        std::optional<string_t> id;
    }; // struct SemanticTokensRegistrationOptions

    enum class ServerCapabilities_semanticTokensProviderType {
        Uninitialized = -1,
        SemanticTokensOptions = 0,
        SemanticTokensRegistrationOptions = 1,
    }; // enum class ServerCapabilities_semanticTokensProviderType

    extern const std::map<
        ServerCapabilities_semanticTokensProviderType,
        std::string
    > ServerCapabilities_semanticTokensProviderTypeNames;

    class ServerCapabilities_semanticTokensProvider {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities_semanticTokensProvider();
        ServerCapabilities_semanticTokensProvider(
            ServerCapabilities_semanticTokensProvider &&other
        );
        ServerCapabilities_semanticTokensProvider(
            const ServerCapabilities_semanticTokensProvider &other
        );
        ~ServerCapabilities_semanticTokensProvider();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            ServerCapabilities_semanticTokensProvider &&other
        ) -> ServerCapabilities_semanticTokensProvider &;

        auto operator=(
            const ServerCapabilities_semanticTokensProvider &other
        ) -> ServerCapabilities_semanticTokensProvider &;

        auto type() const
        -> const ServerCapabilities_semanticTokensProviderType &;

        auto semanticTokensOptions() const -> const SemanticTokensOptions &;

        auto operator=(
            const std::unique_ptr<SemanticTokensOptions> &semanticTokensOptions
        ) -> ServerCapabilities_semanticTokensProvider &;

        auto operator=(
            std::unique_ptr<SemanticTokensOptions> &&semanticTokensOptions
        ) -> ServerCapabilities_semanticTokensProvider &;

        auto operator=(
            const SemanticTokensOptions &semanticTokensOptions
        ) -> ServerCapabilities_semanticTokensProvider &;

        auto operator=(
            SemanticTokensOptions &&semanticTokensOptions
        ) -> ServerCapabilities_semanticTokensProvider &;

        auto semanticTokensRegistrationOptions() const
        -> const SemanticTokensRegistrationOptions &;

        auto operator=(
            const std::unique_ptr<SemanticTokensRegistrationOptions> &semanticTokensRegistrationOptions
        ) -> ServerCapabilities_semanticTokensProvider &;

        auto operator=(
            std::unique_ptr<SemanticTokensRegistrationOptions> &&semanticTokensRegistrationOptions
        ) -> ServerCapabilities_semanticTokensProvider &;

        auto operator=(
            const SemanticTokensRegistrationOptions &semanticTokensRegistrationOptions
        ) -> ServerCapabilities_semanticTokensProvider &;

        auto operator=(
            SemanticTokensRegistrationOptions &&semanticTokensRegistrationOptions
        ) -> ServerCapabilities_semanticTokensProvider &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        ServerCapabilities_semanticTokensProviderType _type{
            ServerCapabilities_semanticTokensProviderType::Uninitialized
        };

        union {
            std::unique_ptr<SemanticTokensOptions> _semanticTokensOptions;
            std::unique_ptr<SemanticTokensRegistrationOptions> _semanticTokensRegistrationOptions;
        };

        auto reset() -> void;
    }; // class ServerCapabilities_semanticTokensProvider

    struct SemanticTokensClientCapabilities_requests_range_1 {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensClientCapabilities_requests_range_1();
        SemanticTokensClientCapabilities_requests_range_1(
            SemanticTokensClientCapabilities_requests_range_1 &&other
        );
        SemanticTokensClientCapabilities_requests_range_1(
            const SemanticTokensClientCapabilities_requests_range_1 &other
        );
        ~SemanticTokensClientCapabilities_requests_range_1();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensClientCapabilities_requests_range_1 &&other
        ) -> SemanticTokensClientCapabilities_requests_range_1 &;

        auto operator=(
            const SemanticTokensClientCapabilities_requests_range_1 &other
        ) -> SemanticTokensClientCapabilities_requests_range_1 &;
    }; // struct SemanticTokensClientCapabilities_requests_range_1

    enum class SemanticTokensClientCapabilities_requests_rangeType {
        Uninitialized = -1,
        Boolean = 0,
        SemanticTokensClientCapabilities_requests_range_1 = 1,
    }; // enum class SemanticTokensClientCapabilities_requests_rangeType

    extern const std::map<
        SemanticTokensClientCapabilities_requests_rangeType,
        std::string
    > SemanticTokensClientCapabilities_requests_rangeTypeNames;

    class SemanticTokensClientCapabilities_requests_range {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensClientCapabilities_requests_range();
        SemanticTokensClientCapabilities_requests_range(
            SemanticTokensClientCapabilities_requests_range &&other
        );
        SemanticTokensClientCapabilities_requests_range(
            const SemanticTokensClientCapabilities_requests_range &other
        );
        ~SemanticTokensClientCapabilities_requests_range();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensClientCapabilities_requests_range &&other
        ) -> SemanticTokensClientCapabilities_requests_range &;

        auto operator=(
            const SemanticTokensClientCapabilities_requests_range &other
        ) -> SemanticTokensClientCapabilities_requests_range &;

        auto type() const
        -> const SemanticTokensClientCapabilities_requests_rangeType &;

        auto boolean() const -> const boolean_t &;

        auto operator=(
            boolean_t boolean
        ) -> SemanticTokensClientCapabilities_requests_range &;

        auto semanticTokensClientCapabilities_requests_range_1() const
        -> const SemanticTokensClientCapabilities_requests_range_1 &;

        auto operator=(
            const std::unique_ptr<SemanticTokensClientCapabilities_requests_range_1> &semanticTokensClientCapabilities_requests_range_1
        ) -> SemanticTokensClientCapabilities_requests_range &;

        auto operator=(
            std::unique_ptr<SemanticTokensClientCapabilities_requests_range_1> &&semanticTokensClientCapabilities_requests_range_1
        ) -> SemanticTokensClientCapabilities_requests_range &;

        auto operator=(
            const SemanticTokensClientCapabilities_requests_range_1 &semanticTokensClientCapabilities_requests_range_1
        ) -> SemanticTokensClientCapabilities_requests_range &;

        auto operator=(
            SemanticTokensClientCapabilities_requests_range_1 &&semanticTokensClientCapabilities_requests_range_1
        ) -> SemanticTokensClientCapabilities_requests_range &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        SemanticTokensClientCapabilities_requests_rangeType _type{
            SemanticTokensClientCapabilities_requests_rangeType::Uninitialized
        };

        union {
            boolean_t _boolean;
            std::unique_ptr<SemanticTokensClientCapabilities_requests_range_1> _semanticTokensClientCapabilities_requests_range_1;
        };

        auto reset() -> void;
    }; // class SemanticTokensClientCapabilities_requests_range

    struct SemanticTokensClientCapabilities_requests {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensClientCapabilities_requests();
        SemanticTokensClientCapabilities_requests(
            SemanticTokensClientCapabilities_requests &&other
        );
        SemanticTokensClientCapabilities_requests(
            const SemanticTokensClientCapabilities_requests &other
        );
        ~SemanticTokensClientCapabilities_requests();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensClientCapabilities_requests &&other
        ) -> SemanticTokensClientCapabilities_requests &;

        auto operator=(
            const SemanticTokensClientCapabilities_requests &other
        ) -> SemanticTokensClientCapabilities_requests &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The client will send the `textDocument/semanticTokens/range` request if
         * the server provides a corresponding handler.
         */
        std::optional<SemanticTokensClientCapabilities_requests_range> range;
        /**
         * The client will send the `textDocument/semanticTokens/full` request if
         * the server provides a corresponding handler.
         */
        std::optional<SemanticTokensClientCapabilities_requests_full> full;
    }; // struct SemanticTokensClientCapabilities_requests

    /**
     * @since 3.16.0
     */
    struct SemanticTokensClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        SemanticTokensClientCapabilities();
        SemanticTokensClientCapabilities(
            SemanticTokensClientCapabilities &&other
        );
        SemanticTokensClientCapabilities(
            const SemanticTokensClientCapabilities &other
        );
        ~SemanticTokensClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            SemanticTokensClientCapabilities &&other
        ) -> SemanticTokensClientCapabilities &;

        auto operator=(
            const SemanticTokensClientCapabilities &other
        ) -> SemanticTokensClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Whether implementation supports dynamic registration. If this is set to `true`
         * the client supports the new `(TextDocumentRegistrationOptions & StaticRegistrationOptions)`
         * return value for the corresponding server capability as well.
         */
        std::optional<boolean_t> dynamicRegistration;
        /**
         * Which requests the client supports and might send to the server
         * depending on the server's capability. Please note that clients might not
         * show semantic tokens or degrade some of the user experience if a range
         * or full request is advertised by the client but not provided by the
         * server. If for example the client capability `requests.full` and
         * `request.range` are both set to true but the server only provides a
         * range provider the client might not render a minimap correctly or might
         * even decide to not show any semantic tokens at all.
         */
        SemanticTokensClientCapabilities_requests requests;
        /**
         * The token types that the client supports.
         */
        std::vector<string_t> tokenTypes;
        /**
         * The token modifiers that the client supports.
         */
        std::vector<string_t> tokenModifiers;
        /**
         * The token formats the clients supports.
         */
        std::vector<TokenFormat> formats;
        /**
         * Whether the client supports tokens that can overlap each other.
         */
        std::optional<boolean_t> overlappingTokenSupport;
        /**
         * Whether the client supports tokens that can span multiple lines.
         */
        std::optional<boolean_t> multilineTokenSupport;
        /**
         * Whether the client allows the server to actively cancel a
         * semantic token request, e.g. supports returning
         * LSPErrorCodes.ServerCancelled. If a server does the client
         * needs to retrigger the request.
         *
         * @since 3.17.0
         */
        std::optional<boolean_t> serverCancelSupport;
        /**
         * Whether the client uses semantic tokens to augment existing
         * syntax tokens. If set to `true` client side created syntax
         * tokens and semantic tokens are both used for colorization. If
         * set to `false` the client only uses the returned semantic tokens
         * for colorization.
         *
         * If the value is `undefined` then the client behavior is not
         * specified.
         *
         * @since 3.17.0
         */
        std::optional<boolean_t> augmentsSyntaxTokens;
    }; // struct SemanticTokensClientCapabilities

    /**
     * Text document specific client capabilities.
     */
    struct TextDocumentClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocumentClientCapabilities();
        TextDocumentClientCapabilities(TextDocumentClientCapabilities &&other);
        TextDocumentClientCapabilities(
            const TextDocumentClientCapabilities &other
        );
        ~TextDocumentClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocumentClientCapabilities &&other
        ) -> TextDocumentClientCapabilities &;

        auto operator=(
            const TextDocumentClientCapabilities &other
        ) -> TextDocumentClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Defines which synchronization capabilities the client supports.
         */
        std::optional<TextDocumentSyncClientCapabilities> synchronization;
        /**
         * Capabilities specific to the `textDocument/completion` request.
         */
        std::optional<CompletionClientCapabilities> completion;
        /**
         * Capabilities specific to the `textDocument/hover` request.
         */
        std::optional<HoverClientCapabilities> hover;
        /**
         * Capabilities specific to the `textDocument/signatureHelp` request.
         */
        std::optional<SignatureHelpClientCapabilities> signatureHelp;
        /**
         * Capabilities specific to the `textDocument/declaration` request.
         *
         * @since 3.14.0
         */
        std::optional<DeclarationClientCapabilities> declaration;
        /**
         * Capabilities specific to the `textDocument/definition` request.
         */
        std::optional<DefinitionClientCapabilities> definition;
        /**
         * Capabilities specific to the `textDocument/typeDefinition` request.
         *
         * @since 3.6.0
         */
        std::optional<TypeDefinitionClientCapabilities> typeDefinition;
        /**
         * Capabilities specific to the `textDocument/implementation` request.
         *
         * @since 3.6.0
         */
        std::optional<ImplementationClientCapabilities> implementation;
        /**
         * Capabilities specific to the `textDocument/references` request.
         */
        std::optional<ReferenceClientCapabilities> references;
        /**
         * Capabilities specific to the `textDocument/documentHighlight` request.
         */
        std::optional<DocumentHighlightClientCapabilities> documentHighlight;
        /**
         * Capabilities specific to the `textDocument/documentSymbol` request.
         */
        std::optional<DocumentSymbolClientCapabilities> documentSymbol;
        /**
         * Capabilities specific to the `textDocument/codeAction` request.
         */
        std::optional<CodeActionClientCapabilities> codeAction;
        /**
         * Capabilities specific to the `textDocument/codeLens` request.
         */
        std::optional<CodeLensClientCapabilities> codeLens;
        /**
         * Capabilities specific to the `textDocument/documentLink` request.
         */
        std::optional<DocumentLinkClientCapabilities> documentLink;
        /**
         * Capabilities specific to the `textDocument/documentColor` and the
         * `textDocument/colorPresentation` request.
         *
         * @since 3.6.0
         */
        std::optional<DocumentColorClientCapabilities> colorProvider;
        /**
         * Capabilities specific to the `textDocument/formatting` request.
         */
        std::optional<DocumentFormattingClientCapabilities> formatting;
        /**
         * Capabilities specific to the `textDocument/rangeFormatting` request.
         */
        std::optional<DocumentRangeFormattingClientCapabilities>
            rangeFormatting;
        /**
         * Capabilities specific to the `textDocument/onTypeFormatting` request.
         */
        std::optional<DocumentOnTypeFormattingClientCapabilities>
            onTypeFormatting;
        /**
         * Capabilities specific to the `textDocument/rename` request.
         */
        std::optional<RenameClientCapabilities> rename;
        /**
         * Capabilities specific to the `textDocument/foldingRange` request.
         *
         * @since 3.10.0
         */
        std::optional<FoldingRangeClientCapabilities> foldingRange;
        /**
         * Capabilities specific to the `textDocument/selectionRange` request.
         *
         * @since 3.15.0
         */
        std::optional<SelectionRangeClientCapabilities> selectionRange;
        /**
         * Capabilities specific to the `textDocument/publishDiagnostics` notification.
         */
        std::optional<PublishDiagnosticsClientCapabilities> publishDiagnostics;
        /**
         * Capabilities specific to the various call hierarchy requests.
         *
         * @since 3.16.0
         */
        std::optional<CallHierarchyClientCapabilities> callHierarchy;
        /**
         * Capabilities specific to the various semantic token request.
         *
         * @since 3.16.0
         */
        std::optional<SemanticTokensClientCapabilities> semanticTokens;
        /**
         * Capabilities specific to the `textDocument/linkedEditingRange` request.
         *
         * @since 3.16.0
         */
        std::optional<LinkedEditingRangeClientCapabilities> linkedEditingRange;
        /**
         * Client capabilities specific to the `textDocument/moniker` request.
         *
         * @since 3.16.0
         */
        std::optional<MonikerClientCapabilities> moniker;
        /**
         * Capabilities specific to the various type hierarchy requests.
         *
         * @since 3.17.0
         */
        std::optional<TypeHierarchyClientCapabilities> typeHierarchy;
        /**
         * Capabilities specific to the `textDocument/inlineValue` request.
         *
         * @since 3.17.0
         */
        std::optional<InlineValueClientCapabilities> inlineValue;
        /**
         * Capabilities specific to the `textDocument/inlayHint` request.
         *
         * @since 3.17.0
         */
        std::optional<InlayHintClientCapabilities> inlayHint;
        /**
         * Capabilities specific to the diagnostic pull model.
         *
         * @since 3.17.0
         */
        std::optional<DiagnosticClientCapabilities> diagnostic;
        /**
         * Client capabilities specific to inline completions.
         *
         * @since 3.18.0
         * @proposed
         */
        std::optional<InlineCompletionClientCapabilities> inlineCompletion;
    }; // struct TextDocumentClientCapabilities

    typedef std::vector<std::unique_ptr<LSPAny>> LSPArray;

    enum class LSPAnyType {
        Uninitialized = -1,
        Object = 0,
        Array = 1,
        String = 2,
        Integer = 3,
        UInteger = 4,
        Decimal = 5,
        Boolean = 6,
        Null = 7,
    }; // enum class LSPAnyType

    extern const std::map<LSPAnyType, std::string> LSPAnyTypeNames;

    class LSPAny {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        LSPAny();
        LSPAny(LSPAny &&other);
        LSPAny(const LSPAny &other);
        ~LSPAny();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(LSPAny &&other) -> LSPAny &;

        auto operator=(const LSPAny &other) -> LSPAny &;

        auto type() const -> const LSPAnyType &;

        auto object() const -> const LSPObject &;

        auto operator=(const std::unique_ptr<LSPObject> &object) -> LSPAny &;

        auto operator=(std::unique_ptr<LSPObject> &&object) -> LSPAny &;

        auto operator=(const LSPObject &object) -> LSPAny &;

        auto operator=(LSPObject &&object) -> LSPAny &;

        auto array() const -> const LSPArray &;

        auto operator=(const std::unique_ptr<LSPArray> &array) -> LSPAny &;

        auto operator=(std::unique_ptr<LSPArray> &&array) -> LSPAny &;

        auto operator=(const LSPArray &array) -> LSPAny &;

        auto operator=(LSPArray &&array) -> LSPAny &;

        auto string() const -> const string_t &;

        auto operator=(const std::unique_ptr<string_t> &string) -> LSPAny &;

        auto operator=(std::unique_ptr<string_t> &&string) -> LSPAny &;

        auto operator=(const string_t &string) -> LSPAny &;

        auto operator=(string_t &&string) -> LSPAny &;

        auto integer() const -> const integer_t &;

        auto operator=(integer_t integer) -> LSPAny &;

        auto uinteger() const -> const uinteger_t &;

        auto operator=(uinteger_t uinteger) -> LSPAny &;

        auto decimal() const -> const decimal_t &;

        auto operator=(decimal_t decimal) -> LSPAny &;

        auto boolean() const -> const boolean_t &;

        auto operator=(boolean_t boolean) -> LSPAny &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> LSPAny &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        LSPAnyType _type{LSPAnyType::Uninitialized};

        union {
            std::unique_ptr<LSPObject> _object;
            std::unique_ptr<LSPArray> _array;
            std::unique_ptr<string_t> _string;
            integer_t _integer;
            uinteger_t _uinteger;
            decimal_t _decimal;
            boolean_t _boolean;
            null_t _null;
        };

        auto reset() -> void;
    }; // class LSPAny

    /**
     * Represents programming constructs like functions or constructors in the context
     * of call hierarchy.
     *
     * @since 3.16.0
     */
    struct CallHierarchyItem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CallHierarchyItem();
        CallHierarchyItem(CallHierarchyItem &&other);
        CallHierarchyItem(const CallHierarchyItem &other);
        ~CallHierarchyItem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CallHierarchyItem &&other) -> CallHierarchyItem &;

        auto operator=(const CallHierarchyItem &other) -> CallHierarchyItem &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The name of this item.
         */
        string_t name;
        /**
         * The kind of this item.
         */
        SymbolKind kind;
        /**
         * Tags for this item.
         */
        std::optional<std::vector<SymbolTag>> tags;
        /**
         * More detail for this item, e.g. the signature of a function.
         */
        std::optional<string_t> detail;
        /**
         * The resource identifier of this item.
         */
        DocumentUri uri;
        /**
         * The range enclosing this symbol not including leading/trailing whitespace but everything else, e.g. comments and code.
         */
        Range range;
        /**
         * The range that should be selected and revealed when this symbol is being picked, e.g. the name of a function.
         * Must be contained by the {@link CallHierarchyItem.range `range`}.
         */
        Range selectionRange;
        /**
         * A data entry field that is preserved between a call hierarchy prepare and
         * incoming calls or outgoing calls requests.
         */
        std::optional<LSPAny> data;
    }; // struct CallHierarchyItem

    /**
     * The parameter of a `callHierarchy/incomingCalls` request.
     *
     * @since 3.16.0
     */
    struct CallHierarchyIncomingCallsParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CallHierarchyIncomingCallsParams();
        CallHierarchyIncomingCallsParams(
            CallHierarchyIncomingCallsParams &&other
        );
        CallHierarchyIncomingCallsParams(
            const CallHierarchyIncomingCallsParams &other
        );
        ~CallHierarchyIncomingCallsParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CallHierarchyIncomingCallsParams &&other
        ) -> CallHierarchyIncomingCallsParams &;

        auto operator=(
            const CallHierarchyIncomingCallsParams &other
        ) -> CallHierarchyIncomingCallsParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        CallHierarchyItem item;
    }; // struct CallHierarchyIncomingCallsParams

    /**
     * Represents an incoming call, e.g. a caller of a method or constructor.
     *
     * @since 3.16.0
     */
    struct CallHierarchyIncomingCall {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CallHierarchyIncomingCall();
        CallHierarchyIncomingCall(CallHierarchyIncomingCall &&other);
        CallHierarchyIncomingCall(const CallHierarchyIncomingCall &other);
        ~CallHierarchyIncomingCall();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CallHierarchyIncomingCall &&other
        ) -> CallHierarchyIncomingCall &;

        auto operator=(
            const CallHierarchyIncomingCall &other
        ) -> CallHierarchyIncomingCall &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The item that makes the call.
         */
        CallHierarchyItem from;
        /**
         * The ranges at which the calls appear. This is relative to the caller
         * denoted by {@link CallHierarchyIncomingCall.from `this.from`}.
         */
        std::vector<Range> fromRanges;
    }; // struct CallHierarchyIncomingCall

    /**
     * The parameter of a `callHierarchy/outgoingCalls` request.
     *
     * @since 3.16.0
     */
    struct CallHierarchyOutgoingCallsParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CallHierarchyOutgoingCallsParams();
        CallHierarchyOutgoingCallsParams(
            CallHierarchyOutgoingCallsParams &&other
        );
        CallHierarchyOutgoingCallsParams(
            const CallHierarchyOutgoingCallsParams &other
        );
        ~CallHierarchyOutgoingCallsParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CallHierarchyOutgoingCallsParams &&other
        ) -> CallHierarchyOutgoingCallsParams &;

        auto operator=(
            const CallHierarchyOutgoingCallsParams &other
        ) -> CallHierarchyOutgoingCallsParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        CallHierarchyItem item;
    }; // struct CallHierarchyOutgoingCallsParams

    /**
     * Represents an outgoing call, e.g. calling a getter from a method or a method from a constructor etc.
     *
     * @since 3.16.0
     */
    struct CallHierarchyOutgoingCall {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CallHierarchyOutgoingCall();
        CallHierarchyOutgoingCall(CallHierarchyOutgoingCall &&other);
        CallHierarchyOutgoingCall(const CallHierarchyOutgoingCall &other);
        ~CallHierarchyOutgoingCall();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CallHierarchyOutgoingCall &&other
        ) -> CallHierarchyOutgoingCall &;

        auto operator=(
            const CallHierarchyOutgoingCall &other
        ) -> CallHierarchyOutgoingCall &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The item that is called.
         */
        CallHierarchyItem to;
        /**
         * The range at which this item is called. This is the range relative to the caller, e.g the item
         * passed to {@link CallHierarchyItemProvider.provideCallHierarchyOutgoingCalls `provideCallHierarchyOutgoingCalls`}
         * and not {@link CallHierarchyOutgoingCall.to `this.to`}.
         */
        std::vector<Range> fromRanges;
    }; // struct CallHierarchyOutgoingCall

    /**
     * @since 3.17.0
     */
    struct TypeHierarchyItem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeHierarchyItem();
        TypeHierarchyItem(TypeHierarchyItem &&other);
        TypeHierarchyItem(const TypeHierarchyItem &other);
        ~TypeHierarchyItem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(TypeHierarchyItem &&other) -> TypeHierarchyItem &;

        auto operator=(const TypeHierarchyItem &other) -> TypeHierarchyItem &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The name of this item.
         */
        string_t name;
        /**
         * The kind of this item.
         */
        SymbolKind kind;
        /**
         * Tags for this item.
         */
        std::optional<std::vector<SymbolTag>> tags;
        /**
         * More detail for this item, e.g. the signature of a function.
         */
        std::optional<string_t> detail;
        /**
         * The resource identifier of this item.
         */
        DocumentUri uri;
        /**
         * The range enclosing this symbol not including leading/trailing whitespace
         * but everything else, e.g. comments and code.
         */
        Range range;
        /**
         * The range that should be selected and revealed when this symbol is being
         * picked, e.g. the name of a function. Must be contained by the
         * {@link TypeHierarchyItem.range `range`}.
         */
        Range selectionRange;
        /**
         * A data entry field that is preserved between a type hierarchy prepare and
         * supertypes or subtypes requests. It could also be used to identify the
         * type hierarchy in the server, helping improve the performance on
         * resolving supertypes and subtypes.
         */
        std::optional<LSPAny> data;
    }; // struct TypeHierarchyItem

    /**
     * The parameter of a `typeHierarchy/supertypes` request.
     *
     * @since 3.17.0
     */
    struct TypeHierarchySupertypesParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeHierarchySupertypesParams();
        TypeHierarchySupertypesParams(TypeHierarchySupertypesParams &&other);
        TypeHierarchySupertypesParams(
            const TypeHierarchySupertypesParams &other
        );
        ~TypeHierarchySupertypesParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TypeHierarchySupertypesParams &&other
        ) -> TypeHierarchySupertypesParams &;

        auto operator=(
            const TypeHierarchySupertypesParams &other
        ) -> TypeHierarchySupertypesParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        TypeHierarchyItem item;
    }; // struct TypeHierarchySupertypesParams

    /**
     * The parameter of a `typeHierarchy/subtypes` request.
     *
     * @since 3.17.0
     */
    struct TypeHierarchySubtypesParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeHierarchySubtypesParams();
        TypeHierarchySubtypesParams(TypeHierarchySubtypesParams &&other);
        TypeHierarchySubtypesParams(const TypeHierarchySubtypesParams &other);
        ~TypeHierarchySubtypesParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TypeHierarchySubtypesParams &&other
        ) -> TypeHierarchySubtypesParams &;

        auto operator=(
            const TypeHierarchySubtypesParams &other
        ) -> TypeHierarchySubtypesParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        TypeHierarchyItem item;
    }; // struct TypeHierarchySubtypesParams

    /**
     * The parameters of a change configuration notification.
     */
    struct DidChangeConfigurationParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidChangeConfigurationParams();
        DidChangeConfigurationParams(DidChangeConfigurationParams &&other);
        DidChangeConfigurationParams(
            const DidChangeConfigurationParams &other
        );
        ~DidChangeConfigurationParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidChangeConfigurationParams &&other
        ) -> DidChangeConfigurationParams &;

        auto operator=(
            const DidChangeConfigurationParams &other
        ) -> DidChangeConfigurationParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The actual changed settings
         */
        LSPAny settings;
    }; // struct DidChangeConfigurationParams

    struct CompletionList_itemDefaults {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionList_itemDefaults();
        CompletionList_itemDefaults(CompletionList_itemDefaults &&other);
        CompletionList_itemDefaults(const CompletionList_itemDefaults &other);
        ~CompletionList_itemDefaults();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CompletionList_itemDefaults &&other
        ) -> CompletionList_itemDefaults &;

        auto operator=(
            const CompletionList_itemDefaults &other
        ) -> CompletionList_itemDefaults &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A default commit character set.
         *
         * @since 3.17.0
         */
        std::optional<std::vector<string_t>> commitCharacters;
        /**
         * A default edit range.
         *
         * @since 3.17.0
         */
        std::optional<CompletionList_itemDefaults_editRange> editRange;
        /**
         * A default insert text format.
         *
         * @since 3.17.0
         */
        std::optional<InsertTextFormat> insertTextFormat;
        /**
         * A default insert text mode.
         *
         * @since 3.17.0
         */
        std::optional<InsertTextMode> insertTextMode;
        /**
         * A default data value.
         *
         * @since 3.17.0
         */
        std::optional<LSPAny> data;
    }; // struct CompletionList_itemDefaults

    /**
     * Represents a reference to a command. Provides a title which
     * will be used to represent a command in the UI and, optionally,
     * an array of arguments which will be passed to the command handler
     * function when invoked.
     */
    struct Command {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Command();
        Command(Command &&other);
        Command(const Command &other);
        ~Command();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Command &&other) -> Command &;

        auto operator=(const Command &other) -> Command &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Title of the command, like `save`.
         */
        string_t title;
        /**
         * The identifier of the actual command handler.
         */
        string_t command;
        /**
         * Arguments that the command handler should be
         * invoked with.
         */
        std::optional<std::vector<LSPAny>> arguments;
    }; // struct Command

    /**
     * An inline completion item represents a text snippet that is proposed inline to complete text that is being typed.
     *
     * @since 3.18.0
     * @proposed
     */
    struct InlineCompletionItem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineCompletionItem();
        InlineCompletionItem(InlineCompletionItem &&other);
        InlineCompletionItem(const InlineCompletionItem &other);
        ~InlineCompletionItem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlineCompletionItem &&other) -> InlineCompletionItem &;

        auto operator=(
            const InlineCompletionItem &other
        ) -> InlineCompletionItem &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The text to replace the range with. Must be set.
         */
        InlineCompletionItem_insertText insertText;
        /**
         * A text that is used to decide if this inline completion should be shown. When `falsy` the {@link InlineCompletionItem.insertText} is used.
         */
        std::optional<string_t> filterText;
        /**
         * The range to replace. Must begin and end on the same line.
         */
        std::optional<Range> range;
        /**
         * An optional {@link Command} that is executed *after* inserting this completion.
         */
        std::optional<Command> command;
    }; // struct InlineCompletionItem

    /**
     * Represents a collection of {@link InlineCompletionItem inline completion items} to be presented in the editor.
     *
     * @since 3.18.0
     * @proposed
     */
    struct InlineCompletionList {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlineCompletionList();
        InlineCompletionList(InlineCompletionList &&other);
        InlineCompletionList(const InlineCompletionList &other);
        ~InlineCompletionList();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlineCompletionList &&other) -> InlineCompletionList &;

        auto operator=(
            const InlineCompletionList &other
        ) -> InlineCompletionList &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The inline completion items
         */
        std::vector<InlineCompletionItem> items;
    }; // struct InlineCompletionList

    typedef std::vector<InlineCompletionItem> InlineCompletionList_items;

    /**
     * A completion item represents a text snippet that is
     * proposed to complete text that is being typed.
     */
    struct CompletionItem {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionItem();
        CompletionItem(CompletionItem &&other);
        CompletionItem(const CompletionItem &other);
        ~CompletionItem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CompletionItem &&other) -> CompletionItem &;

        auto operator=(const CompletionItem &other) -> CompletionItem &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The label of this completion item.
         *
         * The label property is also by default the text that
         * is inserted when selecting this completion.
         *
         * If label details are provided the label itself should
         * be an unqualified name of the completion item.
         */
        string_t label;
        /**
         * Additional details for the label
         *
         * @since 3.17.0
         */
        std::optional<CompletionItemLabelDetails> labelDetails;
        /**
         * The kind of this completion item. Based of the kind
         * an icon is chosen by the editor.
         */
        std::optional<CompletionItemKind> kind;
        /**
         * Tags for this completion item.
         *
         * @since 3.15.0
         */
        std::optional<std::vector<CompletionItemTag>> tags;
        /**
         * A human-readable string with additional information
         * about this item, like type or symbol information.
         */
        std::optional<string_t> detail;
        /**
         * A human-readable string that represents a doc-comment.
         */
        std::optional<CompletionItem_documentation> documentation;
        /**
         * Indicates if this item is deprecated.
         * @deprecated Use `tags` instead.
         */
        std::optional<boolean_t> deprecated;
        /**
         * Select this item when showing.
         *
         * *Note* that only one completion item can be selected and that the
         * tool / client decides which item that is. The rule is that the *first*
         * item of those that match best is selected.
         */
        std::optional<boolean_t> preselect;
        /**
         * A string that should be used when comparing this item
         * with other items. When `falsy` the {@link CompletionItem.label label}
         * is used.
         */
        std::optional<string_t> sortText;
        /**
         * A string that should be used when filtering a set of
         * completion items. When `falsy` the {@link CompletionItem.label label}
         * is used.
         */
        std::optional<string_t> filterText;
        /**
         * A string that should be inserted into a document when selecting
         * this completion. When `falsy` the {@link CompletionItem.label label}
         * is used.
         *
         * The `insertText` is subject to interpretation by the client side.
         * Some tools might not take the string literally. For example
         * VS Code when code complete is requested in this example
         * `con<cursor position>` and a completion item with an `insertText` of
         * `console` is provided it will only insert `sole`. Therefore it is
         * recommended to use `textEdit` instead since it avoids additional client
         * side interpretation.
         */
        std::optional<string_t> insertText;
        /**
         * The format of the insert text. The format applies to both the
         * `insertText` property and the `newText` property of a provided
         * `textEdit`. If omitted defaults to `InsertTextFormat.PlainText`.
         *
         * Please note that the insertTextFormat doesn't apply to
         * `additionalTextEdits`.
         */
        std::optional<InsertTextFormat> insertTextFormat;
        /**
         * How whitespace and indentation is handled during completion
         * item insertion. If not provided the clients default value depends on
         * the `textDocument.completion.insertTextMode` client capability.
         *
         * @since 3.16.0
         */
        std::optional<InsertTextMode> insertTextMode;
        /**
         * An {@link TextEdit edit} which is applied to a document when selecting
         * this completion. When an edit is provided the value of
         * {@link CompletionItem.insertText insertText} is ignored.
         *
         * Most editors support two different operations when accepting a completion
         * item. One is to insert a completion text and the other is to replace an
         * existing text with a completion text. Since this can usually not be
         * predetermined by a server it can report both ranges. Clients need to
         * signal support for `InsertReplaceEdits` via the
         * `textDocument.completion.insertReplaceSupport` client capability
         * property.
         *
         * *Note 1:* The text edit's range as well as both ranges from an insert
         * replace edit must be a [single line] and they must contain the position
         * at which completion has been requested.
         * *Note 2:* If an `InsertReplaceEdit` is returned the edit's insert range
         * must be a prefix of the edit's replace range, that means it must be
         * contained and starting at the same position.
         *
         * @since 3.16.0 additional type `InsertReplaceEdit`
         */
        std::optional<CompletionItem_textEdit> textEdit;
        /**
         * The edit text used if the completion item is part of a CompletionList and
         * CompletionList defines an item default for the text edit range.
         *
         * Clients will only honor this property if they opt into completion list
         * item defaults using the capability `completionList.itemDefaults`.
         *
         * If not provided and a list's default range is provided the label
         * property is used as a text.
         *
         * @since 3.17.0
         */
        std::optional<string_t> textEditText;
        /**
         * An optional array of additional {@link TextEdit text edits} that are applied when
         * selecting this completion. Edits must not overlap (including the same insert position)
         * with the main {@link CompletionItem.textEdit edit} nor with themselves.
         *
         * Additional text edits should be used to change text unrelated to the current cursor position
         * (for example adding an import statement at the top of the file if the completion item will
         * insert an unqualified type).
         */
        std::optional<std::vector<TextEdit>> additionalTextEdits;
        /**
         * An optional set of characters that when pressed while this completion is active will accept it first and
         * then type that character. *Note* that all commit characters should have `length=1` and that superfluous
         * characters will be ignored.
         */
        std::optional<std::vector<string_t>> commitCharacters;
        /**
         * An optional {@link Command command} that is executed *after* inserting this completion. *Note* that
         * additional modifications to the current document should be described with the
         * {@link CompletionItem.additionalTextEdits additionalTextEdits}-property.
         */
        std::optional<Command> command;
        /**
         * A data entry field that is preserved on a completion item between a
         * {@link CompletionRequest} and a {@link CompletionResolveRequest}.
         */
        std::optional<LSPAny> data;
    }; // struct CompletionItem

    /**
     * Represents a collection of {@link CompletionItem completion items} to be presented
     * in the editor.
     */
    struct CompletionList {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CompletionList();
        CompletionList(CompletionList &&other);
        CompletionList(const CompletionList &other);
        ~CompletionList();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CompletionList &&other) -> CompletionList &;

        auto operator=(const CompletionList &other) -> CompletionList &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * This list it not complete. Further typing results in recomputing this list.
         *
         * Recomputed lists have all their items replaced (not appended) in the
         * incomplete completion sessions.
         */
        boolean_t isIncomplete;
        /**
         * In many cases the items of an actual completion result share the same
         * value for properties like `commitCharacters` or the range of a text
         * edit. A completion list can therefore define item defaults which will
         * be used if a completion item itself doesn't specify the value.
         *
         * If a completion list specifies a default value and a completion item
         * also specifies a corresponding value the one from the item is used.
         *
         * Servers are only allowed to return default values if the client
         * signals support for this via the `completionList.itemDefaults`
         * capability.
         *
         * @since 3.17.0
         */
        std::optional<CompletionList_itemDefaults> itemDefaults;
        /**
         * The completion items.
         */
        std::vector<CompletionItem> items;
    }; // struct CompletionList

    typedef std::vector<CompletionItem> CompletionList_items;

    typedef std::vector<LSPAny> Command_arguments;

    /**
     * A special workspace symbol that supports locations without a range.
     *
     * See also SymbolInformation.
     *
     * @since 3.17.0
     */
    struct WorkspaceSymbol
        : public BaseSymbolInformation
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceSymbol();
        WorkspaceSymbol(WorkspaceSymbol &&other);
        WorkspaceSymbol(const WorkspaceSymbol &other);
        ~WorkspaceSymbol();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(WorkspaceSymbol &&other) -> WorkspaceSymbol &;

        auto operator=(const WorkspaceSymbol &other) -> WorkspaceSymbol &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The location of the symbol. Whether a server is allowed to
         * return a location without a range depends on the client
         * capability `workspace.symbol.resolveSupport`.
         *
         * See SymbolInformation#location for more details.
         */
        WorkspaceSymbol_location location;
        /**
         * A data entry field that is preserved on a workspace symbol between a
         * workspace symbol request and a workspace symbol resolve request.
         */
        std::optional<LSPAny> data;
    }; // struct WorkspaceSymbol

    /**
     * A code lens represents a {@link Command command} that should be shown along with
     * source text, like the number of references, a way to run tests, etc.
     *
     * A code lens is _unresolved_ when no command is associated to it. For performance
     * reasons the creation of a code lens and resolving should be done in two stages.
     */
    struct CodeLens {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeLens();
        CodeLens(CodeLens &&other);
        CodeLens(const CodeLens &other);
        ~CodeLens();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CodeLens &&other) -> CodeLens &;

        auto operator=(const CodeLens &other) -> CodeLens &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The range in which this code lens is valid. Should only span a single line.
         */
        Range range;
        /**
         * The command this code lens represents.
         */
        std::optional<Command> command;
        /**
         * A data entry field that is preserved on a code lens item between
         * a {@link CodeLensRequest} and a {@link CodeLensResolveRequest}
         */
        std::optional<LSPAny> data;
    }; // struct CodeLens

    /**
     * A document link is a range in a text document that links to an internal or external resource, like another
     * text document or a web site.
     */
    struct DocumentLink {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentLink();
        DocumentLink(DocumentLink &&other);
        DocumentLink(const DocumentLink &other);
        ~DocumentLink();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(DocumentLink &&other) -> DocumentLink &;

        auto operator=(const DocumentLink &other) -> DocumentLink &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The range this link applies to.
         */
        Range range;
        /**
         * The uri this link points to. If missing a resolve request is sent later.
         */
        std::optional<URI> target;
        /**
         * The tooltip text when you hover over this link.
         *
         * If a tooltip is provided, is will be displayed in a string that includes instructions on how to
         * trigger the link, such as `{0} (ctrl + click)`. The specific instructions vary depending on OS,
         * user settings, and localization.
         *
         * @since 3.15.0
         */
        std::optional<string_t> tooltip;
        /**
         * A data entry field that is preserved on a document link between a
         * DocumentLinkRequest and a DocumentLinkResolveRequest.
         */
        std::optional<LSPAny> data;
    }; // struct DocumentLink

    /**
     * The parameters of a {@link ExecuteCommandRequest}.
     */
    struct ExecuteCommandParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ExecuteCommandParams();
        ExecuteCommandParams(ExecuteCommandParams &&other);
        ExecuteCommandParams(const ExecuteCommandParams &other);
        ~ExecuteCommandParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ExecuteCommandParams &&other) -> ExecuteCommandParams &;

        auto operator=(
            const ExecuteCommandParams &other
        ) -> ExecuteCommandParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The identifier of the actual command handler.
         */
        string_t command;
        /**
         * Arguments that the command should be invoked with.
         */
        std::optional<std::vector<LSPAny>> arguments;
    }; // struct ExecuteCommandParams

    typedef std::vector<LSPAny> ExecuteCommandParams_arguments;

    struct ProgressParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ProgressParams();
        ProgressParams(ProgressParams &&other);
        ProgressParams(const ProgressParams &other);
        ~ProgressParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ProgressParams &&other) -> ProgressParams &;

        auto operator=(const ProgressParams &other) -> ProgressParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The progress token provided by the client or server.
         */
        ProgressToken token;
        /**
         * The progress data.
         */
        LSPAny value;
    }; // struct ProgressParams

    /**
     * An inlay hint label part allows for interactive and composite labels
     * of inlay hints.
     *
     * @since 3.17.0
     */
    struct InlayHintLabelPart {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlayHintLabelPart();
        InlayHintLabelPart(InlayHintLabelPart &&other);
        InlayHintLabelPart(const InlayHintLabelPart &other);
        ~InlayHintLabelPart();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlayHintLabelPart &&other) -> InlayHintLabelPart &;

        auto operator=(
            const InlayHintLabelPart &other
        ) -> InlayHintLabelPart &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The value of this label part.
         */
        string_t value;
        /**
         * The tooltip text when you hover over this label part. Depending on
         * the client capability `inlayHint.resolveSupport` clients might resolve
         * this property late using the resolve request.
         */
        std::optional<InlayHintLabelPart_tooltip> tooltip;
        /**
         * An optional source code location that represents this
         * label part.
         *
         * The editor will use this location for the hover and for code navigation
         * features: This part will become a clickable link that resolves to the
         * definition of the symbol at the given location (not necessarily the
         * location itself), it shows the hover that shows at the given location,
         * and it shows a context menu with further code navigation commands.
         *
         * Depending on the client capability `inlayHint.resolveSupport` clients
         * might resolve this property late using the resolve request.
         */
        std::optional<Location> location;
        /**
         * An optional command for this label part.
         *
         * Depending on the client capability `inlayHint.resolveSupport` clients
         * might resolve this property late using the resolve request.
         */
        std::optional<Command> command;
    }; // struct InlayHintLabelPart

    enum class InlayHint_labelType {
        Uninitialized = -1,
        String = 0,
        InlayHintLabelPartArray = 1,
    }; // enum class InlayHint_labelType

    extern const std::map<InlayHint_labelType, std::string>
        InlayHint_labelTypeNames;

    class InlayHint_label {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlayHint_label();
        InlayHint_label(InlayHint_label &&other);
        InlayHint_label(const InlayHint_label &other);
        ~InlayHint_label();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlayHint_label &&other) -> InlayHint_label &;

        auto operator=(const InlayHint_label &other) -> InlayHint_label &;

        auto type() const -> const InlayHint_labelType &;

        auto string() const -> const string_t &;

        auto operator=(
            const std::unique_ptr<string_t> &string
        ) -> InlayHint_label &;

        auto operator=(
            std::unique_ptr<string_t> &&string
        ) -> InlayHint_label &;

        auto operator=(const string_t &string) -> InlayHint_label &;

        auto operator=(string_t &&string) -> InlayHint_label &;

        auto inlayHintLabelPartArray() const
        -> const std::vector<InlayHintLabelPart> &;

        auto operator=(
            const std::unique_ptr<std::vector<InlayHintLabelPart>> &inlayHintLabelPartArray
        ) -> InlayHint_label &;

        auto operator=(
            std::unique_ptr<std::vector<InlayHintLabelPart>> &&inlayHintLabelPartArray
        ) -> InlayHint_label &;

        auto operator=(
            const std::vector<InlayHintLabelPart> &inlayHintLabelPartArray
        ) -> InlayHint_label &;

        auto operator=(
            std::vector<InlayHintLabelPart> &&inlayHintLabelPartArray
        ) -> InlayHint_label &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        InlayHint_labelType _type{InlayHint_labelType::Uninitialized};

        union {
            std::unique_ptr<string_t> _string;
            std::unique_ptr<std::vector<InlayHintLabelPart>> _inlayHintLabelPartArray;
        };

        auto reset() -> void;
    }; // class InlayHint_label

    /**
     * Inlay hint information.
     *
     * @since 3.17.0
     */
    struct InlayHint {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InlayHint();
        InlayHint(InlayHint &&other);
        InlayHint(const InlayHint &other);
        ~InlayHint();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InlayHint &&other) -> InlayHint &;

        auto operator=(const InlayHint &other) -> InlayHint &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The position of this hint.
         *
         * If multiple hints have the same position, they will be shown in the order
         * they appear in the response.
         */
        Position position;
        /**
         * The label of this hint. A human readable string or an array of
         * InlayHintLabelPart label parts.
         *
         * *Note* that neither the string nor the label part can be empty.
         */
        InlayHint_label label;
        /**
         * The kind of this hint. Can be omitted in which case the client
         * should fall back to a reasonable default.
         */
        std::optional<InlayHintKind> kind;
        /**
         * Optional text edits that are performed when accepting this inlay hint.
         *
         * *Note* that edits are expected to change the document so that the inlay
         * hint (or its nearest variant) is now part of the document and the inlay
         * hint itself is now obsolete.
         */
        std::optional<std::vector<TextEdit>> textEdits;
        /**
         * The tooltip text when you hover over this item.
         */
        std::optional<InlayHint_tooltip> tooltip;
        /**
         * Render padding before the hint.
         *
         * Note: Padding should use the editor's background color, not the
         * background color of the hint itself. That means padding can be used
         * to visually align/separate an inlay hint.
         */
        std::optional<boolean_t> paddingLeft;
        /**
         * Render padding after the hint.
         *
         * Note: Padding should use the editor's background color, not the
         * background color of the hint itself. That means padding can be used
         * to visually align/separate an inlay hint.
         */
        std::optional<boolean_t> paddingRight;
        /**
         * A data entry field that is preserved on an inlay hint between
         * a `textDocument/inlayHint` and a `inlayHint/resolve` request.
         */
        std::optional<LSPAny> data;
    }; // struct InlayHint

    typedef std::vector<InlayHintLabelPart> InlayHint_label_1;

    /**
     * General parameters to register for a notification or to register a provider.
     */
    struct Registration {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Registration();
        Registration(Registration &&other);
        Registration(const Registration &other);
        ~Registration();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Registration &&other) -> Registration &;

        auto operator=(const Registration &other) -> Registration &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The id used to register the request. The id can be used to deregister
         * the request again.
         */
        string_t id;
        /**
         * The method / capability to register for.
         */
        string_t method;
        /**
         * Options necessary for the registration.
         */
        std::optional<LSPAny> registerOptions;
    }; // struct Registration

    struct RegistrationParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RegistrationParams();
        RegistrationParams(RegistrationParams &&other);
        RegistrationParams(const RegistrationParams &other);
        ~RegistrationParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(RegistrationParams &&other) -> RegistrationParams &;

        auto operator=(
            const RegistrationParams &other
        ) -> RegistrationParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::vector<Registration> registrations;
    }; // struct RegistrationParams

    typedef std::vector<Registration> RegistrationParams_registrations;

    /**
     * Defines the capabilities provided by a language
     * server.
     */
    struct ServerCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ServerCapabilities();
        ServerCapabilities(ServerCapabilities &&other);
        ServerCapabilities(const ServerCapabilities &other);
        ~ServerCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ServerCapabilities &&other) -> ServerCapabilities &;

        auto operator=(
            const ServerCapabilities &other
        ) -> ServerCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The position encoding the server picked from the encodings offered
         * by the client via the client capability `general.positionEncodings`.
         *
         * If the client didn't provide any position encodings the only valid
         * value that a server can return is 'utf-16'.
         *
         * If omitted it defaults to 'utf-16'.
         *
         * @since 3.17.0
         */
        std::optional<PositionEncodingKind> positionEncoding;
        /**
         * Defines how text documents are synced. Is either a detailed structure
         * defining each notification or for backwards compatibility the
         * TextDocumentSyncKind number.
         */
        std::optional<ServerCapabilities_textDocumentSync> textDocumentSync;
        /**
         * Defines how notebook documents are synced.
         *
         * @since 3.17.0
         */
        std::optional<ServerCapabilities_notebookDocumentSync>
            notebookDocumentSync;
        /**
         * The server provides completion support.
         */
        std::optional<CompletionOptions> completionProvider;
        /**
         * The server provides hover support.
         */
        std::optional<ServerCapabilities_hoverProvider> hoverProvider;
        /**
         * The server provides signature help support.
         */
        std::optional<SignatureHelpOptions> signatureHelpProvider;
        /**
         * The server provides Goto Declaration support.
         */
        std::optional<ServerCapabilities_declarationProvider>
            declarationProvider;
        /**
         * The server provides goto definition support.
         */
        std::optional<ServerCapabilities_definitionProvider>
            definitionProvider;
        /**
         * The server provides Goto Type Definition support.
         */
        std::optional<ServerCapabilities_typeDefinitionProvider>
            typeDefinitionProvider;
        /**
         * The server provides Goto Implementation support.
         */
        std::optional<ServerCapabilities_implementationProvider>
            implementationProvider;
        /**
         * The server provides find references support.
         */
        std::optional<ServerCapabilities_referencesProvider>
            referencesProvider;
        /**
         * The server provides document highlight support.
         */
        std::optional<ServerCapabilities_documentHighlightProvider>
            documentHighlightProvider;
        /**
         * The server provides document symbol support.
         */
        std::optional<ServerCapabilities_documentSymbolProvider>
            documentSymbolProvider;
        /**
         * The server provides code actions. CodeActionOptions may only be
         * specified if the client states that it supports
         * `codeActionLiteralSupport` in its initial `initialize` request.
         */
        std::optional<ServerCapabilities_codeActionProvider>
            codeActionProvider;
        /**
         * The server provides code lens.
         */
        std::optional<CodeLensOptions> codeLensProvider;
        /**
         * The server provides document link support.
         */
        std::optional<DocumentLinkOptions> documentLinkProvider;
        /**
         * The server provides color provider support.
         */
        std::optional<ServerCapabilities_colorProvider> colorProvider;
        /**
         * The server provides workspace symbol support.
         */
        std::optional<ServerCapabilities_workspaceSymbolProvider>
            workspaceSymbolProvider;
        /**
         * The server provides document formatting.
         */
        std::optional<ServerCapabilities_documentFormattingProvider>
            documentFormattingProvider;
        /**
         * The server provides document range formatting.
         */
        std::optional<ServerCapabilities_documentRangeFormattingProvider>
            documentRangeFormattingProvider;
        /**
         * The server provides document formatting on typing.
         */
        std::optional<DocumentOnTypeFormattingOptions>
            documentOnTypeFormattingProvider;
        /**
         * The server provides rename support. RenameOptions may only be
         * specified if the client states that it supports
         * `prepareSupport` in its initial `initialize` request.
         */
        std::optional<ServerCapabilities_renameProvider> renameProvider;
        /**
         * The server provides folding provider support.
         */
        std::optional<ServerCapabilities_foldingRangeProvider>
            foldingRangeProvider;
        /**
         * The server provides selection range support.
         */
        std::optional<ServerCapabilities_selectionRangeProvider>
            selectionRangeProvider;
        /**
         * The server provides execute command support.
         */
        std::optional<ExecuteCommandOptions> executeCommandProvider;
        /**
         * The server provides call hierarchy support.
         *
         * @since 3.16.0
         */
        std::optional<ServerCapabilities_callHierarchyProvider>
            callHierarchyProvider;
        /**
         * The server provides linked editing range support.
         *
         * @since 3.16.0
         */
        std::optional<ServerCapabilities_linkedEditingRangeProvider>
            linkedEditingRangeProvider;
        /**
         * The server provides semantic tokens support.
         *
         * @since 3.16.0
         */
        std::optional<ServerCapabilities_semanticTokensProvider>
            semanticTokensProvider;
        /**
         * The server provides moniker support.
         *
         * @since 3.16.0
         */
        std::optional<ServerCapabilities_monikerProvider> monikerProvider;
        /**
         * The server provides type hierarchy support.
         *
         * @since 3.17.0
         */
        std::optional<ServerCapabilities_typeHierarchyProvider>
            typeHierarchyProvider;
        /**
         * The server provides inline values.
         *
         * @since 3.17.0
         */
        std::optional<ServerCapabilities_inlineValueProvider>
            inlineValueProvider;
        /**
         * The server provides inlay hints.
         *
         * @since 3.17.0
         */
        std::optional<ServerCapabilities_inlayHintProvider> inlayHintProvider;
        /**
         * The server has support for pull model diagnostics.
         *
         * @since 3.17.0
         */
        std::optional<ServerCapabilities_diagnosticProvider>
            diagnosticProvider;
        /**
         * Inline completion options used during static registration.
         *
         * @since 3.18.0
         * @proposed
         */
        std::optional<ServerCapabilities_inlineCompletionProvider>
            inlineCompletionProvider;
        /**
         * Workspace specific server capabilities.
         */
        std::optional<ServerCapabilities_workspace> workspace;
        /**
         * Experimental server capabilities.
         */
        std::optional<LSPAny> experimental;
    }; // struct ServerCapabilities

    /**
     * The result returned from an initialize request.
     */
    struct InitializeResult {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InitializeResult();
        InitializeResult(InitializeResult &&other);
        InitializeResult(const InitializeResult &other);
        ~InitializeResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InitializeResult &&other) -> InitializeResult &;

        auto operator=(const InitializeResult &other) -> InitializeResult &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The capabilities the language server provides.
         */
        ServerCapabilities capabilities;
        /**
         * Information about the server.
         *
         * @since 3.15.0
         */
        std::optional<InitializeResult_serverInfo> serverInfo;
    }; // struct InitializeResult

    /**
     * Represents a diagnostic, such as a compiler error or warning. Diagnostic objects
     * are only valid in the scope of a resource.
     */
    struct Diagnostic {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Diagnostic();
        Diagnostic(Diagnostic &&other);
        Diagnostic(const Diagnostic &other);
        ~Diagnostic();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(Diagnostic &&other) -> Diagnostic &;

        auto operator=(const Diagnostic &other) -> Diagnostic &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The range at which the message applies
         */
        Range range;
        /**
         * The diagnostic's severity. Can be omitted. If omitted it is up to the
         * client to interpret diagnostics as error, warning, info or hint.
         */
        std::optional<DiagnosticSeverity> severity;
        /**
         * The diagnostic's code, which usually appear in the user interface.
         */
        std::optional<Diagnostic_code> code;
        /**
         * An optional property to describe the error code.
         * Requires the code field (above) to be present/not null.
         *
         * @since 3.16.0
         */
        std::optional<CodeDescription> codeDescription;
        /**
         * A human-readable string describing the source of this
         * diagnostic, e.g. 'typescript' or 'super lint'. It usually
         * appears in the user interface.
         */
        std::optional<string_t> source;
        /**
         * The diagnostic's message. It usually appears in the user interface
         */
        string_t message;
        /**
         * Additional metadata about the diagnostic.
         *
         * @since 3.15.0
         */
        std::optional<std::vector<DiagnosticTag>> tags;
        /**
         * An array of related diagnostic information, e.g. when symbol-names within
         * a scope collide all definitions can be marked via this property.
         */
        std::optional<std::vector<DiagnosticRelatedInformation>>
            relatedInformation;
        /**
         * A data entry field that is preserved between a `textDocument/publishDiagnostics`
         * notification and `textDocument/codeAction` request.
         *
         * @since 3.16.0
         */
        std::optional<LSPAny> data;
    }; // struct Diagnostic

    /**
     * The publish diagnostic notification's parameters.
     */
    struct PublishDiagnosticsParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        PublishDiagnosticsParams();
        PublishDiagnosticsParams(PublishDiagnosticsParams &&other);
        PublishDiagnosticsParams(const PublishDiagnosticsParams &other);
        ~PublishDiagnosticsParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            PublishDiagnosticsParams &&other
        ) -> PublishDiagnosticsParams &;

        auto operator=(
            const PublishDiagnosticsParams &other
        ) -> PublishDiagnosticsParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The URI for which diagnostic information is reported.
         */
        DocumentUri uri;
        /**
         * Optional the version number of the document the diagnostics are published for.
         *
         * @since 3.15.0
         */
        std::optional<integer_t> version;
        /**
         * An array of diagnostic information items.
         */
        std::vector<Diagnostic> diagnostics;
    }; // struct PublishDiagnosticsParams

    typedef std::vector<Diagnostic> PublishDiagnosticsParams_diagnostics;

    /**
     * A code action represents a change that can be performed in code, e.g. to fix a problem or
     * to refactor code.
     *
     * A CodeAction must set either `edit` and/or a `command`. If both are supplied, the `edit` is applied first, then the `command` is executed.
     */
    struct CodeAction {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeAction();
        CodeAction(CodeAction &&other);
        CodeAction(const CodeAction &other);
        ~CodeAction();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CodeAction &&other) -> CodeAction &;

        auto operator=(const CodeAction &other) -> CodeAction &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A short, human-readable, title for this code action.
         */
        string_t title;
        /**
         * The kind of the code action.
         *
         * Used to filter code actions.
         */
        std::optional<CodeActionKind> kind;
        /**
         * The diagnostics that this code action resolves.
         */
        std::optional<std::vector<Diagnostic>> diagnostics;
        /**
         * Marks this as a preferred action. Preferred actions are used by the `auto fix` command and can be targeted
         * by keybindings.
         *
         * A quick fix should be marked preferred if it properly addresses the underlying error.
         * A refactoring should be marked preferred if it is the most reasonable choice of actions to take.
         *
         * @since 3.15.0
         */
        std::optional<boolean_t> isPreferred;
        /**
         * Marks that the code action cannot currently be applied.
         *
         * Clients should follow the following guidelines regarding disabled code actions:
         *
         *   - Disabled code actions are not shown in automatic [lightbulbs](https://code.visualstudio.com/docs/editor/editingevolved#_code-action)
         *     code action menus.
         *
         *   - Disabled actions are shown as faded out in the code action menu when the user requests a more specific type
         *     of code action, such as refactorings.
         *
         *   - If the user has a [keybinding](https://code.visualstudio.com/docs/editor/refactoring#_keybindings-for-code-actions)
         *     that auto applies a code action and only disabled code actions are returned, the client should show the user an
         *     error message with `reason` in the editor.
         *
         * @since 3.16.0
         */
        std::optional<CodeAction_disabled> disabled;
        /**
         * The workspace edit this code action performs.
         */
        std::optional<WorkspaceEdit> edit;
        /**
         * A command this code action executes. If a code action
         * provides an edit and a command, first the edit is
         * executed and then the command.
         */
        std::optional<Command> command;
        /**
         * A data entry field that is preserved on a code action between
         * a `textDocument/codeAction` and a `codeAction/resolve` request.
         *
         * @since 3.16.0
         */
        std::optional<LSPAny> data;
    }; // struct CodeAction

    typedef std::vector<Diagnostic> CodeAction_diagnostics;

    /**
     * A diagnostic report with a full set of problems.
     *
     * @since 3.17.0
     */
    struct FullDocumentDiagnosticReport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        FullDocumentDiagnosticReport();
        FullDocumentDiagnosticReport(FullDocumentDiagnosticReport &&other);
        FullDocumentDiagnosticReport(
            const FullDocumentDiagnosticReport &other
        );
        ~FullDocumentDiagnosticReport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            FullDocumentDiagnosticReport &&other
        ) -> FullDocumentDiagnosticReport &;

        auto operator=(
            const FullDocumentDiagnosticReport &other
        ) -> FullDocumentDiagnosticReport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A full document diagnostic report.
         */
        string_t kind;
        /**
         * An optional result id. If provided it will
         * be sent on the next diagnostic request for the
         * same document.
         */
        std::optional<string_t> resultId;
        /**
         * The actual items.
         */
        std::vector<Diagnostic> items;
    }; // struct FullDocumentDiagnosticReport

    enum class DocumentDiagnosticReportPartialResult_relatedDocuments_valueType {
        Uninitialized = -1,
        FullDocumentDiagnosticReport = 0,
        UnchangedDocumentDiagnosticReport = 1,
    }; // enum class DocumentDiagnosticReportPartialResult_relatedDocuments_valueType

    extern const std::map<
        DocumentDiagnosticReportPartialResult_relatedDocuments_valueType,
        std::string
    > DocumentDiagnosticReportPartialResult_relatedDocuments_valueTypeNames;

    class DocumentDiagnosticReportPartialResult_relatedDocuments_value {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentDiagnosticReportPartialResult_relatedDocuments_value();
        DocumentDiagnosticReportPartialResult_relatedDocuments_value(
            DocumentDiagnosticReportPartialResult_relatedDocuments_value &&other
        );
        DocumentDiagnosticReportPartialResult_relatedDocuments_value(
            const DocumentDiagnosticReportPartialResult_relatedDocuments_value &other
        );
        ~DocumentDiagnosticReportPartialResult_relatedDocuments_value();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentDiagnosticReportPartialResult_relatedDocuments_value &&other
        ) -> DocumentDiagnosticReportPartialResult_relatedDocuments_value &;

        auto operator=(
            const DocumentDiagnosticReportPartialResult_relatedDocuments_value &other
        ) -> DocumentDiagnosticReportPartialResult_relatedDocuments_value &;

        auto type() const
        -> const DocumentDiagnosticReportPartialResult_relatedDocuments_valueType &;

        auto fullDocumentDiagnosticReport() const
        -> const FullDocumentDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<FullDocumentDiagnosticReport> &fullDocumentDiagnosticReport
        ) -> DocumentDiagnosticReportPartialResult_relatedDocuments_value &;

        auto operator=(
            std::unique_ptr<FullDocumentDiagnosticReport> &&fullDocumentDiagnosticReport
        ) -> DocumentDiagnosticReportPartialResult_relatedDocuments_value &;

        auto operator=(
            const FullDocumentDiagnosticReport &fullDocumentDiagnosticReport
        ) -> DocumentDiagnosticReportPartialResult_relatedDocuments_value &;

        auto operator=(
            FullDocumentDiagnosticReport &&fullDocumentDiagnosticReport
        ) -> DocumentDiagnosticReportPartialResult_relatedDocuments_value &;

        auto unchangedDocumentDiagnosticReport() const
        -> const UnchangedDocumentDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<UnchangedDocumentDiagnosticReport> &unchangedDocumentDiagnosticReport
        ) -> DocumentDiagnosticReportPartialResult_relatedDocuments_value &;

        auto operator=(
            std::unique_ptr<UnchangedDocumentDiagnosticReport> &&unchangedDocumentDiagnosticReport
        ) -> DocumentDiagnosticReportPartialResult_relatedDocuments_value &;

        auto operator=(
            const UnchangedDocumentDiagnosticReport &unchangedDocumentDiagnosticReport
        ) -> DocumentDiagnosticReportPartialResult_relatedDocuments_value &;

        auto operator=(
            UnchangedDocumentDiagnosticReport &&unchangedDocumentDiagnosticReport
        ) -> DocumentDiagnosticReportPartialResult_relatedDocuments_value &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        DocumentDiagnosticReportPartialResult_relatedDocuments_valueType _type{
            DocumentDiagnosticReportPartialResult_relatedDocuments_valueType::Uninitialized
        };

        union {
            std::unique_ptr<FullDocumentDiagnosticReport> _fullDocumentDiagnosticReport;
            std::unique_ptr<UnchangedDocumentDiagnosticReport> _unchangedDocumentDiagnosticReport;
        };

        auto reset() -> void;
    }; // class DocumentDiagnosticReportPartialResult_relatedDocuments_value

    /**
     * A partial result for a document diagnostic report.
     *
     * @since 3.17.0
     */
    struct DocumentDiagnosticReportPartialResult {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentDiagnosticReportPartialResult();
        DocumentDiagnosticReportPartialResult(
            DocumentDiagnosticReportPartialResult &&other
        );
        DocumentDiagnosticReportPartialResult(
            const DocumentDiagnosticReportPartialResult &other
        );
        ~DocumentDiagnosticReportPartialResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentDiagnosticReportPartialResult &&other
        ) -> DocumentDiagnosticReportPartialResult &;

        auto operator=(
            const DocumentDiagnosticReportPartialResult &other
        ) -> DocumentDiagnosticReportPartialResult &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::map<DocumentUri, DocumentDiagnosticReportPartialResult_relatedDocuments_value>
            relatedDocuments;
    }; // struct DocumentDiagnosticReportPartialResult

    typedef std::map<DocumentUri, DocumentDiagnosticReportPartialResult_relatedDocuments_value> DocumentDiagnosticReportPartialResult_relatedDocuments;

    enum class RelatedFullDocumentDiagnosticReport_relatedDocuments_valueType {
        Uninitialized = -1,
        FullDocumentDiagnosticReport = 0,
        UnchangedDocumentDiagnosticReport = 1,
    }; // enum class RelatedFullDocumentDiagnosticReport_relatedDocuments_valueType

    extern const std::map<
        RelatedFullDocumentDiagnosticReport_relatedDocuments_valueType,
        std::string
    > RelatedFullDocumentDiagnosticReport_relatedDocuments_valueTypeNames;

    class RelatedFullDocumentDiagnosticReport_relatedDocuments_value {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RelatedFullDocumentDiagnosticReport_relatedDocuments_value();
        RelatedFullDocumentDiagnosticReport_relatedDocuments_value(
            RelatedFullDocumentDiagnosticReport_relatedDocuments_value &&other
        );
        RelatedFullDocumentDiagnosticReport_relatedDocuments_value(
            const RelatedFullDocumentDiagnosticReport_relatedDocuments_value &other
        );
        ~RelatedFullDocumentDiagnosticReport_relatedDocuments_value();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            RelatedFullDocumentDiagnosticReport_relatedDocuments_value &&other
        ) -> RelatedFullDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            const RelatedFullDocumentDiagnosticReport_relatedDocuments_value &other
        ) -> RelatedFullDocumentDiagnosticReport_relatedDocuments_value &;

        auto type() const
        -> const RelatedFullDocumentDiagnosticReport_relatedDocuments_valueType &;

        auto fullDocumentDiagnosticReport() const
        -> const FullDocumentDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<FullDocumentDiagnosticReport> &fullDocumentDiagnosticReport
        ) -> RelatedFullDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            std::unique_ptr<FullDocumentDiagnosticReport> &&fullDocumentDiagnosticReport
        ) -> RelatedFullDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            const FullDocumentDiagnosticReport &fullDocumentDiagnosticReport
        ) -> RelatedFullDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            FullDocumentDiagnosticReport &&fullDocumentDiagnosticReport
        ) -> RelatedFullDocumentDiagnosticReport_relatedDocuments_value &;

        auto unchangedDocumentDiagnosticReport() const
        -> const UnchangedDocumentDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<UnchangedDocumentDiagnosticReport> &unchangedDocumentDiagnosticReport
        ) -> RelatedFullDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            std::unique_ptr<UnchangedDocumentDiagnosticReport> &&unchangedDocumentDiagnosticReport
        ) -> RelatedFullDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            const UnchangedDocumentDiagnosticReport &unchangedDocumentDiagnosticReport
        ) -> RelatedFullDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            UnchangedDocumentDiagnosticReport &&unchangedDocumentDiagnosticReport
        ) -> RelatedFullDocumentDiagnosticReport_relatedDocuments_value &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        RelatedFullDocumentDiagnosticReport_relatedDocuments_valueType _type{
            RelatedFullDocumentDiagnosticReport_relatedDocuments_valueType::Uninitialized
        };

        union {
            std::unique_ptr<FullDocumentDiagnosticReport> _fullDocumentDiagnosticReport;
            std::unique_ptr<UnchangedDocumentDiagnosticReport> _unchangedDocumentDiagnosticReport;
        };

        auto reset() -> void;
    }; // class RelatedFullDocumentDiagnosticReport_relatedDocuments_value

    /**
     * A full diagnostic report with a set of related documents.
     *
     * @since 3.17.0
     */
    struct RelatedFullDocumentDiagnosticReport
        : public FullDocumentDiagnosticReport
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RelatedFullDocumentDiagnosticReport();
        RelatedFullDocumentDiagnosticReport(
            RelatedFullDocumentDiagnosticReport &&other
        );
        RelatedFullDocumentDiagnosticReport(
            const RelatedFullDocumentDiagnosticReport &other
        );
        ~RelatedFullDocumentDiagnosticReport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            RelatedFullDocumentDiagnosticReport &&other
        ) -> RelatedFullDocumentDiagnosticReport &;

        auto operator=(
            const RelatedFullDocumentDiagnosticReport &other
        ) -> RelatedFullDocumentDiagnosticReport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Diagnostics of related documents. This information is useful
         * in programming languages where code in a file A can generate
         * diagnostics in a file B which A depends on. An example of
         * such a language is C/C++ where marco definitions in a file
         * a.cpp and result in errors in a header file b.hpp.
         *
         * @since 3.17.0
         */
        std::optional<
            std::map<DocumentUri, RelatedFullDocumentDiagnosticReport_relatedDocuments_value>
        > relatedDocuments;
    }; // struct RelatedFullDocumentDiagnosticReport

    typedef std::map<DocumentUri, RelatedFullDocumentDiagnosticReport_relatedDocuments_value> RelatedFullDocumentDiagnosticReport_relatedDocuments;

    enum class RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_valueType {
        Uninitialized = -1,
        FullDocumentDiagnosticReport = 0,
        UnchangedDocumentDiagnosticReport = 1,
    }; // enum class RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_valueType

    extern const std::map<
        RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_valueType,
        std::string
    > RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_valueTypeNames;

    class RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value();
        RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value(
            RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &&other
        );
        RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value(
            const RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &other
        );
        ~RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &&other
        ) -> RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            const RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &other
        ) -> RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &;

        auto type() const
        -> const RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_valueType &;

        auto fullDocumentDiagnosticReport() const
        -> const FullDocumentDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<FullDocumentDiagnosticReport> &fullDocumentDiagnosticReport
        ) -> RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            std::unique_ptr<FullDocumentDiagnosticReport> &&fullDocumentDiagnosticReport
        ) -> RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            const FullDocumentDiagnosticReport &fullDocumentDiagnosticReport
        ) -> RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            FullDocumentDiagnosticReport &&fullDocumentDiagnosticReport
        ) -> RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &;

        auto unchangedDocumentDiagnosticReport() const
        -> const UnchangedDocumentDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<UnchangedDocumentDiagnosticReport> &unchangedDocumentDiagnosticReport
        ) -> RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            std::unique_ptr<UnchangedDocumentDiagnosticReport> &&unchangedDocumentDiagnosticReport
        ) -> RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            const UnchangedDocumentDiagnosticReport &unchangedDocumentDiagnosticReport
        ) -> RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &;

        auto operator=(
            UnchangedDocumentDiagnosticReport &&unchangedDocumentDiagnosticReport
        ) -> RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_valueType _type{
            RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_valueType::Uninitialized
        };

        union {
            std::unique_ptr<FullDocumentDiagnosticReport> _fullDocumentDiagnosticReport;
            std::unique_ptr<UnchangedDocumentDiagnosticReport> _unchangedDocumentDiagnosticReport;
        };

        auto reset() -> void;
    }; // class RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value

    /**
     * An unchanged diagnostic report with a set of related documents.
     *
     * @since 3.17.0
     */
    struct RelatedUnchangedDocumentDiagnosticReport
        : public UnchangedDocumentDiagnosticReport
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RelatedUnchangedDocumentDiagnosticReport();
        RelatedUnchangedDocumentDiagnosticReport(
            RelatedUnchangedDocumentDiagnosticReport &&other
        );
        RelatedUnchangedDocumentDiagnosticReport(
            const RelatedUnchangedDocumentDiagnosticReport &other
        );
        ~RelatedUnchangedDocumentDiagnosticReport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            RelatedUnchangedDocumentDiagnosticReport &&other
        ) -> RelatedUnchangedDocumentDiagnosticReport &;

        auto operator=(
            const RelatedUnchangedDocumentDiagnosticReport &other
        ) -> RelatedUnchangedDocumentDiagnosticReport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Diagnostics of related documents. This information is useful
         * in programming languages where code in a file A can generate
         * diagnostics in a file B which A depends on. An example of
         * such a language is C/C++ where marco definitions in a file
         * a.cpp and result in errors in a header file b.hpp.
         *
         * @since 3.17.0
         */
        std::optional<
            std::map<DocumentUri, RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value>
        > relatedDocuments;
    }; // struct RelatedUnchangedDocumentDiagnosticReport

    typedef std::map<DocumentUri, RelatedUnchangedDocumentDiagnosticReport_relatedDocuments_value> RelatedUnchangedDocumentDiagnosticReport_relatedDocuments;

    typedef std::vector<Diagnostic> FullDocumentDiagnosticReport_items;

    /**
     * Contains additional diagnostic information about the context in which
     * a {@link CodeActionProvider.provideCodeActions code action} is run.
     */
    struct CodeActionContext {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeActionContext();
        CodeActionContext(CodeActionContext &&other);
        CodeActionContext(const CodeActionContext &other);
        ~CodeActionContext();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CodeActionContext &&other) -> CodeActionContext &;

        auto operator=(const CodeActionContext &other) -> CodeActionContext &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An array of diagnostics known on the client side overlapping the range provided to the
         * `textDocument/codeAction` request. They are provided so that the server knows which
         * errors are currently presented to the user for the given range. There is no guarantee
         * that these accurately reflect the error state of the resource. The primary parameter
         * to compute code actions is the provided range.
         */
        std::vector<Diagnostic> diagnostics;
        /**
         * Requested kind of actions to return.
         *
         * Actions not of this kind are filtered out by the client before being shown. So servers
         * can omit computing them.
         */
        std::optional<std::vector<CodeActionKind>> only;
        /**
         * The reason why code actions were requested.
         *
         * @since 3.17.0
         */
        std::optional<CodeActionTriggerKind> triggerKind;
    }; // struct CodeActionContext

    /**
     * The parameters of a {@link CodeActionRequest}.
     */
    struct CodeActionParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CodeActionParams();
        CodeActionParams(CodeActionParams &&other);
        CodeActionParams(const CodeActionParams &other);
        ~CodeActionParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(CodeActionParams &&other) -> CodeActionParams &;

        auto operator=(const CodeActionParams &other) -> CodeActionParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report partial results (e.g. streaming) to
         * the client.
         */
        std::optional<ProgressToken> partialResultToken;
        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The document in which the command was invoked.
         */
        TextDocumentIdentifier textDocument;
        /**
         * The range for which the command was invoked.
         */
        Range range;
        /**
         * Context carrying additional information.
         */
        CodeActionContext context;
    }; // struct CodeActionParams

    typedef std::vector<Diagnostic> CodeActionContext_diagnostics;

    /**
     * A full document diagnostic report for a workspace diagnostic result.
     *
     * @since 3.17.0
     */
    struct WorkspaceFullDocumentDiagnosticReport
        : public FullDocumentDiagnosticReport
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceFullDocumentDiagnosticReport();
        WorkspaceFullDocumentDiagnosticReport(
            WorkspaceFullDocumentDiagnosticReport &&other
        );
        WorkspaceFullDocumentDiagnosticReport(
            const WorkspaceFullDocumentDiagnosticReport &other
        );
        ~WorkspaceFullDocumentDiagnosticReport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceFullDocumentDiagnosticReport &&other
        ) -> WorkspaceFullDocumentDiagnosticReport &;

        auto operator=(
            const WorkspaceFullDocumentDiagnosticReport &other
        ) -> WorkspaceFullDocumentDiagnosticReport &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The URI for which diagnostic information is reported.
         */
        DocumentUri uri;
        /**
         * The version number for which the diagnostics are reported.
         * If the document is not marked as open `null` can be provided.
         */
        WorkspaceFullDocumentDiagnosticReport_version version;
    }; // struct WorkspaceFullDocumentDiagnosticReport

    /**
     * A notebook cell.
     *
     * A cell's document URI must be unique across ALL notebook
     * cells and can therefore be used to uniquely identify a
     * notebook cell or the cell's text document.
     *
     * @since 3.17.0
     */
    struct NotebookCell {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookCell();
        NotebookCell(NotebookCell &&other);
        NotebookCell(const NotebookCell &other);
        ~NotebookCell();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(NotebookCell &&other) -> NotebookCell &;

        auto operator=(const NotebookCell &other) -> NotebookCell &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The cell's kind
         */
        NotebookCellKind kind;
        /**
         * The URI of the cell's text document
         * content.
         */
        DocumentUri document;
        /**
         * Additional metadata stored with the cell.
         *
         * Note: should always be an object literal (e.g. LSPObject)
         */
        std::optional<LSPObject> metadata;
        /**
         * Additional execution summary information
         * if supported by the client.
         */
        std::optional<ExecutionSummary> executionSummary;
    }; // struct NotebookCell

    /**
     * A notebook document.
     *
     * @since 3.17.0
     */
    struct NotebookDocument {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocument();
        NotebookDocument(NotebookDocument &&other);
        NotebookDocument(const NotebookDocument &other);
        ~NotebookDocument();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(NotebookDocument &&other) -> NotebookDocument &;

        auto operator=(const NotebookDocument &other) -> NotebookDocument &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The notebook document's uri.
         */
        URI uri;
        /**
         * The type of the notebook.
         */
        string_t notebookType;
        /**
         * The version number of this document (it will increase after each
         * change, including undo/redo).
         */
        integer_t version;
        /**
         * Additional metadata stored with the notebook
         * document.
         *
         * Note: should always be an object literal (e.g. LSPObject)
         */
        std::optional<LSPObject> metadata;
        /**
         * The cells of a notebook.
         */
        std::vector<NotebookCell> cells;
    }; // struct NotebookDocument

    /**
     * The params sent in an open notebook document notification.
     *
     * @since 3.17.0
     */
    struct DidOpenNotebookDocumentParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidOpenNotebookDocumentParams();
        DidOpenNotebookDocumentParams(DidOpenNotebookDocumentParams &&other);
        DidOpenNotebookDocumentParams(
            const DidOpenNotebookDocumentParams &other
        );
        ~DidOpenNotebookDocumentParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidOpenNotebookDocumentParams &&other
        ) -> DidOpenNotebookDocumentParams &;

        auto operator=(
            const DidOpenNotebookDocumentParams &other
        ) -> DidOpenNotebookDocumentParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The notebook document that got opened.
         */
        NotebookDocument notebookDocument;
        /**
         * The text documents that represent the content
         * of a notebook cell.
         */
        std::vector<TextDocumentItem> cellTextDocuments;
    }; // struct DidOpenNotebookDocumentParams

    typedef std::vector<NotebookCell> NotebookDocument_cells;

    typedef std::vector<NotebookCell> NotebookDocumentChangeEvent_cells_data;

    /**
     * A change describing how to move a `NotebookCell`
     * array from state S to S'.
     *
     * @since 3.17.0
     */
    struct NotebookCellArrayChange {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookCellArrayChange();
        NotebookCellArrayChange(NotebookCellArrayChange &&other);
        NotebookCellArrayChange(const NotebookCellArrayChange &other);
        ~NotebookCellArrayChange();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookCellArrayChange &&other
        ) -> NotebookCellArrayChange &;

        auto operator=(
            const NotebookCellArrayChange &other
        ) -> NotebookCellArrayChange &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The start oftest of the cell that changed.
         */
        uinteger_t start;
        /**
         * The deleted cells
         */
        uinteger_t deleteCount;
        /**
         * The new cells, if any
         */
        std::optional<std::vector<NotebookCell>> cells;
    }; // struct NotebookCellArrayChange

    struct NotebookDocumentChangeEvent_cells_structure {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentChangeEvent_cells_structure();
        NotebookDocumentChangeEvent_cells_structure(
            NotebookDocumentChangeEvent_cells_structure &&other
        );
        NotebookDocumentChangeEvent_cells_structure(
            const NotebookDocumentChangeEvent_cells_structure &other
        );
        ~NotebookDocumentChangeEvent_cells_structure();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentChangeEvent_cells_structure &&other
        ) -> NotebookDocumentChangeEvent_cells_structure &;

        auto operator=(
            const NotebookDocumentChangeEvent_cells_structure &other
        ) -> NotebookDocumentChangeEvent_cells_structure &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The change to the cell array.
         */
        NotebookCellArrayChange array;
        /**
         * Additional opened cell text documents.
         */
        std::optional<std::vector<TextDocumentItem>> didOpen;
        /**
         * Additional closed cell text documents.
         */
        std::optional<std::vector<TextDocumentIdentifier>> didClose;
    }; // struct NotebookDocumentChangeEvent_cells_structure

    struct NotebookDocumentChangeEvent_cells {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentChangeEvent_cells();
        NotebookDocumentChangeEvent_cells(
            NotebookDocumentChangeEvent_cells &&other
        );
        NotebookDocumentChangeEvent_cells(
            const NotebookDocumentChangeEvent_cells &other
        );
        ~NotebookDocumentChangeEvent_cells();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentChangeEvent_cells &&other
        ) -> NotebookDocumentChangeEvent_cells &;

        auto operator=(
            const NotebookDocumentChangeEvent_cells &other
        ) -> NotebookDocumentChangeEvent_cells &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Changes to the cell structure to add or
         * remove cells.
         */
        std::optional<NotebookDocumentChangeEvent_cells_structure> structure;
        /**
         * Changes to notebook cells properties like its
         * kind, execution summary or metadata.
         */
        std::optional<std::vector<NotebookCell>> data;
        /**
         * Changes to the text content of notebook cells.
         */
        std::optional<
            std::vector<NotebookDocumentChangeEvent_cells_textContent_elem>
        > textContent;
    }; // struct NotebookDocumentChangeEvent_cells

    /**
     * A change event for a notebook document.
     *
     * @since 3.17.0
     */
    struct NotebookDocumentChangeEvent {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotebookDocumentChangeEvent();
        NotebookDocumentChangeEvent(NotebookDocumentChangeEvent &&other);
        NotebookDocumentChangeEvent(const NotebookDocumentChangeEvent &other);
        ~NotebookDocumentChangeEvent();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            NotebookDocumentChangeEvent &&other
        ) -> NotebookDocumentChangeEvent &;

        auto operator=(
            const NotebookDocumentChangeEvent &other
        ) -> NotebookDocumentChangeEvent &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The changed meta data if any.
         *
         * Note: should always be an object literal (e.g. LSPObject)
         */
        std::optional<LSPObject> metadata;
        /**
         * Changes to cells
         */
        std::optional<NotebookDocumentChangeEvent_cells> cells;
    }; // struct NotebookDocumentChangeEvent

    /**
     * The params sent in a change notebook document notification.
     *
     * @since 3.17.0
     */
    struct DidChangeNotebookDocumentParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DidChangeNotebookDocumentParams();
        DidChangeNotebookDocumentParams(
            DidChangeNotebookDocumentParams &&other
        );
        DidChangeNotebookDocumentParams(
            const DidChangeNotebookDocumentParams &other
        );
        ~DidChangeNotebookDocumentParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DidChangeNotebookDocumentParams &&other
        ) -> DidChangeNotebookDocumentParams &;

        auto operator=(
            const DidChangeNotebookDocumentParams &other
        ) -> DidChangeNotebookDocumentParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The notebook document that did change. The version number points
         * to the version after all provided changes have been applied. If
         * only the text document content of a cell changes the notebook version
         * doesn't necessarily have to change.
         */
        VersionedNotebookDocumentIdentifier notebookDocument;
        /**
         * The actual changes to the notebook document.
         *
         * The changes describe single state changes to the notebook document.
         * So if there are two changes c1 (at array index 0) and c2 (at array
         * index 1) for a notebook in state S then c1 moves the notebook from
         * S to S' and c2 from S' to S''. So c1 is computed on the state S and
         * c2 is computed on the state S'.
         *
         * To mirror the content of a notebook using change events use the following approach:
         * - start with the same initial content
         * - apply the 'notebookDocument/didChange' notifications in the order you receive them.
         * - apply the `NotebookChangeEvent`s in a single notification in the order
         *   you receive them.
         */
        NotebookDocumentChangeEvent change;
    }; // struct DidChangeNotebookDocumentParams

    typedef std::vector<NotebookCell> NotebookCellArrayChange_cells;

    /**
     * Defines the capabilities provided by the client.
     */
    struct ClientCapabilities {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ClientCapabilities();
        ClientCapabilities(ClientCapabilities &&other);
        ClientCapabilities(const ClientCapabilities &other);
        ~ClientCapabilities();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ClientCapabilities &&other) -> ClientCapabilities &;

        auto operator=(
            const ClientCapabilities &other
        ) -> ClientCapabilities &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * Workspace specific client capabilities.
         */
        std::optional<WorkspaceClientCapabilities> workspace;
        /**
         * Text document specific client capabilities.
         */
        std::optional<TextDocumentClientCapabilities> textDocument;
        /**
         * Capabilities specific to the notebook document support.
         *
         * @since 3.17.0
         */
        std::optional<NotebookDocumentClientCapabilities> notebookDocument;
        /**
         * Window specific client capabilities.
         */
        std::optional<WindowClientCapabilities> window;
        /**
         * General client capabilities.
         *
         * @since 3.16.0
         */
        std::optional<GeneralClientCapabilities> general;
        /**
         * Experimental client capabilities.
         */
        std::optional<LSPAny> experimental;
    }; // struct ClientCapabilities

    /**
     * The initialize parameters
     */
    struct _InitializeParams {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        _InitializeParams();
        _InitializeParams(_InitializeParams &&other);
        _InitializeParams(const _InitializeParams &other);
        ~_InitializeParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(_InitializeParams &&other) -> _InitializeParams &;

        auto operator=(const _InitializeParams &other) -> _InitializeParams &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * An optional token that a server can use to report work done progress.
         */
        std::optional<ProgressToken> workDoneToken;
        /**
         * The process Id of the parent process that started
         * the server.
         *
         * Is `null` if the process has not been started by another process.
         * If the parent process is not alive then the server should exit.
         */
        _InitializeParams_processId processId;
        /**
         * Information about the client
         *
         * @since 3.15.0
         */
        std::optional<_InitializeParams_clientInfo> clientInfo;
        /**
         * The locale the client is currently showing the user interface
         * in. This must not necessarily be the locale of the operating
         * system.
         *
         * Uses IETF language tags as the value's syntax
         * (See https://en.wikipedia.org/wiki/IETF_language_tag)
         *
         * @since 3.16.0
         */
        std::optional<string_t> locale;
        /**
         * The rootPath of the workspace. Is null
         * if no folder is open.
         *
         * @deprecated in favour of rootUri.
         */
        std::optional<_InitializeParams_rootPath> rootPath;
        /**
         * The rootUri of the workspace. Is null if no
         * folder is open. If both `rootPath` and `rootUri` are set
         * `rootUri` wins.
         *
         * @deprecated in favour of workspaceFolders.
         */
        _InitializeParams_rootUri rootUri;
        /**
         * The capabilities provided by the client (editor or tool)
         */
        ClientCapabilities capabilities;
        /**
         * User provided initialization options.
         */
        std::optional<LSPAny> initializationOptions;
        /**
         * The initial trace setting. If omitted trace is disabled ('off').
         */
        std::optional<TraceValues> trace;
    }; // struct _InitializeParams

    struct InitializeParams
        : public _InitializeParams
        , public WorkspaceFoldersInitializeParams
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        InitializeParams();
        InitializeParams(InitializeParams &&other);
        InitializeParams(const InitializeParams &other);
        ~InitializeParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(InitializeParams &&other) -> InitializeParams &;

        auto operator=(const InitializeParams &other) -> InitializeParams &;
    }; // struct InitializeParams

    struct ResponseError {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ResponseError();
        ResponseError(ResponseError &&other);
        ResponseError(const ResponseError &other);
        ~ResponseError();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ResponseError &&other) -> ResponseError &;

        auto operator=(const ResponseError &other) -> ResponseError &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * A number indicating the error type that occurred.
         */
        integer_t code;
        /**
         * A string providing a short description of the error.
         */
        string_t message;
        /**
         * A primitive or structured value that contains additional information about
         * the error. Can be omitted.
         */
        std::optional<LSPAny> data;
    }; // struct ResponseError

    /**
     * A Response Message sent as a result of a request. If a request doesn’t
     * provide a result value the receiver of a request still needs to return a
     * response message to conform to the JSON-RPC specification. The result
     * property of the ResponseMessage should be set to null in this case to signal
     * a successful request.
     */
    struct ResponseMessage
        : public Message
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        ResponseMessage();
        ResponseMessage(ResponseMessage &&other);
        ResponseMessage(const ResponseMessage &other);
        ~ResponseMessage();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(ResponseMessage &&other) -> ResponseMessage &;

        auto operator=(const ResponseMessage &other) -> ResponseMessage &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The request id.
         */
        ResponseId id;
        /**
         * The result of a request. This member is REQUIRED on success. This member
         * MUST NOT exist if there was an error invoking the method.
         */
        std::optional<LSPAny> result;
        /**
         * The error object in case a request fails.
         */
        std::optional<ResponseError> error;
    }; // struct ResponseMessage

    enum class DocumentDiagnosticReportType {
        Uninitialized = -1,
        RelatedFullDocumentDiagnosticReport = 0,
        RelatedUnchangedDocumentDiagnosticReport = 1,
    }; // enum class DocumentDiagnosticReportType

    extern const std::map<DocumentDiagnosticReportType, std::string>
        DocumentDiagnosticReportTypeNames;

    class DocumentDiagnosticReport {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        DocumentDiagnosticReport();
        DocumentDiagnosticReport(DocumentDiagnosticReport &&other);
        DocumentDiagnosticReport(const DocumentDiagnosticReport &other);
        ~DocumentDiagnosticReport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            DocumentDiagnosticReport &&other
        ) -> DocumentDiagnosticReport &;

        auto operator=(
            const DocumentDiagnosticReport &other
        ) -> DocumentDiagnosticReport &;

        auto type() const -> const DocumentDiagnosticReportType &;

        auto relatedFullDocumentDiagnosticReport() const
        -> const RelatedFullDocumentDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<RelatedFullDocumentDiagnosticReport> &relatedFullDocumentDiagnosticReport
        ) -> DocumentDiagnosticReport &;

        auto operator=(
            std::unique_ptr<RelatedFullDocumentDiagnosticReport> &&relatedFullDocumentDiagnosticReport
        ) -> DocumentDiagnosticReport &;

        auto operator=(
            const RelatedFullDocumentDiagnosticReport &relatedFullDocumentDiagnosticReport
        ) -> DocumentDiagnosticReport &;

        auto operator=(
            RelatedFullDocumentDiagnosticReport &&relatedFullDocumentDiagnosticReport
        ) -> DocumentDiagnosticReport &;

        auto relatedUnchangedDocumentDiagnosticReport() const
        -> const RelatedUnchangedDocumentDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<RelatedUnchangedDocumentDiagnosticReport> &relatedUnchangedDocumentDiagnosticReport
        ) -> DocumentDiagnosticReport &;

        auto operator=(
            std::unique_ptr<RelatedUnchangedDocumentDiagnosticReport> &&relatedUnchangedDocumentDiagnosticReport
        ) -> DocumentDiagnosticReport &;

        auto operator=(
            const RelatedUnchangedDocumentDiagnosticReport &relatedUnchangedDocumentDiagnosticReport
        ) -> DocumentDiagnosticReport &;

        auto operator=(
            RelatedUnchangedDocumentDiagnosticReport &&relatedUnchangedDocumentDiagnosticReport
        ) -> DocumentDiagnosticReport &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        DocumentDiagnosticReportType _type{
            DocumentDiagnosticReportType::Uninitialized
        };

        union {
            std::unique_ptr<RelatedFullDocumentDiagnosticReport> _relatedFullDocumentDiagnosticReport;
            std::unique_ptr<RelatedUnchangedDocumentDiagnosticReport> _relatedUnchangedDocumentDiagnosticReport;
        };

        auto reset() -> void;
    }; // class DocumentDiagnosticReport

    enum class WorkspaceDocumentDiagnosticReportType {
        Uninitialized = -1,
        WorkspaceFullDocumentDiagnosticReport = 0,
        WorkspaceUnchangedDocumentDiagnosticReport = 1,
    }; // enum class WorkspaceDocumentDiagnosticReportType

    extern const std::map<WorkspaceDocumentDiagnosticReportType, std::string>
        WorkspaceDocumentDiagnosticReportTypeNames;

    class WorkspaceDocumentDiagnosticReport {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceDocumentDiagnosticReport();
        WorkspaceDocumentDiagnosticReport(
            WorkspaceDocumentDiagnosticReport &&other
        );
        WorkspaceDocumentDiagnosticReport(
            const WorkspaceDocumentDiagnosticReport &other
        );
        ~WorkspaceDocumentDiagnosticReport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceDocumentDiagnosticReport &&other
        ) -> WorkspaceDocumentDiagnosticReport &;

        auto operator=(
            const WorkspaceDocumentDiagnosticReport &other
        ) -> WorkspaceDocumentDiagnosticReport &;

        auto type() const -> const WorkspaceDocumentDiagnosticReportType &;

        auto workspaceFullDocumentDiagnosticReport() const
        -> const WorkspaceFullDocumentDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<WorkspaceFullDocumentDiagnosticReport> &workspaceFullDocumentDiagnosticReport
        ) -> WorkspaceDocumentDiagnosticReport &;

        auto operator=(
            std::unique_ptr<WorkspaceFullDocumentDiagnosticReport> &&workspaceFullDocumentDiagnosticReport
        ) -> WorkspaceDocumentDiagnosticReport &;

        auto operator=(
            const WorkspaceFullDocumentDiagnosticReport &workspaceFullDocumentDiagnosticReport
        ) -> WorkspaceDocumentDiagnosticReport &;

        auto operator=(
            WorkspaceFullDocumentDiagnosticReport &&workspaceFullDocumentDiagnosticReport
        ) -> WorkspaceDocumentDiagnosticReport &;

        auto workspaceUnchangedDocumentDiagnosticReport() const
        -> const WorkspaceUnchangedDocumentDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<WorkspaceUnchangedDocumentDiagnosticReport> &workspaceUnchangedDocumentDiagnosticReport
        ) -> WorkspaceDocumentDiagnosticReport &;

        auto operator=(
            std::unique_ptr<WorkspaceUnchangedDocumentDiagnosticReport> &&workspaceUnchangedDocumentDiagnosticReport
        ) -> WorkspaceDocumentDiagnosticReport &;

        auto operator=(
            const WorkspaceUnchangedDocumentDiagnosticReport &workspaceUnchangedDocumentDiagnosticReport
        ) -> WorkspaceDocumentDiagnosticReport &;

        auto operator=(
            WorkspaceUnchangedDocumentDiagnosticReport &&workspaceUnchangedDocumentDiagnosticReport
        ) -> WorkspaceDocumentDiagnosticReport &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        WorkspaceDocumentDiagnosticReportType _type{
            WorkspaceDocumentDiagnosticReportType::Uninitialized
        };

        union {
            std::unique_ptr<WorkspaceFullDocumentDiagnosticReport> _workspaceFullDocumentDiagnosticReport;
            std::unique_ptr<WorkspaceUnchangedDocumentDiagnosticReport> _workspaceUnchangedDocumentDiagnosticReport;
        };

        auto reset() -> void;
    }; // class WorkspaceDocumentDiagnosticReport

    /**
     * A workspace diagnostic report.
     *
     * @since 3.17.0
     */
    struct WorkspaceDiagnosticReport {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceDiagnosticReport();
        WorkspaceDiagnosticReport(WorkspaceDiagnosticReport &&other);
        WorkspaceDiagnosticReport(const WorkspaceDiagnosticReport &other);
        ~WorkspaceDiagnosticReport();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceDiagnosticReport &&other
        ) -> WorkspaceDiagnosticReport &;

        auto operator=(
            const WorkspaceDiagnosticReport &other
        ) -> WorkspaceDiagnosticReport &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::vector<WorkspaceDocumentDiagnosticReport> items;
    }; // struct WorkspaceDiagnosticReport

    typedef std::vector<WorkspaceDocumentDiagnosticReport> WorkspaceDiagnosticReport_items;

    /**
     * A partial result for a workspace diagnostic report.
     *
     * @since 3.17.0
     */
    struct WorkspaceDiagnosticReportPartialResult {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        WorkspaceDiagnosticReportPartialResult();
        WorkspaceDiagnosticReportPartialResult(
            WorkspaceDiagnosticReportPartialResult &&other
        );
        WorkspaceDiagnosticReportPartialResult(
            const WorkspaceDiagnosticReportPartialResult &other
        );
        ~WorkspaceDiagnosticReportPartialResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            WorkspaceDiagnosticReportPartialResult &&other
        ) -> WorkspaceDiagnosticReportPartialResult &;

        auto operator=(
            const WorkspaceDiagnosticReportPartialResult &other
        ) -> WorkspaceDiagnosticReportPartialResult &;

        // ================== //
        // Field Declarations //
        // ================== //

        std::vector<WorkspaceDocumentDiagnosticReport> items;
    }; // struct WorkspaceDiagnosticReportPartialResult

    typedef std::vector<WorkspaceDocumentDiagnosticReport> WorkspaceDiagnosticReportPartialResult_items;

    enum class MessageParamsType {
        Uninitialized = -1,
        Array = 0,
        Object = 1,
    }; // enum class MessageParamsType

    extern const std::map<MessageParamsType, std::string>
        MessageParamsTypeNames;

    class MessageParams {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        MessageParams();
        MessageParams(MessageParams &&other);
        MessageParams(const MessageParams &other);
        ~MessageParams();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(MessageParams &&other) -> MessageParams &;

        auto operator=(const MessageParams &other) -> MessageParams &;

        auto type() const -> const MessageParamsType &;

        auto array() const -> const LSPArray &;

        auto operator=(
            const std::unique_ptr<LSPArray> &array
        ) -> MessageParams &;

        auto operator=(std::unique_ptr<LSPArray> &&array) -> MessageParams &;

        auto operator=(const LSPArray &array) -> MessageParams &;

        auto operator=(LSPArray &&array) -> MessageParams &;

        auto object() const -> const LSPObject &;

        auto operator=(
            const std::unique_ptr<LSPObject> &object
        ) -> MessageParams &;

        auto operator=(std::unique_ptr<LSPObject> &&object) -> MessageParams &;

        auto operator=(const LSPObject &object) -> MessageParams &;

        auto operator=(LSPObject &&object) -> MessageParams &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        MessageParamsType _type{MessageParamsType::Uninitialized};

        union {
            std::unique_ptr<LSPArray> _array;
            std::unique_ptr<LSPObject> _object;
        };

        auto reset() -> void;
    }; // class MessageParams

    /**
     * A request message to describe a request between the client and the server.
     * Every processed request must send a response back to the sender of the
     * request.
     */
    struct RequestMessage
        : public Message
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        RequestMessage();
        RequestMessage(RequestMessage &&other);
        RequestMessage(const RequestMessage &other);
        ~RequestMessage();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(RequestMessage &&other) -> RequestMessage &;

        auto operator=(const RequestMessage &other) -> RequestMessage &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The request id.
         */
        RequestId id;
        /**
         * The method to be invoked.
         */
        string_t method;
        /**
         * The method's params.
         */
        std::optional<MessageParams> params;
    }; // struct RequestMessage

    struct NotificationMessage
        : public Message
    {
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        NotificationMessage();
        NotificationMessage(NotificationMessage &&other);
        NotificationMessage(const NotificationMessage &other);
        ~NotificationMessage();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(NotificationMessage &&other) -> NotificationMessage &;

        auto operator=(
            const NotificationMessage &other
        ) -> NotificationMessage &;

        // ================== //
        // Field Declarations //
        // ================== //

        /**
         * The method to be invoked.
         */
        string_t method;
        /**
         * The notification's params.
         */
        std::optional<MessageParams> params;
    }; // struct NotificationMessage

    typedef std::vector<LSPAny> Workspace_ConfigurationResult;

    enum class TextDocument_PrepareCallHierarchyResultType {
        Uninitialized = -1,
        CallHierarchyItemArray = 0,
        Null = 1,
    }; // enum class TextDocument_PrepareCallHierarchyResultType

    extern const std::map<
        TextDocument_PrepareCallHierarchyResultType,
        std::string
    > TextDocument_PrepareCallHierarchyResultTypeNames;

    class TextDocument_PrepareCallHierarchyResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_PrepareCallHierarchyResult();
        TextDocument_PrepareCallHierarchyResult(
            TextDocument_PrepareCallHierarchyResult &&other
        );
        TextDocument_PrepareCallHierarchyResult(
            const TextDocument_PrepareCallHierarchyResult &other
        );
        ~TextDocument_PrepareCallHierarchyResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_PrepareCallHierarchyResult &&other
        ) -> TextDocument_PrepareCallHierarchyResult &;

        auto operator=(
            const TextDocument_PrepareCallHierarchyResult &other
        ) -> TextDocument_PrepareCallHierarchyResult &;

        auto type() const
        -> const TextDocument_PrepareCallHierarchyResultType &;

        auto callHierarchyItemArray() const
        -> const std::vector<CallHierarchyItem> &;

        auto operator=(
            const std::unique_ptr<std::vector<CallHierarchyItem>> &callHierarchyItemArray
        ) -> TextDocument_PrepareCallHierarchyResult &;

        auto operator=(
            std::unique_ptr<std::vector<CallHierarchyItem>> &&callHierarchyItemArray
        ) -> TextDocument_PrepareCallHierarchyResult &;

        auto operator=(
            const std::vector<CallHierarchyItem> &callHierarchyItemArray
        ) -> TextDocument_PrepareCallHierarchyResult &;

        auto operator=(
            std::vector<CallHierarchyItem> &&callHierarchyItemArray
        ) -> TextDocument_PrepareCallHierarchyResult &;

        auto null() const -> const null_t &;

        auto operator=(
            null_t null
        ) -> TextDocument_PrepareCallHierarchyResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_PrepareCallHierarchyResultType _type{
            TextDocument_PrepareCallHierarchyResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<CallHierarchyItem>> _callHierarchyItemArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_PrepareCallHierarchyResult

    typedef std::vector<CallHierarchyItem> TextDocument_PrepareCallHierarchyResult_0;

    enum class CallHierarchy_IncomingCallsResultType {
        Uninitialized = -1,
        CallHierarchyIncomingCallArray = 0,
        Null = 1,
    }; // enum class CallHierarchy_IncomingCallsResultType

    extern const std::map<CallHierarchy_IncomingCallsResultType, std::string>
        CallHierarchy_IncomingCallsResultTypeNames;

    class CallHierarchy_IncomingCallsResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CallHierarchy_IncomingCallsResult();
        CallHierarchy_IncomingCallsResult(
            CallHierarchy_IncomingCallsResult &&other
        );
        CallHierarchy_IncomingCallsResult(
            const CallHierarchy_IncomingCallsResult &other
        );
        ~CallHierarchy_IncomingCallsResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CallHierarchy_IncomingCallsResult &&other
        ) -> CallHierarchy_IncomingCallsResult &;

        auto operator=(
            const CallHierarchy_IncomingCallsResult &other
        ) -> CallHierarchy_IncomingCallsResult &;

        auto type() const -> const CallHierarchy_IncomingCallsResultType &;

        auto callHierarchyIncomingCallArray() const
        -> const std::vector<CallHierarchyIncomingCall> &;

        auto operator=(
            const std::unique_ptr<std::vector<CallHierarchyIncomingCall>> &callHierarchyIncomingCallArray
        ) -> CallHierarchy_IncomingCallsResult &;

        auto operator=(
            std::unique_ptr<std::vector<CallHierarchyIncomingCall>> &&callHierarchyIncomingCallArray
        ) -> CallHierarchy_IncomingCallsResult &;

        auto operator=(
            const std::vector<CallHierarchyIncomingCall> &callHierarchyIncomingCallArray
        ) -> CallHierarchy_IncomingCallsResult &;

        auto operator=(
            std::vector<CallHierarchyIncomingCall> &&callHierarchyIncomingCallArray
        ) -> CallHierarchy_IncomingCallsResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> CallHierarchy_IncomingCallsResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        CallHierarchy_IncomingCallsResultType _type{
            CallHierarchy_IncomingCallsResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<CallHierarchyIncomingCall>> _callHierarchyIncomingCallArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class CallHierarchy_IncomingCallsResult

    typedef std::vector<CallHierarchyIncomingCall> CallHierarchy_IncomingCallsResult_0;

    enum class CallHierarchy_OutgoingCallsResultType {
        Uninitialized = -1,
        CallHierarchyOutgoingCallArray = 0,
        Null = 1,
    }; // enum class CallHierarchy_OutgoingCallsResultType

    extern const std::map<CallHierarchy_OutgoingCallsResultType, std::string>
        CallHierarchy_OutgoingCallsResultTypeNames;

    class CallHierarchy_OutgoingCallsResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        CallHierarchy_OutgoingCallsResult();
        CallHierarchy_OutgoingCallsResult(
            CallHierarchy_OutgoingCallsResult &&other
        );
        CallHierarchy_OutgoingCallsResult(
            const CallHierarchy_OutgoingCallsResult &other
        );
        ~CallHierarchy_OutgoingCallsResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            CallHierarchy_OutgoingCallsResult &&other
        ) -> CallHierarchy_OutgoingCallsResult &;

        auto operator=(
            const CallHierarchy_OutgoingCallsResult &other
        ) -> CallHierarchy_OutgoingCallsResult &;

        auto type() const -> const CallHierarchy_OutgoingCallsResultType &;

        auto callHierarchyOutgoingCallArray() const
        -> const std::vector<CallHierarchyOutgoingCall> &;

        auto operator=(
            const std::unique_ptr<std::vector<CallHierarchyOutgoingCall>> &callHierarchyOutgoingCallArray
        ) -> CallHierarchy_OutgoingCallsResult &;

        auto operator=(
            std::unique_ptr<std::vector<CallHierarchyOutgoingCall>> &&callHierarchyOutgoingCallArray
        ) -> CallHierarchy_OutgoingCallsResult &;

        auto operator=(
            const std::vector<CallHierarchyOutgoingCall> &callHierarchyOutgoingCallArray
        ) -> CallHierarchy_OutgoingCallsResult &;

        auto operator=(
            std::vector<CallHierarchyOutgoingCall> &&callHierarchyOutgoingCallArray
        ) -> CallHierarchy_OutgoingCallsResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> CallHierarchy_OutgoingCallsResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        CallHierarchy_OutgoingCallsResultType _type{
            CallHierarchy_OutgoingCallsResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<CallHierarchyOutgoingCall>> _callHierarchyOutgoingCallArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class CallHierarchy_OutgoingCallsResult

    typedef std::vector<CallHierarchyOutgoingCall> CallHierarchy_OutgoingCallsResult_0;

    enum class TextDocument_PrepareTypeHierarchyResultType {
        Uninitialized = -1,
        TypeHierarchyItemArray = 0,
        Null = 1,
    }; // enum class TextDocument_PrepareTypeHierarchyResultType

    extern const std::map<
        TextDocument_PrepareTypeHierarchyResultType,
        std::string
    > TextDocument_PrepareTypeHierarchyResultTypeNames;

    class TextDocument_PrepareTypeHierarchyResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_PrepareTypeHierarchyResult();
        TextDocument_PrepareTypeHierarchyResult(
            TextDocument_PrepareTypeHierarchyResult &&other
        );
        TextDocument_PrepareTypeHierarchyResult(
            const TextDocument_PrepareTypeHierarchyResult &other
        );
        ~TextDocument_PrepareTypeHierarchyResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_PrepareTypeHierarchyResult &&other
        ) -> TextDocument_PrepareTypeHierarchyResult &;

        auto operator=(
            const TextDocument_PrepareTypeHierarchyResult &other
        ) -> TextDocument_PrepareTypeHierarchyResult &;

        auto type() const
        -> const TextDocument_PrepareTypeHierarchyResultType &;

        auto typeHierarchyItemArray() const
        -> const std::vector<TypeHierarchyItem> &;

        auto operator=(
            const std::unique_ptr<std::vector<TypeHierarchyItem>> &typeHierarchyItemArray
        ) -> TextDocument_PrepareTypeHierarchyResult &;

        auto operator=(
            std::unique_ptr<std::vector<TypeHierarchyItem>> &&typeHierarchyItemArray
        ) -> TextDocument_PrepareTypeHierarchyResult &;

        auto operator=(
            const std::vector<TypeHierarchyItem> &typeHierarchyItemArray
        ) -> TextDocument_PrepareTypeHierarchyResult &;

        auto operator=(
            std::vector<TypeHierarchyItem> &&typeHierarchyItemArray
        ) -> TextDocument_PrepareTypeHierarchyResult &;

        auto null() const -> const null_t &;

        auto operator=(
            null_t null
        ) -> TextDocument_PrepareTypeHierarchyResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_PrepareTypeHierarchyResultType _type{
            TextDocument_PrepareTypeHierarchyResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<TypeHierarchyItem>> _typeHierarchyItemArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_PrepareTypeHierarchyResult

    typedef std::vector<TypeHierarchyItem> TextDocument_PrepareTypeHierarchyResult_0;

    enum class TypeHierarchy_SupertypesResultType {
        Uninitialized = -1,
        TypeHierarchyItemArray = 0,
        Null = 1,
    }; // enum class TypeHierarchy_SupertypesResultType

    extern const std::map<TypeHierarchy_SupertypesResultType, std::string>
        TypeHierarchy_SupertypesResultTypeNames;

    class TypeHierarchy_SupertypesResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeHierarchy_SupertypesResult();
        TypeHierarchy_SupertypesResult(TypeHierarchy_SupertypesResult &&other);
        TypeHierarchy_SupertypesResult(
            const TypeHierarchy_SupertypesResult &other
        );
        ~TypeHierarchy_SupertypesResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TypeHierarchy_SupertypesResult &&other
        ) -> TypeHierarchy_SupertypesResult &;

        auto operator=(
            const TypeHierarchy_SupertypesResult &other
        ) -> TypeHierarchy_SupertypesResult &;

        auto type() const -> const TypeHierarchy_SupertypesResultType &;

        auto typeHierarchyItemArray() const
        -> const std::vector<TypeHierarchyItem> &;

        auto operator=(
            const std::unique_ptr<std::vector<TypeHierarchyItem>> &typeHierarchyItemArray
        ) -> TypeHierarchy_SupertypesResult &;

        auto operator=(
            std::unique_ptr<std::vector<TypeHierarchyItem>> &&typeHierarchyItemArray
        ) -> TypeHierarchy_SupertypesResult &;

        auto operator=(
            const std::vector<TypeHierarchyItem> &typeHierarchyItemArray
        ) -> TypeHierarchy_SupertypesResult &;

        auto operator=(
            std::vector<TypeHierarchyItem> &&typeHierarchyItemArray
        ) -> TypeHierarchy_SupertypesResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TypeHierarchy_SupertypesResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TypeHierarchy_SupertypesResultType _type{
            TypeHierarchy_SupertypesResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<TypeHierarchyItem>> _typeHierarchyItemArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TypeHierarchy_SupertypesResult

    typedef std::vector<TypeHierarchyItem> TypeHierarchy_SupertypesResult_0;

    enum class TypeHierarchy_SubtypesResultType {
        Uninitialized = -1,
        TypeHierarchyItemArray = 0,
        Null = 1,
    }; // enum class TypeHierarchy_SubtypesResultType

    extern const std::map<TypeHierarchy_SubtypesResultType, std::string>
        TypeHierarchy_SubtypesResultTypeNames;

    class TypeHierarchy_SubtypesResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TypeHierarchy_SubtypesResult();
        TypeHierarchy_SubtypesResult(TypeHierarchy_SubtypesResult &&other);
        TypeHierarchy_SubtypesResult(
            const TypeHierarchy_SubtypesResult &other
        );
        ~TypeHierarchy_SubtypesResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TypeHierarchy_SubtypesResult &&other
        ) -> TypeHierarchy_SubtypesResult &;

        auto operator=(
            const TypeHierarchy_SubtypesResult &other
        ) -> TypeHierarchy_SubtypesResult &;

        auto type() const -> const TypeHierarchy_SubtypesResultType &;

        auto typeHierarchyItemArray() const
        -> const std::vector<TypeHierarchyItem> &;

        auto operator=(
            const std::unique_ptr<std::vector<TypeHierarchyItem>> &typeHierarchyItemArray
        ) -> TypeHierarchy_SubtypesResult &;

        auto operator=(
            std::unique_ptr<std::vector<TypeHierarchyItem>> &&typeHierarchyItemArray
        ) -> TypeHierarchy_SubtypesResult &;

        auto operator=(
            const std::vector<TypeHierarchyItem> &typeHierarchyItemArray
        ) -> TypeHierarchy_SubtypesResult &;

        auto operator=(
            std::vector<TypeHierarchyItem> &&typeHierarchyItemArray
        ) -> TypeHierarchy_SubtypesResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TypeHierarchy_SubtypesResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TypeHierarchy_SubtypesResultType _type{
            TypeHierarchy_SubtypesResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<TypeHierarchyItem>> _typeHierarchyItemArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TypeHierarchy_SubtypesResult

    typedef std::vector<TypeHierarchyItem> TypeHierarchy_SubtypesResult_0;

    enum class TextDocument_InlayHintResultType {
        Uninitialized = -1,
        InlayHintArray = 0,
        Null = 1,
    }; // enum class TextDocument_InlayHintResultType

    extern const std::map<TextDocument_InlayHintResultType, std::string>
        TextDocument_InlayHintResultTypeNames;

    class TextDocument_InlayHintResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_InlayHintResult();
        TextDocument_InlayHintResult(TextDocument_InlayHintResult &&other);
        TextDocument_InlayHintResult(
            const TextDocument_InlayHintResult &other
        );
        ~TextDocument_InlayHintResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_InlayHintResult &&other
        ) -> TextDocument_InlayHintResult &;

        auto operator=(
            const TextDocument_InlayHintResult &other
        ) -> TextDocument_InlayHintResult &;

        auto type() const -> const TextDocument_InlayHintResultType &;

        auto inlayHintArray() const -> const std::vector<InlayHint> &;

        auto operator=(
            const std::unique_ptr<std::vector<InlayHint>> &inlayHintArray
        ) -> TextDocument_InlayHintResult &;

        auto operator=(
            std::unique_ptr<std::vector<InlayHint>> &&inlayHintArray
        ) -> TextDocument_InlayHintResult &;

        auto operator=(
            const std::vector<InlayHint> &inlayHintArray
        ) -> TextDocument_InlayHintResult &;

        auto operator=(
            std::vector<InlayHint> &&inlayHintArray
        ) -> TextDocument_InlayHintResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_InlayHintResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_InlayHintResultType _type{
            TextDocument_InlayHintResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<InlayHint>> _inlayHintArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_InlayHintResult

    typedef std::vector<InlayHint> TextDocument_InlayHintResult_0;

    typedef InlayHint InlayHint_ResolveResult;

    enum class TextDocument_DiagnosticResultType {
        Uninitialized = -1,
        DocumentDiagnosticReport = 0,
        DocumentDiagnosticReportPartialResult = 1,
    }; // enum class TextDocument_DiagnosticResultType

    extern const std::map<TextDocument_DiagnosticResultType, std::string>
        TextDocument_DiagnosticResultTypeNames;

    class TextDocument_DiagnosticResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_DiagnosticResult();
        TextDocument_DiagnosticResult(TextDocument_DiagnosticResult &&other);
        TextDocument_DiagnosticResult(
            const TextDocument_DiagnosticResult &other
        );
        ~TextDocument_DiagnosticResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_DiagnosticResult &&other
        ) -> TextDocument_DiagnosticResult &;

        auto operator=(
            const TextDocument_DiagnosticResult &other
        ) -> TextDocument_DiagnosticResult &;

        auto type() const -> const TextDocument_DiagnosticResultType &;

        auto documentDiagnosticReport() const
        -> const DocumentDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<DocumentDiagnosticReport> &documentDiagnosticReport
        ) -> TextDocument_DiagnosticResult &;

        auto operator=(
            std::unique_ptr<DocumentDiagnosticReport> &&documentDiagnosticReport
        ) -> TextDocument_DiagnosticResult &;

        auto operator=(
            const DocumentDiagnosticReport &documentDiagnosticReport
        ) -> TextDocument_DiagnosticResult &;

        auto operator=(
            DocumentDiagnosticReport &&documentDiagnosticReport
        ) -> TextDocument_DiagnosticResult &;

        auto documentDiagnosticReportPartialResult() const
        -> const DocumentDiagnosticReportPartialResult &;

        auto operator=(
            const std::unique_ptr<DocumentDiagnosticReportPartialResult> &documentDiagnosticReportPartialResult
        ) -> TextDocument_DiagnosticResult &;

        auto operator=(
            std::unique_ptr<DocumentDiagnosticReportPartialResult> &&documentDiagnosticReportPartialResult
        ) -> TextDocument_DiagnosticResult &;

        auto operator=(
            const DocumentDiagnosticReportPartialResult &documentDiagnosticReportPartialResult
        ) -> TextDocument_DiagnosticResult &;

        auto operator=(
            DocumentDiagnosticReportPartialResult &&documentDiagnosticReportPartialResult
        ) -> TextDocument_DiagnosticResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_DiagnosticResultType _type{
            TextDocument_DiagnosticResultType::Uninitialized
        };

        union {
            std::unique_ptr<DocumentDiagnosticReport> _documentDiagnosticReport;
            std::unique_ptr<DocumentDiagnosticReportPartialResult> _documentDiagnosticReportPartialResult;
        };

        auto reset() -> void;
    }; // class TextDocument_DiagnosticResult

    enum class Workspace_DiagnosticResultType {
        Uninitialized = -1,
        WorkspaceDiagnosticReport = 0,
        WorkspaceDiagnosticReportPartialResult = 1,
    }; // enum class Workspace_DiagnosticResultType

    extern const std::map<Workspace_DiagnosticResultType, std::string>
        Workspace_DiagnosticResultTypeNames;

    class Workspace_DiagnosticResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Workspace_DiagnosticResult();
        Workspace_DiagnosticResult(Workspace_DiagnosticResult &&other);
        Workspace_DiagnosticResult(const Workspace_DiagnosticResult &other);
        ~Workspace_DiagnosticResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            Workspace_DiagnosticResult &&other
        ) -> Workspace_DiagnosticResult &;

        auto operator=(
            const Workspace_DiagnosticResult &other
        ) -> Workspace_DiagnosticResult &;

        auto type() const -> const Workspace_DiagnosticResultType &;

        auto workspaceDiagnosticReport() const
        -> const WorkspaceDiagnosticReport &;

        auto operator=(
            const std::unique_ptr<WorkspaceDiagnosticReport> &workspaceDiagnosticReport
        ) -> Workspace_DiagnosticResult &;

        auto operator=(
            std::unique_ptr<WorkspaceDiagnosticReport> &&workspaceDiagnosticReport
        ) -> Workspace_DiagnosticResult &;

        auto operator=(
            const WorkspaceDiagnosticReport &workspaceDiagnosticReport
        ) -> Workspace_DiagnosticResult &;

        auto operator=(
            WorkspaceDiagnosticReport &&workspaceDiagnosticReport
        ) -> Workspace_DiagnosticResult &;

        auto workspaceDiagnosticReportPartialResult() const
        -> const WorkspaceDiagnosticReportPartialResult &;

        auto operator=(
            const std::unique_ptr<WorkspaceDiagnosticReportPartialResult> &workspaceDiagnosticReportPartialResult
        ) -> Workspace_DiagnosticResult &;

        auto operator=(
            std::unique_ptr<WorkspaceDiagnosticReportPartialResult> &&workspaceDiagnosticReportPartialResult
        ) -> Workspace_DiagnosticResult &;

        auto operator=(
            const WorkspaceDiagnosticReportPartialResult &workspaceDiagnosticReportPartialResult
        ) -> Workspace_DiagnosticResult &;

        auto operator=(
            WorkspaceDiagnosticReportPartialResult &&workspaceDiagnosticReportPartialResult
        ) -> Workspace_DiagnosticResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        Workspace_DiagnosticResultType _type{
            Workspace_DiagnosticResultType::Uninitialized
        };

        union {
            std::unique_ptr<WorkspaceDiagnosticReport> _workspaceDiagnosticReport;
            std::unique_ptr<WorkspaceDiagnosticReportPartialResult> _workspaceDiagnosticReportPartialResult;
        };

        auto reset() -> void;
    }; // class Workspace_DiagnosticResult

    enum class TextDocument_InlineCompletionResultType {
        Uninitialized = -1,
        InlineCompletionList = 0,
        InlineCompletionItemArray = 1,
        Null = 2,
    }; // enum class TextDocument_InlineCompletionResultType

    extern const std::map<TextDocument_InlineCompletionResultType, std::string>
        TextDocument_InlineCompletionResultTypeNames;

    class TextDocument_InlineCompletionResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_InlineCompletionResult();
        TextDocument_InlineCompletionResult(
            TextDocument_InlineCompletionResult &&other
        );
        TextDocument_InlineCompletionResult(
            const TextDocument_InlineCompletionResult &other
        );
        ~TextDocument_InlineCompletionResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_InlineCompletionResult &&other
        ) -> TextDocument_InlineCompletionResult &;

        auto operator=(
            const TextDocument_InlineCompletionResult &other
        ) -> TextDocument_InlineCompletionResult &;

        auto type() const -> const TextDocument_InlineCompletionResultType &;

        auto inlineCompletionList() const -> const InlineCompletionList &;

        auto operator=(
            const std::unique_ptr<InlineCompletionList> &inlineCompletionList
        ) -> TextDocument_InlineCompletionResult &;

        auto operator=(
            std::unique_ptr<InlineCompletionList> &&inlineCompletionList
        ) -> TextDocument_InlineCompletionResult &;

        auto operator=(
            const InlineCompletionList &inlineCompletionList
        ) -> TextDocument_InlineCompletionResult &;

        auto operator=(
            InlineCompletionList &&inlineCompletionList
        ) -> TextDocument_InlineCompletionResult &;

        auto inlineCompletionItemArray() const
        -> const std::vector<InlineCompletionItem> &;

        auto operator=(
            const std::unique_ptr<std::vector<InlineCompletionItem>> &inlineCompletionItemArray
        ) -> TextDocument_InlineCompletionResult &;

        auto operator=(
            std::unique_ptr<std::vector<InlineCompletionItem>> &&inlineCompletionItemArray
        ) -> TextDocument_InlineCompletionResult &;

        auto operator=(
            const std::vector<InlineCompletionItem> &inlineCompletionItemArray
        ) -> TextDocument_InlineCompletionResult &;

        auto operator=(
            std::vector<InlineCompletionItem> &&inlineCompletionItemArray
        ) -> TextDocument_InlineCompletionResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_InlineCompletionResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_InlineCompletionResultType _type{
            TextDocument_InlineCompletionResultType::Uninitialized
        };

        union {
            std::unique_ptr<InlineCompletionList> _inlineCompletionList;
            std::unique_ptr<std::vector<InlineCompletionItem>> _inlineCompletionItemArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_InlineCompletionResult

    typedef std::vector<InlineCompletionItem> TextDocument_InlineCompletionResult_1;

    enum class TextDocument_CompletionResultType {
        Uninitialized = -1,
        CompletionItemArray = 0,
        CompletionList = 1,
        Null = 2,
    }; // enum class TextDocument_CompletionResultType

    extern const std::map<TextDocument_CompletionResultType, std::string>
        TextDocument_CompletionResultTypeNames;

    class TextDocument_CompletionResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_CompletionResult();
        TextDocument_CompletionResult(TextDocument_CompletionResult &&other);
        TextDocument_CompletionResult(
            const TextDocument_CompletionResult &other
        );
        ~TextDocument_CompletionResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_CompletionResult &&other
        ) -> TextDocument_CompletionResult &;

        auto operator=(
            const TextDocument_CompletionResult &other
        ) -> TextDocument_CompletionResult &;

        auto type() const -> const TextDocument_CompletionResultType &;

        auto completionItemArray() const
        -> const std::vector<CompletionItem> &;

        auto operator=(
            const std::unique_ptr<std::vector<CompletionItem>> &completionItemArray
        ) -> TextDocument_CompletionResult &;

        auto operator=(
            std::unique_ptr<std::vector<CompletionItem>> &&completionItemArray
        ) -> TextDocument_CompletionResult &;

        auto operator=(
            const std::vector<CompletionItem> &completionItemArray
        ) -> TextDocument_CompletionResult &;

        auto operator=(
            std::vector<CompletionItem> &&completionItemArray
        ) -> TextDocument_CompletionResult &;

        auto completionList() const -> const CompletionList &;

        auto operator=(
            const std::unique_ptr<CompletionList> &completionList
        ) -> TextDocument_CompletionResult &;

        auto operator=(
            std::unique_ptr<CompletionList> &&completionList
        ) -> TextDocument_CompletionResult &;

        auto operator=(
            const CompletionList &completionList
        ) -> TextDocument_CompletionResult &;

        auto operator=(
            CompletionList &&completionList
        ) -> TextDocument_CompletionResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_CompletionResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_CompletionResultType _type{
            TextDocument_CompletionResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<CompletionItem>> _completionItemArray;
            std::unique_ptr<CompletionList> _completionList;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_CompletionResult

    typedef std::vector<CompletionItem> TextDocument_CompletionResult_0;

    typedef CompletionItem CompletionItem_ResolveResult;

    enum class TextDocument_CodeActionResult_0_elemType {
        Uninitialized = -1,
        Command = 0,
        CodeAction = 1,
    }; // enum class TextDocument_CodeActionResult_0_elemType

    extern const std::map<
        TextDocument_CodeActionResult_0_elemType,
        std::string
    > TextDocument_CodeActionResult_0_elemTypeNames;

    class TextDocument_CodeActionResult_0_elem {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_CodeActionResult_0_elem();
        TextDocument_CodeActionResult_0_elem(
            TextDocument_CodeActionResult_0_elem &&other
        );
        TextDocument_CodeActionResult_0_elem(
            const TextDocument_CodeActionResult_0_elem &other
        );
        ~TextDocument_CodeActionResult_0_elem();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_CodeActionResult_0_elem &&other
        ) -> TextDocument_CodeActionResult_0_elem &;

        auto operator=(
            const TextDocument_CodeActionResult_0_elem &other
        ) -> TextDocument_CodeActionResult_0_elem &;

        auto type() const -> const TextDocument_CodeActionResult_0_elemType &;

        auto command() const -> const Command &;

        auto operator=(
            const std::unique_ptr<Command> &command
        ) -> TextDocument_CodeActionResult_0_elem &;

        auto operator=(
            std::unique_ptr<Command> &&command
        ) -> TextDocument_CodeActionResult_0_elem &;

        auto operator=(
            const Command &command
        ) -> TextDocument_CodeActionResult_0_elem &;

        auto operator=(
            Command &&command
        ) -> TextDocument_CodeActionResult_0_elem &;

        auto codeAction() const -> const CodeAction &;

        auto operator=(
            const std::unique_ptr<CodeAction> &codeAction
        ) -> TextDocument_CodeActionResult_0_elem &;

        auto operator=(
            std::unique_ptr<CodeAction> &&codeAction
        ) -> TextDocument_CodeActionResult_0_elem &;

        auto operator=(
            const CodeAction &codeAction
        ) -> TextDocument_CodeActionResult_0_elem &;

        auto operator=(
            CodeAction &&codeAction
        ) -> TextDocument_CodeActionResult_0_elem &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_CodeActionResult_0_elemType _type{
            TextDocument_CodeActionResult_0_elemType::Uninitialized
        };

        union {
            std::unique_ptr<Command> _command;
            std::unique_ptr<CodeAction> _codeAction;
        };

        auto reset() -> void;
    }; // class TextDocument_CodeActionResult_0_elem

    enum class TextDocument_CodeActionResultType {
        Uninitialized = -1,
        CommandOrCodeActionArray = 0,
        Null = 1,
    }; // enum class TextDocument_CodeActionResultType

    extern const std::map<TextDocument_CodeActionResultType, std::string>
        TextDocument_CodeActionResultTypeNames;

    class TextDocument_CodeActionResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_CodeActionResult();
        TextDocument_CodeActionResult(TextDocument_CodeActionResult &&other);
        TextDocument_CodeActionResult(
            const TextDocument_CodeActionResult &other
        );
        ~TextDocument_CodeActionResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_CodeActionResult &&other
        ) -> TextDocument_CodeActionResult &;

        auto operator=(
            const TextDocument_CodeActionResult &other
        ) -> TextDocument_CodeActionResult &;

        auto type() const -> const TextDocument_CodeActionResultType &;

        auto textDocument_CodeActionResult_0() const
        -> const std::vector<TextDocument_CodeActionResult_0_elem> &;

        auto operator=(
            const std::unique_ptr<std::vector<TextDocument_CodeActionResult_0_elem>> &textDocument_CodeActionResult_0
        ) -> TextDocument_CodeActionResult &;

        auto operator=(
            std::unique_ptr<std::vector<TextDocument_CodeActionResult_0_elem>> &&textDocument_CodeActionResult_0
        ) -> TextDocument_CodeActionResult &;

        auto operator=(
            const std::vector<TextDocument_CodeActionResult_0_elem> &textDocument_CodeActionResult_0
        ) -> TextDocument_CodeActionResult &;

        auto operator=(
            std::vector<TextDocument_CodeActionResult_0_elem> &&textDocument_CodeActionResult_0
        ) -> TextDocument_CodeActionResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_CodeActionResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_CodeActionResultType _type{
            TextDocument_CodeActionResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<TextDocument_CodeActionResult_0_elem>> _textDocument_CodeActionResult_0;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_CodeActionResult

    typedef std::vector<TextDocument_CodeActionResult_0_elem> TextDocument_CodeActionResult_0;

    typedef CodeAction CodeAction_ResolveResult;

    enum class Workspace_SymbolResultType {
        Uninitialized = -1,
        SymbolInformationArray = 0,
        WorkspaceSymbolArray = 1,
        Null = 2,
    }; // enum class Workspace_SymbolResultType

    extern const std::map<Workspace_SymbolResultType, std::string>
        Workspace_SymbolResultTypeNames;

    class Workspace_SymbolResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Workspace_SymbolResult();
        Workspace_SymbolResult(Workspace_SymbolResult &&other);
        Workspace_SymbolResult(const Workspace_SymbolResult &other);
        ~Workspace_SymbolResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            Workspace_SymbolResult &&other
        ) -> Workspace_SymbolResult &;

        auto operator=(
            const Workspace_SymbolResult &other
        ) -> Workspace_SymbolResult &;

        auto type() const -> const Workspace_SymbolResultType &;

        auto symbolInformationArray() const
        -> const std::vector<SymbolInformation> &;

        auto operator=(
            const std::unique_ptr<std::vector<SymbolInformation>> &symbolInformationArray
        ) -> Workspace_SymbolResult &;

        auto operator=(
            std::unique_ptr<std::vector<SymbolInformation>> &&symbolInformationArray
        ) -> Workspace_SymbolResult &;

        auto operator=(
            const std::vector<SymbolInformation> &symbolInformationArray
        ) -> Workspace_SymbolResult &;

        auto operator=(
            std::vector<SymbolInformation> &&symbolInformationArray
        ) -> Workspace_SymbolResult &;

        auto workspaceSymbolArray() const
        -> const std::vector<WorkspaceSymbol> &;

        auto operator=(
            const std::unique_ptr<std::vector<WorkspaceSymbol>> &workspaceSymbolArray
        ) -> Workspace_SymbolResult &;

        auto operator=(
            std::unique_ptr<std::vector<WorkspaceSymbol>> &&workspaceSymbolArray
        ) -> Workspace_SymbolResult &;

        auto operator=(
            const std::vector<WorkspaceSymbol> &workspaceSymbolArray
        ) -> Workspace_SymbolResult &;

        auto operator=(
            std::vector<WorkspaceSymbol> &&workspaceSymbolArray
        ) -> Workspace_SymbolResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> Workspace_SymbolResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        Workspace_SymbolResultType _type{
            Workspace_SymbolResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<SymbolInformation>> _symbolInformationArray;
            std::unique_ptr<std::vector<WorkspaceSymbol>> _workspaceSymbolArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class Workspace_SymbolResult

    typedef std::vector<WorkspaceSymbol> Workspace_SymbolResult_1;

    typedef WorkspaceSymbol WorkspaceSymbol_ResolveResult;

    enum class TextDocument_CodeLensResultType {
        Uninitialized = -1,
        CodeLensArray = 0,
        Null = 1,
    }; // enum class TextDocument_CodeLensResultType

    extern const std::map<TextDocument_CodeLensResultType, std::string>
        TextDocument_CodeLensResultTypeNames;

    class TextDocument_CodeLensResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_CodeLensResult();
        TextDocument_CodeLensResult(TextDocument_CodeLensResult &&other);
        TextDocument_CodeLensResult(const TextDocument_CodeLensResult &other);
        ~TextDocument_CodeLensResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_CodeLensResult &&other
        ) -> TextDocument_CodeLensResult &;

        auto operator=(
            const TextDocument_CodeLensResult &other
        ) -> TextDocument_CodeLensResult &;

        auto type() const -> const TextDocument_CodeLensResultType &;

        auto codeLensArray() const -> const std::vector<CodeLens> &;

        auto operator=(
            const std::unique_ptr<std::vector<CodeLens>> &codeLensArray
        ) -> TextDocument_CodeLensResult &;

        auto operator=(
            std::unique_ptr<std::vector<CodeLens>> &&codeLensArray
        ) -> TextDocument_CodeLensResult &;

        auto operator=(
            const std::vector<CodeLens> &codeLensArray
        ) -> TextDocument_CodeLensResult &;

        auto operator=(
            std::vector<CodeLens> &&codeLensArray
        ) -> TextDocument_CodeLensResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_CodeLensResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_CodeLensResultType _type{
            TextDocument_CodeLensResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<CodeLens>> _codeLensArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_CodeLensResult

    typedef std::vector<CodeLens> TextDocument_CodeLensResult_0;

    typedef CodeLens CodeLens_ResolveResult;

    enum class TextDocument_DocumentLinkResultType {
        Uninitialized = -1,
        DocumentLinkArray = 0,
        Null = 1,
    }; // enum class TextDocument_DocumentLinkResultType

    extern const std::map<TextDocument_DocumentLinkResultType, std::string>
        TextDocument_DocumentLinkResultTypeNames;

    class TextDocument_DocumentLinkResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        TextDocument_DocumentLinkResult();
        TextDocument_DocumentLinkResult(
            TextDocument_DocumentLinkResult &&other
        );
        TextDocument_DocumentLinkResult(
            const TextDocument_DocumentLinkResult &other
        );
        ~TextDocument_DocumentLinkResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            TextDocument_DocumentLinkResult &&other
        ) -> TextDocument_DocumentLinkResult &;

        auto operator=(
            const TextDocument_DocumentLinkResult &other
        ) -> TextDocument_DocumentLinkResult &;

        auto type() const -> const TextDocument_DocumentLinkResultType &;

        auto documentLinkArray() const -> const std::vector<DocumentLink> &;

        auto operator=(
            const std::unique_ptr<std::vector<DocumentLink>> &documentLinkArray
        ) -> TextDocument_DocumentLinkResult &;

        auto operator=(
            std::unique_ptr<std::vector<DocumentLink>> &&documentLinkArray
        ) -> TextDocument_DocumentLinkResult &;

        auto operator=(
            const std::vector<DocumentLink> &documentLinkArray
        ) -> TextDocument_DocumentLinkResult &;

        auto operator=(
            std::vector<DocumentLink> &&documentLinkArray
        ) -> TextDocument_DocumentLinkResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> TextDocument_DocumentLinkResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        TextDocument_DocumentLinkResultType _type{
            TextDocument_DocumentLinkResultType::Uninitialized
        };

        union {
            std::unique_ptr<std::vector<DocumentLink>> _documentLinkArray;
            null_t _null;
        };

        auto reset() -> void;
    }; // class TextDocument_DocumentLinkResult

    typedef std::vector<DocumentLink> TextDocument_DocumentLinkResult_0;

    typedef DocumentLink DocumentLink_ResolveResult;

    enum class Workspace_ExecuteCommandResultType {
        Uninitialized = -1,
        Any = 0,
        Null = 1,
    }; // enum class Workspace_ExecuteCommandResultType

    extern const std::map<Workspace_ExecuteCommandResultType, std::string>
        Workspace_ExecuteCommandResultTypeNames;

    class Workspace_ExecuteCommandResult {
    public:
        // ======================================= //
        // Constructor and Destructor Declarations //
        // ======================================= //

        Workspace_ExecuteCommandResult();
        Workspace_ExecuteCommandResult(Workspace_ExecuteCommandResult &&other);
        Workspace_ExecuteCommandResult(
            const Workspace_ExecuteCommandResult &other
        );
        ~Workspace_ExecuteCommandResult();

        // =================== //
        // Method Declarations //
        // =================== //

        auto operator=(
            Workspace_ExecuteCommandResult &&other
        ) -> Workspace_ExecuteCommandResult &;

        auto operator=(
            const Workspace_ExecuteCommandResult &other
        ) -> Workspace_ExecuteCommandResult &;

        auto type() const -> const Workspace_ExecuteCommandResultType &;

        auto any() const -> const LSPAny &;

        auto operator=(
            const std::unique_ptr<LSPAny> &any
        ) -> Workspace_ExecuteCommandResult &;

        auto operator=(
            std::unique_ptr<LSPAny> &&any
        ) -> Workspace_ExecuteCommandResult &;

        auto operator=(const LSPAny &any) -> Workspace_ExecuteCommandResult &;

        auto operator=(LSPAny &&any) -> Workspace_ExecuteCommandResult &;

        auto null() const -> const null_t &;

        auto operator=(null_t null) -> Workspace_ExecuteCommandResult &;
    private:
        // ================== //
        // Field Declarations //
        // ================== //

        Workspace_ExecuteCommandResultType _type{
            Workspace_ExecuteCommandResultType::Uninitialized
        };

        union {
            std::unique_ptr<LSPAny> _any;
            null_t _null;
        };

        auto reset() -> void;
    }; // class Workspace_ExecuteCommandResult

    enum class IncomingRequest {
        TextDocument_Implementation,
        TextDocument_TypeDefinition,
        TextDocument_DocumentColor,
        TextDocument_ColorPresentation,
        TextDocument_FoldingRange,
        TextDocument_Declaration,
        TextDocument_SelectionRange,
        TextDocument_PrepareCallHierarchy,
        CallHierarchy_IncomingCalls,
        CallHierarchy_OutgoingCalls,
        TextDocument_SemanticTokens_Full,
        TextDocument_SemanticTokens_Full_Delta,
        TextDocument_SemanticTokens_Range,
        TextDocument_LinkedEditingRange,
        Workspace_WillCreateFiles,
        Workspace_WillRenameFiles,
        Workspace_WillDeleteFiles,
        TextDocument_Moniker,
        TextDocument_PrepareTypeHierarchy,
        TypeHierarchy_Supertypes,
        TypeHierarchy_Subtypes,
        TextDocument_InlineValue,
        TextDocument_InlayHint,
        InlayHint_Resolve,
        TextDocument_Diagnostic,
        Workspace_Diagnostic,
        TextDocument_InlineCompletion,
        Initialize,
        Shutdown,
        TextDocument_WillSaveWaitUntil,
        TextDocument_Completion,
        CompletionItem_Resolve,
        TextDocument_Hover,
        TextDocument_SignatureHelp,
        TextDocument_Definition,
        TextDocument_References,
        TextDocument_DocumentHighlight,
        TextDocument_DocumentSymbol,
        TextDocument_CodeAction,
        CodeAction_Resolve,
        Workspace_Symbol,
        WorkspaceSymbol_Resolve,
        TextDocument_CodeLens,
        CodeLens_Resolve,
        TextDocument_DocumentLink,
        DocumentLink_Resolve,
        TextDocument_Formatting,
        TextDocument_RangeFormatting,
        TextDocument_RangesFormatting,
        TextDocument_OnTypeFormatting,
        TextDocument_Rename,
        TextDocument_PrepareRename,
        Workspace_ExecuteCommand,
    }; // enum class IncomingRequest

    extern const std::map<IncomingRequest, std::string> IncomingRequestNames;

    extern const std::map<IncomingRequest, std::string> IncomingRequestValues;

    auto incomingRequestByName(const std::string &name) -> IncomingRequest;

    auto incomingRequestByValue(const std::string &value) -> IncomingRequest;

    auto isIncomingRequest(const std::string &value) -> bool;

    enum class OutgoingRequest {
        Workspace_WorkspaceFolders,
        Workspace_Configuration,
        Workspace_FoldingRange_Refresh,
        Window_WorkDoneProgress_Create,
        Workspace_SemanticTokens_Refresh,
        Window_ShowDocument,
        Workspace_InlineValue_Refresh,
        Workspace_InlayHint_Refresh,
        Workspace_Diagnostic_Refresh,
        Client_RegisterCapability,
        Client_UnregisterCapability,
        Window_ShowMessageRequest,
        Workspace_CodeLens_Refresh,
        Workspace_ApplyEdit,
    }; // enum class OutgoingRequest

    extern const std::map<OutgoingRequest, std::string> OutgoingRequestNames;

    extern const std::map<OutgoingRequest, std::string> OutgoingRequestValues;

    auto outgoingRequestByName(const std::string &name) -> OutgoingRequest;

    auto outgoingRequestByValue(const std::string &value) -> OutgoingRequest;

    auto isOutgoingRequest(const std::string &value) -> bool;

    enum class IncomingNotification {
        Workspace_DidChangeWorkspaceFolders,
        Window_WorkDoneProgress_Cancel,
        Workspace_DidCreateFiles,
        Workspace_DidRenameFiles,
        Workspace_DidDeleteFiles,
        NotebookDocument_DidOpen,
        NotebookDocument_DidChange,
        NotebookDocument_DidSave,
        NotebookDocument_DidClose,
        Initialized,
        Exit,
        Workspace_DidChangeConfiguration,
        TextDocument_DidOpen,
        TextDocument_DidChange,
        TextDocument_DidClose,
        TextDocument_DidSave,
        TextDocument_WillSave,
        Workspace_DidChangeWatchedFiles,
        SetTrace,
        CancelRequest,
        Progress,
    }; // enum class IncomingNotification

    extern const std::map<IncomingNotification, std::string>
        IncomingNotificationNames;

    extern const std::map<IncomingNotification, std::string>
        IncomingNotificationValues;

    auto incomingNotificationByName(
        const std::string &name
    ) -> IncomingNotification;

    auto incomingNotificationByValue(
        const std::string &value
    ) -> IncomingNotification;

    auto isIncomingNotification(const std::string &value) -> bool;

    enum class OutgoingNotification {
        Window_ShowMessage,
        Window_LogMessage,
        Telemetry_Event,
        TextDocument_PublishDiagnostics,
        LogTrace,
        CancelRequest,
        Progress,
    }; // enum class OutgoingNotification

    extern const std::map<OutgoingNotification, std::string>
        OutgoingNotificationNames;

    extern const std::map<OutgoingNotification, std::string>
        OutgoingNotificationValues;

    auto outgoingNotificationByName(
        const std::string &name
    ) -> OutgoingNotification;

    auto outgoingNotificationByValue(
        const std::string &value
    ) -> OutgoingNotification;

    auto isOutgoingNotification(const std::string &value) -> bool;

} // namespace LCompilers::LanguageServerProtocol
