#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>
#include <libasr/asr_base_visitor.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Expression Replacer Base class

template <class StructType>
class BaseExprReplacer {
public:
    bool call_replacer_on_value=true;
    StructType& self() { return static_cast<StructType&>(*this); }

    ASR::expr_t** current_expr;

    BaseExprReplacer() : current_expr(nullptr) {}


    void replace_IfExp(IfExp_t* x) {
        ASR::expr_t** current_expr_copy_0 = current_expr;
        current_expr = &(x->m_test);
        self().replace_expr(x->m_test);
        current_expr = current_expr_copy_0;
        ASR::expr_t** current_expr_copy_1 = current_expr;
        current_expr = &(x->m_body);
        self().replace_expr(x->m_body);
        current_expr = current_expr_copy_1;
        ASR::expr_t** current_expr_copy_2 = current_expr;
        current_expr = &(x->m_orelse);
        self().replace_expr(x->m_orelse);
        current_expr = current_expr_copy_2;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_3 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_3;
        }
    }


    void replace_ComplexConstructor(ComplexConstructor_t* x) {
        ASR::expr_t** current_expr_copy_4 = current_expr;
        current_expr = &(x->m_re);
        self().replace_expr(x->m_re);
        current_expr = current_expr_copy_4;
        ASR::expr_t** current_expr_copy_5 = current_expr;
        current_expr = &(x->m_im);
        self().replace_expr(x->m_im);
        current_expr = current_expr_copy_5;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_6 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_6;
        }
    }


    void replace_NamedExpr(NamedExpr_t* x) {
        ASR::expr_t** current_expr_copy_7 = current_expr;
        current_expr = &(x->m_target);
        self().replace_expr(x->m_target);
        current_expr = current_expr_copy_7;
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_8 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_8;
        }
        self().replace_ttype(x->m_type);
    }


    void replace_FunctionCall(FunctionCall_t* x) {
        for (size_t i = 0; i < x->n_args; i++) {
            if (x->m_args[i].m_value != nullptr) {
                ASR::expr_t** current_expr_copy_9 = current_expr;
                current_expr = &(x->m_args[i].m_value);
                self().replace_expr(x->m_args[i].m_value);
                current_expr = current_expr_copy_9;
            }
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_10 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_10;
        }
        ASR::expr_t** current_expr_copy_11 = current_expr;
        current_expr = &(x->m_dt);
        self().replace_expr(x->m_dt);
        current_expr = current_expr_copy_11;
    }


    void replace_IntrinsicElementalFunction(IntrinsicElementalFunction_t* x) {
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::expr_t** current_expr_copy_12 = current_expr;
            current_expr = &(x->m_args[i]);
            self().replace_expr(x->m_args[i]);
            current_expr = current_expr_copy_12;
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_13 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_13;
        }
    }


    void replace_IntrinsicArrayFunction(IntrinsicArrayFunction_t* x) {
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::expr_t** current_expr_copy_14 = current_expr;
            current_expr = &(x->m_args[i]);
            self().replace_expr(x->m_args[i]);
            current_expr = current_expr_copy_14;
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_15 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_15;
        }
    }


    void replace_IntrinsicImpureFunction(IntrinsicImpureFunction_t* x) {
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::expr_t** current_expr_copy_16 = current_expr;
            current_expr = &(x->m_args[i]);
            self().replace_expr(x->m_args[i]);
            current_expr = current_expr_copy_16;
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_17 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_17;
        }
    }


    void replace_TypeInquiry(TypeInquiry_t* x) {
        self().replace_ttype(x->m_arg_type);
        ASR::expr_t** current_expr_copy_18 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_18;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_19 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_19;
        }
    }


    void replace_StructConstructor(StructConstructor_t* x) {
        for (size_t i = 0; i < x->n_args; i++) {
            if (x->m_args[i].m_value != nullptr) {
                ASR::expr_t** current_expr_copy_20 = current_expr;
                current_expr = &(x->m_args[i].m_value);
                self().replace_expr(x->m_args[i].m_value);
                current_expr = current_expr_copy_20;
            }
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_21 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_21;
        }
    }


    void replace_StructConstant(StructConstant_t* x) {
        for (size_t i = 0; i < x->n_args; i++) {
            if (x->m_args[i].m_value != nullptr) {
                ASR::expr_t** current_expr_copy_22 = current_expr;
                current_expr = &(x->m_args[i].m_value);
                self().replace_expr(x->m_args[i].m_value);
                current_expr = current_expr_copy_22;
            }
        }
        self().replace_ttype(x->m_type);
    }


    void replace_EnumConstructor(EnumConstructor_t* x) {
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::expr_t** current_expr_copy_23 = current_expr;
            current_expr = &(x->m_args[i]);
            self().replace_expr(x->m_args[i]);
            current_expr = current_expr_copy_23;
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_24 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_24;
        }
    }


    void replace_UnionConstructor(UnionConstructor_t* x) {
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::expr_t** current_expr_copy_25 = current_expr;
            current_expr = &(x->m_args[i]);
            self().replace_expr(x->m_args[i]);
            current_expr = current_expr_copy_25;
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_26 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_26;
        }
    }


    void replace_ImpliedDoLoop(ImpliedDoLoop_t* x) {
        for (size_t i = 0; i < x->n_values; i++) {
            ASR::expr_t** current_expr_copy_27 = current_expr;
            current_expr = &(x->m_values[i]);
            self().replace_expr(x->m_values[i]);
            current_expr = current_expr_copy_27;
        }
        ASR::expr_t** current_expr_copy_28 = current_expr;
        current_expr = &(x->m_var);
        self().replace_expr(x->m_var);
        current_expr = current_expr_copy_28;
        ASR::expr_t** current_expr_copy_29 = current_expr;
        current_expr = &(x->m_start);
        self().replace_expr(x->m_start);
        current_expr = current_expr_copy_29;
        ASR::expr_t** current_expr_copy_30 = current_expr;
        current_expr = &(x->m_end);
        self().replace_expr(x->m_end);
        current_expr = current_expr_copy_30;
        ASR::expr_t** current_expr_copy_31 = current_expr;
        current_expr = &(x->m_increment);
        self().replace_expr(x->m_increment);
        current_expr = current_expr_copy_31;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_32 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_32;
        }
    }


    void replace_IntegerConstant(IntegerConstant_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_IntegerBitNot(IntegerBitNot_t* x) {
        ASR::expr_t** current_expr_copy_33 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_33;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_34 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_34;
        }
    }


    void replace_IntegerUnaryMinus(IntegerUnaryMinus_t* x) {
        ASR::expr_t** current_expr_copy_35 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_35;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_36 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_36;
        }
    }


    void replace_IntegerCompare(IntegerCompare_t* x) {
        ASR::expr_t** current_expr_copy_37 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_37;
        ASR::expr_t** current_expr_copy_38 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_38;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_39 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_39;
        }
    }


    void replace_IntegerBinOp(IntegerBinOp_t* x) {
        ASR::expr_t** current_expr_copy_40 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_40;
        ASR::expr_t** current_expr_copy_41 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_41;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_42 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_42;
        }
    }


    void replace_UnsignedIntegerConstant(UnsignedIntegerConstant_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_UnsignedIntegerUnaryMinus(UnsignedIntegerUnaryMinus_t* x) {
        ASR::expr_t** current_expr_copy_43 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_43;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_44 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_44;
        }
    }


    void replace_UnsignedIntegerBitNot(UnsignedIntegerBitNot_t* x) {
        ASR::expr_t** current_expr_copy_45 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_45;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_46 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_46;
        }
    }


    void replace_UnsignedIntegerCompare(UnsignedIntegerCompare_t* x) {
        ASR::expr_t** current_expr_copy_47 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_47;
        ASR::expr_t** current_expr_copy_48 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_48;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_49 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_49;
        }
    }


    void replace_UnsignedIntegerBinOp(UnsignedIntegerBinOp_t* x) {
        ASR::expr_t** current_expr_copy_50 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_50;
        ASR::expr_t** current_expr_copy_51 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_51;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_52 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_52;
        }
    }


    void replace_RealConstant(RealConstant_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_RealUnaryMinus(RealUnaryMinus_t* x) {
        ASR::expr_t** current_expr_copy_53 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_53;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_54 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_54;
        }
    }


    void replace_RealCompare(RealCompare_t* x) {
        ASR::expr_t** current_expr_copy_55 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_55;
        ASR::expr_t** current_expr_copy_56 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_56;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_57 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_57;
        }
    }


    void replace_RealBinOp(RealBinOp_t* x) {
        ASR::expr_t** current_expr_copy_58 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_58;
        ASR::expr_t** current_expr_copy_59 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_59;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_60 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_60;
        }
    }


    void replace_RealCopySign(RealCopySign_t* x) {
        ASR::expr_t** current_expr_copy_61 = current_expr;
        current_expr = &(x->m_target);
        self().replace_expr(x->m_target);
        current_expr = current_expr_copy_61;
        ASR::expr_t** current_expr_copy_62 = current_expr;
        current_expr = &(x->m_source);
        self().replace_expr(x->m_source);
        current_expr = current_expr_copy_62;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_63 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_63;
        }
    }


    void replace_ComplexConstant(ComplexConstant_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_ComplexUnaryMinus(ComplexUnaryMinus_t* x) {
        ASR::expr_t** current_expr_copy_64 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_64;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_65 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_65;
        }
    }


    void replace_ComplexCompare(ComplexCompare_t* x) {
        ASR::expr_t** current_expr_copy_66 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_66;
        ASR::expr_t** current_expr_copy_67 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_67;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_68 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_68;
        }
    }


    void replace_ComplexBinOp(ComplexBinOp_t* x) {
        ASR::expr_t** current_expr_copy_69 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_69;
        ASR::expr_t** current_expr_copy_70 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_70;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_71 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_71;
        }
    }


    void replace_LogicalConstant(LogicalConstant_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_LogicalNot(LogicalNot_t* x) {
        ASR::expr_t** current_expr_copy_72 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_72;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_73 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_73;
        }
    }


    void replace_LogicalCompare(LogicalCompare_t* x) {
        ASR::expr_t** current_expr_copy_74 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_74;
        ASR::expr_t** current_expr_copy_75 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_75;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_76 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_76;
        }
    }


    void replace_LogicalBinOp(LogicalBinOp_t* x) {
        ASR::expr_t** current_expr_copy_77 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_77;
        ASR::expr_t** current_expr_copy_78 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_78;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_79 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_79;
        }
    }


    void replace_ListConstant(ListConstant_t* x) {
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::expr_t** current_expr_copy_80 = current_expr;
            current_expr = &(x->m_args[i]);
            self().replace_expr(x->m_args[i]);
            current_expr = current_expr_copy_80;
        }
        self().replace_ttype(x->m_type);
    }


    void replace_ListLen(ListLen_t* x) {
        ASR::expr_t** current_expr_copy_81 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_81;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_82 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_82;
        }
    }


    void replace_ListConcat(ListConcat_t* x) {
        ASR::expr_t** current_expr_copy_83 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_83;
        ASR::expr_t** current_expr_copy_84 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_84;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_85 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_85;
        }
    }


    void replace_ListCompare(ListCompare_t* x) {
        ASR::expr_t** current_expr_copy_86 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_86;
        ASR::expr_t** current_expr_copy_87 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_87;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_88 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_88;
        }
    }


    void replace_ListCount(ListCount_t* x) {
        ASR::expr_t** current_expr_copy_89 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_89;
        ASR::expr_t** current_expr_copy_90 = current_expr;
        current_expr = &(x->m_ele);
        self().replace_expr(x->m_ele);
        current_expr = current_expr_copy_90;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_91 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_91;
        }
    }


    void replace_SetConstant(SetConstant_t* x) {
        for (size_t i = 0; i < x->n_elements; i++) {
            ASR::expr_t** current_expr_copy_92 = current_expr;
            current_expr = &(x->m_elements[i]);
            self().replace_expr(x->m_elements[i]);
            current_expr = current_expr_copy_92;
        }
        self().replace_ttype(x->m_type);
    }


    void replace_SetLen(SetLen_t* x) {
        ASR::expr_t** current_expr_copy_93 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_93;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_94 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_94;
        }
    }


    void replace_TupleConstant(TupleConstant_t* x) {
        for (size_t i = 0; i < x->n_elements; i++) {
            ASR::expr_t** current_expr_copy_95 = current_expr;
            current_expr = &(x->m_elements[i]);
            self().replace_expr(x->m_elements[i]);
            current_expr = current_expr_copy_95;
        }
        self().replace_ttype(x->m_type);
    }


    void replace_TupleLen(TupleLen_t* x) {
        ASR::expr_t** current_expr_copy_96 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_96;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_97 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_97;
        }
    }


    void replace_TupleCompare(TupleCompare_t* x) {
        ASR::expr_t** current_expr_copy_98 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_98;
        ASR::expr_t** current_expr_copy_99 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_99;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_100 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_100;
        }
    }


    void replace_TupleConcat(TupleConcat_t* x) {
        ASR::expr_t** current_expr_copy_101 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_101;
        ASR::expr_t** current_expr_copy_102 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_102;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_103 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_103;
        }
    }


    void replace_StringConstant(StringConstant_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_StringConcat(StringConcat_t* x) {
        ASR::expr_t** current_expr_copy_104 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_104;
        ASR::expr_t** current_expr_copy_105 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_105;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_106 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_106;
        }
    }


    void replace_StringRepeat(StringRepeat_t* x) {
        ASR::expr_t** current_expr_copy_107 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_107;
        ASR::expr_t** current_expr_copy_108 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_108;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_109 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_109;
        }
    }


    void replace_StringLen(StringLen_t* x) {
        ASR::expr_t** current_expr_copy_110 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_110;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_111 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_111;
        }
    }


    void replace_StringItem(StringItem_t* x) {
        ASR::expr_t** current_expr_copy_112 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_112;
        ASR::expr_t** current_expr_copy_113 = current_expr;
        current_expr = &(x->m_idx);
        self().replace_expr(x->m_idx);
        current_expr = current_expr_copy_113;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_114 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_114;
        }
    }


    void replace_StringSection(StringSection_t* x) {
        ASR::expr_t** current_expr_copy_115 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_115;
        ASR::expr_t** current_expr_copy_116 = current_expr;
        current_expr = &(x->m_start);
        self().replace_expr(x->m_start);
        current_expr = current_expr_copy_116;
        ASR::expr_t** current_expr_copy_117 = current_expr;
        current_expr = &(x->m_end);
        self().replace_expr(x->m_end);
        current_expr = current_expr_copy_117;
        ASR::expr_t** current_expr_copy_118 = current_expr;
        current_expr = &(x->m_step);
        self().replace_expr(x->m_step);
        current_expr = current_expr_copy_118;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_119 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_119;
        }
    }


    void replace_StringCompare(StringCompare_t* x) {
        ASR::expr_t** current_expr_copy_120 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_120;
        ASR::expr_t** current_expr_copy_121 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_121;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_122 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_122;
        }
    }


    void replace_StringContains(StringContains_t* x) {
        ASR::expr_t** current_expr_copy_123 = current_expr;
        current_expr = &(x->m_substr);
        self().replace_expr(x->m_substr);
        current_expr = current_expr_copy_123;
        ASR::expr_t** current_expr_copy_124 = current_expr;
        current_expr = &(x->m_str);
        self().replace_expr(x->m_str);
        current_expr = current_expr_copy_124;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_125 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_125;
        }
    }


    void replace_StringOrd(StringOrd_t* x) {
        ASR::expr_t** current_expr_copy_126 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_126;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_127 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_127;
        }
    }


    void replace_StringChr(StringChr_t* x) {
        ASR::expr_t** current_expr_copy_128 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_128;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_129 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_129;
        }
    }


    void replace_StringFormat(StringFormat_t* x) {
        ASR::expr_t** current_expr_copy_130 = current_expr;
        current_expr = &(x->m_fmt);
        self().replace_expr(x->m_fmt);
        current_expr = current_expr_copy_130;
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::expr_t** current_expr_copy_131 = current_expr;
            current_expr = &(x->m_args[i]);
            self().replace_expr(x->m_args[i]);
            current_expr = current_expr_copy_131;
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_132 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_132;
        }
    }


    void replace_StringPhysicalCast(StringPhysicalCast_t* x) {
        ASR::expr_t** current_expr_copy_133 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_133;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_134 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_134;
        }
    }


    void replace_CPtrCompare(CPtrCompare_t* x) {
        ASR::expr_t** current_expr_copy_135 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_135;
        ASR::expr_t** current_expr_copy_136 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_136;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_137 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_137;
        }
    }


    void replace_SymbolicCompare(SymbolicCompare_t* x) {
        ASR::expr_t** current_expr_copy_138 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_138;
        ASR::expr_t** current_expr_copy_139 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_139;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_140 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_140;
        }
    }


    void replace_DictConstant(DictConstant_t* x) {
        for (size_t i = 0; i < x->n_keys; i++) {
            ASR::expr_t** current_expr_copy_141 = current_expr;
            current_expr = &(x->m_keys[i]);
            self().replace_expr(x->m_keys[i]);
            current_expr = current_expr_copy_141;
        }
        for (size_t i = 0; i < x->n_values; i++) {
            ASR::expr_t** current_expr_copy_142 = current_expr;
            current_expr = &(x->m_values[i]);
            self().replace_expr(x->m_values[i]);
            current_expr = current_expr_copy_142;
        }
        self().replace_ttype(x->m_type);
    }


    void replace_DictLen(DictLen_t* x) {
        ASR::expr_t** current_expr_copy_143 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_143;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_144 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_144;
        }
    }


    void replace_Var(Var_t* x) {
        if (x) { }
    }


    void replace_FunctionParam(FunctionParam_t* x) {
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_145 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_145;
        }
    }


    void replace_ArrayConstructor(ArrayConstructor_t* x) {
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::expr_t** current_expr_copy_146 = current_expr;
            current_expr = &(x->m_args[i]);
            self().replace_expr(x->m_args[i]);
            current_expr = current_expr_copy_146;
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_147 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_147;
        }
    }


    void replace_ArrayConstant(ArrayConstant_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_ArrayItem(ArrayItem_t* x) {
        ASR::expr_t** current_expr_copy_148 = current_expr;
        current_expr = &(x->m_v);
        self().replace_expr(x->m_v);
        current_expr = current_expr_copy_148;
        for (size_t i = 0; i < x->n_args; i++) {
            if (x->m_args[i].m_left != nullptr) {
                ASR::expr_t** current_expr_copy_149 = current_expr;
                current_expr = &(x->m_args[i].m_left);
                self().replace_expr(x->m_args[i].m_left);
                current_expr = current_expr_copy_149;
            }
            if (x->m_args[i].m_right != nullptr) {
                ASR::expr_t** current_expr_copy_150 = current_expr;
                current_expr = &(x->m_args[i].m_right);
                self().replace_expr(x->m_args[i].m_right);
                current_expr = current_expr_copy_150;
            }
            if (x->m_args[i].m_step != nullptr) {
                ASR::expr_t** current_expr_copy_151 = current_expr;
                current_expr = &(x->m_args[i].m_step);
                self().replace_expr(x->m_args[i].m_step);
                current_expr = current_expr_copy_151;
            }
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_152 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_152;
        }
    }


    void replace_ArraySection(ArraySection_t* x) {
        ASR::expr_t** current_expr_copy_153 = current_expr;
        current_expr = &(x->m_v);
        self().replace_expr(x->m_v);
        current_expr = current_expr_copy_153;
        for (size_t i = 0; i < x->n_args; i++) {
            if (x->m_args[i].m_left != nullptr) {
                ASR::expr_t** current_expr_copy_154 = current_expr;
                current_expr = &(x->m_args[i].m_left);
                self().replace_expr(x->m_args[i].m_left);
                current_expr = current_expr_copy_154;
            }
            if (x->m_args[i].m_right != nullptr) {
                ASR::expr_t** current_expr_copy_155 = current_expr;
                current_expr = &(x->m_args[i].m_right);
                self().replace_expr(x->m_args[i].m_right);
                current_expr = current_expr_copy_155;
            }
            if (x->m_args[i].m_step != nullptr) {
                ASR::expr_t** current_expr_copy_156 = current_expr;
                current_expr = &(x->m_args[i].m_step);
                self().replace_expr(x->m_args[i].m_step);
                current_expr = current_expr_copy_156;
            }
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_157 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_157;
        }
    }


    void replace_ArraySize(ArraySize_t* x) {
        ASR::expr_t** current_expr_copy_158 = current_expr;
        current_expr = &(x->m_v);
        self().replace_expr(x->m_v);
        current_expr = current_expr_copy_158;
        ASR::expr_t** current_expr_copy_159 = current_expr;
        current_expr = &(x->m_dim);
        self().replace_expr(x->m_dim);
        current_expr = current_expr_copy_159;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_160 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_160;
        }
    }


    void replace_ArrayBound(ArrayBound_t* x) {
        ASR::expr_t** current_expr_copy_161 = current_expr;
        current_expr = &(x->m_v);
        self().replace_expr(x->m_v);
        current_expr = current_expr_copy_161;
        ASR::expr_t** current_expr_copy_162 = current_expr;
        current_expr = &(x->m_dim);
        self().replace_expr(x->m_dim);
        current_expr = current_expr_copy_162;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_163 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_163;
        }
    }


    void replace_ArrayTranspose(ArrayTranspose_t* x) {
        ASR::expr_t** current_expr_copy_164 = current_expr;
        current_expr = &(x->m_matrix);
        self().replace_expr(x->m_matrix);
        current_expr = current_expr_copy_164;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_165 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_165;
        }
    }


    void replace_ArrayPack(ArrayPack_t* x) {
        ASR::expr_t** current_expr_copy_166 = current_expr;
        current_expr = &(x->m_array);
        self().replace_expr(x->m_array);
        current_expr = current_expr_copy_166;
        ASR::expr_t** current_expr_copy_167 = current_expr;
        current_expr = &(x->m_mask);
        self().replace_expr(x->m_mask);
        current_expr = current_expr_copy_167;
        ASR::expr_t** current_expr_copy_168 = current_expr;
        current_expr = &(x->m_vector);
        self().replace_expr(x->m_vector);
        current_expr = current_expr_copy_168;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_169 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_169;
        }
    }


    void replace_ArrayReshape(ArrayReshape_t* x) {
        ASR::expr_t** current_expr_copy_170 = current_expr;
        current_expr = &(x->m_array);
        self().replace_expr(x->m_array);
        current_expr = current_expr_copy_170;
        ASR::expr_t** current_expr_copy_171 = current_expr;
        current_expr = &(x->m_shape);
        self().replace_expr(x->m_shape);
        current_expr = current_expr_copy_171;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_172 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_172;
        }
    }


    void replace_ArrayBroadcast(ArrayBroadcast_t* x) {
        ASR::expr_t** current_expr_copy_173 = current_expr;
        current_expr = &(x->m_array);
        self().replace_expr(x->m_array);
        current_expr = current_expr_copy_173;
        ASR::expr_t** current_expr_copy_174 = current_expr;
        current_expr = &(x->m_shape);
        self().replace_expr(x->m_shape);
        current_expr = current_expr_copy_174;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_175 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_175;
        }
    }


    void replace_BitCast(BitCast_t* x) {
        ASR::expr_t** current_expr_copy_176 = current_expr;
        current_expr = &(x->m_source);
        self().replace_expr(x->m_source);
        current_expr = current_expr_copy_176;
        ASR::expr_t** current_expr_copy_177 = current_expr;
        current_expr = &(x->m_mold);
        self().replace_expr(x->m_mold);
        current_expr = current_expr_copy_177;
        ASR::expr_t** current_expr_copy_178 = current_expr;
        current_expr = &(x->m_size);
        self().replace_expr(x->m_size);
        current_expr = current_expr_copy_178;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_179 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_179;
        }
    }


    void replace_StructInstanceMember(StructInstanceMember_t* x) {
        ASR::expr_t** current_expr_copy_180 = current_expr;
        current_expr = &(x->m_v);
        self().replace_expr(x->m_v);
        current_expr = current_expr_copy_180;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_181 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_181;
        }
    }


    void replace_StructStaticMember(StructStaticMember_t* x) {
        ASR::expr_t** current_expr_copy_182 = current_expr;
        current_expr = &(x->m_v);
        self().replace_expr(x->m_v);
        current_expr = current_expr_copy_182;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_183 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_183;
        }
    }


    void replace_EnumStaticMember(EnumStaticMember_t* x) {
        ASR::expr_t** current_expr_copy_184 = current_expr;
        current_expr = &(x->m_v);
        self().replace_expr(x->m_v);
        current_expr = current_expr_copy_184;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_185 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_185;
        }
    }


    void replace_UnionInstanceMember(UnionInstanceMember_t* x) {
        ASR::expr_t** current_expr_copy_186 = current_expr;
        current_expr = &(x->m_v);
        self().replace_expr(x->m_v);
        current_expr = current_expr_copy_186;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_187 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_187;
        }
    }


    void replace_EnumName(EnumName_t* x) {
        ASR::expr_t** current_expr_copy_188 = current_expr;
        current_expr = &(x->m_v);
        self().replace_expr(x->m_v);
        current_expr = current_expr_copy_188;
        self().replace_ttype(x->m_enum_type);
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_189 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_189;
        }
    }


    void replace_EnumValue(EnumValue_t* x) {
        ASR::expr_t** current_expr_copy_190 = current_expr;
        current_expr = &(x->m_v);
        self().replace_expr(x->m_v);
        current_expr = current_expr_copy_190;
        self().replace_ttype(x->m_enum_type);
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_191 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_191;
        }
    }


    void replace_OverloadedCompare(OverloadedCompare_t* x) {
        ASR::expr_t** current_expr_copy_192 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_192;
        ASR::expr_t** current_expr_copy_193 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_193;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_194 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_194;
        }
        ASR::expr_t** current_expr_copy_195 = current_expr;
        current_expr = &(x->m_overloaded);
        self().replace_expr(x->m_overloaded);
        current_expr = current_expr_copy_195;
    }


    void replace_OverloadedBinOp(OverloadedBinOp_t* x) {
        ASR::expr_t** current_expr_copy_196 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_196;
        ASR::expr_t** current_expr_copy_197 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_197;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_198 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_198;
        }
        ASR::expr_t** current_expr_copy_199 = current_expr;
        current_expr = &(x->m_overloaded);
        self().replace_expr(x->m_overloaded);
        current_expr = current_expr_copy_199;
    }


    void replace_OverloadedUnaryMinus(OverloadedUnaryMinus_t* x) {
        ASR::expr_t** current_expr_copy_200 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_200;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_201 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_201;
        }
        ASR::expr_t** current_expr_copy_202 = current_expr;
        current_expr = &(x->m_overloaded);
        self().replace_expr(x->m_overloaded);
        current_expr = current_expr_copy_202;
    }


    void replace_OverloadedStringConcat(OverloadedStringConcat_t* x) {
        ASR::expr_t** current_expr_copy_203 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_203;
        ASR::expr_t** current_expr_copy_204 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_204;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_205 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_205;
        }
        ASR::expr_t** current_expr_copy_206 = current_expr;
        current_expr = &(x->m_overloaded);
        self().replace_expr(x->m_overloaded);
        current_expr = current_expr_copy_206;
    }


    void replace_Cast(Cast_t* x) {
        ASR::expr_t** current_expr_copy_207 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_207;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_208 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_208;
        }
    }


    void replace_ArrayPhysicalCast(ArrayPhysicalCast_t* x) {
        ASR::expr_t** current_expr_copy_209 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_209;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_210 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_210;
        }
    }


    void replace_ComplexRe(ComplexRe_t* x) {
        ASR::expr_t** current_expr_copy_211 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_211;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_212 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_212;
        }
    }


    void replace_ComplexIm(ComplexIm_t* x) {
        ASR::expr_t** current_expr_copy_213 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_213;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_214 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_214;
        }
    }


    void replace_DictItem(DictItem_t* x) {
        ASR::expr_t** current_expr_copy_215 = current_expr;
        current_expr = &(x->m_a);
        self().replace_expr(x->m_a);
        current_expr = current_expr_copy_215;
        ASR::expr_t** current_expr_copy_216 = current_expr;
        current_expr = &(x->m_key);
        self().replace_expr(x->m_key);
        current_expr = current_expr_copy_216;
        ASR::expr_t** current_expr_copy_217 = current_expr;
        current_expr = &(x->m_default);
        self().replace_expr(x->m_default);
        current_expr = current_expr_copy_217;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_218 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_218;
        }
    }


    void replace_CLoc(CLoc_t* x) {
        ASR::expr_t** current_expr_copy_219 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_219;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_220 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_220;
        }
    }


    void replace_PointerToCPtr(PointerToCPtr_t* x) {
        ASR::expr_t** current_expr_copy_221 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_221;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_222 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_222;
        }
    }


    void replace_GetPointer(GetPointer_t* x) {
        ASR::expr_t** current_expr_copy_223 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_223;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_224 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_224;
        }
    }


    void replace_ListItem(ListItem_t* x) {
        ASR::expr_t** current_expr_copy_225 = current_expr;
        current_expr = &(x->m_a);
        self().replace_expr(x->m_a);
        current_expr = current_expr_copy_225;
        ASR::expr_t** current_expr_copy_226 = current_expr;
        current_expr = &(x->m_pos);
        self().replace_expr(x->m_pos);
        current_expr = current_expr_copy_226;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_227 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_227;
        }
    }


    void replace_TupleItem(TupleItem_t* x) {
        ASR::expr_t** current_expr_copy_228 = current_expr;
        current_expr = &(x->m_a);
        self().replace_expr(x->m_a);
        current_expr = current_expr_copy_228;
        ASR::expr_t** current_expr_copy_229 = current_expr;
        current_expr = &(x->m_pos);
        self().replace_expr(x->m_pos);
        current_expr = current_expr_copy_229;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_230 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_230;
        }
    }


    void replace_ListSection(ListSection_t* x) {
        ASR::expr_t** current_expr_copy_231 = current_expr;
        current_expr = &(x->m_a);
        self().replace_expr(x->m_a);
        current_expr = current_expr_copy_231;
        if (x->m_section.m_left != nullptr) {
            ASR::expr_t** current_expr_copy_232 = current_expr;
            current_expr = &(x->m_section.m_left);
            self().replace_expr(x->m_section.m_left);
            current_expr = current_expr_copy_232;
        }
        if (x->m_section.m_right != nullptr) {
            ASR::expr_t** current_expr_copy_233 = current_expr;
            current_expr = &(x->m_section.m_right);
            self().replace_expr(x->m_section.m_right);
            current_expr = current_expr_copy_233;
        }
        if (x->m_section.m_step != nullptr) {
            ASR::expr_t** current_expr_copy_234 = current_expr;
            current_expr = &(x->m_section.m_step);
            self().replace_expr(x->m_section.m_step);
            current_expr = current_expr_copy_234;
        }
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_235 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_235;
        }
    }


    void replace_ListRepeat(ListRepeat_t* x) {
        ASR::expr_t** current_expr_copy_236 = current_expr;
        current_expr = &(x->m_left);
        self().replace_expr(x->m_left);
        current_expr = current_expr_copy_236;
        ASR::expr_t** current_expr_copy_237 = current_expr;
        current_expr = &(x->m_right);
        self().replace_expr(x->m_right);
        current_expr = current_expr_copy_237;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_238 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_238;
        }
    }


    void replace_DictPop(DictPop_t* x) {
        ASR::expr_t** current_expr_copy_239 = current_expr;
        current_expr = &(x->m_a);
        self().replace_expr(x->m_a);
        current_expr = current_expr_copy_239;
        ASR::expr_t** current_expr_copy_240 = current_expr;
        current_expr = &(x->m_key);
        self().replace_expr(x->m_key);
        current_expr = current_expr_copy_240;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_241 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_241;
        }
    }


    void replace_SetPop(SetPop_t* x) {
        ASR::expr_t** current_expr_copy_242 = current_expr;
        current_expr = &(x->m_a);
        self().replace_expr(x->m_a);
        current_expr = current_expr_copy_242;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_243 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_243;
        }
    }


    void replace_IntegerBitLen(IntegerBitLen_t* x) {
        ASR::expr_t** current_expr_copy_244 = current_expr;
        current_expr = &(x->m_a);
        self().replace_expr(x->m_a);
        current_expr = current_expr_copy_244;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_245 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_245;
        }
    }


    void replace_Ichar(Ichar_t* x) {
        ASR::expr_t** current_expr_copy_246 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_246;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_247 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_247;
        }
    }


    void replace_Iachar(Iachar_t* x) {
        ASR::expr_t** current_expr_copy_248 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_248;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_249 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_249;
        }
    }


    void replace_SizeOfType(SizeOfType_t* x) {
        self().replace_ttype(x->m_arg);
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_250 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_250;
        }
    }


    void replace_PointerNullConstant(PointerNullConstant_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_PointerAssociated(PointerAssociated_t* x) {
        ASR::expr_t** current_expr_copy_251 = current_expr;
        current_expr = &(x->m_ptr);
        self().replace_expr(x->m_ptr);
        current_expr = current_expr_copy_251;
        ASR::expr_t** current_expr_copy_252 = current_expr;
        current_expr = &(x->m_tgt);
        self().replace_expr(x->m_tgt);
        current_expr = current_expr_copy_252;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_253 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_253;
        }
    }


    void replace_RealSqrt(RealSqrt_t* x) {
        ASR::expr_t** current_expr_copy_254 = current_expr;
        current_expr = &(x->m_arg);
        self().replace_expr(x->m_arg);
        current_expr = current_expr_copy_254;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_255 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_255;
        }
    }


    void replace_ArrayIsContiguous(ArrayIsContiguous_t* x) {
        ASR::expr_t** current_expr_copy_256 = current_expr;
        current_expr = &(x->m_array);
        self().replace_expr(x->m_array);
        current_expr = current_expr_copy_256;
        self().replace_ttype(x->m_type);
        if (call_replacer_on_value) {
            ASR::expr_t** current_expr_copy_257 = current_expr;
            current_expr = &(x->m_value);
            self().replace_expr(x->m_value);
            current_expr = current_expr_copy_257;
        }
    }


    void replace_Integer(Integer_t* x) {
        if (x) { }
    }


    void replace_UnsignedInteger(UnsignedInteger_t* x) {
        if (x) { }
    }


    void replace_Real(Real_t* x) {
        if (x) { }
    }


    void replace_Complex(Complex_t* x) {
        if (x) { }
    }


    void replace_String(String_t* x) {
        ASR::expr_t** current_expr_copy_258 = current_expr;
        current_expr = &(x->m_len_expr);
        self().replace_expr(x->m_len_expr);
        current_expr = current_expr_copy_258;
    }


    void replace_Logical(Logical_t* x) {
        if (x) { }
    }


    void replace_Set(Set_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_List(List_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_Tuple(Tuple_t* x) {
        for (size_t i = 0; i < x->n_type; i++) {
            self().replace_ttype(x->m_type[i]);
        }
    }


    void replace_StructType(StructType_t* x) {
        if (x) { }
    }


    void replace_EnumType(EnumType_t* x) {
        if (x) { }
    }


    void replace_UnionType(UnionType_t* x) {
        if (x) { }
    }


    void replace_ClassType(ClassType_t* x) {
        if (x) { }
    }


    void replace_Dict(Dict_t* x) {
        self().replace_ttype(x->m_key_type);
        self().replace_ttype(x->m_value_type);
    }


    void replace_Pointer(Pointer_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_Allocatable(Allocatable_t* x) {
        self().replace_ttype(x->m_type);
    }


    void replace_CPtr(CPtr_t* x) {
        if (x) { }
    }


    void replace_SymbolicExpression(SymbolicExpression_t* x) {
        if (x) { }
    }


    void replace_TypeParameter(TypeParameter_t* x) {
        if (x) { }
    }


    void replace_Array(Array_t* x) {
        self().replace_ttype(x->m_type);
        for (size_t i = 0; i < x->n_dims; i++) {
            ASR::expr_t** current_expr_copy_259 = current_expr;
            current_expr = &(x->m_dims[i].m_length);
            self().replace_expr(x->m_dims[i].m_length);
            current_expr = current_expr_copy_259;
            ASR::expr_t** current_expr_copy_260 = current_expr;
            current_expr = &(x->m_dims[i].m_start);
            self().replace_expr(x->m_dims[i].m_start);
            current_expr = current_expr_copy_260;
        }
    }


    void replace_FunctionType(FunctionType_t* x) {
        for (size_t i = 0; i < x->n_arg_types; i++) {
            self().replace_ttype(x->m_arg_types[i]);
        }
        self().replace_ttype(x->m_return_var_type);
        for (size_t i = 0; i < x->n_restrictions; i++) {
        }
    }

    void replace_expr(ASR::expr_t* x) {
        if( !x ) {
            return ;
        }

        switch(x->type) {
            case ASR::exprType::IfExp: {
                self().replace_IfExp(down_cast<ASR::IfExp_t>(x));
                break;
            }
            case ASR::exprType::ComplexConstructor: {
                self().replace_ComplexConstructor(down_cast<ASR::ComplexConstructor_t>(x));
                break;
            }
            case ASR::exprType::NamedExpr: {
                self().replace_NamedExpr(down_cast<ASR::NamedExpr_t>(x));
                break;
            }
            case ASR::exprType::FunctionCall: {
                self().replace_FunctionCall(down_cast<ASR::FunctionCall_t>(x));
                break;
            }
            case ASR::exprType::IntrinsicElementalFunction: {
                self().replace_IntrinsicElementalFunction(down_cast<ASR::IntrinsicElementalFunction_t>(x));
                break;
            }
            case ASR::exprType::IntrinsicArrayFunction: {
                self().replace_IntrinsicArrayFunction(down_cast<ASR::IntrinsicArrayFunction_t>(x));
                break;
            }
            case ASR::exprType::IntrinsicImpureFunction: {
                self().replace_IntrinsicImpureFunction(down_cast<ASR::IntrinsicImpureFunction_t>(x));
                break;
            }
            case ASR::exprType::TypeInquiry: {
                self().replace_TypeInquiry(down_cast<ASR::TypeInquiry_t>(x));
                break;
            }
            case ASR::exprType::StructConstructor: {
                self().replace_StructConstructor(down_cast<ASR::StructConstructor_t>(x));
                break;
            }
            case ASR::exprType::StructConstant: {
                self().replace_StructConstant(down_cast<ASR::StructConstant_t>(x));
                break;
            }
            case ASR::exprType::EnumConstructor: {
                self().replace_EnumConstructor(down_cast<ASR::EnumConstructor_t>(x));
                break;
            }
            case ASR::exprType::UnionConstructor: {
                self().replace_UnionConstructor(down_cast<ASR::UnionConstructor_t>(x));
                break;
            }
            case ASR::exprType::ImpliedDoLoop: {
                self().replace_ImpliedDoLoop(down_cast<ASR::ImpliedDoLoop_t>(x));
                break;
            }
            case ASR::exprType::IntegerConstant: {
                self().replace_IntegerConstant(down_cast<ASR::IntegerConstant_t>(x));
                break;
            }
            case ASR::exprType::IntegerBitNot: {
                self().replace_IntegerBitNot(down_cast<ASR::IntegerBitNot_t>(x));
                break;
            }
            case ASR::exprType::IntegerUnaryMinus: {
                self().replace_IntegerUnaryMinus(down_cast<ASR::IntegerUnaryMinus_t>(x));
                break;
            }
            case ASR::exprType::IntegerCompare: {
                self().replace_IntegerCompare(down_cast<ASR::IntegerCompare_t>(x));
                break;
            }
            case ASR::exprType::IntegerBinOp: {
                self().replace_IntegerBinOp(down_cast<ASR::IntegerBinOp_t>(x));
                break;
            }
            case ASR::exprType::UnsignedIntegerConstant: {
                self().replace_UnsignedIntegerConstant(down_cast<ASR::UnsignedIntegerConstant_t>(x));
                break;
            }
            case ASR::exprType::UnsignedIntegerUnaryMinus: {
                self().replace_UnsignedIntegerUnaryMinus(down_cast<ASR::UnsignedIntegerUnaryMinus_t>(x));
                break;
            }
            case ASR::exprType::UnsignedIntegerBitNot: {
                self().replace_UnsignedIntegerBitNot(down_cast<ASR::UnsignedIntegerBitNot_t>(x));
                break;
            }
            case ASR::exprType::UnsignedIntegerCompare: {
                self().replace_UnsignedIntegerCompare(down_cast<ASR::UnsignedIntegerCompare_t>(x));
                break;
            }
            case ASR::exprType::UnsignedIntegerBinOp: {
                self().replace_UnsignedIntegerBinOp(down_cast<ASR::UnsignedIntegerBinOp_t>(x));
                break;
            }
            case ASR::exprType::RealConstant: {
                self().replace_RealConstant(down_cast<ASR::RealConstant_t>(x));
                break;
            }
            case ASR::exprType::RealUnaryMinus: {
                self().replace_RealUnaryMinus(down_cast<ASR::RealUnaryMinus_t>(x));
                break;
            }
            case ASR::exprType::RealCompare: {
                self().replace_RealCompare(down_cast<ASR::RealCompare_t>(x));
                break;
            }
            case ASR::exprType::RealBinOp: {
                self().replace_RealBinOp(down_cast<ASR::RealBinOp_t>(x));
                break;
            }
            case ASR::exprType::RealCopySign: {
                self().replace_RealCopySign(down_cast<ASR::RealCopySign_t>(x));
                break;
            }
            case ASR::exprType::ComplexConstant: {
                self().replace_ComplexConstant(down_cast<ASR::ComplexConstant_t>(x));
                break;
            }
            case ASR::exprType::ComplexUnaryMinus: {
                self().replace_ComplexUnaryMinus(down_cast<ASR::ComplexUnaryMinus_t>(x));
                break;
            }
            case ASR::exprType::ComplexCompare: {
                self().replace_ComplexCompare(down_cast<ASR::ComplexCompare_t>(x));
                break;
            }
            case ASR::exprType::ComplexBinOp: {
                self().replace_ComplexBinOp(down_cast<ASR::ComplexBinOp_t>(x));
                break;
            }
            case ASR::exprType::LogicalConstant: {
                self().replace_LogicalConstant(down_cast<ASR::LogicalConstant_t>(x));
                break;
            }
            case ASR::exprType::LogicalNot: {
                self().replace_LogicalNot(down_cast<ASR::LogicalNot_t>(x));
                break;
            }
            case ASR::exprType::LogicalCompare: {
                self().replace_LogicalCompare(down_cast<ASR::LogicalCompare_t>(x));
                break;
            }
            case ASR::exprType::LogicalBinOp: {
                self().replace_LogicalBinOp(down_cast<ASR::LogicalBinOp_t>(x));
                break;
            }
            case ASR::exprType::ListConstant: {
                self().replace_ListConstant(down_cast<ASR::ListConstant_t>(x));
                break;
            }
            case ASR::exprType::ListLen: {
                self().replace_ListLen(down_cast<ASR::ListLen_t>(x));
                break;
            }
            case ASR::exprType::ListConcat: {
                self().replace_ListConcat(down_cast<ASR::ListConcat_t>(x));
                break;
            }
            case ASR::exprType::ListCompare: {
                self().replace_ListCompare(down_cast<ASR::ListCompare_t>(x));
                break;
            }
            case ASR::exprType::ListCount: {
                self().replace_ListCount(down_cast<ASR::ListCount_t>(x));
                break;
            }
            case ASR::exprType::SetConstant: {
                self().replace_SetConstant(down_cast<ASR::SetConstant_t>(x));
                break;
            }
            case ASR::exprType::SetLen: {
                self().replace_SetLen(down_cast<ASR::SetLen_t>(x));
                break;
            }
            case ASR::exprType::TupleConstant: {
                self().replace_TupleConstant(down_cast<ASR::TupleConstant_t>(x));
                break;
            }
            case ASR::exprType::TupleLen: {
                self().replace_TupleLen(down_cast<ASR::TupleLen_t>(x));
                break;
            }
            case ASR::exprType::TupleCompare: {
                self().replace_TupleCompare(down_cast<ASR::TupleCompare_t>(x));
                break;
            }
            case ASR::exprType::TupleConcat: {
                self().replace_TupleConcat(down_cast<ASR::TupleConcat_t>(x));
                break;
            }
            case ASR::exprType::StringConstant: {
                self().replace_StringConstant(down_cast<ASR::StringConstant_t>(x));
                break;
            }
            case ASR::exprType::StringConcat: {
                self().replace_StringConcat(down_cast<ASR::StringConcat_t>(x));
                break;
            }
            case ASR::exprType::StringRepeat: {
                self().replace_StringRepeat(down_cast<ASR::StringRepeat_t>(x));
                break;
            }
            case ASR::exprType::StringLen: {
                self().replace_StringLen(down_cast<ASR::StringLen_t>(x));
                break;
            }
            case ASR::exprType::StringItem: {
                self().replace_StringItem(down_cast<ASR::StringItem_t>(x));
                break;
            }
            case ASR::exprType::StringSection: {
                self().replace_StringSection(down_cast<ASR::StringSection_t>(x));
                break;
            }
            case ASR::exprType::StringCompare: {
                self().replace_StringCompare(down_cast<ASR::StringCompare_t>(x));
                break;
            }
            case ASR::exprType::StringContains: {
                self().replace_StringContains(down_cast<ASR::StringContains_t>(x));
                break;
            }
            case ASR::exprType::StringOrd: {
                self().replace_StringOrd(down_cast<ASR::StringOrd_t>(x));
                break;
            }
            case ASR::exprType::StringChr: {
                self().replace_StringChr(down_cast<ASR::StringChr_t>(x));
                break;
            }
            case ASR::exprType::StringFormat: {
                self().replace_StringFormat(down_cast<ASR::StringFormat_t>(x));
                break;
            }
            case ASR::exprType::StringPhysicalCast: {
                self().replace_StringPhysicalCast(down_cast<ASR::StringPhysicalCast_t>(x));
                break;
            }
            case ASR::exprType::CPtrCompare: {
                self().replace_CPtrCompare(down_cast<ASR::CPtrCompare_t>(x));
                break;
            }
            case ASR::exprType::SymbolicCompare: {
                self().replace_SymbolicCompare(down_cast<ASR::SymbolicCompare_t>(x));
                break;
            }
            case ASR::exprType::DictConstant: {
                self().replace_DictConstant(down_cast<ASR::DictConstant_t>(x));
                break;
            }
            case ASR::exprType::DictLen: {
                self().replace_DictLen(down_cast<ASR::DictLen_t>(x));
                break;
            }
            case ASR::exprType::Var: {
                self().replace_Var(down_cast<ASR::Var_t>(x));
                break;
            }
            case ASR::exprType::FunctionParam: {
                self().replace_FunctionParam(down_cast<ASR::FunctionParam_t>(x));
                break;
            }
            case ASR::exprType::ArrayConstructor: {
                self().replace_ArrayConstructor(down_cast<ASR::ArrayConstructor_t>(x));
                break;
            }
            case ASR::exprType::ArrayConstant: {
                self().replace_ArrayConstant(down_cast<ASR::ArrayConstant_t>(x));
                break;
            }
            case ASR::exprType::ArrayItem: {
                self().replace_ArrayItem(down_cast<ASR::ArrayItem_t>(x));
                break;
            }
            case ASR::exprType::ArraySection: {
                self().replace_ArraySection(down_cast<ASR::ArraySection_t>(x));
                break;
            }
            case ASR::exprType::ArraySize: {
                self().replace_ArraySize(down_cast<ASR::ArraySize_t>(x));
                break;
            }
            case ASR::exprType::ArrayBound: {
                self().replace_ArrayBound(down_cast<ASR::ArrayBound_t>(x));
                break;
            }
            case ASR::exprType::ArrayTranspose: {
                self().replace_ArrayTranspose(down_cast<ASR::ArrayTranspose_t>(x));
                break;
            }
            case ASR::exprType::ArrayPack: {
                self().replace_ArrayPack(down_cast<ASR::ArrayPack_t>(x));
                break;
            }
            case ASR::exprType::ArrayReshape: {
                self().replace_ArrayReshape(down_cast<ASR::ArrayReshape_t>(x));
                break;
            }
            case ASR::exprType::ArrayBroadcast: {
                self().replace_ArrayBroadcast(down_cast<ASR::ArrayBroadcast_t>(x));
                break;
            }
            case ASR::exprType::BitCast: {
                self().replace_BitCast(down_cast<ASR::BitCast_t>(x));
                break;
            }
            case ASR::exprType::StructInstanceMember: {
                self().replace_StructInstanceMember(down_cast<ASR::StructInstanceMember_t>(x));
                break;
            }
            case ASR::exprType::StructStaticMember: {
                self().replace_StructStaticMember(down_cast<ASR::StructStaticMember_t>(x));
                break;
            }
            case ASR::exprType::EnumStaticMember: {
                self().replace_EnumStaticMember(down_cast<ASR::EnumStaticMember_t>(x));
                break;
            }
            case ASR::exprType::UnionInstanceMember: {
                self().replace_UnionInstanceMember(down_cast<ASR::UnionInstanceMember_t>(x));
                break;
            }
            case ASR::exprType::EnumName: {
                self().replace_EnumName(down_cast<ASR::EnumName_t>(x));
                break;
            }
            case ASR::exprType::EnumValue: {
                self().replace_EnumValue(down_cast<ASR::EnumValue_t>(x));
                break;
            }
            case ASR::exprType::OverloadedCompare: {
                self().replace_OverloadedCompare(down_cast<ASR::OverloadedCompare_t>(x));
                break;
            }
            case ASR::exprType::OverloadedBinOp: {
                self().replace_OverloadedBinOp(down_cast<ASR::OverloadedBinOp_t>(x));
                break;
            }
            case ASR::exprType::OverloadedUnaryMinus: {
                self().replace_OverloadedUnaryMinus(down_cast<ASR::OverloadedUnaryMinus_t>(x));
                break;
            }
            case ASR::exprType::OverloadedStringConcat: {
                self().replace_OverloadedStringConcat(down_cast<ASR::OverloadedStringConcat_t>(x));
                break;
            }
            case ASR::exprType::Cast: {
                self().replace_Cast(down_cast<ASR::Cast_t>(x));
                break;
            }
            case ASR::exprType::ArrayPhysicalCast: {
                self().replace_ArrayPhysicalCast(down_cast<ASR::ArrayPhysicalCast_t>(x));
                break;
            }
            case ASR::exprType::ComplexRe: {
                self().replace_ComplexRe(down_cast<ASR::ComplexRe_t>(x));
                break;
            }
            case ASR::exprType::ComplexIm: {
                self().replace_ComplexIm(down_cast<ASR::ComplexIm_t>(x));
                break;
            }
            case ASR::exprType::DictItem: {
                self().replace_DictItem(down_cast<ASR::DictItem_t>(x));
                break;
            }
            case ASR::exprType::CLoc: {
                self().replace_CLoc(down_cast<ASR::CLoc_t>(x));
                break;
            }
            case ASR::exprType::PointerToCPtr: {
                self().replace_PointerToCPtr(down_cast<ASR::PointerToCPtr_t>(x));
                break;
            }
            case ASR::exprType::GetPointer: {
                self().replace_GetPointer(down_cast<ASR::GetPointer_t>(x));
                break;
            }
            case ASR::exprType::ListItem: {
                self().replace_ListItem(down_cast<ASR::ListItem_t>(x));
                break;
            }
            case ASR::exprType::TupleItem: {
                self().replace_TupleItem(down_cast<ASR::TupleItem_t>(x));
                break;
            }
            case ASR::exprType::ListSection: {
                self().replace_ListSection(down_cast<ASR::ListSection_t>(x));
                break;
            }
            case ASR::exprType::ListRepeat: {
                self().replace_ListRepeat(down_cast<ASR::ListRepeat_t>(x));
                break;
            }
            case ASR::exprType::DictPop: {
                self().replace_DictPop(down_cast<ASR::DictPop_t>(x));
                break;
            }
            case ASR::exprType::SetPop: {
                self().replace_SetPop(down_cast<ASR::SetPop_t>(x));
                break;
            }
            case ASR::exprType::IntegerBitLen: {
                self().replace_IntegerBitLen(down_cast<ASR::IntegerBitLen_t>(x));
                break;
            }
            case ASR::exprType::Ichar: {
                self().replace_Ichar(down_cast<ASR::Ichar_t>(x));
                break;
            }
            case ASR::exprType::Iachar: {
                self().replace_Iachar(down_cast<ASR::Iachar_t>(x));
                break;
            }
            case ASR::exprType::SizeOfType: {
                self().replace_SizeOfType(down_cast<ASR::SizeOfType_t>(x));
                break;
            }
            case ASR::exprType::PointerNullConstant: {
                self().replace_PointerNullConstant(down_cast<ASR::PointerNullConstant_t>(x));
                break;
            }
            case ASR::exprType::PointerAssociated: {
                self().replace_PointerAssociated(down_cast<ASR::PointerAssociated_t>(x));
                break;
            }
            case ASR::exprType::RealSqrt: {
                self().replace_RealSqrt(down_cast<ASR::RealSqrt_t>(x));
                break;
            }
            case ASR::exprType::ArrayIsContiguous: {
                self().replace_ArrayIsContiguous(down_cast<ASR::ArrayIsContiguous_t>(x));
                break;
            }
            default: {
                LCOMPILERS_ASSERT_MSG(false, "Replacement in  " + std::to_string(x->type) + " expression is not supported yet.");
            }
        }

    }
    void replace_ttype(ASR::ttype_t* x) {
        if( !x ) {
            return ;
        }

        switch(x->type) {
            case ASR::ttypeType::Integer: {
                self().replace_Integer(down_cast<ASR::Integer_t>(x));
                break;
            }
            case ASR::ttypeType::UnsignedInteger: {
                self().replace_UnsignedInteger(down_cast<ASR::UnsignedInteger_t>(x));
                break;
            }
            case ASR::ttypeType::Real: {
                self().replace_Real(down_cast<ASR::Real_t>(x));
                break;
            }
            case ASR::ttypeType::Complex: {
                self().replace_Complex(down_cast<ASR::Complex_t>(x));
                break;
            }
            case ASR::ttypeType::String: {
                self().replace_String(down_cast<ASR::String_t>(x));
                break;
            }
            case ASR::ttypeType::Logical: {
                self().replace_Logical(down_cast<ASR::Logical_t>(x));
                break;
            }
            case ASR::ttypeType::Set: {
                self().replace_Set(down_cast<ASR::Set_t>(x));
                break;
            }
            case ASR::ttypeType::List: {
                self().replace_List(down_cast<ASR::List_t>(x));
                break;
            }
            case ASR::ttypeType::Tuple: {
                self().replace_Tuple(down_cast<ASR::Tuple_t>(x));
                break;
            }
            case ASR::ttypeType::StructType: {
                self().replace_StructType(down_cast<ASR::StructType_t>(x));
                break;
            }
            case ASR::ttypeType::EnumType: {
                self().replace_EnumType(down_cast<ASR::EnumType_t>(x));
                break;
            }
            case ASR::ttypeType::UnionType: {
                self().replace_UnionType(down_cast<ASR::UnionType_t>(x));
                break;
            }
            case ASR::ttypeType::ClassType: {
                self().replace_ClassType(down_cast<ASR::ClassType_t>(x));
                break;
            }
            case ASR::ttypeType::Dict: {
                self().replace_Dict(down_cast<ASR::Dict_t>(x));
                break;
            }
            case ASR::ttypeType::Pointer: {
                self().replace_Pointer(down_cast<ASR::Pointer_t>(x));
                break;
            }
            case ASR::ttypeType::Allocatable: {
                self().replace_Allocatable(down_cast<ASR::Allocatable_t>(x));
                break;
            }
            case ASR::ttypeType::CPtr: {
                self().replace_CPtr(down_cast<ASR::CPtr_t>(x));
                break;
            }
            case ASR::ttypeType::SymbolicExpression: {
                self().replace_SymbolicExpression(down_cast<ASR::SymbolicExpression_t>(x));
                break;
            }
            case ASR::ttypeType::TypeParameter: {
                self().replace_TypeParameter(down_cast<ASR::TypeParameter_t>(x));
                break;
            }
            case ASR::ttypeType::Array: {
                self().replace_Array(down_cast<ASR::Array_t>(x));
                break;
            }
            case ASR::ttypeType::FunctionType: {
                self().replace_FunctionType(down_cast<ASR::FunctionType_t>(x));
                break;
            }
            default: {
                LCOMPILERS_ASSERT_MSG(false, "Replacement in " + std::to_string(x->type) + " type is not supported yet.");
            }
        }

    }

};


}
