;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; RUN: igc_opt --typed-pointers %s -S -o - -ocl -inputocl -platformdg2 -igc-vectorpreprocess | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v16:16:16-v24:32:32-v32:32:32-v48:64:64-v64:64:64-v96:128:128-v128:128:128-v192:256:256-v256:256:256-v512:512:512-v1024:1024:1024-n8:16:32"
target triple = "spir64-unknown-unknown"

; CHECK: [[VEC4:%.*]] = call <4 x i64> @llvm.genx.GenISA.ldrawvector.indexed.v4i64.p2490368v4i64(<4 x i64> addrspace(2490368)* %bo0, i32 0, i32 32, i1 false)
; CHECK: [[ELT0:%.*]] = extractelement <4 x i64> [[VEC4]], i32 0
; CHECK: [[ELT1:%.*]] = extractelement <4 x i64> [[VEC4]], i32 1
; CHECK: [[ELT2:%.*]] = extractelement <4 x i64> [[VEC4]], i32 2
; CHECK: call void @llvm.genx.GenISA.storeraw.indexed.p2490368i64.i64(i64 addrspace(2490368)* %bo1, i32 0, i64 [[ELT0]], i32 8, i1 false)
; CHECK: call void @llvm.genx.GenISA.storeraw.indexed.p2490368i64.i64(i64 addrspace(2490368)* %bo1, i32 8, i64 [[ELT1]], i32 8, i1 false)
; CHECK: call void @llvm.genx.GenISA.storeraw.indexed.p2490368i64.i64(i64 addrspace(2490368)* %bo1, i32 16, i64 [[ELT2]], i32 8, i1 false)

; Function Attrs: convergent nounwind
define spir_kernel void @test_kernel(<3 x i64> addrspace(1)* %input, i64 addrspace(1)* %output, <8 x i32> %r0, <8 x i32> %payloadHeader, <3 x i32> %enqueuedLocalSize, i16 %localIdX, i16 %localIdY, i16 %localIdZ, i8* %privateBase, i32 %bufferOffset, i32 %bufferOffset1, i32 %bindlessOffset, i32 %bindlessOffset2) {
entry:
  %bo0 = inttoptr i32 %bindlessOffset to <4 x i64> addrspace(2490368)*
  %vec4 = call <4 x i64> @llvm.genx.GenISA.ldrawvector.indexed.v4i64.p2490368v4i64(<4 x i64> addrspace(2490368)* %bo0, i32 0, i32 32, i1 false)
  %v0 = extractelement <4 x i64> %vec4, i32 0
  %v1 = extractelement <4 x i64> %vec4, i32 1
  %v2 = extractelement <4 x i64> %vec4, i32 2
  %bo1 = inttoptr i32 %bindlessOffset2 to i64 addrspace(2490368)*
  call void @llvm.genx.GenISA.storeraw.indexed.p2490368i64.i64(i64 addrspace(2490368)* %bo1, i32 0, i64 %v0, i32 8, i1 false)
  call void @llvm.genx.GenISA.storeraw.indexed.p2490368i64.i64(i64 addrspace(2490368)* %bo1, i32 8, i64 %v1, i32 8, i1 false)
  call void @llvm.genx.GenISA.storeraw.indexed.p2490368i64.i64(i64 addrspace(2490368)* %bo1, i32 16, i64 %v2, i32 8, i1 false)
  ret void
}

; Function Attrs: argmemonly nounwind readonly
declare <4 x i64> @llvm.genx.GenISA.ldrawvector.indexed.v4i64.p2490368v4i64(<4 x i64> addrspace(2490368)*, i32, i32, i1) #5

; Function Attrs: argmemonly nounwind writeonly
declare void @llvm.genx.GenISA.storerawvector.indexed.p2490368v4i32.v4i32(<4 x i32> addrspace(2490368)*, i32, <4 x i32>, i32, i1) #6

; Function Attrs: argmemonly nounwind writeonly
declare void @llvm.genx.GenISA.storeraw.indexed.p2490368i64.i64(i64 addrspace(2490368)*, i32, i64, i32, i1) #6

attributes #0 = { convergent nounwind "less-precise-fpmad"="true" }
attributes #1 = { argmemonly nounwind }
attributes #2 = { convergent "correctly-rounded-divide-sqrt-fp-math"="false" "denorms-are-zero"="false" "disable-tail-calls"="false" "less-precise-fpmad"="false" "no-frame-pointer-elim"="false" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "unsafe-fp-math"="false" "use-soft-float"="false" }
attributes #3 = { convergent nounwind readnone "correctly-rounded-divide-sqrt-fp-math"="false" "denorms-are-zero"="false" "disable-tail-calls"="false" "less-precise-fpmad"="false" "no-frame-pointer-elim"="false" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "unsafe-fp-math"="false" "use-soft-float"="false" }
attributes #4 = { nounwind }
attributes #5 = { argmemonly nounwind readonly }
attributes #6 = { argmemonly nounwind writeonly }

!spirv.MemoryModel = !{!0}
!spirv.Source = !{!1}
!spirv.Generator = !{!2}
!igc.functions = !{!3}
!IGCMetadata = !{!20}
!opencl.ocl.version = !{!342, !342, !342, !342, !342}
!opencl.spir.version = !{!342, !342, !342, !342, !342}
!llvm.ident = !{!343, !343, !343, !343, !343}
!llvm.module.flags = !{!344}

!0 = !{i32 2, i32 2}
!1 = !{i32 3, i32 102000}
!2 = !{i16 6, i16 14}
!3 = !{void (<3 x i64> addrspace(1)*, i64 addrspace(1)*, <8 x i32>, <8 x i32>, <3 x i32>, i16, i16, i16, i8*, i32, i32, i32, i32)* @test_kernel, !4}
!4 = !{!5, !6}
!5 = !{!"function_type", i32 0}
!6 = !{!"implicit_arg_desc", !7, !8, !9, !10, !11, !12, !13, !14, !16, !18, !19}
!7 = !{i32 0}
!8 = !{i32 1}
!9 = !{i32 6}
!10 = !{i32 7}
!11 = !{i32 8}
!12 = !{i32 9}
!13 = !{i32 12}
!14 = !{i32 14, !15}
!15 = !{!"explicit_arg_num", i32 0}
!16 = !{i32 14, !17}
!17 = !{!"explicit_arg_num", i32 1}
!18 = !{i32 57, !15}
!19 = !{i32 57, !17}
!20 = !{!"ModuleMD", !21, !22, !97, !193, !224, !240, !261, !271, !273, !274, !287, !288, !289, !290, !294, !295, !302, !303, !304, !305, !306, !307, !308, !309, !310, !311, !312, !314, !318, !319, !320, !321, !322, !323, !324, !325, !326, !327, !328, !162, !329, !332, !333, !335, !338, !339, !340}
!21 = !{!"isPrecise", i1 false}
!22 = !{!"compOpt", !23, !24, !25, !26, !27, !28, !29, !30, !31, !32, !33, !34, !35, !36, !37, !38, !39, !40, !41, !42, !43, !44, !45, !46, !47, !48, !49, !50, !51, !52, !53, !54, !55, !56, !57, !58, !59, !60, !61, !62, !63, !64, !65, !66, !67, !68, !69, !70, !71, !72, !73, !74, !75, !76, !77, !78, !79, !80, !81, !82, !83, !84, !85, !86, !87, !88, !89, !90, !91, !92, !93, !94, !95, !96}
!23 = !{!"DenormsAreZero", i1 false}
!24 = !{!"BFTFDenormsAreZero", i1 false}
!25 = !{!"CorrectlyRoundedDivSqrt", i1 false}
!26 = !{!"OptDisable", i1 false}
!27 = !{!"MadEnable", i1 true}
!28 = !{!"NoSignedZeros", i1 false}
!29 = !{!"NoNaNs", i1 false}
!30 = !{!"FloatRoundingMode", i32 0}
!31 = !{!"FloatCvtIntRoundingMode", i32 3}
!32 = !{!"LoadCacheDefault", i32 4}
!33 = !{!"StoreCacheDefault", i32 7}
!34 = !{!"VISAPreSchedRPThreshold", i32 0}
!35 = !{!"SetLoopUnrollThreshold", i32 0}
!36 = !{!"UnsafeMathOptimizations", i1 false}
!37 = !{!"disableCustomUnsafeOpts", i1 false}
!38 = !{!"disableReducePow", i1 false}
!39 = !{!"disableSqrtOpt", i1 false}
!40 = !{!"FiniteMathOnly", i1 false}
!41 = !{!"FastRelaxedMath", i1 false}
!42 = !{!"DashGSpecified", i1 false}
!43 = !{!"FastCompilation", i1 false}
!44 = !{!"UseScratchSpacePrivateMemory", i1 false}
!45 = !{!"RelaxedBuiltins", i1 false}
!46 = !{!"SubgroupIndependentForwardProgressRequired", i1 true}
!47 = !{!"GreaterThan2GBBufferRequired", i1 true}
!48 = !{!"GreaterThan4GBBufferRequired", i1 false}
!49 = !{!"DisableA64WA", i1 false}
!50 = !{!"ForceEnableA64WA", i1 false}
!51 = !{!"PushConstantsEnable", i1 true}
!52 = !{!"HasPositivePointerOffset", i1 false}
!53 = !{!"HasBufferOffsetArg", i1 true}
!54 = !{!"BufferOffsetArgOptional", i1 true}
!55 = !{!"replaceGlobalOffsetsByZero", i1 false}
!56 = !{!"forcePixelShaderSIMDMode", i32 0}
!57 = !{!"pixelShaderDoNotAbortOnSpill", i1 false}
!58 = !{!"UniformWGS", i1 false}
!59 = !{!"disableVertexComponentPacking", i1 false}
!60 = !{!"disablePartialVertexComponentPacking", i1 false}
!61 = !{!"PreferBindlessImages", i1 true}
!62 = !{!"UseBindlessMode", i1 true}
!63 = !{!"UseLegacyBindlessMode", i1 false}
!64 = !{!"disableMathRefactoring", i1 false}
!65 = !{!"atomicBranch", i1 false}
!66 = !{!"spillCompression", i1 false}
!67 = !{!"ForceInt32DivRemEmu", i1 false}
!68 = !{!"ForceInt32DivRemEmuSP", i1 false}
!69 = !{!"DisableFastestSingleCSSIMD", i1 false}
!70 = !{!"DisableFastestLinearScan", i1 false}
!71 = !{!"UseStatelessforPrivateMemory", i1 false}
!72 = !{!"EnableTakeGlobalAddress", i1 false}
!73 = !{!"IsLibraryCompilation", i1 false}
!74 = !{!"LibraryCompileSIMDSize", i32 0}
!75 = !{!"FastVISACompile", i1 false}
!76 = !{!"MatchSinCosPi", i1 false}
!77 = !{!"ExcludeIRFromZEBinary", i1 false}
!78 = !{!"EmitZeBinVISASections", i1 false}
!79 = !{!"FP64GenEmulationEnabled", i1 false}
!80 = !{!"allowDisableRematforCS", i1 false}
!81 = !{!"DisableIncSpillCostAllAddrTaken", i1 false}
!82 = !{!"DisableCPSOmaskWA", i1 false}
!83 = !{!"DisableFastestGopt", i1 false}
!84 = !{!"WaForceHalfPromotionComputeShader", i1 false}
!85 = !{!"WaForceHalfPromotionPixelVertexShader", i1 false}
!86 = !{!"DisableConstantCoalescing", i1 false}
!87 = !{!"EnableUndefAlphaOutputAsRed", i1 true}
!88 = !{!"WaEnableALTModeVisaWA", i1 false}
!89 = !{!"NewSpillCostFunction", i1 false}
!90 = !{!"ForceLargeGRFNum4RQ", i1 false}
!91 = !{!"DisableEUFusion", i1 false}
!92 = !{!"DisableFDivToFMulInvOpt", i1 false}
!93 = !{!"initializePhiSampleSourceWA", i1 false}
!94 = !{!"WaDisableSubspanUseNoMaskForCB", i1 false}
!95 = !{!"DisableLoosenSimd32Occu", i1 false}
!96 = !{!"FastestS1Options", i32 0}
!97 = !{!"FuncMD", !98, !99}
!98 = !{!"FuncMDMap[0]", void (<3 x i64> addrspace(1)*, i64 addrspace(1)*, <8 x i32>, <8 x i32>, <3 x i32>, i16, i16, i16, i8*, i32, i32, i32, i32)* @test_kernel}
!99 = !{!"FuncMDValue[0]", !100, !101, !105, !106, !107, !128, !154, !155, !156, !157, !158, !159, !160, !161, !162, !163, !164, !165, !166, !167, !168, !169, !170, !173, !176, !179, !182, !185, !188, !189}
!100 = !{!"localOffsets"}
!101 = !{!"workGroupWalkOrder", !102, !103, !104}
!102 = !{!"dim0", i32 0}
!103 = !{!"dim1", i32 1}
!104 = !{!"dim2", i32 2}
!105 = !{!"funcArgs"}
!106 = !{!"functionType", !"KernelFunction"}
!107 = !{!"rtInfo", !108, !109, !110, !111, !112, !113, !114, !115, !116, !117, !118, !119, !120, !121, !122, !123, !127}
!108 = !{!"callableShaderType", !"NumberOfCallableShaderTypes"}
!109 = !{!"isContinuation", i1 false}
!110 = !{!"hasTraceRayPayload", i1 false}
!111 = !{!"hasHitAttributes", i1 false}
!112 = !{!"hasCallableData", i1 false}
!113 = !{!"ShaderStackSize", i32 0}
!114 = !{!"ShaderHash", i64 0}
!115 = !{!"ShaderName", !""}
!116 = !{!"ParentName", !""}
!117 = !{!"SlotNum", i1* null}
!118 = !{!"NOSSize", i32 0}
!119 = !{!"globalRootSignatureSize", i32 0}
!120 = !{!"Entries"}
!121 = !{!"SpillUnions"}
!122 = !{!"CustomHitAttrSizeInBytes", i32 0}
!123 = !{!"Types", !124, !125, !126}
!124 = !{!"FrameStartTys"}
!125 = !{!"ArgumentTys"}
!126 = !{!"FullFrameTys"}
!127 = !{!"Aliases"}
!128 = !{!"resAllocMD", !129, !130, !131, !132, !153}
!129 = !{!"uavsNumType", i32 7}
!130 = !{!"srvsNumType", i32 0}
!131 = !{!"samplersNumType", i32 0}
!132 = !{!"argAllocMDList", !133, !137, !139, !142, !143, !144, !145, !146, !147, !149, !150, !151, !152}
!133 = !{!"argAllocMDListVec[0]", !134, !135, !136}
!134 = !{!"type", i32 1}
!135 = !{!"extensionType", i32 -1}
!136 = !{!"indexType", i32 3}
!137 = !{!"argAllocMDListVec[1]", !134, !135, !138}
!138 = !{!"indexType", i32 4}
!139 = !{!"argAllocMDListVec[2]", !140, !135, !141}
!140 = !{!"type", i32 0}
!141 = !{!"indexType", i32 -1}
!142 = !{!"argAllocMDListVec[3]", !140, !135, !141}
!143 = !{!"argAllocMDListVec[4]", !140, !135, !141}
!144 = !{!"argAllocMDListVec[5]", !140, !135, !141}
!145 = !{!"argAllocMDListVec[6]", !140, !135, !141}
!146 = !{!"argAllocMDListVec[7]", !140, !135, !141}
!147 = !{!"argAllocMDListVec[8]", !134, !135, !148}
!148 = !{!"indexType", i32 2}
!149 = !{!"argAllocMDListVec[9]", !140, !135, !141}
!150 = !{!"argAllocMDListVec[10]", !140, !135, !141}
!151 = !{!"argAllocMDListVec[11]", !140, !135, !141}
!152 = !{!"argAllocMDListVec[12]", !140, !135, !141}
!153 = !{!"inlineSamplersMD"}
!154 = !{!"maxByteOffsets"}
!155 = !{!"IsInitializer", i1 false}
!156 = !{!"IsFinalizer", i1 false}
!157 = !{!"CompiledSubGroupsNumber", i32 0}
!158 = !{!"hasInlineVmeSamplers", i1 false}
!159 = !{!"localSize", i32 0}
!160 = !{!"localIDPresent", i1 false}
!161 = !{!"groupIDPresent", i1 false}
!162 = !{!"privateMemoryPerWI", i32 0}
!163 = !{!"prevFPOffset", i32 0}
!164 = !{!"globalIDPresent", i1 false}
!165 = !{!"hasSyncRTCalls", i1 false}
!166 = !{!"hasNonKernelArgLoad", i1 false}
!167 = !{!"hasNonKernelArgStore", i1 false}
!168 = !{!"hasNonKernelArgAtomic", i1 false}
!169 = !{!"UserAnnotations"}
!170 = !{!"m_OpenCLArgAddressSpaces", !171, !172}
!171 = !{!"m_OpenCLArgAddressSpacesVec[0]", i32 1}
!172 = !{!"m_OpenCLArgAddressSpacesVec[1]", i32 1}
!173 = !{!"m_OpenCLArgAccessQualifiers", !174, !175}
!174 = !{!"m_OpenCLArgAccessQualifiersVec[0]", !"none"}
!175 = !{!"m_OpenCLArgAccessQualifiersVec[1]", !"none"}
!176 = !{!"m_OpenCLArgTypes", !177, !178}
!177 = !{!"m_OpenCLArgTypesVec[0]", !"long3*"}
!178 = !{!"m_OpenCLArgTypesVec[1]", !"long*"}
!179 = !{!"m_OpenCLArgBaseTypes", !180, !181}
!180 = !{!"m_OpenCLArgBaseTypesVec[0]", !"long3*"}
!181 = !{!"m_OpenCLArgBaseTypesVec[1]", !"long*"}
!182 = !{!"m_OpenCLArgTypeQualifiers", !183, !184}
!183 = !{!"m_OpenCLArgTypeQualifiersVec[0]", !"const"}
!184 = !{!"m_OpenCLArgTypeQualifiersVec[1]", !""}
!185 = !{!"m_OpenCLArgNames", !186, !187}
!186 = !{!"m_OpenCLArgNamesVec[0]", !"input"}
!187 = !{!"m_OpenCLArgNamesVec[1]", !"output"}
!188 = !{!"m_OpenCLArgScalarAsPointers"}
!189 = !{!"m_OptsToDisablePerFunc", !190, !191, !192}
!190 = !{!"m_OptsToDisablePerFuncSet[0]", !"IGC-AddressArithmeticSinking"}
!191 = !{!"m_OptsToDisablePerFuncSet[1]", !"IGC-AllowSimd32Slicing"}
!192 = !{!"m_OptsToDisablePerFuncSet[2]", !"IGC-SinkLoadOpt"}
!193 = !{!"pushInfo", !194, !195, !196, !200, !201, !202, !203, !204, !205, !206, !207, !220, !221, !222, !223}
!194 = !{!"pushableAddresses"}
!195 = !{!"bindlessPushInfo"}
!196 = !{!"dynamicBufferInfo", !197, !198, !199}
!197 = !{!"firstIndex", i32 0}
!198 = !{!"numOffsets", i32 0}
!199 = !{!"forceDisabled", i1 false}
!200 = !{!"MaxNumberOfPushedBuffers", i32 0}
!201 = !{!"inlineConstantBufferSlot", i32 -1}
!202 = !{!"inlineConstantBufferOffset", i32 -1}
!203 = !{!"inlineConstantBufferGRFOffset", i32 -1}
!204 = !{!"constants"}
!205 = !{!"inputs"}
!206 = !{!"constantReg"}
!207 = !{!"simplePushInfoArr", !208, !217, !218, !219}
!208 = !{!"simplePushInfoArrVec[0]", !209, !210, !211, !212, !213, !214, !215, !216}
!209 = !{!"cbIdx", i32 0}
!210 = !{!"pushableAddressGrfOffset", i32 -1}
!211 = !{!"pushableOffsetGrfOffset", i32 -1}
!212 = !{!"offset", i32 0}
!213 = !{!"size", i32 0}
!214 = !{!"isStateless", i1 false}
!215 = !{!"isBindless", i1 false}
!216 = !{!"simplePushLoads"}
!217 = !{!"simplePushInfoArrVec[1]", !209, !210, !211, !212, !213, !214, !215, !216}
!218 = !{!"simplePushInfoArrVec[2]", !209, !210, !211, !212, !213, !214, !215, !216}
!219 = !{!"simplePushInfoArrVec[3]", !209, !210, !211, !212, !213, !214, !215, !216}
!220 = !{!"simplePushBufferUsed", i32 0}
!221 = !{!"pushAnalysisWIInfos"}
!222 = !{!"inlineRTGlobalPtrOffset", i32 0}
!223 = !{!"rtSyncSurfPtrOffset", i32 0}
!224 = !{!"psInfo", !225, !226, !227, !228, !229, !230, !231, !232, !233, !234, !235, !236, !237, !238, !239}
!225 = !{!"BlendStateDisabledMask", i8 0}
!226 = !{!"SkipSrc0Alpha", i1 false}
!227 = !{!"DualSourceBlendingDisabled", i1 false}
!228 = !{!"ForceEnableSimd32", i1 false}
!229 = !{!"outputDepth", i1 false}
!230 = !{!"outputStencil", i1 false}
!231 = !{!"outputMask", i1 false}
!232 = !{!"blendToFillEnabled", i1 false}
!233 = !{!"forceEarlyZ", i1 false}
!234 = !{!"hasVersionedLoop", i1 false}
!235 = !{!"forceSingleSourceRTWAfterDualSourceRTW", i1 false}
!236 = !{!"NumSamples", i8 0}
!237 = !{!"blendOptimizationMode"}
!238 = !{!"colorOutputMask"}
!239 = !{!"WaDisableVRS", i1 false}
!240 = !{!"csInfo", !241, !242, !243, !244, !245, !34, !35, !246, !247, !248, !249, !250, !251, !252, !253, !254, !255, !256, !257, !65, !66, !258, !259, !260}
!241 = !{!"maxWorkGroupSize", i32 0}
!242 = !{!"waveSize", i32 0}
!243 = !{!"ComputeShaderSecondCompile"}
!244 = !{!"forcedSIMDSize", i8 0}
!245 = !{!"forceTotalGRFNum", i32 0}
!246 = !{!"forceSpillCompression", i1 false}
!247 = !{!"allowLowerSimd", i1 false}
!248 = !{!"disableSimd32Slicing", i1 false}
!249 = !{!"disableSplitOnSpill", i1 false}
!250 = !{!"enableNewSpillCostFunction", i1 false}
!251 = !{!"forcedVISAPreRAScheduler", i1 false}
!252 = !{!"forceUniformBuffer", i1 false}
!253 = !{!"forceUniformSurfaceSampler", i1 false}
!254 = !{!"disableLocalIdOrderOptimizations", i1 false}
!255 = !{!"disableDispatchAlongY", i1 false}
!256 = !{!"neededThreadIdLayout", i1* null}
!257 = !{!"forceTileYWalk", i1 false}
!258 = !{!"walkOrderEnabled", i1 false}
!259 = !{!"walkOrderOverride", i32 0}
!260 = !{!"ResForHfPacking"}
!261 = !{!"msInfo", !262, !263, !264, !265, !266, !267, !268, !269, !270}
!262 = !{!"PrimitiveTopology", i32 3}
!263 = !{!"MaxNumOfPrimitives", i32 0}
!264 = !{!"MaxNumOfVertices", i32 0}
!265 = !{!"MaxNumOfPerPrimitiveOutputs", i32 0}
!266 = !{!"MaxNumOfPerVertexOutputs", i32 0}
!267 = !{!"WorkGroupSize", i32 0}
!268 = !{!"WorkGroupMemorySizeInBytes", i32 0}
!269 = !{!"IndexFormat", i32 6}
!270 = !{!"SubgroupSize", i32 0}
!271 = !{!"taskInfo", !272, !267, !268, !270}
!272 = !{!"MaxNumOfOutputs", i32 0}
!273 = !{!"NBarrierCnt", i32 0}
!274 = !{!"rtInfo", !275, !276, !277, !278, !279, !280, !281, !282, !283, !284, !285, !286}
!275 = !{!"RayQueryAllocSizeInBytes", i32 0}
!276 = !{!"NumContinuations", i32 0}
!277 = !{!"RTAsyncStackAddrspace", i32 -1}
!278 = !{!"RTAsyncStackSurfaceStateOffset", i1* null}
!279 = !{!"SWHotZoneAddrspace", i32 -1}
!280 = !{!"SWHotZoneSurfaceStateOffset", i1* null}
!281 = !{!"SWStackAddrspace", i32 -1}
!282 = !{!"SWStackSurfaceStateOffset", i1* null}
!283 = !{!"RTSyncStackAddrspace", i32 -1}
!284 = !{!"RTSyncStackSurfaceStateOffset", i1* null}
!285 = !{!"doSyncDispatchRays", i1 false}
!286 = !{!"MemStyle", !"Xe"}
!287 = !{!"CurUniqueIndirectIdx", i32 0}
!288 = !{!"inlineDynTextures"}
!289 = !{!"inlineResInfoData"}
!290 = !{!"immConstant", !291, !292, !293}
!291 = !{!"data"}
!292 = !{!"sizes"}
!293 = !{!"zeroIdxs"}
!294 = !{!"stringConstants"}
!295 = !{!"inlineBuffers", !296, !300, !301}
!296 = !{!"inlineBuffersVec[0]", !297, !298, !299}
!297 = !{!"alignment", i32 0}
!298 = !{!"allocSize", i64 0}
!299 = !{!"Buffer"}
!300 = !{!"inlineBuffersVec[1]", !297, !298, !299}
!301 = !{!"inlineBuffersVec[2]", !297, !298, !299}
!302 = !{!"GlobalPointerProgramBinaryInfos"}
!303 = !{!"ConstantPointerProgramBinaryInfos"}
!304 = !{!"GlobalBufferAddressRelocInfo"}
!305 = !{!"ConstantBufferAddressRelocInfo"}
!306 = !{!"forceLscCacheList"}
!307 = !{!"SrvMap"}
!308 = !{!"RasterizerOrderedByteAddressBuffer"}
!309 = !{!"RasterizerOrderedViews"}
!310 = !{!"MinNOSPushConstantSize", i32 2}
!311 = !{!"inlineProgramScopeOffsets"}
!312 = !{!"shaderData", !313}
!313 = !{!"numReplicas", i32 0}
!314 = !{!"URBInfo", !315, !316, !317}
!315 = !{!"has64BVertexHeaderInput", i1 false}
!316 = !{!"has64BVertexHeaderOutput", i1 false}
!317 = !{!"hasVertexHeader", i1 true}
!318 = !{!"UseBindlessImage", i1 true}
!319 = !{!"enableRangeReduce", i1 false}
!320 = !{!"allowMatchMadOptimizationforVS", i1 false}
!321 = !{!"disableMatchMadOptimizationForCS", i1 false}
!322 = !{!"disableMemOptforNegativeOffsetLoads", i1 false}
!323 = !{!"enableThreeWayLoadSpiltOpt", i1 false}
!324 = !{!"statefulResourcesNotAliased", i1 false}
!325 = !{!"disableMixMode", i1 false}
!326 = !{!"genericAccessesResolved", i1 false}
!327 = !{!"disableSeparateSpillPvtScratchSpace", i1 false}
!328 = !{!"disableSeparateScratchWA", i1 false}
!329 = !{!"PrivateMemoryPerFG", !330, !331}
!330 = !{!"PrivateMemoryPerFGMap[0]", void (<3 x i64> addrspace(1)*, i64 addrspace(1)*, <8 x i32>, <8 x i32>, <3 x i32>, i16, i16, i16, i8*, i32, i32, i32, i32)* @test_kernel}
!331 = !{!"PrivateMemoryPerFGValue[0]", i32 0}
!332 = !{!"m_OptsToDisable"}
!333 = !{!"capabilities", !334}
!334 = !{!"globalVariableDecorationsINTEL", i1 false}
!335 = !{!"m_ShaderResourceViewMcsMask", !336, !337}
!336 = !{!"m_ShaderResourceViewMcsMaskVec[0]", i64 0}
!337 = !{!"m_ShaderResourceViewMcsMaskVec[1]", i64 0}
!338 = !{!"computedDepthMode", i32 0}
!339 = !{!"isHDCFastClearShader", i1 false}
!340 = !{!"argRegisterReservations", !341}
!341 = !{!"argRegisterReservationsVec[0]", i32 0}
!342 = !{i32 2, i32 0}
!343 = !{!"clang version 14.0.5"}
!344 = !{i32 1, !"wchar_size", i32 4}
