// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// For Resolver list operations ([ListResolverEndpoints] , [ListResolverRules], [ListResolverRuleAssociations], [ListResolverQueryLogConfigs], [ListResolverQueryLogConfigAssociations]), and [ListResolverDnssecConfigs]), an optional specification to
// return a subset of objects.
//
// To filter objects, such as Resolver endpoints or Resolver rules, you specify
// Name and Values . For example, to list only inbound Resolver endpoints, specify
// Direction for Name and specify INBOUND for Values .
//
// [ListResolverRules]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html
// [ListResolverQueryLogConfigs]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html
// [ListResolverDnssecConfigs]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverDnssecConfigs.html
// [ListResolverRuleAssociations]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html
// [ListResolverQueryLogConfigAssociations]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html
// [ListResolverEndpoints]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html
type Filter struct {

	// The name of the parameter that you want to use to filter objects.
	//
	// The valid values for Name depend on the action that you're including the filter
	// in, [ListResolverEndpoints], [ListResolverRules], [ListResolverRuleAssociations], [ListResolverQueryLogConfigs], or [ListResolverQueryLogConfigAssociations].
	//
	// In early versions of Resolver, values for Name were listed as uppercase, with
	// underscore (_) delimiters. For example, CreatorRequestId was originally listed
	// as CREATOR_REQUEST_ID . Uppercase values for Name are still supported.
	//
	// ListResolverEndpoints
	//
	// Valid values for Name include the following:
	//
	//   - CreatorRequestId : The value that you specified when you created the
	//   Resolver endpoint.
	//
	//   - Direction : Whether you want to return inbound or outbound Resolver
	//   endpoints. If you specify DIRECTION for Name , specify INBOUND or OUTBOUND for
	//   Values .
	//
	//   - HostVPCId : The ID of the VPC that inbound DNS queries pass through on the
	//   way from your network to your VPCs in a region, or the VPC that outbound queries
	//   pass through on the way from your VPCs to your network. In a [CreateResolverEndpoint]request, SubnetId
	//   indirectly identifies the VPC. In a [GetResolverEndpoint]request, the VPC ID for a Resolver
	//   endpoint is returned in the HostVPCId element.
	//
	//   - IpAddressCount : The number of IP addresses that you have associated with
	//   the Resolver endpoint.
	//
	//   - Name : The name of the Resolver endpoint.
	//
	//   - SecurityGroupIds : The IDs of the VPC security groups that you specified
	//   when you created the Resolver endpoint.
	//
	//   - Status : The status of the Resolver endpoint. If you specify Status for Name
	//   , specify one of the following status codes for Values : CREATING ,
	//   OPERATIONAL , UPDATING , AUTO_RECOVERING , ACTION_NEEDED , or DELETING . For
	//   more information, see Status in [ResolverEndpoint].
	//
	// ListResolverRules
	//
	// Valid values for Name include the following:
	//
	//   - CreatorRequestId : The value that you specified when you created the
	//   Resolver rule.
	//
	//   - DomainName : The domain name for which Resolver is forwarding DNS queries to
	//   your network. In the value that you specify for Values , include a trailing
	//   dot (.) after the domain name. For example, if the domain name is example.com,
	//   specify the following value. Note the "." after com :
	//
	// example.com.
	//
	//   - Name : The name of the Resolver rule.
	//
	//   - ResolverEndpointId : The ID of the Resolver endpoint that the Resolver rule
	//   is associated with.
	//
	// You can filter on the Resolver endpoint only for rules that have a value of
	//   FORWARD for RuleType .
	//
	//   - Status : The status of the Resolver rule. If you specify Status for Name ,
	//   specify one of the following status codes for Values : COMPLETE , DELETING ,
	//   UPDATING , or FAILED .
	//
	//   - Type : The type of the Resolver rule. If you specify TYPE for Name , specify
	//   FORWARD or SYSTEM for Values .
	//
	// ListResolverRuleAssociations
	//
	// Valid values for Name include the following:
	//
	//   - Name : The name of the Resolver rule association.
	//
	//   - ResolverRuleId : The ID of the Resolver rule that is associated with one or
	//   more VPCs.
	//
	//   - Status : The status of the Resolver rule association. If you specify Status
	//   for Name , specify one of the following status codes for Values : CREATING ,
	//   COMPLETE , DELETING , or FAILED .
	//
	//   - VPCId : The ID of the VPC that the Resolver rule is associated with.
	//
	// ListResolverQueryLogConfigs
	//
	// Valid values for Name include the following:
	//
	//   - Arn : The ARN for the query logging configuration.
	//
	//   - AssociationCount : The number of VPCs that are associated with the query
	//   logging configuration.
	//
	//   - CreationTime : The date and time that the query logging configuration was
	//   created, in Unix time format and Coordinated Universal Time (UTC).
	//
	//   - CreatorRequestId : A unique string that identifies the request that created
	//   the query logging configuration.
	//
	//   - Destination : The Amazon Web Services service that you want to forward query
	//   logs to. Valid values include the following:
	//
	//   - S3
	//
	//   - CloudWatchLogs
	//
	//   - KinesisFirehose
	//
	//   - DestinationArn : The ARN of the location that Resolver is sending query logs
	//   to. This value can be the ARN for an S3 bucket, a CloudWatch Logs log group, or
	//   a Kinesis Data Firehose delivery stream.
	//
	//   - Id : The ID of the query logging configuration
	//
	//   - Name : The name of the query logging configuration
	//
	//   - OwnerId : The Amazon Web Services account ID for the account that created
	//   the query logging configuration.
	//
	//   - ShareStatus : An indication of whether the query logging configuration is
	//   shared with other Amazon Web Services accounts, or was shared with the current
	//   account by another Amazon Web Services account. Valid values include:
	//   NOT_SHARED , SHARED_WITH_ME , or SHARED_BY_ME .
	//
	//   - Status : The status of the query logging configuration. If you specify
	//   Status for Name , specify the applicable status code for Values : CREATING ,
	//   CREATED , DELETING , or FAILED . For more information, see [Status].
	//
	// ListResolverQueryLogConfigAssociations
	//
	// Valid values for Name include the following:
	//
	//   - CreationTime : The date and time that the VPC was associated with the query
	//   logging configuration, in Unix time format and Coordinated Universal Time (UTC).
	//
	//   - Error : If the value of Status is FAILED , specify the cause:
	//   DESTINATION_NOT_FOUND or ACCESS_DENIED .
	//
	//   - Id : The ID of the query logging association.
	//
	//   - ResolverQueryLogConfigId : The ID of the query logging configuration that a
	//   VPC is associated with.
	//
	//   - ResourceId : The ID of the Amazon VPC that is associated with the query
	//   logging configuration.
	//
	//   - Status : The status of the query logging association. If you specify Status
	//   for Name , specify the applicable status code for Values : CREATING , CREATED
	//   , DELETING , or FAILED . For more information, see [Status].
	//
	// [Status]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfigAssociation.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfigAssociation-Status
	// [ListResolverRules]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html
	// [GetResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html
	// [ListResolverQueryLogConfigs]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html
	// [CreateResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html
	// [ResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverEndpoint.html
	// [ListResolverRuleAssociations]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html
	// [ListResolverQueryLogConfigAssociations]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html
	// [ListResolverEndpoints]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html
	Name *string

	// When you're using a List operation and you want the operation to return a
	// subset of objects, such as Resolver endpoints or Resolver rules, the value of
	// the parameter that you want to use to filter objects. For example, to list only
	// inbound Resolver endpoints, specify Direction for Name and specify INBOUND for
	// Values .
	Values []string

	noSmithyDocumentSerde
}

// Configuration of the firewall behavior provided by DNS Firewall for a single
// VPC from Amazon Virtual Private Cloud (Amazon VPC).
type FirewallConfig struct {

	// Determines how DNS Firewall operates during failures, for example when all
	// traffic that is sent to DNS Firewall fails to receive a reply.
	//
	//   - By default, fail open is disabled, which means the failure mode is closed.
	//   This approach favors security over availability. DNS Firewall returns a failure
	//   error when it is unable to properly evaluate a query.
	//
	//   - If you enable this option, the failure mode is open. This approach favors
	//   availability over security. DNS Firewall allows queries to proceed if it is
	//   unable to properly evaluate them.
	//
	// This behavior is only enforced for VPCs that have at least one DNS Firewall
	// rule group association.
	FirewallFailOpen FirewallFailOpenStatus

	// The ID of the firewall configuration.
	Id *string

	// The Amazon Web Services account ID of the owner of the VPC that this firewall
	// configuration applies to.
	OwnerId *string

	// The ID of the VPC that this firewall configuration applies to.
	ResourceId *string

	noSmithyDocumentSerde
}

// High-level information about a list of firewall domains for use in a FirewallRule. This is
// returned by GetFirewallDomainList.
//
// To retrieve the domains that are defined for this domain list, call ListFirewallDomains.
type FirewallDomainList struct {

	// The Amazon Resource Name (ARN) of the firewall domain list.
	Arn *string

	// The date and time that the domain list was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of running the operation twice. This can
	// be any unique string, for example, a timestamp.
	CreatorRequestId *string

	// The number of domain names that are specified in the domain list.
	DomainCount *int32

	// The ID of the domain list.
	Id *string

	// The owner of the list, used only for lists that are not managed by you. For
	// example, the managed domain list AWSManagedDomainsMalwareDomainList has the
	// managed owner name Route 53 Resolver DNS Firewall .
	ManagedOwnerName *string

	// The date and time that the domain list was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string

	// The name of the domain list.
	Name *string

	// The status of the domain list.
	Status FirewallDomainListStatus

	// Additional information about the status of the list, if available.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Minimal high-level information for a firewall domain list. The action ListFirewallDomainLists returns
// an array of these objects.
//
// To retrieve full information for a firewall domain list, call GetFirewallDomainList and ListFirewallDomains.
type FirewallDomainListMetadata struct {

	// The Amazon Resource Name (ARN) of the firewall domain list metadata.
	Arn *string

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of running the operation twice. This can
	// be any unique string, for example, a timestamp.
	CreatorRequestId *string

	// The ID of the domain list.
	Id *string

	// The owner of the list, used only for lists that are not managed by you. For
	// example, the managed domain list AWSManagedDomainsMalwareDomainList has the
	// managed owner name Route 53 Resolver DNS Firewall .
	ManagedOwnerName *string

	// The name of the domain list.
	Name *string

	noSmithyDocumentSerde
}

// A single firewall rule in a rule group.
type FirewallRule struct {

	// The action that DNS Firewall should take on a DNS query when it matches one of
	// the domains in the rule's domain list:
	//
	//   - ALLOW - Permit the request to go through.
	//
	//   - ALERT - Permit the request to go through but send an alert to the logs.
	//
	//   - BLOCK - Disallow the request. If this is specified, additional handling
	//   details are provided in the rule's BlockResponse setting.
	Action Action

	// The DNS record's type. This determines the format of the record value that you
	// provided in BlockOverrideDomain . Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	BlockOverrideDnsType BlockOverrideDnsType

	// The custom DNS record to send back in response to the query. Used for the rule
	// action BLOCK with a BlockResponse setting of OVERRIDE .
	BlockOverrideDomain *string

	// The recommended amount of time, in seconds, for the DNS resolver or web browser
	// to cache the provided override record. Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	BlockOverrideTtl *int32

	// The way that you want DNS Firewall to block the request. Used for the rule
	// action setting BLOCK .
	//
	//   - NODATA - Respond indicating that the query was successful, but no response
	//   is available for it.
	//
	//   - NXDOMAIN - Respond indicating that the domain name that's in the query
	//   doesn't exist.
	//
	//   - OVERRIDE - Provide a custom override in the response. This option requires
	//   custom handling details in the rule's BlockOverride* settings.
	BlockResponse BlockResponse

	// The date and time that the rule was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of executing the operation twice. This
	// can be any unique string, for example, a timestamp.
	CreatorRequestId *string

	// The ID of the domain list that's used in the rule.
	FirewallDomainListId *string

	//  How you want the the rule to evaluate DNS redirection in the DNS redirection
	// chain, such as CNAME or DNAME.
	//
	// Inspect_Redirection_Domain (Default) inspects all domains in the redirection
	// chain. The individual domains in the redirection chain must be added to the
	// domain list.
	//
	// Trust_Redirection_Domain  inspects only the first domain in the redirection
	// chain. You don't need to add the subsequent domains in the domain in the
	// redirection list to the domain list.
	FirewallDomainRedirectionAction FirewallDomainRedirectionAction

	// The unique identifier of the firewall rule group of the rule.
	FirewallRuleGroupId *string

	// The date and time that the rule was last modified, in Unix time format and
	// Coordinated Universal Time (UTC).
	ModificationTime *string

	// The name of the rule.
	Name *string

	// The priority of the rule in the rule group. This value must be unique within
	// the rule group. DNS Firewall processes the rules in a rule group by order of
	// priority, starting from the lowest setting.
	Priority *int32

	//  The DNS query type you want the rule to evaluate. Allowed values are;
	//
	//   - A: Returns an IPv4 address.
	//
	//   - AAAA: Returns an Ipv6 address.
	//
	//   - CAA: Restricts CAs that can create SSL/TLS certifications for the domain.
	//
	//   - CNAME: Returns another domain name.
	//
	//   - DS: Record that identifies the DNSSEC signing key of a delegated zone.
	//
	//   - MX: Specifies mail servers.
	//
	//   - NAPTR: Regular-expression-based rewriting of domain names.
	//
	//   - NS: Authoritative name servers.
	//
	//   - PTR: Maps an IP address to a domain name.
	//
	//   - SOA: Start of authority record for the zone.
	//
	//   - SPF: Lists the servers authorized to send emails from a domain.
	//
	//   - SRV: Application specific values that identify servers.
	//
	//   - TXT: Verifies email senders and application-specific values.
	//
	//   - A query type you define by using the DNS type ID, for example 28 for AAAA.
	//   The values must be defined as TYPENUMBER, where the NUMBER can be 1-65334, for
	//   example, TYPE28. For more information, see [List of DNS record types].
	//
	// [List of DNS record types]: https://en.wikipedia.org/wiki/List_of_DNS_record_types
	Qtype *string

	noSmithyDocumentSerde
}

// High-level information for a firewall rule group. A firewall rule group is a
// collection of rules that DNS Firewall uses to filter DNS network traffic for a
// VPC. To retrieve the rules for the rule group, call ListFirewallRules.
type FirewallRuleGroup struct {

	// The ARN (Amazon Resource Name) of the rule group.
	Arn *string

	// The date and time that the rule group was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of running the operation twice. This can
	// be any unique string, for example, a timestamp.
	CreatorRequestId *string

	// The ID of the rule group.
	Id *string

	// The date and time that the rule group was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string

	// The name of the rule group.
	Name *string

	// The Amazon Web Services account ID for the account that created the rule group.
	// When a rule group is shared with your account, this is the account that has
	// shared the rule group with you.
	OwnerId *string

	// The number of rules in the rule group.
	RuleCount *int32

	// Whether the rule group is shared with other Amazon Web Services accounts, or
	// was shared with the current account by another Amazon Web Services account.
	// Sharing is configured through Resource Access Manager (RAM).
	ShareStatus ShareStatus

	// The status of the domain list.
	Status FirewallRuleGroupStatus

	// Additional information about the status of the rule group, if available.
	StatusMessage *string

	noSmithyDocumentSerde
}

// An association between a firewall rule group and a VPC, which enables DNS
// filtering for the VPC.
type FirewallRuleGroupAssociation struct {

	// The Amazon Resource Name (ARN) of the firewall rule group association.
	Arn *string

	// The date and time that the association was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of running the operation twice. This can
	// be any unique string, for example, a timestamp.
	CreatorRequestId *string

	// The unique identifier of the firewall rule group.
	FirewallRuleGroupId *string

	// The identifier for the association.
	Id *string

	// The owner of the association, used only for associations that are not managed
	// by you. If you use Firewall Manager to manage your DNS Firewalls, then this
	// reports Firewall Manager as the managed owner.
	ManagedOwnerName *string

	// The date and time that the association was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string

	// If enabled, this setting disallows modification or removal of the association,
	// to help prevent against accidentally altering DNS firewall protections.
	MutationProtection MutationProtectionStatus

	// The name of the association.
	Name *string

	// The setting that determines the processing order of the rule group among the
	// rule groups that are associated with a single VPC. DNS Firewall filters VPC
	// traffic starting from rule group with the lowest numeric priority setting.
	Priority *int32

	// The current status of the association.
	Status FirewallRuleGroupAssociationStatus

	// Additional information about the status of the response, if available.
	StatusMessage *string

	// The unique identifier of the VPC that is associated with the rule group.
	VpcId *string

	noSmithyDocumentSerde
}

// Minimal high-level information for a firewall rule group. The action ListFirewallRuleGroups returns
// an array of these objects.
//
// To retrieve full information for a firewall rule group, call GetFirewallRuleGroup and ListFirewallRules.
type FirewallRuleGroupMetadata struct {

	// The ARN (Amazon Resource Name) of the rule group.
	Arn *string

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of running the operation twice. This can
	// be any unique string, for example, a timestamp.
	CreatorRequestId *string

	// The ID of the rule group.
	Id *string

	// The name of the rule group.
	Name *string

	// The Amazon Web Services account ID for the account that created the rule group.
	// When a rule group is shared with your account, this is the account that has
	// shared the rule group with you.
	OwnerId *string

	// Whether the rule group is shared with other Amazon Web Services accounts, or
	// was shared with the current account by another Amazon Web Services account.
	// Sharing is configured through Resource Access Manager (RAM).
	ShareStatus ShareStatus

	noSmithyDocumentSerde
}

// In a [CreateResolverEndpoint] request, the IP address that DNS queries originate from (for outbound
// endpoints) or that you forward DNS queries to (for inbound endpoints).
// IpAddressRequest also includes the ID of the subnet that contains the IP address.
//
// [CreateResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html
type IpAddressRequest struct {

	// The ID of the subnet that contains the IP address.
	//
	// This member is required.
	SubnetId *string

	// The IPv4 address that you want to use for DNS queries.
	Ip *string

	//  The IPv6 address that you want to use for DNS queries.
	Ipv6 *string

	noSmithyDocumentSerde
}

// In the response to a [GetResolverEndpoint] request, information about the IP addresses that the
// Resolver endpoint uses for DNS queries.
//
// [GetResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html
type IpAddressResponse struct {

	// The date and time that the IP address was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string

	// One IPv4 address that the Resolver endpoint uses for DNS queries.
	Ip *string

	// The ID of one IP address.
	IpId *string

	//  One IPv6 address that the Resolver endpoint uses for DNS queries.
	Ipv6 *string

	// The date and time that the IP address was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string

	// A status code that gives the current status of the request.
	Status IpAddressStatus

	// A message that provides additional information about the status of the request.
	StatusMessage *string

	// The ID of one subnet.
	SubnetId *string

	noSmithyDocumentSerde
}

// In an [UpdateResolverEndpoint] request, information about an IP address to update.
//
// [UpdateResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html
type IpAddressUpdate struct {

	// The new IPv4 address.
	Ip *string

	//  Only when removing an IP address from a Resolver endpoint: The ID of the IP
	// address that you want to remove. To get this ID, use [GetResolverEndpoint].
	//
	// [GetResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html
	IpId *string

	//  The new IPv6 address.
	Ipv6 *string

	// The ID of the subnet that includes the IP address that you want to update. To
	// get this ID, use [GetResolverEndpoint].
	//
	// [GetResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html
	SubnetId *string

	noSmithyDocumentSerde
}

// A complex type that contains settings for an existing Resolver on an Outpost.
type OutpostResolver struct {

	// The ARN (Amazon Resource Name) for the Resolver on an Outpost.
	Arn *string

	// The date and time that the Outpost Resolver was created, in Unix time format
	// and Coordinated Universal Time (UTC).
	CreationTime *string

	// A unique string that identifies the request that created the Resolver endpoint.
	// The CreatorRequestId allows failed requests to be retried without the risk of
	// running the operation twice.
	CreatorRequestId *string

	// The ID of the Resolver on Outpost.
	Id *string

	// Amazon EC2 instance count for the Resolver on the Outpost.
	InstanceCount *int32

	// The date and time that the Outpost Resolver was modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string

	// Name of the Resolver.
	Name *string

	// The ARN (Amazon Resource Name) for the Outpost.
	OutpostArn *string

	//  The Amazon EC2 instance type.
	PreferredInstanceType *string

	// Status of the Resolver.
	Status OutpostResolverStatus

	// A detailed description of the Resolver.
	StatusMessage *string

	noSmithyDocumentSerde
}

// A complex type that contains information about a Resolver configuration for a
// VPC.
type ResolverConfig struct {

	//  The status of whether or not the Resolver will create autodefined rules for
	// reverse DNS lookups. This is enabled by default. The status can be one of
	// following:
	//
	//   - ENABLING: Autodefined rules for reverse DNS lookups are being enabled but
	//   are not complete.
	//
	//   - ENABLED: Autodefined rules for reverse DNS lookups are enabled.
	//
	//   - DISABLING: Autodefined rules for reverse DNS lookups are being disabled but
	//   are not complete.
	//
	//   - DISABLED: Autodefined rules for reverse DNS lookups are disabled.
	AutodefinedReverse ResolverAutodefinedReverseStatus

	// ID for the Resolver configuration.
	Id *string

	// The owner account ID of the Amazon Virtual Private Cloud VPC.
	OwnerId *string

	// The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver
	// for.
	ResourceId *string

	noSmithyDocumentSerde
}

// A complex type that contains information about a configuration for DNSSEC
// validation.
type ResolverDnssecConfig struct {

	// The ID for a configuration for DNSSEC validation.
	Id *string

	// The owner account ID of the virtual private cloud (VPC) for a configuration for
	// DNSSEC validation.
	OwnerId *string

	// The ID of the virtual private cloud (VPC) that you're configuring the DNSSEC
	// validation status for.
	ResourceId *string

	// The validation status for a DNSSEC configuration. The status can be one of the
	// following:
	//
	//   - ENABLING: DNSSEC validation is being enabled but is not complete.
	//
	//   - ENABLED: DNSSEC validation is enabled.
	//
	//   - DISABLING: DNSSEC validation is being disabled but is not complete.
	//
	//   - DISABLED DNSSEC validation is disabled.
	ValidationStatus ResolverDNSSECValidationStatus

	noSmithyDocumentSerde
}

// In the response to a [CreateResolverEndpoint], [DeleteResolverEndpoint], [GetResolverEndpoint], Updates the name, or ResolverEndpointType for an
// endpoint, or [UpdateResolverEndpoint]request, a complex type that contains settings for an existing
// inbound or outbound Resolver endpoint.
//
// [UpdateResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html
// [GetResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html
// [CreateResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html
// [DeleteResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverEndpoint.html
type ResolverEndpoint struct {

	// The ARN (Amazon Resource Name) for the Resolver endpoint.
	Arn *string

	// The date and time that the endpoint was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string

	// A unique string that identifies the request that created the Resolver endpoint.
	// The CreatorRequestId allows failed requests to be retried without the risk of
	// running the operation twice.
	CreatorRequestId *string

	// Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:
	//
	//   - INBOUND : allows DNS queries to your VPC from your network
	//
	//   - OUTBOUND : allows DNS queries from your VPC to your network
	Direction ResolverEndpointDirection

	// The ID of the VPC that you want to create the Resolver endpoint in.
	HostVPCId *string

	// The ID of the Resolver endpoint.
	Id *string

	// The number of IP addresses that the Resolver endpoint can use for DNS queries.
	IpAddressCount *int32

	// The date and time that the endpoint was last modified, in Unix time format and
	// Coordinated Universal Time (UTC).
	ModificationTime *string

	// The name that you assigned to the Resolver endpoint when you submitted a [CreateResolverEndpoint]
	// request.
	//
	// [CreateResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html
	Name *string

	// The ARN (Amazon Resource Name) for the Outpost.
	OutpostArn *string

	//  The Amazon EC2 instance type.
	PreferredInstanceType *string

	//  Protocols used for the endpoint. DoH-FIPS is applicable for inbound endpoints
	// only.
	//
	// For an inbound endpoint you can apply the protocols as follows:
	//
	//   - Do53 and DoH in combination.
	//
	//   - Do53 and DoH-FIPS in combination.
	//
	//   - Do53 alone.
	//
	//   - DoH alone.
	//
	//   - DoH-FIPS alone.
	//
	//   - None, which is treated as Do53.
	//
	// For an outbound endpoint you can apply the protocols as follows:
	//
	//   - Do53 and DoH in combination.
	//
	//   - Do53 alone.
	//
	//   - DoH alone.
	//
	//   - None, which is treated as Do53.
	Protocols []Protocol

	//  The Resolver endpoint IP address type.
	ResolverEndpointType ResolverEndpointType

	// The ID of one or more security groups that control access to this VPC. The
	// security group must include one or more inbound rules (for inbound endpoints) or
	// outbound rules (for outbound endpoints). Inbound and outbound rules must allow
	// TCP and UDP access. For inbound access, open port 53. For outbound access, open
	// the port that you're using for DNS queries on your network.
	SecurityGroupIds []string

	// A code that specifies the current status of the Resolver endpoint. Valid values
	// include the following:
	//
	//   - CREATING : Resolver is creating and configuring one or more Amazon VPC
	//   network interfaces for this endpoint.
	//
	//   - OPERATIONAL : The Amazon VPC network interfaces for this endpoint are
	//   correctly configured and able to pass inbound or outbound DNS queries between
	//   your network and Resolver.
	//
	//   - UPDATING : Resolver is associating or disassociating one or more network
	//   interfaces with this endpoint.
	//
	//   - AUTO_RECOVERING : Resolver is trying to recover one or more of the network
	//   interfaces that are associated with this endpoint. During the recovery process,
	//   the endpoint functions with limited capacity because of the limit on the number
	//   of DNS queries per IP address (per network interface). For the current limit,
	//   see [Limits on Route 53 Resolver].
	//
	//   - ACTION_NEEDED : This endpoint is unhealthy, and Resolver can't automatically
	//   recover it. To resolve the problem, we recommend that you check each IP address
	//   that you associated with the endpoint. For each IP address that isn't available,
	//   add another IP address and then delete the IP address that isn't available. (An
	//   endpoint must always include at least two IP addresses.) A status of
	//   ACTION_NEEDED can have a variety of causes. Here are two common causes:
	//
	//   - One or more of the network interfaces that are associated with the endpoint
	//   were deleted using Amazon VPC.
	//
	//   - The network interface couldn't be created for some reason that's outside
	//   the control of Resolver.
	//
	//   - DELETING : Resolver is deleting this endpoint and the associated network
	//   interfaces.
	//
	// [Limits on Route 53 Resolver]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-entities-resolver
	Status ResolverEndpointStatus

	// A detailed description of the status of the Resolver endpoint.
	StatusMessage *string

	noSmithyDocumentSerde
}

// In the response to a [CreateResolverQueryLogConfig], [DeleteResolverQueryLogConfig], [GetResolverQueryLogConfig], or [ListResolverQueryLogConfigs] request, a complex type that contains settings
// for one query logging configuration.
//
// [DeleteResolverQueryLogConfig]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html
// [ListResolverQueryLogConfigs]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html
// [CreateResolverQueryLogConfig]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverQueryLogConfig.html
// [GetResolverQueryLogConfig]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfig.html
type ResolverQueryLogConfig struct {

	// The ARN for the query logging configuration.
	Arn *string

	// The number of VPCs that are associated with the query logging configuration.
	AssociationCount int32

	// The date and time that the query logging configuration was created, in Unix
	// time format and Coordinated Universal Time (UTC).
	CreationTime *string

	// A unique string that identifies the request that created the query logging
	// configuration. The CreatorRequestId allows failed requests to be retried
	// without the risk of running the operation twice.
	CreatorRequestId *string

	// The ARN of the resource that you want Resolver to send query logs: an Amazon S3
	// bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream.
	DestinationArn *string

	// The ID for the query logging configuration.
	Id *string

	// The name of the query logging configuration.
	Name *string

	// The Amazon Web Services account ID for the account that created the query
	// logging configuration.
	OwnerId *string

	// An indication of whether the query logging configuration is shared with other
	// Amazon Web Services accounts, or was shared with the current account by another
	// Amazon Web Services account. Sharing is configured through Resource Access
	// Manager (RAM).
	ShareStatus ShareStatus

	// The status of the specified query logging configuration. Valid values include
	// the following:
	//
	//   - CREATING : Resolver is creating the query logging configuration.
	//
	//   - CREATED : The query logging configuration was successfully created. Resolver
	//   is logging queries that originate in the specified VPC.
	//
	//   - DELETING : Resolver is deleting this query logging configuration.
	//
	//   - FAILED : Resolver can't deliver logs to the location that is specified in
	//   the query logging configuration. Here are two common causes:
	//
	//   - The specified destination (for example, an Amazon S3 bucket) was deleted.
	//
	//   - Permissions don't allow sending logs to the destination.
	Status ResolverQueryLogConfigStatus

	noSmithyDocumentSerde
}

// In the response to an [AssociateResolverQueryLogConfig], [DisassociateResolverQueryLogConfig], [GetResolverQueryLogConfigAssociation], or [ListResolverQueryLogConfigAssociations], request, a complex type that contains settings
// for a specified association between an Amazon VPC and a query logging
// configuration.
//
// [GetResolverQueryLogConfigAssociation]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigAssociation.html
// [AssociateResolverQueryLogConfig]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html
// [DisassociateResolverQueryLogConfig]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html
// [ListResolverQueryLogConfigAssociations]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html
type ResolverQueryLogConfigAssociation struct {

	// The date and time that the VPC was associated with the query logging
	// configuration, in Unix time format and Coordinated Universal Time (UTC).
	CreationTime *string

	// If the value of Status is FAILED , the value of Error indicates the cause:
	//
	//   - DESTINATION_NOT_FOUND : The specified destination (for example, an Amazon S3
	//   bucket) was deleted.
	//
	//   - ACCESS_DENIED : Permissions don't allow sending logs to the destination.
	//
	// If the value of Status is a value other than FAILED , Error is null.
	Error ResolverQueryLogConfigAssociationError

	// Contains additional information about the error. If the value or Error is null,
	// the value of ErrorMessage also is null.
	ErrorMessage *string

	// The ID of the query logging association.
	Id *string

	// The ID of the query logging configuration that a VPC is associated with.
	ResolverQueryLogConfigId *string

	// The ID of the Amazon VPC that is associated with the query logging
	// configuration.
	ResourceId *string

	// The status of the specified query logging association. Valid values include the
	// following:
	//
	//   - CREATING : Resolver is creating an association between an Amazon VPC and a
	//   query logging configuration.
	//
	//   - CREATED : The association between an Amazon VPC and a query logging
	//   configuration was successfully created. Resolver is logging queries that
	//   originate in the specified VPC.
	//
	//   - DELETING : Resolver is deleting this query logging association.
	//
	//   - FAILED : Resolver either couldn't create or couldn't delete the query
	//   logging association.
	Status ResolverQueryLogConfigAssociationStatus

	noSmithyDocumentSerde
}

// For queries that originate in your VPC, detailed information about a Resolver
// rule, which specifies how to route DNS queries out of the VPC. The ResolverRule
// parameter appears in the response to a [CreateResolverRule], [DeleteResolverRule], [GetResolverRule], [ListResolverRules], or [UpdateResolverRule] request.
//
// [GetResolverRule]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html
// [ListResolverRules]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html
// [CreateResolverRule]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html
// [UpdateResolverRule]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html
// [DeleteResolverRule]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverRule.html
type ResolverRule struct {

	// The ARN (Amazon Resource Name) for the Resolver rule specified by Id .
	Arn *string

	// The date and time that the Resolver rule was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string

	// A unique string that you specified when you created the Resolver rule.
	// CreatorRequestId identifies the request and allows failed requests to be retried
	// without the risk of running the operation twice.
	CreatorRequestId *string

	// DNS queries for this domain name are forwarded to the IP addresses that are
	// specified in TargetIps . If a query matches multiple Resolver rules (example.com
	// and www.example.com), the query is routed using the Resolver rule that contains
	// the most specific domain name (www.example.com).
	DomainName *string

	// The ID that Resolver assigned to the Resolver rule when you created it.
	Id *string

	// The date and time that the Resolver rule was last updated, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string

	// The name for the Resolver rule, which you specified when you created the
	// Resolver rule.
	Name *string

	// When a rule is shared with another Amazon Web Services account, the account ID
	// of the account that the rule is shared with.
	OwnerId *string

	// The ID of the endpoint that the rule is associated with.
	ResolverEndpointId *string

	// When you want to forward DNS queries for specified domain name to resolvers on
	// your network, specify FORWARD .
	//
	// When you have a forwarding rule to forward DNS queries for a domain to your
	// network and you want Resolver to process queries for a subdomain of that domain,
	// specify SYSTEM .
	//
	// For example, to forward DNS queries for example.com to resolvers on your
	// network, you create a rule and specify FORWARD for RuleType . To then have
	// Resolver process queries for apex.example.com, you create a rule and specify
	// SYSTEM for RuleType .
	//
	// Currently, only Resolver can create rules that have a value of RECURSIVE for
	// RuleType .
	RuleType RuleTypeOption

	// Whether the rule is shared and, if so, whether the current account is sharing
	// the rule with another account, or another account is sharing the rule with the
	// current account.
	ShareStatus ShareStatus

	// A code that specifies the current status of the Resolver rule.
	Status ResolverRuleStatus

	// A detailed description of the status of a Resolver rule.
	StatusMessage *string

	// An array that contains the IP addresses and ports that an outbound endpoint
	// forwards DNS queries to. Typically, these are the IP addresses of DNS resolvers
	// on your network.
	TargetIps []TargetAddress

	noSmithyDocumentSerde
}

// In the response to an [AssociateResolverRule], [DisassociateResolverRule], or [ListResolverRuleAssociations] request, provides information about an
// association between a Resolver rule and a VPC. The association determines which
// DNS queries that originate in the VPC are forwarded to your network.
//
// [DisassociateResolverRule]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html
// [ListResolverRuleAssociations]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html
// [AssociateResolverRule]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html
type ResolverRuleAssociation struct {

	// The ID of the association between a Resolver rule and a VPC. Resolver assigns
	// this value when you submit an [AssociateResolverRule]request.
	//
	// [AssociateResolverRule]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html
	Id *string

	// The name of an association between a Resolver rule and a VPC.
	Name *string

	// The ID of the Resolver rule that you associated with the VPC that is specified
	// by VPCId .
	ResolverRuleId *string

	// A code that specifies the current status of the association between a Resolver
	// rule and a VPC.
	Status ResolverRuleAssociationStatus

	// A detailed description of the status of the association between a Resolver rule
	// and a VPC.
	StatusMessage *string

	// The ID of the VPC that you associated the Resolver rule with.
	VPCId *string

	noSmithyDocumentSerde
}

// In an [UpdateResolverRule] request, information about the changes that you want to make.
//
// [UpdateResolverRule]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html
type ResolverRuleConfig struct {

	// The new name for the Resolver rule. The name that you specify appears in the
	// Resolver dashboard in the Route 53 console.
	Name *string

	// The ID of the new outbound Resolver endpoint that you want to use to route DNS
	// queries to the IP addresses that you specify in TargetIps .
	ResolverEndpointId *string

	// For DNS queries that originate in your VPC, the new IP addresses that you want
	// to route outbound DNS queries to.
	TargetIps []TargetAddress

	noSmithyDocumentSerde
}

// One tag that you want to add to the specified resource. A tag consists of a Key
// (a name for the tag) and a Value .
type Tag struct {

	// The name for the tag. For example, if you want to associate Resolver resources
	// with the account IDs of your customers for billing purposes, the value of Key
	// might be account-id .
	//
	// This member is required.
	Key *string

	// The value for the tag. For example, if Key is account-id , then Value might be
	// the ID of the customer account that you're creating the resource for.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// In a [CreateResolverRule] request, an array of the IPs that you want to forward DNS queries to.
//
// [CreateResolverRule]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html
type TargetAddress struct {

	// One IPv4 address that you want to forward DNS queries to.
	Ip *string

	//  One IPv6 address that you want to forward DNS queries to.
	Ipv6 *string

	// The port at Ip that you want to forward DNS queries to.
	Port *int32

	//  The protocols for the Resolver endpoints. DoH-FIPS is applicable for inbound
	// endpoints only.
	//
	// For an inbound endpoint you can apply the protocols as follows:
	//
	//   - Do53 and DoH in combination.
	//
	//   - Do53 and DoH-FIPS in combination.
	//
	//   - Do53 alone.
	//
	//   - DoH alone.
	//
	//   - DoH-FIPS alone.
	//
	//   - None, which is treated as Do53.
	//
	// For an outbound endpoint you can apply the protocols as follows:
	//
	//   - Do53 and DoH in combination.
	//
	//   - Do53 alone.
	//
	//   - DoH alone.
	//
	//   - None, which is treated as Do53.
	Protocol Protocol

	noSmithyDocumentSerde
}

//	Provides information about the IP address type in response to [UpdateResolverEndpoint].
//
// [UpdateResolverEndpoint]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html
type UpdateIpAddress struct {

	//  The ID of the IP address, specified by the ResolverEndpointId .
	//
	// This member is required.
	IpId *string

	//  The IPv6 address that you want to use for DNS queries.
	//
	// This member is required.
	Ipv6 *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
