// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Retrieves the summary of the performance analysis report created for a time
// period.
type AnalysisReport struct {

	// The name of the analysis report.
	//
	// This member is required.
	AnalysisReportId *string

	// The time you created the analysis report.
	CreateTime *time.Time

	// The analysis end time in the report.
	EndTime *time.Time

	// The unique identifier of the analysis report.
	Identifier *string

	// The list of identified insights in the analysis report.
	Insights []Insight

	// List the tags for the Amazon Web Services service for which Performance
	// Insights returns metrics. Valid values are as follows:
	//
	//   - RDS
	//
	//   - DOCDB
	ServiceType ServiceType

	// The analysis start time in the report.
	StartTime *time.Time

	// The status of the created analysis report.
	Status AnalysisStatus

	noSmithyDocumentSerde
}

// Retrieves the details of the performance analysis report.
type AnalysisReportSummary struct {

	// The name of the analysis report.
	AnalysisReportId *string

	// The time you created the analysis report.
	CreateTime *time.Time

	// The end time of the analysis in the report.
	EndTime *time.Time

	// The start time of the analysis in the report.
	StartTime *time.Time

	// The status of the analysis report.
	Status AnalysisStatus

	// List of all the tags added to the analysis report.
	Tags []Tag

	noSmithyDocumentSerde
}

// List of data objects which provide details about source metrics. This field can
// be used to determine the PI metric to render for the insight. This data type
// also includes static values for the metrics for the Insight that were calculated
// and included in text and annotations on the DB load chart.
type Data struct {

	// This field determines the Performance Insights metric to render for the
	// insight. The name field refers to a Performance Insights metric.
	PerformanceInsightsMetric *PerformanceInsightsMetric

	noSmithyDocumentSerde
}

// A timestamp, and a single numerical value, which together represent a
// measurement at a particular point in time.
type DataPoint struct {

	// The time, in epoch format, associated with a particular Value .
	//
	// This member is required.
	Timestamp *time.Time

	// The actual value associated with a particular Timestamp .
	//
	// This member is required.
	Value *float64

	noSmithyDocumentSerde
}

// The information about a dimension.
type DimensionDetail struct {

	// The identifier of a dimension.
	Identifier *string

	noSmithyDocumentSerde
}

// A logical grouping of Performance Insights metrics for a related subject area.
// For example, the db.sql dimension group consists of the following dimensions:
//
//   - db.sql.id - The hash of a running SQL statement, generated by Performance
//     Insights.
//
//   - db.sql.db_id - Either the SQL ID generated by the database engine, or a
//     value generated by Performance Insights that begins with pi- .
//
//   - db.sql.statement - The full text of the SQL statement that is running, for
//     example, SELECT * FROM employees .
//
//   - db.sql_tokenized.id - The hash of the SQL digest generated by Performance
//     Insights.
//
// Each response element returns a maximum of 500 bytes. For larger elements, such
// as SQL statements, only the first 500 bytes are returned.
type DimensionGroup struct {

	// The name of the dimension group. Valid values are as follows:
	//
	//   - db - The name of the database to which the client is connected. The
	//   following values are permitted:
	//
	//   - Aurora PostgreSQL
	//
	//   - Amazon RDS PostgreSQL
	//
	//   - Aurora MySQL
	//
	//   - Amazon RDS MySQL
	//
	//   - Amazon RDS MariaDB
	//
	//   - Amazon DocumentDB
	//
	//   - db.application - The name of the application that is connected to the
	//   database. The following values are permitted:
	//
	//   - Aurora PostgreSQL
	//
	//   - Amazon RDS PostgreSQL
	//
	//   - Amazon DocumentDB
	//
	//   - db.host - The host name of the connected client (all engines).
	//
	//   - db.query - The query that is currently running (only Amazon DocumentDB).
	//
	//   - db.query_tokenized - The digest query (only Amazon DocumentDB).
	//
	//   - db.session_type - The type of the current session (only Aurora PostgreSQL
	//   and RDS PostgreSQL).
	//
	//   - db.sql - The text of the SQL statement that is currently running (all
	//   engines except Amazon DocumentDB).
	//
	//   - db.sql_tokenized - The SQL digest (all engines except Amazon DocumentDB).
	//
	//   - db.user - The user logged in to the database (all engines except Amazon
	//   DocumentDB).
	//
	//   - db.wait_event - The event for which the database backend is waiting (all
	//   engines except Amazon DocumentDB).
	//
	//   - db.wait_event_type - The type of event for which the database backend is
	//   waiting (all engines except Amazon DocumentDB).
	//
	//   - db.wait_state - The event for which the database backend is waiting (only
	//   Amazon DocumentDB).
	//
	// This member is required.
	Group *string

	// A list of specific dimensions from a dimension group. If this parameter is not
	// present, then it signifies that all of the dimensions in the group were
	// requested, or are present in the response.
	//
	// Valid values for elements in the Dimensions array are:
	//
	//   - db.application.name - The name of the application that is connected to the
	//   database. Valid values are as follows:
	//
	//   - Aurora PostgreSQL
	//
	//   - Amazon RDS PostgreSQL
	//
	//   - Amazon DocumentDB
	//
	//   - db.host.id - The host ID of the connected client (all engines).
	//
	//   - db.host.name - The host name of the connected client (all engines).
	//
	//   - db.name - The name of the database to which the client is connected. Valid
	//   values are as follows:
	//
	//   - Aurora PostgreSQL
	//
	//   - Amazon RDS PostgreSQL
	//
	//   - Aurora MySQL
	//
	//   - Amazon RDS MySQL
	//
	//   - Amazon RDS MariaDB
	//
	//   - Amazon DocumentDB
	//
	//   - db.query.id - The query ID generated by Performance Insights (only Amazon
	//   DocumentDB).
	//
	//   - db.query.db_id - The query ID generated by the database (only Amazon
	//   DocumentDB).
	//
	//   - db.query.statement - The text of the query that is being run (only Amazon
	//   DocumentDB).
	//
	//   - db.query.tokenized_id
	//
	//   - db.query.tokenized.id - The query digest ID generated by Performance
	//   Insights (only Amazon DocumentDB).
	//
	//   - db.query.tokenized.db_id - The query digest ID generated by Performance
	//   Insights (only Amazon DocumentDB).
	//
	//   - db.query.tokenized.statement - The text of the query digest (only Amazon
	//   DocumentDB).
	//
	//   - db.session_type.name - The type of the current session (only Amazon
	//   DocumentDB).
	//
	//   - db.sql.id - The hash of the full, non-tokenized SQL statement generated by
	//   Performance Insights (all engines except Amazon DocumentDB).
	//
	//   - db.sql.db_id - Either the SQL ID generated by the database engine, or a
	//   value generated by Performance Insights that begins with pi- (all engines
	//   except Amazon DocumentDB).
	//
	//   - db.sql.statement - The full text of the SQL statement that is running, as in
	//   SELECT * FROM employees (all engines except Amazon DocumentDB)
	//
	//   - db.sql.tokenized_id
	//
	//   - db.sql_tokenized.id - The hash of the SQL digest generated by Performance
	//   Insights (all engines except Amazon DocumentDB). In the console,
	//   db.sql_tokenized.id is called the Support ID because Amazon Web Services
	//   Support can look at this data to help you troubleshoot database issues.
	//
	//   - db.sql_tokenized.db_id - Either the native database ID used to refer to the
	//   SQL statement, or a synthetic ID such as pi-2372568224 that Performance
	//   Insights generates if the native database ID isn't available (all engines except
	//   Amazon DocumentDB).
	//
	//   - db.sql_tokenized.statement - The text of the SQL digest, as in SELECT *
	//   FROM employees WHERE employee_id = ? (all engines except Amazon DocumentDB)
	//
	//   - db.user.id - The ID of the user logged in to the database (all engines
	//   except Amazon DocumentDB).
	//
	//   - db.user.name - The name of the user logged in to the database (all engines
	//   except Amazon DocumentDB).
	//
	//   - db.wait_event.name - The event for which the backend is waiting (all engines
	//   except Amazon DocumentDB).
	//
	//   - db.wait_event.type - The type of event for which the backend is waiting (all
	//   engines except Amazon DocumentDB).
	//
	//   - db.wait_event_type.name - The name of the event type for which the backend
	//   is waiting (all engines except Amazon DocumentDB).
	//
	//   - db.wait_state.name - The event for which the backend is waiting (only Amazon
	//   DocumentDB).
	Dimensions []string

	// The maximum number of items to fetch for this dimension group.
	Limit *int32

	noSmithyDocumentSerde
}

// Information about dimensions within a dimension group.
type DimensionGroupDetail struct {

	// The dimensions within a dimension group.
	Dimensions []DimensionDetail

	// The name of the dimension group.
	Group *string

	noSmithyDocumentSerde
}

// An object that includes the requested dimension key values and aggregated
// metric values within a dimension group.
type DimensionKeyDescription struct {

	// A map that contains the value for each additional metric.
	AdditionalMetrics map[string]float64

	// A map of name-value pairs for the dimensions in the group.
	Dimensions map[string]string

	// If PartitionBy was specified, PartitionKeys contains the dimensions that were.
	Partitions []float64

	// The aggregated metric value for the dimensions, over the requested time range.
	Total *float64

	noSmithyDocumentSerde
}

// An object that describes the details for a specified dimension.
type DimensionKeyDetail struct {

	// The full name of the dimension. The full name includes the group name and key
	// name. The following values are valid:
	//
	//   - db.query.statement (Amazon DocumentDB)
	//
	//   - db.sql.statement (Amazon RDS and Aurora)
	Dimension *string

	// The status of the dimension detail data. Possible values include the following:
	//
	//   - AVAILABLE - The dimension detail data is ready to be retrieved.
	//
	//   - PROCESSING - The dimension detail data isn't ready to be retrieved because
	//   more processing time is required. If the requested detail data has the status
	//   PROCESSING , Performance Insights returns the truncated query.
	//
	//   - UNAVAILABLE - The dimension detail data could not be collected successfully.
	Status DetailStatus

	// The value of the dimension detail data. Depending on the return status, this
	// value is either the full or truncated SQL query for the following dimensions:
	//
	//   - db.query.statement (Amazon DocumentDB)
	//
	//   - db.sql.statement (Amazon RDS and Aurora)
	Value *string

	noSmithyDocumentSerde
}

// The metadata for a feature. For example, the metadata might indicate that a
// feature is turned on or off on a specific DB instance.
type FeatureMetadata struct {

	// The status of the feature on the DB instance. Possible values include the
	// following:
	//
	//   - ENABLED - The feature is enabled on the instance.
	//
	//   - DISABLED - The feature is disabled on the instance.
	//
	//   - UNSUPPORTED - The feature isn't supported on the instance.
	//
	//   - ENABLED_PENDING_REBOOT - The feature is enabled on the instance but requires
	//   a reboot to take effect.
	//
	//   - DISABLED_PENDING_REBOOT - The feature is disabled on the instance but
	//   requires a reboot to take effect.
	//
	//   - UNKNOWN - The feature status couldn't be determined.
	Status FeatureStatus

	noSmithyDocumentSerde
}

// Retrieves the list of performance issues which are identified.
type Insight struct {

	// The unique identifier for the insight. For example, insight-12345678901234567 .
	//
	// This member is required.
	InsightId *string

	//  Metric names and values from the timeframe used as baseline to generate the
	// insight.
	BaselineData []Data

	// Indicates if the insight is causal or correlated insight.
	Context ContextType

	// Description of the insight. For example: A high severity Insight found between
	// 02:00 to 02:30, where there was an unusually high DB load 600x above baseline.
	// Likely performance impact .
	Description *string

	// The end time of the insight. For example, 2018-10-30T00:00:00Z .
	EndTime *time.Time

	// List of data objects containing metrics and references from the time range
	// while generating the insight.
	InsightData []Data

	// The type of insight. For example, HighDBLoad , HighCPU , or DominatingSQLs .
	InsightType *string

	// List of recommendations for the insight. For example, Investigate the following
	// SQLs that contributed to 100% of the total DBLoad during that time period:
	// sql-id .
	Recommendations []Recommendation

	// The severity of the insight. The values are: Low , Medium , or High .
	Severity Severity

	// The start time of the insight. For example, 2018-10-30T00:00:00Z .
	StartTime *time.Time

	// List of supporting insights that provide additional factors for the insight.
	SupportingInsights []Insight

	noSmithyDocumentSerde
}

// The available dimension information for a metric type.
type MetricDimensionGroups struct {

	// The available dimension groups for a metric type.
	Groups []DimensionGroupDetail

	// The metric type to which the dimension information belongs.
	Metric *string

	noSmithyDocumentSerde
}

// A time-ordered series of data points, corresponding to a dimension of a
// Performance Insights metric.
type MetricKeyDataPoints struct {

	// An array of timestamp-value pairs, representing measurements over a period of
	// time.
	DataPoints []DataPoint

	// The dimensions to which the data points apply.
	Key *ResponseResourceMetricKey

	noSmithyDocumentSerde
}

// A single query to be processed. You must provide the metric to query and append
// an aggregate function to the metric. For example, to find the average for the
// metric db.load you must use db.load.avg . Valid values for aggregate functions
// include .avg , .min , .max , and .sum . If no other parameters are specified,
// Performance Insights returns all data points for the specified metric.
// Optionally, you can request that the data points be aggregated by dimension
// group ( GroupBy ), and return only those data points that match your criteria (
// Filter ).
type MetricQuery struct {

	// The name of a Performance Insights metric to be measured.
	//
	// Valid values for Metric are:
	//
	//   - db.load.avg - A scaled representation of the number of active sessions for
	//   the database engine.
	//
	//   - db.sampledload.avg - The raw number of active sessions for the database
	//   engine.
	//
	//   - The counter metrics listed in [Performance Insights operating system counters]in the Amazon Aurora User Guide.
	//
	//   - The counter metrics listed in [Performance Insights operating system counters]in the Amazon RDS User Guide.
	//
	// If the number of active sessions is less than an internal Performance Insights
	// threshold, db.load.avg and db.sampledload.avg are the same value. If the number
	// of active sessions is greater than the internal threshold, Performance Insights
	// samples the active sessions, with db.load.avg showing the scaled values,
	// db.sampledload.avg showing the raw values, and db.sampledload.avg less than
	// db.load.avg . For most use cases, you can query db.load.avg only.
	//
	// [Performance Insights operating system counters]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS
	//
	// This member is required.
	Metric *string

	// One or more filters to apply in the request. Restrictions:
	//
	//   - Any number of filters by the same dimension, as specified in the GroupBy
	//   parameter.
	//
	//   - A single filter for any other dimension in this dimension group.
	Filter map[string]string

	// A specification for how to aggregate the data points from a query result. You
	// must specify a valid dimension group. Performance Insights will return all of
	// the dimensions within that group, unless you provide the names of specific
	// dimensions within that group. You can also request that Performance Insights
	// return a limited number of values for a dimension.
	GroupBy *DimensionGroup

	noSmithyDocumentSerde
}

// This data type helps to determine Performance Insights metric to render for the
// insight.
type PerformanceInsightsMetric struct {

	// A dimension map that contains the dimensions for this partition.
	Dimensions map[string]string

	// The Performance Insights metric name.
	DisplayName *string

	// The Performance Insights metric.
	Metric *string

	// The value of the metric. For example, 9 for db.load.avg .
	Value *float64

	noSmithyDocumentSerde
}

// The list of recommendations for the insight.
type Recommendation struct {

	// The recommendation details to help resolve the performance issue. For example,
	// Investigate the following SQLs that contributed to 100% of the total DBLoad
	// during that time period: sql-id
	RecommendationDescription *string

	// The unique identifier for the recommendation.
	RecommendationId *string

	noSmithyDocumentSerde
}

// If PartitionBy was specified in a DescribeDimensionKeys request, the dimensions
// are returned in an array. Each element in the array specifies one dimension.
type ResponsePartitionKey struct {

	// A dimension map that contains the dimensions for this partition.
	//
	// This member is required.
	Dimensions map[string]string

	noSmithyDocumentSerde
}

// An object that contains the full name, description, and unit of a metric.
type ResponseResourceMetric struct {

	// The description of the metric.
	Description *string

	// The full name of the metric.
	Metric *string

	// The unit of the metric.
	Unit *string

	noSmithyDocumentSerde
}

// An object describing a Performance Insights metric and one or more dimensions
// for that metric.
type ResponseResourceMetricKey struct {

	// The name of a Performance Insights metric to be measured.
	//
	// Valid values for Metric are:
	//
	//   - db.load.avg - A scaled representation of the number of active sessions for
	//   the database engine.
	//
	//   - db.sampledload.avg - The raw number of active sessions for the database
	//   engine.
	//
	//   - The counter metrics listed in [Performance Insights operating system counters]in the Amazon Aurora User Guide.
	//
	//   - The counter metrics listed in [Performance Insights operating system counters]in the Amazon RDS User Guide.
	//
	// If the number of active sessions is less than an internal Performance Insights
	// threshold, db.load.avg and db.sampledload.avg are the same value. If the number
	// of active sessions is greater than the internal threshold, Performance Insights
	// samples the active sessions, with db.load.avg showing the scaled values,
	// db.sampledload.avg showing the raw values, and db.sampledload.avg less than
	// db.load.avg . For most use cases, you can query db.load.avg only.
	//
	// [Performance Insights operating system counters]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS
	//
	// This member is required.
	Metric *string

	// The valid dimensions for the metric.
	Dimensions map[string]string

	noSmithyDocumentSerde
}

// Metadata assigned to an Amazon RDS resource consisting of a key-value pair.
type Tag struct {

	// A key is the required name of the tag. The string value can be from 1 to 128
	// Unicode characters in length and can't be prefixed with aws: or rds: . The
	// string can only contain only the set of Unicode letters, digits, white-space,
	// '_', '.', ':', '/', '=', '+', '-', '@' (Java regex:
	// "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$" ).
	//
	// This member is required.
	Key *string

	// A value is the optional value of the tag. The string value can be from 1 to 256
	// Unicode characters in length and can't be prefixed with aws: or rds: . The
	// string can only contain only the set of Unicode letters, digits, white-space,
	// '_', '.', ':', '/', '=', '+', '-', '@' (Java regex:
	// "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
