// Code generated by smithy-go-codegen DO NOT EDIT.

package appsync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appsync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a DataSource object.
func (c *Client) CreateDataSource(ctx context.Context, params *CreateDataSourceInput, optFns ...func(*Options)) (*CreateDataSourceOutput, error) {
	if params == nil {
		params = &CreateDataSourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDataSource", params, optFns, c.addOperationCreateDataSourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDataSourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDataSourceInput struct {

	// The API ID for the GraphQL API for the DataSource .
	//
	// This member is required.
	ApiId *string

	// A user-supplied name for the DataSource .
	//
	// This member is required.
	Name *string

	// The type of the DataSource .
	//
	// This member is required.
	Type types.DataSourceType

	// A description of the DataSource .
	Description *string

	// Amazon DynamoDB settings.
	DynamodbConfig *types.DynamodbDataSourceConfig

	// Amazon OpenSearch Service settings.
	//
	// As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch
	// Service. This configuration is deprecated. For new data sources, use CreateDataSourceRequest$openSearchServiceConfigto create
	// an OpenSearch data source.
	ElasticsearchConfig *types.ElasticsearchDataSourceConfig

	// Amazon EventBridge settings.
	EventBridgeConfig *types.EventBridgeDataSourceConfig

	// HTTP endpoint settings.
	HttpConfig *types.HttpDataSourceConfig

	// Lambda settings.
	LambdaConfig *types.LambdaDataSourceConfig

	// Enables or disables enhanced data source metrics for specified data sources.
	// Note that metricsConfig won't be used unless the dataSourceLevelMetricsBehavior
	// value is set to PER_DATA_SOURCE_METRICS . If the dataSourceLevelMetricsBehavior
	// is set to FULL_REQUEST_DATA_SOURCE_METRICS instead, metricsConfig will be
	// ignored. However, you can still set its value.
	//
	// metricsConfig can be ENABLED or DISABLED .
	MetricsConfig types.DataSourceLevelMetricsConfig

	// Amazon OpenSearch Service settings.
	OpenSearchServiceConfig *types.OpenSearchServiceDataSourceConfig

	// Relational database settings.
	RelationalDatabaseConfig *types.RelationalDatabaseDataSourceConfig

	// The Identity and Access Management (IAM) service role Amazon Resource Name
	// (ARN) for the data source. The system assumes this role when accessing the data
	// source.
	ServiceRoleArn *string

	noSmithyDocumentSerde
}

type CreateDataSourceOutput struct {

	// The DataSource object.
	DataSource *types.DataSource

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDataSourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDataSource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDataSource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDataSource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateDataSourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDataSource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDataSource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDataSource",
	}
}
