//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateSqlPoolVulnerabilityAssessmentRuleBaseline.json
func ExampleSQLPoolVulnerabilityAssessmentRuleBaselinesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armsynapse.NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient("00000000-1111-2222-3333-444444444444", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.CreateOrUpdate(ctx,
		"vulnerabilityaseessmenttest-4799",
		"vulnerabilityaseessmenttest-6440",
		"testdb",
		armsynapse.VulnerabilityAssessmentNameDefault,
		"VA1001",
		armsynapse.VulnerabilityAssessmentPolicyBaselineNameDefault,
		armsynapse.SQLPoolVulnerabilityAssessmentRuleBaseline{
			Properties: &armsynapse.SQLPoolVulnerabilityAssessmentRuleBaselineProperties{
				BaselineResults: []*armsynapse.SQLPoolVulnerabilityAssessmentRuleBaselineItem{
					{
						Result: []*string{
							to.Ptr("userA"),
							to.Ptr("SELECT")},
					},
					{
						Result: []*string{
							to.Ptr("userB"),
							to.Ptr("SELECT")},
					},
					{
						Result: []*string{
							to.Ptr("userC"),
							to.Ptr("SELECT"),
							to.Ptr("tableId_4")},
					}},
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DeleteSqlPoolVulnerabilityAssessmentRuleBaseline.json
func ExampleSQLPoolVulnerabilityAssessmentRuleBaselinesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armsynapse.NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient("00000000-1111-2222-3333-444444444444", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = client.Delete(ctx,
		"vulnerabilityaseessmenttest-4799",
		"vulnerabilityaseessmenttest-6440",
		"testdb",
		armsynapse.VulnerabilityAssessmentNameDefault,
		"VA1001",
		armsynapse.VulnerabilityAssessmentPolicyBaselineNameDefault,
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolVulnerabilityAssessmentRuleBaselineGet.json
func ExampleSQLPoolVulnerabilityAssessmentRuleBaselinesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armsynapse.NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient("00000000-1111-2222-3333-444444444444", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Get(ctx,
		"vulnerabilityaseessmenttest-4711",
		"vulnerabilityaseessmenttest-6411",
		"testdb",
		armsynapse.VulnerabilityAssessmentNameDefault,
		"VA1001",
		armsynapse.VulnerabilityAssessmentPolicyBaselineNameMaster,
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}
