//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armm365securityandcompliance

import "time"

// ErrorDetails - Error details.
type ErrorDetails struct {
	// Object containing error details.
	Error *ErrorDetailsInternal `json:"error,omitempty"`
}

// ErrorDetailsInternal - Error details.
type ErrorDetailsInternal struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the particular error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// Operation - Service REST API operation.
type Operation struct {
	// READ-ONLY; The information displayed about the operation.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; Operation name: {provider}/{resource}/{read | write | action | delete}
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Default value is 'user,system'.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Friendly description for the operation,
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Name of the operation
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft.M365SecurityAndCompliance
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type: Services
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of service operations. It contains a list of operations and a URL link to get the next set
// of results.
type OperationListResult struct {
	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of service operations supported by the Microsoft.M365SecurityAndCompliance resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationResultsClientGetOptions contains the optional parameters for the OperationResultsClient.Get method.
type OperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationResultsDescription - The properties indicating the operation result of an operation on a service.
type OperationResultsDescription struct {
	// Additional properties of the operation result.
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; The ID of the operation returned.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation result.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The time that the operation was started.
	StartTime *string `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The status of the operation being performed.
	Status *OperationResultStatus `json:"status,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Required property for system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsAdtAPIClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsAdtAPIClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsAdtAPIClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsAdtAPIClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsAdtAPIClient.BeginDelete
// method.
type PrivateEndpointConnectionsAdtAPIClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsAdtAPIClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsAdtAPIClient.Get
// method.
type PrivateEndpointConnectionsAdtAPIClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsAdtAPIClientListByServiceOptions contains the optional parameters for the PrivateEndpointConnectionsAdtAPIClient.ListByService
// method.
type PrivateEndpointConnectionsAdtAPIClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsCompClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsCompClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsCompClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsCompClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsCompClient.BeginDelete
// method.
type PrivateEndpointConnectionsCompClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsCompClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsCompClient.Get
// method.
type PrivateEndpointConnectionsCompClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsCompClientListByServiceOptions contains the optional parameters for the PrivateEndpointConnectionsCompClient.ListByService
// method.
type PrivateEndpointConnectionsCompClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsForEDMClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsForEDMClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsForEDMClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsForEDMClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsForEDMClient.BeginDelete
// method.
type PrivateEndpointConnectionsForEDMClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsForEDMClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsForEDMClient.Get
// method.
type PrivateEndpointConnectionsForEDMClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsForEDMClientListByServiceOptions contains the optional parameters for the PrivateEndpointConnectionsForEDMClient.ListByService
// method.
type PrivateEndpointConnectionsForEDMClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsForMIPPolicySyncClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsForMIPPolicySyncClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsForMIPPolicySyncClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsForMIPPolicySyncClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsForMIPPolicySyncClient.BeginDelete
// method.
type PrivateEndpointConnectionsForMIPPolicySyncClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsForMIPPolicySyncClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsForMIPPolicySyncClient.Get
// method.
type PrivateEndpointConnectionsForMIPPolicySyncClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsForMIPPolicySyncClientListByServiceOptions contains the optional parameters for the PrivateEndpointConnectionsForMIPPolicySyncClient.ListByService
// method.
type PrivateEndpointConnectionsForMIPPolicySyncClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsForSCCPowershellClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsForSCCPowershellClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsForSCCPowershellClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsForSCCPowershellClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsForSCCPowershellClient.BeginDelete
// method.
type PrivateEndpointConnectionsForSCCPowershellClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsForSCCPowershellClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsForSCCPowershellClient.Get
// method.
type PrivateEndpointConnectionsForSCCPowershellClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsForSCCPowershellClientListByServiceOptions contains the optional parameters for the PrivateEndpointConnectionsForSCCPowershellClient.ListByService
// method.
type PrivateEndpointConnectionsForSCCPowershellClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsSecClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsSecClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsSecClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsSecClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsSecClient.BeginDelete
// method.
type PrivateEndpointConnectionsSecClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsSecClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsSecClient.Get
// method.
type PrivateEndpointConnectionsSecClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsSecClientListByServiceOptions contains the optional parameters for the PrivateEndpointConnectionsSecClient.ListByService
// method.
type PrivateEndpointConnectionsSecClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Required property for system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesAdtAPIClientGetOptions contains the optional parameters for the PrivateLinkResourcesAdtAPIClient.Get
// method.
type PrivateLinkResourcesAdtAPIClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesAdtAPIClientListByServiceOptions contains the optional parameters for the PrivateLinkResourcesAdtAPIClient.ListByService
// method.
type PrivateLinkResourcesAdtAPIClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByServiceOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByService
// method.
type PrivateLinkResourcesClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesCompClientGetOptions contains the optional parameters for the PrivateLinkResourcesCompClient.Get method.
type PrivateLinkResourcesCompClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesCompClientListByServiceOptions contains the optional parameters for the PrivateLinkResourcesCompClient.ListByService
// method.
type PrivateLinkResourcesCompClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesForMIPPolicySyncClientGetOptions contains the optional parameters for the PrivateLinkResourcesForMIPPolicySyncClient.Get
// method.
type PrivateLinkResourcesForMIPPolicySyncClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesForMIPPolicySyncClientListByServiceOptions contains the optional parameters for the PrivateLinkResourcesForMIPPolicySyncClient.ListByService
// method.
type PrivateLinkResourcesForMIPPolicySyncClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesForSCCPowershellClientGetOptions contains the optional parameters for the PrivateLinkResourcesForSCCPowershellClient.Get
// method.
type PrivateLinkResourcesForSCCPowershellClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesForSCCPowershellClientListByServiceOptions contains the optional parameters for the PrivateLinkResourcesForSCCPowershellClient.ListByService
// method.
type PrivateLinkResourcesForSCCPowershellClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesSecClientGetOptions contains the optional parameters for the PrivateLinkResourcesSecClient.Get method.
type PrivateLinkResourcesSecClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesSecClientListByServiceOptions contains the optional parameters for the PrivateLinkResourcesSecClient.ListByService
// method.
type PrivateLinkResourcesSecClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// PrivateLinkServicesForEDMUploadClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateLinkServicesForEDMUploadClient.BeginCreateOrUpdate
// method.
type PrivateLinkServicesForEDMUploadClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForEDMUploadClientBeginUpdateOptions contains the optional parameters for the PrivateLinkServicesForEDMUploadClient.BeginUpdate
// method.
type PrivateLinkServicesForEDMUploadClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForEDMUploadClientGetOptions contains the optional parameters for the PrivateLinkServicesForEDMUploadClient.Get
// method.
type PrivateLinkServicesForEDMUploadClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForEDMUploadClientListByResourceGroupOptions contains the optional parameters for the PrivateLinkServicesForEDMUploadClient.ListByResourceGroup
// method.
type PrivateLinkServicesForEDMUploadClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForEDMUploadClientListOptions contains the optional parameters for the PrivateLinkServicesForEDMUploadClient.List
// method.
type PrivateLinkServicesForEDMUploadClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForEDMUploadDescription - The description of the service.
type PrivateLinkServicesForEDMUploadDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity `json:"identity,omitempty"`

	// The common properties of a service.
	Properties *ServicesProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Required property for system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkServicesForEDMUploadDescriptionListResult - A list of service description objects with a next link.
type PrivateLinkServicesForEDMUploadDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForEDMUploadDescription `json:"value,omitempty"`

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateLinkServicesForM365ComplianceCenterClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateLinkServicesForM365ComplianceCenterClient.BeginCreateOrUpdate
// method.
type PrivateLinkServicesForM365ComplianceCenterClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForM365ComplianceCenterClientBeginDeleteOptions contains the optional parameters for the PrivateLinkServicesForM365ComplianceCenterClient.BeginDelete
// method.
type PrivateLinkServicesForM365ComplianceCenterClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForM365ComplianceCenterClientBeginUpdateOptions contains the optional parameters for the PrivateLinkServicesForM365ComplianceCenterClient.BeginUpdate
// method.
type PrivateLinkServicesForM365ComplianceCenterClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForM365ComplianceCenterClientGetOptions contains the optional parameters for the PrivateLinkServicesForM365ComplianceCenterClient.Get
// method.
type PrivateLinkServicesForM365ComplianceCenterClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForM365ComplianceCenterClientListByResourceGroupOptions contains the optional parameters for the PrivateLinkServicesForM365ComplianceCenterClient.ListByResourceGroup
// method.
type PrivateLinkServicesForM365ComplianceCenterClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForM365ComplianceCenterClientListOptions contains the optional parameters for the PrivateLinkServicesForM365ComplianceCenterClient.List
// method.
type PrivateLinkServicesForM365ComplianceCenterClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForM365ComplianceCenterDescription - The description of the service.
type PrivateLinkServicesForM365ComplianceCenterDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity `json:"identity,omitempty"`

	// The common properties of a service.
	Properties *ServicesProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Required property for system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkServicesForM365ComplianceCenterDescriptionListResult - A list of service description objects with a next link.
type PrivateLinkServicesForM365ComplianceCenterDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForM365ComplianceCenterDescription `json:"value,omitempty"`

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateLinkServicesForM365SecurityCenterClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateLinkServicesForM365SecurityCenterClient.BeginCreateOrUpdate
// method.
type PrivateLinkServicesForM365SecurityCenterClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForM365SecurityCenterClientBeginDeleteOptions contains the optional parameters for the PrivateLinkServicesForM365SecurityCenterClient.BeginDelete
// method.
type PrivateLinkServicesForM365SecurityCenterClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForM365SecurityCenterClientBeginUpdateOptions contains the optional parameters for the PrivateLinkServicesForM365SecurityCenterClient.BeginUpdate
// method.
type PrivateLinkServicesForM365SecurityCenterClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForM365SecurityCenterClientGetOptions contains the optional parameters for the PrivateLinkServicesForM365SecurityCenterClient.Get
// method.
type PrivateLinkServicesForM365SecurityCenterClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForM365SecurityCenterClientListByResourceGroupOptions contains the optional parameters for the PrivateLinkServicesForM365SecurityCenterClient.ListByResourceGroup
// method.
type PrivateLinkServicesForM365SecurityCenterClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForM365SecurityCenterClientListOptions contains the optional parameters for the PrivateLinkServicesForM365SecurityCenterClient.List
// method.
type PrivateLinkServicesForM365SecurityCenterClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForM365SecurityCenterDescription - The description of the service.
type PrivateLinkServicesForM365SecurityCenterDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity `json:"identity,omitempty"`

	// The common properties of a service.
	Properties *ServicesProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Required property for system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkServicesForM365SecurityCenterDescriptionListResult - A list of service description objects with a next link.
type PrivateLinkServicesForM365SecurityCenterDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForM365SecurityCenterDescription `json:"value,omitempty"`

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateLinkServicesForMIPPolicySyncClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateLinkServicesForMIPPolicySyncClient.BeginCreateOrUpdate
// method.
type PrivateLinkServicesForMIPPolicySyncClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForMIPPolicySyncClientBeginDeleteOptions contains the optional parameters for the PrivateLinkServicesForMIPPolicySyncClient.BeginDelete
// method.
type PrivateLinkServicesForMIPPolicySyncClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForMIPPolicySyncClientBeginUpdateOptions contains the optional parameters for the PrivateLinkServicesForMIPPolicySyncClient.BeginUpdate
// method.
type PrivateLinkServicesForMIPPolicySyncClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForMIPPolicySyncClientGetOptions contains the optional parameters for the PrivateLinkServicesForMIPPolicySyncClient.Get
// method.
type PrivateLinkServicesForMIPPolicySyncClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForMIPPolicySyncClientListByResourceGroupOptions contains the optional parameters for the PrivateLinkServicesForMIPPolicySyncClient.ListByResourceGroup
// method.
type PrivateLinkServicesForMIPPolicySyncClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForMIPPolicySyncClientListOptions contains the optional parameters for the PrivateLinkServicesForMIPPolicySyncClient.List
// method.
type PrivateLinkServicesForMIPPolicySyncClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForMIPPolicySyncDescription - The description of the service.
type PrivateLinkServicesForMIPPolicySyncDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity `json:"identity,omitempty"`

	// The common properties of a service.
	Properties *ServicesProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Required property for system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkServicesForMIPPolicySyncDescriptionListResult - A list of service description objects with a next link.
type PrivateLinkServicesForMIPPolicySyncDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForMIPPolicySyncDescription `json:"value,omitempty"`

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateLinkServicesForO365ManagementActivityAPIClientBeginCreateOrUpdateOptions contains the optional parameters for the
// PrivateLinkServicesForO365ManagementActivityAPIClient.BeginCreateOrUpdate method.
type PrivateLinkServicesForO365ManagementActivityAPIClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForO365ManagementActivityAPIClientBeginDeleteOptions contains the optional parameters for the PrivateLinkServicesForO365ManagementActivityAPIClient.BeginDelete
// method.
type PrivateLinkServicesForO365ManagementActivityAPIClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForO365ManagementActivityAPIClientBeginUpdateOptions contains the optional parameters for the PrivateLinkServicesForO365ManagementActivityAPIClient.BeginUpdate
// method.
type PrivateLinkServicesForO365ManagementActivityAPIClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForO365ManagementActivityAPIClientGetOptions contains the optional parameters for the PrivateLinkServicesForO365ManagementActivityAPIClient.Get
// method.
type PrivateLinkServicesForO365ManagementActivityAPIClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForO365ManagementActivityAPIClientListByResourceGroupOptions contains the optional parameters for the
// PrivateLinkServicesForO365ManagementActivityAPIClient.ListByResourceGroup method.
type PrivateLinkServicesForO365ManagementActivityAPIClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForO365ManagementActivityAPIClientListOptions contains the optional parameters for the PrivateLinkServicesForO365ManagementActivityAPIClient.List
// method.
type PrivateLinkServicesForO365ManagementActivityAPIClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForO365ManagementActivityAPIDescription - The description of the service.
type PrivateLinkServicesForO365ManagementActivityAPIDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity `json:"identity,omitempty"`

	// The common properties of a service.
	Properties *ServicesProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Required property for system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkServicesForO365ManagementActivityAPIDescriptionListResult - A list of service description objects with a next
// link.
type PrivateLinkServicesForO365ManagementActivityAPIDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForO365ManagementActivityAPIDescription `json:"value,omitempty"`

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateLinkServicesForSCCPowershellClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateLinkServicesForSCCPowershellClient.BeginCreateOrUpdate
// method.
type PrivateLinkServicesForSCCPowershellClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForSCCPowershellClientBeginDeleteOptions contains the optional parameters for the PrivateLinkServicesForSCCPowershellClient.BeginDelete
// method.
type PrivateLinkServicesForSCCPowershellClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForSCCPowershellClientBeginUpdateOptions contains the optional parameters for the PrivateLinkServicesForSCCPowershellClient.BeginUpdate
// method.
type PrivateLinkServicesForSCCPowershellClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesForSCCPowershellClientGetOptions contains the optional parameters for the PrivateLinkServicesForSCCPowershellClient.Get
// method.
type PrivateLinkServicesForSCCPowershellClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForSCCPowershellClientListByResourceGroupOptions contains the optional parameters for the PrivateLinkServicesForSCCPowershellClient.ListByResourceGroup
// method.
type PrivateLinkServicesForSCCPowershellClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForSCCPowershellClientListOptions contains the optional parameters for the PrivateLinkServicesForSCCPowershellClient.List
// method.
type PrivateLinkServicesForSCCPowershellClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesForSCCPowershellDescription - The description of the service.
type PrivateLinkServicesForSCCPowershellDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity `json:"identity,omitempty"`

	// The common properties of a service.
	Properties *ServicesProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Required property for system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkServicesForSCCPowershellDescriptionListResult - A list of service description objects with a next link.
type PrivateLinkServicesForSCCPowershellDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForSCCPowershellDescription `json:"value,omitempty"`

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceAccessPolicyEntry - An access policy entry.
type ServiceAccessPolicyEntry struct {
	// REQUIRED; An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
	ObjectID *string `json:"objectId,omitempty"`
}

// ServiceAuthenticationConfigurationInfo - Authentication configuration information
type ServiceAuthenticationConfigurationInfo struct {
	// The audience url for the service
	Audience *string `json:"audience,omitempty"`

	// The authority url for the service
	Authority *string `json:"authority,omitempty"`

	// If the SMART on FHIR proxy is enabled
	SmartProxyEnabled *bool `json:"smartProxyEnabled,omitempty"`
}

// ServiceCorsConfigurationInfo - The settings for the CORS configuration of the service instance.
type ServiceCorsConfigurationInfo struct {
	// If credentials are allowed via CORS.
	AllowCredentials *bool `json:"allowCredentials,omitempty"`

	// The headers to be allowed via CORS.
	Headers []*string `json:"headers,omitempty"`

	// The max age to be allowed via CORS.
	MaxAge *int64 `json:"maxAge,omitempty"`

	// The methods to be allowed via CORS.
	Methods []*string `json:"methods,omitempty"`

	// The origins to be allowed via CORS.
	Origins []*string `json:"origins,omitempty"`
}

// ServiceCosmosDbConfigurationInfo - The settings for the Cosmos DB database backing the service.
type ServiceCosmosDbConfigurationInfo struct {
	// The URI of the customer-managed key for the backing database.
	KeyVaultKeyURI *string `json:"keyVaultKeyUri,omitempty"`

	// The provisioned throughput for the backing database.
	OfferThroughput *int64 `json:"offerThroughput,omitempty"`
}

// ServiceExportConfigurationInfo - Export operation configuration information
type ServiceExportConfigurationInfo struct {
	// The name of the default export storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
}

// ServicesClientBeginDeleteOptions contains the optional parameters for the ServicesClient.BeginDelete method.
type ServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesPatchDescription - The description of the service.
type ServicesPatchDescription struct {
	// The properties for updating a service instance.
	Properties *ServicesPropertiesUpdateParameters `json:"properties,omitempty"`

	// Instance tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServicesProperties - The properties of a service instance.
type ServicesProperties struct {
	// The access policies of the service instance.
	AccessPolicies []*ServiceAccessPolicyEntry `json:"accessPolicies,omitempty"`

	// The authentication configuration for the service instance.
	AuthenticationConfiguration *ServiceAuthenticationConfigurationInfo `json:"authenticationConfiguration,omitempty"`

	// The settings for the CORS configuration of the service instance.
	CorsConfiguration *ServiceCorsConfigurationInfo `json:"corsConfiguration,omitempty"`

	// The settings for the Cosmos DB database backing the service.
	CosmosDbConfiguration *ServiceCosmosDbConfigurationInfo `json:"cosmosDbConfiguration,omitempty"`

	// The settings for the export operation of the service instance.
	ExportConfiguration *ServiceExportConfigurationInfo `json:"exportConfiguration,omitempty"`

	// The list of private endpoint connections that are set up for this resource.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`

	// Control permission for data plane traffic coming from public networks while private endpoint is enabled.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ServicesPropertiesUpdateParameters - The properties for updating a service instance.
type ServicesPropertiesUpdateParameters struct {
	// Control permission for data plane traffic coming from public networks while private endpoint is enabled.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// ServicesResource - The common properties of a service.
type ServicesResource struct {
	// REQUIRED; The kind of the service.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity `json:"identity,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Required property for system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServicesResourceIdentity - Setting indicating whether the service has a managed identity associated with it.
type ServicesResourceIdentity struct {
	// Type of identity being specified, currently SystemAssigned and None are allowed.
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// READ-ONLY; The principal ID of the resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}
