//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridconnectivity

import "time"

// AADProfileProperties - The AAD Profile
type AADProfileProperties struct {
	// REQUIRED; The arc ingress gateway server app id.
	ServerID *string `json:"serverId,omitempty"`

	// REQUIRED; The target resource home tenant id.
	TenantID *string `json:"tenantId,omitempty"`
}

// EndpointAccessResource - The endpoint access for the target resource.
type EndpointAccessResource struct {
	// Azure relay hybrid connection access properties
	Relay *RelayNamespaceAccessProperties `json:"relay,omitempty"`
}

// EndpointProperties - Endpoint details
type EndpointProperties struct {
	// REQUIRED; The type of endpoint.
	Type *Type `json:"type,omitempty"`

	// The resource Id of the connectivity endpoint (optional).
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The resource provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// EndpointResource - The endpoint for the target resource.
type EndpointResource struct {
	// The endpoint properties.
	Properties *EndpointProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System data of endpoint resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EndpointsClientCreateOrUpdateOptions contains the optional parameters for the EndpointsClient.CreateOrUpdate method.
type EndpointsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// EndpointsClientDeleteOptions contains the optional parameters for the EndpointsClient.Delete method.
type EndpointsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// EndpointsClientGetOptions contains the optional parameters for the EndpointsClient.Get method.
type EndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// EndpointsClientListCredentialsOptions contains the optional parameters for the EndpointsClient.ListCredentials method.
type EndpointsClientListCredentialsOptions struct {
	// The is how long the endpoint access token is valid (in seconds).
	Expiresin *int64
}

// EndpointsClientListManagedProxyDetailsOptions contains the optional parameters for the EndpointsClient.ListManagedProxyDetails
// method.
type EndpointsClientListManagedProxyDetailsOptions struct {
	// placeholder for future optional parameters
}

// EndpointsClientListOptions contains the optional parameters for the EndpointsClient.List method.
type EndpointsClientListOptions struct {
	// placeholder for future optional parameters
}

// EndpointsClientUpdateOptions contains the optional parameters for the EndpointsClient.Update method.
type EndpointsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// EndpointsList - The list of endpoints.
type EndpointsList struct {
	// The link used to get the next page of endpoints list.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of endpoint.
	Value []*EndpointResource `json:"value,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// IngressGatewayResource - The ingress gateway access credentials
type IngressGatewayResource struct {
	// Ingress gateway profile
	Ingress *IngressProfileProperties `json:"ingress,omitempty"`

	// Azure relay hybrid connection access properties
	Relay *RelayNamespaceAccessProperties `json:"relay,omitempty"`
}

// IngressProfileProperties - Ingress gateway profile
type IngressProfileProperties struct {
	// REQUIRED; The AAD Profile
	AADProfile *AADProfileProperties `json:"aadProfile,omitempty"`

	// REQUIRED; The ingress hostname.
	Hostname *string `json:"hostname,omitempty"`
}

// ManagedProxyRequest - Represent ManageProxy Request object.
type ManagedProxyRequest struct {
	// REQUIRED; The name of the service.
	Service *string `json:"service,omitempty"`

	// The target host name.
	Hostname *string `json:"hostname,omitempty"`
}

// ManagedProxyResource - Managed Proxy
type ManagedProxyResource struct {
	// REQUIRED; The expiration time of short lived proxy name in unix epoch.
	ExpiresOn *int64 `json:"expiresOn,omitempty"`

	// REQUIRED; The short lived proxy name.
	Proxy *string `json:"proxy,omitempty"`
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RelayNamespaceAccessProperties - Azure relay hybrid connection access properties
type RelayNamespaceAccessProperties struct {
	// REQUIRED; Azure Relay hybrid connection name for the resource.
	HybridConnectionName *string `json:"hybridConnectionName,omitempty"`

	// REQUIRED; The namespace name.
	NamespaceName *string `json:"namespaceName,omitempty"`

	// REQUIRED; The suffix domain name of relay namespace.
	NamespaceNameSuffix *string `json:"namespaceNameSuffix,omitempty"`

	// The expiration of access key in unix time.
	ExpiresOn *int64 `json:"expiresOn,omitempty"`

	// READ-ONLY; Access key for hybrid connection.
	AccessKey *string `json:"accessKey,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}
