//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhealthbot

import "time"

// AvailableOperations - Available operations of the service
type AvailableOperations struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of available operation details
	Value []*OperationDetail `json:"value,omitempty"`
}

// BotResponseList - The list of Azure Health Bot operation response.
type BotResponseList struct {
	// READ-ONLY; The link used to get the next page of bot service resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the list of Azure Health Bot results and their properties.
	Value []*HealthBot `json:"value,omitempty" azure:"ro"`
}

// BotsClientBeginCreateOptions contains the optional parameters for the BotsClient.BeginCreate method.
type BotsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BotsClientBeginDeleteOptions contains the optional parameters for the BotsClient.BeginDelete method.
type BotsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BotsClientGetOptions contains the optional parameters for the BotsClient.Get method.
type BotsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BotsClientListByResourceGroupOptions contains the optional parameters for the BotsClient.ListByResourceGroup method.
type BotsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// BotsClientListOptions contains the optional parameters for the BotsClient.List method.
type BotsClientListOptions struct {
	// placeholder for future optional parameters
}

// BotsClientUpdateOptions contains the optional parameters for the BotsClient.Update method.
type BotsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Error - The resource management error response.
type Error struct {
	// The error object.
	Error *ErrorError `json:"error,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorError - The error object.
type ErrorError struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*Error `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// HealthBot - Azure Health Bot resource definition
type HealthBot struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; SKU of the Azure Health Bot.
	SKU *SKU `json:"sku,omitempty"`

	// The identity of the Azure Health Bot.
	Identity *Identity `json:"identity,omitempty"`

	// The set of properties specific to Azure Health Bot resource.
	Properties *Properties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Identity for the resource.
type Identity struct {
	// The identity type. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user
	// assigned identities. The type 'None' will remove any identities from the Azure
	// Health Bot
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// OperationDetail - Operation detail payload
type OperationDetail struct {
	// Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Name of the operation
	Name *string `json:"name,omitempty"`

	// Origin of the operation
	Origin *string `json:"origin,omitempty"`

	// Additional properties.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationDisplay - Operation display payload
type OperationDisplay struct {
	// Localized friendly description for the operation
	Description *string `json:"description,omitempty"`

	// Localized friendly name for the operation
	Operation *string `json:"operation,omitempty"`

	// Resource provider of the operation
	Provider *string `json:"provider,omitempty"`

	// Resource of the operation
	Resource *string `json:"resource,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Properties - The properties of a Azure Health Bot. The Health Bot Service is a cloud platform that empowers developers
// in Healthcare organizations to build and deploy their compliant, AI-powered virtual health
// assistants and health bots, that help them improve processes and reduce costs.
type Properties struct {
	// READ-ONLY; The link.
	BotManagementPortalLink *string `json:"botManagementPortalLink,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the Azure Health Bot resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// Resource - The resource model definition for a ARM tracked top level resource
type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the Azure Health Bot SKU
	Name *SKUName `json:"name,omitempty"`
}

// SystemData - Read only system data
type SystemData struct {
	// The timestamp of resource creation (UTC)
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource
	CreatedByType *IdentityType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource
	LastModifiedByType *IdentityType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpdateParameters - Parameters for updating a Azure Health Bot.
type UpdateParameters struct {
	// The identity of the Azure Health Bot.
	Identity *Identity `json:"identity,omitempty"`
	Location *string   `json:"location,omitempty"`

	// SKU of the Azure Health Bot.
	SKU *SKU `json:"sku,omitempty"`

	// Tags for a Azure Health Bot.
	Tags map[string]*string `json:"tags,omitempty"`
}

// UserAssignedIdentity - The details of the user assigned managed identity used by the Video Analyzer resource.
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// ValidationResult - The response returned from validation process
type ValidationResult struct {
	// The status code of the response validation.
	Status *string `json:"status,omitempty"`
}
