//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataprotection

import "encoding/json"

func unmarshalAuthCredentialsClassification(rawMsg json.RawMessage) (AuthCredentialsClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AuthCredentialsClassification
	switch m["objectType"] {
	case "SecretStoreBasedAuthCredentials":
		b = &SecretStoreBasedAuthCredentials{}
	default:
		b = &AuthCredentials{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalAzureBackupRecoveryPointClassification(rawMsg json.RawMessage) (AzureBackupRecoveryPointClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AzureBackupRecoveryPointClassification
	switch m["objectType"] {
	case "AzureBackupDiscreteRecoveryPoint":
		b = &AzureBackupDiscreteRecoveryPoint{}
	default:
		b = &AzureBackupRecoveryPoint{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalAzureBackupRestoreRequestClassification(rawMsg json.RawMessage) (AzureBackupRestoreRequestClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AzureBackupRestoreRequestClassification
	switch m["objectType"] {
	case "AzureBackupRecoveryPointBasedRestoreRequest":
		b = &AzureBackupRecoveryPointBasedRestoreRequest{}
	case "AzureBackupRecoveryTimeBasedRestoreRequest":
		b = &AzureBackupRecoveryTimeBasedRestoreRequest{}
	case "AzureBackupRestoreWithRehydrationRequest":
		b = &AzureBackupRestoreWithRehydrationRequest{}
	default:
		b = &AzureBackupRestoreRequest{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalBackupCriteriaClassification(rawMsg json.RawMessage) (BackupCriteriaClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BackupCriteriaClassification
	switch m["objectType"] {
	case "ScheduleBasedBackupCriteria":
		b = &ScheduleBasedBackupCriteria{}
	default:
		b = &BackupCriteria{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalBackupCriteriaClassificationArray(rawMsg json.RawMessage) ([]BackupCriteriaClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]BackupCriteriaClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalBackupCriteriaClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalBackupParametersClassification(rawMsg json.RawMessage) (BackupParametersClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BackupParametersClassification
	switch m["objectType"] {
	case "AzureBackupParams":
		b = &AzureBackupParams{}
	default:
		b = &BackupParameters{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalBaseBackupPolicyClassification(rawMsg json.RawMessage) (BaseBackupPolicyClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BaseBackupPolicyClassification
	switch m["objectType"] {
	case "BackupPolicy":
		b = &BackupPolicy{}
	default:
		b = &BaseBackupPolicy{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalBasePolicyRuleClassification(rawMsg json.RawMessage) (BasePolicyRuleClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BasePolicyRuleClassification
	switch m["objectType"] {
	case "AzureBackupRule":
		b = &AzureBackupRule{}
	case "AzureRetentionRule":
		b = &AzureRetentionRule{}
	default:
		b = &BasePolicyRule{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalBasePolicyRuleClassificationArray(rawMsg json.RawMessage) ([]BasePolicyRuleClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]BasePolicyRuleClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalBasePolicyRuleClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalCopyOptionClassification(rawMsg json.RawMessage) (CopyOptionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b CopyOptionClassification
	switch m["objectType"] {
	case "CopyOnExpiryOption":
		b = &CopyOnExpiryOption{}
	case "CustomCopyOption":
		b = &CustomCopyOption{}
	case "ImmediateCopyOption":
		b = &ImmediateCopyOption{}
	default:
		b = &CopyOption{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalDataStoreParametersClassification(rawMsg json.RawMessage) (DataStoreParametersClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DataStoreParametersClassification
	switch m["objectType"] {
	case "AzureOperationalStoreParameters":
		b = &AzureOperationalStoreParameters{}
	default:
		b = &DataStoreParameters{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalDataStoreParametersClassificationArray(rawMsg json.RawMessage) ([]DataStoreParametersClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]DataStoreParametersClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalDataStoreParametersClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalDeleteOptionClassification(rawMsg json.RawMessage) (DeleteOptionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DeleteOptionClassification
	switch m["objectType"] {
	case "AbsoluteDeleteOption":
		b = &AbsoluteDeleteOption{}
	default:
		b = &DeleteOption{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalFeatureValidationResponseBaseClassification(rawMsg json.RawMessage) (FeatureValidationResponseBaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b FeatureValidationResponseBaseClassification
	switch m["objectType"] {
	case "FeatureValidationResponse":
		b = &FeatureValidationResponse{}
	default:
		b = &FeatureValidationResponseBase{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalItemLevelRestoreCriteriaClassification(rawMsg json.RawMessage) (ItemLevelRestoreCriteriaClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ItemLevelRestoreCriteriaClassification
	switch m["objectType"] {
	case "KubernetesPVRestoreCriteria":
		b = &KubernetesPVRestoreCriteria{}
	case "KubernetesStorageClassRestoreCriteria":
		b = &KubernetesStorageClassRestoreCriteria{}
	case "RangeBasedItemLevelRestoreCriteria":
		b = &RangeBasedItemLevelRestoreCriteria{}
	default:
		b = &ItemLevelRestoreCriteria{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalItemLevelRestoreCriteriaClassificationArray(rawMsg json.RawMessage) ([]ItemLevelRestoreCriteriaClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]ItemLevelRestoreCriteriaClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalItemLevelRestoreCriteriaClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalOperationExtendedInfoClassification(rawMsg json.RawMessage) (OperationExtendedInfoClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b OperationExtendedInfoClassification
	switch m["objectType"] {
	case "OperationJobExtendedInfo":
		b = &OperationJobExtendedInfo{}
	default:
		b = &OperationExtendedInfo{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalRestoreTargetInfoBaseClassification(rawMsg json.RawMessage) (RestoreTargetInfoBaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RestoreTargetInfoBaseClassification
	switch m["objectType"] {
	case "ItemLevelRestoreTargetInfo":
		b = &ItemLevelRestoreTargetInfo{}
	case "RestoreFilesTargetInfo":
		b = &RestoreFilesTargetInfo{}
	case "RestoreTargetInfo":
		b = &RestoreTargetInfo{}
	default:
		b = &RestoreTargetInfoBase{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalTriggerContextClassification(rawMsg json.RawMessage) (TriggerContextClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b TriggerContextClassification
	switch m["objectType"] {
	case "AdhocBasedTriggerContext":
		b = &AdhocBasedTriggerContext{}
	case "ScheduleBasedTriggerContext":
		b = &ScheduleBasedTriggerContext{}
	default:
		b = &TriggerContext{}
	}
	return b, json.Unmarshal(rawMsg, b)
}
