# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## Generative AI (GenAI) Settings section


## Chatbot prompts
## Prompts are plain language ‘instructions’ sent to a chatbot.
## These prompts have been made concise and direct in English because some chatbot providers
## have character restrictions and being direct reduces the chance for misinterpretation.
## When localizing, please be concise and direct, but not at the expense of losing meaning.


## Chatbot menu shortcuts

genai-menu-ask-generic =
    .label = Ssuter deg AI chatbot
# $provider (string) - name of the provider
genai-menu-ask-provider =
    .label = Ssuter { $provider }
genai-menu-remove-generic =
    .label = Kkes AI chatbot
# $provider (string) - name of the provider
genai-menu-remove-provider =
    .label = Kkes { $provider }
genai-input-ask-generic =
    .placeholder = Ssuter deg AI chatbot…
# $provider (string) - name of the provider
genai-input-ask-provider =
    .placeholder = Ssuter { $provider }…
genai-shortcuts-hide =
    .label = Ffer anegzum n chatbot

## Chatbot header

genai-chatbot-title = AI chatbot
genai-header-provider-menu =
    .title = Fren chatbot
genai-header-options-button =
    .title = Ldi umuɣ
genai-header-close-button =
    .title = Mdel
genai-provider-view-details =
    .label = Sken talqayt n chatbot
genai-options-reload-generic =
    .label = Ales asali n AI chatbot
# $provider (string) - name of the provider
genai-options-reload-provider =
    .label = Ales asali n { $provider }
genai-options-show-shortcut =
    .label = Sken anegzum deg ufran aḍris
genai-options-hide-shortcut =
    .label = Ffer anegzum deg ufran aḍris
genai-options-about-chatbot =
    .label = Ɣef AI chatbots deg { -brand-short-name }

## Chatbot onboarding

genai-onboarding-primary = Kemmel
genai-onboarding-secondary = Mdel
genai-onboarding-claude-tooltip =
    .title = Anthropic Claude
genai-onboarding-claude-learn = Issin ugar ɣef Claude
genai-onboarding-chatgpt-tooltip =
    .title = ChatGPT
genai-onboarding-chatgpt-learn = Issin ugar ɣef ChatGPT
genai-onboarding-copilot-tooltip =
    .title = Copilot
genai-onboarding-copilot-learn = Issin ugar ɣef Copilo
genai-onboarding-gemini-tooltip =
    .title = Google Gemini
genai-onboarding-gemini-learn = Issin ugar ɣef Gemini
genai-onboarding-huggingchat-tooltip =
    .title = HuggingChat
genai-onboarding-huggingchat-learn = Issin ugar vef HuggingChat
genai-onboarding-lechat-tooltip =
    .title = Le Chat Mistral
genai-onboarding-lechat-learn = Issi ugar ɣef Chat
genai-onboarding-select-header = Fren aḍris i uwali n yisumar
genai-onboarding-select-primary = Bdu ameslay
genai-chatbot-contextual-button = Fren chatbot

## Chatbot onboarding choices
## These describe features/capabilities of chatbot providers. These are not buttons/actions.

genai-onboarding-claude-generate = Sirew aḍris akked tengalt
genai-onboarding-claude-analyze = Sleḍ isemliyen d tugniwin
genai-onboarding-claude-price = Tixtiṛyin tilelliyin d tid n lexlaṣ; amiḍan yettwasra
genai-onboarding-chatgpt-generate = Sirew aḍris, tugniwin akked tengalt
genai-onboarding-chatgpt-analyze = Sleḍ isemliyen d tugniwin
genai-onboarding-chatgpt-price = Tixtiṛyin tilelliyin d tid n lexlaṣ; amiḍan yettwasra i kra n tmura akked twuriwin
genai-onboarding-copilot-generate = Sirew aḍris, tugniwin akked tengalt
genai-onboarding-copilot-analyze = Sleḍ tugniwin
genai-onboarding-copilot-price = Tixtiṛyin tilelliyin d tid n lexlaṣ; amiḍan yettwasra i kra n temsekriyin
genai-onboarding-gemini-generate = Sirew aḍris, tugniwin akked tengalt
genai-onboarding-gemini-analyze = Sleḍ tugniwin (tileliyin) akked yisemliyen (n lexlaṣ)
genai-onboarding-gemini-price = Tixtiṛyin tilelliyin d tid n lexlaṣ; amiḍan yettwasra
genai-onboarding-huggingchat-generate = Sirew aḍris akked tengalt
genai-onboarding-huggingchat-switch = Senfel gar tegrumma yemgaraden n tmudmin yeldin
genai-onboarding-lechat-generate = Sirew aḍris akked tengalt
genai-onboarding-lechat-price = D ilelli: amiḍan yettwasra

## Model Optin Component

genai-model-optin-continue =
    .label = Kemmel
genai-model-optin-optout =
    .label = Sefsex
genai-model-optin-cancel =
    .label = Sefsex

## Link previews

