/*****************************************************************************
 *  __________________    _________  _____            _____  .__         ._.
 *  \______   \______ \  /   _____/ /     \          /  _  \ |__| ____   | |
 *   |    |  _/|    |  \ \_____  \ /  \ /  \        /  /_\  \|  _/ __ \  | |
 *   |    |   \|    `   \/        /    Y    \      /    |    |  \  ___/   \|
 *   |______  /_______  /_______  \____|__  / /\   \____|__  |__|\___ |   __
 *          \/        \/        \/        \/  )/           \/        \/   \/
 *
 * This file is part of liBDSM. Copyright © 2014-2015 VideoLabs SAS
 *
 * Author: Julien 'Lta' BALLET <contact@lta.io>
 *
 * liBDSM is released under LGPLv2.1 (or later) and is also available
 * under a commercial license.
 *****************************************************************************
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

/*
 * Copyright (c) 2003-2017
 * Distributed Systems Software.  All rights reserved.
 *
 * $Id: netbios_defs.h 2958 2017-05-18 18:56:19Z brachman $
 */

#ifndef _LIBDSM_NETBIOS_DEFS_H_
#define _LIBDSM_NETBIOS_DEFS_H_

#include <stdint.h>

#include "libdsm/netbios_defs.h"
#include "libdsm_common.h"

enum {
  NETBIOS_PORT_NAME     = 137, // UDP
  NETBIOS_PORT_SESSION  = 139, // TCP
  NETBIOS_PORT_DIRECT   = 445, // TCP
  NETBIOS_PORT_DIRECT_SECONDARY = 139 // TCP
};

// http://ubiqx.org/cifs/rfc-draft/rfc1001.html#s17.2
#define NETBIOS_WILDCARD      {											\
	32,																	\
	  'C', 'K', 'A', 'A', 'A', 'A', 'A', 'A',							\
	  'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',							\
	  'A', 'A', 'A', 'A', 'A', 'A', 'A',								\
	  'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 0					\
	  }

enum {
  NETBIOS_NAME_LENGTH = 15
};

enum {
  NETBIOS_NAME_FLAG_GROUP = (1 << 15),
  NETBIOS_FLAG_QUERY      = (1 << 15),
  NETBIOS_FLAG_TRUNCATED  = (1 <<  9),
  NETBIOS_FLAG_RECURSIVE  = (1 <<  8),
  NETBIOS_FLAG_BROADCAST  = (1 <<  4)
};

// Name Service Query
enum {
  NETBIOS_OP_NAME_QUERY = 0x00
};

// Session Service
enum {
  NETBIOS_OP_SESSION_MSG        = 0x00,
  NETBIOS_OP_SESSION_REQ        = 0x81,
  NETBIOS_OP_SESSION_REQ_OK     = 0x82,
  NETBIOS_OP_SESSION_REQ_NOK    = 0x83,
  NETBIOS_OP_SESSION_RETARGET   = 0x84,
  NETBIOS_OP_SESSION_KEEPALIVE  = 0x85
};

SMB_PACKED_START typedef struct {
  uint16_t trn_id;     // Transaction ID
  uint16_t flags;      // Various flags
  uint16_t queries;    // Number of queries in this packet
  uint16_t answers;    // Number of answers
  uint16_t ns_count;   // Number of authorities (?)
  uint16_t ar_count;   // Additionnal (??)
  char payload[];
} SMB_PACKED_END netbios_query_packet;

SMB_PACKED_START typedef struct {
  uint8_t opcode;     // 'TYPE'
  uint8_t flags;      // 0-6 reserved (== 0), byte 7 is the
  // beginning of the length field (!!)
  uint16_t length;     // payload length;
  uint8_t payload[];
} SMB_PACKED_END netbios_session_packet;

#endif
