{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAutoCenterOfRotation: Boolean;
    procedure SetAutoCenterOfRotation(const Value: Boolean);
    function GetCenterOfRotation: TVector3;
    procedure SetCenterOfRotation(const Value: TVector3);
    function GetDescription: String;
    procedure SetDescription(const Value: String);
    function GetJump: Boolean;
    procedure SetJump(const Value: Boolean);
    function GetOrientation: TVector4;
    procedure SetOrientation(const Value: TVector4);
    function GetRetainUserOffsets: Boolean;
    procedure SetRetainUserOffsets(const Value: Boolean);
    function GetCameraMatrixSendAlsoOnOffscreenRendering: Boolean;
    procedure SetCameraMatrixSendAlsoOnOffscreenRendering(const Value: Boolean);
    function GetGravityUp: TVector3;
    procedure SetGravityUp(const Value: TVector3);
    function GetGravityTransform: Boolean;
    procedure SetGravityTransform(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAutoCenterOfRotation: TSFBool;
    { Internal wrapper for property @code(AutoCenterOfRotation). This wrapper API may change, we advise to access simpler @code(AutoCenterOfRotation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAutoCenterOfRotation: TSFBool read FFdAutoCenterOfRotation;
    { When @true, the center of rotation is automatically calculated looking at the middle of scene bounding box. The @link(CenterOfRotation) value is ignored then.

      This field is a Castle Game Engine extension of the X3D standard. The default value (@false) makes behavior compatible with X3D standard. Note that, in contrast, @link(TCastleExamineNavigation.AutoCenterOfRotation) default is @true -- because TCastleExamineNavigation doesn't have to match X3D standard, and the default @true makes it work out-of-the-box on more scenes. }
    property AutoCenterOfRotation: Boolean read GetAutoCenterOfRotation write SetAutoCenterOfRotation;

    strict private FFdCenterOfRotation: TSFVec3f;
    { Internal wrapper for property @code(CenterOfRotation). This wrapper API may change, we advise to access simpler @code(CenterOfRotation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCenterOfRotation: TSFVec3f read FFdCenterOfRotation;
    {  }
    property CenterOfRotation: TVector3 read GetCenterOfRotation write SetCenterOfRotation;

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @code(Description). This wrapper API may change, we advise to access simpler @code(Description) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FFdJump: TSFBool;
    { Internal wrapper for property @code(Jump). This wrapper API may change, we advise to access simpler @code(Jump) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdJump: TSFBool read FFdJump;
    {  }
    property Jump: Boolean read GetJump write SetJump;

    strict private FFdOrientation: TSFRotation;
    { Internal wrapper for property @code(Orientation). This wrapper API may change, we advise to access simpler @code(Orientation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdOrientation: TSFRotation read FFdOrientation;
    { Orientation of the viewpoint, expressed as rotation to transform default direction and up (DefaultX3DCameraDirection, DefaultX3DCameraUp). }
    property Orientation: TVector4 read GetOrientation write SetOrientation;

    strict private FFdRetainUserOffsets: TSFBool;
    { Internal wrapper for property @code(RetainUserOffsets). This wrapper API may change, we advise to access simpler @code(RetainUserOffsets) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRetainUserOffsets: TSFBool read FFdRetainUserOffsets;
    {  }
    property RetainUserOffsets: Boolean read GetRetainUserOffsets write SetRetainUserOffsets;

    strict private FEventCameraMatrix: TSFMatrix4fEvent;
    {  }
    public property EventCameraMatrix: TSFMatrix4fEvent read FEventCameraMatrix;

    strict private FEventCameraInverseMatrix: TSFMatrix4fEvent;
    {  }
    public property EventCameraInverseMatrix: TSFMatrix4fEvent read FEventCameraInverseMatrix;

    strict private FEventCameraRotationMatrix: TSFMatrix3fEvent;
    {  }
    public property EventCameraRotationMatrix: TSFMatrix3fEvent read FEventCameraRotationMatrix;

    strict private FEventCameraRotationInverseMatrix: TSFMatrix3fEvent;
    {  }
    public property EventCameraRotationInverseMatrix: TSFMatrix3fEvent read FEventCameraRotationInverseMatrix;

    strict private FFdCameraMatrixSendAlsoOnOffscreenRendering: TSFBool;
    { Internal wrapper for property @code(CameraMatrixSendAlsoOnOffscreenRendering). This wrapper API may change, we advise to access simpler @code(CameraMatrixSendAlsoOnOffscreenRendering) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCameraMatrixSendAlsoOnOffscreenRendering: TSFBool read FFdCameraMatrixSendAlsoOnOffscreenRendering;
    {  }
    property CameraMatrixSendAlsoOnOffscreenRendering: Boolean read GetCameraMatrixSendAlsoOnOffscreenRendering write SetCameraMatrixSendAlsoOnOffscreenRendering;

    strict private FFdDirection: TMFVec3f;
    { Internal wrapper for property @code(Direction). This wrapper API may change, we advise to access simpler @code(Direction) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDirection: TMFVec3f read FFdDirection;

    strict private FFdUp: TMFVec3f;
    { Internal wrapper for property @code(Up). This wrapper API may change, we advise to access simpler @code(Up) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUp: TMFVec3f read FFdUp;

    strict private FFdGravityUp: TSFVec3f;
    { Internal wrapper for property @code(GravityUp). This wrapper API may change, we advise to access simpler @code(GravityUp) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGravityUp: TSFVec3f read FFdGravityUp;
    { Specify the gravity vector explicitly. See https://castle-engine.io/x3d_implementation_navigation_extensions.php . @deprecated }
    property GravityUp: TVector3 read GetGravityUp write SetGravityUp;

    strict private FFdGravityTransform: TSFBool;
    { Internal wrapper for property @code(GravityTransform). This wrapper API may change, we advise to access simpler @code(GravityTransform) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGravityTransform: TSFBool read FFdGravityTransform;
    { Should the gravity vector be affected by the viewpoint transformation, that is by the @link(TTransformNode) instances that contain this TAbstractViewpointNode. }
    property GravityTransform: Boolean read GetGravityTransform write SetGravityTransform;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractViewpointNode ----------------------------------------------- }

function TAbstractViewpointNode.GetAutoCenterOfRotation: Boolean;
begin
  Result := FdAutoCenterOfRotation.Value;
end;

procedure TAbstractViewpointNode.SetAutoCenterOfRotation(const Value: Boolean);
begin
  FdAutoCenterOfRotation.Send(Value);
end;

function TAbstractViewpointNode.GetCenterOfRotation: TVector3;
begin
  Result := FdCenterOfRotation.Value;
end;

procedure TAbstractViewpointNode.SetCenterOfRotation(const Value: TVector3);
begin
  FdCenterOfRotation.Send(Value);
end;

function TAbstractViewpointNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure TAbstractViewpointNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

function TAbstractViewpointNode.GetJump: Boolean;
begin
  Result := FdJump.Value;
end;

procedure TAbstractViewpointNode.SetJump(const Value: Boolean);
begin
  FdJump.Send(Value);
end;

function TAbstractViewpointNode.GetOrientation: TVector4;
begin
  Result := FdOrientation.Value;
end;

procedure TAbstractViewpointNode.SetOrientation(const Value: TVector4);
begin
  FdOrientation.Send(Value);
end;

function TAbstractViewpointNode.GetRetainUserOffsets: Boolean;
begin
  Result := FdRetainUserOffsets.Value;
end;

procedure TAbstractViewpointNode.SetRetainUserOffsets(const Value: Boolean);
begin
  FdRetainUserOffsets.Send(Value);
end;

function TAbstractViewpointNode.GetCameraMatrixSendAlsoOnOffscreenRendering: Boolean;
begin
  Result := FdCameraMatrixSendAlsoOnOffscreenRendering.Value;
end;

procedure TAbstractViewpointNode.SetCameraMatrixSendAlsoOnOffscreenRendering(const Value: Boolean);
begin
  FdCameraMatrixSendAlsoOnOffscreenRendering.Send(Value);
end;

function TAbstractViewpointNode.GetGravityUp: TVector3;
begin
  Result := FdGravityUp.Value;
end;

procedure TAbstractViewpointNode.SetGravityUp(const Value: TVector3);
begin
  FdGravityUp.Send(Value);
end;

function TAbstractViewpointNode.GetGravityTransform: Boolean;
begin
  Result := FdGravityTransform.Value;
end;

procedure TAbstractViewpointNode.SetGravityTransform(const Value: Boolean);
begin
  FdGravityTransform.Send(Value);
end;

class function TAbstractViewpointNode.ClassX3DType: String;
begin
  Result := 'X3DViewpointNode';
end;

procedure TAbstractViewpointNode.CreateNode;
begin
  inherited;

  FFdAutoCenterOfRotation := TSFBool.Create(Self, True, 'autoCenterOfRotation', false);
   FdAutoCenterOfRotation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAutoCenterOfRotation);

  FFdCenterOfRotation := TSFVec3f.Create(Self, True, 'centerOfRotation', Vector3(0, 0, 0));
   FdCenterOfRotation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCenterOfRotation);

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chNone;
  AddField(FFdDescription);

  FFdJump := TSFBool.Create(Self, True, 'jump', true);
   FdJump.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdJump);

  FFdOrientation := TSFRotation.Create(Self, True, 'orientation', Vector3(0, 0, 1), 0);
   FdOrientation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdOrientation);

  FFdRetainUserOffsets := TSFBool.Create(Self, True, 'retainUserOffsets', false);
   FdRetainUserOffsets.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRetainUserOffsets);

  FEventCameraMatrix := TSFMatrix4fEvent.Create(Self, 'cameraMatrix', false);
  AddEvent(FEventCameraMatrix);

  FEventCameraInverseMatrix := TSFMatrix4fEvent.Create(Self, 'cameraInverseMatrix', false);
  AddEvent(FEventCameraInverseMatrix);

  FEventCameraRotationMatrix := TSFMatrix3fEvent.Create(Self, 'cameraRotationMatrix', false);
  AddEvent(FEventCameraRotationMatrix);

  FEventCameraRotationInverseMatrix := TSFMatrix3fEvent.Create(Self, 'cameraRotationInverseMatrix', false);
  AddEvent(FEventCameraRotationInverseMatrix);

  FFdCameraMatrixSendAlsoOnOffscreenRendering := TSFBool.Create(Self, True, 'cameraMatrixSendAlsoOnOffscreenRendering', false);
   FdCameraMatrixSendAlsoOnOffscreenRendering.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCameraMatrixSendAlsoOnOffscreenRendering);

  FFdDirection := TMFVec3f.Create(Self, True, 'direction', []);
   FdDirection.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDirection);

  FFdUp := TMFVec3f.Create(Self, True, 'up', []);
   FdUp.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUp);

  FFdGravityUp := TSFVec3f.Create(Self, True, 'gravityUp', Vector3(0, 1, 0));
   FdGravityUp.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGravityUp);

  FFdGravityTransform := TSFBool.Create(Self, True, 'gravityTransform', true);
   FdGravityTransform.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGravityTransform);
end;

{$endif read_implementation}
