#ifndef PLATFORMDIALOG_H
#define PLATFORMDIALOG_H

#ifdef AVRDUDE_CONF
#include "avrdude.h"
#include "programmer.h"
#include "part.h"
#else
#include "dude.h"
#endif

//(*Headers(PlatformDialog)
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/dialog.h>
#include <wx/combobox.h>
//*)

class xhex;

class PlatformDialog: public wxDialog
{
	public:

		PlatformDialog(wxWindow* parent,wxWindowID id=wxID_ANY);
		virtual ~PlatformDialog();

		//(*Declarations(PlatformDialog)
		wxStaticText* StaticTextBitclock;
		wxComboBox* ComboBoxPlatform;
		wxStaticText* StaticTextProgrammer;
		wxComboBox* ComboBoxProgrammer;
		wxComboBox* ComboBoxBitclock;
		wxComboBox* ComboBoxBaudrate;
		wxComboBox* ComboBoxMCU;
		wxStaticText* StaticTextInterface;
		wxStaticText* StaticTextBaudrate;
		wxComboBox* ComboBoxInterface;
		wxStdDialogButtonSizer* StdDialogButtonSizer1;
		//*)

        void applyXhex(xhex * xhexfile);

        wxString getHTML();
        void setProgrammers(const std::vector<ProgrammerInfo> & pgi);
        void setParts(const std::vector<PartInfo> & pai);

        virtual int ShowModal (); // override
        virtual void EndModal (int retCode); // override

        void initPlatform();


        wxString getPlatform() {return m_platform;}
        wxString getMCU() {return m_mcu;}
        wxString getBitclock() {return m_bitclock;}
        wxString getProgrammer() {return m_programmer;}
        wxString getInterface() {return m_interface;}
        wxString getBaudrate() {return m_baudrate;}

        wxArrayString getUSBComPorts(const wxString & vid, const wxString & pid);

        void updateSerialPort(bool change);

	protected:

		//(*Identifiers(PlatformDialog)
		static const long ID_COMBOBOX_PLATFORM;
		static const long ID_COMBOBOX_MCU;
		static const long ID_COMBOBOX_BITCLOCK;
		static const long ID_COMBOBOX_PROGRAMMER;
		static const long ID_COMBOBOX_INTERFACE;
		static const long ID_COMBOBOX_BAUDRATE;
		//*)

	private:
	    bool m_isXhex;
      wxString m_xhex_platform;
      wxString m_xhex_mcu;
      wxString m_xhex_bitclock;
      wxString m_xhex_programmer;
      wxString m_xhex_interface;
      wxString m_xhex_baudrate;

      wxString m_platform;
      wxString m_mcu;
      wxString m_bitclock;
      wxString m_programmer;
      wxString m_interface;
      wxString m_baudrate;

		//(*Handlers(PlatformDialog)
		void OnComboBoxPlatformSelected(wxCommandEvent& event);
		void OnComboBoxProgrammerSelected(wxCommandEvent& event);
		//*)
      void OnReset(wxCommandEvent& event);
      void loadPlatform();
      void savePlatform();

      void initGui();


		DECLARE_EVENT_TABLE()
};

#endif
