#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Lilly Looking Through
# send your bug reports to contact@dotslashplay.it
###

script_version=20250228.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='lilly-looking-through'
GAME_NAME='Lilly Looking Through'

ARCHIVE_BASE_0_NAME='setup_lilly_looking_through_1.1.50_(21178).exe'
ARCHIVE_BASE_0_MD5='a3318d6a5a5abfe946293c9e745f1fd9'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='400000'
ARCHIVE_BASE_0_VERSION='1.1.50-gog21178'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/lilly_looking_through'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
adobe air
lillylookingthrough.exe
lilly.swf'
CONTENT_GAME_DATA_FILES='
meta-inf
mimetype
pkmedia'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/com.geetagames.LillyLookingThrough'

APP_MAIN_EXE='lillylookingthrough.exe'
APP_MAIN_ICON='app/goggame-1207659903.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# icotool is used for icon .ico → .png conversion

REQUIREMENTS_LIST="${REQUIREMENTS_LIST:-}
icotool"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

## Work around "insufficient image data" error with convert from imagemagick
## TODO: Check if it is still required with current builds of imagemagick
icon_extract_png_from_ico() {
	local icon destination
	icon="$1"
	destination="$2"

	local icon_file
	icon_file=$(icon_full_path "$icon")
	icotool --extract --output="$destination" "$icon_file"
}
content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
