/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.core.FileUtils;
import org.stathissideris.ascii2image.core.HTMLConverter;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class CommandLineConverter {
    private static String notice = "ditaa version 0.9, Copyright (C) 2004--2009  Efstathios (Stathis) Sideris";
    private static String[] markupModeAllowedValues = new String[]{"use", "ignore", "render"};

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        Object object;
        Object object3;
        long l = System.currentTimeMillis();
        System.out.println("\n" + notice + "\n");
        Options options = new Options();
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Prints usage help.");
        options.addOption(OptionBuilder.create());
        options.addOption("v", "verbose", false, "Makes ditaa more verbose.");
        options.addOption("o", "overwrite", false, "If the filename of the destination image already exists, an alternative name is chosen. If the overwrite option is selected, the image file is instead overwriten.");
        options.addOption("S", "no-shadows", false, "Turns off the drop-shadow effect.");
        options.addOption("A", "no-antialias", false, "Turns anti-aliasing off.");
        options.addOption("d", "debug", false, "Renders the debug grid over the resulting image.");
        options.addOption("r", "round-corners", false, "Causes all corners to be rendered as round corners.");
        options.addOption("E", "no-separation", false, "Prevents the separation of common edges of shapes.");
        options.addOption("h", "html", false, "In this case the input is an HTML file. The contents of the <pre class=\"textdiagram\"> tags are rendered as diagrams and saved in the images directory and a new HTML file is produced with the appropriate <img> tags.");
        OptionBuilder.withLongOpt("encoding");
        OptionBuilder.withDescription("The encoding of the input file.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("ENCODING");
        options.addOption(OptionBuilder.create('e'));
        OptionBuilder.withLongOpt("scale");
        OptionBuilder.withDescription("A natural number that determines the size of the rendered image. The units are fractions of the default size (2.5 renders 1.5 times bigger than the default).");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("SCALE");
        options.addOption(OptionBuilder.create('s'));
        OptionBuilder.withLongOpt("tabs");
        OptionBuilder.withDescription("Tabs are normally interpreted as 8 spaces but it is possible to change that using this option. It is not advisable to use tabs in your diagrams.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("TABS");
        options.addOption(OptionBuilder.create('t'));
        CommandLine commandLine = null;
        try {
            object3 = new PosixParser();
            commandLine = object3.parse(options, stringArray);
            if (commandLine.hasOption("block-size")) {
                System.out.println(commandLine.getOptionValue("block-size"));
            }
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
            new HelpFormatter().printHelp("java -jar ditaa.jar <inpfile> [outfile]", options, true);
            System.exit(2);
        }
        if (commandLine.hasOption("help") || stringArray.length == 0) {
            new HelpFormatter().printHelp("java -jar ditaa.jar <inpfile> [outfile]", options, true);
            System.exit(0);
        }
        object3 = null;
        try {
            object3 = new ConversionOptions(commandLine);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Error: " + unsupportedEncodingException.getMessage());
            System.exit(2);
        }
        stringArray = commandLine.getArgs();
        if (stringArray.length == 0) {
            System.err.println("Error: Please provide the input file filename");
            new HelpFormatter().printHelp("java -jar ditaa.jar <inpfile> [outfile]", options, true);
            System.exit(2);
        }
        System.out.println("Running with options:");
        Option[] optionArray = commandLine.getOptions();
        for (Option object22 : optionArray) {
            if (object22.hasArgs()) {
                for (String string : object22.getValues()) {
                    System.out.println(object22.getLongOpt() + " = " + string);
                }
                continue;
            }
            if (object22.hasArg()) {
                System.out.println(object22.getLongOpt() + " = " + object22.getValue());
                continue;
            }
            System.out.println(object22.getLongOpt());
        }
        if (commandLine.hasOption("html")) {
            object = stringArray[0];
            int n = 0;
            if (((ConversionOptions)object3).processingOptions.overwriteFiles()) {
                n = 1;
            }
            String string = stringArray.length == 1 ? FileUtils.makeTargetPathname((String)object, "html", "_processed", true) : stringArray[1];
            File file = new File(string);
            if (n == 0 && file.exists()) {
                System.out.println("Error: File " + string + " exists. If you would like to overwrite it, please use the --overwrite option.");
                System.exit(0);
            }
            new HTMLConverter().convertHTMLFile((String)object, string, "ditaa_diagram", "images", (ConversionOptions)object3);
            System.exit(0);
        } else {
            void var10_21;
            object = new TextGrid();
            if (((ConversionOptions)object3).processingOptions.getCustomShapes() != null) {
                ((TextGrid)object).addToMarkupTags(((ConversionOptions)object3).processingOptions.getCustomShapes().keySet());
            }
            String string = stringArray[0];
            System.out.println("Reading file: " + string);
            try {
                if (!((TextGrid)object).loadFrom(string, ((ConversionOptions)object3).processingOptions)) {
                    System.err.println("Cannot open file " + string + " for reading");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("Error: " + unsupportedEncodingException.getMessage());
                System.exit(1);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Error: File " + string + " does not exist");
                System.exit(1);
            }
            catch (IOException iOException) {
                System.err.println("Error: Cannot open file " + string + " for reading");
                System.exit(1);
            }
            if (((ConversionOptions)object3).processingOptions.printDebugOutput()) {
                System.out.println("Using grid:");
                ((TextGrid)object).printDebug();
            }
            boolean bl = false;
            if (((ConversionOptions)object3).processingOptions.overwriteFiles()) {
                bl = true;
            }
            if (stringArray.length == 1) {
                String string2 = FileUtils.makeTargetPathname(string, "png", bl);
            } else {
                String string3 = stringArray[1];
            }
            Diagram diagram = new Diagram((TextGrid)object, (ConversionOptions)object3);
            System.out.println("Rendering to file: " + (String)var10_21);
            RenderedImage renderedImage = new BitmapRenderer().renderToImage(diagram, ((ConversionOptions)object3).renderingOptions);
            try {
                File file = new File((String)var10_21);
                ImageIO.write(renderedImage, "png", file);
            }
            catch (IOException iOException) {
                System.err.println("Error: Cannot write to file " + string);
                System.exit(1);
            }
            long l2 = System.currentTimeMillis();
            long l3 = (l2 - l) / 1000L;
            System.out.println("Done in " + l3 + "sec");
        }
    }
}

