/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.feature.map;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureException;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.function.FeatureMapFunction;
import org.maltparser.core.feature.value.FeatureValue;
import org.maltparser.core.feature.value.SingleFeatureValue;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.SymbolTableHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeFeature
implements FeatureMapFunction {
    protected FeatureFunction firstFeature;
    protected FeatureFunction secondFeature;
    protected SymbolTableHandler tableHandler;
    protected SymbolTable table;
    protected SingleFeatureValue singleFeatureValue;

    public MergeFeature(SymbolTableHandler tableHandler) throws MaltChainedException {
        this.setTableHandler(tableHandler);
        this.singleFeatureValue = new SingleFeatureValue(this);
    }

    @Override
    public void initialize(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 2) {
            throw new FeatureException("Could not initialize MergeFeature: number of arguments are not correct. ");
        }
        if (!(arguments[0] instanceof FeatureFunction)) {
            throw new FeatureException("Could not initialize MergeFeature: the first argument is not a feature. ");
        }
        if (!(arguments[1] instanceof FeatureFunction)) {
            throw new FeatureException("Could not initialize MergeFeature: the second argument is not a feature. ");
        }
        this.setFirstFeature((FeatureFunction)arguments[0]);
        this.setSecondFeature((FeatureFunction)arguments[1]);
        this.setSymbolTable(this.tableHandler.addSymbolTable("MERGE2_" + this.firstFeature.getSymbolTable().getName() + "_" + this.secondFeature.getSymbolTable().getName(), this.firstFeature.getSymbolTable()));
    }

    @Override
    public void update() throws MaltChainedException {
        this.singleFeatureValue.reset();
        this.firstFeature.update();
        this.secondFeature.update();
        FeatureValue firstValue = this.firstFeature.getFeatureValue();
        FeatureValue secondValue = this.secondFeature.getFeatureValue();
        if (firstValue instanceof SingleFeatureValue && secondValue instanceof SingleFeatureValue) {
            String symbol = ((SingleFeatureValue)firstValue).getSymbol();
            if (firstValue.isNullValue() && secondValue.isNullValue()) {
                this.singleFeatureValue.setCode(this.firstFeature.getSymbolTable().getSymbolStringToCode(symbol));
                this.singleFeatureValue.setKnown(this.firstFeature.getSymbolTable().getKnown(symbol));
                this.singleFeatureValue.setSymbol(symbol);
                this.singleFeatureValue.setNullValue(true);
            } else {
                StringBuilder mergedValue = new StringBuilder();
                mergedValue.append(((SingleFeatureValue)firstValue).getSymbol());
                mergedValue.append('~');
                mergedValue.append(((SingleFeatureValue)secondValue).getSymbol());
                this.singleFeatureValue.setCode(this.table.addSymbol(mergedValue.toString()));
                this.singleFeatureValue.setKnown(this.table.getKnown(mergedValue.toString()));
                this.singleFeatureValue.setSymbol(mergedValue.toString());
                this.singleFeatureValue.setNullValue(false);
            }
        } else {
            throw new FeatureException("It is not possible to merge Split-features. ");
        }
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class[] paramTypes = new Class[]{FeatureFunction.class, FeatureFunction.class};
        return paramTypes;
    }

    @Override
    public FeatureValue getFeatureValue() {
        return this.singleFeatureValue;
    }

    @Override
    public String getSymbol(int code) throws MaltChainedException {
        return this.table.getSymbolCodeToString(code);
    }

    @Override
    public int getCode(String symbol) throws MaltChainedException {
        return this.table.getSymbolStringToCode(symbol);
    }

    @Override
    public void updateCardinality() throws MaltChainedException {
        this.firstFeature.updateCardinality();
        this.secondFeature.updateCardinality();
        this.singleFeatureValue.setCardinality(this.table.getValueCounter());
    }

    public FeatureFunction getFirstFeature() {
        return this.firstFeature;
    }

    public void setFirstFeature(FeatureFunction firstFeature) {
        this.firstFeature = firstFeature;
    }

    public FeatureFunction getSecondFeature() {
        return this.secondFeature;
    }

    public void setSecondFeature(FeatureFunction secondFeature) {
        this.secondFeature = secondFeature;
    }

    public SymbolTableHandler getTableHandler() {
        return this.tableHandler;
    }

    public void setTableHandler(SymbolTableHandler tableHandler) {
        this.tableHandler = tableHandler;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.table;
    }

    public void setSymbolTable(SymbolTable table) {
        this.table = table;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Merge(");
        sb.append(this.firstFeature.toString());
        sb.append(", ");
        sb.append(this.secondFeature.toString());
        sb.append(')');
        return sb.toString();
    }
}

