use strict;
use Test::More tests => 3;

BEGIN {
	use_ok( 'GSM::SMS::OTA::Operatorlogo' );
}

my $correct = "02F61000480E0107800000000001F0001FE00000000007FC003FF0000000000FFE007FF8000000000CCE007FC0000000000D5600FF00000000000EEE00FC06318C6318CFFE63FC06318C6318CFFE63FF00000000000FFE007FC0000000000EAE007FF8000000000D56003FF0000000000FFE001FE0000000000CE600078000000000084200";

my $correct_inv = "02F61000480E01F87FFFFFFFFFFE0FFFE01FFFFFFFFFF803FFC00FFFFFFFFFF001FF8007FFFFFFFFF331FF803FFFFFFFFFF2A9FF00FFFFFFFFFFF111FF03F9CE739CE730019C03F9CE739CE730019C00FFFFFFFFFFF001FF803FFFFFFFFFF151FF8007FFFFFFFFF2A9FFC00FFFFFFFFFF001FFE01FFFFFFFFFF319FFF87FFFFFFFFFF7BDFF";

my $b64image = <<EOT;
R0lGODlhSAAOAIAAAP///wAAACwAAAAASAAOAEACZ4QdGcftDyNTSSKqrN4Qe+ll3KhVywlU
VriQ7qOKasTO713bzefMfpsC/g7DYO1CPOWAN5cpBdXBQs2qkUdbWp2tmDSJ3b4y5O+FMk2q
kezg2n2lwt1HMRelZE5Z9pF2g9ZHwkQYUQAAOw==
EOT

my $stream = GSM::SMS::OTA::Operatorlogo::OTAOperatorlogo_fromfile( 206, 01, "t/test_72x14.gif" );

ok( $stream eq $correct || $stream eq $correct_inv, "Compare 'fromfile' to test stream" );

$stream = GSM::SMS::OTA::Operatorlogo::OTAOperatorlogo_fromb64( 206, 01, $b64image, 'gif' );

ok( $stream eq $correct || $stream eq $correct_inv, "Compare 'fromb64' to test stream" );
