# Tomtit

Tomtit - Perl6 "Makefile" tool based on [Sparrowdo](https://github.com/melezhik/sparrowdo) plugins.

![tomtit example output](https://raw.githubusercontent.com/melezhik/tomtit/master/tomtit-output.png)

# INSTALL

    zef install Tomtit

# Bootstrap

You need to bootstrap your system to start using tomtit, it's a one time operation,
where you install Sparrow which is underlying tomtit runner.
    
    tom --bootstrap 

# USAGE

    tom $action|$options $scenario

Run scenario:

    tom $scenario

Get help:

    tom

List availbale scenarios:

    tom --list

Show the last executed scenario:

    tom --last

Clean tomtit cache:

    tom --clean

Example:

    tom --list

    [scenarios list]
    test
    build
    install

    tom test        

# Defining scenarios

Tomtit scenarios are just Sparrowdo scenarios you create in `.tom` directory:
  
    mkdir .tom/
    nano .tom/build.pl6
    nano .tom/test.pl6
    nano .tom/install.pl6

You want to ignore tomtit cache which commit files to SCM:

    git add .tom/
    echo .tom/.cache >> .gitignore

# Scenario example

You can do anything, allowable through [Sparrowdo API](https://github.com/melezhik/sparrowdo), like:

    cat .tom/example.pl6

    # you can Sparrowdo shortcuts 
    # to create files and directories

    file 'passwords.txt', %( content => "super secret" );

    directory '.cache';

    # or restart service

    service-restart "web-app";

    # or you can run a certain sparrow plugin
    # by using task-run function:

    task-run 'my task', 'plugin', %( foo => 'bar' );

    # for example, to set git repository, 
    # use git-base plugin:
 
    task-run "set git", "git-base", %(
      email => 'melezhik@gmail.com',
      name  => 'Alexey Melezhik',
      config_scope => 'local',
      set_credential_cache => 'on'
    );

    
And so on.

As result you minimize code to execute many typical tasks.

# Options

    --verbose   # run scenario in verbose mode
    --quiet,-q  # run scenario in less verbose mode

# Author

Alexey Melezhik


# Thanks to

God Who gives me inspiration in my work

