#---------------------------------------------------------------------
# Support for Astro::MoonPhase tests
#---------------------------------------------------------------------
# Convert a Unix time to a string:

sub asDate
{
  my @d = gmtime($_[0]);

  sprintf("%4d-%02d-%02d %02d:%02d:%02d UTC",
          $d[5] + 1900, $d[4] + 1, @d[3,2,1,0]);
} # end asDate

#---------------------------------------------------------------------
# This table of moon phases was taken from
# http://aa.usno.navy.mil/data/docs/MoonPhase.html
#
# All times are UTC.
#
# The phase of the moon is given by the index mod 4:
#  0 = new, 1 = first, 2 = full, 3 = last

@navyPhases = (
  0x00090a74, # Jan  7 1970 20:35
  0x0011de88, # Jan 14 1970 13:18
  0x001c6524, # Jan 22 1970 12:55
  0x00270984, # Jan 30 1970 14:39
  0x002fdb7c, # Feb  6 1970 07:13
  0x0038eb18, # Feb 13 1970 04:10
  0x0043b174, # Feb 21 1970 08:19
  0x004dec5c, # Mar  1 1970 02:33
  0x0056aa68, # Mar  7 1970 17:42
  0x00601710, # Mar 14 1970 21:16
  0x006ae3c0, # Mar 23 1970 01:52
  0x00749fdc, # Mar 30 1970 11:05
  0x007d78dc, # Apr  6 1970 04:09
  0x00875640, # Apr 13 1970 15:44
  0x0091eaec, # Apr 21 1970 16:21
  0x009b32c8, # Apr 28 1970 17:18
  0x00a44ad4, # May  5 1970 14:51
  0x00ae98b8, # May 13 1970 10:26
  0x00b8c518, # May 21 1970 03:38
  0x00c1b7e0, # May 27 1970 22:32
  0x00cb280c, # Jun  4 1970 02:21
  0x00d5cca8, # Jun 12 1970 04:06
  0x00df7c94, # Jun 19 1970 12:27
  0x00e8407c, # Jun 26 1970 04:01
  0x00f219a8, # Jul  3 1970 15:18
  0x00fce3c4, # Jul 11 1970 19:43
  0x010621c8, # Jul 18 1970 19:58
  0x010ede30, # Jul 25 1970 11:00
  0x01192368, # Aug  2 1970 05:58
  0x0123d7b8, # Aug 10 1970 08:50
  0x012cc3b4, # Aug 17 1970 03:15
  0x0135a038, # Aug 23 1970 20:34
  0x0140409c, # Aug 31 1970 22:01
  0x014aab18, # Sep  8 1970 19:38
  0x01536e4c, # Sep 15 1970 11:09
  0x015c9468, # Sep 22 1970 09:42
  0x01676424, # Sep 30 1970 14:31
  0x01716654, # Oct  8 1970 04:43
  0x017a2b2c, # Oct 14 1970 20:21
  0x0183c024, # Oct 22 1970 02:47
  0x018e7ff0, # Oct 30 1970 06:28
  0x01981344, # Nov  6 1970 12:47
  0x01a10300, # Nov 13 1970 07:28
  0x01ab1afc, # Nov 20 1970 23:13
  0x01b58b18, # Nov 28 1970 21:14
  0x01bebcb0, # Dec  5 1970 20:36
  0x01c7fd84, # Dec 12 1970 21:03
  0x01d28aec, # Dec 20 1970 21:09
  0x01dc8434, # Dec 28 1970 10:43
  0x01e56d24, # Jan  4 1971 04:55
  0x01ef1e00, # Jan 11 1971 13:20
  0x01f9ed80, # Jan 19 1971 18:08
  0x02036b44, # Jan 26 1971 22:55
  0x020c2fa4, # Feb  2 1971 14:31
  0x02165b8c, # Feb 10 1971 07:41
  0x02212788, # Feb 18 1971 12:14
  0x022a400c, # Feb 25 1971 09:49
  0x02330cdc, # Mar  4 1971 02:01
  0x023da098, # Mar 12 1971 02:34
  0x02482be4, # Mar 20 1971 02:31
  0x02510214, # Mar 26 1971 19:23
  0x025a09b8, # Apr  2 1971 15:46
  0x0264d398, # Apr 10 1971 20:10
  0x026efa58, # Apr 18 1971 12:58
  0x0277b738, # Apr 25 1971 04:02
  0x02812368, # May  2 1971 07:34
  0x028be550, # May 10 1971 11:24
  0x02959c44, # May 17 1971 20:15
  0x029e6a40, # May 24 1971 12:32
  0x02a84fd8, # Jun  1 1971 00:42
  0x02b2d2f0, # Jun  9 1971 00:04
  0x02bc2030, # Jun 16 1971 01:24
  0x02c52a2c, # Jun 22 1971 21:57
  0x02cf8134, # Jun 30 1971 18:11
  0x02d9a2cc, # Jul  8 1971 10:37
  0x02e29954, # Jul 15 1971 05:47
  0x02ec0494, # Jul 22 1971 09:15
  0x02f6aad4, # Jul 30 1971 11:07
  0x03005e08, # Aug  6 1971 19:42
  0x03091d04, # Aug 13 1971 10:55
  0x0312ffcc, # Aug 20 1971 22:53
  0x031dc4c0, # Aug 29 1971 02:56
  0x03270eb8, # Sep  5 1971 04:02
  0x032fc184, # Sep 11 1971 18:23
  0x033a19b8, # Sep 19 1971 14:42
  0x0344ca0c, # Sep 27 1971 17:17
  0x034dbeb4, # Oct  4 1971 12:19
  0x0356991c, # Oct 11 1971 05:29
  0x03614844, # Oct 19 1971 07:59
  0x036bb6f8, # Oct 27 1971 05:54
  0x037478c4, # Nov  2 1971 21:19
  0x037dacb4, # Nov  9 1971 20:51
  0x03887dd8, # Nov 18 1971 01:46
  0x0392892c, # Nov 25 1971 16:37
  0x039b47b0, # Dec  2 1971 07:48
  0x03a4f5f8, # Dec  9 1971 16:02
  0x03afac64, # Dec 17 1971 19:03
  0x03b942c4, # Dec 25 1971 01:35
  0x03c23370, # Dec 31 1971 20:20
  0x03cc5f94, # Jan  8 1972 13:31
  0x03d6c650, # Jan 16 1972 10:52
  0x03dfed5c, # Jan 23 1972 09:29
  0x03e93cb8, # Jan 30 1972 10:58
  0x03f3cc00, # Feb  7 1972 11:12
  0x03fdc14c, # Feb 15 1972 00:29
  0x04069740, # Feb 21 1972 17:20
  0x04105c80, # Feb 29 1972 03:12
  0x041b1f1c, # Mar  8 1972 07:05
  0x042498e4, # Mar 15 1972 11:35
  0x042d4f70, # Mar 22 1972 02:12
  0x0437856c, # Mar 29 1972 20:05
  0x044244c0, # Apr  6 1972 23:44
  0x044b5204, # Apr 13 1972 20:31
  0x04541f4c, # Apr 20 1972 12:45
  0x045eab10, # Apr 28 1972 12:44
  0x046932d8, # May  6 1972 12:26
  0x0471f8a0, # May 13 1972 04:08
  0x047b0ad0, # May 20 1972 01:16
  0x0485c3d0, # May 28 1972 04:28
  0x048febf8, # Jun  4 1972 21:22
  0x04989bb8, # Jun 11 1972 11:30
  0x04a2110c, # Jun 18 1972 15:41
  0x04acc868, # Jun 26 1972 18:46
  0x04b67c8c, # Jul  4 1972 03:25
  0x04bf49d4, # Jul 10 1972 19:39
  0x04c92eb8, # Jul 18 1972 07:46
  0x04d3b590, # Jul 26 1972 07:24
  0x04dcf8f8, # Aug  2 1972 08:02
  0x04e60ee8, # Aug  9 1972 05:26
  0x04f05eac, # Aug 17 1972 01:09
  0x04fa8b48, # Aug 24 1972 18:22
  0x05037780, # Aug 31 1972 12:48
  0x050cf3a0, # Sep  7 1972 17:28
  0x0517983c, # Sep 15 1972 19:13
  0x05214fe4, # Sep 23 1972 04:07
  0x052a0df0, # Sep 29 1972 19:16
  0x0533fd60, # Oct  7 1972 08:08
  0x053ecca4, # Oct 15 1972 12:55
  0x05480e2c, # Oct 22 1972 13:25
  0x0550cddc, # Oct 29 1972 04:41
  0x055b2afc, # Nov  6 1972 01:21
  0x0565ea8c, # Nov 14 1972 05:01
  0x056ed214, # Nov 20 1972 23:07
  0x0577c11c, # Nov 27 1972 17:45
  0x05827260, # Dec  5 1972 20:24
  0x058ce510, # Dec 13 1972 18:36
  0x0595a31c, # Dec 20 1972 09:45
  0x059ee774, # Dec 27 1972 10:27
  0x05a9bd48, # Jan  4 1973 15:42
  0x05b3b924, # Jan 12 1973 05:27
  0x05bc8360, # Jan 18 1973 21:28
  0x05c6370c, # Jan 26 1973 06:05
  0x05d0f174, # Feb  3 1973 09:23
  0x05da6e0c, # Feb 10 1973 14:05
  0x05e370c4, # Feb 17 1973 10:07
  0x05ed9b08, # Feb 25 1973 03:10
  0x05f7fc24, # Mar  5 1973 00:07
  0x060110e8, # Mar 11 1973 21:26
  0x060a692c, # Mar 18 1973 23:33
  0x0614f838, # Mar 26 1973 23:46
  0x061edb3c, # Apr  3 1973 11:45
  0x0627af50, # Apr 10 1973 04:28
  0x06316dc4, # Apr 17 1973 13:51
  0x063c33e4, # Apr 25 1973 17:59
  0x064597a4, # May  2 1973 20:55
  0x064e5664, # May  9 1973 12:07
  0x06587dd8, # May 17 1973 04:58
  0x06633de0, # May 25 1973 08:40
  0x066c3eb8, # Jun  1 1973 04:34
  0x06751164, # Jun  7 1973 21:11
  0x067f94f4, # Jun 15 1973 20:35
  0x068a153c, # Jun 23 1973 19:45
  0x0692ddd4, # Jun 30 1973 11:39
  0x069beb18, # Jul  7 1973 08:26
  0x06a6a850, # Jul 15 1973 11:56
  0x06b0c448, # Jul 23 1973 03:58
  0x06b98074, # Jul 29 1973 18:59
  0x06c2ebb4, # Aug  5 1973 22:27
  0x06cdad60, # Aug 14 1973 02:16
  0x06d759c8, # Aug 21 1973 10:22
  0x06e0328c, # Aug 28 1973 03:25
  0x06ea1518, # Sep  4 1973 15:22
  0x06f49fb0, # Sep 12 1973 15:16
  0x06fde714, # Sep 19 1973 16:11
  0x07070178, # Sep 26 1973 13:54
  0x07115e20, # Oct  4 1973 10:32
  0x071b824c, # Oct 12 1973 03:09
  0x07247c1c, # Oct 18 1973 22:33
  0x072df92c, # Oct 26 1973 03:17
  0x0738b22c, # Nov  3 1973 06:29
  0x07425cb4, # Nov 10 1973 14:27
  0x074b2858, # Nov 17 1973 06:34
  0x07551e94, # Nov 24 1973 19:55
  0x075ff8dc, # Dec  3 1973 01:29
  0x076934c4, # Dec 10 1973 01:35
  0x0771f99c, # Dec 16 1973 17:13
  0x077c6814, # Dec 24 1973 15:07
  0x07871e08, # Jan  1 1974 18:06
  0x07900b30, # Jan  8 1974 12:36
  0x0798f7e0, # Jan 15 1974 07:04
  0x07a3bba8, # Jan 23 1974 11:02
  0x07ae1814, # Jan 31 1974 07:39
  0x07b6de90, # Feb  6 1974 23:24
  0x07c02270, # Feb 14 1974 00:04
  0x07cafbc8, # Feb 22 1974 05:34
  0x07d4e5d4, # Mar  1 1974 18:03
  0x07ddafd4, # Mar  8 1974 10:03
  0x07e76bb4, # Mar 15 1974 19:15
  0x07f215f0, # Mar 23 1974 21:24
  0x07fb8d60, # Mar 31 1974 01:44
  0x08048550, # Apr  6 1974 21:00
  0x080ebc3c, # Apr 14 1974 14:57
  0x08190660, # Apr 22 1974 10:16
  0x08221c14, # Apr 29 1974 07:39
  0x082b6864, # May  6 1974 08:55
  0x0835fc5c, # May 14 1974 09:29
  0x083fd2b8, # May 21 1974 20:34
  0x0848a384, # May 28 1974 13:03
  0x08525e38, # Jun  4 1974 22:10
  0x085d1c9c, # Jun 13 1974 01:45
  0x086683e0, # Jun 20 1974 04:56
  0x086f3760, # Jun 26 1974 19:20
  0x087965a0, # Jul  4 1974 12:40
  0x08841900, # Jul 12 1974 15:28
  0x088d2464, # Jul 19 1974 12:07
  0x0895eaa4, # Jul 26 1974 03:51
  0x08a0780c, # Aug  3 1974 03:57
  0x08aaf368, # Aug 11 1974 02:46
  0x08b3c128, # Aug 17 1974 19:02
  0x08bccbd8, # Aug 24 1974 15:38
  0x08c78d0c, # Sep  1 1974 19:25
  0x08d1b0fc, # Sep  9 1974 12:01
  0x08da692c, # Sep 16 1974 02:45
  0x08e3e150, # Sep 23 1974 07:08
  0x08ee9e88, # Oct  1 1974 10:38
  0x08f85978, # Oct  8 1974 19:46
  0x09012c9c, # Oct 15 1974 12:25
  0x090b247c, # Oct 23 1974 01:53
  0x0915a884, # Oct 31 1974 01:19
  0x091ef7a4, # Nov  7 1974 02:47
  0x0928176c, # Nov 14 1974 00:53
  0x09328404, # Nov 21 1974 22:39
  0x093ca6c8, # Nov 29 1974 15:10
  0x09459af8, # Dec  6 1974 10:10
  0x094f2d5c, # Dec 13 1974 16:25
  0x0959e7c4, # Dec 21 1974 19:43
  0x096394a4, # Dec 29 1974 03:51
  0x096c53a0, # Jan  4 1975 19:04
  0x097664d0, # Jan 12 1975 10:20
  0x098135b8, # Jan 20 1975 15:14
  0x098a6f0c, # Jan 27 1975 15:09
  0x09932e44, # Feb  3 1975 06:23
  0x099daacc, # Feb 11 1975 05:17
  0x09a857d8, # Feb 19 1975 07:38
  0x09b13858, # Feb 26 1975 01:14
  0x09ba2df0, # Mar  4 1975 20:20
  0x09c4ea74, # Mar 12 1975 23:47
  0x09cf426c, # Mar 20 1975 20:05
  0x09d7f790, # Mar 27 1975 10:36
  0x09e14b9c, # Apr  3 1975 12:25
  0x09ec1324, # Apr 11 1975 16:39
  0x09f5f6dc, # Apr 19 1975 04:41
  0x09feb614, # Apr 25 1975 19:55
  0x0a087aa0, # May  3 1975 05:44
  0x0a13199c, # May 11 1975 07:05
  0x0a1c83ec, # May 18 1975 10:29
  0x0a257d44, # May 25 1975 05:51
  0x0a2fae18, # Jun  1 1975 23:22
  0x0a39fa1c, # Jun  9 1975 18:49
  0x0a42fe78, # Jun 16 1975 14:58
  0x0a4c5428, # Jun 23 1975 16:54
  0x0a56dc2c, # Jul  1 1975 16:37
  0x0a60b918, # Jul  9 1975 04:10
  0x0a697db4, # Jul 15 1975 19:47
  0x0a734060, # Jul 23 1975 05:28
  0x0a7dfb40, # Jul 31 1975 08:48
  0x0a87620c, # Aug  7 1975 11:57
  0x0a901640, # Aug 14 1975 02:24
  0x0a9a4570, # Aug 21 1975 19:48
  0x0aa50320, # Aug 29 1975 23:20
  0x0aae0524, # Sep  5 1975 19:19
  0x0ab6d8c0, # Sep 12 1975 12:00
  0x0ac16268, # Sep 20 1975 11:50
  0x0acbed78, # Sep 28 1975 11:46
  0x0ad4b214, # Oct  5 1975 03:23
  0x0addce94, # Oct 12 1975 01:15
  0x0ae890b8, # Oct 20 1975 05:06
  0x0af2ba84, # Oct 27 1975 22:07
  0x0afb75fc, # Nov  3 1975 13:05
  0x0b04fa8c, # Nov 10 1975 18:21
  0x0b0fc070, # Nov 18 1975 22:28
  0x0b197110, # Nov 26 1975 06:52
  0x0b2256b8, # Dec  3 1975 00:50
  0x0b2c5384, # Dec 10 1975 14:39
  0x0b36df84, # Dec 18 1975 14:39
  0x0b401d10, # Dec 25 1975 14:52
  0x0b4954c0, # Jan  1 1976 14:40
  0x0b53c4a0, # Jan  9 1976 12:40
  0x0b5de1c4, # Jan 17 1976 04:47
  0x0b66cbe0, # Jan 23 1976 23:04
  0x0b706c90, # Jan 31 1976 06:20
  0x0b7b2d4c, # Feb  8 1976 10:05
  0x0b84c514, # Feb 15 1976 16:43
  0x0b8d88c0, # Feb 22 1976 08:16
  0x0b97984c, # Feb 29 1976 23:25
  0x0ba26da8, # Mar  9 1976 04:38
  0x0bab8f8c, # Mar 16 1976 02:53
  0x0bb459c8, # Mar 22 1976 18:54
  0x0bbeccf0, # Mar 30 1976 17:08
  0x0bc973a8, # Apr  7 1976 19:02
  0x0bd248ac, # Apr 14 1976 11:49
  0x0bdb42b8, # Apr 21 1976 07:14
  0x0be5fa14, # Apr 29 1976 10:19
  0x0bf03f4c, # May  7 1976 05:17
  0x0bf8f830, # May 13 1976 20:04
  0x0c0244f8, # May 20 1976 21:22
  0x0c0d0f14, # May 29 1976 01:47
  0x0c16ddf0, # Jun  5 1976 12:20
  0x0c1fa6c4, # Jun 12 1976 04:15
  0x0c295fd4, # Jun 19 1976 13:15
  0x0c340218, # Jun 27 1976 14:50
  0x0c3d61a0, # Jul  4 1976 17:28
  0x0c465f6c, # Jul 11 1976 13:09
  0x0c508dac, # Jul 19 1976 06:29
  0x0c5ad5b4, # Jul 27 1976 01:39
  0x0c63de48, # Aug  2 1976 22:06
  0x0c6d2f84, # Aug  9 1976 23:43
  0x0c77c28c, # Aug 18 1976 00:13
  0x0c8194ec, # Aug 25 1976 11:01
  0x0c8a66e4, # Sep  1 1976 03:35
  0x0c9423f0, # Sep  8 1976 12:52
  0x0c9eeec0, # Sep 16 1976 17:20
  0x0ca84d94, # Sep 23 1976 19:55
  0x0cb10d80, # Sep 30 1976 11:12
  0x0cbb4124, # Oct  8 1976 04:55
  0x0cc60654, # Oct 16 1976 08:59
  0x0ccf0b28, # Oct 23 1976 05:10
  0x0cd7e248, # Oct 29 1976 22:06
  0x0ce27e74, # Nov  6 1976 23:15
  0x0ced0204, # Nov 14 1976 22:39
  0x0cf5d384, # Nov 21 1976 15:11
  0x0cfeef14, # Nov 28 1976 12:59
  0x0d09c524, # Dec  6 1976 18:15
  0x0d13e068, # Dec 14 1976 10:14
  0x0d1ca900, # Dec 21 1976 02:08
  0x0d263330, # Dec 28 1976 07:48
  0x0d30fc98, # Jan  5 1977 12:10
  0x0d3aa414, # Jan 12 1977 19:55
  0x0d438df4, # Jan 19 1977 14:11
  0x0d4d9b64, # Jan 27 1977 05:11
  0x0d5815d0, # Feb  4 1977 03:56
  0x0d6152e4, # Feb 11 1977 04:07
  0x0d6a865c, # Feb 18 1977 03:37
  0x0d750758, # Feb 26 1977 02:50
  0x0d7f0c1c, # Mar  5 1977 17:13
  0x0d87f764, # Mar 12 1977 11:35
  0x0d9193dc, # Mar 19 1977 18:33
  0x0d9c56b4, # Mar 27 1977 22:27
  0x0da5e15c, # Apr  4 1977 04:09
  0x0dae9eb4, # Apr 10 1977 19:15
  0x0db8b0d4, # Apr 18 1977 10:35
  0x0dc376b8, # Apr 26 1977 14:42
  0x0dcc9a04, # May  3 1977 13:03
  0x0dd55720, # May 10 1977 04:08
  0x0ddfd114, # May 18 1977 02:51
  0x0dea63e0, # May 26 1977 03:20
  0x0df33e84, # Jun  1 1977 20:31
  0x0dfc2d14, # Jun  8 1977 15:07
  0x0e06e704, # Jun 16 1977 18:23
  0x0e112390, # Jun 24 1977 12:44
  0x0e19dad0, # Jul  1 1977 03:24
  0x0e2326e4, # Jul  8 1977 04:39
  0x0e2dea70, # Jul 16 1977 08:36
  0x0e37c018, # Jul 23 1977 19:38
  0x0e407f50, # Jul 30 1977 10:52
  0x0e4a43a0, # Aug  6 1977 20:40
  0x0e54db94, # Aug 14 1977 21:31
  0x0e5e4800, # Aug 22 1977 01:04
  0x0e673d98, # Aug 28 1977 20:10
  0x0e717a9c, # Sep  5 1977 14:33
  0x0e7bbdf4, # Sep 13 1977 09:23
  0x0e84cd18, # Sep 20 1977 06:18
  0x0e8e237c, # Sep 27 1977 08:17
  0x0e98be7c, # Oct  5 1977 09:21
  0x0ea29604, # Oct 12 1977 20:31
  0x0eab6388, # Oct 19 1977 12:46
  0x0eb53624, # Oct 26 1977 23:35
  0x0ebfffc8, # Nov  4 1977 03:58
  0x0ec9670c, # Nov 11 1977 07:09
  0x0ed21f00, # Nov 17 1977 21:52
  0x0edc6dd4, # Nov 25 1977 17:31
  0x0ee72e90, # Dec  3 1977 21:16
  0x0ef034cc, # Dec 10 1977 17:33
  0x0ef90dcc, # Dec 17 1977 10:37
  0x0f03b8bc, # Dec 25 1977 12:49
  0x0f0e3ae4, # Jan  2 1978 12:07
  0x0f170340, # Jan  9 1978 04:00
  0x0f203064, # Jan 16 1978 03:03
  0x0f2b0110, # Jan 24 1978 07:56
  0x0f351b64, # Jan 31 1978 23:51
  0x0f3dd808, # Feb  7 1978 14:54
  0x0f4778f4, # Feb 14 1978 22:11
  0x0f5232a8, # Feb 23 1978 01:26
  0x0f5bd178, # Mar  2 1978 08:34
  0x0f64b810, # Mar  9 1978 02:36
  0x0f6ed00c, # Mar 16 1978 18:21
  0x0f793fb0, # Mar 24 1978 16:20
  0x0f826a04, # Mar 31 1978 15:11
  0x0f8ba574, # Apr  7 1978 15:15
  0x0f961ef0, # Apr 15 1978 13:56
  0x0fa021d4, # Apr 23 1978 04:11
  0x0fa8f7c8, # Apr 29 1978 21:02
  0x0fb29f44, # May  7 1978 04:47
  0x0fbd5394, # May 15 1978 07:39
  0x0fc6dd4c, # May 22 1978 13:17
  0x0fcf8e38, # May 29 1978 03:30
  0x0fd9a2ec, # Jun  5 1978 19:01
  0x0fe46330, # Jun 13 1978 22:44
  0x0fed7e84, # Jun 20 1978 20:31
  0x0ff63d80, # Jun 27 1978 11:44
  0x1000aec8, # Jul  5 1978 09:50
  0x100b489c, # Jul 13 1978 10:49
  0x1014165c, # Jul 20 1978 03:05
  0x101d10a4, # Jul 26 1978 22:31
  0x1027bfcc, # Aug  4 1978 01:01
  0x103206a8, # Aug 11 1978 20:06
  0x103ab668, # Aug 18 1978 10:14
  0x10440df8, # Aug 25 1978 12:18
  0x104ed01c, # Sep  2 1978 16:09
  0x1058a7e0, # Sep 10 1978 03:20
  0x10616d6c, # Sep 16 1978 19:01
  0x106b3630, # Sep 24 1978 05:08
  0x1075d7fc, # Oct  2 1978 06:41
  0x107f3bf8, # Oct  9 1978 09:38
  0x108845b8, # Oct 16 1978 06:10
  0x109282f8, # Oct 24 1978 00:34
  0x109cd064, # Oct 31 1978 20:07
  0x10a5d538, # Nov  7 1978 16:18
  0x10af43c0, # Nov 14 1978 20:00
  0x10b9e370, # Nov 22 1978 21:24
  0x10c3b774, # Nov 30 1978 08:19
  0x10cc84f8, # Dec  7 1978 00:34
  0x10d66784, # Dec 14 1978 12:31
  0x10e13c68, # Dec 22 1978 17:42
  0x10ea91a0, # Dec 29 1978 19:36
  0x10f356b4, # Jan  5 1979 11:15
  0x10fda90c, # Jan 13 1979 07:09
  0x11087094, # Jan 21 1979 11:23
  0x11116410, # Jan 28 1979 06:20
  0x111a4df0, # Feb  4 1979 00:36
  0x1124f6c4, # Feb 12 1979 02:39
  0x112f6f8c, # Feb 20 1979 01:17
  0x1138320c, # Feb 26 1979 16:45
  0x11416764, # Mar  5 1979 16:23
  0x114c3798, # Mar 13 1979 21:14
  0x115638d8, # Mar 21 1979 11:22
  0x115efd74, # Mar 28 1979 02:59
  0x116899ec, # Apr  4 1979 09:57
  0x11735454, # Apr 12 1979 13:15
  0x117cd8a8, # Apr 19 1979 18:30
  0x1185c954, # Apr 26 1979 13:15
  0x118fd91c, # May  4 1979 04:25
  0x119a435c, # May 12 1979 02:01
  0x11a360cc, # May 18 1979 23:57
  0x11ac9c00, # May 26 1979 00:00
  0x11b7148c, # Jun  2 1979 22:37
  0x11c10a14, # Jun 10 1979 11:55
  0x11c9e38c, # Jun 17 1979 05:01
  0x11d37fc8, # Jun 24 1979 11:58
  0x11de3c10, # Jul  2 1979 15:24
  0x11e7b704, # Jul  9 1979 19:59
  0x11f072f4, # Jul 16 1979 10:59
  0x11fa7c2c, # Jul 24 1979 01:41
  0x1205442c, # Aug  1 1979 05:57
  0x120e5a1c, # Aug  8 1979 03:21
  0x12171fa8, # Aug 14 1979 19:02
  0x12219168, # Aug 22 1979 17:10
  0x122c2b3c, # Aug 30 1979 18:09
  0x123500f4, # Sep  6 1979 10:59
  0x123df8e4, # Sep 13 1979 06:15
  0x1248b694, # Sep 21 1979 09:47
  0x1252f5f0, # Sep 29 1979 04:20
  0x125bb564, # Oct  5 1979 19:35
  0x12650970, # Oct 12 1979 21:24
  0x126fdb84, # Oct 21 1979 02:23
  0x1279acb8, # Oct 28 1979 13:06
  0x12828054, # Nov  4 1979 05:47
  0x128c5020, # Nov 11 1979 16:24
  0x1296f390, # Nov 19 1979 18:04
  0x12a0596c, # Nov 26 1979 21:09
  0x12a96980, # Dec  3 1979 18:08
  0x12b3bb24, # Dec 11 1979 13:59
  0x12bdf864, # Dec 19 1979 08:23
  0x12c705e4, # Dec 26 1979 05:11
  0x12d07688, # Jan  2 1980 09:02
  0x12db29e8, # Jan 10 1980 11:50
  0x12e4e9c4, # Jan 17 1980 21:19
  0x12edbce8, # Jan 24 1980 13:58
  0x12f7a58c, # Feb  1 1980 02:21
  0x13027b24, # Feb  9 1980 07:35
  0x130bc774, # Feb 16 1980 08:51
  0x131488c8, # Feb 23 1980 00:14
  0x131ee750, # Mar  1 1980 21:00
  0x13299aec, # Mar  9 1980 23:49
  0x133290c0, # Mar 16 1980 18:56
  0x133b7104, # Mar 23 1980 12:31
  0x13462338, # Mar 31 1980 15:14
  0x13508328, # Apr  8 1980 12:06
  0x13594878, # Apr 15 1980 03:46
  0x136277f4, # Apr 22 1980 02:59
  0x136d44a4, # Apr 30 1980 07:35
  0x137739b4, # May  7 1980 20:51
  0x137ff7c0, # May 14 1980 12:00
  0x13899870, # May 21 1980 19:16
  0x13944360, # May 29 1980 21:28
  0x139dca0c, # Jun  6 1980 02:53
  0x13a6aca8, # Jun 12 1980 20:38
  0x13b0c6c0, # Jun 20 1980 12:32
  0x13bb2188, # Jun 28 1980 09:02
  0x13c445c4, # Jul  5 1980 07:27
  0x13cd76a8, # Jul 12 1980 06:46
  0x13d7f5c4, # Jul 20 1980 05:51
  0x13e1e7c8, # Jul 27 1980 18:54
  0x13eac140, # Aug  3 1980 12:00
  0x13f4604c, # Aug 10 1980 19:09
  0x13ff1af0, # Aug 18 1980 22:28
  0x14089f08, # Aug 26 1980 03:42
  0x14115300, # Sep  1 1980 18:08
  0x141b6ca0, # Sep  9 1980 10:00
  0x14262f78, # Sep 17 1980 13:54
  0x142f5120, # Sep 24 1980 12:08
  0x14380f68, # Oct  1 1980 03:18
  0x144294d8, # Oct  9 1980 02:50
  0x144d2e34, # Oct 17 1980 03:47
  0x14560770, # Oct 23 1980 20:52
  0x145f053c, # Oct 30 1980 16:33
  0x1469cbd4, # Nov  7 1980 20:43
  0x14741274, # Nov 15 1980 15:47
  0x147ccc84, # Nov 22 1980 06:39
  0x148635e4, # Nov 29 1980 09:59
  0x14910294, # Dec  7 1980 14:35
  0x149ada94, # Dec 15 1980 01:47
  0x14a3a980, # Dec 21 1980 18:08
  0x14ad9260, # Dec 29 1980 06:32
  0x14b82a90, # Jan  6 1981 07:24
  0x14c18bf8, # Jan 13 1981 10:10
  0x14caa314, # Jan 20 1981 07:39
  0x14d50034, # Jan 28 1981 04:19
  0x14df36a8, # Feb  4 1981 22:14
  0x14e8330c, # Feb 11 1981 17:49
  0x14f1b5f8, # Feb 18 1981 22:58
  0x14fc61d8, # Feb 27 1981 01:14
  0x15061ee4, # Mar  6 1981 10:31
  0x150edf84, # Mar 13 1981 01:51
  0x1518d818, # Mar 20 1981 15:22
  0x15239f28, # Mar 28 1981 19:34
  0x152ce434, # Apr  4 1981 20:19
  0x15359e44, # Apr 11 1981 11:11
  0x153ffd44, # Apr 19 1981 07:59
  0x154aa8e8, # Apr 27 1981 10:14
  0x15539034, # May  4 1981 04:19
  0x155c7708, # May 10 1981 22:22
  0x15671af0, # May 19 1981 00:04
  0x15717bd0, # May 26 1981 21:00
  0x157a3130, # Jun  2 1981 11:32
  0x15836bec, # Jun  9 1981 11:33
  0x158e2960, # Jun 17 1981 15:04
  0x15981f9c, # Jun 25 1981 04:25
  0x15a0d664, # Jul  1 1981 19:03
  0x15aa7bc4, # Jul  9 1981 02:39
  0x15b523e4, # Jul 17 1981 04:39
  0x15bea4f0, # Jul 24 1981 09:40
  0x15c78de0, # Jul 31 1981 03:52
  0x15d1a348, # Aug  7 1981 19:26
  0x15dc07ac, # Aug 15 1981 16:37
  0x15e52120, # Aug 22 1981 14:16
  0x15ee61f4, # Aug 29 1981 14:43
  0x15f8dbe8, # Sep  6 1981 13:26
  0x1602d74c, # Sep 14 1981 03:09
  0x160baa34, # Sep 20 1981 19:47
  0x161559e4, # Sep 28 1981 04:07
  0x162018fc, # Oct  6 1981 07:45
  0x16299abc, # Oct 13 1981 12:49
  0x16325490, # Oct 20 1981 03:40
  0x163c77cc, # Oct 27 1981 20:13
  0x1647492c, # Nov  5 1981 01:09
  0x16505d78, # Nov 11 1981 22:26
  0x16592e08, # Nov 18 1981 14:54
  0x1663b648, # Nov 26 1981 14:38
  0x166e5aa8, # Dec  4 1981 16:22
  0x1677291c, # Dec 11 1981 08:41
  0x16803ad4, # Dec 18 1981 05:47
  0x168b0478, # Dec 26 1981 10:10
  0x16954488, # Jan  3 1982 04:46
  0x169e021c, # Jan  9 1982 19:53
  0x16a77608, # Jan 16 1982 23:58
  0x16b247e0, # Jan 25 1982 04:56
  0x16bc0870, # Feb  1 1982 14:28
  0x16c4e74c, # Feb  8 1982 07:57
  0x16ced02c, # Feb 15 1982 20:21
  0x16d9685c, # Feb 23 1982 21:13
  0x16e2b164, # Mar  2 1982 22:15
  0x16ebd6cc, # Mar  9 1982 20:45
  0x16f63194, # Mar 17 1982 17:15
  0x17005b9c, # Mar 25 1982 10:17
  0x17094db0, # Apr  1 1982 05:08
  0x1712d0d8, # Apr  8 1982 10:18
  0x171d7e98, # Apr 16 1982 12:42
  0x1727268c, # Apr 23 1982 20:29
  0x172feb64, # Apr 30 1982 12:07
  0x1739d78c, # May  8 1982 00:45
  0x1744a1e4, # May 16 1982 05:11
  0x174dd520, # May 23 1982 04:40
  0x17569764, # May 29 1982 20:07
  0x1760e944, # Jun  6 1982 15:59
  0x176b9308, # Jun 14 1982 18:06
  0x177475e0, # Jun 21 1982 11:52
  0x177d5cf0, # Jun 28 1982 05:56
  0x1787ff70, # Jul  6 1982 07:32
  0x179256b4, # Jul 14 1982 03:47
  0x179b14fc, # Jul 20 1982 18:57
  0x17a44748, # Jul 27 1982 18:22
  0x17af0e58, # Aug  4 1982 22:34
  0x17b8f990, # Aug 12 1982 11:08
  0x17c1be2c, # Aug 19 1982 02:45
  0x17cb5c0c, # Aug 26 1982 09:49
  0x17d60d50, # Sep  3 1982 12:28
  0x17df8c04, # Sep 10 1982 17:19
  0x17e87ddc, # Sep 17 1982 12:09
  0x17f298e4, # Sep 25 1982 04:07
  0x17fcfb2c, # Oct  3 1982 01:09
  0x18061d88, # Oct  9 1982 23:26
  0x180f60f0, # Oct 17 1982 00:04
  0x1819ede0, # Oct 25 1982 00:08
  0x1823dc9c, # Nov  1 1982 12:57
  0x182cbe48, # Nov  8 1982 06:38
  0x183670c8, # Nov 15 1982 15:10
  0x18414228, # Nov 23 1982 20:06
  0x184ab86c, # Dec  1 1982 00:21
  0x18537bdc, # Dec  7 1982 15:53
  0x185dab48, # Dec 15 1982 09:18
  0x18687d5c, # Dec 23 1982 14:17
  0x1871916c, # Dec 30 1982 11:33
  0x187a61c0, # Jan  6 1983 04:00
  0x1884fdb0, # Jan 14 1983 05:08
  0x188f8f8c, # Jan 22 1983 05:33
  0x189865f8, # Jan 28 1983 22:26
  0x18a1742c, # Feb  4 1983 19:17
  0x18ac4a00, # Feb 13 1983 00:32
  0x18b67390, # Feb 20 1983 17:32
  0x18bf3598, # Feb 27 1983 08:58
  0x18c8ac90, # Mar  6 1983 13:16
  0x18d37724, # Mar 14 1983 17:43
  0x18dd2bfc, # Mar 22 1983 02:25
  0x18e60484, # Mar 28 1983 19:27
  0x18eff868, # Apr  5 1983 08:38
  0x18fa7b08, # Apr 13 1983 07:58
  0x1903c398, # Apr 20 1983 08:58
  0x190cdba4, # Apr 27 1983 06:31
  0x19174044, # May  5 1983 03:43
  0x1921578c, # May 12 1983 19:25
  0x192a49dc, # May 19 1983 14:17
  0x1933c3e0, # May 26 1983 18:48
  0x193e7074, # Jun  3 1983 21:07
  0x194814a8, # Jun 11 1983 04:38
  0x1950d278, # Jun 17 1983 19:46
  0x195ac080, # Jun 25 1983 08:32
  0x19658010, # Jul  3 1983 12:12
  0x196ebbf8, # Jul 10 1983 12:18
  0x19777158, # Jul 17 1983 02:50
  0x1981cdc4, # Jul 24 1983 23:27
  0x198c6db0, # Aug  2 1983 00:52
  0x199559e8, # Aug  8 1983 19:18
  0x199e38c4, # Aug 15 1983 12:47
  0x19a8e3b4, # Aug 23 1983 14:59
  0x19b33cd8, # Aug 31 1983 11:22
  0x19bbfbd4, # Sep  7 1983 02:35
  0x19c533c0, # Sep 14 1983 02:24
  0x19cffad0, # Sep 22 1983 06:36
  0x19d9f2ec, # Sep 29 1983 20:05
  0x19e2b170, # Oct  6 1983 11:16
  0x19ec6288, # Oct 13 1983 19:42
  0x19f70d3c, # Oct 21 1983 21:53
  0x1a00985c, # Oct 29 1983 03:37
  0x1a0988cc, # Nov  4 1983 22:21
  0x1a13b8ec, # Nov 12 1983 15:49
  0x1a1e160c, # Nov 20 1983 12:29
  0x1a273958, # Nov 27 1983 10:50
  0x1a308a58, # Dec  4 1983 12:26
  0x1a3b206c, # Dec 12 1983 13:09
  0x1a450fa0, # Dec 20 1983 02:00
  0x1a4de5d0, # Dec 26 1983 18:52
  0x1a57b290, # Jan  3 1984 05:16
  0x1a627e50, # Jan 11 1984 09:48
  0x1a6bf50c, # Jan 18 1984 14:05
  0x1a74ad00, # Jan 25 1984 04:48
  0x1a7ef238, # Feb  1 1984 23:46
  0x1a89b9c0, # Feb 10 1984 04:00
  0x1a92c59c, # Feb 17 1984 00:41
  0x1a9b96e0, # Feb 23 1984 17:12
  0x1aa63564, # Mar  2 1984 18:31
  0x1ab0c0b0, # Mar 10 1984 18:28
  0x1ab98678, # Mar 17 1984 10:10
  0x1ac2a208, # Mar 24 1984 07:58
  0x1acd6918, # Apr  1 1984 12:10
  0x1ad78e34, # Apr  9 1984 04:51
  0x1ae040c4, # Apr 15 1984 19:11
  0x1ae9c518, # Apr 23 1984 00:26
  0x1af47fbc, # May  1 1984 03:45
  0x1afe2be8, # May  8 1984 11:50
  0x1b06ff0c, # May 15 1984 04:29
  0x1b10f41c, # May 22 1984 17:45
  0x1b1b72c0, # May 30 1984 16:48
  0x1b24abd8, # Jun  6 1984 16:42
  0x1b2dca38, # Jun 13 1984 14:42
  0x1b382488, # Jun 21 1984 11:10
  0x1b4241e8, # Jun 29 1984 03:18
  0x1b4b24c0, # Jul  5 1984 21:04
  0x1b54a950, # Jul 13 1984 02:20
  0x1b5f4cfc, # Jul 21 1984 04:01
  0x1b68f5a4, # Jul 28 1984 11:51
  0x1b71ad5c, # Aug  4 1984 02:33
  0x1b7ba104, # Aug 11 1984 15:43
  0x1b8664cc, # Aug 19 1984 19:41
  0x1b8f9bc8, # Aug 26 1984 19:26
  0x1b9858a8, # Sep  2 1984 10:30
  0x1ba2b3ac, # Sep 10 1984 07:01
  0x1bad62d4, # Sep 18 1984 09:31
  0x1bb64444, # Sep 25 1984 03:11
  0x1bbf3400, # Oct  1 1984 21:52
  0x1bc9dd88, # Oct  9 1984 23:58
  0x1bd44318, # Oct 17 1984 21:14
  0x1bdcfda0, # Oct 24 1984 12:08
  0x1be645f4, # Oct 31 1984 13:07
  0x1bf112a4, # Nov  8 1984 17:43
  0x1bfb07b4, # Nov 16 1984 06:59
  0x1c03d13c, # Nov 22 1984 22:57
  0x1c0d8b3c, # Nov 30 1984 08:01
  0x1c183f8c, # Dec  8 1984 10:53
  0x1c21b9cc, # Dec 15 1984 15:25
  0x1c2ac134, # Dec 22 1984 11:47
  0x1c34f424, # Dec 30 1984 05:27
  0x1c3f5360, # Jan  7 1985 02:16
  0x1c486644, # Jan 13 1985 23:27
  0x1c51cb30, # Jan 21 1985 02:28
  0x1c5c657c, # Jan 29 1985 03:29
  0x1c664664, # Feb  5 1985 15:19
  0x1c6f194c, # Feb 12 1985 07:57
  0x1c78eb34, # Feb 19 1985 18:43
  0x1c83bd0c, # Feb 27 1985 23:41
  0x1c8d1b2c, # Mar  7 1985 02:13
  0x1c95dc08, # Mar 13 1985 17:34
  0x1ca01984, # Mar 21 1985 11:59
  0x1caae094, # Mar 29 1985 16:11
  0x1cb3d9b0, # Apr  5 1985 11:32
  0x1cbcb3dc, # Apr 12 1985 04:41
  0x1cc74978, # Apr 20 1985 05:22
  0x1cd1c81c, # Apr 28 1985 04:25
  0x1cda8a9c, # May  4 1985 19:53
  0x1ce3a488, # May 11 1985 17:34
  0x1cee6a6c, # May 19 1985 21:41
  0x1cf87b60, # May 27 1985 12:56
  0x1d0135e8, # Jun  3 1985 03:50
  0x1d0aaf74, # Jun 10 1985 08:19
  0x1d156ec8, # Jun 18 1985 11:58
  0x1d1f0a8c, # Jun 25 1985 18:53
  0x1d27e620, # Jul  2 1985 12:08
  0x1d31d2fc, # Jul 10 1985 00:49
  0x1d3c5290, # Jul 17 1985 23:56
  0x1d458914, # Jul 24 1985 23:39
  0x1d4ea7ec, # Jul 31 1985 21:41
  0x1d5906ec, # Aug  8 1985 18:29
  0x1d631d08, # Aug 16 1985 10:06
  0x1d6c0a30, # Aug 23 1985 04:36
  0x1d7588e4, # Aug 30 1985 09:27
  0x1d803c80, # Sep  7 1985 12:16
  0x1d89da60, # Sep 14 1985 19:20
  0x1d92a064, # Sep 21 1985 11:03
  0x1d9c92e0, # Sep 29 1985 00:08
  0x1da76440, # Oct  7 1985 05:04
  0x1db0977c, # Oct 14 1985 04:33
  0x1db95ccc, # Oct 20 1985 20:13
  0x1dc3c478, # Oct 28 1985 17:38
  0x1dce7364, # Nov  5 1985 20:07
  0x1dd75c90, # Nov 12 1985 14:20
  0x1de04d00, # Nov 19 1985 09:04
  0x1deb0c18, # Nov 27 1985 12:42
  0x1df5644c, # Dec  5 1985 09:01
  0x1dfe2ca8, # Dec 12 1985 00:54
  0x1e077628, # Dec 19 1985 01:58
  0x1e124ff8, # Dec 27 1985 07:30
  0x1e1c3734, # Jan  3 1986 19:47
  0x1e250968, # Jan 10 1986 12:22
  0x1e2ece6c, # Jan 17 1986 22:13
  0x1e397ac4, # Jan 26 1986 00:31
  0x1e42efdc, # Feb  2 1986 04:41
  0x1e4bf564, # Feb  9 1986 00:55
  0x1e563b14, # Feb 16 1986 19:55
  0x1e608268, # Feb 24 1986 15:02
  0x1e69963c, # Mar  3 1986 12:17
  0x1e72f510, # Mar 10 1986 14:52
  0x1e7d9a24, # Mar 18 1986 16:39
  0x1e8766a8, # Mar 26 1986 03:02
  0x1e903738, # Apr  1 1986 19:30
  0x1e9a0740, # Apr  9 1986 06:08
  0x1ea4d1d4, # Apr 17 1986 10:35
  0x1eae2b08, # Apr 24 1986 12:46
  0x1eb6e158, # May  1 1986 03:22
  0x1ec12438, # May  8 1986 22:10
  0x1ecbd810, # May 17 1986 01:00
  0x1ed4d6cc, # May 23 1986 20:45
  0x1edda324, # May 30 1986 12:55
  0x1ee83e60, # Jun  7 1986 14:00
  0x1ef2ae40, # Jun 15 1986 12:00
  0x1efb7408, # Jun 22 1986 03:42
  0x1f0486ec, # Jun 29 1986 00:53
  0x1f0f4ba4, # Jul  7 1986 04:55
  0x1f195c98, # Jul 14 1986 20:10
  0x1f221180, # Jul 21 1986 10:40
  0x1f2b90e8, # Jul 28 1986 15:34
  0x1f364790, # Aug  5 1986 18:36
  0x1f3fef0c, # Aug 13 1986 02:21
  0x1f48c0c8, # Aug 19 1986 18:54
  0x1f52bca4, # Aug 27 1986 08:39
  0x1f5d33c8, # Sep  4 1986 07:10
  0x1f66758c, # Sep 11 1986 07:41
  0x1f6f9248, # Sep 18 1986 05:34
  0x1f79fe2c, # Sep 26 1986 03:17
  0x1f841484, # Oct  3 1986 18:55
  0x1f8d0260, # Oct 10 1986 13:28
  0x1f968fd8, # Oct 17 1986 19:22
  0x1fa146f8, # Oct 25 1986 22:26
  0x1faaec58, # Nov  2 1986 06:02
  0x1fb3aa64, # Nov  8 1986 21:11
  0x1fbdb810, # Nov 16 1986 12:12
  0x1fc88538, # Nov 24 1986 16:50
  0x1fd1be14, # Dec  1 1986 16:43
  0x1fda7e3c, # Dec  8 1986 08:01
  0x1fe4fce0, # Dec 16 1986 07:04
  0x1fefa80c, # Dec 24 1986 09:17
  0x1ff88c88, # Dec 31 1986 03:10
  0x20018658, # Jan  6 1987 22:34
  0x200c49a8, # Jan 15 1987 02:30
  0x2016a0ec, # Jan 22 1987 22:45
  0x201f5cdc, # Jan 29 1987 13:45
  0x2028bbec, # Feb  5 1987 16:21
  0x203388d8, # Feb 13 1987 20:58
  0x203d6ba0, # Feb 21 1987 08:56
  0x20463474, # Feb 28 1987 00:51
  0x20500b48, # Mar  7 1987 11:58
  0x205aa8dc, # Mar 15 1987 13:13
  0x20640fa8, # Mar 22 1987 16:22
  0x206d1788, # Mar 29 1987 12:46
  0x20775db0, # Apr  6 1987 07:48
  0x20819f64, # Apr 14 1987 02:31
  0x208a9de4, # Apr 20 1987 22:15
  0x20940708, # Apr 28 1987 01:34
  0x209e9f38, # May  6 1987 02:26
  0x20a86bf8, # May 13 1987 12:50
  0x20b12ab8, # May 20 1987 04:02
  0x20bb027c, # May 27 1987 15:13
  0x20c5c20c, # Jun  4 1987 18:53
  0x20cf17bc, # Jun 11 1987 20:49
  0x20d7c8a8, # Jun 18 1987 11:02
  0x20e2087c, # Jun 26 1987 05:37
  0x20ecbdf8, # Jul  4 1987 08:34
  0x20f5b1ec, # Jul 11 1987 03:33
  0x20fe863c, # Jul 17 1987 20:17
  0x21091728, # Jul 25 1987 20:38
  0x211391d0, # Aug  2 1987 19:24
  0x211c4c1c, # Aug  9 1987 10:17
  0x21256c5c, # Aug 16 1987 08:25
  0x21302a84, # Aug 24 1987 11:59
  0x213a4370, # Sep  1 1987 03:48
  0x2142f72c, # Sep  7 1987 18:13
  0x214c7f40, # Sep 14 1987 23:44
  0x21573b10, # Sep 23 1987 03:08
  0x2160df44, # Sep 30 1987 10:39
  0x2169bf10, # Oct  7 1987 04:12
  0x2173bd08, # Oct 14 1987 18:06
  0x217e4020, # Oct 22 1987 17:28
  0x21877668, # Oct 29 1987 17:10
  0x2190ab48, # Nov  5 1987 16:46
  0x219b1948, # Nov 13 1987 14:38
  0x21a5339c, # Nov 21 1987 06:33
  0x21ae1aac, # Nov 28 1987 00:37
  0x21b7bd3c, # Dec  5 1987 08:01
  0x21c27ccc, # Dec 13 1987 11:41
  0x21cc15fc, # Dec 20 1987 18:25
  0x21d4da5c, # Dec 27 1987 10:01
  0x21def0f0, # Jan  4 1988 01:40
  0x21e9c8e0, # Jan 12 1988 07:04
  0x21f2ec68, # Jan 19 1988 05:26
  0x21fbbcf8, # Jan 25 1988 21:54
  0x22063a70, # Feb  2 1988 20:52
  0x2210e4ac, # Feb 10 1988 23:01
  0x2219bb18, # Feb 17 1988 15:54
  0x2222c244, # Feb 24 1988 12:15
  0x222d833c, # Mar  3 1988 16:01
  0x2237c7c0, # Mar 11 1988 10:56
  0x22408518, # Mar 18 1988 02:02
  0x2249e518, # Mar 25 1988 04:42
  0x2254b27c, # Apr  2 1988 09:21
  0x225e799c, # Apr  9 1988 19:21
  0x22674cc0, # Apr 16 1988 12:00
  0x22711b60, # Apr 23 1988 22:32
  0x227bb78c, # May  1 1988 23:41
  0x228509f4, # May  9 1988 01:23
  0x228e1774, # May 15 1988 22:11
  0x229857fc, # May 23 1988 16:49
  0x22a2908c, # May 31 1988 10:53
  0x22ab8b88, # Jun  7 1988 06:22
  0x22b4ee58, # Jun 14 1988 09:14
  0x22bf8a84, # Jun 22 1988 10:23
  0x22c948f8, # Jun 29 1988 19:46
  0x22d210a0, # Jul  6 1988 11:36
  0x22dbdbbc, # Jul 13 1988 21:53
  0x22e6a4e8, # Jul 22 1988 02:14
  0x22eff00c, # Jul 29 1988 03:25
  0x22f8ab48, # Aug  4 1988 18:22
  0x2302e504, # Aug 12 1988 12:31
  0x230d9fe4, # Aug 20 1988 15:51
  0x23169540, # Aug 27 1988 10:56
  0x231f6c24, # Sep  3 1988 03:51
  0x232a05bc, # Sep 11 1988 04:49
  0x23347c68, # Sep 19 1988 03:18
  0x233d43d4, # Sep 25 1988 19:07
  0x23466018, # Oct  2 1988 16:58
  0x2351304c, # Oct 10 1988 21:49
  0x235b408c, # Oct 18 1988 13:01
  0x236404b0, # Oct 25 1988 04:36
  0x236d8db4, # Nov  1 1988 10:11
  0x23785410, # Nov  9 1988 14:20
  0x2381f484, # Nov 16 1988 21:35
  0x238adedc, # Nov 23 1988 15:53
  0x2394eb5c, # Dec  1 1988 06:49
  0x239f6640, # Dec  9 1988 05:36
  0x23a8a1b0, # Dec 16 1988 05:40
  0x23b1d99c, # Dec 23 1988 05:29
  0x23bc5e1c, # Dec 31 1988 04:57
  0x23c66358, # Jan  7 1989 19:22
  0x23cf51e8, # Jan 14 1989 13:58
  0x23d8f748, # Jan 21 1989 21:34
  0x23e3c218, # Jan 30 1989 02:02
  0x23ed4b1c, # Feb  6 1989 07:37
  0x23f60ff4, # Feb 12 1989 23:15
  0x24002f70, # Feb 20 1989 15:32
  0x240afc20, # Feb 28 1989 20:08
  0x24141d14, # Mar  7 1989 18:19
  0x241ce534, # Mar 14 1989 10:11
  0x24276e28, # Mar 22 1989 09:58
  0x2431ffc8, # Mar 30 1989 10:22
  0x243ada6c, # Apr  6 1989 03:33
  0x2443d7fc, # Apr 12 1989 23:13
  0x244e9c3c, # Apr 21 1989 03:13
  0x2458cd88, # Apr 28 1989 20:46
  0x24618978, # May  5 1989 11:46
  0x246ae810, # May 12 1989 14:20
  0x2475ab60, # May 20 1989 18:16
  0x247f6efc, # May 28 1989 04:01
  0x2488371c, # Jun  3 1989 19:53
  0x24920db4, # Jun 11 1989 06:59
  0x249c993c, # Jun 19 1989 06:57
  0x24a5f2ac, # Jun 26 1989 09:09
  0x24aef294, # Jul  3 1989 04:59
  0x24b93cf4, # Jul 11 1989 00:19
  0x24c36be8, # Jul 18 1989 17:42
  0x24cc6b94, # Jul 25 1989 13:31
  0x24d5ca68, # Aug  1 1989 16:06
  0x24e069dc, # Aug  9 1989 17:29
  0x24ea2bd4, # Aug 17 1989 03:07
  0x24f2ef80, # Aug 23 1989 18:40
  0x24fcc5dc, # Aug 31 1989 05:45
  0x25078b0c, # Sep  8 1989 09:49
  0x2510e224, # Sep 15 1989 11:51
  0x25199478, # Sep 22 1989 02:10
  0x2523e2d4, # Sep 29 1989 21:47
  0x252e9a30, # Oct  8 1989 00:52
  0x253797c0, # Oct 14 1989 20:32
  0x25406cc4, # Oct 21 1989 13:19
  0x254b16c4, # Oct 29 1989 15:27
  0x255590f4, # Nov  6 1989 14:11
  0x255e5644, # Nov 13 1989 05:51
  0x25678110, # Nov 20 1989 04:44
  0x257252ac, # Nov 28 1989 09:41
  0x257c6aa8, # Dec  6 1989 01:26
  0x25852788, # Dec 12 1989 16:30
  0x258eca54, # Dec 19 1989 23:55
  0x25998660, # Dec 28 1989 03:20
  0x25a32800, # Jan  4 1990 10:40
  0x25ac121c, # Jan 11 1990 04:57
  0x25b6324c, # Jan 18 1990 21:17
  0x25c0a2e0, # Jan 26 1990 19:20
  0x25c9d220, # Feb  2 1990 18:32
  0x25d316f0, # Feb  9 1990 19:16
  0x25dd9c60, # Feb 17 1990 18:48
  0x25e79d28, # Feb 25 1990 08:54
  0x25f077cc, # Mar  4 1990 02:05
  0x25fa2f74, # Mar 11 1990 10:59
  0x2604ece8, # Mar 19 1990 14:30
  0x260e71f0, # Mar 26 1990 19:48
  0x26172840, # Apr  2 1990 10:24
  0x26215068, # Apr 10 1990 03:18
  0x262c1124, # Apr 18 1990 07:03
  0x26352714, # Apr 25 1990 04:27
  0x263deef8, # May  1 1990 20:18
  0x26486ff4, # May  9 1990 19:31
  0x2652ff78, # May 17 1990 19:46
  0x265bc9b4, # May 24 1990 11:47
  0x2664d194, # May 31 1990 08:11
  0x266f856c, # Jun  8 1990 11:01
  0x2679ba00, # Jun 16 1990 04:48
  0x26826984, # Jun 22 1990 18:55
  0x268bd104, # Jun 29 1990 22:07
  0x26968af4, # Jul  8 1990 01:23
  0x26a04da0, # Jul 15 1990 11:04
  0x26a91548, # Jul 22 1990 02:54
  0x26b2ec1c, # Jul 29 1990 14:01
  0x26bd7c54, # Aug  6 1990 14:19
  0x26c6cd18, # Aug 13 1990 15:54
  0x26cfd9e4, # Aug 20 1990 12:39
  0x26da1e68, # Aug 28 1990 07:34
  0x26e458d8, # Sep  5 1990 01:46
  0x26ed4eac, # Sep 11 1990 20:53
  0x26f6bfc8, # Sep 19 1990 00:46
  0x27015e88, # Sep 27 1990 02:06
  0x270b24b8, # Oct  4 1990 12:02
  0x2713e774, # Oct 11 1990 03:31
  0x271dcc1c, # Oct 18 1990 15:37
  0x27289bd8, # Oct 26 1990 20:26
  0x2731e990, # Nov  2 1990 21:48
  0x273aa8c8, # Nov  9 1990 13:02
  0x2744fd3c, # Nov 17 1990 09:05
  0x274fc320, # Nov 25 1990 13:12
  0x2758b228, # Dec  2 1990 07:50
  0x27619b90, # Dec  9 1990 02:04
  0x276c47e8, # Dec 17 1990 04:22
  0x2776c470, # Dec 25 1990 03:16
  0x277f84d4, # Dec 31 1990 18:35
  0x2788bf54, # Jan  7 1991 18:35
  0x27939528, # Jan 15 1991 23:50
  0x279d9c08, # Jan 23 1991 14:22
  0x27a66338, # Jan 30 1991 06:10
  0x27b00a00, # Feb  6 1991 13:52
  0x27bac990, # Feb 14 1991 17:32
  0x27c45078, # Feb 21 1991 22:58
  0x27cd4afc, # Feb 28 1991 18:25
  0x27d76820, # Mar  8 1991 10:32
  0x27e1d2d8, # Mar 16 1991 08:10
  0x27eaef94, # Mar 23 1991 06:03
  0x27f43b6c, # Mar 30 1991 07:17
  0x27febfec, # Apr  7 1991 06:45
  0x2808af98, # Apr 14 1991 19:38
  0x281187e4, # Apr 21 1991 12:39
  0x281b3794, # Apr 28 1991 20:59
  0x2825f8c8, # May  7 1991 00:46
  0x282f6930, # May 14 1991 04:36
  0x28382778, # May 20 1991 19:46
  0x284240dc, # May 28 1991 11:37
  0x284d0378, # Jun  5 1991 15:30
  0x28560e28, # Jun 12 1991 12:06
  0x285edb34, # Jun 19 1991 04:19
  0x28695438, # Jun 27 1991 02:58
  0x2873de58, # Jul  5 1991 02:50
  0x287cac18, # Jul 11 1991 19:06
  0x2885af84, # Jul 18 1991 15:11
  0x289068c0, # Jul 26 1991 18:24
  0x289a928c, # Aug  3 1991 11:25
  0x28a34f30, # Aug 10 1991 02:28
  0x28acad8c, # Aug 17 1991 05:01
  0x28b77334, # Aug 25 1991 09:07
  0x28c12e60, # Sep  1 1991 18:16
  0x28ca02ec, # Sep  8 1991 11:01
  0x28d3d81c, # Sep 15 1991 22:01
  0x28de6d40, # Sep 23 1991 22:40
  0x28e7c188, # Oct  1 1991 00:30
  0x28f0d3f4, # Oct  7 1991 21:39
  0x28fb264c, # Oct 15 1991 17:33
  0x29055810, # Oct 23 1991 11:08
  0x290e5b04, # Oct 30 1991 07:11
  0x2917cdc4, # Nov  6 1991 11:11
  0x292281d8, # Nov 14 1991 14:02
  0x292c3980, # Nov 21 1991 22:56
  0x2935095c, # Nov 28 1991 15:21
  0x293ef4d0, # Dec  6 1991 03:56
  0x2949cf90, # Dec 14 1991 09:32
  0x29531604, # Dec 21 1991 10:23
  0x295bd974, # Dec 28 1991 01:55
  0x29663ec8, # Jan  4 1992 23:10
  0x2970fa20, # Jan 13 1992 02:32
  0x2979ed60, # Jan 19 1992 21:28
  0x2982d344, # Jan 26 1992 15:27
  0x298d9130, # Feb  3 1992 19:00
  0x2997f684, # Feb 11 1992 16:15
  0x29a0bdf0, # Feb 18 1992 08:04
  0x29a9f690, # Feb 25 1992 07:56
  0x29b4cef8, # Mar  4 1992 13:22
  0x29bec390, # Mar 12 1992 02:36
  0x29c78958, # Mar 18 1992 18:18
  0x29d13728, # Mar 26 1992 02:30
  0x29dbe68c, # Apr  3 1992 05:01
  0x29e56888, # Apr 10 1992 10:06
  0x29ee5718, # Apr 17 1992 04:42
  0x29f88030, # Apr 24 1992 21:40
  0x2a02d4e0, # May  2 1992 17:44
  0x2a0bf340, # May  9 1992 15:44
  0x2a153234, # May 16 1992 16:03
  0x2a1fbbdc, # May 24 1992 15:53
  0x2a29a00c, # Jun  1 1992 03:57
  0x2a3275c4, # Jun  7 1992 20:47
  0x2a3c2178, # Jun 15 1992 04:50
  0x2a46dc94, # Jun 23 1992 08:11
  0x2a5050f8, # Jun 30 1992 12:18
  0x2a5904b4, # Jul  7 1992 02:43
  0x2a632598, # Jul 14 1992 19:06
  0x2a6ddd30, # Jul 22 1992 22:12
  0x2a76f2e4, # Jul 29 1992 19:35
  0x2a7fb474, # Aug  5 1992 10:59
  0x2a8a38f4, # Aug 13 1992 10:27
  0x2a94bedc, # Aug 21 1992 10:01
  0x2a9d9278, # Aug 28 1992 02:42
  0x2aa69404, # Sep  3 1992 22:39
  0x2ab1531c, # Sep 12 1992 02:17
  0x2abb851c, # Sep 19 1992 19:53
  0x2ac43e00, # Sep 26 1992 10:40
  0x2acdaa30, # Oct  3 1992 14:12
  0x2ad86c54, # Oct 11 1992 18:03
  0x2ae23590, # Oct 19 1992 04:12
  0x2aeb04b8, # Oct 25 1992 20:34
  0x2af4f0a4, # Nov  2 1992 09:11
  0x2aff7ec0, # Nov 10 1992 09:20
  0x2b08d9d4, # Nov 17 1992 11:39
  0x2b11f1a4, # Nov 24 1992 09:11
  0x2b1c54dc, # Dec  2 1992 06:17
  0x2b26840c, # Dec  9 1992 23:41
  0x2b2f7fbc, # Dec 16 1992 19:13
  0x2b390794, # Dec 24 1992 00:43
  0x2b43bc98, # Jan  1 1993 03:38
  0x2b4d756c, # Jan  8 1993 12:37
  0x2b5636fc, # Jan 15 1993 04:01
  0x2b603c74, # Jan 22 1993 18:27
  0x2b6b0d20, # Jan 30 1993 23:20
  0x2b744fd4, # Feb  6 1993 23:55
  0x2b7d0c3c, # Feb 13 1993 14:57
  0x2b877dfc, # Feb 21 1993 13:05
  0x2b922ff4, # Mar  1 1993 15:47
  0x2b9b15d8, # Mar  8 1993 09:46
  0x2ba4033c, # Mar 15 1993 04:17
  0x2baeb8b8, # Mar 23 1993 07:14
  0x2bb91998, # Mar 31 1993 04:10
  0x2bc1cf34, # Apr  6 1993 18:43
  0x2bcb16d4, # Apr 13 1993 19:39
  0x2bd5dd6c, # Apr 21 1993 23:49
  0x2bdfccdc, # Apr 29 1993 12:41
  0x2be88728, # May  6 1993 03:34
  0x2bf23cf0, # May 13 1993 12:20
  0x2bfce204, # May 21 1993 14:07
  0x2c06580c, # May 28 1993 18:21
  0x2c0f47c8, # Jun  4 1993 13:02
  0x2c196b40, # Jun 12 1993 05:36
  0x2c23c2c0, # Jun 20 1993 01:52
  0x2c2cd0f4, # Jun 26 1993 22:43
  0x2c3619fc, # Jul  3 1993 23:45
  0x2c4098dc, # Jul 11 1993 22:49
  0x2c4a8450, # Jul 19 1993 11:24
  0x2c534e8c, # Jul 26 1993 03:25
  0x2c5d0418, # Aug  2 1993 12:10
  0x2c67bc64, # Aug 10 1993 15:19
  0x2c713140, # Aug 17 1993 19:28
  0x2c79e5ec, # Aug 24 1993 09:57
  0x2c8409dc, # Sep  1 1993 02:33
  0x2c8ecc78, # Sep  9 1993 06:26
  0x2c97d908, # Sep 16 1993 03:10
  0x2ca0a86c, # Sep 22 1993 19:33
  0x2cab2b48, # Sep 30 1993 18:54
  0x2cb5c0e4, # Oct  8 1993 19:35
  0x2cbe8b20, # Oct 15 1993 11:36
  0x2cc79f30, # Oct 22 1993 08:52
  0x2cd26028, # Oct 30 1993 12:38
  0x2cdc9750, # Nov  7 1993 06:36
  0x2ce552c8, # Nov 13 1993 21:34
  0x2ceecc54, # Nov 21 1993 02:03
  0x2cf99724, # Nov 29 1993 06:31
  0x2d03546c, # Dec  6 1993 15:49
  0x2d0c3564, # Dec 13 1993 09:27
  0x2d162678, # Dec 20 1993 22:26
  0x2d20bb9c, # Dec 28 1993 23:05
  0x2d2a033c, # Jan  5 1994 00:01
  0x2d3331c8, # Jan 11 1994 23:10
  0x2d3d9794, # Jan 19 1994 20:27
  0x2d47c034, # Jan 27 1994 13:23
  0x2d50b068, # Feb  3 1994 08:06
  0x2d5a44e8, # Feb 10 1994 14:30
  0x2d64ff14, # Feb 18 1994 17:47
  0x2d6ea294, # Feb 26 1994 01:15
  0x2d77676c, # Mar  4 1994 16:53
  0x2d81699c, # Mar 12 1994 07:05
  0x2d8c3e08, # Mar 20 1994 12:14
  0x2d956988, # Mar 27 1994 11:10
  0x2d9e3004, # Apr  3 1994 02:55
  0x2da896fc, # Apr 11 1994 00:17
  0x2db34318, # Apr 19 1994 02:34
  0x2dbc1dbc, # Apr 25 1994 19:45
  0x2dc50ee0, # May  2 1994 14:32
  0x2dcfbf34, # May 10 1994 17:07
  0x2dda0ef8, # May 18 1994 12:50
  0x2de2c854, # May 25 1994 03:39
  0x2dec0838, # Jun  1 1994 04:02
  0x2df6d218, # Jun  9 1994 08:26
  0x2e00ae8c, # Jun 16 1994 19:57
  0x2e0972ec, # Jun 23 1994 11:33
  0x2e131d74, # Jun 30 1994 19:31
  0x2e1dc6fc, # Jul  8 1994 21:37
  0x2e2733e0, # Jul 16 1994 01:12
  0x2e302900, # Jul 22 1994 20:16
  0x2e3a4a20, # Jul 30 1994 12:40
  0x2e449f0c, # Aug  7 1994 08:45
  0x2e4db22c, # Aug 14 1994 05:57
  0x2e56f864, # Aug 21 1994 06:47
  0x2e6182fc, # Aug 29 1994 06:41
  0x2e6b645c, # Sep  5 1994 18:33
  0x2e743ca8, # Sep 12 1994 11:34
  0x2e7dedfc, # Sep 19 1994 20:01
  0x2e88b764, # Sep 28 1994 00:23
  0x2e922394, # Oct  5 1994 03:55
  0x2e9ae4ac, # Oct 11 1994 19:17
  0x2ea50e78, # Oct 19 1994 12:18
  0x2eafd8d0, # Oct 27 1994 16:44
  0x2eb8e704, # Nov  3 1994 13:35
  0x2ec1ba28, # Nov 10 1994 06:14
  0x2ecc503c, # Nov 18 1994 06:57
  0x2ed6dde0, # Nov 26 1994 07:04
  0x2edfb398, # Dec  2 1994 23:54
  0x2ee8c6b8, # Dec  9 1994 21:06
  0x2ef39b9c, # Dec 18 1994 02:17
  0x2efdc298, # Dec 25 1994 19:06
  0x2f068a40, # Jan  1 1995 10:56
  0x2f1008b8, # Jan  8 1995 15:46
  0x2f1ad658, # Jan 16 1995 20:26
  0x2f2488d8, # Jan 24 1995 04:58
  0x2f2d6ca0, # Jan 30 1995 22:48
  0x2f376d68, # Feb  7 1995 12:54
  0x2f41f044, # Feb 15 1995 12:15
  0x2f4b3640, # Feb 22 1995 13:04
  0x2f545ef0, # Mar  1 1995 11:48
  0x2f5ed4e8, # Mar  9 1995 10:14
  0x2f68e528, # Mar 17 1995 01:26
  0x2f71d598, # Mar 23 1995 20:10
  0x2f7b643c, # Mar 31 1995 02:09
  0x2f862084, # Apr  8 1995 05:35
  0x2f8fb720, # Apr 15 1995 12:08
  0x2f987568, # Apr 22 1995 03:18
  0x2fa27900, # Apr 29 1995 17:36
  0x2fad3f20, # May  7 1995 21:44
  0x2fb66c80, # May 14 1995 20:48
  0x2fbf25a0, # May 21 1995 11:36
  0x2fc99364, # May 29 1995 09:27
  0x2fd42d38, # Jun  6 1995 10:26
  0x2fdd0df4, # Jun 13 1995 04:03
  0x2fe5f39c, # Jun 19 1995 22:01
  0x2ff0a738, # Jun 28 1995 00:50
  0x2ffaefb8, # Jul  5 1995 20:02
  0x3003a89c, # Jul 12 1995 10:49
  0x300ce808, # Jul 19 1995 11:10
  0x3017acfc, # Jul 27 1995 15:13
  0x302190f0, # Aug  4 1995 03:16
  0x302a4ce0, # Aug 10 1995 18:16
  0x30340320, # Aug 18 1995 03:04
  0x303ea384, # Aug 26 1995 04:31
  0x30481dc4, # Sep  2 1995 09:03
  0x30510bdc, # Sep  9 1995 03:37
  0x305b3cec, # Sep 16 1995 21:09
  0x30658d64, # Sep 24 1995 16:55
  0x306ea750, # Oct  1 1995 14:36
  0x3077f3a0, # Oct  8 1995 15:52
  0x30828798, # Oct 16 1995 16:26
  0x308c6d30, # Oct 24 1995 04:36
  0x309540cc, # Oct 30 1995 21:17
  0x309f08a0, # Nov  7 1995 07:20
  0x30a9d190, # Nov 15 1995 11:40
  0x30b34504, # Nov 22 1995 15:43
  0x30bbfd70, # Nov 29 1995 06:28
  0x30c642e4, # Dec  7 1995 01:27
  0x30d10814, # Dec 15 1995 05:31
  0x30da1648, # Dec 22 1995 02:22
  0x30e2ea98, # Dec 28 1995 19:06
  0x30ed8f34, # Jan  5 1996 20:51
  0x30f819cc, # Jan 13 1996 20:45
  0x3100e4f8, # Jan 20 1996 12:50
  0x310a08f8, # Jan 27 1996 11:14
  0x3114d788, # Feb  4 1996 15:58
  0x311efc2c, # Feb 12 1996 08:37
  0x3127b678, # Feb 18 1996 23:30
  0x31314a80, # Feb 26 1996 05:52
  0x313c07f4, # Mar  5 1996 09:23
  0x3145b114, # Mar 12 1996 17:15
  0x314e902c, # Mar 19 1996 10:45
  0x31589a54, # Mar 27 1996 01:31
  0x316312a4, # Apr  4 1996 00:07
  0x316c45e0, # Apr 10 1996 23:36
  0x3175755c, # Apr 17 1996 22:49
  0x317fe320, # Apr 25 1996 20:40
  0x3189f270, # May  3 1996 11:48
  0x3192ce40, # May 10 1996 05:04
  0x319c66f8, # May 17 1996 11:46
  0x31a7156c, # May 25 1996 14:13
  0x31b0ac44, # Jun  1 1996 20:47
  0x31b95e5c, # Jun  8 1996 11:05
  0x31c36500, # Jun 16 1996 01:36
  0x31ce2634, # Jun 24 1996 05:23
  0x31d74cc8, # Jul  1 1996 03:58
  0x31e00804, # Jul  7 1996 18:55
  0x31ea6e84, # Jul 15 1996 16:15
  0x31f5108c, # Jul 23 1996 17:49
  0x31fde554, # Jul 30 1996 10:35
  0x3206d72c, # Aug  6 1996 05:25
  0x32118168, # Aug 14 1996 07:34
  0x321bd5a0, # Aug 22 1996 03:36
  0x32248740, # Aug 28 1996 17:52
  0x322dd318, # Sep  4 1996 19:06
  0x32389794, # Sep 12 1996 23:07
  0x32427e94, # Sep 20 1996 11:23
  0x324b4114, # Sep 27 1996 02:51
  0x3254fd30, # Oct  4 1996 12:04
  0x325fa7a8, # Oct 12 1996 14:14
  0x3269193c, # Oct 19 1996 18:09
  0x32721bf4, # Oct 26 1996 14:11
  0x327c4ea8, # Nov  3 1996 07:50
  0x3286a880, # Nov 11 1996 04:16
  0x328fb72c, # Nov 18 1996 01:09
  0x32991c18, # Nov 25 1996 04:10
  0x32a3b538, # Dec  3 1996 05:06
  0x32ad9620, # Dec 10 1996 16:56
  0x32b66854, # Dec 17 1996 09:31
  0x32c03fdc, # Dec 24 1996 20:41
  0x32cb131c, # Jan  2 1997 01:45
  0x32d47358, # Jan  9 1997 04:26
  0x32dd37b8, # Jan 15 1997 20:02
  0x32e77f84, # Jan 23 1997 15:11
  0x32f24a90, # Jan 31 1997 19:40
  0x32fb44d8, # Feb  7 1997 15:06
  0x33042918, # Feb 14 1997 08:58
  0x330ec9f4, # Feb 22 1997 10:27
  0x33194a78, # Mar  2 1997 09:38
  0x33220f14, # Mar  9 1997 01:15
  0x332b3968, # Mar 16 1997 00:06
  0x333606cc, # Mar 24 1997 04:45
  0x33401298, # Mar 31 1997 19:38
  0x3348d428, # Apr  7 1997 11:02
  0x33526290, # Apr 14 1997 17:00
  0x335d207c, # Apr 22 1997 20:33
  0x3366b04c, # Apr 30 1997 02:37
  0x336f98c4, # May  6 1997 20:47
  0x33799a04, # May 14 1997 10:55
  0x33840e1c, # May 22 1997 09:13
  0x338d3564, # May 29 1997 07:51
  0x339664e0, # Jun  5 1997 07:04
  0x33a0d1b4, # Jun 13 1997 04:51
  0x33aad54c, # Jun 20 1997 19:09
  0x33b3b518, # Jun 27 1997 12:42
  0x33bd4380, # Jul  4 1997 18:40
  0x33c7faa0, # Jul 12 1997 21:44
  0x33d183e0, # Jul 20 1997 03:20
  0x33da41b0, # Jul 26 1997 18:28
  0x33e43dc8, # Aug  3 1997 08:14
  0x33ef0898, # Aug 11 1997 12:42
  0x33f82a04, # Aug 18 1997 10:55
  0x3400ecc0, # Aug 25 1997 02:24
  0x340b5520, # Sep  1 1997 23:52
  0x3415f854, # Sep 10 1997 01:31
  0x341ed4d8, # Sep 16 1997 18:50
  0x3427c584, # Sep 23 1997 13:35
  0x34327fb0, # Oct  1 1997 16:52
  0x343ccc68, # Oct  9 1997 12:22
  0x34458df8, # Oct 16 1997 03:46
  0x344ed700, # Oct 23 1997 04:48
  0x3459ac5c, # Oct 31 1997 10:01
  0x34638b64, # Nov  7 1997 21:43
  0x346c5c30, # Nov 14 1997 14:12
  0x34762008, # Nov 21 1997 23:58
  0x3480cbe8, # Nov 30 1997 02:14
  0x348a3d7c, # Dec  7 1997 06:09
  0x3493464c, # Dec 14 1997 02:37
  0x349d8d64, # Dec 21 1997 21:43
  0x34a7d65c, # Dec 29 1997 16:57
  0x34b0eb98, # Jan  5 1998 14:18
  0x34ba51b0, # Jan 12 1998 17:24
  0x34c4fd90, # Jan 20 1998 19:40
  0x34cec99c, # Jan 28 1998 06:01
  0x34d79fcc, # Feb  3 1998 22:53
  0x34e17c04, # Feb 11 1998 10:23
  0x34ec4f44, # Feb 19 1998 15:27
  0x34f5a5a8, # Feb 26 1998 17:26
  0x34fe651c, # Mar  5 1998 08:41
  0x3508b738, # Mar 13 1998 04:34
  0x35136e58, # Mar 21 1998 07:38
  0x351c6af8, # Mar 28 1998 03:14
  0x352543f8, # Apr  3 1998 20:18
  0x352fed44, # Apr 11 1998 22:23
  0x353a561c, # Apr 19 1998 19:53
  0x35431d4c, # Apr 26 1998 11:41
  0x354c4110, # May  3 1998 10:04
  0x35570b2c, # May 11 1998 14:29
  0x35610bf4, # May 19 1998 04:35
  0x3569c730, # May 25 1998 19:32
  0x3573591c, # Jun  2 1998 01:45
  0x357e08f8, # Jun 10 1998 04:18
  0x35879c88, # Jun 17 1998 10:38
  0x35907768, # Jun 24 1998 03:50
  0x359a8334, # Jul  1 1998 18:43
  0x35a4e93c, # Jul  9 1998 16:01
  0x35ae187c, # Jul 16 1998 15:13
  0x35b73e20, # Jul 23 1998 13:44
  0x35c1b2ec, # Jul 31 1998 12:05
  0x35cbb378, # Aug  8 1998 02:10
  0x35d49470, # Aug 14 1998 19:48
  0x35de26d4, # Aug 22 1998 02:03
  0x35e8ddf4, # Aug 30 1998 05:07
  0x35f2701c, # Sep  6 1998 11:21
  0x35fb26a8, # Sep 13 1998 01:58
  0x360534cc, # Sep 20 1998 17:01
  0x360ffb64, # Sep 28 1998 21:11
  0x36192810, # Oct  5 1998 20:12
  0x3621e3c4, # Oct 12 1998 11:11
  0x362c613c, # Oct 20 1998 10:09
  0x363703f8, # Oct 28 1998 11:46
  0x363fe388, # Nov  4 1998 05:18
  0x3648da10, # Nov 11 1998 00:28
  0x36539e14, # Nov 19 1998 04:27
  0x365df0e4, # Nov 27 1998 00:23
  0x3666abe4, # Dec  3 1998 15:19
  0x36700ab8, # Dec 10 1998 17:54
  0x367ada38, # Dec 18 1998 22:42
  0x3684be68, # Dec 26 1998 10:46
  0x368d8958, # Jan  2 1999 02:50
  0x36976608, # Jan  9 1999 14:22
  0x36a205b8, # Jan 17 1999 15:46
  0x36ab7134, # Jan 24 1999 19:15
  0x36b47fa4, # Jan 31 1999 16:07
  0x36bed148, # Feb  8 1999 11:58
  0x36c91284, # Feb 16 1999 06:39
  0x36d215b4, # Feb 23 1999 02:43
  0x36db8bf8, # Mar  2 1999 06:58
  0x36e62fe0, # Mar 10 1999 08:40
  0x36eff8e0, # Mar 17 1999 18:48
  0x36f8bbd8, # Mar 24 1999 10:18
  0x3702a65c, # Mar 31 1999 22:49
  0x370d6b14, # Apr  9 1999 02:51
  0x3716bae8, # Apr 16 1999 04:22
  0x371f7228, # Apr 22 1999 19:02
  0x3729c444, # Apr 30 1999 14:55
  0x3734745c, # May  8 1999 17:29
  0x373d62ec, # May 15 1999 12:05
  0x374641c8, # May 22 1999 05:34
  0x3750dd40, # May 30 1999 06:40
  0x375b4870, # Jun  7 1999 04:20
  0x37640064, # Jun 13 1999 19:03
  0x376d2f2c, # Jun 20 1999 18:13
  0x3777eafc, # Jun 28 1999 21:37
  0x3781ef0c, # Jul  6 1999 11:57
  0x378aa340, # Jul 13 1999 02:24
  0x37943a90, # Jul 20 1999 09:00
  0x379ee88c, # Jul 28 1999 11:25
  0x37a877e4, # Aug  4 1999 17:27
  0x37b15990, # Aug 11 1999 11:08
  0x37bb6214, # Aug 19 1999 01:47
  0x37c5d230, # Aug 26 1999 23:48
  0x37cef75c, # Sep  2 1999 22:17
  0x37d82e58, # Sep  9 1999 22:02
  0x37e29f28, # Sep 17 1999 20:06
  0x37eca914, # Sep 25 1999 10:51
  0x37f583b8, # Oct  2 1999 04:02
  0x37ff2828, # Oct  9 1999 11:34
  0x3809e470, # Oct 17 1999 15:00
  0x381373c8, # Oct 24 1999 21:02
  0x381c3030, # Oct 31 1999 12:04
  0x3826491c, # Nov  8 1999 03:53
  0x38311dc4, # Nov 16 1999 09:03
  0x383a3c60, # Nov 23 1999 07:04
  0x384309e4, # Nov 29 1999 23:19
  0x384d8ae0, # Dec  7 1999 22:32
  0x38583738, # Dec 16 1999 00:50
  0x38610ad4, # Dec 22 1999 17:31
  0x386a14d0, # Dec 29 1999 14:04
  0x3874db68, # Jan  6 2000 18:14
  0x387f25c8, # Jan 14 2000 13:34
  0x3887e320, # Jan 21 2000 04:40
  0x38914bcc, # Jan 28 2000 07:57
  0x389c1f84, # Feb  5 2000 13:03
  0x38a5eadc, # Feb 12 2000 23:21
  0x38aec454, # Feb 19 2000 16:27
  0x38b89fd8, # Feb 27 2000 03:54
  0x38c33f4c, # Mar  6 2000 05:17
  0x38cc91b4, # Mar 13 2000 06:59
  0x38d5ac90, # Mar 20 2000 04:44
  0x38dffaec, # Mar 28 2000 00:21
  0x38ea3070, # Apr  4 2000 18:12
  0x38f328d8, # Apr 11 2000 13:30
  0x38fc9e68, # Apr 18 2000 17:42
  0x390743b8, # Apr 26 2000 19:30
  0x3910f890, # May  4 2000 04:12
  0x3919bffc, # May 10 2000 20:01
  0x39239ce8, # May 18 2000 07:34
  0x392e6614, # May 26 2000 11:55
  0x3937a508, # Jun  2 2000 12:14
  0x3940647c, # Jun  9 2000 03:29
  0x394aa9b4, # Jun 16 2000 22:27
  0x39555990, # Jun 25 2000 01:00
  0x395e4460, # Jul  1 2000 19:20
  0x3967242c, # Jul  8 2000 12:53
  0x3971beb4, # Jul 16 2000 13:55
  0x397c2228, # Jul 24 2000 11:02
  0x3984e37c, # Jul 31 2000 02:25
  0x398e0a88, # Aug  7 2000 01:02
  0x3998d15c, # Aug 15 2000 05:13
  0x39a2cb94, # Aug 22 2000 18:51
  0x39ab8e14, # Aug 29 2000 10:19
  0x39b51ed4, # Sep  5 2000 16:27
  0x39bfd75c, # Sep 13 2000 19:37
  0x39c96420, # Sep 21 2000 01:28
  0x39d2501c, # Sep 27 2000 19:53
  0x39dc5ef4, # Oct  5 2000 10:59
  0x39e6cd6c, # Oct 13 2000 08:53
  0x39effb44, # Oct 20 2000 07:59
  0x39f93588, # Oct 27 2000 07:58
  0x3a03ba44, # Nov  4 2000 07:27
  0x3a0db6d4, # Nov 11 2000 21:15
  0x3a169f10, # Nov 18 2000 15:24
  0x3a204704, # Nov 25 2000 23:11
  0x3a2b1594, # Dec  4 2000 03:55
  0x3a349844, # Dec 11 2000 09:03
  0x3a3d5d1c, # Dec 18 2000 00:41
  0x3a478238, # Dec 25 2000 17:22
  0x3a5256e0, # Jan  2 2001 22:32
  0x3a5b7360, # Jan  9 2001 20:24
  0x3a643ff4, # Jan 16 2001 12:35
  0x3a6ed374, # Jan 24 2001 13:07
  0x3a796c94, # Feb  1 2001 14:03
  0x3a8246c0, # Feb  8 2001 07:12
  0x3a8b4bd0, # Feb 15 2001 03:24
  0x3a961d6c, # Feb 23 2001 08:21
  0x3aa050d4, # Mar  3 2001 02:03
  0x3aa91174, # Mar  9 2001 17:23
  0x3ab27b4c, # Mar 16 2001 20:45
  0x3abd47fc, # Mar 25 2001 01:21
  0x3ac7079c, # Apr  1 2001 10:49
  0x3acfd958, # Apr  8 2001 03:22
  0x3ad9beb4, # Apr 15 2001 15:31
  0x3ae44988, # Apr 23 2001 15:26
  0x3aed9bf0, # Apr 30 2001 17:08
  0x3af6a8bc, # May  7 2001 13:53
  0x3b0100b4, # May 15 2001 10:11
  0x3b0b2468, # May 23 2001 02:46
  0x3b141dfc, # May 29 2001 22:09
  0x3b1d89b4, # Jun  6 2001 01:39
  0x3b282f40, # Jun 14 2001 03:28
  0x3b31e148, # Jun 21 2001 11:58
  0x3b3aa260, # Jun 28 2001 03:20
  0x3b4481e0, # Jul  5 2001 15:04
  0x3b4f41ac, # Jul 13 2001 18:45
  0x3b588a00, # Jul 20 2001 19:44
  0x3b613d80, # Jul 27 2001 10:08
  0x3b6b8e70, # Aug  4 2001 05:56
  0x3b7635dc, # Aug 12 2001 07:53
  0x3b7f2a84, # Aug 19 2001 02:55
  0x3b880294, # Aug 25 2001 19:55
  0x3b92a7e4, # Sep  2 2001 21:43
  0x3b9d0db0, # Sep 10 2001 19:00
  0x3ba5cff4, # Sep 17 2001 10:27
  0x3baefd54, # Sep 24 2001 09:31
  0x3bb9c5cc, # Oct  2 2001 13:49
  0x3bc3cc70, # Oct 10 2001 04:20
  0x3bcc8914, # Oct 16 2001 19:23
  0x3bd62e38, # Oct 24 2001 02:58
  0x3be0e06c, # Nov  1 2001 05:41
  0x3bea78ac, # Nov  8 2001 12:21
  0x3bf36340, # Nov 15 2001 06:40
  0x3bfd885c, # Nov 22 2001 23:21
  0x3c07f0bc, # Nov 30 2001 20:49
  0x3c111de0, # Dec  7 2001 19:52
  0x3c1a6544, # Dec 14 2001 20:47
  0x3c24f360, # Dec 22 2001 20:56
  0x3c2eef3c, # Dec 30 2001 10:41
  0x3c37ca94, # Jan  6 2002 03:55
  0x3c418b9c, # Jan 13 2002 13:29
  0x3c4c5414, # Jan 21 2002 17:47
  0x3c55d598, # Jan 28 2002 22:50
  0x3c5e8d8c, # Feb  4 2002 13:33
  0x3c68c70c, # Feb 12 2002 07:41
  0x3c739038, # Feb 20 2002 12:02
  0x3c7ca40c, # Feb 27 2002 09:17
  0x3c856fec, # Mar  6 2002 01:25
  0x3c9004d4, # Mar 14 2002 02:03
  0x3c9a96ec, # Mar 22 2002 02:29
  0x3ca35ffc, # Mar 28 2002 18:25
  0x3cac713c, # Apr  4 2002 15:29
  0x3cb7339c, # Apr 12 2002 19:21
  0x3cc16380, # Apr 20 2002 12:48
  0x3cca1430, # Apr 27 2002 03:00
  0x3cd38ab0, # May  4 2002 07:16
  0x3cde47ac, # May 12 2002 10:45
  0x3ce80008, # May 19 2002 19:42
  0x3cf0cc24, # May 26 2002 11:51
  0x3cfab2ac, # Jun  3 2002 00:05
  0x3d053a74, # Jun 10 2002 23:47
  0x3d0e7ecc, # Jun 18 2002 00:29
  0x3d179228, # Jun 24 2002 21:42
  0x3d21e084, # Jul  2 2002 17:19
  0x3d2c0bb8, # Jul 10 2002 10:26
  0x3d34f6c4, # Jul 17 2002 04:47
  0x3d3e6e34, # Jul 24 2002 09:07
  0x3d490bc8, # Aug  1 2002 10:22
  0x3d52c334, # Aug  8 2002 19:15
  0x3d5b7e70, # Aug 15 2002 10:12
  0x3d6565ac, # Aug 22 2002 22:29
  0x3d702a64, # Aug 31 2002 02:31
  0x3d796e08, # Sep  7 2002 03:10
  0x3d822980, # Sep 13 2002 18:08
  0x3d8c7b24, # Sep 21 2002 13:59
  0x3d973244, # Sep 29 2002 17:03
  0x3da01be8, # Oct  6 2002 11:18
  0x3da9058c, # Oct 13 2002 05:33
  0x3db3aaa0, # Oct 21 2002 07:20
  0x3dbe1c60, # Oct 29 2002 05:28
  0x3dc6d9b8, # Nov  4 2002 20:34
  0x3dd01870, # Nov 11 2002 20:52
  0x3ddae688, # Nov 20 2002 01:34
  0x3de4e8b8, # Nov 27 2002 15:46
  0x3dedafe8, # Dec  4 2002 07:34
  0x3df75e6c, # Dec 11 2002 15:49
  0x3e021988, # Dec 19 2002 19:10
  0x3e0b9f44, # Dec 27 2002 00:31
  0x3e149fa4, # Jan  2 2003 20:23
  0x3e1ec754, # Jan 10 2003 13:15
  0x3e2930e0, # Jan 18 2003 10:48
  0x3e324bbc, # Jan 25 2003 08:33
  0x3e3ba5e0, # Feb  1 2003 10:48
  0x3e463744, # Feb  9 2003 11:11
  0x3e5023e4, # Feb 16 2003 23:51
  0x3e58fac8, # Feb 23 2003 16:46
  0x3e62bf54, # Mar  3 2003 02:35
  0x3e6d8cf4, # Mar 11 2003 07:15
  0x3e76f654, # Mar 18 2003 10:35
  0x3e7fb604, # Mar 25 2003 01:51
  0x3e89e624, # Apr  1 2003 19:19
  0x3e94af50, # Apr  9 2003 23:40
  0x3e9db0a0, # Apr 16 2003 19:36
  0x3ea68478, # Apr 23 2003 12:18
  0x3eb10fc4, # May  1 2003 12:15
  0x3ebb969c, # May  9 2003 11:53
  0x3ec45ca0, # May 16 2003 03:36
  0x3ecd6bc4, # May 23 2003 00:31
  0x3ed82d70, # May 31 2003 04:20
  0x3ee24ad0, # Jun  7 2003 20:28
  0x3eeb03f0, # Jun 14 2003 11:16
  0x3ef46f6c, # Jun 21 2003 14:45
  0x3eff3244, # Jun 29 2003 18:39
  0x3f08dba0, # Jul  7 2003 02:32
  0x3f11b11c, # Jul 13 2003 19:21
  0x3f1b8fac, # Jul 21 2003 07:01
  0x3f2619cc, # Jul 29 2003 06:53
  0x3f2f5c80, # Aug  5 2003 07:28
  0x3f387180, # Aug 12 2003 04:48
  0x3f42c540, # Aug 20 2003 00:48
  0x3f4ce9a8, # Aug 27 2003 17:26
  0x3f55dfb8, # Sep  3 2003 12:34
  0x3f5f52f0, # Sep 10 2003 16:36
  0x3f6a0164, # Sep 18 2003 19:03
  0x3f73adcc, # Sep 26 2003 03:09
  0x3f7c77cc, # Oct  2 2003 19:09
  0x3f865f44, # Oct 10 2003 07:27
  0x3f913284, # Oct 18 2003 12:31
  0x3f9a7178, # Oct 25 2003 12:50
  0x3fa3359c, # Nov  1 2003 04:25
  0x3fad949c, # Nov  9 2003 01:13
  0x3fb84b44, # Nov 17 2003 04:15
  0x3fc13bb4, # Nov 23 2003 22:59
  0x3fca25d0, # Nov 30 2003 17:16
  0x3fd4e0ec, # Dec  8 2003 20:37
  0x3fdf43e8, # Dec 16 2003 17:42
  0x3fe80e24, # Dec 23 2003 09:43
  0x3ff14d54, # Dec 30 2003 10:03
  0x3ffc2850, # Jan  7 2004 15:40
  0x40061b08, # Jan 15 2004 04:46
  0x400ee97c, # Jan 21 2004 21:05
  0x4018a214, # Jan 29 2004 06:03
  0x40235484, # Feb  6 2004 08:47
  0x402cd3b0, # Feb 13 2004 13:40
  0x4035d0c8, # Feb 20 2004 09:18
  0x404009d0, # Feb 28 2004 03:24
  0x404a5b38, # Mar  6 2004 23:14
  0x4053768c, # Mar 13 2004 21:01
  0x405cc87c, # Mar 20 2004 22:41
  0x40676430, # Mar 28 2004 23:48
  0x40713ce4, # Apr  5 2004 11:03
  0x407a10f8, # Apr 12 2004 03:46
  0x4083d23c, # Apr 19 2004 13:21
  0x408e9910, # Apr 27 2004 17:32
  0x4097fdfc, # May  4 2004 20:33
  0x40a0b320, # May 11 2004 11:04
  0x40aae7f0, # May 19 2004 04:52
  0x40b59f4c, # May 27 2004 07:57
  0x40bea6f0, # Jun  3 2004 04:20
  0x40c76cb8, # Jun  9 2004 20:02
  0x40d1fe94, # Jun 17 2004 20:27
  0x40dc7810, # Jun 25 2004 19:08
  0x40e5424c, # Jul  2 2004 11:09
  0x40ee4a68, # Jul  9 2004 07:34
  0x40f90c50, # Jul 17 2004 11:24
  0x41032adc, # Jul 25 2004 03:37
  0x410bdf4c, # Jul 31 2004 18:05
  0x4115511c, # Aug  7 2004 22:01
  0x41200cb0, # Aug 16 2004 01:24
  0x4129c2f0, # Aug 23 2004 10:12
  0x41328f48, # Aug 30 2004 02:22
  0x413c7e04, # Sep  6 2004 15:11
  0x4147002c, # Sep 14 2004 14:29
  0x41504e98, # Sep 21 2004 15:54
  0x4159626c, # Sep 28 2004 13:09
  0x4163c4f0, # Oct  6 2004 10:12
  0x416de8e0, # Oct 14 2004 02:48
  0x4176dfa4, # Oct 20 2004 21:59
  0x41806254, # Oct 28 2004 03:07
  0x418b153c, # Nov  5 2004 05:53
  0x4194c834, # Nov 12 2004 14:27
  0x419d8988, # Nov 19 2004 05:50
  0x41a78ce4, # Nov 26 2004 20:07
  0x41b25bec, # Dec  5 2004 00:53
  0x41bb9edc, # Dec 12 2004 01:29
  0x41c45d60, # Dec 18 2004 16:40
  0x41ced358, # Dec 26 2004 15:06
  0x41d984d8, # Jan  3 2005 17:46
  0x41e26ef4, # Jan 10 2005 12:03
  0x41eb61bc, # Jan 17 2005 06:57
  0x41f62020, # Jan 25 2005 10:32
  0x420080c4, # Feb  2 2005 07:27
  0x42093cf0, # Feb  8 2005 22:28
  0x421290c0, # Feb 16 2005 00:16
  0x421d5de8, # Feb 24 2005 04:54
  0x42274b00, # Mar  3 2005 17:36
  0x42300ee8, # Mar 10 2005 09:10
  0x4239d824, # Mar 17 2005 19:19
  0x42447b58, # Mar 25 2005 20:58
  0x424dec38, # Apr  2 2005 00:50
  0x4256ea40, # Apr  8 2005 20:32
  0x4261230c, # Apr 16 2005 14:37
  0x426b6f88, # Apr 24 2005 10:06
  0x42747600, # May  1 2005 06:24
  0x427dd18c, # May  8 2005 08:45
  0x4288605c, # May 16 2005 08:57
  0x42923a78, # May 23 2005 20:18
  0x429afd34, # May 30 2005 11:47
  0x42a4c634, # Jun  6 2005 21:55
  0x42af82b8, # Jun 15 2005 01:22
  0x42b8e588, # Jun 22 2005 04:14
  0x42c19584, # Jun 28 2005 18:23
  0x42cbc838, # Jul  6 2005 12:02
  0x42d682a0, # Jul 14 2005 15:20
  0x42df8030, # Jul 21 2005 11:00
  0x42e84ee0, # Jul 28 2005 03:20
  0x42f2d75c, # Aug  5 2005 03:05
  0x42fd5d44, # Aug 13 2005 02:39
  0x43061c7c, # Aug 19 2005 17:53
  0x430f32a8, # Aug 26 2005 15:18
  0x4319ef2c, # Sep  3 2005 18:45
  0x432416dc, # Sep 11 2005 11:37
  0x432cca5c, # Sep 18 2005 02:01
  0x4336467c, # Sep 25 2005 06:41
  0x434107b0, # Oct  3 2005 10:28
  0x434aba6c, # Oct 10 2005 19:01
  0x43539588, # Oct 17 2005 12:14
  0x435d878c, # Oct 25 2005 01:17
  0x4368156c, # Nov  2 2005 01:25
  0x4371576c, # Nov  9 2005 01:57
  0x437a8418, # Nov 16 2005 00:58
  0x4384e8f4, # Nov 23 2005 22:11
  0x438f102c, # Dec  1 2005 15:01
  0x4397fe80, # Dec  8 2005 09:36
  0x43a196c0, # Dec 15 2005 16:16
  0x43ac51a0, # Dec 23 2005 19:36
  0x43b5f700, # Dec 31 2005 03:12
  0x43bebd40, # Jan  6 2006 18:56
  0x43c8c8d0, # Jan 14 2006 09:48
  0x43d3a138, # Jan 22 2006 15:14
  0x43dccde4, # Jan 29 2006 14:15
  0x43e59b2c, # Feb  5 2006 06:29
  0x43f00e90, # Feb 13 2006 04:44
  0x43fabe6c, # Feb 21 2006 07:17
  0x440399c4, # Feb 28 2006 00:31
  0x440c9880, # Mar  6 2006 20:16
  0x44175324, # Mar 14 2006 23:35
  0x4421a108, # Mar 22 2006 19:10
  0x442a5e24, # Mar 29 2006 10:15
  0x4433b17c, # Apr  5 2006 12:01
  0x443e7ee0, # Apr 13 2006 16:40
  0x44485140, # Apr 21 2006 03:28
  0x44511f00, # Apr 27 2006 19:44
  0x445adedc, # May  5 2006 05:13
  0x446581d4, # May 13 2006 06:51
  0x446edf7c, # May 20 2006 09:21
  0x4477e2e8, # May 27 2006 05:26
  0x448215d8, # Jun  3 2006 23:06
  0x448c5ad4, # Jun 11 2006 18:03
  0x44955e40, # Jun 18 2006 14:08
  0x449eb42c, # Jun 25 2006 16:05
  0x44a947ac, # Jul  3 2006 16:37
  0x44b314a8, # Jul 11 2006 03:02
  0x44bbe13c, # Jul 17 2006 19:13
  0x44c59e84, # Jul 25 2006 04:31
  0x44d06648, # Aug  2 2006 08:46
  0x44d9bec8, # Aug  9 2006 10:54
  0x44e27a04, # Aug 16 2006 01:51
  0x44eca808, # Aug 23 2006 19:10
  0x44f76900, # Aug 31 2006 22:56
  0x450067f8, # Sep  7 2006 18:42
  0x450939b4, # Sep 14 2006 11:15
  0x4513ccbc, # Sep 22 2006 11:45
  0x451e4f20, # Sep 30 2006 11:04
  0x45271b3c, # Oct  7 2006 03:13
  0x45302e98, # Oct 14 2006 00:26
  0x453afe18, # Oct 22 2006 05:14
  0x45451c2c, # Oct 29 2006 21:25
  0x454ddfd8, # Nov  5 2006 12:58
  0x45575d9c, # Nov 12 2006 17:45
  0x45622998, # Nov 20 2006 22:18
  0x456bd72c, # Nov 28 2006 06:29
  0x4574bc5c, # Dec  5 2006 00:25
  0x457ebd60, # Dec 12 2006 14:32
  0x4589421c, # Dec 20 2006 14:01
  0x459287a0, # Dec 27 2006 14:48
  0x459bb62c, # Jan  3 2007 13:57
  0x45a6314c, # Jan 11 2007 12:45
  0x45b0427c, # Jan 19 2007 04:01
  0x45b936ac, # Jan 25 2007 23:01
  0x45c2cfdc, # Feb  2 2007 05:45
  0x45cd9584, # Feb 10 2007 09:51
  0x45d729c8, # Feb 17 2007 16:14
  0x45dfef90, # Feb 24 2007 07:56
  0x45ea01ec, # Mar  3 2007 23:17
  0x45f4ced8, # Mar 12 2007 03:54
  0x45fdf8b4, # Mar 19 2007 02:43
  0x4606bc60, # Mar 25 2007 18:16
  0x46113a14, # Apr  2 2007 17:15
  0x461bd190, # Apr 10 2007 18:04
  0x4624b120, # Apr 17 2007 11:36
  0x462da514, # Apr 24 2007 06:35
  0x4638633c, # May  2 2007 10:09
  0x46429f14, # May 10 2007 04:27
  0x464b5b04, # May 16 2007 19:27
  0x4654abc8, # May 23 2007 21:02
  0x465f7080, # Jun  1 2007 01:04
  0x466940c4, # Jun  8 2007 11:43
  0x467203bc, # Jun 15 2007 03:13
  0x467bcb54, # Jun 22 2007 13:15
  0x46865f4c, # Jun 30 2007 13:49
  0x468fc528, # Jul  7 2007 16:54
  0x4698bbb0, # Jul 14 2007 12:04
  0x46a2f92c, # Jul 22 2007 06:29
  0x46ad3540, # Jul 30 2007 00:48
  0x46b63f00, # Aug  5 2007 21:20
  0x46bf9168, # Aug 12 2007 23:02
  0x46ca2998, # Aug 20 2007 23:54
  0x46d3fa54, # Aug 28 2007 10:35
  0x46dcc3a0, # Sep  4 2007 02:32
  0x46e68d90, # Sep 11 2007 12:44
  0x46f152c0, # Sep 19 2007 16:48
  0x46fab6bc, # Sep 26 2007 19:45
  0x47036988, # Oct  3 2007 10:06
  0x470dae0c, # Oct 11 2007 05:01
  0x47186bbc, # Oct 19 2007 08:33
  0x47217270, # Oct 26 2007 04:52
  0x472a4288, # Nov  1 2007 21:18
  0x4734e724, # Nov  9 2007 23:03
  0x473f6c1c, # Nov 17 2007 22:33
  0x47483568, # Nov 24 2007 14:30
  0x47515710, # Dec  1 2007 12:44
  0x475c2870, # Dec  9 2007 17:40
  0x47664c9c, # Dec 17 2007 10:17
  0x476f0850, # Dec 24 2007 01:16
  0x47789f64, # Dec 31 2007 07:51
  0x4783605c, # Jan  8 2008 11:37
  0x478d0d78, # Jan 15 2008 19:46
  0x4795f104, # Jan 22 2008 13:35
  0x47a00504, # Jan 30 2008 05:03
  0x47aa7e80, # Feb  7 2008 03:44
  0x47b3b66c, # Feb 14 2008 03:33
  0x47bcf038, # Feb 21 2008 03:30
  0x47c76b58, # Feb 29 2008 02:18
  0x47d177d8, # Mar  7 2008 17:14
  0x47da5768, # Mar 14 2008 10:46
  0x47e40100, # Mar 21 2008 18:40
  0x47eeb8d4, # Mar 29 2008 21:47
  0x47f84994, # Apr  6 2008 03:55
  0x48010020, # Apr 12 2008 18:32
  0x480b19fc, # Apr 20 2008 10:25
  0x4815db30, # Apr 28 2008 14:12
  0x481efaf8, # May  5 2008 12:18
  0x4827bdb4, # May 12 2008 03:47
  0x48323334, # May 20 2008 02:11
  0x483cc9fc, # May 28 2008 02:57
  0x48459a14, # Jun  3 2008 19:23
  0x484e97e0, # Jun 10 2008 15:04
  0x48594618, # Jun 18 2008 17:30
  0x48638718, # Jun 26 2008 12:10
  0x486c3714, # Jul  3 2008 02:19
  0x48759174, # Jul 10 2008 04:35
  0x48804d44, # Jul 18 2008 07:59
  0x488a1e78, # Jul 25 2008 18:42
  0x4892e1ac, # Aug  1 2008 10:13
  0x489caa70, # Aug  8 2008 20:20
  0x48a74390, # Aug 16 2008 21:16
  0x48b0a228, # Aug 23 2008 23:50
  0x48b9a648, # Aug 30 2008 19:58
  0x48c3df50, # Sep  7 2008 14:04
  0x48ce271c, # Sep 15 2008 09:13
  0x48d72740, # Sep 22 2008 05:04
  0x48e08dd0, # Sep 29 2008 08:12
  0x48eb2600, # Oct  7 2008 09:04
  0x48f4fab8, # Oct 14 2008 20:02
  0x48fdc314, # Oct 21 2008 11:55
  0x49079cb8, # Oct 28 2008 23:14
  0x49126c74, # Nov  6 2008 04:03
  0x491bc65c, # Nov 13 2008 06:17
  0x49248594, # Nov 19 2008 21:31
  0x492ed0e4, # Nov 27 2008 16:55
  0x49399c68, # Dec  5 2008 21:26
  0x4942932c, # Dec 12 2008 16:37
  0x494b776c, # Dec 19 2008 10:29
  0x49561de8, # Dec 27 2008 12:22
  0x4960a3d0, # Jan  4 2009 11:56
  0x49696704, # Jan 11 2009 03:27
  0x497297e8, # Jan 18 2009 02:46
  0x497d6c54, # Jan 26 2009 07:55
  0x49877dfc, # Feb  2 2009 23:13
  0x4990425c, # Feb  9 2009 14:49
  0x4999dc7c, # Feb 16 2009 21:37
  0x49a4a044, # Feb 25 2009 01:35
  0x49ae31b8, # Mar  4 2009 07:46
  0x49b72408, # Mar 11 2009 02:38
  0x49c13394, # Mar 18 2009 17:47
  0x49cba7e8, # Mar 26 2009 16:06
  0x49d4ccd8, # Apr  2 2009 14:34
  0x49de0c80, # Apr  9 2009 14:56
  0x49e885c0, # Apr 17 2009 13:36
  0x49f28214, # Apr 25 2009 03:23
  0x49fb5f10, # May  1 2009 20:44
  0x4a04fffc, # May  9 2009 04:01
  0x4a0fbc08, # May 17 2009 07:26
  0x4a193954, # May 24 2009 12:11
  0x4a21f7d8, # May 31 2009 03:22
  0x4a2c02f0, # Jun  7 2009 18:12
  0x4a36c7e4, # Jun 15 2009 22:15
  0x4a3fdce4, # Jun 22 2009 19:35
  0x4a48a540, # Jun 29 2009 11:28
  0x4a53137c, # Jul  7 2009 09:21
  0x4a5da6fc, # Jul 15 2009 09:53
  0x4a667ad4, # Jul 22 2009 02:35
  0x4a6f74e0, # Jul 28 2009 22:00
  0x4a7a29e4, # Aug  6 2009 00:55
  0x4a846184, # Aug 13 2009 18:55
  0x4a8d1f18, # Aug 20 2009 10:02
  0x4a967108, # Aug 27 2009 11:42
  0x4aa13a34, # Sep  4 2009 16:03
  0x4aab0460, # Sep 12 2009 02:16
  0x4ab3d4f0, # Sep 18 2009 18:44
  0x4abd9d78, # Sep 26 2009 04:50
  0x4ac83c38, # Oct  4 2009 06:10
  0x4ad19da0, # Oct 11 2009 08:56
  0x4adaa88c, # Oct 18 2009 05:33
  0x4ae4f058, # Oct 26 2009 00:42
  0x4aef2f78, # Nov  2 2009 19:14
  0x4af83b90, # Nov  9 2009 15:56
  0x4b01a478, # Nov 16 2009 19:14
  0x4b0c5274, # Nov 24 2009 21:39
  0x4b161778, # Dec  2 2009 07:30
  0x4b1eeb8c, # Dec  9 2009 00:13
  0x4b28cc38, # Dec 16 2009 12:02
  0x4b33a680, # Dec 24 2009 17:36
  0x4b3cf7bc, # Dec 31 2009 19:13
  0x4b45b9c4, # Jan  7 2010 10:39
  0x4b501504, # Jan 15 2010 07:11
  0x4b5ad50c, # Jan 23 2010 10:53
  0x4b63cf18, # Jan 30 2010 06:18
  0x4b6cae30, # Feb  5 2010 23:48
  0x4b776514, # Feb 14 2010 02:51
  0x4b81d2d8, # Feb 22 2010 00:42
  0x4b8a9be8, # Feb 28 2010 16:38
  0x4b93c948, # Mar  7 2010 15:42
  0x4b9ea00c, # Mar 15 2010 21:01
  0x4ba89f30, # Mar 23 2010 11:00
  0x4bb160fc, # Mar 30 2010 02:25
  0x4bbb00bc, # Apr  6 2010 09:37
  0x4bc5b50c, # Apr 14 2010 12:29
  0x4bcf41d0, # Apr 21 2010 18:20
  0x4bd82778, # Apr 28 2010 12:18
  0x4be24244, # May  6 2010 04:15
  0x4beca180, # May 14 2010 01:04
  0x4bf5c904, # May 20 2010 23:43
  0x4bfefb14, # May 27 2010 23:07
  0x4c097a6c, # Jun  4 2010 22:13
  0x4c136c34, # Jun 12 2010 11:15
  0x4c1c478c, # Jun 19 2010 04:29
  0x4c25e4b8, # Jun 26 2010 11:30
  0x4c309c14, # Jul  4 2010 14:35
  0x4c3a1e10, # Jul 11 2010 19:40
  0x4c42d2f8, # Jul 18 2010 10:10
  0x4c4ce680, # Jul 26 2010 01:36
  0x4c57a214, # Aug  3 2010 04:59
  0x4c60c290, # Aug 10 2010 03:08
  0x4c697fe8, # Aug 16 2010 18:14
  0x4c73fbbc, # Aug 24 2010 17:05
  0x4c7e8bb8, # Sep  1 2010 17:22
  0x4c8765a8, # Sep  8 2010 10:30
  0x4c905e88, # Sep 15 2010 05:50
  0x4c9b1b0c, # Sep 23 2010 09:17
  0x4ca55ae0, # Oct  1 2010 03:52
  0x4cae14f0, # Oct  7 2010 18:44
  0x4cb775a4, # Oct 14 2010 21:27
  0x4cc23c00, # Oct 23 2010 01:36
  0x4ccc1388, # Oct 30 2010 12:46
  0x4cd4def0, # Nov  6 2010 04:52
  0x4cdebf24, # Nov 13 2010 16:39
  0x4ce95664, # Nov 21 2010 17:27
  0x4cf2bd30, # Nov 28 2010 20:36
  0x4cfbcd80, # Dec  5 2010 17:36
  0x4d0626a4, # Dec 13 2010 13:59
  0x4d10618c, # Dec 21 2010 08:13
  0x4d1964f8, # Dec 28 2010 04:18
); # end @navyPhases
