#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <stdlib.h>
#include <string.h>

#ifndef sv_sethek
#	define sv_sethek(a, b)  Perl_sv_sethek(aTHX_ a, b)
#endif

static SV * _new(SV *class, HV *hash) {
	dTHX;
	if (SvTYPE(class) != SVt_PV) {
		char *name = HvNAME(SvSTASH(SvRV(class)));
		class = newSVpv(name, strlen(name));
	}
	return sv_bless(newRV_noinc((SV*)hash), gv_stashsv(class, 0));
}

char *substr(const char *input, size_t start, size_t len) {
	dTHX;
	char *ret = (char *)malloc(len - start + 1);
	memcpy(ret, input + start, len - start);
	ret[len - start] = '\0';
	return ret;
}

int find_last(const char *str, const char word) {
	dTHX;
	int lastIndex = -1, i = 0;
	for (i = 0; str[i] != '\0'; i++) {
		if (str[i] == word) {
			lastIndex = i;
		}
	}
	return lastIndex;
}

char *get_ex_method(const char *name) {
	dTHX;
	SV *caller = newSV(0);
	HEK *stash_hek = HvNAME_HEK((HV*)CopSTASH(PL_curcop));
	sv_sethek(caller, stash_hek);
	STRLEN retlen;
	char *callr = SvPV(caller, retlen);
	size_t ex_len = strlen(name) + 2 + retlen + 1;
	char *ex_out = (char *)malloc(ex_len);
	if (!ex_out) croak("Out of memory in get_ex_method");
	snprintf(ex_out, ex_len, "%s::%s", callr, name);
	SvREFCNT_dec(caller);
	return ex_out;
}

char *get_caller(void) {
	dTHX;
	SV *caller = newSV(0);
	HEK *stash_hek = HvNAME_HEK((HV*)CopSTASH(PL_curcop));
	sv_sethek(caller, stash_hek);
	STRLEN retlen;
	char *callr = SvPV(caller, retlen);
	char *ex_out = strdup(callr);
	SvREFCNT_dec(caller);
	return ex_out;
}

void get_class_and_method(SV *cv_name_sv, char **class_out, char **method_out) {
	dTHX;
	STRLEN len;
	char *full = SvPV(cv_name_sv, len);
	int idx = find_last(full, ':');
	if (idx == -1 || idx < 1) {
		*class_out = strdup("");
		*method_out = strdup(full);
		return;
	}
	int sep = idx;
	if (sep > 0 && full[sep-1] == ':') sep--;
	*class_out = substr(full, 0, sep);
	*method_out = substr(full, idx+1, len);
}

HV *get_metadata(const char *class) {
	dTHX;
	size_t meta_len = strlen(class) + 10;
	char *meta = (char *)malloc(meta_len);
	if (!meta) croak("Out of memory in get_metadata");
	snprintf(meta, meta_len, "%s::METADATA", class);
	HV *hv = get_hv(meta, GV_ADD);
	free(meta);
	return hv;
}

void register_attribute(CV *cv, char *name, SV *attr, XSUBADDR_t xsub_addr) {
	SV *newcv = (SV *)CvXSUBANY(cv).any_ptr;
	SV *spec = (SV *)CvXSUBANY(newcv).any_ptr;

	if (!SvROK(attr)) {
		HV *n = newHV();
		hv_store(n, "name", 4, newSVpv(name, strlen(name)), 0);
		attr = newRV_noinc((SV*)newHV());
	} else {
		SV *rv = SvRV(attr);
		if (SvTYPE(rv) != SVt_PVHV || !hv_exists((HV*)rv, "isa", 3)) {
			HV *n = newHV();
			hv_store(n, "name", 4, newSVpv(name, strlen(name)), 0);
			hv_store(n, "isa", 3, newSVsv(attr), 0);
			attr = newRV_noinc((SV*)n);
		} else {
			hv_store((HV*)rv, "name", 4, newSVpv(name, strlen(name)), 0);
		}
	}

	hv_store((HV*)SvRV(spec), name, strlen(name), newSVsv(attr), 0);

	char *ex = get_ex_method(name);
	CV *new_attr_cv = newXS(ex, xsub_addr, __FILE__);
	SvREFCNT_inc(attr);
	CvXSUBANY(new_attr_cv).any_ptr = (void *)attr;
	free(ex);
}

MODULE = Meow  PACKAGE = Meow
PROTOTYPES: ENABLE

SV *
new(pkg, ...)
	SV *pkg
	CODE:
		SV *spec = (SV *)CvXSUBANY(cv).any_ptr;
		HV *args;
		int i;
		if (items > 2) {
			if ((items - 1) % 2 != 0) {
				croak("Odd number of elements in hash assignment");
			}
			args = newHV();
			for (i = 1; i < items; i += 2) {
				STRLEN retlen;
				char *key = SvPV(ST(i), retlen);
				SV *value = newSVsv(ST(i + 1));
				hv_store(args, key, retlen, value, 0);
			}
		} else {
			if (!SvOK(ST(1))) {
				args = newHV();
			} else if (!SvROK(ST(1)) || SvTYPE(SvRV(ST(1))) != SVt_PVHV) {
				croak("Not a hash assignment");
			} else {
				args = (HV*)SvRV(newSVsv(ST(1)));
			}
		}

		HV *right = (HV*)SvRV(spec);
		HE *entry;
		(void)hv_iterinit(right);
		while ((entry = hv_iternext(right))) {
			STRLEN retlen;
			char *key = SvPV(hv_iterkeysv(entry), retlen);
			SV **valp = hv_fetch(args, key, retlen, 0);
			SV *value;
			if (!valp) {
				value = &PL_sv_undef;
			} else{
				value = *valp;
			}
			if (hv_exists(right, key, retlen)) {
				SV **spec_sv = hv_fetch(right, key, retlen, 0);

				if (spec_sv && SvROK(*spec_sv) && SvTYPE(SvRV(*spec_sv)) == SVt_PVHV) {
					HV *spec_hv = (HV*)SvRV(*spec_sv);
					if (!SvOK(value) && hv_exists(spec_hv, "default", 7)) {
						SV **default_sv = hv_fetch(spec_hv, "default", 7, 0);
						if (default_sv) {
							if (SvROK(*default_sv) && SvTYPE(SvRV(*default_sv)) == SVt_PVCV) {
								dSP;
								PUSHMARK(SP);
								XPUSHs(newSVsv(value));
								PUTBACK;
								call_sv(*default_sv, G_SCALAR);
								SPAGAIN;
								value = POPs;
								PUTBACK;
							} else {
								value = newSVsv(*default_sv);
							}
						} else {
							croak("No default value for '%s'", key);
						}
					}

					if (hv_exists(spec_hv, "isa", 3)) {
						SV *sv = *hv_fetch(spec_hv, "isa", 3, 0);
						dSP;
						PUSHMARK(SP);
						XPUSHs(newSVsv(value));
						PUTBACK;
						call_sv(sv, G_SCALAR);
						SPAGAIN;
						value = POPs;
						PUTBACK;
					}
				}
			}
			hv_store(args, key, retlen, value, 0);
		}
		RETVAL = _new(newSVsv(ST(0)), args);
	OUTPUT:
		RETVAL

SV *
rw_attribute(...)
	CODE:
		SV *spe = (SV *)CvXSUBANY(cv).any_ptr;
		SvREFCNT_inc(spe);
		HV *spec = (HV*)SvRV(spe);
		STRLEN retlen;
		SV **name_sv = hv_fetch(spec, "name", 4, 0);
		if (!name_sv) croak("No 'name' in spec");
		char *method = SvPV(*name_sv, retlen);
		SV *val;
		HV *self = (HV*)SvRV(ST(0));
		if (items > 1) {
			if (hv_exists(spec, "isa", 3)) {
				SV *sv = *hv_fetch(spec, "isa", 3, 0);
				dSP;
				PUSHMARK(SP);
				XPUSHs(newSVsv(ST(1)));
				PUTBACK;
				call_sv(sv, G_SCALAR);
				SPAGAIN;
				ST(1) = POPs;
				PUTBACK;
			}
			val = newSVsv(ST(1));
			hv_store(self, method, strlen(method), newSVsv(val), 0);
		} else {
			val = newSVsv(hv_exists(self, method, strlen(method)) ? *hv_fetch(self, method, strlen(method), 0) : NULL);
		}
		RETVAL = val;
	OUTPUT:
		RETVAL

SV *
rw(name, attr)
	char *name
	SV *attr
	CODE:
		register_attribute(cv, name, attr, XS_Meow_rw_attribute);

		RETVAL = newSViv(1);
	OUTPUT:
		RETVAL

SV *
ro_attribute(...)
	CODE:
		if (items > 1) {
			croak("Read only attributes cannot be set");
		}
		SV *spe = (SV *)CvXSUBANY(cv).any_ptr;
		SvREFCNT_inc(spe);
		HV *spec = (HV*)SvRV(spe);
		STRLEN retlen;
		SV **name_sv = hv_fetch(spec, "name", 4, 0);
		if (!name_sv) croak("No 'name' in spec");
		char *method = SvPV(*name_sv, retlen);
		HV *self = (HV*)SvRV(ST(0));
		SV *val = newSVsv(hv_exists(self, method, strlen(method)) ? *hv_fetch(self, method, strlen(method), 0) : NULL);
		RETVAL = val;
	OUTPUT:
		RETVAL

SV *
ro(name, attr)
	char *name
	SV *attr
	CODE:
		register_attribute(cv, name, attr, XS_Meow_ro_attribute);

		RETVAL = newSViv(1);
	OUTPUT:
		RETVAL

SV *
Default(...)
	CODE:
		SV * attr = ST(0);

		if (!SvROK(attr)) {
			HV *n = newHV();
			attr = newRV_noinc((SV*)newHV());
		} else {
			SV *rv = SvRV(attr);
			if (SvTYPE(rv) != SVt_PVHV || !hv_exists((HV*)rv, "isa", 3)) {
				HV *n = newHV();
				hv_store(n, "isa", 3, newSVsv(attr), 0);
				attr = newRV_noinc((SV*)n);
			}
		}

		HV *spec = (HV*)SvRV(attr);
		hv_store(spec, "default", 7, newSVsv(ST(1)), 0);
		SvREFCNT_inc(attr);
		RETVAL = attr;
	OUTPUT:
		RETVAL

void
import(pkg, ...)
	char *pkg
	CODE:
		char *callr = get_caller();
		const char *export[] = { "new", "rw", "ro", "Default" };
		int i;
		CV *newcv = NULL;
		for (i = 0; i < 4; i++) {
			const char *ex = export[i];
			size_t name_len = strlen(callr) + 2 + strlen(ex) + 1;
			char *name = (char *)malloc(name_len);
			if (!name) croak("Out of memory in import");
			snprintf(name, name_len, "%s::%s", callr, ex);
			if (strcmp(ex, "new") == 0) {
				newcv = newXS(name, XS_Meow_new, __FILE__);
				SV *spec = newRV_noinc((SV*)newHV());
				CvXSUBANY(newcv).any_ptr = (void *)spec;
			} else if (strcmp(ex, "rw") == 0) {
				CV *rwcv = newXS(name, XS_Meow_rw, __FILE__);
				CvXSUBANY(rwcv).any_ptr = (void *)newcv;
			} else if (strcmp(ex, "ro") == 0) {
				CV *rwcv = newXS(name, XS_Meow_ro, __FILE__);
				CvXSUBANY(rwcv).any_ptr = (void *)newcv;
			} else if (strcmp(ex, "Default") == 0) {
				CV *default_cv = newXS(name, XS_Meow_Default, __FILE__);
			}
		}
