######################################################################
#
# 2087_cp932_by_cp00930.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x37",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x04"],
        ["\x2D",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x2E",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x06"],
        ["\x2F",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\x16",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x08"],
        ["\x05",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x09"],
        ["\x15",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0A"],
        ["\x0B",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x3C",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x14"],
        ["\x3D",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x32",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x26",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x17"],
        ["\x18",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x3F",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1A"],
        ["\x27",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1B"],
        ["\x1C",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x40",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x20"],
        ["\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x21"],
        ["\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x22"],
        ["\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x23"],
        ["\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x24"],
        ["\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x25"],
        ["\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x28"],
        ["\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x29"],
        ["\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2A"],
        ["\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2B"],
        ["\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2C"],
        ["\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x30"],
        ["\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x31"],
        ["\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x33"],
        ["\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x34"],
        ["\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x35"],
        ["\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x36"],
        ["\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x38"],
        ["\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x39"],
        ["\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3A"],
        ["\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3B"],
        ["\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3E"],
        ["\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x41"],
        ["\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x42"],
        ["\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x43"],
        ["\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x44"],
        ["\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x45"],
        ["\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x46"],
        ["\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x47"],
        ["\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x48"],
        ["\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x49"],
        ["\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x51"],
        ["\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x52"],
        ["\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x53"],
        ["\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x54"],
        ["\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x55"],
        ["\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x56"],
        ["\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x57"],
        ["\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x58"],
        ["\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x07",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\x20",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x80"],
        ["\x21",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x81"],
        ["\x22",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x82"],
        ["\x23",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x83"],
        ["\x24",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x84"],
        ["\x25",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x85"],
        ["\x06",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x86"],
        ["\x17",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x87"],
        ["\x28",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x88"],
        ["\x29",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x89"],
        ["\x2A",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x8A"],
        ["\x2B",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x8B"],
        ["\x2C",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x8C"],
        ["\x09",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x8D"],
        ["\x0A",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x8E"],
        ["\x1B",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x8F"],
        ["\x30",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x90"],
        ["\x31",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x91"],
        ["\x1A",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x92"],
        ["\x33",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x93"],
        ["\x34",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x94"],
        ["\x35",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x95"],
        ["\x36",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x96"],
        ["\x08",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x97"],
        ["\x38",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x98"],
        ["\x39",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x99"],
        ["\x3A",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x9A"],
        ["\x3B",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x9B"],
        ["\x04",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x9C"],
        ["\x14",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x9D"],
        ["\x3E",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x9E"],
        ["\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\x9F"],
        ["\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xA0"],
        ["\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xA1"],
        ["\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xA2"],
        ["\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xA3"],
        ["\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xA4"],
        ["\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xA5"],
        ["\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xA6"],
        ["\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xA7"],
        ["\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xA8"],
        ["\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xA9"],
        ["\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xAA"],
        ["\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xAB"],
        ["\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xAC"],
        ["\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xAD"],
        ["\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xAE"],
        ["\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xAF"],
        ["\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xB0"],
        ["\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xB1"],
        ["\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xB2"],
        ["\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xB3"],
        ["\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xB4"],
        ["\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xB5"],
        ["\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xB6"],
        ["\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xB7"],
        ["\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xB8"],
        ["\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xB9"],
        ["\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xBA"],
        ["\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xBB"],
        ["\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xBC"],
        ["\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xBD"],
        ["\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xBE"],
        ["\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xBF"],
        ["\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xC0"],
        ["\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xC1"],
        ["\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xC2"],
        ["\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xC3"],
        ["\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xC4"],
        ["\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xC5"],
        ["\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xC6"],
        ["\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xC7"],
        ["\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xC8"],
        ["\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xC9"],
        ["\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xCA"],
        ["\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xCB"],
        ["\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xCC"],
        ["\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xCD"],
        ["\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xCE"],
        ["\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xCF"],
        ["\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xD0"],
        ["\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xD1"],
        ["\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xD2"],
        ["\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xD3"],
        ["\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xD4"],
        ["\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xD5"],
        ["\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xD6"],
        ["\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xD7"],
        ["\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xD8"],
        ["\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xD9"],
        ["\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xDA"],
        ["\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xDB"],
        ["\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xDC"],
        ["\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xDD"],
        ["\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xDE"],
        ["\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xDF"],
        ["\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xE0"],
        ["\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xE1"],
        ["\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xE2"],
        ["\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xE3"],
        ["\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xE4"],
        ["\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xE5"],
        ["\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xE6"],
        ["\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xE7"],
        ["\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xE8"],
        ["\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xE9"],
        ["\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEA"],
        ["\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEB"],
        ["\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEC"],
        ["\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xED"],
        ["\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEE"],
        ["\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xEF"],
        ["\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF0"],
        ["\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF1"],
        ["\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF2"],
        ["\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3"],
        ["\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF4"],
        ["\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF5"],
        ["\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF6"],
        ["\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF7"],
        ["\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF8"],
        ["\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF9"],
        ["\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xFA"],
        ["\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xFB"],
        ["\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xFC"],
        ["\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xFD"],
        ["\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xFE"],
        ["\xFF",'cp932','cp00930',{'INPUT_LAYOUT'=>'S'},"\xFF"],
        ["\x40\x40",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x40"],
        ["\x43\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x41"],
        ["\x43\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x42"],
        ["\x42\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x43"],
        ["\x42\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x44"],
        ["\x43\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x45"],
        ["\x42\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x46"],
        ["\x42\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x47"],
        ["\x42\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x48"],
        ["\x42\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x49"],
        ["\x43\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x4A"],
        ["\x43\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x4B"],
        ["\x44\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x4C"],
        ["\x42\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x4D"],
        ["\x44\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x4E"],
        ["\x44\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x4F"],
        ["\x42\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x50"],
        ["\x42\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x51"],
        ["\x43\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x52"],
        ["\x43\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x53"],
        ["\x44\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x54"],
        ["\x44\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x55"],
        ["\x44\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x56"],
        ["\x44\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x57"],
        ["\x44\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x58"],
        ["\x44\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x59"],
        ["\x44\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x5A"],
        ["\x43\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x5B"],
        ["\xDD\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x5C"],
        ["\x44\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x5D"],
        ["\x42\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x5E"],
        ["\x43\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x5F"],
        ["\x43\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x60"],
        ["\xDF\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x61"],
        ["\x42\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x62"],
        ["\x44\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x63"],
        ["\x44\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x64"],
        ["\x44\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x65"],
        ["\x44\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x66"],
        ["\x44\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x67"],
        ["\x44\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x68"],
        ["\x42\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x69"],
        ["\x42\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x6A"],
        ["\x44\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x6B"],
        ["\x44\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x6C"],
        ["\x44\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x6D"],
        ["\x44\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x6E"],
        ["\x42\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x6F"],
        ["\x42\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x70"],
        ["\x44\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x71"],
        ["\x44\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x72"],
        ["\x44\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x73"],
        ["\x44\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x74"],
        ["\x43\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x75"],
        ["\x43\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x76"],
        ["\x44\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x77"],
        ["\x44\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x78"],
        ["\x44\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x79"],
        ["\x44\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x7A"],
        ["\x42\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x7B"],
        ["\xE9\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x7C"],
        ["\x44\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x7D"],
        ["\x44\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x7E"],
        ["\x44\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x80"],
        ["\x42\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x81"],
        ["\x44\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x82"],
        ["\x42\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x83"],
        ["\x42\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x84"],
        ["\x44\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x85"],
        ["\x44\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x86"],
        ["\x44\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x87"],
        ["\x44\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x88"],
        ["\x44\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x89"],
        ["\x44\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x8A"],
        ["\x44\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x8B"],
        ["\x44\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x8C"],
        ["\x44\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x8D"],
        ["\x44\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x8E"],
        ["\x42\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x8F"],
        ["\x42\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x90"],
        ["\x43\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x91"],
        ["\x42\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x92"],
        ["\x42\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x93"],
        ["\x42\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x94"],
        ["\x42\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x95"],
        ["\x42\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x96"],
        ["\x42\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x97"],
        ["\x44\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x98"],
        ["\x44\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x99"],
        ["\x44\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x9A"],
        ["\x44\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x9B"],
        ["\x44\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x9C"],
        ["\x44\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x9D"],
        ["\x44\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x9E"],
        ["\x44\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\x9F"],
        ["\x44\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xA0"],
        ["\x44\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xA1"],
        ["\x44\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xA2"],
        ["\x44\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xA3"],
        ["\x44\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xA4"],
        ["\x44\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xA5"],
        ["\x44\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xA6"],
        ["\x44\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xA7"],
        ["\x44\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xA8"],
        ["\x44\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xA9"],
        ["\x44\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xAA"],
        ["\x44\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xAB"],
        ["\x44\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x43\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xB8"],
        ["\x43\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xB9"],
        ["\x43\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xBA"],
        ["\x43\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xBB"],
        ["\x43\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xBC"],
        ["\x43\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xBD"],
        ["\x43\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xBE"],
        ["\x43\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xBF"],
        ["\x43\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xC8"],
        ["\x43\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xC9"],
        ["\x42\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xCA"],
        ["\x43\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xCB"],
        ["\x43\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xCC"],
        ["\x43\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xCD"],
        ["\x43\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xCE"],
        ["\x43\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xDA"],
        ["\x43\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xDB"],
        ["\x43\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xDC"],
        ["\x43\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xDD"],
        ["\x43\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xDE"],
        ["\x43\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xDF"],
        ["\x43\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xE0"],
        ["\x43\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xE1"],
        ["\x43\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xE2"],
        ["\x43\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xE3"],
        ["\x43\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xE4"],
        ["\x43\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xE5"],
        ["\x44\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xE6"],
        ["\x43\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xE7"],
        ["\x43\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xE8"],
        ["\x43\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xF0"],
        ["\x43\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xF1"],
        ["\x43\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xF2"],
        ["\x43\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xF3"],
        ["\x43\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xF4"],
        ["\x43\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xF5"],
        ["\x43\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xF6"],
        ["\x43\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xF7"],
        ["\x43\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x81\xFC"],
        ["\x42\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x4F"],
        ["\x42\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x50"],
        ["\x42\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x51"],
        ["\x42\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x52"],
        ["\x42\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x53"],
        ["\x42\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x54"],
        ["\x42\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x55"],
        ["\x42\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x56"],
        ["\x42\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x57"],
        ["\x42\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x58"],
        ["\x42\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x60"],
        ["\x42\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x61"],
        ["\x42\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x62"],
        ["\x42\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x63"],
        ["\x42\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x64"],
        ["\x42\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x65"],
        ["\x42\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x66"],
        ["\x42\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x67"],
        ["\x42\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x68"],
        ["\x42\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x69"],
        ["\x42\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x6A"],
        ["\x42\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x6B"],
        ["\x42\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x6C"],
        ["\x42\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x6D"],
        ["\x42\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x6E"],
        ["\x42\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x6F"],
        ["\x42\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x70"],
        ["\x42\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x71"],
        ["\x42\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x72"],
        ["\x42\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x73"],
        ["\x42\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x74"],
        ["\x42\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x75"],
        ["\x42\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x76"],
        ["\x42\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x77"],
        ["\x42\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x78"],
        ["\x42\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x79"],
        ["\x42\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x81"],
        ["\x42\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x82"],
        ["\x42\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x83"],
        ["\x42\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x84"],
        ["\x42\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x85"],
        ["\x42\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x86"],
        ["\x42\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x87"],
        ["\x42\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x88"],
        ["\x42\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x89"],
        ["\x42\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x8A"],
        ["\x42\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x8B"],
        ["\x42\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x8C"],
        ["\x42\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x8D"],
        ["\x42\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x8E"],
        ["\x42\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x8F"],
        ["\x42\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x90"],
        ["\x42\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x91"],
        ["\x42\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x92"],
        ["\x42\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x93"],
        ["\x42\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x94"],
        ["\x42\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x95"],
        ["\x42\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x96"],
        ["\x42\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x97"],
        ["\x42\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x98"],
        ["\x42\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x99"],
        ["\x42\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x9A"],
        ["\x44\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\x9F"],
        ["\x44\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xA0"],
        ["\x44\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xA1"],
        ["\x44\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xA2"],
        ["\x44\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xA3"],
        ["\x44\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xA4"],
        ["\x44\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xA5"],
        ["\x44\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xA6"],
        ["\x44\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xA7"],
        ["\x44\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xA8"],
        ["\x44\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xA9"],
        ["\x44\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xAA"],
        ["\x44\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xAB"],
        ["\x44\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xAC"],
        ["\x44\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xAD"],
        ["\x44\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xAE"],
        ["\x44\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xAF"],
        ["\x44\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xB0"],
        ["\x44\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xB1"],
        ["\x44\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xB2"],
        ["\x44\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xB3"],
        ["\x44\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xB4"],
        ["\x44\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xB5"],
        ["\x44\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xB6"],
        ["\x44\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xB7"],
        ["\x44\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xB8"],
        ["\x44\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xB9"],
        ["\x44\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xBA"],
        ["\x44\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xBB"],
        ["\x44\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xBC"],
        ["\x44\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xBD"],
        ["\x44\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xBE"],
        ["\x44\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xBF"],
        ["\x44\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xC0"],
        ["\x44\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xC1"],
        ["\x44\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xC2"],
        ["\x44\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xC3"],
        ["\x44\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xC4"],
        ["\x44\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xC5"],
        ["\x44\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xC6"],
        ["\x44\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xC7"],
        ["\x44\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xC8"],
        ["\x44\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xC9"],
        ["\x44\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xCA"],
        ["\x44\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xCB"],
        ["\x44\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xCC"],
        ["\x44\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xCD"],
        ["\x44\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xCE"],
        ["\x44\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xCF"],
        ["\x44\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xD0"],
        ["\x44\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xD1"],
        ["\x44\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xD2"],
        ["\x44\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xD3"],
        ["\x44\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xD4"],
        ["\x44\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xD5"],
        ["\x44\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xD6"],
        ["\x44\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xD7"],
        ["\x44\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xD8"],
        ["\x44\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xD9"],
        ["\x44\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xDA"],
        ["\x44\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xDB"],
        ["\x44\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xDC"],
        ["\x44\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xDD"],
        ["\x44\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xDE"],
        ["\x44\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xDF"],
        ["\x44\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xE0"],
        ["\x44\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xE1"],
        ["\x44\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xE2"],
        ["\x44\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xE3"],
        ["\x44\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xE4"],
        ["\x44\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xE5"],
        ["\x44\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xE6"],
        ["\x44\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xE7"],
        ["\x44\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xE8"],
        ["\x44\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xE9"],
        ["\x44\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xEA"],
        ["\x44\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xEB"],
        ["\x44\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xEC"],
        ["\x44\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xED"],
        ["\x44\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xEE"],
        ["\x44\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xEF"],
        ["\x44\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xF0"],
        ["\x44\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x82\xF1"],
        ["\x43\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x40"],
        ["\x43\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x41"],
        ["\x43\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x42"],
        ["\x43\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x43"],
        ["\x43\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x44"],
        ["\x43\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x45"],
        ["\x43\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x46"],
        ["\x43\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x47"],
        ["\x43\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x48"],
        ["\x43\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x49"],
        ["\x43\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x4A"],
        ["\x43\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x4B"],
        ["\x43\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x4C"],
        ["\x43\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x4D"],
        ["\x43\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x4E"],
        ["\x43\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x4F"],
        ["\x43\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x50"],
        ["\x43\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x51"],
        ["\x43\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x52"],
        ["\x43\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x53"],
        ["\x43\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x54"],
        ["\x43\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x55"],
        ["\x43\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x56"],
        ["\x43\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x57"],
        ["\x43\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x58"],
        ["\x43\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x59"],
        ["\x43\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x5A"],
        ["\x43\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x5B"],
        ["\x43\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x5C"],
        ["\x43\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x5D"],
        ["\x43\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x5E"],
        ["\x43\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x5F"],
        ["\x43\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x60"],
        ["\x43\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x61"],
        ["\x43\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x62"],
        ["\x43\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x63"],
        ["\x43\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x64"],
        ["\x43\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x65"],
        ["\x43\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x66"],
        ["\x43\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x67"],
        ["\x43\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x68"],
        ["\x43\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x69"],
        ["\x43\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x6A"],
        ["\x43\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x6B"],
        ["\x43\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x6C"],
        ["\x43\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x6D"],
        ["\x43\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x6E"],
        ["\x43\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x6F"],
        ["\x43\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x70"],
        ["\x43\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x71"],
        ["\x43\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x72"],
        ["\x43\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x73"],
        ["\x43\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x74"],
        ["\x43\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x75"],
        ["\x43\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x76"],
        ["\x43\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x77"],
        ["\x43\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x78"],
        ["\x43\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x79"],
        ["\x43\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x7A"],
        ["\x43\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x7B"],
        ["\x43\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x7C"],
        ["\x43\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x7D"],
        ["\x43\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x7E"],
        ["\x43\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x80"],
        ["\x43\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x81"],
        ["\x43\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x82"],
        ["\x43\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x83"],
        ["\x43\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x84"],
        ["\x43\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x85"],
        ["\x43\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x86"],
        ["\x43\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x87"],
        ["\x43\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x88"],
        ["\x43\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x89"],
        ["\x43\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x8A"],
        ["\x43\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x8B"],
        ["\x43\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x8C"],
        ["\x43\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x8D"],
        ["\x43\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x8E"],
        ["\x43\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x8F"],
        ["\x43\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x90"],
        ["\x43\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x91"],
        ["\x43\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x92"],
        ["\x43\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x93"],
        ["\x43\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x94"],
        ["\x43\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x95"],
        ["\x43\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x96"],
        ["\x41\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\x9F"],
        ["\x41\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xA0"],
        ["\x41\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xA1"],
        ["\x41\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xA2"],
        ["\x41\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xA3"],
        ["\x41\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xA4"],
        ["\x41\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xA5"],
        ["\x41\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xA6"],
        ["\x41\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xA7"],
        ["\x41\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xA8"],
        ["\x41\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xA9"],
        ["\x41\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xAA"],
        ["\x41\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xAB"],
        ["\x41\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xAC"],
        ["\x41\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xAD"],
        ["\x41\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xAE"],
        ["\x41\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xAF"],
        ["\x41\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xB0"],
        ["\x41\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xB1"],
        ["\x41\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xB2"],
        ["\x41\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xB3"],
        ["\x41\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xB4"],
        ["\x41\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xB5"],
        ["\x41\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xB6"],
        ["\x41\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xBF"],
        ["\x41\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xC0"],
        ["\x41\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xC1"],
        ["\x41\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xC2"],
        ["\x41\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xC3"],
        ["\x41\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xC4"],
        ["\x41\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xC5"],
        ["\x41\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xC6"],
        ["\x41\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xC7"],
        ["\x41\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xC8"],
        ["\x41\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xC9"],
        ["\x41\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xCA"],
        ["\x41\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xCB"],
        ["\x41\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xCC"],
        ["\x41\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xCD"],
        ["\x41\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xCE"],
        ["\x41\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xCF"],
        ["\x41\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xD0"],
        ["\x41\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xD1"],
        ["\x41\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xD2"],
        ["\x41\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xD3"],
        ["\x41\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xD4"],
        ["\x41\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xD5"],
        ["\x41\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x83\xD6"],
        ["\x41\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x40"],
        ["\x41\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x41"],
        ["\x41\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x42"],
        ["\x41\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x43"],
        ["\x41\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x44"],
        ["\x41\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x45"],
        ["\x41\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x46"],
        ["\x41\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x47"],
        ["\x41\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x48"],
        ["\x41\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x49"],
        ["\x41\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x4A"],
        ["\x41\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x4B"],
        ["\x41\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x4C"],
        ["\x41\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x4D"],
        ["\x41\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x4E"],
        ["\x41\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x4F"],
        ["\x41\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x50"],
        ["\x41\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x51"],
        ["\x41\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x52"],
        ["\x41\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x53"],
        ["\x41\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x54"],
        ["\x41\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x55"],
        ["\x41\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x56"],
        ["\x41\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x57"],
        ["\x41\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x58"],
        ["\x41\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x59"],
        ["\x41\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x5A"],
        ["\x41\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x5B"],
        ["\x41\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x5C"],
        ["\x41\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x5D"],
        ["\x41\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x5E"],
        ["\x41\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x5F"],
        ["\x41\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x60"],
        ["\x41\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x70"],
        ["\x41\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x71"],
        ["\x41\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x72"],
        ["\x41\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x73"],
        ["\x41\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x74"],
        ["\x41\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x75"],
        ["\x41\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x76"],
        ["\x41\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x77"],
        ["\x41\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x78"],
        ["\x41\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x79"],
        ["\x41\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x7A"],
        ["\x41\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x7B"],
        ["\x41\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x7C"],
        ["\x41\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x7D"],
        ["\x41\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x7E"],
        ["\x41\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x80"],
        ["\x41\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x81"],
        ["\x41\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x82"],
        ["\x41\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x83"],
        ["\x41\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x84"],
        ["\x41\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x85"],
        ["\x41\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x86"],
        ["\x41\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x87"],
        ["\x41\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x88"],
        ["\x41\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x89"],
        ["\x41\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x8A"],
        ["\x41\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x8B"],
        ["\x41\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x8C"],
        ["\x41\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x8D"],
        ["\x41\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x8E"],
        ["\x41\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x8F"],
        ["\x41\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x90"],
        ["\x41\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x91"],
        ["\x43\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\x9F"],
        ["\x43\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xA0"],
        ["\x43\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xA1"],
        ["\x43\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xA2"],
        ["\x43\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xA3"],
        ["\x43\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xA4"],
        ["\x43\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xA5"],
        ["\x43\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xA6"],
        ["\x43\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xA7"],
        ["\x43\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xA8"],
        ["\x43\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xA9"],
        ["\x43\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xAA"],
        ["\x43\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xAB"],
        ["\x43\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xAC"],
        ["\x43\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xAD"],
        ["\x43\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xAE"],
        ["\x43\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xAF"],
        ["\x43\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xB0"],
        ["\x43\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xB1"],
        ["\x43\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xB2"],
        ["\x43\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xB3"],
        ["\x43\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xB4"],
        ["\x43\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xB5"],
        ["\x43\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xB6"],
        ["\x43\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xB7"],
        ["\x43\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xB8"],
        ["\x43\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xB9"],
        ["\x43\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xBA"],
        ["\x43\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xBB"],
        ["\x43\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xBC"],
        ["\x43\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xBD"],
        ["\x43\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x84\xBE"],
        ["\xE2\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x40"],
        ["\xE2\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x41"],
        ["\xE2\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x42"],
        ["\xE2\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x43"],
        ["\xE2\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x44"],
        ["\xE2\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x45"],
        ["\xE2\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x46"],
        ["\xE2\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x47"],
        ["\xE2\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x48"],
        ["\xE2\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x49"],
        ["\xE2\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x4A"],
        ["\xE2\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x4B"],
        ["\xE2\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x4C"],
        ["\xE2\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x4D"],
        ["\xE2\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x4E"],
        ["\xE2\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x4F"],
        ["\xE2\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x50"],
        ["\xE2\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x51"],
        ["\xE2\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x52"],
        ["\xE2\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x53"],
        ["\x41\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x54"],
        ["\x41\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x55"],
        ["\x41\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x56"],
        ["\x41\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x57"],
        ["\x41\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x58"],
        ["\x41\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x59"],
        ["\x41\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x5A"],
        ["\x41\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x5B"],
        ["\x41\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x5C"],
        ["\x41\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x5D"],
        ["\xE8\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x5F"],
        ["\xE8\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x60"],
        ["\xE8\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x61"],
        ["\xE8\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x62"],
        ["\xE8\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x63"],
        ["\xE8\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x64"],
        ["\xE8\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x65"],
        ["\xE8\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x66"],
        ["\xE8\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x67"],
        ["\xE8\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x68"],
        ["\xE8\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x69"],
        ["\xE8\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x6A"],
        ["\xE8\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x6B"],
        ["\xE8\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x6C"],
        ["\xE8\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x6D"],
        ["\xE8\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x6E"],
        ["\xE8\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x6F"],
        ["\xE8\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x70"],
        ["\xE8\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x71"],
        ["\xE8\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x72"],
        ["\xE8\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x73"],
        ["\xE9\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x74"],
        ["\xE8\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x75"],
        ["\xE8\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x7E"],
        ["\xE6\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x80"],
        ["\xE6\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x81"],
        ["\x44\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x82"],
        ["\xE9\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x83"],
        ["\x44\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x84"],
        ["\xE7\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x85"],
        ["\xE7\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x86"],
        ["\xE7\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x87"],
        ["\xE7\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x88"],
        ["\xE7\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x89"],
        ["\x44\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x8A"],
        ["\xE6\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x8B"],
        ["\xE6\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x8C"],
        ["\xE8\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x8D"],
        ["\xE8\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x8E"],
        ["\xE8\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x8F"],
        ["\xDF\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x93"],
        ["\xDF\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x94"],
        ["\xDF\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x98"],
        ["\xE0\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x87\x99"],
        ["\x48\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\x9F"],
        ["\x54\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xA0"],
        ["\x55\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xA1"],
        ["\x46\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xA2"],
        ["\x4E\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xA3"],
        ["\x45\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xA4"],
        ["\x4F\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xA5"],
        ["\x51\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xA6"],
        ["\x4D\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xA7"],
        ["\x50\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xA8"],
        ["\x50\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xA9"],
        ["\x50\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xAA"],
        ["\x49\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xAB"],
        ["\x4D\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xAC"],
        ["\x4E\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xAD"],
        ["\x47\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xAE"],
        ["\x4E\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xAF"],
        ["\x4A\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xB0"],
        ["\x67\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xB1"],
        ["\x50\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xB2"],
        ["\x47\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xB3"],
        ["\x55\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xB4"],
        ["\x4C\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xB5"],
        ["\x50\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xB6"],
        ["\x54\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xB7"],
        ["\x51\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xB8"],
        ["\x52\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xB9"],
        ["\x4E\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xBA"],
        ["\x49\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xBB"],
        ["\x4F\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xBC"],
        ["\x4D\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xBD"],
        ["\x4B\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xBE"],
        ["\x54\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xBF"],
        ["\x45\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xC0"],
        ["\x4E\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xC1"],
        ["\x54\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xC2"],
        ["\x4B\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xC3"],
        ["\x48\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xC4"],
        ["\x53\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xC5"],
        ["\x50\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xC6"],
        ["\x50\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xC7"],
        ["\x46\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xC8"],
        ["\x45\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xC9"],
        ["\x47\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xCA"],
        ["\x4A\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xCB"],
        ["\x4D\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xCC"],
        ["\x4A\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xCD"],
        ["\x51\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xCE"],
        ["\x48\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xCF"],
        ["\x4C\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xD0"],
        ["\x51\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xD1"],
        ["\x4F\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xD2"],
        ["\x47\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xD3"],
        ["\x4F\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xD4"],
        ["\x47\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xD5"],
        ["\x4F\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xD6"],
        ["\x49\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xD7"],
        ["\x55\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xD8"],
        ["\x4A\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xD9"],
        ["\x49\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xDA"],
        ["\x48\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xDB"],
        ["\x4E\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xDC"],
        ["\x4D\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xDD"],
        ["\x54\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xDE"],
        ["\x4A\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xDF"],
        ["\x55\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xE0"],
        ["\x49\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xE1"],
        ["\x4C\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xE2"],
        ["\x4A\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xE3"],
        ["\x45\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xE4"],
        ["\x4F\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xE5"],
        ["\x48\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xE6"],
        ["\x48\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xE7"],
        ["\x49\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xE8"],
        ["\x48\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xE9"],
        ["\x45\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xEA"],
        ["\x4E\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xEB"],
        ["\x52\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xEC"],
        ["\x4A\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xED"],
        ["\x47\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xEE"],
        ["\x47\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xEF"],
        ["\x51\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xF0"],
        ["\x55\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xF1"],
        ["\x4C\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xF2"],
        ["\x47\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xF3"],
        ["\x52\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xF4"],
        ["\x46\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xF5"],
        ["\x4A\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xF6"],
        ["\x52\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xF7"],
        ["\x46\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xF8"],
        ["\x4B\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xF9"],
        ["\x55\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xFA"],
        ["\x4E\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xFB"],
        ["\x4E\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x88\xFC"],
        ["\x49\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x40"],
        ["\x4C\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x41"],
        ["\x4E\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x42"],
        ["\x55\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x43"],
        ["\x55\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x44"],
        ["\x48\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x45"],
        ["\x46\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x46"],
        ["\x50\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x47"],
        ["\x47\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x48"],
        ["\x55\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x49"],
        ["\x49\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x4A"],
        ["\x4C\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x4B"],
        ["\x4B\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x4C"],
        ["\x55\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x4D"],
        ["\x4D\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x4E"],
        ["\x4F\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x4F"],
        ["\x4A\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x50"],
        ["\x51\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x51"],
        ["\x50\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x52"],
        ["\x4C\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x53"],
        ["\x55\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x54"],
        ["\x54\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x55"],
        ["\x54\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x56"],
        ["\x52\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x57"],
        ["\x53\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x58"],
        ["\x46\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x59"],
        ["\x4E\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x5A"],
        ["\x54\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x5B"],
        ["\x52\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x5C"],
        ["\x49\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x5D"],
        ["\x46\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x5E"],
        ["\x4A\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x5F"],
        ["\x51\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x60"],
        ["\x50\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x61"],
        ["\x51\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x62"],
        ["\x48\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x63"],
        ["\x55\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x64"],
        ["\x49\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x65"],
        ["\x47\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x66"],
        ["\x4E\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x67"],
        ["\x45\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x68"],
        ["\x45\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x69"],
        ["\x4F\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x6A"],
        ["\x50\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x6B"],
        ["\x4F\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x6C"],
        ["\x51\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x6D"],
        ["\x52\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x6E"],
        ["\x55\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x6F"],
        ["\x45\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x70"],
        ["\x47\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x71"],
        ["\x51\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x72"],
        ["\x4D\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x73"],
        ["\x4A\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x74"],
        ["\x50\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x75"],
        ["\x47\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x76"],
        ["\x49\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x77"],
        ["\x48\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x78"],
        ["\x54\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x79"],
        ["\x46\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x7A"],
        ["\x51\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x7B"],
        ["\x49\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x7C"],
        ["\x53\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x7D"],
        ["\x46\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x7E"],
        ["\x47\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x80"],
        ["\x50\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x81"],
        ["\x52\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x82"],
        ["\x50\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x83"],
        ["\x47\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x84"],
        ["\x54\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x85"],
        ["\x55\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x86"],
        ["\x4A\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x87"],
        ["\x4E\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x88"],
        ["\x49\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x89"],
        ["\x4D\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x8A"],
        ["\x53\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x8B"],
        ["\x4B\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x8C"],
        ["\x50\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x8D"],
        ["\x4C\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x8E"],
        ["\x4B\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x8F"],
        ["\x4D\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x90"],
        ["\x50\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x91"],
        ["\x4C\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x92"],
        ["\x46\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x93"],
        ["\x49\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x94"],
        ["\x52\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x95"],
        ["\x47\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x96"],
        ["\x4D\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x97"],
        ["\x4E\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x98"],
        ["\x55\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x99"],
        ["\x50\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x9A"],
        ["\x47\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x9B"],
        ["\x46\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x9C"],
        ["\x4C\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x9D"],
        ["\x48\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x9E"],
        ["\x49\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\x9F"],
        ["\x4F\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xA0"],
        ["\x45\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xA1"],
        ["\x4A\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xA2"],
        ["\x54\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xA3"],
        ["\x49\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xA4"],
        ["\x4F\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xA5"],
        ["\x54\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xA6"],
        ["\x67\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xA7"],
        ["\x54\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xA8"],
        ["\x4A\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xA9"],
        ["\x45\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xAA"],
        ["\x47\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xAB"],
        ["\x49\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xAC"],
        ["\x45\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xAD"],
        ["\x45\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xAE"],
        ["\x4E\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xAF"],
        ["\x54\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xB0"],
        ["\x4E\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xB1"],
        ["\x50\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xB2"],
        ["\x4B\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xB3"],
        ["\x4E\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xB4"],
        ["\x4E\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xB5"],
        ["\x4C\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xB6"],
        ["\x49\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xB7"],
        ["\x50\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xB8"],
        ["\x48\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xB9"],
        ["\x45\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xBA"],
        ["\x45\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xBB"],
        ["\x4D\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xBC"],
        ["\x47\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xBD"],
        ["\x54\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xBE"],
        ["\x47\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xBF"],
        ["\x48\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xC0"],
        ["\x45\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xC1"],
        ["\x47\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xC2"],
        ["\x47\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xC3"],
        ["\x49\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xC4"],
        ["\x4E\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xC5"],
        ["\x46\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xC6"],
        ["\x52\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xC7"],
        ["\x48\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xC8"],
        ["\x4F\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xC9"],
        ["\x47\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xCA"],
        ["\x4E\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xCB"],
        ["\x46\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xCC"],
        ["\x46\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xCD"],
        ["\x47\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xCE"],
        ["\x4C\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xCF"],
        ["\x52\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xD0"],
        ["\x54\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xD1"],
        ["\x4D\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xD2"],
        ["\x4F\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xD3"],
        ["\x46\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xD4"],
        ["\x53\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xD5"],
        ["\x54\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xD6"],
        ["\x4B\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xD7"],
        ["\x4B\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xD8"],
        ["\x4C\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xD9"],
        ["\x51\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xDA"],
        ["\x49\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xDB"],
        ["\x52\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xDC"],
        ["\x4A\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xDD"],
        ["\x53\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xDE"],
        ["\x48\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xDF"],
        ["\x4E\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xE0"],
        ["\x4F\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xE1"],
        ["\x54\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xE2"],
        ["\x4F\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xE3"],
        ["\x49\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xE4"],
        ["\x53\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xE5"],
        ["\x46\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xE6"],
        ["\x53\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xE7"],
        ["\x4E\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xE8"],
        ["\x55\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xE9"],
        ["\x46\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xEA"],
        ["\x47\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xEB"],
        ["\x55\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xEC"],
        ["\x53\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xED"],
        ["\x48\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xEE"],
        ["\x45\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xEF"],
        ["\x47\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xF0"],
        ["\x46\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xF1"],
        ["\x50\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xF2"],
        ["\x4E\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xF3"],
        ["\x4B\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xF4"],
        ["\x4C\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xF5"],
        ["\x4E\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xF6"],
        ["\x50\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xF7"],
        ["\x55\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xF8"],
        ["\x4E\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xF9"],
        ["\x4D\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xFA"],
        ["\x53\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xFB"],
        ["\x48\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x89\xFC"],
        ["\x52\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x40"],
        ["\x55\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x41"],
        ["\x46\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x42"],
        ["\x45\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x43"],
        ["\x4A\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x44"],
        ["\x47\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x45"],
        ["\x4A\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x46"],
        ["\x4A\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x47"],
        ["\x4F\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x48"],
        ["\x50\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x49"],
        ["\x46\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x4A"],
        ["\x49\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x4B"],
        ["\x49\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x4C"],
        ["\x51\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x4D"],
        ["\x55\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x4E"],
        ["\x46\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x4F"],
        ["\x53\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x50"],
        ["\x49\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x51"],
        ["\x50\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x52"],
        ["\x52\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x53"],
        ["\x4C\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x54"],
        ["\x4F\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x55"],
        ["\x53\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x56"],
        ["\x4F\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x57"],
        ["\x4B\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x58"],
        ["\x4D\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x59"],
        ["\x54\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x5A"],
        ["\x55\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x5B"],
        ["\x55\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x5C"],
        ["\x4B\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x5D"],
        ["\x55\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x5E"],
        ["\x47\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x5F"],
        ["\x4A\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x60"],
        ["\x62\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x61"],
        ["\x53\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x62"],
        ["\x55\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x63"],
        ["\x55\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x64"],
        ["\x47\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x65"],
        ["\x54\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x66"],
        ["\x48\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x67"],
        ["\x5B\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x68"],
        ["\x47\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x69"],
        ["\x4B\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x6A"],
        ["\x50\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x6B"],
        ["\x4D\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x6C"],
        ["\x48\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x6D"],
        ["\x4F\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x6E"],
        ["\x4A\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x6F"],
        ["\x47\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x70"],
        ["\x53\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x71"],
        ["\x4A\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x72"],
        ["\x51\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x73"],
        ["\x4A\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x74"],
        ["\x50\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x75"],
        ["\x4A\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x76"],
        ["\x45\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x77"],
        ["\x4D\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x78"],
        ["\x47\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x79"],
        ["\x47\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x7A"],
        ["\x54\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x7B"],
        ["\x4A\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x7C"],
        ["\x47\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x7D"],
        ["\x4B\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x7E"],
        ["\x4F\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x80"],
        ["\x49\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x81"],
        ["\x55\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x82"],
        ["\x46\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x83"],
        ["\x47\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x84"],
        ["\x54\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x85"],
        ["\x53\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x86"],
        ["\x4F\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x87"],
        ["\x47\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x88"],
        ["\x54\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x89"],
        ["\x4B\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x8A"],
        ["\x48\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x8B"],
        ["\x54\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x8C"],
        ["\x50\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x8D"],
        ["\x4F\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x8E"],
        ["\x53\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x8F"],
        ["\x4F\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x90"],
        ["\x51\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x91"],
        ["\x4E\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x92"],
        ["\x54\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x93"],
        ["\x48\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x94"],
        ["\x51\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x95"],
        ["\x60\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x96"],
        ["\x49\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x97"],
        ["\x4A\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x98"],
        ["\x49\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x99"],
        ["\x54\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x9A"],
        ["\x4C\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x9B"],
        ["\x52\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x9C"],
        ["\x4B\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x9D"],
        ["\x4F\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x9E"],
        ["\x52\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\x9F"],
        ["\x4B\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xA0"],
        ["\x4E\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xA1"],
        ["\x49\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xA2"],
        ["\x49\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xA3"],
        ["\x4F\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xA4"],
        ["\x4E\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xA5"],
        ["\x4B\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xA6"],
        ["\x4C\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xA7"],
        ["\x4B\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xA8"],
        ["\x4C\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xA9"],
        ["\x48\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xAA"],
        ["\x52\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xAB"],
        ["\x4F\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xAC"],
        ["\x55\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xAD"],
        ["\x48\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xAE"],
        ["\x49\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xAF"],
        ["\x47\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xB0"],
        ["\x4A\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xB1"],
        ["\x48\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xB2"],
        ["\x4D\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xB3"],
        ["\x47\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xB4"],
        ["\x4D\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xB5"],
        ["\x51\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xB6"],
        ["\x49\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xB7"],
        ["\x4F\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xB8"],
        ["\x4E\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xB9"],
        ["\x53\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xBA"],
        ["\x55\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xBB"],
        ["\x4E\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xBC"],
        ["\x4D\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xBD"],
        ["\x4E\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xBE"],
        ["\x4F\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xBF"],
        ["\x54\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xC0"],
        ["\x5D\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xC1"],
        ["\x4A\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xC2"],
        ["\x4B\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xC3"],
        ["\x49\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xC4"],
        ["\x4D\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xC5"],
        ["\x52\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xC6"],
        ["\x46\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xC7"],
        ["\x4B\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xC8"],
        ["\x4C\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xC9"],
        ["\x50\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xCA"],
        ["\x54\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xCB"],
        ["\x4C\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xCC"],
        ["\x4C\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xCD"],
        ["\x51\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xCE"],
        ["\x48\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xCF"],
        ["\x63\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xD0"],
        ["\x49\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xD1"],
        ["\x4D\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xD2"],
        ["\x4E\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xD3"],
        ["\x45\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xD4"],
        ["\x4D\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xD5"],
        ["\x45\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xD6"],
        ["\x4F\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xD7"],
        ["\x4E\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xD8"],
        ["\x48\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xD9"],
        ["\x4C\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xDA"],
        ["\x46\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xDB"],
        ["\x49\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xDC"],
        ["\x47\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xDD"],
        ["\x49\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xDE"],
        ["\x4E\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xDF"],
        ["\x54\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xE0"],
        ["\x49\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xE1"],
        ["\x45\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xE2"],
        ["\x55\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xE3"],
        ["\x55\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xE4"],
        ["\x51\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xE5"],
        ["\x53\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xE6"],
        ["\x48\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xE7"],
        ["\x4C\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xE8"],
        ["\x47\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xE9"],
        ["\x4E\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xEA"],
        ["\x4B\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xEB"],
        ["\x45\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xEC"],
        ["\x45\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xED"],
        ["\x46\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xEE"],
        ["\x4D\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xEF"],
        ["\x4F\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xF0"],
        ["\x49\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xF1"],
        ["\x47\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xF2"],
        ["\x4A\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xF3"],
        ["\x4B\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xF4"],
        ["\x50\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xF5"],
        ["\x4B\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xF6"],
        ["\x4D\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xF7"],
        ["\x4D\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xF8"],
        ["\x4B\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xF9"],
        ["\x46\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xFA"],
        ["\x4E\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xFB"],
        ["\x4E\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8A\xFC"],
        ["\x45\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x40"],
        ["\x49\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x41"],
        ["\x4A\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x42"],
        ["\x45\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x43"],
        ["\x49\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x44"],
        ["\x50\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x45"],
        ["\x4E\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x46"],
        ["\x4A\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x47"],
        ["\x52\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x48"],
        ["\x46\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x49"],
        ["\x55\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x4A"],
        ["\x46\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x4B"],
        ["\x47\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x4C"],
        ["\x48\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x4D"],
        ["\x48\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x4E"],
        ["\x4D\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x4F"],
        ["\x47\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x50"],
        ["\x53\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x51"],
        ["\x50\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x52"],
        ["\x4A\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x53"],
        ["\x47\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x54"],
        ["\x50\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x55"],
        ["\x49\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x56"],
        ["\x53\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x57"],
        ["\x4D\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x58"],
        ["\x4F\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x59"],
        ["\x48\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x5A"],
        ["\x4F\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x5B"],
        ["\x51\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x5C"],
        ["\x4F\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x5D"],
        ["\x4C\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x5E"],
        ["\x51\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x5F"],
        ["\x45\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x60"],
        ["\x51\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x61"],
        ["\x52\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x62"],
        ["\x47\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x63"],
        ["\x55\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x64"],
        ["\x46\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x65"],
        ["\x51\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x66"],
        ["\x45\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x67"],
        ["\x55\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x68"],
        ["\x4D\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x69"],
        ["\x53\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x6A"],
        ["\x4B\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x6B"],
        ["\x4B\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x6C"],
        ["\x52\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x6D"],
        ["\x4A\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x6E"],
        ["\x55\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x6F"],
        ["\x4A\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x70"],
        ["\x4A\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x71"],
        ["\x4D\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x72"],
        ["\x52\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x73"],
        ["\x4B\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x74"],
        ["\x4D\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x75"],
        ["\x45\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x76"],
        ["\x50\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x77"],
        ["\x4A\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x78"],
        ["\x48\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x79"],
        ["\x4B\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x7A"],
        ["\x45\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x7B"],
        ["\x4B\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x7C"],
        ["\x47\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x7D"],
        ["\x4C\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x7E"],
        ["\x50\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x80"],
        ["\x49\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x81"],
        ["\x50\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x82"],
        ["\x4D\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x83"],
        ["\x54\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x84"],
        ["\x48\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x85"],
        ["\x49\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x86"],
        ["\x50\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x87"],
        ["\x51\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x88"],
        ["\x49\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x89"],
        ["\x51\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x8A"],
        ["\x47\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x8B"],
        ["\x4C\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x8C"],
        ["\x49\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x8D"],
        ["\x4A\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x8E"],
        ["\x48\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x8F"],
        ["\x4A\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x90"],
        ["\x4F\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x91"],
        ["\x4D\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x92"],
        ["\x4B\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x93"],
        ["\x52\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x94"],
        ["\x4F\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x95"],
        ["\x4A\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x96"],
        ["\x4D\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x97"],
        ["\x51\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x98"],
        ["\x4B\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x99"],
        ["\x55\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x9A"],
        ["\x48\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x9B"],
        ["\x4B\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x9C"],
        ["\x4B\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x9D"],
        ["\x45\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x9E"],
        ["\x48\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\x9F"],
        ["\x52\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xA0"],
        ["\x55\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xA1"],
        ["\x55\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xA2"],
        ["\x49\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xA3"],
        ["\x47\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xA4"],
        ["\x51\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xA5"],
        ["\x47\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xA6"],
        ["\x4D\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xA7"],
        ["\x53\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xA8"],
        ["\x4D\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xA9"],
        ["\x4C\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xAA"],
        ["\x4A\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xAB"],
        ["\x51\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xAC"],
        ["\x46\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xAD"],
        ["\x53\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xAE"],
        ["\x55\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xAF"],
        ["\x4B\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xB0"],
        ["\x49\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xB1"],
        ["\x55\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xB2"],
        ["\x47\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xB3"],
        ["\x45\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xB4"],
        ["\x4A\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xB5"],
        ["\x4E\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xB6"],
        ["\x4C\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xB7"],
        ["\x51\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xB8"],
        ["\x4B\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xB9"],
        ["\x50\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xBA"],
        ["\x46\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xBB"],
        ["\x55\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xBC"],
        ["\x49\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xBD"],
        ["\x4A\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xBE"],
        ["\x4A\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xBF"],
        ["\x51\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xC0"],
        ["\x4C\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xC1"],
        ["\x4D\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xC2"],
        ["\x4E\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xC3"],
        ["\x68\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xC4"],
        ["\x4C\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xC5"],
        ["\x45\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xC6"],
        ["\x48\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xC7"],
        ["\x49\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xC8"],
        ["\x49\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xC9"],
        ["\x45\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xCA"],
        ["\x49\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xCB"],
        ["\x55\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xCC"],
        ["\x4F\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xCD"],
        ["\x49\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xCE"],
        ["\x49\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xCF"],
        ["\x4A\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xD0"],
        ["\x4B\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xD1"],
        ["\x54\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xD2"],
        ["\x4B\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xD3"],
        ["\x4C\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xD4"],
        ["\x4C\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xD5"],
        ["\x4D\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xD6"],
        ["\x55\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xD7"],
        ["\x4B\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xD8"],
        ["\x4B\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xD9"],
        ["\x4D\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xDA"],
        ["\x4C\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xDB"],
        ["\x4A\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xDC"],
        ["\x54\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xDD"],
        ["\x4D\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xDE"],
        ["\x46\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xDF"],
        ["\x45\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xE0"],
        ["\x50\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xE1"],
        ["\x47\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xE2"],
        ["\x45\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xE3"],
        ["\x4F\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xE4"],
        ["\x4C\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xE5"],
        ["\x45\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xE6"],
        ["\x52\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xE7"],
        ["\x4D\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xE8"],
        ["\x4E\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xE9"],
        ["\x4A\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xEA"],
        ["\x53\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xEB"],
        ["\x4C\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xEC"],
        ["\x4F\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xED"],
        ["\x49\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xEE"],
        ["\x47\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xEF"],
        ["\x52\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xF0"],
        ["\x55\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xF1"],
        ["\x4E\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xF2"],
        ["\x47\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xF3"],
        ["\x50\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xF4"],
        ["\x55\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xF5"],
        ["\x49\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xF6"],
        ["\x4B\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xF7"],
        ["\x4C\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xF8"],
        ["\x4D\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xF9"],
        ["\x4B\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xFA"],
        ["\x54\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xFB"],
        ["\x4D\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8B\xFC"],
        ["\x4D\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x40"],
        ["\x50\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x41"],
        ["\x4F\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x42"],
        ["\x4D\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x43"],
        ["\x52\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x44"],
        ["\x4A\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x45"],
        ["\x46\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x46"],
        ["\x4C\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x47"],
        ["\x4E\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x48"],
        ["\x47\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x49"],
        ["\x4B\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x4A"],
        ["\x48\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x4B"],
        ["\x4F\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x4C"],
        ["\x49\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x4D"],
        ["\x47\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x4E"],
        ["\x49\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x4F"],
        ["\x4B\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x50"],
        ["\x47\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x51"],
        ["\x48\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x52"],
        ["\x49\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x53"],
        ["\x53\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x54"],
        ["\x4F\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x55"],
        ["\x53\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x56"],
        ["\x48\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x57"],
        ["\x4A\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x58"],
        ["\x4C\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x59"],
        ["\x4B\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x5A"],
        ["\x47\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x5B"],
        ["\x49\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x5C"],
        ["\x4C\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x5D"],
        ["\x46\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x5E"],
        ["\x4C\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x5F"],
        ["\x46\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x60"],
        ["\x4E\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x61"],
        ["\x46\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x62"],
        ["\x48\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x63"],
        ["\x4E\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x64"],
        ["\x51\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x65"],
        ["\x4D\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x66"],
        ["\x4E\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x67"],
        ["\x47\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x68"],
        ["\x49\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x69"],
        ["\x49\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x6A"],
        ["\x51\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x6B"],
        ["\x51\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x6C"],
        ["\x4F\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x6D"],
        ["\x48\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x6E"],
        ["\x46\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x6F"],
        ["\x4A\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x70"],
        ["\x53\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x71"],
        ["\x55\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x72"],
        ["\x4E\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x73"],
        ["\x53\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x74"],
        ["\x4D\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x75"],
        ["\x45\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x76"],
        ["\x54\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x77"],
        ["\x4A\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x78"],
        ["\x48\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x79"],
        ["\x66\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x7A"],
        ["\x4D\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x7B"],
        ["\x49\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x7C"],
        ["\x4B\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x7D"],
        ["\x4D\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x7E"],
        ["\x49\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x80"],
        ["\x54\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x81"],
        ["\x4A\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x82"],
        ["\x4B\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x83"],
        ["\x53\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x84"],
        ["\x50\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x85"],
        ["\x4F\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x86"],
        ["\x4C\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x87"],
        ["\x47\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x88"],
        ["\x4A\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x89"],
        ["\x4B\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x8A"],
        ["\x46\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x8B"],
        ["\x4B\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x8C"],
        ["\x54\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x8D"],
        ["\x45\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x8E"],
        ["\x48\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x8F"],
        ["\x52\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x90"],
        ["\x52\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x91"],
        ["\x46\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x92"],
        ["\x48\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x93"],
        ["\x4B\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x94"],
        ["\x4C\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x95"],
        ["\x4F\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x96"],
        ["\x4F\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x97"],
        ["\x4A\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x98"],
        ["\x4E\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x99"],
        ["\x46\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x9A"],
        ["\x47\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x9B"],
        ["\x4D\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x9C"],
        ["\x50\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x9D"],
        ["\x54\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x9E"],
        ["\x48\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\x9F"],
        ["\x48\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xA0"],
        ["\x54\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xA1"],
        ["\x4A\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xA2"],
        ["\x4F\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xA3"],
        ["\x46\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xA4"],
        ["\x53\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xA5"],
        ["\x49\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xA6"],
        ["\x45\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xA7"],
        ["\x4B\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xA8"],
        ["\x45\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xA9"],
        ["\x49\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xAA"],
        ["\x47\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xAB"],
        ["\x4E\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xAC"],
        ["\x4E\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xAD"],
        ["\x4E\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xAE"],
        ["\x4A\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xAF"],
        ["\x4A\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xB0"],
        ["\x48\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xB1"],
        ["\x4C\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xB2"],
        ["\x46\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xB3"],
        ["\x45\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xB4"],
        ["\x4C\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xB5"],
        ["\x50\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xB6"],
        ["\x4E\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xB7"],
        ["\x47\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xB8"],
        ["\x47\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xB9"],
        ["\x4C\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xBA"],
        ["\x46\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xBB"],
        ["\x55\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xBC"],
        ["\x53\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xBD"],
        ["\x47\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xBE"],
        ["\x55\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xBF"],
        ["\x48\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xC0"],
        ["\x54\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xC1"],
        ["\x49\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xC2"],
        ["\x45\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xC3"],
        ["\x4A\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xC4"],
        ["\x4A\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xC5"],
        ["\x53\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xC6"],
        ["\x4E\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xC7"],
        ["\x47\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xC8"],
        ["\x45\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xC9"],
        ["\x53\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xCA"],
        ["\x45\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xCB"],
        ["\x4A\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xCC"],
        ["\x50\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xCD"],
        ["\x4D\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xCE"],
        ["\x51\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xCF"],
        ["\x54\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xD0"],
        ["\x4F\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xD1"],
        ["\x4C\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xD2"],
        ["\x4D\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xD3"],
        ["\x51\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xD4"],
        ["\x4A\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xD5"],
        ["\x4E\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xD6"],
        ["\x55\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xD7"],
        ["\x55\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xD8"],
        ["\x4C\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xD9"],
        ["\x4E\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xDA"],
        ["\x4F\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xDB"],
        ["\x45\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xDC"],
        ["\x4B\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xDD"],
        ["\x4D\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xDE"],
        ["\x45\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xDF"],
        ["\x4A\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xE0"],
        ["\x47\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xE1"],
        ["\x50\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xE2"],
        ["\x45\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xE3"],
        ["\x46\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xE4"],
        ["\x4A\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xE5"],
        ["\x52\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xE6"],
        ["\x55\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xE7"],
        ["\x53\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xE8"],
        ["\x4F\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xE9"],
        ["\x48\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xEA"],
        ["\x4D\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xEB"],
        ["\x49\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xEC"],
        ["\x51\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xED"],
        ["\x4E\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xEE"],
        ["\x4F\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xEF"],
        ["\x47\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xF0"],
        ["\x54\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xF1"],
        ["\x53\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xF2"],
        ["\x4C\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xF3"],
        ["\x53\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xF4"],
        ["\x45\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xF5"],
        ["\x46\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xF6"],
        ["\x48\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xF7"],
        ["\x49\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xF8"],
        ["\x51\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xF9"],
        ["\x49\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xFA"],
        ["\x45\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xFB"],
        ["\x46\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8C\xFC"],
        ["\x51\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x40"],
        ["\x52\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x41"],
        ["\x4E\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x42"],
        ["\x54\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x43"],
        ["\x46\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x44"],
        ["\x4B\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x45"],
        ["\x45\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x46"],
        ["\x46\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x47"],
        ["\x45\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x48"],
        ["\x4C\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x49"],
        ["\x53\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x4A"],
        ["\x45\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x4B"],
        ["\x45\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x4C"],
        ["\x51\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x4D"],
        ["\x46\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x4E"],
        ["\x45\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x4F"],
        ["\x47\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x50"],
        ["\x53\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x51"],
        ["\x4A\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x52"],
        ["\x50\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x53"],
        ["\x4C\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x54"],
        ["\x4B\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x55"],
        ["\x5B\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x56"],
        ["\x48\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x57"],
        ["\x4A\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x58"],
        ["\x50\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x59"],
        ["\x48\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x5A"],
        ["\x52\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x5B"],
        ["\x47\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x5C"],
        ["\x45\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x5D"],
        ["\x4F\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x5E"],
        ["\x46\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x5F"],
        ["\x48\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x60"],
        ["\x4A\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x61"],
        ["\x48\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x62"],
        ["\x4C\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x63"],
        ["\x4A\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x64"],
        ["\x4F\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x65"],
        ["\x51\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x66"],
        ["\x4B\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x67"],
        ["\x4C\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x68"],
        ["\x50\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x69"],
        ["\x48\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x6A"],
        ["\x49\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x6B"],
        ["\x47\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x6C"],
        ["\x50\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x6D"],
        ["\x52\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x6E"],
        ["\x52\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x6F"],
        ["\x51\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x70"],
        ["\x48\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x71"],
        ["\x46\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x72"],
        ["\x45\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x73"],
        ["\x4B\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x74"],
        ["\x4A\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x75"],
        ["\x4A\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x76"],
        ["\x4E\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x77"],
        ["\x50\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x78"],
        ["\x4D\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x79"],
        ["\x48\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x7A"],
        ["\x5F\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x7B"],
        ["\x46\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x7C"],
        ["\x54\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x7D"],
        ["\x49\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x7E"],
        ["\x4A\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x80"],
        ["\x46\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x81"],
        ["\x45\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x82"],
        ["\x4D\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x83"],
        ["\x49\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x84"],
        ["\x54\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x85"],
        ["\x48\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x86"],
        ["\x45\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x87"],
        ["\x55\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x88"],
        ["\x55\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x89"],
        ["\x53\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x8A"],
        ["\x4C\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x8B"],
        ["\x50\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x8C"],
        ["\x52\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x8D"],
        ["\x47\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x8E"],
        ["\x4B\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x8F"],
        ["\x49\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x90"],
        ["\x45\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x91"],
        ["\x4E\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x92"],
        ["\x51\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x93"],
        ["\x50\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x94"],
        ["\x46\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x95"],
        ["\x4E\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x96"],
        ["\x54\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x97"],
        ["\x4B\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x98"],
        ["\x54\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x99"],
        ["\x50\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x9A"],
        ["\x54\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x9B"],
        ["\x4A\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x9C"],
        ["\x50\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x9D"],
        ["\x48\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x9E"],
        ["\x4D\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\x9F"],
        ["\x49\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xA0"],
        ["\x45\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xA1"],
        ["\x4B\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xA2"],
        ["\x53\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xA3"],
        ["\x54\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xA4"],
        ["\x4A\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xA5"],
        ["\x53\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xA6"],
        ["\x4E\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xA7"],
        ["\x54\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xA8"],
        ["\x4F\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xA9"],
        ["\x46\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xAA"],
        ["\x53\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xAB"],
        ["\x4B\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xAC"],
        ["\x53\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xAD"],
        ["\x4C\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xAE"],
        ["\x55\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xAF"],
        ["\x50\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xB0"],
        ["\x55\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xB1"],
        ["\x45\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xB2"],
        ["\x50\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xB3"],
        ["\x51\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xB4"],
        ["\x4E\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xB5"],
        ["\x48\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xB6"],
        ["\x49\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xB7"],
        ["\x47\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xB8"],
        ["\x4E\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xB9"],
        ["\x51\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xBA"],
        ["\x49\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xBB"],
        ["\x51\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xBC"],
        ["\x4D\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xBD"],
        ["\x4F\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xBE"],
        ["\x4E\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xBF"],
        ["\x48\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xC0"],
        ["\x54\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xC1"],
        ["\x4B\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xC2"],
        ["\x4C\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xC3"],
        ["\x48\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xC4"],
        ["\x46\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xC5"],
        ["\x4A\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xC6"],
        ["\x53\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xC7"],
        ["\x49\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xC8"],
        ["\x4E\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xC9"],
        ["\x4D\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xCA"],
        ["\x49\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xCB"],
        ["\x4B\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xCC"],
        ["\x4D\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xCD"],
        ["\x48\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xCE"],
        ["\x47\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xCF"],
        ["\x4C\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xD0"],
        ["\x53\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xD1"],
        ["\x53\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xD2"],
        ["\x4C\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xD3"],
        ["\x54\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xD4"],
        ["\x4C\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xD5"],
        ["\x47\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xD6"],
        ["\x47\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xD7"],
        ["\x4B\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xD8"],
        ["\x49\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xD9"],
        ["\x4D\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xDA"],
        ["\x47\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xDB"],
        ["\x47\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xDC"],
        ["\x47\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xDD"],
        ["\x46\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xDE"],
        ["\x4C\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xDF"],
        ["\x49\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xE0"],
        ["\x50\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xE1"],
        ["\x45\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xE2"],
        ["\x45\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xE3"],
        ["\x4A\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xE4"],
        ["\x4B\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xE5"],
        ["\x54\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xE6"],
        ["\x4C\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xE7"],
        ["\x45\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xE8"],
        ["\x46\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xE9"],
        ["\x52\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xEA"],
        ["\x50\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xEB"],
        ["\x45\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xEC"],
        ["\x4A\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xED"],
        ["\x4F\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xEE"],
        ["\x50\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xEF"],
        ["\x48\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xF0"],
        ["\x4F\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xF1"],
        ["\x51\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xF2"],
        ["\x54\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xF3"],
        ["\x46\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xF4"],
        ["\x4C\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xF5"],
        ["\x50\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xF6"],
        ["\x47\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xF7"],
        ["\x53\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xF8"],
        ["\x49\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xF9"],
        ["\x54\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xFA"],
        ["\x4E\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xFB"],
        ["\x48\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8D\xFC"],
        ["\x4B\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x40"],
        ["\x4F\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x41"],
        ["\x4C\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x42"],
        ["\x4F\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x43"],
        ["\x48\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x44"],
        ["\x49\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x45"],
        ["\x4C\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x46"],
        ["\x4A\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x47"],
        ["\x52\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x48"],
        ["\x4F\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x49"],
        ["\x55\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x4A"],
        ["\x55\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x4B"],
        ["\x4E\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x4C"],
        ["\x4D\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x4D"],
        ["\x54\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x4E"],
        ["\x45\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x4F"],
        ["\x50\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x50"],
        ["\x48\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x51"],
        ["\x45\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x52"],
        ["\x50\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x53"],
        ["\x53\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x54"],
        ["\x4A\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x55"],
        ["\x51\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x56"],
        ["\x54\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x57"],
        ["\x53\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x58"],
        ["\x45\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x59"],
        ["\x48\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x5A"],
        ["\x55\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x5B"],
        ["\x4F\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x5C"],
        ["\x51\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x5D"],
        ["\x4D\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x5E"],
        ["\x48\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x5F"],
        ["\x55\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x60"],
        ["\x4E\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x61"],
        ["\x50\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x62"],
        ["\x49\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x63"],
        ["\x48\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x64"],
        ["\x54\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x65"],
        ["\x50\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x66"],
        ["\x48\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x67"],
        ["\x4B\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x68"],
        ["\x45\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x69"],
        ["\x47\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x6A"],
        ["\x4B\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x6B"],
        ["\x45\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x6C"],
        ["\x46\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x6D"],
        ["\x49\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x6E"],
        ["\x4C\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x6F"],
        ["\x4B\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x70"],
        ["\x45\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x71"],
        ["\x55\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x72"],
        ["\x45\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x73"],
        ["\x4A\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x74"],
        ["\x46\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x75"],
        ["\x46\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x76"],
        ["\x47\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x77"],
        ["\x47\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x78"],
        ["\x4F\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x79"],
        ["\x4E\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x7A"],
        ["\x48\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x7B"],
        ["\x4D\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x7C"],
        ["\x46\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x7D"],
        ["\x48\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x7E"],
        ["\x49\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x80"],
        ["\x48\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x81"],
        ["\x51\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x82"],
        ["\x4F\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x83"],
        ["\x46\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x84"],
        ["\x46\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x85"],
        ["\x46\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x86"],
        ["\x4A\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x87"],
        ["\x53\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x88"],
        ["\x48\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x89"],
        ["\x4A\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x8A"],
        ["\x4A\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x8B"],
        ["\x4E\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x8C"],
        ["\x4C\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x8D"],
        ["\x49\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x8E"],
        ["\x4B\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x8F"],
        ["\x4F\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x90"],
        ["\x46\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x91"],
        ["\x4F\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x92"],
        ["\x52\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x93"],
        ["\x4A\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x94"],
        ["\x4A\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x95"],
        ["\x45\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x96"],
        ["\x4B\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x97"],
        ["\x4F\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x98"],
        ["\x46\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x99"],
        ["\x48\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x9A"],
        ["\x46\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x9B"],
        ["\x4C\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x9C"],
        ["\x46\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x9D"],
        ["\x46\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x9E"],
        ["\x45\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\x9F"],
        ["\x48\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xA0"],
        ["\x45\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xA1"],
        ["\x4C\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xA2"],
        ["\x52\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xA3"],
        ["\x51\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xA4"],
        ["\x4A\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xA5"],
        ["\x48\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xA6"],
        ["\x51\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xA7"],
        ["\x4C\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xA8"],
        ["\x45\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xA9"],
        ["\x4F\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xAA"],
        ["\x4D\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xAB"],
        ["\x50\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xAC"],
        ["\x46\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xAD"],
        ["\x46\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xAE"],
        ["\x4A\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xAF"],
        ["\x50\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xB0"],
        ["\x54\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xB1"],
        ["\x4B\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xB2"],
        ["\x4C\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xB3"],
        ["\x52\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xB4"],
        ["\x45\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xB5"],
        ["\x50\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xB6"],
        ["\x4D\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xB7"],
        ["\x49\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xB8"],
        ["\x53\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xB9"],
        ["\x47\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xBA"],
        ["\x54\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xBB"],
        ["\x4C\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xBC"],
        ["\x4D\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xBD"],
        ["\x51\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xBE"],
        ["\x46\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xBF"],
        ["\x45\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xC0"],
        ["\x52\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xC1"],
        ["\x48\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xC2"],
        ["\x54\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xC3"],
        ["\x47\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xC4"],
        ["\x49\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xC5"],
        ["\x55\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xC6"],
        ["\x62\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xC7"],
        ["\x4F\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xC8"],
        ["\x4C\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xC9"],
        ["\x48\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xCA"],
        ["\x49\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xCB"],
        ["\x4B\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xCC"],
        ["\x51\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xCD"],
        ["\x4B\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xCE"],
        ["\x4C\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xCF"],
        ["\x46\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xD0"],
        ["\x4F\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xD1"],
        ["\x46\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xD2"],
        ["\x4D\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xD3"],
        ["\x46\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xD4"],
        ["\x54\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xD5"],
        ["\x4F\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xD6"],
        ["\x4E\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xD7"],
        ["\x4A\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xD8"],
        ["\x54\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xD9"],
        ["\x4C\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xDA"],
        ["\x54\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xDB"],
        ["\x54\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xDC"],
        ["\x53\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xDD"],
        ["\x52\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xDE"],
        ["\x4D\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xDF"],
        ["\x52\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xE0"],
        ["\x46\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xE1"],
        ["\x4F\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xE2"],
        ["\x4B\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xE3"],
        ["\x54\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xE4"],
        ["\x47\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xE5"],
        ["\x46\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xE6"],
        ["\x46\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xE7"],
        ["\x45\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xE8"],
        ["\x4D\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xE9"],
        ["\x48\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xEA"],
        ["\x4A\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xEB"],
        ["\x4B\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xEC"],
        ["\x46\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xED"],
        ["\x51\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xEE"],
        ["\x4C\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xEF"],
        ["\x47\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xF0"],
        ["\x49\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xF1"],
        ["\x54\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xF2"],
        ["\x48\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xF3"],
        ["\x54\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xF4"],
        ["\x46\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xF5"],
        ["\x4C\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xF6"],
        ["\x46\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xF7"],
        ["\x51\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xF8"],
        ["\x47\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xF9"],
        ["\x50\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xFA"],
        ["\x47\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xFB"],
        ["\x48\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8E\xFC"],
        ["\x47\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x40"],
        ["\x4B\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x41"],
        ["\x47\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x42"],
        ["\x46\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x43"],
        ["\x52\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x44"],
        ["\x4D\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x45"],
        ["\x4B\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x46"],
        ["\x45\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x47"],
        ["\x46\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x48"],
        ["\x49\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x49"],
        ["\x52\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x4A"],
        ["\x4A\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x4B"],
        ["\x4D\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x4C"],
        ["\x4B\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x4D"],
        ["\x4F\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x4E"],
        ["\x4B\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x4F"],
        ["\x4D\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x50"],
        ["\x53\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x51"],
        ["\x52\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x52"],
        ["\x55\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x53"],
        ["\x4A\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x54"],
        ["\x55\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x55"],
        ["\x51\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x56"],
        ["\x47\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x57"],
        ["\x53\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x58"],
        ["\x53\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x59"],
        ["\x46\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x5A"],
        ["\x48\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x5B"],
        ["\x45\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x5C"],
        ["\x48\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x5D"],
        ["\x51\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x5E"],
        ["\x4D\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x5F"],
        ["\x4D\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x60"],
        ["\x48\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x61"],
        ["\x4F\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x62"],
        ["\x4E\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x63"],
        ["\x45\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x64"],
        ["\x4C\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x65"],
        ["\x4F\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x66"],
        ["\x54\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x67"],
        ["\x48\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x68"],
        ["\x4A\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x69"],
        ["\x4C\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x6A"],
        ["\x49\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x6B"],
        ["\x4F\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x6C"],
        ["\x52\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x6D"],
        ["\x4E\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x6E"],
        ["\x45\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x6F"],
        ["\x48\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x70"],
        ["\x4A\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x71"],
        ["\x46\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x72"],
        ["\x50\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x73"],
        ["\x46\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x74"],
        ["\x4D\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x75"],
        ["\x54\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x76"],
        ["\x4F\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x77"],
        ["\x4C\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x78"],
        ["\x4F\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x79"],
        ["\x4E\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x7A"],
        ["\x4D\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x7B"],
        ["\x4F\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x7C"],
        ["\x53\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x7D"],
        ["\x48\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x7E"],
        ["\x46\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x80"],
        ["\x4A\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x81"],
        ["\x50\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x82"],
        ["\x47\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x83"],
        ["\x4D\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x84"],
        ["\x52\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x85"],
        ["\x51\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x86"],
        ["\x47\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x87"],
        ["\x48\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x88"],
        ["\x47\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x89"],
        ["\x45\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x8A"],
        ["\x4F\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x8B"],
        ["\x51\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x8C"],
        ["\x50\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x8D"],
        ["\x50\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x8E"],
        ["\x4A\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x8F"],
        ["\x4C\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x90"],
        ["\x47\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x91"],
        ["\x53\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x92"],
        ["\x55\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x93"],
        ["\x47\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x94"],
        ["\x46\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x95"],
        ["\x50\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x96"],
        ["\x46\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x97"],
        ["\x4D\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x98"],
        ["\x50\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x99"],
        ["\x52\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x9A"],
        ["\x52\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x9B"],
        ["\x49\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x9C"],
        ["\x4C\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x9D"],
        ["\x4A\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x9E"],
        ["\x45\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\x9F"],
        ["\x4E\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xA0"],
        ["\x4E\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xA1"],
        ["\x4F\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xA2"],
        ["\x55\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xA3"],
        ["\x46\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xA4"],
        ["\x4D\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xA5"],
        ["\x54\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xA6"],
        ["\x4E\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xA7"],
        ["\x53\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xA8"],
        ["\x54\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xA9"],
        ["\x52\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xAA"],
        ["\x49\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xAB"],
        ["\x45\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xAC"],
        ["\x48\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xAD"],
        ["\x48\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xAE"],
        ["\x48\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xAF"],
        ["\x4A\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xB0"],
        ["\x55\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xB1"],
        ["\x49\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xB2"],
        ["\x4C\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xB3"],
        ["\x4E\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xB4"],
        ["\x4B\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xB5"],
        ["\x4E\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xB6"],
        ["\x4D\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xB7"],
        ["\x46\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xB8"],
        ["\x46\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xB9"],
        ["\x45\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xBA"],
        ["\x4A\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xBB"],
        ["\x45\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xBC"],
        ["\x50\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xBD"],
        ["\x53\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xBE"],
        ["\x55\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xBF"],
        ["\x46\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xC0"],
        ["\x48\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xC1"],
        ["\x4A\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xC2"],
        ["\x51\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xC3"],
        ["\x49\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xC4"],
        ["\x4D\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xC5"],
        ["\x47\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xC6"],
        ["\x4E\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xC7"],
        ["\x48\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xC8"],
        ["\x49\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xC9"],
        ["\x51\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xCA"],
        ["\x49\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xCB"],
        ["\x4B\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xCC"],
        ["\x47\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xCD"],
        ["\x49\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xCE"],
        ["\x4B\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xCF"],
        ["\x4C\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xD0"],
        ["\x52\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xD1"],
        ["\x51\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xD2"],
        ["\x53\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xD3"],
        ["\x53\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xD4"],
        ["\x4D\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xD5"],
        ["\x4F\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xD6"],
        ["\x50\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xD7"],
        ["\x49\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xD8"],
        ["\x4F\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xD9"],
        ["\x4D\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xDA"],
        ["\x49\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xDB"],
        ["\x4A\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xDC"],
        ["\x50\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xDD"],
        ["\x4F\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xDE"],
        ["\x53\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xDF"],
        ["\x4C\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xE0"],
        ["\x4B\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xE1"],
        ["\x52\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xE2"],
        ["\x45\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xE3"],
        ["\x49\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xE4"],
        ["\x4F\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xE5"],
        ["\x49\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xE6"],
        ["\x52\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xE7"],
        ["\x4D\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xE8"],
        ["\x45\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xE9"],
        ["\x45\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xEA"],
        ["\x51\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xEB"],
        ["\x4D\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xEC"],
        ["\x46\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xED"],
        ["\x48\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xEE"],
        ["\x55\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xEF"],
        ["\x47\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xF0"],
        ["\x50\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xF1"],
        ["\x4C\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xF2"],
        ["\x48\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xF3"],
        ["\x4E\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xF4"],
        ["\x4E\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xF5"],
        ["\x4A\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xF6"],
        ["\x4B\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xF7"],
        ["\x50\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xF8"],
        ["\x4E\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xF9"],
        ["\x50\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xFA"],
        ["\x4F\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xFB"],
        ["\x49\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x8F\xFC"],
        ["\x4E\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x40"],
        ["\x47\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x41"],
        ["\x4E\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x42"],
        ["\x54\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x43"],
        ["\x48\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x44"],
        ["\x48\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x45"],
        ["\x47\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x46"],
        ["\x4C\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x47"],
        ["\x46\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x48"],
        ["\x53\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x49"],
        ["\x52\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x4A"],
        ["\x49\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x4B"],
        ["\x46\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x4C"],
        ["\x45\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x4D"],
        ["\x4F\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x4E"],
        ["\x4F\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x4F"],
        ["\x52\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x50"],
        ["\x4B\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x51"],
        ["\x49\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x52"],
        ["\x46\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x53"],
        ["\x4A\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x54"],
        ["\x48\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x55"],
        ["\x45\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x56"],
        ["\x4B\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x57"],
        ["\x45\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x58"],
        ["\x4D\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x59"],
        ["\x4D\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x5A"],
        ["\x47\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x5B"],
        ["\x49\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x5C"],
        ["\x54\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x5D"],
        ["\x46\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x5E"],
        ["\x45\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x5F"],
        ["\x4C\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x60"],
        ["\x4E\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x61"],
        ["\x4A\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x62"],
        ["\x4F\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x63"],
        ["\x54\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x64"],
        ["\x48\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x65"],
        ["\x4D\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x66"],
        ["\x47\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x67"],
        ["\x4D\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x68"],
        ["\x46\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x69"],
        ["\x49\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x6A"],
        ["\x4D\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x6B"],
        ["\x45\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x6C"],
        ["\x47\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x6D"],
        ["\x4F\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x6E"],
        ["\x4D\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x6F"],
        ["\x51\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x70"],
        ["\x4D\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x71"],
        ["\x4B\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x72"],
        ["\x4F\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x73"],
        ["\x52\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x74"],
        ["\x50\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x75"],
        ["\x50\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x76"],
        ["\x4C\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x77"],
        ["\x66\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x78"],
        ["\x52\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x79"],
        ["\x4B\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x7A"],
        ["\x46\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x7B"],
        ["\x4B\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x7C"],
        ["\x47\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x7D"],
        ["\x51\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x7E"],
        ["\x4F\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x80"],
        ["\x49\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x81"],
        ["\x4B\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x82"],
        ["\x52\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x83"],
        ["\x48\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x84"],
        ["\x45\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x85"],
        ["\x4F\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x86"],
        ["\x52\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x87"],
        ["\x4F\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x88"],
        ["\x4F\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x89"],
        ["\x4F\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x8A"],
        ["\x4C\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x8B"],
        ["\x4E\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x8C"],
        ["\x53\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x8D"],
        ["\x54\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x8E"],
        ["\x4E\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x8F"],
        ["\x4B\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x90"],
        ["\x52\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x91"],
        ["\x4C\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x92"],
        ["\x50\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x93"],
        ["\x46\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x94"],
        ["\x52\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x95"],
        ["\x55\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x96"],
        ["\x51\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x97"],
        ["\x4E\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x98"],
        ["\x46\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x99"],
        ["\x4F\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x9A"],
        ["\x47\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x9B"],
        ["\x55\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x9C"],
        ["\x4F\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x9D"],
        ["\x4C\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x9E"],
        ["\x48\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\x9F"],
        ["\x51\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xA0"],
        ["\x4B\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xA1"],
        ["\x46\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xA2"],
        ["\x46\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xA3"],
        ["\x50\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xA4"],
        ["\x4B\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xA5"],
        ["\x52\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xA6"],
        ["\x46\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xA7"],
        ["\x47\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xA8"],
        ["\x4F\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xA9"],
        ["\x4A\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xAA"],
        ["\x46\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xAB"],
        ["\x45\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xAC"],
        ["\x45\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xAD"],
        ["\x47\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xAE"],
        ["\x47\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xAF"],
        ["\x47\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xB0"],
        ["\x53\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xB1"],
        ["\x4D\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xB2"],
        ["\x45\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xB3"],
        ["\x45\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xB4"],
        ["\x51\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xB5"],
        ["\x45\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xB6"],
        ["\x48\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xB7"],
        ["\x46\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xB8"],
        ["\x4B\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xB9"],
        ["\x49\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xBA"],
        ["\x45\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xBB"],
        ["\x45\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xBC"],
        ["\x46\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xBD"],
        ["\x4F\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xBE"],
        ["\x4A\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xBF"],
        ["\x53\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xC0"],
        ["\x53\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xC1"],
        ["\x46\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xC2"],
        ["\x46\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xC3"],
        ["\x46\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xC4"],
        ["\x47\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xC5"],
        ["\x55\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xC6"],
        ["\x4F\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xC7"],
        ["\x4B\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xC8"],
        ["\x4E\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xC9"],
        ["\x55\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xCA"],
        ["\x51\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xCB"],
        ["\x4C\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xCC"],
        ["\x4A\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xCD"],
        ["\x45\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xCE"],
        ["\x48\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xCF"],
        ["\x4D\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xD0"],
        ["\x48\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xD1"],
        ["\x53\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xD2"],
        ["\x4B\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xD3"],
        ["\x46\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xD4"],
        ["\x4C\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xD5"],
        ["\x53\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xD6"],
        ["\x50\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xD7"],
        ["\x47\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xD8"],
        ["\x52\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xD9"],
        ["\x47\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xDA"],
        ["\x4E\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xDB"],
        ["\x49\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xDC"],
        ["\x45\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xDD"],
        ["\x51\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xDE"],
        ["\x47\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xDF"],
        ["\x49\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xE0"],
        ["\x49\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xE1"],
        ["\x4A\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xE2"],
        ["\x50\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xE3"],
        ["\x53\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xE4"],
        ["\x48\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xE5"],
        ["\x47\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xE6"],
        ["\x45\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xE7"],
        ["\x49\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xE8"],
        ["\x49\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xE9"],
        ["\x49\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xEA"],
        ["\x53\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xEB"],
        ["\x45\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xEC"],
        ["\x47\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xED"],
        ["\x4D\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xEE"],
        ["\x53\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xEF"],
        ["\x50\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xF0"],
        ["\x55\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xF1"],
        ["\x46\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xF2"],
        ["\x46\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xF3"],
        ["\x4A\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xF4"],
        ["\x48\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xF5"],
        ["\x4D\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xF6"],
        ["\x54\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xF7"],
        ["\x55\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xF8"],
        ["\x4D\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xF9"],
        ["\x4E\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xFA"],
        ["\x51\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xFB"],
        ["\x46\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x90\xFC"],
        ["\x48\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x40"],
        ["\x55\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x41"],
        ["\x52\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x42"],
        ["\x4F\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x43"],
        ["\x46\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x44"],
        ["\x4F\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x45"],
        ["\x51\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x46"],
        ["\x64\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x47"],
        ["\x50\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x48"],
        ["\x48\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x49"],
        ["\x53\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x4A"],
        ["\x4D\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x4B"],
        ["\x4C\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x4C"],
        ["\x51\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x4D"],
        ["\x4C\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x4E"],
        ["\x45\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x4F"],
        ["\x46\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x50"],
        ["\x4D\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x51"],
        ["\x47\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x52"],
        ["\x46\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x53"],
        ["\x4F\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x54"],
        ["\x51\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x55"],
        ["\x50\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x56"],
        ["\x51\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x57"],
        ["\x50\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x58"],
        ["\x4E\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x59"],
        ["\x54\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x5A"],
        ["\x4A\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x5B"],
        ["\x51\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x5C"],
        ["\x49\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x5D"],
        ["\x53\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x5E"],
        ["\x4E\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x5F"],
        ["\x55\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x60"],
        ["\x51\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x61"],
        ["\x4C\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x62"],
        ["\x4C\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x63"],
        ["\x4D\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x64"],
        ["\x4D\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x65"],
        ["\x47\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x66"],
        ["\x46\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x67"],
        ["\x4C\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x68"],
        ["\x4C\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x69"],
        ["\x4F\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x6A"],
        ["\x54\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x6B"],
        ["\x50\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x6C"],
        ["\x4E\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x6D"],
        ["\x4B\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x6E"],
        ["\x4B\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x6F"],
        ["\x53\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x70"],
        ["\x45\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x71"],
        ["\x51\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x72"],
        ["\x4C\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x73"],
        ["\x4C\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x74"],
        ["\x52\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x75"],
        ["\x52\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x76"],
        ["\x4A\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x77"],
        ["\x51\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x78"],
        ["\x4B\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x79"],
        ["\x48\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x7A"],
        ["\x4D\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x7B"],
        ["\x4D\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x7C"],
        ["\x55\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x7D"],
        ["\x54\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x7E"],
        ["\x49\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x80"],
        ["\x46\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x81"],
        ["\x4E\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x82"],
        ["\x4C\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x83"],
        ["\x52\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x84"],
        ["\x4D\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x85"],
        ["\x54\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x86"],
        ["\x4C\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x87"],
        ["\x48\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x88"],
        ["\x54\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x89"],
        ["\x46\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x8A"],
        ["\x4B\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x8B"],
        ["\x51\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x8C"],
        ["\x47\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x8D"],
        ["\x50\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x8E"],
        ["\x4B\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x8F"],
        ["\x48\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x90"],
        ["\x4B\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x91"],
        ["\x4F\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x92"],
        ["\x50\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x93"],
        ["\x50\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x94"],
        ["\x48\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x95"],
        ["\x4A\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x96"],
        ["\x47\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x97"],
        ["\x51\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x98"],
        ["\x51\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x99"],
        ["\x4D\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x9A"],
        ["\x4D\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x9B"],
        ["\x4B\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x9C"],
        ["\x46\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x9D"],
        ["\x4F\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x9E"],
        ["\x4D\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\x9F"],
        ["\x46\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xA0"],
        ["\x4C\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xA1"],
        ["\x45\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xA2"],
        ["\x4A\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xA3"],
        ["\x49\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xA4"],
        ["\x47\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xA5"],
        ["\x4B\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xA6"],
        ["\x4B\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xA7"],
        ["\x53\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xA8"],
        ["\x4B\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xA9"],
        ["\x49\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xAA"],
        ["\x46\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xAB"],
        ["\x48\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xAC"],
        ["\x4E\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xAD"],
        ["\x47\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xAE"],
        ["\x4F\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xAF"],
        ["\x4A\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xB0"],
        ["\x47\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xB1"],
        ["\x4A\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xB2"],
        ["\x4A\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xB3"],
        ["\x4F\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xB4"],
        ["\x4E\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xB5"],
        ["\x4A\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xB6"],
        ["\x4C\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xB7"],
        ["\x4C\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xB8"],
        ["\x4B\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xB9"],
        ["\x45\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xBA"],
        ["\x54\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xBB"],
        ["\x47\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xBC"],
        ["\x45\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xBD"],
        ["\x45\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xBE"],
        ["\x50\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xBF"],
        ["\x55\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xC0"],
        ["\x54\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xC1"],
        ["\x53\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xC2"],
        ["\x4D\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xC3"],
        ["\x54\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xC4"],
        ["\x47\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xC5"],
        ["\x55\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xC6"],
        ["\x54\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xC7"],
        ["\x55\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xC8"],
        ["\x4F\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xC9"],
        ["\x4D\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xCA"],
        ["\x53\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xCB"],
        ["\x46\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xCC"],
        ["\x53\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xCD"],
        ["\x46\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xCE"],
        ["\x49\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xCF"],
        ["\x52\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xD0"],
        ["\x49\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xD1"],
        ["\x48\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xD2"],
        ["\x50\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xD3"],
        ["\x48\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xD4"],
        ["\x50\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xD5"],
        ["\x4B\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xD6"],
        ["\x46\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xD7"],
        ["\x4D\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xD8"],
        ["\x52\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xD9"],
        ["\x52\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xDA"],
        ["\x52\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xDB"],
        ["\x4A\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xDC"],
        ["\x4A\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xDD"],
        ["\x4B\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xDE"],
        ["\x4F\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xDF"],
        ["\x4A\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xE0"],
        ["\x51\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xE1"],
        ["\x50\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xE2"],
        ["\x45\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xE3"],
        ["\x47\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xE4"],
        ["\x45\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xE5"],
        ["\x46\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xE6"],
        ["\x51\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xE7"],
        ["\x47\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xE8"],
        ["\x4B\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xE9"],
        ["\x47\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xEA"],
        ["\x52\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xEB"],
        ["\x49\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xEC"],
        ["\x53\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xED"],
        ["\x48\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xEE"],
        ["\x55\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xEF"],
        ["\x4E\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xF0"],
        ["\x4B\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xF1"],
        ["\x45\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xF2"],
        ["\x4D\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xF3"],
        ["\x4E\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xF4"],
        ["\x4A\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xF5"],
        ["\x53\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xF6"],
        ["\x50\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xF7"],
        ["\x4F\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xF8"],
        ["\x4D\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xF9"],
        ["\x55\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xFA"],
        ["\x52\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xFB"],
        ["\x4E\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x91\xFC"],
        ["\x4F\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x40"],
        ["\x4E\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x41"],
        ["\x46\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x42"],
        ["\x47\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x43"],
        ["\x4E\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x44"],
        ["\x4A\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x45"],
        ["\x4E\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x46"],
        ["\x51\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x47"],
        ["\x54\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x48"],
        ["\x4B\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x49"],
        ["\x45\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x4A"],
        ["\x52\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x4B"],
        ["\x55\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x4C"],
        ["\x4B\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x4D"],
        ["\x4B\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x4E"],
        ["\x48\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x4F"],
        ["\x48\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x50"],
        ["\x50\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x51"],
        ["\x51\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x52"],
        ["\x4A\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x53"],
        ["\x4B\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x54"],
        ["\x4D\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x55"],
        ["\x54\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x56"],
        ["\x4C\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x57"],
        ["\x53\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x58"],
        ["\x48\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x59"],
        ["\x4A\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x5A"],
        ["\x48\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x5B"],
        ["\x54\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x5C"],
        ["\x54\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x5D"],
        ["\x55\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x5E"],
        ["\x4E\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x5F"],
        ["\x53\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x60"],
        ["\x4F\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x61"],
        ["\x48\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x62"],
        ["\x47\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x63"],
        ["\x4E\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x64"],
        ["\x4A\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x65"],
        ["\x49\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x66"],
        ["\x4D\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x67"],
        ["\x4F\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x68"],
        ["\x47\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x69"],
        ["\x45\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x6A"],
        ["\x49\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x6B"],
        ["\x48\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x6C"],
        ["\x45\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x6D"],
        ["\x45\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x6E"],
        ["\x55\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x6F"],
        ["\x4E\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x70"],
        ["\x46\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x71"],
        ["\x45\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x72"],
        ["\x50\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x73"],
        ["\x4D\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x74"],
        ["\x46\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x75"],
        ["\x4C\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x76"],
        ["\x54\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x77"],
        ["\x4C\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x78"],
        ["\x52\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x79"],
        ["\x49\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x7A"],
        ["\x4D\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x7B"],
        ["\x45\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x7C"],
        ["\x4B\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x7D"],
        ["\x4C\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x7E"],
        ["\x50\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x80"],
        ["\x4D\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x81"],
        ["\x4F\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x82"],
        ["\x49\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x83"],
        ["\x55\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x84"],
        ["\x47\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x85"],
        ["\x45\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x86"],
        ["\x48\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x87"],
        ["\x4D\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x88"],
        ["\x46\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x89"],
        ["\x4D\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x8A"],
        ["\x4C\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x8B"],
        ["\x4B\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x8C"],
        ["\x49\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x8D"],
        ["\x4B\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x8E"],
        ["\x52\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x8F"],
        ["\x4F\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x90"],
        ["\x55\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x91"],
        ["\x48\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x92"],
        ["\x4D\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x93"],
        ["\x53\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x94"],
        ["\x4F\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x95"],
        ["\x49\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x96"],
        ["\x54\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x97"],
        ["\x4A\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x98"],
        ["\x4C\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x99"],
        ["\x4B\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x9A"],
        ["\x4D\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x9B"],
        ["\x55\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x9C"],
        ["\x55\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x9D"],
        ["\x55\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x9E"],
        ["\x51\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\x9F"],
        ["\x4D\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xA0"],
        ["\x4B\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xA1"],
        ["\x51\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xA2"],
        ["\x48\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xA3"],
        ["\x4E\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xA4"],
        ["\x4C\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xA5"],
        ["\x51\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xA6"],
        ["\x4F\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xA7"],
        ["\x4C\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xA8"],
        ["\x47\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xA9"],
        ["\x4C\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xAA"],
        ["\x55\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xAB"],
        ["\x45\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xAC"],
        ["\x4E\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xAD"],
        ["\x4D\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xAE"],
        ["\x55\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xAF"],
        ["\x4D\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xB0"],
        ["\x4E\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xB1"],
        ["\x46\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xB2"],
        ["\x55\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xB3"],
        ["\x4A\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xB4"],
        ["\x50\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xB5"],
        ["\x4E\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xB6"],
        ["\x45\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xB7"],
        ["\x4D\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xB8"],
        ["\x47\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xB9"],
        ["\x4E\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xBA"],
        ["\x55\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xBB"],
        ["\x46\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xBC"],
        ["\x55\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xBD"],
        ["\x4C\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xBE"],
        ["\x4D\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xBF"],
        ["\x4B\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xC0"],
        ["\x4C\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xC1"],
        ["\x4E\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xC2"],
        ["\x45\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xC3"],
        ["\x51\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xC4"],
        ["\x4B\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xC5"],
        ["\x4E\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xC6"],
        ["\x49\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xC7"],
        ["\x54\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xC8"],
        ["\x4C\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xC9"],
        ["\x45\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xCA"],
        ["\x46\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xCB"],
        ["\x52\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xCC"],
        ["\x54\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xCD"],
        ["\x4B\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xCE"],
        ["\x4E\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xCF"],
        ["\x4E\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xD0"],
        ["\x4F\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xD1"],
        ["\x47\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xD2"],
        ["\x4F\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xD3"],
        ["\x4D\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xD4"],
        ["\x54\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xD5"],
        ["\x4C\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xD6"],
        ["\x54\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xD7"],
        ["\x49\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xD8"],
        ["\x58\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xD9"],
        ["\x52\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xDA"],
        ["\x55\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xDB"],
        ["\x4C\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xDC"],
        ["\x53\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xDD"],
        ["\x4C\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xDE"],
        ["\x47\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xDF"],
        ["\x4E\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xE0"],
        ["\x48\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xE1"],
        ["\x4E\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xE2"],
        ["\x4F\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xE3"],
        ["\x53\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xE4"],
        ["\x46\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xE5"],
        ["\x4F\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xE6"],
        ["\x4B\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xE7"],
        ["\x45\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xE8"],
        ["\x48\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xE9"],
        ["\x4B\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xEA"],
        ["\x48\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xEB"],
        ["\x50\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xEC"],
        ["\x4C\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xED"],
        ["\x4D\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xEE"],
        ["\x4B\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xEF"],
        ["\x53\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xF0"],
        ["\x49\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xF1"],
        ["\x51\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xF2"],
        ["\x53\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xF3"],
        ["\x51\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xF4"],
        ["\x4B\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xF5"],
        ["\x47\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xF6"],
        ["\x4A\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xF7"],
        ["\x4D\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xF8"],
        ["\x4F\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xF9"],
        ["\x52\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xFA"],
        ["\x55\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xFB"],
        ["\x51\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x92\xFC"],
        ["\x4D\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x40"],
        ["\x51\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x41"],
        ["\x4F\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x42"],
        ["\x51\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x43"],
        ["\x4E\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x44"],
        ["\x4D\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x45"],
        ["\x55\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x46"],
        ["\x4B\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x47"],
        ["\x4F\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x48"],
        ["\x45\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x49"],
        ["\x4F\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x4A"],
        ["\x49\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x4B"],
        ["\x50\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x4C"],
        ["\x54\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x4D"],
        ["\x47\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x4E"],
        ["\x48\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x4F"],
        ["\x4E\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x50"],
        ["\x54\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x51"],
        ["\x53\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x52"],
        ["\x45\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x53"],
        ["\x47\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x54"],
        ["\x4F\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x55"],
        ["\x46\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x56"],
        ["\x48\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x57"],
        ["\x48\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x58"],
        ["\x4A\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x59"],
        ["\x55\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x5A"],
        ["\x52\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x5B"],
        ["\x50\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x5C"],
        ["\x47\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x5D"],
        ["\x55\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x5E"],
        ["\x47\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x5F"],
        ["\x48\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x60"],
        ["\x48\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x61"],
        ["\x55\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x62"],
        ["\x45\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x63"],
        ["\x45\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x64"],
        ["\x50\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x65"],
        ["\x4E\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x66"],
        ["\x54\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x67"],
        ["\x48\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x68"],
        ["\x53\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x69"],
        ["\x53\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x6A"],
        ["\x4C\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x6B"],
        ["\x4E\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x6C"],
        ["\x52\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x6D"],
        ["\x45\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x6E"],
        ["\x46\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x6F"],
        ["\x53\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x70"],
        ["\x52\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x71"],
        ["\x48\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x72"],
        ["\x45\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x73"],
        ["\x55\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x74"],
        ["\x4D\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x75"],
        ["\x50\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x76"],
        ["\x4A\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x77"],
        ["\x45\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x78"],
        ["\x46\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x79"],
        ["\x4D\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x7A"],
        ["\x4C\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x7B"],
        ["\x4B\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x7C"],
        ["\x49\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x7D"],
        ["\x4B\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x7E"],
        ["\x4B\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x80"],
        ["\x4C\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x81"],
        ["\x4B\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x82"],
        ["\x4C\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x83"],
        ["\x52\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x84"],
        ["\x55\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x85"],
        ["\x51\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x86"],
        ["\x45\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x87"],
        ["\x47\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x88"],
        ["\x51\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x89"],
        ["\x47\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x8A"],
        ["\x52\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x8B"],
        ["\x45\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x8C"],
        ["\x4A\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x8D"],
        ["\x5C\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x8E"],
        ["\x4E\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x8F"],
        ["\x4D\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x90"],
        ["\x55\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x91"],
        ["\x48\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x92"],
        ["\x5D\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x93"],
        ["\x4B\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x94"],
        ["\x4E\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x95"],
        ["\x46\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x96"],
        ["\x55\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x97"],
        ["\x55\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x98"],
        ["\x46\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x99"],
        ["\x49\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x9A"],
        ["\x4B\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x9B"],
        ["\x48\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x9C"],
        ["\x48\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x9D"],
        ["\x4C\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x9E"],
        ["\x50\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\x9F"],
        ["\x54\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xA0"],
        ["\x45\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xA1"],
        ["\x49\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xA2"],
        ["\x4F\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xA3"],
        ["\x4A\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xA4"],
        ["\x4D\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xA5"],
        ["\x4C\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xA6"],
        ["\x4B\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xA7"],
        ["\x52\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xA8"],
        ["\x4A\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xA9"],
        ["\x47\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xAA"],
        ["\x4E\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xAB"],
        ["\x4B\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xAC"],
        ["\x48\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xAD"],
        ["\x45\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xAE"],
        ["\x46\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xAF"],
        ["\x49\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xB0"],
        ["\x48\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xB1"],
        ["\x53\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xB2"],
        ["\x55\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xB3"],
        ["\x4D\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xB4"],
        ["\x4F\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xB5"],
        ["\x4D\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xB6"],
        ["\x4E\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xB7"],
        ["\x54\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xB8"],
        ["\x45\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xB9"],
        ["\x48\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xBA"],
        ["\x4F\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xBB"],
        ["\x51\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xBC"],
        ["\x50\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xBD"],
        ["\x47\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xBE"],
        ["\x46\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xBF"],
        ["\x55\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xC0"],
        ["\x46\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xC1"],
        ["\x4A\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xC2"],
        ["\x53\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xC3"],
        ["\x4A\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xC4"],
        ["\x4C\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xC5"],
        ["\x4A\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xC6"],
        ["\x4A\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xC7"],
        ["\x47\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xC8"],
        ["\x55\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xC9"],
        ["\x50\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xCA"],
        ["\x4A\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xCB"],
        ["\x54\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xCC"],
        ["\x4D\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xCD"],
        ["\x54\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xCE"],
        ["\x4D\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xCF"],
        ["\x4A\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xD0"],
        ["\x4F\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xD1"],
        ["\x53\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xD2"],
        ["\x55\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xD3"],
        ["\x4F\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xD4"],
        ["\x4E\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xD5"],
        ["\x49\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xD6"],
        ["\x55\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xD7"],
        ["\x4C\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xD8"],
        ["\x54\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xD9"],
        ["\x51\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xDA"],
        ["\x50\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xDB"],
        ["\x4C\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xDC"],
        ["\x4E\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xDD"],
        ["\x45\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xDE"],
        ["\x48\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xDF"],
        ["\x45\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xE0"],
        ["\x55\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xE1"],
        ["\x54\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xE2"],
        ["\x51\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xE3"],
        ["\x52\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xE4"],
        ["\x4B\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xE5"],
        ["\x4F\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xE6"],
        ["\x4B\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xE7"],
        ["\x4D\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xE8"],
        ["\x50\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xE9"],
        ["\x48\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xEA"],
        ["\x50\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xEB"],
        ["\x45\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xEC"],
        ["\x4A\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xED"],
        ["\x4C\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xEE"],
        ["\x49\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xEF"],
        ["\x55\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xF0"],
        ["\x45\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xF1"],
        ["\x4A\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xF2"],
        ["\x50\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xF3"],
        ["\x64\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xF4"],
        ["\x4E\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xF5"],
        ["\x53\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xF6"],
        ["\x4A\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xF7"],
        ["\x51\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xF8"],
        ["\x51\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xF9"],
        ["\x45\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xFA"],
        ["\x4A\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xFB"],
        ["\x46\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x93\xFC"],
        ["\x4B\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x40"],
        ["\x4C\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x41"],
        ["\x4F\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x42"],
        ["\x4A\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x43"],
        ["\x50\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x44"],
        ["\x4B\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x45"],
        ["\x4A\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x46"],
        ["\x50\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x47"],
        ["\x50\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x48"],
        ["\x4F\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x49"],
        ["\x4F\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x4A"],
        ["\x54\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x4B"],
        ["\x4F\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x4C"],
        ["\x47\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x4D"],
        ["\x45\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x4E"],
        ["\x4A\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x4F"],
        ["\x54\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x50"],
        ["\x53\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x51"],
        ["\x49\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x52"],
        ["\x4B\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x53"],
        ["\x4B\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x54"],
        ["\x55\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x55"],
        ["\x45\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x56"],
        ["\x4D\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x57"],
        ["\x51\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x58"],
        ["\x4B\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x59"],
        ["\x4A\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x5A"],
        ["\x49\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x5B"],
        ["\x47\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x5C"],
        ["\x4C\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x5D"],
        ["\x53\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x5E"],
        ["\x48\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x5F"],
        ["\x53\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x60"],
        ["\x55\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x61"],
        ["\x4E\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x62"],
        ["\x4E\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x63"],
        ["\x4E\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x64"],
        ["\x4B\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x65"],
        ["\x52\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x66"],
        ["\x46\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x67"],
        ["\x4A\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x68"],
        ["\x52\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x69"],
        ["\x4A\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x6A"],
        ["\x4E\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x6B"],
        ["\x55\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x6C"],
        ["\x54\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x6D"],
        ["\x46\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x6E"],
        ["\x4C\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x6F"],
        ["\x4B\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x70"],
        ["\x4E\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x71"],
        ["\x4C\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x72"],
        ["\x4B\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x73"],
        ["\x4C\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x74"],
        ["\x53\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x75"],
        ["\x55\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x76"],
        ["\x4A\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x77"],
        ["\x50\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x78"],
        ["\x4E\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x79"],
        ["\x47\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x7A"],
        ["\x4A\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x7B"],
        ["\x4D\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x7C"],
        ["\x4D\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x7D"],
        ["\x47\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x7E"],
        ["\x52\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x80"],
        ["\x54\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x81"],
        ["\x54\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x82"],
        ["\x49\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x83"],
        ["\x47\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x84"],
        ["\x4F\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x85"],
        ["\x55\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x86"],
        ["\x4F\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x87"],
        ["\x63\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x88"],
        ["\x50\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x89"],
        ["\x55\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x8A"],
        ["\x49\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x8B"],
        ["\x49\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x8C"],
        ["\x54\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x8D"],
        ["\x45\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x8E"],
        ["\x4F\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x8F"],
        ["\x49\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x90"],
        ["\x4D\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x91"],
        ["\x46\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x92"],
        ["\x4E\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x93"],
        ["\x4C\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x94"],
        ["\x4B\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x95"],
        ["\x4A\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x96"],
        ["\x49\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x97"],
        ["\x52\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x98"],
        ["\x50\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x99"],
        ["\x4A\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x9A"],
        ["\x52\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x9B"],
        ["\x54\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x9C"],
        ["\x55\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x9D"],
        ["\x4A\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x9E"],
        ["\x4B\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\x9F"],
        ["\x4A\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xA0"],
        ["\x52\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xA1"],
        ["\x50\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xA2"],
        ["\x4B\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xA3"],
        ["\x4D\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xA4"],
        ["\x51\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xA5"],
        ["\x48\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xA6"],
        ["\x4E\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xA7"],
        ["\x47\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xA8"],
        ["\x49\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xA9"],
        ["\x45\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xAA"],
        ["\x4E\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xAB"],
        ["\x54\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xAC"],
        ["\x46\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xAD"],
        ["\x51\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xAE"],
        ["\x4C\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xAF"],
        ["\x50\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xB0"],
        ["\x4F\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xB1"],
        ["\x4A\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xB2"],
        ["\x52\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xB3"],
        ["\x51\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xB4"],
        ["\x4D\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xB5"],
        ["\x55\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xB6"],
        ["\x4F\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xB7"],
        ["\x55\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xB8"],
        ["\x4E\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xB9"],
        ["\x49\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xBA"],
        ["\x49\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xBB"],
        ["\x47\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xBC"],
        ["\x47\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xBD"],
        ["\x55\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xBE"],
        ["\x4F\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xBF"],
        ["\x4D\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xC0"],
        ["\x52\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xC1"],
        ["\x46\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xC2"],
        ["\x55\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xC3"],
        ["\x50\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xC4"],
        ["\x4A\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xC5"],
        ["\x4C\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xC6"],
        ["\x50\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xC7"],
        ["\x4E\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xC8"],
        ["\x47\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xC9"],
        ["\x49\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xCA"],
        ["\x4F\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xCB"],
        ["\x4A\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xCC"],
        ["\x49\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xCD"],
        ["\x53\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xCE"],
        ["\x54\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xCF"],
        ["\x55\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xD0"],
        ["\x46\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xD1"],
        ["\x52\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xD2"],
        ["\x4C\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xD3"],
        ["\x48\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xD4"],
        ["\x48\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xD5"],
        ["\x4B\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xD6"],
        ["\x52\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xD7"],
        ["\x53\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xD8"],
        ["\x55\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xD9"],
        ["\x53\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xDA"],
        ["\x4C\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xDB"],
        ["\x51\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xDC"],
        ["\x55\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xDD"],
        ["\x47\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xDE"],
        ["\x4C\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xDF"],
        ["\x50\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xE0"],
        ["\x4C\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xE1"],
        ["\x4F\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xE2"],
        ["\x4B\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xE3"],
        ["\x47\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xE4"],
        ["\x51\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xE5"],
        ["\x4D\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xE6"],
        ["\x49\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xE7"],
        ["\x51\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xE8"],
        ["\x4C\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xE9"],
        ["\x53\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xEA"],
        ["\x55\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xEB"],
        ["\x49\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xEC"],
        ["\x4B\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xED"],
        ["\x55\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xEE"],
        ["\x46\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xEF"],
        ["\x4C\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xF0"],
        ["\x48\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xF1"],
        ["\x48\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xF2"],
        ["\x49\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xF3"],
        ["\x51\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xF4"],
        ["\x46\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xF5"],
        ["\x45\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xF6"],
        ["\x4B\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xF7"],
        ["\x52\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xF8"],
        ["\x53\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xF9"],
        ["\x52\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xFA"],
        ["\x52\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xFB"],
        ["\x45\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x94\xFC"],
        ["\x4C\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x40"],
        ["\x52\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x41"],
        ["\x50\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x42"],
        ["\x4F\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x43"],
        ["\x4E\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x44"],
        ["\x50\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x45"],
        ["\x45\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x46"],
        ["\x50\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x47"],
        ["\x48\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x48"],
        ["\x52\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x49"],
        ["\x52\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x4A"],
        ["\x47\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x4B"],
        ["\x55\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x4C"],
        ["\x4A\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x4D"],
        ["\x55\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x4E"],
        ["\x50\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x4F"],
        ["\x4A\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x50"],
        ["\x48\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x51"],
        ["\x4F\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x52"],
        ["\x45\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x53"],
        ["\x55\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x54"],
        ["\x4D\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x55"],
        ["\x51\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x56"],
        ["\x49\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x57"],
        ["\x4C\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x58"],
        ["\x4F\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x59"],
        ["\x54\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x5A"],
        ["\x4D\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x5B"],
        ["\x46\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x5C"],
        ["\x49\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x5D"],
        ["\x55\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x5E"],
        ["\x55\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x5F"],
        ["\x4B\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x60"],
        ["\x49\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x61"],
        ["\x4D\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x62"],
        ["\x4A\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x63"],
        ["\x53\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x64"],
        ["\x55\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x65"],
        ["\x52\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x66"],
        ["\x4E\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x67"],
        ["\x54\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x68"],
        ["\x45\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x69"],
        ["\x4E\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x6A"],
        ["\x51\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x6B"],
        ["\x45\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x6C"],
        ["\x55\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x6D"],
        ["\x4D\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x6E"],
        ["\x50\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x6F"],
        ["\x53\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x70"],
        ["\x46\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x71"],
        ["\x4C\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x72"],
        ["\x46\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x73"],
        ["\x47\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x74"],
        ["\x51\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x75"],
        ["\x45\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x76"],
        ["\x49\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x77"],
        ["\x45\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x78"],
        ["\x48\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x79"],
        ["\x47\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x7A"],
        ["\x45\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x7B"],
        ["\x4E\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x7C"],
        ["\x4D\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x7D"],
        ["\x49\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x7E"],
        ["\x51\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x80"],
        ["\x49\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x81"],
        ["\x4A\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x82"],
        ["\x45\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x83"],
        ["\x4F\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x84"],
        ["\x4D\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x85"],
        ["\x51\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x86"],
        ["\x4E\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x87"],
        ["\x4E\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x88"],
        ["\x49\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x89"],
        ["\x4F\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x8A"],
        ["\x50\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x8B"],
        ["\x47\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x8C"],
        ["\x4B\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x8D"],
        ["\x53\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x8E"],
        ["\x51\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x8F"],
        ["\x45\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x90"],
        ["\x4A\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x91"],
        ["\x55\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x92"],
        ["\x51\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x93"],
        ["\x45\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x94"],
        ["\x4D\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x95"],
        ["\x52\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x96"],
        ["\x47\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x97"],
        ["\x50\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x98"],
        ["\x54\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x99"],
        ["\x4A\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x9A"],
        ["\x4B\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x9B"],
        ["\x4A\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x9C"],
        ["\x4A\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x9D"],
        ["\x47\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x9E"],
        ["\x45\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\x9F"],
        ["\x4C\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xA0"],
        ["\x4B\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xA1"],
        ["\x4D\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xA2"],
        ["\x48\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xA3"],
        ["\x54\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xA4"],
        ["\x49\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xA5"],
        ["\x4E\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xA6"],
        ["\x4B\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xA7"],
        ["\x46\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xA8"],
        ["\x52\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xA9"],
        ["\x45\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xAA"],
        ["\x53\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xAB"],
        ["\x4E\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xAC"],
        ["\x52\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xAD"],
        ["\x4F\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xAE"],
        ["\x54\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xAF"],
        ["\x54\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xB0"],
        ["\x4E\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xB1"],
        ["\x48\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xB2"],
        ["\x54\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xB3"],
        ["\x4F\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xB4"],
        ["\x4F\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xB5"],
        ["\x45\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xB6"],
        ["\x48\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xB7"],
        ["\x50\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xB8"],
        ["\x4B\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xB9"],
        ["\x46\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xBA"],
        ["\x53\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xBB"],
        ["\x4E\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xBC"],
        ["\x45\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xBD"],
        ["\x50\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xBE"],
        ["\x4A\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xBF"],
        ["\x48\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xC0"],
        ["\x54\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xC1"],
        ["\x4B\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xC2"],
        ["\x51\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xC3"],
        ["\x46\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xC4"],
        ["\x4C\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xC5"],
        ["\x55\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xC6"],
        ["\x4B\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xC7"],
        ["\x53\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xC8"],
        ["\x4D\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xC9"],
        ["\x46\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xCA"],
        ["\x55\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xCB"],
        ["\x55\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xCC"],
        ["\x55\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xCD"],
        ["\x50\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xCE"],
        ["\x47\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xCF"],
        ["\x47\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xD0"],
        ["\x4F\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xD1"],
        ["\x48\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xD2"],
        ["\x45\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xD3"],
        ["\x48\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xD4"],
        ["\x50\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xD5"],
        ["\x4B\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xD6"],
        ["\x48\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xD7"],
        ["\x54\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xD8"],
        ["\x4B\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xD9"],
        ["\x54\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xDA"],
        ["\x45\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xDB"],
        ["\x4E\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xDC"],
        ["\x53\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xDD"],
        ["\x53\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xDE"],
        ["\x4C\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xDF"],
        ["\x47\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xE0"],
        ["\x4D\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xE1"],
        ["\x49\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xE2"],
        ["\x4A\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xE3"],
        ["\x48\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xE4"],
        ["\x4A\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xE5"],
        ["\x4E\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xE6"],
        ["\x52\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xE7"],
        ["\x51\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xE8"],
        ["\x4A\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xE9"],
        ["\x49\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xEA"],
        ["\x4F\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xEB"],
        ["\x51\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xEC"],
        ["\x55\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xED"],
        ["\x50\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xEE"],
        ["\x4A\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xEF"],
        ["\x50\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xF0"],
        ["\x49\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xF1"],
        ["\x4D\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xF2"],
        ["\x49\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xF3"],
        ["\x48\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xF4"],
        ["\x4A\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xF5"],
        ["\x4F\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xF6"],
        ["\x55\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xF7"],
        ["\x4C\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xF8"],
        ["\x52\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xF9"],
        ["\x48\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xFA"],
        ["\x45\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xFB"],
        ["\x4B\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x95\xFC"],
        ["\x46\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x40"],
        ["\x4E\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x41"],
        ["\x55\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x42"],
        ["\x4C\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x43"],
        ["\x49\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x44"],
        ["\x50\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x45"],
        ["\x46\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x46"],
        ["\x50\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x47"],
        ["\x50\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x48"],
        ["\x4E\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x49"],
        ["\x51\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x4A"],
        ["\x4A\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x4B"],
        ["\x46\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x4C"],
        ["\x46\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x4D"],
        ["\x54\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x4E"],
        ["\x4D\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x4F"],
        ["\x4E\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x50"],
        ["\x51\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x51"],
        ["\x4F\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x52"],
        ["\x4C\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x53"],
        ["\x4E\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x54"],
        ["\x51\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x55"],
        ["\x4C\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x56"],
        ["\x50\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x57"],
        ["\x4C\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x58"],
        ["\x4C\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x59"],
        ["\x4E\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x5A"],
        ["\x47\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x5B"],
        ["\x4C\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x5C"],
        ["\x47\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x5D"],
        ["\x50\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x5E"],
        ["\x4B\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x5F"],
        ["\x4F\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x60"],
        ["\x48\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x61"],
        ["\x4C\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x62"],
        ["\x4E\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x63"],
        ["\x4F\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x64"],
        ["\x50\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x65"],
        ["\x48\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x66"],
        ["\x51\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x67"],
        ["\x47\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x68"],
        ["\x53\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x69"],
        ["\x4E\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x6A"],
        ["\x45\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x6B"],
        ["\x4A\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x6C"],
        ["\x51\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x6D"],
        ["\x4A\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x6E"],
        ["\x4E\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x6F"],
        ["\x4E\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x70"],
        ["\x48\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x71"],
        ["\x4A\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x72"],
        ["\x52\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x73"],
        ["\x53\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x74"],
        ["\x54\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x75"],
        ["\x50\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x76"],
        ["\x4F\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x77"],
        ["\x46\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x78"],
        ["\x49\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x79"],
        ["\x52\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x7A"],
        ["\x45\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x7B"],
        ["\x51\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x7C"],
        ["\x4D\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x7D"],
        ["\x50\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x7E"],
        ["\x48\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x80"],
        ["\x49\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x81"],
        ["\x4D\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x82"],
        ["\x48\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x83"],
        ["\x4E\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x84"],
        ["\x4B\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x85"],
        ["\x55\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x86"],
        ["\x49\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x87"],
        ["\x49\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x88"],
        ["\x55\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x89"],
        ["\x68\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x8A"],
        ["\x4C\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x8B"],
        ["\x4D\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x8C"],
        ["\x4F\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x8D"],
        ["\x55\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x8E"],
        ["\x50\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x8F"],
        ["\x53\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x90"],
        ["\x4D\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x91"],
        ["\x4F\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x92"],
        ["\x4B\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x93"],
        ["\x48\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x94"],
        ["\x51\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x95"],
        ["\x47\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x96"],
        ["\x53\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x97"],
        ["\x49\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x98"],
        ["\x56\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x99"],
        ["\x4D\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x9A"],
        ["\x4E\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x9B"],
        ["\x45\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x9C"],
        ["\x4D\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x9D"],
        ["\x47\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x9E"],
        ["\x4F\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\x9F"],
        ["\x55\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xA0"],
        ["\x47\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xA1"],
        ["\x49\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xA2"],
        ["\x4D\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xA3"],
        ["\x4A\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xA4"],
        ["\x4C\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xA5"],
        ["\x50\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xA6"],
        ["\x4A\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xA7"],
        ["\x53\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xA8"],
        ["\x4C\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xA9"],
        ["\x4F\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xAA"],
        ["\x47\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xAB"],
        ["\x50\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xAC"],
        ["\x4A\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xAD"],
        ["\x53\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xAE"],
        ["\x47\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xAF"],
        ["\x4E\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xB0"],
        ["\x46\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xB1"],
        ["\x4B\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xB2"],
        ["\x47\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xB3"],
        ["\x4A\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xB4"],
        ["\x50\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xB5"],
        ["\x4E\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xB6"],
        ["\x55\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xB7"],
        ["\x4D\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xB8"],
        ["\x54\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xB9"],
        ["\x4B\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xBA"],
        ["\x54\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xBB"],
        ["\x45\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xBC"],
        ["\x49\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xBD"],
        ["\x45\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xBE"],
        ["\x4B\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xBF"],
        ["\x4E\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xC0"],
        ["\x4D\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xC1"],
        ["\x4B\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xC2"],
        ["\x55\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xC3"],
        ["\x55\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xC4"],
        ["\x4E\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xC5"],
        ["\x4B\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xC6"],
        ["\x55\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xC7"],
        ["\x48\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xC8"],
        ["\x55\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xC9"],
        ["\x46\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xCA"],
        ["\x55\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xCB"],
        ["\x55\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xCC"],
        ["\x48\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xCD"],
        ["\x46\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xCE"],
        ["\x55\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xCF"],
        ["\x4F\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xD0"],
        ["\x46\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xD1"],
        ["\x4A\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xD2"],
        ["\x50\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xD3"],
        ["\x4A\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xD4"],
        ["\x4F\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xD5"],
        ["\x50\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xD6"],
        ["\x54\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xD7"],
        ["\x45\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xD8"],
        ["\x4D\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xD9"],
        ["\x46\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xDA"],
        ["\x51\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xDB"],
        ["\x52\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xDC"],
        ["\x50\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xDD"],
        ["\x53\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xDE"],
        ["\x4C\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xDF"],
        ["\x4F\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xE0"],
        ["\x4D\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xE1"],
        ["\x46\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xE2"],
        ["\x55\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xE3"],
        ["\x4C\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xE4"],
        ["\x46\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xE5"],
        ["\x4F\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xE6"],
        ["\x47\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xE7"],
        ["\x51\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xE8"],
        ["\x48\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xE9"],
        ["\x50\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xEA"],
        ["\x4E\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xEB"],
        ["\x45\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xEC"],
        ["\x47\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xED"],
        ["\x46\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xEE"],
        ["\x53\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xEF"],
        ["\x49\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xF0"],
        ["\x47\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xF1"],
        ["\x46\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xF2"],
        ["\x4B\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xF3"],
        ["\x4C\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xF4"],
        ["\x48\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xF5"],
        ["\x46\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xF6"],
        ["\x62\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xF7"],
        ["\x52\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xF8"],
        ["\x50\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xF9"],
        ["\x53\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xFA"],
        ["\x46\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xFB"],
        ["\x53\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x96\xFC"],
        ["\x4E\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x40"],
        ["\x46\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x41"],
        ["\x4B\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x42"],
        ["\x4C\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x43"],
        ["\x47\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x44"],
        ["\x46\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x45"],
        ["\x46\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x46"],
        ["\x4F\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x47"],
        ["\x52\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x48"],
        ["\x4D\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x49"],
        ["\x50\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x4A"],
        ["\x4C\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x4B"],
        ["\x46\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x4C"],
        ["\x4E\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x4D"],
        ["\x4F\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x4E"],
        ["\x4F\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x4F"],
        ["\x50\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x50"],
        ["\x53\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x51"],
        ["\x46\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x52"],
        ["\x48\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x53"],
        ["\x46\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x54"],
        ["\x4A\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x55"],
        ["\x4A\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x56"],
        ["\x4C\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x57"],
        ["\x4C\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x58"],
        ["\x45\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x59"],
        ["\x48\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x5A"],
        ["\x4A\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x5B"],
        ["\x47\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x5C"],
        ["\x49\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x5D"],
        ["\x47\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x5E"],
        ["\x4D\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x5F"],
        ["\x50\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x60"],
        ["\x4D\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x61"],
        ["\x54\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x62"],
        ["\x4D\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x63"],
        ["\x53\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x64"],
        ["\x48\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x65"],
        ["\x4C\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x66"],
        ["\x4C\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x67"],
        ["\x4F\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x68"],
        ["\x51\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x69"],
        ["\x4B\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x6A"],
        ["\x51\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x6B"],
        ["\x48\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x6C"],
        ["\x45\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x6D"],
        ["\x48\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x6E"],
        ["\x52\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x6F"],
        ["\x45\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x70"],
        ["\x49\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x71"],
        ["\x4A\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x72"],
        ["\x52\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x73"],
        ["\x45\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x74"],
        ["\x50\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x75"],
        ["\x46\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x76"],
        ["\x4D\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x77"],
        ["\x4C\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x78"],
        ["\x68\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x79"],
        ["\x47\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x7A"],
        ["\x49\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x7B"],
        ["\x53\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x7C"],
        ["\x4D\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x7D"],
        ["\x4B\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x7E"],
        ["\x55\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x80"],
        ["\x4B\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x81"],
        ["\x4D\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x82"],
        ["\x4D\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x83"],
        ["\x4A\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x84"],
        ["\x4D\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x85"],
        ["\x51\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x86"],
        ["\x4F\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x87"],
        ["\x46\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x88"],
        ["\x52\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x89"],
        ["\x4A\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x8A"],
        ["\x4B\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x8B"],
        ["\x54\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x8C"],
        ["\x4C\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x8D"],
        ["\x47\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x8E"],
        ["\x50\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x8F"],
        ["\x4B\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x90"],
        ["\x4C\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x91"],
        ["\x49\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x92"],
        ["\x4E\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x93"],
        ["\x55\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x94"],
        ["\x4E\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x95"],
        ["\x4C\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x96"],
        ["\x4E\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x97"],
        ["\x45\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x98"],
        ["\x50\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x99"],
        ["\x4C\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x9A"],
        ["\x4E\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x9B"],
        ["\x48\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x9C"],
        ["\x45\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x9D"],
        ["\x52\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x9E"],
        ["\x51\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\x9F"],
        ["\x49\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xA0"],
        ["\x54\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xA1"],
        ["\x47\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xA2"],
        ["\x49\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xA3"],
        ["\x49\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xA4"],
        ["\x49\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xA5"],
        ["\x47\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xA6"],
        ["\x45\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xA7"],
        ["\x55\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xA8"],
        ["\x55\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xA9"],
        ["\x4C\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xAA"],
        ["\x51\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xAB"],
        ["\x46\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xAC"],
        ["\x4D\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xAD"],
        ["\x50\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xAE"],
        ["\x47\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xAF"],
        ["\x49\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xB0"],
        ["\x4C\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xB1"],
        ["\x46\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xB2"],
        ["\x49\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xB3"],
        ["\x48\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xB4"],
        ["\x55\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xB5"],
        ["\x4C\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xB6"],
        ["\x4A\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xB7"],
        ["\x52\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xB8"],
        ["\x4B\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xB9"],
        ["\x49\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xBA"],
        ["\x4D\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xBB"],
        ["\x48\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xBC"],
        ["\x53\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xBD"],
        ["\x4C\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xBE"],
        ["\x46\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xBF"],
        ["\x4E\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xC0"],
        ["\x4E\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xC1"],
        ["\x4E\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xC2"],
        ["\x4B\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xC3"],
        ["\x52\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xC4"],
        ["\x52\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xC5"],
        ["\x4E\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xC6"],
        ["\x45\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xC7"],
        ["\x51\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xC8"],
        ["\x52\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xC9"],
        ["\x47\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xCA"],
        ["\x50\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xCB"],
        ["\x4A\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xCC"],
        ["\x45\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xCD"],
        ["\x48\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xCE"],
        ["\x4D\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xCF"],
        ["\x4F\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xD0"],
        ["\x45\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xD1"],
        ["\x52\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xD2"],
        ["\x4A\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xD3"],
        ["\x54\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xD4"],
        ["\x4C\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xD5"],
        ["\x48\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xD6"],
        ["\x4C\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xD7"],
        ["\x55\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xD8"],
        ["\x51\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xD9"],
        ["\x50\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xDA"],
        ["\x4B\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xDB"],
        ["\x4D\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xDC"],
        ["\x51\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xDD"],
        ["\x46\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xDE"],
        ["\x49\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xDF"],
        ["\x54\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xE0"],
        ["\x4A\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xE1"],
        ["\x48\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xE2"],
        ["\x4D\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xE3"],
        ["\x4C\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xE4"],
        ["\x50\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xE5"],
        ["\x4A\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xE6"],
        ["\x49\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xE7"],
        ["\x55\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xE8"],
        ["\x45\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xE9"],
        ["\x55\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xEA"],
        ["\x50\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xEB"],
        ["\x4F\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xEC"],
        ["\x4C\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xED"],
        ["\x4C\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xEE"],
        ["\x50\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xEF"],
        ["\x49\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xF0"],
        ["\x4B\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xF1"],
        ["\x4E\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xF2"],
        ["\x4D\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xF3"],
        ["\x4F\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xF4"],
        ["\x4E\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xF5"],
        ["\x4B\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xF6"],
        ["\x55\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xF7"],
        ["\x54\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xF8"],
        ["\x4C\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xF9"],
        ["\x52\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xFA"],
        ["\x48\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xFB"],
        ["\x53\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x97\xFC"],
        ["\x4B\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x40"],
        ["\x47\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x41"],
        ["\x4F\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x42"],
        ["\x4B\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x43"],
        ["\x51\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x44"],
        ["\x55\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x45"],
        ["\x49\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x46"],
        ["\x55\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x47"],
        ["\x47\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x48"],
        ["\x4B\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x49"],
        ["\x48\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x4A"],
        ["\x50\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x4B"],
        ["\x4E\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x4C"],
        ["\x54\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x4D"],
        ["\x48\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x4E"],
        ["\x52\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x4F"],
        ["\x55\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x50"],
        ["\x4A\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x51"],
        ["\x50\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x52"],
        ["\x55\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x53"],
        ["\x50\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x54"],
        ["\x54\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x55"],
        ["\x49\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x56"],
        ["\x53\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x57"],
        ["\x52\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x58"],
        ["\x45\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x59"],
        ["\x45\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x5A"],
        ["\x51\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x5B"],
        ["\x50\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x5C"],
        ["\x55\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x5D"],
        ["\x48\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x5E"],
        ["\x48\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x5F"],
        ["\x4F\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x60"],
        ["\x45\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x61"],
        ["\x47\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x62"],
        ["\x55\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x63"],
        ["\x50\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x64"],
        ["\x47\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x65"],
        ["\x4E\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x66"],
        ["\x4F\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x67"],
        ["\x4B\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x68"],
        ["\x50\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x69"],
        ["\x4B\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x6A"],
        ["\x52\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x6B"],
        ["\x50\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x6C"],
        ["\x4F\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x6D"],
        ["\x50\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x6E"],
        ["\x54\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x6F"],
        ["\x4D\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x70"],
        ["\x54\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x71"],
        ["\x4C\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x72"],
        ["\x56\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\x9F"],
        ["\x56\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xA0"],
        ["\x56\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xA1"],
        ["\x56\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xA2"],
        ["\x56\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xA3"],
        ["\x56\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xA4"],
        ["\x54\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xA5"],
        ["\x56\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xA6"],
        ["\x56\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xA7"],
        ["\x56\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xA8"],
        ["\x56\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xA9"],
        ["\x56\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xAA"],
        ["\x56\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xAB"],
        ["\x53\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xAC"],
        ["\x56\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xAD"],
        ["\x61\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xAE"],
        ["\x56\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xAF"],
        ["\x56\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xB0"],
        ["\x56\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xB1"],
        ["\x51\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xB2"],
        ["\x56\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xB3"],
        ["\x56\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xB4"],
        ["\x56\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xB5"],
        ["\x56\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xB6"],
        ["\x56\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xB7"],
        ["\x56\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xB8"],
        ["\x56\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xB9"],
        ["\x56\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xBA"],
        ["\x56\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xBB"],
        ["\x56\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xBC"],
        ["\x56\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xBD"],
        ["\x56\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xBE"],
        ["\x56\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xBF"],
        ["\x56\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xC0"],
        ["\x53\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xC1"],
        ["\x56\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xC2"],
        ["\x56\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xC3"],
        ["\x56\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xC4"],
        ["\x56\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xC5"],
        ["\x56\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xC6"],
        ["\x56\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xC7"],
        ["\x56\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xC8"],
        ["\x51\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xC9"],
        ["\x56\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xCA"],
        ["\x56\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xCB"],
        ["\x56\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xCC"],
        ["\x56\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xCD"],
        ["\x56\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xCE"],
        ["\x56\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xCF"],
        ["\x4F\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xD0"],
        ["\x56\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xD1"],
        ["\x56\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xD2"],
        ["\x56\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xD3"],
        ["\x52\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xD4"],
        ["\x56\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xD5"],
        ["\x53\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xD6"],
        ["\x56\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xD7"],
        ["\x56\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xD8"],
        ["\x56\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xD9"],
        ["\x56\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xDA"],
        ["\x56\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xDB"],
        ["\x56\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xDC"],
        ["\x56\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xDD"],
        ["\x56\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xDE"],
        ["\x56\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xDF"],
        ["\x56\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xE0"],
        ["\x56\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xE1"],
        ["\x56\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xE2"],
        ["\x56\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xE3"],
        ["\x56\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xE4"],
        ["\x56\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xE5"],
        ["\x51\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xE6"],
        ["\x56\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xE7"],
        ["\x56\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xE8"],
        ["\x56\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xE9"],
        ["\x56\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xEA"],
        ["\x56\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xEB"],
        ["\x56\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xEC"],
        ["\x56\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xED"],
        ["\x56\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xEE"],
        ["\x56\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xEF"],
        ["\x56\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xF0"],
        ["\x56\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xF1"],
        ["\x56\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xF2"],
        ["\x56\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xF3"],
        ["\x56\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xF4"],
        ["\x56\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xF5"],
        ["\x56\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xF6"],
        ["\x56\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xF7"],
        ["\x56\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xF8"],
        ["\x56\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xF9"],
        ["\x56\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xFA"],
        ["\x56\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xFB"],
        ["\x56\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x98\xFC"],
        ["\x56\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x40"],
        ["\x56\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x41"],
        ["\x56\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x42"],
        ["\x56\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x43"],
        ["\x52\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x44"],
        ["\x56\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x45"],
        ["\x56\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x46"],
        ["\x56\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x47"],
        ["\x56\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x48"],
        ["\x56\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x49"],
        ["\x56\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x4A"],
        ["\x56\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x4B"],
        ["\x56\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x4C"],
        ["\x56\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x4D"],
        ["\x56\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x4E"],
        ["\x56\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x4F"],
        ["\x56\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x50"],
        ["\x56\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x51"],
        ["\x56\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x52"],
        ["\x56\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x53"],
        ["\x56\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x54"],
        ["\x56\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x55"],
        ["\x56\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x56"],
        ["\x56\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x57"],
        ["\x56\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x58"],
        ["\x56\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x59"],
        ["\x56\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x5A"],
        ["\x56\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x5B"],
        ["\x56\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x5C"],
        ["\x56\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x5D"],
        ["\x60\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x5E"],
        ["\x56\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x5F"],
        ["\x56\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x60"],
        ["\x56\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x61"],
        ["\x56\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x62"],
        ["\x56\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x63"],
        ["\x56\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x64"],
        ["\x56\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x65"],
        ["\x56\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x66"],
        ["\x56\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x67"],
        ["\x56\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x68"],
        ["\x56\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x69"],
        ["\x56\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x6A"],
        ["\x56\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x6B"],
        ["\x56\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x6C"],
        ["\x56\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x6D"],
        ["\x56\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x6E"],
        ["\x56\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x6F"],
        ["\x56\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x70"],
        ["\x56\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x71"],
        ["\x56\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x72"],
        ["\x56\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x73"],
        ["\x56\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x74"],
        ["\x56\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x75"],
        ["\x56\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x76"],
        ["\x56\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x77"],
        ["\x56\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x78"],
        ["\x56\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x79"],
        ["\x56\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x7A"],
        ["\x56\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x7B"],
        ["\x62\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x7C"],
        ["\x56\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x7D"],
        ["\x56\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x7E"],
        ["\x56\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x80"],
        ["\x56\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x81"],
        ["\x56\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x82"],
        ["\x56\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x83"],
        ["\x56\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x84"],
        ["\x56\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x85"],
        ["\x54\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x86"],
        ["\x56\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x87"],
        ["\x56\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x88"],
        ["\x56\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x89"],
        ["\x56\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x8A"],
        ["\x56\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x8B"],
        ["\x57\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x8C"],
        ["\x56\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x8D"],
        ["\x56\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x8E"],
        ["\x51\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x8F"],
        ["\x57\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x90"],
        ["\x57\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x91"],
        ["\x57\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x92"],
        ["\x57\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x93"],
        ["\x57\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x94"],
        ["\x57\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x95"],
        ["\x57\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x96"],
        ["\x57\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x97"],
        ["\x57\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x98"],
        ["\x55\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x99"],
        ["\x57\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x9A"],
        ["\x57\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x9B"],
        ["\x57\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x9C"],
        ["\x57\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x9D"],
        ["\x64\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x9E"],
        ["\x64\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\x9F"],
        ["\x57\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xA0"],
        ["\x57\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xA1"],
        ["\x57\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xA2"],
        ["\x57\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xA3"],
        ["\x57\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xA4"],
        ["\x57\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xA5"],
        ["\x53\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xA6"],
        ["\x57\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xA7"],
        ["\x57\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xA8"],
        ["\x57\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xA9"],
        ["\x66\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xAA"],
        ["\x57\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xAB"],
        ["\x57\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xAC"],
        ["\x57\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xAD"],
        ["\x57\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xAE"],
        ["\x57\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xAF"],
        ["\x57\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xB0"],
        ["\x57\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xB1"],
        ["\x57\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xB2"],
        ["\x57\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xB3"],
        ["\x57\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xB4"],
        ["\x57\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xB5"],
        ["\x57\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xB6"],
        ["\x57\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xB7"],
        ["\x57\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xB8"],
        ["\x57\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xB9"],
        ["\x57\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xBA"],
        ["\x57\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xBB"],
        ["\x57\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xBC"],
        ["\x57\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xBD"],
        ["\x57\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xBE"],
        ["\x57\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xBF"],
        ["\x57\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xC0"],
        ["\x57\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xC1"],
        ["\x57\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xC2"],
        ["\x57\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xC3"],
        ["\x57\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xC4"],
        ["\x57\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xC5"],
        ["\x57\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xC6"],
        ["\x52\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xC7"],
        ["\x57\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xC8"],
        ["\x57\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xC9"],
        ["\x57\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xCA"],
        ["\x57\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xCB"],
        ["\x57\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xCC"],
        ["\x57\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xCD"],
        ["\x57\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xCE"],
        ["\x57\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xCF"],
        ["\x57\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xD0"],
        ["\x57\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xD1"],
        ["\x57\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xD2"],
        ["\x57\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xD3"],
        ["\x66\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xD4"],
        ["\x57\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xD5"],
        ["\x57\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xD6"],
        ["\x57\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xD7"],
        ["\x57\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xD8"],
        ["\x57\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xD9"],
        ["\x57\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xDA"],
        ["\x57\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xDB"],
        ["\x57\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xDC"],
        ["\x57\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xDD"],
        ["\x57\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xDE"],
        ["\x57\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xDF"],
        ["\x57\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xE0"],
        ["\x57\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xE1"],
        ["\x57\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xE2"],
        ["\x57\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xE3"],
        ["\x57\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xE4"],
        ["\x57\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xE5"],
        ["\x57\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xE6"],
        ["\x57\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xE7"],
        ["\x57\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xE8"],
        ["\x57\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xE9"],
        ["\x57\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xEA"],
        ["\x57\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xEB"],
        ["\x57\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xEC"],
        ["\x57\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xED"],
        ["\x57\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xEE"],
        ["\x57\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xEF"],
        ["\x57\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xF0"],
        ["\x57\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xF1"],
        ["\x57\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xF2"],
        ["\x57\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xF3"],
        ["\x57\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xF4"],
        ["\x57\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xF5"],
        ["\x57\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xF6"],
        ["\x57\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xF7"],
        ["\x57\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xF8"],
        ["\x57\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xF9"],
        ["\x57\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xFA"],
        ["\x57\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xFB"],
        ["\x57\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x99\xFC"],
        ["\x57\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x40"],
        ["\x57\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x41"],
        ["\x57\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x42"],
        ["\x57\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x43"],
        ["\x57\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x44"],
        ["\x57\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x45"],
        ["\x57\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x46"],
        ["\x57\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x47"],
        ["\x57\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x48"],
        ["\x57\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x49"],
        ["\x57\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x4A"],
        ["\x57\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x4B"],
        ["\x57\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x4C"],
        ["\x54\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x4D"],
        ["\x57\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x4E"],
        ["\x57\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x4F"],
        ["\x57\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x50"],
        ["\x57\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x51"],
        ["\x57\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x52"],
        ["\x57\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x53"],
        ["\x57\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x54"],
        ["\x57\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x55"],
        ["\x57\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x56"],
        ["\x57\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x57"],
        ["\x57\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x58"],
        ["\x57\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x59"],
        ["\x57\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x5A"],
        ["\x57\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x5B"],
        ["\x57\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x5C"],
        ["\x57\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x5D"],
        ["\x57\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x5E"],
        ["\x57\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x5F"],
        ["\x57\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x60"],
        ["\x57\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x61"],
        ["\x57\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x62"],
        ["\x57\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x63"],
        ["\x57\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x64"],
        ["\x57\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x65"],
        ["\x57\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x66"],
        ["\x57\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x67"],
        ["\x57\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x68"],
        ["\x57\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x69"],
        ["\x52\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x6A"],
        ["\x57\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x6B"],
        ["\x57\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x6C"],
        ["\x57\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x6D"],
        ["\x57\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x6E"],
        ["\x57\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x6F"],
        ["\x57\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x70"],
        ["\x57\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x71"],
        ["\x57\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x72"],
        ["\x57\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x73"],
        ["\x57\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x74"],
        ["\x57\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x75"],
        ["\x57\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x76"],
        ["\x57\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x77"],
        ["\x57\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x78"],
        ["\x57\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x79"],
        ["\x57\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x7A"],
        ["\x54\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x7B"],
        ["\x57\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x7C"],
        ["\x57\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x7D"],
        ["\x57\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x7E"],
        ["\x57\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x80"],
        ["\x57\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x81"],
        ["\x57\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x82"],
        ["\x57\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x83"],
        ["\x57\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x84"],
        ["\x57\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x85"],
        ["\x57\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x86"],
        ["\x58\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x87"],
        ["\x58\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x88"],
        ["\x57\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x89"],
        ["\x57\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x8A"],
        ["\x58\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x8B"],
        ["\x58\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x8C"],
        ["\x58\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x8D"],
        ["\x58\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x8E"],
        ["\x58\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x8F"],
        ["\x58\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x90"],
        ["\x58\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x91"],
        ["\x58\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x92"],
        ["\x58\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x93"],
        ["\x58\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x94"],
        ["\x58\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x95"],
        ["\x58\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x96"],
        ["\x58\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x97"],
        ["\x58\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x98"],
        ["\x58\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x99"],
        ["\x58\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x9A"],
        ["\x52\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x9B"],
        ["\x58\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x9C"],
        ["\x58\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x9D"],
        ["\x58\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x9E"],
        ["\x58\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\x9F"],
        ["\x51\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xA0"],
        ["\x58\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xA1"],
        ["\x54\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xA2"],
        ["\x58\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xA3"],
        ["\x58\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xA4"],
        ["\x58\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xA5"],
        ["\x58\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xA6"],
        ["\x58\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xA7"],
        ["\x51\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xA8"],
        ["\x58\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xA9"],
        ["\x58\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xAA"],
        ["\x58\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xAB"],
        ["\x58\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xAC"],
        ["\x58\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xAD"],
        ["\x53\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xAE"],
        ["\x58\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xAF"],
        ["\x58\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xB0"],
        ["\x58\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xB1"],
        ["\x58\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xB2"],
        ["\x58\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xB3"],
        ["\x58\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xB4"],
        ["\x58\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xB5"],
        ["\x58\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xB6"],
        ["\x58\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xB7"],
        ["\x58\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xB8"],
        ["\x53\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xB9"],
        ["\x58\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xBA"],
        ["\x58\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xBB"],
        ["\x58\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xBC"],
        ["\x58\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xBD"],
        ["\x58\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xBE"],
        ["\x58\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xBF"],
        ["\x58\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xC0"],
        ["\x58\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xC1"],
        ["\x58\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xC2"],
        ["\x58\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xC3"],
        ["\x53\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xC4"],
        ["\x58\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xC5"],
        ["\x58\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xC6"],
        ["\x58\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xC7"],
        ["\x58\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xC8"],
        ["\x58\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xC9"],
        ["\x58\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xCA"],
        ["\x58\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xCB"],
        ["\x58\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xCC"],
        ["\x58\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xCD"],
        ["\x58\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xCE"],
        ["\x58\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xCF"],
        ["\x58\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xD0"],
        ["\x58\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xD1"],
        ["\x58\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xD2"],
        ["\x58\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xD3"],
        ["\x55\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xD4"],
        ["\x58\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xD5"],
        ["\x58\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xD6"],
        ["\x58\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xD7"],
        ["\x58\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xD8"],
        ["\x58\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xD9"],
        ["\x58\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xDA"],
        ["\x58\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xDB"],
        ["\x58\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xDC"],
        ["\x58\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xDD"],
        ["\x58\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xDE"],
        ["\x58\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xDF"],
        ["\x58\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xE0"],
        ["\x58\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xE1"],
        ["\x50\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xE2"],
        ["\x58\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xE3"],
        ["\x58\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xE4"],
        ["\x58\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xE5"],
        ["\x52\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xE6"],
        ["\x58\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xE7"],
        ["\x58\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xE8"],
        ["\x58\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xE9"],
        ["\x58\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xEA"],
        ["\x58\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xEB"],
        ["\x58\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xEC"],
        ["\x58\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xED"],
        ["\x58\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xEE"],
        ["\x58\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xEF"],
        ["\x58\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xF0"],
        ["\x58\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xF1"],
        ["\x60\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xF2"],
        ["\x58\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xF3"],
        ["\x58\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xF4"],
        ["\x51\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xF5"],
        ["\x58\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xF6"],
        ["\x58\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xF7"],
        ["\x58\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xF8"],
        ["\x58\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xF9"],
        ["\x58\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xFA"],
        ["\x58\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xFB"],
        ["\x58\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9A\xFC"],
        ["\x58\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x40"],
        ["\x58\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x41"],
        ["\x58\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x42"],
        ["\x56\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x43"],
        ["\x56\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x44"],
        ["\x58\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x45"],
        ["\x58\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x46"],
        ["\x58\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x47"],
        ["\x58\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x48"],
        ["\x51\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x49"],
        ["\x58\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x4A"],
        ["\x58\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x4B"],
        ["\x58\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x4C"],
        ["\x58\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x4D"],
        ["\x58\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x4E"],
        ["\x58\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x4F"],
        ["\x58\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x50"],
        ["\x58\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x51"],
        ["\x58\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x52"],
        ["\x58\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x53"],
        ["\x58\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x54"],
        ["\x58\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x55"],
        ["\x58\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x56"],
        ["\x58\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x57"],
        ["\x58\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x58"],
        ["\x58\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x59"],
        ["\x58\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x5A"],
        ["\x58\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x5B"],
        ["\x58\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x5C"],
        ["\x58\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x5D"],
        ["\x58\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x5E"],
        ["\x58\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x5F"],
        ["\x58\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x60"],
        ["\x58\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x61"],
        ["\x58\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x62"],
        ["\x58\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x63"],
        ["\x58\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x64"],
        ["\x58\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x65"],
        ["\x58\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x66"],
        ["\x58\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x67"],
        ["\x58\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x68"],
        ["\x58\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x69"],
        ["\x58\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x6A"],
        ["\x58\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x6B"],
        ["\x58\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x6C"],
        ["\x58\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x6D"],
        ["\x58\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x6E"],
        ["\x58\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x6F"],
        ["\x58\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x70"],
        ["\x58\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x71"],
        ["\x58\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x72"],
        ["\x58\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x73"],
        ["\x52\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x74"],
        ["\x58\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x75"],
        ["\x58\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x76"],
        ["\x58\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x77"],
        ["\x58\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x78"],
        ["\x58\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x79"],
        ["\x58\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x7A"],
        ["\x58\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x7B"],
        ["\x58\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x7C"],
        ["\x58\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x7D"],
        ["\x58\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x7E"],
        ["\x58\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x80"],
        ["\x58\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x81"],
        ["\x58\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x82"],
        ["\x58\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x83"],
        ["\x58\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x84"],
        ["\x58\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x85"],
        ["\x52\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x86"],
        ["\x59\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x87"],
        ["\x59\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x88"],
        ["\x51\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x89"],
        ["\x59\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x8A"],
        ["\x59\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x8B"],
        ["\x59\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x8C"],
        ["\x59\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x8D"],
        ["\x59\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x8E"],
        ["\x59\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x8F"],
        ["\x59\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x90"],
        ["\x59\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x91"],
        ["\x59\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x92"],
        ["\x59\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x93"],
        ["\x59\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x94"],
        ["\x59\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x95"],
        ["\x59\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x96"],
        ["\x59\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x97"],
        ["\x59\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x98"],
        ["\x59\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x99"],
        ["\x51\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x9A"],
        ["\x59\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x9B"],
        ["\x59\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x9C"],
        ["\x59\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x9D"],
        ["\x59\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x9E"],
        ["\x59\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\x9F"],
        ["\x54\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xA0"],
        ["\x59\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xA1"],
        ["\x59\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xA2"],
        ["\x59\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xA3"],
        ["\x56\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xA4"],
        ["\x59\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xA5"],
        ["\x59\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xA6"],
        ["\x59\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xA7"],
        ["\x52\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xA8"],
        ["\x59\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xA9"],
        ["\x58\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xAA"],
        ["\x59\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xAB"],
        ["\x59\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xAC"],
        ["\x59\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xAD"],
        ["\x59\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xAE"],
        ["\x59\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xAF"],
        ["\x59\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xB0"],
        ["\x59\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xB1"],
        ["\x59\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xB2"],
        ["\x59\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xB3"],
        ["\x59\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xB4"],
        ["\x59\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xB5"],
        ["\x59\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xB6"],
        ["\x59\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xB7"],
        ["\x59\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xB8"],
        ["\x59\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xB9"],
        ["\x59\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xBA"],
        ["\x59\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xBB"],
        ["\x54\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xBC"],
        ["\x59\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xBD"],
        ["\x59\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xBE"],
        ["\x59\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xBF"],
        ["\x59\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xC0"],
        ["\x51\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xC1"],
        ["\x59\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xC2"],
        ["\x59\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xC3"],
        ["\x59\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xC4"],
        ["\x59\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xC5"],
        ["\x59\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xC6"],
        ["\x59\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xC7"],
        ["\x59\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xC8"],
        ["\x59\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xC9"],
        ["\x59\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xCA"],
        ["\x59\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xCB"],
        ["\x59\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xCC"],
        ["\x59\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xCD"],
        ["\x59\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xCE"],
        ["\x59\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xCF"],
        ["\x59\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xD0"],
        ["\x59\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xD1"],
        ["\x59\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xD2"],
        ["\x59\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xD3"],
        ["\x4F\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xD4"],
        ["\x59\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xD5"],
        ["\x59\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xD6"],
        ["\x59\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xD7"],
        ["\x59\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xD8"],
        ["\x52\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xD9"],
        ["\x59\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xDA"],
        ["\x59\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xDB"],
        ["\x51\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xDC"],
        ["\x59\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xDD"],
        ["\x59\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xDE"],
        ["\x4A\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xDF"],
        ["\x59\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xE0"],
        ["\x59\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xE1"],
        ["\x59\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xE2"],
        ["\x59\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xE3"],
        ["\x59\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xE4"],
        ["\x59\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xE5"],
        ["\x59\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xE6"],
        ["\x54\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xE7"],
        ["\x59\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xE8"],
        ["\x59\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xE9"],
        ["\x59\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xEA"],
        ["\x59\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xEB"],
        ["\x59\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xEC"],
        ["\x59\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xED"],
        ["\x54\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xEE"],
        ["\x59\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xEF"],
        ["\x59\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xF0"],
        ["\x59\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xF1"],
        ["\x59\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xF2"],
        ["\x59\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xF3"],
        ["\x59\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xF4"],
        ["\x68\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xF5"],
        ["\x59\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xF6"],
        ["\x59\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xF7"],
        ["\x59\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xF8"],
        ["\x59\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xF9"],
        ["\x59\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xFA"],
        ["\x59\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xFB"],
        ["\x59\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9B\xFC"],
        ["\x53\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x40"],
        ["\x50\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x41"],
        ["\x59\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x42"],
        ["\x59\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x43"],
        ["\x59\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x44"],
        ["\x59\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x45"],
        ["\x59\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x46"],
        ["\x59\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x47"],
        ["\x59\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x48"],
        ["\x59\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x49"],
        ["\x59\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x4A"],
        ["\x59\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x4B"],
        ["\x59\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x4C"],
        ["\x59\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x4D"],
        ["\x52\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x4E"],
        ["\x54\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x4F"],
        ["\x59\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x50"],
        ["\x59\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x51"],
        ["\x59\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x52"],
        ["\x59\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x53"],
        ["\x59\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x54"],
        ["\x59\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x55"],
        ["\x59\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x56"],
        ["\x59\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x57"],
        ["\x59\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x58"],
        ["\x59\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x59"],
        ["\x59\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x5B"],
        ["\x59\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x5C"],
        ["\x59\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x5D"],
        ["\x59\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x5E"],
        ["\x59\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x5F"],
        ["\x59\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x60"],
        ["\x59\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x61"],
        ["\x59\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x62"],
        ["\x59\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x63"],
        ["\x52\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x64"],
        ["\x59\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x65"],
        ["\x59\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x66"],
        ["\x59\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x67"],
        ["\x59\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x68"],
        ["\x59\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x69"],
        ["\x59\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x6A"],
        ["\x59\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x6B"],
        ["\x59\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x6C"],
        ["\x59\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x6D"],
        ["\x59\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x6E"],
        ["\x59\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x6F"],
        ["\x59\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x70"],
        ["\x59\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x71"],
        ["\x59\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x72"],
        ["\x59\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x73"],
        ["\x59\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x74"],
        ["\x59\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x75"],
        ["\x59\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x76"],
        ["\x59\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x77"],
        ["\x59\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x78"],
        ["\x59\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x79"],
        ["\x59\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x7A"],
        ["\x52\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x7B"],
        ["\x59\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x7C"],
        ["\x59\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x7D"],
        ["\x5A\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x7E"],
        ["\x59\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x80"],
        ["\x59\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x81"],
        ["\x59\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x82"],
        ["\x59\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x83"],
        ["\x59\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x84"],
        ["\x59\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x85"],
        ["\x59\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x86"],
        ["\x59\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x87"],
        ["\x59\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x88"],
        ["\x59\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x89"],
        ["\x59\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x8A"],
        ["\x5A\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x8B"],
        ["\x5A\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x8C"],
        ["\x5A\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x8D"],
        ["\x5A\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x8E"],
        ["\x5A\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x8F"],
        ["\x5A\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x90"],
        ["\x5A\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x91"],
        ["\x5A\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x92"],
        ["\x5A\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x93"],
        ["\x5A\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x94"],
        ["\x5A\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x95"],
        ["\x52\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x96"],
        ["\x5A\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x97"],
        ["\x5A\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x98"],
        ["\x5A\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x99"],
        ["\x5A\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x9A"],
        ["\x55\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x9B"],
        ["\x55\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x9C"],
        ["\x5A\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x9D"],
        ["\x5A\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x9E"],
        ["\x5A\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x9F"],
        ["\x5A\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xA0"],
        ["\x5A\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xA1"],
        ["\x5A\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xA2"],
        ["\x5A\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xA3"],
        ["\x5A\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xA4"],
        ["\x5A\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xA5"],
        ["\x5A\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xA6"],
        ["\x5A\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xA7"],
        ["\x5A\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xA8"],
        ["\x5A\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xA9"],
        ["\x53\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xAA"],
        ["\x59\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xAB"],
        ["\x5A\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xAC"],
        ["\x5A\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xAD"],
        ["\x5A\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xAE"],
        ["\x5A\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xAF"],
        ["\x5A\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xB0"],
        ["\x5A\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xB1"],
        ["\x5A\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xB2"],
        ["\x5A\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xB3"],
        ["\x5A\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xB4"],
        ["\x5A\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xB5"],
        ["\x5A\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xB6"],
        ["\x5A\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xB7"],
        ["\x5A\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xB8"],
        ["\x5A\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xB9"],
        ["\x5A\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xBA"],
        ["\x5A\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xBB"],
        ["\x5A\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xBC"],
        ["\x5A\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xBD"],
        ["\x5A\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xBE"],
        ["\x5A\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xBF"],
        ["\x5A\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xC0"],
        ["\x5A\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xC1"],
        ["\x5A\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xC2"],
        ["\x51\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xC3"],
        ["\x5A\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xC4"],
        ["\x5A\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xC5"],
        ["\x5A\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xC6"],
        ["\x5A\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xC7"],
        ["\x5A\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xC8"],
        ["\x5A\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xC9"],
        ["\x5A\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xCA"],
        ["\x5A\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xCB"],
        ["\x5A\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xCC"],
        ["\x5A\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xCD"],
        ["\x5A\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xCE"],
        ["\x5A\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xCF"],
        ["\x5A\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xD0"],
        ["\x5A\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xD1"],
        ["\x5A\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xD2"],
        ["\x5A\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xD3"],
        ["\x5A\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xD4"],
        ["\x5A\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xD5"],
        ["\x5A\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xD6"],
        ["\x5A\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xD7"],
        ["\x5A\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xD8"],
        ["\x5A\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xD9"],
        ["\x5A\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xDA"],
        ["\x5A\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xDB"],
        ["\x5A\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xDC"],
        ["\x55\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xDD"],
        ["\x5A\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xDE"],
        ["\x5A\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xDF"],
        ["\x5A\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xE0"],
        ["\x5A\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xE1"],
        ["\x5A\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xE2"],
        ["\x5A\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xE3"],
        ["\x5A\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xE4"],
        ["\x5A\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xE5"],
        ["\x5A\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xE6"],
        ["\x5A\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xE7"],
        ["\x5A\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xE8"],
        ["\x5A\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xE9"],
        ["\x5A\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xEA"],
        ["\x5A\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xEB"],
        ["\x5A\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xEC"],
        ["\x5A\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xED"],
        ["\x5A\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xEE"],
        ["\x5A\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xEF"],
        ["\x5A\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xF0"],
        ["\x5A\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xF1"],
        ["\x5A\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xF2"],
        ["\x5A\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xF3"],
        ["\x5A\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xF4"],
        ["\x5A\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xF5"],
        ["\x5A\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xF6"],
        ["\x5A\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xF7"],
        ["\x5A\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xF8"],
        ["\x5A\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xF9"],
        ["\x54\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xFA"],
        ["\x5A\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xFB"],
        ["\x5A\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\xFC"],
        ["\x5A\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x40"],
        ["\x5A\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x41"],
        ["\x5A\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x42"],
        ["\x5A\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x43"],
        ["\x5A\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x44"],
        ["\x5A\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x45"],
        ["\x5A\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x46"],
        ["\x5A\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x47"],
        ["\x5A\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x48"],
        ["\x5A\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x49"],
        ["\x5A\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x4A"],
        ["\x5A\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x4B"],
        ["\x5A\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x4C"],
        ["\x5A\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x4D"],
        ["\x5A\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x4E"],
        ["\x5A\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x4F"],
        ["\x5A\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x50"],
        ["\x5A\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x51"],
        ["\x5A\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x52"],
        ["\x5A\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x53"],
        ["\x5A\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x54"],
        ["\x5A\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x55"],
        ["\x5A\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x56"],
        ["\x5A\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x57"],
        ["\x5A\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x58"],
        ["\x5A\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x59"],
        ["\x5A\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x5A"],
        ["\x5A\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x5B"],
        ["\x5A\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x5C"],
        ["\x5A\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x5D"],
        ["\x5B\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x5E"],
        ["\x5A\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x5F"],
        ["\x5A\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x60"],
        ["\x53\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x61"],
        ["\x5A\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x62"],
        ["\x5A\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x63"],
        ["\x5A\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x64"],
        ["\x5A\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x65"],
        ["\x5A\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x66"],
        ["\x5A\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x67"],
        ["\x5A\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x68"],
        ["\x5A\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x69"],
        ["\x5A\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x6A"],
        ["\x5A\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x6B"],
        ["\x5A\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x6C"],
        ["\x5A\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x6D"],
        ["\x5A\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x6E"],
        ["\x5A\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x6F"],
        ["\x5A\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x70"],
        ["\x5A\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x71"],
        ["\x5B\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x72"],
        ["\x5A\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x73"],
        ["\x5A\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x74"],
        ["\x5A\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x75"],
        ["\x5A\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x76"],
        ["\x5A\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x77"],
        ["\x5A\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x78"],
        ["\x5A\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x79"],
        ["\x5A\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x7A"],
        ["\x5A\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x7B"],
        ["\x5A\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x7C"],
        ["\x5A\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x7D"],
        ["\x5A\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x7E"],
        ["\x5A\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x80"],
        ["\x5A\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x81"],
        ["\x5A\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x82"],
        ["\x5A\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x83"],
        ["\x5A\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x84"],
        ["\x5A\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x85"],
        ["\x5A\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x86"],
        ["\x5A\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x87"],
        ["\x5B\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x88"],
        ["\x5B\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x89"],
        ["\x5B\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x8A"],
        ["\x5B\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x8B"],
        ["\x5B\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x8C"],
        ["\x5B\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x8D"],
        ["\x5B\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x8E"],
        ["\x5B\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x8F"],
        ["\x5B\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x90"],
        ["\x5B\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x91"],
        ["\x5B\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x92"],
        ["\x5B\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x93"],
        ["\x5B\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x94"],
        ["\x5B\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x95"],
        ["\x5B\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x96"],
        ["\x5B\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x97"],
        ["\x52\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x98"],
        ["\x5B\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x99"],
        ["\x5B\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x9A"],
        ["\x5B\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x9B"],
        ["\x5B\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x9C"],
        ["\x5B\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x9D"],
        ["\x5B\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x9E"],
        ["\x5B\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\x9F"],
        ["\x5B\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xA0"],
        ["\x5B\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xA1"],
        ["\x5B\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xA2"],
        ["\x5B\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xA3"],
        ["\x5B\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xA4"],
        ["\x5B\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xA5"],
        ["\x5B\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xA6"],
        ["\x5B\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xA7"],
        ["\x57\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xA8"],
        ["\x5B\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xA9"],
        ["\x5B\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xAA"],
        ["\x5A\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xAB"],
        ["\x5B\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xAC"],
        ["\x5B\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xAD"],
        ["\x5B\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xAE"],
        ["\x5B\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xAF"],
        ["\x5B\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xB0"],
        ["\x5B\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xB1"],
        ["\x5B\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xB2"],
        ["\x5B\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xB3"],
        ["\x5B\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xB4"],
        ["\x5B\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xB5"],
        ["\x5B\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xB6"],
        ["\x5B\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xB7"],
        ["\x5B\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xB8"],
        ["\x5B\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xB9"],
        ["\x5B\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xBA"],
        ["\x5B\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xBB"],
        ["\x5B\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xBC"],
        ["\x5B\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xBD"],
        ["\x5B\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xBE"],
        ["\x5B\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xBF"],
        ["\x5B\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xC0"],
        ["\x5B\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xC1"],
        ["\x5B\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xC2"],
        ["\x5B\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xC3"],
        ["\x5B\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xC4"],
        ["\x5B\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xC5"],
        ["\x51\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xC6"],
        ["\x5B\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xC7"],
        ["\x5B\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xC8"],
        ["\x5B\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xC9"],
        ["\x5B\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xCA"],
        ["\x5B\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xCB"],
        ["\x5B\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xCC"],
        ["\x5B\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xCD"],
        ["\x5B\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xCE"],
        ["\x5B\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xCF"],
        ["\x5B\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xD0"],
        ["\x5B\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xD1"],
        ["\x5B\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xD2"],
        ["\x5B\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xD3"],
        ["\x5B\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xD4"],
        ["\x5B\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xD5"],
        ["\x5B\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xD6"],
        ["\x51\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xD7"],
        ["\x5B\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xD8"],
        ["\x5B\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xD9"],
        ["\x5B\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xDA"],
        ["\x5B\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xDB"],
        ["\x5B\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xDC"],
        ["\x52\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xDD"],
        ["\x5B\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xDE"],
        ["\x5B\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xDF"],
        ["\x5B\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xE0"],
        ["\x5B\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xE1"],
        ["\x51\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xE2"],
        ["\x5B\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xE3"],
        ["\x5B\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xE4"],
        ["\x51\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xE5"],
        ["\x5B\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xE6"],
        ["\x5B\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xE7"],
        ["\x52\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xE8"],
        ["\x5B\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xE9"],
        ["\x5B\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xEA"],
        ["\x5B\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xEB"],
        ["\x50\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xEC"],
        ["\x51\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xED"],
        ["\x4F\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xEE"],
        ["\x5B\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xEF"],
        ["\x5B\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xF0"],
        ["\x5B\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xF1"],
        ["\x5B\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xF2"],
        ["\x4F\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xF3"],
        ["\x4E\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xF4"],
        ["\x5B\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xF5"],
        ["\x5B\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xF6"],
        ["\x5B\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xF7"],
        ["\x5B\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xF8"],
        ["\x52\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xF9"],
        ["\x5B\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xFA"],
        ["\x5B\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xFB"],
        ["\x5B\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9D\xFC"],
        ["\x5B\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x40"],
        ["\x5B\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x41"],
        ["\x5B\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x42"],
        ["\x5B\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x43"],
        ["\x51\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x44"],
        ["\x5B\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x45"],
        ["\x5B\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x46"],
        ["\x5B\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x47"],
        ["\x5B\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x48"],
        ["\x5B\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x49"],
        ["\x5B\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x4A"],
        ["\x54\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x4B"],
        ["\x5B\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x4C"],
        ["\x5B\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x4D"],
        ["\x5B\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x4E"],
        ["\x5B\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x4F"],
        ["\x5B\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x50"],
        ["\x5B\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x51"],
        ["\x5B\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x52"],
        ["\x5B\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x53"],
        ["\x53\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x54"],
        ["\x5B\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x55"],
        ["\x5B\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x56"],
        ["\x5B\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x57"],
        ["\x5B\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x58"],
        ["\x54\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x59"],
        ["\x5B\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x5A"],
        ["\x52\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x5B"],
        ["\x5B\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x5C"],
        ["\x5B\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x5D"],
        ["\x5B\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x5E"],
        ["\x5B\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x5F"],
        ["\x54\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x60"],
        ["\x5B\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x61"],
        ["\x54\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x62"],
        ["\x5B\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x63"],
        ["\x5B\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x64"],
        ["\x5B\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x65"],
        ["\x5B\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x66"],
        ["\x5B\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x67"],
        ["\x5B\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x68"],
        ["\x5B\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x69"],
        ["\x5B\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x6A"],
        ["\x54\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x6B"],
        ["\x5B\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x6C"],
        ["\x5B\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x6D"],
        ["\x5B\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x6E"],
        ["\x54\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x6F"],
        ["\x5B\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x70"],
        ["\x5B\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x71"],
        ["\x5B\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x72"],
        ["\x5B\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x73"],
        ["\x5B\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x74"],
        ["\x5B\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x75"],
        ["\x5B\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x76"],
        ["\x4D\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x77"],
        ["\x5B\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x78"],
        ["\x5B\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x79"],
        ["\x52\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x7A"],
        ["\x5B\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x7B"],
        ["\x5B\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x7C"],
        ["\x5B\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x7D"],
        ["\x5B\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x7E"],
        ["\x53\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x80"],
        ["\x52\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x81"],
        ["\x5B\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x82"],
        ["\x5B\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x83"],
        ["\x5C\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x84"],
        ["\x5C\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x85"],
        ["\x5C\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x86"],
        ["\x5C\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x87"],
        ["\x5C\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x88"],
        ["\x5C\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x89"],
        ["\x4E\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x8A"],
        ["\x53\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x8B"],
        ["\x5C\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x8C"],
        ["\x54\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x8D"],
        ["\x5C\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x8E"],
        ["\x5C\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x8F"],
        ["\x5C\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x90"],
        ["\x52\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x91"],
        ["\x5C\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x92"],
        ["\x5C\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x93"],
        ["\x5B\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x94"],
        ["\x5C\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x95"],
        ["\x5C\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x96"],
        ["\x5C\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x97"],
        ["\x5C\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x98"],
        ["\x5C\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x99"],
        ["\x5C\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x9A"],
        ["\x5C\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x9B"],
        ["\x5C\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x9C"],
        ["\x5C\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x9D"],
        ["\x5C\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x9E"],
        ["\x5C\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\x9F"],
        ["\x5C\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xA0"],
        ["\x5C\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xA1"],
        ["\x5C\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xA2"],
        ["\x5C\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xA3"],
        ["\x5C\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xA4"],
        ["\x54\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xA5"],
        ["\x5C\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xA6"],
        ["\x53\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xA7"],
        ["\x54\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xA8"],
        ["\x5C\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xA9"],
        ["\x5C\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xAA"],
        ["\x5C\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xAB"],
        ["\x5C\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xAC"],
        ["\x53\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xAD"],
        ["\x5C\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xAE"],
        ["\x5C\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xAF"],
        ["\x5C\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xB0"],
        ["\x5C\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xB1"],
        ["\x5C\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xB2"],
        ["\x54\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xB3"],
        ["\x5C\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xB4"],
        ["\x54\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xB5"],
        ["\x5C\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xB6"],
        ["\x5C\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xB7"],
        ["\x53\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xB8"],
        ["\x52\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xB9"],
        ["\x5C\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xBA"],
        ["\x5C\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xBB"],
        ["\x5C\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xBC"],
        ["\x5C\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xBD"],
        ["\x52\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xBE"],
        ["\x5C\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xBF"],
        ["\x5C\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xC0"],
        ["\x5C\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xC1"],
        ["\x5C\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xC2"],
        ["\x5C\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xC3"],
        ["\x51\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xC4"],
        ["\x54\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xC5"],
        ["\x5C\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xC6"],
        ["\x5C\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xC7"],
        ["\x5C\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xC8"],
        ["\x5C\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xC9"],
        ["\x5C\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xCA"],
        ["\x5C\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xCB"],
        ["\x5C\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xCC"],
        ["\x5C\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xCD"],
        ["\x5C\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xCE"],
        ["\x5C\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xCF"],
        ["\x53\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xD0"],
        ["\x5C\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xD1"],
        ["\x54\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xD2"],
        ["\x5C\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xD3"],
        ["\x5C\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xD4"],
        ["\x5C\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xD5"],
        ["\x53\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xD6"],
        ["\x5C\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xD7"],
        ["\x5C\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xD8"],
        ["\x5C\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xD9"],
        ["\x5C\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xDA"],
        ["\x5C\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xDB"],
        ["\x5C\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xDC"],
        ["\x5C\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xDD"],
        ["\x5C\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xDE"],
        ["\x5C\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xDF"],
        ["\x53\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xE0"],
        ["\x5C\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xE1"],
        ["\x5C\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xE2"],
        ["\x5C\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xE3"],
        ["\x5C\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xE4"],
        ["\x5C\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xE5"],
        ["\x5C\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xE6"],
        ["\x5C\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xE7"],
        ["\x5C\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xE8"],
        ["\x5C\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xE9"],
        ["\x5C\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xEA"],
        ["\x5C\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xEB"],
        ["\x5C\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xEC"],
        ["\x5C\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xED"],
        ["\x5C\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xEE"],
        ["\x5C\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xEF"],
        ["\x5C\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xF0"],
        ["\x5C\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xF1"],
        ["\x5C\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xF2"],
        ["\x5C\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xF3"],
        ["\x5C\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xF4"],
        ["\x5C\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xF5"],
        ["\x5C\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xF6"],
        ["\x5C\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xF7"],
        ["\x5C\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xF8"],
        ["\x5C\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xF9"],
        ["\x5C\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xFA"],
        ["\x5C\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xFB"],
        ["\x5C\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9E\xFC"],
        ["\x5C\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x40"],
        ["\x5C\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x41"],
        ["\x5C\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x42"],
        ["\x52\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x43"],
        ["\x5C\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x44"],
        ["\x5C\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x45"],
        ["\x5C\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x46"],
        ["\x5C\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x47"],
        ["\x5C\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x48"],
        ["\x5C\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x49"],
        ["\x53\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x4A"],
        ["\x5C\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x4B"],
        ["\x5C\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x4C"],
        ["\x5C\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x4D"],
        ["\x52\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x4E"],
        ["\x5C\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x4F"],
        ["\x5C\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x50"],
        ["\x5C\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x51"],
        ["\x5C\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x52"],
        ["\x5C\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x53"],
        ["\x67\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x54"],
        ["\x5C\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x55"],
        ["\x5C\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x56"],
        ["\x5C\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x57"],
        ["\x5C\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x58"],
        ["\x5C\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x59"],
        ["\x5C\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x5A"],
        ["\x5C\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x5B"],
        ["\x5C\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x5C"],
        ["\x5C\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x5D"],
        ["\x5C\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x5E"],
        ["\x5C\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x5F"],
        ["\x5C\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x60"],
        ["\x5C\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x61"],
        ["\x5C\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x62"],
        ["\x5C\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x63"],
        ["\x5C\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x64"],
        ["\x5C\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x65"],
        ["\x5C\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x66"],
        ["\x5C\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x67"],
        ["\x5C\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x68"],
        ["\x5C\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x69"],
        ["\x5C\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x6A"],
        ["\x5C\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x6B"],
        ["\x5C\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x6C"],
        ["\x5C\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x6D"],
        ["\x5C\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x6E"],
        ["\x5C\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x6F"],
        ["\x5C\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x70"],
        ["\x5C\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x71"],
        ["\x5C\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x72"],
        ["\x5C\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x73"],
        ["\x5C\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x74"],
        ["\x5C\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x75"],
        ["\x5C\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x76"],
        ["\x5C\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x77"],
        ["\x5C\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x78"],
        ["\x5C\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x79"],
        ["\x5C\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x7A"],
        ["\x5C\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x7B"],
        ["\x5C\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x7C"],
        ["\x5C\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x7D"],
        ["\x5C\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x7E"],
        ["\x68\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x80"],
        ["\x5C\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x81"],
        ["\x5C\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x82"],
        ["\x5C\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x83"],
        ["\x5C\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x84"],
        ["\x5C\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x85"],
        ["\x5C\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x86"],
        ["\x5C\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x87"],
        ["\x5C\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x88"],
        ["\x5C\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x89"],
        ["\x52\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x8A"],
        ["\x5C\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x8B"],
        ["\x5C\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x8C"],
        ["\x5D\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x8D"],
        ["\x5D\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x8E"],
        ["\x5D\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x8F"],
        ["\x5D\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x90"],
        ["\x5D\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x91"],
        ["\x5D\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x92"],
        ["\x5D\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x93"],
        ["\x5D\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x94"],
        ["\x5D\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x95"],
        ["\x5D\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x96"],
        ["\x54\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x97"],
        ["\x5D\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x98"],
        ["\x55\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x99"],
        ["\x5D\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x9A"],
        ["\x5D\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x9B"],
        ["\x5D\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x9C"],
        ["\x5D\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x9D"],
        ["\x5D\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x9E"],
        ["\x5D\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\x9F"],
        ["\x5D\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xA0"],
        ["\x5D\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xA1"],
        ["\x5D\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xA2"],
        ["\x5D\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xA3"],
        ["\x5D\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xA4"],
        ["\x63\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xA5"],
        ["\x5D\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xA6"],
        ["\x5D\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xA7"],
        ["\x5D\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xA8"],
        ["\x50\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xA9"],
        ["\x52\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xAA"],
        ["\x52\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xAB"],
        ["\x5D\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xAC"],
        ["\x5D\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xAD"],
        ["\x5D\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xAE"],
        ["\x5D\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xAF"],
        ["\x5D\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xB0"],
        ["\x5D\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xB1"],
        ["\x5D\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xB2"],
        ["\x5D\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xB3"],
        ["\x5D\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xB4"],
        ["\x5D\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xB5"],
        ["\x5D\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xB6"],
        ["\x51\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xB7"],
        ["\x5D\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xB8"],
        ["\x5D\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xB9"],
        ["\x51\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xBA"],
        ["\x5D\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xBB"],
        ["\x5D\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xBC"],
        ["\x5D\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xBD"],
        ["\x5D\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xBE"],
        ["\x5D\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xBF"],
        ["\x5D\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xC0"],
        ["\x5D\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xC1"],
        ["\x5D\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xC2"],
        ["\x5D\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xC3"],
        ["\x5D\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xC4"],
        ["\x5D\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xC5"],
        ["\x5D\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xC6"],
        ["\x5D\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xC7"],
        ["\x5D\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xC8"],
        ["\x5D\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xC9"],
        ["\x5D\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xCA"],
        ["\x5D\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xCB"],
        ["\x5D\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xCC"],
        ["\x5D\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xCD"],
        ["\x5D\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xCE"],
        ["\x5D\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"],
        ["\x5D\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xD0"],
        ["\x5D\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xD1"],
        ["\x5D\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xD2"],
        ["\x5D\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xD3"],
        ["\x5D\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xD4"],
        ["\x5D\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xD5"],
        ["\x5D\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xD6"],
        ["\x5D\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xD7"],
        ["\x5D\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xD8"],
        ["\x5D\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xD9"],
        ["\x5D\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xDA"],
        ["\x5D\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xDB"],
        ["\x5D\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xDC"],
        ["\x5D\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xDD"],
        ["\x5D\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xDE"],
        ["\x5D\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xDF"],
        ["\x5D\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xE0"],
        ["\x5D\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xE1"],
        ["\x5D\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xE2"],
        ["\x5D\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xE3"],
        ["\x52\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xE4"],
        ["\x5D\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xE5"],
        ["\x52\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xE6"],
        ["\x5D\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xE7"],
        ["\x5D\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xE8"],
        ["\x5D\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xE9"],
        ["\x5D\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xEA"],
        ["\x5D\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xEB"],
        ["\x5D\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xEC"],
        ["\x5D\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xED"],
        ["\x53\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xEE"],
        ["\x5D\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xEF"],
        ["\x5D\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xF0"],
        ["\x5D\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xF1"],
        ["\x55\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xF2"],
        ["\x53\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xF3"],
        ["\x5D\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xF4"],
        ["\x5D\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xF5"],
        ["\x5D\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xF6"],
        ["\x5D\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xF7"],
        ["\x5D\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xF8"],
        ["\x5D\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xF9"],
        ["\x5D\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xFA"],
        ["\x5D\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xFB"],
        ["\x5D\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9F\xFC"],
        ["\x5D\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x40"],
        ["\x5D\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x41"],
        ["\x5D\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x42"],
        ["\x5D\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x43"],
        ["\x5D\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x44"],
        ["\x5D\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x45"],
        ["\x55\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x46"],
        ["\x5D\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x47"],
        ["\x5D\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x48"],
        ["\x5D\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x49"],
        ["\x5D\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x4A"],
        ["\x5D\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x4B"],
        ["\x5D\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x4C"],
        ["\x5D\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x4D"],
        ["\x5D\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x4E"],
        ["\x5D\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x4F"],
        ["\x5D\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x50"],
        ["\x5D\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x51"],
        ["\x5D\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x52"],
        ["\x5D\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x53"],
        ["\x5D\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x54"],
        ["\x5D\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x55"],
        ["\x4E\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x56"],
        ["\x5D\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x57"],
        ["\x5D\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x58"],
        ["\x5D\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],
        ["\x5D\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x5A"],
        ["\x5D\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x5B"],
        ["\x5D\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x5C"],
        ["\x5D\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x5D"],
        ["\x5D\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x5E"],
        ["\x50\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x5F"],
        ["\x5D\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x60"],
        ["\x5D\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x61"],
        ["\x5D\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x62"],
        ["\x5D\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],
        ["\x5D\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x64"],
        ["\x5D\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x65"],
        ["\x5D\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x66"],
        ["\x5D\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x67"],
        ["\x51\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\x5D\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\x5D\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x6A"],
        ["\x5D\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x6B"],
        ["\x52\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x6C"],
        ["\x5D\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x6D"],
        ["\x5D\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],
        ["\x5D\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x6F"],
        ["\x5D\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x70"],
        ["\x5D\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x71"],
        ["\x5D\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x72"],
        ["\x5D\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x73"],
        ["\x5D\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\x4F\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\x5D\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],
        ["\x5D\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x77"],
        ["\x5D\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\x5D\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\x52\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x7A"],
        ["\x5D\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x7B"],
        ["\x5D\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x7C"],
        ["\x5D\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x7D"],
        ["\x53\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x7E"],
        ["\x5D\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x80"],
        ["\x5D\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x81"],
        ["\x5D\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x82"],
        ["\x5D\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x83"],
        ["\x5D\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x84"],
        ["\x53\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x85"],
        ["\x68\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x86"],
        ["\x5E\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x87"],
        ["\x5D\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x88"],
        ["\x5E\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x89"],
        ["\x5E\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x8A"],
        ["\x5E\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x8B"],
        ["\x5E\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x8C"],
        ["\x5E\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x8D"],
        ["\x5E\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x8E"],
        ["\x5E\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x8F"],
        ["\x5E\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x90"],
        ["\x54\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x91"],
        ["\x5E\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x92"],
        ["\x5E\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x93"],
        ["\x5E\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x94"],
        ["\x5E\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x95"],
        ["\x5E\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x96"],
        ["\x5E\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x97"],
        ["\x5E\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x98"],
        ["\x5E\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x99"],
        ["\x5E\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x9A"],
        ["\x5E\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x9B"],
        ["\x5E\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x9C"],
        ["\x5E\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x9D"],
        ["\x5E\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x9E"],
        ["\x5E\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\x9F"],
        ["\x5E\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA0"],
        ["\x5E\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\x5E\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\x53\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\x5E\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\x5E\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\x5E\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\x5E\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\x5E\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\x5E\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\x5E\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\x5E\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\x5E\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\x5E\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\x5E\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\x5E\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\x5E\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\x5E\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\x5E\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\x5E\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\x5E\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\x5E\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\x5E\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\x5E\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\x5E\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\x5E\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\x5E\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\x5E\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\x5E\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\x5E\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\x5E\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\x5E\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\x5E\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\x5E\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\x5E\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\x5E\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\x5E\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\x56\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\x5E\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\x5E\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\x5E\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\x5E\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\x5E\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\x5E\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\x5E\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\x5E\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\x5E\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\x5E\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\x5E\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\x5E\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\x5E\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\x5E\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\x5E\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\x5E\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\x5E\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\x5E\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\x5E\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\x5E\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\x51\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\x5E\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\x5E\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\x5E\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\x5E\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\x5E\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\x5E\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\x5E\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\x5E\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\x5E\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\x5E\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\x5E\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\x5E\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\x5E\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\x5E\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\x5E\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\x5E\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\x5E\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\x5E\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\x5E\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\x5E\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\x5E\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\x5E\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\x5E\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\x5E\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\x5E\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\x68\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\x5E\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\x50\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\x5E\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\x5E\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\x5E\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\x5E\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\x5E\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\x5E\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\x5E\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x40"],
        ["\x5E\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x41"],
        ["\x5E\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x42"],
        ["\x5E\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x43"],
        ["\x5E\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x44"],
        ["\x5E\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x45"],
        ["\x5E\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x46"],
        ["\x5E\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x47"],
        ["\x5E\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x48"],
        ["\x5E\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x49"],
        ["\x5E\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x4A"],
        ["\x5E\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x4B"],
        ["\x5E\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x4C"],
        ["\x5E\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x4D"],
        ["\x5E\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x4E"],
        ["\x5E\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x4F"],
        ["\x53\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x50"],
        ["\x5E\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x51"],
        ["\x5E\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x52"],
        ["\x5E\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x53"],
        ["\x5E\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x54"],
        ["\x5E\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x55"],
        ["\x5E\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x56"],
        ["\x5E\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x57"],
        ["\x5E\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x58"],
        ["\x5E\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x59"],
        ["\x5E\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x5A"],
        ["\x5E\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x5B"],
        ["\x5E\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x5C"],
        ["\x52\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x5D"],
        ["\x5E\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x5E"],
        ["\x5E\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x5F"],
        ["\x5E\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x60"],
        ["\x5E\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x61"],
        ["\x5E\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x62"],
        ["\x5E\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x63"],
        ["\x5E\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x64"],
        ["\x5E\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x65"],
        ["\x5E\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x66"],
        ["\x5E\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x67"],
        ["\x5E\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x68"],
        ["\x5E\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x69"],
        ["\x5E\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x6A"],
        ["\x5E\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x6B"],
        ["\x5E\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x6C"],
        ["\x5E\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x6D"],
        ["\x5E\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x6E"],
        ["\x5E\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x6F"],
        ["\x5E\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x70"],
        ["\x5E\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x71"],
        ["\x5E\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x72"],
        ["\x5E\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x73"],
        ["\x5E\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x74"],
        ["\x5E\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x75"],
        ["\x5E\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x76"],
        ["\x5E\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x77"],
        ["\x5F\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x78"],
        ["\x5F\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x79"],
        ["\x5F\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x7A"],
        ["\x5F\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x7B"],
        ["\x5F\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x7C"],
        ["\x5F\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x7D"],
        ["\x5F\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x7E"],
        ["\x5F\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x80"],
        ["\x5F\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x81"],
        ["\x5F\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x82"],
        ["\x5F\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x83"],
        ["\x5F\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x84"],
        ["\x5F\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x85"],
        ["\x5F\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x86"],
        ["\x52\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x87"],
        ["\x5F\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x88"],
        ["\x5F\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x89"],
        ["\x5F\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x8A"],
        ["\x5F\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x8B"],
        ["\x5F\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x8C"],
        ["\x5F\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x8D"],
        ["\x5F\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x8E"],
        ["\x5F\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x8F"],
        ["\x5F\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x90"],
        ["\x5F\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x91"],
        ["\x5F\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x92"],
        ["\x5F\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x93"],
        ["\x5F\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x94"],
        ["\x5F\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x95"],
        ["\x5F\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x96"],
        ["\x5F\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x97"],
        ["\x5F\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x98"],
        ["\x5F\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x99"],
        ["\x5F\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x9A"],
        ["\x5F\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x9B"],
        ["\x5F\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x9C"],
        ["\x5F\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x9D"],
        ["\x5F\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x9E"],
        ["\x5F\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\x9F"],
        ["\x5F\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA0"],
        ["\x53\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\x5F\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\x5F\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\x5F\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\x5F\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\x5F\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\x52\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\x53\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\x4E\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\x5F\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\x5F\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\x5F\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\x5F\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\x5F\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\x5F\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\x5F\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\x5F\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\x5F\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\x5F\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\x5F\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\x5F\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\x5F\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\x5F\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\x53\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\x5F\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\x5F\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\x5F\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\x5F\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\x5F\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\x5F\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\x5F\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\x5F\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\x51\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\x5F\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\x5F\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\x5F\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\x5F\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\x5F\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\x5F\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\x5F\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\x5F\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\x5F\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\x5F\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\x5F\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\x5F\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\x5F\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\x5F\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\x5F\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\x5F\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\x5F\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\x5F\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\x5F\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\x5F\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\x5F\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\x5F\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\x5F\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\x5F\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\x5F\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\x5F\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\x5F\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\x5F\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\x53\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\x5F\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\x5F\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\x5F\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\x5F\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\x5F\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\x5F\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\x5F\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\x51\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\x5F\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\x51\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\x5F\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\x5F\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\x5F\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\x5F\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\x5F\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\x5F\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\x5F\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\x5F\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\x5F\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\x5F\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\x5F\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\x5F\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\x5F\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\x5F\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\x5F\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\x5F\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\x5F\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\x5F\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\x5F\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\x5F\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\x5F\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x40"],
        ["\x5F\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x41"],
        ["\x5F\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x42"],
        ["\x5F\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x43"],
        ["\x5F\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x44"],
        ["\x4D\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x45"],
        ["\x5F\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x46"],
        ["\x5F\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x47"],
        ["\x5F\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x48"],
        ["\x5F\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x49"],
        ["\x5F\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],
        ["\x5F\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],
        ["\x53\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],
        ["\x5F\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x4D"],
        ["\x5F\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x4E"],
        ["\x5F\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x4F"],
        ["\x55\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x50"],
        ["\x52\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x51"],
        ["\x5F\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x52"],
        ["\x5F\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x53"],
        ["\x5F\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x54"],
        ["\x4F\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x55"],
        ["\x51\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x56"],
        ["\x5F\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x57"],
        ["\x54\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x58"],
        ["\x5F\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x59"],
        ["\x53\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x5A"],
        ["\x5F\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],
        ["\x5F\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x5C"],
        ["\x5F\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x5D"],
        ["\x5F\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x5E"],
        ["\x5F\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x5F"],
        ["\x54\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x60"],
        ["\x5F\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x61"],
        ["\x5F\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x62"],
        ["\x5F\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x63"],
        ["\x5F\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x64"],
        ["\x5F\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x65"],
        ["\x53\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x66"],
        ["\x5F\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x67"],
        ["\x50\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x68"],
        ["\x5F\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x69"],
        ["\x5F\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x6A"],
        ["\x5F\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x6B"],
        ["\x5F\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x6C"],
        ["\x5F\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x6D"],
        ["\x5F\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x6E"],
        ["\x5F\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],
        ["\x5F\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\x5F\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\x5F\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\x5F\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\x5F\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\x5F\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\x5F\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\x5F\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\x60\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\x5F\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\x5F\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\x5F\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\x60\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\x52\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\x60\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\x60\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\x60\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\x60\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\x60\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\x60\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84"],
        ["\x60\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85"],
        ["\x60\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86"],
        ["\x60\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x87"],
        ["\x60\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88"],
        ["\x60\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89"],
        ["\x60\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A"],
        ["\x60\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B"],
        ["\x60\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C"],
        ["\x60\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8D"],
        ["\x60\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E"],
        ["\x60\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F"],
        ["\x60\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x90"],
        ["\x60\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91"],
        ["\x60\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x92"],
        ["\x60\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x93"],
        ["\x60\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94"],
        ["\x60\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x95"],
        ["\x60\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96"],
        ["\x60\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97"],
        ["\x53\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98"],
        ["\x60\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99"],
        ["\x60\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9A"],
        ["\x60\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9B"],
        ["\x60\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C"],
        ["\x60\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D"],
        ["\x60\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9E"],
        ["\x60\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x9F"],
        ["\x54\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA0"],
        ["\x60\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\x60\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\x60\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\x60\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\x60\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\x54\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\x60\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\x50\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\x60\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\x60\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\x53\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\x60\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\x60\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\x60\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\x60\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\x60\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\x60\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\x60\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\x55\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\x60\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\x60\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\x60\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\x60\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\x60\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\x51\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\x60\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\x60\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\x60\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\x60\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\x60\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\x60\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\x4F\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\x60\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\x60\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\x60\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\x4C\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\x60\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\x60\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\x60\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\x60\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\x60\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\x51\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\x60\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\x60\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\x60\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\x60\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\x60\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\x60\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\x60\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\x60\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\x60\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\x60\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\x60\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\x4F\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\x51\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\x60\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\x60\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\x60\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\x60\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\x52\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\x60\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\x60\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\x60\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\x60\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\x60\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\x60\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\x60\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\x60\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\x60\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\x60\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\x60\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\x60\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\x60\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\x60\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\x60\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\x60\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\x60\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\x60\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\x51\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\x60\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\x60\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\x60\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\x60\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\x60\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\x60\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\x67\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\x60\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\x60\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\x60\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\x60\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\x52\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\x60\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\x60\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x40"],
        ["\x60\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x41"],
        ["\x60\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x42"],
        ["\x60\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x43"],
        ["\x60\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x44"],
        ["\x60\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x45"],
        ["\x60\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x46"],
        ["\x60\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x47"],
        ["\x60\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x48"],
        ["\x60\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x49"],
        ["\x60\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\x60\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\x60\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\x60\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\x52\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\x60\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\x60\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\x60\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x51"],
        ["\x60\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x52"],
        ["\x60\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x53"],
        ["\x60\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x54"],
        ["\x60\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x55"],
        ["\x53\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x56"],
        ["\x54\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x57"],
        ["\x54\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x58"],
        ["\x54\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x59"],
        ["\x60\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],
        ["\x60\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x5B"],
        ["\x60\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x5C"],
        ["\x60\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x5D"],
        ["\x60\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x5E"],
        ["\x60\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],
        ["\x60\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],
        ["\x60\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],
        ["\x60\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x62"],
        ["\x60\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],
        ["\x60\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x64"],
        ["\x60\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x65"],
        ["\x60\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x66"],
        ["\x60\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x67"],
        ["\x60\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],
        ["\x60\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],
        ["\x60\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x6A"],
        ["\x60\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x6B"],
        ["\x60\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x6C"],
        ["\x60\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x6D"],
        ["\x60\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x6E"],
        ["\x60\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x6F"],
        ["\x55\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x70"],
        ["\x60\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],
        ["\x60\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],
        ["\x60\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x73"],
        ["\x60\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x74"],
        ["\x60\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x75"],
        ["\x60\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x76"],
        ["\x5B\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x77"],
        ["\x60\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\x60\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],
        ["\x60\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x7A"],
        ["\x60\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x7B"],
        ["\x60\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x7C"],
        ["\x60\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x7D"],
        ["\x60\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x7E"],
        ["\x60\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80"],
        ["\x60\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81"],
        ["\x61\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82"],
        ["\x60\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83"],
        ["\x60\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x84"],
        ["\x60\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x85"],
        ["\x60\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x86"],
        ["\x61\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x87"],
        ["\x61\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x88"],
        ["\x61\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x89"],
        ["\x61\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A"],
        ["\x61\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B"],
        ["\x61\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C"],
        ["\x61\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D"],
        ["\x60\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E"],
        ["\x61\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F"],
        ["\x61\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x90"],
        ["\x61\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x91"],
        ["\x52\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x92"],
        ["\x61\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x93"],
        ["\x61\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x94"],
        ["\x61\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x95"],
        ["\x52\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x96"],
        ["\x61\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x97"],
        ["\x61\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x98"],
        ["\x61\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x99"],
        ["\x61\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A"],
        ["\x61\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B"],
        ["\x53\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9C"],
        ["\x61\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D"],
        ["\x61\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9E"],
        ["\x61\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F"],
        ["\x61\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0"],
        ["\x54\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\x61\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\x51\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\x61\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\x61\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\x61\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\x61\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\x61\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\x61\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\x61\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\x61\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\x61\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\x61\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\x61\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\x61\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\x61\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\x61\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\x61\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\x61\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\x61\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\x61\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\x61\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\x61\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\x61\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\x61\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\x61\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\x61\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\x61\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\x61\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\x61\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\x61\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\x61\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\x61\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\x61\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\x61\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\x54\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\x61\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\x61\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\x61\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\x61\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\x61\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\x66\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\x53\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\x61\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\x61\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\x61\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\x54\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\x61\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\x61\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\x61\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\x61\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\x61\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\x61\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\x61\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\x61\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\x61\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\x61\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\x54\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\x61\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\x61\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\x61\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\x61\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\x61\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\x61\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\x61\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\x61\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\x61\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\x61\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\x61\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\x53\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\x61\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\x52\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\x61\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\x61\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\x61\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\x61\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\x61\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\x61\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\x61\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\x61\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\x61\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\x61\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\x61\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\x52\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\x61\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\x61\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\x61\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\x61\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\x4C\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\x61\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\x61\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\x61\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\x66\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x40"],
        ["\x61\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x41"],
        ["\x61\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x42"],
        ["\x61\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x43"],
        ["\x61\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x44"],
        ["\x61\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x45"],
        ["\x61\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x46"],
        ["\x61\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x47"],
        ["\x61\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x48"],
        ["\x61\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x49"],
        ["\x61\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x4A"],
        ["\x61\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],
        ["\x61\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x4C"],
        ["\x61\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x4D"],
        ["\x61\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x4E"],
        ["\x61\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\x61\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\x61\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x51"],
        ["\x61\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x52"],
        ["\x61\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x53"],
        ["\x61\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x54"],
        ["\x61\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x55"],
        ["\x61\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x56"],
        ["\x61\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x57"],
        ["\x61\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x58"],
        ["\x61\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x59"],
        ["\x61\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x5A"],
        ["\x61\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],
        ["\x61\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],
        ["\x61\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],
        ["\x61\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],
        ["\x61\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x5F"],
        ["\x61\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],
        ["\x61\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x61"],
        ["\x61\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x62"],
        ["\x61\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x63"],
        ["\x61\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x64"],
        ["\x61\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x65"],
        ["\x61\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x66"],
        ["\x61\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x67"],
        ["\x51\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\x61\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\x61\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\x61\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\x61\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x6C"],
        ["\x61\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x6D"],
        ["\x61\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x6E"],
        ["\x53\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],
        ["\x62\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x70"],
        ["\x61\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x71"],
        ["\x61\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x72"],
        ["\x61\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],
        ["\x61\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\x61\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x75"],
        ["\x61\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x76"],
        ["\x61\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x77"],
        ["\x61\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x78"],
        ["\x61\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x79"],
        ["\x54\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],
        ["\x61\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x7B"],
        ["\x61\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x7C"],
        ["\x61\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x7D"],
        ["\x61\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\x61\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x80"],
        ["\x61\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x81"],
        ["\x61\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x82"],
        ["\x61\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x83"],
        ["\x61\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x84"],
        ["\x61\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x85"],
        ["\x61\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x86"],
        ["\x53\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x87"],
        ["\x61\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x88"],
        ["\x61\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x89"],
        ["\x61\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8A"],
        ["\x61\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B"],
        ["\x61\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C"],
        ["\x61\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8D"],
        ["\x61\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8E"],
        ["\x61\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F"],
        ["\x61\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x90"],
        ["\x61\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x91"],
        ["\x61\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x92"],
        ["\x61\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x93"],
        ["\x61\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x94"],
        ["\x62\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x95"],
        ["\x62\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x96"],
        ["\x61\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x97"],
        ["\x61\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x98"],
        ["\x61\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x99"],
        ["\x62\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A"],
        ["\x62\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x9B"],
        ["\x62\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C"],
        ["\x62\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x9D"],
        ["\x62\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x9E"],
        ["\x62\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\x9F"],
        ["\x62\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0"],
        ["\x62\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\x54\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\x62\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\x62\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\x62\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\x62\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\x62\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\x62\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\x62\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\x53\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\x62\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\x62\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\x62\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\x62\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\x62\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\x62\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\x62\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\x62\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\x62\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\x54\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\x62\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\x62\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\x62\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\x62\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\x62\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\x62\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\x62\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\x62\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\x62\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\x62\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\x54\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\x62\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\x62\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\x62\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\x62\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\x62\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\x62\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\x62\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\x62\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\x62\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\x62\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\x62\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\x54\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\x62\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\x62\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\x62\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\x62\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\x62\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\x51\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\x62\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\x62\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\x62\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\x62\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\x62\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\x62\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\x62\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\x62\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\x62\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\x62\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\x62\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\x4B\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\x62\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\x62\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\x62\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\x62\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\x62\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\x62\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\x62\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\x62\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\x62\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\x62\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\x62\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\x62\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\x62\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\x62\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\x62\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\x62\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\x62\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\x54\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\x62\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\x62\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\x62\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\x62\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\x62\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\x62\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\x62\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\x62\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\x51\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\x62\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\x62\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\x62\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\x62\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\x62\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x40"],
        ["\x54\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x41"],
        ["\x62\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x42"],
        ["\x62\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x43"],
        ["\x62\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x44"],
        ["\x62\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x45"],
        ["\x62\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x46"],
        ["\x62\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x47"],
        ["\x62\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x48"],
        ["\x62\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x49"],
        ["\x62\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],
        ["\x62\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x4B"],
        ["\x62\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x4C"],
        ["\x4C\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x4D"],
        ["\x62\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x4E"],
        ["\x62\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x4F"],
        ["\x62\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],
        ["\x62\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x51"],
        ["\x62\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x52"],
        ["\x62\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x53"],
        ["\x62\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x54"],
        ["\x62\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x55"],
        ["\x62\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x56"],
        ["\x62\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x57"],
        ["\x62\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x58"],
        ["\x62\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x59"],
        ["\x62\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x5A"],
        ["\x62\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x5B"],
        ["\x62\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x5C"],
        ["\x62\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x5D"],
        ["\x62\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x5E"],
        ["\x62\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x5F"],
        ["\x62\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x60"],
        ["\x53\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x61"],
        ["\x4E\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],
        ["\x62\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x63"],
        ["\x62\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],
        ["\x62\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x65"],
        ["\x62\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x66"],
        ["\x62\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x67"],
        ["\x62\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x68"],
        ["\x52\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x69"],
        ["\x62\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],
        ["\x62\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],
        ["\x62\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],
        ["\x62\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x6D"],
        ["\x62\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x6E"],
        ["\x62\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x6F"],
        ["\x62\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x70"],
        ["\x62\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x71"],
        ["\x62\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x72"],
        ["\x62\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x73"],
        ["\x62\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x74"],
        ["\x62\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],
        ["\x62\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x76"],
        ["\x62\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x77"],
        ["\x62\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x78"],
        ["\x53\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],
        ["\x62\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x7A"],
        ["\x62\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x7B"],
        ["\x62\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x7C"],
        ["\x62\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x7D"],
        ["\x62\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x7E"],
        ["\x62\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80"],
        ["\x62\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81"],
        ["\x4F\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82"],
        ["\x62\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83"],
        ["\x62\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84"],
        ["\x62\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85"],
        ["\x62\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86"],
        ["\x62\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87"],
        ["\x62\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88"],
        ["\x62\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89"],
        ["\x62\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A"],
        ["\x62\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B"],
        ["\x62\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C"],
        ["\x62\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D"],
        ["\x62\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E"],
        ["\x62\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F"],
        ["\x52\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90"],
        ["\x62\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91"],
        ["\x62\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92"],
        ["\x62\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93"],
        ["\x62\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94"],
        ["\x63\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95"],
        ["\x62\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96"],
        ["\x62\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97"],
        ["\x62\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98"],
        ["\x62\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99"],
        ["\x63\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A"],
        ["\x63\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B"],
        ["\x63\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C"],
        ["\x63\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D"],
        ["\x63\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E"],
        ["\x63\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F"],
        ["\x63\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0"],
        ["\x63\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\x55\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\x63\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\x63\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\x63\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\x63\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\x63\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\x63\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\x63\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\x63\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\x63\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\x63\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\x63\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\x63\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\x54\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\x63\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\x63\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\x63\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\x63\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\x63\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\x63\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\x63\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\x63\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\x63\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\x63\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\x63\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\x63\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\x63\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\x63\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\x63\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\x63\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\x63\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\x63\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\x63\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\x63\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\x63\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\x63\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\x63\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\x63\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\x63\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\x63\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\x63\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\x63\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\x63\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\x63\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\x63\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\x63\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\x63\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\x63\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\x63\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\x63\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\x63\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\x63\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\x63\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\x63\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\x63\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\x63\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\x63\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\x63\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\x54\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\x63\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\x63\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\x63\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\x63\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\x63\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\x63\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\x63\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\x63\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\x63\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\x63\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\x63\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\x53\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\x63\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\x63\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\x63\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\x63\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\x63\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\x63\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\x63\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\x63\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\x63\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\x63\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\x63\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\x63\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\x50\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\x63\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\x63\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\x63\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\x63\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\x63\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\x63\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\x63\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\x63\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x40"],
        ["\x63\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x41"],
        ["\x63\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x42"],
        ["\x63\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x43"],
        ["\x63\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x44"],
        ["\x63\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x45"],
        ["\x63\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x46"],
        ["\x63\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x47"],
        ["\x63\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x48"],
        ["\x63\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x49"],
        ["\x63\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],
        ["\x63\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x4B"],
        ["\x63\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x4C"],
        ["\x63\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x4D"],
        ["\x63\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x4E"],
        ["\x63\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x4F"],
        ["\x63\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x50"],
        ["\x63\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x51"],
        ["\x63\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x52"],
        ["\x63\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x53"],
        ["\x63\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x54"],
        ["\x63\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x55"],
        ["\x63\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x56"],
        ["\x63\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x57"],
        ["\x53\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x58"],
        ["\x63\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x59"],
        ["\x63\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x5A"],
        ["\x63\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x5B"],
        ["\x63\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x5C"],
        ["\x63\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x5D"],
        ["\x63\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x5E"],
        ["\x63\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x5F"],
        ["\x63\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x60"],
        ["\x63\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x61"],
        ["\x63\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x62"],
        ["\x63\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x63"],
        ["\x63\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x64"],
        ["\x63\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x65"],
        ["\x63\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x66"],
        ["\x63\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x67"],
        ["\x63\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x68"],
        ["\x63\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x69"],
        ["\x63\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x6A"],
        ["\x63\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x6B"],
        ["\x63\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x6C"],
        ["\x63\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x6D"],
        ["\x63\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x6E"],
        ["\x63\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x6F"],
        ["\x63\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x70"],
        ["\x63\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x71"],
        ["\x63\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x72"],
        ["\x63\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x73"],
        ["\x63\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x74"],
        ["\x63\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x75"],
        ["\x63\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x76"],
        ["\x63\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x77"],
        ["\x50\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x78"],
        ["\x63\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x79"],
        ["\x63\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x7A"],
        ["\x63\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x7B"],
        ["\x4E\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x7C"],
        ["\x63\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x7D"],
        ["\x63\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x7E"],
        ["\x63\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80"],
        ["\x63\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81"],
        ["\x63\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82"],
        ["\x63\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83"],
        ["\x63\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84"],
        ["\x63\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85"],
        ["\x63\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86"],
        ["\x63\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87"],
        ["\x63\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88"],
        ["\x63\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89"],
        ["\x63\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A"],
        ["\x63\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B"],
        ["\x63\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C"],
        ["\x63\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D"],
        ["\x63\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E"],
        ["\x63\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F"],
        ["\x63\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90"],
        ["\x63\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91"],
        ["\x63\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92"],
        ["\x63\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93"],
        ["\x64\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94"],
        ["\x53\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95"],
        ["\x63\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96"],
        ["\x64\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97"],
        ["\x64\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98"],
        ["\x64\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99"],
        ["\x64\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A"],
        ["\x64\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B"],
        ["\x64\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C"],
        ["\x64\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D"],
        ["\x64\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E"],
        ["\x64\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F"],
        ["\x64\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0"],
        ["\x64\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\x64\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\x64\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\x64\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\x64\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\x64\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\x64\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\x64\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\x64\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\x64\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\x64\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\x64\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\x64\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\x64\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\x64\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\x64\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\x64\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\x64\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\x64\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\x64\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\x64\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\x64\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\x64\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\x64\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\x64\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\x64\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\x64\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\x64\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\x64\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\x64\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\x64\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\x64\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\x64\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\x64\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\x64\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\x64\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\x64\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\x64\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\x64\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\x64\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\x64\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\x64\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\x55\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\x64\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\x64\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\x64\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\x64\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\x64\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\x53\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\x55\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\x64\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\x64\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\x64\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\x64\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\x64\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\x68\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\x64\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\x64\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\x64\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\x64\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\x64\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\x64\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\x64\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\x51\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\x64\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\x51\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\x64\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\x64\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\x64\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\x64\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\x64\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\x64\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\x64\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\x64\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\x64\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\x64\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\x64\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\x64\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\x64\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\x64\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\x64\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\x64\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\x64\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\x64\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\x64\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\x64\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\x64\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\x64\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\x64\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\x64\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\x64\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\x64\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\x64\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x40"],
        ["\x64\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x41"],
        ["\x64\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x42"],
        ["\x64\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x43"],
        ["\x64\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x44"],
        ["\x64\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x45"],
        ["\x64\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x46"],
        ["\x64\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x47"],
        ["\x50\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x48"],
        ["\x64\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x49"],
        ["\x64\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x4A"],
        ["\x64\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x4B"],
        ["\x64\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x4C"],
        ["\x64\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x4D"],
        ["\x64\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x4E"],
        ["\x64\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x4F"],
        ["\x64\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x50"],
        ["\x64\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x51"],
        ["\x64\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x52"],
        ["\x64\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x53"],
        ["\x64\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x54"],
        ["\x64\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x55"],
        ["\x64\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x56"],
        ["\x64\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x57"],
        ["\x64\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x58"],
        ["\x64\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x59"],
        ["\x50\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x5A"],
        ["\x53\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x5B"],
        ["\x64\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x5C"],
        ["\x64\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x5D"],
        ["\x64\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x5E"],
        ["\x64\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x5F"],
        ["\x64\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x60"],
        ["\x64\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x61"],
        ["\x64\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x62"],
        ["\x64\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x63"],
        ["\x64\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x64"],
        ["\x64\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x65"],
        ["\x64\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x66"],
        ["\x64\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\x64\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\x64\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\x64\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\x64\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\x64\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x6C"],
        ["\x64\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x6D"],
        ["\x64\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x6E"],
        ["\x64\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x6F"],
        ["\x51\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x70"],
        ["\x64\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x71"],
        ["\x64\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x72"],
        ["\x64\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x73"],
        ["\x64\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x74"],
        ["\x64\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x75"],
        ["\x64\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x76"],
        ["\x64\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x77"],
        ["\x64\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x78"],
        ["\x64\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x79"],
        ["\x64\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x7A"],
        ["\x64\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x7B"],
        ["\x64\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x7C"],
        ["\x64\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x7D"],
        ["\x64\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x7E"],
        ["\x64\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],
        ["\x64\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81"],
        ["\x64\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82"],
        ["\x64\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83"],
        ["\x64\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84"],
        ["\x64\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85"],
        ["\x64\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86"],
        ["\x64\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87"],
        ["\x64\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88"],
        ["\x64\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89"],
        ["\x64\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A"],
        ["\x64\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],
        ["\x4E\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C"],
        ["\x64\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D"],
        ["\x51\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E"],
        ["\x64\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F"],
        ["\x64\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90"],
        ["\x64\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91"],
        ["\x54\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92"],
        ["\x64\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93"],
        ["\x64\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94"],
        ["\x64\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95"],
        ["\x65\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96"],
        ["\x65\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97"],
        ["\x65\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98"],
        ["\x65\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99"],
        ["\x65\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A"],
        ["\x65\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B"],
        ["\x54\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],
        ["\x65\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D"],
        ["\x64\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E"],
        ["\x65\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F"],
        ["\x65\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0"],
        ["\x65\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\x65\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\x64\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\x65\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\x65\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\x65\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\x65\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\x65\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\x65\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\x65\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\x65\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\x65\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\x65\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\x65\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\x65\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\x53\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\x65\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\x50\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\x65\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\x65\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\x51\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\x65\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\x65\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\x65\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\x65\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\x65\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\x65\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\x65\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\x65\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\x65\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\x65\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\x65\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\x65\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\x65\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\x65\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\x65\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\x65\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\x65\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\x65\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\x65\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\x65\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\x65\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\x65\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\x65\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\x65\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\x65\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\x65\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\x65\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\x65\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\x65\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\x65\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\x65\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\x65\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\x52\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\x65\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\x65\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\x65\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\x65\x88",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\x65\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\x65\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\x51\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\x65\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\x65\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\x65\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\x65\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\x65\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\x65\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\x65\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\x52\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\x53\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\x65\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\x65\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\x65\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\x65\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\x65\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\x65\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\x65\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\x65\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\x65\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\x65\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\x65\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\x65\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\x65\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\x65\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\x65\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\x65\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\x65\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\x65\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\x65\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\x65\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\x65\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\x52\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\x65\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x40"],
        ["\x65\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x41"],
        ["\x65\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x42"],
        ["\x65\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x43"],
        ["\x65\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x44"],
        ["\x65\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x45"],
        ["\x65\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x46"],
        ["\x52\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x47"],
        ["\x65\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x48"],
        ["\x65\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x49"],
        ["\x65\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x4A"],
        ["\x65\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x4B"],
        ["\x65\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x4C"],
        ["\x53\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x4D"],
        ["\x65\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x4E"],
        ["\x65\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x4F"],
        ["\x65\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x50"],
        ["\x65\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x51"],
        ["\x65\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x52"],
        ["\x65\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x53"],
        ["\x65\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x54"],
        ["\x65\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x55"],
        ["\x65\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x56"],
        ["\x65\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x57"],
        ["\x65\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x58"],
        ["\x65\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x59"],
        ["\x65\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x5A"],
        ["\x65\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x5B"],
        ["\x65\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x5C"],
        ["\x65\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x5D"],
        ["\x65\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x5E"],
        ["\x65\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x5F"],
        ["\x51\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x60"],
        ["\x65\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x61"],
        ["\x65\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x62"],
        ["\x51\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x63"],
        ["\x65\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\x65\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x65"],
        ["\x65\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x66"],
        ["\x65\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x67"],
        ["\x65\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x68"],
        ["\x65\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x69"],
        ["\x65\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x6A"],
        ["\x65\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x6B"],
        ["\x65\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x6C"],
        ["\x65\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x6D"],
        ["\x65\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\x65\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x6F"],
        ["\x65\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x70"],
        ["\x66\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x71"],
        ["\x66\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x72"],
        ["\x65\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x73"],
        ["\x66\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x74"],
        ["\x66\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\x66\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x76"],
        ["\x66\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x77"],
        ["\x66\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x78"],
        ["\x66\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\x66\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x7A"],
        ["\x66\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x7B"],
        ["\x66\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x7C"],
        ["\x66\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x7D"],
        ["\x66\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x7E"],
        ["\x66\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80"],
        ["\x66\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81"],
        ["\x66\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82"],
        ["\x66\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83"],
        ["\x66\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84"],
        ["\x66\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85"],
        ["\x66\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86"],
        ["\x66\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87"],
        ["\x66\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88"],
        ["\x66\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89"],
        ["\x66\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A"],
        ["\x66\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B"],
        ["\x66\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C"],
        ["\x66\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D"],
        ["\x66\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E"],
        ["\x66\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F"],
        ["\x66\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90"],
        ["\x66\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91"],
        ["\x66\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92"],
        ["\x66\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93"],
        ["\x66\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94"],
        ["\x66\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95"],
        ["\x66\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96"],
        ["\x66\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97"],
        ["\x66\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98"],
        ["\x66\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99"],
        ["\x66\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A"],
        ["\x66\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B"],
        ["\x66\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\x66\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D"],
        ["\x52\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E"],
        ["\x66\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F"],
        ["\x66\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0"],
        ["\x66\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\x66\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\x66\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\x66\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\x66\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\x66\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\x66\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\x66\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\x66\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\x66\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\x66\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\x66\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\x66\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\x66\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\x66\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\x66\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\x66\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\x66\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\x54\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\x52\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\x63\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\x66\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\x66\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\x66\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\x66\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\x66\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\x66\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\x66\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\x66\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\x66\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\x66\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\x66\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\x66\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\x66\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\x66\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\x66\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\x66\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\x66\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\x66\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\x66\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\x66\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\x66\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\x66\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\x66\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\x66\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\x66\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\x66\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\x66\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\x66\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\x66\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\x53\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\x53\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\x52\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\x66\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\x66\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\x66\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\x66\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\x66\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\x52\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\x66\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\x66\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\x66\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\x66\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\x66\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\x66\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\x66\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\x66\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\x66\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\x66\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\x66\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\x66\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\x66\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\x66\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\x66\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\x68\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\x66\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\x66\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\x52\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\x66\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\x66\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\x54\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\x50\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\x66\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\x66\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\x66\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\x66\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\x51\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\x66\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\x66\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\x66\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\x66\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\x66\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\x66\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x40"],
        ["\x66\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x41"],
        ["\x66\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x42"],
        ["\x66\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x43"],
        ["\x66\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x44"],
        ["\x66\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x45"],
        ["\x66\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x46"],
        ["\x66\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x47"],
        ["\x66\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x48"],
        ["\x66\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x49"],
        ["\x66\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x4A"],
        ["\x66\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x4B"],
        ["\x66\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x4C"],
        ["\x54\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x4D"],
        ["\x66\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x4E"],
        ["\x66\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x4F"],
        ["\x66\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x50"],
        ["\x66\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x51"],
        ["\x66\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x52"],
        ["\x66\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x53"],
        ["\x66\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x54"],
        ["\x66\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x55"],
        ["\x66\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x56"],
        ["\x66\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x57"],
        ["\x66\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x58"],
        ["\x66\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x59"],
        ["\x66\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x5A"],
        ["\x66\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x5B"],
        ["\x66\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x5C"],
        ["\x66\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x5D"],
        ["\x66\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x5E"],
        ["\x66\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x5F"],
        ["\x52\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x60"],
        ["\x66\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x61"],
        ["\x66\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x62"],
        ["\x66\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\x66\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x64"],
        ["\x66\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x65"],
        ["\x66\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x66"],
        ["\x66\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x67"],
        ["\x66\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x68"],
        ["\x66\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x69"],
        ["\x67\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],
        ["\x67\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x6B"],
        ["\x67\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\x67\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x6D"],
        ["\x67\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x6E"],
        ["\x67\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x6F"],
        ["\x67\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x70"],
        ["\x67\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x71"],
        ["\x67\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x72"],
        ["\x67\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x73"],
        ["\x67\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x74"],
        ["\x67\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x75"],
        ["\x67\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x76"],
        ["\x67\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x77"],
        ["\x67\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x78"],
        ["\x67\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x79"],
        ["\x67\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x7A"],
        ["\x67\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x7B"],
        ["\x67\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x7C"],
        ["\x67\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x7D"],
        ["\x67\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x7E"],
        ["\x67\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80"],
        ["\x67\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81"],
        ["\x67\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82"],
        ["\x67\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83"],
        ["\x67\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84"],
        ["\x67\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85"],
        ["\x67\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86"],
        ["\x67\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87"],
        ["\x67\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88"],
        ["\x67\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89"],
        ["\x67\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A"],
        ["\x67\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B"],
        ["\x67\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C"],
        ["\x67\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D"],
        ["\x67\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E"],
        ["\x67\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F"],
        ["\x67\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90"],
        ["\x67\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91"],
        ["\x67\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x92"],
        ["\x67\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x93"],
        ["\x67\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x94"],
        ["\x67\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x95"],
        ["\x67\x6F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96"],
        ["\x67\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97"],
        ["\x67\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98"],
        ["\x67\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99"],
        ["\x67\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A"],
        ["\x67\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B"],
        ["\x67\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C"],
        ["\x67\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D"],
        ["\x67\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E"],
        ["\x67\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F"],
        ["\x67\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0"],
        ["\x67\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\x67\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\x67\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\x67\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\x67\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\x67\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\x67\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\x67\x81",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\x67\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\x67\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\x67\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\x67\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\x67\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\x67\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\x67\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\x53\x89",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\x67\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\x67\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\x67\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\x67\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\x67\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\x67\x92",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\x67\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\x67\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\x67\x96",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\x67\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\x67\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\x67\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\x67\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\x67\x9C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\x67\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\x67\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\x67\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\x67\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\x67\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\x67\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\x67\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\x67\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\x67\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\x67\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\x67\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\x67\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\x51\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\x67\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\x67\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\x55\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\x67\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\x67\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\x67\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\x67\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\x67\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\x67\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\x67\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\x67\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\x67\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\x67\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\x67\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\x67\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\x67\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\x67\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\x67\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\x67\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\x67\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\x67\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\x67\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\x67\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\x67\xC2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\x67\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\x67\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\x67\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\x67\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\x67\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\x67\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\x67\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\x67\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\x54\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\x67\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\x67\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\x67\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\x67\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\x67\xCF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\x50\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\x67\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\x67\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\x67\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\x67\xD3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\x67\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\x67\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\x67\xD6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\x67\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\x67\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\x67\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\x67\xDB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x40"],
        ["\x67\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x41"],
        ["\x67\xE0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x42"],
        ["\x67\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x43"],
        ["\x67\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x44"],
        ["\x67\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x45"],
        ["\x67\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x46"],
        ["\x53\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x47"],
        ["\x67\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x48"],
        ["\x67\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x49"],
        ["\x67\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x4A"],
        ["\x67\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x4B"],
        ["\x67\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x4C"],
        ["\x67\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x4D"],
        ["\x67\xE9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x4E"],
        ["\x67\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x4F"],
        ["\x67\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x50"],
        ["\x67\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x51"],
        ["\x67\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x52"],
        ["\x67\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x53"],
        ["\x67\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x54"],
        ["\x67\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x55"],
        ["\x67\xF2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x56"],
        ["\x67\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x57"],
        ["\x67\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x58"],
        ["\x67\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x59"],
        ["\x67\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x5A"],
        ["\x67\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x5B"],
        ["\x67\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x5C"],
        ["\x67\xFA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x5D"],
        ["\x67\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x5E"],
        ["\x67\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x5F"],
        ["\x67\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x60"],
        ["\x68\x41",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x61"],
        ["\x68\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x62"],
        ["\x68\x43",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x63"],
        ["\x68\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x64"],
        ["\x68\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x65"],
        ["\x68\x46",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x66"],
        ["\x68\x47",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x67"],
        ["\x68\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x68"],
        ["\x51\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x69"],
        ["\x68\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x6A"],
        ["\x68\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x6B"],
        ["\x68\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x6C"],
        ["\x68\x4C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x6D"],
        ["\x53\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x6E"],
        ["\x68\x4D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x6F"],
        ["\x68\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x70"],
        ["\x68\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x71"],
        ["\x68\x52",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x72"],
        ["\x68\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x73"],
        ["\x51\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x74"],
        ["\x68\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x75"],
        ["\x68\x55",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x76"],
        ["\x68\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x77"],
        ["\x68\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x78"],
        ["\x68\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x79"],
        ["\x68\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x7A"],
        ["\x68\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x7B"],
        ["\x68\x5C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x7C"],
        ["\x68\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x7D"],
        ["\x68\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x7E"],
        ["\x68\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x80"],
        ["\x68\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x81"],
        ["\x68\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x82"],
        ["\x68\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x83"],
        ["\x68\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x84"],
        ["\x68\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x85"],
        ["\x68\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x86"],
        ["\x68\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x87"],
        ["\x68\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x88"],
        ["\x68\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x89"],
        ["\x68\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x8A"],
        ["\x68\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x8B"],
        ["\x68\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x8C"],
        ["\x68\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x8D"],
        ["\x68\x6D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x8E"],
        ["\x68\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x8F"],
        ["\x68\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x90"],
        ["\x68\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x91"],
        ["\x68\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x92"],
        ["\x68\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x93"],
        ["\x68\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x94"],
        ["\x68\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x95"],
        ["\x68\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x96"],
        ["\x68\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x97"],
        ["\x68\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x98"],
        ["\x68\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x99"],
        ["\x68\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x9A"],
        ["\x68\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x9B"],
        ["\x68\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x9C"],
        ["\x68\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x9D"],
        ["\x68\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x9E"],
        ["\x4E\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\x9F"],
        ["\x4D\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA0"],
        ["\x52\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\x5E\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\x68\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\x4F\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\x41\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x40"],
        ["\x41\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x41"],
        ["\x41\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x42"],
        ["\x41\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x43"],
        ["\x41\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x44"],
        ["\x41\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x45"],
        ["\x41\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x46"],
        ["\x41\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x47"],
        ["\x41\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x48"],
        ["\x41\xBA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x49"],
        ["\xE9\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x55"],
        ["\x42\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x56"],
        ["\x42\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x57"],
        ["\x51\xBF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x5C"],
        ["\x51\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x5D"],
        ["\x51\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x5E"],
        ["\x52\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x5F"],
        ["\x52\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x60"],
        ["\x52\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x61"],
        ["\x52\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x62"],
        ["\x52\xEB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x63"],
        ["\x53\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x64"],
        ["\x53\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x65"],
        ["\x53\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x66"],
        ["\x53\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x67"],
        ["\x56\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x68"],
        ["\x56\x5D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x69"],
        ["\x56\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x6A"],
        ["\x56\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x6B"],
        ["\x56\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x6C"],
        ["\x56\x6A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x6D"],
        ["\x56\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x6E"],
        ["\x56\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x6F"],
        ["\x56\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x70"],
        ["\x56\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x71"],
        ["\x56\x7B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x72"],
        ["\x56\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x73"],
        ["\x56\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x74"],
        ["\x56\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x75"],
        ["\x56\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x76"],
        ["\x56\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x77"],
        ["\x56\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x78"],
        ["\x56\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x79"],
        ["\x56\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x7A"],
        ["\x56\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x7B"],
        ["\x56\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x7C"],
        ["\x56\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x7D"],
        ["\x56\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x7E"],
        ["\x56\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x80"],
        ["\x56\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x81"],
        ["\x56\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x82"],
        ["\x56\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x83"],
        ["\x56\xF7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x84"],
        ["\x57\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x85"],
        ["\x57\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x86"],
        ["\x57\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x87"],
        ["\x57\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x88"],
        ["\x57\x61",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x89"],
        ["\x57\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x8A"],
        ["\x57\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x8B"],
        ["\x57\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x8C"],
        ["\x57\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x8D"],
        ["\x57\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x8E"],
        ["\x57\x8B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x8F"],
        ["\x57\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x90"],
        ["\x57\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x91"],
        ["\x57\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x92"],
        ["\x57\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x93"],
        ["\x57\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x94"],
        ["\x57\xDE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x95"],
        ["\x58\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x96"],
        ["\x58\x63",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x97"],
        ["\x58\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x98"],
        ["\x58\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x99"],
        ["\x58\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x9A"],
        ["\x58\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x9B"],
        ["\x58\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x9C"],
        ["\x58\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x9D"],
        ["\x58\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x9E"],
        ["\x58\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\x9F"],
        ["\x58\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xA0"],
        ["\x58\xB0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xA1"],
        ["\x58\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xA2"],
        ["\x58\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xA3"],
        ["\x58\xBE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xA4"],
        ["\x58\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xA5"],
        ["\x58\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xA6"],
        ["\x58\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xA7"],
        ["\x58\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xA8"],
        ["\x59\x42",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xA9"],
        ["\x59\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xAA"],
        ["\x59\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xAB"],
        ["\x59\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xAC"],
        ["\x59\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xAD"],
        ["\x59\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xAE"],
        ["\x59\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xAF"],
        ["\x59\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xB0"],
        ["\x59\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xB1"],
        ["\x59\x84",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xB2"],
        ["\x59\x87",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xB3"],
        ["\x59\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xB4"],
        ["\x59\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xB5"],
        ["\x59\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xB6"],
        ["\x59\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xB7"],
        ["\x59\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xB8"],
        ["\x59\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xB9"],
        ["\x59\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xBA"],
        ["\x59\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xBB"],
        ["\x5A\x44",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xBC"],
        ["\x5A\x51",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xBD"],
        ["\x5A\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xBE"],
        ["\x5A\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xBF"],
        ["\x5A\x65",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xC0"],
        ["\x5A\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xC1"],
        ["\x5A\x68",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xC2"],
        ["\x5A\x76",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xC3"],
        ["\x5A\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xC4"],
        ["\x5A\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xC5"],
        ["\x5A\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xC6"],
        ["\x5A\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xC7"],
        ["\x5A\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xC8"],
        ["\x5A\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xC9"],
        ["\x5B\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xCA"],
        ["\x5B\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xCB"],
        ["\x5B\x54",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xCC"],
        ["\x5B\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xCD"],
        ["\x5B\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xCE"],
        ["\x5B\x98",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xCF"],
        ["\x4F\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xD0"],
        ["\x5B\x9D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xD1"],
        ["\x5B\xA0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xD2"],
        ["\x5B\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xD3"],
        ["\x5B\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xD4"],
        ["\x5B\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xD5"],
        ["\x5B\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xD6"],
        ["\x5B\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xD7"],
        ["\x5B\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xD8"],
        ["\x5B\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xD9"],
        ["\x5B\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xDA"],
        ["\x5B\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xDB"],
        ["\x5B\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xDC"],
        ["\x5B\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xDD"],
        ["\x5B\xC7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xDE"],
        ["\x5B\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xDF"],
        ["\x5B\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xE0"],
        ["\x5B\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xE1"],
        ["\x5B\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xE2"],
        ["\x5B\xEC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xE3"],
        ["\x5B\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xE4"],
        ["\x5B\xF3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xE5"],
        ["\x5B\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xE6"],
        ["\x5C\x5F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xE7"],
        ["\x5C\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xE8"],
        ["\x5C\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xE9"],
        ["\x5C\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xEA"],
        ["\x5C\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xEB"],
        ["\x5C\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xEC"],
        ["\x5C\x9A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xED"],
        ["\x5C\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xEE"],
        ["\x5C\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xEF"],
        ["\x5C\xA9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xF0"],
        ["\x5C\xAF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xF1"],
        ["\x5C\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xF2"],
        ["\x5C\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xF3"],
        ["\x5C\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xF4"],
        ["\x5C\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xF5"],
        ["\x5C\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xF6"],
        ["\x5C\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xF7"],
        ["\x5C\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xF8"],
        ["\x5D\x4E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xF9"],
        ["\x5D\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xFA"],
        ["\x5D\x60",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xFB"],
        ["\x5D\x62",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFA\xFC"],
        ["\x5D\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x40"],
        ["\x5D\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x41"],
        ["\x5D\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x42"],
        ["\x5D\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x43"],
        ["\x5D\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x44"],
        ["\x5D\x80",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x45"],
        ["\x5D\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x46"],
        ["\x5D\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x47"],
        ["\x5D\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x48"],
        ["\x5D\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x49"],
        ["\x5D\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x4A"],
        ["\x5D\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x4B"],
        ["\x5D\xCA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x4C"],
        ["\x5D\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x4D"],
        ["\x5D\xD7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x4E"],
        ["\x5D\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x4F"],
        ["\x5D\xE3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x50"],
        ["\x5D\xEA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x51"],
        ["\x5D\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x52"],
        ["\x5D\xF5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x53"],
        ["\x5D\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x54"],
        ["\x5D\xFB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x55"],
        ["\x5D\xFC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x56"],
        ["\x5D\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x57"],
        ["\x5E\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x58"],
        ["\x5E\x4B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x59"],
        ["\x5E\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x5A"],
        ["\x5E\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x5B"],
        ["\x5E\x75",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x5C"],
        ["\x5E\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x5D"],
        ["\x5E\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x5E"],
        ["\x5E\x94",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x5F"],
        ["\x5E\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x60"],
        ["\x5E\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x61"],
        ["\x5E\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x62"],
        ["\x5E\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x63"],
        ["\x5E\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x64"],
        ["\x5E\xA7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x65"],
        ["\x5E\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x66"],
        ["\x5E\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x67"],
        ["\x5E\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x68"],
        ["\x5E\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x69"],
        ["\x5E\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x6A"],
        ["\x5E\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x6B"],
        ["\x5E\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x6C"],
        ["\x5E\xC0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x6D"],
        ["\x5E\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x6E"],
        ["\x5E\xE7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x6F"],
        ["\x5F\x69",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x70"],
        ["\x5F\x70",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x71"],
        ["\x5F\x71",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x72"],
        ["\x5F\x72",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x73"],
        ["\x5F\x73",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x74"],
        ["\x5F\x7A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x75"],
        ["\x5F\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x76"],
        ["\x5F\xAA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x77"],
        ["\x5F\xAE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x78"],
        ["\x5F\xB2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x79"],
        ["\x5F\xB3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x7A"],
        ["\x5F\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x7B"],
        ["\x5F\xD1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x7C"],
        ["\x5F\xD2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x7D"],
        ["\x5F\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x7E"],
        ["\x5F\xD9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x80"],
        ["\x5F\xDC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x81"],
        ["\x5F\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x82"],
        ["\x5F\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x83"],
        ["\x60\x4F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x84"],
        ["\x60\x58",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x85"],
        ["\x60\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x86"],
        ["\x60\x5A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x87"],
        ["\x60\x82",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x88"],
        ["\x60\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x89"],
        ["\x60\xC4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x8A"],
        ["\x60\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x8B"],
        ["\x60\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x8C"],
        ["\x60\xDA",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x8D"],
        ["\x60\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x8E"],
        ["\x60\xFD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x8F"],
        ["\x61\x57",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x90"],
        ["\x61\x6E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x91"],
        ["\x61\x77",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x92"],
        ["\x61\xF8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x93"],
        ["\x62\x48",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x94"],
        ["\x62\x5B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x95"],
        ["\x62\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x96"],
        ["\x62\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x97"],
        ["\x62\x7E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x98"],
        ["\x62\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x99"],
        ["\x62\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x9A"],
        ["\x62\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x9B"],
        ["\x62\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x9C"],
        ["\x62\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x9D"],
        ["\x62\xBB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x9E"],
        ["\x62\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\x9F"],
        ["\x62\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xA0"],
        ["\x63\x5E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xA1"],
        ["\x63\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xA2"],
        ["\x63\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xA3"],
        ["\x63\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xA4"],
        ["\x63\xD4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xA5"],
        ["\x63\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xA6"],
        ["\x63\xE1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xA7"],
        ["\x63\xED",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xA8"],
        ["\x63\xEE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xA9"],
        ["\x63\xEF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xAA"],
        ["\x64\x45",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xAB"],
        ["\x64\x50",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xAC"],
        ["\x64\x7C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xAD"],
        ["\x64\x7D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xAE"],
        ["\x64\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xAF"],
        ["\x64\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xB0"],
        ["\x64\x8E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xB1"],
        ["\x64\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xB2"],
        ["\x64\xF1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xB3"],
        ["\x65\x49",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xB4"],
        ["\x65\x53",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xB5"],
        ["\x65\x64",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xB6"],
        ["\x65\x66",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xB7"],
        ["\x65\x67",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xB8"],
        ["\x65\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xB9"],
        ["\x65\x83",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xBA"],
        ["\x65\x85",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xBB"],
        ["\x65\x86",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xBC"],
        ["\x65\x8A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xBD"],
        ["\x65\x8C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xBE"],
        ["\x65\x8D",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xBF"],
        ["\x65\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xC0"],
        ["\x65\x90",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xC1"],
        ["\x65\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xC2"],
        ["\x65\x95",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xC3"],
        ["\x65\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xC4"],
        ["\x65\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xC5"],
        ["\x65\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xC6"],
        ["\x65\xA1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xC7"],
        ["\x65\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xC8"],
        ["\x65\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xC9"],
        ["\x65\xA6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xCA"],
        ["\x65\xA8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xCB"],
        ["\x65\xAB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xCC"],
        ["\x65\xAC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xCD"],
        ["\x65\xAD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xCE"],
        ["\x65\xB4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xCF"],
        ["\x65\xB5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xD0"],
        ["\x65\xB6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xD1"],
        ["\x65\xB7",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xD2"],
        ["\x65\xB8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xD3"],
        ["\x65\xB9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xD4"],
        ["\x65\xBC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xD5"],
        ["\x65\xBD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xD6"],
        ["\x65\xC1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xD7"],
        ["\x65\xC3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xD8"],
        ["\x65\xC5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xD9"],
        ["\x65\xC6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xDA"],
        ["\x65\xC8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xDB"],
        ["\x65\xC9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xDC"],
        ["\x65\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xDD"],
        ["\x65\xCE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xDE"],
        ["\x65\xD0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xDF"],
        ["\x65\xD5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xE0"],
        ["\x65\xD8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xE1"],
        ["\x65\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xE2"],
        ["\x65\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xE3"],
        ["\x65\xE8",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xE4"],
        ["\x65\xF0",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xE5"],
        ["\x65\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xE6"],
        ["\x65\xF6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xE7"],
        ["\x66\x4A",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xE8"],
        ["\x66\x74",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xE9"],
        ["\x66\x78",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xEA"],
        ["\x66\x79",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xEB"],
        ["\x66\x7F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xEC"],
        ["\x66\x97",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xED"],
        ["\x66\x99",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xEE"],
        ["\x66\x9E",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xEF"],
        ["\x66\xA2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xF0"],
        ["\x66\xA3",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xF1"],
        ["\x66\xA4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xF2"],
        ["\x66\xA5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xF3"],
        ["\x66\xCB",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xF4"],
        ["\x66\xCC",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xF5"],
        ["\x66\xDD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xF6"],
        ["\x66\xDF",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xF7"],
        ["\x66\xE5",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xF8"],
        ["\x66\xE6",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xF9"],
        ["\x66\xF9",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xFA"],
        ["\x67\x59",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xFB"],
        ["\x67\x6B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFB\xFC"],
        ["\x67\x6C",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x40"],
        ["\x67\x8F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x41"],
        ["\x67\x91",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x42"],
        ["\x67\x93",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x43"],
        ["\x67\x9B",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x44"],
        ["\x67\x9F",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x45"],
        ["\x67\xB1",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x46"],
        ["\x67\xE2",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x47"],
        ["\x67\xE4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x48"],
        ["\x67\xF4",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x49"],
        ["\x67\xFE",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x4A"],
        ["\x68\x56",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\xFC\x4B"],
        ["\x59\xCD",'cp932','cp00930',{'INPUT_LAYOUT'=>'D'},"\x9C\x5A"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e::RoundTrip;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::RoundTrip::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
