######################################################################
#
# 0302_add_mapping-keis-2.13.6.18.t
#
# Copyright (c) 2021 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ['𠮟', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xD5"],
        ['𡉴', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA5"],
        ['㟢', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA8"],
        ['䰗', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD0"],
        ['伃', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA1"],
        ['伋', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA2"],
        ['俠', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xB0"],
        ['俱', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xFC"],
        ['僙', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xC0"],
        ['刕', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA3"],
        ['剝', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xB8"],
        ['卽', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xBF"],
        ['吞', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['啞', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xBC"],
        ['噓', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xBF"],
        ['嚙', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xC3"],
        ['囊', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xC6"],
        ['埇', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA6"],
        ['埞', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA7"],
        ['塡', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xC9"],
        ['增', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xD1"],
        ['姸', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['寬', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xC7"],
        ['尒', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xC3"],
        ['屛', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xCD"],
        ['屢', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xCF"],
        ['嵭', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA9"],
        ['巢', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xCF"],
        ['幷', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['徵', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xE4"],
        ['德', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xE6"],
        ['扚', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAA"],
        ['揭', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xDF"],
        ['搔', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xDD"],
        ['摑', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xDF"],
        ['擊', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xF3"],
        ['攢', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xE2"],
        ['晚', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xDB"],
        ['曆', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xF0"],
        ['杻', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAB"],
        ['柀', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAC"],
        ['椵', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAE"],
        ['榀', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAF"],
        ['榒', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB0"],
        ['橫', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xA9"],
        ['檞', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB2"],
        ['步', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xC5"],
        ['歷', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xC7"],
        ['每', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xCF"],
        ['沗', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB4"],
        ['涉', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xF0"],
        ['淚', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xEF"],
        ['渴', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xAC"],
        ['湗', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB5"],
        ['溫', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xC1"],
        ['溿', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB6"],
        ['潑', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xF4"],
        ['澍', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB7"],
        ['瀆', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xF5"],
        ['瀨', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xF1"],
        ['焏', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB9"],
        ['焰', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xFA"],
        ['犾', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xBA"],
        ['狀', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xC7"],
        ['甁', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xB9"],
        ['畾', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xBC"],
        ['瘦', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xA3"],
        ['硏', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xF8"],
        ['禱', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xA6"],
        ['穝', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC0"],
        ['簞', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xAD"],
        ['粠', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC1"],
        ['糙', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC2"],
        ['綠', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xEB"],
        ['緖', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF1"],
        ['緣', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF5"],
        ['繡', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xB5"],
        ['繫', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xB4"],
        ['芎', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC4"],
        ['茰', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC5"],
        ['萊', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xC4"],
        ['葚', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC6"],
        ['蔣', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xC6"],
        ['薭', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC7"],
        ['薰', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xC9"],
        ['虛', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xD2"],
        ['蟬', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xCE"],
        ['蠋', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC8"],
        ['蠟', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xD0"],
        ['賴', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xCF"],
        ['軀', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xD6"],
        ['郞', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xC7"],
        ['鄕', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xCD"],
        ['醬', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xE4"],
        ['醱', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xE5"],
        ['鋓', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCA"],
        ['錄', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xC0"],
        ['鍊', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xC9"],
        ['鎺', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCB"],
        ['閍', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCC"],
        ['霳', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCD"],
        ['霻', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCE"],
        ['靏', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCF"],
        ['頰', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xEC"],
        ['顚', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xED"],
        ['驒', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF0"],
        ['魦', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD1"],
        ['魵', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD2"],
        ['鰀', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD3"],
        ['鱣', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD4"],
        ['鴞', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD6"],
        ['鵢', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD7"],
        ['鵰', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD8"],
        ['鶖', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD5"],
        ['鷗', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF4"],
        ['鹼', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF5"],
        ['麴', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF7"],
        ['麵', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF8"],
        ['黃', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xFE"],
        ['黑', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xA1"],
        ['欄', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xBE"],
        ['廊', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xC2"],
        ['朗', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xA7"],
        ['虜', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xD3"],
        ['類', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xC0"],
        ['隆', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xA2"],
        ['塚', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC4\xCD"],
        ['猪', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xCE"],
        ['神', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBB"],
        ['祥', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xC2"],
        ['福', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xD3"],
        ['諸', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xB2"],
        ['都', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xCA"],
        ['侮', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xE2"],
        ['僧', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xBD"],
        ['免', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xCE"],
        ['勉', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xF9"],
        ['勤', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xA3"],
        ['卑', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xB4"],
        ['喝', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xEF"],
        ['嘆', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xF9"],
        ['器', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xA2"],
        ['墨', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xD2"],
        ['層', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xD7"],
        ['悔', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xF7"],
        ['憎', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xC1"],
        ['懲', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xC7"],
        ['敏', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xF7"],
        ['暑', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xE4"],
        ['梅', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xCD"],
        ['海', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xEA"],
        ['渚', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xB0"],
        ['漢', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xCB"],
        ['煮', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xAC"],
        ['琢', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xF4"],
        ['碑', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xA4"],
        ['社', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xB4"],
        ['祉', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xB6"],
        ['祈', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xB5"],
        ['祐', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBD"],
        ['祖', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBC"],
        ['祝', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBA"],
        ['禍', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xCF"],
        ['禎', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xD1"],
        ['穀', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xEB"],
        ['突', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xF7"],
        ['節', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xB6"],
        ['練', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF2"],
        ['繁', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF8"],
        ['署', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xA8"],
        ['者', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xBA"],
        ['臭', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xC6"],
        ['著', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xAC"],
        ['褐', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xE4"],
        ['視', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xC7"],
        ['謁', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xB1"],
        ['謹', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xB9"],
        ['賓', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xCE"],
        ['贈', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xD4"],
        ['逸', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xFD"],
        ['難', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xAB"],
        ['響', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xBA"],
        ['‖', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['−',  'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['∥', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA1\xC2"],
        ['〜', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA1\xC1"],
        ['凜', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['堯', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xC3"],
        ['尭', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xC6"],
        ['槇', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xFC"],
        ['槙', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xEA"],
        ['熙', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xB8"],
        ['瑤', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xA7"],
        ['瑶', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xE0\xF6"],
        ['遙', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xA2"],
        ['遥', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xDA"],
        ['－', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA1\xDD"],
        ['～', 'keis78', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['𠮟', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xD5"],
        ['𡉴', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA5"],
        ['㟢', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA8"],
        ['䰗', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD0"],
        ['伃', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA1"],
        ['伋', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA2"],
        ['俠', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xB0"],
        ['俱', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xFC"],
        ['僙', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xC0"],
        ['刕', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA3"],
        ['剝', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xB8"],
        ['卽', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xBF"],
        ['吞', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['啞', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xBC"],
        ['噓', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xBF"],
        ['嚙', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xC3"],
        ['囊', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xC6"],
        ['埇', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA6"],
        ['埞', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA7"],
        ['塡', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xC9"],
        ['增', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xD1"],
        ['姸', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['寬', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xC7"],
        ['尒', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xC3"],
        ['屛', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xCD"],
        ['屢', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xCF"],
        ['嵭', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA9"],
        ['巢', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xCF"],
        ['幷', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['徵', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xE4"],
        ['德', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xE6"],
        ['扚', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAA"],
        ['揭', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xDF"],
        ['搔', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xDD"],
        ['摑', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xDF"],
        ['擊', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xF3"],
        ['攢', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xE2"],
        ['晚', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xDB"],
        ['曆', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xF0"],
        ['杻', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAB"],
        ['柀', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAC"],
        ['椵', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAE"],
        ['榀', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAF"],
        ['榒', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB0"],
        ['橫', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xA9"],
        ['檞', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB2"],
        ['步', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xC5"],
        ['歷', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xC7"],
        ['每', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xCF"],
        ['沗', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB4"],
        ['涉', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xF0"],
        ['淚', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xEF"],
        ['渴', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xAC"],
        ['湗', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB5"],
        ['溫', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xC1"],
        ['溿', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB6"],
        ['潑', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xF4"],
        ['澍', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB7"],
        ['瀆', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xF5"],
        ['瀨', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xF1"],
        ['焏', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB9"],
        ['焰', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xFA"],
        ['犾', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xBA"],
        ['狀', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xC7"],
        ['甁', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xB9"],
        ['畾', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xBC"],
        ['瘦', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xA3"],
        ['硏', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xF8"],
        ['禱', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xA6"],
        ['穝', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC0"],
        ['簞', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xAD"],
        ['粠', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC1"],
        ['糙', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC2"],
        ['綠', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xEB"],
        ['緖', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF1"],
        ['緣', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF5"],
        ['繡', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xB5"],
        ['繫', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xB4"],
        ['芎', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC4"],
        ['茰', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC5"],
        ['萊', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xC4"],
        ['葚', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC6"],
        ['蔣', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xC6"],
        ['薭', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC7"],
        ['薰', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xC9"],
        ['虛', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xD2"],
        ['蟬', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xCE"],
        ['蠋', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC8"],
        ['蠟', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xD0"],
        ['賴', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xCF"],
        ['軀', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xD6"],
        ['郞', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xC7"],
        ['鄕', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xCD"],
        ['醬', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xE4"],
        ['醱', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xE5"],
        ['鋓', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCA"],
        ['錄', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xC0"],
        ['鍊', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xC9"],
        ['鎺', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCB"],
        ['閍', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCC"],
        ['霳', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCD"],
        ['霻', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCE"],
        ['靏', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCF"],
        ['頰', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xEC"],
        ['顚', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xED"],
        ['驒', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF0"],
        ['魦', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD1"],
        ['魵', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD2"],
        ['鰀', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD3"],
        ['鱣', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD4"],
        ['鴞', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD6"],
        ['鵢', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD7"],
        ['鵰', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD8"],
        ['鶖', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD5"],
        ['鷗', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF4"],
        ['鹼', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF5"],
        ['麴', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF7"],
        ['麵', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF8"],
        ['黃', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xFE"],
        ['黑', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xA1"],
        ['欄', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xBE"],
        ['廊', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xC2"],
        ['朗', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xA7"],
        ['虜', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xD3"],
        ['類', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xC0"],
        ['隆', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xA2"],
        ['塚', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xC7"],
        ['猪', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xCE"],
        ['神', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBB"],
        ['祥', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xC2"],
        ['福', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xD3"],
        ['諸', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xB2"],
        ['都', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xCA"],
        ['侮', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xE2"],
        ['僧', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xBD"],
        ['免', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xCE"],
        ['勉', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xF9"],
        ['勤', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xA3"],
        ['卑', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xB4"],
        ['喝', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xEF"],
        ['嘆', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xF9"],
        ['器', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xA2"],
        ['墨', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xD2"],
        ['層', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xD7"],
        ['悔', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xF7"],
        ['憎', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xC1"],
        ['懲', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xC7"],
        ['敏', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xF7"],
        ['暑', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xE4"],
        ['梅', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xCD"],
        ['海', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xEA"],
        ['渚', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xB0"],
        ['漢', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xCB"],
        ['煮', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xAC"],
        ['琢', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xF4"],
        ['碑', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xA4"],
        ['社', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xB4"],
        ['祉', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xB6"],
        ['祈', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xB5"],
        ['祐', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBD"],
        ['祖', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBC"],
        ['祝', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBA"],
        ['禍', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xCF"],
        ['禎', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xD1"],
        ['穀', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xEB"],
        ['突', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xF7"],
        ['節', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xB6"],
        ['練', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF2"],
        ['繁', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF8"],
        ['署', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xA8"],
        ['者', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xBA"],
        ['臭', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xC6"],
        ['著', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xAC"],
        ['褐', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xE4"],
        ['視', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xC7"],
        ['謁', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xB1"],
        ['謹', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xB9"],
        ['賓', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xCE"],
        ['贈', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xD4"],
        ['逸', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xFD"],
        ['難', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xAB"],
        ['響', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xBA"],
        ['‖', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['−',  'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['∥', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA1\xC2"],
        ['〜', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA1\xC1"],
        ['凜', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['堯', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xF4\xA1"],
        ['尭', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xC6"],
        ['槇', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xF4\xA2"],
        ['槙', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xEA"],
        ['熙', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xB8"],
        ['瑤', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xF4\xA4"],
        ['瑶', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xE0\xF6"],
        ['遙', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xF4\xA3"],
        ['遥', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xDA"],
        ['－', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA1\xDD"],
        ['～', 'keis83', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['𠮟', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xD5"],
        ['𡉴', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA5"],
        ['㟢', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA8"],
        ['䰗', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD0"],
        ['伃', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA1"],
        ['伋', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA2"],
        ['俠', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xB0"],
        ['俱', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xFC"],
        ['僙', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xC0"],
        ['刕', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA3"],
        ['剝', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xB8"],
        ['卽', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xBF"],
        ['吞', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['啞', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xBC"],
        ['噓', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xBF"],
        ['嚙', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xC3"],
        ['囊', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xC6"],
        ['埇', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA6"],
        ['埞', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA7"],
        ['塡', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xC9"],
        ['增', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xD1"],
        ['姸', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['寬', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xC7"],
        ['尒', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xC3"],
        ['屛', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xCD"],
        ['屢', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xCF"],
        ['嵭', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xA9"],
        ['巢', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xCF"],
        ['幷', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['徵', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xE4"],
        ['德', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xE6"],
        ['扚', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAA"],
        ['揭', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xDF"],
        ['搔', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xDD"],
        ['摑', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xDF"],
        ['擊', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xF3"],
        ['攢', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xE2"],
        ['晚', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xDB"],
        ['曆', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xF0"],
        ['杻', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAB"],
        ['柀', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAC"],
        ['椵', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAE"],
        ['榀', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xAF"],
        ['榒', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB0"],
        ['橫', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xA9"],
        ['檞', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB2"],
        ['步', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xC5"],
        ['歷', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xC7"],
        ['每', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xCF"],
        ['沗', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB4"],
        ['涉', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xF0"],
        ['淚', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xEF"],
        ['渴', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xAC"],
        ['湗', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB5"],
        ['溫', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xC1"],
        ['溿', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB6"],
        ['潑', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xF4"],
        ['澍', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB7"],
        ['瀆', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xF5"],
        ['瀨', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xF1"],
        ['焏', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xB9"],
        ['焰', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xFA"],
        ['犾', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xBA"],
        ['狀', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xC7"],
        ['甁', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xB9"],
        ['畾', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xBC"],
        ['瘦', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xA3"],
        ['硏', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xF8"],
        ['禱', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xA6"],
        ['穝', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC0"],
        ['簞', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xAD"],
        ['粠', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC1"],
        ['糙', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC2"],
        ['綠', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xEB"],
        ['緖', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF1"],
        ['緣', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF5"],
        ['繡', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xB5"],
        ['繫', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xB4"],
        ['芎', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC4"],
        ['茰', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC5"],
        ['萊', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xC4"],
        ['葚', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC6"],
        ['蔣', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xC6"],
        ['薭', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC7"],
        ['薰', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xC9"],
        ['虛', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xD2"],
        ['蟬', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xCE"],
        ['蠋', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xC8"],
        ['蠟', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xD0"],
        ['賴', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xCF"],
        ['軀', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xD6"],
        ['郞', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xC7"],
        ['鄕', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xCD"],
        ['醬', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xE4"],
        ['醱', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xE5"],
        ['鋓', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCA"],
        ['錄', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xC0"],
        ['鍊', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xC9"],
        ['鎺', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCB"],
        ['閍', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCC"],
        ['霳', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCD"],
        ['霻', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCE"],
        ['靏', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xCF"],
        ['頰', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xEC"],
        ['顚', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xED"],
        ['驒', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF0"],
        ['魦', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD1"],
        ['魵', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD2"],
        ['鰀', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD3"],
        ['鱣', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD4"],
        ['鴞', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD6"],
        ['鵢', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD7"],
        ['鵰', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD8"],
        ['鶖', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x9F\xD5"],
        ['鷗', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF4"],
        ['鹼', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF5"],
        ['麴', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF7"],
        ['麵', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x80\xF8"],
        ['黃', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xFE"],
        ['黑', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xA1"],
        ['欄', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xBE"],
        ['廊', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xC2"],
        ['朗', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xA7"],
        ['虜', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xD3"],
        ['類', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xC0"],
        ['隆', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xA2"],
        ['塚', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xC7"],
        ['猪', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xCE"],
        ['神', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBB"],
        ['祥', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xC2"],
        ['福', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xD3"],
        ['諸', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xB2"],
        ['都', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xCA"],
        ['侮', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xE2"],
        ['僧', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xBD"],
        ['免', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xCE"],
        ['勉', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xF9"],
        ['勤', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xA3"],
        ['卑', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xB4"],
        ['喝', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xEF"],
        ['嘆', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xF9"],
        ['器', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xA2"],
        ['墨', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xD2"],
        ['層', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xD7"],
        ['悔', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xF7"],
        ['憎', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xC1"],
        ['懲', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xC7"],
        ['敏', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xF7"],
        ['暑', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xE4"],
        ['梅', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xCD"],
        ['海', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xEA"],
        ['渚', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xB0"],
        ['漢', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xCB"],
        ['煮', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xAC"],
        ['琢', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xF4"],
        ['碑', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xA4"],
        ['社', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xB4"],
        ['祉', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xB6"],
        ['祈', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xB5"],
        ['祐', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBD"],
        ['祖', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBC"],
        ['祝', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xBA"],
        ['禍', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xCF"],
        ['禎', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xD1"],
        ['穀', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xEB"],
        ['突', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xF7"],
        ['節', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xB6"],
        ['練', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF2"],
        ['繁', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF8"],
        ['署', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xA8"],
        ['者', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xBA"],
        ['臭', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xC6"],
        ['著', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xAC"],
        ['褐', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xE4"],
        ['視', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xC7"],
        ['謁', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xB1"],
        ['謹', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xB9"],
        ['賓', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xCE"],
        ['贈', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xD4"],
        ['逸', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xFD"],
        ['難', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xAB"],
        ['響', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xBA"],
        ['‖', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['−',  'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['∥', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA1\xC2"],
        ['〜', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA1\xC1"],
        ['凜', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xF4\xA5"],
        ['堯', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xF4\xA1"],
        ['尭', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xC6"],
        ['槇', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xF4\xA2"],
        ['槙', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xEA"],
        ['熙', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xF4\xA6"],
        ['瑤', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xF4\xA4"],
        ['瑶', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xE0\xF6"],
        ['遙', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xF4\xA3"],
        ['遥', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xDA"],
        ['－', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA1\xDD"],
        ['～', 'keis90', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    $option->{'GETA'} = "\x00\x00";
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'},}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'},}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]},} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]},}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$give $INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__DATA__
