use strict;

BEGIN {
    use lib '.';
    use Bio::Root::Test;

    test_begin(-tests => 3);

    use_ok('Bio::Tools::PrositeScan');
    use_ok('Bio::SeqFeature::FeaturePair');
}

# Note: data generated by running
#
#   ./ps_scan.pl --pfscan ./pfscan -d prosite.dat -o fasta \
#       t/data/test.fasta > t/data/ps_scan/out.PrositeScan
#
# followed by a manual removal of some of the output to simplify the test.

subtest "Predictions" => sub {
    my $factory = Bio::Tools::PrositeScan->new(
          '-file'   => test_input_file('ps_scan/out.PrositeScan'),
          '-format' => 'fasta'
    );

    my $expected_matches = [
        { seq_id => 'roa1_drome', coords => [253, 256], psac => 'PS00001', subseq => 'NNSF' },
        { seq_id => 'roa1_drome', coords => [270, 273], psac => 'PS00001', subseq => 'NNSW' },
        { seq_id => 'roa2_drome', coords => [344, 349], psac => 'PS00008', subseq => 'GNNQGF' },
        { seq_id => 'roa2_drome', coords => [217, 355], psac => 'PS50321', subseq => re(qr/NR.{135}NN/) },
    ];

    my $actual_matches = [];
    while( my $match = $factory->next_prediction ) {
        push @$actual_matches, {
            seq_id  =>   $match->seq_id,
            coords  => [ $match->start, $match->end ],
            psac    =>   $match->hseq_id,
            subseq  =>   $match->feature1->seq->seq,
        };
    }

    cmp_deeply( $actual_matches, $expected_matches, 'Comparing parsed prediction input' );
};
