#!/usr/bin/perl

package eBay::API::XML::DataType::InsuranceDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. InsuranceDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::InsuranceDetailsType

=head1 DESCRIPTION

some notes here.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::InsuranceDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::Enum::InsuranceOptionCodeType;


my @gaProperties = ( [ 'InsuranceFee', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'InsuranceOption', 'ns:InsuranceOptionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::InsuranceOptionCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setInsuranceFee()

Cost of shipping insurance set by the seller. If the
buyer bought more than one of this item, this is the insurance
for just a single item. Exception: for GetItemShipping, this is
proportional to QuantitySold. Default
is 0.00. Value should be greater than 0.00 if InsuranceOption
is Optional or Required. For flat shipping only.
Optional as input and only allowed if ChangePaymentInstructions
is true.
Also applicable to Half.com (for GetOrders).
This field is ignored when Item.ListingType=Express.

  Calls: AddItem
         GetItemRecommendations
         AddOrder
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setInsuranceFee {
  my $self = shift;
  $self->{'InsuranceFee'} = shift
}

=head2 getInsuranceFee()

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none
  Context: OrderArray.Order

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
  Context: OrderArray.Order

#    Returns: 'ns:AmountType'

=cut

sub getInsuranceFee {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InsuranceFee'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setInsuranceOption()

Whether the seller offers shipping insurance and, if
so, whether the insurance is optional or required. Flat and
calculated shipping. Optional as input and only allowed if
ChangePaymentInstructions is true.
Also applicable to Half.com (for GetOrders).
This field is ignored when Item.ListingType=Express.

  Calls: AddItem
         GetItemRecommendations
         AddOrder
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No
  AllValuesExcept: NotOfferedOnSite

#    Argument: 'ns:InsuranceOptionCodeType'

=cut

sub setInsuranceOption {
  my $self = shift;
  $self->{'InsuranceOption'} = shift
}

=head2 getInsuranceOption()

  Calls: GetBidderList
         GetItemShipping
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Always
  Context: OrderArray.Order

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
  Context: OrderArray.Order

#    Returns: 'ns:InsuranceOptionCodeType'

=cut

sub getInsuranceOption {
  my $self = shift;
  return $self->{'InsuranceOption'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
