#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::DisputeResolutionReasonCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DisputeResolutionReasonCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::DisputeResolutionReasonCodeType

=head1 DESCRIPTION

Defines the reason a dispute was resolved.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Unresolved

The dispute was not resolved.



=cut


use constant Unresolved => scalar('Unresolved');


=head2 ProofOfPayment

The buyer provided proof of payment in feedback.



=cut


use constant ProofOfPayment => scalar('ProofOfPayment');


=head2 ComputerTechnicalProblem

The buyer or seller had a technical problem with a computer.



=cut


use constant ComputerTechnicalProblem => scalar('ComputerTechnicalProblem');


=head2 NoContact

The buyer and seller have not made contact.



=cut


use constant NoContact => scalar('NoContact');


=head2 FamilyEmergency

The buyer or seller had a family emergency.



=cut


use constant FamilyEmergency => scalar('FamilyEmergency');


=head2 ProofGivenInFeedback

The buyer provided proof of payment in feedback.



=cut


use constant ProofGivenInFeedback => scalar('ProofGivenInFeedback');


=head2 FirstInfraction

The dispute was the buyer's first infraction.



=cut


use constant FirstInfraction => scalar('FirstInfraction');


=head2 CameToAgreement

The buyer and seller came to agreement.



=cut


use constant CameToAgreement => scalar('CameToAgreement');


=head2 ItemReturned

The buyer returned the item.



=cut


use constant ItemReturned => scalar('ItemReturned');


=head2 BuyerPaidAuctionFees

The buyer reimbursed the seller's auction fees.



=cut


use constant BuyerPaidAuctionFees => scalar('BuyerPaidAuctionFees');


=head2 SellerReceivedPayment

The seller received payment.



=cut


use constant SellerReceivedPayment => scalar('SellerReceivedPayment');


=head2 OtherResolution

Some other resolution occurred.



=cut


use constant OtherResolution => scalar('OtherResolution');


=head2 ClaimPaid

After eBay approved payment of the claim, the claim was paid.



=cut


use constant ClaimPaid => scalar('ClaimPaid');


=head2 CustomCode

Reserved for future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
