/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.HomogeneityChecker;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AncestorQualifiedPattern;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.GeneralNodePattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternMaker;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawSlashExpression
extends BinaryExpression
implements ContextSwitchingExpression,
ContextMappingFunction {
    public RawSlashExpression(Expression start, Expression step) {
        super(start, 2, step);
    }

    @Override
    protected OperandRole getOperandRole(int arg) {
        return arg == 0 ? OperandRole.FOCUS_CONTROLLING_SELECT : OperandRole.FOCUS_CONTROLLED_ACTION;
    }

    public Expression getStart() {
        return this.getLhsExpression();
    }

    public void setStart(Expression start) {
        this.setLhsExpression(start);
    }

    public Expression getStep() {
        return this.getRhsExpression();
    }

    public void setStep(Expression step) {
        this.setRhsExpression(step);
    }

    @Override
    public String getExpressionName() {
        return "rawPathExp";
    }

    @Override
    public Expression getSelectExpression() {
        return this.getStart();
    }

    @Override
    public Expression getActionExpression() {
        return this.getStep();
    }

    @Override
    public final ItemType getItemType() {
        return this.getStep().getItemType();
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return this.getStep().getStaticUType(this.getStart().getStaticUType(contextItemType));
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return this.getStep().getIntegerBounds();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getLhs().typeCheck(visitor, contextInfo);
        ItemType startType = this.getStart().getItemType();
        if (startType.equals(ErrorType.getInstance())) {
            return Literal.makeEmptySequence();
        }
        ContextItemStaticInfo cit = visitor.getConfiguration().makeContextItemStaticInfo(startType, false);
        cit.setContextSettingExpression(this.getStart());
        this.getRhs().typeCheck(visitor, cit);
        SlashExpression e2 = new SlashExpression(this.getStart(), this.getStep());
        ExpressionTool.copyLocationInfo(this, e2);
        Expression result = e2;
        UType t = e2.getStaticUType(contextInfo.getContextItemUType());
        if (t.overlaps(UType.ANY_NODE)) {
            if (t.overlaps(UType.ANY_ATOMIC.union(UType.FUNCTION))) {
                result = new HomogeneityChecker(result);
            } else if ((e2.getSpecialProperties() & 0x20000) == 0) {
                result = (e2.getSpecialProperties() & 0x40000) != 0 ? SystemFunction.makeCall("reverse", this.getRetainedStaticContext(), e2) : new DocumentSorter(e2);
            }
        }
        ExpressionTool.copyLocationInfo(this, result);
        return result.simplify().typeCheck(visitor, contextInfo);
    }

    @Override
    public int getCost() {
        return this.getLhsExpression().getCost() * this.getRhsExpression().getCost();
    }

    @Override
    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        this.setStart(this.getStart().unordered(retainAllNodes, forStreaming));
        this.setStep(this.getStep().unordered(retainAllNodes, forStreaming));
        return this;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.getStart().addToPathMap(pathMap, pathMapNodeSet);
        return this.getStep().addToPathMap(pathMap, target);
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public RawSlashExpression copy(RebindingMap rebindings) {
        RawSlashExpression exp = (RawSlashExpression)ExpressionTool.makePathExpression(this.getStart().copy(rebindings), this.getStep().copy(rebindings), false);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public int computeCardinality() {
        int c1 = this.getStart().getCardinality();
        int c2 = this.getStep().getCardinality();
        return Cardinality.multiply(c1, c2);
    }

    @Override
    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        AxisExpression mid;
        RawSlashExpression start;
        ItemChecker checker;
        Expression head = this.getLeadingSteps();
        Expression tail = this.getLastStep();
        if (head instanceof ItemChecker && (checker = (ItemChecker)head).getBaseExpression() instanceof ContextItemExpression) {
            return tail.toPattern(config, is30);
        }
        Pattern tailPattern = tail.toPattern(config, is30);
        if (tailPattern instanceof NodeTestPattern) {
            if (tailPattern.getItemType() instanceof ErrorType) {
                return tailPattern;
            }
        } else if (tailPattern instanceof GeneralNodePattern) {
            return new GeneralNodePattern(this, (NodeTest)tailPattern.getItemType());
        }
        byte axis = 9;
        Pattern headPattern = null;
        if (head instanceof RawSlashExpression && (start = (RawSlashExpression)head).getActionExpression() instanceof AxisExpression && (mid = (AxisExpression)start.getActionExpression()).getAxis() == 5 && (mid.getNodeTest() == null || mid.getNodeTest() instanceof AnyNodeTest)) {
            axis = 0;
            headPattern = start.getSelectExpression().toPattern(config, is30);
        }
        if (headPattern == null) {
            axis = PatternMaker.getAxisForPathStep(tail);
            headPattern = head.toPattern(config, is30);
        }
        return new AncestorQualifiedPattern(tailPattern, headPattern, axis);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RawSlashExpression)) {
            return false;
        }
        RawSlashExpression p = (RawSlashExpression)other;
        return this.getStart().equals(p.getStart()) && this.getStep().equals(p.getStep());
    }

    @Override
    public int hashCode() {
        return "SlashExpression".hashCode() + this.getStart().hashCode() + this.getStep().hashCode();
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        FocusTrackingIterator result = new FocusTrackingIterator(this.getStart().iterate(context));
        XPathContextMinor context2 = context.newMinorContext();
        context2.setCurrentIterator(result);
        return new ContextMappingIterator(this, context2);
    }

    @Override
    public SequenceIterator map(XPathContext context) throws XPathException {
        return this.getStep().iterate(context);
    }

    @Override
    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("slash", this);
        this.getStart().export(destination);
        this.getStep().export(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getStart()) + "/" + ExpressionTool.parenthesize(this.getStep());
    }

    public Expression getFirstStep() {
        if (this.getStart() instanceof RawSlashExpression) {
            return ((RawSlashExpression)this.getStart()).getFirstStep();
        }
        return this.getStart();
    }

    public Expression getRemainingSteps() {
        if (this.getStart() instanceof RawSlashExpression) {
            ArrayList<Expression> list = new ArrayList<Expression>(8);
            this.gatherSteps(list);
            Expression rem = this.rebuildSteps(list.subList(1, list.size()));
            ExpressionTool.copyLocationInfo(this, rem);
            return rem;
        }
        return this.getStep();
    }

    private void gatherSteps(List<Expression> list) {
        if (this.getStart() instanceof RawSlashExpression) {
            ((RawSlashExpression)this.getStart()).gatherSteps(list);
        } else {
            list.add(this.getStart());
        }
        if (this.getStep() instanceof RawSlashExpression) {
            ((RawSlashExpression)this.getStep()).gatherSteps(list);
        } else {
            list.add(this.getStep());
        }
    }

    private Expression rebuildSteps(List<Expression> list) {
        if (list.size() == 1) {
            return list.get(0).copy(new RebindingMap());
        }
        return new RawSlashExpression(list.get(0).copy(new RebindingMap()), this.rebuildSteps(list.subList(1, list.size())));
    }

    public Expression getLastStep() {
        if (this.getStep() instanceof RawSlashExpression) {
            return ((RawSlashExpression)this.getStep()).getLastStep();
        }
        return this.getStep();
    }

    public Expression getLeadingSteps() {
        if (this.getStep() instanceof RawSlashExpression) {
            ArrayList<Expression> list = new ArrayList<Expression>(8);
            this.gatherSteps(list);
            Expression rem = this.rebuildSteps(list.subList(0, list.size() - 1));
            ExpressionTool.copyLocationInfo(this, rem);
            return rem;
        }
        return this.getStart();
    }

    public boolean isAbsolute() {
        Expression first = this.getFirstStep();
        return first.getItemType().getPrimitiveType() == 9;
    }

    @Override
    public String getStreamerName() {
        return "ForEach";
    }
}

