### an area with a bitmap with a matrix as data structure
### uses aggregatees of subclass MatrixBitmapAreaSelector.pm

sub new {
    my $class = shift;

    ### The offsets are from another matrix where this selects the areas
    ### same for w, h
    $self = { areamatrixobj => undef,
	      xoffset => 0, yoffset => 0,
	      width => 0, height => 0, };

    bless $self, $class;

};

sub setXYOffset {
  my ($self, $xo, $yo) = @_;

  $self->{xoffset} = $xo;
  $self->{yoffset} = $yo;
}

sub setXYWHOffset {
  my ($self, $xo, $yo, $w, $h) = @_;

  $self->{xoffset} = $xo;
  $self->{yoffset} = $yo;
  $self->{width} = $w;
  $self->{height} = $h;
}

sub setXOffset {
  my ($self, $xo) = @_;

  $self->{xoffset} = $xo;
}

sub setYOffset {
  my ($self, $yo) = @_;

  $self->{yoffset} = $yo;
}

sub setWidth {
  my ($self, $w) = @_;

  $self->{width} = $w;
}

sub setHeight {
  my ($self, $h) = @_;

  $self->{height} = $h;
}


sub getAreaMatrix {
  my $self = shift;

  return $self->{areamatrixobj};
}

sub setAreaMatrix {
    my ($self, $m) = @_;

    $self->{areamatrixobj} = $m;
}

sub selectWithAgg {
  my ($self, $areaselectionagg, $bitmapmatrix) = @_;

  ### sets this matrix object
  ### NOTE : you need x,y,w,h for ovals and rectangles but there might be
  ### other variables concerning this method
  $self->setAreaMatrix($areaselectionagg->selectArea($self->{xoffset},
						     $self->{yoffset},
						     $self->{width},
						     $self->{height},
						     $bitmapmatrix,
						     $self));
}

1;
