package blib::tiny;

use 5.008004;

# ABSTRACT: Like blib but lighter
our $VERSION = '0.01'; # VERSION


sub import
{
  my $class = shift;
  unshift @INC, 'blib/arch', 'blib/lib';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

blib::tiny - Like blib but lighter

=head1 VERSION

version 0.01

=head1 SYNOPSIS

 perl -Mblib::tiny script [args...]

=head1 DESCRIPTION

This works similar to L<blib>, except it doesn't pull in any other
modules.  This avoids introducing side effects of loading modules
earlier or loading them at all compared to when they would be called
without L<blib>.

It is different in that it does not die if there is no blib found,
and doesn't accept any arguments (only the blib relative to the current
directory is supported).

=head1 CAVEATS

This module avoids using any other modules (in-core or otherwise) so as
not to pollute the namespace for tests or command lines, so it doesn't
even try to use native directory specifications with L<File::Spec> etc,
and may not work on platforms other than Windows and Unix.

=head1 SEE ALSO

=over 4

=item L<blib>

=item L<tlib::tiny>

=back

=head1 AUTHOR

Graham Ollis <plicease@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022-2024 by Graham Ollis.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
