package Daje::Workflow::Database::Connector;
use Mojo::Base -base, -signatures;

use Daje::Workflow::Database::Model::Workflow;
use Daje::Workflow::Database::Model::Context;

# NAME
# ====
#
# Daje::Workflow::Database::Connector
#
#
# REQUIRES
# ========
#
# Daje::Workflow::Database::Model::Context>
#
# Daje::Workflow::Database::Model::Workflow>
#
# Mojo::Base>
#
#
# METHODS
# =======
#
#  load($self)
#
#  load_context($self)
#
#  load_workflow($self)
#
#  save_context($self)
#
#  save_workflow($self)
#
#  start($self)
#
#  stop($self,
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

has 'pg';
has 'db';
has 'workflow_pkey';
has 'workflow';
has 'context';

sub start($self) {

    $self->pg->migrations->name('workflow')->from_data(
        'Daje::Workflow::Database::Connector', 'workflow'
    )->migrate(2);

    my $data = $self->load();

    return $data;
}

sub stop($self, $workflow, $context) {
    $self->save_workflow($workflow);
    $context->{workflow_fkey} = $workflow->{workflow_pkey};
    $self->save_context($context);
}

sub load($self) {
    my $data->{workflow} = $self->load_workflow();
    $self->workflow_pkey($data->{workflow}->{workflow_pkey});
    $data->{context} = $self->load_context();
    return $data;
}

sub load_workflow($self) {
    my $data = Daje::Workflow::Database::Model::Workflow->new(
        db            => $self->db,
        workflow_pkey => $self->workflow_pkey,
        workflow      => $self->workflow,
    )->load();

    return $data;
}

sub save_workflow($self, $data) {
    my $workflow_pkey = Daje::Workflow::Database::Model::Workflow->new(
        db => $self->db
    )->save(
        $data
    );
    return $workflow_pkey;
}

sub load_context($self) {
    my $data = Daje::Workflow::Database::Model::Context->new(
        db => $self->db,
        workflow_pkey => $self->workflow_pkey
    )->load_fk();

    return $data;
}

sub save_context($self, $data) {
    Daje::Workflow::Database::Model::Context->new(
        db => $self->db
    )->save(
        $self->context
    );
    return ;
}
1;

__DATA__

@@ workflow

-- 1 up

CREATE TABLE IF NOT EXISTS workflow
(
    workflow_pkey serial not null primary key,
    editnum bigint NOT NULL DEFAULT 1,
    insby varchar NOT NULL DEFAULT 'System',
    insdatetime timestamp without time zone NOT NULL DEFAULT NOW(),
    modby varchar NOT NULL DEFAULT 'System',
    moddatetime timestamp without time zone NOT NULL DEFAULT NOW(),
    name varchar not null,
    state varchar not null
);

CREATE TABLE IF NOT EXISTS context
(
    context_pkey serial not null primary key,
    editnum bigint NOT NULL DEFAULT 1,
    insby varchar NOT NULL DEFAULT 'System',
    insdatetime timestamp without time zone NOT NULL DEFAULT NOW(),
    modby varchar NOT NULL DEFAULT 'System',
    moddatetime timestamp without time zone NOT NULL DEFAULT NOW(),
    workflow_fkey bigint not null,
    context JSON,
    CONSTRAINT context_workflow_fkey FOREIGN KEY (workflow_fkey)
        REFERENCES workflow (workflow_pkey)
);

CREATE INDEX IF NOT EXISTS idx_context_workflow_fkey
    ON context(workflow_fkey);

CREATE TABLE IF NOT EXISTS history
(
    history_pkey serial not null primary key,
    editnum bigint NOT NULL DEFAULT 1,
    insby varchar NOT NULL DEFAULT 'System',
    insdatetime timestamp without time zone NOT NULL DEFAULT NOW(),
    modby varchar NOT NULL DEFAULT 'System',
    moddatetime timestamp without time zone NOT NULL DEFAULT NOW(),
    workflow_fkey bigint not null,
    history varchar,
    CONSTRAINT history_workflow_fkey FOREIGN KEY (workflow_fkey)
        REFERENCES workflow (workflow_pkey)
);

CREATE INDEX IF NOT EXISTS idx_history_workflow_fkey
    ON history(workflow_fkey);

-- 1 down

DROP TABLE workflow;
DROP TABLE context;
DROP TABLE history;

-- 2 up

DROP INDEX idx_context_workflow_fkey;

CREATE UNIQUE INDEX IF NOT EXISTS idx_unique_context_workflow_fkey
    ON context(workflow_fkey);

-- 2 down

DROP INDEX idx_unique_context_workflow_fkey;
CREATE INDEX IF NOT EXISTS idx_context_workflow_fkey
    ON context(workflow_fkey);

__END__






#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Database::Connector




=head1 REQUIRES


Daje::Workflow::Database::Model::Context>

Daje::Workflow::Database::Model::Workflow>

Mojo::Base>




=head1 METHODS


 load($self)

 load_context($self)

 load_workflow($self)

 save_context($self)

 save_workflow($self)

 start($self)

 stop($self,



=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

