#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 570_Slurm-SAWCKey-parse.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::WCKey;

my $testDir = dirname(abs_path($0));
my $num_tests_run = 0; 

#Set up expected results
my @fakedata =
(	
	{ wckey=>'aaa', cluster=>'yottascale', user=>'payerle' },
	{ wckey=>'aaa', cluster=>'yottascale', user=>'root' },
	{ wckey=>'bbb', cluster=>'yottascale', user=>'root' },
	{ wckey=>'ccc', cluster=>'test1', user=>'payerle' },
	{ wckey=>'ddd', cluster=>'yottascale' , user=>'payerle' },
);
my @fake_data = ();
foreach my $fakedatum (@fakedata)
{	my $uname = $fakedatum->{wckey};

	my $uobj = new_ok('Slurm::Sacctmgr::WCKey' => 
		[ %$fakedatum ],
		"$uname" );
	$num_tests_run++;

	push @fake_data, $uobj;
}
#Make sure @fake_data is alphabetically by wckeyname
@fake_data = sort { $a->wckey cmp $b->wckey || $a->cluster cmp $b->cluster || $a->user cmp $b->user } @fake_data;

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/fake_sacctmgr_wckey");
my $sawckey = 'Slurm::Sacctmgr::WCKey';

my $results;
my $args;
my $temp;
my $val;
my @temp;

#Test various commands with echo sacctmgr
#$sa->verbose(1);

$results = $sawckey->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all wckeys');
$num_tests_run++;

$val = 'aaa';
@temp = ( wckey => $val );
$temp = [ grep { $_->wckey eq $val } @fake_data ];
$results = $sawckey->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list wckey by name (aaa)');
$num_tests_run++;

$val = 'bbb';
@temp = ( wckey => $val );
$temp = [ grep { $_->wckey eq $val } @fake_data ];
$results = $sawckey->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list wckey by name (bbb)');
$num_tests_run++;

$val = 'ccc';
@temp = ( wckey => $val );
$temp = [ grep { $_->wckey eq $val } @fake_data ];
$results = $sawckey->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list wckey by name (ccc)');
$num_tests_run++;

$val = 'ddd';
@temp = ( wckey => $val );
$temp = [ grep { $_->wckey eq $val } @fake_data ];
$results = $sawckey->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list wckey by name (ddd)');
$num_tests_run++;

$val = 'root';
@temp = ( user => $val );
$temp = [ grep { $_->user eq $val } @fake_data ];
$results = $sawckey->sacctmgr_list($sa, @temp);
is_deeply($results, $temp, 'list wckey by user (root)');
$num_tests_run++;

$val = 'payerle';
@temp = ( user => $val );
$temp = [ grep { $_->user eq $val } @fake_data ];
$results = $sawckey->sacctmgr_list($sa, @temp);
is_deeply($results, $temp, 'list wckey by user (payerle)');
$num_tests_run++;

$val = 'aaa';
@temp = ( wckey => $val );
$temp = [ grep { $_->wckey eq $val } @fake_data ];
$val = 'payerle';
push @temp, ( user => $val );
$temp = [ grep { $_->user eq $val } @$temp ];
$results = $sawckey->sacctmgr_list($sa, @temp);
is_deeply($results, $temp, 'list wckey by name/user (aaa/payerle)');
$num_tests_run++;

#Test for match failing
$val = 'zzz';
@temp = ( wckey => $val );
$temp = [ grep { $_->wckey eq $val } @fake_data ];
$results = $sawckey->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list wckey by name (no match)');
$num_tests_run++;

#Test that still works when in dryrun mode
$sa->dryrun(1);
$results = $sawckey->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all wckeys (dryrun)');
$num_tests_run++;

done_testing($num_tests_run);

