/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* getenum.c
*/


#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "pfile.h"
#include "ptemplat.h"
#include "parameter.h"

static int
strdict (char *value, char *dict)
{
  int alias = 0;
  char *tok;
  int ii;

  char v[FIELD_SZ];
  char d[FIELD_SZ];

  strcpy (d, dict);

  for (ii = 0; dict[ii]; ii++)
    d[ii] = toupper (dict[ii]);
  d[ii] = '\0';
  for (ii = 0; value[ii]; ii++)
    v[ii] = toupper (value[ii]);
  v[ii] = '\0';

  for (ii = 1, tok = strtok (d, "|"); tok; ii++, tok = strtok (NULL, "|"))
    {
      if (!strcmp (tok, v))
	return ii;

      if (strstr (tok, v) == tok)
	{
	  if (alias)
	    return 0;
	  else
	    alias = ii;
	}
    }

  return alias;
}

int
pgetenum (ParamFile pp, char *name, char *dict)
{
  char value[FIELD_SZ];

  pgetstr (pp, name, value, FIELD_SZ);
  return strdict (value, dict);
}
