package Shipment::UPS::WSDL::TrackTypes::ActivityLocationType;
$Shipment::UPS::WSDL::TrackTypes::ActivityLocationType::VERSION = '3.03';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %Address_of : ATTR(:get<Address>);
    my %TransportFacility_of : ATTR(:get<TransportFacility>);
    my %Code_of : ATTR(:get<Code>);
    my %Description_of : ATTR(:get<Description>);
    my %SignedForByName_of : ATTR(:get<SignedForByName>);

    __PACKAGE__->_factory(
        [   qw(        Address
              TransportFacility
              Code
              Description
              SignedForByName

              )
        ],
        {   'Address'           => \%Address_of,
            'TransportFacility' => \%TransportFacility_of,
            'Code'              => \%Code_of,
            'Description'       => \%Description_of,
            'SignedForByName'   => \%SignedForByName_of,
        },
        {   'Address' => 'Shipment::UPS::WSDL::TrackTypes::AddressType',
            'TransportFacility' =>
              'Shipment::UPS::WSDL::TrackTypes::TransportFacilityType',
            'Code'            => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Description'     => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'SignedForByName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        },
        {

            'Address'           => 'Address',
            'TransportFacility' => 'TransportFacility',
            'Code'              => 'Code',
            'Description'       => 'Description',
            'SignedForByName'   => 'SignedForByName',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::TrackTypes::ActivityLocationType

=head1 VERSION

version 3.03

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ActivityLocationType from the namespace http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Address

=item * TransportFacility

=item * Code

=item * Description

=item * SignedForByName

=back

=head1 NAME

Shipment::UPS::WSDL::TrackTypes::ActivityLocationType

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::UPS::WSDL::TrackTypes::ActivityLocationType
   Address =>  { # Shipment::UPS::WSDL::TrackTypes::AddressType
     AddressLine =>  $some_value, # string
     City =>  $some_value, # string
     StateProvinceCode =>  $some_value, # string
     PostalCode =>  $some_value, # string
     CountryCode =>  $some_value, # string
   },
   TransportFacility =>  { # Shipment::UPS::WSDL::TrackTypes::TransportFacilityType
     Type =>  $some_value, # string
     Code =>  $some_value, # string
   },
   Code =>  $some_value, # string
   Description =>  $some_value, # string
   SignedForByName =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
