# Generated by default/object.tt
package Paws::TimestreamWrite::Record;
  use Moose;
  has Dimensions => (is => 'ro', isa => 'ArrayRef[Paws::TimestreamWrite::Dimension]');
  has MeasureName => (is => 'ro', isa => 'Str');
  has MeasureValue => (is => 'ro', isa => 'Str');
  has MeasureValueType => (is => 'ro', isa => 'Str');
  has Time => (is => 'ro', isa => 'Str');
  has TimeUnit => (is => 'ro', isa => 'Str');
  has Version => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::TimestreamWrite::Record

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::TimestreamWrite::Record object:

  $service_obj->Method(Att1 => { Dimensions => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::TimestreamWrite::Record object:

  $result = $service_obj->Method(...);
  $result->Att1->Dimensions

=head1 DESCRIPTION

Record represents a time series data point being written into
Timestream. Each record contains an array of dimensions. Dimensions
represent the meta data attributes of a time series data point such as
the instance name or availability zone of an EC2 instance. A record
also contains the measure name which is the name of the measure being
collected for example the CPU utilization of an EC2 instance. A record
also contains the measure value and the value type which is the data
type of the measure value. In addition, the record contains the
timestamp when the measure was collected that the timestamp unit which
represents the granularity of the timestamp.

=head1 ATTRIBUTES


=head2 Dimensions => ArrayRef[L<Paws::TimestreamWrite::Dimension>]

Contains the list of dimensions for time series data points.


=head2 MeasureName => Str

Measure represents the data attribute of the time series. For example,
the CPU utilization of an EC2 instance or the RPM of a wind turbine are
measures.


=head2 MeasureValue => Str

Contains the measure value for the time series data point.


=head2 MeasureValueType => Str

Contains the data type of the measure value for the time series data
point.


=head2 Time => Str

Contains the time at which the measure value for the data point was
collected. The time value plus the unit provides the time elapsed since
the epoch. For example, if the time value is C<12345> and the unit is
C<ms>, then C<12345 ms> have elapsed since the epoch.


=head2 TimeUnit => Str

The granularity of the timestamp unit. It indicates if the time value
is in seconds, milliseconds, nanoseconds or other supported values.


=head2 Version => Int

64-bit attribute used for record updates. Write requests for duplicate
data with a higher version number will update the existing measure
value and version. In cases where the measure value is the same,
C<Version> will still be updated . Default value is to 1.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::TimestreamWrite>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

