# Generated by default/object.tt
package Paws::SageMaker::ExperimentConfig;
  use Moose;
  has ExperimentName => (is => 'ro', isa => 'Str');
  has TrialComponentDisplayName => (is => 'ro', isa => 'Str');
  has TrialName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ExperimentConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ExperimentConfig object:

  $service_obj->Method(Att1 => { ExperimentName => $value, ..., TrialName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ExperimentConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ExperimentName

=head1 DESCRIPTION

Associates a SageMaker job as a trial component with an experiment and
trial. Specified when you call the following APIs:

=over

=item *

CreateProcessingJob

=item *

CreateTrainingJob

=item *

CreateTransformJob

=back


=head1 ATTRIBUTES


=head2 ExperimentName => Str

The name of an existing experiment to associate the trial component
with.


=head2 TrialComponentDisplayName => Str

The display name for the trial component. If this key isn't specified,
the display name is the trial component name.


=head2 TrialName => Str

The name of an existing trial to associate the trial component with. If
not specified, a new trial is created.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

