# Generated by default/object.tt
package Paws::Robomaker::WorldCount;
  use Moose;
  has FloorplanCount => (is => 'ro', isa => 'Int', request_name => 'floorplanCount', traits => ['NameInRequest']);
  has InteriorCountPerFloorplan => (is => 'ro', isa => 'Int', request_name => 'interiorCountPerFloorplan', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Robomaker::WorldCount

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Robomaker::WorldCount object:

  $service_obj->Method(Att1 => { FloorplanCount => $value, ..., InteriorCountPerFloorplan => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Robomaker::WorldCount object:

  $result = $service_obj->Method(...);
  $result->Att1->FloorplanCount

=head1 DESCRIPTION

The number of worlds that will be created. You can configure the number
of unique floorplans and the number of unique interiors for each floor
plan. For example, if you want 1 world with 20 unique interiors, you
set C<floorplanCount = 1> and C<interiorCountPerFloorplan = 20>. This
will result in 20 worlds (C<floorplanCount> *
C<interiorCountPerFloorplan)>.

If you set C<floorplanCount = 4> and C<interiorCountPerFloorplan = 5>,
there will be 20 worlds with 5 unique floor plans.

=head1 ATTRIBUTES


=head2 FloorplanCount => Int

The number of unique floorplans.


=head2 InteriorCountPerFloorplan => Int

The number of unique interiors per floorplan.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Robomaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

